# COVESA VSS Tools Official Distribution

[![License](https://img.shields.io/badge/License-MPL%202.0-blue.svg)](https://opensource.org/licenses/MPL-2.0)

## Introduction

VSS-Tools is a collection of tools developed by [COVESA](https://www.covesa.global/) to validate and transform
signal catalogs defined by the COVESA Vehicle Signal Specification (VSS) syntax. The PyPI packaging of VSS-tools
provide tools for converting VSS source files (*.vspec) to:

* CSV
* DDS IDL
* JSON
* Yaml
* Franca IDL
* Protobuf
* GraphQL

## Installing vss-tools

If you just want the latest version this should be sufficient:

```sh
pip install vss-tools
```

When installed tools like `vspec2json.py` shall be available on your path.

For more information see the [VSS-Tools wiki](https://github.com/COVESA/vss-tools/wiki/PyPI-packing)

## Usage

For more information please visit the [COVESA VSS-Tools repository](https://github.com/COVESA/vss-tools).

## Pip versioning

This is the versions types that may exist in PyPI for vss-tools and used for local pip install (`pip install -e .`)

* X.Y or X.Y.Z - A released version.
* X.Y.devN, N starting from 0 - Developer builds - may be published to PyPI if needed for testing purposes.
* X.YaN, N starting from 0 - Pre-releases, may be published to PyPI if needed for testing purposes.
* X.YrcN, N starting from 0 - Release candidates, to be published around two weeks before a major/minor release.

## References

For more information on VSS and VSS-Tools please visit

* [COVESA homepage](https://www.covesa.global/)
* [COVESA VSS Github repository](https://github.com/COVESA/vehicle_signal_specification)
* [COVESA VSS-Tools repository](https://github.com/COVESA/vss-tools)
* [COVESA VSS Wiki](https://wiki.covesa.global/display/WIK4/VSS+Resources+at+a+Glance)
