/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;

public final class FixedAttribute
extends AttributeCreator {
    private int nameCode;

    public FixedAttribute(int nameCode, int validationAction, SimpleType schemaType, int annotation) {
        this.nameCode = nameCode;
        this.setSchemaType(schemaType);
        if (annotation == -1) {
            this.setAnnotation(631);
        } else {
            this.setAnnotation(annotation);
        }
        this.setValidationAction(validationAction);
        this.setOptions(0);
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public void setSelect(Expression select, Configuration config) throws XPathException {
        super.setSelect(select, config);
        if ((this.nameCode & 0xFFFFF) == 388) {
            select = SystemFunction.makeSystemFunction("normalize-space", new Expression[]{select});
            super.setSelect(select, config);
        }
    }

    public void localTypeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        CharSequence value;
        ValidationFailure err;
        Configuration config = visitor.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        SimpleType schemaType = this.getSchemaType();
        if (schemaType == null) {
            SchemaDeclaration decl;
            int validation = this.getValidationAction();
            if (validation == 1) {
                decl = config.getAttributeDeclaration(this.nameCode & 0xFFFFF);
                if (decl == null) {
                    XPathException se = new XPathException("Strict validation fails: there is no global attribute declaration for " + config.getNamePool().getDisplayName(this.nameCode));
                    se.setErrorCode("XTTE1510");
                    se.setLocator(this);
                    throw se;
                }
                schemaType = (SimpleType)decl.getType();
            } else if (validation == 2) {
                decl = config.getAttributeDeclaration(this.nameCode & 0xFFFFF);
                if (decl != null) {
                    schemaType = (SimpleType)decl.getType();
                } else {
                    visitor.getStaticContext().issueWarning("Lax validation has no effect: there is no global attribute declaration for " + config.getNamePool().getDisplayName(this.nameCode), this);
                }
            }
        }
        if (Literal.isAtomic(this.select) && schemaType != null && !schemaType.isNamespaceSensitive() && (err = schemaType.validateContent(value = ((Literal)this.select).getValue().getStringValueCS(), DummyNamespaceResolver.getInstance(), rules)) != null) {
            XPathException se = new XPathException("Attribute value " + Err.wrap(value, 4) + " does not the match the required type " + schemaType.getDescription() + ". " + err.getMessage());
            se.setErrorCode("XTTE1540");
            throw se;
        }
        if (this.select instanceof StringLiteral) {
            boolean special = false;
            String val = ((StringLiteral)this.select).getStringValue();
            for (int k = 0; k < val.length(); ++k) {
                char c = val.charAt(k);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&' && c != '\"') continue;
                special = true;
                break;
            }
            if (!special) {
                this.setNoSpecialChars();
            }
        }
    }

    public int getAttributeNameCode() {
        return this.nameCode;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 16384;
    }

    public Expression copy() {
        FixedAttribute exp = new FixedAttribute(this.nameCode, this.getValidationAction(), this.getSchemaType(), this.getAnnotation());
        try {
            exp.setSelect(this.select.copy(), this.getExecutable().getConfiguration());
        }
        catch (XPathException err) {
            throw new UnsupportedOperationException(err.getMessage());
        }
        return exp;
    }

    public int evaluateNameCode(XPathContext context) {
        return this.nameCode;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        SimpleType type;
        int fp = this.nameCode & 0xFFFFF;
        if (fp == 641 || fp == 643 || fp == 642 || fp == 644) {
            return;
        }
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Attribute " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            if (this.getHostLanguage() == 50) {
                err.setErrorCode("XTTE1510");
            } else {
                err.setErrorCode("XQDY0027");
            }
            throw err;
        }
        try {
            type = ((ComplexType)parentType).getAttributeUseType(fp);
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
        if (type == null) {
            XPathException err = new XPathException("Attribute " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            if (this.getHostLanguage() == 50) {
                err.setErrorCode("XTTE1510");
            } else {
                err.setErrorCode("XQDY0027");
            }
            throw err;
        }
        try {
            this.select.checkPermittedContents(type, env, true);
        }
        catch (XPathException e) {
            if (e.getLocator() == null || e.getLocator() == e) {
                e.setLocator(this);
            }
            throw e;
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        Orphan o = (Orphan)super.evaluateItem(context);
        SimpleType schemaType = this.getSchemaType();
        int validationAction = this.getValidationAction();
        if (schemaType != null) {
            ValidationFailure err = schemaType.validateContent(o.getStringValueCS(), DummyNamespaceResolver.getInstance(), rules);
            if (err != null) {
                throw new ValidationException("Attribute value " + Err.wrap(o.getStringValueCS(), 4) + " does not the match the required type " + schemaType.getDescription() + ". " + err.getMessage());
            }
            o.setTypeAnnotation(schemaType.getFingerprint());
            if (schemaType.isNamespaceSensitive()) {
                throw new XPathException("Cannot validate a parentless attribute whose content is namespace-sensitive");
            }
        } else if (validationAction == 1 || validationAction == 2) {
            try {
                int ann = context.getController().getConfiguration().validateAttribute(this.nameCode, o.getStringValueCS(), validationAction);
                o.setTypeAnnotation(ann);
            }
            catch (ValidationException e) {
                XPathException err = XPathException.makeXPathException(e);
                err.setErrorCodeQName(e.getErrorCodeQName());
                err.setXPathContext(context);
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
        return o;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("directAttribute");
        out.emitAttribute("name", out.getNamePool().getDisplayName(this.nameCode));
        out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        this.getContentExpression().explain(out);
        out.endElement();
    }
}

