/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.value.Whitespace;

public class MetaTagAdjuster
extends ProxyReceiver {
    boolean seekingHead = true;
    int droppingMetaTags = -1;
    boolean inMetaTag = false;
    boolean foundHead = false;
    String headPrefix = null;
    int metaCode;
    short requiredURICode = 0;
    AttributeCollectionImpl attributes;
    String encoding;
    String mediaType;
    int level = 0;
    boolean isXHTML = false;

    public void setOutputProperties(Properties details) {
        this.encoding = details.getProperty("encoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.mediaType = details.getProperty("media-type");
        if (this.mediaType == null) {
            this.mediaType = "text/html";
        }
    }

    public void setIsXHTML(boolean xhtml) {
        this.isXHTML = xhtml;
        this.requiredURICode = xhtml ? this.getNamePool().getCodeForURI("http://www.w3.org/1999/xhtml") : (short)0;
    }

    private boolean comparesEqual(String name1, String name2) {
        if (this.isXHTML) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.droppingMetaTags == this.level) {
            this.metaCode = nameCode;
            short uriCode = this.getNamePool().getURICode(nameCode);
            String localName = this.getNamePool().getLocalName(nameCode);
            if (uriCode == this.requiredURICode && this.comparesEqual(localName, "meta")) {
                this.inMetaTag = true;
                this.attributes.clear();
                return;
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        if (this.seekingHead) {
            NamePool namePool = this.getNamePool();
            short uriCode = namePool.getURICode(nameCode);
            String localName = namePool.getLocalName(nameCode);
            if (uriCode == this.requiredURICode && this.comparesEqual(localName, "head")) {
                this.foundHead = true;
                this.headPrefix = namePool.getPrefix(nameCode);
            }
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.inMetaTag) {
            this.attributes.addAttribute(nameCode, typeCode, ((Object)value).toString(), locationId, properties);
        } else {
            this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.foundHead) {
            this.foundHead = false;
            NamePool namePool = this.getNamePool();
            this.nextReceiver.startContent();
            String uri = this.requiredURICode == 0 ? "" : "http://www.w3.org/1999/xhtml";
            int metaCode = namePool.allocate(this.headPrefix, uri, "meta");
            this.nextReceiver.startElement(metaCode, 630, 0, 0);
            int httpEquivCode = namePool.allocate("", "", "http-equiv");
            this.nextReceiver.attribute(httpEquivCode, 631, "Content-Type", 0, 0);
            int contentCode = namePool.allocate("", "", "content");
            this.nextReceiver.attribute(contentCode, 631, this.mediaType + "; charset=" + this.encoding, 0, 0);
            this.nextReceiver.startContent();
            this.droppingMetaTags = this.level;
            this.seekingHead = false;
            this.attributes = new AttributeCollectionImpl(this.getConfiguration());
            this.nextReceiver.endElement();
        }
        if (!this.inMetaTag) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        if (this.inMetaTag) {
            int i;
            this.inMetaTag = false;
            boolean found = false;
            for (i = 0; i < this.attributes.getLength(); ++i) {
                String value;
                String name = this.attributes.getLocalName(i);
                if (!this.comparesEqual(name, "http-equiv") || !(value = Whitespace.trim(this.attributes.getValue(i))).equalsIgnoreCase("Content-Type")) continue;
                found = true;
                break;
            }
            if (!found) {
                this.nextReceiver.startElement(this.metaCode, 630, 0, 0);
                for (i = 0; i < this.attributes.getLength(); ++i) {
                    int nameCode = this.attributes.getNameCode(i);
                    int typeCode = this.attributes.getTypeAnnotation(i);
                    String value = this.attributes.getValue(i);
                    int locationId = this.attributes.getLocationId(i);
                    int properties = this.attributes.getProperties(i);
                    this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
                }
                this.nextReceiver.startContent();
                this.nextReceiver.endElement();
            }
        } else {
            --this.level;
            if (this.droppingMetaTags == this.level + 1) {
                this.droppingMetaTags = -1;
            }
            this.nextReceiver.endElement();
        }
    }
}

