/* Sparc64 T4-T5 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2019 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* 3600 MHz ultrasparct5 running GNU/Linux */
/* FFT tuning limit = 0.5 M */
/* Generated by tuneup.c, 2019-10-01, gcc 7.4 */

#define DIVREM_1_NORM_THRESHOLD              3
#define DIVREM_1_UNNORM_THRESHOLD            3
#define MOD_1_1P_METHOD                      2  /* 0.34% faster than 1 */
#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               3
#define MOD_1N_TO_MOD_1_1_THRESHOLD          6
#define MOD_1U_TO_MOD_1_1_THRESHOLD          6
#define MOD_1_1_TO_MOD_1_2_THRESHOLD         8
#define MOD_1_2_TO_MOD_1_4_THRESHOLD         0  /* never mpn_mod_1s_2p */
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD     13
#define USE_PREINV_DIVREM_1                  1
/* From gcc105.fsffrance.org, 2023-07-25 */
#define DIV_QR_1N_PI1_METHOD                 4  /* 7.06% faster than 2 */
#define DIV_QR_1_NORM_THRESHOLD              3
#define DIV_QR_1_UNNORM_THRESHOLD            2
#define DIV_QR_2_PI2_THRESHOLD               5
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           19

#define DIV_1_VS_MUL_1_PERCENT             654

#define MUL_TOOM22_THRESHOLD                40
#define MUL_TOOM33_THRESHOLD               129
#define MUL_TOOM44_THRESHOLD               372
#define MUL_TOOM6H_THRESHOLD               494
#define MUL_TOOM8H_THRESHOLD               656

#define MUL_TOOM32_TO_TOOM43_THRESHOLD     126
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     247
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     225
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     219
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     188

#define SQR_BASECASE_THRESHOLD              20
#define SQR_TOOM2_THRESHOLD                 59
#define SQR_TOOM3_THRESHOLD                107
#define SQR_TOOM4_THRESHOLD                298
#define SQR_TOOM6_THRESHOLD                399
#define SQR_TOOM8_THRESHOLD                562

#define MULMID_TOOM42_THRESHOLD             48

#define MULMOD_BNM1_THRESHOLD               25
#define SQRMOD_BNM1_THRESHOLD               23

#define MUL_FFT_MODF_THRESHOLD             555  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    555, 5}, {     29, 6}, {     31, 7}, {     31, 8}, \
    {     17, 7}, {     36, 8}, {     19, 7}, {     39, 8}, \
    {     21, 7}, {     43, 8}, {     29, 9}, {     15, 8}, \
    {     31, 7}, {     63, 8}, {     35, 9}, {     19, 8}, \
    {     43, 9}, {     23, 8}, {     51, 9}, {     27, 8}, \
    {     57,10}, {     15, 8}, {     61, 9}, {     31, 8}, \
    {     67, 9}, {     35, 8}, {     71, 9}, {     39, 8}, \
    {     81, 9}, {     43,10}, {     23, 9}, {     59,11}, \
    {     15,10}, {     31, 9}, {     71,10}, {     39, 9}, \
    {     87,10}, {     47, 9}, {     99,10}, {     55, 9}, \
    {    115,11}, {     31,10}, {     63, 9}, {    131,10}, \
    {     87,11}, {     47,10}, {    111, 9}, {    223,12}, \
    {     31,11}, {     63,10}, {    135,11}, {     79,10}, \
    {    159,11}, {     95,10}, {    191,11}, {    111,12}, \
    {     63,11}, {    143,10}, {    287,11}, {    159,12}, \
    {     95,11}, {    191,10}, {    383, 9}, {    767,13}, \
    {   8192,14}, {  16384,15}, {  32768,16}, {  65536,17}, \
    { 131072,18}, { 262144,19}, { 524288,20}, {1048576,21}, \
    {2097152,22}, {4194304,23}, {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 75
#define MUL_FFT_THRESHOLD                 5760

#define SQR_FFT_MODF_THRESHOLD             372  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    372, 5}, {     23, 6}, {     12, 5}, {     25, 6}, \
    {     25, 7}, {     13, 6}, {     27, 7}, {     25, 8}, \
    {     13, 7}, {     28, 8}, {     15, 7}, {     31, 8}, \
    {     27, 9}, {     15, 8}, {     35, 9}, {     19, 8}, \
    {     41, 9}, {     23, 8}, {     47, 9}, {     27,10}, \
    {     15, 9}, {     39,10}, {     23, 9}, {     51,11}, \
    {     15,10}, {     31, 9}, {     67,10}, {     39, 9}, \
    {     79,10}, {     47, 9}, {     95,10}, {     55,11}, \
    {     31,10}, {     79,11}, {     47,10}, {     95,12}, \
    {     31,11}, {     63,10}, {    135,11}, {     79,10}, \
    {    159, 9}, {    319,11}, {     95,10}, {    191, 9}, \
    {    383,11}, {    111,12}, {     63,11}, {    127,10}, \
    {    255, 9}, {    511,10}, {    271,11}, {    143,10}, \
    {    287, 9}, {    575,10}, {    303, 9}, {    607,11}, \
    {    159,10}, {    319, 9}, {    639,12}, {     95,11}, \
    {    191,10}, {    383, 9}, {    767,11}, {    207,13}, \
    {   8192,14}, {  16384,15}, {  32768,16}, {  65536,17}, \
    { 131072,18}, { 262144,19}, { 524288,20}, {1048576,21}, \
    {2097152,22}, {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 75
#define SQR_FFT_THRESHOLD                 3776

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  35
#define MULLO_MUL_N_THRESHOLD            11278
#define SQRLO_BASECASE_THRESHOLD             0  /* always */
#define SQRLO_DC_THRESHOLD                 168
#define SQRLO_SQR_THRESHOLD               7511

#define DC_DIV_QR_THRESHOLD                 36
#define DC_DIVAPPR_Q_THRESHOLD             103
#define DC_BDIV_QR_THRESHOLD                28
#define DC_BDIV_Q_THRESHOLD                 88

#define INV_MULMOD_BNM1_THRESHOLD           78
#define INV_NEWTON_THRESHOLD               181
#define INV_APPR_THRESHOLD                 118

#define BINV_NEWTON_THRESHOLD              296
#define REDC_1_TO_REDC_2_THRESHOLD           4
#define REDC_2_TO_REDC_N_THRESHOLD          79

#define MU_DIV_QR_THRESHOLD               1970
#define MU_DIVAPPR_Q_THRESHOLD            1970
#define MUPI_DIV_QR_THRESHOLD               82
#define MU_BDIV_QR_THRESHOLD              1528
#define MU_BDIV_Q_THRESHOLD               1970

#define POWM_SEC_TABLE  1,58,102,1509

#define GET_STR_DC_THRESHOLD                15
#define GET_STR_PRECOMPUTE_THRESHOLD        29
#define SET_STR_DC_THRESHOLD               686
#define SET_STR_PRECOMPUTE_THRESHOLD      2717

#define FAC_DSC_THRESHOLD                  336
#define FAC_ODD_THRESHOLD                   24

#define MATRIX22_STRASSEN_THRESHOLD         32
#define HGCD2_DIV1_METHOD                    1  /* 0.66% faster than 3 */
#define HGCD_THRESHOLD                      57
#define HGCD_APPR_THRESHOLD                 50
#define HGCD_REDUCE_THRESHOLD             3389
#define GCD_DC_THRESHOLD                   386
#define GCDEXT_DC_THRESHOLD                288
#define JACOBI_BASE_METHOD                   4  /* 2.50% faster than 3 */
