// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v10.1.6), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/method_call.h>
#include <flutter/method_channel.h>
#include <flutter/standard_method_codec.h>

#include <optional>
#include <string>

#include "plugins/common/common.h"

namespace plugin_pdf {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

extern std::unique_ptr<flutter::MethodChannel<flutter::EncodableValue>> channel;

// Sets up an instance of `PrintingApi` to handle messages through the
// `binary_messenger`.
void PrintingApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                        PrintingApi* api) {
  {
    channel = std::make_unique<flutter::MethodChannel<>>(
        binary_messenger, "net.nfet.printing",
        &flutter::StandardMethodCodec::GetInstance());
    if (api != nullptr) {
      channel->SetMethodCallHandler(
          [api](const flutter::MethodCall<EncodableValue>& call,
                const std::unique_ptr<flutter::MethodResult<EncodableValue>>&
                    result) {
            SPDLOG_DEBUG("[printing] {}", call.method_name());
            if ("printingInfo" == call.method_name()) {
              flutter::EncodableMap map = {
                  {EncodableValue("canPrint"), EncodableValue(false)},
                  {EncodableValue("canShare"), EncodableValue(true)},
                  {EncodableValue("canRaster"), EncodableValue(true)},
                  {EncodableValue("canListPrinters"), EncodableValue(false)},
                  {EncodableValue("directPrint"), EncodableValue(false)},
                  {EncodableValue("dynamicLayout"), EncodableValue(false)},
              };
              result->Success(flutter::EncodableValue(map));
            } else if ("sharePdf" == call.method_name()) {
              const auto& args = std::get_if<EncodableMap>(call.arguments());
              std::string name = "document.pdf";
              std::vector<uint8_t> doc;
              for (auto& it : *args) {
                if ("name" == std::get<std::string>(it.first) &&
                    std::holds_alternative<std::string>(it.second)) {
                  name = std::get<std::string>(it.second);
                }
                if ("doc" == std::get<std::string>(it.first) &&
                    std::holds_alternative<std::vector<uint8_t>>(it.second)) {
                  doc = std::get<std::vector<uint8_t>>(it.second);
                }
              }
              auto res = api->SharePdf(std::move(doc), name);
              result->Success(flutter::EncodableValue(res ? 1 : 0));
            } else if ("rasterPdf" == call.method_name()) {
              const auto& args = std::get_if<EncodableMap>(call.arguments());
              std::vector<uint8_t> doc;
              std::vector<int32_t> pages;
              int32_t job_id;
              double scale;
              for (auto& it : *args) {
                if ("doc" == std::get<std::string>(it.first) &&
                    std::holds_alternative<std::vector<uint8_t>>(it.second)) {
                  doc = std::get<std::vector<uint8_t>>(it.second);
                } else if ("pages" == std::get<std::string>(it.first) &&
                           std::holds_alternative<std::vector<int32_t>>(
                               it.second)) {
                  pages = std::get<std::vector<int32_t>>(it.second);
                } else if ("job" == std::get<std::string>(it.first) &&
                           std::holds_alternative<int32_t>(it.second)) {
                  job_id = std::get<int32_t>(it.second);
                } else if ("scale" == std::get<std::string>(it.first) &&
                           std::holds_alternative<double>(it.second)) {
                  scale = std::get<double>(it.second);
                }
              }
              api->RasterPdf(std::move(doc), std::move(pages), scale, job_id);
              result->Success();
            } else {
              result->NotImplemented();
            }
          });
    }
  }
}

EncodableValue PrintingApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue PrintingApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

}  // namespace plugin_pdf
