// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 42;
// AUTOGENERATED END

const file = 'step_through_property_get_test.dart';

void code() {
  final bar = Bar();
  bar.doStuff();
}

class Foo {
  final List<String> data1;

  Foo() : data1 = ['a', 'b', 'c'];

  void doStuff() {
    print(data1);
    print(data1[1]);
  }
}

class Bar extends Foo {
  final List<String> data2;

  Bar() : data2 = ['d', 'e', 'f'];

  @override
  void doStuff() {
    print(data2); // LINE_A
    print(data2[1]);

    print(data1);
    print(data1[1]);

    print(super.data1);
    print(super.data1[1]);
  }
}

final stops = <String>[];
const expected = <String>[
  '$file:${LINE_A + 0}:11', // on 'data2'
  '$file:${LINE_A + 0}:5', // on 'print'
  '$file:${LINE_A + 1}:11', // on 'data2'
  '$file:${LINE_A + 1}:16', // on '['
  '$file:${LINE_A + 1}:5', // on 'print'

  '$file:${LINE_A + 3}:11', // on 'data1'
  '$file:${LINE_A + 3}:5', // on 'print'
  '$file:${LINE_A + 4}:11', // on 'data1'
  '$file:${LINE_A + 4}:16', // on '['
  '$file:${LINE_A + 4}:5', // on 'print'

  '$file:${LINE_A + 6}:17', // on 'data1'
  '$file:${LINE_A + 6}:5', // on 'print'
  '$file:${LINE_A + 7}:17', // on 'data1'
  '$file:${LINE_A + 7}:22', // on '['
  '$file:${LINE_A + 7}:5', // on 'print'

  '$file:${LINE_A + 8}:3', // on ending '}'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepIntoThroughProgramRecordingStops(stops),
  checkRecordedStops(
    stops,
    expected,
    debugPrint: true,
    debugPrintFile: file,
    debugPrintLine: LINE_A,
  ),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_property_get_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
