// Copyright 2023, the Chromium project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// Autogenerated from Pigeon (v11.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#ifndef PIGEON_MESSAGES_G_H_
#define PIGEON_MESSAGES_G_H_
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>
#include <utility>

namespace firebase_auth_linux {

// Generated class from Pigeon.

class FlutterError {
 public:
  explicit FlutterError(std::string code) : code_(std::move(code)) {}
  explicit FlutterError(std::string code, std::string message)
      : code_(std::move(code)), message_(std::move(message)) {}
  explicit FlutterError(std::string code,
                        std::string message,
                        flutter::EncodableValue details)
      : code_(std::move(code)),
        message_(std::move(message)),
        details_(std::move(details)) {}

  const std::string& code() const { return code_; }
  const std::string& message() const { return message_; }
  const flutter::EncodableValue& details() const { return details_; }

 private:
  std::string code_;
  std::string message_;
  flutter::EncodableValue details_;
};

template <class T>
class ErrorOr {
 public:
  ErrorOr(const T& rhs) : v_(rhs) {}
  ErrorOr(const T&& rhs) : v_(std::move(rhs)) {}
  ErrorOr(const FlutterError& rhs) : v_(rhs) {}
  ErrorOr(const FlutterError&& rhs) : v_(rhs) {}

  bool has_error() const { return std::holds_alternative<FlutterError>(v_); }
  const T& value() const { return std::get<T>(v_); };
  const FlutterError& error() const { return std::get<FlutterError>(v_); };

 private:
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthUserHostApi;
  friend class MultiFactorUserHostApi;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpSecretHostApi;
  friend class GenerateInterfaces;
  ErrorOr() = default;
  T TakeValue() && { return std::get<T>(std::move(v_)); }

  std::variant<T, FlutterError> v_;
};

// The type of operation that generated the action code from calling
// [checkActionCode].
enum class ActionCodeInfoOperation {
  // Unknown operation.
  unknown = 0,
  // Password reset code generated via [sendPasswordResetEmail].
  passwordReset = 1,
  // Email verification code generated via [User.sendEmailVerification].
  verifyEmail = 2,
  // Email change revocation code generated via [User.updateEmail].
  recoverEmail = 3,
  // Email sign in code generated via [sendSignInLinkToEmail].
  emailSignIn = 4,
  // Verify and change email code generated via [User.verifyBeforeUpdateEmail].
  verifyAndChangeEmail = 5,
  // Action code for reverting second factor addition.
  revertSecondFactorAddition = 6
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonMultiFactorSession {
 public:
  // Constructs an object setting all fields.
  explicit PigeonMultiFactorSession(std::string id);

  const std::string& id() const;
  void set_id(std::string_view value_arg);

 private:
  static PigeonMultiFactorSession FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string id_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonPhoneMultiFactorAssertion {
 public:
  // Constructs an object setting all fields.
  explicit PigeonPhoneMultiFactorAssertion(std::string verification_id,
                                           std::string verification_code);

  const std::string& verification_id() const;
  void set_verification_id(std::string_view value_arg);

  const std::string& verification_code() const;
  void set_verification_code(std::string_view value_arg);

 private:
  static PigeonPhoneMultiFactorAssertion FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string verification_id_;
  std::string verification_code_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonMultiFactorInfo {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonMultiFactorInfo(double enrollment_timestamp, std::string uid);

  // Constructs an object setting all fields.
  explicit PigeonMultiFactorInfo(const std::string* display_name,
                                 double enrollment_timestamp,
                                 const std::string* factor_id,
                                 std::string uid,
                                 const std::string* phone_number);

  const std::string* display_name() const;
  void set_display_name(const std::string_view* value_arg);
  void set_display_name(std::string_view value_arg);

  double enrollment_timestamp() const;
  void set_enrollment_timestamp(double value_arg);

  const std::string* factor_id() const;
  void set_factor_id(const std::string_view* value_arg);
  void set_factor_id(std::string_view value_arg);

  const std::string& uid() const;
  void set_uid(std::string_view value_arg);

  const std::string* phone_number() const;
  void set_phone_number(const std::string_view* value_arg);
  void set_phone_number(std::string_view value_arg);

 private:
  static PigeonMultiFactorInfo FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<std::string> display_name_;
  double enrollment_timestamp_;
  std::optional<std::string> factor_id_;
  std::string uid_;
  std::optional<std::string> phone_number_;
};

// Generated class from Pigeon that represents data sent in messages.
class AuthPigeonFirebaseApp {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit AuthPigeonFirebaseApp(std::string app_name);

  // Constructs an object setting all fields.
  explicit AuthPigeonFirebaseApp(std::string app_name,
                                 const std::string* tenant_id);

  const std::string& app_name() const;
  void set_app_name(std::string_view value_arg);

  const std::string* tenant_id() const;
  void set_tenant_id(const std::string_view* value_arg);
  void set_tenant_id(std::string_view value_arg);

 private:
  static AuthPigeonFirebaseApp FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string app_name_;
  std::optional<std::string> tenant_id_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonActionCodeInfoData {
 public:
  // Constructs an object setting all non-nullable fields.
  PigeonActionCodeInfoData();

  // Constructs an object setting all fields.
  explicit PigeonActionCodeInfoData(const std::string* email,
                                    const std::string* previous_email);

  const std::string* email() const;
  void set_email(const std::string_view* value_arg);
  void set_email(std::string_view value_arg);

  const std::string* previous_email() const;
  void set_previous_email(const std::string_view* value_arg);
  void set_previous_email(std::string_view value_arg);

 private:
  static PigeonActionCodeInfoData FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class PigeonActionCodeInfo;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<std::string> email_;
  std::optional<std::string> previous_email_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonActionCodeInfo {
 public:
  // Constructs an object setting all fields.
  explicit PigeonActionCodeInfo(const ActionCodeInfoOperation& operation,
                                PigeonActionCodeInfoData data);

  const ActionCodeInfoOperation& operation() const;
  void set_operation(const ActionCodeInfoOperation& value_arg);

  const PigeonActionCodeInfoData& data() const;
  void set_data(const PigeonActionCodeInfoData& value_arg);

 private:
  static PigeonActionCodeInfo FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  ActionCodeInfoOperation operation_;
  PigeonActionCodeInfoData data_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonAdditionalUserInfo {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonAdditionalUserInfo(bool is_new_user);

  // Constructs an object setting all fields.
  explicit PigeonAdditionalUserInfo(bool is_new_user,
                                    const std::string* provider_id,
                                    const std::string* username,
                                    const std::string* authorization_code,
                                    const flutter::EncodableMap* profile);

  bool is_new_user() const;
  void set_is_new_user(bool value_arg);

  const std::string* provider_id() const;
  void set_provider_id(const std::string_view* value_arg);
  void set_provider_id(std::string_view value_arg);

  const std::string* username() const;
  void set_username(const std::string_view* value_arg);
  void set_username(std::string_view value_arg);

  const std::string* authorization_code() const;
  void set_authorization_code(const std::string_view* value_arg);
  void set_authorization_code(std::string_view value_arg);

  const flutter::EncodableMap* profile() const;
  void set_profile(const flutter::EncodableMap* value_arg);
  void set_profile(const flutter::EncodableMap& value_arg);

 private:
  static PigeonAdditionalUserInfo FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class PigeonUserCredential;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  bool is_new_user_;
  std::optional<std::string> provider_id_;
  std::optional<std::string> username_;
  std::optional<std::string> authorization_code_;
  std::optional<flutter::EncodableMap> profile_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonAuthCredential {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonAuthCredential(std::string provider_id,
                                std::string sign_in_method,
                                int64_t native_id);

  // Constructs an object setting all fields.
  explicit PigeonAuthCredential(std::string provider_id,
                                std::string sign_in_method,
                                int64_t native_id,
                                const std::string* access_token);

  const std::string& provider_id() const;
  void set_provider_id(std::string_view value_arg);

  const std::string& sign_in_method() const;
  void set_sign_in_method(std::string_view value_arg);

  int64_t native_id() const;
  void set_native_id(int64_t value_arg);

  const std::string* access_token() const;
  void set_access_token(const std::string_view* value_arg);
  void set_access_token(std::string_view value_arg);

 private:
  static PigeonAuthCredential FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class PigeonUserCredential;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string provider_id_;
  std::string sign_in_method_;
  int64_t native_id_;
  std::optional<std::string> access_token_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonUserInfo {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonUserInfo(std::string uid,
                          bool is_anonymous,
                          bool is_email_verified);

  // Constructs an object setting all fields.
  explicit PigeonUserInfo(std::string uid,
                          const std::string* email,
                          const std::string* display_name,
                          const std::string* photo_url,
                          const std::string* phone_number,
                          bool is_anonymous,
                          bool is_email_verified,
                          const std::string* provider_id,
                          const std::string* tenant_id,
                          const std::string* refresh_token,
                          const int64_t* creation_timestamp,
                          const int64_t* last_sign_in_timestamp);

  const std::string& uid() const;
  void set_uid(std::string_view value_arg);

  const std::string* email() const;
  void set_email(const std::string_view* value_arg);
  void set_email(std::string_view value_arg);

  const std::string* display_name() const;
  void set_display_name(const std::string_view* value_arg);
  void set_display_name(std::string_view value_arg);

  const std::string* photo_url() const;
  void set_photo_url(const std::string_view* value_arg);
  void set_photo_url(std::string_view value_arg);

  const std::string* phone_number() const;
  void set_phone_number(const std::string_view* value_arg);
  void set_phone_number(std::string_view value_arg);

  bool is_anonymous() const;
  void set_is_anonymous(bool value_arg);

  bool is_email_verified() const;
  void set_is_email_verified(bool value_arg);

  const std::string* provider_id() const;
  void set_provider_id(const std::string_view* value_arg);
  void set_provider_id(std::string_view value_arg);

  const std::string* tenant_id() const;
  void set_tenant_id(const std::string_view* value_arg);
  void set_tenant_id(std::string_view value_arg);

  const std::string* refresh_token() const;
  void set_refresh_token(const std::string_view* value_arg);
  void set_refresh_token(std::string_view value_arg);

  const int64_t* creation_timestamp() const;
  void set_creation_timestamp(const int64_t* value_arg);
  void set_creation_timestamp(int64_t value_arg);

  const int64_t* last_sign_in_timestamp() const;
  void set_last_sign_in_timestamp(const int64_t* value_arg);
  void set_last_sign_in_timestamp(int64_t value_arg);

 private:
  static PigeonUserInfo FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class PigeonUserDetails;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string uid_;
  std::optional<std::string> email_;
  std::optional<std::string> display_name_;
  std::optional<std::string> photo_url_;
  std::optional<std::string> phone_number_;
  bool is_anonymous_;
  bool is_email_verified_;
  std::optional<std::string> provider_id_;
  std::optional<std::string> tenant_id_;
  std::optional<std::string> refresh_token_;
  std::optional<int64_t> creation_timestamp_;
  std::optional<int64_t> last_sign_in_timestamp_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonUserDetails {
 public:
  // Constructs an object setting all fields.
  explicit PigeonUserDetails(PigeonUserInfo user_info,
                             flutter::EncodableList provider_data);

  const PigeonUserInfo& user_info() const;
  void set_user_info(const PigeonUserInfo& value_arg);

  const flutter::EncodableList& provider_data() const;
  void set_provider_data(const flutter::EncodableList& value_arg);
  static PigeonUserDetails FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;

 private:
  friend class PigeonUserCredential;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  PigeonUserInfo user_info_;
  flutter::EncodableList provider_data_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonUserCredential {
 public:
  // Constructs an object setting all non-nullable fields.
  PigeonUserCredential();

  // Constructs an object setting all fields.
  explicit PigeonUserCredential(
      const PigeonUserDetails* user,
      const PigeonAdditionalUserInfo* additional_user_info,
      const PigeonAuthCredential* credential);

  const PigeonUserDetails* user() const;
  void set_user(const PigeonUserDetails* value_arg);
  void set_user(const PigeonUserDetails& value_arg);

  const PigeonAdditionalUserInfo* additional_user_info() const;
  void set_additional_user_info(const PigeonAdditionalUserInfo* value_arg);
  void set_additional_user_info(const PigeonAdditionalUserInfo& value_arg);

  const PigeonAuthCredential* credential() const;
  void set_credential(const PigeonAuthCredential* value_arg);
  void set_credential(const PigeonAuthCredential& value_arg);

 private:
  static PigeonUserCredential FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<PigeonUserDetails> user_;
  std::optional<PigeonAdditionalUserInfo> additional_user_info_;
  std::optional<PigeonAuthCredential> credential_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonActionCodeSettings {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonActionCodeSettings(std::string url,
                                    bool handle_code_in_app,
                                    bool android_install_app);

  // Constructs an object setting all fields.
  explicit PigeonActionCodeSettings(std::string url,
                                    const std::string* dynamic_link_domain,
                                    bool handle_code_in_app,
                                    const std::string* i_o_s_bundle_id,
                                    const std::string* android_package_name,
                                    bool android_install_app,
                                    const std::string* android_minimum_version);

  const std::string& url() const;
  void set_url(std::string_view value_arg);

  const std::string* dynamic_link_domain() const;
  void set_dynamic_link_domain(const std::string_view* value_arg);
  void set_dynamic_link_domain(std::string_view value_arg);

  bool handle_code_in_app() const;
  void set_handle_code_in_app(bool value_arg);

  const std::string* i_o_s_bundle_id() const;
  void set_i_o_s_bundle_id(const std::string_view* value_arg);
  void set_i_o_s_bundle_id(std::string_view value_arg);

  const std::string* android_package_name() const;
  void set_android_package_name(const std::string_view* value_arg);
  void set_android_package_name(std::string_view value_arg);

  bool android_install_app() const;
  void set_android_install_app(bool value_arg);

  const std::string* android_minimum_version() const;
  void set_android_minimum_version(const std::string_view* value_arg);
  void set_android_minimum_version(std::string_view value_arg);

 private:
  static PigeonActionCodeSettings FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string url_;
  std::optional<std::string> dynamic_link_domain_;
  bool handle_code_in_app_;
  std::optional<std::string> i_o_s_bundle_id_;
  std::optional<std::string> android_package_name_;
  bool android_install_app_;
  std::optional<std::string> android_minimum_version_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonFirebaseAuthSettings {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonFirebaseAuthSettings(
      bool app_verification_disabled_for_testing);

  // Constructs an object setting all fields.
  explicit PigeonFirebaseAuthSettings(
      bool app_verification_disabled_for_testing,
      const std::string* user_access_group,
      const std::string* phone_number,
      const std::string* sms_code,
      const bool* force_recaptcha_flow);

  bool app_verification_disabled_for_testing() const;
  void set_app_verification_disabled_for_testing(bool value_arg);

  const std::string* user_access_group() const;
  void set_user_access_group(const std::string_view* value_arg);
  void set_user_access_group(std::string_view value_arg);

  const std::string* phone_number() const;
  void set_phone_number(const std::string_view* value_arg);
  void set_phone_number(std::string_view value_arg);

  const std::string* sms_code() const;
  void set_sms_code(const std::string_view* value_arg);
  void set_sms_code(std::string_view value_arg);

  const bool* force_recaptcha_flow() const;
  void set_force_recaptcha_flow(const bool* value_arg);
  void set_force_recaptcha_flow(bool value_arg);

 private:
  static PigeonFirebaseAuthSettings FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  bool app_verification_disabled_for_testing_;
  std::optional<std::string> user_access_group_;
  std::optional<std::string> phone_number_;
  std::optional<std::string> sms_code_;
  std::optional<bool> force_recaptcha_flow_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonSignInProvider {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonSignInProvider(std::string provider_id);

  // Constructs an object setting all fields.
  explicit PigeonSignInProvider(std::string provider_id,
                                const flutter::EncodableList* scopes,
                                const flutter::EncodableMap* custom_parameters);

  const std::string& provider_id() const;
  void set_provider_id(std::string_view value_arg);

  const flutter::EncodableList* scopes() const;
  void set_scopes(const flutter::EncodableList* value_arg);
  void set_scopes(const flutter::EncodableList& value_arg);

  const flutter::EncodableMap* custom_parameters() const;
  void set_custom_parameters(const flutter::EncodableMap* value_arg);
  void set_custom_parameters(const flutter::EncodableMap& value_arg);

 private:
  static PigeonSignInProvider FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::string provider_id_;
  std::optional<flutter::EncodableList> scopes_;
  std::optional<flutter::EncodableMap> custom_parameters_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonVerifyPhoneNumberRequest {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonVerifyPhoneNumberRequest(int64_t timeout);

  // Constructs an object setting all fields.
  explicit PigeonVerifyPhoneNumberRequest(
      const std::string* phone_number,
      int64_t timeout,
      const int64_t* force_resending_token,
      const std::string* auto_retrieved_sms_code_for_testing,
      const std::string* multi_factor_info_id,
      const std::string* multi_factor_session_id);

  const std::string* phone_number() const;
  void set_phone_number(const std::string_view* value_arg);
  void set_phone_number(std::string_view value_arg);

  int64_t timeout() const;
  void set_timeout(int64_t value_arg);

  const int64_t* force_resending_token() const;
  void set_force_resending_token(const int64_t* value_arg);
  void set_force_resending_token(int64_t value_arg);

  const std::string* auto_retrieved_sms_code_for_testing() const;
  void set_auto_retrieved_sms_code_for_testing(
      const std::string_view* value_arg);
  void set_auto_retrieved_sms_code_for_testing(std::string_view value_arg);

  const std::string* multi_factor_info_id() const;
  void set_multi_factor_info_id(const std::string_view* value_arg);
  void set_multi_factor_info_id(std::string_view value_arg);

  const std::string* multi_factor_session_id() const;
  void set_multi_factor_session_id(const std::string_view* value_arg);
  void set_multi_factor_session_id(std::string_view value_arg);

 private:
  static PigeonVerifyPhoneNumberRequest FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<std::string> phone_number_;
  int64_t timeout_;
  std::optional<int64_t> force_resending_token_;
  std::optional<std::string> auto_retrieved_sms_code_for_testing_;
  std::optional<std::string> multi_factor_info_id_;
  std::optional<std::string> multi_factor_session_id_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonIdTokenResult {
 public:
  // Constructs an object setting all non-nullable fields.
  PigeonIdTokenResult();

  // Constructs an object setting all fields.
  explicit PigeonIdTokenResult(const std::string* token,
                               const int64_t* expiration_timestamp,
                               const int64_t* auth_timestamp,
                               const int64_t* issued_at_timestamp,
                               const std::string* sign_in_provider,
                               const flutter::EncodableMap* claims,
                               const std::string* sign_in_second_factor);

  const std::string* token() const;
  void set_token(const std::string_view* value_arg);
  void set_token(std::string_view value_arg);

  const int64_t* expiration_timestamp() const;
  void set_expiration_timestamp(const int64_t* value_arg);
  void set_expiration_timestamp(int64_t value_arg);

  const int64_t* auth_timestamp() const;
  void set_auth_timestamp(const int64_t* value_arg);
  void set_auth_timestamp(int64_t value_arg);

  const int64_t* issued_at_timestamp() const;
  void set_issued_at_timestamp(const int64_t* value_arg);
  void set_issued_at_timestamp(int64_t value_arg);

  const std::string* sign_in_provider() const;
  void set_sign_in_provider(const std::string_view* value_arg);
  void set_sign_in_provider(std::string_view value_arg);

  const flutter::EncodableMap* claims() const;
  void set_claims(const flutter::EncodableMap* value_arg);
  void set_claims(const flutter::EncodableMap& value_arg);

  const std::string* sign_in_second_factor() const;
  void set_sign_in_second_factor(const std::string_view* value_arg);
  void set_sign_in_second_factor(std::string_view value_arg);

 private:
  static PigeonIdTokenResult FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<std::string> token_;
  std::optional<int64_t> expiration_timestamp_;
  std::optional<int64_t> auth_timestamp_;
  std::optional<int64_t> issued_at_timestamp_;
  std::optional<std::string> sign_in_provider_;
  std::optional<flutter::EncodableMap> claims_;
  std::optional<std::string> sign_in_second_factor_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonUserProfile {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonUserProfile(bool display_name_changed, bool photo_url_changed);

  // Constructs an object setting all fields.
  explicit PigeonUserProfile(const std::string* display_name,
                             const std::string* photo_url,
                             bool display_name_changed,
                             bool photo_url_changed);

  const std::string* display_name() const;
  void set_display_name(const std::string_view* value_arg);
  void set_display_name(std::string_view value_arg);

  const std::string* photo_url() const;
  void set_photo_url(const std::string_view* value_arg);
  void set_photo_url(std::string_view value_arg);

  bool display_name_changed() const;
  void set_display_name_changed(bool value_arg);

  bool photo_url_changed() const;
  void set_photo_url_changed(bool value_arg);

 private:
  static PigeonUserProfile FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<std::string> display_name_;
  std::optional<std::string> photo_url_;
  bool display_name_changed_;
  bool photo_url_changed_;
};

// Generated class from Pigeon that represents data sent in messages.
class PigeonTotpSecret {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit PigeonTotpSecret(std::string secret_key);

  // Constructs an object setting all fields.
  explicit PigeonTotpSecret(const int64_t* code_interval_seconds,
                            const int64_t* code_length,
                            const int64_t* enrollment_completion_deadline,
                            const std::string* hashing_algorithm,
                            std::string secret_key);

  const int64_t* code_interval_seconds() const;
  void set_code_interval_seconds(const int64_t* value_arg);
  void set_code_interval_seconds(int64_t value_arg);

  const int64_t* code_length() const;
  void set_code_length(const int64_t* value_arg);
  void set_code_length(int64_t value_arg);

  const int64_t* enrollment_completion_deadline() const;
  void set_enrollment_completion_deadline(const int64_t* value_arg);
  void set_enrollment_completion_deadline(int64_t value_arg);

  const std::string* hashing_algorithm() const;
  void set_hashing_algorithm(const std::string_view* value_arg);
  void set_hashing_algorithm(std::string_view value_arg);

  const std::string& secret_key() const;
  void set_secret_key(std::string_view value_arg);

 private:
  static PigeonTotpSecret FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class FirebaseAuthHostApi;
  friend class FirebaseAuthHostApiCodecSerializer;
  friend class FirebaseAuthUserHostApi;
  friend class FirebaseAuthUserHostApiCodecSerializer;
  friend class MultiFactorUserHostApi;
  friend class MultiFactorUserHostApiCodecSerializer;
  friend class MultiFactoResolverHostApi;
  friend class MultiFactoResolverHostApiCodecSerializer;
  friend class MultiFactorTotpHostApi;
  friend class MultiFactorTotpHostApiCodecSerializer;
  friend class MultiFactorTotpSecretHostApi;
  friend class MultiFactorTotpSecretHostApiCodecSerializer;
  friend class GenerateInterfaces;
  friend class GenerateInterfacesCodecSerializer;
  std::optional<int64_t> code_interval_seconds_;
  std::optional<int64_t> code_length_;
  std::optional<int64_t> enrollment_completion_deadline_;
  std::optional<std::string> hashing_algorithm_;
  std::string secret_key_;
};

class FirebaseAuthHostApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  FirebaseAuthHostApiCodecSerializer();
  inline static FirebaseAuthHostApiCodecSerializer& GetInstance() {
    static FirebaseAuthHostApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class FirebaseAuthHostApi {
 public:
  FirebaseAuthHostApi(const FirebaseAuthHostApi&) = delete;
  FirebaseAuthHostApi& operator=(const FirebaseAuthHostApi&) = delete;
  virtual ~FirebaseAuthHostApi() = default;
  virtual void RegisterIdTokenListener(
      const AuthPigeonFirebaseApp& app,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void RegisterAuthStateListener(
      const AuthPigeonFirebaseApp& app,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void UseEmulator(
      const AuthPigeonFirebaseApp& app,
      const std::string& host,
      int64_t port,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void ApplyActionCode(
      const AuthPigeonFirebaseApp& app,
      const std::string& code,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void CheckActionCode(
      const AuthPigeonFirebaseApp& app,
      const std::string& code,
      std::function<void(ErrorOr<PigeonActionCodeInfo> reply)> result) = 0;
  virtual void ConfirmPasswordReset(
      const AuthPigeonFirebaseApp& app,
      const std::string& code,
      const std::string& new_password,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void CreateUserWithEmailAndPassword(
      const AuthPigeonFirebaseApp& app,
      const std::string& email,
      const std::string& password,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignInAnonymously(
      const AuthPigeonFirebaseApp& app,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignInWithCredential(
      const AuthPigeonFirebaseApp& app,
      const flutter::EncodableMap& input,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignInWithCustomToken(
      const AuthPigeonFirebaseApp& app,
      const std::string& token,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignInWithEmailAndPassword(
      const AuthPigeonFirebaseApp& app,
      const std::string& email,
      const std::string& password,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignInWithEmailLink(
      const AuthPigeonFirebaseApp& app,
      const std::string& email,
      const std::string& email_link,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignInWithProvider(
      const AuthPigeonFirebaseApp& app,
      const PigeonSignInProvider& sign_in_provider,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void SignOut(
      const AuthPigeonFirebaseApp& app,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void FetchSignInMethodsForEmail(
      const AuthPigeonFirebaseApp& app,
      const std::string& email,
      std::function<void(ErrorOr<flutter::EncodableList> reply)> result) = 0;
  virtual void SendPasswordResetEmail(
      const AuthPigeonFirebaseApp& app,
      const std::string& email,
      const PigeonActionCodeSettings* action_code_settings,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void SendSignInLinkToEmail(
      const AuthPigeonFirebaseApp& app,
      const std::string& email,
      const PigeonActionCodeSettings& action_code_settings,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void SetLanguageCode(
      const AuthPigeonFirebaseApp& app,
      const std::string* language_code,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void SetSettings(
      const AuthPigeonFirebaseApp& app,
      const PigeonFirebaseAuthSettings& settings,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void VerifyPasswordResetCode(
      const AuthPigeonFirebaseApp& app,
      const std::string& code,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void VerifyPhoneNumber(
      const AuthPigeonFirebaseApp& app,
      const PigeonVerifyPhoneNumberRequest& request,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void RevokeTokenWithAuthorizationCode(
      const AuthPigeonFirebaseApp& app,
      const std::string& authorization_code,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;

  // The codec used by FirebaseAuthHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `FirebaseAuthHostApi` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    FirebaseAuthHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  FirebaseAuthHostApi() = default;
};
class FirebaseAuthUserHostApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  FirebaseAuthUserHostApiCodecSerializer();
  inline static FirebaseAuthUserHostApiCodecSerializer& GetInstance() {
    static FirebaseAuthUserHostApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class FirebaseAuthUserHostApi {
 public:
  FirebaseAuthUserHostApi(const FirebaseAuthUserHostApi&) = delete;
  FirebaseAuthUserHostApi& operator=(const FirebaseAuthUserHostApi&) = delete;
  virtual ~FirebaseAuthUserHostApi() = default;
  virtual void Delete(
      const AuthPigeonFirebaseApp& app,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void GetIdToken(
      const AuthPigeonFirebaseApp& app,
      bool force_refresh,
      std::function<void(ErrorOr<PigeonIdTokenResult> reply)> result) = 0;
  virtual void LinkWithCredential(
      const AuthPigeonFirebaseApp& app,
      const flutter::EncodableMap& input,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void LinkWithProvider(
      const AuthPigeonFirebaseApp& app,
      const PigeonSignInProvider& sign_in_provider,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void ReauthenticateWithCredential(
      const AuthPigeonFirebaseApp& app,
      const flutter::EncodableMap& input,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void ReauthenticateWithProvider(
      const AuthPigeonFirebaseApp& app,
      const PigeonSignInProvider& sign_in_provider,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void Reload(
      const AuthPigeonFirebaseApp& app,
      std::function<void(ErrorOr<PigeonUserDetails> reply)> result) = 0;
  virtual void SendEmailVerification(
      const AuthPigeonFirebaseApp& app,
      const PigeonActionCodeSettings* action_code_settings,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void Unlink(
      const AuthPigeonFirebaseApp& app,
      const std::string& provider_id,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;
  virtual void UpdateEmail(
      const AuthPigeonFirebaseApp& app,
      const std::string& new_email,
      std::function<void(ErrorOr<PigeonUserDetails> reply)> result) = 0;
  virtual void UpdatePassword(
      const AuthPigeonFirebaseApp& app,
      const std::string& new_password,
      std::function<void(ErrorOr<PigeonUserDetails> reply)> result) = 0;
  virtual void UpdatePhoneNumber(
      const AuthPigeonFirebaseApp& app,
      const flutter::EncodableMap& input,
      std::function<void(ErrorOr<PigeonUserDetails> reply)> result) = 0;
  virtual void UpdateProfile(
      const AuthPigeonFirebaseApp& app,
      const PigeonUserProfile& profile,
      std::function<void(ErrorOr<PigeonUserDetails> reply)> result) = 0;
  virtual void VerifyBeforeUpdateEmail(
      const AuthPigeonFirebaseApp& app,
      const std::string& new_email,
      const PigeonActionCodeSettings* action_code_settings,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;

  // The codec used by FirebaseAuthUserHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `FirebaseAuthUserHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    FirebaseAuthUserHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  FirebaseAuthUserHostApi() = default;
};
class MultiFactorUserHostApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  MultiFactorUserHostApiCodecSerializer();
  inline static MultiFactorUserHostApiCodecSerializer& GetInstance() {
    static MultiFactorUserHostApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class MultiFactorUserHostApi {
 public:
  MultiFactorUserHostApi(const MultiFactorUserHostApi&) = delete;
  MultiFactorUserHostApi& operator=(const MultiFactorUserHostApi&) = delete;
  virtual ~MultiFactorUserHostApi() = default;
  virtual void EnrollPhone(
      const AuthPigeonFirebaseApp& app,
      const PigeonPhoneMultiFactorAssertion& assertion,
      const std::string* display_name,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void EnrollTotp(
      const AuthPigeonFirebaseApp& app,
      const std::string& assertion_id,
      const std::string* display_name,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void GetSession(
      const AuthPigeonFirebaseApp& app,
      std::function<void(ErrorOr<PigeonMultiFactorSession> reply)> result) = 0;
  virtual void Unenroll(
      const AuthPigeonFirebaseApp& app,
      const std::string& factor_uid,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void GetEnrolledFactors(
      const AuthPigeonFirebaseApp& app,
      std::function<void(ErrorOr<flutter::EncodableList> reply)> result) = 0;

  // The codec used by MultiFactorUserHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `MultiFactorUserHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    MultiFactorUserHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  MultiFactorUserHostApi() = default;
};
class MultiFactoResolverHostApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  MultiFactoResolverHostApiCodecSerializer();
  inline static MultiFactoResolverHostApiCodecSerializer& GetInstance() {
    static MultiFactoResolverHostApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class MultiFactoResolverHostApi {
 public:
  MultiFactoResolverHostApi(const MultiFactoResolverHostApi&) = delete;
  MultiFactoResolverHostApi& operator=(const MultiFactoResolverHostApi&) =
      delete;
  virtual ~MultiFactoResolverHostApi() = default;
  virtual void ResolveSignIn(
      const std::string& resolver_id,
      const PigeonPhoneMultiFactorAssertion* assertion,
      const std::string* totp_assertion_id,
      std::function<void(ErrorOr<PigeonUserCredential> reply)> result) = 0;

  // The codec used by MultiFactoResolverHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `MultiFactoResolverHostApi` to handle messages
  // through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    MultiFactoResolverHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  MultiFactoResolverHostApi() = default;
};
class MultiFactorTotpHostApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  MultiFactorTotpHostApiCodecSerializer();
  inline static MultiFactorTotpHostApiCodecSerializer& GetInstance() {
    static MultiFactorTotpHostApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class MultiFactorTotpHostApi {
 public:
  MultiFactorTotpHostApi(const MultiFactorTotpHostApi&) = delete;
  MultiFactorTotpHostApi& operator=(const MultiFactorTotpHostApi&) = delete;
  virtual ~MultiFactorTotpHostApi() = default;
  virtual void GenerateSecret(
      const std::string& session_id,
      std::function<void(ErrorOr<PigeonTotpSecret> reply)> result) = 0;
  virtual void GetAssertionForEnrollment(
      const std::string& secret_key,
      const std::string& one_time_password,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void GetAssertionForSignIn(
      const std::string& enrollment_id,
      const std::string& one_time_password,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;

  // The codec used by MultiFactorTotpHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `MultiFactorTotpHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    MultiFactorTotpHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  MultiFactorTotpHostApi() = default;
};
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class MultiFactorTotpSecretHostApi {
 public:
  MultiFactorTotpSecretHostApi(const MultiFactorTotpSecretHostApi&) = delete;
  MultiFactorTotpSecretHostApi& operator=(const MultiFactorTotpSecretHostApi&) =
      delete;
  virtual ~MultiFactorTotpSecretHostApi() = default;
  virtual void GenerateQrCodeUrl(
      const std::string& secret_key,
      const std::string* account_name,
      const std::string* issuer,
      std::function<void(ErrorOr<std::string> reply)> result) = 0;
  virtual void OpenInOtpApp(
      const std::string& secret_key,
      const std::string& qr_code_url,
      std::function<void(std::optional<FlutterError> reply)> result) = 0;

  // The codec used by MultiFactorTotpSecretHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `MultiFactorTotpSecretHostApi` to handle messages
  // through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    MultiFactorTotpSecretHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  MultiFactorTotpSecretHostApi() = default;
};
class GenerateInterfacesCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  GenerateInterfacesCodecSerializer();
  inline static GenerateInterfacesCodecSerializer& GetInstance() {
    static GenerateInterfacesCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Only used to generate the object interface that are use outside of the Pigeon
// interface
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class GenerateInterfaces {
 public:
  GenerateInterfaces(const GenerateInterfaces&) = delete;
  GenerateInterfaces& operator=(const GenerateInterfaces&) = delete;
  virtual ~GenerateInterfaces() = default;
  virtual std::optional<FlutterError> PigeonInterface(
      const PigeonMultiFactorInfo& info) = 0;

  // The codec used by GenerateInterfaces.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `GenerateInterfaces` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    GenerateInterfaces* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  GenerateInterfaces() = default;
};
}  // namespace firebase_auth_linux
#endif  // PIGEON_MESSAGES_G_H_
