// Autogenerated from Pigeon (v11.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#ifndef PIGEON_MESSAGE_G_H_
#define PIGEON_MESSAGE_G_H_
#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace plugin_webview_flutter {

// Generated class from Pigeon.

class FlutterError {
 public:
  explicit FlutterError(const std::string& code) : code_(code) {}
  explicit FlutterError(const std::string& code, const std::string& message)
      : code_(code), message_(message) {}
  explicit FlutterError(const std::string& code,
                        const std::string& message,
                        const flutter::EncodableValue& details)
      : code_(code), message_(message), details_(details) {}

  const std::string& code() const { return code_; }
  const std::string& message() const { return message_; }
  const flutter::EncodableValue& details() const { return details_; }

 private:
  std::string code_;
  std::string message_;
  flutter::EncodableValue details_;
};

template <class T>
class ErrorOr {
 public:
  ErrorOr(const T& rhs) : v_(rhs) {}
  ErrorOr(const T&& rhs) : v_(std::move(rhs)) {}
  ErrorOr(const FlutterError& rhs) : v_(rhs) {}
  ErrorOr(const FlutterError&& rhs) : v_(std::move(rhs)) {}

  bool has_error() const { return std::holds_alternative<FlutterError>(v_); }
  const T& value() const { return std::get<T>(v_); };
  const FlutterError& error() const { return std::get<FlutterError>(v_); };

 private:
  friend class InstanceManagerHostApi;
  friend class JavaObjectHostApi;
  friend class JavaObjectFlutterApi;
  friend class CookieManagerHostApi;
  friend class WebViewHostApi;
  friend class WebViewFlutterApi;
  friend class WebSettingsHostApi;
  friend class JavaScriptChannelHostApi;
  friend class JavaScriptChannelFlutterApi;
  friend class WebViewClientHostApi;
  friend class WebViewClientFlutterApi;
  friend class DownloadListenerHostApi;
  friend class DownloadListenerFlutterApi;
  friend class WebChromeClientHostApi;
  friend class FlutterAssetManagerHostApi;
  friend class WebChromeClientFlutterApi;
  friend class WebStorageHostApi;
  friend class FileChooserParamsFlutterApi;
  friend class PermissionRequestHostApi;
  friend class PermissionRequestFlutterApi;
  friend class CustomViewCallbackHostApi;
  friend class CustomViewCallbackFlutterApi;
  friend class ViewFlutterApi;
  friend class GeolocationPermissionsCallbackHostApi;
  friend class GeolocationPermissionsCallbackFlutterApi;
  friend class HttpAuthHandlerHostApi;
  friend class HttpAuthHandlerFlutterApi;
  ErrorOr() = default;
  T TakeValue() && { return std::get<T>(std::move(v_)); }

  std::variant<T, FlutterError> v_;
};

// Mode of how to select files for a file chooser.
//
// See
// https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams.
enum class FileChooserMode {
  // Open single file and requires that the file exists before allowing the
  // user to pick it.
  //
  // See
  // https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams#MODE_OPEN.
  open = 0,
  // Similar to [open] but allows multiple files to be selected.
  //
  // See
  // https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams#MODE_OPEN_MULTIPLE.
  openMultiple = 1,
  // Allows picking a nonexistent file and saving it.
  //
  // See
  // https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams#MODE_SAVE.
  save = 2
};

// Indicates the type of message logged to the console.
//
// See
// https://developer.android.com/reference/android/webkit/ConsoleMessage.MessageLevel.
enum class ConsoleMessageLevel {
  // Indicates a message is logged for debugging.
  //
  // See
  // https://developer.android.com/reference/android/webkit/ConsoleMessage.MessageLevel#DEBUG.
  debug = 0,
  // Indicates a message is provided as an error.
  //
  // See
  // https://developer.android.com/reference/android/webkit/ConsoleMessage.MessageLevel#ERROR.
  error = 1,
  // Indicates a message is provided as a basic log message.
  //
  // See
  // https://developer.android.com/reference/android/webkit/ConsoleMessage.MessageLevel#LOG.
  log = 2,
  // Indicates a message is provided as a tip.
  //
  // See
  // https://developer.android.com/reference/android/webkit/ConsoleMessage.MessageLevel#TIP.
  tip = 3,
  // Indicates a message is provided as a warning.
  //
  // See
  // https://developer.android.com/reference/android/webkit/ConsoleMessage.MessageLevel#WARNING.
  warning = 4,
  // Indicates a message with an unknown level.
  //
  // This does not represent an actual value provided by the platform and only
  // indicates a value was provided that isn't currently supported.
  unknown = 5
};

// Generated class from Pigeon that represents data sent in messages.
class WebResourceRequestData {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit WebResourceRequestData(const std::string& url,
                                  bool is_for_main_frame,
                                  bool has_gesture,
                                  const std::string& method,
                                  const flutter::EncodableMap& request_headers);

  // Constructs an object setting all fields.
  explicit WebResourceRequestData(const std::string& url,
                                  bool is_for_main_frame,
                                  const bool* is_redirect,
                                  bool has_gesture,
                                  const std::string& method,
                                  const flutter::EncodableMap& request_headers);

  const std::string& url() const;
  void set_url(std::string_view value_arg);

  bool is_for_main_frame() const;
  void set_is_for_main_frame(bool value_arg);

  const bool* is_redirect() const;
  void set_is_redirect(const bool* value_arg);
  void set_is_redirect(bool value_arg);

  bool has_gesture() const;
  void set_has_gesture(bool value_arg);

  const std::string& method() const;
  void set_method(std::string_view value_arg);

  const flutter::EncodableMap& request_headers() const;
  void set_request_headers(const flutter::EncodableMap& value_arg);

 private:
  static WebResourceRequestData FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class InstanceManagerHostApi;
  friend class InstanceManagerHostApiCodecSerializer;
  friend class JavaObjectHostApi;
  friend class JavaObjectHostApiCodecSerializer;
  friend class JavaObjectFlutterApi;
  friend class JavaObjectFlutterApiCodecSerializer;
  friend class CookieManagerHostApi;
  friend class CookieManagerHostApiCodecSerializer;
  friend class WebViewHostApi;
  friend class WebViewHostApiCodecSerializer;
  friend class WebViewFlutterApi;
  friend class WebViewFlutterApiCodecSerializer;
  friend class WebSettingsHostApi;
  friend class WebSettingsHostApiCodecSerializer;
  friend class JavaScriptChannelHostApi;
  friend class JavaScriptChannelHostApiCodecSerializer;
  friend class JavaScriptChannelFlutterApi;
  friend class JavaScriptChannelFlutterApiCodecSerializer;
  friend class WebViewClientHostApi;
  friend class WebViewClientHostApiCodecSerializer;
  friend class WebViewClientFlutterApi;
  friend class WebViewClientFlutterApiCodecSerializer;
  friend class DownloadListenerHostApi;
  friend class DownloadListenerHostApiCodecSerializer;
  friend class DownloadListenerFlutterApi;
  friend class DownloadListenerFlutterApiCodecSerializer;
  friend class WebChromeClientHostApi;
  friend class WebChromeClientHostApiCodecSerializer;
  friend class FlutterAssetManagerHostApi;
  friend class FlutterAssetManagerHostApiCodecSerializer;
  friend class WebChromeClientFlutterApi;
  friend class WebChromeClientFlutterApiCodecSerializer;
  friend class WebStorageHostApi;
  friend class WebStorageHostApiCodecSerializer;
  friend class FileChooserParamsFlutterApi;
  friend class FileChooserParamsFlutterApiCodecSerializer;
  friend class PermissionRequestHostApi;
  friend class PermissionRequestHostApiCodecSerializer;
  friend class PermissionRequestFlutterApi;
  friend class PermissionRequestFlutterApiCodecSerializer;
  friend class CustomViewCallbackHostApi;
  friend class CustomViewCallbackHostApiCodecSerializer;
  friend class CustomViewCallbackFlutterApi;
  friend class CustomViewCallbackFlutterApiCodecSerializer;
  friend class ViewFlutterApi;
  friend class ViewFlutterApiCodecSerializer;
  friend class GeolocationPermissionsCallbackHostApi;
  friend class GeolocationPermissionsCallbackHostApiCodecSerializer;
  friend class GeolocationPermissionsCallbackFlutterApi;
  friend class GeolocationPermissionsCallbackFlutterApiCodecSerializer;
  friend class HttpAuthHandlerHostApi;
  friend class HttpAuthHandlerHostApiCodecSerializer;
  friend class HttpAuthHandlerFlutterApi;
  friend class HttpAuthHandlerFlutterApiCodecSerializer;
  std::string url_;
  bool is_for_main_frame_;
  std::optional<bool> is_redirect_;
  bool has_gesture_;
  std::string method_;
  flutter::EncodableMap request_headers_;
};

// Generated class from Pigeon that represents data sent in messages.
class WebResourceErrorData {
 public:
  // Constructs an object setting all fields.
  explicit WebResourceErrorData(int64_t error_code,
                                const std::string& description);

  int64_t error_code() const;
  void set_error_code(int64_t value_arg);

  const std::string& description() const;
  void set_description(std::string_view value_arg);

 private:
  static WebResourceErrorData FromEncodableList(
      const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class InstanceManagerHostApi;
  friend class InstanceManagerHostApiCodecSerializer;
  friend class JavaObjectHostApi;
  friend class JavaObjectHostApiCodecSerializer;
  friend class JavaObjectFlutterApi;
  friend class JavaObjectFlutterApiCodecSerializer;
  friend class CookieManagerHostApi;
  friend class CookieManagerHostApiCodecSerializer;
  friend class WebViewHostApi;
  friend class WebViewHostApiCodecSerializer;
  friend class WebViewFlutterApi;
  friend class WebViewFlutterApiCodecSerializer;
  friend class WebSettingsHostApi;
  friend class WebSettingsHostApiCodecSerializer;
  friend class JavaScriptChannelHostApi;
  friend class JavaScriptChannelHostApiCodecSerializer;
  friend class JavaScriptChannelFlutterApi;
  friend class JavaScriptChannelFlutterApiCodecSerializer;
  friend class WebViewClientHostApi;
  friend class WebViewClientHostApiCodecSerializer;
  friend class WebViewClientFlutterApi;
  friend class WebViewClientFlutterApiCodecSerializer;
  friend class DownloadListenerHostApi;
  friend class DownloadListenerHostApiCodecSerializer;
  friend class DownloadListenerFlutterApi;
  friend class DownloadListenerFlutterApiCodecSerializer;
  friend class WebChromeClientHostApi;
  friend class WebChromeClientHostApiCodecSerializer;
  friend class FlutterAssetManagerHostApi;
  friend class FlutterAssetManagerHostApiCodecSerializer;
  friend class WebChromeClientFlutterApi;
  friend class WebChromeClientFlutterApiCodecSerializer;
  friend class WebStorageHostApi;
  friend class WebStorageHostApiCodecSerializer;
  friend class FileChooserParamsFlutterApi;
  friend class FileChooserParamsFlutterApiCodecSerializer;
  friend class PermissionRequestHostApi;
  friend class PermissionRequestHostApiCodecSerializer;
  friend class PermissionRequestFlutterApi;
  friend class PermissionRequestFlutterApiCodecSerializer;
  friend class CustomViewCallbackHostApi;
  friend class CustomViewCallbackHostApiCodecSerializer;
  friend class CustomViewCallbackFlutterApi;
  friend class CustomViewCallbackFlutterApiCodecSerializer;
  friend class ViewFlutterApi;
  friend class ViewFlutterApiCodecSerializer;
  friend class GeolocationPermissionsCallbackHostApi;
  friend class GeolocationPermissionsCallbackHostApiCodecSerializer;
  friend class GeolocationPermissionsCallbackFlutterApi;
  friend class GeolocationPermissionsCallbackFlutterApiCodecSerializer;
  friend class HttpAuthHandlerHostApi;
  friend class HttpAuthHandlerHostApiCodecSerializer;
  friend class HttpAuthHandlerFlutterApi;
  friend class HttpAuthHandlerFlutterApiCodecSerializer;
  int64_t error_code_;
  std::string description_;
};

// Generated class from Pigeon that represents data sent in messages.
class WebViewPoint {
 public:
  // Constructs an object setting all fields.
  explicit WebViewPoint(int64_t x, int64_t y);

  int64_t x() const;
  void set_x(int64_t value_arg);

  int64_t y() const;
  void set_y(int64_t value_arg);

 private:
  static WebViewPoint FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class InstanceManagerHostApi;
  friend class InstanceManagerHostApiCodecSerializer;
  friend class JavaObjectHostApi;
  friend class JavaObjectHostApiCodecSerializer;
  friend class JavaObjectFlutterApi;
  friend class JavaObjectFlutterApiCodecSerializer;
  friend class CookieManagerHostApi;
  friend class CookieManagerHostApiCodecSerializer;
  friend class WebViewHostApi;
  friend class WebViewHostApiCodecSerializer;
  friend class WebViewFlutterApi;
  friend class WebViewFlutterApiCodecSerializer;
  friend class WebSettingsHostApi;
  friend class WebSettingsHostApiCodecSerializer;
  friend class JavaScriptChannelHostApi;
  friend class JavaScriptChannelHostApiCodecSerializer;
  friend class JavaScriptChannelFlutterApi;
  friend class JavaScriptChannelFlutterApiCodecSerializer;
  friend class WebViewClientHostApi;
  friend class WebViewClientHostApiCodecSerializer;
  friend class WebViewClientFlutterApi;
  friend class WebViewClientFlutterApiCodecSerializer;
  friend class DownloadListenerHostApi;
  friend class DownloadListenerHostApiCodecSerializer;
  friend class DownloadListenerFlutterApi;
  friend class DownloadListenerFlutterApiCodecSerializer;
  friend class WebChromeClientHostApi;
  friend class WebChromeClientHostApiCodecSerializer;
  friend class FlutterAssetManagerHostApi;
  friend class FlutterAssetManagerHostApiCodecSerializer;
  friend class WebChromeClientFlutterApi;
  friend class WebChromeClientFlutterApiCodecSerializer;
  friend class WebStorageHostApi;
  friend class WebStorageHostApiCodecSerializer;
  friend class FileChooserParamsFlutterApi;
  friend class FileChooserParamsFlutterApiCodecSerializer;
  friend class PermissionRequestHostApi;
  friend class PermissionRequestHostApiCodecSerializer;
  friend class PermissionRequestFlutterApi;
  friend class PermissionRequestFlutterApiCodecSerializer;
  friend class CustomViewCallbackHostApi;
  friend class CustomViewCallbackHostApiCodecSerializer;
  friend class CustomViewCallbackFlutterApi;
  friend class CustomViewCallbackFlutterApiCodecSerializer;
  friend class ViewFlutterApi;
  friend class ViewFlutterApiCodecSerializer;
  friend class GeolocationPermissionsCallbackHostApi;
  friend class GeolocationPermissionsCallbackHostApiCodecSerializer;
  friend class GeolocationPermissionsCallbackFlutterApi;
  friend class GeolocationPermissionsCallbackFlutterApiCodecSerializer;
  friend class HttpAuthHandlerHostApi;
  friend class HttpAuthHandlerHostApiCodecSerializer;
  friend class HttpAuthHandlerFlutterApi;
  friend class HttpAuthHandlerFlutterApiCodecSerializer;
  int64_t x_;
  int64_t y_;
};

// Represents a JavaScript console message from WebCore.
//
// See https://developer.android.com/reference/android/webkit/ConsoleMessage
//
// Generated class from Pigeon that represents data sent in messages.
class ConsoleMessage {
 public:
  // Constructs an object setting all fields.
  explicit ConsoleMessage(int64_t line_number,
                          const std::string& message,
                          const ConsoleMessageLevel& level,
                          const std::string& source_id);

  int64_t line_number() const;
  void set_line_number(int64_t value_arg);

  const std::string& message() const;
  void set_message(std::string_view value_arg);

  const ConsoleMessageLevel& level() const;
  void set_level(const ConsoleMessageLevel& value_arg);

  const std::string& source_id() const;
  void set_source_id(std::string_view value_arg);

 private:
  static ConsoleMessage FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class InstanceManagerHostApi;
  friend class InstanceManagerHostApiCodecSerializer;
  friend class JavaObjectHostApi;
  friend class JavaObjectHostApiCodecSerializer;
  friend class JavaObjectFlutterApi;
  friend class JavaObjectFlutterApiCodecSerializer;
  friend class CookieManagerHostApi;
  friend class CookieManagerHostApiCodecSerializer;
  friend class WebViewHostApi;
  friend class WebViewHostApiCodecSerializer;
  friend class WebViewFlutterApi;
  friend class WebViewFlutterApiCodecSerializer;
  friend class WebSettingsHostApi;
  friend class WebSettingsHostApiCodecSerializer;
  friend class JavaScriptChannelHostApi;
  friend class JavaScriptChannelHostApiCodecSerializer;
  friend class JavaScriptChannelFlutterApi;
  friend class JavaScriptChannelFlutterApiCodecSerializer;
  friend class WebViewClientHostApi;
  friend class WebViewClientHostApiCodecSerializer;
  friend class WebViewClientFlutterApi;
  friend class WebViewClientFlutterApiCodecSerializer;
  friend class DownloadListenerHostApi;
  friend class DownloadListenerHostApiCodecSerializer;
  friend class DownloadListenerFlutterApi;
  friend class DownloadListenerFlutterApiCodecSerializer;
  friend class WebChromeClientHostApi;
  friend class WebChromeClientHostApiCodecSerializer;
  friend class FlutterAssetManagerHostApi;
  friend class FlutterAssetManagerHostApiCodecSerializer;
  friend class WebChromeClientFlutterApi;
  friend class WebChromeClientFlutterApiCodecSerializer;
  friend class WebStorageHostApi;
  friend class WebStorageHostApiCodecSerializer;
  friend class FileChooserParamsFlutterApi;
  friend class FileChooserParamsFlutterApiCodecSerializer;
  friend class PermissionRequestHostApi;
  friend class PermissionRequestHostApiCodecSerializer;
  friend class PermissionRequestFlutterApi;
  friend class PermissionRequestFlutterApiCodecSerializer;
  friend class CustomViewCallbackHostApi;
  friend class CustomViewCallbackHostApiCodecSerializer;
  friend class CustomViewCallbackFlutterApi;
  friend class CustomViewCallbackFlutterApiCodecSerializer;
  friend class ViewFlutterApi;
  friend class ViewFlutterApiCodecSerializer;
  friend class GeolocationPermissionsCallbackHostApi;
  friend class GeolocationPermissionsCallbackHostApiCodecSerializer;
  friend class GeolocationPermissionsCallbackFlutterApi;
  friend class GeolocationPermissionsCallbackFlutterApiCodecSerializer;
  friend class HttpAuthHandlerHostApi;
  friend class HttpAuthHandlerHostApiCodecSerializer;
  friend class HttpAuthHandlerFlutterApi;
  friend class HttpAuthHandlerFlutterApiCodecSerializer;
  int64_t line_number_;
  std::string message_;
  ConsoleMessageLevel level_;
  std::string source_id_;
};

// Host API for managing the native `InstanceManager`.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class InstanceManagerHostApi {
 public:
  InstanceManagerHostApi(const InstanceManagerHostApi&) = delete;
  InstanceManagerHostApi& operator=(const InstanceManagerHostApi&) = delete;
  virtual ~InstanceManagerHostApi() {}
  // Clear the native `InstanceManager`.
  //
  // This is typically only used after a hot restart.
  virtual std::optional<FlutterError> Clear() = 0;

  // The codec used by InstanceManagerHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `InstanceManagerHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    InstanceManagerHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  InstanceManagerHostApi() = default;
};
// Handles methods calls to the native Java Object class.
//
// Also handles calls to remove the reference to an instance with `dispose`.
//
// See https://docs.oracle.com/javase/7/docs/api/java/lang/Object.html.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class JavaObjectHostApi {
 public:
  JavaObjectHostApi(const JavaObjectHostApi&) = delete;
  JavaObjectHostApi& operator=(const JavaObjectHostApi&) = delete;
  virtual ~JavaObjectHostApi() {}
  virtual std::optional<FlutterError> Dispose(int64_t identifier) = 0;

  // The codec used by JavaObjectHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `JavaObjectHostApi` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    JavaObjectHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  JavaObjectHostApi() = default;
};
// Handles callbacks methods for the native Java Object class.
//
// See https://docs.oracle.com/javase/7/docs/api/java/lang/Object.html.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class JavaObjectFlutterApi {
 public:
  JavaObjectFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  void Dispose(int64_t identifier,
               std::function<void(void)>&& on_success,
               std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Host API for `CookieManager`.
//
// This class may handle instantiating and adding native object instances that
// are attached to a Dart instance or handle method calls on the associated
// native class or an instance of the class.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class CookieManagerHostApi {
 public:
  CookieManagerHostApi(const CookieManagerHostApi&) = delete;
  CookieManagerHostApi& operator=(const CookieManagerHostApi&) = delete;
  virtual ~CookieManagerHostApi() {}
  // Handles attaching `CookieManager.instance` to a native instance.
  virtual std::optional<FlutterError> AttachInstance(
      int64_t instance_identifier) = 0;
  // Handles Dart method `CookieManager.setCookie`.
  virtual std::optional<FlutterError> SetCookie(int64_t identifier,
                                                const std::string& url,
                                                const std::string& value) = 0;
  // Handles Dart method `CookieManager.removeAllCookies`.
  virtual void RemoveAllCookies(
      int64_t identifier,
      std::function<void(ErrorOr<bool> reply)> result) = 0;
  // Handles Dart method `CookieManager.setAcceptThirdPartyCookies`.
  virtual std::optional<FlutterError> SetAcceptThirdPartyCookies(
      int64_t identifier,
      int64_t web_view_identifier,
      bool accept) = 0;

  // The codec used by CookieManagerHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `CookieManagerHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    CookieManagerHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  CookieManagerHostApi() = default;
};
class WebViewHostApiCodecSerializer : public flutter::StandardCodecSerializer {
 public:
  WebViewHostApiCodecSerializer();
  inline static WebViewHostApiCodecSerializer& GetInstance() {
    static WebViewHostApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class WebViewHostApi {
 public:
  WebViewHostApi(const WebViewHostApi&) = delete;
  WebViewHostApi& operator=(const WebViewHostApi&) = delete;
  virtual ~WebViewHostApi() {}
  virtual std::optional<FlutterError> Create(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> LoadData(int64_t instance_id,
                                               const std::string& data,
                                               const std::string* mime_type,
                                               const std::string* encoding) = 0;
  virtual std::optional<FlutterError> LoadDataWithBaseUrl(
      int64_t instance_id,
      const std::string* base_url,
      const std::string& data,
      const std::string* mime_type,
      const std::string* encoding,
      const std::string* history_url) = 0;
  virtual std::optional<FlutterError> LoadUrl(
      int64_t instance_id,
      const std::string& url,
      const flutter::EncodableMap& headers) = 0;
  virtual std::optional<FlutterError> PostUrl(
      int64_t instance_id,
      const std::string& url,
      const std::vector<uint8_t>& data) = 0;
  virtual ErrorOr<std::optional<std::string>> GetUrl(int64_t instance_id) = 0;
  virtual ErrorOr<bool> CanGoBack(int64_t instance_id) = 0;
  virtual ErrorOr<bool> CanGoForward(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> GoBack(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> GoForward(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> Reload(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> ClearCache(int64_t instance_id,
                                                 bool include_disk_files) = 0;
  virtual void EvaluateJavascript(
      int64_t instance_id,
      const std::string& javascript_string,
      std::function<void(ErrorOr<std::optional<std::string>> reply)>
          result) = 0;
  virtual ErrorOr<std::optional<std::string>> GetTitle(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> ScrollTo(int64_t instance_id,
                                               int64_t x,
                                               int64_t y) = 0;
  virtual std::optional<FlutterError> ScrollBy(int64_t instance_id,
                                               int64_t x,
                                               int64_t y) = 0;
  virtual ErrorOr<int64_t> GetScrollX(int64_t instance_id) = 0;
  virtual ErrorOr<int64_t> GetScrollY(int64_t instance_id) = 0;
  virtual ErrorOr<WebViewPoint> GetScrollPosition(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> SetWebContentsDebuggingEnabled(
      bool enabled) = 0;
  virtual std::optional<FlutterError> SetWebViewClient(
      int64_t instance_id,
      int64_t web_view_client_instance_id) = 0;
  virtual std::optional<FlutterError> AddJavaScriptChannel(
      int64_t instance_id,
      int64_t java_script_channel_instance_id) = 0;
  virtual std::optional<FlutterError> RemoveJavaScriptChannel(
      int64_t instance_id,
      int64_t java_script_channel_instance_id) = 0;
  virtual std::optional<FlutterError> SetDownloadListener(
      int64_t instance_id,
      const int64_t* listener_instance_id) = 0;
  virtual std::optional<FlutterError> SetWebChromeClient(
      int64_t instance_id,
      const int64_t* client_instance_id) = 0;
  virtual std::optional<FlutterError> SetBackgroundColor(int64_t instance_id,
                                                         int64_t color) = 0;

  // The codec used by WebViewHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `WebViewHostApi` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    WebViewHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  WebViewHostApi() = default;
};
// Flutter API for `WebView`.
//
// This class may handle instantiating and adding Dart instances that are
// attached to a native instance or receiving callback methods from an
// overridden native class.
//
// See https://developer.android.com/reference/android/webkit/WebView.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class WebViewFlutterApi {
 public:
  WebViewFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  // Create a new Dart instance and add it to the `InstanceManager`.
  void Create(int64_t identifier,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class WebSettingsHostApi {
 public:
  WebSettingsHostApi(const WebSettingsHostApi&) = delete;
  WebSettingsHostApi& operator=(const WebSettingsHostApi&) = delete;
  virtual ~WebSettingsHostApi() {}
  virtual std::optional<FlutterError> Create(int64_t instance_id,
                                             int64_t web_view_instance_id) = 0;
  virtual std::optional<FlutterError> SetDomStorageEnabled(int64_t instance_id,
                                                           bool flag) = 0;
  virtual std::optional<FlutterError> SetJavaScriptCanOpenWindowsAutomatically(
      int64_t instance_id,
      bool flag) = 0;
  virtual std::optional<FlutterError> SetSupportMultipleWindows(
      int64_t instance_id,
      bool support) = 0;
  virtual std::optional<FlutterError> SetJavaScriptEnabled(int64_t instance_id,
                                                           bool flag) = 0;
  virtual std::optional<FlutterError> SetUserAgentString(
      int64_t instance_id,
      const std::string* user_agent_string) = 0;
  virtual std::optional<FlutterError> SetMediaPlaybackRequiresUserGesture(
      int64_t instance_id,
      bool require) = 0;
  virtual std::optional<FlutterError> SetSupportZoom(int64_t instance_id,
                                                     bool support) = 0;
  virtual std::optional<FlutterError> SetLoadWithOverviewMode(
      int64_t instance_id,
      bool overview) = 0;
  virtual std::optional<FlutterError> SetUseWideViewPort(int64_t instance_id,
                                                         bool use) = 0;
  virtual std::optional<FlutterError> SetDisplayZoomControls(
      int64_t instance_id,
      bool enabled) = 0;
  virtual std::optional<FlutterError> SetBuiltInZoomControls(
      int64_t instance_id,
      bool enabled) = 0;
  virtual std::optional<FlutterError> SetAllowFileAccess(int64_t instance_id,
                                                         bool enabled) = 0;
  virtual std::optional<FlutterError> SetTextZoom(int64_t instance_id,
                                                  int64_t text_zoom) = 0;
  virtual ErrorOr<std::string> GetUserAgentString(int64_t instance_id) = 0;

  // The codec used by WebSettingsHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `WebSettingsHostApi` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    WebSettingsHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  WebSettingsHostApi() = default;
};
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class JavaScriptChannelHostApi {
 public:
  JavaScriptChannelHostApi(const JavaScriptChannelHostApi&) = delete;
  JavaScriptChannelHostApi& operator=(const JavaScriptChannelHostApi&) = delete;
  virtual ~JavaScriptChannelHostApi() {}
  virtual std::optional<FlutterError> Create(
      int64_t instance_id,
      const std::string& channel_name) = 0;

  // The codec used by JavaScriptChannelHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `JavaScriptChannelHostApi` to handle messages
  // through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    JavaScriptChannelHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  JavaScriptChannelHostApi() = default;
};
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class JavaScriptChannelFlutterApi {
 public:
  JavaScriptChannelFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  void PostMessage(int64_t instance_id,
                   const std::string& message,
                   std::function<void(void)>&& on_success,
                   std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class WebViewClientHostApi {
 public:
  WebViewClientHostApi(const WebViewClientHostApi&) = delete;
  WebViewClientHostApi& operator=(const WebViewClientHostApi&) = delete;
  virtual ~WebViewClientHostApi() {}
  virtual std::optional<FlutterError> Create(int64_t instance_id) = 0;
  virtual std::optional<FlutterError>
  SetSynchronousReturnValueForShouldOverrideUrlLoading(int64_t instance_id,
                                                       bool value) = 0;

  // The codec used by WebViewClientHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `WebViewClientHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    WebViewClientHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  WebViewClientHostApi() = default;
};
class WebViewClientFlutterApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  WebViewClientFlutterApiCodecSerializer();
  ~WebViewClientFlutterApiCodecSerializer() override;
  static WebViewClientFlutterApiCodecSerializer& GetInstance() {
    static WebViewClientFlutterApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class WebViewClientFlutterApi {
 public:
  WebViewClientFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  void OnPageStarted(int64_t instance_id,
                     int64_t web_view_instance_id,
                     const std::string& url,
                     std::function<void(void)>&& on_success,
                     std::function<void(const FlutterError&)>&& on_error);
  void OnPageFinished(int64_t instance_id,
                      int64_t web_view_instance_id,
                      const std::string& url,
                      std::function<void(void)>&& on_success,
                      std::function<void(const FlutterError&)>&& on_error);
  void OnReceivedRequestError(
      int64_t instance_id,
      int64_t web_view_instance_id,
      const WebResourceRequestData& request,
      const WebResourceErrorData& error,
      std::function<void(void)>&& on_success,
      std::function<void(const FlutterError&)>&& on_error);
  void OnReceivedError(int64_t instance_id,
                       int64_t web_view_instance_id,
                       int64_t error_code,
                       const std::string& description,
                       const std::string& failing_url,
                       std::function<void(void)>&& on_success,
                       std::function<void(const FlutterError&)>&& on_error);
  void RequestLoading(int64_t instance_id,
                      int64_t web_view_instance_id,
                      const WebResourceRequestData& request,
                      std::function<void(void)>&& on_success,
                      std::function<void(const FlutterError&)>&& on_error);
  void UrlLoading(int64_t instance_id,
                  int64_t web_view_instance_id,
                  const std::string& url,
                  std::function<void(void)>&& on_success,
                  std::function<void(const FlutterError&)>&& on_error);
  void DoUpdateVisitedHistory(
      int64_t instance_id,
      int64_t web_view_instance_id,
      const std::string& url,
      bool is_reload,
      std::function<void(void)>&& on_success,
      std::function<void(const FlutterError&)>&& on_error);
  void OnReceivedHttpAuthRequest(
      int64_t instance_id,
      int64_t web_view_instance_id,
      int64_t http_auth_handler_instance_id,
      const std::string& host,
      const std::string& realm,
      std::function<void(void)>&& on_success,
      std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class DownloadListenerHostApi {
 public:
  DownloadListenerHostApi(const DownloadListenerHostApi&) = delete;
  DownloadListenerHostApi& operator=(const DownloadListenerHostApi&) = delete;
  virtual ~DownloadListenerHostApi() {}
  virtual std::optional<FlutterError> Create(int64_t instance_id) = 0;

  // The codec used by DownloadListenerHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `DownloadListenerHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    DownloadListenerHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  DownloadListenerHostApi() = default;
};
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class DownloadListenerFlutterApi {
 public:
  DownloadListenerFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  void OnDownloadStart(int64_t instance_id,
                       const std::string& url,
                       const std::string& user_agent,
                       const std::string& content_disposition,
                       const std::string& mimetype,
                       int64_t content_length,
                       std::function<void(void)>&& on_success,
                       std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class WebChromeClientHostApi {
 public:
  WebChromeClientHostApi(const WebChromeClientHostApi&) = delete;
  WebChromeClientHostApi& operator=(const WebChromeClientHostApi&) = delete;
  virtual ~WebChromeClientHostApi() {}
  virtual std::optional<FlutterError> Create(int64_t instance_id) = 0;
  virtual std::optional<FlutterError>
  SetSynchronousReturnValueForOnShowFileChooser(int64_t instance_id,
                                                bool value) = 0;
  virtual std::optional<FlutterError>
  SetSynchronousReturnValueForOnConsoleMessage(int64_t instance_id,
                                               bool value) = 0;

  // The codec used by WebChromeClientHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `WebChromeClientHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    WebChromeClientHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  WebChromeClientHostApi() = default;
};
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class FlutterAssetManagerHostApi {
 public:
  FlutterAssetManagerHostApi(const FlutterAssetManagerHostApi&) = delete;
  FlutterAssetManagerHostApi& operator=(const FlutterAssetManagerHostApi&) =
      delete;
  virtual ~FlutterAssetManagerHostApi() {}
  virtual ErrorOr<flutter::EncodableList> List(const std::string& path) = 0;
  virtual ErrorOr<std::string> GetAssetFilePathByName(
      const std::string& name) = 0;

  // The codec used by FlutterAssetManagerHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `FlutterAssetManagerHostApi` to handle messages
  // through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    FlutterAssetManagerHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  FlutterAssetManagerHostApi() = default;
};
class WebChromeClientFlutterApiCodecSerializer
    : public flutter::StandardCodecSerializer {
 public:
  WebChromeClientFlutterApiCodecSerializer() = default;
  static WebChromeClientFlutterApiCodecSerializer& GetInstance() {
    static WebChromeClientFlutterApiCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(const flutter::EncodableValue& value,
                  flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
      uint8_t type,
      flutter::ByteStreamReader* stream) const override;
};

// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class WebChromeClientFlutterApi {
 public:
  WebChromeClientFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  void OnProgressChanged(int64_t instance_id,
                         int64_t web_view_instance_id,
                         int64_t progress,
                         std::function<void(void)>&& on_success,
                         std::function<void(const FlutterError&)>&& on_error);
  void OnShowFileChooser(
      int64_t instance_id,
      int64_t web_view_instance_id,
      int64_t params_instance_id,
      std::function<void(const flutter::EncodableList&)>&& on_success,
      std::function<void(const FlutterError&)>&& on_error);
  // Callback to Dart function `WebChromeClient.onPermissionRequest`.
  void OnPermissionRequest(int64_t instance_id,
                           int64_t request_instance_id,
                           std::function<void(void)>&& on_success,
                           std::function<void(const FlutterError&)>&& on_error);
  // Callback to Dart function `WebChromeClient.onShowCustomView`.
  void OnShowCustomView(int64_t instance_id,
                        int64_t view_identifier,
                        int64_t callback_identifier,
                        std::function<void(void)>&& on_success,
                        std::function<void(const FlutterError&)>&& on_error);
  // Callback to Dart function `WebChromeClient.onHideCustomView`.
  void OnHideCustomView(int64_t instance_id,
                        std::function<void(void)>&& on_success,
                        std::function<void(const FlutterError&)>&& on_error);
  // Callback to Dart function
  // `WebChromeClient.onGeolocationPermissionsShowPrompt`.
  void OnGeolocationPermissionsShowPrompt(
      int64_t instance_id,
      int64_t params_instance_id,
      const std::string& origin,
      std::function<void(void)>&& on_success,
      std::function<void(const FlutterError&)>&& on_error);
  // Callback to Dart function
  // `WebChromeClient.onGeolocationPermissionsHidePrompt`.
  void OnGeolocationPermissionsHidePrompt(
      int64_t identifier,
      std::function<void(void)>&& on_success,
      std::function<void(const FlutterError&)>&& on_error);
  // Callback to Dart function `WebChromeClient.onConsoleMessage`.
  void OnConsoleMessage(int64_t instance_id,
                        const ConsoleMessage& message,
                        std::function<void(void)>&& on_success,
                        std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class WebStorageHostApi {
 public:
  WebStorageHostApi(const WebStorageHostApi&) = delete;
  WebStorageHostApi& operator=(const WebStorageHostApi&) = delete;
  virtual ~WebStorageHostApi() {}
  virtual std::optional<FlutterError> Create(int64_t instance_id) = 0;
  virtual std::optional<FlutterError> DeleteAllData(int64_t instance_id) = 0;

  // The codec used by WebStorageHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `WebStorageHostApi` to handle messages through the
  // `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    WebStorageHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  WebStorageHostApi() = default;
};
// Handles callbacks methods for the native Java FileChooserParams class.
//
// See
// https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class FileChooserParamsFlutterApi {
 public:
  FileChooserParamsFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  void Create(int64_t instance_id,
              bool is_capture_enabled,
              const flutter::EncodableList& accept_types,
              const FileChooserMode& mode,
              const std::string* filename_hint,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Host API for `PermissionRequest`.
//
// This class may handle instantiating and adding native object instances that
// are attached to a Dart instance or handle method calls on the associated
// native class or an instance of the class.
//
// See https://developer.android.com/reference/android/webkit/PermissionRequest.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class PermissionRequestHostApi {
 public:
  PermissionRequestHostApi(const PermissionRequestHostApi&) = delete;
  PermissionRequestHostApi& operator=(const PermissionRequestHostApi&) = delete;
  virtual ~PermissionRequestHostApi() {}
  // Handles Dart method `PermissionRequest.grant`.
  virtual std::optional<FlutterError> Grant(
      int64_t instance_id,
      const flutter::EncodableList& resources) = 0;
  // Handles Dart method `PermissionRequest.deny`.
  virtual std::optional<FlutterError> Deny(int64_t instance_id) = 0;

  // The codec used by PermissionRequestHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `PermissionRequestHostApi` to handle messages
  // through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    PermissionRequestHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  PermissionRequestHostApi() = default;
};
// Flutter API for `PermissionRequest`.
//
// This class may handle instantiating and adding Dart instances that are
// attached to a native instance or receiving callback methods from an
// overridden native class.
//
// See https://developer.android.com/reference/android/webkit/PermissionRequest.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class PermissionRequestFlutterApi {
 public:
  PermissionRequestFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  // Create a new Dart instance and add it to the `InstanceManager`.
  void Create(int64_t instance_id,
              const flutter::EncodableList& resources,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Host API for `CustomViewCallback`.
//
// This class may handle instantiating and adding native object instances that
// are attached to a Dart instance or handle method calls on the associated
// native class or an instance of the class.
//
// See
// https://developer.android.com/reference/android/webkit/WebChromeClient.CustomViewCallback.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class CustomViewCallbackHostApi {
 public:
  CustomViewCallbackHostApi(const CustomViewCallbackHostApi&) = delete;
  CustomViewCallbackHostApi& operator=(const CustomViewCallbackHostApi&) =
      delete;
  virtual ~CustomViewCallbackHostApi() {}
  // Handles Dart method `CustomViewCallback.onCustomViewHidden`.
  virtual std::optional<FlutterError> OnCustomViewHidden(
      int64_t identifier) = 0;

  // The codec used by CustomViewCallbackHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `CustomViewCallbackHostApi` to handle messages
  // through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    CustomViewCallbackHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  CustomViewCallbackHostApi() = default;
};
// Flutter API for `CustomViewCallback`.
//
// This class may handle instantiating and adding Dart instances that are
// attached to a native instance or receiving callback methods from an
// overridden native class.
//
// See
// https://developer.android.com/reference/android/webkit/WebChromeClient.CustomViewCallback.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class CustomViewCallbackFlutterApi {
 public:
  CustomViewCallbackFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  // Create a new Dart instance and add it to the `InstanceManager`.
  void Create(int64_t identifier,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Flutter API for `View`.
//
// This class may handle instantiating and adding Dart instances that are
// attached to a native instance or receiving callback methods from an
// overridden native class.
//
// See https://developer.android.com/reference/android/view/View.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class ViewFlutterApi {
 public:
  ViewFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  // Create a new Dart instance and add it to the `InstanceManager`.
  void Create(int64_t identifier,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Host API for `GeolocationPermissionsCallback`.
//
// This class may handle instantiating and adding native object instances that
// are attached to a Dart instance or handle method calls on the associated
// native class or an instance of the class.
//
// See
// https://developer.android.com/reference/android/webkit/GeolocationPermissions.Callback.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class GeolocationPermissionsCallbackHostApi {
 public:
  GeolocationPermissionsCallbackHostApi(
      const GeolocationPermissionsCallbackHostApi&) = delete;
  GeolocationPermissionsCallbackHostApi& operator=(
      const GeolocationPermissionsCallbackHostApi&) = delete;
  virtual ~GeolocationPermissionsCallbackHostApi() {}
  // Handles Dart method `GeolocationPermissionsCallback.invoke`.
  virtual std::optional<FlutterError> Invoke(int64_t instance_id,
                                             const std::string& origin,
                                             bool allow,
                                             bool retain) = 0;

  // The codec used by GeolocationPermissionsCallbackHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `GeolocationPermissionsCallbackHostApi` to handle
  // messages through the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    GeolocationPermissionsCallbackHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  GeolocationPermissionsCallbackHostApi() = default;
};
// Flutter API for `GeolocationPermissionsCallback`.
//
// This class may handle instantiating and adding Dart instances that are
// attached to a native instance or receiving callback methods from an
// overridden native class.
//
// See
// https://developer.android.com/reference/android/webkit/GeolocationPermissions.Callback.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class GeolocationPermissionsCallbackFlutterApi {
 public:
  GeolocationPermissionsCallbackFlutterApi(
      flutter::BinaryMessenger* binary_messenger)
      : binary_messenger_(binary_messenger) {}
  static const flutter::StandardMessageCodec& GetCodec();
  // Create a new Dart instance and add it to the `InstanceManager`.
  void Create(int64_t instance_id,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

// Host API for `HttpAuthHandler`.
//
// This class may handle instantiating and adding native object instances that
// are attached to a Dart instance or handle method calls on the associated
// native class or an instance of the class.
//
// See https://developer.android.com/reference/android/webkit/HttpAuthHandler.
//
// Generated interface from Pigeon that represents a handler of messages from
// Flutter.
class HttpAuthHandlerHostApi {
 public:
  HttpAuthHandlerHostApi(const HttpAuthHandlerHostApi&) = delete;
  HttpAuthHandlerHostApi& operator=(const HttpAuthHandlerHostApi&) = delete;
  virtual ~HttpAuthHandlerHostApi() {}
  // Handles Dart method `HttpAuthHandler.useHttpAuthUsernamePassword`.
  virtual ErrorOr<bool> UseHttpAuthUsernamePassword(int64_t instance_id) = 0;
  // Handles Dart method `HttpAuthHandler.cancel`.
  virtual std::optional<FlutterError> Cancel(int64_t instance_id) = 0;
  // Handles Dart method `HttpAuthHandler.proceed`.
  virtual std::optional<FlutterError> Proceed(int64_t instance_id,
                                              const std::string& username,
                                              const std::string& password) = 0;

  // The codec used by HttpAuthHandlerHostApi.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `HttpAuthHandlerHostApi` to handle messages through
  // the `binary_messenger`.
  static void SetUp(flutter::BinaryMessenger* binary_messenger,
                    HttpAuthHandlerHostApi* api);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  HttpAuthHandlerHostApi() = default;
};
// Flutter API for `HttpAuthHandler`.
//
// This class may handle instantiating and adding Dart instances that are
// attached to a native instance or receiving callback methods from an
// overridden native class.
//
// See https://developer.android.com/reference/android/webkit/HttpAuthHandler.
//
// Generated class from Pigeon that represents Flutter messages that can be
// called from C++.
class HttpAuthHandlerFlutterApi {
 public:
  HttpAuthHandlerFlutterApi(flutter::BinaryMessenger* binary_messenger);
  static const flutter::StandardMessageCodec& GetCodec();
  // Create a new Dart instance and add it to the `InstanceManager`.
  void Create(int64_t instance_id,
              std::function<void(void)>&& on_success,
              std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
};

}  // namespace plugin_webview_flutter
#endif  // PIGEON_MESSAGE_G_H_
