// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

#include "google/protobuf/map_lite_test_util.h"

#include "google/protobuf/map_lite_unittest.pb.h"
#include "google/protobuf/map_test_util_impl.h"

namespace google {
namespace protobuf {

void MapLiteTestUtil::SetMapFields(unittest::TestMapLite* message) {
  MapTestUtilImpl::SetMapFields<unittest::MapEnumLite,
                                unittest::MAP_ENUM_BAR_LITE,
                                unittest::MAP_ENUM_BAZ_LITE>(message);
}

void MapLiteTestUtil::SetArenaMapFields(unittest::TestArenaMapLite* message) {
  MapTestUtilImpl::SetArenaMapFields<unittest::MapEnumLite,
                                     unittest::MAP_ENUM_BAR_LITE,
                                     unittest::MAP_ENUM_BAZ_LITE>(message);
}

void MapLiteTestUtil::SetMapFieldsInitialized(unittest::TestMapLite* message) {
  MapTestUtilImpl::SetMapFieldsInitialized(message);
}

void MapLiteTestUtil::ModifyMapFields(unittest::TestMapLite* message) {
  MapTestUtilImpl::ModifyMapFields<unittest::MapEnumLite,
                                   unittest::MAP_ENUM_FOO_LITE>(message);
}

void MapLiteTestUtil::ExpectClear(const unittest::TestMapLite& message) {
  MapTestUtilImpl::ExpectClear(message);
}

void MapLiteTestUtil::ExpectMapFieldsSet(const unittest::TestMapLite& message) {
  MapTestUtilImpl::ExpectMapFieldsSet<unittest::MapEnumLite,
                                      unittest::MAP_ENUM_BAR_LITE,
                                      unittest::MAP_ENUM_BAZ_LITE>(message);
}

void MapLiteTestUtil::ExpectArenaMapFieldsSet(
    const unittest::TestArenaMapLite& message) {
  MapTestUtilImpl::ExpectArenaMapFieldsSet<unittest::MapEnumLite,
                                           unittest::MAP_ENUM_BAR_LITE,
                                           unittest::MAP_ENUM_BAZ_LITE>(
      message);
}

void MapLiteTestUtil::ExpectMapFieldsSetInitialized(
    const unittest::TestMapLite& message) {
  MapTestUtilImpl::ExpectMapFieldsSetInitialized<unittest::MapEnumLite,
                                                 unittest::MAP_ENUM_FOO_LITE>(
      message);
}

void MapLiteTestUtil::ExpectMapFieldsModified(
    const unittest::TestMapLite& message) {
  MapTestUtilImpl::ExpectMapFieldsModified<unittest::MapEnumLite,
                                           unittest::MAP_ENUM_BAR_LITE,
                                           unittest::MAP_ENUM_FOO_LITE>(
      message);
}

}  // namespace protobuf
}  // namespace google
