/* valaccodecompiler.c generated by valac, the Vala compiler
 * generated from valaccodecompiler.vala, do not modify */

/* valaccodecompiler.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valacodegen.h"
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecCCodeCompiler ValaParamSpecCCodeCompiler;

struct _ValaParamSpecCCodeCompiler {
	GParamSpec parent_instance;
};

static gpointer vala_ccode_compiler_parent_class = NULL;

static void vala_ccode_compiler_finalize (ValaCCodeCompiler * obj);
static GType vala_ccode_compiler_get_type_once (void);

ValaCCodeCompiler*
vala_ccode_compiler_construct (GType object_type)
{
	ValaCCodeCompiler* self = NULL;
	self = (ValaCCodeCompiler*) g_type_create_instance (object_type);
	return self;
}

ValaCCodeCompiler*
vala_ccode_compiler_new (void)
{
	return vala_ccode_compiler_construct (VALA_TYPE_CCODE_COMPILER);
}

/**
 * Compile generated C code to object code and optionally link object
 * files.
 *
 * @param context a code context
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
vala_ccode_compiler_compile (ValaCCodeCompiler* self,
                             ValaCodeContext* context,
                             const gchar* cc_command,
                             gchar** cc_options,
                             gint cc_options_length1)
{
	gchar* pc = NULL;
	gchar* _tmp0_;
	ValaProfile _tmp1_;
	ValaProfile _tmp2_;
	gchar* pkgflags = NULL;
	const gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gchar* cmdline = NULL;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	ValaList* source_files = NULL;
	ValaList* _tmp60_;
	ValaList* _tmp61_;
	ValaList* c_source_files = NULL;
	ValaList* _tmp82_;
	ValaList* _tmp83_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gboolean _tmp114_;
	gboolean _tmp115_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_strdup ("");
	pc = _tmp0_;
	_tmp1_ = vala_code_context_get_profile (context);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_PROFILE_GOBJECT) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = pc;
		_tmp4_ = g_strconcat (_tmp3_, " gobject-2.0", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
	}
	{
		ValaList* _pkg_list = NULL;
		ValaList* _tmp5_;
		gint _pkg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _pkg_index = 0;
		_tmp5_ = vala_code_context_get_packages (context);
		_pkg_list = _tmp5_;
		_tmp6_ = _pkg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_pkg_size = _tmp8_;
		_pkg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gchar* pkg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			const gchar* _tmp13_;
			_pkg_index = _pkg_index + 1;
			_tmp9_ = _pkg_index;
			_tmp10_ = _pkg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _pkg_list;
			_tmp12_ = vala_list_get (_tmp11_, _pkg_index);
			pkg = (gchar*) _tmp12_;
			_tmp13_ = pkg;
			if (vala_code_context_pkg_config_exists (context, _tmp13_)) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = pc;
				_tmp15_ = pkg;
				_tmp16_ = g_strconcat (" ", _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
				_g_free0 (pc);
				pc = _tmp18_;
				_g_free0 (_tmp17_);
			}
			_g_free0 (pkg);
		}
	}
	_tmp19_ = pc;
	_tmp20_ = strlen (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ > 0) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = pc;
		_tmp23_ = vala_code_context_pkg_config_compile_flags (context, _tmp22_);
		_g_free0 (pkgflags);
		pkgflags = _tmp23_;
		_tmp24_ = pkgflags;
		if (_tmp24_ == NULL) {
			_g_free0 (pkgflags);
			_g_free0 (pc);
			return;
		}
	} else {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("");
		_g_free0 (pkgflags);
		pkgflags = _tmp25_;
	}
	if (cc_command == NULL) {
		cc_command = "cc";
	}
	_tmp26_ = g_strdup (cc_command);
	cmdline = _tmp26_;
	_tmp27_ = vala_code_context_get_debug (context);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = cmdline;
		_tmp30_ = g_strconcat (_tmp29_, " -g", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp30_;
	}
	_tmp31_ = vala_code_context_get_compile_only (context);
	_tmp32_ = _tmp31_;
	if (_tmp32_) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp33_ = cmdline;
		_tmp34_ = g_strconcat (_tmp33_, " -c", NULL);
		_g_free0 (cmdline);
		cmdline = _tmp34_;
	} else {
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp35_ = vala_code_context_get_output (context);
		_tmp36_ = _tmp35_;
		if (_tmp36_ != NULL) {
			gchar* output = NULL;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_ = FALSE;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp37_ = vala_code_context_get_output (context);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup (_tmp38_);
			output = _tmp39_;
			_tmp42_ = vala_code_context_get_directory (context);
			_tmp43_ = _tmp42_;
			if (_tmp43_ != NULL) {
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				_tmp44_ = vala_code_context_get_directory (context);
				_tmp45_ = _tmp44_;
				_tmp41_ = g_strcmp0 (_tmp45_, "") != 0;
			} else {
				_tmp41_ = FALSE;
			}
			if (_tmp41_) {
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp46_ = vala_code_context_get_output (context);
				_tmp47_ = _tmp46_;
				_tmp40_ = !g_path_is_absolute (_tmp47_);
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp48_ = vala_code_context_get_directory (context);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_code_context_get_output (context);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strdup_printf ("%s%c%s", _tmp49_, (gint) G_DIR_SEPARATOR, _tmp51_);
				_g_free0 (output);
				output = _tmp52_;
			}
			_tmp53_ = cmdline;
			_tmp54_ = output;
			_tmp55_ = g_shell_quote (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat (" -o ", _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strconcat (_tmp53_, _tmp58_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp59_;
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_free0 (output);
		}
	}
	_tmp60_ = vala_code_context_get_source_files (context);
	_tmp61_ = _vala_iterable_ref0 (_tmp60_);
	source_files = _tmp61_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp62_;
		gint _file_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _file_index = 0;
		_tmp62_ = source_files;
		_file_list = _tmp62_;
		_tmp63_ = _file_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_file_size = _tmp65_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaSourceFile* _tmp70_;
			ValaSourceFileType _tmp71_;
			ValaSourceFileType _tmp72_;
			_file_index = _file_index + 1;
			_tmp66_ = _file_index;
			_tmp67_ = _file_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _file_list;
			_tmp69_ = vala_list_get (_tmp68_, _file_index);
			file = (ValaSourceFile*) _tmp69_;
			_tmp70_ = file;
			_tmp71_ = vala_source_file_get_file_type (_tmp70_);
			_tmp72_ = _tmp71_;
			if (_tmp72_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				const gchar* _tmp73_;
				ValaSourceFile* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp73_ = cmdline;
				_tmp74_ = file;
				_tmp75_ = vala_source_file_get_csource_filename (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_shell_quote (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strconcat (" ", _tmp78_, NULL);
				_tmp80_ = _tmp79_;
				_tmp81_ = g_strconcat (_tmp73_, _tmp80_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp81_;
				_g_free0 (_tmp80_);
				_g_free0 (_tmp78_);
				_g_free0 (_tmp76_);
			}
			_vala_source_file_unref0 (file);
		}
	}
	_tmp82_ = vala_code_context_get_c_source_files (context);
	_tmp83_ = _vala_iterable_ref0 (_tmp82_);
	c_source_files = _tmp83_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp84_;
		gint _file_size = 0;
		ValaList* _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		gint _file_index = 0;
		_tmp84_ = c_source_files;
		_file_list = _tmp84_;
		_tmp85_ = _file_list;
		_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
		_tmp87_ = _tmp86_;
		_file_size = _tmp87_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp88_;
			gint _tmp89_;
			gchar* file = NULL;
			ValaList* _tmp90_;
			gpointer _tmp91_;
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			_file_index = _file_index + 1;
			_tmp88_ = _file_index;
			_tmp89_ = _file_size;
			if (!(_tmp88_ < _tmp89_)) {
				break;
			}
			_tmp90_ = _file_list;
			_tmp91_ = vala_list_get (_tmp90_, _file_index);
			file = (gchar*) _tmp91_;
			_tmp92_ = cmdline;
			_tmp93_ = file;
			_tmp94_ = g_shell_quote (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strconcat (" ", _tmp95_, NULL);
			_tmp97_ = _tmp96_;
			_tmp98_ = g_strconcat (_tmp92_, _tmp97_, NULL);
			_g_free0 (cmdline);
			cmdline = _tmp98_;
			_g_free0 (_tmp97_);
			_g_free0 (_tmp95_);
			_g_free0 (file);
		}
	}
	_tmp99_ = cmdline;
	_tmp100_ = pkgflags;
	_tmp101_ = string_strip (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = g_strconcat (" ", _tmp102_, NULL);
	_tmp104_ = _tmp103_;
	_tmp105_ = g_strconcat (_tmp99_, _tmp104_, NULL);
	_g_free0 (cmdline);
	cmdline = _tmp105_;
	_g_free0 (_tmp104_);
	_g_free0 (_tmp102_);
	{
		gchar** cc_option_collection = NULL;
		gint cc_option_collection_length1 = 0;
		gint _cc_option_collection_size_ = 0;
		gint cc_option_it = 0;
		cc_option_collection = cc_options;
		cc_option_collection_length1 = cc_options_length1;
		for (cc_option_it = 0; cc_option_it < cc_option_collection_length1; cc_option_it = cc_option_it + 1) {
			gchar* _tmp106_;
			gchar* cc_option = NULL;
			_tmp106_ = g_strdup (cc_option_collection[cc_option_it]);
			cc_option = _tmp106_;
			{
				const gchar* _tmp107_;
				const gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				gchar* _tmp113_;
				_tmp107_ = cmdline;
				_tmp108_ = cc_option;
				_tmp109_ = g_shell_quote (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = g_strconcat (" ", _tmp110_, NULL);
				_tmp112_ = _tmp111_;
				_tmp113_ = g_strconcat (_tmp107_, _tmp112_, NULL);
				_g_free0 (cmdline);
				cmdline = _tmp113_;
				_g_free0 (_tmp112_);
				_g_free0 (_tmp110_);
				_g_free0 (cc_option);
			}
		}
	}
	_tmp114_ = vala_code_context_get_verbose_mode (context);
	_tmp115_ = _tmp114_;
	if (_tmp115_) {
		const gchar* _tmp116_;
		_tmp116_ = cmdline;
		g_print ("%s\n", _tmp116_);
	}
	{
		gint exit_status = 0;
		const gchar* _tmp117_;
		gint _tmp118_ = 0;
		_tmp117_ = cmdline;
		g_spawn_command_line_sync (_tmp117_, NULL, NULL, &_tmp118_, &_inner_error0_);
		exit_status = _tmp118_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_vala_iterable_unref0 (c_source_files);
			_vala_iterable_unref0 (source_files);
			_g_free0 (cmdline);
			_g_free0 (pkgflags);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (exit_status != 0) {
			vala_report_error (NULL, "cc exited with status %d", exit_status);
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp119_;
		const gchar* _tmp120_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp119_ = e;
		_tmp120_ = _tmp119_->message;
		vala_report_error (NULL, "%s", _tmp120_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_vala_iterable_unref0 (c_source_files);
		_vala_iterable_unref0 (source_files);
		_g_free0 (cmdline);
		_g_free0 (pkgflags);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp121_ = vala_code_context_get_save_csources (context);
	_tmp122_ = _tmp121_;
	if (!_tmp122_) {
		{
			ValaList* _file_list = NULL;
			ValaList* _tmp123_;
			gint _file_size = 0;
			ValaList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _file_index = 0;
			_tmp123_ = source_files;
			_file_list = _tmp123_;
			_tmp124_ = _file_list;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
			_tmp126_ = _tmp125_;
			_file_size = _tmp126_;
			_file_index = -1;
			while (TRUE) {
				gint _tmp127_;
				gint _tmp128_;
				ValaSourceFile* file = NULL;
				ValaList* _tmp129_;
				gpointer _tmp130_;
				ValaSourceFile* _tmp131_;
				ValaSourceFileType _tmp132_;
				ValaSourceFileType _tmp133_;
				_file_index = _file_index + 1;
				_tmp127_ = _file_index;
				_tmp128_ = _file_size;
				if (!(_tmp127_ < _tmp128_)) {
					break;
				}
				_tmp129_ = _file_list;
				_tmp130_ = vala_list_get (_tmp129_, _file_index);
				file = (ValaSourceFile*) _tmp130_;
				_tmp131_ = file;
				_tmp132_ = vala_source_file_get_file_type (_tmp131_);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
					ValaSourceFile* _tmp134_;
					gchar* _tmp135_;
					gchar* _tmp136_;
					_tmp134_ = file;
					_tmp135_ = vala_source_file_get_csource_filename (_tmp134_);
					_tmp136_ = _tmp135_;
					g_unlink (_tmp136_);
					_g_free0 (_tmp136_);
				}
				_vala_source_file_unref0 (file);
			}
		}
	}
	_vala_iterable_unref0 (c_source_files);
	_vala_iterable_unref0 (source_files);
	_g_free0 (cmdline);
	_g_free0 (pkgflags);
	_g_free0 (pc);
}

static void
vala_value_ccode_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_ccode_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_ccode_compiler_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_ccode_compiler_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_ccode_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_ccode_compiler_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCCodeCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_ccode_compiler_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	ValaCCodeCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_ccode_compiler (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ValaParamSpecCCodeCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_ccode_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_ccode_compiler (GValue* value,
                               gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}

void
vala_value_take_ccode_compiler (GValue* value,
                                gpointer v_object)
{
	ValaCCodeCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_compiler_unref (old);
	}
}

static void
vala_ccode_compiler_class_init (ValaCCodeCompilerClass * klass,
                                gpointer klass_data)
{
	vala_ccode_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeCompilerClass *) klass)->finalize = vala_ccode_compiler_finalize;
}

static void
vala_ccode_compiler_instance_init (ValaCCodeCompiler * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_ccode_compiler_finalize (ValaCCodeCompiler * obj)
{
	ValaCCodeCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler);
	g_signal_handlers_destroy (self);
}

/**
 * Interface to the C compiler.
 */
static GType
vala_ccode_compiler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_compiler_init, vala_value_ccode_compiler_free_value, vala_value_ccode_compiler_copy_value, vala_value_ccode_compiler_peek_pointer, "p", vala_value_ccode_compiler_collect_value, "p", vala_value_ccode_compiler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCompiler), 0, (GInstanceInitFunc) vala_ccode_compiler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_ccode_compiler_type_id;
	vala_ccode_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_ccode_compiler_type_id;
}

GType
vala_ccode_compiler_get_type (void)
{
	static volatile gsize vala_ccode_compiler_type_id__once = 0;
	if (g_once_init_enter (&vala_ccode_compiler_type_id__once)) {
		GType vala_ccode_compiler_type_id;
		vala_ccode_compiler_type_id = vala_ccode_compiler_get_type_once ();
		g_once_init_leave (&vala_ccode_compiler_type_id__once, vala_ccode_compiler_type_id);
	}
	return vala_ccode_compiler_type_id__once;
}

gpointer
vala_ccode_compiler_ref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_ccode_compiler_unref (gpointer instance)
{
	ValaCCodeCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

