#!/bin/sh

# MOST setup parameters
CDEV_NUM_BUFFERS=32
CDEV_BUFFER_SIZE=128

SOUND_PACKETS_PER_XACT=128
SOUND_SUBBUFFER_SIZE=4
SOUND_NUM_BUFFERS=4
SOUND_BUFFER_SIZE=4096
SOUND_PARAMS=2x16

# Use cfgfs for Linux kernel 5.4 and above
set_cdev_cfgfs()
{
	CHANCFGFS=${MOSTCFGFS}/most_cdev/${1}

	echo "-- Setting up cdev ${1}: ${3} channel ${2} --"
	mkdir -p ${CHANCFGFS}
	echo -n ${DEVICE}		> ${CHANCFGFS}/device
	echo -n ${2}			> ${CHANCFGFS}/channel
	echo control			> ${CHANCFGFS}/datatype
	echo dir_${3}			> ${CHANCFGFS}/direction
	echo ${CDEV_NUM_BUFFERS}	> ${CHANCFGFS}/num_buffers
	echo ${CDEV_BUFFER_SIZE}	> ${CHANCFGFS}/buffer_size
	echo 1				> ${CHANCFGFS}/create_link
}

set_sound_cfgfs()
{
	CHANCFGFS=${MOSTCFGFS}/most_sound/${MDEV}/${1}

	echo "-- Setting up sound ${1}: ${3} channel ${2} --"
	mkdir -p ${CHANCFGFS}
	echo -n ${DEVICE}		> ${CHANCFGFS}/device
	echo -n ${2}			> ${CHANCFGFS}/channel
	echo ${SOUND_PACKETS_PER_XACT}	> ${CHANCFGFS}/packets_per_xact
	echo ${SOUND_SUBBUFFER_SIZE}	> ${CHANCFGFS}/subbuffer_size
	echo sync			> ${CHANCFGFS}/datatype
	echo dir_${3}			> ${CHANCFGFS}/direction
	echo ${SOUND_NUM_BUFFERS}	> ${CHANCFGFS}/num_buffers
	echo ${SOUND_BUFFER_SIZE}	> ${CHANCFGFS}/buffer_size
	echo ${SOUND_PARAMS}		> ${CHANCFGFS}/comp_params
	echo 1				> ${CHANCFGFS}/create_link
}

# Use sysfs before Linux kernel 5.4
set_cdev_sysfs()
{
	CHANSYSFS=${MOSTSYSFS}/devices/${MDEV}/${2}
	AIMSSYSFS=${MOSTSYSFS}/aims/cdev

	echo "-- Setting up cdev ${1}: ${3} channel ${2} --"
	echo control			> ${CHANSYSFS}/set_datatype
	echo dir_${3}			> ${CHANSYSFS}/set_direction
	echo ${CDEV_NUM_BUFFERS}	> ${CHANSYSFS}/set_number_of_buffers
	echo ${CDEV_BUFFER_SIZE}	> ${CHANSYSFS}/set_buffer_size
	echo ${MDEV}:${2}:${1}		> ${AIMSSYSFS}/add_link
}

set_sound_sysfs()
{
	CHANSYSFS=${MOSTSYSFS}/devices/${MDEV}/${2}
	AIMSSYSFS=${MOSTSYSFS}/aims/sound

	echo "-- Setting up sound ${1}: ${3} channel ${2} --"
	echo ${SOUND_PACKETS_PER_XACT}	> ${CHANSYSFS}/set_packets_per_xact
	echo ${SOUND_SUBBUFFER_SIZE}	> ${CHANSYSFS}/set_subbuffer_size
	echo sync			> ${CHANSYSFS}/set_datatype
	echo dir_${3}			> ${CHANSYSFS}/set_direction
	echo ${SOUND_NUM_BUFFERS}	> ${CHANSYSFS}/set_number_of_buffers
	echo ${SOUND_BUFFER_SIZE}	> ${CHANSYSFS}/set_buffer_size
	echo ${MDEV}:${2}:${1}.${SOUND_PARAMS} > ${AIMSSYSFS}/add_link
}

# Setup MOST
MDEV=mdev0
DEVICE=dim2-00000000ec520000
MOSTCFGFS=/sys/kernel/config
MOSTSYSFS=/sys/devices/virtual/most/mostcore

if [ -d ${MOSTCFGFS}/most_cdev ]; then
	set_cdev_cfgfs most_ctrl_rx ca2 rx
	set_cdev_cfgfs most_ctrl_tx ca4 tx
elif [ -d ${MOSTSYSFS}/aims/cdev ]; then
	set_cdev_sysfs most_ctrl_rx ca2 rx
	set_cdev_sysfs most_ctrl_tx ca4 tx
else
	echo "MOST cdev component not found"
	exit 1
fi

if [ -d ${MOSTCFGFS}/most_sound ]; then
	set_sound_cfgfs rx0 ca6 rx
	set_sound_cfgfs tx0 ca8 tx
	set_sound_cfgfs tx1 ca12 tx

	echo 1 > ${MOSTCFGFS}/most_sound/${MDEV}/create_card
elif [ -d ${MOSTSYSFS}/aims/sound ]; then
	set_sound_sysfs rx0 ca6 rx
	set_sound_sysfs tx0 ca8 tx
	set_sound_sysfs tx1 ca12 tx
else
	echo "MOST sound component not found"
	exit 1
fi

echo "MOST setup complete"
