SUMMARY = "Hunspell dictionaries used by Maliit"

#Provided by Titus Wormer (wooorm) https://github.com/wooorm/dictionaries

LICENSE = "MIT"
LICENSE:dictionaries/bg = "LGPL 2.1"
LICENSE:dictionaries/br = "GPL 3.0"
LICENSE:dictionaries/ca-valencia = "GPL 2.0 & LGPL-2.1-only"
LICENSE:dictionaries/ca = "GPL 2.0 & LGPL-2.1-only"
LICENSE:dictionaries/cs = "GPL-2.0-only"
LICENSE:dictionaries/da = "GPL-2.0-only"
LICENSE:dictionaries/de-AT = "GPL-3.0-only"
LICENSE:dictionaries/de-CH = "GPL-3.0-only"
LICENSE:dictionaries/de = "GPL-3.0-only"
LICENSE:dictionaries/el-polyton = "GPL-2.0-only"
LICENSE:dictionaries/el = "GPL-2.0-only"
LICENSE:dictionaries/en-AU = "LGPL-2.0-only"
LICENSE:dictionaries/en-CA = "MIT & BSD"
LICENSE:dictionaries/en-GB = "LGPL-2.0-only"
LICENSE:dictionaries/en-US = "MIT & BSD"
LICENSE:dictionaries/en-ZA = "LGPL 2.1"
LICENSE:dictionaries/eo = "GPL-2.0-only"
LICENSE:dictionaries/es = "GPL-3.0-only"
LICENSE:dictionaries/et = "LGPL-2.1-only"
LICENSE:dictionaries/eu = "GPL-2.0-only"
LICENSE:dictionaries/fo = "GPL-2.0-only"
LICENSE:dictionaries/fr = "MPL-2.0"
LICENSE:dictionaries/fur = "GPL-2.0-only"
LICENSE:dictionaries/fy = "GPL-3.0-only"
LICENSE:dictionaries/ga = "GPL-2.0-only"
LICENSE:dictionaries/gd = "GPL-3.0-only"
LICENSE:dictionaries/gl = "GPL-3.0-only"
LICENSE:dictionaries/he = "AGPL-3.0-only"
LICENSE:dictionaries/hr = "GPL-3.0-only"
LICENSE:dictionaries/hu = "GPL-2.0-only"
LICENSE:dictionaries/hy-arevela = "GPL-2.0-only"
LICENSE:dictionaries/hy-arevmda = "GPL-2.0-only"
LICENSE:dictionaries/ia = "GPL-3.0-only"
LICENSE:dictionaries/ie = "Apache-2.0"
LICENSE:dictionaries/is = "CC BY-SA 3.0 & CC BY 4.0"
LICENSE:dictionaries/it = "GPL-3.0-only"
LICENSE:dictionaries/ko = "MPL-1.1 & GPL-2.0-only & LGPL-2.1-only"
LICENSE:dictionaries/la = "GPL-3.0-only"
LICENSE:dictionaries/lb = "EUPL-1.1"
LICENSE:dictionaries/lt = "Other"
LICENSE:dictionaries/ltg = "LGPL-2.1-only"
LICENSE:dictionaries/lv = "LGPL-2.1-only"
LICENSE:dictionaries/mk = "GPL-3.0-only"
LICENSE:dictionaries/mn = "GPL-2.0-only"
LICENSE:dictionaries/nb = "GPL-2.0-only"
LICENSE:dictionaries/nds = "GPL-2.0-only"
LICENSE:dictionaries/ne = "LGPL-2.1-only"
LICENSE:dictionaries/nl = "BSD"
LICENSE:dictionaries/nn = "GPL-2.0-only"
LICENSE:dictionaries/pl = "GPL-3.0-only"
LICENSE:dictionaries/pt-BR = "LGPL 2.1"
LICENSE:dictionaries/pt = "GPL-2.0-only"
LICENSE:dictionaries/ro = "GPL-2.0-only"
LICENSE:dictionaries/ru = "BSD"
LICENSE:dictionaries/rw = "GPL-3.0-only"
LICENSE:dictionaries/sk = "GPL-2.0-only"
LICENSE:dictionaries/sl = "GPL-2.0-only"
LICENSE:dictionaries/sr-Latn = "LGPL 3.0"
LICENSE:dictionaries/sr = "LGPL 3.0"
LICENSE:dictionaries/sv = "LGPL 3.0"
LICENSE:dictionaries/tr = "MIT"
LICENSE:dictionaries/uk = "GPL 2.0"
LICENSE:dictionaries/vi = "GPL 3.0"
LIC_FILES_CHKSUM = " \
    file://dictionaries/bg/license;md5=ab14e2ded1a43b84be9aba2be64b9814 \
    file://dictionaries/br/license;md5=2e046c64edc0a4e47fb3ea614e6c82c4 \
    file://dictionaries/ca-valencia/license;md5=da087cefab7bc3b7687203198a0042ec \
    file://dictionaries/ca/license;md5=da087cefab7bc3b7687203198a0042ec \
    file://dictionaries/cs/license;md5=e0496d626a53ad31addea1869c1bed53 \
    file://dictionaries/da/license;md5=b7678b3e997999043be3503dc717d96d \
    file://dictionaries/de-AT/license;md5=a03d823e8cd00fd71c9ba18b8ec4ccf1 \
    file://dictionaries/de-CH/license;md5=a03d823e8cd00fd71c9ba18b8ec4ccf1 \
    file://dictionaries/de/license;md5=a03d823e8cd00fd71c9ba18b8ec4ccf1 \
    file://dictionaries/el-polyton/license;md5=d952bcbf1c67129920f03536197c7281 \
    file://dictionaries/el/license;md5=90b757dd77b1ebbf473eef31037a59e8 \
    file://dictionaries/en-AU/license;md5=dae002c846eab5e1132ba2e00692dc68 \
    file://dictionaries/en-CA/license;md5=6c205de0cbcae4b42cf992bb355a5346 \
    file://dictionaries/en-GB/license;md5=dd6d2bbd7b7f4519448f2b995fd99cd4 \
    file://dictionaries/en-US/license;md5=244a909f295640bfafeb8d9e522d454b \
    file://dictionaries/en-ZA/license;md5=56e4b4ca965de3bba6db42494cc34576 \
    file://dictionaries/eo/license;md5=eb723b61539feef013de476e68b5c50a \
    file://dictionaries/es/license;md5=b41cabf4e6f2a7d951684246518bea4f \
    file://dictionaries/et/readme.md;md5=59d851f12cc280f893b245938abc1905 \
    file://dictionaries/fo/license;md5=fa9ce505d07423c9f8e6c1073f4806c2 \
    file://dictionaries/fr/license;md5=2346c7bffe6ab4d51730ab3116817c72 \
    file://dictionaries/fur/license;md5=28ac8c6e75d6c44b60016a8c850036e3 \
    file://dictionaries/fy/license;md5=c05115c38ca2a4aa95cb9c9b00ed78df \
    file://dictionaries/ga/license;md5=ee7d601b5d3be3856a169afa71eb3376 \
    file://dictionaries/gd/license;md5=b5f39c26d691733095323a59d0f02216 \
    file://dictionaries/gl/license;md5=d32239bcb673463ab874e80d47fae504 \
    file://dictionaries/he/license;md5=e627dcdf6878e7eca4454e39d1489271 \
    file://dictionaries/hr/license;md5=4b03c9b6e41a6ef12b4e31d2fb224d46 \
    file://dictionaries/hu/license;md5=c9755266de74fdbe69636bdb3076b603 \
    file://dictionaries/hy-arevela/license;md5=c690b6bc807de0a6dcd62db030843ee4 \
    file://dictionaries/hy-arevmda/license;md5=c690b6bc807de0a6dcd62db030843ee4 \
    file://dictionaries/ia/license;md5=25c37bbb54f9ab5da9b4bcdda2e2f68e \
    file://dictionaries/ie/license;md5=fa818a259cbed7ce8bc2a22d35a464fc \
    file://dictionaries/is/license;md5=db5e38a312b91d717561514767c95999 \
    file://dictionaries/it/license;md5=31d06285633a89f4d0267895ef8b7107 \
    file://dictionaries/ko/license;md5=5ff35d5b0523cccb3049edff77c73a10 \
    file://dictionaries/la/license;md5=9bc08ae2930eb806cee44bbae905b7ba \
    file://dictionaries/lb/license;md5=5d6417331778645577c40c3329a3d559 \
    file://dictionaries/lt/license;md5=3d1264d7017271c6731fefaba912a15f \
    file://dictionaries/ltg/license;md5=72c786f9d43bb07c101766457fcf6435 \
    file://dictionaries/lv/license;md5=957d42bd58feff079daa6ede1d215585 \
    file://dictionaries/mk/license;md5=c05a3747d4c871f3c6378909668ec72d \
    file://dictionaries/mn/license;md5=93a1be573a1bd039cb4e17c21ed800a7 \
    file://dictionaries/nb/license;md5=6b50c67a5ee9ba5af1b4ab6c009b66f2 \
    file://dictionaries/nds/license;md5=08c69ee106e67a1085d45dc723ae5396 \
    file://dictionaries/ne/license;md5=620e39f1aec72b0bdbc922128dd08267 \
    file://dictionaries/nl/license;md5=f9181fe437dd701ce6ae690f6e09b119 \
    file://dictionaries/nn/license;md5=9d372c99817cb42bdd1f6c0acb7f4d11 \
    file://dictionaries/pl/license;md5=5d0961c4eee8448d5f3738b1ff04ebe8 \
    file://dictionaries/pt-BR/license;md5=08a7e74543d3e612e7613f2959bedab0 \
    file://dictionaries/pt/license;md5=53d8ed71b4053ef0ccfcf6b3f89880a8 \
    file://dictionaries/ro/license;md5=db18b1d6cfc0d4ca32371cb76900de2c \
    file://dictionaries/ru/license;md5=a3d4108679bd3b76ec1a86520b5362cf \
    file://dictionaries/rw/license;md5=784d7dc7357bd924e8d5642892bf1b6b \
    file://dictionaries/sk/license;md5=7fb3956bf960db433deedec7746d33c5 \
    file://dictionaries/sl/license;md5=4965d53062ea2045837facf483475ac7 \
    file://dictionaries/sr-Latn/license;md5=0139a4b8ce316882cceae8924030950d \
    file://dictionaries/sr/license;md5=0139a4b8ce316882cceae8924030950d \
    file://dictionaries/sv/license;md5=fe5c586fe56d04fbdc44df187129ac29 \
    file://dictionaries/tr/readme.md;md5=27c07bbfa543cfdd163f2dad491703bd \
    file://dictionaries/uk/license;md5=7702f203b58979ebbc31bfaeb44f219c \
    file://dictionaries/vi/license;md5=8d9ecb4e7577ce760029786aba7ecec5 \
"

RDEPENDS:${PN} = "hunspell"

PV = "0.0.0+git"
SRCREV = "820a65e539e34a3a8c2a855d2450b84745c624ee"
SRC_URI = "git://github.com/wooorm/dictionaries.git;branch=master;protocol=https"

S = "${WORKDIR}/git"

do_install() {
    for LANGUAGE in `ls -d1 ${S}/dictionaries/*` ; do
        LANGUAGE_DIR=`basename $LANGUAGE | sed 's:-:_:'`
        install -D -m0644 $LANGUAGE/index.dic ${D}${datadir}/hunspell/$LANGUAGE_DIR.dic
        install -D -m0644 $LANGUAGE/index.aff ${D}${datadir}/hunspell/$LANGUAGE_DIR.aff
        install -D -m0644 $LANGUAGE/LICENSE   ${D}${datadir}/hunspell/LICENSE-$LANGUAGE_DIR 2>/dev/null || echo "No LICENSE for language $LANGUAGE"
    done
}

FILES:${PN} = "${datadir}/hunspell"
