/* Generated by re2c */
#line 1 "real_world/parse_date_b.re"
// re2c $INPUT -o $OUTPUT -b
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */



#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 846 "real_world/parse_date_b.re"



#line 744 "real_world/parse_date_b.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		104,  32,  32,  32,  32,  32,  32,  32, 
		 32,  32,  32,  32,  96,  32,  96,   0, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 192, 128, 128, 128, 
		192, 128, 128, 128, 128, 128, 192, 128, 
		128, 128, 192, 192, 192, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00:
		case '\n': goto yy1;
		case ' ': goto yy4;
		case '(': goto yy6;
		case '+':
		case '-': goto yy7;
		case ',':
		case '.': goto yy8;
		case '0': goto yy9;
		case '1': goto yy10;
		case '2': goto yy11;
		case '3': goto yy12;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy13;
		case '@': goto yy14;
		case 'A': goto yy15;
		case 'B':
		case 'C':
		case 'G':
		case 'H':
		case 'K':
		case 'Q':
		case 'R':
		case 'U':
		case 'Z': goto yy17;
		case 'D': goto yy18;
		case 'E': goto yy19;
		case 'F': goto yy20;
		case 'I': goto yy21;
		case 'J': goto yy22;
		case 'L': goto yy23;
		case 'M': goto yy24;
		case 'N': goto yy25;
		case 'O': goto yy26;
		case 'P': goto yy27;
		case 'S': goto yy28;
		case 'T': goto yy29;
		case 'V': goto yy30;
		case 'W': goto yy31;
		case 'X': goto yy32;
		case 'Y': goto yy33;
		case 'a': goto yy34;
		case 'b':
		case 'c':
		case 'g':
		case 'h':
		case 'i':
		case 'k':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy35;
		case 'd': goto yy36;
		case 'e': goto yy37;
		case 'f': goto yy38;
		case 'j': goto yy39;
		case 'l': goto yy40;
		case 'm': goto yy41;
		case 'n': goto yy42;
		case 'o': goto yy43;
		case 'p': goto yy44;
		case 's': goto yy45;
		case 't': goto yy46;
		case 'w': goto yy47;
		case 'y': goto yy48;
		default: goto yy2;
	}
yy1:
	++YYCURSOR;
#line 1401 "real_world/parse_date_b.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 865 "real_world/parse_date_b.c"
yy2:
	++YYCURSOR;
yy3:
#line 1407 "real_world/parse_date_b.re"
	{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
#line 875 "real_world/parse_date_b.c"
yy4:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy49;
	}
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy51;
yy5:
#line 1396 "real_world/parse_date_b.re"
	{
		goto std;
	}
#line 889 "real_world/parse_date_b.c"
yy6:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy3;
	if (yych <= 'Z') goto yy35;
	if (yych <= '`') goto yy3;
	if (yych <= 'z') goto yy35;
	goto yy3;
yy7:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy49;
	}
	if (yych <= '/') goto yy3;
	if (yych <= '1') goto yy52;
	if (yych <= '2') goto yy53;
	if (yych <= '9') goto yy54;
	goto yy3;
yy8:
	++YYCURSOR;
	goto yy5;
yy9:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'w':
		case 'y': goto yy56;
		case '-': goto yy59;
		case '.': goto yy60;
		case '/': goto yy61;
		case '0': goto yy62;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy63;
		case ':': goto yy64;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy10:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2': goto yy63;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy88;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2':
		case '3': goto yy88;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy92;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy12:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1': goto yy92;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy93;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy13:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy93;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy14:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy94;
	if (yych <= '0') goto yy3;
	if (yych <= '9') goto yy95;
	goto yy3;
yy15:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy97;
			if (yych >= 'A') goto yy98;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy99;
				goto yy98;
			} else {
				if (yych <= 'P') goto yy100;
				if (yych <= 'T') goto yy98;
				goto yy101;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
			} else {
				if (yych == 'g') goto yy103;
				goto yy102;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy104;
				goto yy102;
			} else {
				if (yych <= 'u') goto yy105;
				if (yych <= 'z') goto yy102;
			}
		}
	}
yy16:
#line 1341 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1276 "real_world/parse_date_b.c"
yy17:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy98;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy102;
		goto yy16;
	}
yy18:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy106;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'e') goto yy107;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy19:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy108;
			if (yych <= 'K') goto yy98;
			goto yy109;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy102;
			goto yy110;
		} else {
			if (yych == 'l') goto yy111;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy98;
				goto yy112;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy113;
				goto yy98;
			} else {
				if (yych <= 'O') goto yy114;
				if (yych <= 'Q') goto yy98;
				goto yy115;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy98;
				if (yych <= '`') goto yy16;
				goto yy102;
			} else {
				if (yych <= 'e') goto yy116;
				if (yych <= 'h') goto yy102;
				goto yy117;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy118;
				goto yy102;
			} else {
				if (yych <= 'r') goto yy119;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy21:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy98;
		}
	} else {
		if (yych <= 'W') {
			if (yych <= 'I') goto yy127;
			if (yych == 'V') goto yy128;
			goto yy98;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'X') goto yy128;
				goto yy98;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy129;
			if (yych <= 'T') goto yy98;
			goto yy130;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy131;
		} else {
			if (yych == 'u') goto yy132;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy23:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy133;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy98;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy134;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy24:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy135;
		} else {
			if (yych == 'I') goto yy136;
			if (yych <= 'N') goto yy98;
			goto yy137;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy138;
			goto yy102;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy139;
				goto yy102;
			} else {
				if (yych <= 'o') goto yy140;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy25:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy141;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy142;
				if (yych <= 'N') goto yy98;
				goto yy143;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych == 'e') goto yy144;
				goto yy102;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy145;
				goto yy102;
			} else {
				if (yych <= 'o') goto yy146;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy26:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy98;
			goto yy147;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'c') goto yy148;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy27:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy98;
			goto yy149;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'r') goto yy150;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy28:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy151;
				goto yy98;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy152;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy153;
				if (yych <= 'T') goto yy98;
				goto yy137;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy154;
				if (yych <= 'd') goto yy102;
				goto yy155;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy156;
				goto yy102;
			} else {
				if (yych <= 'u') goto yy140;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy29:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '@') {
				if (yych == ')') goto yy97;
				goto yy16;
			} else {
				if (yych == 'E') goto yy142;
				goto yy98;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'H') goto yy157;
				if (yych <= 'N') goto yy98;
				goto yy158;
			} else {
				if (yych == 'U') goto yy159;
				if (yych <= 'V') goto yy98;
				goto yy160;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy98;
				if (yych <= '`') goto yy16;
				goto yy102;
			} else {
				if (yych <= 'e') goto yy145;
				if (yych == 'h') goto yy161;
				goto yy102;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') goto yy162;
				if (yych <= 't') goto yy102;
				goto yy163;
			} else {
				if (yych == 'w') goto yy164;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy30:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy98;
			goto yy165;
		} else {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy31:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'e') goto yy167;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy32:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy98;
			goto yy127;
		} else {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy33:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'e') goto yy169;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy34:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy99;
				goto yy98;
			} else {
				if (yych <= 'P') goto yy100;
				if (yych <= 'T') goto yy98;
				goto yy101;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych == 'g') goto yy99;
				goto yy98;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy100;
				goto yy98;
			} else {
				if (yych <= 'u') goto yy101;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy35:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy98;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy98;
		goto yy16;
	}
yy36:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy106;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'e') goto yy106;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy108;
			if (yych <= 'K') goto yy98;
			goto yy109;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy98;
			goto yy108;
		} else {
			if (yych == 'l') goto yy109;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy38:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy98;
				goto yy112;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy113;
				goto yy98;
			} else {
				if (yych <= 'O') goto yy114;
				if (yych <= 'Q') goto yy98;
				goto yy115;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy98;
				if (yych <= '`') goto yy16;
				goto yy98;
			} else {
				if (yych <= 'e') goto yy112;
				if (yych <= 'h') goto yy98;
				goto yy113;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy114;
				goto yy98;
			} else {
				if (yych <= 'r') goto yy115;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy129;
			if (yych <= 'T') goto yy98;
			goto yy130;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy129;
		} else {
			if (yych == 'u') goto yy130;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy40:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy133;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy98;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy133;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy135;
		} else {
			if (yych == 'I') goto yy136;
			if (yych <= 'N') goto yy98;
			goto yy137;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy135;
			goto yy98;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy136;
				goto yy98;
			} else {
				if (yych <= 'o') goto yy137;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy42:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy141;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy142;
				if (yych <= 'N') goto yy98;
				goto yy143;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych == 'e') goto yy141;
				goto yy98;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy142;
				goto yy98;
			} else {
				if (yych <= 'o') goto yy143;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy43:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy98;
			goto yy147;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'c') goto yy147;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy98;
			goto yy149;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'r') goto yy149;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy45:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy151;
				goto yy98;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy152;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy153;
				if (yych <= 'T') goto yy98;
				goto yy137;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy151;
				if (yych <= 'd') goto yy98;
				goto yy152;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy153;
				goto yy98;
			} else {
				if (yych <= 'u') goto yy137;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy46:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '@') {
				if (yych == ')') goto yy97;
				goto yy16;
			} else {
				if (yych == 'E') goto yy142;
				goto yy98;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'H') goto yy157;
				if (yych <= 'N') goto yy98;
				goto yy158;
			} else {
				if (yych == 'U') goto yy159;
				if (yych <= 'V') goto yy98;
				goto yy160;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy98;
				if (yych <= '`') goto yy16;
				goto yy98;
			} else {
				if (yych <= 'e') goto yy142;
				if (yych == 'h') goto yy157;
				goto yy98;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') goto yy158;
				if (yych <= 't') goto yy98;
				goto yy159;
			} else {
				if (yych == 'w') goto yy160;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy47:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy166;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'e') goto yy166;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy48:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'e') goto yy168;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy49:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy49;
	}
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy51;
yy50:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 13) {
		if (yyaccept <= 6) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept == 0) {
						goto yy5;
					} else {
						goto yy3;
					}
				} else {
					if (yyaccept == 2) {
						goto yy16;
					} else {
						goto yy70;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept == 4) {
						goto yy187;
					} else {
						goto yy192;
					}
				} else {
					goto yy250;
				}
			}
		} else {
			if (yyaccept <= 10) {
				if (yyaccept <= 8) {
					if (yyaccept == 7) {
						goto yy269;
					} else {
						goto yy124;
					}
				} else {
					if (yyaccept == 9) {
						goto yy298;
					} else {
						goto yy351;
					}
				}
			} else {
				if (yyaccept <= 12) {
					if (yyaccept == 11) {
						goto yy353;
					} else {
						goto yy357;
					}
				} else {
					goto yy437;
				}
			}
		}
	} else {
		if (yyaccept <= 20) {
			if (yyaccept <= 17) {
				if (yyaccept <= 15) {
					if (yyaccept == 14) {
						goto yy468;
					} else {
						goto yy575;
					}
				} else {
					if (yyaccept == 16) {
						goto yy578;
					} else {
						goto yy614;
					}
				}
			} else {
				if (yyaccept <= 19) {
					if (yyaccept == 18) {
						goto yy655;
					} else {
						goto yy766;
					}
				} else {
					goto yy499;
				}
			}
		} else {
			if (yyaccept <= 23) {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy794;
					} else {
						goto yy846;
					}
				} else {
					goto yy851;
				}
			} else {
				if (yyaccept <= 25) {
					if (yyaccept == 24) {
						goto yy890;
					} else {
						goto yy935;
					}
				} else {
					goto yy1006;
				}
			}
		}
	}
yy51:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	switch (yych) {
		case ' ': goto yy170;
		case 'D':
		case 'd': goto yy172;
		case 'F':
		case 'f': goto yy173;
		case 'H':
		case 'h': goto yy68;
		case 'M':
		case 'm': goto yy174;
		case 'S':
		case 's': goto yy175;
		case 'T':
		case 't': goto yy76;
		case 'W':
		case 'w': goto yy78;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy52:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy54;
		case ':': goto yy176;
		default: goto yy16;
	}
yy53:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3': goto yy54;
		case '4':
		case '5': goto yy177;
		case '6':
		case '7':
		case '8':
		case '9': goto yy178;
		case ':': goto yy176;
		default: goto yy16;
	}
yy54:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy177;
		case '6':
		case '7':
		case '8':
		case '9': goto yy178;
		case ':': goto yy176;
		default: goto yy16;
	}
yy55:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy56:
	switch (yych) {
		case ' ': goto yy55;
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy57;
		case 'A':
		case 'a': goto yy65;
		case 'D':
		case 'd': goto yy66;
		case 'F':
		case 'f': goto yy67;
		case 'H':
		case 'h': goto yy68;
		case 'I': goto yy69;
		case 'J':
		case 'j': goto yy71;
		case 'M':
		case 'm': goto yy72;
		case 'N':
		case 'n': goto yy73;
		case 'O':
		case 'o': goto yy74;
		case 'S':
		case 's': goto yy75;
		case 'T':
		case 't': goto yy76;
		case 'V': goto yy77;
		case 'W':
		case 'w': goto yy78;
		case 'X': goto yy79;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy57:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy58:
	if (yybm[0+yych] & 32) {
		goto yy57;
	}
	switch (yych) {
		case 'A':
		case 'a': goto yy65;
		case 'D':
		case 'd': goto yy179;
		case 'F':
		case 'f': goto yy180;
		case 'I': goto yy69;
		case 'J':
		case 'j': goto yy71;
		case 'M':
		case 'm': goto yy181;
		case 'N':
		case 'n': goto yy73;
		case 'O':
		case 'o': goto yy74;
		case 'S':
		case 's': goto yy182;
		case 'V': goto yy77;
		case 'X': goto yy79;
		default: goto yy50;
	}
yy59:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy58;
	if (yych <= '0') goto yy183;
	if (yych <= '1') goto yy184;
	if (yych <= '9') goto yy185;
	goto yy58;
yy60:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy58;
		if (yych <= '0') goto yy186;
		goto yy188;
	} else {
		if (yych <= '5') goto yy189;
		if (yych <= '9') goto yy190;
		goto yy58;
	}
yy61:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy191;
		case '3': goto yy193;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy194;
		case 'A':
		case 'a': goto yy195;
		case 'D':
		case 'd': goto yy196;
		case 'F':
		case 'f': goto yy197;
		case 'J':
		case 'j': goto yy198;
		case 'M':
		case 'm': goto yy199;
		case 'N':
		case 'n': goto yy200;
		case 'O':
		case 'o': goto yy201;
		case 'S':
		case 's': goto yy202;
		default: goto yy50;
	}
yy62:
	yych = *++YYCURSOR;
	if (yych <= ':') {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			if (yych <= '-') goto yy59;
			goto yy60;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '5') goto yy203;
			if (yych <= '9') goto yy204;
			goto yy64;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy81;
			goto yy56;
		} else {
			if (yych <= 'r') goto yy82;
			if (yych <= 's') goto yy83;
			if (yych <= 't') goto yy84;
			goto yy56;
		}
	}
yy63:
	yych = *++YYCURSOR;
	if (yych <= ':') {
		if (yych <= '.') {
			if (yych <= ',') goto yy86;
			if (yych <= '-') goto yy59;
			goto yy87;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '5') goto yy203;
			if (yych <= '9') goto yy204;
			goto yy89;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy81;
			goto yy86;
		} else {
			if (yych <= 'r') goto yy82;
			if (yych <= 's') goto yy83;
			if (yych <= 't') goto yy84;
			goto yy86;
		}
	}
yy64:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy205;
	if (yych <= '9') goto yy206;
	goto yy50;
yy65:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy207;
		if (yych <= 'T') goto yy50;
		goto yy208;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy207;
		} else {
			if (yych == 'u') goto yy208;
			goto yy50;
		}
	}
yy66:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy209;
		if (yych <= 'D') goto yy50;
		goto yy210;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy209;
		} else {
			if (yych == 'e') goto yy210;
			goto yy50;
		}
	}
yy67:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy211;
			goto yy50;
		} else {
			if (yych <= 'O') goto yy212;
			if (yych <= 'Q') goto yy50;
			goto yy213;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy211;
			goto yy50;
		} else {
			if (yych <= 'o') goto yy212;
			if (yych == 'r') goto yy213;
			goto yy50;
		}
	}
yy68:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy214;
	if (yych == 'o') goto yy214;
	goto yy50;
yy69:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych >= ' ') goto yy215;
		} else {
			if (yych <= '/') goto yy70;
			if (yych <= '9') goto yy216;
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'I') goto yy218;
			if (yych >= 'V') goto yy219;
		} else {
			if (yych == 'X') goto yy219;
		}
	}
yy70:
#line 1140 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 2666 "real_world/parse_date_b.c"
yy71:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy220;
		if (yych <= 'T') goto yy50;
		goto yy221;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy220;
		} else {
			if (yych == 'u') goto yy221;
			goto yy50;
		}
	}
yy72:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy222;
			goto yy50;
		} else {
			if (yych <= 'I') goto yy223;
			if (yych <= 'N') goto yy50;
			goto yy224;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy222;
			goto yy50;
		} else {
			if (yych <= 'i') goto yy223;
			if (yych == 'o') goto yy224;
			goto yy50;
		}
	}
yy73:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy225;
	if (yych == 'o') goto yy225;
	goto yy50;
yy74:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy226;
	if (yych == 'c') goto yy226;
	goto yy50;
yy75:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy228;
			if (yych <= 'T') goto yy50;
			goto yy229;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy228;
			if (yych == 'u') goto yy229;
			goto yy50;
		}
	}
yy76:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy230;
		if (yych <= 'T') goto yy50;
		goto yy231;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy230;
		} else {
			if (yych == 'u') goto yy231;
			goto yy50;
		}
	}
yy77:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		goto yy70;
	} else {
		if (yych <= '9') goto yy216;
		if (yych == 'I') goto yy79;
		goto yy70;
	}
yy78:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy232;
	if (yych == 'e') goto yy232;
	goto yy50;
yy79:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		goto yy70;
	} else {
		if (yych <= '9') goto yy216;
		if (yych == 'I') goto yy218;
		goto yy70;
	}
yy80:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy233;
	if (yych == 'e') goto yy233;
	goto yy50;
yy81:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy225;
		goto yy50;
	} else {
		if (yych <= 'd') goto yy234;
		if (yych == 'o') goto yy225;
		goto yy50;
	}
yy82:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy234;
	goto yy50;
yy83:
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy228;
			if (yych == 'U') goto yy229;
			goto yy50;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy227;
			if (yych <= 'd') goto yy50;
			goto yy228;
		} else {
			if (yych <= 's') goto yy50;
			if (yych <= 't') goto yy234;
			if (yych <= 'u') goto yy229;
			goto yy50;
		}
	}
yy84:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy230;
		if (yych <= 'T') goto yy50;
		goto yy231;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy235;
		} else {
			if (yych == 'u') goto yy231;
			goto yy50;
		}
	}
yy85:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy86:
	switch (yych) {
		case ' ': goto yy85;
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy57;
		case 'A':
		case 'a': goto yy90;
		case 'D':
		case 'd': goto yy66;
		case 'F':
		case 'f': goto yy67;
		case 'H':
		case 'h': goto yy68;
		case 'I': goto yy69;
		case 'J':
		case 'j': goto yy71;
		case 'M':
		case 'm': goto yy72;
		case 'N':
		case 'n': goto yy73;
		case 'O':
		case 'o': goto yy74;
		case 'P':
		case 'p': goto yy91;
		case 'S':
		case 's': goto yy75;
		case 'T':
		case 't': goto yy76;
		case 'V': goto yy77;
		case 'W':
		case 'w': goto yy78;
		case 'X': goto yy79;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy87:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy58;
		if (yych <= '0') goto yy236;
		goto yy237;
	} else {
		if (yych <= '5') goto yy238;
		if (yych <= '9') goto yy239;
		goto yy58;
	}
yy88:
	yych = *++YYCURSOR;
	if (yych <= ':') {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			if (yych <= '-') goto yy59;
			goto yy60;
		} else {
			if (yych <= '/') goto yy240;
			if (yych <= '5') goto yy203;
			if (yych <= '9') goto yy204;
			goto yy64;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy81;
			goto yy56;
		} else {
			if (yych <= 'r') goto yy82;
			if (yych <= 's') goto yy83;
			if (yych <= 't') goto yy84;
			goto yy56;
		}
	}
yy89:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy241;
	if (yych <= '9') goto yy242;
	goto yy50;
yy90:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy243;
			goto yy50;
		} else {
			if (yych <= 'M') goto yy244;
			if (yych == 'P') goto yy207;
			goto yy50;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy208;
			if (yych == 'm') goto yy244;
			goto yy50;
		} else {
			if (yych <= 'p') goto yy207;
			if (yych == 'u') goto yy208;
			goto yy50;
		}
	}
yy91:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy243;
		goto yy50;
	} else {
		if (yych <= 'M') goto yy244;
		if (yych == 'm') goto yy244;
		goto yy50;
	}
yy92:
	yych = *++YYCURSOR;
	if (yych <= 'm') {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			if (yych <= '-') goto yy59;
			goto yy246;
		} else {
			if (yych <= '/') goto yy240;
			if (yych <= '9') goto yy204;
			goto yy56;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy81;
			if (yych <= 'q') goto yy56;
			goto yy82;
		} else {
			if (yych <= 's') goto yy83;
			if (yych <= 't') goto yy84;
			goto yy56;
		}
	}
yy93:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy247;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy204;
	goto yy171;
yy94:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych >= ':') goto yy50;
yy95:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy96;
	if (yych <= '9') goto yy95;
yy96:
#line 906 "real_world/parse_date_b.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3023 "real_world/parse_date_b.c"
yy97:
	++YYCURSOR;
	goto yy16;
yy98:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy248;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy248;
		goto yy16;
	}
yy99:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy248;
			goto yy249;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'o') goto yy249;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy100:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy248;
			goto yy251;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'r') goto yy251;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy101:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy248;
			goto yy252;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'g') goto yy252;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy102:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == '/') goto yy253;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '^') goto yy16;
			goto yy253;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy103:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy248;
			goto yy249;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'o') goto yy255;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy104:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy248;
			goto yy251;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'r') goto yy256;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy105:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy248;
			goto yy252;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'g') goto yy257;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy106:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy248;
			goto yy258;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'c') goto yy258;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy107:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy248;
			goto yy258;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'c') goto yy259;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy108:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy248;
			goto yy260;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'g') goto yy260;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy109:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy261;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'e') goto yy261;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy110:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy248;
			goto yy260;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'g') goto yy262;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy111:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy261;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy263;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy112:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy248;
			goto yy264;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'b') goto yy264;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy113:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'F') goto yy265;
			if (yych <= 'Q') goto yy248;
			goto yy266;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'e') goto yy248;
			goto yy265;
		} else {
			if (yych == 'r') goto yy266;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy114:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy248;
			goto yy267;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'u') goto yy267;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy115:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy248;
			goto yy268;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'i') goto yy268;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy116:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy248;
			goto yy264;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'b') goto yy270;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy117:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy253;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy16;
				goto yy248;
			} else {
				if (yych <= 'F') goto yy265;
				if (yych <= 'Q') goto yy248;
				goto yy266;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych <= '_') goto yy253;
				if (yych <= '`') goto yy16;
				goto yy254;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy271;
				goto yy254;
			} else {
				if (yych <= 'r') goto yy272;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy118:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy248;
			goto yy267;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'u') goto yy273;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy119:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy248;
			goto yy268;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'i') goto yy274;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy120:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy121:
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy50;
		if (yych <= '.') goto yy120;
		goto yy50;
	} else {
		if (yych <= '2') goto yy123;
		if (yych <= '3') goto yy125;
		if (yych <= '9') goto yy126;
		goto yy50;
	}
yy122:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) goto yy16;
	if (yych == '/') goto yy16;
	if (yych <= '9') goto yy121;
	goto yy16;
yy123:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy277;
	goto yy276;
yy124:
#line 1127 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3576 "real_world/parse_date_b.c"
yy125:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '1') goto yy277;
	if (yych <= '2') goto yy278;
	if (yych <= '9') goto yy279;
	goto yy276;
yy126:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '1') goto yy280;
	if (yych <= '2') goto yy278;
	if (yych <= '9') goto yy279;
	goto yy276;
yy127:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy248;
			goto yy281;
		} else {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy128:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych <= ')') goto yy122;
			if (yych <= '.') goto yy121;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy248;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy129:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy248;
			goto yy282;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'n') goto yy282;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy130:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'L') goto yy283;
			if (yych <= 'M') goto yy248;
			goto yy284;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'k') goto yy248;
			goto yy283;
		} else {
			if (yych == 'n') goto yy284;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy131:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy248;
			goto yy282;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy285;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy132:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy253;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy16;
				goto yy248;
			} else {
				if (yych <= 'L') goto yy283;
				if (yych <= 'M') goto yy248;
				goto yy284;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych <= '_') goto yy253;
				if (yych <= '`') goto yy16;
				goto yy254;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy286;
				goto yy254;
			} else {
				if (yych <= 'n') goto yy287;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy133:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy248;
			goto yy288;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 's') goto yy288;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy134:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy248;
			goto yy288;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 's') goto yy289;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy135:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'R') goto yy290;
			if (yych <= 'X') goto yy248;
			goto yy291;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'q') goto yy248;
			goto yy290;
		} else {
			if (yych == 'y') goto yy291;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy136:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy248;
			goto yy292;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'd') goto yy292;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy137:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy248;
			goto yy268;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'n') goto yy268;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy138:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy253;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy16;
				goto yy248;
			} else {
				if (yych <= 'R') goto yy290;
				if (yych <= 'X') goto yy248;
				goto yy291;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych <= '_') goto yy253;
				if (yych <= '`') goto yy16;
				goto yy254;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy293;
				goto yy254;
			} else {
				if (yych <= 'y') goto yy294;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy139:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy248;
			goto yy292;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'd') goto yy295;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy140:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy248;
			goto yy268;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy274;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy141:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy248;
			goto yy288;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'x') goto yy288;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy142:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy248;
			goto yy265;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'n') goto yy265;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy143:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'O') goto yy296;
			if (yych <= 'U') goto yy248;
			if (yych <= 'V') goto yy258;
			goto yy297;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'n') goto yy248;
			goto yy296;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy248;
				goto yy258;
			} else {
				if (yych <= 'w') goto yy297;
				if (yych <= 'z') goto yy248;
				goto yy16;
			}
		}
	}
yy144:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy248;
			goto yy288;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'x') goto yy289;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy145:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy248;
			goto yy265;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy271;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy146:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych == '/') goto yy253;
				goto yy16;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy248;
				goto yy296;
			} else {
				if (yych <= 'U') goto yy248;
				if (yych <= 'V') goto yy258;
				goto yy297;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych <= '_') goto yy253;
				if (yych <= '`') goto yy16;
				goto yy254;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy299;
				if (yych <= 'u') goto yy254;
				goto yy259;
			} else {
				if (yych <= 'w') goto yy300;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy147:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy248;
			goto yy301;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 't') goto yy301;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy148:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy248;
			goto yy301;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy302;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy149:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy303;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'e') goto yy303;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy150:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy303;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy304;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy151:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy248;
			goto yy305;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 't') goto yy305;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy152:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy306;
				goto yy248;
			} else {
				if (yych <= 'P') goto yy307;
				if (yych <= 'U') goto yy248;
				goto yy308;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych == 'c') goto yy306;
				goto yy248;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy307;
				goto yy248;
			} else {
				if (yych <= 'v') goto yy308;
				if (yych <= 'z') goto yy248;
				goto yy16;
			}
		}
	}
yy153:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy248;
			goto yy265;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'x') goto yy265;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy154:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy248;
			goto yy305;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy309;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy155:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych == '/') goto yy253;
				goto yy16;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy306;
				goto yy248;
			} else {
				if (yych <= 'P') goto yy307;
				if (yych <= 'U') goto yy248;
				goto yy308;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy248;
				if (yych <= '^') goto yy16;
				goto yy253;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'b') goto yy254;
				goto yy310;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy311;
				goto yy254;
			} else {
				if (yych <= 'v') goto yy312;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy156:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy248;
			goto yy265;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'x') goto yy271;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy157:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy313;
			if (yych <= 'T') goto yy248;
			goto yy314;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy248;
			goto yy313;
		} else {
			if (yych == 'u') goto yy314;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy158:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'D') goto yy315;
			if (yych <= 'L') goto yy248;
			goto yy316;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'c') goto yy248;
			goto yy315;
		} else {
			if (yych == 'm') goto yy316;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy159:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy317;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'e') goto yy317;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy160:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy318;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'e') goto yy318;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy161:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy253;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy248;
			} else {
				if (yych <= 'I') goto yy313;
				if (yych <= 'T') goto yy248;
				goto yy314;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych <= '_') goto yy253;
				if (yych <= '`') goto yy16;
				goto yy254;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy319;
				goto yy254;
			} else {
				if (yych <= 'u') goto yy320;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy162:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy253;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy16;
				goto yy248;
			} else {
				if (yych <= 'D') goto yy315;
				if (yych <= 'L') goto yy248;
				goto yy316;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy248;
				goto yy16;
			} else {
				if (yych <= '_') goto yy253;
				if (yych <= '`') goto yy16;
				goto yy254;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy321;
				goto yy254;
			} else {
				if (yych <= 'm') goto yy322;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy163:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy317;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy323;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy164:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy248;
			goto yy318;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy324;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy165:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy248;
			goto yy325;
		} else {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy166:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy248;
			goto yy326;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 'd') goto yy326;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy167:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy248;
			goto yy326;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'd') goto yy327;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy168:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy248;
			goto yy328;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy248;
			if (yych <= '`') goto yy16;
			goto yy248;
		} else {
			if (yych <= 's') goto yy328;
			if (yych <= 'z') goto yy248;
			goto yy16;
		}
	}
yy169:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy248;
			goto yy328;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy248;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 's') goto yy329;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy170:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy171:
	switch (yych) {
		case ' ': goto yy170;
		case 'D':
		case 'd': goto yy172;
		case 'F':
		case 'f': goto yy173;
		case 'H':
		case 'h': goto yy68;
		case 'M':
		case 'm': goto yy174;
		case 'S':
		case 's': goto yy175;
		case 'T':
		case 't': goto yy76;
		case 'W':
		case 'w': goto yy78;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy172:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy209;
	if (yych == 'a') goto yy209;
	goto yy50;
yy173:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy212;
		if (yych <= 'Q') goto yy50;
		goto yy213;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy50;
			goto yy212;
		} else {
			if (yych == 'r') goto yy213;
			goto yy50;
		}
	}
yy174:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy223;
		if (yych <= 'N') goto yy50;
		goto yy224;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy50;
			goto yy223;
		} else {
			if (yych == 'o') goto yy224;
			goto yy50;
		}
	}
yy175:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy330;
			if (yych <= 'T') goto yy50;
			goto yy229;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy330;
			if (yych == 'u') goto yy229;
			goto yy50;
		}
	}
yy176:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy331;
	if (yych <= '9') goto yy97;
	goto yy16;
yy177:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy178;
		default: goto yy16;
	}
yy178:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= 'C') {
				if (yych == ' ') goto yy171;
				goto yy16;
			} else {
				if (yych == 'E') goto yy16;
				if (yych <= 'F') goto yy171;
				goto yy16;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') goto yy171;
				if (yych == 'M') goto yy171;
				goto yy16;
			} else {
				if (yych <= 'T') goto yy171;
				if (yych == 'W') goto yy171;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy171;
				if (yych == 'd') goto yy171;
				goto yy16;
			} else {
				if (yych == 'g') goto yy16;
				if (yych <= 'h') goto yy171;
				goto yy16;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') goto yy171;
				if (yych <= 'r') goto yy16;
				if (yych <= 't') goto yy171;
				goto yy16;
			} else {
				if (yych == 'x') goto yy16;
				if (yych <= 'y') goto yy171;
				goto yy16;
			}
		}
	}
yy179:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy210;
	if (yych == 'e') goto yy210;
	goto yy50;
yy180:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy211;
	if (yych == 'e') goto yy211;
	goto yy50;
yy181:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy222;
	if (yych == 'a') goto yy222;
	goto yy50;
yy182:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy332;
	if (yych == 'e') goto yy332;
	goto yy50;
yy183:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy333;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy185;
	goto yy50;
yy184:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy333;
	if (yych <= '/') goto yy50;
	if (yych >= '3') goto yy50;
yy185:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy333;
	goto yy50;
yy186:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
	} else {
		if (yych <= '9') goto yy190;
		if (yych <= ':') goto yy335;
	}
yy187:
#line 947 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 4948 "real_world/parse_date_b.c"
yy188:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy187;
	} else {
		if (yych <= '2') goto yy190;
		if (yych <= '9') goto yy206;
		if (yych <= ':') goto yy335;
		goto yy187;
	}
yy189:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy334;
		goto yy187;
	} else {
		if (yych <= '9') goto yy206;
		if (yych <= ':') goto yy335;
		goto yy187;
	}
yy190:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy334;
	if (yych == ':') goto yy335;
	goto yy187;
yy191:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy336;
		} else {
			if (yych <= '9') goto yy194;
			if (yych >= 'n') goto yy337;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy337;
		} else {
			if (yych <= 's') goto yy338;
			if (yych <= 't') goto yy339;
		}
	}
yy192:
#line 1034 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 5011 "real_world/parse_date_b.c"
yy193:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy192;
			goto yy336;
		} else {
			if (yych <= '1') goto yy194;
			if (yych <= 'm') goto yy192;
			goto yy337;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy192;
			goto yy337;
		} else {
			if (yych <= 's') goto yy338;
			if (yych <= 't') goto yy339;
			goto yy192;
		}
	}
yy194:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy336;
		if (yych <= 'm') goto yy192;
		goto yy337;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy192;
			goto yy337;
		} else {
			if (yych <= 's') goto yy338;
			if (yych <= 't') goto yy339;
			goto yy192;
		}
	}
yy195:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy340;
		if (yych <= 'T') goto yy50;
		goto yy341;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy340;
		} else {
			if (yych == 'u') goto yy341;
			goto yy50;
		}
	}
yy196:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy342;
	if (yych == 'e') goto yy342;
	goto yy50;
yy197:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy343;
	if (yych == 'e') goto yy343;
	goto yy50;
yy198:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy344;
		if (yych <= 'T') goto yy50;
		goto yy345;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy344;
		} else {
			if (yych == 'u') goto yy345;
			goto yy50;
		}
	}
yy199:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy346;
	if (yych == 'a') goto yy346;
	goto yy50;
yy200:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy347;
	if (yych == 'o') goto yy347;
	goto yy50;
yy201:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy348;
	if (yych == 'c') goto yy348;
	goto yy50;
yy202:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy349;
	if (yych == 'e') goto yy349;
	goto yy50;
yy203:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy247;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy350;
	goto yy171;
yy204:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy247;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy352;
	goto yy171;
yy205:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy335;
		goto yy187;
	} else {
		if (yych <= '9') goto yy206;
		if (yych <= ':') goto yy335;
		goto yy187;
	}
yy206:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy335;
	if (yych == ':') goto yy335;
	goto yy187;
yy207:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy354;
	if (yych == 'r') goto yy354;
	goto yy50;
yy208:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy355;
	if (yych == 'g') goto yy355;
	goto yy50;
yy209:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy356;
	if (yych == 'y') goto yy356;
	goto yy50;
yy210:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy358;
	if (yych == 'c') goto yy358;
	goto yy50;
yy211:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy359;
	if (yych == 'b') goto yy359;
	goto yy50;
yy212:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy360;
	if (yych == 'r') goto yy360;
	goto yy50;
yy213:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy361;
	if (yych == 'i') goto yy361;
	goto yy50;
yy214:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy362;
	if (yych == 'u') goto yy362;
	goto yy50;
yy215:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= 0x1F) goto yy50;
	if (yych <= '.') goto yy215;
	if (yych <= '/') goto yy50;
	if (yych >= ':') goto yy50;
yy216:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy217;
	if (yych <= '9') goto yy363;
yy217:
#line 1074 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 5206 "real_world/parse_date_b.c"
yy218:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		goto yy70;
	} else {
		if (yych <= '9') goto yy216;
		if (yych != 'I') goto yy70;
	}
yy219:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) goto yy70;
	if (yych <= '.') goto yy215;
	if (yych <= '/') goto yy70;
	if (yych <= '9') goto yy216;
	goto yy70;
yy220:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy364;
	if (yych == 'n') goto yy364;
	goto yy50;
yy221:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy365;
		if (yych <= 'M') goto yy50;
		goto yy366;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy365;
		} else {
			if (yych == 'n') goto yy366;
			goto yy50;
		}
	}
yy222:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy367;
		if (yych <= 'X') goto yy50;
		goto yy219;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy367;
		} else {
			if (yych == 'y') goto yy219;
			goto yy50;
		}
	}
yy223:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy368;
	if (yych == 'n') goto yy368;
	goto yy50;
yy224:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy369;
	if (yych == 'n') goto yy369;
	goto yy50;
yy225:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy358;
	if (yych == 'v') goto yy358;
	goto yy50;
yy226:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy370;
	if (yych == 't') goto yy370;
	goto yy50;
yy227:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy371;
	if (yych == 't') goto yy371;
	goto yy50;
yy228:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy372;
		if (yych <= 'O') goto yy50;
		goto yy373;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy50;
			goto yy372;
		} else {
			if (yych == 'p') goto yy373;
			goto yy50;
		}
	}
yy229:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy361;
	if (yych == 'n') goto yy361;
	goto yy50;
yy230:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy374;
	if (yych == 'u') goto yy374;
	goto yy50;
yy231:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy375;
	if (yych == 'e') goto yy375;
	goto yy50;
yy232:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy50;
		if (yych <= 'D') goto yy376;
		goto yy377;
	} else {
		if (yych <= 'c') goto yy50;
		if (yych <= 'd') goto yy376;
		if (yych <= 'e') goto yy377;
		goto yy50;
	}
yy233:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy362;
	if (yych == 'a') goto yy362;
	goto yy50;
yy234:
	yych = *++YYCURSOR;
	if (yych <= '-') goto yy58;
	if (yych <= '.') goto yy246;
	if (yych <= '/') goto yy240;
	goto yy58;
yy235:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= '-') goto yy58;
		if (yych <= '.') goto yy246;
		if (yych <= '/') goto yy240;
		goto yy58;
	} else {
		if (yych <= 'U') goto yy374;
		if (yych == 'u') goto yy374;
		goto yy58;
	}
yy236:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy378;
		goto yy187;
	} else {
		if (yych <= '9') goto yy379;
		if (yych <= ':') goto yy380;
		goto yy187;
	}
yy237:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy378;
		goto yy187;
	} else {
		if (yych <= '2') goto yy379;
		if (yych <= '9') goto yy381;
		if (yych <= ':') goto yy380;
		goto yy187;
	}
yy238:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy378;
		goto yy187;
	} else {
		if (yych <= '9') goto yy381;
		if (yych <= ':') goto yy380;
		goto yy187;
	}
yy239:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy378;
	if (yych == ':') goto yy380;
	goto yy187;
yy240:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy195;
		case 'D':
		case 'd': goto yy196;
		case 'F':
		case 'f': goto yy197;
		case 'J':
		case 'j': goto yy198;
		case 'M':
		case 'm': goto yy199;
		case 'N':
		case 'n': goto yy200;
		case 'O':
		case 'o': goto yy201;
		case 'S':
		case 's': goto yy202;
		default: goto yy50;
	}
yy241:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy380;
		goto yy187;
	} else {
		if (yych <= '9') goto yy381;
		if (yych <= ':') goto yy380;
		goto yy187;
	}
yy242:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy380;
	if (yych == ':') goto yy380;
	goto yy187;
yy243:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy244;
	if (yych != 'm') goto yy50;
yy244:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy382;
yy245:
#line 930 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 5453 "real_world/parse_date_b.c"
yy246:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy58;
	if (yych <= '0') goto yy383;
	if (yych <= '1') goto yy384;
	if (yych <= '9') goto yy385;
	goto yy58;
yy247:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy183;
		case '1': goto yy184;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy185;
		case 'A':
		case 'a': goto yy386;
		case 'D':
		case 'd': goto yy387;
		case 'F':
		case 'f': goto yy388;
		case 'J':
		case 'j': goto yy389;
		case 'M':
		case 'm': goto yy390;
		case 'N':
		case 'n': goto yy391;
		case 'O':
		case 'o': goto yy392;
		case 'S':
		case 's': goto yy393;
		default: goto yy50;
	}
yy248:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy394;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy394;
		goto yy16;
	}
yy249:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
	} else {
		if (yych <= 'Z') goto yy394;
		if (yych <= '`') goto yy250;
		if (yych <= 'z') goto yy394;
	}
yy250:
#line 1293 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 5527 "real_world/parse_date_b.c"
yy251:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'I') goto yy396;
			goto yy394;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'i') goto yy396;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy252:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'U') goto yy397;
			goto yy394;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'u') goto yy397;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy253:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy50;
	if (yych <= 'Z') goto yy398;
	goto yy50;
yy254:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == '/') goto yy253;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '^') goto yy16;
			goto yy253;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy255:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy250;
			goto yy97;
		} else {
			if (yych == '/') goto yy253;
			goto yy250;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '^') goto yy250;
			goto yy253;
		} else {
			if (yych <= '`') goto yy250;
			if (yych <= 'z') goto yy399;
			goto yy250;
		}
	}
yy256:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') {
				if (yych <= 'H') goto yy394;
				goto yy396;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'i') goto yy400;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy257:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') {
				if (yych <= 'T') goto yy394;
				goto yy397;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'u') goto yy401;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy258:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'E') goto yy402;
			goto yy394;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'e') goto yy402;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy259:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy394;
				goto yy402;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'e') goto yy403;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy260:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy394;
			goto yy404;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'h') goto yy404;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy261:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy394;
			goto yy405;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'v') goto yy405;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy262:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy394;
			goto yy404;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'h') goto yy406;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy263:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy394;
			goto yy405;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'v') goto yy407;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy264:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'R') goto yy408;
			goto yy394;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'r') goto yy408;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy265:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy394;
			goto yy409;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 't') goto yy409;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy266:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy394;
			goto yy404;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 's') goto yy404;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy267:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy394;
			goto yy410;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'r') goto yy410;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy268:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy97;
		} else {
			if (yych <= '@') goto yy269;
			if (yych <= 'C') goto yy394;
			goto yy411;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy394;
			if (yych >= 'a') goto yy394;
		} else {
			if (yych <= 'd') goto yy411;
			if (yych <= 'z') goto yy394;
		}
	}
yy269:
#line 1308 "real_world/parse_date_b.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 6005 "real_world/parse_date_b.c"
yy270:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') {
				if (yych <= 'Q') goto yy394;
				goto yy408;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'r') goto yy412;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy271:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy394;
			goto yy409;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy413;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy272:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy394;
			goto yy404;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 's') goto yy406;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy273:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy394;
			goto yy410;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'r') goto yy414;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy274:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy269;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy269;
			if (yych <= 'C') goto yy394;
			goto yy411;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy269;
		} else {
			if (yych == 'd') goto yy415;
			if (yych <= 'z') goto yy399;
			goto yy269;
		}
	}
yy275:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
yy276:
	if (yybm[0+yych] & 64) {
		goto yy275;
	}
	if (yych <= '/') goto yy124;
	if (yych <= '1') goto yy416;
	if (yych <= '2') goto yy417;
	if (yych <= '9') goto yy418;
	goto yy124;
yy277:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych == '.') goto yy419;
		if (yych <= '/') goto yy276;
		goto yy420;
	} else {
		if (yych <= '2') goto yy421;
		if (yych <= '9') goto yy422;
		if (yych <= ':') goto yy423;
		goto yy276;
	}
yy278:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '3') goto yy424;
		if (yych <= '9') goto yy425;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy279:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy425;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy280:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy424;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy281:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych <= ')') goto yy122;
			if (yych <= '.') goto yy121;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy394;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy282:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'U') goto yy426;
			goto yy394;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'u') goto yy426;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy283:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'Y') goto yy427;
			goto yy394;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'y') goto yy427;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy284:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'E') goto yy427;
			goto yy394;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'e') goto yy427;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy285:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') {
				if (yych <= 'T') goto yy394;
				goto yy426;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'u') goto yy428;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy286:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') {
				if (yych <= 'X') goto yy394;
				goto yy427;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'y') goto yy429;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy287:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy394;
				goto yy427;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'e') goto yy429;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy288:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy394;
			goto yy430;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 't') goto yy430;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy289:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy394;
			goto yy430;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy431;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy290:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'C') goto yy432;
			goto yy394;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'c') goto yy432;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy291:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '-') goto yy395;
			goto yy121;
		}
	} else {
		if (yych <= '@') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy292:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy394;
			goto yy433;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'n') goto yy433;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy293:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy394;
				goto yy432;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'c') goto yy434;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy294:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '-') goto yy395;
			if (yych <= '.') goto yy121;
			goto yy253;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy394;
			goto yy16;
		} else {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy295:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy394;
			goto yy433;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy435;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy296:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy394;
			goto yy436;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'n') goto yy436;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy297:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
	} else {
		if (yych <= 'Z') goto yy394;
		if (yych <= '`') goto yy298;
		if (yych <= 'z') goto yy394;
	}
yy298:
#line 863 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 6678 "real_world/parse_date_b.c"
yy299:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy394;
			goto yy436;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy438;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy300:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy298;
			goto yy97;
		} else {
			if (yych == '/') goto yy253;
			goto yy298;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '^') goto yy298;
			goto yy253;
		} else {
			if (yych <= '`') goto yy298;
			if (yych <= 'z') goto yy399;
			goto yy298;
		}
	}
yy301:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'O') goto yy439;
			goto yy394;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 'o') goto yy439;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy302:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy394;
				goto yy439;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 'o') goto yy440;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy303:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy394;
			goto yy441;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'v') goto yy441;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy304:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy394;
			goto yy441;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'v') goto yy442;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy305:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy269;
			goto yy97;
		} else {
			if (yych <= '@') goto yy269;
			if (yych <= 'T') goto yy394;
			goto yy443;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy269;
			goto yy394;
		} else {
			if (yych <= 'u') goto yy443;
			if (yych <= 'z') goto yy394;
			goto yy269;
		}
	}
yy306:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy394;
			goto yy444;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'o') goto yy444;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy307:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			if (yych == 'T') goto yy445;
			goto yy394;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy394;
			} else {
				if (yych <= 't') goto yy445;
				if (yych <= 'z') goto yy394;
				goto yy16;
			}
		}
	}
yy308:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy394;
			goto yy446;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'e') goto yy446;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy309:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy269;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy269;
			if (yych <= 'T') goto yy394;
			goto yy443;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy269;
		} else {
			if (yych == 'u') goto yy447;
			if (yych <= 'z') goto yy399;
			goto yy269;
		}
	}
yy310:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy394;
			goto yy444;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'o') goto yy448;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy311:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy395;
				goto yy121;
			} else {
				if (yych <= '/') goto yy253;
				if (yych <= '9') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') {
				if (yych <= 'S') goto yy394;
				goto yy445;
			} else {
				if (yych <= 'Z') goto yy394;
				if (yych <= '^') goto yy16;
				goto yy253;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy399;
			} else {
				if (yych <= 't') goto yy449;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy312:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy394;
			goto yy446;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy450;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy313:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'Q') goto yy394;
			if (yych <= 'R') goto yy451;
			goto yy430;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'r') goto yy451;
			if (yych <= 's') goto yy430;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy314:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy269;
			goto yy97;
		} else {
			if (yych <= '@') goto yy269;
			if (yych <= 'Q') goto yy394;
			goto yy452;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy269;
			goto yy394;
		} else {
			if (yych <= 'r') goto yy452;
			if (yych <= 'z') goto yy394;
			goto yy269;
		}
	}
yy315:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy453;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy453;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy316:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy394;
			goto yy454;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'o') goto yy454;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy317:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy269;
			goto yy97;
		} else {
			if (yych <= '@') goto yy269;
			if (yych <= 'R') goto yy394;
			goto yy455;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy269;
			goto yy394;
		} else {
			if (yych <= 's') goto yy455;
			if (yych <= 'z') goto yy394;
			goto yy269;
		}
	}
yy318:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy394;
			goto yy456;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 'l') goto yy456;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy319:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy253;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy394;
			if (yych <= 'R') goto yy451;
			goto yy430;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy399;
				goto yy457;
			} else {
				if (yych <= 's') goto yy431;
				if (yych <= 'z') goto yy399;
				goto yy16;
			}
		}
	}
yy320:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy269;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy269;
			if (yych <= 'Q') goto yy394;
			goto yy452;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy269;
		} else {
			if (yych == 'r') goto yy458;
			if (yych <= 'z') goto yy399;
			goto yy269;
		}
	}
yy321:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '^') goto yy16;
			goto yy253;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy459;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy322:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy394;
			goto yy454;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'o') goto yy460;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy323:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy269;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy269;
			if (yych <= 'R') goto yy394;
			goto yy455;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy269;
		} else {
			if (yych == 's') goto yy461;
			if (yych <= 'z') goto yy399;
			goto yy269;
		}
	}
yy324:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy394;
			goto yy456;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'l') goto yy462;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy325:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '/') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'I') {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy394;
			goto yy427;
		} else {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy326:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy269;
			goto yy97;
		} else {
			if (yych <= '@') goto yy269;
			if (yych <= 'M') goto yy394;
			goto yy463;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy269;
			goto yy394;
		} else {
			if (yych <= 'n') goto yy463;
			if (yych <= 'z') goto yy394;
			goto yy269;
		}
	}
yy327:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy269;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy269;
			if (yych <= 'M') goto yy394;
			goto yy463;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy269;
		} else {
			if (yych == 'n') goto yy464;
			if (yych <= 'z') goto yy399;
			goto yy269;
		}
	}
yy328:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy394;
			goto yy465;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy394;
			if (yych <= '`') goto yy16;
			goto yy394;
		} else {
			if (yych <= 't') goto yy465;
			if (yych <= 'z') goto yy394;
			goto yy16;
		}
	}
yy329:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy394;
			goto yy465;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy394;
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy466;
			if (yych <= 'z') goto yy399;
			goto yy16;
		}
	}
yy330:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy372;
	if (yych == 'c') goto yy372;
	goto yy50;
yy331:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy97;
	goto yy16;
yy332:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy373;
	if (yych == 'p') goto yy373;
	goto yy50;
yy333:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy467;
	if (yych <= '3') goto yy469;
	if (yych <= '9') goto yy470;
	goto yy50;
yy334:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy471;
	if (yych <= '6') goto yy472;
	if (yych <= '9') goto yy473;
	goto yy50;
yy335:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy474;
	if (yych <= '6') goto yy475;
	if (yych <= '9') goto yy476;
	goto yy50;
yy336:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy477;
	goto yy50;
yy337:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy478;
	goto yy50;
yy338:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy478;
	goto yy50;
yy339:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy478;
	goto yy50;
yy340:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy479;
	if (yych == 'r') goto yy479;
	goto yy50;
yy341:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy479;
	if (yych == 'g') goto yy479;
	goto yy50;
yy342:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy479;
	if (yych == 'c') goto yy479;
	goto yy50;
yy343:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy479;
	if (yych == 'b') goto yy479;
	goto yy50;
yy344:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy479;
	if (yych == 'n') goto yy479;
	goto yy50;
yy345:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy479;
		if (yych <= 'M') goto yy50;
		goto yy479;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy479;
		} else {
			if (yych == 'n') goto yy479;
			goto yy50;
		}
	}
yy346:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy479;
		if (yych <= 'X') goto yy50;
		goto yy479;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy479;
		} else {
			if (yych == 'y') goto yy479;
			goto yy50;
		}
	}
yy347:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy479;
	if (yych == 'v') goto yy479;
	goto yy50;
yy348:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy479;
	if (yych == 't') goto yy479;
	goto yy50;
yy349:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy480;
	if (yych == 'p') goto yy480;
	goto yy50;
yy350:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy482;
		case '-': goto yy485;
		case '.': goto yy486;
		case '/': goto yy487;
		case '0': goto yy488;
		case '1': goto yy489;
		case '2': goto yy490;
		case '3': goto yy491;
		case '4':
		case '5': goto yy492;
		case '6': goto yy493;
		case '7':
		case '8':
		case '9': goto yy51;
		case ':': goto yy494;
		case 'W': goto yy506;
		default: goto yy351;
	}
yy351:
#line 971 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 7643 "real_world/parse_date_b.c"
yy352:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy482;
		case '-': goto yy485;
		case '.': goto yy486;
		case '/': goto yy487;
		case '0': goto yy508;
		case '1': goto yy509;
		case '2': goto yy510;
		case '3': goto yy511;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		case ':': goto yy494;
		case 'W': goto yy506;
		default: goto yy353;
	}
yy353:
#line 1284 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 7713 "real_world/parse_date_b.c"
yy354:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy70;
			goto yy512;
		} else {
			if (yych == 'i') goto yy512;
			goto yy70;
		}
	}
yy355:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy70;
			goto yy513;
		} else {
			if (yych == 'u') goto yy513;
			goto yy70;
		}
	}
yy356:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy514;
	if (yych == 's') goto yy514;
yy357:
#line 1380 "real_world/parse_date_b.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7768 "real_world/parse_date_b.c"
yy358:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy70;
			goto yy515;
		} else {
			if (yych == 'e') goto yy515;
			goto yy70;
		}
	}
yy359:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy70;
			goto yy516;
		} else {
			if (yych == 'r') goto yy516;
			goto yy70;
		}
	}
yy360:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy517;
	if (yych == 't') goto yy517;
	goto yy50;
yy361:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy518;
	if (yych == 'd') goto yy518;
	goto yy357;
yy362:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy356;
	if (yych == 'r') goto yy356;
	goto yy50;
yy363:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy217;
	if (yych <= '9') goto yy519;
	goto yy217;
yy364:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy70;
			goto yy520;
		} else {
			if (yych == 'u') goto yy520;
			goto yy70;
		}
	}
yy365:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'Y') {
			if (yych <= 'X') goto yy70;
			goto yy219;
		} else {
			if (yych == 'y') goto yy219;
			goto yy70;
		}
	}
yy366:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy70;
			goto yy219;
		} else {
			if (yych == 'e') goto yy219;
			goto yy70;
		}
	}
yy367:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'C') {
			if (yych <= 'B') goto yy70;
			goto yy521;
		} else {
			if (yych == 'c') goto yy521;
			goto yy70;
		}
	}
yy368:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy514;
		if (yych <= 'T') goto yy357;
		goto yy522;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy357;
			goto yy514;
		} else {
			if (yych == 'u') goto yy522;
			goto yy357;
		}
	}
yy369:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy518;
		if (yych <= 'S') goto yy357;
		goto yy523;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy357;
			goto yy518;
		} else {
			if (yych == 't') goto yy523;
			goto yy357;
		}
	}
yy370:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy70;
			goto yy524;
		} else {
			if (yych == 'o') goto yy524;
			goto yy70;
		}
	}
yy371:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy525;
	if (yych == 'u') goto yy525;
	goto yy357;
yy372:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy526;
		if (yych <= 'R') goto yy357;
		goto yy514;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy357;
			goto yy526;
		} else {
			if (yych == 's') goto yy514;
			goto yy357;
		}
	}
yy373:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= '.') goto yy215;
		if (yych <= '/') goto yy70;
		goto yy216;
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy70;
			goto yy358;
		} else {
			if (yych == 't') goto yy358;
			goto yy70;
		}
	}
yy374:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy527;
	if (yych == 'r') goto yy527;
	goto yy357;
yy375:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy528;
	if (yych == 's') goto yy528;
	goto yy357;
yy376:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy529;
	if (yych == 'n') goto yy529;
	goto yy357;
yy377:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy356;
	if (yych == 'k') goto yy356;
	goto yy50;
yy378:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy530;
	if (yych <= '6') goto yy531;
	if (yych <= '9') goto yy473;
	goto yy50;
yy379:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych == ' ') goto yy532;
			goto yy187;
		} else {
			if (yych <= '.') goto yy378;
			if (yych != ':') goto yy187;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy91;
			if (yych == 'P') goto yy91;
			goto yy187;
		} else {
			if (yych <= 'a') goto yy91;
			if (yych == 'p') goto yy91;
			goto yy187;
		}
	}
yy380:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy533;
	if (yych <= '6') goto yy534;
	if (yych <= '9') goto yy476;
	goto yy50;
yy381:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych == ' ') goto yy532;
			goto yy187;
		} else {
			if (yych <= '.') goto yy380;
			if (yych == ':') goto yy380;
			goto yy187;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy91;
			if (yych == 'P') goto yy91;
			goto yy187;
		} else {
			if (yych <= 'a') goto yy91;
			if (yych == 'p') goto yy91;
			goto yy187;
		}
	}
yy382:
	++YYCURSOR;
	goto yy245;
yy383:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy535;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy385;
	goto yy50;
yy384:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy535;
	if (yych <= '/') goto yy50;
	if (yych >= '3') goto yy50;
yy385:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy535;
	goto yy50;
yy386:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy536;
		if (yych <= 'T') goto yy50;
		goto yy537;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy536;
		} else {
			if (yych == 'u') goto yy537;
			goto yy50;
		}
	}
yy387:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy538;
	if (yych == 'e') goto yy538;
	goto yy50;
yy388:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy539;
	if (yych == 'e') goto yy539;
	goto yy50;
yy389:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy540;
		if (yych <= 'T') goto yy50;
		goto yy541;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy540;
		} else {
			if (yych == 'u') goto yy541;
			goto yy50;
		}
	}
yy390:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy542;
	if (yych == 'a') goto yy542;
	goto yy50;
yy391:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy543;
	if (yych == 'o') goto yy543;
	goto yy50;
yy392:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy544;
	if (yych == 'c') goto yy544;
	goto yy50;
yy393:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy545;
	if (yych == 'e') goto yy545;
	goto yy50;
yy394:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy97;
	goto yy16;
yy395:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy121;
	if (yych <= '0') goto yy546;
	if (yych <= '2') goto yy547;
	if (yych <= '3') goto yy548;
	goto yy121;
yy396:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'L') goto yy120;
		if (yych == 'l') goto yy120;
		goto yy16;
	}
yy397:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'S') goto yy549;
		if (yych == 's') goto yy549;
		goto yy16;
	}
yy398:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy550;
	}
	goto yy50;
yy399:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy97;
		if (yych <= '.') goto yy16;
		goto yy253;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy16;
			goto yy253;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy400:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'K') goto yy16;
			goto yy120;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'l') goto yy553;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy401:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'R') goto yy16;
			goto yy549;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 's') goto yy554;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy402:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'M') goto yy555;
		if (yych == 'm') goto yy555;
		goto yy16;
	}
yy403:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'L') goto yy16;
			goto yy555;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'm') goto yy556;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy404:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'T') goto yy557;
		if (yych == 't') goto yy557;
		goto yy16;
	}
yy405:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy559;
		if (yych == 'e') goto yy559;
		goto yy16;
	}
yy406:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'S') goto yy16;
			goto yy557;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy560;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy407:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'D') goto yy16;
			goto yy559;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy561;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy408:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'U') goto yy562;
		if (yych == 'u') goto yy562;
		goto yy16;
	}
yy409:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy557;
		if (yych == 'h') goto yy557;
		goto yy16;
	}
yy410:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'T') goto yy563;
		if (yych == 't') goto yy563;
		goto yy16;
	}
yy411:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy564;
		if (yych == 'a') goto yy564;
		goto yy16;
	}
yy412:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'T') goto yy16;
			goto yy562;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'u') goto yy565;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy413:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'G') goto yy16;
			goto yy557;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'h') goto yy560;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy414:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'S') goto yy16;
			goto yy563;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 't') goto yy566;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy415:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			goto yy564;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy567;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy416:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy568;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy417:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '3') goto yy568;
		if (yych <= '9') goto yy569;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy418:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy569;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy419:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy276;
		if (yych <= '1') goto yy570;
		goto yy571;
	} else {
		if (yych <= '5') goto yy572;
		if (yych <= '9') goto yy573;
		goto yy276;
	}
yy420:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy574;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy421:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '3') goto yy574;
		if (yych <= '9') goto yy576;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy422:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy124;
	} else {
		if (yych <= '9') goto yy576;
		if (yych >= ';') goto yy124;
	}
yy423:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy577;
	if (yych <= '9') goto yy579;
	goto yy50;
yy424:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy580;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy425:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy124;
	if (yych <= '9') goto yy580;
	goto yy124;
yy426:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy581;
		if (yych == 'a') goto yy581;
		goto yy16;
	}
yy427:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= 0x1F) goto yy16;
		if (yych <= '(') goto yy121;
		goto yy122;
	} else {
		if (yych == '/') goto yy16;
		if (yych <= '9') goto yy121;
		goto yy16;
	}
yy428:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= '@') goto yy16;
			goto yy581;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy582;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy429:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych <= ')') goto yy122;
			if (yych <= '.') goto yy121;
			goto yy253;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '9') goto yy121;
			if (yych <= '^') goto yy16;
			goto yy253;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy430:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy558;
		case ')': goto yy97;
		default: goto yy16;
	}
yy431:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y': goto yy558;
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy551;
		case 'd': goto yy591;
		case 'f': goto yy592;
		case 'h': goto yy593;
		case 'm': goto yy594;
		case 's': goto yy595;
		case 't': goto yy596;
		case 'w': goto yy597;
		case 'y': goto yy598;
		default: goto yy16;
	}
yy432:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy120;
		if (yych == 'h') goto yy120;
		goto yy16;
	}
yy433:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'I') goto yy599;
		if (yych == 'i') goto yy599;
		goto yy16;
	}
yy434:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'G') goto yy16;
			goto yy120;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'h') goto yy553;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy435:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'H') goto yy16;
			goto yy599;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'i') goto yy600;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy436:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy97;
yy437:
#line 872 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8789 "real_world/parse_date_b.c"
yy438:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy97;
		if (yych <= '.') goto yy437;
		goto yy253;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy437;
			goto yy253;
		} else {
			if (yych <= '`') goto yy437;
			if (yych <= 'z') goto yy551;
			goto yy437;
		}
	}
yy439:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'B') goto yy601;
		if (yych == 'b') goto yy601;
		goto yy16;
	}
yy440:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'A') goto yy16;
			goto yy601;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'b') goto yy602;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy441:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'I') goto yy603;
		if (yych == 'i') goto yy603;
		goto yy16;
	}
yy442:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'H') goto yy16;
			goto yy603;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'i') goto yy604;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy443:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy605;
		if (yych == 'r') goto yy605;
		goto yy16;
	}
yy444:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'N') goto yy606;
		if (yych == 'n') goto yy606;
		goto yy16;
	}
yy445:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= 0x1F) goto yy16;
			if (yych <= '(') goto yy121;
			goto yy122;
		} else {
			if (yych == '-') goto yy395;
			goto yy121;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'E') goto yy607;
			if (yych == 'e') goto yy607;
			goto yy16;
		}
	}
yy446:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'N') goto yy608;
		if (yych == 'n') goto yy608;
		goto yy16;
	}
yy447:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'Q') goto yy16;
			goto yy605;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'r') goto yy609;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy448:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'M') goto yy16;
			goto yy606;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy610;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy449:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych <= 0x1F) goto yy16;
			if (yych == ')') goto yy122;
			goto yy121;
		} else {
			if (yych <= '-') goto yy395;
			if (yych == '/') goto yy253;
			goto yy121;
		}
	} else {
		if (yych <= '_') {
			if (yych == 'E') goto yy607;
			if (yych <= '^') goto yy16;
			goto yy253;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy551;
			} else {
				if (yych <= 'e') goto yy611;
				if (yych <= 'z') goto yy551;
				goto yy16;
			}
		}
	}
yy450:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'M') goto yy16;
			goto yy608;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'n') goto yy612;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy451:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy557;
		if (yych == 'd') goto yy557;
		goto yy16;
	}
yy452:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'S') goto yy605;
		if (yych == 's') goto yy605;
		goto yy16;
	}
yy453:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy613;
		if (yych == 'y') goto yy613;
		goto yy16;
	}
yy454:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy615;
		if (yych == 'r') goto yy615;
		goto yy16;
	}
yy455:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy616;
		if (yych == 'd') goto yy616;
		goto yy16;
	}
yy456:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'F') goto yy608;
		if (yych == 'f') goto yy608;
		goto yy16;
	}
yy457:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'C') goto yy16;
			goto yy557;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'd') goto yy560;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy458:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'R') goto yy16;
			goto yy605;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 's') goto yy609;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy459:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'X') goto yy16;
			goto yy613;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'y') goto yy617;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy460:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'Q') goto yy16;
			goto yy615;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'r') goto yy618;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy461:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'C') goto yy16;
			goto yy616;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'd') goto yy619;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy462:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'E') goto yy16;
			goto yy608;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'f') goto yy612;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy463:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy620;
		if (yych == 'e') goto yy620;
		goto yy16;
	}
yy464:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'D') goto yy16;
			goto yy620;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy621;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy465:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy622;
		if (yych == 'e') goto yy622;
		goto yy16;
	}
yy466:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy253;
			if (yych <= 'D') goto yy16;
			goto yy622;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy253;
			goto yy16;
		} else {
			if (yych == 'e') goto yy623;
			if (yych <= 'z') goto yy551;
			goto yy16;
		}
	}
yy467:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy468;
		if (yych <= '9') goto yy470;
		if (yych >= 'n') goto yy624;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy624;
		} else {
			if (yych <= 's') goto yy625;
			if (yych <= 't') goto yy626;
		}
	}
yy468:
#line 1061 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 9315 "real_world/parse_date_b.c"
yy469:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy468;
		if (yych <= '1') goto yy470;
		if (yych <= 'm') goto yy468;
		goto yy624;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy468;
			goto yy624;
		} else {
			if (yych <= 's') goto yy625;
			if (yych <= 't') goto yy626;
			goto yy468;
		}
	}
yy470:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy624;
		goto yy468;
	} else {
		if (yych <= 'r') goto yy624;
		if (yych <= 's') goto yy625;
		if (yych <= 't') goto yy626;
		goto yy468;
	}
yy471:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy628;
	goto yy187;
yy472:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy627;
		goto yy187;
	} else {
		if (yych <= '0') goto yy628;
		if (yych <= '9') goto yy629;
		goto yy187;
	}
yy473:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy629;
	goto yy187;
yy474:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy476;
	goto yy187;
yy475:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych != '0') goto yy187;
yy476:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	goto yy187;
yy477:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy631;
	goto yy192;
yy478:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy336;
	goto yy192;
yy479:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy632;
	goto yy50;
yy480:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy632;
		goto yy50;
	} else {
		if (yych <= 'T') goto yy479;
		if (yych == 't') goto yy479;
		goto yy50;
	}
yy481:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy482:
	switch (yych) {
		case ' ': goto yy481;
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy483;
		case 'A':
		case 'a': goto yy495;
		case 'D':
		case 'd': goto yy496;
		case 'F':
		case 'f': goto yy497;
		case 'H':
		case 'h': goto yy68;
		case 'I': goto yy498;
		case 'J':
		case 'j': goto yy500;
		case 'M':
		case 'm': goto yy501;
		case 'N':
		case 'n': goto yy502;
		case 'O':
		case 'o': goto yy503;
		case 'S':
		case 's': goto yy504;
		case 'T':
		case 't': goto yy76;
		case 'V': goto yy505;
		case 'W':
		case 'w': goto yy78;
		case 'X': goto yy507;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy483:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy484:
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy483;
		case 'A':
		case 'a': goto yy495;
		case 'D':
		case 'd': goto yy633;
		case 'F':
		case 'f': goto yy634;
		case 'I': goto yy498;
		case 'J':
		case 'j': goto yy500;
		case 'M':
		case 'm': goto yy635;
		case 'N':
		case 'n': goto yy502;
		case 'O':
		case 'o': goto yy503;
		case 'S':
		case 's': goto yy636;
		case 'V': goto yy505;
		case 'X': goto yy507;
		default: goto yy50;
	}
yy485:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy637;
		case '1': goto yy638;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy639;
		case 'A':
		case 'a': goto yy640;
		case 'D':
		case 'd': goto yy641;
		case 'F':
		case 'f': goto yy642;
		case 'J':
		case 'j': goto yy643;
		case 'M':
		case 'm': goto yy644;
		case 'N':
		case 'n': goto yy645;
		case 'O':
		case 'o': goto yy646;
		case 'S':
		case 's': goto yy647;
		default: goto yy484;
	}
yy486:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy484;
	if (yych <= '0') goto yy648;
	if (yych <= '2') goto yy649;
	if (yych <= '3') goto yy650;
	goto yy484;
yy487:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy651;
	if (yych <= '1') goto yy652;
	if (yych <= '9') goto yy653;
	goto yy50;
yy488:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '0') goto yy654;
	if (yych <= '9') goto yy656;
	goto yy171;
yy489:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '2') goto yy656;
	if (yych <= '9') goto yy657;
	goto yy171;
yy490:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy657;
	goto yy171;
yy491:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '5') goto yy657;
	if (yych <= '6') goto yy658;
	if (yych <= '9') goto yy659;
	goto yy171;
yy492:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy659;
	goto yy171;
yy493:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '0') goto yy659;
	if (yych <= '9') goto yy51;
	goto yy171;
yy494:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy660;
	if (yych <= '1') goto yy661;
	goto yy50;
yy495:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy662;
		if (yych <= 'T') goto yy50;
		goto yy663;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy662;
		} else {
			if (yych == 'u') goto yy663;
			goto yy50;
		}
	}
yy496:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy209;
		if (yych <= 'D') goto yy50;
		goto yy664;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy209;
		} else {
			if (yych == 'e') goto yy664;
			goto yy50;
		}
	}
yy497:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy665;
			goto yy50;
		} else {
			if (yych <= 'O') goto yy212;
			if (yych <= 'Q') goto yy50;
			goto yy213;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy665;
			goto yy50;
		} else {
			if (yych <= 'o') goto yy212;
			if (yych == 'r') goto yy213;
			goto yy50;
		}
	}
yy498:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy666;
	} else {
		if (yych == 'W') goto yy499;
		if (yych <= 'X') goto yy667;
	}
yy499:
#line 1114 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 9662 "real_world/parse_date_b.c"
yy500:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy668;
		if (yych <= 'T') goto yy50;
		goto yy669;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy668;
		} else {
			if (yych == 'u') goto yy669;
			goto yy50;
		}
	}
yy501:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy670;
			goto yy50;
		} else {
			if (yych <= 'I') goto yy223;
			if (yych <= 'N') goto yy50;
			goto yy224;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy670;
			goto yy50;
		} else {
			if (yych <= 'i') goto yy223;
			if (yych == 'o') goto yy224;
			goto yy50;
		}
	}
yy502:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy671;
	if (yych == 'o') goto yy671;
	goto yy50;
yy503:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy672;
	if (yych == 'c') goto yy672;
	goto yy50;
yy504:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy673;
			if (yych <= 'T') goto yy50;
			goto yy229;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy227;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy673;
			if (yych == 'u') goto yy229;
			goto yy50;
		}
	}
yy505:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy507;
	goto yy499;
yy506:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy50;
		if (yych <= '0') goto yy674;
		if (yych <= '4') goto yy675;
		goto yy676;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy50;
			goto yy232;
		} else {
			if (yych == 'e') goto yy232;
			goto yy50;
		}
	}
yy507:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy666;
	goto yy499;
yy508:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '0') goto yy677;
	if (yych <= '9') goto yy678;
	goto yy171;
yy509:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '2') goto yy678;
	if (yych <= '9') goto yy679;
	goto yy171;
yy510:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy679;
	goto yy171;
yy511:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '5') goto yy679;
	if (yych <= '6') goto yy680;
	if (yych <= '9') goto yy51;
	goto yy171;
yy512:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy219;
	if (yych == 'l') goto yy219;
	goto yy50;
yy513:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy681;
	if (yych == 's') goto yy681;
	goto yy50;
yy514:
	++YYCURSOR;
	goto yy357;
yy515:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy524;
	if (yych == 'm') goto yy524;
	goto yy50;
yy516:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy520;
	if (yych == 'u') goto yy520;
	goto yy50;
yy517:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy682;
		if (yych <= 'M') goto yy50;
		goto yy683;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy682;
		} else {
			if (yych == 'n') goto yy683;
			goto yy50;
		}
	}
yy518:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy684;
	if (yych == 'a') goto yy684;
	goto yy50;
yy519:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy217;
	if (yych <= '9') goto yy685;
	goto yy217;
yy520:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy686;
	if (yych == 'a') goto yy686;
	goto yy50;
yy521:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy219;
	if (yych == 'h') goto yy219;
	goto yy50;
yy522:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy687;
	if (yych == 't') goto yy687;
	goto yy50;
yy523:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy356;
	if (yych == 'h') goto yy356;
	goto yy50;
yy524:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy688;
	if (yych == 'b') goto yy688;
	goto yy50;
yy525:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy528;
	if (yych == 'r') goto yy528;
	goto yy50;
yy526:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy689;
	if (yych == 'n') goto yy689;
	goto yy50;
yy527:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy528;
	if (yych != 's') goto yy50;
yy528:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy518;
	if (yych == 'd') goto yy518;
	goto yy50;
yy529:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy527;
	if (yych == 'e') goto yy527;
	goto yy50;
yy530:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy690;
	goto yy187;
yy531:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy627;
		goto yy187;
	} else {
		if (yych <= '0') goto yy690;
		if (yych <= '9') goto yy629;
		goto yy187;
	}
yy532:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy50;
			goto yy532;
		} else {
			if (yych == 'A') goto yy91;
			goto yy50;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy91;
			if (yych <= '`') goto yy50;
			goto yy91;
		} else {
			if (yych == 'p') goto yy91;
			goto yy50;
		}
	}
yy533:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy691;
	goto yy187;
yy534:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych == '0') goto yy691;
	goto yy187;
yy535:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy692;
	goto yy50;
yy536:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy693;
	if (yych == 'r') goto yy693;
	goto yy50;
yy537:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy693;
	if (yych == 'g') goto yy693;
	goto yy50;
yy538:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy693;
	if (yych == 'c') goto yy693;
	goto yy50;
yy539:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy693;
	if (yych == 'b') goto yy693;
	goto yy50;
yy540:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy693;
	if (yych == 'n') goto yy693;
	goto yy50;
yy541:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy693;
		if (yych <= 'M') goto yy50;
		goto yy693;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy693;
		} else {
			if (yych == 'n') goto yy693;
			goto yy50;
		}
	}
yy542:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy693;
		if (yych <= 'X') goto yy50;
		goto yy693;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy693;
		} else {
			if (yych == 'y') goto yy693;
			goto yy50;
		}
	}
yy543:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy693;
	if (yych == 'v') goto yy693;
	goto yy50;
yy544:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy693;
	if (yych == 't') goto yy693;
	goto yy50;
yy545:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy694;
	if (yych == 'p') goto yy694;
	goto yy50;
yy546:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '0') goto yy277;
	if (yych <= '9') goto yy695;
	goto yy276;
yy547:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy695;
	goto yy276;
yy548:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '1') goto yy695;
	if (yych <= '2') goto yy278;
	if (yych <= '9') goto yy279;
	goto yy276;
yy549:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy120;
	if (yych == 't') goto yy120;
	goto yy50;
yy550:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy550;
	}
	if (yych == '/') goto yy253;
	if (yych == '_') goto yy253;
	goto yy16;
yy551:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy552:
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy50;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy50;
		if (yych <= 'z') goto yy551;
		goto yy50;
	}
yy553:
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy121;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy121;
		if (yych <= 'z') goto yy551;
		goto yy121;
	}
yy554:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy120;
	if (yych == 't') goto yy553;
	goto yy552;
yy555:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy601;
	if (yych == 'b') goto yy601;
	goto yy50;
yy556:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy601;
	if (yych == 'b') goto yy602;
	goto yy552;
yy557:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy558:
	switch (yych) {
		case ' ': goto yy557;
		case 'D':
		case 'd': goto yy583;
		case 'F':
		case 'f': goto yy584;
		case 'H':
		case 'h': goto yy585;
		case 'M':
		case 'm': goto yy586;
		case 'S':
		case 's': goto yy587;
		case 'T':
		case 't': goto yy588;
		case 'W':
		case 'w': goto yy589;
		case 'Y':
		case 'y': goto yy590;
		default: goto yy50;
	}
yy559:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy608;
	if (yych == 'n') goto yy608;
	goto yy50;
yy560:
	yych = *++YYCURSOR;
	if (yych <= 'h') {
		if (yych <= '`') {
			if (yych <= '/') {
				if (yych <= '.') goto yy558;
				goto yy253;
			} else {
				if (yych == '_') goto yy253;
				goto yy558;
			}
		} else {
			if (yych <= 'e') {
				if (yych == 'd') goto yy591;
				goto yy551;
			} else {
				if (yych <= 'f') goto yy592;
				if (yych <= 'g') goto yy551;
				goto yy593;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy551;
				goto yy594;
			} else {
				if (yych <= 'r') goto yy551;
				if (yych <= 's') goto yy595;
				goto yy596;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'w') goto yy597;
				goto yy551;
			} else {
				if (yych <= 'y') goto yy598;
				if (yych <= 'z') goto yy551;
				goto yy558;
			}
		}
	}
yy561:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy608;
	if (yych == 'n') goto yy612;
	goto yy552;
yy562:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy581;
	if (yych == 'a') goto yy581;
	goto yy50;
yy563:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy557;
	if (yych == 'h') goto yy557;
	goto yy50;
yy564:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy696;
	if (yych == 'y') goto yy696;
	goto yy50;
yy565:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy581;
	if (yych == 'a') goto yy582;
	goto yy552;
yy566:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy557;
	if (yych == 'h') goto yy560;
	goto yy552;
yy567:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy696;
	if (yych == 'y') goto yy697;
	goto yy552;
yy568:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
		goto yy124;
	} else {
		if (yych <= '9') goto yy698;
		if (yych <= ':') goto yy423;
		goto yy124;
	}
yy569:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy124;
	if (yych <= '9') goto yy698;
	goto yy124;
yy570:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy699;
		goto yy124;
	} else {
		if (yych <= '9') goto yy700;
		if (yych <= ':') goto yy699;
		goto yy124;
	}
yy571:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy699;
		goto yy124;
	} else {
		if (yych <= '3') goto yy700;
		if (yych <= '9') goto yy701;
		if (yych <= ':') goto yy699;
		goto yy124;
	}
yy572:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy699;
		goto yy124;
	} else {
		if (yych <= '9') goto yy701;
		if (yych <= ':') goto yy699;
		goto yy124;
	}
yy573:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy699;
		goto yy124;
	} else {
		if (yych <= '9') goto yy569;
		if (yych <= ':') goto yy699;
		goto yy124;
	}
yy574:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy423;
	} else {
		if (yych <= '9') goto yy698;
		if (yych <= ':') goto yy423;
	}
yy575:
#line 1101 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 10267 "real_world/parse_date_b.c"
yy576:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy575;
	if (yych <= '9') goto yy698;
	goto yy575;
yy577:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy702;
	} else {
		if (yych <= '9') goto yy579;
		if (yych <= ':') goto yy702;
	}
yy578:
#line 1352 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 10310 "real_world/parse_date_b.c"
yy579:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy702;
	if (yych == ':') goto yy702;
	goto yy578;
yy580:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy575;
	if (yych <= '9') goto yy703;
	goto yy575;
yy581:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy704;
	if (yych == 'r') goto yy704;
	goto yy50;
yy582:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy704;
	if (yych == 'r') goto yy705;
	goto yy552;
yy583:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy706;
	if (yych == 'a') goto yy706;
	goto yy50;
yy584:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy707;
		if (yych <= 'Q') goto yy50;
		goto yy708;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy50;
			goto yy707;
		} else {
			if (yych == 'r') goto yy708;
			goto yy50;
		}
	}
yy585:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy709;
	if (yych == 'o') goto yy709;
	goto yy50;
yy586:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy710;
		if (yych <= 'N') goto yy50;
		goto yy711;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy50;
			goto yy710;
		} else {
			if (yych == 'o') goto yy711;
			goto yy50;
		}
	}
yy587:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy712;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy713;
			if (yych <= 'T') goto yy50;
			goto yy714;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy712;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy713;
			if (yych == 'u') goto yy714;
			goto yy50;
		}
	}
yy588:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy715;
		if (yych <= 'T') goto yy50;
		goto yy716;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy715;
		} else {
			if (yych == 'u') goto yy716;
			goto yy50;
		}
	}
yy589:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy717;
	if (yych == 'e') goto yy717;
	goto yy50;
yy590:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy718;
	if (yych == 'e') goto yy718;
	goto yy50;
yy591:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy706;
	if (yych == 'a') goto yy719;
	goto yy552;
yy592:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy707;
		if (yych <= 'Q') goto yy552;
		goto yy708;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy552;
			goto yy720;
		} else {
			if (yych == 'r') goto yy721;
			goto yy552;
		}
	}
yy593:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy709;
	if (yych == 'o') goto yy722;
	goto yy552;
yy594:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy710;
		if (yych <= 'N') goto yy552;
		goto yy711;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy552;
			goto yy723;
		} else {
			if (yych == 'o') goto yy724;
			goto yy552;
		}
	}
yy595:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy712;
			goto yy552;
		} else {
			if (yych <= 'E') goto yy713;
			if (yych <= 'T') goto yy552;
			goto yy714;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy725;
			goto yy552;
		} else {
			if (yych <= 'e') goto yy726;
			if (yych == 'u') goto yy727;
			goto yy552;
		}
	}
yy596:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy715;
		if (yych <= 'T') goto yy552;
		goto yy716;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy552;
			goto yy728;
		} else {
			if (yych == 'u') goto yy729;
			goto yy552;
		}
	}
yy597:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy717;
	if (yych == 'e') goto yy730;
	goto yy552;
yy598:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy718;
	if (yych == 'e') goto yy731;
	goto yy552;
yy599:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy732;
	if (yych == 'g') goto yy732;
	goto yy50;
yy600:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy732;
	if (yych == 'g') goto yy733;
	goto yy552;
yy601:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy734;
	if (yych == 'e') goto yy734;
	goto yy50;
yy602:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy734;
	if (yych == 'e') goto yy735;
	goto yy552;
yy603:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy736;
	if (yych == 'o') goto yy736;
	goto yy50;
yy604:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy736;
	if (yych == 'o') goto yy737;
	goto yy552;
yy605:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy616;
	if (yych == 'd') goto yy616;
	goto yy50;
yy606:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy557;
	if (yych == 'd') goto yy557;
	goto yy50;
yy607:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy555;
	if (yych == 'm') goto yy555;
	goto yy50;
yy608:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy563;
	if (yych == 't') goto yy563;
	goto yy50;
yy609:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy616;
	if (yych == 'd') goto yy619;
	goto yy552;
yy610:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy557;
	if (yych == 'd') goto yy560;
	goto yy552;
yy611:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy555;
	if (yych == 'm') goto yy556;
	goto yy552;
yy612:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy563;
	if (yych == 't') goto yy566;
	goto yy552;
yy613:
	++YYCURSOR;
yy614:
#line 884 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 10586 "real_world/parse_date_b.c"
yy615:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy738;
	if (yych == 'r') goto yy738;
	goto yy50;
yy616:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy564;
	if (yych == 'a') goto yy564;
	goto yy50;
yy617:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy614;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy614;
		if (yych <= 'z') goto yy551;
		goto yy614;
	}
yy618:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy738;
	if (yych == 'r') goto yy739;
	goto yy552;
yy619:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy564;
	if (yych == 'a') goto yy567;
	goto yy552;
yy620:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy605;
	if (yych == 's') goto yy605;
	goto yy50;
yy621:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy605;
	if (yych == 's') goto yy609;
	goto yy552;
yy622:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy740;
	if (yych == 'r') goto yy740;
	goto yy50;
yy623:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy740;
	if (yych == 'r') goto yy741;
	goto yy552;
yy624:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy742;
	goto yy50;
yy625:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy742;
	goto yy50;
yy626:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy742;
	goto yy50;
yy627:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy743;
	goto yy50;
yy628:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy627;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy744;
	goto yy187;
yy629:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy630;
	if (yych <= '9') goto yy744;
yy630:
#line 1088 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10680 "real_world/parse_date_b.c"
yy631:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy745;
	goto yy192;
yy632:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy746;
	goto yy50;
yy633:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy664;
	if (yych == 'e') goto yy664;
	goto yy50;
yy634:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy665;
	if (yych == 'e') goto yy665;
	goto yy50;
yy635:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy670;
	if (yych == 'a') goto yy670;
	goto yy50;
yy636:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy747;
	if (yych == 'e') goto yy747;
	goto yy50;
yy637:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy748;
		goto yy50;
	} else {
		if (yych <= '0') goto yy639;
		if (yych <= '9') goto yy749;
		goto yy50;
	}
yy638:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy748;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy749;
	goto yy50;
yy639:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy748;
	goto yy50;
yy640:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy750;
		if (yych <= 'T') goto yy50;
		goto yy751;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy750;
		} else {
			if (yych == 'u') goto yy751;
			goto yy50;
		}
	}
yy641:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy752;
	if (yych == 'e') goto yy752;
	goto yy50;
yy642:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy753;
	if (yych == 'e') goto yy753;
	goto yy50;
yy643:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy754;
		if (yych <= 'T') goto yy50;
		goto yy755;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy754;
		} else {
			if (yych == 'u') goto yy755;
			goto yy50;
		}
	}
yy644:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy756;
	if (yych == 'a') goto yy756;
	goto yy50;
yy645:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy757;
	if (yych == 'o') goto yy757;
	goto yy50;
yy646:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy758;
	if (yych == 'c') goto yy758;
	goto yy50;
yy647:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy759;
	if (yych == 'e') goto yy759;
	goto yy50;
yy648:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy760;
	if (yych <= '9') goto yy761;
	goto yy50;
yy649:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy761;
	goto yy50;
yy650:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy761;
	if (yych <= '6') goto yy762;
	goto yy50;
yy651:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy50;
	if (yych <= '/') goto yy763;
	if (yych <= '0') goto yy653;
	if (yych <= '9') goto yy764;
	goto yy50;
yy652:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy50;
	if (yych <= '/') goto yy763;
	if (yych <= '2') goto yy764;
	goto yy50;
yy653:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy763;
	goto yy50;
yy654:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0': goto yy51;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy655;
	}
yy655:
#line 1016 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 10876 "real_world/parse_date_b.c"
yy656:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0': goto yy767;
		case '1':
		case '2': goto yy768;
		case '3': goto yy769;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy655;
	}
yy657:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy655;
	}
yy658:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6': goto yy765;
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy655;
	}
yy659:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= 'C') {
				if (yych == ' ') goto yy171;
				goto yy655;
			} else {
				if (yych == 'E') goto yy655;
				if (yych <= 'F') goto yy171;
				goto yy655;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') goto yy171;
				if (yych == 'M') goto yy171;
				goto yy655;
			} else {
				if (yych <= 'T') goto yy171;
				if (yych == 'W') goto yy171;
				goto yy655;
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy171;
				if (yych == 'd') goto yy171;
				goto yy655;
			} else {
				if (yych == 'g') goto yy655;
				if (yych <= 'h') goto yy171;
				goto yy655;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') goto yy171;
				if (yych <= 'r') goto yy655;
				if (yych <= 't') goto yy171;
				goto yy655;
			} else {
				if (yych == 'x') goto yy655;
				if (yych <= 'y') goto yy171;
				goto yy655;
			}
		}
	}
yy660:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy770;
	goto yy50;
yy661:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy770;
	goto yy50;
yy662:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy771;
	if (yych == 'r') goto yy771;
	goto yy50;
yy663:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy772;
	if (yych == 'g') goto yy772;
	goto yy50;
yy664:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy773;
	if (yych == 'c') goto yy773;
	goto yy50;
yy665:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy774;
	if (yych == 'b') goto yy774;
	goto yy50;
yy666:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy499;
yy667:
	++YYCURSOR;
	goto yy499;
yy668:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy775;
	if (yych == 'n') goto yy775;
	goto yy50;
yy669:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy776;
		if (yych <= 'M') goto yy50;
		goto yy777;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy776;
		} else {
			if (yych == 'n') goto yy777;
			goto yy50;
		}
	}
yy670:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy778;
		if (yych <= 'X') goto yy50;
		goto yy667;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy778;
		} else {
			if (yych == 'y') goto yy667;
			goto yy50;
		}
	}
yy671:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy773;
	if (yych == 'v') goto yy773;
	goto yy50;
yy672:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy779;
	if (yych == 't') goto yy779;
	goto yy50;
yy673:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy372;
		if (yych <= 'O') goto yy50;
		goto yy780;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy50;
			goto yy372;
		} else {
			if (yych == 'p') goto yy780;
			goto yy50;
		}
	}
yy674:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy781;
	goto yy50;
yy675:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy781;
	goto yy50;
yy676:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy781;
	goto yy50;
yy677:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '0') goto yy51;
	if (yych <= '9') goto yy765;
	goto yy171;
yy678:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy171;
		if (yych <= '0') goto yy767;
		goto yy768;
	} else {
		if (yych <= '3') goto yy769;
		if (yych <= '9') goto yy765;
		goto yy171;
	}
yy679:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '9') goto yy765;
	goto yy171;
yy680:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy171;
	if (yych <= '6') goto yy765;
	if (yych <= '9') goto yy51;
	goto yy171;
yy681:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy219;
	if (yych == 't') goto yy219;
	goto yy50;
yy682:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy683;
	if (yych != 'n') goto yy50;
yy683:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy783;
	if (yych == 'i') goto yy783;
	goto yy50;
yy684:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy514;
	if (yych == 'y') goto yy514;
	goto yy50;
yy685:
	++YYCURSOR;
	goto yy217;
yy686:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy784;
	if (yych == 'r') goto yy784;
	goto yy50;
yy687:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy356;
	if (yych == 'e') goto yy356;
	goto yy50;
yy688:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy785;
	if (yych == 'e') goto yy785;
	goto yy50;
yy689:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy356;
	if (yych == 'd') goto yy356;
	goto yy50;
yy690:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych == ' ') goto yy532;
			goto yy187;
		} else {
			if (yych <= '.') goto yy627;
			if (yych <= '/') goto yy187;
			if (yych <= '9') goto yy744;
			goto yy187;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy91;
			if (yych == 'P') goto yy91;
			goto yy187;
		} else {
			if (yych <= 'a') goto yy91;
			if (yych == 'p') goto yy91;
			goto yy187;
		}
	}
yy691:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ' ') goto yy532;
			goto yy187;
		} else {
			if (yych <= '.') goto yy627;
			if (yych <= '@') goto yy187;
			goto yy91;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy91;
			goto yy187;
		} else {
			if (yych <= 'a') goto yy91;
			if (yych == 'p') goto yy91;
			goto yy187;
		}
	}
yy692:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy630;
	if (yych <= '9') goto yy629;
	goto yy630;
yy693:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy786;
	goto yy50;
yy694:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy786;
		goto yy50;
	} else {
		if (yych <= 'T') goto yy693;
		if (yych == 't') goto yy693;
		goto yy50;
	}
yy695:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy787;
		case '.': goto yy419;
		case '0':
		case '1': goto yy420;
		case '2': goto yy421;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy422;
		case ':': goto yy423;
		default: goto yy276;
	}
yy696:
	++YYCURSOR;
	goto yy269;
yy697:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy269;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy269;
		if (yych <= 'z') goto yy551;
		goto yy269;
	}
yy698:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy124;
	if (yych <= '9') goto yy703;
	goto yy124;
yy699:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy788;
	if (yych <= '6') goto yy789;
	if (yych <= '9') goto yy579;
	goto yy50;
yy700:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy699;
		goto yy124;
	} else {
		if (yych <= '9') goto yy698;
		if (yych <= ':') goto yy699;
		goto yy124;
	}
yy701:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy124;
	} else {
		if (yych <= '9') goto yy698;
		if (yych >= ';') goto yy124;
	}
yy702:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy790;
	if (yych <= '6') goto yy791;
	if (yych <= '9') goto yy792;
	goto yy50;
yy703:
	++YYCURSOR;
	goto yy124;
yy704:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy120;
	if (yych == 'y') goto yy120;
	goto yy50;
yy705:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy120;
	if (yych == 'y') goto yy553;
	goto yy552;
yy706:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy793;
	if (yych == 'y') goto yy793;
	goto yy50;
yy707:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy795;
	if (yych == 'r') goto yy795;
	goto yy50;
yy708:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy796;
	if (yych == 'i') goto yy796;
	goto yy50;
yy709:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy797;
	if (yych == 'u') goto yy797;
	goto yy50;
yy710:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy798;
	if (yych == 'n') goto yy798;
	goto yy50;
yy711:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy799;
	if (yych == 'n') goto yy799;
	goto yy50;
yy712:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy800;
	if (yych == 't') goto yy800;
	goto yy50;
yy713:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy801;
	if (yych == 'c') goto yy801;
	goto yy50;
yy714:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy796;
	if (yych == 'n') goto yy796;
	goto yy50;
yy715:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy802;
	if (yych == 'u') goto yy802;
	goto yy50;
yy716:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy803;
	if (yych == 'e') goto yy803;
	goto yy50;
yy717:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy50;
		if (yych <= 'D') goto yy804;
		goto yy805;
	} else {
		if (yych <= 'c') goto yy50;
		if (yych <= 'd') goto yy804;
		if (yych <= 'e') goto yy805;
		goto yy50;
	}
yy718:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy797;
	if (yych == 'a') goto yy797;
	goto yy50;
yy719:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy793;
	if (yych == 'y') goto yy806;
	goto yy552;
yy720:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy795;
	if (yych == 'r') goto yy807;
	goto yy552;
yy721:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy796;
	if (yych == 'i') goto yy808;
	goto yy552;
yy722:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy797;
	if (yych == 'u') goto yy809;
	goto yy552;
yy723:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy798;
	if (yych == 'n') goto yy810;
	goto yy552;
yy724:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy799;
	if (yych == 'n') goto yy811;
	goto yy552;
yy725:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy800;
	if (yych == 't') goto yy812;
	goto yy552;
yy726:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy801;
	if (yych == 'c') goto yy813;
	goto yy552;
yy727:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy796;
	if (yych == 'n') goto yy808;
	goto yy552;
yy728:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy802;
	if (yych == 'u') goto yy814;
	goto yy552;
yy729:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy803;
	if (yych == 'e') goto yy815;
	goto yy552;
yy730:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy552;
		if (yych <= 'D') goto yy804;
		goto yy805;
	} else {
		if (yych <= 'c') goto yy552;
		if (yych <= 'd') goto yy816;
		if (yych <= 'e') goto yy817;
		goto yy552;
	}
yy731:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy797;
	if (yych == 'a') goto yy809;
	goto yy552;
yy732:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy818;
	if (yych == 'h') goto yy818;
	goto yy50;
yy733:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy818;
	if (yych == 'h') goto yy819;
	goto yy552;
yy734:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy120;
	if (yych == 'r') goto yy120;
	goto yy50;
yy735:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy120;
	if (yych == 'r') goto yy553;
	goto yy552;
yy736:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy820;
	if (yych == 'u') goto yy820;
	goto yy50;
yy737:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy820;
	if (yych == 'u') goto yy821;
	goto yy552;
yy738:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy822;
	if (yych == 'o') goto yy822;
	goto yy50;
yy739:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy822;
	if (yych == 'o') goto yy823;
	goto yy552;
yy740:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy824;
	if (yych == 'd') goto yy824;
	goto yy50;
yy741:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy824;
	if (yych == 'd') goto yy825;
	goto yy552;
yy742:
	++YYCURSOR;
	goto yy468;
yy743:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy187;
	if (yych <= '9') goto yy743;
	goto yy187;
yy744:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy630;
	if (yych <= '9') goto yy826;
	goto yy630;
yy745:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '9') goto yy827;
	goto yy192;
yy746:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy828;
	goto yy50;
yy747:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy780;
	if (yych == 'p') goto yy780;
	goto yy50;
yy748:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy829;
	if (yych <= '3') goto yy830;
	if (yych <= '9') goto yy831;
	goto yy50;
yy749:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy832;
	goto yy50;
yy750:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy833;
	if (yych == 'r') goto yy833;
	goto yy50;
yy751:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy834;
	if (yych == 'g') goto yy834;
	goto yy50;
yy752:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy835;
	if (yych == 'c') goto yy835;
	goto yy50;
yy753:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy836;
	if (yych == 'b') goto yy836;
	goto yy50;
yy754:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy837;
	if (yych == 'n') goto yy837;
	goto yy50;
yy755:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy838;
		if (yych <= 'M') goto yy50;
		goto yy839;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy838;
		} else {
			if (yych == 'n') goto yy839;
			goto yy50;
		}
	}
yy756:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy840;
		if (yych <= 'X') goto yy50;
		goto yy841;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy840;
		} else {
			if (yych == 'y') goto yy841;
			goto yy50;
		}
	}
yy757:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy835;
	if (yych == 'v') goto yy835;
	goto yy50;
yy758:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy842;
	if (yych == 't') goto yy842;
	goto yy50;
yy759:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy843;
	if (yych == 'p') goto yy843;
	goto yy50;
yy760:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy844;
	goto yy50;
yy761:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy844;
	goto yy50;
yy762:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '6') goto yy844;
	goto yy50;
yy763:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy845;
	if (yych <= '3') goto yy847;
	if (yych <= '9') goto yy848;
	goto yy50;
yy764:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy849;
	goto yy50;
yy765:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= 'C') {
				if (yych == ' ') goto yy171;
			} else {
				if (yych == 'E') goto yy766;
				if (yych <= 'F') goto yy171;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') goto yy171;
				if (yych == 'M') goto yy171;
			} else {
				if (yych <= 'T') goto yy171;
				if (yych == 'W') goto yy171;
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy171;
				if (yych == 'd') goto yy171;
			} else {
				if (yych == 'g') goto yy766;
				if (yych <= 'h') goto yy171;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') goto yy171;
				if (yych <= 'r') goto yy766;
				if (yych <= 't') goto yy171;
			} else {
				if (yych == 'x') goto yy766;
				if (yych <= 'y') goto yy171;
			}
		}
	}
yy766:
#line 1188 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 11746 "real_world/parse_date_b.c"
yy767:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0': goto yy51;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy850;
		default: goto yy766;
	}
yy768:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy850;
		default: goto yy766;
	}
yy769:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1': goto yy850;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy766;
	}
yy770:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy852;
	goto yy50;
yy771:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy853;
	if (yych == 'i') goto yy853;
	goto yy499;
yy772:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy854;
	if (yych == 'u') goto yy854;
	goto yy499;
yy773:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy855;
	if (yych == 'e') goto yy855;
	goto yy499;
yy774:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy856;
	if (yych == 'r') goto yy856;
	goto yy499;
yy775:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy857;
	if (yych == 'u') goto yy857;
	goto yy499;
yy776:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy667;
	if (yych == 'y') goto yy667;
	goto yy499;
yy777:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy667;
	if (yych == 'e') goto yy667;
	goto yy499;
yy778:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy858;
	if (yych == 'c') goto yy858;
	goto yy499;
yy779:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy859;
	if (yych == 'o') goto yy859;
	goto yy499;
yy780:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy773;
	if (yych == 't') goto yy773;
	goto yy499;
yy781:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy782;
	if (yych <= '7') goto yy860;
yy782:
#line 1220 "real_world/parse_date_b.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 11930 "real_world/parse_date_b.c"
yy783:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy861;
	if (yych == 'g') goto yy861;
	goto yy50;
yy784:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy219;
	if (yych == 'y') goto yy219;
	goto yy50;
yy785:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy219;
	if (yych == 'r') goto yy219;
	goto yy50;
yy786:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy862;
	if (yych <= '2') goto yy863;
	if (yych <= '3') goto yy864;
	goto yy50;
yy787:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy865;
	goto yy50;
yy788:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy702;
		goto yy578;
	} else {
		if (yych <= '9') goto yy867;
		if (yych <= ':') goto yy702;
		goto yy578;
	}
yy789:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy702;
		goto yy578;
	} else {
		if (yych <= '0') goto yy868;
		if (yych == ':') goto yy702;
		goto yy578;
	}
yy790:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '9') goto yy868;
	goto yy578;
yy791:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy868;
	goto yy578;
yy792:
	++YYCURSOR;
	goto yy578;
yy793:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy869;
	if (yych == 's') goto yy869;
yy794:
#line 1324 "real_world/parse_date_b.re"
	{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12013 "real_world/parse_date_b.c"
yy795:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy870;
	if (yych == 't') goto yy870;
	goto yy50;
yy796:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy871;
	if (yych == 'd') goto yy871;
	goto yy794;
yy797:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy793;
	if (yych == 'r') goto yy793;
	goto yy50;
yy798:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy869;
		if (yych <= 'T') goto yy794;
		goto yy872;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy794;
			goto yy869;
		} else {
			if (yych == 'u') goto yy872;
			goto yy794;
		}
	}
yy799:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy871;
		if (yych <= 'S') goto yy794;
		goto yy873;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy794;
			goto yy871;
		} else {
			if (yych == 't') goto yy873;
			goto yy794;
		}
	}
yy800:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy874;
	if (yych == 'u') goto yy874;
	goto yy794;
yy801:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy875;
		if (yych <= 'R') goto yy794;
		goto yy869;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy794;
			goto yy875;
		} else {
			if (yych == 's') goto yy869;
			goto yy794;
		}
	}
yy802:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy876;
	if (yych == 'r') goto yy876;
	goto yy794;
yy803:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy877;
	if (yych == 's') goto yy877;
	goto yy794;
yy804:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy878;
	if (yych == 'n') goto yy878;
	goto yy794;
yy805:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy793;
	if (yych == 'k') goto yy793;
	goto yy50;
yy806:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy794;
			goto yy253;
		} else {
			if (yych == 'S') goto yy869;
			goto yy794;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			goto yy551;
		} else {
			if (yych <= 's') goto yy879;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy807:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy870;
	if (yych == 't') goto yy880;
	goto yy552;
yy808:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy794;
			goto yy253;
		} else {
			if (yych == 'D') goto yy871;
			goto yy794;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			goto yy551;
		} else {
			if (yych <= 'd') goto yy881;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy809:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy793;
	if (yych == 'r') goto yy806;
	goto yy552;
yy810:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'R') {
			if (yych == '/') goto yy253;
			goto yy794;
		} else {
			if (yych <= 'S') goto yy869;
			if (yych == 'U') goto yy872;
			goto yy794;
		}
	} else {
		if (yych <= 's') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			if (yych <= 'r') goto yy551;
			goto yy879;
		} else {
			if (yych == 'u') goto yy882;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy811:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'C') {
			if (yych == '/') goto yy253;
			goto yy794;
		} else {
			if (yych <= 'D') goto yy871;
			if (yych == 'T') goto yy873;
			goto yy794;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			if (yych <= 'c') goto yy551;
			goto yy881;
		} else {
			if (yych == 't') goto yy883;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy812:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy794;
			goto yy253;
		} else {
			if (yych == 'U') goto yy874;
			goto yy794;
		}
	} else {
		if (yych <= 't') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			goto yy551;
		} else {
			if (yych <= 'u') goto yy884;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy813:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'N') {
			if (yych == '/') goto yy253;
			goto yy794;
		} else {
			if (yych <= 'O') goto yy875;
			if (yych == 'S') goto yy869;
			goto yy794;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			if (yych <= 'n') goto yy551;
			goto yy885;
		} else {
			if (yych == 's') goto yy879;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy814:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy794;
			goto yy253;
		} else {
			if (yych == 'R') goto yy876;
			goto yy794;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			goto yy551;
		} else {
			if (yych <= 'r') goto yy886;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy815:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy794;
			goto yy253;
		} else {
			if (yych == 'S') goto yy877;
			goto yy794;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			goto yy551;
		} else {
			if (yych <= 's') goto yy887;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy816:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy794;
			goto yy253;
		} else {
			if (yych == 'N') goto yy878;
			goto yy794;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= '_') goto yy253;
			if (yych <= '`') goto yy794;
			goto yy551;
		} else {
			if (yych <= 'n') goto yy888;
			if (yych <= 'z') goto yy551;
			goto yy794;
		}
	}
yy817:
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy793;
	if (yych == 'k') goto yy806;
	goto yy552;
yy818:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy613;
	if (yych == 't') goto yy613;
	goto yy50;
yy819:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy613;
	if (yych == 't') goto yy617;
	goto yy552;
yy820:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy557;
	if (yych == 's') goto yy557;
	goto yy50;
yy821:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy557;
	if (yych == 's') goto yy560;
	goto yy552;
yy822:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy889;
	if (yych == 'w') goto yy889;
	goto yy50;
yy823:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy889;
	if (yych == 'w') goto yy891;
	goto yy552;
yy824:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy892;
	if (yych == 'a') goto yy892;
	goto yy50;
yy825:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy892;
	if (yych == 'a') goto yy893;
	goto yy552;
yy826:
	++YYCURSOR;
	goto yy630;
yy827:
	++YYCURSOR;
	goto yy192;
yy828:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy894;
	goto yy50;
yy829:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy468;
			goto yy831;
		} else {
			if (yych == 'T') goto yy895;
			goto yy468;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy896;
			if (yych <= 'q') goto yy468;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy468;
		}
	}
yy830:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy468;
		} else {
			if (yych == 'T') goto yy895;
			goto yy468;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy896;
			if (yych <= 'q') goto yy468;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy468;
		}
	}
yy831:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy895;
		if (yych <= 'm') goto yy468;
		goto yy896;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy468;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy468;
		}
	}
yy832:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy50;
		if (yych <= '0') goto yy899;
		goto yy900;
	} else {
		if (yych <= '3') goto yy901;
		if (yych <= '9') goto yy831;
		goto yy50;
	}
yy833:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'I') goto yy853;
		if (yych == 'i') goto yy853;
		goto yy499;
	}
yy834:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'U') goto yy854;
		if (yych == 'u') goto yy854;
		goto yy499;
	}
yy835:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'E') goto yy855;
		if (yych == 'e') goto yy855;
		goto yy499;
	}
yy836:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'R') goto yy856;
		if (yych == 'r') goto yy856;
		goto yy499;
	}
yy837:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'U') goto yy857;
		if (yych == 'u') goto yy857;
		goto yy499;
	}
yy838:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'Y') goto yy667;
		if (yych == 'y') goto yy667;
		goto yy499;
	}
yy839:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'E') goto yy667;
		if (yych == 'e') goto yy667;
		goto yy499;
	}
yy840:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'C') goto yy858;
		if (yych == 'c') goto yy858;
		goto yy499;
	}
yy841:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy786;
	goto yy499;
yy842:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'O') goto yy859;
		if (yych == 'o') goto yy859;
		goto yy499;
	}
yy843:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy786;
		goto yy499;
	} else {
		if (yych <= 'T') goto yy835;
		if (yych == 't') goto yy835;
		goto yy499;
	}
yy844:
	++YYCURSOR;
	goto yy766;
yy845:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy846;
		if (yych <= '9') goto yy848;
		if (yych >= 'n') goto yy902;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy902;
		} else {
			if (yych <= 's') goto yy903;
			if (yych <= 't') goto yy904;
		}
	}
yy846:
#line 1049 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 12593 "real_world/parse_date_b.c"
yy847:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy846;
		if (yych <= '1') goto yy848;
		if (yych <= 'm') goto yy846;
		goto yy902;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy846;
			goto yy902;
		} else {
			if (yych <= 's') goto yy903;
			if (yych <= 't') goto yy904;
			goto yy846;
		}
	}
yy848:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy902;
		goto yy846;
	} else {
		if (yych <= 'r') goto yy902;
		if (yych <= 's') goto yy903;
		if (yych <= 't') goto yy904;
		goto yy846;
	}
yy849:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy50;
		if (yych <= '0') goto yy905;
		goto yy906;
	} else {
		if (yych <= '3') goto yy907;
		if (yych <= '9') goto yy848;
		goto yy50;
	}
yy850:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	switch (yych) {
		case ' ': goto yy170;
		case 'D':
		case 'd': goto yy172;
		case 'F':
		case 'f': goto yy173;
		case 'H':
		case 'h': goto yy68;
		case 'M':
		case 'm': goto yy174;
		case 'S':
		case 's': goto yy175;
		case 'T': goto yy908;
		case 'W':
		case 'w': goto yy78;
		case 'Y':
		case 'y': goto yy80;
		case 't': goto yy909;
		default: goto yy851;
	}
yy851:
#line 1152 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 12673 "real_world/parse_date_b.c"
yy852:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy910;
	if (yych <= '2') goto yy911;
	if (yych <= '3') goto yy912;
	goto yy50;
yy853:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy667;
	if (yych == 'l') goto yy667;
	goto yy50;
yy854:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy913;
	if (yych == 's') goto yy913;
	goto yy50;
yy855:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy859;
	if (yych == 'm') goto yy859;
	goto yy50;
yy856:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy857;
	if (yych != 'u') goto yy50;
yy857:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy914;
	if (yych == 'a') goto yy914;
	goto yy50;
yy858:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy667;
	if (yych == 'h') goto yy667;
	goto yy50;
yy859:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy915;
	if (yych == 'b') goto yy915;
	goto yy50;
yy860:
	++YYCURSOR;
#line 1201 "real_world/parse_date_b.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 12735 "real_world/parse_date_b.c"
yy861:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy916;
	if (yych == 'h') goto yy916;
	goto yy50;
yy862:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy917;
	goto yy50;
yy863:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy917;
	goto yy50;
yy864:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy917;
	goto yy50;
yy865:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy866;
	if (yych <= '9') goto yy918;
yy866:
#line 1239 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 12773 "real_world/parse_date_b.c"
yy867:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= '(') {
			if (yych == ' ') goto yy919;
			if (yych <= '\'') goto yy578;
			goto yy920;
		} else {
			if (yych == '+') goto yy921;
			if (yych <= ',') goto yy578;
			goto yy921;
		}
	} else {
		if (yych <= '@') {
			if (yych <= '.') goto yy702;
			if (yych == ':') goto yy702;
			goto yy578;
		} else {
			if (yych <= 'Z') goto yy922;
			if (yych <= '`') goto yy578;
			if (yych <= 'z') goto yy923;
			goto yy578;
		}
	}
yy868:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '+') {
		if (yych <= '\'') {
			if (yych == ' ') goto yy919;
			goto yy578;
		} else {
			if (yych <= '(') goto yy920;
			if (yych <= '*') goto yy578;
			goto yy921;
		}
	} else {
		if (yych <= '@') {
			if (yych == '-') goto yy921;
			goto yy578;
		} else {
			if (yych <= 'Z') goto yy922;
			if (yych <= '`') goto yy578;
			if (yych <= 'z') goto yy923;
			goto yy578;
		}
	}
yy869:
	++YYCURSOR;
	goto yy794;
yy870:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy924;
		if (yych <= 'M') goto yy50;
		goto yy925;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy924;
		} else {
			if (yych == 'n') goto yy925;
			goto yy50;
		}
	}
yy871:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy926;
	if (yych == 'a') goto yy926;
	goto yy50;
yy872:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy927;
	if (yych == 't') goto yy927;
	goto yy50;
yy873:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy793;
	if (yych == 'h') goto yy793;
	goto yy50;
yy874:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy877;
	if (yych == 'r') goto yy877;
	goto yy50;
yy875:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy928;
	if (yych == 'n') goto yy928;
	goto yy50;
yy876:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy877;
	if (yych != 's') goto yy50;
yy877:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy871;
	if (yych == 'd') goto yy871;
	goto yy50;
yy878:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy876;
	if (yych == 'e') goto yy876;
	goto yy50;
yy879:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy794;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy794;
		if (yych <= 'z') goto yy551;
		goto yy794;
	}
yy880:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy924;
		if (yych <= 'M') goto yy552;
		goto yy925;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy552;
			goto yy929;
		} else {
			if (yych == 'n') goto yy930;
			goto yy552;
		}
	}
yy881:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy926;
	if (yych == 'a') goto yy931;
	goto yy552;
yy882:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy927;
	if (yych == 't') goto yy932;
	goto yy552;
yy883:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy793;
	if (yych == 'h') goto yy806;
	goto yy552;
yy884:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy877;
	if (yych == 'r') goto yy887;
	goto yy552;
yy885:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy928;
	if (yych == 'n') goto yy933;
	goto yy552;
yy886:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy877;
	if (yych != 's') goto yy552;
yy887:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy871;
	if (yych == 'd') goto yy881;
	goto yy552;
yy888:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy876;
	if (yych == 'e') goto yy886;
	goto yy552;
yy889:
	++YYCURSOR;
yy890:
#line 894 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12959 "real_world/parse_date_b.c"
yy891:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy890;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy890;
		if (yych <= 'z') goto yy551;
		goto yy890;
	}
yy892:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy934;
	if (yych == 'y') goto yy934;
	goto yy50;
yy893:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy934;
	if (yych == 'y') goto yy936;
	goto yy552;
yy894:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy937;
	goto yy50;
yy895:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy938;
	if (yych <= '2') goto yy939;
	if (yych <= '9') goto yy940;
	goto yy50;
yy896:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy941;
	goto yy50;
yy897:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy941;
	goto yy50;
yy898:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy941;
	goto yy50;
yy899:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy468;
			if (yych <= '0') goto yy831;
			goto yy942;
		} else {
			if (yych == 'T') goto yy895;
			goto yy468;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy896;
			if (yych <= 'q') goto yy468;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy468;
		}
	}
yy900:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy468;
			goto yy942;
		} else {
			if (yych == 'T') goto yy895;
			goto yy468;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy896;
			if (yych <= 'q') goto yy468;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy468;
		}
	}
yy901:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy468;
			goto yy942;
		} else {
			if (yych == 'T') goto yy895;
			goto yy468;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy896;
			if (yych <= 'q') goto yy468;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy468;
		}
	}
yy902:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy943;
	goto yy50;
yy903:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy943;
	goto yy50;
yy904:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy943;
	goto yy50;
yy905:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '0') {
			if (yych <= '/') goto yy846;
			goto yy848;
		} else {
			if (yych <= '9') goto yy944;
			if (yych <= 'm') goto yy846;
			goto yy902;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy846;
			goto yy902;
		} else {
			if (yych <= 's') goto yy903;
			if (yych <= 't') goto yy904;
			goto yy846;
		}
	}
yy906:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy846;
		if (yych <= '9') goto yy944;
		if (yych <= 'm') goto yy846;
		goto yy902;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy846;
			goto yy902;
		} else {
			if (yych <= 's') goto yy903;
			if (yych <= 't') goto yy904;
			goto yy846;
		}
	}
yy907:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy846;
		if (yych <= '1') goto yy944;
		if (yych <= 'm') goto yy846;
		goto yy902;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy846;
			goto yy902;
		} else {
			if (yych <= 's') goto yy903;
			if (yych <= 't') goto yy904;
			goto yy846;
		}
	}
yy908:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy50;
			if (yych <= '1') goto yy945;
			goto yy946;
		} else {
			if (yych <= '9') goto yy947;
			if (yych <= 'G') goto yy50;
			goto yy230;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy231;
			goto yy50;
		} else {
			if (yych <= 'h') goto yy230;
			if (yych == 'u') goto yy231;
			goto yy50;
		}
	}
yy909:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy50;
			if (yych <= '1') goto yy948;
			goto yy949;
		} else {
			if (yych <= '9') goto yy950;
			if (yych <= 'G') goto yy50;
			goto yy230;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy231;
			goto yy50;
		} else {
			if (yych <= 'h') goto yy230;
			if (yych == 'u') goto yy231;
			goto yy50;
		}
	}
yy910:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy951;
	goto yy50;
yy911:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy951;
	goto yy50;
yy912:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy951;
	goto yy50;
yy913:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy667;
	if (yych == 't') goto yy667;
	goto yy50;
yy914:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy952;
	if (yych == 'r') goto yy952;
	goto yy50;
yy915:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy953;
	if (yych == 'e') goto yy953;
	goto yy50;
yy916:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy356;
	if (yych == 't') goto yy356;
	goto yy50;
yy917:
	++YYCURSOR;
#line 1252 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 13236 "real_world/parse_date_b.c"
yy918:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy866;
	if (yych <= '9') goto yy954;
	goto yy866;
yy919:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= '+') {
		if (yych <= '\'') {
			if (yych == ' ') goto yy919;
			goto yy50;
		} else {
			if (yych <= '(') goto yy920;
			if (yych <= '*') goto yy50;
			goto yy921;
		}
	} else {
		if (yych <= '@') {
			if (yych == '-') goto yy921;
			goto yy50;
		} else {
			if (yych <= 'Z') goto yy922;
			if (yych <= '`') goto yy50;
			if (yych <= 'z') goto yy923;
			goto yy50;
		}
	}
yy920:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy50;
	if (yych <= 'Z') goto yy923;
	if (yych <= '`') goto yy50;
	if (yych <= 'z') goto yy923;
	goto yy50;
yy921:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy955;
	if (yych <= '2') goto yy956;
	if (yych <= '9') goto yy957;
	goto yy50;
yy922:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy792;
		goto yy578;
	} else {
		if (yych <= 'Z') goto yy958;
		if (yych <= '`') goto yy578;
		if (yych <= 'z') goto yy959;
		goto yy578;
	}
yy923:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy792;
		goto yy578;
	} else {
		if (yych <= 'Z') goto yy958;
		if (yych <= '`') goto yy578;
		if (yych <= 'z') goto yy958;
		goto yy578;
	}
yy924:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy925;
	if (yych != 'n') goto yy50;
yy925:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy960;
	if (yych == 'i') goto yy960;
	goto yy50;
yy926:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy869;
	if (yych == 'y') goto yy869;
	goto yy50;
yy927:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy793;
	if (yych == 'e') goto yy793;
	goto yy50;
yy928:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy793;
	if (yych == 'd') goto yy793;
	goto yy50;
yy929:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy925;
	if (yych != 'n') goto yy552;
yy930:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy960;
	if (yych == 'i') goto yy961;
	goto yy552;
yy931:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy869;
	if (yych == 'y') goto yy879;
	goto yy552;
yy932:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy793;
	if (yych == 'e') goto yy806;
	goto yy552;
yy933:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy793;
	if (yych == 'd') goto yy806;
	goto yy552;
yy934:
	++YYCURSOR;
yy935:
#line 851 "real_world/parse_date_b.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13364 "real_world/parse_date_b.c"
yy936:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy253;
		goto yy935;
	} else {
		if (yych <= '_') goto yy253;
		if (yych <= '`') goto yy935;
		if (yych <= 'z') goto yy551;
		goto yy935;
	}
yy937:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy962;
	goto yy50;
yy938:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy940;
	if (yych <= ':') goto yy963;
	goto yy50;
yy939:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy940;
	if (yych == ':') goto yy963;
	goto yy50;
yy940:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy963;
	goto yy50;
yy941:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy895;
	goto yy468;
yy942:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy964;
		if (yych <= 'm') goto yy846;
		goto yy896;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy846;
			goto yy896;
		} else {
			if (yych <= 's') goto yy897;
			if (yych <= 't') goto yy898;
			goto yy846;
		}
	}
yy943:
	++YYCURSOR;
	goto yy846;
yy944:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy943;
		if (yych <= 'm') goto yy846;
		goto yy902;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy846;
			goto yy902;
		} else {
			if (yych <= 's') goto yy903;
			if (yych <= 't') goto yy904;
			goto yy846;
		}
	}
yy945:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy965;
	if (yych <= '9') goto yy947;
	if (yych <= ':') goto yy966;
	goto yy50;
yy946:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy50;
		if (yych <= '3') goto yy965;
		goto yy967;
	} else {
		if (yych == ':') goto yy966;
		goto yy50;
	}
yy947:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy967;
	if (yych == ':') goto yy966;
	goto yy50;
yy948:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy968;
	if (yych <= '9') goto yy950;
	goto yy50;
yy949:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy968;
	if (yych <= '5') goto yy967;
	goto yy50;
yy950:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy967;
	goto yy50;
yy951:
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy969;
	goto yy50;
yy952:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy667;
	if (yych == 'y') goto yy667;
	goto yy50;
yy953:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy667;
	if (yych == 'r') goto yy667;
	goto yy50;
yy954:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy866;
	if (yych <= '9') goto yy970;
	goto yy866;
yy955:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '9') goto yy957;
	if (yych <= ':') goto yy971;
	goto yy578;
yy956:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy578;
		if (yych >= '4') goto yy972;
	} else {
		if (yych <= '9') goto yy792;
		if (yych <= ':') goto yy971;
		goto yy578;
	}
yy957:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '5') goto yy972;
	if (yych <= '9') goto yy792;
	if (yych <= ':') goto yy971;
	goto yy578;
yy958:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy792;
		goto yy578;
	} else {
		if (yych <= 'Z') goto yy973;
		if (yych <= '`') goto yy578;
		if (yych <= 'z') goto yy973;
		goto yy578;
	}
yy959:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy578;
			goto yy792;
		} else {
			if (yych == '/') goto yy974;
			goto yy578;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy973;
			if (yych <= '^') goto yy578;
			goto yy974;
		} else {
			if (yych <= '`') goto yy578;
			if (yych <= 'z') goto yy975;
			goto yy578;
		}
	}
yy960:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy976;
	if (yych == 'g') goto yy976;
	goto yy50;
yy961:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy976;
	if (yych == 'g') goto yy977;
	goto yy552;
yy962:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy978;
	if (yych <= '2') goto yy979;
	goto yy50;
yy963:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy980;
	if (yych <= '9') goto yy981;
	goto yy50;
yy964:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy982;
	if (yych <= '2') goto yy983;
	if (yych <= '9') goto yy940;
	goto yy50;
yy965:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy984;
	if (yych <= '9') goto yy985;
	if (yych >= ';') goto yy50;
yy966:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy986;
	goto yy50;
yy967:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy985;
	goto yy50;
yy968:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy984;
	if (yych <= '9') goto yy985;
	goto yy50;
yy969:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy987;
	if (yych <= '2') goto yy988;
	goto yy50;
yy970:
	++YYCURSOR;
	goto yy866;
yy971:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '5') goto yy972;
	if (yych <= '9') goto yy792;
	goto yy578;
yy972:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy578;
	if (yych <= '9') goto yy792;
	goto yy578;
yy973:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy792;
		goto yy578;
	} else {
		if (yych <= 'Z') goto yy989;
		if (yych <= '`') goto yy578;
		if (yych <= 'z') goto yy989;
		goto yy578;
	}
yy974:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy50;
	if (yych <= 'Z') goto yy990;
	goto yy50;
yy975:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy578;
			goto yy792;
		} else {
			if (yych == '/') goto yy974;
			goto yy578;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy989;
			if (yych <= '^') goto yy578;
			goto yy974;
		} else {
			if (yych <= '`') goto yy578;
			if (yych <= 'z') goto yy991;
			goto yy578;
		}
	}
yy976:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy992;
	if (yych == 'h') goto yy992;
	goto yy50;
yy977:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy992;
	if (yych == 'h') goto yy993;
	goto yy552;
yy978:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy994;
	goto yy50;
yy979:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy994;
	goto yy50;
yy980:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy981;
	if (yych <= ':') goto yy995;
	goto yy50;
yy981:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy995;
	goto yy50;
yy982:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy996;
	if (yych <= ':') goto yy963;
	goto yy50;
yy983:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy996;
	if (yych == ':') goto yy963;
	goto yy50;
yy984:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy995;
	if (yych <= '6') goto yy997;
	if (yych >= ':') goto yy50;
yy985:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy998;
	if (yych <= '6') goto yy999;
	goto yy50;
yy986:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1000;
	goto yy50;
yy987:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1001;
	goto yy50;
yy988:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy1001;
	goto yy50;
yy989:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy792;
	goto yy578;
yy990:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy50;
	if (yych <= 'z') goto yy1002;
	goto yy50;
yy991:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy792;
		if (yych <= '.') goto yy578;
		goto yy974;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy578;
			goto yy974;
		} else {
			if (yych <= '`') goto yy578;
			if (yych <= 'z') goto yy1003;
			goto yy578;
		}
	}
yy992:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy793;
	if (yych == 't') goto yy793;
	goto yy50;
yy993:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy793;
	if (yych == 't') goto yy806;
	goto yy552;
yy994:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1004;
	goto yy50;
yy995:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1005;
	if (yych <= '6') goto yy1007;
	if (yych <= '9') goto yy1008;
	goto yy50;
yy996:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1009;
	goto yy50;
yy997:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy1005;
	if (yych <= '5') goto yy998;
	if (yych <= '6') goto yy999;
	goto yy50;
yy998:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1008;
	goto yy50;
yy999:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1008;
	goto yy50;
yy1000:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy985;
	goto yy50;
yy1001:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy966;
	goto yy50;
yy1002:
	yyaccept = 16;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy974;
		goto yy578;
	} else {
		if (yych <= '_') goto yy974;
		if (yych <= '`') goto yy578;
		if (yych <= 'z') goto yy1002;
		goto yy578;
	}
yy1003:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy974;
		goto yy50;
	} else {
		if (yych <= '_') goto yy974;
		if (yych <= '`') goto yy50;
		if (yych <= 'z') goto yy1003;
		goto yy50;
	}
yy1004:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1010;
	goto yy50;
yy1005:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1006;
	if (yych <= '9') goto yy1008;
yy1006:
#line 1164 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 13871 "real_world/parse_date_b.c"
yy1007:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1006;
yy1008:
	++YYCURSOR;
	goto yy1006;
yy1009:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1011;
	if (yych <= '9') goto yy981;
	goto yy50;
yy1010:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1012;
	goto yy50;
yy1011:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1013;
	if (yych <= ':') goto yy995;
	goto yy50;
yy1012:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1014;
	goto yy50;
yy1013:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1015;
	goto yy50;
yy1014:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1016;
	if (yych <= '6') goto yy1017;
	goto yy50;
yy1015:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1018;
	if (yych <= '6') goto yy1019;
	if (yych <= '9') goto yy1008;
	goto yy50;
yy1016:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1020;
	goto yy50;
yy1017:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1020;
	goto yy50;
yy1018:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1006;
	if (yych <= '9') goto yy1021;
	goto yy1006;
yy1019:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1021;
	goto yy1006;
yy1020:
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1022;
	goto yy50;
yy1021:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1023;
	goto yy1006;
yy1022:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych == ' ') goto yy1022;
		goto yy50;
	} else {
		if (yych == ',') goto yy50;
		if (yych <= '-') goto yy1024;
		goto yy50;
	}
yy1023:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1025;
	goto yy50;
yy1024:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1026;
	if (yych <= '2') goto yy1028;
	if (yych <= '9') goto yy1029;
	goto yy50;
yy1025:
	yyaccept = 26;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy1030;
		goto yy1006;
	} else {
		if (yych <= '-') goto yy1030;
		if (yych <= '/') goto yy1006;
		if (yych <= '9') goto yy1025;
		goto yy1006;
	}
yy1026:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1027;
	if (yych <= '9') goto yy1029;
	if (yych <= ':') goto yy1031;
yy1027:
#line 1265 "real_world/parse_date_b.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 14005 "real_world/parse_date_b.c"
yy1028:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1027;
		if (yych >= '4') goto yy1032;
	} else {
		if (yych <= '9') goto yy1033;
		if (yych <= ':') goto yy1031;
		goto yy1027;
	}
yy1029:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1027;
	if (yych <= '5') goto yy1032;
	if (yych <= '9') goto yy1033;
	if (yych <= ':') goto yy1031;
	goto yy1027;
yy1030:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1034;
	if (yych <= '2') goto yy1035;
	if (yych <= '9') goto yy1036;
	goto yy50;
yy1031:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1027;
	if (yych <= '5') goto yy1032;
	if (yych <= '9') goto yy1033;
	goto yy1027;
yy1032:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1027;
	if (yych >= ':') goto yy1027;
yy1033:
	++YYCURSOR;
	goto yy1027;
yy1034:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1006;
	if (yych <= '9') goto yy1036;
	if (yych <= ':') goto yy1037;
	goto yy1006;
yy1035:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1006;
		if (yych >= '4') goto yy1005;
	} else {
		if (yych <= '9') goto yy1008;
		if (yych <= ':') goto yy1037;
		goto yy1006;
	}
yy1036:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1006;
	if (yych <= '5') goto yy1005;
	if (yych <= '9') goto yy1008;
	if (yych >= ';') goto yy1006;
yy1037:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1006;
	if (yych <= '5') goto yy1005;
	if (yych <= '9') goto yy1008;
	goto yy1006;
}
#line 1412 "real_world/parse_date_b.re"

}

#line 14076 "real_world/parse_date_b.c"
#define YYMAXFILL 26
#line 1415 "real_world/parse_date_b.re"


timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
