#!/bin/sh
file=$1

if [ x$file = x ]; then
	echo "Usage: $0 <audio file path> [audio output index]"
	echo "  Default audio output index: 0"
	exit 1
fi

if [ ! -f $file ]; then
	echo "File $file not found"
	exit 1
fi

let idx=$2+0;

device=`aplay -l | sed -n 's/^\s*card\s*\([0-9]\+\):.*\[Microchip[^]]*\],\s*device\s*\([0-9]\+\):\s*tx'$idx'\s\+.*$/hw:\1,\2/p'`

if [ x$device = x ]; then
	echo "Audio output $idx not found"
	exit 1
fi

echo "Audio file  : $file"
echo "Output index: $idx"
echo "ALSA device : $device"

gst-launch-1.0 filesrc location=$file ! decodebin ! audioconvert ! audioresample ! alsasink device=$device
