#!/bin/sh
# Write OTP memory first 6 bytes of BANK#1 with randomly generated ID
#
# usage: otp_write
# example: otp_write

dev=/dev/video0

ov10640_read() {
    let high=$1/256
    let low=$1%256
    v4l2-dbg -d $dev -c subdev0 -s 0xfffd 0x80  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xfffe 0x19  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5000 0x1   | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5001 $high | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5002 $low  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xfffe 0x80  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xc0 0xc1    | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xfffe 0x19  | exit
    v4l2-dbg -d $dev -c subdev0 -g 0x5000
}

ov10640_write() {
    let high=$1/256
    let low=$1%256
    let val=$2

    v4l2-dbg -d $dev -c subdev0 -s 0xfffd 0x80  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xfffe 0x19  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5000 0x0   | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5001 $high | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5002 $low  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0x5003 $val  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xfffe 0x80  | exit
    v4l2-dbg -d $dev -c subdev0 -s 0xc0 0xc1    | exit
}

########## VERIFY OTP MEMORY IS ZERO (NOT PROGRAMMED) ##########

for i in `seq 0 5`;
do
    let kk=0x34ae+$i
    ov10640_write $kk 0x0
done

# set range
ov10640_write 0x3496 0x0
ov10640_write 0x3497 0x5
# set bank1
ov10640_write 0x3495 0x41
# read strobe
ov10640_write 0x349c 0x1
sleep 1

for i in `seq 0 5`;
do
    let kk=0x34ae+$i
    val=$(ov10640_read $kk | grep "5000 =" | cut -c23-24 | xargs printf "%s\n")
    if [ "$val" != "0h" ]; then
        echo "OTP memory is not zero. Exit programming!"
        exit 1
    fi
done


########## PROGRAM OTP MEMORY ##########

# non-program state (deselect banks)
ov10640_write 0x3495 0x00

# clear OTP buffer (6 bytes)
for i in `seq 0 5`;
do
    let kk=0x34ae+$i
    ov10640_write $kk 0x0
done

# write OTP buffer (6 bytes) with random data
for i in `seq 0 5`;
do
    let adr=0x34ae+$i
    let val=$(cat /proc/interrupts | sha1sum | cut -c1-2 | xargs printf "0x%s\n")
    ov10640_write $adr $val
done

# set range 0-5 (6 bytes)
ov10640_write 0x3496 0x0
ov10640_write 0x3497 0x5
# set bank1
ov10640_write 0x3495 0x41
# program strobe
ov10640_write 0x349b 0x1
sleep 1

echo "Done"
