export sites="gotest.tools/v3:gotest.tools/v3:force \
           go.uber.org/mock:go.uber.org/mock:force \
           golang.org/x/net:golang.org/x/net:force \
           golang.org/x/sys:golang.org/x/sys:force \
           gopkg.in/yaml.v3:gopkg.in/yaml.v3:force \
           go.opencensus.io:go.opencensus.io:force \
           golang.org/x/exp:golang.org/x/exp:force \
           golang.org/x/mod:golang.org/x/mod:force \
           golang.org/x/sync:golang.org/x/sync:force \
           golang.org/x/term:golang.org/x/term:force \
           golang.org/x/text:golang.org/x/text:force \
           golang.org/x/tools:golang.org/x/tools:force \
           golang.org/x/crypto:golang.org/x/crypto:force \
           github.com/moby/term:github.com/moby/term:force \
           go.mozilla.org/pkcs7:go.mozilla.org/pkcs7:force \
           github.com/docker/cli:github.com/docker/cli:force \
           github.com/pkg/errors:github.com/pkg/errors:force \
           github.com/fatih/color:github.com/fatih/color:force \
           github.com/ipfs/go-cid:github.com/ipfs/go-cid:force \
           github.com/spf13/cobra:github.com/spf13/cobra:force \
           github.com/spf13/pflag:github.com/spf13/pflag:force \
           github.com/cilium/ebpf:github.com/cilium/ebpf:force \
           github.com/google/uuid:github.com/google/uuid:force \
           github.com/moby/locker:github.com/moby/locker:force \
           google.golang.org/grpc:google.golang.org/grpc:force \
           github.com/go-logr/logr:github.com/go-logr/logr:force \
           github.com/go-logr/stdr:github.com/go-logr/stdr:force \
           github.com/miekg/pkcs11:github.com/miekg/pkcs11:force \
           github.com/tinylib/msgp:github.com/tinylib/msgp:force \
           lukechampine.com/blake3:lukechampine.com/blake3:force \
           github.com/docker/docker:github.com/docker/docker:force \
           github.com/tidwall/gjson:github.com/tidwall/gjson:force \
           github.com/gogo/protobuf:github.com/gogo/protobuf:force \
           github.com/google/go-cmp:github.com/google/go-cmp:force \
           github.com/imdario/mergo:github.com/imdario/mergo:force \
           github.com/philhofer/fwd:github.com/philhofer/fwd:force \
           github.com/tidwall/match:github.com/tidwall/match:force \
           go.opentelemetry.io/otel:go.opentelemetry.io/otel:force \
           github.com/containerd/log:github.com/containerd/log:force \
           github.com/djherbis/times:github.com/djherbis/times:force \
           github.com/godbus/dbus/v5:github.com/godbus/dbus/v5:force \
           github.com/mr-tron/base58:github.com/mr-tron/base58:force \
           github.com/tidwall/pretty:github.com/tidwall/pretty:force \
           github.com/containerd/fifo:github.com/containerd/fifo:force \
           github.com/docker/go-units:github.com/docker/go-units:force \
           github.com/mattn/go-isatty:github.com/mattn/go-isatty:force \
           github.com/yuchanns/srslog:github.com/yuchanns/srslog:force \
           github.com/golang/protobuf:github.com/golang/protobuf:force \
           github.com/sirupsen/logrus:github.com/sirupsen/logrus:force \
           google.golang.org/genproto:google.golang.org/genproto:force \
           google.golang.org/protobuf:google.golang.org/protobuf:force \
           github.com/moby/sys/user:github.com/moby/sys/user/user:force \
           github.com/bmizerany/assert:github.com/bmizerany/assert:force \
           github.com/containerd/ttrpc:github.com/containerd/ttrpc:force \
           github.com/docker/go-events:github.com/docker/go-events:force \
           github.com/vbatts/tar-split:github.com/vbatts/tar-split:force \
           github.com/Microsoft/hcsshim:github.com/Microsoft/hcsshim:force \
           github.com/containerd/go-cni:github.com/containerd/go-cni:force \
           github.com/moby/sys/mount:github.com/moby/sys/mount/mount:force \
           github.com/vishvananda/netns:github.com/vishvananda/netns:force \
           github.com/Azure/go-ansiterm:github.com/Azure/go-ansiterm:force \
           github.com/felixge/httpsnoop:github.com/felixge/httpsnoop:force \
           github.com/golang/groupcache:github.com/golang/groupcache:force \
           github.com/hashicorp/errwrap:github.com/hashicorp/errwrap:force \
           github.com/minio/sha256-simd:github.com/minio/sha256-simd:force \
           github.com/pelletier/go-toml:github.com/pelletier/go-toml:force \
           github.com/spaolacci/murmur3:github.com/spaolacci/murmur3:force \
           github.com/Microsoft/go-winio:github.com/Microsoft/go-winio:force \
           github.com/containerd/console:github.com/containerd/console:force \
           github.com/coreos/go-iptables:github.com/coreos/go-iptables:force \
           github.com/containerd/cgroups:github.com/containerd/cgroups:force \
           github.com/containerd/go-runc:github.com/containerd/go-runc:force \
           github.com/containerd/typeurl:github.com/containerd/typeurl:force \
           github.com/go-jose/go-jose/v3:github.com/go-jose/go-jose/v3:force \
           github.com/klauspost/compress:github.com/klauspost/compress:force \
           github.com/klauspost/cpuid/v2:github.com/klauspost/cpuid/v2:force \
           github.com/mattn/go-colorable:github.com/mattn/go-colorable:force \
           github.com/moby/sys/signal:github.com/moby/sys/signal/signal:force \
           github.com/containerd/imgcrypt:github.com/containerd/imgcrypt:force \
           github.com/muesli/cancelreader:github.com/muesli/cancelreader:force \
           github.com/vishvananda/netlink:github.com/vishvananda/netlink:force \
           github.com/containers/ocicrypt:github.com/containers/ocicrypt:force \
           github.com/mattn/go-shellwords:github.com/mattn/go-shellwords:force \
           github.com/containerd/platforms:github.com/containerd/platforms:force \
           github.com/pelletier/go-toml/v2:github.com/pelletier/go-toml/v2:force \
           github.com/mitchellh/go-homedir:github.com/mitchellh/go-homedir:force \
           github.com/moby/sys/symlink:github.com/moby/sys/symlink/symlink:force \
           github.com/xeipuuv/gojsonschema:github.com/xeipuuv/gojsonschema:force \
           github.com/Masterminds/semver/v3:github.com/Masterminds/semver/v3:force \
           github.com/containerd/cgroups/v3:github.com/containerd/cgroups/v3:force \
           github.com/containerd/containerd:github.com/containerd/containerd:force \
           github.com/containerd/continuity:github.com/containerd/continuity:force \
           github.com/containerd/typeurl/v2:github.com/containerd/typeurl/v2:force \
           github.com/coreos/go-systemd/v22:github.com/coreos/go-systemd/v22:force \
           github.com/docker/go-connections:github.com/docker/go-connections:force \
           github.com/xeipuuv/gojsonpointer:github.com/xeipuuv/gojsonpointer:force \
           github.com/fahedouch/go-logrotate:github.com/fahedouch/go-logrotate:force \
           github.com/mitchellh/mapstructure:github.com/mitchellh/mapstructure:force \
           github.com/distribution/reference:github.com/distribution/reference:force \
           github.com/multiformats/go-base32:github.com/multiformats/go-base32:force \
           github.com/multiformats/go-base36:github.com/multiformats/go-base36:force \
           github.com/multiformats/go-varint:github.com/multiformats/go-varint:force \
           github.com/opencontainers/selinux:github.com/opencontainers/selinux:force \
           go.opentelemetry.io/otel/trace:go.opentelemetry.io/otel/trace/trace:force \
           github.com/compose-spec/compose-go:github.com/compose-spec/compose-go:force \
           github.com/containernetworking/cni:github.com/containernetworking/cni:force \
           github.com/hashicorp/go-multierror:github.com/hashicorp/go-multierror:force \
           github.com/moby/sys/mountinfo:github.com/moby/sys/mountinfo/mountinfo:force \
           github.com/xeipuuv/gojsonreference:github.com/xeipuuv/gojsonreference:force \
           go.opentelemetry.io/otel/metric:go.opentelemetry.io/otel/metric/metric:force \
           github.com/awslabs/soci-snapshotter:github.com/awslabs/soci-snapshotter:force \
           github.com/opencontainers/go-digest:github.com/opencontainers/go-digest:force \
           github.com/moby/sys/sequential:github.com/moby/sys/sequential/sequential:force \
           github.com/opencontainers/image-spec:github.com/opencontainers/image-spec:force \
           github.com/AdaLogics/go-fuzz-headers:github.com/AdaLogics/go-fuzz-headers:force \
           github.com/inconshreveable/mousetrap:github.com/inconshreveable/mousetrap:force \
           github.com/multiformats/go-multiaddr:github.com/multiformats/go-multiaddr:force \
           github.com/multiformats/go-multibase:github.com/multiformats/go-multibase:force \
           github.com/multiformats/go-multihash:github.com/multiformats/go-multihash:force \
           github.com/stefanberger/go-pkcs11uri:github.com/stefanberger/go-pkcs11uri:force \
           github.com/cyphar/filepath-securejoin:github.com/cyphar/filepath-securejoin:force \
           github.com/containernetworking/plugins:github.com/containernetworking/plugins:force \
           github.com/fluent/fluent-logger-golang:github.com/fluent/fluent-logger-golang:force \
           github.com/opencontainers/runtime-spec:github.com/opencontainers/runtime-spec:force \
           github.com/AdamKorcz/go-118-fuzz-build:github.com/AdamKorcz/go-118-fuzz-build:force \
           github.com/containerd/nydus-snapshotter:github.com/containerd/nydus-snapshotter:force \
           github.com/containerd/stargz-snapshotter:github.com/containerd/stargz-snapshotter:force \
           github.com/rootless-containers/bypass4netns:github.com/rootless-containers/bypass4netns:force \
           github.com/docker/docker-credential-helpers:github.com/docker/docker-credential-helpers:force \
           github.com/rootless-containers/rootlesskit/v2:github.com/rootless-containers/rootlesskit/v2:force \
           github.com/containerd/stargz-snapshotter/ipfs:github.com/containerd/stargz-snapshotter/ipfs/ipfs:force \
           google.golang.org/genproto/googleapis/rpc:google.golang.org/genproto/googleapis/rpc/googleapis/rpc:force \
           github.com/containerd/accelerated-container-image:github.com/containerd/accelerated-container-image:force \
           github.com/containerd/stargz-snapshotter/estargz:github.com/containerd/stargz-snapshotter/estargz/estargz:force \
           go.opentelemetry.io/contrib/instrumentation/net/http/otelhttp:go.opentelemetry.io/contrib/instrumentation/net/http/otelhttp/instrumentation/net/http/otelhttp:force"

do_compile:prepend() {
    cd ${S}/src/import
    for s in $sites; do
        site_dest=$(echo $s | cut -d: -f1)
        site_source=$(echo $s | cut -d: -f2)
        force_flag=$(echo $s | cut -d: -f3)
        mkdir -p vendor.copy/$site_dest
        if [ -n "$force_flag" ]; then
            echo "[INFO] $site_dest: force copying .go files"
            rm -rf vendor.copy/$site_dest
            rsync -a --exclude='vendor/' --exclude='.git/' vendor.fetch/$site_source/ vendor.copy/$site_dest
        else
            [ -n "$(ls -A vendor.copy/$site_dest/*.go 2> /dev/null)" ] && { echo "[INFO] vendor.fetch/$site_source -> $site_dest: go copy skipped (files present)" ; true ; } || { echo "[INFO] $site_dest: copying .go files" ; rsync -a --exclude='vendor/' --exclude='.git/' vendor.fetch/$site_source/ vendor.copy/$site_dest ; }
        fi
    done
}
