# fsl-eula-unpack.bbclass provides the mechanism used for unpacking
# the .bin file downloaded by HTTP and handle the EULA acceptance.
#
# To use it, the 'fsl-eula' parameter needs to be added to the
# SRC_URI entry, e.g:
#
#  SRC_URI = "${FSL_MIRROR}/firmware-imx-${PV};fsl-eula=true"

FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V8          = "01ba08a2b77c3a0a9d0ab5d4d83fed64"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V10         = "3880bb9c943b135a30fad5e8aabd3ee9"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V11         = "a31dce3023402a821cfcdc1bb8dbdbc0"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V12         = "8cf95184c220e247b9917e7244124c5a"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V13         = "102094e9e695888c6a9f9fda9004165d"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V14         = "d4f548f93b5fe0ee2bc86758c344412d"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V16         = "be67a88e9e6c841043b005ad7bcf8309"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V17         = "88595f92466edd79be7f4f9547ffa0ef"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V18         = "6b552f505eedab4a11ab538cf3db743a"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V20         = "08fd295cce89b0a9c74b9b83ed74f671"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V21         = "6bd2df2910a2234bf6f419b7d2f531a3"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V22         = "75abe2fa1d16ca79f87cde926f05f72d"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V24         = "ab61cab9599935bfe9f700405ef00f28"
FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V26         = "5ab1a30d0cd181e3408077727ea5a2db"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V3  = "6dfb32a488e5fd6bae52fbf6c7ebb086"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V5  = "80c0478f4339af024519b3723023fe28"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V7  = "fb0303e4ee8b0e71c094171e2272bd44"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V8  = "72c0f70181bb6e83eee6aab8de12a9f3"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V9  = "6c12031a11b81db21cdfe0be88cac4b3"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V10 = "fd4b227530cd88a82af6a5982cfb724d"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V11 = "228c72f2a91452b8a03c4cab30f30ef9"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V13 = "1b4db4b25c3a1e422c0c0ed64feb65d2"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V15 = "983e4c77621568488dd902b27e0c2143"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V16 = "e9e880185bda059c90c541d40ceca922"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V17 = "cf3f9b8d09bc3926b1004ea71f7a248a"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V18 = "231e11849a4331fcbb19d7f4aab4a659"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V19 = "a632fefd1c359980434f9389833cab3a"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V22 = "3c3fe2b904fd694f28d2f646ee16dddb"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V23 = "85d06b38f17b935ca11784d67075b846"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V24 = "417b82f17fc02b88125331ed312f6f1b"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V24.1 = "b3b0bab6ff55420d043cf1652c52d788"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V25 = "f35df765ff17e69043ea21f350e3229c"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V27 = "e565271ec9a80ce47abbddc4bffe56fa"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V29 = "28241cb895217d7946e40e7227136d02"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V30 = "03bcadc8dc0a788f66ca9e2b89f56c6f"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V31 = "dedee5689786754f61ea3a76035c8a81"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V32 = "17d2319de7baa686e8a755ba58a9ebf5"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V33 = "e4098ac4459cb81b07d3f0c22b3e8370"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V34 = "be5ff43682ed6c57dfcbeb97651c2829"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V35 = "d3c315c6eaa43e07d8c130dc3a04a011"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V36 = "b54da624b8d2ffe8a3b47757da48e60f"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V37 = "37cb2d8c2bcf8bf2fbe0366d5d928c29"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V38 = "65c483bb431ccd9a1820e6872c604771"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V39 = "5a0bf11f745e68024f37b4724a5364fe"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V40 = "add2d392714d3096ed7e0f7e2190724b"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V42 = "ea25d099982d035af85d193c88a1b479"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V44 = "d7853b7bf2936b2c25c893eac7033374"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V45 = "63a38e9f392d8813d6f1f4d0d6fbe657"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V46 = "673fa34349fa40f59e0713cb0ac22b1f"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V47 = "9135422c7a38dac21bf1f858b6ef3bac"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V48 = "db4762b09b6bda63da103963e6e081de"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V49 = "2827219e81f28aba7c6a569f7c437fa7"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V53 = "44a8052c384584ba09077e85a3d1654f"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V56 = "10c0fda810c63b052409b15a5445671a"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V57 = "ca53281cc0caa7e320d4945a896fb837"
FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V58 = "c0fb372b5d7f12181de23ef480f225f3"

FSL_EULA_FILE_MD5SUMS = " \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V8} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V10} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V11} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V12} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V13} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V14} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V16} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V17} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V18} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V20} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V21} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V22} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V24} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_BASE_LICENSE_V26} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V3} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V5} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V7} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V8} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V9} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V10} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V11} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V13} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V15} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V16} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V17} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V18} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V19} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V22} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V23} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V24} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V24.1} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V25} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V27} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V29} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V30} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V31} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V32} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V33} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V34} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V35} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V36} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V37} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V38} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V39} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V40} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V42} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V44} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V45} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V46} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V47} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V48} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V49} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V53} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V56} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V57} \
    ${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V58} \
"

# The checksum for the EULA in the layer
FSL_EULA_FILE_MD5SUM ?= \
    "${FSL_EULA_FILE_MD5SUM_LA_OPT_NXP_SOFTWARE_LICENSE_V57}"

LIC_FILES_CHKSUM_LAYER ?= "file://${FSL_EULA_FILE};md5=${FSL_EULA_FILE_MD5SUM}"
LIC_FILES_CHKSUM_LAYER[vardepsexclude] += "FSL_EULA_FILE"
LIC_FILES_CHKSUM:append = " ${LIC_FILES_CHKSUM_LAYER}"

LIC_FILES_CHKSUM[vardepsexclude] += "FSL_EULA_FILE"

do_fetch:prepend() {
    if "Proprietary" not in d.getVar("LICENSE"):
        bb.fatal("The recipe LICENSE should include Proprietary but is " + d.getVar("LICENSE") + ".")
}

do_unpack[vardepsexclude] += "FSL_EULA_FILE"
python do_unpack() {
    eula = d.getVar('ACCEPT_FSL_EULA')
    eula_file = d.getVar('FSL_EULA_FILE')
    pkg = d.getVar('PN')
    if eula == None:
        bb.fatal("To use '%s' you need to accept the Freescale EULA at '%s'. "
                 "Please read it and in case you accept it, write: "
                 "ACCEPT_FSL_EULA = \"1\" in your local.conf." % (pkg, eula_file))
    elif eula == '0':
        bb.fatal("To use '%s' you need to accept the Freescale EULA." % pkg)
    else:
        bb.note("Freescale EULA has been accepted for '%s'" % pkg)

    try:
        bb.build.exec_func('base_do_unpack', d)
    except:
        raise

    bb.build.exec_func('fsl_bin_do_unpack', d)
}

python fsl_bin_do_unpack() {
    src_uri = (d.getVar('SRC_URI') or "").split()
    if len(src_uri) == 0:
        return

    localdata = bb.data.createCopy(d)

    rootdir = localdata.getVar('WORKDIR', True)
    fetcher = bb.fetch2.Fetch(src_uri, localdata)

    found = 0
    for url in fetcher.ud.values():
        # Skip this fetcher if it's not under EULA or if the fetcher type is not supported
        if not url.parm.get('fsl-eula', False) or url.type not in ['http', 'https', 'ftp', 'file']:
            continue
        # If download has failed, do nothing
        if not os.path.exists(url.localpath):
            bb.debug(1, "Exiting as '%s' cannot be found" % url.basename)
            return
        found += 1
        bb.note("Handling file '%s' as a Freescale EULA-licensed archive." % url.basename)
        cmd = "sh %s --auto-accept --force" % (url.localpath)
        bb.fetch2.runfetchcmd(cmd, d, quiet=True, workdir=rootdir)
    if not found:
        bb.fatal("The recipe inherits 'fsl-eula-unpack.bbclass' but does not mark any URL in SRC_URI with the option 'fsl-eula=true'")

    # Check for two EULAs, one from the layer and one from the package
    bb.note("Checking LIC_FILES_CHKSUM for Freescale EULA consistency...")
    if found > 1:
        bb.warn("The package contains multiple Freescale EULA-licensed archives. The consistency logic may not be able to detect a EULA problem.")
    (layer_license, licenses, md5sums, found_layer_licenses, found_package_licenses) = find_nxp_eula_licenses(d)
    if not found_layer_licenses:
        bb.fatal("The Freescale layer EULA '%s' is not listed in LIC_FILES_CHKSUM '%s'."
                 % (layer_license, licenses))
    if not found_package_licenses:
        bb.fatal("A valid package EULA with md5sum in %s was not found in LIC_FILES_CHKSUM '%s'."
                 % (md5sums.split(), licenses))
}

def find_nxp_eula_licenses(d):
    layer_license = d.getVar('LIC_FILES_CHKSUM_LAYER')
    licenses = d.getVar('LIC_FILES_CHKSUM') or ""
    md5sums = d.getVar('FSL_EULA_FILE_MD5SUMS') or ""
    found_layer_licenses = ""
    found_package_licenses = ""
    for license in licenses.split():
        try:
            (method, host, path, user, pswd, parm) = bb.fetch.decodeurl(license)
            if method != "file" or not path:
                raise bb.fetch.MalformedUrl()
        except bb.fetch.MalformedUrl:
            bb.fatal("%s: LIC_FILES_CHKSUM contains an invalid URL:  %s" % (d.getVar('PF'), license))
        if license == layer_license:
            bb.note("Found Freescale EULA for the layer %s." % license)
            found_layer_licenses += license
        elif parm.get('md5') in md5sums:
            bb.note("Found Freescale EULA for the package %s." % license)
            found_package_licenses += license
    return (layer_license, licenses, md5sums, found_layer_licenses, found_package_licenses)
