# This file contains a list of CVE's where resolution has proven to be impractical
# or there is no reasonable action the Yocto Project can take to resolve the issue.
# It contains all the information we are aware of about an issue and analysis about
# why we believe it can't be fixed/handled. Additional information is welcome through
# patches to the file.
#
# Include this file in your local.conf or distro.conf to exclude these CVE's
# from the cve-check results or add to the bitbake command with:
#     -R conf/distro/include/cve-extra-exclusions.inc
#
# The file is not included by default since users should review this data to ensure
# it matches their expectations and usage of the project.
#
# We may also include "in-flight" information about current/ongoing CVE work with
# the aim of sharing that work and ensuring we don't duplicate it.
#

# strace https://nvd.nist.gov/vuln/detail/CVE-2000-0006
CVE_STATUS[CVE-2000-0006] = "upstream-wontfix: CVE is more than 20 years old \
with no resolution evident. Broken links in CVE database references make resolution impractical."

# epiphany https://nvd.nist.gov/vuln/detail/CVE-2005-0238
CVE_STATUS[CVE-2005-0238] = "upstream-wontfix: \
The issue here is spoofing of domain names using characters from other character sets. \
There has been much discussion amongst the epiphany and webkit developers and \
whilst there are improvements about how domains are handled and displayed to the user \
there is unlikely ever to be a single fix to webkit or epiphany which addresses this \
problem. There isn't any mitigation or fix or way to progress this further."

# glibc https://nvd.nist.gov/vuln/detail/CVE-2010-4756
CVE_STATUS[CVE-2010-4756] = "upstream-wontfix: \
Issue is memory exhaustion via glob() calls, e.g. from within an ftp server \
Best discussion in https://bugzilla.redhat.com/show_bug.cgi?id=681681 \
Upstream don't see it as a security issue, ftp servers shouldn't be passing \
this to libc glob. Upstream have no plans to add BSD's GLOB_LIMIT or similar."

# go https://nvd.nist.gov/vuln/detail/CVE-2020-29509
# go https://nvd.nist.gov/vuln/detail/CVE-2020-29511
CVE_STATUS_GROUPS += "CVE_STATUS_GO"
CVE_STATUS_GO = "CVE-2020-29509 CVE-2020-29511"
CVE_STATUS_GO[status] = "not-applicable-config: \
The encoding/xml package in go can potentially be used for security exploits if not used correctly \
CVE applies to a netapp product as well as flagging a general issue. We don't ship anything \
exposing this interface in an exploitable way"

# db
CVE_STATUS_GROUPS += "CVE_STATUS_DB"
CVE_STATUS_DB = "CVE-2015-2583 CVE-2015-2624 CVE-2015-2626 CVE-2015-2640 CVE-2015-2654 \
CVE-2015-2656 CVE-2015-4754 CVE-2015-4764 CVE-2015-4774 CVE-2015-4775 CVE-2015-4776 CVE-2015-4777 \
CVE-2015-4778 CVE-2015-4779 CVE-2015-4780 CVE-2015-4781 CVE-2015-4782 CVE-2015-4783 CVE-2015-4784 \
CVE-2015-4785 CVE-2015-4786 CVE-2015-4787 CVE-2015-4788 CVE-2015-4789 CVE-2015-4790 CVE-2016-0682 \
CVE-2016-0689 CVE-2016-0692 CVE-2016-0694 CVE-2016-3418 CVE-2020-2981"
CVE_STATUS_DB[status] = "upstream-wontfix: Since Oracle relicensed bdb, the open source community is slowly but surely \
replacing bdb with supported and open source friendly alternatives. As a result this CVE is unlikely to ever be fixed."

# Kernel CVEs that are generic but can't be added to the kernel's hand-maintained cve-exclusion.inc
# or machine-maintained cve-exclusion_VERSION.inc files, such as issues that describe TCP/IP design
# flaws or processor-specific exploits that can't be mitigated.
#
# For OE-Core our policy is to stay as close to the kernel stable releases as we can. This should
# ensure the bulk of the major kernel CVEs are fixed and we don't dive into each individual issue
# as the stable maintainers are much more able to do that.
CVE_STATUS[CVE-1999-0524] = "ignored: issue is that ICMP exists, can be filewalled if required"
CVE_STATUS[CVE-2008-4609] = "ignored: describes design flaws in TCP"
CVE_STATUS[CVE-2010-4563] = "ignored: low impact, only enables detection of hosts which are sniffing network traffic"
CVE_STATUS[CVE-2011-0640] = "ignored: requires physical access and any mitigation would mean USB is impractical to use"

# qemu:qemu-native:qemu-system-native https://nvd.nist.gov/vuln/detail/CVE-2021-20255
CVE_STATUS[CVE-2021-20255] = "upstream-wontfix: \
There was a proposed patch https://lists.gnu.org/archive/html/qemu-devel/2021-02/msg06098.html \
qemu maintainers say the patch is incorrect and should not be applied \
The issue is of low impact, at worst sitting in an infinite loop rather than exploitable."

# qemu:qemu-native:qemu-system-native https://nvd.nist.gov/vuln/detail/CVE-2019-12067
CVE_STATUS[CVE-2019-12067] = "upstream-wontfix: \
There was a proposed patch but rejected by upstream qemu. It is unclear if the issue can \
still be reproduced or where exactly any bug is. \
We'll pick up any fix when upstream accepts one."

# nasm:nasm-native https://nvd.nist.gov/vuln/detail/CVE-2020-18974
CVE_STATUS[CVE-2020-18974] = "upstream-wontfix: \
It is a fuzzing related buffer overflow. It is of low impact since most devices \
wouldn't expose an assembler. The upstream is inactive and there is little to be \
done about the bug, ignore from an OE perspective."
