// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#ifndef LISTWIDGET_TASKMENU_H
#define LISTWIDGET_TASKMENU_H

#include <QtWidgets/qlistwidget.h>
#include <QtCore/qpointer.h>

#include <qdesigner_taskmenu_p.h>
#include <extensionfactory_p.h>

QT_BEGIN_NAMESPACE

class QLineEdit;
class QDesignerFormWindowInterface;

namespace qdesigner_internal {

class ListWidgetTaskMenu: public QDesignerTaskMenu
{
    Q_OBJECT
public:
    explicit ListWidgetTaskMenu(QListWidget *button, QObject *parent = nullptr);
    ~ListWidgetTaskMenu() override;

    QAction *preferredEditAction() const override;
    QList<QAction*> taskActions() const override;

private slots:
    void editItems();
    void updateSelection();

private:
    QListWidget *m_listWidget;
    QPointer<QDesignerFormWindowInterface> m_formWindow;
    QPointer<QLineEdit> m_editor;
    mutable QList<QAction*> m_taskActions;
    QAction *m_editItemsAction;
};

using ListWidgetTaskMenuFactory = ExtensionFactory<QDesignerTaskMenuExtension, QListWidget, ListWidgetTaskMenu>;
}  // namespace qdesigner_internal

QT_END_NAMESPACE

#endif // LISTWIDGET_TASKMENU_H
