# Clocks

The `GstClock` returns a monotonically increasing time with the method
`_get_time()`. Its accuracy and base time depends on the specific clock
implementation but time is always expressed in nanoseconds. Since the
baseline of the clock is undefined, the clock time returned is not
meaningful in itself, what matters are the deltas between two clock
times. The time reported by the clock is called the `absolute_time`.

## Clock Selection

To synchronize the different elements, the `GstPipeline` is responsible
for selecting and distributing a global `GstClock` for all the elements in
it.

This selection happens whenever the pipeline goes to PLAYING. Whenever
an element is added/removed from the pipeline, this selection will be
redone in the next state change to PLAYING. Adding an element that can
provide a clock will post a `GST_MESSAGE_CLOCK_PROVIDE` message on the
bus to inform parent bins of the fact that a clock recalculation is
needed.

When a clock is selected, a `NEW_CLOCK` message is posted on the bus
signaling the clock to the application.

When the element that provided the clock is removed from the pipeline, a
`CLOCK_LOST` message is posted. The application must then set the
pipeline to PAUSED and PLAYING again in order to let the pipeline select
a new clock and distribute a new base time.

The clock selection is performed as part of the state change from PAUSED
to PLAYING and is described in [states](additional/design/states.md).

## Clock features

The clock supports periodic and single shot clock notifications both
synchronous and asynchronous.

One first needs to create a `GstClockID` for the periodic or single shot
notification using `_clock_new_single_shot_id()` or
`_clock_new_periodic_id()`.

To perform a blocking wait for the specific time of the `GstClockID` use
the `gst_clock_id_wait()`. To receive a callback when the specific time
is reached in the clock use `gstclock_id_wait_async()`. Both these
calls can be interrupted with the `gst_clock_id_unschedule()` call. If
the blocking wait is unscheduled a value of `GST_CLOCK_UNSCHEDULED` is
returned.

The async callbacks can happen from any thread, either provided by the
core or from a streaming thread. The application should be prepared for
this.

A `GstClockID` that has been unscheduled cannot be used again for any wait
operation.

It is possible to perform a blocking wait on the same ID from multiple
threads. However, registering the same ID for multiple async
notifications is not possible, the callback will only be called once.

None of the wait operations unref the `GstClockID`, the owner is
responsible for unreffing the ids itself. This holds true for both
periodic and single shot notifications. The reason being that the owner
of the ClockID has to keep a handle to the ID to unblock the wait on
FLUSHING events or state changes and if we unref it automatically, the
handle might be invalid.

These clock operations do not operate on the stream time, so the
callbacks will also occur when not in PLAYING state as if the clock just
keeps on running. Some clocks however do not progress when the element
that provided the clock is not PLAYING.

## Clock implementations

The GStreamer core provides a `GstSystemClock` based on the system time.
Asynchronous callbacks are scheduled from an internal thread.

Clock implementers are encouraged to subclass this systemclock as it
implements the async notification.

Subclasses can however override all of the important methods for sync
and async notifications to implement their own callback methods or
blocking wait operations.
