#![doc = " fiat-crypto output postprocessed by fiat-constify: https://github.com/rustcrypto/utils"]
#![doc = " Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384_scalar 32 '2^384 - 1388124618062372383947042015309946732620727252194336364173' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp"]
#![doc = " curve description: p384_scalar"]
#![doc = " machine_wordsize = 32 (from \"32\")"]
#![doc = " requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp"]
#![doc = " m = 0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973 (from \"2^384 - 1388124618062372383947042015309946732620727252194336364173\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in"]
#![doc = "                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    dead_code,
    rustdoc::bare_urls,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p384_scalar_u1 = u8;
pub type fiat_p384_scalar_i1 = i8;
pub type fiat_p384_scalar_u2 = u8;
pub type fiat_p384_scalar_i2 = i8;
pub type fiat_p384_scalar_montgomery_domain_field_element = [u32; 12];
pub type fiat_p384_scalar_non_montgomery_domain_field_element = [u32; 12];
#[doc = " The function fiat_p384_scalar_addcarryx_u32 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^32"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_scalar_addcarryx_u32(
    arg1: fiat_p384_scalar_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p384_scalar_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p384_scalar_u1 = 0;
    let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: fiat_p384_scalar_u1 = ((x1 >> 32) as fiat_p384_scalar_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_scalar_subborrowx_u32 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^32"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_scalar_subborrowx_u32(
    arg1: fiat_p384_scalar_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p384_scalar_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p384_scalar_u1 = 0;
    let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
    let x2: fiat_p384_scalar_i1 = ((x1 >> 32) as fiat_p384_scalar_i1);
    let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
    out1 = x3;
    out2 = (((0x0 as fiat_p384_scalar_i2) - (x2 as fiat_p384_scalar_i2)) as fiat_p384_scalar_u1);
    (out1, out2)
}
#[doc = " The function fiat_p384_scalar_mulx_u32 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^32"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_scalar_mulx_u32(arg1: u32, arg2: u32) -> (u32, u32) {
    let mut out1: u32 = 0;
    let mut out2: u32 = 0;
    let x1: u64 = ((arg1 as u64) * (arg2 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: u32 = ((x1 >> 32) as u32);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_scalar_cmovznz_u32 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_scalar_cmovznz_u32(arg1: fiat_p384_scalar_u1, arg2: u32, arg3: u32) -> u32 {
    let mut out1: u32 = 0;
    let x1: fiat_p384_scalar_u1 = (!(!arg1));
    let x2: u32 = ((((((0x0 as fiat_p384_scalar_i2) - (x1 as fiat_p384_scalar_i2))
        as fiat_p384_scalar_i1) as i64)
        & (0xffffffff as i64)) as u32);
    let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p384_scalar_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_mul(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
    arg2: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let mut x13: u32 = 0;
    let mut x14: u32 = 0;
    let (x13, x14) = fiat_p384_scalar_mulx_u32(x12, (arg2[11]));
    let mut x15: u32 = 0;
    let mut x16: u32 = 0;
    let (x15, x16) = fiat_p384_scalar_mulx_u32(x12, (arg2[10]));
    let mut x17: u32 = 0;
    let mut x18: u32 = 0;
    let (x17, x18) = fiat_p384_scalar_mulx_u32(x12, (arg2[9]));
    let mut x19: u32 = 0;
    let mut x20: u32 = 0;
    let (x19, x20) = fiat_p384_scalar_mulx_u32(x12, (arg2[8]));
    let mut x21: u32 = 0;
    let mut x22: u32 = 0;
    let (x21, x22) = fiat_p384_scalar_mulx_u32(x12, (arg2[7]));
    let mut x23: u32 = 0;
    let mut x24: u32 = 0;
    let (x23, x24) = fiat_p384_scalar_mulx_u32(x12, (arg2[6]));
    let mut x25: u32 = 0;
    let mut x26: u32 = 0;
    let (x25, x26) = fiat_p384_scalar_mulx_u32(x12, (arg2[5]));
    let mut x27: u32 = 0;
    let mut x28: u32 = 0;
    let (x27, x28) = fiat_p384_scalar_mulx_u32(x12, (arg2[4]));
    let mut x29: u32 = 0;
    let mut x30: u32 = 0;
    let (x29, x30) = fiat_p384_scalar_mulx_u32(x12, (arg2[3]));
    let mut x31: u32 = 0;
    let mut x32: u32 = 0;
    let (x31, x32) = fiat_p384_scalar_mulx_u32(x12, (arg2[2]));
    let mut x33: u32 = 0;
    let mut x34: u32 = 0;
    let (x33, x34) = fiat_p384_scalar_mulx_u32(x12, (arg2[1]));
    let mut x35: u32 = 0;
    let mut x36: u32 = 0;
    let (x35, x36) = fiat_p384_scalar_mulx_u32(x12, (arg2[0]));
    let mut x37: u32 = 0;
    let mut x38: fiat_p384_scalar_u1 = 0;
    let (x37, x38) = fiat_p384_scalar_addcarryx_u32(0x0, x36, x33);
    let mut x39: u32 = 0;
    let mut x40: fiat_p384_scalar_u1 = 0;
    let (x39, x40) = fiat_p384_scalar_addcarryx_u32(x38, x34, x31);
    let mut x41: u32 = 0;
    let mut x42: fiat_p384_scalar_u1 = 0;
    let (x41, x42) = fiat_p384_scalar_addcarryx_u32(x40, x32, x29);
    let mut x43: u32 = 0;
    let mut x44: fiat_p384_scalar_u1 = 0;
    let (x43, x44) = fiat_p384_scalar_addcarryx_u32(x42, x30, x27);
    let mut x45: u32 = 0;
    let mut x46: fiat_p384_scalar_u1 = 0;
    let (x45, x46) = fiat_p384_scalar_addcarryx_u32(x44, x28, x25);
    let mut x47: u32 = 0;
    let mut x48: fiat_p384_scalar_u1 = 0;
    let (x47, x48) = fiat_p384_scalar_addcarryx_u32(x46, x26, x23);
    let mut x49: u32 = 0;
    let mut x50: fiat_p384_scalar_u1 = 0;
    let (x49, x50) = fiat_p384_scalar_addcarryx_u32(x48, x24, x21);
    let mut x51: u32 = 0;
    let mut x52: fiat_p384_scalar_u1 = 0;
    let (x51, x52) = fiat_p384_scalar_addcarryx_u32(x50, x22, x19);
    let mut x53: u32 = 0;
    let mut x54: fiat_p384_scalar_u1 = 0;
    let (x53, x54) = fiat_p384_scalar_addcarryx_u32(x52, x20, x17);
    let mut x55: u32 = 0;
    let mut x56: fiat_p384_scalar_u1 = 0;
    let (x55, x56) = fiat_p384_scalar_addcarryx_u32(x54, x18, x15);
    let mut x57: u32 = 0;
    let mut x58: fiat_p384_scalar_u1 = 0;
    let (x57, x58) = fiat_p384_scalar_addcarryx_u32(x56, x16, x13);
    let x59: u32 = ((x58 as u32) + x14);
    let mut x60: u32 = 0;
    let mut x61: u32 = 0;
    let (x60, x61) = fiat_p384_scalar_mulx_u32(x35, 0xe88fdc45);
    let mut x62: u32 = 0;
    let mut x63: u32 = 0;
    let (x62, x63) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x64: u32 = 0;
    let mut x65: u32 = 0;
    let (x64, x65) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x66: u32 = 0;
    let mut x67: u32 = 0;
    let (x66, x67) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x68: u32 = 0;
    let mut x69: u32 = 0;
    let (x68, x69) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x70: u32 = 0;
    let mut x71: u32 = 0;
    let (x70, x71) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x72: u32 = 0;
    let mut x73: u32 = 0;
    let (x72, x73) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x74: u32 = 0;
    let mut x75: u32 = 0;
    let (x74, x75) = fiat_p384_scalar_mulx_u32(x60, 0xc7634d81);
    let mut x76: u32 = 0;
    let mut x77: u32 = 0;
    let (x76, x77) = fiat_p384_scalar_mulx_u32(x60, 0xf4372ddf);
    let mut x78: u32 = 0;
    let mut x79: u32 = 0;
    let (x78, x79) = fiat_p384_scalar_mulx_u32(x60, 0x581a0db2);
    let mut x80: u32 = 0;
    let mut x81: u32 = 0;
    let (x80, x81) = fiat_p384_scalar_mulx_u32(x60, 0x48b0a77a);
    let mut x82: u32 = 0;
    let mut x83: u32 = 0;
    let (x82, x83) = fiat_p384_scalar_mulx_u32(x60, 0xecec196a);
    let mut x84: u32 = 0;
    let mut x85: u32 = 0;
    let (x84, x85) = fiat_p384_scalar_mulx_u32(x60, 0xccc52973);
    let mut x86: u32 = 0;
    let mut x87: fiat_p384_scalar_u1 = 0;
    let (x86, x87) = fiat_p384_scalar_addcarryx_u32(0x0, x85, x82);
    let mut x88: u32 = 0;
    let mut x89: fiat_p384_scalar_u1 = 0;
    let (x88, x89) = fiat_p384_scalar_addcarryx_u32(x87, x83, x80);
    let mut x90: u32 = 0;
    let mut x91: fiat_p384_scalar_u1 = 0;
    let (x90, x91) = fiat_p384_scalar_addcarryx_u32(x89, x81, x78);
    let mut x92: u32 = 0;
    let mut x93: fiat_p384_scalar_u1 = 0;
    let (x92, x93) = fiat_p384_scalar_addcarryx_u32(x91, x79, x76);
    let mut x94: u32 = 0;
    let mut x95: fiat_p384_scalar_u1 = 0;
    let (x94, x95) = fiat_p384_scalar_addcarryx_u32(x93, x77, x74);
    let mut x96: u32 = 0;
    let mut x97: fiat_p384_scalar_u1 = 0;
    let (x96, x97) = fiat_p384_scalar_addcarryx_u32(x95, x75, x72);
    let mut x98: u32 = 0;
    let mut x99: fiat_p384_scalar_u1 = 0;
    let (x98, x99) = fiat_p384_scalar_addcarryx_u32(x97, x73, x70);
    let mut x100: u32 = 0;
    let mut x101: fiat_p384_scalar_u1 = 0;
    let (x100, x101) = fiat_p384_scalar_addcarryx_u32(x99, x71, x68);
    let mut x102: u32 = 0;
    let mut x103: fiat_p384_scalar_u1 = 0;
    let (x102, x103) = fiat_p384_scalar_addcarryx_u32(x101, x69, x66);
    let mut x104: u32 = 0;
    let mut x105: fiat_p384_scalar_u1 = 0;
    let (x104, x105) = fiat_p384_scalar_addcarryx_u32(x103, x67, x64);
    let mut x106: u32 = 0;
    let mut x107: fiat_p384_scalar_u1 = 0;
    let (x106, x107) = fiat_p384_scalar_addcarryx_u32(x105, x65, x62);
    let x108: u32 = ((x107 as u32) + x63);
    let mut x109: u32 = 0;
    let mut x110: fiat_p384_scalar_u1 = 0;
    let (x109, x110) = fiat_p384_scalar_addcarryx_u32(0x0, x35, x84);
    let mut x111: u32 = 0;
    let mut x112: fiat_p384_scalar_u1 = 0;
    let (x111, x112) = fiat_p384_scalar_addcarryx_u32(x110, x37, x86);
    let mut x113: u32 = 0;
    let mut x114: fiat_p384_scalar_u1 = 0;
    let (x113, x114) = fiat_p384_scalar_addcarryx_u32(x112, x39, x88);
    let mut x115: u32 = 0;
    let mut x116: fiat_p384_scalar_u1 = 0;
    let (x115, x116) = fiat_p384_scalar_addcarryx_u32(x114, x41, x90);
    let mut x117: u32 = 0;
    let mut x118: fiat_p384_scalar_u1 = 0;
    let (x117, x118) = fiat_p384_scalar_addcarryx_u32(x116, x43, x92);
    let mut x119: u32 = 0;
    let mut x120: fiat_p384_scalar_u1 = 0;
    let (x119, x120) = fiat_p384_scalar_addcarryx_u32(x118, x45, x94);
    let mut x121: u32 = 0;
    let mut x122: fiat_p384_scalar_u1 = 0;
    let (x121, x122) = fiat_p384_scalar_addcarryx_u32(x120, x47, x96);
    let mut x123: u32 = 0;
    let mut x124: fiat_p384_scalar_u1 = 0;
    let (x123, x124) = fiat_p384_scalar_addcarryx_u32(x122, x49, x98);
    let mut x125: u32 = 0;
    let mut x126: fiat_p384_scalar_u1 = 0;
    let (x125, x126) = fiat_p384_scalar_addcarryx_u32(x124, x51, x100);
    let mut x127: u32 = 0;
    let mut x128: fiat_p384_scalar_u1 = 0;
    let (x127, x128) = fiat_p384_scalar_addcarryx_u32(x126, x53, x102);
    let mut x129: u32 = 0;
    let mut x130: fiat_p384_scalar_u1 = 0;
    let (x129, x130) = fiat_p384_scalar_addcarryx_u32(x128, x55, x104);
    let mut x131: u32 = 0;
    let mut x132: fiat_p384_scalar_u1 = 0;
    let (x131, x132) = fiat_p384_scalar_addcarryx_u32(x130, x57, x106);
    let mut x133: u32 = 0;
    let mut x134: fiat_p384_scalar_u1 = 0;
    let (x133, x134) = fiat_p384_scalar_addcarryx_u32(x132, x59, x108);
    let mut x135: u32 = 0;
    let mut x136: u32 = 0;
    let (x135, x136) = fiat_p384_scalar_mulx_u32(x1, (arg2[11]));
    let mut x137: u32 = 0;
    let mut x138: u32 = 0;
    let (x137, x138) = fiat_p384_scalar_mulx_u32(x1, (arg2[10]));
    let mut x139: u32 = 0;
    let mut x140: u32 = 0;
    let (x139, x140) = fiat_p384_scalar_mulx_u32(x1, (arg2[9]));
    let mut x141: u32 = 0;
    let mut x142: u32 = 0;
    let (x141, x142) = fiat_p384_scalar_mulx_u32(x1, (arg2[8]));
    let mut x143: u32 = 0;
    let mut x144: u32 = 0;
    let (x143, x144) = fiat_p384_scalar_mulx_u32(x1, (arg2[7]));
    let mut x145: u32 = 0;
    let mut x146: u32 = 0;
    let (x145, x146) = fiat_p384_scalar_mulx_u32(x1, (arg2[6]));
    let mut x147: u32 = 0;
    let mut x148: u32 = 0;
    let (x147, x148) = fiat_p384_scalar_mulx_u32(x1, (arg2[5]));
    let mut x149: u32 = 0;
    let mut x150: u32 = 0;
    let (x149, x150) = fiat_p384_scalar_mulx_u32(x1, (arg2[4]));
    let mut x151: u32 = 0;
    let mut x152: u32 = 0;
    let (x151, x152) = fiat_p384_scalar_mulx_u32(x1, (arg2[3]));
    let mut x153: u32 = 0;
    let mut x154: u32 = 0;
    let (x153, x154) = fiat_p384_scalar_mulx_u32(x1, (arg2[2]));
    let mut x155: u32 = 0;
    let mut x156: u32 = 0;
    let (x155, x156) = fiat_p384_scalar_mulx_u32(x1, (arg2[1]));
    let mut x157: u32 = 0;
    let mut x158: u32 = 0;
    let (x157, x158) = fiat_p384_scalar_mulx_u32(x1, (arg2[0]));
    let mut x159: u32 = 0;
    let mut x160: fiat_p384_scalar_u1 = 0;
    let (x159, x160) = fiat_p384_scalar_addcarryx_u32(0x0, x158, x155);
    let mut x161: u32 = 0;
    let mut x162: fiat_p384_scalar_u1 = 0;
    let (x161, x162) = fiat_p384_scalar_addcarryx_u32(x160, x156, x153);
    let mut x163: u32 = 0;
    let mut x164: fiat_p384_scalar_u1 = 0;
    let (x163, x164) = fiat_p384_scalar_addcarryx_u32(x162, x154, x151);
    let mut x165: u32 = 0;
    let mut x166: fiat_p384_scalar_u1 = 0;
    let (x165, x166) = fiat_p384_scalar_addcarryx_u32(x164, x152, x149);
    let mut x167: u32 = 0;
    let mut x168: fiat_p384_scalar_u1 = 0;
    let (x167, x168) = fiat_p384_scalar_addcarryx_u32(x166, x150, x147);
    let mut x169: u32 = 0;
    let mut x170: fiat_p384_scalar_u1 = 0;
    let (x169, x170) = fiat_p384_scalar_addcarryx_u32(x168, x148, x145);
    let mut x171: u32 = 0;
    let mut x172: fiat_p384_scalar_u1 = 0;
    let (x171, x172) = fiat_p384_scalar_addcarryx_u32(x170, x146, x143);
    let mut x173: u32 = 0;
    let mut x174: fiat_p384_scalar_u1 = 0;
    let (x173, x174) = fiat_p384_scalar_addcarryx_u32(x172, x144, x141);
    let mut x175: u32 = 0;
    let mut x176: fiat_p384_scalar_u1 = 0;
    let (x175, x176) = fiat_p384_scalar_addcarryx_u32(x174, x142, x139);
    let mut x177: u32 = 0;
    let mut x178: fiat_p384_scalar_u1 = 0;
    let (x177, x178) = fiat_p384_scalar_addcarryx_u32(x176, x140, x137);
    let mut x179: u32 = 0;
    let mut x180: fiat_p384_scalar_u1 = 0;
    let (x179, x180) = fiat_p384_scalar_addcarryx_u32(x178, x138, x135);
    let x181: u32 = ((x180 as u32) + x136);
    let mut x182: u32 = 0;
    let mut x183: fiat_p384_scalar_u1 = 0;
    let (x182, x183) = fiat_p384_scalar_addcarryx_u32(0x0, x111, x157);
    let mut x184: u32 = 0;
    let mut x185: fiat_p384_scalar_u1 = 0;
    let (x184, x185) = fiat_p384_scalar_addcarryx_u32(x183, x113, x159);
    let mut x186: u32 = 0;
    let mut x187: fiat_p384_scalar_u1 = 0;
    let (x186, x187) = fiat_p384_scalar_addcarryx_u32(x185, x115, x161);
    let mut x188: u32 = 0;
    let mut x189: fiat_p384_scalar_u1 = 0;
    let (x188, x189) = fiat_p384_scalar_addcarryx_u32(x187, x117, x163);
    let mut x190: u32 = 0;
    let mut x191: fiat_p384_scalar_u1 = 0;
    let (x190, x191) = fiat_p384_scalar_addcarryx_u32(x189, x119, x165);
    let mut x192: u32 = 0;
    let mut x193: fiat_p384_scalar_u1 = 0;
    let (x192, x193) = fiat_p384_scalar_addcarryx_u32(x191, x121, x167);
    let mut x194: u32 = 0;
    let mut x195: fiat_p384_scalar_u1 = 0;
    let (x194, x195) = fiat_p384_scalar_addcarryx_u32(x193, x123, x169);
    let mut x196: u32 = 0;
    let mut x197: fiat_p384_scalar_u1 = 0;
    let (x196, x197) = fiat_p384_scalar_addcarryx_u32(x195, x125, x171);
    let mut x198: u32 = 0;
    let mut x199: fiat_p384_scalar_u1 = 0;
    let (x198, x199) = fiat_p384_scalar_addcarryx_u32(x197, x127, x173);
    let mut x200: u32 = 0;
    let mut x201: fiat_p384_scalar_u1 = 0;
    let (x200, x201) = fiat_p384_scalar_addcarryx_u32(x199, x129, x175);
    let mut x202: u32 = 0;
    let mut x203: fiat_p384_scalar_u1 = 0;
    let (x202, x203) = fiat_p384_scalar_addcarryx_u32(x201, x131, x177);
    let mut x204: u32 = 0;
    let mut x205: fiat_p384_scalar_u1 = 0;
    let (x204, x205) = fiat_p384_scalar_addcarryx_u32(x203, x133, x179);
    let mut x206: u32 = 0;
    let mut x207: fiat_p384_scalar_u1 = 0;
    let (x206, x207) = fiat_p384_scalar_addcarryx_u32(x205, (x134 as u32), x181);
    let mut x208: u32 = 0;
    let mut x209: u32 = 0;
    let (x208, x209) = fiat_p384_scalar_mulx_u32(x182, 0xe88fdc45);
    let mut x210: u32 = 0;
    let mut x211: u32 = 0;
    let (x210, x211) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x212: u32 = 0;
    let mut x213: u32 = 0;
    let (x212, x213) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x214: u32 = 0;
    let mut x215: u32 = 0;
    let (x214, x215) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x216: u32 = 0;
    let mut x217: u32 = 0;
    let (x216, x217) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x218: u32 = 0;
    let mut x219: u32 = 0;
    let (x218, x219) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x220: u32 = 0;
    let mut x221: u32 = 0;
    let (x220, x221) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x222: u32 = 0;
    let mut x223: u32 = 0;
    let (x222, x223) = fiat_p384_scalar_mulx_u32(x208, 0xc7634d81);
    let mut x224: u32 = 0;
    let mut x225: u32 = 0;
    let (x224, x225) = fiat_p384_scalar_mulx_u32(x208, 0xf4372ddf);
    let mut x226: u32 = 0;
    let mut x227: u32 = 0;
    let (x226, x227) = fiat_p384_scalar_mulx_u32(x208, 0x581a0db2);
    let mut x228: u32 = 0;
    let mut x229: u32 = 0;
    let (x228, x229) = fiat_p384_scalar_mulx_u32(x208, 0x48b0a77a);
    let mut x230: u32 = 0;
    let mut x231: u32 = 0;
    let (x230, x231) = fiat_p384_scalar_mulx_u32(x208, 0xecec196a);
    let mut x232: u32 = 0;
    let mut x233: u32 = 0;
    let (x232, x233) = fiat_p384_scalar_mulx_u32(x208, 0xccc52973);
    let mut x234: u32 = 0;
    let mut x235: fiat_p384_scalar_u1 = 0;
    let (x234, x235) = fiat_p384_scalar_addcarryx_u32(0x0, x233, x230);
    let mut x236: u32 = 0;
    let mut x237: fiat_p384_scalar_u1 = 0;
    let (x236, x237) = fiat_p384_scalar_addcarryx_u32(x235, x231, x228);
    let mut x238: u32 = 0;
    let mut x239: fiat_p384_scalar_u1 = 0;
    let (x238, x239) = fiat_p384_scalar_addcarryx_u32(x237, x229, x226);
    let mut x240: u32 = 0;
    let mut x241: fiat_p384_scalar_u1 = 0;
    let (x240, x241) = fiat_p384_scalar_addcarryx_u32(x239, x227, x224);
    let mut x242: u32 = 0;
    let mut x243: fiat_p384_scalar_u1 = 0;
    let (x242, x243) = fiat_p384_scalar_addcarryx_u32(x241, x225, x222);
    let mut x244: u32 = 0;
    let mut x245: fiat_p384_scalar_u1 = 0;
    let (x244, x245) = fiat_p384_scalar_addcarryx_u32(x243, x223, x220);
    let mut x246: u32 = 0;
    let mut x247: fiat_p384_scalar_u1 = 0;
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(x245, x221, x218);
    let mut x248: u32 = 0;
    let mut x249: fiat_p384_scalar_u1 = 0;
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x219, x216);
    let mut x250: u32 = 0;
    let mut x251: fiat_p384_scalar_u1 = 0;
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x217, x214);
    let mut x252: u32 = 0;
    let mut x253: fiat_p384_scalar_u1 = 0;
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x215, x212);
    let mut x254: u32 = 0;
    let mut x255: fiat_p384_scalar_u1 = 0;
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x213, x210);
    let x256: u32 = ((x255 as u32) + x211);
    let mut x257: u32 = 0;
    let mut x258: fiat_p384_scalar_u1 = 0;
    let (x257, x258) = fiat_p384_scalar_addcarryx_u32(0x0, x182, x232);
    let mut x259: u32 = 0;
    let mut x260: fiat_p384_scalar_u1 = 0;
    let (x259, x260) = fiat_p384_scalar_addcarryx_u32(x258, x184, x234);
    let mut x261: u32 = 0;
    let mut x262: fiat_p384_scalar_u1 = 0;
    let (x261, x262) = fiat_p384_scalar_addcarryx_u32(x260, x186, x236);
    let mut x263: u32 = 0;
    let mut x264: fiat_p384_scalar_u1 = 0;
    let (x263, x264) = fiat_p384_scalar_addcarryx_u32(x262, x188, x238);
    let mut x265: u32 = 0;
    let mut x266: fiat_p384_scalar_u1 = 0;
    let (x265, x266) = fiat_p384_scalar_addcarryx_u32(x264, x190, x240);
    let mut x267: u32 = 0;
    let mut x268: fiat_p384_scalar_u1 = 0;
    let (x267, x268) = fiat_p384_scalar_addcarryx_u32(x266, x192, x242);
    let mut x269: u32 = 0;
    let mut x270: fiat_p384_scalar_u1 = 0;
    let (x269, x270) = fiat_p384_scalar_addcarryx_u32(x268, x194, x244);
    let mut x271: u32 = 0;
    let mut x272: fiat_p384_scalar_u1 = 0;
    let (x271, x272) = fiat_p384_scalar_addcarryx_u32(x270, x196, x246);
    let mut x273: u32 = 0;
    let mut x274: fiat_p384_scalar_u1 = 0;
    let (x273, x274) = fiat_p384_scalar_addcarryx_u32(x272, x198, x248);
    let mut x275: u32 = 0;
    let mut x276: fiat_p384_scalar_u1 = 0;
    let (x275, x276) = fiat_p384_scalar_addcarryx_u32(x274, x200, x250);
    let mut x277: u32 = 0;
    let mut x278: fiat_p384_scalar_u1 = 0;
    let (x277, x278) = fiat_p384_scalar_addcarryx_u32(x276, x202, x252);
    let mut x279: u32 = 0;
    let mut x280: fiat_p384_scalar_u1 = 0;
    let (x279, x280) = fiat_p384_scalar_addcarryx_u32(x278, x204, x254);
    let mut x281: u32 = 0;
    let mut x282: fiat_p384_scalar_u1 = 0;
    let (x281, x282) = fiat_p384_scalar_addcarryx_u32(x280, x206, x256);
    let x283: u32 = ((x282 as u32) + (x207 as u32));
    let mut x284: u32 = 0;
    let mut x285: u32 = 0;
    let (x284, x285) = fiat_p384_scalar_mulx_u32(x2, (arg2[11]));
    let mut x286: u32 = 0;
    let mut x287: u32 = 0;
    let (x286, x287) = fiat_p384_scalar_mulx_u32(x2, (arg2[10]));
    let mut x288: u32 = 0;
    let mut x289: u32 = 0;
    let (x288, x289) = fiat_p384_scalar_mulx_u32(x2, (arg2[9]));
    let mut x290: u32 = 0;
    let mut x291: u32 = 0;
    let (x290, x291) = fiat_p384_scalar_mulx_u32(x2, (arg2[8]));
    let mut x292: u32 = 0;
    let mut x293: u32 = 0;
    let (x292, x293) = fiat_p384_scalar_mulx_u32(x2, (arg2[7]));
    let mut x294: u32 = 0;
    let mut x295: u32 = 0;
    let (x294, x295) = fiat_p384_scalar_mulx_u32(x2, (arg2[6]));
    let mut x296: u32 = 0;
    let mut x297: u32 = 0;
    let (x296, x297) = fiat_p384_scalar_mulx_u32(x2, (arg2[5]));
    let mut x298: u32 = 0;
    let mut x299: u32 = 0;
    let (x298, x299) = fiat_p384_scalar_mulx_u32(x2, (arg2[4]));
    let mut x300: u32 = 0;
    let mut x301: u32 = 0;
    let (x300, x301) = fiat_p384_scalar_mulx_u32(x2, (arg2[3]));
    let mut x302: u32 = 0;
    let mut x303: u32 = 0;
    let (x302, x303) = fiat_p384_scalar_mulx_u32(x2, (arg2[2]));
    let mut x304: u32 = 0;
    let mut x305: u32 = 0;
    let (x304, x305) = fiat_p384_scalar_mulx_u32(x2, (arg2[1]));
    let mut x306: u32 = 0;
    let mut x307: u32 = 0;
    let (x306, x307) = fiat_p384_scalar_mulx_u32(x2, (arg2[0]));
    let mut x308: u32 = 0;
    let mut x309: fiat_p384_scalar_u1 = 0;
    let (x308, x309) = fiat_p384_scalar_addcarryx_u32(0x0, x307, x304);
    let mut x310: u32 = 0;
    let mut x311: fiat_p384_scalar_u1 = 0;
    let (x310, x311) = fiat_p384_scalar_addcarryx_u32(x309, x305, x302);
    let mut x312: u32 = 0;
    let mut x313: fiat_p384_scalar_u1 = 0;
    let (x312, x313) = fiat_p384_scalar_addcarryx_u32(x311, x303, x300);
    let mut x314: u32 = 0;
    let mut x315: fiat_p384_scalar_u1 = 0;
    let (x314, x315) = fiat_p384_scalar_addcarryx_u32(x313, x301, x298);
    let mut x316: u32 = 0;
    let mut x317: fiat_p384_scalar_u1 = 0;
    let (x316, x317) = fiat_p384_scalar_addcarryx_u32(x315, x299, x296);
    let mut x318: u32 = 0;
    let mut x319: fiat_p384_scalar_u1 = 0;
    let (x318, x319) = fiat_p384_scalar_addcarryx_u32(x317, x297, x294);
    let mut x320: u32 = 0;
    let mut x321: fiat_p384_scalar_u1 = 0;
    let (x320, x321) = fiat_p384_scalar_addcarryx_u32(x319, x295, x292);
    let mut x322: u32 = 0;
    let mut x323: fiat_p384_scalar_u1 = 0;
    let (x322, x323) = fiat_p384_scalar_addcarryx_u32(x321, x293, x290);
    let mut x324: u32 = 0;
    let mut x325: fiat_p384_scalar_u1 = 0;
    let (x324, x325) = fiat_p384_scalar_addcarryx_u32(x323, x291, x288);
    let mut x326: u32 = 0;
    let mut x327: fiat_p384_scalar_u1 = 0;
    let (x326, x327) = fiat_p384_scalar_addcarryx_u32(x325, x289, x286);
    let mut x328: u32 = 0;
    let mut x329: fiat_p384_scalar_u1 = 0;
    let (x328, x329) = fiat_p384_scalar_addcarryx_u32(x327, x287, x284);
    let x330: u32 = ((x329 as u32) + x285);
    let mut x331: u32 = 0;
    let mut x332: fiat_p384_scalar_u1 = 0;
    let (x331, x332) = fiat_p384_scalar_addcarryx_u32(0x0, x259, x306);
    let mut x333: u32 = 0;
    let mut x334: fiat_p384_scalar_u1 = 0;
    let (x333, x334) = fiat_p384_scalar_addcarryx_u32(x332, x261, x308);
    let mut x335: u32 = 0;
    let mut x336: fiat_p384_scalar_u1 = 0;
    let (x335, x336) = fiat_p384_scalar_addcarryx_u32(x334, x263, x310);
    let mut x337: u32 = 0;
    let mut x338: fiat_p384_scalar_u1 = 0;
    let (x337, x338) = fiat_p384_scalar_addcarryx_u32(x336, x265, x312);
    let mut x339: u32 = 0;
    let mut x340: fiat_p384_scalar_u1 = 0;
    let (x339, x340) = fiat_p384_scalar_addcarryx_u32(x338, x267, x314);
    let mut x341: u32 = 0;
    let mut x342: fiat_p384_scalar_u1 = 0;
    let (x341, x342) = fiat_p384_scalar_addcarryx_u32(x340, x269, x316);
    let mut x343: u32 = 0;
    let mut x344: fiat_p384_scalar_u1 = 0;
    let (x343, x344) = fiat_p384_scalar_addcarryx_u32(x342, x271, x318);
    let mut x345: u32 = 0;
    let mut x346: fiat_p384_scalar_u1 = 0;
    let (x345, x346) = fiat_p384_scalar_addcarryx_u32(x344, x273, x320);
    let mut x347: u32 = 0;
    let mut x348: fiat_p384_scalar_u1 = 0;
    let (x347, x348) = fiat_p384_scalar_addcarryx_u32(x346, x275, x322);
    let mut x349: u32 = 0;
    let mut x350: fiat_p384_scalar_u1 = 0;
    let (x349, x350) = fiat_p384_scalar_addcarryx_u32(x348, x277, x324);
    let mut x351: u32 = 0;
    let mut x352: fiat_p384_scalar_u1 = 0;
    let (x351, x352) = fiat_p384_scalar_addcarryx_u32(x350, x279, x326);
    let mut x353: u32 = 0;
    let mut x354: fiat_p384_scalar_u1 = 0;
    let (x353, x354) = fiat_p384_scalar_addcarryx_u32(x352, x281, x328);
    let mut x355: u32 = 0;
    let mut x356: fiat_p384_scalar_u1 = 0;
    let (x355, x356) = fiat_p384_scalar_addcarryx_u32(x354, x283, x330);
    let mut x357: u32 = 0;
    let mut x358: u32 = 0;
    let (x357, x358) = fiat_p384_scalar_mulx_u32(x331, 0xe88fdc45);
    let mut x359: u32 = 0;
    let mut x360: u32 = 0;
    let (x359, x360) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x361: u32 = 0;
    let mut x362: u32 = 0;
    let (x361, x362) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x363: u32 = 0;
    let mut x364: u32 = 0;
    let (x363, x364) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x365: u32 = 0;
    let mut x366: u32 = 0;
    let (x365, x366) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x367: u32 = 0;
    let mut x368: u32 = 0;
    let (x367, x368) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x369: u32 = 0;
    let mut x370: u32 = 0;
    let (x369, x370) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x371: u32 = 0;
    let mut x372: u32 = 0;
    let (x371, x372) = fiat_p384_scalar_mulx_u32(x357, 0xc7634d81);
    let mut x373: u32 = 0;
    let mut x374: u32 = 0;
    let (x373, x374) = fiat_p384_scalar_mulx_u32(x357, 0xf4372ddf);
    let mut x375: u32 = 0;
    let mut x376: u32 = 0;
    let (x375, x376) = fiat_p384_scalar_mulx_u32(x357, 0x581a0db2);
    let mut x377: u32 = 0;
    let mut x378: u32 = 0;
    let (x377, x378) = fiat_p384_scalar_mulx_u32(x357, 0x48b0a77a);
    let mut x379: u32 = 0;
    let mut x380: u32 = 0;
    let (x379, x380) = fiat_p384_scalar_mulx_u32(x357, 0xecec196a);
    let mut x381: u32 = 0;
    let mut x382: u32 = 0;
    let (x381, x382) = fiat_p384_scalar_mulx_u32(x357, 0xccc52973);
    let mut x383: u32 = 0;
    let mut x384: fiat_p384_scalar_u1 = 0;
    let (x383, x384) = fiat_p384_scalar_addcarryx_u32(0x0, x382, x379);
    let mut x385: u32 = 0;
    let mut x386: fiat_p384_scalar_u1 = 0;
    let (x385, x386) = fiat_p384_scalar_addcarryx_u32(x384, x380, x377);
    let mut x387: u32 = 0;
    let mut x388: fiat_p384_scalar_u1 = 0;
    let (x387, x388) = fiat_p384_scalar_addcarryx_u32(x386, x378, x375);
    let mut x389: u32 = 0;
    let mut x390: fiat_p384_scalar_u1 = 0;
    let (x389, x390) = fiat_p384_scalar_addcarryx_u32(x388, x376, x373);
    let mut x391: u32 = 0;
    let mut x392: fiat_p384_scalar_u1 = 0;
    let (x391, x392) = fiat_p384_scalar_addcarryx_u32(x390, x374, x371);
    let mut x393: u32 = 0;
    let mut x394: fiat_p384_scalar_u1 = 0;
    let (x393, x394) = fiat_p384_scalar_addcarryx_u32(x392, x372, x369);
    let mut x395: u32 = 0;
    let mut x396: fiat_p384_scalar_u1 = 0;
    let (x395, x396) = fiat_p384_scalar_addcarryx_u32(x394, x370, x367);
    let mut x397: u32 = 0;
    let mut x398: fiat_p384_scalar_u1 = 0;
    let (x397, x398) = fiat_p384_scalar_addcarryx_u32(x396, x368, x365);
    let mut x399: u32 = 0;
    let mut x400: fiat_p384_scalar_u1 = 0;
    let (x399, x400) = fiat_p384_scalar_addcarryx_u32(x398, x366, x363);
    let mut x401: u32 = 0;
    let mut x402: fiat_p384_scalar_u1 = 0;
    let (x401, x402) = fiat_p384_scalar_addcarryx_u32(x400, x364, x361);
    let mut x403: u32 = 0;
    let mut x404: fiat_p384_scalar_u1 = 0;
    let (x403, x404) = fiat_p384_scalar_addcarryx_u32(x402, x362, x359);
    let x405: u32 = ((x404 as u32) + x360);
    let mut x406: u32 = 0;
    let mut x407: fiat_p384_scalar_u1 = 0;
    let (x406, x407) = fiat_p384_scalar_addcarryx_u32(0x0, x331, x381);
    let mut x408: u32 = 0;
    let mut x409: fiat_p384_scalar_u1 = 0;
    let (x408, x409) = fiat_p384_scalar_addcarryx_u32(x407, x333, x383);
    let mut x410: u32 = 0;
    let mut x411: fiat_p384_scalar_u1 = 0;
    let (x410, x411) = fiat_p384_scalar_addcarryx_u32(x409, x335, x385);
    let mut x412: u32 = 0;
    let mut x413: fiat_p384_scalar_u1 = 0;
    let (x412, x413) = fiat_p384_scalar_addcarryx_u32(x411, x337, x387);
    let mut x414: u32 = 0;
    let mut x415: fiat_p384_scalar_u1 = 0;
    let (x414, x415) = fiat_p384_scalar_addcarryx_u32(x413, x339, x389);
    let mut x416: u32 = 0;
    let mut x417: fiat_p384_scalar_u1 = 0;
    let (x416, x417) = fiat_p384_scalar_addcarryx_u32(x415, x341, x391);
    let mut x418: u32 = 0;
    let mut x419: fiat_p384_scalar_u1 = 0;
    let (x418, x419) = fiat_p384_scalar_addcarryx_u32(x417, x343, x393);
    let mut x420: u32 = 0;
    let mut x421: fiat_p384_scalar_u1 = 0;
    let (x420, x421) = fiat_p384_scalar_addcarryx_u32(x419, x345, x395);
    let mut x422: u32 = 0;
    let mut x423: fiat_p384_scalar_u1 = 0;
    let (x422, x423) = fiat_p384_scalar_addcarryx_u32(x421, x347, x397);
    let mut x424: u32 = 0;
    let mut x425: fiat_p384_scalar_u1 = 0;
    let (x424, x425) = fiat_p384_scalar_addcarryx_u32(x423, x349, x399);
    let mut x426: u32 = 0;
    let mut x427: fiat_p384_scalar_u1 = 0;
    let (x426, x427) = fiat_p384_scalar_addcarryx_u32(x425, x351, x401);
    let mut x428: u32 = 0;
    let mut x429: fiat_p384_scalar_u1 = 0;
    let (x428, x429) = fiat_p384_scalar_addcarryx_u32(x427, x353, x403);
    let mut x430: u32 = 0;
    let mut x431: fiat_p384_scalar_u1 = 0;
    let (x430, x431) = fiat_p384_scalar_addcarryx_u32(x429, x355, x405);
    let x432: u32 = ((x431 as u32) + (x356 as u32));
    let mut x433: u32 = 0;
    let mut x434: u32 = 0;
    let (x433, x434) = fiat_p384_scalar_mulx_u32(x3, (arg2[11]));
    let mut x435: u32 = 0;
    let mut x436: u32 = 0;
    let (x435, x436) = fiat_p384_scalar_mulx_u32(x3, (arg2[10]));
    let mut x437: u32 = 0;
    let mut x438: u32 = 0;
    let (x437, x438) = fiat_p384_scalar_mulx_u32(x3, (arg2[9]));
    let mut x439: u32 = 0;
    let mut x440: u32 = 0;
    let (x439, x440) = fiat_p384_scalar_mulx_u32(x3, (arg2[8]));
    let mut x441: u32 = 0;
    let mut x442: u32 = 0;
    let (x441, x442) = fiat_p384_scalar_mulx_u32(x3, (arg2[7]));
    let mut x443: u32 = 0;
    let mut x444: u32 = 0;
    let (x443, x444) = fiat_p384_scalar_mulx_u32(x3, (arg2[6]));
    let mut x445: u32 = 0;
    let mut x446: u32 = 0;
    let (x445, x446) = fiat_p384_scalar_mulx_u32(x3, (arg2[5]));
    let mut x447: u32 = 0;
    let mut x448: u32 = 0;
    let (x447, x448) = fiat_p384_scalar_mulx_u32(x3, (arg2[4]));
    let mut x449: u32 = 0;
    let mut x450: u32 = 0;
    let (x449, x450) = fiat_p384_scalar_mulx_u32(x3, (arg2[3]));
    let mut x451: u32 = 0;
    let mut x452: u32 = 0;
    let (x451, x452) = fiat_p384_scalar_mulx_u32(x3, (arg2[2]));
    let mut x453: u32 = 0;
    let mut x454: u32 = 0;
    let (x453, x454) = fiat_p384_scalar_mulx_u32(x3, (arg2[1]));
    let mut x455: u32 = 0;
    let mut x456: u32 = 0;
    let (x455, x456) = fiat_p384_scalar_mulx_u32(x3, (arg2[0]));
    let mut x457: u32 = 0;
    let mut x458: fiat_p384_scalar_u1 = 0;
    let (x457, x458) = fiat_p384_scalar_addcarryx_u32(0x0, x456, x453);
    let mut x459: u32 = 0;
    let mut x460: fiat_p384_scalar_u1 = 0;
    let (x459, x460) = fiat_p384_scalar_addcarryx_u32(x458, x454, x451);
    let mut x461: u32 = 0;
    let mut x462: fiat_p384_scalar_u1 = 0;
    let (x461, x462) = fiat_p384_scalar_addcarryx_u32(x460, x452, x449);
    let mut x463: u32 = 0;
    let mut x464: fiat_p384_scalar_u1 = 0;
    let (x463, x464) = fiat_p384_scalar_addcarryx_u32(x462, x450, x447);
    let mut x465: u32 = 0;
    let mut x466: fiat_p384_scalar_u1 = 0;
    let (x465, x466) = fiat_p384_scalar_addcarryx_u32(x464, x448, x445);
    let mut x467: u32 = 0;
    let mut x468: fiat_p384_scalar_u1 = 0;
    let (x467, x468) = fiat_p384_scalar_addcarryx_u32(x466, x446, x443);
    let mut x469: u32 = 0;
    let mut x470: fiat_p384_scalar_u1 = 0;
    let (x469, x470) = fiat_p384_scalar_addcarryx_u32(x468, x444, x441);
    let mut x471: u32 = 0;
    let mut x472: fiat_p384_scalar_u1 = 0;
    let (x471, x472) = fiat_p384_scalar_addcarryx_u32(x470, x442, x439);
    let mut x473: u32 = 0;
    let mut x474: fiat_p384_scalar_u1 = 0;
    let (x473, x474) = fiat_p384_scalar_addcarryx_u32(x472, x440, x437);
    let mut x475: u32 = 0;
    let mut x476: fiat_p384_scalar_u1 = 0;
    let (x475, x476) = fiat_p384_scalar_addcarryx_u32(x474, x438, x435);
    let mut x477: u32 = 0;
    let mut x478: fiat_p384_scalar_u1 = 0;
    let (x477, x478) = fiat_p384_scalar_addcarryx_u32(x476, x436, x433);
    let x479: u32 = ((x478 as u32) + x434);
    let mut x480: u32 = 0;
    let mut x481: fiat_p384_scalar_u1 = 0;
    let (x480, x481) = fiat_p384_scalar_addcarryx_u32(0x0, x408, x455);
    let mut x482: u32 = 0;
    let mut x483: fiat_p384_scalar_u1 = 0;
    let (x482, x483) = fiat_p384_scalar_addcarryx_u32(x481, x410, x457);
    let mut x484: u32 = 0;
    let mut x485: fiat_p384_scalar_u1 = 0;
    let (x484, x485) = fiat_p384_scalar_addcarryx_u32(x483, x412, x459);
    let mut x486: u32 = 0;
    let mut x487: fiat_p384_scalar_u1 = 0;
    let (x486, x487) = fiat_p384_scalar_addcarryx_u32(x485, x414, x461);
    let mut x488: u32 = 0;
    let mut x489: fiat_p384_scalar_u1 = 0;
    let (x488, x489) = fiat_p384_scalar_addcarryx_u32(x487, x416, x463);
    let mut x490: u32 = 0;
    let mut x491: fiat_p384_scalar_u1 = 0;
    let (x490, x491) = fiat_p384_scalar_addcarryx_u32(x489, x418, x465);
    let mut x492: u32 = 0;
    let mut x493: fiat_p384_scalar_u1 = 0;
    let (x492, x493) = fiat_p384_scalar_addcarryx_u32(x491, x420, x467);
    let mut x494: u32 = 0;
    let mut x495: fiat_p384_scalar_u1 = 0;
    let (x494, x495) = fiat_p384_scalar_addcarryx_u32(x493, x422, x469);
    let mut x496: u32 = 0;
    let mut x497: fiat_p384_scalar_u1 = 0;
    let (x496, x497) = fiat_p384_scalar_addcarryx_u32(x495, x424, x471);
    let mut x498: u32 = 0;
    let mut x499: fiat_p384_scalar_u1 = 0;
    let (x498, x499) = fiat_p384_scalar_addcarryx_u32(x497, x426, x473);
    let mut x500: u32 = 0;
    let mut x501: fiat_p384_scalar_u1 = 0;
    let (x500, x501) = fiat_p384_scalar_addcarryx_u32(x499, x428, x475);
    let mut x502: u32 = 0;
    let mut x503: fiat_p384_scalar_u1 = 0;
    let (x502, x503) = fiat_p384_scalar_addcarryx_u32(x501, x430, x477);
    let mut x504: u32 = 0;
    let mut x505: fiat_p384_scalar_u1 = 0;
    let (x504, x505) = fiat_p384_scalar_addcarryx_u32(x503, x432, x479);
    let mut x506: u32 = 0;
    let mut x507: u32 = 0;
    let (x506, x507) = fiat_p384_scalar_mulx_u32(x480, 0xe88fdc45);
    let mut x508: u32 = 0;
    let mut x509: u32 = 0;
    let (x508, x509) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x510: u32 = 0;
    let mut x511: u32 = 0;
    let (x510, x511) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x512: u32 = 0;
    let mut x513: u32 = 0;
    let (x512, x513) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x514: u32 = 0;
    let mut x515: u32 = 0;
    let (x514, x515) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x516: u32 = 0;
    let mut x517: u32 = 0;
    let (x516, x517) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x518: u32 = 0;
    let mut x519: u32 = 0;
    let (x518, x519) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x520: u32 = 0;
    let mut x521: u32 = 0;
    let (x520, x521) = fiat_p384_scalar_mulx_u32(x506, 0xc7634d81);
    let mut x522: u32 = 0;
    let mut x523: u32 = 0;
    let (x522, x523) = fiat_p384_scalar_mulx_u32(x506, 0xf4372ddf);
    let mut x524: u32 = 0;
    let mut x525: u32 = 0;
    let (x524, x525) = fiat_p384_scalar_mulx_u32(x506, 0x581a0db2);
    let mut x526: u32 = 0;
    let mut x527: u32 = 0;
    let (x526, x527) = fiat_p384_scalar_mulx_u32(x506, 0x48b0a77a);
    let mut x528: u32 = 0;
    let mut x529: u32 = 0;
    let (x528, x529) = fiat_p384_scalar_mulx_u32(x506, 0xecec196a);
    let mut x530: u32 = 0;
    let mut x531: u32 = 0;
    let (x530, x531) = fiat_p384_scalar_mulx_u32(x506, 0xccc52973);
    let mut x532: u32 = 0;
    let mut x533: fiat_p384_scalar_u1 = 0;
    let (x532, x533) = fiat_p384_scalar_addcarryx_u32(0x0, x531, x528);
    let mut x534: u32 = 0;
    let mut x535: fiat_p384_scalar_u1 = 0;
    let (x534, x535) = fiat_p384_scalar_addcarryx_u32(x533, x529, x526);
    let mut x536: u32 = 0;
    let mut x537: fiat_p384_scalar_u1 = 0;
    let (x536, x537) = fiat_p384_scalar_addcarryx_u32(x535, x527, x524);
    let mut x538: u32 = 0;
    let mut x539: fiat_p384_scalar_u1 = 0;
    let (x538, x539) = fiat_p384_scalar_addcarryx_u32(x537, x525, x522);
    let mut x540: u32 = 0;
    let mut x541: fiat_p384_scalar_u1 = 0;
    let (x540, x541) = fiat_p384_scalar_addcarryx_u32(x539, x523, x520);
    let mut x542: u32 = 0;
    let mut x543: fiat_p384_scalar_u1 = 0;
    let (x542, x543) = fiat_p384_scalar_addcarryx_u32(x541, x521, x518);
    let mut x544: u32 = 0;
    let mut x545: fiat_p384_scalar_u1 = 0;
    let (x544, x545) = fiat_p384_scalar_addcarryx_u32(x543, x519, x516);
    let mut x546: u32 = 0;
    let mut x547: fiat_p384_scalar_u1 = 0;
    let (x546, x547) = fiat_p384_scalar_addcarryx_u32(x545, x517, x514);
    let mut x548: u32 = 0;
    let mut x549: fiat_p384_scalar_u1 = 0;
    let (x548, x549) = fiat_p384_scalar_addcarryx_u32(x547, x515, x512);
    let mut x550: u32 = 0;
    let mut x551: fiat_p384_scalar_u1 = 0;
    let (x550, x551) = fiat_p384_scalar_addcarryx_u32(x549, x513, x510);
    let mut x552: u32 = 0;
    let mut x553: fiat_p384_scalar_u1 = 0;
    let (x552, x553) = fiat_p384_scalar_addcarryx_u32(x551, x511, x508);
    let x554: u32 = ((x553 as u32) + x509);
    let mut x555: u32 = 0;
    let mut x556: fiat_p384_scalar_u1 = 0;
    let (x555, x556) = fiat_p384_scalar_addcarryx_u32(0x0, x480, x530);
    let mut x557: u32 = 0;
    let mut x558: fiat_p384_scalar_u1 = 0;
    let (x557, x558) = fiat_p384_scalar_addcarryx_u32(x556, x482, x532);
    let mut x559: u32 = 0;
    let mut x560: fiat_p384_scalar_u1 = 0;
    let (x559, x560) = fiat_p384_scalar_addcarryx_u32(x558, x484, x534);
    let mut x561: u32 = 0;
    let mut x562: fiat_p384_scalar_u1 = 0;
    let (x561, x562) = fiat_p384_scalar_addcarryx_u32(x560, x486, x536);
    let mut x563: u32 = 0;
    let mut x564: fiat_p384_scalar_u1 = 0;
    let (x563, x564) = fiat_p384_scalar_addcarryx_u32(x562, x488, x538);
    let mut x565: u32 = 0;
    let mut x566: fiat_p384_scalar_u1 = 0;
    let (x565, x566) = fiat_p384_scalar_addcarryx_u32(x564, x490, x540);
    let mut x567: u32 = 0;
    let mut x568: fiat_p384_scalar_u1 = 0;
    let (x567, x568) = fiat_p384_scalar_addcarryx_u32(x566, x492, x542);
    let mut x569: u32 = 0;
    let mut x570: fiat_p384_scalar_u1 = 0;
    let (x569, x570) = fiat_p384_scalar_addcarryx_u32(x568, x494, x544);
    let mut x571: u32 = 0;
    let mut x572: fiat_p384_scalar_u1 = 0;
    let (x571, x572) = fiat_p384_scalar_addcarryx_u32(x570, x496, x546);
    let mut x573: u32 = 0;
    let mut x574: fiat_p384_scalar_u1 = 0;
    let (x573, x574) = fiat_p384_scalar_addcarryx_u32(x572, x498, x548);
    let mut x575: u32 = 0;
    let mut x576: fiat_p384_scalar_u1 = 0;
    let (x575, x576) = fiat_p384_scalar_addcarryx_u32(x574, x500, x550);
    let mut x577: u32 = 0;
    let mut x578: fiat_p384_scalar_u1 = 0;
    let (x577, x578) = fiat_p384_scalar_addcarryx_u32(x576, x502, x552);
    let mut x579: u32 = 0;
    let mut x580: fiat_p384_scalar_u1 = 0;
    let (x579, x580) = fiat_p384_scalar_addcarryx_u32(x578, x504, x554);
    let x581: u32 = ((x580 as u32) + (x505 as u32));
    let mut x582: u32 = 0;
    let mut x583: u32 = 0;
    let (x582, x583) = fiat_p384_scalar_mulx_u32(x4, (arg2[11]));
    let mut x584: u32 = 0;
    let mut x585: u32 = 0;
    let (x584, x585) = fiat_p384_scalar_mulx_u32(x4, (arg2[10]));
    let mut x586: u32 = 0;
    let mut x587: u32 = 0;
    let (x586, x587) = fiat_p384_scalar_mulx_u32(x4, (arg2[9]));
    let mut x588: u32 = 0;
    let mut x589: u32 = 0;
    let (x588, x589) = fiat_p384_scalar_mulx_u32(x4, (arg2[8]));
    let mut x590: u32 = 0;
    let mut x591: u32 = 0;
    let (x590, x591) = fiat_p384_scalar_mulx_u32(x4, (arg2[7]));
    let mut x592: u32 = 0;
    let mut x593: u32 = 0;
    let (x592, x593) = fiat_p384_scalar_mulx_u32(x4, (arg2[6]));
    let mut x594: u32 = 0;
    let mut x595: u32 = 0;
    let (x594, x595) = fiat_p384_scalar_mulx_u32(x4, (arg2[5]));
    let mut x596: u32 = 0;
    let mut x597: u32 = 0;
    let (x596, x597) = fiat_p384_scalar_mulx_u32(x4, (arg2[4]));
    let mut x598: u32 = 0;
    let mut x599: u32 = 0;
    let (x598, x599) = fiat_p384_scalar_mulx_u32(x4, (arg2[3]));
    let mut x600: u32 = 0;
    let mut x601: u32 = 0;
    let (x600, x601) = fiat_p384_scalar_mulx_u32(x4, (arg2[2]));
    let mut x602: u32 = 0;
    let mut x603: u32 = 0;
    let (x602, x603) = fiat_p384_scalar_mulx_u32(x4, (arg2[1]));
    let mut x604: u32 = 0;
    let mut x605: u32 = 0;
    let (x604, x605) = fiat_p384_scalar_mulx_u32(x4, (arg2[0]));
    let mut x606: u32 = 0;
    let mut x607: fiat_p384_scalar_u1 = 0;
    let (x606, x607) = fiat_p384_scalar_addcarryx_u32(0x0, x605, x602);
    let mut x608: u32 = 0;
    let mut x609: fiat_p384_scalar_u1 = 0;
    let (x608, x609) = fiat_p384_scalar_addcarryx_u32(x607, x603, x600);
    let mut x610: u32 = 0;
    let mut x611: fiat_p384_scalar_u1 = 0;
    let (x610, x611) = fiat_p384_scalar_addcarryx_u32(x609, x601, x598);
    let mut x612: u32 = 0;
    let mut x613: fiat_p384_scalar_u1 = 0;
    let (x612, x613) = fiat_p384_scalar_addcarryx_u32(x611, x599, x596);
    let mut x614: u32 = 0;
    let mut x615: fiat_p384_scalar_u1 = 0;
    let (x614, x615) = fiat_p384_scalar_addcarryx_u32(x613, x597, x594);
    let mut x616: u32 = 0;
    let mut x617: fiat_p384_scalar_u1 = 0;
    let (x616, x617) = fiat_p384_scalar_addcarryx_u32(x615, x595, x592);
    let mut x618: u32 = 0;
    let mut x619: fiat_p384_scalar_u1 = 0;
    let (x618, x619) = fiat_p384_scalar_addcarryx_u32(x617, x593, x590);
    let mut x620: u32 = 0;
    let mut x621: fiat_p384_scalar_u1 = 0;
    let (x620, x621) = fiat_p384_scalar_addcarryx_u32(x619, x591, x588);
    let mut x622: u32 = 0;
    let mut x623: fiat_p384_scalar_u1 = 0;
    let (x622, x623) = fiat_p384_scalar_addcarryx_u32(x621, x589, x586);
    let mut x624: u32 = 0;
    let mut x625: fiat_p384_scalar_u1 = 0;
    let (x624, x625) = fiat_p384_scalar_addcarryx_u32(x623, x587, x584);
    let mut x626: u32 = 0;
    let mut x627: fiat_p384_scalar_u1 = 0;
    let (x626, x627) = fiat_p384_scalar_addcarryx_u32(x625, x585, x582);
    let x628: u32 = ((x627 as u32) + x583);
    let mut x629: u32 = 0;
    let mut x630: fiat_p384_scalar_u1 = 0;
    let (x629, x630) = fiat_p384_scalar_addcarryx_u32(0x0, x557, x604);
    let mut x631: u32 = 0;
    let mut x632: fiat_p384_scalar_u1 = 0;
    let (x631, x632) = fiat_p384_scalar_addcarryx_u32(x630, x559, x606);
    let mut x633: u32 = 0;
    let mut x634: fiat_p384_scalar_u1 = 0;
    let (x633, x634) = fiat_p384_scalar_addcarryx_u32(x632, x561, x608);
    let mut x635: u32 = 0;
    let mut x636: fiat_p384_scalar_u1 = 0;
    let (x635, x636) = fiat_p384_scalar_addcarryx_u32(x634, x563, x610);
    let mut x637: u32 = 0;
    let mut x638: fiat_p384_scalar_u1 = 0;
    let (x637, x638) = fiat_p384_scalar_addcarryx_u32(x636, x565, x612);
    let mut x639: u32 = 0;
    let mut x640: fiat_p384_scalar_u1 = 0;
    let (x639, x640) = fiat_p384_scalar_addcarryx_u32(x638, x567, x614);
    let mut x641: u32 = 0;
    let mut x642: fiat_p384_scalar_u1 = 0;
    let (x641, x642) = fiat_p384_scalar_addcarryx_u32(x640, x569, x616);
    let mut x643: u32 = 0;
    let mut x644: fiat_p384_scalar_u1 = 0;
    let (x643, x644) = fiat_p384_scalar_addcarryx_u32(x642, x571, x618);
    let mut x645: u32 = 0;
    let mut x646: fiat_p384_scalar_u1 = 0;
    let (x645, x646) = fiat_p384_scalar_addcarryx_u32(x644, x573, x620);
    let mut x647: u32 = 0;
    let mut x648: fiat_p384_scalar_u1 = 0;
    let (x647, x648) = fiat_p384_scalar_addcarryx_u32(x646, x575, x622);
    let mut x649: u32 = 0;
    let mut x650: fiat_p384_scalar_u1 = 0;
    let (x649, x650) = fiat_p384_scalar_addcarryx_u32(x648, x577, x624);
    let mut x651: u32 = 0;
    let mut x652: fiat_p384_scalar_u1 = 0;
    let (x651, x652) = fiat_p384_scalar_addcarryx_u32(x650, x579, x626);
    let mut x653: u32 = 0;
    let mut x654: fiat_p384_scalar_u1 = 0;
    let (x653, x654) = fiat_p384_scalar_addcarryx_u32(x652, x581, x628);
    let mut x655: u32 = 0;
    let mut x656: u32 = 0;
    let (x655, x656) = fiat_p384_scalar_mulx_u32(x629, 0xe88fdc45);
    let mut x657: u32 = 0;
    let mut x658: u32 = 0;
    let (x657, x658) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x659: u32 = 0;
    let mut x660: u32 = 0;
    let (x659, x660) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x661: u32 = 0;
    let mut x662: u32 = 0;
    let (x661, x662) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x663: u32 = 0;
    let mut x664: u32 = 0;
    let (x663, x664) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x665: u32 = 0;
    let mut x666: u32 = 0;
    let (x665, x666) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x667: u32 = 0;
    let mut x668: u32 = 0;
    let (x667, x668) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x669: u32 = 0;
    let mut x670: u32 = 0;
    let (x669, x670) = fiat_p384_scalar_mulx_u32(x655, 0xc7634d81);
    let mut x671: u32 = 0;
    let mut x672: u32 = 0;
    let (x671, x672) = fiat_p384_scalar_mulx_u32(x655, 0xf4372ddf);
    let mut x673: u32 = 0;
    let mut x674: u32 = 0;
    let (x673, x674) = fiat_p384_scalar_mulx_u32(x655, 0x581a0db2);
    let mut x675: u32 = 0;
    let mut x676: u32 = 0;
    let (x675, x676) = fiat_p384_scalar_mulx_u32(x655, 0x48b0a77a);
    let mut x677: u32 = 0;
    let mut x678: u32 = 0;
    let (x677, x678) = fiat_p384_scalar_mulx_u32(x655, 0xecec196a);
    let mut x679: u32 = 0;
    let mut x680: u32 = 0;
    let (x679, x680) = fiat_p384_scalar_mulx_u32(x655, 0xccc52973);
    let mut x681: u32 = 0;
    let mut x682: fiat_p384_scalar_u1 = 0;
    let (x681, x682) = fiat_p384_scalar_addcarryx_u32(0x0, x680, x677);
    let mut x683: u32 = 0;
    let mut x684: fiat_p384_scalar_u1 = 0;
    let (x683, x684) = fiat_p384_scalar_addcarryx_u32(x682, x678, x675);
    let mut x685: u32 = 0;
    let mut x686: fiat_p384_scalar_u1 = 0;
    let (x685, x686) = fiat_p384_scalar_addcarryx_u32(x684, x676, x673);
    let mut x687: u32 = 0;
    let mut x688: fiat_p384_scalar_u1 = 0;
    let (x687, x688) = fiat_p384_scalar_addcarryx_u32(x686, x674, x671);
    let mut x689: u32 = 0;
    let mut x690: fiat_p384_scalar_u1 = 0;
    let (x689, x690) = fiat_p384_scalar_addcarryx_u32(x688, x672, x669);
    let mut x691: u32 = 0;
    let mut x692: fiat_p384_scalar_u1 = 0;
    let (x691, x692) = fiat_p384_scalar_addcarryx_u32(x690, x670, x667);
    let mut x693: u32 = 0;
    let mut x694: fiat_p384_scalar_u1 = 0;
    let (x693, x694) = fiat_p384_scalar_addcarryx_u32(x692, x668, x665);
    let mut x695: u32 = 0;
    let mut x696: fiat_p384_scalar_u1 = 0;
    let (x695, x696) = fiat_p384_scalar_addcarryx_u32(x694, x666, x663);
    let mut x697: u32 = 0;
    let mut x698: fiat_p384_scalar_u1 = 0;
    let (x697, x698) = fiat_p384_scalar_addcarryx_u32(x696, x664, x661);
    let mut x699: u32 = 0;
    let mut x700: fiat_p384_scalar_u1 = 0;
    let (x699, x700) = fiat_p384_scalar_addcarryx_u32(x698, x662, x659);
    let mut x701: u32 = 0;
    let mut x702: fiat_p384_scalar_u1 = 0;
    let (x701, x702) = fiat_p384_scalar_addcarryx_u32(x700, x660, x657);
    let x703: u32 = ((x702 as u32) + x658);
    let mut x704: u32 = 0;
    let mut x705: fiat_p384_scalar_u1 = 0;
    let (x704, x705) = fiat_p384_scalar_addcarryx_u32(0x0, x629, x679);
    let mut x706: u32 = 0;
    let mut x707: fiat_p384_scalar_u1 = 0;
    let (x706, x707) = fiat_p384_scalar_addcarryx_u32(x705, x631, x681);
    let mut x708: u32 = 0;
    let mut x709: fiat_p384_scalar_u1 = 0;
    let (x708, x709) = fiat_p384_scalar_addcarryx_u32(x707, x633, x683);
    let mut x710: u32 = 0;
    let mut x711: fiat_p384_scalar_u1 = 0;
    let (x710, x711) = fiat_p384_scalar_addcarryx_u32(x709, x635, x685);
    let mut x712: u32 = 0;
    let mut x713: fiat_p384_scalar_u1 = 0;
    let (x712, x713) = fiat_p384_scalar_addcarryx_u32(x711, x637, x687);
    let mut x714: u32 = 0;
    let mut x715: fiat_p384_scalar_u1 = 0;
    let (x714, x715) = fiat_p384_scalar_addcarryx_u32(x713, x639, x689);
    let mut x716: u32 = 0;
    let mut x717: fiat_p384_scalar_u1 = 0;
    let (x716, x717) = fiat_p384_scalar_addcarryx_u32(x715, x641, x691);
    let mut x718: u32 = 0;
    let mut x719: fiat_p384_scalar_u1 = 0;
    let (x718, x719) = fiat_p384_scalar_addcarryx_u32(x717, x643, x693);
    let mut x720: u32 = 0;
    let mut x721: fiat_p384_scalar_u1 = 0;
    let (x720, x721) = fiat_p384_scalar_addcarryx_u32(x719, x645, x695);
    let mut x722: u32 = 0;
    let mut x723: fiat_p384_scalar_u1 = 0;
    let (x722, x723) = fiat_p384_scalar_addcarryx_u32(x721, x647, x697);
    let mut x724: u32 = 0;
    let mut x725: fiat_p384_scalar_u1 = 0;
    let (x724, x725) = fiat_p384_scalar_addcarryx_u32(x723, x649, x699);
    let mut x726: u32 = 0;
    let mut x727: fiat_p384_scalar_u1 = 0;
    let (x726, x727) = fiat_p384_scalar_addcarryx_u32(x725, x651, x701);
    let mut x728: u32 = 0;
    let mut x729: fiat_p384_scalar_u1 = 0;
    let (x728, x729) = fiat_p384_scalar_addcarryx_u32(x727, x653, x703);
    let x730: u32 = ((x729 as u32) + (x654 as u32));
    let mut x731: u32 = 0;
    let mut x732: u32 = 0;
    let (x731, x732) = fiat_p384_scalar_mulx_u32(x5, (arg2[11]));
    let mut x733: u32 = 0;
    let mut x734: u32 = 0;
    let (x733, x734) = fiat_p384_scalar_mulx_u32(x5, (arg2[10]));
    let mut x735: u32 = 0;
    let mut x736: u32 = 0;
    let (x735, x736) = fiat_p384_scalar_mulx_u32(x5, (arg2[9]));
    let mut x737: u32 = 0;
    let mut x738: u32 = 0;
    let (x737, x738) = fiat_p384_scalar_mulx_u32(x5, (arg2[8]));
    let mut x739: u32 = 0;
    let mut x740: u32 = 0;
    let (x739, x740) = fiat_p384_scalar_mulx_u32(x5, (arg2[7]));
    let mut x741: u32 = 0;
    let mut x742: u32 = 0;
    let (x741, x742) = fiat_p384_scalar_mulx_u32(x5, (arg2[6]));
    let mut x743: u32 = 0;
    let mut x744: u32 = 0;
    let (x743, x744) = fiat_p384_scalar_mulx_u32(x5, (arg2[5]));
    let mut x745: u32 = 0;
    let mut x746: u32 = 0;
    let (x745, x746) = fiat_p384_scalar_mulx_u32(x5, (arg2[4]));
    let mut x747: u32 = 0;
    let mut x748: u32 = 0;
    let (x747, x748) = fiat_p384_scalar_mulx_u32(x5, (arg2[3]));
    let mut x749: u32 = 0;
    let mut x750: u32 = 0;
    let (x749, x750) = fiat_p384_scalar_mulx_u32(x5, (arg2[2]));
    let mut x751: u32 = 0;
    let mut x752: u32 = 0;
    let (x751, x752) = fiat_p384_scalar_mulx_u32(x5, (arg2[1]));
    let mut x753: u32 = 0;
    let mut x754: u32 = 0;
    let (x753, x754) = fiat_p384_scalar_mulx_u32(x5, (arg2[0]));
    let mut x755: u32 = 0;
    let mut x756: fiat_p384_scalar_u1 = 0;
    let (x755, x756) = fiat_p384_scalar_addcarryx_u32(0x0, x754, x751);
    let mut x757: u32 = 0;
    let mut x758: fiat_p384_scalar_u1 = 0;
    let (x757, x758) = fiat_p384_scalar_addcarryx_u32(x756, x752, x749);
    let mut x759: u32 = 0;
    let mut x760: fiat_p384_scalar_u1 = 0;
    let (x759, x760) = fiat_p384_scalar_addcarryx_u32(x758, x750, x747);
    let mut x761: u32 = 0;
    let mut x762: fiat_p384_scalar_u1 = 0;
    let (x761, x762) = fiat_p384_scalar_addcarryx_u32(x760, x748, x745);
    let mut x763: u32 = 0;
    let mut x764: fiat_p384_scalar_u1 = 0;
    let (x763, x764) = fiat_p384_scalar_addcarryx_u32(x762, x746, x743);
    let mut x765: u32 = 0;
    let mut x766: fiat_p384_scalar_u1 = 0;
    let (x765, x766) = fiat_p384_scalar_addcarryx_u32(x764, x744, x741);
    let mut x767: u32 = 0;
    let mut x768: fiat_p384_scalar_u1 = 0;
    let (x767, x768) = fiat_p384_scalar_addcarryx_u32(x766, x742, x739);
    let mut x769: u32 = 0;
    let mut x770: fiat_p384_scalar_u1 = 0;
    let (x769, x770) = fiat_p384_scalar_addcarryx_u32(x768, x740, x737);
    let mut x771: u32 = 0;
    let mut x772: fiat_p384_scalar_u1 = 0;
    let (x771, x772) = fiat_p384_scalar_addcarryx_u32(x770, x738, x735);
    let mut x773: u32 = 0;
    let mut x774: fiat_p384_scalar_u1 = 0;
    let (x773, x774) = fiat_p384_scalar_addcarryx_u32(x772, x736, x733);
    let mut x775: u32 = 0;
    let mut x776: fiat_p384_scalar_u1 = 0;
    let (x775, x776) = fiat_p384_scalar_addcarryx_u32(x774, x734, x731);
    let x777: u32 = ((x776 as u32) + x732);
    let mut x778: u32 = 0;
    let mut x779: fiat_p384_scalar_u1 = 0;
    let (x778, x779) = fiat_p384_scalar_addcarryx_u32(0x0, x706, x753);
    let mut x780: u32 = 0;
    let mut x781: fiat_p384_scalar_u1 = 0;
    let (x780, x781) = fiat_p384_scalar_addcarryx_u32(x779, x708, x755);
    let mut x782: u32 = 0;
    let mut x783: fiat_p384_scalar_u1 = 0;
    let (x782, x783) = fiat_p384_scalar_addcarryx_u32(x781, x710, x757);
    let mut x784: u32 = 0;
    let mut x785: fiat_p384_scalar_u1 = 0;
    let (x784, x785) = fiat_p384_scalar_addcarryx_u32(x783, x712, x759);
    let mut x786: u32 = 0;
    let mut x787: fiat_p384_scalar_u1 = 0;
    let (x786, x787) = fiat_p384_scalar_addcarryx_u32(x785, x714, x761);
    let mut x788: u32 = 0;
    let mut x789: fiat_p384_scalar_u1 = 0;
    let (x788, x789) = fiat_p384_scalar_addcarryx_u32(x787, x716, x763);
    let mut x790: u32 = 0;
    let mut x791: fiat_p384_scalar_u1 = 0;
    let (x790, x791) = fiat_p384_scalar_addcarryx_u32(x789, x718, x765);
    let mut x792: u32 = 0;
    let mut x793: fiat_p384_scalar_u1 = 0;
    let (x792, x793) = fiat_p384_scalar_addcarryx_u32(x791, x720, x767);
    let mut x794: u32 = 0;
    let mut x795: fiat_p384_scalar_u1 = 0;
    let (x794, x795) = fiat_p384_scalar_addcarryx_u32(x793, x722, x769);
    let mut x796: u32 = 0;
    let mut x797: fiat_p384_scalar_u1 = 0;
    let (x796, x797) = fiat_p384_scalar_addcarryx_u32(x795, x724, x771);
    let mut x798: u32 = 0;
    let mut x799: fiat_p384_scalar_u1 = 0;
    let (x798, x799) = fiat_p384_scalar_addcarryx_u32(x797, x726, x773);
    let mut x800: u32 = 0;
    let mut x801: fiat_p384_scalar_u1 = 0;
    let (x800, x801) = fiat_p384_scalar_addcarryx_u32(x799, x728, x775);
    let mut x802: u32 = 0;
    let mut x803: fiat_p384_scalar_u1 = 0;
    let (x802, x803) = fiat_p384_scalar_addcarryx_u32(x801, x730, x777);
    let mut x804: u32 = 0;
    let mut x805: u32 = 0;
    let (x804, x805) = fiat_p384_scalar_mulx_u32(x778, 0xe88fdc45);
    let mut x806: u32 = 0;
    let mut x807: u32 = 0;
    let (x806, x807) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x808: u32 = 0;
    let mut x809: u32 = 0;
    let (x808, x809) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x810: u32 = 0;
    let mut x811: u32 = 0;
    let (x810, x811) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x812: u32 = 0;
    let mut x813: u32 = 0;
    let (x812, x813) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x814: u32 = 0;
    let mut x815: u32 = 0;
    let (x814, x815) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x816: u32 = 0;
    let mut x817: u32 = 0;
    let (x816, x817) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x818: u32 = 0;
    let mut x819: u32 = 0;
    let (x818, x819) = fiat_p384_scalar_mulx_u32(x804, 0xc7634d81);
    let mut x820: u32 = 0;
    let mut x821: u32 = 0;
    let (x820, x821) = fiat_p384_scalar_mulx_u32(x804, 0xf4372ddf);
    let mut x822: u32 = 0;
    let mut x823: u32 = 0;
    let (x822, x823) = fiat_p384_scalar_mulx_u32(x804, 0x581a0db2);
    let mut x824: u32 = 0;
    let mut x825: u32 = 0;
    let (x824, x825) = fiat_p384_scalar_mulx_u32(x804, 0x48b0a77a);
    let mut x826: u32 = 0;
    let mut x827: u32 = 0;
    let (x826, x827) = fiat_p384_scalar_mulx_u32(x804, 0xecec196a);
    let mut x828: u32 = 0;
    let mut x829: u32 = 0;
    let (x828, x829) = fiat_p384_scalar_mulx_u32(x804, 0xccc52973);
    let mut x830: u32 = 0;
    let mut x831: fiat_p384_scalar_u1 = 0;
    let (x830, x831) = fiat_p384_scalar_addcarryx_u32(0x0, x829, x826);
    let mut x832: u32 = 0;
    let mut x833: fiat_p384_scalar_u1 = 0;
    let (x832, x833) = fiat_p384_scalar_addcarryx_u32(x831, x827, x824);
    let mut x834: u32 = 0;
    let mut x835: fiat_p384_scalar_u1 = 0;
    let (x834, x835) = fiat_p384_scalar_addcarryx_u32(x833, x825, x822);
    let mut x836: u32 = 0;
    let mut x837: fiat_p384_scalar_u1 = 0;
    let (x836, x837) = fiat_p384_scalar_addcarryx_u32(x835, x823, x820);
    let mut x838: u32 = 0;
    let mut x839: fiat_p384_scalar_u1 = 0;
    let (x838, x839) = fiat_p384_scalar_addcarryx_u32(x837, x821, x818);
    let mut x840: u32 = 0;
    let mut x841: fiat_p384_scalar_u1 = 0;
    let (x840, x841) = fiat_p384_scalar_addcarryx_u32(x839, x819, x816);
    let mut x842: u32 = 0;
    let mut x843: fiat_p384_scalar_u1 = 0;
    let (x842, x843) = fiat_p384_scalar_addcarryx_u32(x841, x817, x814);
    let mut x844: u32 = 0;
    let mut x845: fiat_p384_scalar_u1 = 0;
    let (x844, x845) = fiat_p384_scalar_addcarryx_u32(x843, x815, x812);
    let mut x846: u32 = 0;
    let mut x847: fiat_p384_scalar_u1 = 0;
    let (x846, x847) = fiat_p384_scalar_addcarryx_u32(x845, x813, x810);
    let mut x848: u32 = 0;
    let mut x849: fiat_p384_scalar_u1 = 0;
    let (x848, x849) = fiat_p384_scalar_addcarryx_u32(x847, x811, x808);
    let mut x850: u32 = 0;
    let mut x851: fiat_p384_scalar_u1 = 0;
    let (x850, x851) = fiat_p384_scalar_addcarryx_u32(x849, x809, x806);
    let x852: u32 = ((x851 as u32) + x807);
    let mut x853: u32 = 0;
    let mut x854: fiat_p384_scalar_u1 = 0;
    let (x853, x854) = fiat_p384_scalar_addcarryx_u32(0x0, x778, x828);
    let mut x855: u32 = 0;
    let mut x856: fiat_p384_scalar_u1 = 0;
    let (x855, x856) = fiat_p384_scalar_addcarryx_u32(x854, x780, x830);
    let mut x857: u32 = 0;
    let mut x858: fiat_p384_scalar_u1 = 0;
    let (x857, x858) = fiat_p384_scalar_addcarryx_u32(x856, x782, x832);
    let mut x859: u32 = 0;
    let mut x860: fiat_p384_scalar_u1 = 0;
    let (x859, x860) = fiat_p384_scalar_addcarryx_u32(x858, x784, x834);
    let mut x861: u32 = 0;
    let mut x862: fiat_p384_scalar_u1 = 0;
    let (x861, x862) = fiat_p384_scalar_addcarryx_u32(x860, x786, x836);
    let mut x863: u32 = 0;
    let mut x864: fiat_p384_scalar_u1 = 0;
    let (x863, x864) = fiat_p384_scalar_addcarryx_u32(x862, x788, x838);
    let mut x865: u32 = 0;
    let mut x866: fiat_p384_scalar_u1 = 0;
    let (x865, x866) = fiat_p384_scalar_addcarryx_u32(x864, x790, x840);
    let mut x867: u32 = 0;
    let mut x868: fiat_p384_scalar_u1 = 0;
    let (x867, x868) = fiat_p384_scalar_addcarryx_u32(x866, x792, x842);
    let mut x869: u32 = 0;
    let mut x870: fiat_p384_scalar_u1 = 0;
    let (x869, x870) = fiat_p384_scalar_addcarryx_u32(x868, x794, x844);
    let mut x871: u32 = 0;
    let mut x872: fiat_p384_scalar_u1 = 0;
    let (x871, x872) = fiat_p384_scalar_addcarryx_u32(x870, x796, x846);
    let mut x873: u32 = 0;
    let mut x874: fiat_p384_scalar_u1 = 0;
    let (x873, x874) = fiat_p384_scalar_addcarryx_u32(x872, x798, x848);
    let mut x875: u32 = 0;
    let mut x876: fiat_p384_scalar_u1 = 0;
    let (x875, x876) = fiat_p384_scalar_addcarryx_u32(x874, x800, x850);
    let mut x877: u32 = 0;
    let mut x878: fiat_p384_scalar_u1 = 0;
    let (x877, x878) = fiat_p384_scalar_addcarryx_u32(x876, x802, x852);
    let x879: u32 = ((x878 as u32) + (x803 as u32));
    let mut x880: u32 = 0;
    let mut x881: u32 = 0;
    let (x880, x881) = fiat_p384_scalar_mulx_u32(x6, (arg2[11]));
    let mut x882: u32 = 0;
    let mut x883: u32 = 0;
    let (x882, x883) = fiat_p384_scalar_mulx_u32(x6, (arg2[10]));
    let mut x884: u32 = 0;
    let mut x885: u32 = 0;
    let (x884, x885) = fiat_p384_scalar_mulx_u32(x6, (arg2[9]));
    let mut x886: u32 = 0;
    let mut x887: u32 = 0;
    let (x886, x887) = fiat_p384_scalar_mulx_u32(x6, (arg2[8]));
    let mut x888: u32 = 0;
    let mut x889: u32 = 0;
    let (x888, x889) = fiat_p384_scalar_mulx_u32(x6, (arg2[7]));
    let mut x890: u32 = 0;
    let mut x891: u32 = 0;
    let (x890, x891) = fiat_p384_scalar_mulx_u32(x6, (arg2[6]));
    let mut x892: u32 = 0;
    let mut x893: u32 = 0;
    let (x892, x893) = fiat_p384_scalar_mulx_u32(x6, (arg2[5]));
    let mut x894: u32 = 0;
    let mut x895: u32 = 0;
    let (x894, x895) = fiat_p384_scalar_mulx_u32(x6, (arg2[4]));
    let mut x896: u32 = 0;
    let mut x897: u32 = 0;
    let (x896, x897) = fiat_p384_scalar_mulx_u32(x6, (arg2[3]));
    let mut x898: u32 = 0;
    let mut x899: u32 = 0;
    let (x898, x899) = fiat_p384_scalar_mulx_u32(x6, (arg2[2]));
    let mut x900: u32 = 0;
    let mut x901: u32 = 0;
    let (x900, x901) = fiat_p384_scalar_mulx_u32(x6, (arg2[1]));
    let mut x902: u32 = 0;
    let mut x903: u32 = 0;
    let (x902, x903) = fiat_p384_scalar_mulx_u32(x6, (arg2[0]));
    let mut x904: u32 = 0;
    let mut x905: fiat_p384_scalar_u1 = 0;
    let (x904, x905) = fiat_p384_scalar_addcarryx_u32(0x0, x903, x900);
    let mut x906: u32 = 0;
    let mut x907: fiat_p384_scalar_u1 = 0;
    let (x906, x907) = fiat_p384_scalar_addcarryx_u32(x905, x901, x898);
    let mut x908: u32 = 0;
    let mut x909: fiat_p384_scalar_u1 = 0;
    let (x908, x909) = fiat_p384_scalar_addcarryx_u32(x907, x899, x896);
    let mut x910: u32 = 0;
    let mut x911: fiat_p384_scalar_u1 = 0;
    let (x910, x911) = fiat_p384_scalar_addcarryx_u32(x909, x897, x894);
    let mut x912: u32 = 0;
    let mut x913: fiat_p384_scalar_u1 = 0;
    let (x912, x913) = fiat_p384_scalar_addcarryx_u32(x911, x895, x892);
    let mut x914: u32 = 0;
    let mut x915: fiat_p384_scalar_u1 = 0;
    let (x914, x915) = fiat_p384_scalar_addcarryx_u32(x913, x893, x890);
    let mut x916: u32 = 0;
    let mut x917: fiat_p384_scalar_u1 = 0;
    let (x916, x917) = fiat_p384_scalar_addcarryx_u32(x915, x891, x888);
    let mut x918: u32 = 0;
    let mut x919: fiat_p384_scalar_u1 = 0;
    let (x918, x919) = fiat_p384_scalar_addcarryx_u32(x917, x889, x886);
    let mut x920: u32 = 0;
    let mut x921: fiat_p384_scalar_u1 = 0;
    let (x920, x921) = fiat_p384_scalar_addcarryx_u32(x919, x887, x884);
    let mut x922: u32 = 0;
    let mut x923: fiat_p384_scalar_u1 = 0;
    let (x922, x923) = fiat_p384_scalar_addcarryx_u32(x921, x885, x882);
    let mut x924: u32 = 0;
    let mut x925: fiat_p384_scalar_u1 = 0;
    let (x924, x925) = fiat_p384_scalar_addcarryx_u32(x923, x883, x880);
    let x926: u32 = ((x925 as u32) + x881);
    let mut x927: u32 = 0;
    let mut x928: fiat_p384_scalar_u1 = 0;
    let (x927, x928) = fiat_p384_scalar_addcarryx_u32(0x0, x855, x902);
    let mut x929: u32 = 0;
    let mut x930: fiat_p384_scalar_u1 = 0;
    let (x929, x930) = fiat_p384_scalar_addcarryx_u32(x928, x857, x904);
    let mut x931: u32 = 0;
    let mut x932: fiat_p384_scalar_u1 = 0;
    let (x931, x932) = fiat_p384_scalar_addcarryx_u32(x930, x859, x906);
    let mut x933: u32 = 0;
    let mut x934: fiat_p384_scalar_u1 = 0;
    let (x933, x934) = fiat_p384_scalar_addcarryx_u32(x932, x861, x908);
    let mut x935: u32 = 0;
    let mut x936: fiat_p384_scalar_u1 = 0;
    let (x935, x936) = fiat_p384_scalar_addcarryx_u32(x934, x863, x910);
    let mut x937: u32 = 0;
    let mut x938: fiat_p384_scalar_u1 = 0;
    let (x937, x938) = fiat_p384_scalar_addcarryx_u32(x936, x865, x912);
    let mut x939: u32 = 0;
    let mut x940: fiat_p384_scalar_u1 = 0;
    let (x939, x940) = fiat_p384_scalar_addcarryx_u32(x938, x867, x914);
    let mut x941: u32 = 0;
    let mut x942: fiat_p384_scalar_u1 = 0;
    let (x941, x942) = fiat_p384_scalar_addcarryx_u32(x940, x869, x916);
    let mut x943: u32 = 0;
    let mut x944: fiat_p384_scalar_u1 = 0;
    let (x943, x944) = fiat_p384_scalar_addcarryx_u32(x942, x871, x918);
    let mut x945: u32 = 0;
    let mut x946: fiat_p384_scalar_u1 = 0;
    let (x945, x946) = fiat_p384_scalar_addcarryx_u32(x944, x873, x920);
    let mut x947: u32 = 0;
    let mut x948: fiat_p384_scalar_u1 = 0;
    let (x947, x948) = fiat_p384_scalar_addcarryx_u32(x946, x875, x922);
    let mut x949: u32 = 0;
    let mut x950: fiat_p384_scalar_u1 = 0;
    let (x949, x950) = fiat_p384_scalar_addcarryx_u32(x948, x877, x924);
    let mut x951: u32 = 0;
    let mut x952: fiat_p384_scalar_u1 = 0;
    let (x951, x952) = fiat_p384_scalar_addcarryx_u32(x950, x879, x926);
    let mut x953: u32 = 0;
    let mut x954: u32 = 0;
    let (x953, x954) = fiat_p384_scalar_mulx_u32(x927, 0xe88fdc45);
    let mut x955: u32 = 0;
    let mut x956: u32 = 0;
    let (x955, x956) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x957: u32 = 0;
    let mut x958: u32 = 0;
    let (x957, x958) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x959: u32 = 0;
    let mut x960: u32 = 0;
    let (x959, x960) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x961: u32 = 0;
    let mut x962: u32 = 0;
    let (x961, x962) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x963: u32 = 0;
    let mut x964: u32 = 0;
    let (x963, x964) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x965: u32 = 0;
    let mut x966: u32 = 0;
    let (x965, x966) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x967: u32 = 0;
    let mut x968: u32 = 0;
    let (x967, x968) = fiat_p384_scalar_mulx_u32(x953, 0xc7634d81);
    let mut x969: u32 = 0;
    let mut x970: u32 = 0;
    let (x969, x970) = fiat_p384_scalar_mulx_u32(x953, 0xf4372ddf);
    let mut x971: u32 = 0;
    let mut x972: u32 = 0;
    let (x971, x972) = fiat_p384_scalar_mulx_u32(x953, 0x581a0db2);
    let mut x973: u32 = 0;
    let mut x974: u32 = 0;
    let (x973, x974) = fiat_p384_scalar_mulx_u32(x953, 0x48b0a77a);
    let mut x975: u32 = 0;
    let mut x976: u32 = 0;
    let (x975, x976) = fiat_p384_scalar_mulx_u32(x953, 0xecec196a);
    let mut x977: u32 = 0;
    let mut x978: u32 = 0;
    let (x977, x978) = fiat_p384_scalar_mulx_u32(x953, 0xccc52973);
    let mut x979: u32 = 0;
    let mut x980: fiat_p384_scalar_u1 = 0;
    let (x979, x980) = fiat_p384_scalar_addcarryx_u32(0x0, x978, x975);
    let mut x981: u32 = 0;
    let mut x982: fiat_p384_scalar_u1 = 0;
    let (x981, x982) = fiat_p384_scalar_addcarryx_u32(x980, x976, x973);
    let mut x983: u32 = 0;
    let mut x984: fiat_p384_scalar_u1 = 0;
    let (x983, x984) = fiat_p384_scalar_addcarryx_u32(x982, x974, x971);
    let mut x985: u32 = 0;
    let mut x986: fiat_p384_scalar_u1 = 0;
    let (x985, x986) = fiat_p384_scalar_addcarryx_u32(x984, x972, x969);
    let mut x987: u32 = 0;
    let mut x988: fiat_p384_scalar_u1 = 0;
    let (x987, x988) = fiat_p384_scalar_addcarryx_u32(x986, x970, x967);
    let mut x989: u32 = 0;
    let mut x990: fiat_p384_scalar_u1 = 0;
    let (x989, x990) = fiat_p384_scalar_addcarryx_u32(x988, x968, x965);
    let mut x991: u32 = 0;
    let mut x992: fiat_p384_scalar_u1 = 0;
    let (x991, x992) = fiat_p384_scalar_addcarryx_u32(x990, x966, x963);
    let mut x993: u32 = 0;
    let mut x994: fiat_p384_scalar_u1 = 0;
    let (x993, x994) = fiat_p384_scalar_addcarryx_u32(x992, x964, x961);
    let mut x995: u32 = 0;
    let mut x996: fiat_p384_scalar_u1 = 0;
    let (x995, x996) = fiat_p384_scalar_addcarryx_u32(x994, x962, x959);
    let mut x997: u32 = 0;
    let mut x998: fiat_p384_scalar_u1 = 0;
    let (x997, x998) = fiat_p384_scalar_addcarryx_u32(x996, x960, x957);
    let mut x999: u32 = 0;
    let mut x1000: fiat_p384_scalar_u1 = 0;
    let (x999, x1000) = fiat_p384_scalar_addcarryx_u32(x998, x958, x955);
    let x1001: u32 = ((x1000 as u32) + x956);
    let mut x1002: u32 = 0;
    let mut x1003: fiat_p384_scalar_u1 = 0;
    let (x1002, x1003) = fiat_p384_scalar_addcarryx_u32(0x0, x927, x977);
    let mut x1004: u32 = 0;
    let mut x1005: fiat_p384_scalar_u1 = 0;
    let (x1004, x1005) = fiat_p384_scalar_addcarryx_u32(x1003, x929, x979);
    let mut x1006: u32 = 0;
    let mut x1007: fiat_p384_scalar_u1 = 0;
    let (x1006, x1007) = fiat_p384_scalar_addcarryx_u32(x1005, x931, x981);
    let mut x1008: u32 = 0;
    let mut x1009: fiat_p384_scalar_u1 = 0;
    let (x1008, x1009) = fiat_p384_scalar_addcarryx_u32(x1007, x933, x983);
    let mut x1010: u32 = 0;
    let mut x1011: fiat_p384_scalar_u1 = 0;
    let (x1010, x1011) = fiat_p384_scalar_addcarryx_u32(x1009, x935, x985);
    let mut x1012: u32 = 0;
    let mut x1013: fiat_p384_scalar_u1 = 0;
    let (x1012, x1013) = fiat_p384_scalar_addcarryx_u32(x1011, x937, x987);
    let mut x1014: u32 = 0;
    let mut x1015: fiat_p384_scalar_u1 = 0;
    let (x1014, x1015) = fiat_p384_scalar_addcarryx_u32(x1013, x939, x989);
    let mut x1016: u32 = 0;
    let mut x1017: fiat_p384_scalar_u1 = 0;
    let (x1016, x1017) = fiat_p384_scalar_addcarryx_u32(x1015, x941, x991);
    let mut x1018: u32 = 0;
    let mut x1019: fiat_p384_scalar_u1 = 0;
    let (x1018, x1019) = fiat_p384_scalar_addcarryx_u32(x1017, x943, x993);
    let mut x1020: u32 = 0;
    let mut x1021: fiat_p384_scalar_u1 = 0;
    let (x1020, x1021) = fiat_p384_scalar_addcarryx_u32(x1019, x945, x995);
    let mut x1022: u32 = 0;
    let mut x1023: fiat_p384_scalar_u1 = 0;
    let (x1022, x1023) = fiat_p384_scalar_addcarryx_u32(x1021, x947, x997);
    let mut x1024: u32 = 0;
    let mut x1025: fiat_p384_scalar_u1 = 0;
    let (x1024, x1025) = fiat_p384_scalar_addcarryx_u32(x1023, x949, x999);
    let mut x1026: u32 = 0;
    let mut x1027: fiat_p384_scalar_u1 = 0;
    let (x1026, x1027) = fiat_p384_scalar_addcarryx_u32(x1025, x951, x1001);
    let x1028: u32 = ((x1027 as u32) + (x952 as u32));
    let mut x1029: u32 = 0;
    let mut x1030: u32 = 0;
    let (x1029, x1030) = fiat_p384_scalar_mulx_u32(x7, (arg2[11]));
    let mut x1031: u32 = 0;
    let mut x1032: u32 = 0;
    let (x1031, x1032) = fiat_p384_scalar_mulx_u32(x7, (arg2[10]));
    let mut x1033: u32 = 0;
    let mut x1034: u32 = 0;
    let (x1033, x1034) = fiat_p384_scalar_mulx_u32(x7, (arg2[9]));
    let mut x1035: u32 = 0;
    let mut x1036: u32 = 0;
    let (x1035, x1036) = fiat_p384_scalar_mulx_u32(x7, (arg2[8]));
    let mut x1037: u32 = 0;
    let mut x1038: u32 = 0;
    let (x1037, x1038) = fiat_p384_scalar_mulx_u32(x7, (arg2[7]));
    let mut x1039: u32 = 0;
    let mut x1040: u32 = 0;
    let (x1039, x1040) = fiat_p384_scalar_mulx_u32(x7, (arg2[6]));
    let mut x1041: u32 = 0;
    let mut x1042: u32 = 0;
    let (x1041, x1042) = fiat_p384_scalar_mulx_u32(x7, (arg2[5]));
    let mut x1043: u32 = 0;
    let mut x1044: u32 = 0;
    let (x1043, x1044) = fiat_p384_scalar_mulx_u32(x7, (arg2[4]));
    let mut x1045: u32 = 0;
    let mut x1046: u32 = 0;
    let (x1045, x1046) = fiat_p384_scalar_mulx_u32(x7, (arg2[3]));
    let mut x1047: u32 = 0;
    let mut x1048: u32 = 0;
    let (x1047, x1048) = fiat_p384_scalar_mulx_u32(x7, (arg2[2]));
    let mut x1049: u32 = 0;
    let mut x1050: u32 = 0;
    let (x1049, x1050) = fiat_p384_scalar_mulx_u32(x7, (arg2[1]));
    let mut x1051: u32 = 0;
    let mut x1052: u32 = 0;
    let (x1051, x1052) = fiat_p384_scalar_mulx_u32(x7, (arg2[0]));
    let mut x1053: u32 = 0;
    let mut x1054: fiat_p384_scalar_u1 = 0;
    let (x1053, x1054) = fiat_p384_scalar_addcarryx_u32(0x0, x1052, x1049);
    let mut x1055: u32 = 0;
    let mut x1056: fiat_p384_scalar_u1 = 0;
    let (x1055, x1056) = fiat_p384_scalar_addcarryx_u32(x1054, x1050, x1047);
    let mut x1057: u32 = 0;
    let mut x1058: fiat_p384_scalar_u1 = 0;
    let (x1057, x1058) = fiat_p384_scalar_addcarryx_u32(x1056, x1048, x1045);
    let mut x1059: u32 = 0;
    let mut x1060: fiat_p384_scalar_u1 = 0;
    let (x1059, x1060) = fiat_p384_scalar_addcarryx_u32(x1058, x1046, x1043);
    let mut x1061: u32 = 0;
    let mut x1062: fiat_p384_scalar_u1 = 0;
    let (x1061, x1062) = fiat_p384_scalar_addcarryx_u32(x1060, x1044, x1041);
    let mut x1063: u32 = 0;
    let mut x1064: fiat_p384_scalar_u1 = 0;
    let (x1063, x1064) = fiat_p384_scalar_addcarryx_u32(x1062, x1042, x1039);
    let mut x1065: u32 = 0;
    let mut x1066: fiat_p384_scalar_u1 = 0;
    let (x1065, x1066) = fiat_p384_scalar_addcarryx_u32(x1064, x1040, x1037);
    let mut x1067: u32 = 0;
    let mut x1068: fiat_p384_scalar_u1 = 0;
    let (x1067, x1068) = fiat_p384_scalar_addcarryx_u32(x1066, x1038, x1035);
    let mut x1069: u32 = 0;
    let mut x1070: fiat_p384_scalar_u1 = 0;
    let (x1069, x1070) = fiat_p384_scalar_addcarryx_u32(x1068, x1036, x1033);
    let mut x1071: u32 = 0;
    let mut x1072: fiat_p384_scalar_u1 = 0;
    let (x1071, x1072) = fiat_p384_scalar_addcarryx_u32(x1070, x1034, x1031);
    let mut x1073: u32 = 0;
    let mut x1074: fiat_p384_scalar_u1 = 0;
    let (x1073, x1074) = fiat_p384_scalar_addcarryx_u32(x1072, x1032, x1029);
    let x1075: u32 = ((x1074 as u32) + x1030);
    let mut x1076: u32 = 0;
    let mut x1077: fiat_p384_scalar_u1 = 0;
    let (x1076, x1077) = fiat_p384_scalar_addcarryx_u32(0x0, x1004, x1051);
    let mut x1078: u32 = 0;
    let mut x1079: fiat_p384_scalar_u1 = 0;
    let (x1078, x1079) = fiat_p384_scalar_addcarryx_u32(x1077, x1006, x1053);
    let mut x1080: u32 = 0;
    let mut x1081: fiat_p384_scalar_u1 = 0;
    let (x1080, x1081) = fiat_p384_scalar_addcarryx_u32(x1079, x1008, x1055);
    let mut x1082: u32 = 0;
    let mut x1083: fiat_p384_scalar_u1 = 0;
    let (x1082, x1083) = fiat_p384_scalar_addcarryx_u32(x1081, x1010, x1057);
    let mut x1084: u32 = 0;
    let mut x1085: fiat_p384_scalar_u1 = 0;
    let (x1084, x1085) = fiat_p384_scalar_addcarryx_u32(x1083, x1012, x1059);
    let mut x1086: u32 = 0;
    let mut x1087: fiat_p384_scalar_u1 = 0;
    let (x1086, x1087) = fiat_p384_scalar_addcarryx_u32(x1085, x1014, x1061);
    let mut x1088: u32 = 0;
    let mut x1089: fiat_p384_scalar_u1 = 0;
    let (x1088, x1089) = fiat_p384_scalar_addcarryx_u32(x1087, x1016, x1063);
    let mut x1090: u32 = 0;
    let mut x1091: fiat_p384_scalar_u1 = 0;
    let (x1090, x1091) = fiat_p384_scalar_addcarryx_u32(x1089, x1018, x1065);
    let mut x1092: u32 = 0;
    let mut x1093: fiat_p384_scalar_u1 = 0;
    let (x1092, x1093) = fiat_p384_scalar_addcarryx_u32(x1091, x1020, x1067);
    let mut x1094: u32 = 0;
    let mut x1095: fiat_p384_scalar_u1 = 0;
    let (x1094, x1095) = fiat_p384_scalar_addcarryx_u32(x1093, x1022, x1069);
    let mut x1096: u32 = 0;
    let mut x1097: fiat_p384_scalar_u1 = 0;
    let (x1096, x1097) = fiat_p384_scalar_addcarryx_u32(x1095, x1024, x1071);
    let mut x1098: u32 = 0;
    let mut x1099: fiat_p384_scalar_u1 = 0;
    let (x1098, x1099) = fiat_p384_scalar_addcarryx_u32(x1097, x1026, x1073);
    let mut x1100: u32 = 0;
    let mut x1101: fiat_p384_scalar_u1 = 0;
    let (x1100, x1101) = fiat_p384_scalar_addcarryx_u32(x1099, x1028, x1075);
    let mut x1102: u32 = 0;
    let mut x1103: u32 = 0;
    let (x1102, x1103) = fiat_p384_scalar_mulx_u32(x1076, 0xe88fdc45);
    let mut x1104: u32 = 0;
    let mut x1105: u32 = 0;
    let (x1104, x1105) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1106: u32 = 0;
    let mut x1107: u32 = 0;
    let (x1106, x1107) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1108: u32 = 0;
    let mut x1109: u32 = 0;
    let (x1108, x1109) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1110: u32 = 0;
    let mut x1111: u32 = 0;
    let (x1110, x1111) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1112: u32 = 0;
    let mut x1113: u32 = 0;
    let (x1112, x1113) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1114: u32 = 0;
    let mut x1115: u32 = 0;
    let (x1114, x1115) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1116: u32 = 0;
    let mut x1117: u32 = 0;
    let (x1116, x1117) = fiat_p384_scalar_mulx_u32(x1102, 0xc7634d81);
    let mut x1118: u32 = 0;
    let mut x1119: u32 = 0;
    let (x1118, x1119) = fiat_p384_scalar_mulx_u32(x1102, 0xf4372ddf);
    let mut x1120: u32 = 0;
    let mut x1121: u32 = 0;
    let (x1120, x1121) = fiat_p384_scalar_mulx_u32(x1102, 0x581a0db2);
    let mut x1122: u32 = 0;
    let mut x1123: u32 = 0;
    let (x1122, x1123) = fiat_p384_scalar_mulx_u32(x1102, 0x48b0a77a);
    let mut x1124: u32 = 0;
    let mut x1125: u32 = 0;
    let (x1124, x1125) = fiat_p384_scalar_mulx_u32(x1102, 0xecec196a);
    let mut x1126: u32 = 0;
    let mut x1127: u32 = 0;
    let (x1126, x1127) = fiat_p384_scalar_mulx_u32(x1102, 0xccc52973);
    let mut x1128: u32 = 0;
    let mut x1129: fiat_p384_scalar_u1 = 0;
    let (x1128, x1129) = fiat_p384_scalar_addcarryx_u32(0x0, x1127, x1124);
    let mut x1130: u32 = 0;
    let mut x1131: fiat_p384_scalar_u1 = 0;
    let (x1130, x1131) = fiat_p384_scalar_addcarryx_u32(x1129, x1125, x1122);
    let mut x1132: u32 = 0;
    let mut x1133: fiat_p384_scalar_u1 = 0;
    let (x1132, x1133) = fiat_p384_scalar_addcarryx_u32(x1131, x1123, x1120);
    let mut x1134: u32 = 0;
    let mut x1135: fiat_p384_scalar_u1 = 0;
    let (x1134, x1135) = fiat_p384_scalar_addcarryx_u32(x1133, x1121, x1118);
    let mut x1136: u32 = 0;
    let mut x1137: fiat_p384_scalar_u1 = 0;
    let (x1136, x1137) = fiat_p384_scalar_addcarryx_u32(x1135, x1119, x1116);
    let mut x1138: u32 = 0;
    let mut x1139: fiat_p384_scalar_u1 = 0;
    let (x1138, x1139) = fiat_p384_scalar_addcarryx_u32(x1137, x1117, x1114);
    let mut x1140: u32 = 0;
    let mut x1141: fiat_p384_scalar_u1 = 0;
    let (x1140, x1141) = fiat_p384_scalar_addcarryx_u32(x1139, x1115, x1112);
    let mut x1142: u32 = 0;
    let mut x1143: fiat_p384_scalar_u1 = 0;
    let (x1142, x1143) = fiat_p384_scalar_addcarryx_u32(x1141, x1113, x1110);
    let mut x1144: u32 = 0;
    let mut x1145: fiat_p384_scalar_u1 = 0;
    let (x1144, x1145) = fiat_p384_scalar_addcarryx_u32(x1143, x1111, x1108);
    let mut x1146: u32 = 0;
    let mut x1147: fiat_p384_scalar_u1 = 0;
    let (x1146, x1147) = fiat_p384_scalar_addcarryx_u32(x1145, x1109, x1106);
    let mut x1148: u32 = 0;
    let mut x1149: fiat_p384_scalar_u1 = 0;
    let (x1148, x1149) = fiat_p384_scalar_addcarryx_u32(x1147, x1107, x1104);
    let x1150: u32 = ((x1149 as u32) + x1105);
    let mut x1151: u32 = 0;
    let mut x1152: fiat_p384_scalar_u1 = 0;
    let (x1151, x1152) = fiat_p384_scalar_addcarryx_u32(0x0, x1076, x1126);
    let mut x1153: u32 = 0;
    let mut x1154: fiat_p384_scalar_u1 = 0;
    let (x1153, x1154) = fiat_p384_scalar_addcarryx_u32(x1152, x1078, x1128);
    let mut x1155: u32 = 0;
    let mut x1156: fiat_p384_scalar_u1 = 0;
    let (x1155, x1156) = fiat_p384_scalar_addcarryx_u32(x1154, x1080, x1130);
    let mut x1157: u32 = 0;
    let mut x1158: fiat_p384_scalar_u1 = 0;
    let (x1157, x1158) = fiat_p384_scalar_addcarryx_u32(x1156, x1082, x1132);
    let mut x1159: u32 = 0;
    let mut x1160: fiat_p384_scalar_u1 = 0;
    let (x1159, x1160) = fiat_p384_scalar_addcarryx_u32(x1158, x1084, x1134);
    let mut x1161: u32 = 0;
    let mut x1162: fiat_p384_scalar_u1 = 0;
    let (x1161, x1162) = fiat_p384_scalar_addcarryx_u32(x1160, x1086, x1136);
    let mut x1163: u32 = 0;
    let mut x1164: fiat_p384_scalar_u1 = 0;
    let (x1163, x1164) = fiat_p384_scalar_addcarryx_u32(x1162, x1088, x1138);
    let mut x1165: u32 = 0;
    let mut x1166: fiat_p384_scalar_u1 = 0;
    let (x1165, x1166) = fiat_p384_scalar_addcarryx_u32(x1164, x1090, x1140);
    let mut x1167: u32 = 0;
    let mut x1168: fiat_p384_scalar_u1 = 0;
    let (x1167, x1168) = fiat_p384_scalar_addcarryx_u32(x1166, x1092, x1142);
    let mut x1169: u32 = 0;
    let mut x1170: fiat_p384_scalar_u1 = 0;
    let (x1169, x1170) = fiat_p384_scalar_addcarryx_u32(x1168, x1094, x1144);
    let mut x1171: u32 = 0;
    let mut x1172: fiat_p384_scalar_u1 = 0;
    let (x1171, x1172) = fiat_p384_scalar_addcarryx_u32(x1170, x1096, x1146);
    let mut x1173: u32 = 0;
    let mut x1174: fiat_p384_scalar_u1 = 0;
    let (x1173, x1174) = fiat_p384_scalar_addcarryx_u32(x1172, x1098, x1148);
    let mut x1175: u32 = 0;
    let mut x1176: fiat_p384_scalar_u1 = 0;
    let (x1175, x1176) = fiat_p384_scalar_addcarryx_u32(x1174, x1100, x1150);
    let x1177: u32 = ((x1176 as u32) + (x1101 as u32));
    let mut x1178: u32 = 0;
    let mut x1179: u32 = 0;
    let (x1178, x1179) = fiat_p384_scalar_mulx_u32(x8, (arg2[11]));
    let mut x1180: u32 = 0;
    let mut x1181: u32 = 0;
    let (x1180, x1181) = fiat_p384_scalar_mulx_u32(x8, (arg2[10]));
    let mut x1182: u32 = 0;
    let mut x1183: u32 = 0;
    let (x1182, x1183) = fiat_p384_scalar_mulx_u32(x8, (arg2[9]));
    let mut x1184: u32 = 0;
    let mut x1185: u32 = 0;
    let (x1184, x1185) = fiat_p384_scalar_mulx_u32(x8, (arg2[8]));
    let mut x1186: u32 = 0;
    let mut x1187: u32 = 0;
    let (x1186, x1187) = fiat_p384_scalar_mulx_u32(x8, (arg2[7]));
    let mut x1188: u32 = 0;
    let mut x1189: u32 = 0;
    let (x1188, x1189) = fiat_p384_scalar_mulx_u32(x8, (arg2[6]));
    let mut x1190: u32 = 0;
    let mut x1191: u32 = 0;
    let (x1190, x1191) = fiat_p384_scalar_mulx_u32(x8, (arg2[5]));
    let mut x1192: u32 = 0;
    let mut x1193: u32 = 0;
    let (x1192, x1193) = fiat_p384_scalar_mulx_u32(x8, (arg2[4]));
    let mut x1194: u32 = 0;
    let mut x1195: u32 = 0;
    let (x1194, x1195) = fiat_p384_scalar_mulx_u32(x8, (arg2[3]));
    let mut x1196: u32 = 0;
    let mut x1197: u32 = 0;
    let (x1196, x1197) = fiat_p384_scalar_mulx_u32(x8, (arg2[2]));
    let mut x1198: u32 = 0;
    let mut x1199: u32 = 0;
    let (x1198, x1199) = fiat_p384_scalar_mulx_u32(x8, (arg2[1]));
    let mut x1200: u32 = 0;
    let mut x1201: u32 = 0;
    let (x1200, x1201) = fiat_p384_scalar_mulx_u32(x8, (arg2[0]));
    let mut x1202: u32 = 0;
    let mut x1203: fiat_p384_scalar_u1 = 0;
    let (x1202, x1203) = fiat_p384_scalar_addcarryx_u32(0x0, x1201, x1198);
    let mut x1204: u32 = 0;
    let mut x1205: fiat_p384_scalar_u1 = 0;
    let (x1204, x1205) = fiat_p384_scalar_addcarryx_u32(x1203, x1199, x1196);
    let mut x1206: u32 = 0;
    let mut x1207: fiat_p384_scalar_u1 = 0;
    let (x1206, x1207) = fiat_p384_scalar_addcarryx_u32(x1205, x1197, x1194);
    let mut x1208: u32 = 0;
    let mut x1209: fiat_p384_scalar_u1 = 0;
    let (x1208, x1209) = fiat_p384_scalar_addcarryx_u32(x1207, x1195, x1192);
    let mut x1210: u32 = 0;
    let mut x1211: fiat_p384_scalar_u1 = 0;
    let (x1210, x1211) = fiat_p384_scalar_addcarryx_u32(x1209, x1193, x1190);
    let mut x1212: u32 = 0;
    let mut x1213: fiat_p384_scalar_u1 = 0;
    let (x1212, x1213) = fiat_p384_scalar_addcarryx_u32(x1211, x1191, x1188);
    let mut x1214: u32 = 0;
    let mut x1215: fiat_p384_scalar_u1 = 0;
    let (x1214, x1215) = fiat_p384_scalar_addcarryx_u32(x1213, x1189, x1186);
    let mut x1216: u32 = 0;
    let mut x1217: fiat_p384_scalar_u1 = 0;
    let (x1216, x1217) = fiat_p384_scalar_addcarryx_u32(x1215, x1187, x1184);
    let mut x1218: u32 = 0;
    let mut x1219: fiat_p384_scalar_u1 = 0;
    let (x1218, x1219) = fiat_p384_scalar_addcarryx_u32(x1217, x1185, x1182);
    let mut x1220: u32 = 0;
    let mut x1221: fiat_p384_scalar_u1 = 0;
    let (x1220, x1221) = fiat_p384_scalar_addcarryx_u32(x1219, x1183, x1180);
    let mut x1222: u32 = 0;
    let mut x1223: fiat_p384_scalar_u1 = 0;
    let (x1222, x1223) = fiat_p384_scalar_addcarryx_u32(x1221, x1181, x1178);
    let x1224: u32 = ((x1223 as u32) + x1179);
    let mut x1225: u32 = 0;
    let mut x1226: fiat_p384_scalar_u1 = 0;
    let (x1225, x1226) = fiat_p384_scalar_addcarryx_u32(0x0, x1153, x1200);
    let mut x1227: u32 = 0;
    let mut x1228: fiat_p384_scalar_u1 = 0;
    let (x1227, x1228) = fiat_p384_scalar_addcarryx_u32(x1226, x1155, x1202);
    let mut x1229: u32 = 0;
    let mut x1230: fiat_p384_scalar_u1 = 0;
    let (x1229, x1230) = fiat_p384_scalar_addcarryx_u32(x1228, x1157, x1204);
    let mut x1231: u32 = 0;
    let mut x1232: fiat_p384_scalar_u1 = 0;
    let (x1231, x1232) = fiat_p384_scalar_addcarryx_u32(x1230, x1159, x1206);
    let mut x1233: u32 = 0;
    let mut x1234: fiat_p384_scalar_u1 = 0;
    let (x1233, x1234) = fiat_p384_scalar_addcarryx_u32(x1232, x1161, x1208);
    let mut x1235: u32 = 0;
    let mut x1236: fiat_p384_scalar_u1 = 0;
    let (x1235, x1236) = fiat_p384_scalar_addcarryx_u32(x1234, x1163, x1210);
    let mut x1237: u32 = 0;
    let mut x1238: fiat_p384_scalar_u1 = 0;
    let (x1237, x1238) = fiat_p384_scalar_addcarryx_u32(x1236, x1165, x1212);
    let mut x1239: u32 = 0;
    let mut x1240: fiat_p384_scalar_u1 = 0;
    let (x1239, x1240) = fiat_p384_scalar_addcarryx_u32(x1238, x1167, x1214);
    let mut x1241: u32 = 0;
    let mut x1242: fiat_p384_scalar_u1 = 0;
    let (x1241, x1242) = fiat_p384_scalar_addcarryx_u32(x1240, x1169, x1216);
    let mut x1243: u32 = 0;
    let mut x1244: fiat_p384_scalar_u1 = 0;
    let (x1243, x1244) = fiat_p384_scalar_addcarryx_u32(x1242, x1171, x1218);
    let mut x1245: u32 = 0;
    let mut x1246: fiat_p384_scalar_u1 = 0;
    let (x1245, x1246) = fiat_p384_scalar_addcarryx_u32(x1244, x1173, x1220);
    let mut x1247: u32 = 0;
    let mut x1248: fiat_p384_scalar_u1 = 0;
    let (x1247, x1248) = fiat_p384_scalar_addcarryx_u32(x1246, x1175, x1222);
    let mut x1249: u32 = 0;
    let mut x1250: fiat_p384_scalar_u1 = 0;
    let (x1249, x1250) = fiat_p384_scalar_addcarryx_u32(x1248, x1177, x1224);
    let mut x1251: u32 = 0;
    let mut x1252: u32 = 0;
    let (x1251, x1252) = fiat_p384_scalar_mulx_u32(x1225, 0xe88fdc45);
    let mut x1253: u32 = 0;
    let mut x1254: u32 = 0;
    let (x1253, x1254) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1255: u32 = 0;
    let mut x1256: u32 = 0;
    let (x1255, x1256) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1257: u32 = 0;
    let mut x1258: u32 = 0;
    let (x1257, x1258) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1259: u32 = 0;
    let mut x1260: u32 = 0;
    let (x1259, x1260) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1261: u32 = 0;
    let mut x1262: u32 = 0;
    let (x1261, x1262) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1263: u32 = 0;
    let mut x1264: u32 = 0;
    let (x1263, x1264) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1265: u32 = 0;
    let mut x1266: u32 = 0;
    let (x1265, x1266) = fiat_p384_scalar_mulx_u32(x1251, 0xc7634d81);
    let mut x1267: u32 = 0;
    let mut x1268: u32 = 0;
    let (x1267, x1268) = fiat_p384_scalar_mulx_u32(x1251, 0xf4372ddf);
    let mut x1269: u32 = 0;
    let mut x1270: u32 = 0;
    let (x1269, x1270) = fiat_p384_scalar_mulx_u32(x1251, 0x581a0db2);
    let mut x1271: u32 = 0;
    let mut x1272: u32 = 0;
    let (x1271, x1272) = fiat_p384_scalar_mulx_u32(x1251, 0x48b0a77a);
    let mut x1273: u32 = 0;
    let mut x1274: u32 = 0;
    let (x1273, x1274) = fiat_p384_scalar_mulx_u32(x1251, 0xecec196a);
    let mut x1275: u32 = 0;
    let mut x1276: u32 = 0;
    let (x1275, x1276) = fiat_p384_scalar_mulx_u32(x1251, 0xccc52973);
    let mut x1277: u32 = 0;
    let mut x1278: fiat_p384_scalar_u1 = 0;
    let (x1277, x1278) = fiat_p384_scalar_addcarryx_u32(0x0, x1276, x1273);
    let mut x1279: u32 = 0;
    let mut x1280: fiat_p384_scalar_u1 = 0;
    let (x1279, x1280) = fiat_p384_scalar_addcarryx_u32(x1278, x1274, x1271);
    let mut x1281: u32 = 0;
    let mut x1282: fiat_p384_scalar_u1 = 0;
    let (x1281, x1282) = fiat_p384_scalar_addcarryx_u32(x1280, x1272, x1269);
    let mut x1283: u32 = 0;
    let mut x1284: fiat_p384_scalar_u1 = 0;
    let (x1283, x1284) = fiat_p384_scalar_addcarryx_u32(x1282, x1270, x1267);
    let mut x1285: u32 = 0;
    let mut x1286: fiat_p384_scalar_u1 = 0;
    let (x1285, x1286) = fiat_p384_scalar_addcarryx_u32(x1284, x1268, x1265);
    let mut x1287: u32 = 0;
    let mut x1288: fiat_p384_scalar_u1 = 0;
    let (x1287, x1288) = fiat_p384_scalar_addcarryx_u32(x1286, x1266, x1263);
    let mut x1289: u32 = 0;
    let mut x1290: fiat_p384_scalar_u1 = 0;
    let (x1289, x1290) = fiat_p384_scalar_addcarryx_u32(x1288, x1264, x1261);
    let mut x1291: u32 = 0;
    let mut x1292: fiat_p384_scalar_u1 = 0;
    let (x1291, x1292) = fiat_p384_scalar_addcarryx_u32(x1290, x1262, x1259);
    let mut x1293: u32 = 0;
    let mut x1294: fiat_p384_scalar_u1 = 0;
    let (x1293, x1294) = fiat_p384_scalar_addcarryx_u32(x1292, x1260, x1257);
    let mut x1295: u32 = 0;
    let mut x1296: fiat_p384_scalar_u1 = 0;
    let (x1295, x1296) = fiat_p384_scalar_addcarryx_u32(x1294, x1258, x1255);
    let mut x1297: u32 = 0;
    let mut x1298: fiat_p384_scalar_u1 = 0;
    let (x1297, x1298) = fiat_p384_scalar_addcarryx_u32(x1296, x1256, x1253);
    let x1299: u32 = ((x1298 as u32) + x1254);
    let mut x1300: u32 = 0;
    let mut x1301: fiat_p384_scalar_u1 = 0;
    let (x1300, x1301) = fiat_p384_scalar_addcarryx_u32(0x0, x1225, x1275);
    let mut x1302: u32 = 0;
    let mut x1303: fiat_p384_scalar_u1 = 0;
    let (x1302, x1303) = fiat_p384_scalar_addcarryx_u32(x1301, x1227, x1277);
    let mut x1304: u32 = 0;
    let mut x1305: fiat_p384_scalar_u1 = 0;
    let (x1304, x1305) = fiat_p384_scalar_addcarryx_u32(x1303, x1229, x1279);
    let mut x1306: u32 = 0;
    let mut x1307: fiat_p384_scalar_u1 = 0;
    let (x1306, x1307) = fiat_p384_scalar_addcarryx_u32(x1305, x1231, x1281);
    let mut x1308: u32 = 0;
    let mut x1309: fiat_p384_scalar_u1 = 0;
    let (x1308, x1309) = fiat_p384_scalar_addcarryx_u32(x1307, x1233, x1283);
    let mut x1310: u32 = 0;
    let mut x1311: fiat_p384_scalar_u1 = 0;
    let (x1310, x1311) = fiat_p384_scalar_addcarryx_u32(x1309, x1235, x1285);
    let mut x1312: u32 = 0;
    let mut x1313: fiat_p384_scalar_u1 = 0;
    let (x1312, x1313) = fiat_p384_scalar_addcarryx_u32(x1311, x1237, x1287);
    let mut x1314: u32 = 0;
    let mut x1315: fiat_p384_scalar_u1 = 0;
    let (x1314, x1315) = fiat_p384_scalar_addcarryx_u32(x1313, x1239, x1289);
    let mut x1316: u32 = 0;
    let mut x1317: fiat_p384_scalar_u1 = 0;
    let (x1316, x1317) = fiat_p384_scalar_addcarryx_u32(x1315, x1241, x1291);
    let mut x1318: u32 = 0;
    let mut x1319: fiat_p384_scalar_u1 = 0;
    let (x1318, x1319) = fiat_p384_scalar_addcarryx_u32(x1317, x1243, x1293);
    let mut x1320: u32 = 0;
    let mut x1321: fiat_p384_scalar_u1 = 0;
    let (x1320, x1321) = fiat_p384_scalar_addcarryx_u32(x1319, x1245, x1295);
    let mut x1322: u32 = 0;
    let mut x1323: fiat_p384_scalar_u1 = 0;
    let (x1322, x1323) = fiat_p384_scalar_addcarryx_u32(x1321, x1247, x1297);
    let mut x1324: u32 = 0;
    let mut x1325: fiat_p384_scalar_u1 = 0;
    let (x1324, x1325) = fiat_p384_scalar_addcarryx_u32(x1323, x1249, x1299);
    let x1326: u32 = ((x1325 as u32) + (x1250 as u32));
    let mut x1327: u32 = 0;
    let mut x1328: u32 = 0;
    let (x1327, x1328) = fiat_p384_scalar_mulx_u32(x9, (arg2[11]));
    let mut x1329: u32 = 0;
    let mut x1330: u32 = 0;
    let (x1329, x1330) = fiat_p384_scalar_mulx_u32(x9, (arg2[10]));
    let mut x1331: u32 = 0;
    let mut x1332: u32 = 0;
    let (x1331, x1332) = fiat_p384_scalar_mulx_u32(x9, (arg2[9]));
    let mut x1333: u32 = 0;
    let mut x1334: u32 = 0;
    let (x1333, x1334) = fiat_p384_scalar_mulx_u32(x9, (arg2[8]));
    let mut x1335: u32 = 0;
    let mut x1336: u32 = 0;
    let (x1335, x1336) = fiat_p384_scalar_mulx_u32(x9, (arg2[7]));
    let mut x1337: u32 = 0;
    let mut x1338: u32 = 0;
    let (x1337, x1338) = fiat_p384_scalar_mulx_u32(x9, (arg2[6]));
    let mut x1339: u32 = 0;
    let mut x1340: u32 = 0;
    let (x1339, x1340) = fiat_p384_scalar_mulx_u32(x9, (arg2[5]));
    let mut x1341: u32 = 0;
    let mut x1342: u32 = 0;
    let (x1341, x1342) = fiat_p384_scalar_mulx_u32(x9, (arg2[4]));
    let mut x1343: u32 = 0;
    let mut x1344: u32 = 0;
    let (x1343, x1344) = fiat_p384_scalar_mulx_u32(x9, (arg2[3]));
    let mut x1345: u32 = 0;
    let mut x1346: u32 = 0;
    let (x1345, x1346) = fiat_p384_scalar_mulx_u32(x9, (arg2[2]));
    let mut x1347: u32 = 0;
    let mut x1348: u32 = 0;
    let (x1347, x1348) = fiat_p384_scalar_mulx_u32(x9, (arg2[1]));
    let mut x1349: u32 = 0;
    let mut x1350: u32 = 0;
    let (x1349, x1350) = fiat_p384_scalar_mulx_u32(x9, (arg2[0]));
    let mut x1351: u32 = 0;
    let mut x1352: fiat_p384_scalar_u1 = 0;
    let (x1351, x1352) = fiat_p384_scalar_addcarryx_u32(0x0, x1350, x1347);
    let mut x1353: u32 = 0;
    let mut x1354: fiat_p384_scalar_u1 = 0;
    let (x1353, x1354) = fiat_p384_scalar_addcarryx_u32(x1352, x1348, x1345);
    let mut x1355: u32 = 0;
    let mut x1356: fiat_p384_scalar_u1 = 0;
    let (x1355, x1356) = fiat_p384_scalar_addcarryx_u32(x1354, x1346, x1343);
    let mut x1357: u32 = 0;
    let mut x1358: fiat_p384_scalar_u1 = 0;
    let (x1357, x1358) = fiat_p384_scalar_addcarryx_u32(x1356, x1344, x1341);
    let mut x1359: u32 = 0;
    let mut x1360: fiat_p384_scalar_u1 = 0;
    let (x1359, x1360) = fiat_p384_scalar_addcarryx_u32(x1358, x1342, x1339);
    let mut x1361: u32 = 0;
    let mut x1362: fiat_p384_scalar_u1 = 0;
    let (x1361, x1362) = fiat_p384_scalar_addcarryx_u32(x1360, x1340, x1337);
    let mut x1363: u32 = 0;
    let mut x1364: fiat_p384_scalar_u1 = 0;
    let (x1363, x1364) = fiat_p384_scalar_addcarryx_u32(x1362, x1338, x1335);
    let mut x1365: u32 = 0;
    let mut x1366: fiat_p384_scalar_u1 = 0;
    let (x1365, x1366) = fiat_p384_scalar_addcarryx_u32(x1364, x1336, x1333);
    let mut x1367: u32 = 0;
    let mut x1368: fiat_p384_scalar_u1 = 0;
    let (x1367, x1368) = fiat_p384_scalar_addcarryx_u32(x1366, x1334, x1331);
    let mut x1369: u32 = 0;
    let mut x1370: fiat_p384_scalar_u1 = 0;
    let (x1369, x1370) = fiat_p384_scalar_addcarryx_u32(x1368, x1332, x1329);
    let mut x1371: u32 = 0;
    let mut x1372: fiat_p384_scalar_u1 = 0;
    let (x1371, x1372) = fiat_p384_scalar_addcarryx_u32(x1370, x1330, x1327);
    let x1373: u32 = ((x1372 as u32) + x1328);
    let mut x1374: u32 = 0;
    let mut x1375: fiat_p384_scalar_u1 = 0;
    let (x1374, x1375) = fiat_p384_scalar_addcarryx_u32(0x0, x1302, x1349);
    let mut x1376: u32 = 0;
    let mut x1377: fiat_p384_scalar_u1 = 0;
    let (x1376, x1377) = fiat_p384_scalar_addcarryx_u32(x1375, x1304, x1351);
    let mut x1378: u32 = 0;
    let mut x1379: fiat_p384_scalar_u1 = 0;
    let (x1378, x1379) = fiat_p384_scalar_addcarryx_u32(x1377, x1306, x1353);
    let mut x1380: u32 = 0;
    let mut x1381: fiat_p384_scalar_u1 = 0;
    let (x1380, x1381) = fiat_p384_scalar_addcarryx_u32(x1379, x1308, x1355);
    let mut x1382: u32 = 0;
    let mut x1383: fiat_p384_scalar_u1 = 0;
    let (x1382, x1383) = fiat_p384_scalar_addcarryx_u32(x1381, x1310, x1357);
    let mut x1384: u32 = 0;
    let mut x1385: fiat_p384_scalar_u1 = 0;
    let (x1384, x1385) = fiat_p384_scalar_addcarryx_u32(x1383, x1312, x1359);
    let mut x1386: u32 = 0;
    let mut x1387: fiat_p384_scalar_u1 = 0;
    let (x1386, x1387) = fiat_p384_scalar_addcarryx_u32(x1385, x1314, x1361);
    let mut x1388: u32 = 0;
    let mut x1389: fiat_p384_scalar_u1 = 0;
    let (x1388, x1389) = fiat_p384_scalar_addcarryx_u32(x1387, x1316, x1363);
    let mut x1390: u32 = 0;
    let mut x1391: fiat_p384_scalar_u1 = 0;
    let (x1390, x1391) = fiat_p384_scalar_addcarryx_u32(x1389, x1318, x1365);
    let mut x1392: u32 = 0;
    let mut x1393: fiat_p384_scalar_u1 = 0;
    let (x1392, x1393) = fiat_p384_scalar_addcarryx_u32(x1391, x1320, x1367);
    let mut x1394: u32 = 0;
    let mut x1395: fiat_p384_scalar_u1 = 0;
    let (x1394, x1395) = fiat_p384_scalar_addcarryx_u32(x1393, x1322, x1369);
    let mut x1396: u32 = 0;
    let mut x1397: fiat_p384_scalar_u1 = 0;
    let (x1396, x1397) = fiat_p384_scalar_addcarryx_u32(x1395, x1324, x1371);
    let mut x1398: u32 = 0;
    let mut x1399: fiat_p384_scalar_u1 = 0;
    let (x1398, x1399) = fiat_p384_scalar_addcarryx_u32(x1397, x1326, x1373);
    let mut x1400: u32 = 0;
    let mut x1401: u32 = 0;
    let (x1400, x1401) = fiat_p384_scalar_mulx_u32(x1374, 0xe88fdc45);
    let mut x1402: u32 = 0;
    let mut x1403: u32 = 0;
    let (x1402, x1403) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1404: u32 = 0;
    let mut x1405: u32 = 0;
    let (x1404, x1405) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1406: u32 = 0;
    let mut x1407: u32 = 0;
    let (x1406, x1407) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1408: u32 = 0;
    let mut x1409: u32 = 0;
    let (x1408, x1409) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1410: u32 = 0;
    let mut x1411: u32 = 0;
    let (x1410, x1411) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1412: u32 = 0;
    let mut x1413: u32 = 0;
    let (x1412, x1413) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1414: u32 = 0;
    let mut x1415: u32 = 0;
    let (x1414, x1415) = fiat_p384_scalar_mulx_u32(x1400, 0xc7634d81);
    let mut x1416: u32 = 0;
    let mut x1417: u32 = 0;
    let (x1416, x1417) = fiat_p384_scalar_mulx_u32(x1400, 0xf4372ddf);
    let mut x1418: u32 = 0;
    let mut x1419: u32 = 0;
    let (x1418, x1419) = fiat_p384_scalar_mulx_u32(x1400, 0x581a0db2);
    let mut x1420: u32 = 0;
    let mut x1421: u32 = 0;
    let (x1420, x1421) = fiat_p384_scalar_mulx_u32(x1400, 0x48b0a77a);
    let mut x1422: u32 = 0;
    let mut x1423: u32 = 0;
    let (x1422, x1423) = fiat_p384_scalar_mulx_u32(x1400, 0xecec196a);
    let mut x1424: u32 = 0;
    let mut x1425: u32 = 0;
    let (x1424, x1425) = fiat_p384_scalar_mulx_u32(x1400, 0xccc52973);
    let mut x1426: u32 = 0;
    let mut x1427: fiat_p384_scalar_u1 = 0;
    let (x1426, x1427) = fiat_p384_scalar_addcarryx_u32(0x0, x1425, x1422);
    let mut x1428: u32 = 0;
    let mut x1429: fiat_p384_scalar_u1 = 0;
    let (x1428, x1429) = fiat_p384_scalar_addcarryx_u32(x1427, x1423, x1420);
    let mut x1430: u32 = 0;
    let mut x1431: fiat_p384_scalar_u1 = 0;
    let (x1430, x1431) = fiat_p384_scalar_addcarryx_u32(x1429, x1421, x1418);
    let mut x1432: u32 = 0;
    let mut x1433: fiat_p384_scalar_u1 = 0;
    let (x1432, x1433) = fiat_p384_scalar_addcarryx_u32(x1431, x1419, x1416);
    let mut x1434: u32 = 0;
    let mut x1435: fiat_p384_scalar_u1 = 0;
    let (x1434, x1435) = fiat_p384_scalar_addcarryx_u32(x1433, x1417, x1414);
    let mut x1436: u32 = 0;
    let mut x1437: fiat_p384_scalar_u1 = 0;
    let (x1436, x1437) = fiat_p384_scalar_addcarryx_u32(x1435, x1415, x1412);
    let mut x1438: u32 = 0;
    let mut x1439: fiat_p384_scalar_u1 = 0;
    let (x1438, x1439) = fiat_p384_scalar_addcarryx_u32(x1437, x1413, x1410);
    let mut x1440: u32 = 0;
    let mut x1441: fiat_p384_scalar_u1 = 0;
    let (x1440, x1441) = fiat_p384_scalar_addcarryx_u32(x1439, x1411, x1408);
    let mut x1442: u32 = 0;
    let mut x1443: fiat_p384_scalar_u1 = 0;
    let (x1442, x1443) = fiat_p384_scalar_addcarryx_u32(x1441, x1409, x1406);
    let mut x1444: u32 = 0;
    let mut x1445: fiat_p384_scalar_u1 = 0;
    let (x1444, x1445) = fiat_p384_scalar_addcarryx_u32(x1443, x1407, x1404);
    let mut x1446: u32 = 0;
    let mut x1447: fiat_p384_scalar_u1 = 0;
    let (x1446, x1447) = fiat_p384_scalar_addcarryx_u32(x1445, x1405, x1402);
    let x1448: u32 = ((x1447 as u32) + x1403);
    let mut x1449: u32 = 0;
    let mut x1450: fiat_p384_scalar_u1 = 0;
    let (x1449, x1450) = fiat_p384_scalar_addcarryx_u32(0x0, x1374, x1424);
    let mut x1451: u32 = 0;
    let mut x1452: fiat_p384_scalar_u1 = 0;
    let (x1451, x1452) = fiat_p384_scalar_addcarryx_u32(x1450, x1376, x1426);
    let mut x1453: u32 = 0;
    let mut x1454: fiat_p384_scalar_u1 = 0;
    let (x1453, x1454) = fiat_p384_scalar_addcarryx_u32(x1452, x1378, x1428);
    let mut x1455: u32 = 0;
    let mut x1456: fiat_p384_scalar_u1 = 0;
    let (x1455, x1456) = fiat_p384_scalar_addcarryx_u32(x1454, x1380, x1430);
    let mut x1457: u32 = 0;
    let mut x1458: fiat_p384_scalar_u1 = 0;
    let (x1457, x1458) = fiat_p384_scalar_addcarryx_u32(x1456, x1382, x1432);
    let mut x1459: u32 = 0;
    let mut x1460: fiat_p384_scalar_u1 = 0;
    let (x1459, x1460) = fiat_p384_scalar_addcarryx_u32(x1458, x1384, x1434);
    let mut x1461: u32 = 0;
    let mut x1462: fiat_p384_scalar_u1 = 0;
    let (x1461, x1462) = fiat_p384_scalar_addcarryx_u32(x1460, x1386, x1436);
    let mut x1463: u32 = 0;
    let mut x1464: fiat_p384_scalar_u1 = 0;
    let (x1463, x1464) = fiat_p384_scalar_addcarryx_u32(x1462, x1388, x1438);
    let mut x1465: u32 = 0;
    let mut x1466: fiat_p384_scalar_u1 = 0;
    let (x1465, x1466) = fiat_p384_scalar_addcarryx_u32(x1464, x1390, x1440);
    let mut x1467: u32 = 0;
    let mut x1468: fiat_p384_scalar_u1 = 0;
    let (x1467, x1468) = fiat_p384_scalar_addcarryx_u32(x1466, x1392, x1442);
    let mut x1469: u32 = 0;
    let mut x1470: fiat_p384_scalar_u1 = 0;
    let (x1469, x1470) = fiat_p384_scalar_addcarryx_u32(x1468, x1394, x1444);
    let mut x1471: u32 = 0;
    let mut x1472: fiat_p384_scalar_u1 = 0;
    let (x1471, x1472) = fiat_p384_scalar_addcarryx_u32(x1470, x1396, x1446);
    let mut x1473: u32 = 0;
    let mut x1474: fiat_p384_scalar_u1 = 0;
    let (x1473, x1474) = fiat_p384_scalar_addcarryx_u32(x1472, x1398, x1448);
    let x1475: u32 = ((x1474 as u32) + (x1399 as u32));
    let mut x1476: u32 = 0;
    let mut x1477: u32 = 0;
    let (x1476, x1477) = fiat_p384_scalar_mulx_u32(x10, (arg2[11]));
    let mut x1478: u32 = 0;
    let mut x1479: u32 = 0;
    let (x1478, x1479) = fiat_p384_scalar_mulx_u32(x10, (arg2[10]));
    let mut x1480: u32 = 0;
    let mut x1481: u32 = 0;
    let (x1480, x1481) = fiat_p384_scalar_mulx_u32(x10, (arg2[9]));
    let mut x1482: u32 = 0;
    let mut x1483: u32 = 0;
    let (x1482, x1483) = fiat_p384_scalar_mulx_u32(x10, (arg2[8]));
    let mut x1484: u32 = 0;
    let mut x1485: u32 = 0;
    let (x1484, x1485) = fiat_p384_scalar_mulx_u32(x10, (arg2[7]));
    let mut x1486: u32 = 0;
    let mut x1487: u32 = 0;
    let (x1486, x1487) = fiat_p384_scalar_mulx_u32(x10, (arg2[6]));
    let mut x1488: u32 = 0;
    let mut x1489: u32 = 0;
    let (x1488, x1489) = fiat_p384_scalar_mulx_u32(x10, (arg2[5]));
    let mut x1490: u32 = 0;
    let mut x1491: u32 = 0;
    let (x1490, x1491) = fiat_p384_scalar_mulx_u32(x10, (arg2[4]));
    let mut x1492: u32 = 0;
    let mut x1493: u32 = 0;
    let (x1492, x1493) = fiat_p384_scalar_mulx_u32(x10, (arg2[3]));
    let mut x1494: u32 = 0;
    let mut x1495: u32 = 0;
    let (x1494, x1495) = fiat_p384_scalar_mulx_u32(x10, (arg2[2]));
    let mut x1496: u32 = 0;
    let mut x1497: u32 = 0;
    let (x1496, x1497) = fiat_p384_scalar_mulx_u32(x10, (arg2[1]));
    let mut x1498: u32 = 0;
    let mut x1499: u32 = 0;
    let (x1498, x1499) = fiat_p384_scalar_mulx_u32(x10, (arg2[0]));
    let mut x1500: u32 = 0;
    let mut x1501: fiat_p384_scalar_u1 = 0;
    let (x1500, x1501) = fiat_p384_scalar_addcarryx_u32(0x0, x1499, x1496);
    let mut x1502: u32 = 0;
    let mut x1503: fiat_p384_scalar_u1 = 0;
    let (x1502, x1503) = fiat_p384_scalar_addcarryx_u32(x1501, x1497, x1494);
    let mut x1504: u32 = 0;
    let mut x1505: fiat_p384_scalar_u1 = 0;
    let (x1504, x1505) = fiat_p384_scalar_addcarryx_u32(x1503, x1495, x1492);
    let mut x1506: u32 = 0;
    let mut x1507: fiat_p384_scalar_u1 = 0;
    let (x1506, x1507) = fiat_p384_scalar_addcarryx_u32(x1505, x1493, x1490);
    let mut x1508: u32 = 0;
    let mut x1509: fiat_p384_scalar_u1 = 0;
    let (x1508, x1509) = fiat_p384_scalar_addcarryx_u32(x1507, x1491, x1488);
    let mut x1510: u32 = 0;
    let mut x1511: fiat_p384_scalar_u1 = 0;
    let (x1510, x1511) = fiat_p384_scalar_addcarryx_u32(x1509, x1489, x1486);
    let mut x1512: u32 = 0;
    let mut x1513: fiat_p384_scalar_u1 = 0;
    let (x1512, x1513) = fiat_p384_scalar_addcarryx_u32(x1511, x1487, x1484);
    let mut x1514: u32 = 0;
    let mut x1515: fiat_p384_scalar_u1 = 0;
    let (x1514, x1515) = fiat_p384_scalar_addcarryx_u32(x1513, x1485, x1482);
    let mut x1516: u32 = 0;
    let mut x1517: fiat_p384_scalar_u1 = 0;
    let (x1516, x1517) = fiat_p384_scalar_addcarryx_u32(x1515, x1483, x1480);
    let mut x1518: u32 = 0;
    let mut x1519: fiat_p384_scalar_u1 = 0;
    let (x1518, x1519) = fiat_p384_scalar_addcarryx_u32(x1517, x1481, x1478);
    let mut x1520: u32 = 0;
    let mut x1521: fiat_p384_scalar_u1 = 0;
    let (x1520, x1521) = fiat_p384_scalar_addcarryx_u32(x1519, x1479, x1476);
    let x1522: u32 = ((x1521 as u32) + x1477);
    let mut x1523: u32 = 0;
    let mut x1524: fiat_p384_scalar_u1 = 0;
    let (x1523, x1524) = fiat_p384_scalar_addcarryx_u32(0x0, x1451, x1498);
    let mut x1525: u32 = 0;
    let mut x1526: fiat_p384_scalar_u1 = 0;
    let (x1525, x1526) = fiat_p384_scalar_addcarryx_u32(x1524, x1453, x1500);
    let mut x1527: u32 = 0;
    let mut x1528: fiat_p384_scalar_u1 = 0;
    let (x1527, x1528) = fiat_p384_scalar_addcarryx_u32(x1526, x1455, x1502);
    let mut x1529: u32 = 0;
    let mut x1530: fiat_p384_scalar_u1 = 0;
    let (x1529, x1530) = fiat_p384_scalar_addcarryx_u32(x1528, x1457, x1504);
    let mut x1531: u32 = 0;
    let mut x1532: fiat_p384_scalar_u1 = 0;
    let (x1531, x1532) = fiat_p384_scalar_addcarryx_u32(x1530, x1459, x1506);
    let mut x1533: u32 = 0;
    let mut x1534: fiat_p384_scalar_u1 = 0;
    let (x1533, x1534) = fiat_p384_scalar_addcarryx_u32(x1532, x1461, x1508);
    let mut x1535: u32 = 0;
    let mut x1536: fiat_p384_scalar_u1 = 0;
    let (x1535, x1536) = fiat_p384_scalar_addcarryx_u32(x1534, x1463, x1510);
    let mut x1537: u32 = 0;
    let mut x1538: fiat_p384_scalar_u1 = 0;
    let (x1537, x1538) = fiat_p384_scalar_addcarryx_u32(x1536, x1465, x1512);
    let mut x1539: u32 = 0;
    let mut x1540: fiat_p384_scalar_u1 = 0;
    let (x1539, x1540) = fiat_p384_scalar_addcarryx_u32(x1538, x1467, x1514);
    let mut x1541: u32 = 0;
    let mut x1542: fiat_p384_scalar_u1 = 0;
    let (x1541, x1542) = fiat_p384_scalar_addcarryx_u32(x1540, x1469, x1516);
    let mut x1543: u32 = 0;
    let mut x1544: fiat_p384_scalar_u1 = 0;
    let (x1543, x1544) = fiat_p384_scalar_addcarryx_u32(x1542, x1471, x1518);
    let mut x1545: u32 = 0;
    let mut x1546: fiat_p384_scalar_u1 = 0;
    let (x1545, x1546) = fiat_p384_scalar_addcarryx_u32(x1544, x1473, x1520);
    let mut x1547: u32 = 0;
    let mut x1548: fiat_p384_scalar_u1 = 0;
    let (x1547, x1548) = fiat_p384_scalar_addcarryx_u32(x1546, x1475, x1522);
    let mut x1549: u32 = 0;
    let mut x1550: u32 = 0;
    let (x1549, x1550) = fiat_p384_scalar_mulx_u32(x1523, 0xe88fdc45);
    let mut x1551: u32 = 0;
    let mut x1552: u32 = 0;
    let (x1551, x1552) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1553: u32 = 0;
    let mut x1554: u32 = 0;
    let (x1553, x1554) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1555: u32 = 0;
    let mut x1556: u32 = 0;
    let (x1555, x1556) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1557: u32 = 0;
    let mut x1558: u32 = 0;
    let (x1557, x1558) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1559: u32 = 0;
    let mut x1560: u32 = 0;
    let (x1559, x1560) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1561: u32 = 0;
    let mut x1562: u32 = 0;
    let (x1561, x1562) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1563: u32 = 0;
    let mut x1564: u32 = 0;
    let (x1563, x1564) = fiat_p384_scalar_mulx_u32(x1549, 0xc7634d81);
    let mut x1565: u32 = 0;
    let mut x1566: u32 = 0;
    let (x1565, x1566) = fiat_p384_scalar_mulx_u32(x1549, 0xf4372ddf);
    let mut x1567: u32 = 0;
    let mut x1568: u32 = 0;
    let (x1567, x1568) = fiat_p384_scalar_mulx_u32(x1549, 0x581a0db2);
    let mut x1569: u32 = 0;
    let mut x1570: u32 = 0;
    let (x1569, x1570) = fiat_p384_scalar_mulx_u32(x1549, 0x48b0a77a);
    let mut x1571: u32 = 0;
    let mut x1572: u32 = 0;
    let (x1571, x1572) = fiat_p384_scalar_mulx_u32(x1549, 0xecec196a);
    let mut x1573: u32 = 0;
    let mut x1574: u32 = 0;
    let (x1573, x1574) = fiat_p384_scalar_mulx_u32(x1549, 0xccc52973);
    let mut x1575: u32 = 0;
    let mut x1576: fiat_p384_scalar_u1 = 0;
    let (x1575, x1576) = fiat_p384_scalar_addcarryx_u32(0x0, x1574, x1571);
    let mut x1577: u32 = 0;
    let mut x1578: fiat_p384_scalar_u1 = 0;
    let (x1577, x1578) = fiat_p384_scalar_addcarryx_u32(x1576, x1572, x1569);
    let mut x1579: u32 = 0;
    let mut x1580: fiat_p384_scalar_u1 = 0;
    let (x1579, x1580) = fiat_p384_scalar_addcarryx_u32(x1578, x1570, x1567);
    let mut x1581: u32 = 0;
    let mut x1582: fiat_p384_scalar_u1 = 0;
    let (x1581, x1582) = fiat_p384_scalar_addcarryx_u32(x1580, x1568, x1565);
    let mut x1583: u32 = 0;
    let mut x1584: fiat_p384_scalar_u1 = 0;
    let (x1583, x1584) = fiat_p384_scalar_addcarryx_u32(x1582, x1566, x1563);
    let mut x1585: u32 = 0;
    let mut x1586: fiat_p384_scalar_u1 = 0;
    let (x1585, x1586) = fiat_p384_scalar_addcarryx_u32(x1584, x1564, x1561);
    let mut x1587: u32 = 0;
    let mut x1588: fiat_p384_scalar_u1 = 0;
    let (x1587, x1588) = fiat_p384_scalar_addcarryx_u32(x1586, x1562, x1559);
    let mut x1589: u32 = 0;
    let mut x1590: fiat_p384_scalar_u1 = 0;
    let (x1589, x1590) = fiat_p384_scalar_addcarryx_u32(x1588, x1560, x1557);
    let mut x1591: u32 = 0;
    let mut x1592: fiat_p384_scalar_u1 = 0;
    let (x1591, x1592) = fiat_p384_scalar_addcarryx_u32(x1590, x1558, x1555);
    let mut x1593: u32 = 0;
    let mut x1594: fiat_p384_scalar_u1 = 0;
    let (x1593, x1594) = fiat_p384_scalar_addcarryx_u32(x1592, x1556, x1553);
    let mut x1595: u32 = 0;
    let mut x1596: fiat_p384_scalar_u1 = 0;
    let (x1595, x1596) = fiat_p384_scalar_addcarryx_u32(x1594, x1554, x1551);
    let x1597: u32 = ((x1596 as u32) + x1552);
    let mut x1598: u32 = 0;
    let mut x1599: fiat_p384_scalar_u1 = 0;
    let (x1598, x1599) = fiat_p384_scalar_addcarryx_u32(0x0, x1523, x1573);
    let mut x1600: u32 = 0;
    let mut x1601: fiat_p384_scalar_u1 = 0;
    let (x1600, x1601) = fiat_p384_scalar_addcarryx_u32(x1599, x1525, x1575);
    let mut x1602: u32 = 0;
    let mut x1603: fiat_p384_scalar_u1 = 0;
    let (x1602, x1603) = fiat_p384_scalar_addcarryx_u32(x1601, x1527, x1577);
    let mut x1604: u32 = 0;
    let mut x1605: fiat_p384_scalar_u1 = 0;
    let (x1604, x1605) = fiat_p384_scalar_addcarryx_u32(x1603, x1529, x1579);
    let mut x1606: u32 = 0;
    let mut x1607: fiat_p384_scalar_u1 = 0;
    let (x1606, x1607) = fiat_p384_scalar_addcarryx_u32(x1605, x1531, x1581);
    let mut x1608: u32 = 0;
    let mut x1609: fiat_p384_scalar_u1 = 0;
    let (x1608, x1609) = fiat_p384_scalar_addcarryx_u32(x1607, x1533, x1583);
    let mut x1610: u32 = 0;
    let mut x1611: fiat_p384_scalar_u1 = 0;
    let (x1610, x1611) = fiat_p384_scalar_addcarryx_u32(x1609, x1535, x1585);
    let mut x1612: u32 = 0;
    let mut x1613: fiat_p384_scalar_u1 = 0;
    let (x1612, x1613) = fiat_p384_scalar_addcarryx_u32(x1611, x1537, x1587);
    let mut x1614: u32 = 0;
    let mut x1615: fiat_p384_scalar_u1 = 0;
    let (x1614, x1615) = fiat_p384_scalar_addcarryx_u32(x1613, x1539, x1589);
    let mut x1616: u32 = 0;
    let mut x1617: fiat_p384_scalar_u1 = 0;
    let (x1616, x1617) = fiat_p384_scalar_addcarryx_u32(x1615, x1541, x1591);
    let mut x1618: u32 = 0;
    let mut x1619: fiat_p384_scalar_u1 = 0;
    let (x1618, x1619) = fiat_p384_scalar_addcarryx_u32(x1617, x1543, x1593);
    let mut x1620: u32 = 0;
    let mut x1621: fiat_p384_scalar_u1 = 0;
    let (x1620, x1621) = fiat_p384_scalar_addcarryx_u32(x1619, x1545, x1595);
    let mut x1622: u32 = 0;
    let mut x1623: fiat_p384_scalar_u1 = 0;
    let (x1622, x1623) = fiat_p384_scalar_addcarryx_u32(x1621, x1547, x1597);
    let x1624: u32 = ((x1623 as u32) + (x1548 as u32));
    let mut x1625: u32 = 0;
    let mut x1626: u32 = 0;
    let (x1625, x1626) = fiat_p384_scalar_mulx_u32(x11, (arg2[11]));
    let mut x1627: u32 = 0;
    let mut x1628: u32 = 0;
    let (x1627, x1628) = fiat_p384_scalar_mulx_u32(x11, (arg2[10]));
    let mut x1629: u32 = 0;
    let mut x1630: u32 = 0;
    let (x1629, x1630) = fiat_p384_scalar_mulx_u32(x11, (arg2[9]));
    let mut x1631: u32 = 0;
    let mut x1632: u32 = 0;
    let (x1631, x1632) = fiat_p384_scalar_mulx_u32(x11, (arg2[8]));
    let mut x1633: u32 = 0;
    let mut x1634: u32 = 0;
    let (x1633, x1634) = fiat_p384_scalar_mulx_u32(x11, (arg2[7]));
    let mut x1635: u32 = 0;
    let mut x1636: u32 = 0;
    let (x1635, x1636) = fiat_p384_scalar_mulx_u32(x11, (arg2[6]));
    let mut x1637: u32 = 0;
    let mut x1638: u32 = 0;
    let (x1637, x1638) = fiat_p384_scalar_mulx_u32(x11, (arg2[5]));
    let mut x1639: u32 = 0;
    let mut x1640: u32 = 0;
    let (x1639, x1640) = fiat_p384_scalar_mulx_u32(x11, (arg2[4]));
    let mut x1641: u32 = 0;
    let mut x1642: u32 = 0;
    let (x1641, x1642) = fiat_p384_scalar_mulx_u32(x11, (arg2[3]));
    let mut x1643: u32 = 0;
    let mut x1644: u32 = 0;
    let (x1643, x1644) = fiat_p384_scalar_mulx_u32(x11, (arg2[2]));
    let mut x1645: u32 = 0;
    let mut x1646: u32 = 0;
    let (x1645, x1646) = fiat_p384_scalar_mulx_u32(x11, (arg2[1]));
    let mut x1647: u32 = 0;
    let mut x1648: u32 = 0;
    let (x1647, x1648) = fiat_p384_scalar_mulx_u32(x11, (arg2[0]));
    let mut x1649: u32 = 0;
    let mut x1650: fiat_p384_scalar_u1 = 0;
    let (x1649, x1650) = fiat_p384_scalar_addcarryx_u32(0x0, x1648, x1645);
    let mut x1651: u32 = 0;
    let mut x1652: fiat_p384_scalar_u1 = 0;
    let (x1651, x1652) = fiat_p384_scalar_addcarryx_u32(x1650, x1646, x1643);
    let mut x1653: u32 = 0;
    let mut x1654: fiat_p384_scalar_u1 = 0;
    let (x1653, x1654) = fiat_p384_scalar_addcarryx_u32(x1652, x1644, x1641);
    let mut x1655: u32 = 0;
    let mut x1656: fiat_p384_scalar_u1 = 0;
    let (x1655, x1656) = fiat_p384_scalar_addcarryx_u32(x1654, x1642, x1639);
    let mut x1657: u32 = 0;
    let mut x1658: fiat_p384_scalar_u1 = 0;
    let (x1657, x1658) = fiat_p384_scalar_addcarryx_u32(x1656, x1640, x1637);
    let mut x1659: u32 = 0;
    let mut x1660: fiat_p384_scalar_u1 = 0;
    let (x1659, x1660) = fiat_p384_scalar_addcarryx_u32(x1658, x1638, x1635);
    let mut x1661: u32 = 0;
    let mut x1662: fiat_p384_scalar_u1 = 0;
    let (x1661, x1662) = fiat_p384_scalar_addcarryx_u32(x1660, x1636, x1633);
    let mut x1663: u32 = 0;
    let mut x1664: fiat_p384_scalar_u1 = 0;
    let (x1663, x1664) = fiat_p384_scalar_addcarryx_u32(x1662, x1634, x1631);
    let mut x1665: u32 = 0;
    let mut x1666: fiat_p384_scalar_u1 = 0;
    let (x1665, x1666) = fiat_p384_scalar_addcarryx_u32(x1664, x1632, x1629);
    let mut x1667: u32 = 0;
    let mut x1668: fiat_p384_scalar_u1 = 0;
    let (x1667, x1668) = fiat_p384_scalar_addcarryx_u32(x1666, x1630, x1627);
    let mut x1669: u32 = 0;
    let mut x1670: fiat_p384_scalar_u1 = 0;
    let (x1669, x1670) = fiat_p384_scalar_addcarryx_u32(x1668, x1628, x1625);
    let x1671: u32 = ((x1670 as u32) + x1626);
    let mut x1672: u32 = 0;
    let mut x1673: fiat_p384_scalar_u1 = 0;
    let (x1672, x1673) = fiat_p384_scalar_addcarryx_u32(0x0, x1600, x1647);
    let mut x1674: u32 = 0;
    let mut x1675: fiat_p384_scalar_u1 = 0;
    let (x1674, x1675) = fiat_p384_scalar_addcarryx_u32(x1673, x1602, x1649);
    let mut x1676: u32 = 0;
    let mut x1677: fiat_p384_scalar_u1 = 0;
    let (x1676, x1677) = fiat_p384_scalar_addcarryx_u32(x1675, x1604, x1651);
    let mut x1678: u32 = 0;
    let mut x1679: fiat_p384_scalar_u1 = 0;
    let (x1678, x1679) = fiat_p384_scalar_addcarryx_u32(x1677, x1606, x1653);
    let mut x1680: u32 = 0;
    let mut x1681: fiat_p384_scalar_u1 = 0;
    let (x1680, x1681) = fiat_p384_scalar_addcarryx_u32(x1679, x1608, x1655);
    let mut x1682: u32 = 0;
    let mut x1683: fiat_p384_scalar_u1 = 0;
    let (x1682, x1683) = fiat_p384_scalar_addcarryx_u32(x1681, x1610, x1657);
    let mut x1684: u32 = 0;
    let mut x1685: fiat_p384_scalar_u1 = 0;
    let (x1684, x1685) = fiat_p384_scalar_addcarryx_u32(x1683, x1612, x1659);
    let mut x1686: u32 = 0;
    let mut x1687: fiat_p384_scalar_u1 = 0;
    let (x1686, x1687) = fiat_p384_scalar_addcarryx_u32(x1685, x1614, x1661);
    let mut x1688: u32 = 0;
    let mut x1689: fiat_p384_scalar_u1 = 0;
    let (x1688, x1689) = fiat_p384_scalar_addcarryx_u32(x1687, x1616, x1663);
    let mut x1690: u32 = 0;
    let mut x1691: fiat_p384_scalar_u1 = 0;
    let (x1690, x1691) = fiat_p384_scalar_addcarryx_u32(x1689, x1618, x1665);
    let mut x1692: u32 = 0;
    let mut x1693: fiat_p384_scalar_u1 = 0;
    let (x1692, x1693) = fiat_p384_scalar_addcarryx_u32(x1691, x1620, x1667);
    let mut x1694: u32 = 0;
    let mut x1695: fiat_p384_scalar_u1 = 0;
    let (x1694, x1695) = fiat_p384_scalar_addcarryx_u32(x1693, x1622, x1669);
    let mut x1696: u32 = 0;
    let mut x1697: fiat_p384_scalar_u1 = 0;
    let (x1696, x1697) = fiat_p384_scalar_addcarryx_u32(x1695, x1624, x1671);
    let mut x1698: u32 = 0;
    let mut x1699: u32 = 0;
    let (x1698, x1699) = fiat_p384_scalar_mulx_u32(x1672, 0xe88fdc45);
    let mut x1700: u32 = 0;
    let mut x1701: u32 = 0;
    let (x1700, x1701) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1702: u32 = 0;
    let mut x1703: u32 = 0;
    let (x1702, x1703) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1704: u32 = 0;
    let mut x1705: u32 = 0;
    let (x1704, x1705) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1706: u32 = 0;
    let mut x1707: u32 = 0;
    let (x1706, x1707) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1708: u32 = 0;
    let mut x1709: u32 = 0;
    let (x1708, x1709) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1710: u32 = 0;
    let mut x1711: u32 = 0;
    let (x1710, x1711) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1712: u32 = 0;
    let mut x1713: u32 = 0;
    let (x1712, x1713) = fiat_p384_scalar_mulx_u32(x1698, 0xc7634d81);
    let mut x1714: u32 = 0;
    let mut x1715: u32 = 0;
    let (x1714, x1715) = fiat_p384_scalar_mulx_u32(x1698, 0xf4372ddf);
    let mut x1716: u32 = 0;
    let mut x1717: u32 = 0;
    let (x1716, x1717) = fiat_p384_scalar_mulx_u32(x1698, 0x581a0db2);
    let mut x1718: u32 = 0;
    let mut x1719: u32 = 0;
    let (x1718, x1719) = fiat_p384_scalar_mulx_u32(x1698, 0x48b0a77a);
    let mut x1720: u32 = 0;
    let mut x1721: u32 = 0;
    let (x1720, x1721) = fiat_p384_scalar_mulx_u32(x1698, 0xecec196a);
    let mut x1722: u32 = 0;
    let mut x1723: u32 = 0;
    let (x1722, x1723) = fiat_p384_scalar_mulx_u32(x1698, 0xccc52973);
    let mut x1724: u32 = 0;
    let mut x1725: fiat_p384_scalar_u1 = 0;
    let (x1724, x1725) = fiat_p384_scalar_addcarryx_u32(0x0, x1723, x1720);
    let mut x1726: u32 = 0;
    let mut x1727: fiat_p384_scalar_u1 = 0;
    let (x1726, x1727) = fiat_p384_scalar_addcarryx_u32(x1725, x1721, x1718);
    let mut x1728: u32 = 0;
    let mut x1729: fiat_p384_scalar_u1 = 0;
    let (x1728, x1729) = fiat_p384_scalar_addcarryx_u32(x1727, x1719, x1716);
    let mut x1730: u32 = 0;
    let mut x1731: fiat_p384_scalar_u1 = 0;
    let (x1730, x1731) = fiat_p384_scalar_addcarryx_u32(x1729, x1717, x1714);
    let mut x1732: u32 = 0;
    let mut x1733: fiat_p384_scalar_u1 = 0;
    let (x1732, x1733) = fiat_p384_scalar_addcarryx_u32(x1731, x1715, x1712);
    let mut x1734: u32 = 0;
    let mut x1735: fiat_p384_scalar_u1 = 0;
    let (x1734, x1735) = fiat_p384_scalar_addcarryx_u32(x1733, x1713, x1710);
    let mut x1736: u32 = 0;
    let mut x1737: fiat_p384_scalar_u1 = 0;
    let (x1736, x1737) = fiat_p384_scalar_addcarryx_u32(x1735, x1711, x1708);
    let mut x1738: u32 = 0;
    let mut x1739: fiat_p384_scalar_u1 = 0;
    let (x1738, x1739) = fiat_p384_scalar_addcarryx_u32(x1737, x1709, x1706);
    let mut x1740: u32 = 0;
    let mut x1741: fiat_p384_scalar_u1 = 0;
    let (x1740, x1741) = fiat_p384_scalar_addcarryx_u32(x1739, x1707, x1704);
    let mut x1742: u32 = 0;
    let mut x1743: fiat_p384_scalar_u1 = 0;
    let (x1742, x1743) = fiat_p384_scalar_addcarryx_u32(x1741, x1705, x1702);
    let mut x1744: u32 = 0;
    let mut x1745: fiat_p384_scalar_u1 = 0;
    let (x1744, x1745) = fiat_p384_scalar_addcarryx_u32(x1743, x1703, x1700);
    let x1746: u32 = ((x1745 as u32) + x1701);
    let mut x1747: u32 = 0;
    let mut x1748: fiat_p384_scalar_u1 = 0;
    let (x1747, x1748) = fiat_p384_scalar_addcarryx_u32(0x0, x1672, x1722);
    let mut x1749: u32 = 0;
    let mut x1750: fiat_p384_scalar_u1 = 0;
    let (x1749, x1750) = fiat_p384_scalar_addcarryx_u32(x1748, x1674, x1724);
    let mut x1751: u32 = 0;
    let mut x1752: fiat_p384_scalar_u1 = 0;
    let (x1751, x1752) = fiat_p384_scalar_addcarryx_u32(x1750, x1676, x1726);
    let mut x1753: u32 = 0;
    let mut x1754: fiat_p384_scalar_u1 = 0;
    let (x1753, x1754) = fiat_p384_scalar_addcarryx_u32(x1752, x1678, x1728);
    let mut x1755: u32 = 0;
    let mut x1756: fiat_p384_scalar_u1 = 0;
    let (x1755, x1756) = fiat_p384_scalar_addcarryx_u32(x1754, x1680, x1730);
    let mut x1757: u32 = 0;
    let mut x1758: fiat_p384_scalar_u1 = 0;
    let (x1757, x1758) = fiat_p384_scalar_addcarryx_u32(x1756, x1682, x1732);
    let mut x1759: u32 = 0;
    let mut x1760: fiat_p384_scalar_u1 = 0;
    let (x1759, x1760) = fiat_p384_scalar_addcarryx_u32(x1758, x1684, x1734);
    let mut x1761: u32 = 0;
    let mut x1762: fiat_p384_scalar_u1 = 0;
    let (x1761, x1762) = fiat_p384_scalar_addcarryx_u32(x1760, x1686, x1736);
    let mut x1763: u32 = 0;
    let mut x1764: fiat_p384_scalar_u1 = 0;
    let (x1763, x1764) = fiat_p384_scalar_addcarryx_u32(x1762, x1688, x1738);
    let mut x1765: u32 = 0;
    let mut x1766: fiat_p384_scalar_u1 = 0;
    let (x1765, x1766) = fiat_p384_scalar_addcarryx_u32(x1764, x1690, x1740);
    let mut x1767: u32 = 0;
    let mut x1768: fiat_p384_scalar_u1 = 0;
    let (x1767, x1768) = fiat_p384_scalar_addcarryx_u32(x1766, x1692, x1742);
    let mut x1769: u32 = 0;
    let mut x1770: fiat_p384_scalar_u1 = 0;
    let (x1769, x1770) = fiat_p384_scalar_addcarryx_u32(x1768, x1694, x1744);
    let mut x1771: u32 = 0;
    let mut x1772: fiat_p384_scalar_u1 = 0;
    let (x1771, x1772) = fiat_p384_scalar_addcarryx_u32(x1770, x1696, x1746);
    let x1773: u32 = ((x1772 as u32) + (x1697 as u32));
    let mut x1774: u32 = 0;
    let mut x1775: fiat_p384_scalar_u1 = 0;
    let (x1774, x1775) = fiat_p384_scalar_subborrowx_u32(0x0, x1749, 0xccc52973);
    let mut x1776: u32 = 0;
    let mut x1777: fiat_p384_scalar_u1 = 0;
    let (x1776, x1777) = fiat_p384_scalar_subborrowx_u32(x1775, x1751, 0xecec196a);
    let mut x1778: u32 = 0;
    let mut x1779: fiat_p384_scalar_u1 = 0;
    let (x1778, x1779) = fiat_p384_scalar_subborrowx_u32(x1777, x1753, 0x48b0a77a);
    let mut x1780: u32 = 0;
    let mut x1781: fiat_p384_scalar_u1 = 0;
    let (x1780, x1781) = fiat_p384_scalar_subborrowx_u32(x1779, x1755, 0x581a0db2);
    let mut x1782: u32 = 0;
    let mut x1783: fiat_p384_scalar_u1 = 0;
    let (x1782, x1783) = fiat_p384_scalar_subborrowx_u32(x1781, x1757, 0xf4372ddf);
    let mut x1784: u32 = 0;
    let mut x1785: fiat_p384_scalar_u1 = 0;
    let (x1784, x1785) = fiat_p384_scalar_subborrowx_u32(x1783, x1759, 0xc7634d81);
    let mut x1786: u32 = 0;
    let mut x1787: fiat_p384_scalar_u1 = 0;
    let (x1786, x1787) = fiat_p384_scalar_subborrowx_u32(x1785, x1761, 0xffffffff);
    let mut x1788: u32 = 0;
    let mut x1789: fiat_p384_scalar_u1 = 0;
    let (x1788, x1789) = fiat_p384_scalar_subborrowx_u32(x1787, x1763, 0xffffffff);
    let mut x1790: u32 = 0;
    let mut x1791: fiat_p384_scalar_u1 = 0;
    let (x1790, x1791) = fiat_p384_scalar_subborrowx_u32(x1789, x1765, 0xffffffff);
    let mut x1792: u32 = 0;
    let mut x1793: fiat_p384_scalar_u1 = 0;
    let (x1792, x1793) = fiat_p384_scalar_subborrowx_u32(x1791, x1767, 0xffffffff);
    let mut x1794: u32 = 0;
    let mut x1795: fiat_p384_scalar_u1 = 0;
    let (x1794, x1795) = fiat_p384_scalar_subborrowx_u32(x1793, x1769, 0xffffffff);
    let mut x1796: u32 = 0;
    let mut x1797: fiat_p384_scalar_u1 = 0;
    let (x1796, x1797) = fiat_p384_scalar_subborrowx_u32(x1795, x1771, 0xffffffff);
    let mut x1798: u32 = 0;
    let mut x1799: fiat_p384_scalar_u1 = 0;
    let (x1798, x1799) = fiat_p384_scalar_subborrowx_u32(x1797, x1773, (0x0 as u32));
    let mut x1800: u32 = 0;
    let (x1800) = fiat_p384_scalar_cmovznz_u32(x1799, x1774, x1749);
    let mut x1801: u32 = 0;
    let (x1801) = fiat_p384_scalar_cmovznz_u32(x1799, x1776, x1751);
    let mut x1802: u32 = 0;
    let (x1802) = fiat_p384_scalar_cmovznz_u32(x1799, x1778, x1753);
    let mut x1803: u32 = 0;
    let (x1803) = fiat_p384_scalar_cmovznz_u32(x1799, x1780, x1755);
    let mut x1804: u32 = 0;
    let (x1804) = fiat_p384_scalar_cmovznz_u32(x1799, x1782, x1757);
    let mut x1805: u32 = 0;
    let (x1805) = fiat_p384_scalar_cmovznz_u32(x1799, x1784, x1759);
    let mut x1806: u32 = 0;
    let (x1806) = fiat_p384_scalar_cmovznz_u32(x1799, x1786, x1761);
    let mut x1807: u32 = 0;
    let (x1807) = fiat_p384_scalar_cmovznz_u32(x1799, x1788, x1763);
    let mut x1808: u32 = 0;
    let (x1808) = fiat_p384_scalar_cmovznz_u32(x1799, x1790, x1765);
    let mut x1809: u32 = 0;
    let (x1809) = fiat_p384_scalar_cmovznz_u32(x1799, x1792, x1767);
    let mut x1810: u32 = 0;
    let (x1810) = fiat_p384_scalar_cmovznz_u32(x1799, x1794, x1769);
    let mut x1811: u32 = 0;
    let (x1811) = fiat_p384_scalar_cmovznz_u32(x1799, x1796, x1771);
    out1[0] = x1800;
    out1[1] = x1801;
    out1[2] = x1802;
    out1[3] = x1803;
    out1[4] = x1804;
    out1[5] = x1805;
    out1[6] = x1806;
    out1[7] = x1807;
    out1[8] = x1808;
    out1[9] = x1809;
    out1[10] = x1810;
    out1[11] = x1811;
    out1
}
#[doc = " The function fiat_p384_scalar_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_square(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let mut x13: u32 = 0;
    let mut x14: u32 = 0;
    let (x13, x14) = fiat_p384_scalar_mulx_u32(x12, (arg1[11]));
    let mut x15: u32 = 0;
    let mut x16: u32 = 0;
    let (x15, x16) = fiat_p384_scalar_mulx_u32(x12, (arg1[10]));
    let mut x17: u32 = 0;
    let mut x18: u32 = 0;
    let (x17, x18) = fiat_p384_scalar_mulx_u32(x12, (arg1[9]));
    let mut x19: u32 = 0;
    let mut x20: u32 = 0;
    let (x19, x20) = fiat_p384_scalar_mulx_u32(x12, (arg1[8]));
    let mut x21: u32 = 0;
    let mut x22: u32 = 0;
    let (x21, x22) = fiat_p384_scalar_mulx_u32(x12, (arg1[7]));
    let mut x23: u32 = 0;
    let mut x24: u32 = 0;
    let (x23, x24) = fiat_p384_scalar_mulx_u32(x12, (arg1[6]));
    let mut x25: u32 = 0;
    let mut x26: u32 = 0;
    let (x25, x26) = fiat_p384_scalar_mulx_u32(x12, (arg1[5]));
    let mut x27: u32 = 0;
    let mut x28: u32 = 0;
    let (x27, x28) = fiat_p384_scalar_mulx_u32(x12, (arg1[4]));
    let mut x29: u32 = 0;
    let mut x30: u32 = 0;
    let (x29, x30) = fiat_p384_scalar_mulx_u32(x12, (arg1[3]));
    let mut x31: u32 = 0;
    let mut x32: u32 = 0;
    let (x31, x32) = fiat_p384_scalar_mulx_u32(x12, (arg1[2]));
    let mut x33: u32 = 0;
    let mut x34: u32 = 0;
    let (x33, x34) = fiat_p384_scalar_mulx_u32(x12, (arg1[1]));
    let mut x35: u32 = 0;
    let mut x36: u32 = 0;
    let (x35, x36) = fiat_p384_scalar_mulx_u32(x12, (arg1[0]));
    let mut x37: u32 = 0;
    let mut x38: fiat_p384_scalar_u1 = 0;
    let (x37, x38) = fiat_p384_scalar_addcarryx_u32(0x0, x36, x33);
    let mut x39: u32 = 0;
    let mut x40: fiat_p384_scalar_u1 = 0;
    let (x39, x40) = fiat_p384_scalar_addcarryx_u32(x38, x34, x31);
    let mut x41: u32 = 0;
    let mut x42: fiat_p384_scalar_u1 = 0;
    let (x41, x42) = fiat_p384_scalar_addcarryx_u32(x40, x32, x29);
    let mut x43: u32 = 0;
    let mut x44: fiat_p384_scalar_u1 = 0;
    let (x43, x44) = fiat_p384_scalar_addcarryx_u32(x42, x30, x27);
    let mut x45: u32 = 0;
    let mut x46: fiat_p384_scalar_u1 = 0;
    let (x45, x46) = fiat_p384_scalar_addcarryx_u32(x44, x28, x25);
    let mut x47: u32 = 0;
    let mut x48: fiat_p384_scalar_u1 = 0;
    let (x47, x48) = fiat_p384_scalar_addcarryx_u32(x46, x26, x23);
    let mut x49: u32 = 0;
    let mut x50: fiat_p384_scalar_u1 = 0;
    let (x49, x50) = fiat_p384_scalar_addcarryx_u32(x48, x24, x21);
    let mut x51: u32 = 0;
    let mut x52: fiat_p384_scalar_u1 = 0;
    let (x51, x52) = fiat_p384_scalar_addcarryx_u32(x50, x22, x19);
    let mut x53: u32 = 0;
    let mut x54: fiat_p384_scalar_u1 = 0;
    let (x53, x54) = fiat_p384_scalar_addcarryx_u32(x52, x20, x17);
    let mut x55: u32 = 0;
    let mut x56: fiat_p384_scalar_u1 = 0;
    let (x55, x56) = fiat_p384_scalar_addcarryx_u32(x54, x18, x15);
    let mut x57: u32 = 0;
    let mut x58: fiat_p384_scalar_u1 = 0;
    let (x57, x58) = fiat_p384_scalar_addcarryx_u32(x56, x16, x13);
    let x59: u32 = ((x58 as u32) + x14);
    let mut x60: u32 = 0;
    let mut x61: u32 = 0;
    let (x60, x61) = fiat_p384_scalar_mulx_u32(x35, 0xe88fdc45);
    let mut x62: u32 = 0;
    let mut x63: u32 = 0;
    let (x62, x63) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x64: u32 = 0;
    let mut x65: u32 = 0;
    let (x64, x65) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x66: u32 = 0;
    let mut x67: u32 = 0;
    let (x66, x67) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x68: u32 = 0;
    let mut x69: u32 = 0;
    let (x68, x69) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x70: u32 = 0;
    let mut x71: u32 = 0;
    let (x70, x71) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x72: u32 = 0;
    let mut x73: u32 = 0;
    let (x72, x73) = fiat_p384_scalar_mulx_u32(x60, 0xffffffff);
    let mut x74: u32 = 0;
    let mut x75: u32 = 0;
    let (x74, x75) = fiat_p384_scalar_mulx_u32(x60, 0xc7634d81);
    let mut x76: u32 = 0;
    let mut x77: u32 = 0;
    let (x76, x77) = fiat_p384_scalar_mulx_u32(x60, 0xf4372ddf);
    let mut x78: u32 = 0;
    let mut x79: u32 = 0;
    let (x78, x79) = fiat_p384_scalar_mulx_u32(x60, 0x581a0db2);
    let mut x80: u32 = 0;
    let mut x81: u32 = 0;
    let (x80, x81) = fiat_p384_scalar_mulx_u32(x60, 0x48b0a77a);
    let mut x82: u32 = 0;
    let mut x83: u32 = 0;
    let (x82, x83) = fiat_p384_scalar_mulx_u32(x60, 0xecec196a);
    let mut x84: u32 = 0;
    let mut x85: u32 = 0;
    let (x84, x85) = fiat_p384_scalar_mulx_u32(x60, 0xccc52973);
    let mut x86: u32 = 0;
    let mut x87: fiat_p384_scalar_u1 = 0;
    let (x86, x87) = fiat_p384_scalar_addcarryx_u32(0x0, x85, x82);
    let mut x88: u32 = 0;
    let mut x89: fiat_p384_scalar_u1 = 0;
    let (x88, x89) = fiat_p384_scalar_addcarryx_u32(x87, x83, x80);
    let mut x90: u32 = 0;
    let mut x91: fiat_p384_scalar_u1 = 0;
    let (x90, x91) = fiat_p384_scalar_addcarryx_u32(x89, x81, x78);
    let mut x92: u32 = 0;
    let mut x93: fiat_p384_scalar_u1 = 0;
    let (x92, x93) = fiat_p384_scalar_addcarryx_u32(x91, x79, x76);
    let mut x94: u32 = 0;
    let mut x95: fiat_p384_scalar_u1 = 0;
    let (x94, x95) = fiat_p384_scalar_addcarryx_u32(x93, x77, x74);
    let mut x96: u32 = 0;
    let mut x97: fiat_p384_scalar_u1 = 0;
    let (x96, x97) = fiat_p384_scalar_addcarryx_u32(x95, x75, x72);
    let mut x98: u32 = 0;
    let mut x99: fiat_p384_scalar_u1 = 0;
    let (x98, x99) = fiat_p384_scalar_addcarryx_u32(x97, x73, x70);
    let mut x100: u32 = 0;
    let mut x101: fiat_p384_scalar_u1 = 0;
    let (x100, x101) = fiat_p384_scalar_addcarryx_u32(x99, x71, x68);
    let mut x102: u32 = 0;
    let mut x103: fiat_p384_scalar_u1 = 0;
    let (x102, x103) = fiat_p384_scalar_addcarryx_u32(x101, x69, x66);
    let mut x104: u32 = 0;
    let mut x105: fiat_p384_scalar_u1 = 0;
    let (x104, x105) = fiat_p384_scalar_addcarryx_u32(x103, x67, x64);
    let mut x106: u32 = 0;
    let mut x107: fiat_p384_scalar_u1 = 0;
    let (x106, x107) = fiat_p384_scalar_addcarryx_u32(x105, x65, x62);
    let x108: u32 = ((x107 as u32) + x63);
    let mut x109: u32 = 0;
    let mut x110: fiat_p384_scalar_u1 = 0;
    let (x109, x110) = fiat_p384_scalar_addcarryx_u32(0x0, x35, x84);
    let mut x111: u32 = 0;
    let mut x112: fiat_p384_scalar_u1 = 0;
    let (x111, x112) = fiat_p384_scalar_addcarryx_u32(x110, x37, x86);
    let mut x113: u32 = 0;
    let mut x114: fiat_p384_scalar_u1 = 0;
    let (x113, x114) = fiat_p384_scalar_addcarryx_u32(x112, x39, x88);
    let mut x115: u32 = 0;
    let mut x116: fiat_p384_scalar_u1 = 0;
    let (x115, x116) = fiat_p384_scalar_addcarryx_u32(x114, x41, x90);
    let mut x117: u32 = 0;
    let mut x118: fiat_p384_scalar_u1 = 0;
    let (x117, x118) = fiat_p384_scalar_addcarryx_u32(x116, x43, x92);
    let mut x119: u32 = 0;
    let mut x120: fiat_p384_scalar_u1 = 0;
    let (x119, x120) = fiat_p384_scalar_addcarryx_u32(x118, x45, x94);
    let mut x121: u32 = 0;
    let mut x122: fiat_p384_scalar_u1 = 0;
    let (x121, x122) = fiat_p384_scalar_addcarryx_u32(x120, x47, x96);
    let mut x123: u32 = 0;
    let mut x124: fiat_p384_scalar_u1 = 0;
    let (x123, x124) = fiat_p384_scalar_addcarryx_u32(x122, x49, x98);
    let mut x125: u32 = 0;
    let mut x126: fiat_p384_scalar_u1 = 0;
    let (x125, x126) = fiat_p384_scalar_addcarryx_u32(x124, x51, x100);
    let mut x127: u32 = 0;
    let mut x128: fiat_p384_scalar_u1 = 0;
    let (x127, x128) = fiat_p384_scalar_addcarryx_u32(x126, x53, x102);
    let mut x129: u32 = 0;
    let mut x130: fiat_p384_scalar_u1 = 0;
    let (x129, x130) = fiat_p384_scalar_addcarryx_u32(x128, x55, x104);
    let mut x131: u32 = 0;
    let mut x132: fiat_p384_scalar_u1 = 0;
    let (x131, x132) = fiat_p384_scalar_addcarryx_u32(x130, x57, x106);
    let mut x133: u32 = 0;
    let mut x134: fiat_p384_scalar_u1 = 0;
    let (x133, x134) = fiat_p384_scalar_addcarryx_u32(x132, x59, x108);
    let mut x135: u32 = 0;
    let mut x136: u32 = 0;
    let (x135, x136) = fiat_p384_scalar_mulx_u32(x1, (arg1[11]));
    let mut x137: u32 = 0;
    let mut x138: u32 = 0;
    let (x137, x138) = fiat_p384_scalar_mulx_u32(x1, (arg1[10]));
    let mut x139: u32 = 0;
    let mut x140: u32 = 0;
    let (x139, x140) = fiat_p384_scalar_mulx_u32(x1, (arg1[9]));
    let mut x141: u32 = 0;
    let mut x142: u32 = 0;
    let (x141, x142) = fiat_p384_scalar_mulx_u32(x1, (arg1[8]));
    let mut x143: u32 = 0;
    let mut x144: u32 = 0;
    let (x143, x144) = fiat_p384_scalar_mulx_u32(x1, (arg1[7]));
    let mut x145: u32 = 0;
    let mut x146: u32 = 0;
    let (x145, x146) = fiat_p384_scalar_mulx_u32(x1, (arg1[6]));
    let mut x147: u32 = 0;
    let mut x148: u32 = 0;
    let (x147, x148) = fiat_p384_scalar_mulx_u32(x1, (arg1[5]));
    let mut x149: u32 = 0;
    let mut x150: u32 = 0;
    let (x149, x150) = fiat_p384_scalar_mulx_u32(x1, (arg1[4]));
    let mut x151: u32 = 0;
    let mut x152: u32 = 0;
    let (x151, x152) = fiat_p384_scalar_mulx_u32(x1, (arg1[3]));
    let mut x153: u32 = 0;
    let mut x154: u32 = 0;
    let (x153, x154) = fiat_p384_scalar_mulx_u32(x1, (arg1[2]));
    let mut x155: u32 = 0;
    let mut x156: u32 = 0;
    let (x155, x156) = fiat_p384_scalar_mulx_u32(x1, (arg1[1]));
    let mut x157: u32 = 0;
    let mut x158: u32 = 0;
    let (x157, x158) = fiat_p384_scalar_mulx_u32(x1, (arg1[0]));
    let mut x159: u32 = 0;
    let mut x160: fiat_p384_scalar_u1 = 0;
    let (x159, x160) = fiat_p384_scalar_addcarryx_u32(0x0, x158, x155);
    let mut x161: u32 = 0;
    let mut x162: fiat_p384_scalar_u1 = 0;
    let (x161, x162) = fiat_p384_scalar_addcarryx_u32(x160, x156, x153);
    let mut x163: u32 = 0;
    let mut x164: fiat_p384_scalar_u1 = 0;
    let (x163, x164) = fiat_p384_scalar_addcarryx_u32(x162, x154, x151);
    let mut x165: u32 = 0;
    let mut x166: fiat_p384_scalar_u1 = 0;
    let (x165, x166) = fiat_p384_scalar_addcarryx_u32(x164, x152, x149);
    let mut x167: u32 = 0;
    let mut x168: fiat_p384_scalar_u1 = 0;
    let (x167, x168) = fiat_p384_scalar_addcarryx_u32(x166, x150, x147);
    let mut x169: u32 = 0;
    let mut x170: fiat_p384_scalar_u1 = 0;
    let (x169, x170) = fiat_p384_scalar_addcarryx_u32(x168, x148, x145);
    let mut x171: u32 = 0;
    let mut x172: fiat_p384_scalar_u1 = 0;
    let (x171, x172) = fiat_p384_scalar_addcarryx_u32(x170, x146, x143);
    let mut x173: u32 = 0;
    let mut x174: fiat_p384_scalar_u1 = 0;
    let (x173, x174) = fiat_p384_scalar_addcarryx_u32(x172, x144, x141);
    let mut x175: u32 = 0;
    let mut x176: fiat_p384_scalar_u1 = 0;
    let (x175, x176) = fiat_p384_scalar_addcarryx_u32(x174, x142, x139);
    let mut x177: u32 = 0;
    let mut x178: fiat_p384_scalar_u1 = 0;
    let (x177, x178) = fiat_p384_scalar_addcarryx_u32(x176, x140, x137);
    let mut x179: u32 = 0;
    let mut x180: fiat_p384_scalar_u1 = 0;
    let (x179, x180) = fiat_p384_scalar_addcarryx_u32(x178, x138, x135);
    let x181: u32 = ((x180 as u32) + x136);
    let mut x182: u32 = 0;
    let mut x183: fiat_p384_scalar_u1 = 0;
    let (x182, x183) = fiat_p384_scalar_addcarryx_u32(0x0, x111, x157);
    let mut x184: u32 = 0;
    let mut x185: fiat_p384_scalar_u1 = 0;
    let (x184, x185) = fiat_p384_scalar_addcarryx_u32(x183, x113, x159);
    let mut x186: u32 = 0;
    let mut x187: fiat_p384_scalar_u1 = 0;
    let (x186, x187) = fiat_p384_scalar_addcarryx_u32(x185, x115, x161);
    let mut x188: u32 = 0;
    let mut x189: fiat_p384_scalar_u1 = 0;
    let (x188, x189) = fiat_p384_scalar_addcarryx_u32(x187, x117, x163);
    let mut x190: u32 = 0;
    let mut x191: fiat_p384_scalar_u1 = 0;
    let (x190, x191) = fiat_p384_scalar_addcarryx_u32(x189, x119, x165);
    let mut x192: u32 = 0;
    let mut x193: fiat_p384_scalar_u1 = 0;
    let (x192, x193) = fiat_p384_scalar_addcarryx_u32(x191, x121, x167);
    let mut x194: u32 = 0;
    let mut x195: fiat_p384_scalar_u1 = 0;
    let (x194, x195) = fiat_p384_scalar_addcarryx_u32(x193, x123, x169);
    let mut x196: u32 = 0;
    let mut x197: fiat_p384_scalar_u1 = 0;
    let (x196, x197) = fiat_p384_scalar_addcarryx_u32(x195, x125, x171);
    let mut x198: u32 = 0;
    let mut x199: fiat_p384_scalar_u1 = 0;
    let (x198, x199) = fiat_p384_scalar_addcarryx_u32(x197, x127, x173);
    let mut x200: u32 = 0;
    let mut x201: fiat_p384_scalar_u1 = 0;
    let (x200, x201) = fiat_p384_scalar_addcarryx_u32(x199, x129, x175);
    let mut x202: u32 = 0;
    let mut x203: fiat_p384_scalar_u1 = 0;
    let (x202, x203) = fiat_p384_scalar_addcarryx_u32(x201, x131, x177);
    let mut x204: u32 = 0;
    let mut x205: fiat_p384_scalar_u1 = 0;
    let (x204, x205) = fiat_p384_scalar_addcarryx_u32(x203, x133, x179);
    let mut x206: u32 = 0;
    let mut x207: fiat_p384_scalar_u1 = 0;
    let (x206, x207) = fiat_p384_scalar_addcarryx_u32(x205, (x134 as u32), x181);
    let mut x208: u32 = 0;
    let mut x209: u32 = 0;
    let (x208, x209) = fiat_p384_scalar_mulx_u32(x182, 0xe88fdc45);
    let mut x210: u32 = 0;
    let mut x211: u32 = 0;
    let (x210, x211) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x212: u32 = 0;
    let mut x213: u32 = 0;
    let (x212, x213) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x214: u32 = 0;
    let mut x215: u32 = 0;
    let (x214, x215) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x216: u32 = 0;
    let mut x217: u32 = 0;
    let (x216, x217) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x218: u32 = 0;
    let mut x219: u32 = 0;
    let (x218, x219) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x220: u32 = 0;
    let mut x221: u32 = 0;
    let (x220, x221) = fiat_p384_scalar_mulx_u32(x208, 0xffffffff);
    let mut x222: u32 = 0;
    let mut x223: u32 = 0;
    let (x222, x223) = fiat_p384_scalar_mulx_u32(x208, 0xc7634d81);
    let mut x224: u32 = 0;
    let mut x225: u32 = 0;
    let (x224, x225) = fiat_p384_scalar_mulx_u32(x208, 0xf4372ddf);
    let mut x226: u32 = 0;
    let mut x227: u32 = 0;
    let (x226, x227) = fiat_p384_scalar_mulx_u32(x208, 0x581a0db2);
    let mut x228: u32 = 0;
    let mut x229: u32 = 0;
    let (x228, x229) = fiat_p384_scalar_mulx_u32(x208, 0x48b0a77a);
    let mut x230: u32 = 0;
    let mut x231: u32 = 0;
    let (x230, x231) = fiat_p384_scalar_mulx_u32(x208, 0xecec196a);
    let mut x232: u32 = 0;
    let mut x233: u32 = 0;
    let (x232, x233) = fiat_p384_scalar_mulx_u32(x208, 0xccc52973);
    let mut x234: u32 = 0;
    let mut x235: fiat_p384_scalar_u1 = 0;
    let (x234, x235) = fiat_p384_scalar_addcarryx_u32(0x0, x233, x230);
    let mut x236: u32 = 0;
    let mut x237: fiat_p384_scalar_u1 = 0;
    let (x236, x237) = fiat_p384_scalar_addcarryx_u32(x235, x231, x228);
    let mut x238: u32 = 0;
    let mut x239: fiat_p384_scalar_u1 = 0;
    let (x238, x239) = fiat_p384_scalar_addcarryx_u32(x237, x229, x226);
    let mut x240: u32 = 0;
    let mut x241: fiat_p384_scalar_u1 = 0;
    let (x240, x241) = fiat_p384_scalar_addcarryx_u32(x239, x227, x224);
    let mut x242: u32 = 0;
    let mut x243: fiat_p384_scalar_u1 = 0;
    let (x242, x243) = fiat_p384_scalar_addcarryx_u32(x241, x225, x222);
    let mut x244: u32 = 0;
    let mut x245: fiat_p384_scalar_u1 = 0;
    let (x244, x245) = fiat_p384_scalar_addcarryx_u32(x243, x223, x220);
    let mut x246: u32 = 0;
    let mut x247: fiat_p384_scalar_u1 = 0;
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(x245, x221, x218);
    let mut x248: u32 = 0;
    let mut x249: fiat_p384_scalar_u1 = 0;
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x219, x216);
    let mut x250: u32 = 0;
    let mut x251: fiat_p384_scalar_u1 = 0;
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x217, x214);
    let mut x252: u32 = 0;
    let mut x253: fiat_p384_scalar_u1 = 0;
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x215, x212);
    let mut x254: u32 = 0;
    let mut x255: fiat_p384_scalar_u1 = 0;
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x213, x210);
    let x256: u32 = ((x255 as u32) + x211);
    let mut x257: u32 = 0;
    let mut x258: fiat_p384_scalar_u1 = 0;
    let (x257, x258) = fiat_p384_scalar_addcarryx_u32(0x0, x182, x232);
    let mut x259: u32 = 0;
    let mut x260: fiat_p384_scalar_u1 = 0;
    let (x259, x260) = fiat_p384_scalar_addcarryx_u32(x258, x184, x234);
    let mut x261: u32 = 0;
    let mut x262: fiat_p384_scalar_u1 = 0;
    let (x261, x262) = fiat_p384_scalar_addcarryx_u32(x260, x186, x236);
    let mut x263: u32 = 0;
    let mut x264: fiat_p384_scalar_u1 = 0;
    let (x263, x264) = fiat_p384_scalar_addcarryx_u32(x262, x188, x238);
    let mut x265: u32 = 0;
    let mut x266: fiat_p384_scalar_u1 = 0;
    let (x265, x266) = fiat_p384_scalar_addcarryx_u32(x264, x190, x240);
    let mut x267: u32 = 0;
    let mut x268: fiat_p384_scalar_u1 = 0;
    let (x267, x268) = fiat_p384_scalar_addcarryx_u32(x266, x192, x242);
    let mut x269: u32 = 0;
    let mut x270: fiat_p384_scalar_u1 = 0;
    let (x269, x270) = fiat_p384_scalar_addcarryx_u32(x268, x194, x244);
    let mut x271: u32 = 0;
    let mut x272: fiat_p384_scalar_u1 = 0;
    let (x271, x272) = fiat_p384_scalar_addcarryx_u32(x270, x196, x246);
    let mut x273: u32 = 0;
    let mut x274: fiat_p384_scalar_u1 = 0;
    let (x273, x274) = fiat_p384_scalar_addcarryx_u32(x272, x198, x248);
    let mut x275: u32 = 0;
    let mut x276: fiat_p384_scalar_u1 = 0;
    let (x275, x276) = fiat_p384_scalar_addcarryx_u32(x274, x200, x250);
    let mut x277: u32 = 0;
    let mut x278: fiat_p384_scalar_u1 = 0;
    let (x277, x278) = fiat_p384_scalar_addcarryx_u32(x276, x202, x252);
    let mut x279: u32 = 0;
    let mut x280: fiat_p384_scalar_u1 = 0;
    let (x279, x280) = fiat_p384_scalar_addcarryx_u32(x278, x204, x254);
    let mut x281: u32 = 0;
    let mut x282: fiat_p384_scalar_u1 = 0;
    let (x281, x282) = fiat_p384_scalar_addcarryx_u32(x280, x206, x256);
    let x283: u32 = ((x282 as u32) + (x207 as u32));
    let mut x284: u32 = 0;
    let mut x285: u32 = 0;
    let (x284, x285) = fiat_p384_scalar_mulx_u32(x2, (arg1[11]));
    let mut x286: u32 = 0;
    let mut x287: u32 = 0;
    let (x286, x287) = fiat_p384_scalar_mulx_u32(x2, (arg1[10]));
    let mut x288: u32 = 0;
    let mut x289: u32 = 0;
    let (x288, x289) = fiat_p384_scalar_mulx_u32(x2, (arg1[9]));
    let mut x290: u32 = 0;
    let mut x291: u32 = 0;
    let (x290, x291) = fiat_p384_scalar_mulx_u32(x2, (arg1[8]));
    let mut x292: u32 = 0;
    let mut x293: u32 = 0;
    let (x292, x293) = fiat_p384_scalar_mulx_u32(x2, (arg1[7]));
    let mut x294: u32 = 0;
    let mut x295: u32 = 0;
    let (x294, x295) = fiat_p384_scalar_mulx_u32(x2, (arg1[6]));
    let mut x296: u32 = 0;
    let mut x297: u32 = 0;
    let (x296, x297) = fiat_p384_scalar_mulx_u32(x2, (arg1[5]));
    let mut x298: u32 = 0;
    let mut x299: u32 = 0;
    let (x298, x299) = fiat_p384_scalar_mulx_u32(x2, (arg1[4]));
    let mut x300: u32 = 0;
    let mut x301: u32 = 0;
    let (x300, x301) = fiat_p384_scalar_mulx_u32(x2, (arg1[3]));
    let mut x302: u32 = 0;
    let mut x303: u32 = 0;
    let (x302, x303) = fiat_p384_scalar_mulx_u32(x2, (arg1[2]));
    let mut x304: u32 = 0;
    let mut x305: u32 = 0;
    let (x304, x305) = fiat_p384_scalar_mulx_u32(x2, (arg1[1]));
    let mut x306: u32 = 0;
    let mut x307: u32 = 0;
    let (x306, x307) = fiat_p384_scalar_mulx_u32(x2, (arg1[0]));
    let mut x308: u32 = 0;
    let mut x309: fiat_p384_scalar_u1 = 0;
    let (x308, x309) = fiat_p384_scalar_addcarryx_u32(0x0, x307, x304);
    let mut x310: u32 = 0;
    let mut x311: fiat_p384_scalar_u1 = 0;
    let (x310, x311) = fiat_p384_scalar_addcarryx_u32(x309, x305, x302);
    let mut x312: u32 = 0;
    let mut x313: fiat_p384_scalar_u1 = 0;
    let (x312, x313) = fiat_p384_scalar_addcarryx_u32(x311, x303, x300);
    let mut x314: u32 = 0;
    let mut x315: fiat_p384_scalar_u1 = 0;
    let (x314, x315) = fiat_p384_scalar_addcarryx_u32(x313, x301, x298);
    let mut x316: u32 = 0;
    let mut x317: fiat_p384_scalar_u1 = 0;
    let (x316, x317) = fiat_p384_scalar_addcarryx_u32(x315, x299, x296);
    let mut x318: u32 = 0;
    let mut x319: fiat_p384_scalar_u1 = 0;
    let (x318, x319) = fiat_p384_scalar_addcarryx_u32(x317, x297, x294);
    let mut x320: u32 = 0;
    let mut x321: fiat_p384_scalar_u1 = 0;
    let (x320, x321) = fiat_p384_scalar_addcarryx_u32(x319, x295, x292);
    let mut x322: u32 = 0;
    let mut x323: fiat_p384_scalar_u1 = 0;
    let (x322, x323) = fiat_p384_scalar_addcarryx_u32(x321, x293, x290);
    let mut x324: u32 = 0;
    let mut x325: fiat_p384_scalar_u1 = 0;
    let (x324, x325) = fiat_p384_scalar_addcarryx_u32(x323, x291, x288);
    let mut x326: u32 = 0;
    let mut x327: fiat_p384_scalar_u1 = 0;
    let (x326, x327) = fiat_p384_scalar_addcarryx_u32(x325, x289, x286);
    let mut x328: u32 = 0;
    let mut x329: fiat_p384_scalar_u1 = 0;
    let (x328, x329) = fiat_p384_scalar_addcarryx_u32(x327, x287, x284);
    let x330: u32 = ((x329 as u32) + x285);
    let mut x331: u32 = 0;
    let mut x332: fiat_p384_scalar_u1 = 0;
    let (x331, x332) = fiat_p384_scalar_addcarryx_u32(0x0, x259, x306);
    let mut x333: u32 = 0;
    let mut x334: fiat_p384_scalar_u1 = 0;
    let (x333, x334) = fiat_p384_scalar_addcarryx_u32(x332, x261, x308);
    let mut x335: u32 = 0;
    let mut x336: fiat_p384_scalar_u1 = 0;
    let (x335, x336) = fiat_p384_scalar_addcarryx_u32(x334, x263, x310);
    let mut x337: u32 = 0;
    let mut x338: fiat_p384_scalar_u1 = 0;
    let (x337, x338) = fiat_p384_scalar_addcarryx_u32(x336, x265, x312);
    let mut x339: u32 = 0;
    let mut x340: fiat_p384_scalar_u1 = 0;
    let (x339, x340) = fiat_p384_scalar_addcarryx_u32(x338, x267, x314);
    let mut x341: u32 = 0;
    let mut x342: fiat_p384_scalar_u1 = 0;
    let (x341, x342) = fiat_p384_scalar_addcarryx_u32(x340, x269, x316);
    let mut x343: u32 = 0;
    let mut x344: fiat_p384_scalar_u1 = 0;
    let (x343, x344) = fiat_p384_scalar_addcarryx_u32(x342, x271, x318);
    let mut x345: u32 = 0;
    let mut x346: fiat_p384_scalar_u1 = 0;
    let (x345, x346) = fiat_p384_scalar_addcarryx_u32(x344, x273, x320);
    let mut x347: u32 = 0;
    let mut x348: fiat_p384_scalar_u1 = 0;
    let (x347, x348) = fiat_p384_scalar_addcarryx_u32(x346, x275, x322);
    let mut x349: u32 = 0;
    let mut x350: fiat_p384_scalar_u1 = 0;
    let (x349, x350) = fiat_p384_scalar_addcarryx_u32(x348, x277, x324);
    let mut x351: u32 = 0;
    let mut x352: fiat_p384_scalar_u1 = 0;
    let (x351, x352) = fiat_p384_scalar_addcarryx_u32(x350, x279, x326);
    let mut x353: u32 = 0;
    let mut x354: fiat_p384_scalar_u1 = 0;
    let (x353, x354) = fiat_p384_scalar_addcarryx_u32(x352, x281, x328);
    let mut x355: u32 = 0;
    let mut x356: fiat_p384_scalar_u1 = 0;
    let (x355, x356) = fiat_p384_scalar_addcarryx_u32(x354, x283, x330);
    let mut x357: u32 = 0;
    let mut x358: u32 = 0;
    let (x357, x358) = fiat_p384_scalar_mulx_u32(x331, 0xe88fdc45);
    let mut x359: u32 = 0;
    let mut x360: u32 = 0;
    let (x359, x360) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x361: u32 = 0;
    let mut x362: u32 = 0;
    let (x361, x362) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x363: u32 = 0;
    let mut x364: u32 = 0;
    let (x363, x364) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x365: u32 = 0;
    let mut x366: u32 = 0;
    let (x365, x366) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x367: u32 = 0;
    let mut x368: u32 = 0;
    let (x367, x368) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x369: u32 = 0;
    let mut x370: u32 = 0;
    let (x369, x370) = fiat_p384_scalar_mulx_u32(x357, 0xffffffff);
    let mut x371: u32 = 0;
    let mut x372: u32 = 0;
    let (x371, x372) = fiat_p384_scalar_mulx_u32(x357, 0xc7634d81);
    let mut x373: u32 = 0;
    let mut x374: u32 = 0;
    let (x373, x374) = fiat_p384_scalar_mulx_u32(x357, 0xf4372ddf);
    let mut x375: u32 = 0;
    let mut x376: u32 = 0;
    let (x375, x376) = fiat_p384_scalar_mulx_u32(x357, 0x581a0db2);
    let mut x377: u32 = 0;
    let mut x378: u32 = 0;
    let (x377, x378) = fiat_p384_scalar_mulx_u32(x357, 0x48b0a77a);
    let mut x379: u32 = 0;
    let mut x380: u32 = 0;
    let (x379, x380) = fiat_p384_scalar_mulx_u32(x357, 0xecec196a);
    let mut x381: u32 = 0;
    let mut x382: u32 = 0;
    let (x381, x382) = fiat_p384_scalar_mulx_u32(x357, 0xccc52973);
    let mut x383: u32 = 0;
    let mut x384: fiat_p384_scalar_u1 = 0;
    let (x383, x384) = fiat_p384_scalar_addcarryx_u32(0x0, x382, x379);
    let mut x385: u32 = 0;
    let mut x386: fiat_p384_scalar_u1 = 0;
    let (x385, x386) = fiat_p384_scalar_addcarryx_u32(x384, x380, x377);
    let mut x387: u32 = 0;
    let mut x388: fiat_p384_scalar_u1 = 0;
    let (x387, x388) = fiat_p384_scalar_addcarryx_u32(x386, x378, x375);
    let mut x389: u32 = 0;
    let mut x390: fiat_p384_scalar_u1 = 0;
    let (x389, x390) = fiat_p384_scalar_addcarryx_u32(x388, x376, x373);
    let mut x391: u32 = 0;
    let mut x392: fiat_p384_scalar_u1 = 0;
    let (x391, x392) = fiat_p384_scalar_addcarryx_u32(x390, x374, x371);
    let mut x393: u32 = 0;
    let mut x394: fiat_p384_scalar_u1 = 0;
    let (x393, x394) = fiat_p384_scalar_addcarryx_u32(x392, x372, x369);
    let mut x395: u32 = 0;
    let mut x396: fiat_p384_scalar_u1 = 0;
    let (x395, x396) = fiat_p384_scalar_addcarryx_u32(x394, x370, x367);
    let mut x397: u32 = 0;
    let mut x398: fiat_p384_scalar_u1 = 0;
    let (x397, x398) = fiat_p384_scalar_addcarryx_u32(x396, x368, x365);
    let mut x399: u32 = 0;
    let mut x400: fiat_p384_scalar_u1 = 0;
    let (x399, x400) = fiat_p384_scalar_addcarryx_u32(x398, x366, x363);
    let mut x401: u32 = 0;
    let mut x402: fiat_p384_scalar_u1 = 0;
    let (x401, x402) = fiat_p384_scalar_addcarryx_u32(x400, x364, x361);
    let mut x403: u32 = 0;
    let mut x404: fiat_p384_scalar_u1 = 0;
    let (x403, x404) = fiat_p384_scalar_addcarryx_u32(x402, x362, x359);
    let x405: u32 = ((x404 as u32) + x360);
    let mut x406: u32 = 0;
    let mut x407: fiat_p384_scalar_u1 = 0;
    let (x406, x407) = fiat_p384_scalar_addcarryx_u32(0x0, x331, x381);
    let mut x408: u32 = 0;
    let mut x409: fiat_p384_scalar_u1 = 0;
    let (x408, x409) = fiat_p384_scalar_addcarryx_u32(x407, x333, x383);
    let mut x410: u32 = 0;
    let mut x411: fiat_p384_scalar_u1 = 0;
    let (x410, x411) = fiat_p384_scalar_addcarryx_u32(x409, x335, x385);
    let mut x412: u32 = 0;
    let mut x413: fiat_p384_scalar_u1 = 0;
    let (x412, x413) = fiat_p384_scalar_addcarryx_u32(x411, x337, x387);
    let mut x414: u32 = 0;
    let mut x415: fiat_p384_scalar_u1 = 0;
    let (x414, x415) = fiat_p384_scalar_addcarryx_u32(x413, x339, x389);
    let mut x416: u32 = 0;
    let mut x417: fiat_p384_scalar_u1 = 0;
    let (x416, x417) = fiat_p384_scalar_addcarryx_u32(x415, x341, x391);
    let mut x418: u32 = 0;
    let mut x419: fiat_p384_scalar_u1 = 0;
    let (x418, x419) = fiat_p384_scalar_addcarryx_u32(x417, x343, x393);
    let mut x420: u32 = 0;
    let mut x421: fiat_p384_scalar_u1 = 0;
    let (x420, x421) = fiat_p384_scalar_addcarryx_u32(x419, x345, x395);
    let mut x422: u32 = 0;
    let mut x423: fiat_p384_scalar_u1 = 0;
    let (x422, x423) = fiat_p384_scalar_addcarryx_u32(x421, x347, x397);
    let mut x424: u32 = 0;
    let mut x425: fiat_p384_scalar_u1 = 0;
    let (x424, x425) = fiat_p384_scalar_addcarryx_u32(x423, x349, x399);
    let mut x426: u32 = 0;
    let mut x427: fiat_p384_scalar_u1 = 0;
    let (x426, x427) = fiat_p384_scalar_addcarryx_u32(x425, x351, x401);
    let mut x428: u32 = 0;
    let mut x429: fiat_p384_scalar_u1 = 0;
    let (x428, x429) = fiat_p384_scalar_addcarryx_u32(x427, x353, x403);
    let mut x430: u32 = 0;
    let mut x431: fiat_p384_scalar_u1 = 0;
    let (x430, x431) = fiat_p384_scalar_addcarryx_u32(x429, x355, x405);
    let x432: u32 = ((x431 as u32) + (x356 as u32));
    let mut x433: u32 = 0;
    let mut x434: u32 = 0;
    let (x433, x434) = fiat_p384_scalar_mulx_u32(x3, (arg1[11]));
    let mut x435: u32 = 0;
    let mut x436: u32 = 0;
    let (x435, x436) = fiat_p384_scalar_mulx_u32(x3, (arg1[10]));
    let mut x437: u32 = 0;
    let mut x438: u32 = 0;
    let (x437, x438) = fiat_p384_scalar_mulx_u32(x3, (arg1[9]));
    let mut x439: u32 = 0;
    let mut x440: u32 = 0;
    let (x439, x440) = fiat_p384_scalar_mulx_u32(x3, (arg1[8]));
    let mut x441: u32 = 0;
    let mut x442: u32 = 0;
    let (x441, x442) = fiat_p384_scalar_mulx_u32(x3, (arg1[7]));
    let mut x443: u32 = 0;
    let mut x444: u32 = 0;
    let (x443, x444) = fiat_p384_scalar_mulx_u32(x3, (arg1[6]));
    let mut x445: u32 = 0;
    let mut x446: u32 = 0;
    let (x445, x446) = fiat_p384_scalar_mulx_u32(x3, (arg1[5]));
    let mut x447: u32 = 0;
    let mut x448: u32 = 0;
    let (x447, x448) = fiat_p384_scalar_mulx_u32(x3, (arg1[4]));
    let mut x449: u32 = 0;
    let mut x450: u32 = 0;
    let (x449, x450) = fiat_p384_scalar_mulx_u32(x3, (arg1[3]));
    let mut x451: u32 = 0;
    let mut x452: u32 = 0;
    let (x451, x452) = fiat_p384_scalar_mulx_u32(x3, (arg1[2]));
    let mut x453: u32 = 0;
    let mut x454: u32 = 0;
    let (x453, x454) = fiat_p384_scalar_mulx_u32(x3, (arg1[1]));
    let mut x455: u32 = 0;
    let mut x456: u32 = 0;
    let (x455, x456) = fiat_p384_scalar_mulx_u32(x3, (arg1[0]));
    let mut x457: u32 = 0;
    let mut x458: fiat_p384_scalar_u1 = 0;
    let (x457, x458) = fiat_p384_scalar_addcarryx_u32(0x0, x456, x453);
    let mut x459: u32 = 0;
    let mut x460: fiat_p384_scalar_u1 = 0;
    let (x459, x460) = fiat_p384_scalar_addcarryx_u32(x458, x454, x451);
    let mut x461: u32 = 0;
    let mut x462: fiat_p384_scalar_u1 = 0;
    let (x461, x462) = fiat_p384_scalar_addcarryx_u32(x460, x452, x449);
    let mut x463: u32 = 0;
    let mut x464: fiat_p384_scalar_u1 = 0;
    let (x463, x464) = fiat_p384_scalar_addcarryx_u32(x462, x450, x447);
    let mut x465: u32 = 0;
    let mut x466: fiat_p384_scalar_u1 = 0;
    let (x465, x466) = fiat_p384_scalar_addcarryx_u32(x464, x448, x445);
    let mut x467: u32 = 0;
    let mut x468: fiat_p384_scalar_u1 = 0;
    let (x467, x468) = fiat_p384_scalar_addcarryx_u32(x466, x446, x443);
    let mut x469: u32 = 0;
    let mut x470: fiat_p384_scalar_u1 = 0;
    let (x469, x470) = fiat_p384_scalar_addcarryx_u32(x468, x444, x441);
    let mut x471: u32 = 0;
    let mut x472: fiat_p384_scalar_u1 = 0;
    let (x471, x472) = fiat_p384_scalar_addcarryx_u32(x470, x442, x439);
    let mut x473: u32 = 0;
    let mut x474: fiat_p384_scalar_u1 = 0;
    let (x473, x474) = fiat_p384_scalar_addcarryx_u32(x472, x440, x437);
    let mut x475: u32 = 0;
    let mut x476: fiat_p384_scalar_u1 = 0;
    let (x475, x476) = fiat_p384_scalar_addcarryx_u32(x474, x438, x435);
    let mut x477: u32 = 0;
    let mut x478: fiat_p384_scalar_u1 = 0;
    let (x477, x478) = fiat_p384_scalar_addcarryx_u32(x476, x436, x433);
    let x479: u32 = ((x478 as u32) + x434);
    let mut x480: u32 = 0;
    let mut x481: fiat_p384_scalar_u1 = 0;
    let (x480, x481) = fiat_p384_scalar_addcarryx_u32(0x0, x408, x455);
    let mut x482: u32 = 0;
    let mut x483: fiat_p384_scalar_u1 = 0;
    let (x482, x483) = fiat_p384_scalar_addcarryx_u32(x481, x410, x457);
    let mut x484: u32 = 0;
    let mut x485: fiat_p384_scalar_u1 = 0;
    let (x484, x485) = fiat_p384_scalar_addcarryx_u32(x483, x412, x459);
    let mut x486: u32 = 0;
    let mut x487: fiat_p384_scalar_u1 = 0;
    let (x486, x487) = fiat_p384_scalar_addcarryx_u32(x485, x414, x461);
    let mut x488: u32 = 0;
    let mut x489: fiat_p384_scalar_u1 = 0;
    let (x488, x489) = fiat_p384_scalar_addcarryx_u32(x487, x416, x463);
    let mut x490: u32 = 0;
    let mut x491: fiat_p384_scalar_u1 = 0;
    let (x490, x491) = fiat_p384_scalar_addcarryx_u32(x489, x418, x465);
    let mut x492: u32 = 0;
    let mut x493: fiat_p384_scalar_u1 = 0;
    let (x492, x493) = fiat_p384_scalar_addcarryx_u32(x491, x420, x467);
    let mut x494: u32 = 0;
    let mut x495: fiat_p384_scalar_u1 = 0;
    let (x494, x495) = fiat_p384_scalar_addcarryx_u32(x493, x422, x469);
    let mut x496: u32 = 0;
    let mut x497: fiat_p384_scalar_u1 = 0;
    let (x496, x497) = fiat_p384_scalar_addcarryx_u32(x495, x424, x471);
    let mut x498: u32 = 0;
    let mut x499: fiat_p384_scalar_u1 = 0;
    let (x498, x499) = fiat_p384_scalar_addcarryx_u32(x497, x426, x473);
    let mut x500: u32 = 0;
    let mut x501: fiat_p384_scalar_u1 = 0;
    let (x500, x501) = fiat_p384_scalar_addcarryx_u32(x499, x428, x475);
    let mut x502: u32 = 0;
    let mut x503: fiat_p384_scalar_u1 = 0;
    let (x502, x503) = fiat_p384_scalar_addcarryx_u32(x501, x430, x477);
    let mut x504: u32 = 0;
    let mut x505: fiat_p384_scalar_u1 = 0;
    let (x504, x505) = fiat_p384_scalar_addcarryx_u32(x503, x432, x479);
    let mut x506: u32 = 0;
    let mut x507: u32 = 0;
    let (x506, x507) = fiat_p384_scalar_mulx_u32(x480, 0xe88fdc45);
    let mut x508: u32 = 0;
    let mut x509: u32 = 0;
    let (x508, x509) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x510: u32 = 0;
    let mut x511: u32 = 0;
    let (x510, x511) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x512: u32 = 0;
    let mut x513: u32 = 0;
    let (x512, x513) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x514: u32 = 0;
    let mut x515: u32 = 0;
    let (x514, x515) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x516: u32 = 0;
    let mut x517: u32 = 0;
    let (x516, x517) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x518: u32 = 0;
    let mut x519: u32 = 0;
    let (x518, x519) = fiat_p384_scalar_mulx_u32(x506, 0xffffffff);
    let mut x520: u32 = 0;
    let mut x521: u32 = 0;
    let (x520, x521) = fiat_p384_scalar_mulx_u32(x506, 0xc7634d81);
    let mut x522: u32 = 0;
    let mut x523: u32 = 0;
    let (x522, x523) = fiat_p384_scalar_mulx_u32(x506, 0xf4372ddf);
    let mut x524: u32 = 0;
    let mut x525: u32 = 0;
    let (x524, x525) = fiat_p384_scalar_mulx_u32(x506, 0x581a0db2);
    let mut x526: u32 = 0;
    let mut x527: u32 = 0;
    let (x526, x527) = fiat_p384_scalar_mulx_u32(x506, 0x48b0a77a);
    let mut x528: u32 = 0;
    let mut x529: u32 = 0;
    let (x528, x529) = fiat_p384_scalar_mulx_u32(x506, 0xecec196a);
    let mut x530: u32 = 0;
    let mut x531: u32 = 0;
    let (x530, x531) = fiat_p384_scalar_mulx_u32(x506, 0xccc52973);
    let mut x532: u32 = 0;
    let mut x533: fiat_p384_scalar_u1 = 0;
    let (x532, x533) = fiat_p384_scalar_addcarryx_u32(0x0, x531, x528);
    let mut x534: u32 = 0;
    let mut x535: fiat_p384_scalar_u1 = 0;
    let (x534, x535) = fiat_p384_scalar_addcarryx_u32(x533, x529, x526);
    let mut x536: u32 = 0;
    let mut x537: fiat_p384_scalar_u1 = 0;
    let (x536, x537) = fiat_p384_scalar_addcarryx_u32(x535, x527, x524);
    let mut x538: u32 = 0;
    let mut x539: fiat_p384_scalar_u1 = 0;
    let (x538, x539) = fiat_p384_scalar_addcarryx_u32(x537, x525, x522);
    let mut x540: u32 = 0;
    let mut x541: fiat_p384_scalar_u1 = 0;
    let (x540, x541) = fiat_p384_scalar_addcarryx_u32(x539, x523, x520);
    let mut x542: u32 = 0;
    let mut x543: fiat_p384_scalar_u1 = 0;
    let (x542, x543) = fiat_p384_scalar_addcarryx_u32(x541, x521, x518);
    let mut x544: u32 = 0;
    let mut x545: fiat_p384_scalar_u1 = 0;
    let (x544, x545) = fiat_p384_scalar_addcarryx_u32(x543, x519, x516);
    let mut x546: u32 = 0;
    let mut x547: fiat_p384_scalar_u1 = 0;
    let (x546, x547) = fiat_p384_scalar_addcarryx_u32(x545, x517, x514);
    let mut x548: u32 = 0;
    let mut x549: fiat_p384_scalar_u1 = 0;
    let (x548, x549) = fiat_p384_scalar_addcarryx_u32(x547, x515, x512);
    let mut x550: u32 = 0;
    let mut x551: fiat_p384_scalar_u1 = 0;
    let (x550, x551) = fiat_p384_scalar_addcarryx_u32(x549, x513, x510);
    let mut x552: u32 = 0;
    let mut x553: fiat_p384_scalar_u1 = 0;
    let (x552, x553) = fiat_p384_scalar_addcarryx_u32(x551, x511, x508);
    let x554: u32 = ((x553 as u32) + x509);
    let mut x555: u32 = 0;
    let mut x556: fiat_p384_scalar_u1 = 0;
    let (x555, x556) = fiat_p384_scalar_addcarryx_u32(0x0, x480, x530);
    let mut x557: u32 = 0;
    let mut x558: fiat_p384_scalar_u1 = 0;
    let (x557, x558) = fiat_p384_scalar_addcarryx_u32(x556, x482, x532);
    let mut x559: u32 = 0;
    let mut x560: fiat_p384_scalar_u1 = 0;
    let (x559, x560) = fiat_p384_scalar_addcarryx_u32(x558, x484, x534);
    let mut x561: u32 = 0;
    let mut x562: fiat_p384_scalar_u1 = 0;
    let (x561, x562) = fiat_p384_scalar_addcarryx_u32(x560, x486, x536);
    let mut x563: u32 = 0;
    let mut x564: fiat_p384_scalar_u1 = 0;
    let (x563, x564) = fiat_p384_scalar_addcarryx_u32(x562, x488, x538);
    let mut x565: u32 = 0;
    let mut x566: fiat_p384_scalar_u1 = 0;
    let (x565, x566) = fiat_p384_scalar_addcarryx_u32(x564, x490, x540);
    let mut x567: u32 = 0;
    let mut x568: fiat_p384_scalar_u1 = 0;
    let (x567, x568) = fiat_p384_scalar_addcarryx_u32(x566, x492, x542);
    let mut x569: u32 = 0;
    let mut x570: fiat_p384_scalar_u1 = 0;
    let (x569, x570) = fiat_p384_scalar_addcarryx_u32(x568, x494, x544);
    let mut x571: u32 = 0;
    let mut x572: fiat_p384_scalar_u1 = 0;
    let (x571, x572) = fiat_p384_scalar_addcarryx_u32(x570, x496, x546);
    let mut x573: u32 = 0;
    let mut x574: fiat_p384_scalar_u1 = 0;
    let (x573, x574) = fiat_p384_scalar_addcarryx_u32(x572, x498, x548);
    let mut x575: u32 = 0;
    let mut x576: fiat_p384_scalar_u1 = 0;
    let (x575, x576) = fiat_p384_scalar_addcarryx_u32(x574, x500, x550);
    let mut x577: u32 = 0;
    let mut x578: fiat_p384_scalar_u1 = 0;
    let (x577, x578) = fiat_p384_scalar_addcarryx_u32(x576, x502, x552);
    let mut x579: u32 = 0;
    let mut x580: fiat_p384_scalar_u1 = 0;
    let (x579, x580) = fiat_p384_scalar_addcarryx_u32(x578, x504, x554);
    let x581: u32 = ((x580 as u32) + (x505 as u32));
    let mut x582: u32 = 0;
    let mut x583: u32 = 0;
    let (x582, x583) = fiat_p384_scalar_mulx_u32(x4, (arg1[11]));
    let mut x584: u32 = 0;
    let mut x585: u32 = 0;
    let (x584, x585) = fiat_p384_scalar_mulx_u32(x4, (arg1[10]));
    let mut x586: u32 = 0;
    let mut x587: u32 = 0;
    let (x586, x587) = fiat_p384_scalar_mulx_u32(x4, (arg1[9]));
    let mut x588: u32 = 0;
    let mut x589: u32 = 0;
    let (x588, x589) = fiat_p384_scalar_mulx_u32(x4, (arg1[8]));
    let mut x590: u32 = 0;
    let mut x591: u32 = 0;
    let (x590, x591) = fiat_p384_scalar_mulx_u32(x4, (arg1[7]));
    let mut x592: u32 = 0;
    let mut x593: u32 = 0;
    let (x592, x593) = fiat_p384_scalar_mulx_u32(x4, (arg1[6]));
    let mut x594: u32 = 0;
    let mut x595: u32 = 0;
    let (x594, x595) = fiat_p384_scalar_mulx_u32(x4, (arg1[5]));
    let mut x596: u32 = 0;
    let mut x597: u32 = 0;
    let (x596, x597) = fiat_p384_scalar_mulx_u32(x4, (arg1[4]));
    let mut x598: u32 = 0;
    let mut x599: u32 = 0;
    let (x598, x599) = fiat_p384_scalar_mulx_u32(x4, (arg1[3]));
    let mut x600: u32 = 0;
    let mut x601: u32 = 0;
    let (x600, x601) = fiat_p384_scalar_mulx_u32(x4, (arg1[2]));
    let mut x602: u32 = 0;
    let mut x603: u32 = 0;
    let (x602, x603) = fiat_p384_scalar_mulx_u32(x4, (arg1[1]));
    let mut x604: u32 = 0;
    let mut x605: u32 = 0;
    let (x604, x605) = fiat_p384_scalar_mulx_u32(x4, (arg1[0]));
    let mut x606: u32 = 0;
    let mut x607: fiat_p384_scalar_u1 = 0;
    let (x606, x607) = fiat_p384_scalar_addcarryx_u32(0x0, x605, x602);
    let mut x608: u32 = 0;
    let mut x609: fiat_p384_scalar_u1 = 0;
    let (x608, x609) = fiat_p384_scalar_addcarryx_u32(x607, x603, x600);
    let mut x610: u32 = 0;
    let mut x611: fiat_p384_scalar_u1 = 0;
    let (x610, x611) = fiat_p384_scalar_addcarryx_u32(x609, x601, x598);
    let mut x612: u32 = 0;
    let mut x613: fiat_p384_scalar_u1 = 0;
    let (x612, x613) = fiat_p384_scalar_addcarryx_u32(x611, x599, x596);
    let mut x614: u32 = 0;
    let mut x615: fiat_p384_scalar_u1 = 0;
    let (x614, x615) = fiat_p384_scalar_addcarryx_u32(x613, x597, x594);
    let mut x616: u32 = 0;
    let mut x617: fiat_p384_scalar_u1 = 0;
    let (x616, x617) = fiat_p384_scalar_addcarryx_u32(x615, x595, x592);
    let mut x618: u32 = 0;
    let mut x619: fiat_p384_scalar_u1 = 0;
    let (x618, x619) = fiat_p384_scalar_addcarryx_u32(x617, x593, x590);
    let mut x620: u32 = 0;
    let mut x621: fiat_p384_scalar_u1 = 0;
    let (x620, x621) = fiat_p384_scalar_addcarryx_u32(x619, x591, x588);
    let mut x622: u32 = 0;
    let mut x623: fiat_p384_scalar_u1 = 0;
    let (x622, x623) = fiat_p384_scalar_addcarryx_u32(x621, x589, x586);
    let mut x624: u32 = 0;
    let mut x625: fiat_p384_scalar_u1 = 0;
    let (x624, x625) = fiat_p384_scalar_addcarryx_u32(x623, x587, x584);
    let mut x626: u32 = 0;
    let mut x627: fiat_p384_scalar_u1 = 0;
    let (x626, x627) = fiat_p384_scalar_addcarryx_u32(x625, x585, x582);
    let x628: u32 = ((x627 as u32) + x583);
    let mut x629: u32 = 0;
    let mut x630: fiat_p384_scalar_u1 = 0;
    let (x629, x630) = fiat_p384_scalar_addcarryx_u32(0x0, x557, x604);
    let mut x631: u32 = 0;
    let mut x632: fiat_p384_scalar_u1 = 0;
    let (x631, x632) = fiat_p384_scalar_addcarryx_u32(x630, x559, x606);
    let mut x633: u32 = 0;
    let mut x634: fiat_p384_scalar_u1 = 0;
    let (x633, x634) = fiat_p384_scalar_addcarryx_u32(x632, x561, x608);
    let mut x635: u32 = 0;
    let mut x636: fiat_p384_scalar_u1 = 0;
    let (x635, x636) = fiat_p384_scalar_addcarryx_u32(x634, x563, x610);
    let mut x637: u32 = 0;
    let mut x638: fiat_p384_scalar_u1 = 0;
    let (x637, x638) = fiat_p384_scalar_addcarryx_u32(x636, x565, x612);
    let mut x639: u32 = 0;
    let mut x640: fiat_p384_scalar_u1 = 0;
    let (x639, x640) = fiat_p384_scalar_addcarryx_u32(x638, x567, x614);
    let mut x641: u32 = 0;
    let mut x642: fiat_p384_scalar_u1 = 0;
    let (x641, x642) = fiat_p384_scalar_addcarryx_u32(x640, x569, x616);
    let mut x643: u32 = 0;
    let mut x644: fiat_p384_scalar_u1 = 0;
    let (x643, x644) = fiat_p384_scalar_addcarryx_u32(x642, x571, x618);
    let mut x645: u32 = 0;
    let mut x646: fiat_p384_scalar_u1 = 0;
    let (x645, x646) = fiat_p384_scalar_addcarryx_u32(x644, x573, x620);
    let mut x647: u32 = 0;
    let mut x648: fiat_p384_scalar_u1 = 0;
    let (x647, x648) = fiat_p384_scalar_addcarryx_u32(x646, x575, x622);
    let mut x649: u32 = 0;
    let mut x650: fiat_p384_scalar_u1 = 0;
    let (x649, x650) = fiat_p384_scalar_addcarryx_u32(x648, x577, x624);
    let mut x651: u32 = 0;
    let mut x652: fiat_p384_scalar_u1 = 0;
    let (x651, x652) = fiat_p384_scalar_addcarryx_u32(x650, x579, x626);
    let mut x653: u32 = 0;
    let mut x654: fiat_p384_scalar_u1 = 0;
    let (x653, x654) = fiat_p384_scalar_addcarryx_u32(x652, x581, x628);
    let mut x655: u32 = 0;
    let mut x656: u32 = 0;
    let (x655, x656) = fiat_p384_scalar_mulx_u32(x629, 0xe88fdc45);
    let mut x657: u32 = 0;
    let mut x658: u32 = 0;
    let (x657, x658) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x659: u32 = 0;
    let mut x660: u32 = 0;
    let (x659, x660) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x661: u32 = 0;
    let mut x662: u32 = 0;
    let (x661, x662) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x663: u32 = 0;
    let mut x664: u32 = 0;
    let (x663, x664) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x665: u32 = 0;
    let mut x666: u32 = 0;
    let (x665, x666) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x667: u32 = 0;
    let mut x668: u32 = 0;
    let (x667, x668) = fiat_p384_scalar_mulx_u32(x655, 0xffffffff);
    let mut x669: u32 = 0;
    let mut x670: u32 = 0;
    let (x669, x670) = fiat_p384_scalar_mulx_u32(x655, 0xc7634d81);
    let mut x671: u32 = 0;
    let mut x672: u32 = 0;
    let (x671, x672) = fiat_p384_scalar_mulx_u32(x655, 0xf4372ddf);
    let mut x673: u32 = 0;
    let mut x674: u32 = 0;
    let (x673, x674) = fiat_p384_scalar_mulx_u32(x655, 0x581a0db2);
    let mut x675: u32 = 0;
    let mut x676: u32 = 0;
    let (x675, x676) = fiat_p384_scalar_mulx_u32(x655, 0x48b0a77a);
    let mut x677: u32 = 0;
    let mut x678: u32 = 0;
    let (x677, x678) = fiat_p384_scalar_mulx_u32(x655, 0xecec196a);
    let mut x679: u32 = 0;
    let mut x680: u32 = 0;
    let (x679, x680) = fiat_p384_scalar_mulx_u32(x655, 0xccc52973);
    let mut x681: u32 = 0;
    let mut x682: fiat_p384_scalar_u1 = 0;
    let (x681, x682) = fiat_p384_scalar_addcarryx_u32(0x0, x680, x677);
    let mut x683: u32 = 0;
    let mut x684: fiat_p384_scalar_u1 = 0;
    let (x683, x684) = fiat_p384_scalar_addcarryx_u32(x682, x678, x675);
    let mut x685: u32 = 0;
    let mut x686: fiat_p384_scalar_u1 = 0;
    let (x685, x686) = fiat_p384_scalar_addcarryx_u32(x684, x676, x673);
    let mut x687: u32 = 0;
    let mut x688: fiat_p384_scalar_u1 = 0;
    let (x687, x688) = fiat_p384_scalar_addcarryx_u32(x686, x674, x671);
    let mut x689: u32 = 0;
    let mut x690: fiat_p384_scalar_u1 = 0;
    let (x689, x690) = fiat_p384_scalar_addcarryx_u32(x688, x672, x669);
    let mut x691: u32 = 0;
    let mut x692: fiat_p384_scalar_u1 = 0;
    let (x691, x692) = fiat_p384_scalar_addcarryx_u32(x690, x670, x667);
    let mut x693: u32 = 0;
    let mut x694: fiat_p384_scalar_u1 = 0;
    let (x693, x694) = fiat_p384_scalar_addcarryx_u32(x692, x668, x665);
    let mut x695: u32 = 0;
    let mut x696: fiat_p384_scalar_u1 = 0;
    let (x695, x696) = fiat_p384_scalar_addcarryx_u32(x694, x666, x663);
    let mut x697: u32 = 0;
    let mut x698: fiat_p384_scalar_u1 = 0;
    let (x697, x698) = fiat_p384_scalar_addcarryx_u32(x696, x664, x661);
    let mut x699: u32 = 0;
    let mut x700: fiat_p384_scalar_u1 = 0;
    let (x699, x700) = fiat_p384_scalar_addcarryx_u32(x698, x662, x659);
    let mut x701: u32 = 0;
    let mut x702: fiat_p384_scalar_u1 = 0;
    let (x701, x702) = fiat_p384_scalar_addcarryx_u32(x700, x660, x657);
    let x703: u32 = ((x702 as u32) + x658);
    let mut x704: u32 = 0;
    let mut x705: fiat_p384_scalar_u1 = 0;
    let (x704, x705) = fiat_p384_scalar_addcarryx_u32(0x0, x629, x679);
    let mut x706: u32 = 0;
    let mut x707: fiat_p384_scalar_u1 = 0;
    let (x706, x707) = fiat_p384_scalar_addcarryx_u32(x705, x631, x681);
    let mut x708: u32 = 0;
    let mut x709: fiat_p384_scalar_u1 = 0;
    let (x708, x709) = fiat_p384_scalar_addcarryx_u32(x707, x633, x683);
    let mut x710: u32 = 0;
    let mut x711: fiat_p384_scalar_u1 = 0;
    let (x710, x711) = fiat_p384_scalar_addcarryx_u32(x709, x635, x685);
    let mut x712: u32 = 0;
    let mut x713: fiat_p384_scalar_u1 = 0;
    let (x712, x713) = fiat_p384_scalar_addcarryx_u32(x711, x637, x687);
    let mut x714: u32 = 0;
    let mut x715: fiat_p384_scalar_u1 = 0;
    let (x714, x715) = fiat_p384_scalar_addcarryx_u32(x713, x639, x689);
    let mut x716: u32 = 0;
    let mut x717: fiat_p384_scalar_u1 = 0;
    let (x716, x717) = fiat_p384_scalar_addcarryx_u32(x715, x641, x691);
    let mut x718: u32 = 0;
    let mut x719: fiat_p384_scalar_u1 = 0;
    let (x718, x719) = fiat_p384_scalar_addcarryx_u32(x717, x643, x693);
    let mut x720: u32 = 0;
    let mut x721: fiat_p384_scalar_u1 = 0;
    let (x720, x721) = fiat_p384_scalar_addcarryx_u32(x719, x645, x695);
    let mut x722: u32 = 0;
    let mut x723: fiat_p384_scalar_u1 = 0;
    let (x722, x723) = fiat_p384_scalar_addcarryx_u32(x721, x647, x697);
    let mut x724: u32 = 0;
    let mut x725: fiat_p384_scalar_u1 = 0;
    let (x724, x725) = fiat_p384_scalar_addcarryx_u32(x723, x649, x699);
    let mut x726: u32 = 0;
    let mut x727: fiat_p384_scalar_u1 = 0;
    let (x726, x727) = fiat_p384_scalar_addcarryx_u32(x725, x651, x701);
    let mut x728: u32 = 0;
    let mut x729: fiat_p384_scalar_u1 = 0;
    let (x728, x729) = fiat_p384_scalar_addcarryx_u32(x727, x653, x703);
    let x730: u32 = ((x729 as u32) + (x654 as u32));
    let mut x731: u32 = 0;
    let mut x732: u32 = 0;
    let (x731, x732) = fiat_p384_scalar_mulx_u32(x5, (arg1[11]));
    let mut x733: u32 = 0;
    let mut x734: u32 = 0;
    let (x733, x734) = fiat_p384_scalar_mulx_u32(x5, (arg1[10]));
    let mut x735: u32 = 0;
    let mut x736: u32 = 0;
    let (x735, x736) = fiat_p384_scalar_mulx_u32(x5, (arg1[9]));
    let mut x737: u32 = 0;
    let mut x738: u32 = 0;
    let (x737, x738) = fiat_p384_scalar_mulx_u32(x5, (arg1[8]));
    let mut x739: u32 = 0;
    let mut x740: u32 = 0;
    let (x739, x740) = fiat_p384_scalar_mulx_u32(x5, (arg1[7]));
    let mut x741: u32 = 0;
    let mut x742: u32 = 0;
    let (x741, x742) = fiat_p384_scalar_mulx_u32(x5, (arg1[6]));
    let mut x743: u32 = 0;
    let mut x744: u32 = 0;
    let (x743, x744) = fiat_p384_scalar_mulx_u32(x5, (arg1[5]));
    let mut x745: u32 = 0;
    let mut x746: u32 = 0;
    let (x745, x746) = fiat_p384_scalar_mulx_u32(x5, (arg1[4]));
    let mut x747: u32 = 0;
    let mut x748: u32 = 0;
    let (x747, x748) = fiat_p384_scalar_mulx_u32(x5, (arg1[3]));
    let mut x749: u32 = 0;
    let mut x750: u32 = 0;
    let (x749, x750) = fiat_p384_scalar_mulx_u32(x5, (arg1[2]));
    let mut x751: u32 = 0;
    let mut x752: u32 = 0;
    let (x751, x752) = fiat_p384_scalar_mulx_u32(x5, (arg1[1]));
    let mut x753: u32 = 0;
    let mut x754: u32 = 0;
    let (x753, x754) = fiat_p384_scalar_mulx_u32(x5, (arg1[0]));
    let mut x755: u32 = 0;
    let mut x756: fiat_p384_scalar_u1 = 0;
    let (x755, x756) = fiat_p384_scalar_addcarryx_u32(0x0, x754, x751);
    let mut x757: u32 = 0;
    let mut x758: fiat_p384_scalar_u1 = 0;
    let (x757, x758) = fiat_p384_scalar_addcarryx_u32(x756, x752, x749);
    let mut x759: u32 = 0;
    let mut x760: fiat_p384_scalar_u1 = 0;
    let (x759, x760) = fiat_p384_scalar_addcarryx_u32(x758, x750, x747);
    let mut x761: u32 = 0;
    let mut x762: fiat_p384_scalar_u1 = 0;
    let (x761, x762) = fiat_p384_scalar_addcarryx_u32(x760, x748, x745);
    let mut x763: u32 = 0;
    let mut x764: fiat_p384_scalar_u1 = 0;
    let (x763, x764) = fiat_p384_scalar_addcarryx_u32(x762, x746, x743);
    let mut x765: u32 = 0;
    let mut x766: fiat_p384_scalar_u1 = 0;
    let (x765, x766) = fiat_p384_scalar_addcarryx_u32(x764, x744, x741);
    let mut x767: u32 = 0;
    let mut x768: fiat_p384_scalar_u1 = 0;
    let (x767, x768) = fiat_p384_scalar_addcarryx_u32(x766, x742, x739);
    let mut x769: u32 = 0;
    let mut x770: fiat_p384_scalar_u1 = 0;
    let (x769, x770) = fiat_p384_scalar_addcarryx_u32(x768, x740, x737);
    let mut x771: u32 = 0;
    let mut x772: fiat_p384_scalar_u1 = 0;
    let (x771, x772) = fiat_p384_scalar_addcarryx_u32(x770, x738, x735);
    let mut x773: u32 = 0;
    let mut x774: fiat_p384_scalar_u1 = 0;
    let (x773, x774) = fiat_p384_scalar_addcarryx_u32(x772, x736, x733);
    let mut x775: u32 = 0;
    let mut x776: fiat_p384_scalar_u1 = 0;
    let (x775, x776) = fiat_p384_scalar_addcarryx_u32(x774, x734, x731);
    let x777: u32 = ((x776 as u32) + x732);
    let mut x778: u32 = 0;
    let mut x779: fiat_p384_scalar_u1 = 0;
    let (x778, x779) = fiat_p384_scalar_addcarryx_u32(0x0, x706, x753);
    let mut x780: u32 = 0;
    let mut x781: fiat_p384_scalar_u1 = 0;
    let (x780, x781) = fiat_p384_scalar_addcarryx_u32(x779, x708, x755);
    let mut x782: u32 = 0;
    let mut x783: fiat_p384_scalar_u1 = 0;
    let (x782, x783) = fiat_p384_scalar_addcarryx_u32(x781, x710, x757);
    let mut x784: u32 = 0;
    let mut x785: fiat_p384_scalar_u1 = 0;
    let (x784, x785) = fiat_p384_scalar_addcarryx_u32(x783, x712, x759);
    let mut x786: u32 = 0;
    let mut x787: fiat_p384_scalar_u1 = 0;
    let (x786, x787) = fiat_p384_scalar_addcarryx_u32(x785, x714, x761);
    let mut x788: u32 = 0;
    let mut x789: fiat_p384_scalar_u1 = 0;
    let (x788, x789) = fiat_p384_scalar_addcarryx_u32(x787, x716, x763);
    let mut x790: u32 = 0;
    let mut x791: fiat_p384_scalar_u1 = 0;
    let (x790, x791) = fiat_p384_scalar_addcarryx_u32(x789, x718, x765);
    let mut x792: u32 = 0;
    let mut x793: fiat_p384_scalar_u1 = 0;
    let (x792, x793) = fiat_p384_scalar_addcarryx_u32(x791, x720, x767);
    let mut x794: u32 = 0;
    let mut x795: fiat_p384_scalar_u1 = 0;
    let (x794, x795) = fiat_p384_scalar_addcarryx_u32(x793, x722, x769);
    let mut x796: u32 = 0;
    let mut x797: fiat_p384_scalar_u1 = 0;
    let (x796, x797) = fiat_p384_scalar_addcarryx_u32(x795, x724, x771);
    let mut x798: u32 = 0;
    let mut x799: fiat_p384_scalar_u1 = 0;
    let (x798, x799) = fiat_p384_scalar_addcarryx_u32(x797, x726, x773);
    let mut x800: u32 = 0;
    let mut x801: fiat_p384_scalar_u1 = 0;
    let (x800, x801) = fiat_p384_scalar_addcarryx_u32(x799, x728, x775);
    let mut x802: u32 = 0;
    let mut x803: fiat_p384_scalar_u1 = 0;
    let (x802, x803) = fiat_p384_scalar_addcarryx_u32(x801, x730, x777);
    let mut x804: u32 = 0;
    let mut x805: u32 = 0;
    let (x804, x805) = fiat_p384_scalar_mulx_u32(x778, 0xe88fdc45);
    let mut x806: u32 = 0;
    let mut x807: u32 = 0;
    let (x806, x807) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x808: u32 = 0;
    let mut x809: u32 = 0;
    let (x808, x809) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x810: u32 = 0;
    let mut x811: u32 = 0;
    let (x810, x811) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x812: u32 = 0;
    let mut x813: u32 = 0;
    let (x812, x813) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x814: u32 = 0;
    let mut x815: u32 = 0;
    let (x814, x815) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x816: u32 = 0;
    let mut x817: u32 = 0;
    let (x816, x817) = fiat_p384_scalar_mulx_u32(x804, 0xffffffff);
    let mut x818: u32 = 0;
    let mut x819: u32 = 0;
    let (x818, x819) = fiat_p384_scalar_mulx_u32(x804, 0xc7634d81);
    let mut x820: u32 = 0;
    let mut x821: u32 = 0;
    let (x820, x821) = fiat_p384_scalar_mulx_u32(x804, 0xf4372ddf);
    let mut x822: u32 = 0;
    let mut x823: u32 = 0;
    let (x822, x823) = fiat_p384_scalar_mulx_u32(x804, 0x581a0db2);
    let mut x824: u32 = 0;
    let mut x825: u32 = 0;
    let (x824, x825) = fiat_p384_scalar_mulx_u32(x804, 0x48b0a77a);
    let mut x826: u32 = 0;
    let mut x827: u32 = 0;
    let (x826, x827) = fiat_p384_scalar_mulx_u32(x804, 0xecec196a);
    let mut x828: u32 = 0;
    let mut x829: u32 = 0;
    let (x828, x829) = fiat_p384_scalar_mulx_u32(x804, 0xccc52973);
    let mut x830: u32 = 0;
    let mut x831: fiat_p384_scalar_u1 = 0;
    let (x830, x831) = fiat_p384_scalar_addcarryx_u32(0x0, x829, x826);
    let mut x832: u32 = 0;
    let mut x833: fiat_p384_scalar_u1 = 0;
    let (x832, x833) = fiat_p384_scalar_addcarryx_u32(x831, x827, x824);
    let mut x834: u32 = 0;
    let mut x835: fiat_p384_scalar_u1 = 0;
    let (x834, x835) = fiat_p384_scalar_addcarryx_u32(x833, x825, x822);
    let mut x836: u32 = 0;
    let mut x837: fiat_p384_scalar_u1 = 0;
    let (x836, x837) = fiat_p384_scalar_addcarryx_u32(x835, x823, x820);
    let mut x838: u32 = 0;
    let mut x839: fiat_p384_scalar_u1 = 0;
    let (x838, x839) = fiat_p384_scalar_addcarryx_u32(x837, x821, x818);
    let mut x840: u32 = 0;
    let mut x841: fiat_p384_scalar_u1 = 0;
    let (x840, x841) = fiat_p384_scalar_addcarryx_u32(x839, x819, x816);
    let mut x842: u32 = 0;
    let mut x843: fiat_p384_scalar_u1 = 0;
    let (x842, x843) = fiat_p384_scalar_addcarryx_u32(x841, x817, x814);
    let mut x844: u32 = 0;
    let mut x845: fiat_p384_scalar_u1 = 0;
    let (x844, x845) = fiat_p384_scalar_addcarryx_u32(x843, x815, x812);
    let mut x846: u32 = 0;
    let mut x847: fiat_p384_scalar_u1 = 0;
    let (x846, x847) = fiat_p384_scalar_addcarryx_u32(x845, x813, x810);
    let mut x848: u32 = 0;
    let mut x849: fiat_p384_scalar_u1 = 0;
    let (x848, x849) = fiat_p384_scalar_addcarryx_u32(x847, x811, x808);
    let mut x850: u32 = 0;
    let mut x851: fiat_p384_scalar_u1 = 0;
    let (x850, x851) = fiat_p384_scalar_addcarryx_u32(x849, x809, x806);
    let x852: u32 = ((x851 as u32) + x807);
    let mut x853: u32 = 0;
    let mut x854: fiat_p384_scalar_u1 = 0;
    let (x853, x854) = fiat_p384_scalar_addcarryx_u32(0x0, x778, x828);
    let mut x855: u32 = 0;
    let mut x856: fiat_p384_scalar_u1 = 0;
    let (x855, x856) = fiat_p384_scalar_addcarryx_u32(x854, x780, x830);
    let mut x857: u32 = 0;
    let mut x858: fiat_p384_scalar_u1 = 0;
    let (x857, x858) = fiat_p384_scalar_addcarryx_u32(x856, x782, x832);
    let mut x859: u32 = 0;
    let mut x860: fiat_p384_scalar_u1 = 0;
    let (x859, x860) = fiat_p384_scalar_addcarryx_u32(x858, x784, x834);
    let mut x861: u32 = 0;
    let mut x862: fiat_p384_scalar_u1 = 0;
    let (x861, x862) = fiat_p384_scalar_addcarryx_u32(x860, x786, x836);
    let mut x863: u32 = 0;
    let mut x864: fiat_p384_scalar_u1 = 0;
    let (x863, x864) = fiat_p384_scalar_addcarryx_u32(x862, x788, x838);
    let mut x865: u32 = 0;
    let mut x866: fiat_p384_scalar_u1 = 0;
    let (x865, x866) = fiat_p384_scalar_addcarryx_u32(x864, x790, x840);
    let mut x867: u32 = 0;
    let mut x868: fiat_p384_scalar_u1 = 0;
    let (x867, x868) = fiat_p384_scalar_addcarryx_u32(x866, x792, x842);
    let mut x869: u32 = 0;
    let mut x870: fiat_p384_scalar_u1 = 0;
    let (x869, x870) = fiat_p384_scalar_addcarryx_u32(x868, x794, x844);
    let mut x871: u32 = 0;
    let mut x872: fiat_p384_scalar_u1 = 0;
    let (x871, x872) = fiat_p384_scalar_addcarryx_u32(x870, x796, x846);
    let mut x873: u32 = 0;
    let mut x874: fiat_p384_scalar_u1 = 0;
    let (x873, x874) = fiat_p384_scalar_addcarryx_u32(x872, x798, x848);
    let mut x875: u32 = 0;
    let mut x876: fiat_p384_scalar_u1 = 0;
    let (x875, x876) = fiat_p384_scalar_addcarryx_u32(x874, x800, x850);
    let mut x877: u32 = 0;
    let mut x878: fiat_p384_scalar_u1 = 0;
    let (x877, x878) = fiat_p384_scalar_addcarryx_u32(x876, x802, x852);
    let x879: u32 = ((x878 as u32) + (x803 as u32));
    let mut x880: u32 = 0;
    let mut x881: u32 = 0;
    let (x880, x881) = fiat_p384_scalar_mulx_u32(x6, (arg1[11]));
    let mut x882: u32 = 0;
    let mut x883: u32 = 0;
    let (x882, x883) = fiat_p384_scalar_mulx_u32(x6, (arg1[10]));
    let mut x884: u32 = 0;
    let mut x885: u32 = 0;
    let (x884, x885) = fiat_p384_scalar_mulx_u32(x6, (arg1[9]));
    let mut x886: u32 = 0;
    let mut x887: u32 = 0;
    let (x886, x887) = fiat_p384_scalar_mulx_u32(x6, (arg1[8]));
    let mut x888: u32 = 0;
    let mut x889: u32 = 0;
    let (x888, x889) = fiat_p384_scalar_mulx_u32(x6, (arg1[7]));
    let mut x890: u32 = 0;
    let mut x891: u32 = 0;
    let (x890, x891) = fiat_p384_scalar_mulx_u32(x6, (arg1[6]));
    let mut x892: u32 = 0;
    let mut x893: u32 = 0;
    let (x892, x893) = fiat_p384_scalar_mulx_u32(x6, (arg1[5]));
    let mut x894: u32 = 0;
    let mut x895: u32 = 0;
    let (x894, x895) = fiat_p384_scalar_mulx_u32(x6, (arg1[4]));
    let mut x896: u32 = 0;
    let mut x897: u32 = 0;
    let (x896, x897) = fiat_p384_scalar_mulx_u32(x6, (arg1[3]));
    let mut x898: u32 = 0;
    let mut x899: u32 = 0;
    let (x898, x899) = fiat_p384_scalar_mulx_u32(x6, (arg1[2]));
    let mut x900: u32 = 0;
    let mut x901: u32 = 0;
    let (x900, x901) = fiat_p384_scalar_mulx_u32(x6, (arg1[1]));
    let mut x902: u32 = 0;
    let mut x903: u32 = 0;
    let (x902, x903) = fiat_p384_scalar_mulx_u32(x6, (arg1[0]));
    let mut x904: u32 = 0;
    let mut x905: fiat_p384_scalar_u1 = 0;
    let (x904, x905) = fiat_p384_scalar_addcarryx_u32(0x0, x903, x900);
    let mut x906: u32 = 0;
    let mut x907: fiat_p384_scalar_u1 = 0;
    let (x906, x907) = fiat_p384_scalar_addcarryx_u32(x905, x901, x898);
    let mut x908: u32 = 0;
    let mut x909: fiat_p384_scalar_u1 = 0;
    let (x908, x909) = fiat_p384_scalar_addcarryx_u32(x907, x899, x896);
    let mut x910: u32 = 0;
    let mut x911: fiat_p384_scalar_u1 = 0;
    let (x910, x911) = fiat_p384_scalar_addcarryx_u32(x909, x897, x894);
    let mut x912: u32 = 0;
    let mut x913: fiat_p384_scalar_u1 = 0;
    let (x912, x913) = fiat_p384_scalar_addcarryx_u32(x911, x895, x892);
    let mut x914: u32 = 0;
    let mut x915: fiat_p384_scalar_u1 = 0;
    let (x914, x915) = fiat_p384_scalar_addcarryx_u32(x913, x893, x890);
    let mut x916: u32 = 0;
    let mut x917: fiat_p384_scalar_u1 = 0;
    let (x916, x917) = fiat_p384_scalar_addcarryx_u32(x915, x891, x888);
    let mut x918: u32 = 0;
    let mut x919: fiat_p384_scalar_u1 = 0;
    let (x918, x919) = fiat_p384_scalar_addcarryx_u32(x917, x889, x886);
    let mut x920: u32 = 0;
    let mut x921: fiat_p384_scalar_u1 = 0;
    let (x920, x921) = fiat_p384_scalar_addcarryx_u32(x919, x887, x884);
    let mut x922: u32 = 0;
    let mut x923: fiat_p384_scalar_u1 = 0;
    let (x922, x923) = fiat_p384_scalar_addcarryx_u32(x921, x885, x882);
    let mut x924: u32 = 0;
    let mut x925: fiat_p384_scalar_u1 = 0;
    let (x924, x925) = fiat_p384_scalar_addcarryx_u32(x923, x883, x880);
    let x926: u32 = ((x925 as u32) + x881);
    let mut x927: u32 = 0;
    let mut x928: fiat_p384_scalar_u1 = 0;
    let (x927, x928) = fiat_p384_scalar_addcarryx_u32(0x0, x855, x902);
    let mut x929: u32 = 0;
    let mut x930: fiat_p384_scalar_u1 = 0;
    let (x929, x930) = fiat_p384_scalar_addcarryx_u32(x928, x857, x904);
    let mut x931: u32 = 0;
    let mut x932: fiat_p384_scalar_u1 = 0;
    let (x931, x932) = fiat_p384_scalar_addcarryx_u32(x930, x859, x906);
    let mut x933: u32 = 0;
    let mut x934: fiat_p384_scalar_u1 = 0;
    let (x933, x934) = fiat_p384_scalar_addcarryx_u32(x932, x861, x908);
    let mut x935: u32 = 0;
    let mut x936: fiat_p384_scalar_u1 = 0;
    let (x935, x936) = fiat_p384_scalar_addcarryx_u32(x934, x863, x910);
    let mut x937: u32 = 0;
    let mut x938: fiat_p384_scalar_u1 = 0;
    let (x937, x938) = fiat_p384_scalar_addcarryx_u32(x936, x865, x912);
    let mut x939: u32 = 0;
    let mut x940: fiat_p384_scalar_u1 = 0;
    let (x939, x940) = fiat_p384_scalar_addcarryx_u32(x938, x867, x914);
    let mut x941: u32 = 0;
    let mut x942: fiat_p384_scalar_u1 = 0;
    let (x941, x942) = fiat_p384_scalar_addcarryx_u32(x940, x869, x916);
    let mut x943: u32 = 0;
    let mut x944: fiat_p384_scalar_u1 = 0;
    let (x943, x944) = fiat_p384_scalar_addcarryx_u32(x942, x871, x918);
    let mut x945: u32 = 0;
    let mut x946: fiat_p384_scalar_u1 = 0;
    let (x945, x946) = fiat_p384_scalar_addcarryx_u32(x944, x873, x920);
    let mut x947: u32 = 0;
    let mut x948: fiat_p384_scalar_u1 = 0;
    let (x947, x948) = fiat_p384_scalar_addcarryx_u32(x946, x875, x922);
    let mut x949: u32 = 0;
    let mut x950: fiat_p384_scalar_u1 = 0;
    let (x949, x950) = fiat_p384_scalar_addcarryx_u32(x948, x877, x924);
    let mut x951: u32 = 0;
    let mut x952: fiat_p384_scalar_u1 = 0;
    let (x951, x952) = fiat_p384_scalar_addcarryx_u32(x950, x879, x926);
    let mut x953: u32 = 0;
    let mut x954: u32 = 0;
    let (x953, x954) = fiat_p384_scalar_mulx_u32(x927, 0xe88fdc45);
    let mut x955: u32 = 0;
    let mut x956: u32 = 0;
    let (x955, x956) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x957: u32 = 0;
    let mut x958: u32 = 0;
    let (x957, x958) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x959: u32 = 0;
    let mut x960: u32 = 0;
    let (x959, x960) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x961: u32 = 0;
    let mut x962: u32 = 0;
    let (x961, x962) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x963: u32 = 0;
    let mut x964: u32 = 0;
    let (x963, x964) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x965: u32 = 0;
    let mut x966: u32 = 0;
    let (x965, x966) = fiat_p384_scalar_mulx_u32(x953, 0xffffffff);
    let mut x967: u32 = 0;
    let mut x968: u32 = 0;
    let (x967, x968) = fiat_p384_scalar_mulx_u32(x953, 0xc7634d81);
    let mut x969: u32 = 0;
    let mut x970: u32 = 0;
    let (x969, x970) = fiat_p384_scalar_mulx_u32(x953, 0xf4372ddf);
    let mut x971: u32 = 0;
    let mut x972: u32 = 0;
    let (x971, x972) = fiat_p384_scalar_mulx_u32(x953, 0x581a0db2);
    let mut x973: u32 = 0;
    let mut x974: u32 = 0;
    let (x973, x974) = fiat_p384_scalar_mulx_u32(x953, 0x48b0a77a);
    let mut x975: u32 = 0;
    let mut x976: u32 = 0;
    let (x975, x976) = fiat_p384_scalar_mulx_u32(x953, 0xecec196a);
    let mut x977: u32 = 0;
    let mut x978: u32 = 0;
    let (x977, x978) = fiat_p384_scalar_mulx_u32(x953, 0xccc52973);
    let mut x979: u32 = 0;
    let mut x980: fiat_p384_scalar_u1 = 0;
    let (x979, x980) = fiat_p384_scalar_addcarryx_u32(0x0, x978, x975);
    let mut x981: u32 = 0;
    let mut x982: fiat_p384_scalar_u1 = 0;
    let (x981, x982) = fiat_p384_scalar_addcarryx_u32(x980, x976, x973);
    let mut x983: u32 = 0;
    let mut x984: fiat_p384_scalar_u1 = 0;
    let (x983, x984) = fiat_p384_scalar_addcarryx_u32(x982, x974, x971);
    let mut x985: u32 = 0;
    let mut x986: fiat_p384_scalar_u1 = 0;
    let (x985, x986) = fiat_p384_scalar_addcarryx_u32(x984, x972, x969);
    let mut x987: u32 = 0;
    let mut x988: fiat_p384_scalar_u1 = 0;
    let (x987, x988) = fiat_p384_scalar_addcarryx_u32(x986, x970, x967);
    let mut x989: u32 = 0;
    let mut x990: fiat_p384_scalar_u1 = 0;
    let (x989, x990) = fiat_p384_scalar_addcarryx_u32(x988, x968, x965);
    let mut x991: u32 = 0;
    let mut x992: fiat_p384_scalar_u1 = 0;
    let (x991, x992) = fiat_p384_scalar_addcarryx_u32(x990, x966, x963);
    let mut x993: u32 = 0;
    let mut x994: fiat_p384_scalar_u1 = 0;
    let (x993, x994) = fiat_p384_scalar_addcarryx_u32(x992, x964, x961);
    let mut x995: u32 = 0;
    let mut x996: fiat_p384_scalar_u1 = 0;
    let (x995, x996) = fiat_p384_scalar_addcarryx_u32(x994, x962, x959);
    let mut x997: u32 = 0;
    let mut x998: fiat_p384_scalar_u1 = 0;
    let (x997, x998) = fiat_p384_scalar_addcarryx_u32(x996, x960, x957);
    let mut x999: u32 = 0;
    let mut x1000: fiat_p384_scalar_u1 = 0;
    let (x999, x1000) = fiat_p384_scalar_addcarryx_u32(x998, x958, x955);
    let x1001: u32 = ((x1000 as u32) + x956);
    let mut x1002: u32 = 0;
    let mut x1003: fiat_p384_scalar_u1 = 0;
    let (x1002, x1003) = fiat_p384_scalar_addcarryx_u32(0x0, x927, x977);
    let mut x1004: u32 = 0;
    let mut x1005: fiat_p384_scalar_u1 = 0;
    let (x1004, x1005) = fiat_p384_scalar_addcarryx_u32(x1003, x929, x979);
    let mut x1006: u32 = 0;
    let mut x1007: fiat_p384_scalar_u1 = 0;
    let (x1006, x1007) = fiat_p384_scalar_addcarryx_u32(x1005, x931, x981);
    let mut x1008: u32 = 0;
    let mut x1009: fiat_p384_scalar_u1 = 0;
    let (x1008, x1009) = fiat_p384_scalar_addcarryx_u32(x1007, x933, x983);
    let mut x1010: u32 = 0;
    let mut x1011: fiat_p384_scalar_u1 = 0;
    let (x1010, x1011) = fiat_p384_scalar_addcarryx_u32(x1009, x935, x985);
    let mut x1012: u32 = 0;
    let mut x1013: fiat_p384_scalar_u1 = 0;
    let (x1012, x1013) = fiat_p384_scalar_addcarryx_u32(x1011, x937, x987);
    let mut x1014: u32 = 0;
    let mut x1015: fiat_p384_scalar_u1 = 0;
    let (x1014, x1015) = fiat_p384_scalar_addcarryx_u32(x1013, x939, x989);
    let mut x1016: u32 = 0;
    let mut x1017: fiat_p384_scalar_u1 = 0;
    let (x1016, x1017) = fiat_p384_scalar_addcarryx_u32(x1015, x941, x991);
    let mut x1018: u32 = 0;
    let mut x1019: fiat_p384_scalar_u1 = 0;
    let (x1018, x1019) = fiat_p384_scalar_addcarryx_u32(x1017, x943, x993);
    let mut x1020: u32 = 0;
    let mut x1021: fiat_p384_scalar_u1 = 0;
    let (x1020, x1021) = fiat_p384_scalar_addcarryx_u32(x1019, x945, x995);
    let mut x1022: u32 = 0;
    let mut x1023: fiat_p384_scalar_u1 = 0;
    let (x1022, x1023) = fiat_p384_scalar_addcarryx_u32(x1021, x947, x997);
    let mut x1024: u32 = 0;
    let mut x1025: fiat_p384_scalar_u1 = 0;
    let (x1024, x1025) = fiat_p384_scalar_addcarryx_u32(x1023, x949, x999);
    let mut x1026: u32 = 0;
    let mut x1027: fiat_p384_scalar_u1 = 0;
    let (x1026, x1027) = fiat_p384_scalar_addcarryx_u32(x1025, x951, x1001);
    let x1028: u32 = ((x1027 as u32) + (x952 as u32));
    let mut x1029: u32 = 0;
    let mut x1030: u32 = 0;
    let (x1029, x1030) = fiat_p384_scalar_mulx_u32(x7, (arg1[11]));
    let mut x1031: u32 = 0;
    let mut x1032: u32 = 0;
    let (x1031, x1032) = fiat_p384_scalar_mulx_u32(x7, (arg1[10]));
    let mut x1033: u32 = 0;
    let mut x1034: u32 = 0;
    let (x1033, x1034) = fiat_p384_scalar_mulx_u32(x7, (arg1[9]));
    let mut x1035: u32 = 0;
    let mut x1036: u32 = 0;
    let (x1035, x1036) = fiat_p384_scalar_mulx_u32(x7, (arg1[8]));
    let mut x1037: u32 = 0;
    let mut x1038: u32 = 0;
    let (x1037, x1038) = fiat_p384_scalar_mulx_u32(x7, (arg1[7]));
    let mut x1039: u32 = 0;
    let mut x1040: u32 = 0;
    let (x1039, x1040) = fiat_p384_scalar_mulx_u32(x7, (arg1[6]));
    let mut x1041: u32 = 0;
    let mut x1042: u32 = 0;
    let (x1041, x1042) = fiat_p384_scalar_mulx_u32(x7, (arg1[5]));
    let mut x1043: u32 = 0;
    let mut x1044: u32 = 0;
    let (x1043, x1044) = fiat_p384_scalar_mulx_u32(x7, (arg1[4]));
    let mut x1045: u32 = 0;
    let mut x1046: u32 = 0;
    let (x1045, x1046) = fiat_p384_scalar_mulx_u32(x7, (arg1[3]));
    let mut x1047: u32 = 0;
    let mut x1048: u32 = 0;
    let (x1047, x1048) = fiat_p384_scalar_mulx_u32(x7, (arg1[2]));
    let mut x1049: u32 = 0;
    let mut x1050: u32 = 0;
    let (x1049, x1050) = fiat_p384_scalar_mulx_u32(x7, (arg1[1]));
    let mut x1051: u32 = 0;
    let mut x1052: u32 = 0;
    let (x1051, x1052) = fiat_p384_scalar_mulx_u32(x7, (arg1[0]));
    let mut x1053: u32 = 0;
    let mut x1054: fiat_p384_scalar_u1 = 0;
    let (x1053, x1054) = fiat_p384_scalar_addcarryx_u32(0x0, x1052, x1049);
    let mut x1055: u32 = 0;
    let mut x1056: fiat_p384_scalar_u1 = 0;
    let (x1055, x1056) = fiat_p384_scalar_addcarryx_u32(x1054, x1050, x1047);
    let mut x1057: u32 = 0;
    let mut x1058: fiat_p384_scalar_u1 = 0;
    let (x1057, x1058) = fiat_p384_scalar_addcarryx_u32(x1056, x1048, x1045);
    let mut x1059: u32 = 0;
    let mut x1060: fiat_p384_scalar_u1 = 0;
    let (x1059, x1060) = fiat_p384_scalar_addcarryx_u32(x1058, x1046, x1043);
    let mut x1061: u32 = 0;
    let mut x1062: fiat_p384_scalar_u1 = 0;
    let (x1061, x1062) = fiat_p384_scalar_addcarryx_u32(x1060, x1044, x1041);
    let mut x1063: u32 = 0;
    let mut x1064: fiat_p384_scalar_u1 = 0;
    let (x1063, x1064) = fiat_p384_scalar_addcarryx_u32(x1062, x1042, x1039);
    let mut x1065: u32 = 0;
    let mut x1066: fiat_p384_scalar_u1 = 0;
    let (x1065, x1066) = fiat_p384_scalar_addcarryx_u32(x1064, x1040, x1037);
    let mut x1067: u32 = 0;
    let mut x1068: fiat_p384_scalar_u1 = 0;
    let (x1067, x1068) = fiat_p384_scalar_addcarryx_u32(x1066, x1038, x1035);
    let mut x1069: u32 = 0;
    let mut x1070: fiat_p384_scalar_u1 = 0;
    let (x1069, x1070) = fiat_p384_scalar_addcarryx_u32(x1068, x1036, x1033);
    let mut x1071: u32 = 0;
    let mut x1072: fiat_p384_scalar_u1 = 0;
    let (x1071, x1072) = fiat_p384_scalar_addcarryx_u32(x1070, x1034, x1031);
    let mut x1073: u32 = 0;
    let mut x1074: fiat_p384_scalar_u1 = 0;
    let (x1073, x1074) = fiat_p384_scalar_addcarryx_u32(x1072, x1032, x1029);
    let x1075: u32 = ((x1074 as u32) + x1030);
    let mut x1076: u32 = 0;
    let mut x1077: fiat_p384_scalar_u1 = 0;
    let (x1076, x1077) = fiat_p384_scalar_addcarryx_u32(0x0, x1004, x1051);
    let mut x1078: u32 = 0;
    let mut x1079: fiat_p384_scalar_u1 = 0;
    let (x1078, x1079) = fiat_p384_scalar_addcarryx_u32(x1077, x1006, x1053);
    let mut x1080: u32 = 0;
    let mut x1081: fiat_p384_scalar_u1 = 0;
    let (x1080, x1081) = fiat_p384_scalar_addcarryx_u32(x1079, x1008, x1055);
    let mut x1082: u32 = 0;
    let mut x1083: fiat_p384_scalar_u1 = 0;
    let (x1082, x1083) = fiat_p384_scalar_addcarryx_u32(x1081, x1010, x1057);
    let mut x1084: u32 = 0;
    let mut x1085: fiat_p384_scalar_u1 = 0;
    let (x1084, x1085) = fiat_p384_scalar_addcarryx_u32(x1083, x1012, x1059);
    let mut x1086: u32 = 0;
    let mut x1087: fiat_p384_scalar_u1 = 0;
    let (x1086, x1087) = fiat_p384_scalar_addcarryx_u32(x1085, x1014, x1061);
    let mut x1088: u32 = 0;
    let mut x1089: fiat_p384_scalar_u1 = 0;
    let (x1088, x1089) = fiat_p384_scalar_addcarryx_u32(x1087, x1016, x1063);
    let mut x1090: u32 = 0;
    let mut x1091: fiat_p384_scalar_u1 = 0;
    let (x1090, x1091) = fiat_p384_scalar_addcarryx_u32(x1089, x1018, x1065);
    let mut x1092: u32 = 0;
    let mut x1093: fiat_p384_scalar_u1 = 0;
    let (x1092, x1093) = fiat_p384_scalar_addcarryx_u32(x1091, x1020, x1067);
    let mut x1094: u32 = 0;
    let mut x1095: fiat_p384_scalar_u1 = 0;
    let (x1094, x1095) = fiat_p384_scalar_addcarryx_u32(x1093, x1022, x1069);
    let mut x1096: u32 = 0;
    let mut x1097: fiat_p384_scalar_u1 = 0;
    let (x1096, x1097) = fiat_p384_scalar_addcarryx_u32(x1095, x1024, x1071);
    let mut x1098: u32 = 0;
    let mut x1099: fiat_p384_scalar_u1 = 0;
    let (x1098, x1099) = fiat_p384_scalar_addcarryx_u32(x1097, x1026, x1073);
    let mut x1100: u32 = 0;
    let mut x1101: fiat_p384_scalar_u1 = 0;
    let (x1100, x1101) = fiat_p384_scalar_addcarryx_u32(x1099, x1028, x1075);
    let mut x1102: u32 = 0;
    let mut x1103: u32 = 0;
    let (x1102, x1103) = fiat_p384_scalar_mulx_u32(x1076, 0xe88fdc45);
    let mut x1104: u32 = 0;
    let mut x1105: u32 = 0;
    let (x1104, x1105) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1106: u32 = 0;
    let mut x1107: u32 = 0;
    let (x1106, x1107) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1108: u32 = 0;
    let mut x1109: u32 = 0;
    let (x1108, x1109) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1110: u32 = 0;
    let mut x1111: u32 = 0;
    let (x1110, x1111) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1112: u32 = 0;
    let mut x1113: u32 = 0;
    let (x1112, x1113) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1114: u32 = 0;
    let mut x1115: u32 = 0;
    let (x1114, x1115) = fiat_p384_scalar_mulx_u32(x1102, 0xffffffff);
    let mut x1116: u32 = 0;
    let mut x1117: u32 = 0;
    let (x1116, x1117) = fiat_p384_scalar_mulx_u32(x1102, 0xc7634d81);
    let mut x1118: u32 = 0;
    let mut x1119: u32 = 0;
    let (x1118, x1119) = fiat_p384_scalar_mulx_u32(x1102, 0xf4372ddf);
    let mut x1120: u32 = 0;
    let mut x1121: u32 = 0;
    let (x1120, x1121) = fiat_p384_scalar_mulx_u32(x1102, 0x581a0db2);
    let mut x1122: u32 = 0;
    let mut x1123: u32 = 0;
    let (x1122, x1123) = fiat_p384_scalar_mulx_u32(x1102, 0x48b0a77a);
    let mut x1124: u32 = 0;
    let mut x1125: u32 = 0;
    let (x1124, x1125) = fiat_p384_scalar_mulx_u32(x1102, 0xecec196a);
    let mut x1126: u32 = 0;
    let mut x1127: u32 = 0;
    let (x1126, x1127) = fiat_p384_scalar_mulx_u32(x1102, 0xccc52973);
    let mut x1128: u32 = 0;
    let mut x1129: fiat_p384_scalar_u1 = 0;
    let (x1128, x1129) = fiat_p384_scalar_addcarryx_u32(0x0, x1127, x1124);
    let mut x1130: u32 = 0;
    let mut x1131: fiat_p384_scalar_u1 = 0;
    let (x1130, x1131) = fiat_p384_scalar_addcarryx_u32(x1129, x1125, x1122);
    let mut x1132: u32 = 0;
    let mut x1133: fiat_p384_scalar_u1 = 0;
    let (x1132, x1133) = fiat_p384_scalar_addcarryx_u32(x1131, x1123, x1120);
    let mut x1134: u32 = 0;
    let mut x1135: fiat_p384_scalar_u1 = 0;
    let (x1134, x1135) = fiat_p384_scalar_addcarryx_u32(x1133, x1121, x1118);
    let mut x1136: u32 = 0;
    let mut x1137: fiat_p384_scalar_u1 = 0;
    let (x1136, x1137) = fiat_p384_scalar_addcarryx_u32(x1135, x1119, x1116);
    let mut x1138: u32 = 0;
    let mut x1139: fiat_p384_scalar_u1 = 0;
    let (x1138, x1139) = fiat_p384_scalar_addcarryx_u32(x1137, x1117, x1114);
    let mut x1140: u32 = 0;
    let mut x1141: fiat_p384_scalar_u1 = 0;
    let (x1140, x1141) = fiat_p384_scalar_addcarryx_u32(x1139, x1115, x1112);
    let mut x1142: u32 = 0;
    let mut x1143: fiat_p384_scalar_u1 = 0;
    let (x1142, x1143) = fiat_p384_scalar_addcarryx_u32(x1141, x1113, x1110);
    let mut x1144: u32 = 0;
    let mut x1145: fiat_p384_scalar_u1 = 0;
    let (x1144, x1145) = fiat_p384_scalar_addcarryx_u32(x1143, x1111, x1108);
    let mut x1146: u32 = 0;
    let mut x1147: fiat_p384_scalar_u1 = 0;
    let (x1146, x1147) = fiat_p384_scalar_addcarryx_u32(x1145, x1109, x1106);
    let mut x1148: u32 = 0;
    let mut x1149: fiat_p384_scalar_u1 = 0;
    let (x1148, x1149) = fiat_p384_scalar_addcarryx_u32(x1147, x1107, x1104);
    let x1150: u32 = ((x1149 as u32) + x1105);
    let mut x1151: u32 = 0;
    let mut x1152: fiat_p384_scalar_u1 = 0;
    let (x1151, x1152) = fiat_p384_scalar_addcarryx_u32(0x0, x1076, x1126);
    let mut x1153: u32 = 0;
    let mut x1154: fiat_p384_scalar_u1 = 0;
    let (x1153, x1154) = fiat_p384_scalar_addcarryx_u32(x1152, x1078, x1128);
    let mut x1155: u32 = 0;
    let mut x1156: fiat_p384_scalar_u1 = 0;
    let (x1155, x1156) = fiat_p384_scalar_addcarryx_u32(x1154, x1080, x1130);
    let mut x1157: u32 = 0;
    let mut x1158: fiat_p384_scalar_u1 = 0;
    let (x1157, x1158) = fiat_p384_scalar_addcarryx_u32(x1156, x1082, x1132);
    let mut x1159: u32 = 0;
    let mut x1160: fiat_p384_scalar_u1 = 0;
    let (x1159, x1160) = fiat_p384_scalar_addcarryx_u32(x1158, x1084, x1134);
    let mut x1161: u32 = 0;
    let mut x1162: fiat_p384_scalar_u1 = 0;
    let (x1161, x1162) = fiat_p384_scalar_addcarryx_u32(x1160, x1086, x1136);
    let mut x1163: u32 = 0;
    let mut x1164: fiat_p384_scalar_u1 = 0;
    let (x1163, x1164) = fiat_p384_scalar_addcarryx_u32(x1162, x1088, x1138);
    let mut x1165: u32 = 0;
    let mut x1166: fiat_p384_scalar_u1 = 0;
    let (x1165, x1166) = fiat_p384_scalar_addcarryx_u32(x1164, x1090, x1140);
    let mut x1167: u32 = 0;
    let mut x1168: fiat_p384_scalar_u1 = 0;
    let (x1167, x1168) = fiat_p384_scalar_addcarryx_u32(x1166, x1092, x1142);
    let mut x1169: u32 = 0;
    let mut x1170: fiat_p384_scalar_u1 = 0;
    let (x1169, x1170) = fiat_p384_scalar_addcarryx_u32(x1168, x1094, x1144);
    let mut x1171: u32 = 0;
    let mut x1172: fiat_p384_scalar_u1 = 0;
    let (x1171, x1172) = fiat_p384_scalar_addcarryx_u32(x1170, x1096, x1146);
    let mut x1173: u32 = 0;
    let mut x1174: fiat_p384_scalar_u1 = 0;
    let (x1173, x1174) = fiat_p384_scalar_addcarryx_u32(x1172, x1098, x1148);
    let mut x1175: u32 = 0;
    let mut x1176: fiat_p384_scalar_u1 = 0;
    let (x1175, x1176) = fiat_p384_scalar_addcarryx_u32(x1174, x1100, x1150);
    let x1177: u32 = ((x1176 as u32) + (x1101 as u32));
    let mut x1178: u32 = 0;
    let mut x1179: u32 = 0;
    let (x1178, x1179) = fiat_p384_scalar_mulx_u32(x8, (arg1[11]));
    let mut x1180: u32 = 0;
    let mut x1181: u32 = 0;
    let (x1180, x1181) = fiat_p384_scalar_mulx_u32(x8, (arg1[10]));
    let mut x1182: u32 = 0;
    let mut x1183: u32 = 0;
    let (x1182, x1183) = fiat_p384_scalar_mulx_u32(x8, (arg1[9]));
    let mut x1184: u32 = 0;
    let mut x1185: u32 = 0;
    let (x1184, x1185) = fiat_p384_scalar_mulx_u32(x8, (arg1[8]));
    let mut x1186: u32 = 0;
    let mut x1187: u32 = 0;
    let (x1186, x1187) = fiat_p384_scalar_mulx_u32(x8, (arg1[7]));
    let mut x1188: u32 = 0;
    let mut x1189: u32 = 0;
    let (x1188, x1189) = fiat_p384_scalar_mulx_u32(x8, (arg1[6]));
    let mut x1190: u32 = 0;
    let mut x1191: u32 = 0;
    let (x1190, x1191) = fiat_p384_scalar_mulx_u32(x8, (arg1[5]));
    let mut x1192: u32 = 0;
    let mut x1193: u32 = 0;
    let (x1192, x1193) = fiat_p384_scalar_mulx_u32(x8, (arg1[4]));
    let mut x1194: u32 = 0;
    let mut x1195: u32 = 0;
    let (x1194, x1195) = fiat_p384_scalar_mulx_u32(x8, (arg1[3]));
    let mut x1196: u32 = 0;
    let mut x1197: u32 = 0;
    let (x1196, x1197) = fiat_p384_scalar_mulx_u32(x8, (arg1[2]));
    let mut x1198: u32 = 0;
    let mut x1199: u32 = 0;
    let (x1198, x1199) = fiat_p384_scalar_mulx_u32(x8, (arg1[1]));
    let mut x1200: u32 = 0;
    let mut x1201: u32 = 0;
    let (x1200, x1201) = fiat_p384_scalar_mulx_u32(x8, (arg1[0]));
    let mut x1202: u32 = 0;
    let mut x1203: fiat_p384_scalar_u1 = 0;
    let (x1202, x1203) = fiat_p384_scalar_addcarryx_u32(0x0, x1201, x1198);
    let mut x1204: u32 = 0;
    let mut x1205: fiat_p384_scalar_u1 = 0;
    let (x1204, x1205) = fiat_p384_scalar_addcarryx_u32(x1203, x1199, x1196);
    let mut x1206: u32 = 0;
    let mut x1207: fiat_p384_scalar_u1 = 0;
    let (x1206, x1207) = fiat_p384_scalar_addcarryx_u32(x1205, x1197, x1194);
    let mut x1208: u32 = 0;
    let mut x1209: fiat_p384_scalar_u1 = 0;
    let (x1208, x1209) = fiat_p384_scalar_addcarryx_u32(x1207, x1195, x1192);
    let mut x1210: u32 = 0;
    let mut x1211: fiat_p384_scalar_u1 = 0;
    let (x1210, x1211) = fiat_p384_scalar_addcarryx_u32(x1209, x1193, x1190);
    let mut x1212: u32 = 0;
    let mut x1213: fiat_p384_scalar_u1 = 0;
    let (x1212, x1213) = fiat_p384_scalar_addcarryx_u32(x1211, x1191, x1188);
    let mut x1214: u32 = 0;
    let mut x1215: fiat_p384_scalar_u1 = 0;
    let (x1214, x1215) = fiat_p384_scalar_addcarryx_u32(x1213, x1189, x1186);
    let mut x1216: u32 = 0;
    let mut x1217: fiat_p384_scalar_u1 = 0;
    let (x1216, x1217) = fiat_p384_scalar_addcarryx_u32(x1215, x1187, x1184);
    let mut x1218: u32 = 0;
    let mut x1219: fiat_p384_scalar_u1 = 0;
    let (x1218, x1219) = fiat_p384_scalar_addcarryx_u32(x1217, x1185, x1182);
    let mut x1220: u32 = 0;
    let mut x1221: fiat_p384_scalar_u1 = 0;
    let (x1220, x1221) = fiat_p384_scalar_addcarryx_u32(x1219, x1183, x1180);
    let mut x1222: u32 = 0;
    let mut x1223: fiat_p384_scalar_u1 = 0;
    let (x1222, x1223) = fiat_p384_scalar_addcarryx_u32(x1221, x1181, x1178);
    let x1224: u32 = ((x1223 as u32) + x1179);
    let mut x1225: u32 = 0;
    let mut x1226: fiat_p384_scalar_u1 = 0;
    let (x1225, x1226) = fiat_p384_scalar_addcarryx_u32(0x0, x1153, x1200);
    let mut x1227: u32 = 0;
    let mut x1228: fiat_p384_scalar_u1 = 0;
    let (x1227, x1228) = fiat_p384_scalar_addcarryx_u32(x1226, x1155, x1202);
    let mut x1229: u32 = 0;
    let mut x1230: fiat_p384_scalar_u1 = 0;
    let (x1229, x1230) = fiat_p384_scalar_addcarryx_u32(x1228, x1157, x1204);
    let mut x1231: u32 = 0;
    let mut x1232: fiat_p384_scalar_u1 = 0;
    let (x1231, x1232) = fiat_p384_scalar_addcarryx_u32(x1230, x1159, x1206);
    let mut x1233: u32 = 0;
    let mut x1234: fiat_p384_scalar_u1 = 0;
    let (x1233, x1234) = fiat_p384_scalar_addcarryx_u32(x1232, x1161, x1208);
    let mut x1235: u32 = 0;
    let mut x1236: fiat_p384_scalar_u1 = 0;
    let (x1235, x1236) = fiat_p384_scalar_addcarryx_u32(x1234, x1163, x1210);
    let mut x1237: u32 = 0;
    let mut x1238: fiat_p384_scalar_u1 = 0;
    let (x1237, x1238) = fiat_p384_scalar_addcarryx_u32(x1236, x1165, x1212);
    let mut x1239: u32 = 0;
    let mut x1240: fiat_p384_scalar_u1 = 0;
    let (x1239, x1240) = fiat_p384_scalar_addcarryx_u32(x1238, x1167, x1214);
    let mut x1241: u32 = 0;
    let mut x1242: fiat_p384_scalar_u1 = 0;
    let (x1241, x1242) = fiat_p384_scalar_addcarryx_u32(x1240, x1169, x1216);
    let mut x1243: u32 = 0;
    let mut x1244: fiat_p384_scalar_u1 = 0;
    let (x1243, x1244) = fiat_p384_scalar_addcarryx_u32(x1242, x1171, x1218);
    let mut x1245: u32 = 0;
    let mut x1246: fiat_p384_scalar_u1 = 0;
    let (x1245, x1246) = fiat_p384_scalar_addcarryx_u32(x1244, x1173, x1220);
    let mut x1247: u32 = 0;
    let mut x1248: fiat_p384_scalar_u1 = 0;
    let (x1247, x1248) = fiat_p384_scalar_addcarryx_u32(x1246, x1175, x1222);
    let mut x1249: u32 = 0;
    let mut x1250: fiat_p384_scalar_u1 = 0;
    let (x1249, x1250) = fiat_p384_scalar_addcarryx_u32(x1248, x1177, x1224);
    let mut x1251: u32 = 0;
    let mut x1252: u32 = 0;
    let (x1251, x1252) = fiat_p384_scalar_mulx_u32(x1225, 0xe88fdc45);
    let mut x1253: u32 = 0;
    let mut x1254: u32 = 0;
    let (x1253, x1254) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1255: u32 = 0;
    let mut x1256: u32 = 0;
    let (x1255, x1256) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1257: u32 = 0;
    let mut x1258: u32 = 0;
    let (x1257, x1258) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1259: u32 = 0;
    let mut x1260: u32 = 0;
    let (x1259, x1260) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1261: u32 = 0;
    let mut x1262: u32 = 0;
    let (x1261, x1262) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1263: u32 = 0;
    let mut x1264: u32 = 0;
    let (x1263, x1264) = fiat_p384_scalar_mulx_u32(x1251, 0xffffffff);
    let mut x1265: u32 = 0;
    let mut x1266: u32 = 0;
    let (x1265, x1266) = fiat_p384_scalar_mulx_u32(x1251, 0xc7634d81);
    let mut x1267: u32 = 0;
    let mut x1268: u32 = 0;
    let (x1267, x1268) = fiat_p384_scalar_mulx_u32(x1251, 0xf4372ddf);
    let mut x1269: u32 = 0;
    let mut x1270: u32 = 0;
    let (x1269, x1270) = fiat_p384_scalar_mulx_u32(x1251, 0x581a0db2);
    let mut x1271: u32 = 0;
    let mut x1272: u32 = 0;
    let (x1271, x1272) = fiat_p384_scalar_mulx_u32(x1251, 0x48b0a77a);
    let mut x1273: u32 = 0;
    let mut x1274: u32 = 0;
    let (x1273, x1274) = fiat_p384_scalar_mulx_u32(x1251, 0xecec196a);
    let mut x1275: u32 = 0;
    let mut x1276: u32 = 0;
    let (x1275, x1276) = fiat_p384_scalar_mulx_u32(x1251, 0xccc52973);
    let mut x1277: u32 = 0;
    let mut x1278: fiat_p384_scalar_u1 = 0;
    let (x1277, x1278) = fiat_p384_scalar_addcarryx_u32(0x0, x1276, x1273);
    let mut x1279: u32 = 0;
    let mut x1280: fiat_p384_scalar_u1 = 0;
    let (x1279, x1280) = fiat_p384_scalar_addcarryx_u32(x1278, x1274, x1271);
    let mut x1281: u32 = 0;
    let mut x1282: fiat_p384_scalar_u1 = 0;
    let (x1281, x1282) = fiat_p384_scalar_addcarryx_u32(x1280, x1272, x1269);
    let mut x1283: u32 = 0;
    let mut x1284: fiat_p384_scalar_u1 = 0;
    let (x1283, x1284) = fiat_p384_scalar_addcarryx_u32(x1282, x1270, x1267);
    let mut x1285: u32 = 0;
    let mut x1286: fiat_p384_scalar_u1 = 0;
    let (x1285, x1286) = fiat_p384_scalar_addcarryx_u32(x1284, x1268, x1265);
    let mut x1287: u32 = 0;
    let mut x1288: fiat_p384_scalar_u1 = 0;
    let (x1287, x1288) = fiat_p384_scalar_addcarryx_u32(x1286, x1266, x1263);
    let mut x1289: u32 = 0;
    let mut x1290: fiat_p384_scalar_u1 = 0;
    let (x1289, x1290) = fiat_p384_scalar_addcarryx_u32(x1288, x1264, x1261);
    let mut x1291: u32 = 0;
    let mut x1292: fiat_p384_scalar_u1 = 0;
    let (x1291, x1292) = fiat_p384_scalar_addcarryx_u32(x1290, x1262, x1259);
    let mut x1293: u32 = 0;
    let mut x1294: fiat_p384_scalar_u1 = 0;
    let (x1293, x1294) = fiat_p384_scalar_addcarryx_u32(x1292, x1260, x1257);
    let mut x1295: u32 = 0;
    let mut x1296: fiat_p384_scalar_u1 = 0;
    let (x1295, x1296) = fiat_p384_scalar_addcarryx_u32(x1294, x1258, x1255);
    let mut x1297: u32 = 0;
    let mut x1298: fiat_p384_scalar_u1 = 0;
    let (x1297, x1298) = fiat_p384_scalar_addcarryx_u32(x1296, x1256, x1253);
    let x1299: u32 = ((x1298 as u32) + x1254);
    let mut x1300: u32 = 0;
    let mut x1301: fiat_p384_scalar_u1 = 0;
    let (x1300, x1301) = fiat_p384_scalar_addcarryx_u32(0x0, x1225, x1275);
    let mut x1302: u32 = 0;
    let mut x1303: fiat_p384_scalar_u1 = 0;
    let (x1302, x1303) = fiat_p384_scalar_addcarryx_u32(x1301, x1227, x1277);
    let mut x1304: u32 = 0;
    let mut x1305: fiat_p384_scalar_u1 = 0;
    let (x1304, x1305) = fiat_p384_scalar_addcarryx_u32(x1303, x1229, x1279);
    let mut x1306: u32 = 0;
    let mut x1307: fiat_p384_scalar_u1 = 0;
    let (x1306, x1307) = fiat_p384_scalar_addcarryx_u32(x1305, x1231, x1281);
    let mut x1308: u32 = 0;
    let mut x1309: fiat_p384_scalar_u1 = 0;
    let (x1308, x1309) = fiat_p384_scalar_addcarryx_u32(x1307, x1233, x1283);
    let mut x1310: u32 = 0;
    let mut x1311: fiat_p384_scalar_u1 = 0;
    let (x1310, x1311) = fiat_p384_scalar_addcarryx_u32(x1309, x1235, x1285);
    let mut x1312: u32 = 0;
    let mut x1313: fiat_p384_scalar_u1 = 0;
    let (x1312, x1313) = fiat_p384_scalar_addcarryx_u32(x1311, x1237, x1287);
    let mut x1314: u32 = 0;
    let mut x1315: fiat_p384_scalar_u1 = 0;
    let (x1314, x1315) = fiat_p384_scalar_addcarryx_u32(x1313, x1239, x1289);
    let mut x1316: u32 = 0;
    let mut x1317: fiat_p384_scalar_u1 = 0;
    let (x1316, x1317) = fiat_p384_scalar_addcarryx_u32(x1315, x1241, x1291);
    let mut x1318: u32 = 0;
    let mut x1319: fiat_p384_scalar_u1 = 0;
    let (x1318, x1319) = fiat_p384_scalar_addcarryx_u32(x1317, x1243, x1293);
    let mut x1320: u32 = 0;
    let mut x1321: fiat_p384_scalar_u1 = 0;
    let (x1320, x1321) = fiat_p384_scalar_addcarryx_u32(x1319, x1245, x1295);
    let mut x1322: u32 = 0;
    let mut x1323: fiat_p384_scalar_u1 = 0;
    let (x1322, x1323) = fiat_p384_scalar_addcarryx_u32(x1321, x1247, x1297);
    let mut x1324: u32 = 0;
    let mut x1325: fiat_p384_scalar_u1 = 0;
    let (x1324, x1325) = fiat_p384_scalar_addcarryx_u32(x1323, x1249, x1299);
    let x1326: u32 = ((x1325 as u32) + (x1250 as u32));
    let mut x1327: u32 = 0;
    let mut x1328: u32 = 0;
    let (x1327, x1328) = fiat_p384_scalar_mulx_u32(x9, (arg1[11]));
    let mut x1329: u32 = 0;
    let mut x1330: u32 = 0;
    let (x1329, x1330) = fiat_p384_scalar_mulx_u32(x9, (arg1[10]));
    let mut x1331: u32 = 0;
    let mut x1332: u32 = 0;
    let (x1331, x1332) = fiat_p384_scalar_mulx_u32(x9, (arg1[9]));
    let mut x1333: u32 = 0;
    let mut x1334: u32 = 0;
    let (x1333, x1334) = fiat_p384_scalar_mulx_u32(x9, (arg1[8]));
    let mut x1335: u32 = 0;
    let mut x1336: u32 = 0;
    let (x1335, x1336) = fiat_p384_scalar_mulx_u32(x9, (arg1[7]));
    let mut x1337: u32 = 0;
    let mut x1338: u32 = 0;
    let (x1337, x1338) = fiat_p384_scalar_mulx_u32(x9, (arg1[6]));
    let mut x1339: u32 = 0;
    let mut x1340: u32 = 0;
    let (x1339, x1340) = fiat_p384_scalar_mulx_u32(x9, (arg1[5]));
    let mut x1341: u32 = 0;
    let mut x1342: u32 = 0;
    let (x1341, x1342) = fiat_p384_scalar_mulx_u32(x9, (arg1[4]));
    let mut x1343: u32 = 0;
    let mut x1344: u32 = 0;
    let (x1343, x1344) = fiat_p384_scalar_mulx_u32(x9, (arg1[3]));
    let mut x1345: u32 = 0;
    let mut x1346: u32 = 0;
    let (x1345, x1346) = fiat_p384_scalar_mulx_u32(x9, (arg1[2]));
    let mut x1347: u32 = 0;
    let mut x1348: u32 = 0;
    let (x1347, x1348) = fiat_p384_scalar_mulx_u32(x9, (arg1[1]));
    let mut x1349: u32 = 0;
    let mut x1350: u32 = 0;
    let (x1349, x1350) = fiat_p384_scalar_mulx_u32(x9, (arg1[0]));
    let mut x1351: u32 = 0;
    let mut x1352: fiat_p384_scalar_u1 = 0;
    let (x1351, x1352) = fiat_p384_scalar_addcarryx_u32(0x0, x1350, x1347);
    let mut x1353: u32 = 0;
    let mut x1354: fiat_p384_scalar_u1 = 0;
    let (x1353, x1354) = fiat_p384_scalar_addcarryx_u32(x1352, x1348, x1345);
    let mut x1355: u32 = 0;
    let mut x1356: fiat_p384_scalar_u1 = 0;
    let (x1355, x1356) = fiat_p384_scalar_addcarryx_u32(x1354, x1346, x1343);
    let mut x1357: u32 = 0;
    let mut x1358: fiat_p384_scalar_u1 = 0;
    let (x1357, x1358) = fiat_p384_scalar_addcarryx_u32(x1356, x1344, x1341);
    let mut x1359: u32 = 0;
    let mut x1360: fiat_p384_scalar_u1 = 0;
    let (x1359, x1360) = fiat_p384_scalar_addcarryx_u32(x1358, x1342, x1339);
    let mut x1361: u32 = 0;
    let mut x1362: fiat_p384_scalar_u1 = 0;
    let (x1361, x1362) = fiat_p384_scalar_addcarryx_u32(x1360, x1340, x1337);
    let mut x1363: u32 = 0;
    let mut x1364: fiat_p384_scalar_u1 = 0;
    let (x1363, x1364) = fiat_p384_scalar_addcarryx_u32(x1362, x1338, x1335);
    let mut x1365: u32 = 0;
    let mut x1366: fiat_p384_scalar_u1 = 0;
    let (x1365, x1366) = fiat_p384_scalar_addcarryx_u32(x1364, x1336, x1333);
    let mut x1367: u32 = 0;
    let mut x1368: fiat_p384_scalar_u1 = 0;
    let (x1367, x1368) = fiat_p384_scalar_addcarryx_u32(x1366, x1334, x1331);
    let mut x1369: u32 = 0;
    let mut x1370: fiat_p384_scalar_u1 = 0;
    let (x1369, x1370) = fiat_p384_scalar_addcarryx_u32(x1368, x1332, x1329);
    let mut x1371: u32 = 0;
    let mut x1372: fiat_p384_scalar_u1 = 0;
    let (x1371, x1372) = fiat_p384_scalar_addcarryx_u32(x1370, x1330, x1327);
    let x1373: u32 = ((x1372 as u32) + x1328);
    let mut x1374: u32 = 0;
    let mut x1375: fiat_p384_scalar_u1 = 0;
    let (x1374, x1375) = fiat_p384_scalar_addcarryx_u32(0x0, x1302, x1349);
    let mut x1376: u32 = 0;
    let mut x1377: fiat_p384_scalar_u1 = 0;
    let (x1376, x1377) = fiat_p384_scalar_addcarryx_u32(x1375, x1304, x1351);
    let mut x1378: u32 = 0;
    let mut x1379: fiat_p384_scalar_u1 = 0;
    let (x1378, x1379) = fiat_p384_scalar_addcarryx_u32(x1377, x1306, x1353);
    let mut x1380: u32 = 0;
    let mut x1381: fiat_p384_scalar_u1 = 0;
    let (x1380, x1381) = fiat_p384_scalar_addcarryx_u32(x1379, x1308, x1355);
    let mut x1382: u32 = 0;
    let mut x1383: fiat_p384_scalar_u1 = 0;
    let (x1382, x1383) = fiat_p384_scalar_addcarryx_u32(x1381, x1310, x1357);
    let mut x1384: u32 = 0;
    let mut x1385: fiat_p384_scalar_u1 = 0;
    let (x1384, x1385) = fiat_p384_scalar_addcarryx_u32(x1383, x1312, x1359);
    let mut x1386: u32 = 0;
    let mut x1387: fiat_p384_scalar_u1 = 0;
    let (x1386, x1387) = fiat_p384_scalar_addcarryx_u32(x1385, x1314, x1361);
    let mut x1388: u32 = 0;
    let mut x1389: fiat_p384_scalar_u1 = 0;
    let (x1388, x1389) = fiat_p384_scalar_addcarryx_u32(x1387, x1316, x1363);
    let mut x1390: u32 = 0;
    let mut x1391: fiat_p384_scalar_u1 = 0;
    let (x1390, x1391) = fiat_p384_scalar_addcarryx_u32(x1389, x1318, x1365);
    let mut x1392: u32 = 0;
    let mut x1393: fiat_p384_scalar_u1 = 0;
    let (x1392, x1393) = fiat_p384_scalar_addcarryx_u32(x1391, x1320, x1367);
    let mut x1394: u32 = 0;
    let mut x1395: fiat_p384_scalar_u1 = 0;
    let (x1394, x1395) = fiat_p384_scalar_addcarryx_u32(x1393, x1322, x1369);
    let mut x1396: u32 = 0;
    let mut x1397: fiat_p384_scalar_u1 = 0;
    let (x1396, x1397) = fiat_p384_scalar_addcarryx_u32(x1395, x1324, x1371);
    let mut x1398: u32 = 0;
    let mut x1399: fiat_p384_scalar_u1 = 0;
    let (x1398, x1399) = fiat_p384_scalar_addcarryx_u32(x1397, x1326, x1373);
    let mut x1400: u32 = 0;
    let mut x1401: u32 = 0;
    let (x1400, x1401) = fiat_p384_scalar_mulx_u32(x1374, 0xe88fdc45);
    let mut x1402: u32 = 0;
    let mut x1403: u32 = 0;
    let (x1402, x1403) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1404: u32 = 0;
    let mut x1405: u32 = 0;
    let (x1404, x1405) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1406: u32 = 0;
    let mut x1407: u32 = 0;
    let (x1406, x1407) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1408: u32 = 0;
    let mut x1409: u32 = 0;
    let (x1408, x1409) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1410: u32 = 0;
    let mut x1411: u32 = 0;
    let (x1410, x1411) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1412: u32 = 0;
    let mut x1413: u32 = 0;
    let (x1412, x1413) = fiat_p384_scalar_mulx_u32(x1400, 0xffffffff);
    let mut x1414: u32 = 0;
    let mut x1415: u32 = 0;
    let (x1414, x1415) = fiat_p384_scalar_mulx_u32(x1400, 0xc7634d81);
    let mut x1416: u32 = 0;
    let mut x1417: u32 = 0;
    let (x1416, x1417) = fiat_p384_scalar_mulx_u32(x1400, 0xf4372ddf);
    let mut x1418: u32 = 0;
    let mut x1419: u32 = 0;
    let (x1418, x1419) = fiat_p384_scalar_mulx_u32(x1400, 0x581a0db2);
    let mut x1420: u32 = 0;
    let mut x1421: u32 = 0;
    let (x1420, x1421) = fiat_p384_scalar_mulx_u32(x1400, 0x48b0a77a);
    let mut x1422: u32 = 0;
    let mut x1423: u32 = 0;
    let (x1422, x1423) = fiat_p384_scalar_mulx_u32(x1400, 0xecec196a);
    let mut x1424: u32 = 0;
    let mut x1425: u32 = 0;
    let (x1424, x1425) = fiat_p384_scalar_mulx_u32(x1400, 0xccc52973);
    let mut x1426: u32 = 0;
    let mut x1427: fiat_p384_scalar_u1 = 0;
    let (x1426, x1427) = fiat_p384_scalar_addcarryx_u32(0x0, x1425, x1422);
    let mut x1428: u32 = 0;
    let mut x1429: fiat_p384_scalar_u1 = 0;
    let (x1428, x1429) = fiat_p384_scalar_addcarryx_u32(x1427, x1423, x1420);
    let mut x1430: u32 = 0;
    let mut x1431: fiat_p384_scalar_u1 = 0;
    let (x1430, x1431) = fiat_p384_scalar_addcarryx_u32(x1429, x1421, x1418);
    let mut x1432: u32 = 0;
    let mut x1433: fiat_p384_scalar_u1 = 0;
    let (x1432, x1433) = fiat_p384_scalar_addcarryx_u32(x1431, x1419, x1416);
    let mut x1434: u32 = 0;
    let mut x1435: fiat_p384_scalar_u1 = 0;
    let (x1434, x1435) = fiat_p384_scalar_addcarryx_u32(x1433, x1417, x1414);
    let mut x1436: u32 = 0;
    let mut x1437: fiat_p384_scalar_u1 = 0;
    let (x1436, x1437) = fiat_p384_scalar_addcarryx_u32(x1435, x1415, x1412);
    let mut x1438: u32 = 0;
    let mut x1439: fiat_p384_scalar_u1 = 0;
    let (x1438, x1439) = fiat_p384_scalar_addcarryx_u32(x1437, x1413, x1410);
    let mut x1440: u32 = 0;
    let mut x1441: fiat_p384_scalar_u1 = 0;
    let (x1440, x1441) = fiat_p384_scalar_addcarryx_u32(x1439, x1411, x1408);
    let mut x1442: u32 = 0;
    let mut x1443: fiat_p384_scalar_u1 = 0;
    let (x1442, x1443) = fiat_p384_scalar_addcarryx_u32(x1441, x1409, x1406);
    let mut x1444: u32 = 0;
    let mut x1445: fiat_p384_scalar_u1 = 0;
    let (x1444, x1445) = fiat_p384_scalar_addcarryx_u32(x1443, x1407, x1404);
    let mut x1446: u32 = 0;
    let mut x1447: fiat_p384_scalar_u1 = 0;
    let (x1446, x1447) = fiat_p384_scalar_addcarryx_u32(x1445, x1405, x1402);
    let x1448: u32 = ((x1447 as u32) + x1403);
    let mut x1449: u32 = 0;
    let mut x1450: fiat_p384_scalar_u1 = 0;
    let (x1449, x1450) = fiat_p384_scalar_addcarryx_u32(0x0, x1374, x1424);
    let mut x1451: u32 = 0;
    let mut x1452: fiat_p384_scalar_u1 = 0;
    let (x1451, x1452) = fiat_p384_scalar_addcarryx_u32(x1450, x1376, x1426);
    let mut x1453: u32 = 0;
    let mut x1454: fiat_p384_scalar_u1 = 0;
    let (x1453, x1454) = fiat_p384_scalar_addcarryx_u32(x1452, x1378, x1428);
    let mut x1455: u32 = 0;
    let mut x1456: fiat_p384_scalar_u1 = 0;
    let (x1455, x1456) = fiat_p384_scalar_addcarryx_u32(x1454, x1380, x1430);
    let mut x1457: u32 = 0;
    let mut x1458: fiat_p384_scalar_u1 = 0;
    let (x1457, x1458) = fiat_p384_scalar_addcarryx_u32(x1456, x1382, x1432);
    let mut x1459: u32 = 0;
    let mut x1460: fiat_p384_scalar_u1 = 0;
    let (x1459, x1460) = fiat_p384_scalar_addcarryx_u32(x1458, x1384, x1434);
    let mut x1461: u32 = 0;
    let mut x1462: fiat_p384_scalar_u1 = 0;
    let (x1461, x1462) = fiat_p384_scalar_addcarryx_u32(x1460, x1386, x1436);
    let mut x1463: u32 = 0;
    let mut x1464: fiat_p384_scalar_u1 = 0;
    let (x1463, x1464) = fiat_p384_scalar_addcarryx_u32(x1462, x1388, x1438);
    let mut x1465: u32 = 0;
    let mut x1466: fiat_p384_scalar_u1 = 0;
    let (x1465, x1466) = fiat_p384_scalar_addcarryx_u32(x1464, x1390, x1440);
    let mut x1467: u32 = 0;
    let mut x1468: fiat_p384_scalar_u1 = 0;
    let (x1467, x1468) = fiat_p384_scalar_addcarryx_u32(x1466, x1392, x1442);
    let mut x1469: u32 = 0;
    let mut x1470: fiat_p384_scalar_u1 = 0;
    let (x1469, x1470) = fiat_p384_scalar_addcarryx_u32(x1468, x1394, x1444);
    let mut x1471: u32 = 0;
    let mut x1472: fiat_p384_scalar_u1 = 0;
    let (x1471, x1472) = fiat_p384_scalar_addcarryx_u32(x1470, x1396, x1446);
    let mut x1473: u32 = 0;
    let mut x1474: fiat_p384_scalar_u1 = 0;
    let (x1473, x1474) = fiat_p384_scalar_addcarryx_u32(x1472, x1398, x1448);
    let x1475: u32 = ((x1474 as u32) + (x1399 as u32));
    let mut x1476: u32 = 0;
    let mut x1477: u32 = 0;
    let (x1476, x1477) = fiat_p384_scalar_mulx_u32(x10, (arg1[11]));
    let mut x1478: u32 = 0;
    let mut x1479: u32 = 0;
    let (x1478, x1479) = fiat_p384_scalar_mulx_u32(x10, (arg1[10]));
    let mut x1480: u32 = 0;
    let mut x1481: u32 = 0;
    let (x1480, x1481) = fiat_p384_scalar_mulx_u32(x10, (arg1[9]));
    let mut x1482: u32 = 0;
    let mut x1483: u32 = 0;
    let (x1482, x1483) = fiat_p384_scalar_mulx_u32(x10, (arg1[8]));
    let mut x1484: u32 = 0;
    let mut x1485: u32 = 0;
    let (x1484, x1485) = fiat_p384_scalar_mulx_u32(x10, (arg1[7]));
    let mut x1486: u32 = 0;
    let mut x1487: u32 = 0;
    let (x1486, x1487) = fiat_p384_scalar_mulx_u32(x10, (arg1[6]));
    let mut x1488: u32 = 0;
    let mut x1489: u32 = 0;
    let (x1488, x1489) = fiat_p384_scalar_mulx_u32(x10, (arg1[5]));
    let mut x1490: u32 = 0;
    let mut x1491: u32 = 0;
    let (x1490, x1491) = fiat_p384_scalar_mulx_u32(x10, (arg1[4]));
    let mut x1492: u32 = 0;
    let mut x1493: u32 = 0;
    let (x1492, x1493) = fiat_p384_scalar_mulx_u32(x10, (arg1[3]));
    let mut x1494: u32 = 0;
    let mut x1495: u32 = 0;
    let (x1494, x1495) = fiat_p384_scalar_mulx_u32(x10, (arg1[2]));
    let mut x1496: u32 = 0;
    let mut x1497: u32 = 0;
    let (x1496, x1497) = fiat_p384_scalar_mulx_u32(x10, (arg1[1]));
    let mut x1498: u32 = 0;
    let mut x1499: u32 = 0;
    let (x1498, x1499) = fiat_p384_scalar_mulx_u32(x10, (arg1[0]));
    let mut x1500: u32 = 0;
    let mut x1501: fiat_p384_scalar_u1 = 0;
    let (x1500, x1501) = fiat_p384_scalar_addcarryx_u32(0x0, x1499, x1496);
    let mut x1502: u32 = 0;
    let mut x1503: fiat_p384_scalar_u1 = 0;
    let (x1502, x1503) = fiat_p384_scalar_addcarryx_u32(x1501, x1497, x1494);
    let mut x1504: u32 = 0;
    let mut x1505: fiat_p384_scalar_u1 = 0;
    let (x1504, x1505) = fiat_p384_scalar_addcarryx_u32(x1503, x1495, x1492);
    let mut x1506: u32 = 0;
    let mut x1507: fiat_p384_scalar_u1 = 0;
    let (x1506, x1507) = fiat_p384_scalar_addcarryx_u32(x1505, x1493, x1490);
    let mut x1508: u32 = 0;
    let mut x1509: fiat_p384_scalar_u1 = 0;
    let (x1508, x1509) = fiat_p384_scalar_addcarryx_u32(x1507, x1491, x1488);
    let mut x1510: u32 = 0;
    let mut x1511: fiat_p384_scalar_u1 = 0;
    let (x1510, x1511) = fiat_p384_scalar_addcarryx_u32(x1509, x1489, x1486);
    let mut x1512: u32 = 0;
    let mut x1513: fiat_p384_scalar_u1 = 0;
    let (x1512, x1513) = fiat_p384_scalar_addcarryx_u32(x1511, x1487, x1484);
    let mut x1514: u32 = 0;
    let mut x1515: fiat_p384_scalar_u1 = 0;
    let (x1514, x1515) = fiat_p384_scalar_addcarryx_u32(x1513, x1485, x1482);
    let mut x1516: u32 = 0;
    let mut x1517: fiat_p384_scalar_u1 = 0;
    let (x1516, x1517) = fiat_p384_scalar_addcarryx_u32(x1515, x1483, x1480);
    let mut x1518: u32 = 0;
    let mut x1519: fiat_p384_scalar_u1 = 0;
    let (x1518, x1519) = fiat_p384_scalar_addcarryx_u32(x1517, x1481, x1478);
    let mut x1520: u32 = 0;
    let mut x1521: fiat_p384_scalar_u1 = 0;
    let (x1520, x1521) = fiat_p384_scalar_addcarryx_u32(x1519, x1479, x1476);
    let x1522: u32 = ((x1521 as u32) + x1477);
    let mut x1523: u32 = 0;
    let mut x1524: fiat_p384_scalar_u1 = 0;
    let (x1523, x1524) = fiat_p384_scalar_addcarryx_u32(0x0, x1451, x1498);
    let mut x1525: u32 = 0;
    let mut x1526: fiat_p384_scalar_u1 = 0;
    let (x1525, x1526) = fiat_p384_scalar_addcarryx_u32(x1524, x1453, x1500);
    let mut x1527: u32 = 0;
    let mut x1528: fiat_p384_scalar_u1 = 0;
    let (x1527, x1528) = fiat_p384_scalar_addcarryx_u32(x1526, x1455, x1502);
    let mut x1529: u32 = 0;
    let mut x1530: fiat_p384_scalar_u1 = 0;
    let (x1529, x1530) = fiat_p384_scalar_addcarryx_u32(x1528, x1457, x1504);
    let mut x1531: u32 = 0;
    let mut x1532: fiat_p384_scalar_u1 = 0;
    let (x1531, x1532) = fiat_p384_scalar_addcarryx_u32(x1530, x1459, x1506);
    let mut x1533: u32 = 0;
    let mut x1534: fiat_p384_scalar_u1 = 0;
    let (x1533, x1534) = fiat_p384_scalar_addcarryx_u32(x1532, x1461, x1508);
    let mut x1535: u32 = 0;
    let mut x1536: fiat_p384_scalar_u1 = 0;
    let (x1535, x1536) = fiat_p384_scalar_addcarryx_u32(x1534, x1463, x1510);
    let mut x1537: u32 = 0;
    let mut x1538: fiat_p384_scalar_u1 = 0;
    let (x1537, x1538) = fiat_p384_scalar_addcarryx_u32(x1536, x1465, x1512);
    let mut x1539: u32 = 0;
    let mut x1540: fiat_p384_scalar_u1 = 0;
    let (x1539, x1540) = fiat_p384_scalar_addcarryx_u32(x1538, x1467, x1514);
    let mut x1541: u32 = 0;
    let mut x1542: fiat_p384_scalar_u1 = 0;
    let (x1541, x1542) = fiat_p384_scalar_addcarryx_u32(x1540, x1469, x1516);
    let mut x1543: u32 = 0;
    let mut x1544: fiat_p384_scalar_u1 = 0;
    let (x1543, x1544) = fiat_p384_scalar_addcarryx_u32(x1542, x1471, x1518);
    let mut x1545: u32 = 0;
    let mut x1546: fiat_p384_scalar_u1 = 0;
    let (x1545, x1546) = fiat_p384_scalar_addcarryx_u32(x1544, x1473, x1520);
    let mut x1547: u32 = 0;
    let mut x1548: fiat_p384_scalar_u1 = 0;
    let (x1547, x1548) = fiat_p384_scalar_addcarryx_u32(x1546, x1475, x1522);
    let mut x1549: u32 = 0;
    let mut x1550: u32 = 0;
    let (x1549, x1550) = fiat_p384_scalar_mulx_u32(x1523, 0xe88fdc45);
    let mut x1551: u32 = 0;
    let mut x1552: u32 = 0;
    let (x1551, x1552) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1553: u32 = 0;
    let mut x1554: u32 = 0;
    let (x1553, x1554) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1555: u32 = 0;
    let mut x1556: u32 = 0;
    let (x1555, x1556) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1557: u32 = 0;
    let mut x1558: u32 = 0;
    let (x1557, x1558) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1559: u32 = 0;
    let mut x1560: u32 = 0;
    let (x1559, x1560) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1561: u32 = 0;
    let mut x1562: u32 = 0;
    let (x1561, x1562) = fiat_p384_scalar_mulx_u32(x1549, 0xffffffff);
    let mut x1563: u32 = 0;
    let mut x1564: u32 = 0;
    let (x1563, x1564) = fiat_p384_scalar_mulx_u32(x1549, 0xc7634d81);
    let mut x1565: u32 = 0;
    let mut x1566: u32 = 0;
    let (x1565, x1566) = fiat_p384_scalar_mulx_u32(x1549, 0xf4372ddf);
    let mut x1567: u32 = 0;
    let mut x1568: u32 = 0;
    let (x1567, x1568) = fiat_p384_scalar_mulx_u32(x1549, 0x581a0db2);
    let mut x1569: u32 = 0;
    let mut x1570: u32 = 0;
    let (x1569, x1570) = fiat_p384_scalar_mulx_u32(x1549, 0x48b0a77a);
    let mut x1571: u32 = 0;
    let mut x1572: u32 = 0;
    let (x1571, x1572) = fiat_p384_scalar_mulx_u32(x1549, 0xecec196a);
    let mut x1573: u32 = 0;
    let mut x1574: u32 = 0;
    let (x1573, x1574) = fiat_p384_scalar_mulx_u32(x1549, 0xccc52973);
    let mut x1575: u32 = 0;
    let mut x1576: fiat_p384_scalar_u1 = 0;
    let (x1575, x1576) = fiat_p384_scalar_addcarryx_u32(0x0, x1574, x1571);
    let mut x1577: u32 = 0;
    let mut x1578: fiat_p384_scalar_u1 = 0;
    let (x1577, x1578) = fiat_p384_scalar_addcarryx_u32(x1576, x1572, x1569);
    let mut x1579: u32 = 0;
    let mut x1580: fiat_p384_scalar_u1 = 0;
    let (x1579, x1580) = fiat_p384_scalar_addcarryx_u32(x1578, x1570, x1567);
    let mut x1581: u32 = 0;
    let mut x1582: fiat_p384_scalar_u1 = 0;
    let (x1581, x1582) = fiat_p384_scalar_addcarryx_u32(x1580, x1568, x1565);
    let mut x1583: u32 = 0;
    let mut x1584: fiat_p384_scalar_u1 = 0;
    let (x1583, x1584) = fiat_p384_scalar_addcarryx_u32(x1582, x1566, x1563);
    let mut x1585: u32 = 0;
    let mut x1586: fiat_p384_scalar_u1 = 0;
    let (x1585, x1586) = fiat_p384_scalar_addcarryx_u32(x1584, x1564, x1561);
    let mut x1587: u32 = 0;
    let mut x1588: fiat_p384_scalar_u1 = 0;
    let (x1587, x1588) = fiat_p384_scalar_addcarryx_u32(x1586, x1562, x1559);
    let mut x1589: u32 = 0;
    let mut x1590: fiat_p384_scalar_u1 = 0;
    let (x1589, x1590) = fiat_p384_scalar_addcarryx_u32(x1588, x1560, x1557);
    let mut x1591: u32 = 0;
    let mut x1592: fiat_p384_scalar_u1 = 0;
    let (x1591, x1592) = fiat_p384_scalar_addcarryx_u32(x1590, x1558, x1555);
    let mut x1593: u32 = 0;
    let mut x1594: fiat_p384_scalar_u1 = 0;
    let (x1593, x1594) = fiat_p384_scalar_addcarryx_u32(x1592, x1556, x1553);
    let mut x1595: u32 = 0;
    let mut x1596: fiat_p384_scalar_u1 = 0;
    let (x1595, x1596) = fiat_p384_scalar_addcarryx_u32(x1594, x1554, x1551);
    let x1597: u32 = ((x1596 as u32) + x1552);
    let mut x1598: u32 = 0;
    let mut x1599: fiat_p384_scalar_u1 = 0;
    let (x1598, x1599) = fiat_p384_scalar_addcarryx_u32(0x0, x1523, x1573);
    let mut x1600: u32 = 0;
    let mut x1601: fiat_p384_scalar_u1 = 0;
    let (x1600, x1601) = fiat_p384_scalar_addcarryx_u32(x1599, x1525, x1575);
    let mut x1602: u32 = 0;
    let mut x1603: fiat_p384_scalar_u1 = 0;
    let (x1602, x1603) = fiat_p384_scalar_addcarryx_u32(x1601, x1527, x1577);
    let mut x1604: u32 = 0;
    let mut x1605: fiat_p384_scalar_u1 = 0;
    let (x1604, x1605) = fiat_p384_scalar_addcarryx_u32(x1603, x1529, x1579);
    let mut x1606: u32 = 0;
    let mut x1607: fiat_p384_scalar_u1 = 0;
    let (x1606, x1607) = fiat_p384_scalar_addcarryx_u32(x1605, x1531, x1581);
    let mut x1608: u32 = 0;
    let mut x1609: fiat_p384_scalar_u1 = 0;
    let (x1608, x1609) = fiat_p384_scalar_addcarryx_u32(x1607, x1533, x1583);
    let mut x1610: u32 = 0;
    let mut x1611: fiat_p384_scalar_u1 = 0;
    let (x1610, x1611) = fiat_p384_scalar_addcarryx_u32(x1609, x1535, x1585);
    let mut x1612: u32 = 0;
    let mut x1613: fiat_p384_scalar_u1 = 0;
    let (x1612, x1613) = fiat_p384_scalar_addcarryx_u32(x1611, x1537, x1587);
    let mut x1614: u32 = 0;
    let mut x1615: fiat_p384_scalar_u1 = 0;
    let (x1614, x1615) = fiat_p384_scalar_addcarryx_u32(x1613, x1539, x1589);
    let mut x1616: u32 = 0;
    let mut x1617: fiat_p384_scalar_u1 = 0;
    let (x1616, x1617) = fiat_p384_scalar_addcarryx_u32(x1615, x1541, x1591);
    let mut x1618: u32 = 0;
    let mut x1619: fiat_p384_scalar_u1 = 0;
    let (x1618, x1619) = fiat_p384_scalar_addcarryx_u32(x1617, x1543, x1593);
    let mut x1620: u32 = 0;
    let mut x1621: fiat_p384_scalar_u1 = 0;
    let (x1620, x1621) = fiat_p384_scalar_addcarryx_u32(x1619, x1545, x1595);
    let mut x1622: u32 = 0;
    let mut x1623: fiat_p384_scalar_u1 = 0;
    let (x1622, x1623) = fiat_p384_scalar_addcarryx_u32(x1621, x1547, x1597);
    let x1624: u32 = ((x1623 as u32) + (x1548 as u32));
    let mut x1625: u32 = 0;
    let mut x1626: u32 = 0;
    let (x1625, x1626) = fiat_p384_scalar_mulx_u32(x11, (arg1[11]));
    let mut x1627: u32 = 0;
    let mut x1628: u32 = 0;
    let (x1627, x1628) = fiat_p384_scalar_mulx_u32(x11, (arg1[10]));
    let mut x1629: u32 = 0;
    let mut x1630: u32 = 0;
    let (x1629, x1630) = fiat_p384_scalar_mulx_u32(x11, (arg1[9]));
    let mut x1631: u32 = 0;
    let mut x1632: u32 = 0;
    let (x1631, x1632) = fiat_p384_scalar_mulx_u32(x11, (arg1[8]));
    let mut x1633: u32 = 0;
    let mut x1634: u32 = 0;
    let (x1633, x1634) = fiat_p384_scalar_mulx_u32(x11, (arg1[7]));
    let mut x1635: u32 = 0;
    let mut x1636: u32 = 0;
    let (x1635, x1636) = fiat_p384_scalar_mulx_u32(x11, (arg1[6]));
    let mut x1637: u32 = 0;
    let mut x1638: u32 = 0;
    let (x1637, x1638) = fiat_p384_scalar_mulx_u32(x11, (arg1[5]));
    let mut x1639: u32 = 0;
    let mut x1640: u32 = 0;
    let (x1639, x1640) = fiat_p384_scalar_mulx_u32(x11, (arg1[4]));
    let mut x1641: u32 = 0;
    let mut x1642: u32 = 0;
    let (x1641, x1642) = fiat_p384_scalar_mulx_u32(x11, (arg1[3]));
    let mut x1643: u32 = 0;
    let mut x1644: u32 = 0;
    let (x1643, x1644) = fiat_p384_scalar_mulx_u32(x11, (arg1[2]));
    let mut x1645: u32 = 0;
    let mut x1646: u32 = 0;
    let (x1645, x1646) = fiat_p384_scalar_mulx_u32(x11, (arg1[1]));
    let mut x1647: u32 = 0;
    let mut x1648: u32 = 0;
    let (x1647, x1648) = fiat_p384_scalar_mulx_u32(x11, (arg1[0]));
    let mut x1649: u32 = 0;
    let mut x1650: fiat_p384_scalar_u1 = 0;
    let (x1649, x1650) = fiat_p384_scalar_addcarryx_u32(0x0, x1648, x1645);
    let mut x1651: u32 = 0;
    let mut x1652: fiat_p384_scalar_u1 = 0;
    let (x1651, x1652) = fiat_p384_scalar_addcarryx_u32(x1650, x1646, x1643);
    let mut x1653: u32 = 0;
    let mut x1654: fiat_p384_scalar_u1 = 0;
    let (x1653, x1654) = fiat_p384_scalar_addcarryx_u32(x1652, x1644, x1641);
    let mut x1655: u32 = 0;
    let mut x1656: fiat_p384_scalar_u1 = 0;
    let (x1655, x1656) = fiat_p384_scalar_addcarryx_u32(x1654, x1642, x1639);
    let mut x1657: u32 = 0;
    let mut x1658: fiat_p384_scalar_u1 = 0;
    let (x1657, x1658) = fiat_p384_scalar_addcarryx_u32(x1656, x1640, x1637);
    let mut x1659: u32 = 0;
    let mut x1660: fiat_p384_scalar_u1 = 0;
    let (x1659, x1660) = fiat_p384_scalar_addcarryx_u32(x1658, x1638, x1635);
    let mut x1661: u32 = 0;
    let mut x1662: fiat_p384_scalar_u1 = 0;
    let (x1661, x1662) = fiat_p384_scalar_addcarryx_u32(x1660, x1636, x1633);
    let mut x1663: u32 = 0;
    let mut x1664: fiat_p384_scalar_u1 = 0;
    let (x1663, x1664) = fiat_p384_scalar_addcarryx_u32(x1662, x1634, x1631);
    let mut x1665: u32 = 0;
    let mut x1666: fiat_p384_scalar_u1 = 0;
    let (x1665, x1666) = fiat_p384_scalar_addcarryx_u32(x1664, x1632, x1629);
    let mut x1667: u32 = 0;
    let mut x1668: fiat_p384_scalar_u1 = 0;
    let (x1667, x1668) = fiat_p384_scalar_addcarryx_u32(x1666, x1630, x1627);
    let mut x1669: u32 = 0;
    let mut x1670: fiat_p384_scalar_u1 = 0;
    let (x1669, x1670) = fiat_p384_scalar_addcarryx_u32(x1668, x1628, x1625);
    let x1671: u32 = ((x1670 as u32) + x1626);
    let mut x1672: u32 = 0;
    let mut x1673: fiat_p384_scalar_u1 = 0;
    let (x1672, x1673) = fiat_p384_scalar_addcarryx_u32(0x0, x1600, x1647);
    let mut x1674: u32 = 0;
    let mut x1675: fiat_p384_scalar_u1 = 0;
    let (x1674, x1675) = fiat_p384_scalar_addcarryx_u32(x1673, x1602, x1649);
    let mut x1676: u32 = 0;
    let mut x1677: fiat_p384_scalar_u1 = 0;
    let (x1676, x1677) = fiat_p384_scalar_addcarryx_u32(x1675, x1604, x1651);
    let mut x1678: u32 = 0;
    let mut x1679: fiat_p384_scalar_u1 = 0;
    let (x1678, x1679) = fiat_p384_scalar_addcarryx_u32(x1677, x1606, x1653);
    let mut x1680: u32 = 0;
    let mut x1681: fiat_p384_scalar_u1 = 0;
    let (x1680, x1681) = fiat_p384_scalar_addcarryx_u32(x1679, x1608, x1655);
    let mut x1682: u32 = 0;
    let mut x1683: fiat_p384_scalar_u1 = 0;
    let (x1682, x1683) = fiat_p384_scalar_addcarryx_u32(x1681, x1610, x1657);
    let mut x1684: u32 = 0;
    let mut x1685: fiat_p384_scalar_u1 = 0;
    let (x1684, x1685) = fiat_p384_scalar_addcarryx_u32(x1683, x1612, x1659);
    let mut x1686: u32 = 0;
    let mut x1687: fiat_p384_scalar_u1 = 0;
    let (x1686, x1687) = fiat_p384_scalar_addcarryx_u32(x1685, x1614, x1661);
    let mut x1688: u32 = 0;
    let mut x1689: fiat_p384_scalar_u1 = 0;
    let (x1688, x1689) = fiat_p384_scalar_addcarryx_u32(x1687, x1616, x1663);
    let mut x1690: u32 = 0;
    let mut x1691: fiat_p384_scalar_u1 = 0;
    let (x1690, x1691) = fiat_p384_scalar_addcarryx_u32(x1689, x1618, x1665);
    let mut x1692: u32 = 0;
    let mut x1693: fiat_p384_scalar_u1 = 0;
    let (x1692, x1693) = fiat_p384_scalar_addcarryx_u32(x1691, x1620, x1667);
    let mut x1694: u32 = 0;
    let mut x1695: fiat_p384_scalar_u1 = 0;
    let (x1694, x1695) = fiat_p384_scalar_addcarryx_u32(x1693, x1622, x1669);
    let mut x1696: u32 = 0;
    let mut x1697: fiat_p384_scalar_u1 = 0;
    let (x1696, x1697) = fiat_p384_scalar_addcarryx_u32(x1695, x1624, x1671);
    let mut x1698: u32 = 0;
    let mut x1699: u32 = 0;
    let (x1698, x1699) = fiat_p384_scalar_mulx_u32(x1672, 0xe88fdc45);
    let mut x1700: u32 = 0;
    let mut x1701: u32 = 0;
    let (x1700, x1701) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1702: u32 = 0;
    let mut x1703: u32 = 0;
    let (x1702, x1703) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1704: u32 = 0;
    let mut x1705: u32 = 0;
    let (x1704, x1705) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1706: u32 = 0;
    let mut x1707: u32 = 0;
    let (x1706, x1707) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1708: u32 = 0;
    let mut x1709: u32 = 0;
    let (x1708, x1709) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1710: u32 = 0;
    let mut x1711: u32 = 0;
    let (x1710, x1711) = fiat_p384_scalar_mulx_u32(x1698, 0xffffffff);
    let mut x1712: u32 = 0;
    let mut x1713: u32 = 0;
    let (x1712, x1713) = fiat_p384_scalar_mulx_u32(x1698, 0xc7634d81);
    let mut x1714: u32 = 0;
    let mut x1715: u32 = 0;
    let (x1714, x1715) = fiat_p384_scalar_mulx_u32(x1698, 0xf4372ddf);
    let mut x1716: u32 = 0;
    let mut x1717: u32 = 0;
    let (x1716, x1717) = fiat_p384_scalar_mulx_u32(x1698, 0x581a0db2);
    let mut x1718: u32 = 0;
    let mut x1719: u32 = 0;
    let (x1718, x1719) = fiat_p384_scalar_mulx_u32(x1698, 0x48b0a77a);
    let mut x1720: u32 = 0;
    let mut x1721: u32 = 0;
    let (x1720, x1721) = fiat_p384_scalar_mulx_u32(x1698, 0xecec196a);
    let mut x1722: u32 = 0;
    let mut x1723: u32 = 0;
    let (x1722, x1723) = fiat_p384_scalar_mulx_u32(x1698, 0xccc52973);
    let mut x1724: u32 = 0;
    let mut x1725: fiat_p384_scalar_u1 = 0;
    let (x1724, x1725) = fiat_p384_scalar_addcarryx_u32(0x0, x1723, x1720);
    let mut x1726: u32 = 0;
    let mut x1727: fiat_p384_scalar_u1 = 0;
    let (x1726, x1727) = fiat_p384_scalar_addcarryx_u32(x1725, x1721, x1718);
    let mut x1728: u32 = 0;
    let mut x1729: fiat_p384_scalar_u1 = 0;
    let (x1728, x1729) = fiat_p384_scalar_addcarryx_u32(x1727, x1719, x1716);
    let mut x1730: u32 = 0;
    let mut x1731: fiat_p384_scalar_u1 = 0;
    let (x1730, x1731) = fiat_p384_scalar_addcarryx_u32(x1729, x1717, x1714);
    let mut x1732: u32 = 0;
    let mut x1733: fiat_p384_scalar_u1 = 0;
    let (x1732, x1733) = fiat_p384_scalar_addcarryx_u32(x1731, x1715, x1712);
    let mut x1734: u32 = 0;
    let mut x1735: fiat_p384_scalar_u1 = 0;
    let (x1734, x1735) = fiat_p384_scalar_addcarryx_u32(x1733, x1713, x1710);
    let mut x1736: u32 = 0;
    let mut x1737: fiat_p384_scalar_u1 = 0;
    let (x1736, x1737) = fiat_p384_scalar_addcarryx_u32(x1735, x1711, x1708);
    let mut x1738: u32 = 0;
    let mut x1739: fiat_p384_scalar_u1 = 0;
    let (x1738, x1739) = fiat_p384_scalar_addcarryx_u32(x1737, x1709, x1706);
    let mut x1740: u32 = 0;
    let mut x1741: fiat_p384_scalar_u1 = 0;
    let (x1740, x1741) = fiat_p384_scalar_addcarryx_u32(x1739, x1707, x1704);
    let mut x1742: u32 = 0;
    let mut x1743: fiat_p384_scalar_u1 = 0;
    let (x1742, x1743) = fiat_p384_scalar_addcarryx_u32(x1741, x1705, x1702);
    let mut x1744: u32 = 0;
    let mut x1745: fiat_p384_scalar_u1 = 0;
    let (x1744, x1745) = fiat_p384_scalar_addcarryx_u32(x1743, x1703, x1700);
    let x1746: u32 = ((x1745 as u32) + x1701);
    let mut x1747: u32 = 0;
    let mut x1748: fiat_p384_scalar_u1 = 0;
    let (x1747, x1748) = fiat_p384_scalar_addcarryx_u32(0x0, x1672, x1722);
    let mut x1749: u32 = 0;
    let mut x1750: fiat_p384_scalar_u1 = 0;
    let (x1749, x1750) = fiat_p384_scalar_addcarryx_u32(x1748, x1674, x1724);
    let mut x1751: u32 = 0;
    let mut x1752: fiat_p384_scalar_u1 = 0;
    let (x1751, x1752) = fiat_p384_scalar_addcarryx_u32(x1750, x1676, x1726);
    let mut x1753: u32 = 0;
    let mut x1754: fiat_p384_scalar_u1 = 0;
    let (x1753, x1754) = fiat_p384_scalar_addcarryx_u32(x1752, x1678, x1728);
    let mut x1755: u32 = 0;
    let mut x1756: fiat_p384_scalar_u1 = 0;
    let (x1755, x1756) = fiat_p384_scalar_addcarryx_u32(x1754, x1680, x1730);
    let mut x1757: u32 = 0;
    let mut x1758: fiat_p384_scalar_u1 = 0;
    let (x1757, x1758) = fiat_p384_scalar_addcarryx_u32(x1756, x1682, x1732);
    let mut x1759: u32 = 0;
    let mut x1760: fiat_p384_scalar_u1 = 0;
    let (x1759, x1760) = fiat_p384_scalar_addcarryx_u32(x1758, x1684, x1734);
    let mut x1761: u32 = 0;
    let mut x1762: fiat_p384_scalar_u1 = 0;
    let (x1761, x1762) = fiat_p384_scalar_addcarryx_u32(x1760, x1686, x1736);
    let mut x1763: u32 = 0;
    let mut x1764: fiat_p384_scalar_u1 = 0;
    let (x1763, x1764) = fiat_p384_scalar_addcarryx_u32(x1762, x1688, x1738);
    let mut x1765: u32 = 0;
    let mut x1766: fiat_p384_scalar_u1 = 0;
    let (x1765, x1766) = fiat_p384_scalar_addcarryx_u32(x1764, x1690, x1740);
    let mut x1767: u32 = 0;
    let mut x1768: fiat_p384_scalar_u1 = 0;
    let (x1767, x1768) = fiat_p384_scalar_addcarryx_u32(x1766, x1692, x1742);
    let mut x1769: u32 = 0;
    let mut x1770: fiat_p384_scalar_u1 = 0;
    let (x1769, x1770) = fiat_p384_scalar_addcarryx_u32(x1768, x1694, x1744);
    let mut x1771: u32 = 0;
    let mut x1772: fiat_p384_scalar_u1 = 0;
    let (x1771, x1772) = fiat_p384_scalar_addcarryx_u32(x1770, x1696, x1746);
    let x1773: u32 = ((x1772 as u32) + (x1697 as u32));
    let mut x1774: u32 = 0;
    let mut x1775: fiat_p384_scalar_u1 = 0;
    let (x1774, x1775) = fiat_p384_scalar_subborrowx_u32(0x0, x1749, 0xccc52973);
    let mut x1776: u32 = 0;
    let mut x1777: fiat_p384_scalar_u1 = 0;
    let (x1776, x1777) = fiat_p384_scalar_subborrowx_u32(x1775, x1751, 0xecec196a);
    let mut x1778: u32 = 0;
    let mut x1779: fiat_p384_scalar_u1 = 0;
    let (x1778, x1779) = fiat_p384_scalar_subborrowx_u32(x1777, x1753, 0x48b0a77a);
    let mut x1780: u32 = 0;
    let mut x1781: fiat_p384_scalar_u1 = 0;
    let (x1780, x1781) = fiat_p384_scalar_subborrowx_u32(x1779, x1755, 0x581a0db2);
    let mut x1782: u32 = 0;
    let mut x1783: fiat_p384_scalar_u1 = 0;
    let (x1782, x1783) = fiat_p384_scalar_subborrowx_u32(x1781, x1757, 0xf4372ddf);
    let mut x1784: u32 = 0;
    let mut x1785: fiat_p384_scalar_u1 = 0;
    let (x1784, x1785) = fiat_p384_scalar_subborrowx_u32(x1783, x1759, 0xc7634d81);
    let mut x1786: u32 = 0;
    let mut x1787: fiat_p384_scalar_u1 = 0;
    let (x1786, x1787) = fiat_p384_scalar_subborrowx_u32(x1785, x1761, 0xffffffff);
    let mut x1788: u32 = 0;
    let mut x1789: fiat_p384_scalar_u1 = 0;
    let (x1788, x1789) = fiat_p384_scalar_subborrowx_u32(x1787, x1763, 0xffffffff);
    let mut x1790: u32 = 0;
    let mut x1791: fiat_p384_scalar_u1 = 0;
    let (x1790, x1791) = fiat_p384_scalar_subborrowx_u32(x1789, x1765, 0xffffffff);
    let mut x1792: u32 = 0;
    let mut x1793: fiat_p384_scalar_u1 = 0;
    let (x1792, x1793) = fiat_p384_scalar_subborrowx_u32(x1791, x1767, 0xffffffff);
    let mut x1794: u32 = 0;
    let mut x1795: fiat_p384_scalar_u1 = 0;
    let (x1794, x1795) = fiat_p384_scalar_subborrowx_u32(x1793, x1769, 0xffffffff);
    let mut x1796: u32 = 0;
    let mut x1797: fiat_p384_scalar_u1 = 0;
    let (x1796, x1797) = fiat_p384_scalar_subborrowx_u32(x1795, x1771, 0xffffffff);
    let mut x1798: u32 = 0;
    let mut x1799: fiat_p384_scalar_u1 = 0;
    let (x1798, x1799) = fiat_p384_scalar_subborrowx_u32(x1797, x1773, (0x0 as u32));
    let mut x1800: u32 = 0;
    let (x1800) = fiat_p384_scalar_cmovznz_u32(x1799, x1774, x1749);
    let mut x1801: u32 = 0;
    let (x1801) = fiat_p384_scalar_cmovznz_u32(x1799, x1776, x1751);
    let mut x1802: u32 = 0;
    let (x1802) = fiat_p384_scalar_cmovznz_u32(x1799, x1778, x1753);
    let mut x1803: u32 = 0;
    let (x1803) = fiat_p384_scalar_cmovznz_u32(x1799, x1780, x1755);
    let mut x1804: u32 = 0;
    let (x1804) = fiat_p384_scalar_cmovznz_u32(x1799, x1782, x1757);
    let mut x1805: u32 = 0;
    let (x1805) = fiat_p384_scalar_cmovznz_u32(x1799, x1784, x1759);
    let mut x1806: u32 = 0;
    let (x1806) = fiat_p384_scalar_cmovznz_u32(x1799, x1786, x1761);
    let mut x1807: u32 = 0;
    let (x1807) = fiat_p384_scalar_cmovznz_u32(x1799, x1788, x1763);
    let mut x1808: u32 = 0;
    let (x1808) = fiat_p384_scalar_cmovznz_u32(x1799, x1790, x1765);
    let mut x1809: u32 = 0;
    let (x1809) = fiat_p384_scalar_cmovznz_u32(x1799, x1792, x1767);
    let mut x1810: u32 = 0;
    let (x1810) = fiat_p384_scalar_cmovznz_u32(x1799, x1794, x1769);
    let mut x1811: u32 = 0;
    let (x1811) = fiat_p384_scalar_cmovznz_u32(x1799, x1796, x1771);
    out1[0] = x1800;
    out1[1] = x1801;
    out1[2] = x1802;
    out1[3] = x1803;
    out1[4] = x1804;
    out1[5] = x1805;
    out1[6] = x1806;
    out1[7] = x1807;
    out1[8] = x1808;
    out1[9] = x1809;
    out1[10] = x1810;
    out1[11] = x1811;
    out1
}
#[doc = " The function fiat_p384_scalar_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_add(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
    arg2: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let mut x1: u32 = 0;
    let mut x2: fiat_p384_scalar_u1 = 0;
    let (x1, x2) = fiat_p384_scalar_addcarryx_u32(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u32 = 0;
    let mut x4: fiat_p384_scalar_u1 = 0;
    let (x3, x4) = fiat_p384_scalar_addcarryx_u32(x2, (arg1[1]), (arg2[1]));
    let mut x5: u32 = 0;
    let mut x6: fiat_p384_scalar_u1 = 0;
    let (x5, x6) = fiat_p384_scalar_addcarryx_u32(x4, (arg1[2]), (arg2[2]));
    let mut x7: u32 = 0;
    let mut x8: fiat_p384_scalar_u1 = 0;
    let (x7, x8) = fiat_p384_scalar_addcarryx_u32(x6, (arg1[3]), (arg2[3]));
    let mut x9: u32 = 0;
    let mut x10: fiat_p384_scalar_u1 = 0;
    let (x9, x10) = fiat_p384_scalar_addcarryx_u32(x8, (arg1[4]), (arg2[4]));
    let mut x11: u32 = 0;
    let mut x12: fiat_p384_scalar_u1 = 0;
    let (x11, x12) = fiat_p384_scalar_addcarryx_u32(x10, (arg1[5]), (arg2[5]));
    let mut x13: u32 = 0;
    let mut x14: fiat_p384_scalar_u1 = 0;
    let (x13, x14) = fiat_p384_scalar_addcarryx_u32(x12, (arg1[6]), (arg2[6]));
    let mut x15: u32 = 0;
    let mut x16: fiat_p384_scalar_u1 = 0;
    let (x15, x16) = fiat_p384_scalar_addcarryx_u32(x14, (arg1[7]), (arg2[7]));
    let mut x17: u32 = 0;
    let mut x18: fiat_p384_scalar_u1 = 0;
    let (x17, x18) = fiat_p384_scalar_addcarryx_u32(x16, (arg1[8]), (arg2[8]));
    let mut x19: u32 = 0;
    let mut x20: fiat_p384_scalar_u1 = 0;
    let (x19, x20) = fiat_p384_scalar_addcarryx_u32(x18, (arg1[9]), (arg2[9]));
    let mut x21: u32 = 0;
    let mut x22: fiat_p384_scalar_u1 = 0;
    let (x21, x22) = fiat_p384_scalar_addcarryx_u32(x20, (arg1[10]), (arg2[10]));
    let mut x23: u32 = 0;
    let mut x24: fiat_p384_scalar_u1 = 0;
    let (x23, x24) = fiat_p384_scalar_addcarryx_u32(x22, (arg1[11]), (arg2[11]));
    let mut x25: u32 = 0;
    let mut x26: fiat_p384_scalar_u1 = 0;
    let (x25, x26) = fiat_p384_scalar_subborrowx_u32(0x0, x1, 0xccc52973);
    let mut x27: u32 = 0;
    let mut x28: fiat_p384_scalar_u1 = 0;
    let (x27, x28) = fiat_p384_scalar_subborrowx_u32(x26, x3, 0xecec196a);
    let mut x29: u32 = 0;
    let mut x30: fiat_p384_scalar_u1 = 0;
    let (x29, x30) = fiat_p384_scalar_subborrowx_u32(x28, x5, 0x48b0a77a);
    let mut x31: u32 = 0;
    let mut x32: fiat_p384_scalar_u1 = 0;
    let (x31, x32) = fiat_p384_scalar_subborrowx_u32(x30, x7, 0x581a0db2);
    let mut x33: u32 = 0;
    let mut x34: fiat_p384_scalar_u1 = 0;
    let (x33, x34) = fiat_p384_scalar_subborrowx_u32(x32, x9, 0xf4372ddf);
    let mut x35: u32 = 0;
    let mut x36: fiat_p384_scalar_u1 = 0;
    let (x35, x36) = fiat_p384_scalar_subborrowx_u32(x34, x11, 0xc7634d81);
    let mut x37: u32 = 0;
    let mut x38: fiat_p384_scalar_u1 = 0;
    let (x37, x38) = fiat_p384_scalar_subborrowx_u32(x36, x13, 0xffffffff);
    let mut x39: u32 = 0;
    let mut x40: fiat_p384_scalar_u1 = 0;
    let (x39, x40) = fiat_p384_scalar_subborrowx_u32(x38, x15, 0xffffffff);
    let mut x41: u32 = 0;
    let mut x42: fiat_p384_scalar_u1 = 0;
    let (x41, x42) = fiat_p384_scalar_subborrowx_u32(x40, x17, 0xffffffff);
    let mut x43: u32 = 0;
    let mut x44: fiat_p384_scalar_u1 = 0;
    let (x43, x44) = fiat_p384_scalar_subborrowx_u32(x42, x19, 0xffffffff);
    let mut x45: u32 = 0;
    let mut x46: fiat_p384_scalar_u1 = 0;
    let (x45, x46) = fiat_p384_scalar_subborrowx_u32(x44, x21, 0xffffffff);
    let mut x47: u32 = 0;
    let mut x48: fiat_p384_scalar_u1 = 0;
    let (x47, x48) = fiat_p384_scalar_subborrowx_u32(x46, x23, 0xffffffff);
    let mut x49: u32 = 0;
    let mut x50: fiat_p384_scalar_u1 = 0;
    let (x49, x50) = fiat_p384_scalar_subborrowx_u32(x48, (x24 as u32), (0x0 as u32));
    let mut x51: u32 = 0;
    let (x51) = fiat_p384_scalar_cmovznz_u32(x50, x25, x1);
    let mut x52: u32 = 0;
    let (x52) = fiat_p384_scalar_cmovznz_u32(x50, x27, x3);
    let mut x53: u32 = 0;
    let (x53) = fiat_p384_scalar_cmovznz_u32(x50, x29, x5);
    let mut x54: u32 = 0;
    let (x54) = fiat_p384_scalar_cmovznz_u32(x50, x31, x7);
    let mut x55: u32 = 0;
    let (x55) = fiat_p384_scalar_cmovznz_u32(x50, x33, x9);
    let mut x56: u32 = 0;
    let (x56) = fiat_p384_scalar_cmovznz_u32(x50, x35, x11);
    let mut x57: u32 = 0;
    let (x57) = fiat_p384_scalar_cmovznz_u32(x50, x37, x13);
    let mut x58: u32 = 0;
    let (x58) = fiat_p384_scalar_cmovznz_u32(x50, x39, x15);
    let mut x59: u32 = 0;
    let (x59) = fiat_p384_scalar_cmovznz_u32(x50, x41, x17);
    let mut x60: u32 = 0;
    let (x60) = fiat_p384_scalar_cmovznz_u32(x50, x43, x19);
    let mut x61: u32 = 0;
    let (x61) = fiat_p384_scalar_cmovznz_u32(x50, x45, x21);
    let mut x62: u32 = 0;
    let (x62) = fiat_p384_scalar_cmovznz_u32(x50, x47, x23);
    out1[0] = x51;
    out1[1] = x52;
    out1[2] = x53;
    out1[3] = x54;
    out1[4] = x55;
    out1[5] = x56;
    out1[6] = x57;
    out1[7] = x58;
    out1[8] = x59;
    out1[9] = x60;
    out1[10] = x61;
    out1[11] = x62;
    out1
}
#[doc = " The function fiat_p384_scalar_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_sub(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
    arg2: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let mut x1: u32 = 0;
    let mut x2: fiat_p384_scalar_u1 = 0;
    let (x1, x2) = fiat_p384_scalar_subborrowx_u32(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u32 = 0;
    let mut x4: fiat_p384_scalar_u1 = 0;
    let (x3, x4) = fiat_p384_scalar_subborrowx_u32(x2, (arg1[1]), (arg2[1]));
    let mut x5: u32 = 0;
    let mut x6: fiat_p384_scalar_u1 = 0;
    let (x5, x6) = fiat_p384_scalar_subborrowx_u32(x4, (arg1[2]), (arg2[2]));
    let mut x7: u32 = 0;
    let mut x8: fiat_p384_scalar_u1 = 0;
    let (x7, x8) = fiat_p384_scalar_subborrowx_u32(x6, (arg1[3]), (arg2[3]));
    let mut x9: u32 = 0;
    let mut x10: fiat_p384_scalar_u1 = 0;
    let (x9, x10) = fiat_p384_scalar_subborrowx_u32(x8, (arg1[4]), (arg2[4]));
    let mut x11: u32 = 0;
    let mut x12: fiat_p384_scalar_u1 = 0;
    let (x11, x12) = fiat_p384_scalar_subborrowx_u32(x10, (arg1[5]), (arg2[5]));
    let mut x13: u32 = 0;
    let mut x14: fiat_p384_scalar_u1 = 0;
    let (x13, x14) = fiat_p384_scalar_subborrowx_u32(x12, (arg1[6]), (arg2[6]));
    let mut x15: u32 = 0;
    let mut x16: fiat_p384_scalar_u1 = 0;
    let (x15, x16) = fiat_p384_scalar_subborrowx_u32(x14, (arg1[7]), (arg2[7]));
    let mut x17: u32 = 0;
    let mut x18: fiat_p384_scalar_u1 = 0;
    let (x17, x18) = fiat_p384_scalar_subborrowx_u32(x16, (arg1[8]), (arg2[8]));
    let mut x19: u32 = 0;
    let mut x20: fiat_p384_scalar_u1 = 0;
    let (x19, x20) = fiat_p384_scalar_subborrowx_u32(x18, (arg1[9]), (arg2[9]));
    let mut x21: u32 = 0;
    let mut x22: fiat_p384_scalar_u1 = 0;
    let (x21, x22) = fiat_p384_scalar_subborrowx_u32(x20, (arg1[10]), (arg2[10]));
    let mut x23: u32 = 0;
    let mut x24: fiat_p384_scalar_u1 = 0;
    let (x23, x24) = fiat_p384_scalar_subborrowx_u32(x22, (arg1[11]), (arg2[11]));
    let mut x25: u32 = 0;
    let (x25) = fiat_p384_scalar_cmovznz_u32(x24, (0x0 as u32), 0xffffffff);
    let mut x26: u32 = 0;
    let mut x27: fiat_p384_scalar_u1 = 0;
    let (x26, x27) = fiat_p384_scalar_addcarryx_u32(0x0, x1, (x25 & 0xccc52973));
    let mut x28: u32 = 0;
    let mut x29: fiat_p384_scalar_u1 = 0;
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(x27, x3, (x25 & 0xecec196a));
    let mut x30: u32 = 0;
    let mut x31: fiat_p384_scalar_u1 = 0;
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, x5, (x25 & 0x48b0a77a));
    let mut x32: u32 = 0;
    let mut x33: fiat_p384_scalar_u1 = 0;
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, x7, (x25 & 0x581a0db2));
    let mut x34: u32 = 0;
    let mut x35: fiat_p384_scalar_u1 = 0;
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, x9, (x25 & 0xf4372ddf));
    let mut x36: u32 = 0;
    let mut x37: fiat_p384_scalar_u1 = 0;
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, x11, (x25 & 0xc7634d81));
    let mut x38: u32 = 0;
    let mut x39: fiat_p384_scalar_u1 = 0;
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, x13, x25);
    let mut x40: u32 = 0;
    let mut x41: fiat_p384_scalar_u1 = 0;
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, x15, x25);
    let mut x42: u32 = 0;
    let mut x43: fiat_p384_scalar_u1 = 0;
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, x17, x25);
    let mut x44: u32 = 0;
    let mut x45: fiat_p384_scalar_u1 = 0;
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, x19, x25);
    let mut x46: u32 = 0;
    let mut x47: fiat_p384_scalar_u1 = 0;
    let (x46, x47) = fiat_p384_scalar_addcarryx_u32(x45, x21, x25);
    let mut x48: u32 = 0;
    let mut x49: fiat_p384_scalar_u1 = 0;
    let (x48, x49) = fiat_p384_scalar_addcarryx_u32(x47, x23, x25);
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
    out1
}
#[doc = " The function fiat_p384_scalar_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_opp(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let mut x1: u32 = 0;
    let mut x2: fiat_p384_scalar_u1 = 0;
    let (x1, x2) = fiat_p384_scalar_subborrowx_u32(0x0, (0x0 as u32), (arg1[0]));
    let mut x3: u32 = 0;
    let mut x4: fiat_p384_scalar_u1 = 0;
    let (x3, x4) = fiat_p384_scalar_subborrowx_u32(x2, (0x0 as u32), (arg1[1]));
    let mut x5: u32 = 0;
    let mut x6: fiat_p384_scalar_u1 = 0;
    let (x5, x6) = fiat_p384_scalar_subborrowx_u32(x4, (0x0 as u32), (arg1[2]));
    let mut x7: u32 = 0;
    let mut x8: fiat_p384_scalar_u1 = 0;
    let (x7, x8) = fiat_p384_scalar_subborrowx_u32(x6, (0x0 as u32), (arg1[3]));
    let mut x9: u32 = 0;
    let mut x10: fiat_p384_scalar_u1 = 0;
    let (x9, x10) = fiat_p384_scalar_subborrowx_u32(x8, (0x0 as u32), (arg1[4]));
    let mut x11: u32 = 0;
    let mut x12: fiat_p384_scalar_u1 = 0;
    let (x11, x12) = fiat_p384_scalar_subborrowx_u32(x10, (0x0 as u32), (arg1[5]));
    let mut x13: u32 = 0;
    let mut x14: fiat_p384_scalar_u1 = 0;
    let (x13, x14) = fiat_p384_scalar_subborrowx_u32(x12, (0x0 as u32), (arg1[6]));
    let mut x15: u32 = 0;
    let mut x16: fiat_p384_scalar_u1 = 0;
    let (x15, x16) = fiat_p384_scalar_subborrowx_u32(x14, (0x0 as u32), (arg1[7]));
    let mut x17: u32 = 0;
    let mut x18: fiat_p384_scalar_u1 = 0;
    let (x17, x18) = fiat_p384_scalar_subborrowx_u32(x16, (0x0 as u32), (arg1[8]));
    let mut x19: u32 = 0;
    let mut x20: fiat_p384_scalar_u1 = 0;
    let (x19, x20) = fiat_p384_scalar_subborrowx_u32(x18, (0x0 as u32), (arg1[9]));
    let mut x21: u32 = 0;
    let mut x22: fiat_p384_scalar_u1 = 0;
    let (x21, x22) = fiat_p384_scalar_subborrowx_u32(x20, (0x0 as u32), (arg1[10]));
    let mut x23: u32 = 0;
    let mut x24: fiat_p384_scalar_u1 = 0;
    let (x23, x24) = fiat_p384_scalar_subborrowx_u32(x22, (0x0 as u32), (arg1[11]));
    let mut x25: u32 = 0;
    let (x25) = fiat_p384_scalar_cmovznz_u32(x24, (0x0 as u32), 0xffffffff);
    let mut x26: u32 = 0;
    let mut x27: fiat_p384_scalar_u1 = 0;
    let (x26, x27) = fiat_p384_scalar_addcarryx_u32(0x0, x1, (x25 & 0xccc52973));
    let mut x28: u32 = 0;
    let mut x29: fiat_p384_scalar_u1 = 0;
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(x27, x3, (x25 & 0xecec196a));
    let mut x30: u32 = 0;
    let mut x31: fiat_p384_scalar_u1 = 0;
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, x5, (x25 & 0x48b0a77a));
    let mut x32: u32 = 0;
    let mut x33: fiat_p384_scalar_u1 = 0;
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, x7, (x25 & 0x581a0db2));
    let mut x34: u32 = 0;
    let mut x35: fiat_p384_scalar_u1 = 0;
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, x9, (x25 & 0xf4372ddf));
    let mut x36: u32 = 0;
    let mut x37: fiat_p384_scalar_u1 = 0;
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, x11, (x25 & 0xc7634d81));
    let mut x38: u32 = 0;
    let mut x39: fiat_p384_scalar_u1 = 0;
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, x13, x25);
    let mut x40: u32 = 0;
    let mut x41: fiat_p384_scalar_u1 = 0;
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, x15, x25);
    let mut x42: u32 = 0;
    let mut x43: fiat_p384_scalar_u1 = 0;
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, x17, x25);
    let mut x44: u32 = 0;
    let mut x45: fiat_p384_scalar_u1 = 0;
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, x19, x25);
    let mut x46: u32 = 0;
    let mut x47: fiat_p384_scalar_u1 = 0;
    let (x46, x47) = fiat_p384_scalar_addcarryx_u32(x45, x21, x25);
    let mut x48: u32 = 0;
    let mut x49: fiat_p384_scalar_u1 = 0;
    let (x48, x49) = fiat_p384_scalar_addcarryx_u32(x47, x23, x25);
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
    out1
}
#[doc = " The function fiat_p384_scalar_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_from_montgomery(
    arg1: &fiat_p384_scalar_montgomery_domain_field_element,
) -> fiat_p384_scalar_non_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_non_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[0]);
    let mut x2: u32 = 0;
    let mut x3: u32 = 0;
    let (x2, x3) = fiat_p384_scalar_mulx_u32(x1, 0xe88fdc45);
    let mut x4: u32 = 0;
    let mut x5: u32 = 0;
    let (x4, x5) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let mut x6: u32 = 0;
    let mut x7: u32 = 0;
    let (x6, x7) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let mut x8: u32 = 0;
    let mut x9: u32 = 0;
    let (x8, x9) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let mut x10: u32 = 0;
    let mut x11: u32 = 0;
    let (x10, x11) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let mut x12: u32 = 0;
    let mut x13: u32 = 0;
    let (x12, x13) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let mut x14: u32 = 0;
    let mut x15: u32 = 0;
    let (x14, x15) = fiat_p384_scalar_mulx_u32(x2, 0xffffffff);
    let mut x16: u32 = 0;
    let mut x17: u32 = 0;
    let (x16, x17) = fiat_p384_scalar_mulx_u32(x2, 0xc7634d81);
    let mut x18: u32 = 0;
    let mut x19: u32 = 0;
    let (x18, x19) = fiat_p384_scalar_mulx_u32(x2, 0xf4372ddf);
    let mut x20: u32 = 0;
    let mut x21: u32 = 0;
    let (x20, x21) = fiat_p384_scalar_mulx_u32(x2, 0x581a0db2);
    let mut x22: u32 = 0;
    let mut x23: u32 = 0;
    let (x22, x23) = fiat_p384_scalar_mulx_u32(x2, 0x48b0a77a);
    let mut x24: u32 = 0;
    let mut x25: u32 = 0;
    let (x24, x25) = fiat_p384_scalar_mulx_u32(x2, 0xecec196a);
    let mut x26: u32 = 0;
    let mut x27: u32 = 0;
    let (x26, x27) = fiat_p384_scalar_mulx_u32(x2, 0xccc52973);
    let mut x28: u32 = 0;
    let mut x29: fiat_p384_scalar_u1 = 0;
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(0x0, x27, x24);
    let mut x30: u32 = 0;
    let mut x31: fiat_p384_scalar_u1 = 0;
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, x25, x22);
    let mut x32: u32 = 0;
    let mut x33: fiat_p384_scalar_u1 = 0;
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, x23, x20);
    let mut x34: u32 = 0;
    let mut x35: fiat_p384_scalar_u1 = 0;
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, x21, x18);
    let mut x36: u32 = 0;
    let mut x37: fiat_p384_scalar_u1 = 0;
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, x19, x16);
    let mut x38: u32 = 0;
    let mut x39: fiat_p384_scalar_u1 = 0;
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, x17, x14);
    let mut x40: u32 = 0;
    let mut x41: fiat_p384_scalar_u1 = 0;
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, x15, x12);
    let mut x42: u32 = 0;
    let mut x43: fiat_p384_scalar_u1 = 0;
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, x13, x10);
    let mut x44: u32 = 0;
    let mut x45: fiat_p384_scalar_u1 = 0;
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, x11, x8);
    let mut x46: u32 = 0;
    let mut x47: fiat_p384_scalar_u1 = 0;
    let (x46, x47) = fiat_p384_scalar_addcarryx_u32(x45, x9, x6);
    let mut x48: u32 = 0;
    let mut x49: fiat_p384_scalar_u1 = 0;
    let (x48, x49) = fiat_p384_scalar_addcarryx_u32(x47, x7, x4);
    let mut x50: u32 = 0;
    let mut x51: fiat_p384_scalar_u1 = 0;
    let (x50, x51) = fiat_p384_scalar_addcarryx_u32(0x0, x1, x26);
    let mut x52: u32 = 0;
    let mut x53: fiat_p384_scalar_u1 = 0;
    let (x52, x53) = fiat_p384_scalar_addcarryx_u32(x51, (0x0 as u32), x28);
    let mut x54: u32 = 0;
    let mut x55: fiat_p384_scalar_u1 = 0;
    let (x54, x55) = fiat_p384_scalar_addcarryx_u32(x53, (0x0 as u32), x30);
    let mut x56: u32 = 0;
    let mut x57: fiat_p384_scalar_u1 = 0;
    let (x56, x57) = fiat_p384_scalar_addcarryx_u32(x55, (0x0 as u32), x32);
    let mut x58: u32 = 0;
    let mut x59: fiat_p384_scalar_u1 = 0;
    let (x58, x59) = fiat_p384_scalar_addcarryx_u32(x57, (0x0 as u32), x34);
    let mut x60: u32 = 0;
    let mut x61: fiat_p384_scalar_u1 = 0;
    let (x60, x61) = fiat_p384_scalar_addcarryx_u32(x59, (0x0 as u32), x36);
    let mut x62: u32 = 0;
    let mut x63: fiat_p384_scalar_u1 = 0;
    let (x62, x63) = fiat_p384_scalar_addcarryx_u32(x61, (0x0 as u32), x38);
    let mut x64: u32 = 0;
    let mut x65: fiat_p384_scalar_u1 = 0;
    let (x64, x65) = fiat_p384_scalar_addcarryx_u32(x63, (0x0 as u32), x40);
    let mut x66: u32 = 0;
    let mut x67: fiat_p384_scalar_u1 = 0;
    let (x66, x67) = fiat_p384_scalar_addcarryx_u32(x65, (0x0 as u32), x42);
    let mut x68: u32 = 0;
    let mut x69: fiat_p384_scalar_u1 = 0;
    let (x68, x69) = fiat_p384_scalar_addcarryx_u32(x67, (0x0 as u32), x44);
    let mut x70: u32 = 0;
    let mut x71: fiat_p384_scalar_u1 = 0;
    let (x70, x71) = fiat_p384_scalar_addcarryx_u32(x69, (0x0 as u32), x46);
    let mut x72: u32 = 0;
    let mut x73: fiat_p384_scalar_u1 = 0;
    let (x72, x73) = fiat_p384_scalar_addcarryx_u32(x71, (0x0 as u32), x48);
    let mut x74: u32 = 0;
    let mut x75: fiat_p384_scalar_u1 = 0;
    let (x74, x75) = fiat_p384_scalar_addcarryx_u32(x73, (0x0 as u32), ((x49 as u32) + x5));
    let mut x76: u32 = 0;
    let mut x77: fiat_p384_scalar_u1 = 0;
    let (x76, x77) = fiat_p384_scalar_addcarryx_u32(0x0, x52, (arg1[1]));
    let mut x78: u32 = 0;
    let mut x79: fiat_p384_scalar_u1 = 0;
    let (x78, x79) = fiat_p384_scalar_addcarryx_u32(x77, x54, (0x0 as u32));
    let mut x80: u32 = 0;
    let mut x81: fiat_p384_scalar_u1 = 0;
    let (x80, x81) = fiat_p384_scalar_addcarryx_u32(x79, x56, (0x0 as u32));
    let mut x82: u32 = 0;
    let mut x83: fiat_p384_scalar_u1 = 0;
    let (x82, x83) = fiat_p384_scalar_addcarryx_u32(x81, x58, (0x0 as u32));
    let mut x84: u32 = 0;
    let mut x85: fiat_p384_scalar_u1 = 0;
    let (x84, x85) = fiat_p384_scalar_addcarryx_u32(x83, x60, (0x0 as u32));
    let mut x86: u32 = 0;
    let mut x87: fiat_p384_scalar_u1 = 0;
    let (x86, x87) = fiat_p384_scalar_addcarryx_u32(x85, x62, (0x0 as u32));
    let mut x88: u32 = 0;
    let mut x89: fiat_p384_scalar_u1 = 0;
    let (x88, x89) = fiat_p384_scalar_addcarryx_u32(x87, x64, (0x0 as u32));
    let mut x90: u32 = 0;
    let mut x91: fiat_p384_scalar_u1 = 0;
    let (x90, x91) = fiat_p384_scalar_addcarryx_u32(x89, x66, (0x0 as u32));
    let mut x92: u32 = 0;
    let mut x93: fiat_p384_scalar_u1 = 0;
    let (x92, x93) = fiat_p384_scalar_addcarryx_u32(x91, x68, (0x0 as u32));
    let mut x94: u32 = 0;
    let mut x95: fiat_p384_scalar_u1 = 0;
    let (x94, x95) = fiat_p384_scalar_addcarryx_u32(x93, x70, (0x0 as u32));
    let mut x96: u32 = 0;
    let mut x97: fiat_p384_scalar_u1 = 0;
    let (x96, x97) = fiat_p384_scalar_addcarryx_u32(x95, x72, (0x0 as u32));
    let mut x98: u32 = 0;
    let mut x99: fiat_p384_scalar_u1 = 0;
    let (x98, x99) = fiat_p384_scalar_addcarryx_u32(x97, x74, (0x0 as u32));
    let mut x100: u32 = 0;
    let mut x101: u32 = 0;
    let (x100, x101) = fiat_p384_scalar_mulx_u32(x76, 0xe88fdc45);
    let mut x102: u32 = 0;
    let mut x103: u32 = 0;
    let (x102, x103) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let mut x104: u32 = 0;
    let mut x105: u32 = 0;
    let (x104, x105) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let mut x106: u32 = 0;
    let mut x107: u32 = 0;
    let (x106, x107) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let mut x108: u32 = 0;
    let mut x109: u32 = 0;
    let (x108, x109) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let mut x110: u32 = 0;
    let mut x111: u32 = 0;
    let (x110, x111) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let mut x112: u32 = 0;
    let mut x113: u32 = 0;
    let (x112, x113) = fiat_p384_scalar_mulx_u32(x100, 0xffffffff);
    let mut x114: u32 = 0;
    let mut x115: u32 = 0;
    let (x114, x115) = fiat_p384_scalar_mulx_u32(x100, 0xc7634d81);
    let mut x116: u32 = 0;
    let mut x117: u32 = 0;
    let (x116, x117) = fiat_p384_scalar_mulx_u32(x100, 0xf4372ddf);
    let mut x118: u32 = 0;
    let mut x119: u32 = 0;
    let (x118, x119) = fiat_p384_scalar_mulx_u32(x100, 0x581a0db2);
    let mut x120: u32 = 0;
    let mut x121: u32 = 0;
    let (x120, x121) = fiat_p384_scalar_mulx_u32(x100, 0x48b0a77a);
    let mut x122: u32 = 0;
    let mut x123: u32 = 0;
    let (x122, x123) = fiat_p384_scalar_mulx_u32(x100, 0xecec196a);
    let mut x124: u32 = 0;
    let mut x125: u32 = 0;
    let (x124, x125) = fiat_p384_scalar_mulx_u32(x100, 0xccc52973);
    let mut x126: u32 = 0;
    let mut x127: fiat_p384_scalar_u1 = 0;
    let (x126, x127) = fiat_p384_scalar_addcarryx_u32(0x0, x125, x122);
    let mut x128: u32 = 0;
    let mut x129: fiat_p384_scalar_u1 = 0;
    let (x128, x129) = fiat_p384_scalar_addcarryx_u32(x127, x123, x120);
    let mut x130: u32 = 0;
    let mut x131: fiat_p384_scalar_u1 = 0;
    let (x130, x131) = fiat_p384_scalar_addcarryx_u32(x129, x121, x118);
    let mut x132: u32 = 0;
    let mut x133: fiat_p384_scalar_u1 = 0;
    let (x132, x133) = fiat_p384_scalar_addcarryx_u32(x131, x119, x116);
    let mut x134: u32 = 0;
    let mut x135: fiat_p384_scalar_u1 = 0;
    let (x134, x135) = fiat_p384_scalar_addcarryx_u32(x133, x117, x114);
    let mut x136: u32 = 0;
    let mut x137: fiat_p384_scalar_u1 = 0;
    let (x136, x137) = fiat_p384_scalar_addcarryx_u32(x135, x115, x112);
    let mut x138: u32 = 0;
    let mut x139: fiat_p384_scalar_u1 = 0;
    let (x138, x139) = fiat_p384_scalar_addcarryx_u32(x137, x113, x110);
    let mut x140: u32 = 0;
    let mut x141: fiat_p384_scalar_u1 = 0;
    let (x140, x141) = fiat_p384_scalar_addcarryx_u32(x139, x111, x108);
    let mut x142: u32 = 0;
    let mut x143: fiat_p384_scalar_u1 = 0;
    let (x142, x143) = fiat_p384_scalar_addcarryx_u32(x141, x109, x106);
    let mut x144: u32 = 0;
    let mut x145: fiat_p384_scalar_u1 = 0;
    let (x144, x145) = fiat_p384_scalar_addcarryx_u32(x143, x107, x104);
    let mut x146: u32 = 0;
    let mut x147: fiat_p384_scalar_u1 = 0;
    let (x146, x147) = fiat_p384_scalar_addcarryx_u32(x145, x105, x102);
    let mut x148: u32 = 0;
    let mut x149: fiat_p384_scalar_u1 = 0;
    let (x148, x149) = fiat_p384_scalar_addcarryx_u32(0x0, x76, x124);
    let mut x150: u32 = 0;
    let mut x151: fiat_p384_scalar_u1 = 0;
    let (x150, x151) = fiat_p384_scalar_addcarryx_u32(x149, x78, x126);
    let mut x152: u32 = 0;
    let mut x153: fiat_p384_scalar_u1 = 0;
    let (x152, x153) = fiat_p384_scalar_addcarryx_u32(x151, x80, x128);
    let mut x154: u32 = 0;
    let mut x155: fiat_p384_scalar_u1 = 0;
    let (x154, x155) = fiat_p384_scalar_addcarryx_u32(x153, x82, x130);
    let mut x156: u32 = 0;
    let mut x157: fiat_p384_scalar_u1 = 0;
    let (x156, x157) = fiat_p384_scalar_addcarryx_u32(x155, x84, x132);
    let mut x158: u32 = 0;
    let mut x159: fiat_p384_scalar_u1 = 0;
    let (x158, x159) = fiat_p384_scalar_addcarryx_u32(x157, x86, x134);
    let mut x160: u32 = 0;
    let mut x161: fiat_p384_scalar_u1 = 0;
    let (x160, x161) = fiat_p384_scalar_addcarryx_u32(x159, x88, x136);
    let mut x162: u32 = 0;
    let mut x163: fiat_p384_scalar_u1 = 0;
    let (x162, x163) = fiat_p384_scalar_addcarryx_u32(x161, x90, x138);
    let mut x164: u32 = 0;
    let mut x165: fiat_p384_scalar_u1 = 0;
    let (x164, x165) = fiat_p384_scalar_addcarryx_u32(x163, x92, x140);
    let mut x166: u32 = 0;
    let mut x167: fiat_p384_scalar_u1 = 0;
    let (x166, x167) = fiat_p384_scalar_addcarryx_u32(x165, x94, x142);
    let mut x168: u32 = 0;
    let mut x169: fiat_p384_scalar_u1 = 0;
    let (x168, x169) = fiat_p384_scalar_addcarryx_u32(x167, x96, x144);
    let mut x170: u32 = 0;
    let mut x171: fiat_p384_scalar_u1 = 0;
    let (x170, x171) = fiat_p384_scalar_addcarryx_u32(x169, x98, x146);
    let mut x172: u32 = 0;
    let mut x173: fiat_p384_scalar_u1 = 0;
    let (x172, x173) =
        fiat_p384_scalar_addcarryx_u32(x171, ((x99 as u32) + (x75 as u32)), ((x147 as u32) + x103));
    let mut x174: u32 = 0;
    let mut x175: fiat_p384_scalar_u1 = 0;
    let (x174, x175) = fiat_p384_scalar_addcarryx_u32(0x0, x150, (arg1[2]));
    let mut x176: u32 = 0;
    let mut x177: fiat_p384_scalar_u1 = 0;
    let (x176, x177) = fiat_p384_scalar_addcarryx_u32(x175, x152, (0x0 as u32));
    let mut x178: u32 = 0;
    let mut x179: fiat_p384_scalar_u1 = 0;
    let (x178, x179) = fiat_p384_scalar_addcarryx_u32(x177, x154, (0x0 as u32));
    let mut x180: u32 = 0;
    let mut x181: fiat_p384_scalar_u1 = 0;
    let (x180, x181) = fiat_p384_scalar_addcarryx_u32(x179, x156, (0x0 as u32));
    let mut x182: u32 = 0;
    let mut x183: fiat_p384_scalar_u1 = 0;
    let (x182, x183) = fiat_p384_scalar_addcarryx_u32(x181, x158, (0x0 as u32));
    let mut x184: u32 = 0;
    let mut x185: fiat_p384_scalar_u1 = 0;
    let (x184, x185) = fiat_p384_scalar_addcarryx_u32(x183, x160, (0x0 as u32));
    let mut x186: u32 = 0;
    let mut x187: fiat_p384_scalar_u1 = 0;
    let (x186, x187) = fiat_p384_scalar_addcarryx_u32(x185, x162, (0x0 as u32));
    let mut x188: u32 = 0;
    let mut x189: fiat_p384_scalar_u1 = 0;
    let (x188, x189) = fiat_p384_scalar_addcarryx_u32(x187, x164, (0x0 as u32));
    let mut x190: u32 = 0;
    let mut x191: fiat_p384_scalar_u1 = 0;
    let (x190, x191) = fiat_p384_scalar_addcarryx_u32(x189, x166, (0x0 as u32));
    let mut x192: u32 = 0;
    let mut x193: fiat_p384_scalar_u1 = 0;
    let (x192, x193) = fiat_p384_scalar_addcarryx_u32(x191, x168, (0x0 as u32));
    let mut x194: u32 = 0;
    let mut x195: fiat_p384_scalar_u1 = 0;
    let (x194, x195) = fiat_p384_scalar_addcarryx_u32(x193, x170, (0x0 as u32));
    let mut x196: u32 = 0;
    let mut x197: fiat_p384_scalar_u1 = 0;
    let (x196, x197) = fiat_p384_scalar_addcarryx_u32(x195, x172, (0x0 as u32));
    let mut x198: u32 = 0;
    let mut x199: u32 = 0;
    let (x198, x199) = fiat_p384_scalar_mulx_u32(x174, 0xe88fdc45);
    let mut x200: u32 = 0;
    let mut x201: u32 = 0;
    let (x200, x201) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let mut x202: u32 = 0;
    let mut x203: u32 = 0;
    let (x202, x203) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let mut x204: u32 = 0;
    let mut x205: u32 = 0;
    let (x204, x205) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let mut x206: u32 = 0;
    let mut x207: u32 = 0;
    let (x206, x207) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let mut x208: u32 = 0;
    let mut x209: u32 = 0;
    let (x208, x209) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let mut x210: u32 = 0;
    let mut x211: u32 = 0;
    let (x210, x211) = fiat_p384_scalar_mulx_u32(x198, 0xffffffff);
    let mut x212: u32 = 0;
    let mut x213: u32 = 0;
    let (x212, x213) = fiat_p384_scalar_mulx_u32(x198, 0xc7634d81);
    let mut x214: u32 = 0;
    let mut x215: u32 = 0;
    let (x214, x215) = fiat_p384_scalar_mulx_u32(x198, 0xf4372ddf);
    let mut x216: u32 = 0;
    let mut x217: u32 = 0;
    let (x216, x217) = fiat_p384_scalar_mulx_u32(x198, 0x581a0db2);
    let mut x218: u32 = 0;
    let mut x219: u32 = 0;
    let (x218, x219) = fiat_p384_scalar_mulx_u32(x198, 0x48b0a77a);
    let mut x220: u32 = 0;
    let mut x221: u32 = 0;
    let (x220, x221) = fiat_p384_scalar_mulx_u32(x198, 0xecec196a);
    let mut x222: u32 = 0;
    let mut x223: u32 = 0;
    let (x222, x223) = fiat_p384_scalar_mulx_u32(x198, 0xccc52973);
    let mut x224: u32 = 0;
    let mut x225: fiat_p384_scalar_u1 = 0;
    let (x224, x225) = fiat_p384_scalar_addcarryx_u32(0x0, x223, x220);
    let mut x226: u32 = 0;
    let mut x227: fiat_p384_scalar_u1 = 0;
    let (x226, x227) = fiat_p384_scalar_addcarryx_u32(x225, x221, x218);
    let mut x228: u32 = 0;
    let mut x229: fiat_p384_scalar_u1 = 0;
    let (x228, x229) = fiat_p384_scalar_addcarryx_u32(x227, x219, x216);
    let mut x230: u32 = 0;
    let mut x231: fiat_p384_scalar_u1 = 0;
    let (x230, x231) = fiat_p384_scalar_addcarryx_u32(x229, x217, x214);
    let mut x232: u32 = 0;
    let mut x233: fiat_p384_scalar_u1 = 0;
    let (x232, x233) = fiat_p384_scalar_addcarryx_u32(x231, x215, x212);
    let mut x234: u32 = 0;
    let mut x235: fiat_p384_scalar_u1 = 0;
    let (x234, x235) = fiat_p384_scalar_addcarryx_u32(x233, x213, x210);
    let mut x236: u32 = 0;
    let mut x237: fiat_p384_scalar_u1 = 0;
    let (x236, x237) = fiat_p384_scalar_addcarryx_u32(x235, x211, x208);
    let mut x238: u32 = 0;
    let mut x239: fiat_p384_scalar_u1 = 0;
    let (x238, x239) = fiat_p384_scalar_addcarryx_u32(x237, x209, x206);
    let mut x240: u32 = 0;
    let mut x241: fiat_p384_scalar_u1 = 0;
    let (x240, x241) = fiat_p384_scalar_addcarryx_u32(x239, x207, x204);
    let mut x242: u32 = 0;
    let mut x243: fiat_p384_scalar_u1 = 0;
    let (x242, x243) = fiat_p384_scalar_addcarryx_u32(x241, x205, x202);
    let mut x244: u32 = 0;
    let mut x245: fiat_p384_scalar_u1 = 0;
    let (x244, x245) = fiat_p384_scalar_addcarryx_u32(x243, x203, x200);
    let mut x246: u32 = 0;
    let mut x247: fiat_p384_scalar_u1 = 0;
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(0x0, x174, x222);
    let mut x248: u32 = 0;
    let mut x249: fiat_p384_scalar_u1 = 0;
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x176, x224);
    let mut x250: u32 = 0;
    let mut x251: fiat_p384_scalar_u1 = 0;
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x178, x226);
    let mut x252: u32 = 0;
    let mut x253: fiat_p384_scalar_u1 = 0;
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x180, x228);
    let mut x254: u32 = 0;
    let mut x255: fiat_p384_scalar_u1 = 0;
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x182, x230);
    let mut x256: u32 = 0;
    let mut x257: fiat_p384_scalar_u1 = 0;
    let (x256, x257) = fiat_p384_scalar_addcarryx_u32(x255, x184, x232);
    let mut x258: u32 = 0;
    let mut x259: fiat_p384_scalar_u1 = 0;
    let (x258, x259) = fiat_p384_scalar_addcarryx_u32(x257, x186, x234);
    let mut x260: u32 = 0;
    let mut x261: fiat_p384_scalar_u1 = 0;
    let (x260, x261) = fiat_p384_scalar_addcarryx_u32(x259, x188, x236);
    let mut x262: u32 = 0;
    let mut x263: fiat_p384_scalar_u1 = 0;
    let (x262, x263) = fiat_p384_scalar_addcarryx_u32(x261, x190, x238);
    let mut x264: u32 = 0;
    let mut x265: fiat_p384_scalar_u1 = 0;
    let (x264, x265) = fiat_p384_scalar_addcarryx_u32(x263, x192, x240);
    let mut x266: u32 = 0;
    let mut x267: fiat_p384_scalar_u1 = 0;
    let (x266, x267) = fiat_p384_scalar_addcarryx_u32(x265, x194, x242);
    let mut x268: u32 = 0;
    let mut x269: fiat_p384_scalar_u1 = 0;
    let (x268, x269) = fiat_p384_scalar_addcarryx_u32(x267, x196, x244);
    let mut x270: u32 = 0;
    let mut x271: fiat_p384_scalar_u1 = 0;
    let (x270, x271) = fiat_p384_scalar_addcarryx_u32(
        x269,
        ((x197 as u32) + (x173 as u32)),
        ((x245 as u32) + x201),
    );
    let mut x272: u32 = 0;
    let mut x273: fiat_p384_scalar_u1 = 0;
    let (x272, x273) = fiat_p384_scalar_addcarryx_u32(0x0, x248, (arg1[3]));
    let mut x274: u32 = 0;
    let mut x275: fiat_p384_scalar_u1 = 0;
    let (x274, x275) = fiat_p384_scalar_addcarryx_u32(x273, x250, (0x0 as u32));
    let mut x276: u32 = 0;
    let mut x277: fiat_p384_scalar_u1 = 0;
    let (x276, x277) = fiat_p384_scalar_addcarryx_u32(x275, x252, (0x0 as u32));
    let mut x278: u32 = 0;
    let mut x279: fiat_p384_scalar_u1 = 0;
    let (x278, x279) = fiat_p384_scalar_addcarryx_u32(x277, x254, (0x0 as u32));
    let mut x280: u32 = 0;
    let mut x281: fiat_p384_scalar_u1 = 0;
    let (x280, x281) = fiat_p384_scalar_addcarryx_u32(x279, x256, (0x0 as u32));
    let mut x282: u32 = 0;
    let mut x283: fiat_p384_scalar_u1 = 0;
    let (x282, x283) = fiat_p384_scalar_addcarryx_u32(x281, x258, (0x0 as u32));
    let mut x284: u32 = 0;
    let mut x285: fiat_p384_scalar_u1 = 0;
    let (x284, x285) = fiat_p384_scalar_addcarryx_u32(x283, x260, (0x0 as u32));
    let mut x286: u32 = 0;
    let mut x287: fiat_p384_scalar_u1 = 0;
    let (x286, x287) = fiat_p384_scalar_addcarryx_u32(x285, x262, (0x0 as u32));
    let mut x288: u32 = 0;
    let mut x289: fiat_p384_scalar_u1 = 0;
    let (x288, x289) = fiat_p384_scalar_addcarryx_u32(x287, x264, (0x0 as u32));
    let mut x290: u32 = 0;
    let mut x291: fiat_p384_scalar_u1 = 0;
    let (x290, x291) = fiat_p384_scalar_addcarryx_u32(x289, x266, (0x0 as u32));
    let mut x292: u32 = 0;
    let mut x293: fiat_p384_scalar_u1 = 0;
    let (x292, x293) = fiat_p384_scalar_addcarryx_u32(x291, x268, (0x0 as u32));
    let mut x294: u32 = 0;
    let mut x295: fiat_p384_scalar_u1 = 0;
    let (x294, x295) = fiat_p384_scalar_addcarryx_u32(x293, x270, (0x0 as u32));
    let mut x296: u32 = 0;
    let mut x297: u32 = 0;
    let (x296, x297) = fiat_p384_scalar_mulx_u32(x272, 0xe88fdc45);
    let mut x298: u32 = 0;
    let mut x299: u32 = 0;
    let (x298, x299) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let mut x300: u32 = 0;
    let mut x301: u32 = 0;
    let (x300, x301) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let mut x302: u32 = 0;
    let mut x303: u32 = 0;
    let (x302, x303) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let mut x304: u32 = 0;
    let mut x305: u32 = 0;
    let (x304, x305) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let mut x306: u32 = 0;
    let mut x307: u32 = 0;
    let (x306, x307) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let mut x308: u32 = 0;
    let mut x309: u32 = 0;
    let (x308, x309) = fiat_p384_scalar_mulx_u32(x296, 0xffffffff);
    let mut x310: u32 = 0;
    let mut x311: u32 = 0;
    let (x310, x311) = fiat_p384_scalar_mulx_u32(x296, 0xc7634d81);
    let mut x312: u32 = 0;
    let mut x313: u32 = 0;
    let (x312, x313) = fiat_p384_scalar_mulx_u32(x296, 0xf4372ddf);
    let mut x314: u32 = 0;
    let mut x315: u32 = 0;
    let (x314, x315) = fiat_p384_scalar_mulx_u32(x296, 0x581a0db2);
    let mut x316: u32 = 0;
    let mut x317: u32 = 0;
    let (x316, x317) = fiat_p384_scalar_mulx_u32(x296, 0x48b0a77a);
    let mut x318: u32 = 0;
    let mut x319: u32 = 0;
    let (x318, x319) = fiat_p384_scalar_mulx_u32(x296, 0xecec196a);
    let mut x320: u32 = 0;
    let mut x321: u32 = 0;
    let (x320, x321) = fiat_p384_scalar_mulx_u32(x296, 0xccc52973);
    let mut x322: u32 = 0;
    let mut x323: fiat_p384_scalar_u1 = 0;
    let (x322, x323) = fiat_p384_scalar_addcarryx_u32(0x0, x321, x318);
    let mut x324: u32 = 0;
    let mut x325: fiat_p384_scalar_u1 = 0;
    let (x324, x325) = fiat_p384_scalar_addcarryx_u32(x323, x319, x316);
    let mut x326: u32 = 0;
    let mut x327: fiat_p384_scalar_u1 = 0;
    let (x326, x327) = fiat_p384_scalar_addcarryx_u32(x325, x317, x314);
    let mut x328: u32 = 0;
    let mut x329: fiat_p384_scalar_u1 = 0;
    let (x328, x329) = fiat_p384_scalar_addcarryx_u32(x327, x315, x312);
    let mut x330: u32 = 0;
    let mut x331: fiat_p384_scalar_u1 = 0;
    let (x330, x331) = fiat_p384_scalar_addcarryx_u32(x329, x313, x310);
    let mut x332: u32 = 0;
    let mut x333: fiat_p384_scalar_u1 = 0;
    let (x332, x333) = fiat_p384_scalar_addcarryx_u32(x331, x311, x308);
    let mut x334: u32 = 0;
    let mut x335: fiat_p384_scalar_u1 = 0;
    let (x334, x335) = fiat_p384_scalar_addcarryx_u32(x333, x309, x306);
    let mut x336: u32 = 0;
    let mut x337: fiat_p384_scalar_u1 = 0;
    let (x336, x337) = fiat_p384_scalar_addcarryx_u32(x335, x307, x304);
    let mut x338: u32 = 0;
    let mut x339: fiat_p384_scalar_u1 = 0;
    let (x338, x339) = fiat_p384_scalar_addcarryx_u32(x337, x305, x302);
    let mut x340: u32 = 0;
    let mut x341: fiat_p384_scalar_u1 = 0;
    let (x340, x341) = fiat_p384_scalar_addcarryx_u32(x339, x303, x300);
    let mut x342: u32 = 0;
    let mut x343: fiat_p384_scalar_u1 = 0;
    let (x342, x343) = fiat_p384_scalar_addcarryx_u32(x341, x301, x298);
    let mut x344: u32 = 0;
    let mut x345: fiat_p384_scalar_u1 = 0;
    let (x344, x345) = fiat_p384_scalar_addcarryx_u32(0x0, x272, x320);
    let mut x346: u32 = 0;
    let mut x347: fiat_p384_scalar_u1 = 0;
    let (x346, x347) = fiat_p384_scalar_addcarryx_u32(x345, x274, x322);
    let mut x348: u32 = 0;
    let mut x349: fiat_p384_scalar_u1 = 0;
    let (x348, x349) = fiat_p384_scalar_addcarryx_u32(x347, x276, x324);
    let mut x350: u32 = 0;
    let mut x351: fiat_p384_scalar_u1 = 0;
    let (x350, x351) = fiat_p384_scalar_addcarryx_u32(x349, x278, x326);
    let mut x352: u32 = 0;
    let mut x353: fiat_p384_scalar_u1 = 0;
    let (x352, x353) = fiat_p384_scalar_addcarryx_u32(x351, x280, x328);
    let mut x354: u32 = 0;
    let mut x355: fiat_p384_scalar_u1 = 0;
    let (x354, x355) = fiat_p384_scalar_addcarryx_u32(x353, x282, x330);
    let mut x356: u32 = 0;
    let mut x357: fiat_p384_scalar_u1 = 0;
    let (x356, x357) = fiat_p384_scalar_addcarryx_u32(x355, x284, x332);
    let mut x358: u32 = 0;
    let mut x359: fiat_p384_scalar_u1 = 0;
    let (x358, x359) = fiat_p384_scalar_addcarryx_u32(x357, x286, x334);
    let mut x360: u32 = 0;
    let mut x361: fiat_p384_scalar_u1 = 0;
    let (x360, x361) = fiat_p384_scalar_addcarryx_u32(x359, x288, x336);
    let mut x362: u32 = 0;
    let mut x363: fiat_p384_scalar_u1 = 0;
    let (x362, x363) = fiat_p384_scalar_addcarryx_u32(x361, x290, x338);
    let mut x364: u32 = 0;
    let mut x365: fiat_p384_scalar_u1 = 0;
    let (x364, x365) = fiat_p384_scalar_addcarryx_u32(x363, x292, x340);
    let mut x366: u32 = 0;
    let mut x367: fiat_p384_scalar_u1 = 0;
    let (x366, x367) = fiat_p384_scalar_addcarryx_u32(x365, x294, x342);
    let mut x368: u32 = 0;
    let mut x369: fiat_p384_scalar_u1 = 0;
    let (x368, x369) = fiat_p384_scalar_addcarryx_u32(
        x367,
        ((x295 as u32) + (x271 as u32)),
        ((x343 as u32) + x299),
    );
    let mut x370: u32 = 0;
    let mut x371: fiat_p384_scalar_u1 = 0;
    let (x370, x371) = fiat_p384_scalar_addcarryx_u32(0x0, x346, (arg1[4]));
    let mut x372: u32 = 0;
    let mut x373: fiat_p384_scalar_u1 = 0;
    let (x372, x373) = fiat_p384_scalar_addcarryx_u32(x371, x348, (0x0 as u32));
    let mut x374: u32 = 0;
    let mut x375: fiat_p384_scalar_u1 = 0;
    let (x374, x375) = fiat_p384_scalar_addcarryx_u32(x373, x350, (0x0 as u32));
    let mut x376: u32 = 0;
    let mut x377: fiat_p384_scalar_u1 = 0;
    let (x376, x377) = fiat_p384_scalar_addcarryx_u32(x375, x352, (0x0 as u32));
    let mut x378: u32 = 0;
    let mut x379: fiat_p384_scalar_u1 = 0;
    let (x378, x379) = fiat_p384_scalar_addcarryx_u32(x377, x354, (0x0 as u32));
    let mut x380: u32 = 0;
    let mut x381: fiat_p384_scalar_u1 = 0;
    let (x380, x381) = fiat_p384_scalar_addcarryx_u32(x379, x356, (0x0 as u32));
    let mut x382: u32 = 0;
    let mut x383: fiat_p384_scalar_u1 = 0;
    let (x382, x383) = fiat_p384_scalar_addcarryx_u32(x381, x358, (0x0 as u32));
    let mut x384: u32 = 0;
    let mut x385: fiat_p384_scalar_u1 = 0;
    let (x384, x385) = fiat_p384_scalar_addcarryx_u32(x383, x360, (0x0 as u32));
    let mut x386: u32 = 0;
    let mut x387: fiat_p384_scalar_u1 = 0;
    let (x386, x387) = fiat_p384_scalar_addcarryx_u32(x385, x362, (0x0 as u32));
    let mut x388: u32 = 0;
    let mut x389: fiat_p384_scalar_u1 = 0;
    let (x388, x389) = fiat_p384_scalar_addcarryx_u32(x387, x364, (0x0 as u32));
    let mut x390: u32 = 0;
    let mut x391: fiat_p384_scalar_u1 = 0;
    let (x390, x391) = fiat_p384_scalar_addcarryx_u32(x389, x366, (0x0 as u32));
    let mut x392: u32 = 0;
    let mut x393: fiat_p384_scalar_u1 = 0;
    let (x392, x393) = fiat_p384_scalar_addcarryx_u32(x391, x368, (0x0 as u32));
    let mut x394: u32 = 0;
    let mut x395: u32 = 0;
    let (x394, x395) = fiat_p384_scalar_mulx_u32(x370, 0xe88fdc45);
    let mut x396: u32 = 0;
    let mut x397: u32 = 0;
    let (x396, x397) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let mut x398: u32 = 0;
    let mut x399: u32 = 0;
    let (x398, x399) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let mut x400: u32 = 0;
    let mut x401: u32 = 0;
    let (x400, x401) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let mut x402: u32 = 0;
    let mut x403: u32 = 0;
    let (x402, x403) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let mut x404: u32 = 0;
    let mut x405: u32 = 0;
    let (x404, x405) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let mut x406: u32 = 0;
    let mut x407: u32 = 0;
    let (x406, x407) = fiat_p384_scalar_mulx_u32(x394, 0xffffffff);
    let mut x408: u32 = 0;
    let mut x409: u32 = 0;
    let (x408, x409) = fiat_p384_scalar_mulx_u32(x394, 0xc7634d81);
    let mut x410: u32 = 0;
    let mut x411: u32 = 0;
    let (x410, x411) = fiat_p384_scalar_mulx_u32(x394, 0xf4372ddf);
    let mut x412: u32 = 0;
    let mut x413: u32 = 0;
    let (x412, x413) = fiat_p384_scalar_mulx_u32(x394, 0x581a0db2);
    let mut x414: u32 = 0;
    let mut x415: u32 = 0;
    let (x414, x415) = fiat_p384_scalar_mulx_u32(x394, 0x48b0a77a);
    let mut x416: u32 = 0;
    let mut x417: u32 = 0;
    let (x416, x417) = fiat_p384_scalar_mulx_u32(x394, 0xecec196a);
    let mut x418: u32 = 0;
    let mut x419: u32 = 0;
    let (x418, x419) = fiat_p384_scalar_mulx_u32(x394, 0xccc52973);
    let mut x420: u32 = 0;
    let mut x421: fiat_p384_scalar_u1 = 0;
    let (x420, x421) = fiat_p384_scalar_addcarryx_u32(0x0, x419, x416);
    let mut x422: u32 = 0;
    let mut x423: fiat_p384_scalar_u1 = 0;
    let (x422, x423) = fiat_p384_scalar_addcarryx_u32(x421, x417, x414);
    let mut x424: u32 = 0;
    let mut x425: fiat_p384_scalar_u1 = 0;
    let (x424, x425) = fiat_p384_scalar_addcarryx_u32(x423, x415, x412);
    let mut x426: u32 = 0;
    let mut x427: fiat_p384_scalar_u1 = 0;
    let (x426, x427) = fiat_p384_scalar_addcarryx_u32(x425, x413, x410);
    let mut x428: u32 = 0;
    let mut x429: fiat_p384_scalar_u1 = 0;
    let (x428, x429) = fiat_p384_scalar_addcarryx_u32(x427, x411, x408);
    let mut x430: u32 = 0;
    let mut x431: fiat_p384_scalar_u1 = 0;
    let (x430, x431) = fiat_p384_scalar_addcarryx_u32(x429, x409, x406);
    let mut x432: u32 = 0;
    let mut x433: fiat_p384_scalar_u1 = 0;
    let (x432, x433) = fiat_p384_scalar_addcarryx_u32(x431, x407, x404);
    let mut x434: u32 = 0;
    let mut x435: fiat_p384_scalar_u1 = 0;
    let (x434, x435) = fiat_p384_scalar_addcarryx_u32(x433, x405, x402);
    let mut x436: u32 = 0;
    let mut x437: fiat_p384_scalar_u1 = 0;
    let (x436, x437) = fiat_p384_scalar_addcarryx_u32(x435, x403, x400);
    let mut x438: u32 = 0;
    let mut x439: fiat_p384_scalar_u1 = 0;
    let (x438, x439) = fiat_p384_scalar_addcarryx_u32(x437, x401, x398);
    let mut x440: u32 = 0;
    let mut x441: fiat_p384_scalar_u1 = 0;
    let (x440, x441) = fiat_p384_scalar_addcarryx_u32(x439, x399, x396);
    let mut x442: u32 = 0;
    let mut x443: fiat_p384_scalar_u1 = 0;
    let (x442, x443) = fiat_p384_scalar_addcarryx_u32(0x0, x370, x418);
    let mut x444: u32 = 0;
    let mut x445: fiat_p384_scalar_u1 = 0;
    let (x444, x445) = fiat_p384_scalar_addcarryx_u32(x443, x372, x420);
    let mut x446: u32 = 0;
    let mut x447: fiat_p384_scalar_u1 = 0;
    let (x446, x447) = fiat_p384_scalar_addcarryx_u32(x445, x374, x422);
    let mut x448: u32 = 0;
    let mut x449: fiat_p384_scalar_u1 = 0;
    let (x448, x449) = fiat_p384_scalar_addcarryx_u32(x447, x376, x424);
    let mut x450: u32 = 0;
    let mut x451: fiat_p384_scalar_u1 = 0;
    let (x450, x451) = fiat_p384_scalar_addcarryx_u32(x449, x378, x426);
    let mut x452: u32 = 0;
    let mut x453: fiat_p384_scalar_u1 = 0;
    let (x452, x453) = fiat_p384_scalar_addcarryx_u32(x451, x380, x428);
    let mut x454: u32 = 0;
    let mut x455: fiat_p384_scalar_u1 = 0;
    let (x454, x455) = fiat_p384_scalar_addcarryx_u32(x453, x382, x430);
    let mut x456: u32 = 0;
    let mut x457: fiat_p384_scalar_u1 = 0;
    let (x456, x457) = fiat_p384_scalar_addcarryx_u32(x455, x384, x432);
    let mut x458: u32 = 0;
    let mut x459: fiat_p384_scalar_u1 = 0;
    let (x458, x459) = fiat_p384_scalar_addcarryx_u32(x457, x386, x434);
    let mut x460: u32 = 0;
    let mut x461: fiat_p384_scalar_u1 = 0;
    let (x460, x461) = fiat_p384_scalar_addcarryx_u32(x459, x388, x436);
    let mut x462: u32 = 0;
    let mut x463: fiat_p384_scalar_u1 = 0;
    let (x462, x463) = fiat_p384_scalar_addcarryx_u32(x461, x390, x438);
    let mut x464: u32 = 0;
    let mut x465: fiat_p384_scalar_u1 = 0;
    let (x464, x465) = fiat_p384_scalar_addcarryx_u32(x463, x392, x440);
    let mut x466: u32 = 0;
    let mut x467: fiat_p384_scalar_u1 = 0;
    let (x466, x467) = fiat_p384_scalar_addcarryx_u32(
        x465,
        ((x393 as u32) + (x369 as u32)),
        ((x441 as u32) + x397),
    );
    let mut x468: u32 = 0;
    let mut x469: fiat_p384_scalar_u1 = 0;
    let (x468, x469) = fiat_p384_scalar_addcarryx_u32(0x0, x444, (arg1[5]));
    let mut x470: u32 = 0;
    let mut x471: fiat_p384_scalar_u1 = 0;
    let (x470, x471) = fiat_p384_scalar_addcarryx_u32(x469, x446, (0x0 as u32));
    let mut x472: u32 = 0;
    let mut x473: fiat_p384_scalar_u1 = 0;
    let (x472, x473) = fiat_p384_scalar_addcarryx_u32(x471, x448, (0x0 as u32));
    let mut x474: u32 = 0;
    let mut x475: fiat_p384_scalar_u1 = 0;
    let (x474, x475) = fiat_p384_scalar_addcarryx_u32(x473, x450, (0x0 as u32));
    let mut x476: u32 = 0;
    let mut x477: fiat_p384_scalar_u1 = 0;
    let (x476, x477) = fiat_p384_scalar_addcarryx_u32(x475, x452, (0x0 as u32));
    let mut x478: u32 = 0;
    let mut x479: fiat_p384_scalar_u1 = 0;
    let (x478, x479) = fiat_p384_scalar_addcarryx_u32(x477, x454, (0x0 as u32));
    let mut x480: u32 = 0;
    let mut x481: fiat_p384_scalar_u1 = 0;
    let (x480, x481) = fiat_p384_scalar_addcarryx_u32(x479, x456, (0x0 as u32));
    let mut x482: u32 = 0;
    let mut x483: fiat_p384_scalar_u1 = 0;
    let (x482, x483) = fiat_p384_scalar_addcarryx_u32(x481, x458, (0x0 as u32));
    let mut x484: u32 = 0;
    let mut x485: fiat_p384_scalar_u1 = 0;
    let (x484, x485) = fiat_p384_scalar_addcarryx_u32(x483, x460, (0x0 as u32));
    let mut x486: u32 = 0;
    let mut x487: fiat_p384_scalar_u1 = 0;
    let (x486, x487) = fiat_p384_scalar_addcarryx_u32(x485, x462, (0x0 as u32));
    let mut x488: u32 = 0;
    let mut x489: fiat_p384_scalar_u1 = 0;
    let (x488, x489) = fiat_p384_scalar_addcarryx_u32(x487, x464, (0x0 as u32));
    let mut x490: u32 = 0;
    let mut x491: fiat_p384_scalar_u1 = 0;
    let (x490, x491) = fiat_p384_scalar_addcarryx_u32(x489, x466, (0x0 as u32));
    let mut x492: u32 = 0;
    let mut x493: u32 = 0;
    let (x492, x493) = fiat_p384_scalar_mulx_u32(x468, 0xe88fdc45);
    let mut x494: u32 = 0;
    let mut x495: u32 = 0;
    let (x494, x495) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let mut x496: u32 = 0;
    let mut x497: u32 = 0;
    let (x496, x497) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let mut x498: u32 = 0;
    let mut x499: u32 = 0;
    let (x498, x499) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let mut x500: u32 = 0;
    let mut x501: u32 = 0;
    let (x500, x501) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let mut x502: u32 = 0;
    let mut x503: u32 = 0;
    let (x502, x503) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let mut x504: u32 = 0;
    let mut x505: u32 = 0;
    let (x504, x505) = fiat_p384_scalar_mulx_u32(x492, 0xffffffff);
    let mut x506: u32 = 0;
    let mut x507: u32 = 0;
    let (x506, x507) = fiat_p384_scalar_mulx_u32(x492, 0xc7634d81);
    let mut x508: u32 = 0;
    let mut x509: u32 = 0;
    let (x508, x509) = fiat_p384_scalar_mulx_u32(x492, 0xf4372ddf);
    let mut x510: u32 = 0;
    let mut x511: u32 = 0;
    let (x510, x511) = fiat_p384_scalar_mulx_u32(x492, 0x581a0db2);
    let mut x512: u32 = 0;
    let mut x513: u32 = 0;
    let (x512, x513) = fiat_p384_scalar_mulx_u32(x492, 0x48b0a77a);
    let mut x514: u32 = 0;
    let mut x515: u32 = 0;
    let (x514, x515) = fiat_p384_scalar_mulx_u32(x492, 0xecec196a);
    let mut x516: u32 = 0;
    let mut x517: u32 = 0;
    let (x516, x517) = fiat_p384_scalar_mulx_u32(x492, 0xccc52973);
    let mut x518: u32 = 0;
    let mut x519: fiat_p384_scalar_u1 = 0;
    let (x518, x519) = fiat_p384_scalar_addcarryx_u32(0x0, x517, x514);
    let mut x520: u32 = 0;
    let mut x521: fiat_p384_scalar_u1 = 0;
    let (x520, x521) = fiat_p384_scalar_addcarryx_u32(x519, x515, x512);
    let mut x522: u32 = 0;
    let mut x523: fiat_p384_scalar_u1 = 0;
    let (x522, x523) = fiat_p384_scalar_addcarryx_u32(x521, x513, x510);
    let mut x524: u32 = 0;
    let mut x525: fiat_p384_scalar_u1 = 0;
    let (x524, x525) = fiat_p384_scalar_addcarryx_u32(x523, x511, x508);
    let mut x526: u32 = 0;
    let mut x527: fiat_p384_scalar_u1 = 0;
    let (x526, x527) = fiat_p384_scalar_addcarryx_u32(x525, x509, x506);
    let mut x528: u32 = 0;
    let mut x529: fiat_p384_scalar_u1 = 0;
    let (x528, x529) = fiat_p384_scalar_addcarryx_u32(x527, x507, x504);
    let mut x530: u32 = 0;
    let mut x531: fiat_p384_scalar_u1 = 0;
    let (x530, x531) = fiat_p384_scalar_addcarryx_u32(x529, x505, x502);
    let mut x532: u32 = 0;
    let mut x533: fiat_p384_scalar_u1 = 0;
    let (x532, x533) = fiat_p384_scalar_addcarryx_u32(x531, x503, x500);
    let mut x534: u32 = 0;
    let mut x535: fiat_p384_scalar_u1 = 0;
    let (x534, x535) = fiat_p384_scalar_addcarryx_u32(x533, x501, x498);
    let mut x536: u32 = 0;
    let mut x537: fiat_p384_scalar_u1 = 0;
    let (x536, x537) = fiat_p384_scalar_addcarryx_u32(x535, x499, x496);
    let mut x538: u32 = 0;
    let mut x539: fiat_p384_scalar_u1 = 0;
    let (x538, x539) = fiat_p384_scalar_addcarryx_u32(x537, x497, x494);
    let mut x540: u32 = 0;
    let mut x541: fiat_p384_scalar_u1 = 0;
    let (x540, x541) = fiat_p384_scalar_addcarryx_u32(0x0, x468, x516);
    let mut x542: u32 = 0;
    let mut x543: fiat_p384_scalar_u1 = 0;
    let (x542, x543) = fiat_p384_scalar_addcarryx_u32(x541, x470, x518);
    let mut x544: u32 = 0;
    let mut x545: fiat_p384_scalar_u1 = 0;
    let (x544, x545) = fiat_p384_scalar_addcarryx_u32(x543, x472, x520);
    let mut x546: u32 = 0;
    let mut x547: fiat_p384_scalar_u1 = 0;
    let (x546, x547) = fiat_p384_scalar_addcarryx_u32(x545, x474, x522);
    let mut x548: u32 = 0;
    let mut x549: fiat_p384_scalar_u1 = 0;
    let (x548, x549) = fiat_p384_scalar_addcarryx_u32(x547, x476, x524);
    let mut x550: u32 = 0;
    let mut x551: fiat_p384_scalar_u1 = 0;
    let (x550, x551) = fiat_p384_scalar_addcarryx_u32(x549, x478, x526);
    let mut x552: u32 = 0;
    let mut x553: fiat_p384_scalar_u1 = 0;
    let (x552, x553) = fiat_p384_scalar_addcarryx_u32(x551, x480, x528);
    let mut x554: u32 = 0;
    let mut x555: fiat_p384_scalar_u1 = 0;
    let (x554, x555) = fiat_p384_scalar_addcarryx_u32(x553, x482, x530);
    let mut x556: u32 = 0;
    let mut x557: fiat_p384_scalar_u1 = 0;
    let (x556, x557) = fiat_p384_scalar_addcarryx_u32(x555, x484, x532);
    let mut x558: u32 = 0;
    let mut x559: fiat_p384_scalar_u1 = 0;
    let (x558, x559) = fiat_p384_scalar_addcarryx_u32(x557, x486, x534);
    let mut x560: u32 = 0;
    let mut x561: fiat_p384_scalar_u1 = 0;
    let (x560, x561) = fiat_p384_scalar_addcarryx_u32(x559, x488, x536);
    let mut x562: u32 = 0;
    let mut x563: fiat_p384_scalar_u1 = 0;
    let (x562, x563) = fiat_p384_scalar_addcarryx_u32(x561, x490, x538);
    let mut x564: u32 = 0;
    let mut x565: fiat_p384_scalar_u1 = 0;
    let (x564, x565) = fiat_p384_scalar_addcarryx_u32(
        x563,
        ((x491 as u32) + (x467 as u32)),
        ((x539 as u32) + x495),
    );
    let mut x566: u32 = 0;
    let mut x567: fiat_p384_scalar_u1 = 0;
    let (x566, x567) = fiat_p384_scalar_addcarryx_u32(0x0, x542, (arg1[6]));
    let mut x568: u32 = 0;
    let mut x569: fiat_p384_scalar_u1 = 0;
    let (x568, x569) = fiat_p384_scalar_addcarryx_u32(x567, x544, (0x0 as u32));
    let mut x570: u32 = 0;
    let mut x571: fiat_p384_scalar_u1 = 0;
    let (x570, x571) = fiat_p384_scalar_addcarryx_u32(x569, x546, (0x0 as u32));
    let mut x572: u32 = 0;
    let mut x573: fiat_p384_scalar_u1 = 0;
    let (x572, x573) = fiat_p384_scalar_addcarryx_u32(x571, x548, (0x0 as u32));
    let mut x574: u32 = 0;
    let mut x575: fiat_p384_scalar_u1 = 0;
    let (x574, x575) = fiat_p384_scalar_addcarryx_u32(x573, x550, (0x0 as u32));
    let mut x576: u32 = 0;
    let mut x577: fiat_p384_scalar_u1 = 0;
    let (x576, x577) = fiat_p384_scalar_addcarryx_u32(x575, x552, (0x0 as u32));
    let mut x578: u32 = 0;
    let mut x579: fiat_p384_scalar_u1 = 0;
    let (x578, x579) = fiat_p384_scalar_addcarryx_u32(x577, x554, (0x0 as u32));
    let mut x580: u32 = 0;
    let mut x581: fiat_p384_scalar_u1 = 0;
    let (x580, x581) = fiat_p384_scalar_addcarryx_u32(x579, x556, (0x0 as u32));
    let mut x582: u32 = 0;
    let mut x583: fiat_p384_scalar_u1 = 0;
    let (x582, x583) = fiat_p384_scalar_addcarryx_u32(x581, x558, (0x0 as u32));
    let mut x584: u32 = 0;
    let mut x585: fiat_p384_scalar_u1 = 0;
    let (x584, x585) = fiat_p384_scalar_addcarryx_u32(x583, x560, (0x0 as u32));
    let mut x586: u32 = 0;
    let mut x587: fiat_p384_scalar_u1 = 0;
    let (x586, x587) = fiat_p384_scalar_addcarryx_u32(x585, x562, (0x0 as u32));
    let mut x588: u32 = 0;
    let mut x589: fiat_p384_scalar_u1 = 0;
    let (x588, x589) = fiat_p384_scalar_addcarryx_u32(x587, x564, (0x0 as u32));
    let mut x590: u32 = 0;
    let mut x591: u32 = 0;
    let (x590, x591) = fiat_p384_scalar_mulx_u32(x566, 0xe88fdc45);
    let mut x592: u32 = 0;
    let mut x593: u32 = 0;
    let (x592, x593) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let mut x594: u32 = 0;
    let mut x595: u32 = 0;
    let (x594, x595) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let mut x596: u32 = 0;
    let mut x597: u32 = 0;
    let (x596, x597) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let mut x598: u32 = 0;
    let mut x599: u32 = 0;
    let (x598, x599) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let mut x600: u32 = 0;
    let mut x601: u32 = 0;
    let (x600, x601) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let mut x602: u32 = 0;
    let mut x603: u32 = 0;
    let (x602, x603) = fiat_p384_scalar_mulx_u32(x590, 0xffffffff);
    let mut x604: u32 = 0;
    let mut x605: u32 = 0;
    let (x604, x605) = fiat_p384_scalar_mulx_u32(x590, 0xc7634d81);
    let mut x606: u32 = 0;
    let mut x607: u32 = 0;
    let (x606, x607) = fiat_p384_scalar_mulx_u32(x590, 0xf4372ddf);
    let mut x608: u32 = 0;
    let mut x609: u32 = 0;
    let (x608, x609) = fiat_p384_scalar_mulx_u32(x590, 0x581a0db2);
    let mut x610: u32 = 0;
    let mut x611: u32 = 0;
    let (x610, x611) = fiat_p384_scalar_mulx_u32(x590, 0x48b0a77a);
    let mut x612: u32 = 0;
    let mut x613: u32 = 0;
    let (x612, x613) = fiat_p384_scalar_mulx_u32(x590, 0xecec196a);
    let mut x614: u32 = 0;
    let mut x615: u32 = 0;
    let (x614, x615) = fiat_p384_scalar_mulx_u32(x590, 0xccc52973);
    let mut x616: u32 = 0;
    let mut x617: fiat_p384_scalar_u1 = 0;
    let (x616, x617) = fiat_p384_scalar_addcarryx_u32(0x0, x615, x612);
    let mut x618: u32 = 0;
    let mut x619: fiat_p384_scalar_u1 = 0;
    let (x618, x619) = fiat_p384_scalar_addcarryx_u32(x617, x613, x610);
    let mut x620: u32 = 0;
    let mut x621: fiat_p384_scalar_u1 = 0;
    let (x620, x621) = fiat_p384_scalar_addcarryx_u32(x619, x611, x608);
    let mut x622: u32 = 0;
    let mut x623: fiat_p384_scalar_u1 = 0;
    let (x622, x623) = fiat_p384_scalar_addcarryx_u32(x621, x609, x606);
    let mut x624: u32 = 0;
    let mut x625: fiat_p384_scalar_u1 = 0;
    let (x624, x625) = fiat_p384_scalar_addcarryx_u32(x623, x607, x604);
    let mut x626: u32 = 0;
    let mut x627: fiat_p384_scalar_u1 = 0;
    let (x626, x627) = fiat_p384_scalar_addcarryx_u32(x625, x605, x602);
    let mut x628: u32 = 0;
    let mut x629: fiat_p384_scalar_u1 = 0;
    let (x628, x629) = fiat_p384_scalar_addcarryx_u32(x627, x603, x600);
    let mut x630: u32 = 0;
    let mut x631: fiat_p384_scalar_u1 = 0;
    let (x630, x631) = fiat_p384_scalar_addcarryx_u32(x629, x601, x598);
    let mut x632: u32 = 0;
    let mut x633: fiat_p384_scalar_u1 = 0;
    let (x632, x633) = fiat_p384_scalar_addcarryx_u32(x631, x599, x596);
    let mut x634: u32 = 0;
    let mut x635: fiat_p384_scalar_u1 = 0;
    let (x634, x635) = fiat_p384_scalar_addcarryx_u32(x633, x597, x594);
    let mut x636: u32 = 0;
    let mut x637: fiat_p384_scalar_u1 = 0;
    let (x636, x637) = fiat_p384_scalar_addcarryx_u32(x635, x595, x592);
    let mut x638: u32 = 0;
    let mut x639: fiat_p384_scalar_u1 = 0;
    let (x638, x639) = fiat_p384_scalar_addcarryx_u32(0x0, x566, x614);
    let mut x640: u32 = 0;
    let mut x641: fiat_p384_scalar_u1 = 0;
    let (x640, x641) = fiat_p384_scalar_addcarryx_u32(x639, x568, x616);
    let mut x642: u32 = 0;
    let mut x643: fiat_p384_scalar_u1 = 0;
    let (x642, x643) = fiat_p384_scalar_addcarryx_u32(x641, x570, x618);
    let mut x644: u32 = 0;
    let mut x645: fiat_p384_scalar_u1 = 0;
    let (x644, x645) = fiat_p384_scalar_addcarryx_u32(x643, x572, x620);
    let mut x646: u32 = 0;
    let mut x647: fiat_p384_scalar_u1 = 0;
    let (x646, x647) = fiat_p384_scalar_addcarryx_u32(x645, x574, x622);
    let mut x648: u32 = 0;
    let mut x649: fiat_p384_scalar_u1 = 0;
    let (x648, x649) = fiat_p384_scalar_addcarryx_u32(x647, x576, x624);
    let mut x650: u32 = 0;
    let mut x651: fiat_p384_scalar_u1 = 0;
    let (x650, x651) = fiat_p384_scalar_addcarryx_u32(x649, x578, x626);
    let mut x652: u32 = 0;
    let mut x653: fiat_p384_scalar_u1 = 0;
    let (x652, x653) = fiat_p384_scalar_addcarryx_u32(x651, x580, x628);
    let mut x654: u32 = 0;
    let mut x655: fiat_p384_scalar_u1 = 0;
    let (x654, x655) = fiat_p384_scalar_addcarryx_u32(x653, x582, x630);
    let mut x656: u32 = 0;
    let mut x657: fiat_p384_scalar_u1 = 0;
    let (x656, x657) = fiat_p384_scalar_addcarryx_u32(x655, x584, x632);
    let mut x658: u32 = 0;
    let mut x659: fiat_p384_scalar_u1 = 0;
    let (x658, x659) = fiat_p384_scalar_addcarryx_u32(x657, x586, x634);
    let mut x660: u32 = 0;
    let mut x661: fiat_p384_scalar_u1 = 0;
    let (x660, x661) = fiat_p384_scalar_addcarryx_u32(x659, x588, x636);
    let mut x662: u32 = 0;
    let mut x663: fiat_p384_scalar_u1 = 0;
    let (x662, x663) = fiat_p384_scalar_addcarryx_u32(
        x661,
        ((x589 as u32) + (x565 as u32)),
        ((x637 as u32) + x593),
    );
    let mut x664: u32 = 0;
    let mut x665: fiat_p384_scalar_u1 = 0;
    let (x664, x665) = fiat_p384_scalar_addcarryx_u32(0x0, x640, (arg1[7]));
    let mut x666: u32 = 0;
    let mut x667: fiat_p384_scalar_u1 = 0;
    let (x666, x667) = fiat_p384_scalar_addcarryx_u32(x665, x642, (0x0 as u32));
    let mut x668: u32 = 0;
    let mut x669: fiat_p384_scalar_u1 = 0;
    let (x668, x669) = fiat_p384_scalar_addcarryx_u32(x667, x644, (0x0 as u32));
    let mut x670: u32 = 0;
    let mut x671: fiat_p384_scalar_u1 = 0;
    let (x670, x671) = fiat_p384_scalar_addcarryx_u32(x669, x646, (0x0 as u32));
    let mut x672: u32 = 0;
    let mut x673: fiat_p384_scalar_u1 = 0;
    let (x672, x673) = fiat_p384_scalar_addcarryx_u32(x671, x648, (0x0 as u32));
    let mut x674: u32 = 0;
    let mut x675: fiat_p384_scalar_u1 = 0;
    let (x674, x675) = fiat_p384_scalar_addcarryx_u32(x673, x650, (0x0 as u32));
    let mut x676: u32 = 0;
    let mut x677: fiat_p384_scalar_u1 = 0;
    let (x676, x677) = fiat_p384_scalar_addcarryx_u32(x675, x652, (0x0 as u32));
    let mut x678: u32 = 0;
    let mut x679: fiat_p384_scalar_u1 = 0;
    let (x678, x679) = fiat_p384_scalar_addcarryx_u32(x677, x654, (0x0 as u32));
    let mut x680: u32 = 0;
    let mut x681: fiat_p384_scalar_u1 = 0;
    let (x680, x681) = fiat_p384_scalar_addcarryx_u32(x679, x656, (0x0 as u32));
    let mut x682: u32 = 0;
    let mut x683: fiat_p384_scalar_u1 = 0;
    let (x682, x683) = fiat_p384_scalar_addcarryx_u32(x681, x658, (0x0 as u32));
    let mut x684: u32 = 0;
    let mut x685: fiat_p384_scalar_u1 = 0;
    let (x684, x685) = fiat_p384_scalar_addcarryx_u32(x683, x660, (0x0 as u32));
    let mut x686: u32 = 0;
    let mut x687: fiat_p384_scalar_u1 = 0;
    let (x686, x687) = fiat_p384_scalar_addcarryx_u32(x685, x662, (0x0 as u32));
    let mut x688: u32 = 0;
    let mut x689: u32 = 0;
    let (x688, x689) = fiat_p384_scalar_mulx_u32(x664, 0xe88fdc45);
    let mut x690: u32 = 0;
    let mut x691: u32 = 0;
    let (x690, x691) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let mut x692: u32 = 0;
    let mut x693: u32 = 0;
    let (x692, x693) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let mut x694: u32 = 0;
    let mut x695: u32 = 0;
    let (x694, x695) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let mut x696: u32 = 0;
    let mut x697: u32 = 0;
    let (x696, x697) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let mut x698: u32 = 0;
    let mut x699: u32 = 0;
    let (x698, x699) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let mut x700: u32 = 0;
    let mut x701: u32 = 0;
    let (x700, x701) = fiat_p384_scalar_mulx_u32(x688, 0xffffffff);
    let mut x702: u32 = 0;
    let mut x703: u32 = 0;
    let (x702, x703) = fiat_p384_scalar_mulx_u32(x688, 0xc7634d81);
    let mut x704: u32 = 0;
    let mut x705: u32 = 0;
    let (x704, x705) = fiat_p384_scalar_mulx_u32(x688, 0xf4372ddf);
    let mut x706: u32 = 0;
    let mut x707: u32 = 0;
    let (x706, x707) = fiat_p384_scalar_mulx_u32(x688, 0x581a0db2);
    let mut x708: u32 = 0;
    let mut x709: u32 = 0;
    let (x708, x709) = fiat_p384_scalar_mulx_u32(x688, 0x48b0a77a);
    let mut x710: u32 = 0;
    let mut x711: u32 = 0;
    let (x710, x711) = fiat_p384_scalar_mulx_u32(x688, 0xecec196a);
    let mut x712: u32 = 0;
    let mut x713: u32 = 0;
    let (x712, x713) = fiat_p384_scalar_mulx_u32(x688, 0xccc52973);
    let mut x714: u32 = 0;
    let mut x715: fiat_p384_scalar_u1 = 0;
    let (x714, x715) = fiat_p384_scalar_addcarryx_u32(0x0, x713, x710);
    let mut x716: u32 = 0;
    let mut x717: fiat_p384_scalar_u1 = 0;
    let (x716, x717) = fiat_p384_scalar_addcarryx_u32(x715, x711, x708);
    let mut x718: u32 = 0;
    let mut x719: fiat_p384_scalar_u1 = 0;
    let (x718, x719) = fiat_p384_scalar_addcarryx_u32(x717, x709, x706);
    let mut x720: u32 = 0;
    let mut x721: fiat_p384_scalar_u1 = 0;
    let (x720, x721) = fiat_p384_scalar_addcarryx_u32(x719, x707, x704);
    let mut x722: u32 = 0;
    let mut x723: fiat_p384_scalar_u1 = 0;
    let (x722, x723) = fiat_p384_scalar_addcarryx_u32(x721, x705, x702);
    let mut x724: u32 = 0;
    let mut x725: fiat_p384_scalar_u1 = 0;
    let (x724, x725) = fiat_p384_scalar_addcarryx_u32(x723, x703, x700);
    let mut x726: u32 = 0;
    let mut x727: fiat_p384_scalar_u1 = 0;
    let (x726, x727) = fiat_p384_scalar_addcarryx_u32(x725, x701, x698);
    let mut x728: u32 = 0;
    let mut x729: fiat_p384_scalar_u1 = 0;
    let (x728, x729) = fiat_p384_scalar_addcarryx_u32(x727, x699, x696);
    let mut x730: u32 = 0;
    let mut x731: fiat_p384_scalar_u1 = 0;
    let (x730, x731) = fiat_p384_scalar_addcarryx_u32(x729, x697, x694);
    let mut x732: u32 = 0;
    let mut x733: fiat_p384_scalar_u1 = 0;
    let (x732, x733) = fiat_p384_scalar_addcarryx_u32(x731, x695, x692);
    let mut x734: u32 = 0;
    let mut x735: fiat_p384_scalar_u1 = 0;
    let (x734, x735) = fiat_p384_scalar_addcarryx_u32(x733, x693, x690);
    let mut x736: u32 = 0;
    let mut x737: fiat_p384_scalar_u1 = 0;
    let (x736, x737) = fiat_p384_scalar_addcarryx_u32(0x0, x664, x712);
    let mut x738: u32 = 0;
    let mut x739: fiat_p384_scalar_u1 = 0;
    let (x738, x739) = fiat_p384_scalar_addcarryx_u32(x737, x666, x714);
    let mut x740: u32 = 0;
    let mut x741: fiat_p384_scalar_u1 = 0;
    let (x740, x741) = fiat_p384_scalar_addcarryx_u32(x739, x668, x716);
    let mut x742: u32 = 0;
    let mut x743: fiat_p384_scalar_u1 = 0;
    let (x742, x743) = fiat_p384_scalar_addcarryx_u32(x741, x670, x718);
    let mut x744: u32 = 0;
    let mut x745: fiat_p384_scalar_u1 = 0;
    let (x744, x745) = fiat_p384_scalar_addcarryx_u32(x743, x672, x720);
    let mut x746: u32 = 0;
    let mut x747: fiat_p384_scalar_u1 = 0;
    let (x746, x747) = fiat_p384_scalar_addcarryx_u32(x745, x674, x722);
    let mut x748: u32 = 0;
    let mut x749: fiat_p384_scalar_u1 = 0;
    let (x748, x749) = fiat_p384_scalar_addcarryx_u32(x747, x676, x724);
    let mut x750: u32 = 0;
    let mut x751: fiat_p384_scalar_u1 = 0;
    let (x750, x751) = fiat_p384_scalar_addcarryx_u32(x749, x678, x726);
    let mut x752: u32 = 0;
    let mut x753: fiat_p384_scalar_u1 = 0;
    let (x752, x753) = fiat_p384_scalar_addcarryx_u32(x751, x680, x728);
    let mut x754: u32 = 0;
    let mut x755: fiat_p384_scalar_u1 = 0;
    let (x754, x755) = fiat_p384_scalar_addcarryx_u32(x753, x682, x730);
    let mut x756: u32 = 0;
    let mut x757: fiat_p384_scalar_u1 = 0;
    let (x756, x757) = fiat_p384_scalar_addcarryx_u32(x755, x684, x732);
    let mut x758: u32 = 0;
    let mut x759: fiat_p384_scalar_u1 = 0;
    let (x758, x759) = fiat_p384_scalar_addcarryx_u32(x757, x686, x734);
    let mut x760: u32 = 0;
    let mut x761: fiat_p384_scalar_u1 = 0;
    let (x760, x761) = fiat_p384_scalar_addcarryx_u32(
        x759,
        ((x687 as u32) + (x663 as u32)),
        ((x735 as u32) + x691),
    );
    let mut x762: u32 = 0;
    let mut x763: fiat_p384_scalar_u1 = 0;
    let (x762, x763) = fiat_p384_scalar_addcarryx_u32(0x0, x738, (arg1[8]));
    let mut x764: u32 = 0;
    let mut x765: fiat_p384_scalar_u1 = 0;
    let (x764, x765) = fiat_p384_scalar_addcarryx_u32(x763, x740, (0x0 as u32));
    let mut x766: u32 = 0;
    let mut x767: fiat_p384_scalar_u1 = 0;
    let (x766, x767) = fiat_p384_scalar_addcarryx_u32(x765, x742, (0x0 as u32));
    let mut x768: u32 = 0;
    let mut x769: fiat_p384_scalar_u1 = 0;
    let (x768, x769) = fiat_p384_scalar_addcarryx_u32(x767, x744, (0x0 as u32));
    let mut x770: u32 = 0;
    let mut x771: fiat_p384_scalar_u1 = 0;
    let (x770, x771) = fiat_p384_scalar_addcarryx_u32(x769, x746, (0x0 as u32));
    let mut x772: u32 = 0;
    let mut x773: fiat_p384_scalar_u1 = 0;
    let (x772, x773) = fiat_p384_scalar_addcarryx_u32(x771, x748, (0x0 as u32));
    let mut x774: u32 = 0;
    let mut x775: fiat_p384_scalar_u1 = 0;
    let (x774, x775) = fiat_p384_scalar_addcarryx_u32(x773, x750, (0x0 as u32));
    let mut x776: u32 = 0;
    let mut x777: fiat_p384_scalar_u1 = 0;
    let (x776, x777) = fiat_p384_scalar_addcarryx_u32(x775, x752, (0x0 as u32));
    let mut x778: u32 = 0;
    let mut x779: fiat_p384_scalar_u1 = 0;
    let (x778, x779) = fiat_p384_scalar_addcarryx_u32(x777, x754, (0x0 as u32));
    let mut x780: u32 = 0;
    let mut x781: fiat_p384_scalar_u1 = 0;
    let (x780, x781) = fiat_p384_scalar_addcarryx_u32(x779, x756, (0x0 as u32));
    let mut x782: u32 = 0;
    let mut x783: fiat_p384_scalar_u1 = 0;
    let (x782, x783) = fiat_p384_scalar_addcarryx_u32(x781, x758, (0x0 as u32));
    let mut x784: u32 = 0;
    let mut x785: fiat_p384_scalar_u1 = 0;
    let (x784, x785) = fiat_p384_scalar_addcarryx_u32(x783, x760, (0x0 as u32));
    let mut x786: u32 = 0;
    let mut x787: u32 = 0;
    let (x786, x787) = fiat_p384_scalar_mulx_u32(x762, 0xe88fdc45);
    let mut x788: u32 = 0;
    let mut x789: u32 = 0;
    let (x788, x789) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let mut x790: u32 = 0;
    let mut x791: u32 = 0;
    let (x790, x791) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let mut x792: u32 = 0;
    let mut x793: u32 = 0;
    let (x792, x793) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let mut x794: u32 = 0;
    let mut x795: u32 = 0;
    let (x794, x795) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let mut x796: u32 = 0;
    let mut x797: u32 = 0;
    let (x796, x797) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let mut x798: u32 = 0;
    let mut x799: u32 = 0;
    let (x798, x799) = fiat_p384_scalar_mulx_u32(x786, 0xffffffff);
    let mut x800: u32 = 0;
    let mut x801: u32 = 0;
    let (x800, x801) = fiat_p384_scalar_mulx_u32(x786, 0xc7634d81);
    let mut x802: u32 = 0;
    let mut x803: u32 = 0;
    let (x802, x803) = fiat_p384_scalar_mulx_u32(x786, 0xf4372ddf);
    let mut x804: u32 = 0;
    let mut x805: u32 = 0;
    let (x804, x805) = fiat_p384_scalar_mulx_u32(x786, 0x581a0db2);
    let mut x806: u32 = 0;
    let mut x807: u32 = 0;
    let (x806, x807) = fiat_p384_scalar_mulx_u32(x786, 0x48b0a77a);
    let mut x808: u32 = 0;
    let mut x809: u32 = 0;
    let (x808, x809) = fiat_p384_scalar_mulx_u32(x786, 0xecec196a);
    let mut x810: u32 = 0;
    let mut x811: u32 = 0;
    let (x810, x811) = fiat_p384_scalar_mulx_u32(x786, 0xccc52973);
    let mut x812: u32 = 0;
    let mut x813: fiat_p384_scalar_u1 = 0;
    let (x812, x813) = fiat_p384_scalar_addcarryx_u32(0x0, x811, x808);
    let mut x814: u32 = 0;
    let mut x815: fiat_p384_scalar_u1 = 0;
    let (x814, x815) = fiat_p384_scalar_addcarryx_u32(x813, x809, x806);
    let mut x816: u32 = 0;
    let mut x817: fiat_p384_scalar_u1 = 0;
    let (x816, x817) = fiat_p384_scalar_addcarryx_u32(x815, x807, x804);
    let mut x818: u32 = 0;
    let mut x819: fiat_p384_scalar_u1 = 0;
    let (x818, x819) = fiat_p384_scalar_addcarryx_u32(x817, x805, x802);
    let mut x820: u32 = 0;
    let mut x821: fiat_p384_scalar_u1 = 0;
    let (x820, x821) = fiat_p384_scalar_addcarryx_u32(x819, x803, x800);
    let mut x822: u32 = 0;
    let mut x823: fiat_p384_scalar_u1 = 0;
    let (x822, x823) = fiat_p384_scalar_addcarryx_u32(x821, x801, x798);
    let mut x824: u32 = 0;
    let mut x825: fiat_p384_scalar_u1 = 0;
    let (x824, x825) = fiat_p384_scalar_addcarryx_u32(x823, x799, x796);
    let mut x826: u32 = 0;
    let mut x827: fiat_p384_scalar_u1 = 0;
    let (x826, x827) = fiat_p384_scalar_addcarryx_u32(x825, x797, x794);
    let mut x828: u32 = 0;
    let mut x829: fiat_p384_scalar_u1 = 0;
    let (x828, x829) = fiat_p384_scalar_addcarryx_u32(x827, x795, x792);
    let mut x830: u32 = 0;
    let mut x831: fiat_p384_scalar_u1 = 0;
    let (x830, x831) = fiat_p384_scalar_addcarryx_u32(x829, x793, x790);
    let mut x832: u32 = 0;
    let mut x833: fiat_p384_scalar_u1 = 0;
    let (x832, x833) = fiat_p384_scalar_addcarryx_u32(x831, x791, x788);
    let mut x834: u32 = 0;
    let mut x835: fiat_p384_scalar_u1 = 0;
    let (x834, x835) = fiat_p384_scalar_addcarryx_u32(0x0, x762, x810);
    let mut x836: u32 = 0;
    let mut x837: fiat_p384_scalar_u1 = 0;
    let (x836, x837) = fiat_p384_scalar_addcarryx_u32(x835, x764, x812);
    let mut x838: u32 = 0;
    let mut x839: fiat_p384_scalar_u1 = 0;
    let (x838, x839) = fiat_p384_scalar_addcarryx_u32(x837, x766, x814);
    let mut x840: u32 = 0;
    let mut x841: fiat_p384_scalar_u1 = 0;
    let (x840, x841) = fiat_p384_scalar_addcarryx_u32(x839, x768, x816);
    let mut x842: u32 = 0;
    let mut x843: fiat_p384_scalar_u1 = 0;
    let (x842, x843) = fiat_p384_scalar_addcarryx_u32(x841, x770, x818);
    let mut x844: u32 = 0;
    let mut x845: fiat_p384_scalar_u1 = 0;
    let (x844, x845) = fiat_p384_scalar_addcarryx_u32(x843, x772, x820);
    let mut x846: u32 = 0;
    let mut x847: fiat_p384_scalar_u1 = 0;
    let (x846, x847) = fiat_p384_scalar_addcarryx_u32(x845, x774, x822);
    let mut x848: u32 = 0;
    let mut x849: fiat_p384_scalar_u1 = 0;
    let (x848, x849) = fiat_p384_scalar_addcarryx_u32(x847, x776, x824);
    let mut x850: u32 = 0;
    let mut x851: fiat_p384_scalar_u1 = 0;
    let (x850, x851) = fiat_p384_scalar_addcarryx_u32(x849, x778, x826);
    let mut x852: u32 = 0;
    let mut x853: fiat_p384_scalar_u1 = 0;
    let (x852, x853) = fiat_p384_scalar_addcarryx_u32(x851, x780, x828);
    let mut x854: u32 = 0;
    let mut x855: fiat_p384_scalar_u1 = 0;
    let (x854, x855) = fiat_p384_scalar_addcarryx_u32(x853, x782, x830);
    let mut x856: u32 = 0;
    let mut x857: fiat_p384_scalar_u1 = 0;
    let (x856, x857) = fiat_p384_scalar_addcarryx_u32(x855, x784, x832);
    let mut x858: u32 = 0;
    let mut x859: fiat_p384_scalar_u1 = 0;
    let (x858, x859) = fiat_p384_scalar_addcarryx_u32(
        x857,
        ((x785 as u32) + (x761 as u32)),
        ((x833 as u32) + x789),
    );
    let mut x860: u32 = 0;
    let mut x861: fiat_p384_scalar_u1 = 0;
    let (x860, x861) = fiat_p384_scalar_addcarryx_u32(0x0, x836, (arg1[9]));
    let mut x862: u32 = 0;
    let mut x863: fiat_p384_scalar_u1 = 0;
    let (x862, x863) = fiat_p384_scalar_addcarryx_u32(x861, x838, (0x0 as u32));
    let mut x864: u32 = 0;
    let mut x865: fiat_p384_scalar_u1 = 0;
    let (x864, x865) = fiat_p384_scalar_addcarryx_u32(x863, x840, (0x0 as u32));
    let mut x866: u32 = 0;
    let mut x867: fiat_p384_scalar_u1 = 0;
    let (x866, x867) = fiat_p384_scalar_addcarryx_u32(x865, x842, (0x0 as u32));
    let mut x868: u32 = 0;
    let mut x869: fiat_p384_scalar_u1 = 0;
    let (x868, x869) = fiat_p384_scalar_addcarryx_u32(x867, x844, (0x0 as u32));
    let mut x870: u32 = 0;
    let mut x871: fiat_p384_scalar_u1 = 0;
    let (x870, x871) = fiat_p384_scalar_addcarryx_u32(x869, x846, (0x0 as u32));
    let mut x872: u32 = 0;
    let mut x873: fiat_p384_scalar_u1 = 0;
    let (x872, x873) = fiat_p384_scalar_addcarryx_u32(x871, x848, (0x0 as u32));
    let mut x874: u32 = 0;
    let mut x875: fiat_p384_scalar_u1 = 0;
    let (x874, x875) = fiat_p384_scalar_addcarryx_u32(x873, x850, (0x0 as u32));
    let mut x876: u32 = 0;
    let mut x877: fiat_p384_scalar_u1 = 0;
    let (x876, x877) = fiat_p384_scalar_addcarryx_u32(x875, x852, (0x0 as u32));
    let mut x878: u32 = 0;
    let mut x879: fiat_p384_scalar_u1 = 0;
    let (x878, x879) = fiat_p384_scalar_addcarryx_u32(x877, x854, (0x0 as u32));
    let mut x880: u32 = 0;
    let mut x881: fiat_p384_scalar_u1 = 0;
    let (x880, x881) = fiat_p384_scalar_addcarryx_u32(x879, x856, (0x0 as u32));
    let mut x882: u32 = 0;
    let mut x883: fiat_p384_scalar_u1 = 0;
    let (x882, x883) = fiat_p384_scalar_addcarryx_u32(x881, x858, (0x0 as u32));
    let mut x884: u32 = 0;
    let mut x885: u32 = 0;
    let (x884, x885) = fiat_p384_scalar_mulx_u32(x860, 0xe88fdc45);
    let mut x886: u32 = 0;
    let mut x887: u32 = 0;
    let (x886, x887) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let mut x888: u32 = 0;
    let mut x889: u32 = 0;
    let (x888, x889) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let mut x890: u32 = 0;
    let mut x891: u32 = 0;
    let (x890, x891) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let mut x892: u32 = 0;
    let mut x893: u32 = 0;
    let (x892, x893) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let mut x894: u32 = 0;
    let mut x895: u32 = 0;
    let (x894, x895) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let mut x896: u32 = 0;
    let mut x897: u32 = 0;
    let (x896, x897) = fiat_p384_scalar_mulx_u32(x884, 0xffffffff);
    let mut x898: u32 = 0;
    let mut x899: u32 = 0;
    let (x898, x899) = fiat_p384_scalar_mulx_u32(x884, 0xc7634d81);
    let mut x900: u32 = 0;
    let mut x901: u32 = 0;
    let (x900, x901) = fiat_p384_scalar_mulx_u32(x884, 0xf4372ddf);
    let mut x902: u32 = 0;
    let mut x903: u32 = 0;
    let (x902, x903) = fiat_p384_scalar_mulx_u32(x884, 0x581a0db2);
    let mut x904: u32 = 0;
    let mut x905: u32 = 0;
    let (x904, x905) = fiat_p384_scalar_mulx_u32(x884, 0x48b0a77a);
    let mut x906: u32 = 0;
    let mut x907: u32 = 0;
    let (x906, x907) = fiat_p384_scalar_mulx_u32(x884, 0xecec196a);
    let mut x908: u32 = 0;
    let mut x909: u32 = 0;
    let (x908, x909) = fiat_p384_scalar_mulx_u32(x884, 0xccc52973);
    let mut x910: u32 = 0;
    let mut x911: fiat_p384_scalar_u1 = 0;
    let (x910, x911) = fiat_p384_scalar_addcarryx_u32(0x0, x909, x906);
    let mut x912: u32 = 0;
    let mut x913: fiat_p384_scalar_u1 = 0;
    let (x912, x913) = fiat_p384_scalar_addcarryx_u32(x911, x907, x904);
    let mut x914: u32 = 0;
    let mut x915: fiat_p384_scalar_u1 = 0;
    let (x914, x915) = fiat_p384_scalar_addcarryx_u32(x913, x905, x902);
    let mut x916: u32 = 0;
    let mut x917: fiat_p384_scalar_u1 = 0;
    let (x916, x917) = fiat_p384_scalar_addcarryx_u32(x915, x903, x900);
    let mut x918: u32 = 0;
    let mut x919: fiat_p384_scalar_u1 = 0;
    let (x918, x919) = fiat_p384_scalar_addcarryx_u32(x917, x901, x898);
    let mut x920: u32 = 0;
    let mut x921: fiat_p384_scalar_u1 = 0;
    let (x920, x921) = fiat_p384_scalar_addcarryx_u32(x919, x899, x896);
    let mut x922: u32 = 0;
    let mut x923: fiat_p384_scalar_u1 = 0;
    let (x922, x923) = fiat_p384_scalar_addcarryx_u32(x921, x897, x894);
    let mut x924: u32 = 0;
    let mut x925: fiat_p384_scalar_u1 = 0;
    let (x924, x925) = fiat_p384_scalar_addcarryx_u32(x923, x895, x892);
    let mut x926: u32 = 0;
    let mut x927: fiat_p384_scalar_u1 = 0;
    let (x926, x927) = fiat_p384_scalar_addcarryx_u32(x925, x893, x890);
    let mut x928: u32 = 0;
    let mut x929: fiat_p384_scalar_u1 = 0;
    let (x928, x929) = fiat_p384_scalar_addcarryx_u32(x927, x891, x888);
    let mut x930: u32 = 0;
    let mut x931: fiat_p384_scalar_u1 = 0;
    let (x930, x931) = fiat_p384_scalar_addcarryx_u32(x929, x889, x886);
    let mut x932: u32 = 0;
    let mut x933: fiat_p384_scalar_u1 = 0;
    let (x932, x933) = fiat_p384_scalar_addcarryx_u32(0x0, x860, x908);
    let mut x934: u32 = 0;
    let mut x935: fiat_p384_scalar_u1 = 0;
    let (x934, x935) = fiat_p384_scalar_addcarryx_u32(x933, x862, x910);
    let mut x936: u32 = 0;
    let mut x937: fiat_p384_scalar_u1 = 0;
    let (x936, x937) = fiat_p384_scalar_addcarryx_u32(x935, x864, x912);
    let mut x938: u32 = 0;
    let mut x939: fiat_p384_scalar_u1 = 0;
    let (x938, x939) = fiat_p384_scalar_addcarryx_u32(x937, x866, x914);
    let mut x940: u32 = 0;
    let mut x941: fiat_p384_scalar_u1 = 0;
    let (x940, x941) = fiat_p384_scalar_addcarryx_u32(x939, x868, x916);
    let mut x942: u32 = 0;
    let mut x943: fiat_p384_scalar_u1 = 0;
    let (x942, x943) = fiat_p384_scalar_addcarryx_u32(x941, x870, x918);
    let mut x944: u32 = 0;
    let mut x945: fiat_p384_scalar_u1 = 0;
    let (x944, x945) = fiat_p384_scalar_addcarryx_u32(x943, x872, x920);
    let mut x946: u32 = 0;
    let mut x947: fiat_p384_scalar_u1 = 0;
    let (x946, x947) = fiat_p384_scalar_addcarryx_u32(x945, x874, x922);
    let mut x948: u32 = 0;
    let mut x949: fiat_p384_scalar_u1 = 0;
    let (x948, x949) = fiat_p384_scalar_addcarryx_u32(x947, x876, x924);
    let mut x950: u32 = 0;
    let mut x951: fiat_p384_scalar_u1 = 0;
    let (x950, x951) = fiat_p384_scalar_addcarryx_u32(x949, x878, x926);
    let mut x952: u32 = 0;
    let mut x953: fiat_p384_scalar_u1 = 0;
    let (x952, x953) = fiat_p384_scalar_addcarryx_u32(x951, x880, x928);
    let mut x954: u32 = 0;
    let mut x955: fiat_p384_scalar_u1 = 0;
    let (x954, x955) = fiat_p384_scalar_addcarryx_u32(x953, x882, x930);
    let mut x956: u32 = 0;
    let mut x957: fiat_p384_scalar_u1 = 0;
    let (x956, x957) = fiat_p384_scalar_addcarryx_u32(
        x955,
        ((x883 as u32) + (x859 as u32)),
        ((x931 as u32) + x887),
    );
    let mut x958: u32 = 0;
    let mut x959: fiat_p384_scalar_u1 = 0;
    let (x958, x959) = fiat_p384_scalar_addcarryx_u32(0x0, x934, (arg1[10]));
    let mut x960: u32 = 0;
    let mut x961: fiat_p384_scalar_u1 = 0;
    let (x960, x961) = fiat_p384_scalar_addcarryx_u32(x959, x936, (0x0 as u32));
    let mut x962: u32 = 0;
    let mut x963: fiat_p384_scalar_u1 = 0;
    let (x962, x963) = fiat_p384_scalar_addcarryx_u32(x961, x938, (0x0 as u32));
    let mut x964: u32 = 0;
    let mut x965: fiat_p384_scalar_u1 = 0;
    let (x964, x965) = fiat_p384_scalar_addcarryx_u32(x963, x940, (0x0 as u32));
    let mut x966: u32 = 0;
    let mut x967: fiat_p384_scalar_u1 = 0;
    let (x966, x967) = fiat_p384_scalar_addcarryx_u32(x965, x942, (0x0 as u32));
    let mut x968: u32 = 0;
    let mut x969: fiat_p384_scalar_u1 = 0;
    let (x968, x969) = fiat_p384_scalar_addcarryx_u32(x967, x944, (0x0 as u32));
    let mut x970: u32 = 0;
    let mut x971: fiat_p384_scalar_u1 = 0;
    let (x970, x971) = fiat_p384_scalar_addcarryx_u32(x969, x946, (0x0 as u32));
    let mut x972: u32 = 0;
    let mut x973: fiat_p384_scalar_u1 = 0;
    let (x972, x973) = fiat_p384_scalar_addcarryx_u32(x971, x948, (0x0 as u32));
    let mut x974: u32 = 0;
    let mut x975: fiat_p384_scalar_u1 = 0;
    let (x974, x975) = fiat_p384_scalar_addcarryx_u32(x973, x950, (0x0 as u32));
    let mut x976: u32 = 0;
    let mut x977: fiat_p384_scalar_u1 = 0;
    let (x976, x977) = fiat_p384_scalar_addcarryx_u32(x975, x952, (0x0 as u32));
    let mut x978: u32 = 0;
    let mut x979: fiat_p384_scalar_u1 = 0;
    let (x978, x979) = fiat_p384_scalar_addcarryx_u32(x977, x954, (0x0 as u32));
    let mut x980: u32 = 0;
    let mut x981: fiat_p384_scalar_u1 = 0;
    let (x980, x981) = fiat_p384_scalar_addcarryx_u32(x979, x956, (0x0 as u32));
    let mut x982: u32 = 0;
    let mut x983: u32 = 0;
    let (x982, x983) = fiat_p384_scalar_mulx_u32(x958, 0xe88fdc45);
    let mut x984: u32 = 0;
    let mut x985: u32 = 0;
    let (x984, x985) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let mut x986: u32 = 0;
    let mut x987: u32 = 0;
    let (x986, x987) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let mut x988: u32 = 0;
    let mut x989: u32 = 0;
    let (x988, x989) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let mut x990: u32 = 0;
    let mut x991: u32 = 0;
    let (x990, x991) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let mut x992: u32 = 0;
    let mut x993: u32 = 0;
    let (x992, x993) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let mut x994: u32 = 0;
    let mut x995: u32 = 0;
    let (x994, x995) = fiat_p384_scalar_mulx_u32(x982, 0xffffffff);
    let mut x996: u32 = 0;
    let mut x997: u32 = 0;
    let (x996, x997) = fiat_p384_scalar_mulx_u32(x982, 0xc7634d81);
    let mut x998: u32 = 0;
    let mut x999: u32 = 0;
    let (x998, x999) = fiat_p384_scalar_mulx_u32(x982, 0xf4372ddf);
    let mut x1000: u32 = 0;
    let mut x1001: u32 = 0;
    let (x1000, x1001) = fiat_p384_scalar_mulx_u32(x982, 0x581a0db2);
    let mut x1002: u32 = 0;
    let mut x1003: u32 = 0;
    let (x1002, x1003) = fiat_p384_scalar_mulx_u32(x982, 0x48b0a77a);
    let mut x1004: u32 = 0;
    let mut x1005: u32 = 0;
    let (x1004, x1005) = fiat_p384_scalar_mulx_u32(x982, 0xecec196a);
    let mut x1006: u32 = 0;
    let mut x1007: u32 = 0;
    let (x1006, x1007) = fiat_p384_scalar_mulx_u32(x982, 0xccc52973);
    let mut x1008: u32 = 0;
    let mut x1009: fiat_p384_scalar_u1 = 0;
    let (x1008, x1009) = fiat_p384_scalar_addcarryx_u32(0x0, x1007, x1004);
    let mut x1010: u32 = 0;
    let mut x1011: fiat_p384_scalar_u1 = 0;
    let (x1010, x1011) = fiat_p384_scalar_addcarryx_u32(x1009, x1005, x1002);
    let mut x1012: u32 = 0;
    let mut x1013: fiat_p384_scalar_u1 = 0;
    let (x1012, x1013) = fiat_p384_scalar_addcarryx_u32(x1011, x1003, x1000);
    let mut x1014: u32 = 0;
    let mut x1015: fiat_p384_scalar_u1 = 0;
    let (x1014, x1015) = fiat_p384_scalar_addcarryx_u32(x1013, x1001, x998);
    let mut x1016: u32 = 0;
    let mut x1017: fiat_p384_scalar_u1 = 0;
    let (x1016, x1017) = fiat_p384_scalar_addcarryx_u32(x1015, x999, x996);
    let mut x1018: u32 = 0;
    let mut x1019: fiat_p384_scalar_u1 = 0;
    let (x1018, x1019) = fiat_p384_scalar_addcarryx_u32(x1017, x997, x994);
    let mut x1020: u32 = 0;
    let mut x1021: fiat_p384_scalar_u1 = 0;
    let (x1020, x1021) = fiat_p384_scalar_addcarryx_u32(x1019, x995, x992);
    let mut x1022: u32 = 0;
    let mut x1023: fiat_p384_scalar_u1 = 0;
    let (x1022, x1023) = fiat_p384_scalar_addcarryx_u32(x1021, x993, x990);
    let mut x1024: u32 = 0;
    let mut x1025: fiat_p384_scalar_u1 = 0;
    let (x1024, x1025) = fiat_p384_scalar_addcarryx_u32(x1023, x991, x988);
    let mut x1026: u32 = 0;
    let mut x1027: fiat_p384_scalar_u1 = 0;
    let (x1026, x1027) = fiat_p384_scalar_addcarryx_u32(x1025, x989, x986);
    let mut x1028: u32 = 0;
    let mut x1029: fiat_p384_scalar_u1 = 0;
    let (x1028, x1029) = fiat_p384_scalar_addcarryx_u32(x1027, x987, x984);
    let mut x1030: u32 = 0;
    let mut x1031: fiat_p384_scalar_u1 = 0;
    let (x1030, x1031) = fiat_p384_scalar_addcarryx_u32(0x0, x958, x1006);
    let mut x1032: u32 = 0;
    let mut x1033: fiat_p384_scalar_u1 = 0;
    let (x1032, x1033) = fiat_p384_scalar_addcarryx_u32(x1031, x960, x1008);
    let mut x1034: u32 = 0;
    let mut x1035: fiat_p384_scalar_u1 = 0;
    let (x1034, x1035) = fiat_p384_scalar_addcarryx_u32(x1033, x962, x1010);
    let mut x1036: u32 = 0;
    let mut x1037: fiat_p384_scalar_u1 = 0;
    let (x1036, x1037) = fiat_p384_scalar_addcarryx_u32(x1035, x964, x1012);
    let mut x1038: u32 = 0;
    let mut x1039: fiat_p384_scalar_u1 = 0;
    let (x1038, x1039) = fiat_p384_scalar_addcarryx_u32(x1037, x966, x1014);
    let mut x1040: u32 = 0;
    let mut x1041: fiat_p384_scalar_u1 = 0;
    let (x1040, x1041) = fiat_p384_scalar_addcarryx_u32(x1039, x968, x1016);
    let mut x1042: u32 = 0;
    let mut x1043: fiat_p384_scalar_u1 = 0;
    let (x1042, x1043) = fiat_p384_scalar_addcarryx_u32(x1041, x970, x1018);
    let mut x1044: u32 = 0;
    let mut x1045: fiat_p384_scalar_u1 = 0;
    let (x1044, x1045) = fiat_p384_scalar_addcarryx_u32(x1043, x972, x1020);
    let mut x1046: u32 = 0;
    let mut x1047: fiat_p384_scalar_u1 = 0;
    let (x1046, x1047) = fiat_p384_scalar_addcarryx_u32(x1045, x974, x1022);
    let mut x1048: u32 = 0;
    let mut x1049: fiat_p384_scalar_u1 = 0;
    let (x1048, x1049) = fiat_p384_scalar_addcarryx_u32(x1047, x976, x1024);
    let mut x1050: u32 = 0;
    let mut x1051: fiat_p384_scalar_u1 = 0;
    let (x1050, x1051) = fiat_p384_scalar_addcarryx_u32(x1049, x978, x1026);
    let mut x1052: u32 = 0;
    let mut x1053: fiat_p384_scalar_u1 = 0;
    let (x1052, x1053) = fiat_p384_scalar_addcarryx_u32(x1051, x980, x1028);
    let mut x1054: u32 = 0;
    let mut x1055: fiat_p384_scalar_u1 = 0;
    let (x1054, x1055) = fiat_p384_scalar_addcarryx_u32(
        x1053,
        ((x981 as u32) + (x957 as u32)),
        ((x1029 as u32) + x985),
    );
    let mut x1056: u32 = 0;
    let mut x1057: fiat_p384_scalar_u1 = 0;
    let (x1056, x1057) = fiat_p384_scalar_addcarryx_u32(0x0, x1032, (arg1[11]));
    let mut x1058: u32 = 0;
    let mut x1059: fiat_p384_scalar_u1 = 0;
    let (x1058, x1059) = fiat_p384_scalar_addcarryx_u32(x1057, x1034, (0x0 as u32));
    let mut x1060: u32 = 0;
    let mut x1061: fiat_p384_scalar_u1 = 0;
    let (x1060, x1061) = fiat_p384_scalar_addcarryx_u32(x1059, x1036, (0x0 as u32));
    let mut x1062: u32 = 0;
    let mut x1063: fiat_p384_scalar_u1 = 0;
    let (x1062, x1063) = fiat_p384_scalar_addcarryx_u32(x1061, x1038, (0x0 as u32));
    let mut x1064: u32 = 0;
    let mut x1065: fiat_p384_scalar_u1 = 0;
    let (x1064, x1065) = fiat_p384_scalar_addcarryx_u32(x1063, x1040, (0x0 as u32));
    let mut x1066: u32 = 0;
    let mut x1067: fiat_p384_scalar_u1 = 0;
    let (x1066, x1067) = fiat_p384_scalar_addcarryx_u32(x1065, x1042, (0x0 as u32));
    let mut x1068: u32 = 0;
    let mut x1069: fiat_p384_scalar_u1 = 0;
    let (x1068, x1069) = fiat_p384_scalar_addcarryx_u32(x1067, x1044, (0x0 as u32));
    let mut x1070: u32 = 0;
    let mut x1071: fiat_p384_scalar_u1 = 0;
    let (x1070, x1071) = fiat_p384_scalar_addcarryx_u32(x1069, x1046, (0x0 as u32));
    let mut x1072: u32 = 0;
    let mut x1073: fiat_p384_scalar_u1 = 0;
    let (x1072, x1073) = fiat_p384_scalar_addcarryx_u32(x1071, x1048, (0x0 as u32));
    let mut x1074: u32 = 0;
    let mut x1075: fiat_p384_scalar_u1 = 0;
    let (x1074, x1075) = fiat_p384_scalar_addcarryx_u32(x1073, x1050, (0x0 as u32));
    let mut x1076: u32 = 0;
    let mut x1077: fiat_p384_scalar_u1 = 0;
    let (x1076, x1077) = fiat_p384_scalar_addcarryx_u32(x1075, x1052, (0x0 as u32));
    let mut x1078: u32 = 0;
    let mut x1079: fiat_p384_scalar_u1 = 0;
    let (x1078, x1079) = fiat_p384_scalar_addcarryx_u32(x1077, x1054, (0x0 as u32));
    let mut x1080: u32 = 0;
    let mut x1081: u32 = 0;
    let (x1080, x1081) = fiat_p384_scalar_mulx_u32(x1056, 0xe88fdc45);
    let mut x1082: u32 = 0;
    let mut x1083: u32 = 0;
    let (x1082, x1083) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let mut x1084: u32 = 0;
    let mut x1085: u32 = 0;
    let (x1084, x1085) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let mut x1086: u32 = 0;
    let mut x1087: u32 = 0;
    let (x1086, x1087) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let mut x1088: u32 = 0;
    let mut x1089: u32 = 0;
    let (x1088, x1089) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let mut x1090: u32 = 0;
    let mut x1091: u32 = 0;
    let (x1090, x1091) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let mut x1092: u32 = 0;
    let mut x1093: u32 = 0;
    let (x1092, x1093) = fiat_p384_scalar_mulx_u32(x1080, 0xffffffff);
    let mut x1094: u32 = 0;
    let mut x1095: u32 = 0;
    let (x1094, x1095) = fiat_p384_scalar_mulx_u32(x1080, 0xc7634d81);
    let mut x1096: u32 = 0;
    let mut x1097: u32 = 0;
    let (x1096, x1097) = fiat_p384_scalar_mulx_u32(x1080, 0xf4372ddf);
    let mut x1098: u32 = 0;
    let mut x1099: u32 = 0;
    let (x1098, x1099) = fiat_p384_scalar_mulx_u32(x1080, 0x581a0db2);
    let mut x1100: u32 = 0;
    let mut x1101: u32 = 0;
    let (x1100, x1101) = fiat_p384_scalar_mulx_u32(x1080, 0x48b0a77a);
    let mut x1102: u32 = 0;
    let mut x1103: u32 = 0;
    let (x1102, x1103) = fiat_p384_scalar_mulx_u32(x1080, 0xecec196a);
    let mut x1104: u32 = 0;
    let mut x1105: u32 = 0;
    let (x1104, x1105) = fiat_p384_scalar_mulx_u32(x1080, 0xccc52973);
    let mut x1106: u32 = 0;
    let mut x1107: fiat_p384_scalar_u1 = 0;
    let (x1106, x1107) = fiat_p384_scalar_addcarryx_u32(0x0, x1105, x1102);
    let mut x1108: u32 = 0;
    let mut x1109: fiat_p384_scalar_u1 = 0;
    let (x1108, x1109) = fiat_p384_scalar_addcarryx_u32(x1107, x1103, x1100);
    let mut x1110: u32 = 0;
    let mut x1111: fiat_p384_scalar_u1 = 0;
    let (x1110, x1111) = fiat_p384_scalar_addcarryx_u32(x1109, x1101, x1098);
    let mut x1112: u32 = 0;
    let mut x1113: fiat_p384_scalar_u1 = 0;
    let (x1112, x1113) = fiat_p384_scalar_addcarryx_u32(x1111, x1099, x1096);
    let mut x1114: u32 = 0;
    let mut x1115: fiat_p384_scalar_u1 = 0;
    let (x1114, x1115) = fiat_p384_scalar_addcarryx_u32(x1113, x1097, x1094);
    let mut x1116: u32 = 0;
    let mut x1117: fiat_p384_scalar_u1 = 0;
    let (x1116, x1117) = fiat_p384_scalar_addcarryx_u32(x1115, x1095, x1092);
    let mut x1118: u32 = 0;
    let mut x1119: fiat_p384_scalar_u1 = 0;
    let (x1118, x1119) = fiat_p384_scalar_addcarryx_u32(x1117, x1093, x1090);
    let mut x1120: u32 = 0;
    let mut x1121: fiat_p384_scalar_u1 = 0;
    let (x1120, x1121) = fiat_p384_scalar_addcarryx_u32(x1119, x1091, x1088);
    let mut x1122: u32 = 0;
    let mut x1123: fiat_p384_scalar_u1 = 0;
    let (x1122, x1123) = fiat_p384_scalar_addcarryx_u32(x1121, x1089, x1086);
    let mut x1124: u32 = 0;
    let mut x1125: fiat_p384_scalar_u1 = 0;
    let (x1124, x1125) = fiat_p384_scalar_addcarryx_u32(x1123, x1087, x1084);
    let mut x1126: u32 = 0;
    let mut x1127: fiat_p384_scalar_u1 = 0;
    let (x1126, x1127) = fiat_p384_scalar_addcarryx_u32(x1125, x1085, x1082);
    let mut x1128: u32 = 0;
    let mut x1129: fiat_p384_scalar_u1 = 0;
    let (x1128, x1129) = fiat_p384_scalar_addcarryx_u32(0x0, x1056, x1104);
    let mut x1130: u32 = 0;
    let mut x1131: fiat_p384_scalar_u1 = 0;
    let (x1130, x1131) = fiat_p384_scalar_addcarryx_u32(x1129, x1058, x1106);
    let mut x1132: u32 = 0;
    let mut x1133: fiat_p384_scalar_u1 = 0;
    let (x1132, x1133) = fiat_p384_scalar_addcarryx_u32(x1131, x1060, x1108);
    let mut x1134: u32 = 0;
    let mut x1135: fiat_p384_scalar_u1 = 0;
    let (x1134, x1135) = fiat_p384_scalar_addcarryx_u32(x1133, x1062, x1110);
    let mut x1136: u32 = 0;
    let mut x1137: fiat_p384_scalar_u1 = 0;
    let (x1136, x1137) = fiat_p384_scalar_addcarryx_u32(x1135, x1064, x1112);
    let mut x1138: u32 = 0;
    let mut x1139: fiat_p384_scalar_u1 = 0;
    let (x1138, x1139) = fiat_p384_scalar_addcarryx_u32(x1137, x1066, x1114);
    let mut x1140: u32 = 0;
    let mut x1141: fiat_p384_scalar_u1 = 0;
    let (x1140, x1141) = fiat_p384_scalar_addcarryx_u32(x1139, x1068, x1116);
    let mut x1142: u32 = 0;
    let mut x1143: fiat_p384_scalar_u1 = 0;
    let (x1142, x1143) = fiat_p384_scalar_addcarryx_u32(x1141, x1070, x1118);
    let mut x1144: u32 = 0;
    let mut x1145: fiat_p384_scalar_u1 = 0;
    let (x1144, x1145) = fiat_p384_scalar_addcarryx_u32(x1143, x1072, x1120);
    let mut x1146: u32 = 0;
    let mut x1147: fiat_p384_scalar_u1 = 0;
    let (x1146, x1147) = fiat_p384_scalar_addcarryx_u32(x1145, x1074, x1122);
    let mut x1148: u32 = 0;
    let mut x1149: fiat_p384_scalar_u1 = 0;
    let (x1148, x1149) = fiat_p384_scalar_addcarryx_u32(x1147, x1076, x1124);
    let mut x1150: u32 = 0;
    let mut x1151: fiat_p384_scalar_u1 = 0;
    let (x1150, x1151) = fiat_p384_scalar_addcarryx_u32(x1149, x1078, x1126);
    let mut x1152: u32 = 0;
    let mut x1153: fiat_p384_scalar_u1 = 0;
    let (x1152, x1153) = fiat_p384_scalar_addcarryx_u32(
        x1151,
        ((x1079 as u32) + (x1055 as u32)),
        ((x1127 as u32) + x1083),
    );
    let mut x1154: u32 = 0;
    let mut x1155: fiat_p384_scalar_u1 = 0;
    let (x1154, x1155) = fiat_p384_scalar_subborrowx_u32(0x0, x1130, 0xccc52973);
    let mut x1156: u32 = 0;
    let mut x1157: fiat_p384_scalar_u1 = 0;
    let (x1156, x1157) = fiat_p384_scalar_subborrowx_u32(x1155, x1132, 0xecec196a);
    let mut x1158: u32 = 0;
    let mut x1159: fiat_p384_scalar_u1 = 0;
    let (x1158, x1159) = fiat_p384_scalar_subborrowx_u32(x1157, x1134, 0x48b0a77a);
    let mut x1160: u32 = 0;
    let mut x1161: fiat_p384_scalar_u1 = 0;
    let (x1160, x1161) = fiat_p384_scalar_subborrowx_u32(x1159, x1136, 0x581a0db2);
    let mut x1162: u32 = 0;
    let mut x1163: fiat_p384_scalar_u1 = 0;
    let (x1162, x1163) = fiat_p384_scalar_subborrowx_u32(x1161, x1138, 0xf4372ddf);
    let mut x1164: u32 = 0;
    let mut x1165: fiat_p384_scalar_u1 = 0;
    let (x1164, x1165) = fiat_p384_scalar_subborrowx_u32(x1163, x1140, 0xc7634d81);
    let mut x1166: u32 = 0;
    let mut x1167: fiat_p384_scalar_u1 = 0;
    let (x1166, x1167) = fiat_p384_scalar_subborrowx_u32(x1165, x1142, 0xffffffff);
    let mut x1168: u32 = 0;
    let mut x1169: fiat_p384_scalar_u1 = 0;
    let (x1168, x1169) = fiat_p384_scalar_subborrowx_u32(x1167, x1144, 0xffffffff);
    let mut x1170: u32 = 0;
    let mut x1171: fiat_p384_scalar_u1 = 0;
    let (x1170, x1171) = fiat_p384_scalar_subborrowx_u32(x1169, x1146, 0xffffffff);
    let mut x1172: u32 = 0;
    let mut x1173: fiat_p384_scalar_u1 = 0;
    let (x1172, x1173) = fiat_p384_scalar_subborrowx_u32(x1171, x1148, 0xffffffff);
    let mut x1174: u32 = 0;
    let mut x1175: fiat_p384_scalar_u1 = 0;
    let (x1174, x1175) = fiat_p384_scalar_subborrowx_u32(x1173, x1150, 0xffffffff);
    let mut x1176: u32 = 0;
    let mut x1177: fiat_p384_scalar_u1 = 0;
    let (x1176, x1177) = fiat_p384_scalar_subborrowx_u32(x1175, x1152, 0xffffffff);
    let mut x1178: u32 = 0;
    let mut x1179: fiat_p384_scalar_u1 = 0;
    let (x1178, x1179) = fiat_p384_scalar_subborrowx_u32(x1177, (x1153 as u32), (0x0 as u32));
    let mut x1180: u32 = 0;
    let (x1180) = fiat_p384_scalar_cmovznz_u32(x1179, x1154, x1130);
    let mut x1181: u32 = 0;
    let (x1181) = fiat_p384_scalar_cmovznz_u32(x1179, x1156, x1132);
    let mut x1182: u32 = 0;
    let (x1182) = fiat_p384_scalar_cmovznz_u32(x1179, x1158, x1134);
    let mut x1183: u32 = 0;
    let (x1183) = fiat_p384_scalar_cmovznz_u32(x1179, x1160, x1136);
    let mut x1184: u32 = 0;
    let (x1184) = fiat_p384_scalar_cmovznz_u32(x1179, x1162, x1138);
    let mut x1185: u32 = 0;
    let (x1185) = fiat_p384_scalar_cmovznz_u32(x1179, x1164, x1140);
    let mut x1186: u32 = 0;
    let (x1186) = fiat_p384_scalar_cmovznz_u32(x1179, x1166, x1142);
    let mut x1187: u32 = 0;
    let (x1187) = fiat_p384_scalar_cmovznz_u32(x1179, x1168, x1144);
    let mut x1188: u32 = 0;
    let (x1188) = fiat_p384_scalar_cmovznz_u32(x1179, x1170, x1146);
    let mut x1189: u32 = 0;
    let (x1189) = fiat_p384_scalar_cmovznz_u32(x1179, x1172, x1148);
    let mut x1190: u32 = 0;
    let (x1190) = fiat_p384_scalar_cmovznz_u32(x1179, x1174, x1150);
    let mut x1191: u32 = 0;
    let (x1191) = fiat_p384_scalar_cmovznz_u32(x1179, x1176, x1152);
    out1[0] = x1180;
    out1[1] = x1181;
    out1[2] = x1182;
    out1[3] = x1183;
    out1[4] = x1184;
    out1[5] = x1185;
    out1[6] = x1186;
    out1[7] = x1187;
    out1[8] = x1188;
    out1[9] = x1189;
    out1[10] = x1190;
    out1[11] = x1191;
    out1
}
#[doc = " The function fiat_p384_scalar_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_to_montgomery(
    arg1: &fiat_p384_scalar_non_montgomery_domain_field_element,
) -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[7]);
    let x8: u32 = (arg1[8]);
    let x9: u32 = (arg1[9]);
    let x10: u32 = (arg1[10]);
    let x11: u32 = (arg1[11]);
    let x12: u32 = (arg1[0]);
    let mut x13: u32 = 0;
    let mut x14: u32 = 0;
    let (x13, x14) = fiat_p384_scalar_mulx_u32(x12, 0xc84ee01);
    let mut x15: u32 = 0;
    let mut x16: u32 = 0;
    let (x15, x16) = fiat_p384_scalar_mulx_u32(x12, 0x2b39bf21);
    let mut x17: u32 = 0;
    let mut x18: u32 = 0;
    let (x17, x18) = fiat_p384_scalar_mulx_u32(x12, 0x3fb05b7a);
    let mut x19: u32 = 0;
    let mut x20: u32 = 0;
    let (x19, x20) = fiat_p384_scalar_mulx_u32(x12, 0x28266895);
    let mut x21: u32 = 0;
    let mut x22: u32 = 0;
    let (x21, x22) = fiat_p384_scalar_mulx_u32(x12, 0xd40d4917);
    let mut x23: u32 = 0;
    let mut x24: u32 = 0;
    let (x23, x24) = fiat_p384_scalar_mulx_u32(x12, 0x4aab1cc5);
    let mut x25: u32 = 0;
    let mut x26: u32 = 0;
    let (x25, x26) = fiat_p384_scalar_mulx_u32(x12, 0xbc3e483a);
    let mut x27: u32 = 0;
    let mut x28: u32 = 0;
    let (x27, x28) = fiat_p384_scalar_mulx_u32(x12, 0xfcb82947);
    let mut x29: u32 = 0;
    let mut x30: u32 = 0;
    let (x29, x30) = fiat_p384_scalar_mulx_u32(x12, 0xff3d81e5);
    let mut x31: u32 = 0;
    let mut x32: u32 = 0;
    let (x31, x32) = fiat_p384_scalar_mulx_u32(x12, 0xdf1aa419);
    let mut x33: u32 = 0;
    let mut x34: u32 = 0;
    let (x33, x34) = fiat_p384_scalar_mulx_u32(x12, 0x2d319b24);
    let mut x35: u32 = 0;
    let mut x36: u32 = 0;
    let (x35, x36) = fiat_p384_scalar_mulx_u32(x12, 0x19b409a9);
    let mut x37: u32 = 0;
    let mut x38: fiat_p384_scalar_u1 = 0;
    let (x37, x38) = fiat_p384_scalar_addcarryx_u32(0x0, x36, x33);
    let mut x39: u32 = 0;
    let mut x40: fiat_p384_scalar_u1 = 0;
    let (x39, x40) = fiat_p384_scalar_addcarryx_u32(x38, x34, x31);
    let mut x41: u32 = 0;
    let mut x42: fiat_p384_scalar_u1 = 0;
    let (x41, x42) = fiat_p384_scalar_addcarryx_u32(x40, x32, x29);
    let mut x43: u32 = 0;
    let mut x44: fiat_p384_scalar_u1 = 0;
    let (x43, x44) = fiat_p384_scalar_addcarryx_u32(x42, x30, x27);
    let mut x45: u32 = 0;
    let mut x46: fiat_p384_scalar_u1 = 0;
    let (x45, x46) = fiat_p384_scalar_addcarryx_u32(x44, x28, x25);
    let mut x47: u32 = 0;
    let mut x48: fiat_p384_scalar_u1 = 0;
    let (x47, x48) = fiat_p384_scalar_addcarryx_u32(x46, x26, x23);
    let mut x49: u32 = 0;
    let mut x50: fiat_p384_scalar_u1 = 0;
    let (x49, x50) = fiat_p384_scalar_addcarryx_u32(x48, x24, x21);
    let mut x51: u32 = 0;
    let mut x52: fiat_p384_scalar_u1 = 0;
    let (x51, x52) = fiat_p384_scalar_addcarryx_u32(x50, x22, x19);
    let mut x53: u32 = 0;
    let mut x54: fiat_p384_scalar_u1 = 0;
    let (x53, x54) = fiat_p384_scalar_addcarryx_u32(x52, x20, x17);
    let mut x55: u32 = 0;
    let mut x56: fiat_p384_scalar_u1 = 0;
    let (x55, x56) = fiat_p384_scalar_addcarryx_u32(x54, x18, x15);
    let mut x57: u32 = 0;
    let mut x58: fiat_p384_scalar_u1 = 0;
    let (x57, x58) = fiat_p384_scalar_addcarryx_u32(x56, x16, x13);
    let mut x59: u32 = 0;
    let mut x60: u32 = 0;
    let (x59, x60) = fiat_p384_scalar_mulx_u32(x35, 0xe88fdc45);
    let mut x61: u32 = 0;
    let mut x62: u32 = 0;
    let (x61, x62) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let mut x63: u32 = 0;
    let mut x64: u32 = 0;
    let (x63, x64) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let mut x65: u32 = 0;
    let mut x66: u32 = 0;
    let (x65, x66) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let mut x67: u32 = 0;
    let mut x68: u32 = 0;
    let (x67, x68) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let mut x69: u32 = 0;
    let mut x70: u32 = 0;
    let (x69, x70) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let mut x71: u32 = 0;
    let mut x72: u32 = 0;
    let (x71, x72) = fiat_p384_scalar_mulx_u32(x59, 0xffffffff);
    let mut x73: u32 = 0;
    let mut x74: u32 = 0;
    let (x73, x74) = fiat_p384_scalar_mulx_u32(x59, 0xc7634d81);
    let mut x75: u32 = 0;
    let mut x76: u32 = 0;
    let (x75, x76) = fiat_p384_scalar_mulx_u32(x59, 0xf4372ddf);
    let mut x77: u32 = 0;
    let mut x78: u32 = 0;
    let (x77, x78) = fiat_p384_scalar_mulx_u32(x59, 0x581a0db2);
    let mut x79: u32 = 0;
    let mut x80: u32 = 0;
    let (x79, x80) = fiat_p384_scalar_mulx_u32(x59, 0x48b0a77a);
    let mut x81: u32 = 0;
    let mut x82: u32 = 0;
    let (x81, x82) = fiat_p384_scalar_mulx_u32(x59, 0xecec196a);
    let mut x83: u32 = 0;
    let mut x84: u32 = 0;
    let (x83, x84) = fiat_p384_scalar_mulx_u32(x59, 0xccc52973);
    let mut x85: u32 = 0;
    let mut x86: fiat_p384_scalar_u1 = 0;
    let (x85, x86) = fiat_p384_scalar_addcarryx_u32(0x0, x84, x81);
    let mut x87: u32 = 0;
    let mut x88: fiat_p384_scalar_u1 = 0;
    let (x87, x88) = fiat_p384_scalar_addcarryx_u32(x86, x82, x79);
    let mut x89: u32 = 0;
    let mut x90: fiat_p384_scalar_u1 = 0;
    let (x89, x90) = fiat_p384_scalar_addcarryx_u32(x88, x80, x77);
    let mut x91: u32 = 0;
    let mut x92: fiat_p384_scalar_u1 = 0;
    let (x91, x92) = fiat_p384_scalar_addcarryx_u32(x90, x78, x75);
    let mut x93: u32 = 0;
    let mut x94: fiat_p384_scalar_u1 = 0;
    let (x93, x94) = fiat_p384_scalar_addcarryx_u32(x92, x76, x73);
    let mut x95: u32 = 0;
    let mut x96: fiat_p384_scalar_u1 = 0;
    let (x95, x96) = fiat_p384_scalar_addcarryx_u32(x94, x74, x71);
    let mut x97: u32 = 0;
    let mut x98: fiat_p384_scalar_u1 = 0;
    let (x97, x98) = fiat_p384_scalar_addcarryx_u32(x96, x72, x69);
    let mut x99: u32 = 0;
    let mut x100: fiat_p384_scalar_u1 = 0;
    let (x99, x100) = fiat_p384_scalar_addcarryx_u32(x98, x70, x67);
    let mut x101: u32 = 0;
    let mut x102: fiat_p384_scalar_u1 = 0;
    let (x101, x102) = fiat_p384_scalar_addcarryx_u32(x100, x68, x65);
    let mut x103: u32 = 0;
    let mut x104: fiat_p384_scalar_u1 = 0;
    let (x103, x104) = fiat_p384_scalar_addcarryx_u32(x102, x66, x63);
    let mut x105: u32 = 0;
    let mut x106: fiat_p384_scalar_u1 = 0;
    let (x105, x106) = fiat_p384_scalar_addcarryx_u32(x104, x64, x61);
    let mut x107: u32 = 0;
    let mut x108: fiat_p384_scalar_u1 = 0;
    let (x107, x108) = fiat_p384_scalar_addcarryx_u32(0x0, x35, x83);
    let mut x109: u32 = 0;
    let mut x110: fiat_p384_scalar_u1 = 0;
    let (x109, x110) = fiat_p384_scalar_addcarryx_u32(x108, x37, x85);
    let mut x111: u32 = 0;
    let mut x112: fiat_p384_scalar_u1 = 0;
    let (x111, x112) = fiat_p384_scalar_addcarryx_u32(x110, x39, x87);
    let mut x113: u32 = 0;
    let mut x114: fiat_p384_scalar_u1 = 0;
    let (x113, x114) = fiat_p384_scalar_addcarryx_u32(x112, x41, x89);
    let mut x115: u32 = 0;
    let mut x116: fiat_p384_scalar_u1 = 0;
    let (x115, x116) = fiat_p384_scalar_addcarryx_u32(x114, x43, x91);
    let mut x117: u32 = 0;
    let mut x118: fiat_p384_scalar_u1 = 0;
    let (x117, x118) = fiat_p384_scalar_addcarryx_u32(x116, x45, x93);
    let mut x119: u32 = 0;
    let mut x120: fiat_p384_scalar_u1 = 0;
    let (x119, x120) = fiat_p384_scalar_addcarryx_u32(x118, x47, x95);
    let mut x121: u32 = 0;
    let mut x122: fiat_p384_scalar_u1 = 0;
    let (x121, x122) = fiat_p384_scalar_addcarryx_u32(x120, x49, x97);
    let mut x123: u32 = 0;
    let mut x124: fiat_p384_scalar_u1 = 0;
    let (x123, x124) = fiat_p384_scalar_addcarryx_u32(x122, x51, x99);
    let mut x125: u32 = 0;
    let mut x126: fiat_p384_scalar_u1 = 0;
    let (x125, x126) = fiat_p384_scalar_addcarryx_u32(x124, x53, x101);
    let mut x127: u32 = 0;
    let mut x128: fiat_p384_scalar_u1 = 0;
    let (x127, x128) = fiat_p384_scalar_addcarryx_u32(x126, x55, x103);
    let mut x129: u32 = 0;
    let mut x130: fiat_p384_scalar_u1 = 0;
    let (x129, x130) = fiat_p384_scalar_addcarryx_u32(x128, x57, x105);
    let mut x131: u32 = 0;
    let mut x132: fiat_p384_scalar_u1 = 0;
    let (x131, x132) =
        fiat_p384_scalar_addcarryx_u32(x130, ((x58 as u32) + x14), ((x106 as u32) + x62));
    let mut x133: u32 = 0;
    let mut x134: u32 = 0;
    let (x133, x134) = fiat_p384_scalar_mulx_u32(x1, 0xc84ee01);
    let mut x135: u32 = 0;
    let mut x136: u32 = 0;
    let (x135, x136) = fiat_p384_scalar_mulx_u32(x1, 0x2b39bf21);
    let mut x137: u32 = 0;
    let mut x138: u32 = 0;
    let (x137, x138) = fiat_p384_scalar_mulx_u32(x1, 0x3fb05b7a);
    let mut x139: u32 = 0;
    let mut x140: u32 = 0;
    let (x139, x140) = fiat_p384_scalar_mulx_u32(x1, 0x28266895);
    let mut x141: u32 = 0;
    let mut x142: u32 = 0;
    let (x141, x142) = fiat_p384_scalar_mulx_u32(x1, 0xd40d4917);
    let mut x143: u32 = 0;
    let mut x144: u32 = 0;
    let (x143, x144) = fiat_p384_scalar_mulx_u32(x1, 0x4aab1cc5);
    let mut x145: u32 = 0;
    let mut x146: u32 = 0;
    let (x145, x146) = fiat_p384_scalar_mulx_u32(x1, 0xbc3e483a);
    let mut x147: u32 = 0;
    let mut x148: u32 = 0;
    let (x147, x148) = fiat_p384_scalar_mulx_u32(x1, 0xfcb82947);
    let mut x149: u32 = 0;
    let mut x150: u32 = 0;
    let (x149, x150) = fiat_p384_scalar_mulx_u32(x1, 0xff3d81e5);
    let mut x151: u32 = 0;
    let mut x152: u32 = 0;
    let (x151, x152) = fiat_p384_scalar_mulx_u32(x1, 0xdf1aa419);
    let mut x153: u32 = 0;
    let mut x154: u32 = 0;
    let (x153, x154) = fiat_p384_scalar_mulx_u32(x1, 0x2d319b24);
    let mut x155: u32 = 0;
    let mut x156: u32 = 0;
    let (x155, x156) = fiat_p384_scalar_mulx_u32(x1, 0x19b409a9);
    let mut x157: u32 = 0;
    let mut x158: fiat_p384_scalar_u1 = 0;
    let (x157, x158) = fiat_p384_scalar_addcarryx_u32(0x0, x156, x153);
    let mut x159: u32 = 0;
    let mut x160: fiat_p384_scalar_u1 = 0;
    let (x159, x160) = fiat_p384_scalar_addcarryx_u32(x158, x154, x151);
    let mut x161: u32 = 0;
    let mut x162: fiat_p384_scalar_u1 = 0;
    let (x161, x162) = fiat_p384_scalar_addcarryx_u32(x160, x152, x149);
    let mut x163: u32 = 0;
    let mut x164: fiat_p384_scalar_u1 = 0;
    let (x163, x164) = fiat_p384_scalar_addcarryx_u32(x162, x150, x147);
    let mut x165: u32 = 0;
    let mut x166: fiat_p384_scalar_u1 = 0;
    let (x165, x166) = fiat_p384_scalar_addcarryx_u32(x164, x148, x145);
    let mut x167: u32 = 0;
    let mut x168: fiat_p384_scalar_u1 = 0;
    let (x167, x168) = fiat_p384_scalar_addcarryx_u32(x166, x146, x143);
    let mut x169: u32 = 0;
    let mut x170: fiat_p384_scalar_u1 = 0;
    let (x169, x170) = fiat_p384_scalar_addcarryx_u32(x168, x144, x141);
    let mut x171: u32 = 0;
    let mut x172: fiat_p384_scalar_u1 = 0;
    let (x171, x172) = fiat_p384_scalar_addcarryx_u32(x170, x142, x139);
    let mut x173: u32 = 0;
    let mut x174: fiat_p384_scalar_u1 = 0;
    let (x173, x174) = fiat_p384_scalar_addcarryx_u32(x172, x140, x137);
    let mut x175: u32 = 0;
    let mut x176: fiat_p384_scalar_u1 = 0;
    let (x175, x176) = fiat_p384_scalar_addcarryx_u32(x174, x138, x135);
    let mut x177: u32 = 0;
    let mut x178: fiat_p384_scalar_u1 = 0;
    let (x177, x178) = fiat_p384_scalar_addcarryx_u32(x176, x136, x133);
    let mut x179: u32 = 0;
    let mut x180: fiat_p384_scalar_u1 = 0;
    let (x179, x180) = fiat_p384_scalar_addcarryx_u32(0x0, x109, x155);
    let mut x181: u32 = 0;
    let mut x182: fiat_p384_scalar_u1 = 0;
    let (x181, x182) = fiat_p384_scalar_addcarryx_u32(x180, x111, x157);
    let mut x183: u32 = 0;
    let mut x184: fiat_p384_scalar_u1 = 0;
    let (x183, x184) = fiat_p384_scalar_addcarryx_u32(x182, x113, x159);
    let mut x185: u32 = 0;
    let mut x186: fiat_p384_scalar_u1 = 0;
    let (x185, x186) = fiat_p384_scalar_addcarryx_u32(x184, x115, x161);
    let mut x187: u32 = 0;
    let mut x188: fiat_p384_scalar_u1 = 0;
    let (x187, x188) = fiat_p384_scalar_addcarryx_u32(x186, x117, x163);
    let mut x189: u32 = 0;
    let mut x190: fiat_p384_scalar_u1 = 0;
    let (x189, x190) = fiat_p384_scalar_addcarryx_u32(x188, x119, x165);
    let mut x191: u32 = 0;
    let mut x192: fiat_p384_scalar_u1 = 0;
    let (x191, x192) = fiat_p384_scalar_addcarryx_u32(x190, x121, x167);
    let mut x193: u32 = 0;
    let mut x194: fiat_p384_scalar_u1 = 0;
    let (x193, x194) = fiat_p384_scalar_addcarryx_u32(x192, x123, x169);
    let mut x195: u32 = 0;
    let mut x196: fiat_p384_scalar_u1 = 0;
    let (x195, x196) = fiat_p384_scalar_addcarryx_u32(x194, x125, x171);
    let mut x197: u32 = 0;
    let mut x198: fiat_p384_scalar_u1 = 0;
    let (x197, x198) = fiat_p384_scalar_addcarryx_u32(x196, x127, x173);
    let mut x199: u32 = 0;
    let mut x200: fiat_p384_scalar_u1 = 0;
    let (x199, x200) = fiat_p384_scalar_addcarryx_u32(x198, x129, x175);
    let mut x201: u32 = 0;
    let mut x202: fiat_p384_scalar_u1 = 0;
    let (x201, x202) = fiat_p384_scalar_addcarryx_u32(x200, x131, x177);
    let mut x203: u32 = 0;
    let mut x204: u32 = 0;
    let (x203, x204) = fiat_p384_scalar_mulx_u32(x179, 0xe88fdc45);
    let mut x205: u32 = 0;
    let mut x206: u32 = 0;
    let (x205, x206) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let mut x207: u32 = 0;
    let mut x208: u32 = 0;
    let (x207, x208) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let mut x209: u32 = 0;
    let mut x210: u32 = 0;
    let (x209, x210) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let mut x211: u32 = 0;
    let mut x212: u32 = 0;
    let (x211, x212) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let mut x213: u32 = 0;
    let mut x214: u32 = 0;
    let (x213, x214) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let mut x215: u32 = 0;
    let mut x216: u32 = 0;
    let (x215, x216) = fiat_p384_scalar_mulx_u32(x203, 0xffffffff);
    let mut x217: u32 = 0;
    let mut x218: u32 = 0;
    let (x217, x218) = fiat_p384_scalar_mulx_u32(x203, 0xc7634d81);
    let mut x219: u32 = 0;
    let mut x220: u32 = 0;
    let (x219, x220) = fiat_p384_scalar_mulx_u32(x203, 0xf4372ddf);
    let mut x221: u32 = 0;
    let mut x222: u32 = 0;
    let (x221, x222) = fiat_p384_scalar_mulx_u32(x203, 0x581a0db2);
    let mut x223: u32 = 0;
    let mut x224: u32 = 0;
    let (x223, x224) = fiat_p384_scalar_mulx_u32(x203, 0x48b0a77a);
    let mut x225: u32 = 0;
    let mut x226: u32 = 0;
    let (x225, x226) = fiat_p384_scalar_mulx_u32(x203, 0xecec196a);
    let mut x227: u32 = 0;
    let mut x228: u32 = 0;
    let (x227, x228) = fiat_p384_scalar_mulx_u32(x203, 0xccc52973);
    let mut x229: u32 = 0;
    let mut x230: fiat_p384_scalar_u1 = 0;
    let (x229, x230) = fiat_p384_scalar_addcarryx_u32(0x0, x228, x225);
    let mut x231: u32 = 0;
    let mut x232: fiat_p384_scalar_u1 = 0;
    let (x231, x232) = fiat_p384_scalar_addcarryx_u32(x230, x226, x223);
    let mut x233: u32 = 0;
    let mut x234: fiat_p384_scalar_u1 = 0;
    let (x233, x234) = fiat_p384_scalar_addcarryx_u32(x232, x224, x221);
    let mut x235: u32 = 0;
    let mut x236: fiat_p384_scalar_u1 = 0;
    let (x235, x236) = fiat_p384_scalar_addcarryx_u32(x234, x222, x219);
    let mut x237: u32 = 0;
    let mut x238: fiat_p384_scalar_u1 = 0;
    let (x237, x238) = fiat_p384_scalar_addcarryx_u32(x236, x220, x217);
    let mut x239: u32 = 0;
    let mut x240: fiat_p384_scalar_u1 = 0;
    let (x239, x240) = fiat_p384_scalar_addcarryx_u32(x238, x218, x215);
    let mut x241: u32 = 0;
    let mut x242: fiat_p384_scalar_u1 = 0;
    let (x241, x242) = fiat_p384_scalar_addcarryx_u32(x240, x216, x213);
    let mut x243: u32 = 0;
    let mut x244: fiat_p384_scalar_u1 = 0;
    let (x243, x244) = fiat_p384_scalar_addcarryx_u32(x242, x214, x211);
    let mut x245: u32 = 0;
    let mut x246: fiat_p384_scalar_u1 = 0;
    let (x245, x246) = fiat_p384_scalar_addcarryx_u32(x244, x212, x209);
    let mut x247: u32 = 0;
    let mut x248: fiat_p384_scalar_u1 = 0;
    let (x247, x248) = fiat_p384_scalar_addcarryx_u32(x246, x210, x207);
    let mut x249: u32 = 0;
    let mut x250: fiat_p384_scalar_u1 = 0;
    let (x249, x250) = fiat_p384_scalar_addcarryx_u32(x248, x208, x205);
    let mut x251: u32 = 0;
    let mut x252: fiat_p384_scalar_u1 = 0;
    let (x251, x252) = fiat_p384_scalar_addcarryx_u32(0x0, x179, x227);
    let mut x253: u32 = 0;
    let mut x254: fiat_p384_scalar_u1 = 0;
    let (x253, x254) = fiat_p384_scalar_addcarryx_u32(x252, x181, x229);
    let mut x255: u32 = 0;
    let mut x256: fiat_p384_scalar_u1 = 0;
    let (x255, x256) = fiat_p384_scalar_addcarryx_u32(x254, x183, x231);
    let mut x257: u32 = 0;
    let mut x258: fiat_p384_scalar_u1 = 0;
    let (x257, x258) = fiat_p384_scalar_addcarryx_u32(x256, x185, x233);
    let mut x259: u32 = 0;
    let mut x260: fiat_p384_scalar_u1 = 0;
    let (x259, x260) = fiat_p384_scalar_addcarryx_u32(x258, x187, x235);
    let mut x261: u32 = 0;
    let mut x262: fiat_p384_scalar_u1 = 0;
    let (x261, x262) = fiat_p384_scalar_addcarryx_u32(x260, x189, x237);
    let mut x263: u32 = 0;
    let mut x264: fiat_p384_scalar_u1 = 0;
    let (x263, x264) = fiat_p384_scalar_addcarryx_u32(x262, x191, x239);
    let mut x265: u32 = 0;
    let mut x266: fiat_p384_scalar_u1 = 0;
    let (x265, x266) = fiat_p384_scalar_addcarryx_u32(x264, x193, x241);
    let mut x267: u32 = 0;
    let mut x268: fiat_p384_scalar_u1 = 0;
    let (x267, x268) = fiat_p384_scalar_addcarryx_u32(x266, x195, x243);
    let mut x269: u32 = 0;
    let mut x270: fiat_p384_scalar_u1 = 0;
    let (x269, x270) = fiat_p384_scalar_addcarryx_u32(x268, x197, x245);
    let mut x271: u32 = 0;
    let mut x272: fiat_p384_scalar_u1 = 0;
    let (x271, x272) = fiat_p384_scalar_addcarryx_u32(x270, x199, x247);
    let mut x273: u32 = 0;
    let mut x274: fiat_p384_scalar_u1 = 0;
    let (x273, x274) = fiat_p384_scalar_addcarryx_u32(x272, x201, x249);
    let mut x275: u32 = 0;
    let mut x276: fiat_p384_scalar_u1 = 0;
    let (x275, x276) = fiat_p384_scalar_addcarryx_u32(
        x274,
        (((x202 as u32) + (x132 as u32)) + ((x178 as u32) + x134)),
        ((x250 as u32) + x206),
    );
    let mut x277: u32 = 0;
    let mut x278: u32 = 0;
    let (x277, x278) = fiat_p384_scalar_mulx_u32(x2, 0xc84ee01);
    let mut x279: u32 = 0;
    let mut x280: u32 = 0;
    let (x279, x280) = fiat_p384_scalar_mulx_u32(x2, 0x2b39bf21);
    let mut x281: u32 = 0;
    let mut x282: u32 = 0;
    let (x281, x282) = fiat_p384_scalar_mulx_u32(x2, 0x3fb05b7a);
    let mut x283: u32 = 0;
    let mut x284: u32 = 0;
    let (x283, x284) = fiat_p384_scalar_mulx_u32(x2, 0x28266895);
    let mut x285: u32 = 0;
    let mut x286: u32 = 0;
    let (x285, x286) = fiat_p384_scalar_mulx_u32(x2, 0xd40d4917);
    let mut x287: u32 = 0;
    let mut x288: u32 = 0;
    let (x287, x288) = fiat_p384_scalar_mulx_u32(x2, 0x4aab1cc5);
    let mut x289: u32 = 0;
    let mut x290: u32 = 0;
    let (x289, x290) = fiat_p384_scalar_mulx_u32(x2, 0xbc3e483a);
    let mut x291: u32 = 0;
    let mut x292: u32 = 0;
    let (x291, x292) = fiat_p384_scalar_mulx_u32(x2, 0xfcb82947);
    let mut x293: u32 = 0;
    let mut x294: u32 = 0;
    let (x293, x294) = fiat_p384_scalar_mulx_u32(x2, 0xff3d81e5);
    let mut x295: u32 = 0;
    let mut x296: u32 = 0;
    let (x295, x296) = fiat_p384_scalar_mulx_u32(x2, 0xdf1aa419);
    let mut x297: u32 = 0;
    let mut x298: u32 = 0;
    let (x297, x298) = fiat_p384_scalar_mulx_u32(x2, 0x2d319b24);
    let mut x299: u32 = 0;
    let mut x300: u32 = 0;
    let (x299, x300) = fiat_p384_scalar_mulx_u32(x2, 0x19b409a9);
    let mut x301: u32 = 0;
    let mut x302: fiat_p384_scalar_u1 = 0;
    let (x301, x302) = fiat_p384_scalar_addcarryx_u32(0x0, x300, x297);
    let mut x303: u32 = 0;
    let mut x304: fiat_p384_scalar_u1 = 0;
    let (x303, x304) = fiat_p384_scalar_addcarryx_u32(x302, x298, x295);
    let mut x305: u32 = 0;
    let mut x306: fiat_p384_scalar_u1 = 0;
    let (x305, x306) = fiat_p384_scalar_addcarryx_u32(x304, x296, x293);
    let mut x307: u32 = 0;
    let mut x308: fiat_p384_scalar_u1 = 0;
    let (x307, x308) = fiat_p384_scalar_addcarryx_u32(x306, x294, x291);
    let mut x309: u32 = 0;
    let mut x310: fiat_p384_scalar_u1 = 0;
    let (x309, x310) = fiat_p384_scalar_addcarryx_u32(x308, x292, x289);
    let mut x311: u32 = 0;
    let mut x312: fiat_p384_scalar_u1 = 0;
    let (x311, x312) = fiat_p384_scalar_addcarryx_u32(x310, x290, x287);
    let mut x313: u32 = 0;
    let mut x314: fiat_p384_scalar_u1 = 0;
    let (x313, x314) = fiat_p384_scalar_addcarryx_u32(x312, x288, x285);
    let mut x315: u32 = 0;
    let mut x316: fiat_p384_scalar_u1 = 0;
    let (x315, x316) = fiat_p384_scalar_addcarryx_u32(x314, x286, x283);
    let mut x317: u32 = 0;
    let mut x318: fiat_p384_scalar_u1 = 0;
    let (x317, x318) = fiat_p384_scalar_addcarryx_u32(x316, x284, x281);
    let mut x319: u32 = 0;
    let mut x320: fiat_p384_scalar_u1 = 0;
    let (x319, x320) = fiat_p384_scalar_addcarryx_u32(x318, x282, x279);
    let mut x321: u32 = 0;
    let mut x322: fiat_p384_scalar_u1 = 0;
    let (x321, x322) = fiat_p384_scalar_addcarryx_u32(x320, x280, x277);
    let mut x323: u32 = 0;
    let mut x324: fiat_p384_scalar_u1 = 0;
    let (x323, x324) = fiat_p384_scalar_addcarryx_u32(0x0, x253, x299);
    let mut x325: u32 = 0;
    let mut x326: fiat_p384_scalar_u1 = 0;
    let (x325, x326) = fiat_p384_scalar_addcarryx_u32(x324, x255, x301);
    let mut x327: u32 = 0;
    let mut x328: fiat_p384_scalar_u1 = 0;
    let (x327, x328) = fiat_p384_scalar_addcarryx_u32(x326, x257, x303);
    let mut x329: u32 = 0;
    let mut x330: fiat_p384_scalar_u1 = 0;
    let (x329, x330) = fiat_p384_scalar_addcarryx_u32(x328, x259, x305);
    let mut x331: u32 = 0;
    let mut x332: fiat_p384_scalar_u1 = 0;
    let (x331, x332) = fiat_p384_scalar_addcarryx_u32(x330, x261, x307);
    let mut x333: u32 = 0;
    let mut x334: fiat_p384_scalar_u1 = 0;
    let (x333, x334) = fiat_p384_scalar_addcarryx_u32(x332, x263, x309);
    let mut x335: u32 = 0;
    let mut x336: fiat_p384_scalar_u1 = 0;
    let (x335, x336) = fiat_p384_scalar_addcarryx_u32(x334, x265, x311);
    let mut x337: u32 = 0;
    let mut x338: fiat_p384_scalar_u1 = 0;
    let (x337, x338) = fiat_p384_scalar_addcarryx_u32(x336, x267, x313);
    let mut x339: u32 = 0;
    let mut x340: fiat_p384_scalar_u1 = 0;
    let (x339, x340) = fiat_p384_scalar_addcarryx_u32(x338, x269, x315);
    let mut x341: u32 = 0;
    let mut x342: fiat_p384_scalar_u1 = 0;
    let (x341, x342) = fiat_p384_scalar_addcarryx_u32(x340, x271, x317);
    let mut x343: u32 = 0;
    let mut x344: fiat_p384_scalar_u1 = 0;
    let (x343, x344) = fiat_p384_scalar_addcarryx_u32(x342, x273, x319);
    let mut x345: u32 = 0;
    let mut x346: fiat_p384_scalar_u1 = 0;
    let (x345, x346) = fiat_p384_scalar_addcarryx_u32(x344, x275, x321);
    let mut x347: u32 = 0;
    let mut x348: u32 = 0;
    let (x347, x348) = fiat_p384_scalar_mulx_u32(x323, 0xe88fdc45);
    let mut x349: u32 = 0;
    let mut x350: u32 = 0;
    let (x349, x350) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let mut x351: u32 = 0;
    let mut x352: u32 = 0;
    let (x351, x352) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let mut x353: u32 = 0;
    let mut x354: u32 = 0;
    let (x353, x354) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let mut x355: u32 = 0;
    let mut x356: u32 = 0;
    let (x355, x356) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let mut x357: u32 = 0;
    let mut x358: u32 = 0;
    let (x357, x358) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let mut x359: u32 = 0;
    let mut x360: u32 = 0;
    let (x359, x360) = fiat_p384_scalar_mulx_u32(x347, 0xffffffff);
    let mut x361: u32 = 0;
    let mut x362: u32 = 0;
    let (x361, x362) = fiat_p384_scalar_mulx_u32(x347, 0xc7634d81);
    let mut x363: u32 = 0;
    let mut x364: u32 = 0;
    let (x363, x364) = fiat_p384_scalar_mulx_u32(x347, 0xf4372ddf);
    let mut x365: u32 = 0;
    let mut x366: u32 = 0;
    let (x365, x366) = fiat_p384_scalar_mulx_u32(x347, 0x581a0db2);
    let mut x367: u32 = 0;
    let mut x368: u32 = 0;
    let (x367, x368) = fiat_p384_scalar_mulx_u32(x347, 0x48b0a77a);
    let mut x369: u32 = 0;
    let mut x370: u32 = 0;
    let (x369, x370) = fiat_p384_scalar_mulx_u32(x347, 0xecec196a);
    let mut x371: u32 = 0;
    let mut x372: u32 = 0;
    let (x371, x372) = fiat_p384_scalar_mulx_u32(x347, 0xccc52973);
    let mut x373: u32 = 0;
    let mut x374: fiat_p384_scalar_u1 = 0;
    let (x373, x374) = fiat_p384_scalar_addcarryx_u32(0x0, x372, x369);
    let mut x375: u32 = 0;
    let mut x376: fiat_p384_scalar_u1 = 0;
    let (x375, x376) = fiat_p384_scalar_addcarryx_u32(x374, x370, x367);
    let mut x377: u32 = 0;
    let mut x378: fiat_p384_scalar_u1 = 0;
    let (x377, x378) = fiat_p384_scalar_addcarryx_u32(x376, x368, x365);
    let mut x379: u32 = 0;
    let mut x380: fiat_p384_scalar_u1 = 0;
    let (x379, x380) = fiat_p384_scalar_addcarryx_u32(x378, x366, x363);
    let mut x381: u32 = 0;
    let mut x382: fiat_p384_scalar_u1 = 0;
    let (x381, x382) = fiat_p384_scalar_addcarryx_u32(x380, x364, x361);
    let mut x383: u32 = 0;
    let mut x384: fiat_p384_scalar_u1 = 0;
    let (x383, x384) = fiat_p384_scalar_addcarryx_u32(x382, x362, x359);
    let mut x385: u32 = 0;
    let mut x386: fiat_p384_scalar_u1 = 0;
    let (x385, x386) = fiat_p384_scalar_addcarryx_u32(x384, x360, x357);
    let mut x387: u32 = 0;
    let mut x388: fiat_p384_scalar_u1 = 0;
    let (x387, x388) = fiat_p384_scalar_addcarryx_u32(x386, x358, x355);
    let mut x389: u32 = 0;
    let mut x390: fiat_p384_scalar_u1 = 0;
    let (x389, x390) = fiat_p384_scalar_addcarryx_u32(x388, x356, x353);
    let mut x391: u32 = 0;
    let mut x392: fiat_p384_scalar_u1 = 0;
    let (x391, x392) = fiat_p384_scalar_addcarryx_u32(x390, x354, x351);
    let mut x393: u32 = 0;
    let mut x394: fiat_p384_scalar_u1 = 0;
    let (x393, x394) = fiat_p384_scalar_addcarryx_u32(x392, x352, x349);
    let mut x395: u32 = 0;
    let mut x396: fiat_p384_scalar_u1 = 0;
    let (x395, x396) = fiat_p384_scalar_addcarryx_u32(0x0, x323, x371);
    let mut x397: u32 = 0;
    let mut x398: fiat_p384_scalar_u1 = 0;
    let (x397, x398) = fiat_p384_scalar_addcarryx_u32(x396, x325, x373);
    let mut x399: u32 = 0;
    let mut x400: fiat_p384_scalar_u1 = 0;
    let (x399, x400) = fiat_p384_scalar_addcarryx_u32(x398, x327, x375);
    let mut x401: u32 = 0;
    let mut x402: fiat_p384_scalar_u1 = 0;
    let (x401, x402) = fiat_p384_scalar_addcarryx_u32(x400, x329, x377);
    let mut x403: u32 = 0;
    let mut x404: fiat_p384_scalar_u1 = 0;
    let (x403, x404) = fiat_p384_scalar_addcarryx_u32(x402, x331, x379);
    let mut x405: u32 = 0;
    let mut x406: fiat_p384_scalar_u1 = 0;
    let (x405, x406) = fiat_p384_scalar_addcarryx_u32(x404, x333, x381);
    let mut x407: u32 = 0;
    let mut x408: fiat_p384_scalar_u1 = 0;
    let (x407, x408) = fiat_p384_scalar_addcarryx_u32(x406, x335, x383);
    let mut x409: u32 = 0;
    let mut x410: fiat_p384_scalar_u1 = 0;
    let (x409, x410) = fiat_p384_scalar_addcarryx_u32(x408, x337, x385);
    let mut x411: u32 = 0;
    let mut x412: fiat_p384_scalar_u1 = 0;
    let (x411, x412) = fiat_p384_scalar_addcarryx_u32(x410, x339, x387);
    let mut x413: u32 = 0;
    let mut x414: fiat_p384_scalar_u1 = 0;
    let (x413, x414) = fiat_p384_scalar_addcarryx_u32(x412, x341, x389);
    let mut x415: u32 = 0;
    let mut x416: fiat_p384_scalar_u1 = 0;
    let (x415, x416) = fiat_p384_scalar_addcarryx_u32(x414, x343, x391);
    let mut x417: u32 = 0;
    let mut x418: fiat_p384_scalar_u1 = 0;
    let (x417, x418) = fiat_p384_scalar_addcarryx_u32(x416, x345, x393);
    let mut x419: u32 = 0;
    let mut x420: fiat_p384_scalar_u1 = 0;
    let (x419, x420) = fiat_p384_scalar_addcarryx_u32(
        x418,
        (((x346 as u32) + (x276 as u32)) + ((x322 as u32) + x278)),
        ((x394 as u32) + x350),
    );
    let mut x421: u32 = 0;
    let mut x422: u32 = 0;
    let (x421, x422) = fiat_p384_scalar_mulx_u32(x3, 0xc84ee01);
    let mut x423: u32 = 0;
    let mut x424: u32 = 0;
    let (x423, x424) = fiat_p384_scalar_mulx_u32(x3, 0x2b39bf21);
    let mut x425: u32 = 0;
    let mut x426: u32 = 0;
    let (x425, x426) = fiat_p384_scalar_mulx_u32(x3, 0x3fb05b7a);
    let mut x427: u32 = 0;
    let mut x428: u32 = 0;
    let (x427, x428) = fiat_p384_scalar_mulx_u32(x3, 0x28266895);
    let mut x429: u32 = 0;
    let mut x430: u32 = 0;
    let (x429, x430) = fiat_p384_scalar_mulx_u32(x3, 0xd40d4917);
    let mut x431: u32 = 0;
    let mut x432: u32 = 0;
    let (x431, x432) = fiat_p384_scalar_mulx_u32(x3, 0x4aab1cc5);
    let mut x433: u32 = 0;
    let mut x434: u32 = 0;
    let (x433, x434) = fiat_p384_scalar_mulx_u32(x3, 0xbc3e483a);
    let mut x435: u32 = 0;
    let mut x436: u32 = 0;
    let (x435, x436) = fiat_p384_scalar_mulx_u32(x3, 0xfcb82947);
    let mut x437: u32 = 0;
    let mut x438: u32 = 0;
    let (x437, x438) = fiat_p384_scalar_mulx_u32(x3, 0xff3d81e5);
    let mut x439: u32 = 0;
    let mut x440: u32 = 0;
    let (x439, x440) = fiat_p384_scalar_mulx_u32(x3, 0xdf1aa419);
    let mut x441: u32 = 0;
    let mut x442: u32 = 0;
    let (x441, x442) = fiat_p384_scalar_mulx_u32(x3, 0x2d319b24);
    let mut x443: u32 = 0;
    let mut x444: u32 = 0;
    let (x443, x444) = fiat_p384_scalar_mulx_u32(x3, 0x19b409a9);
    let mut x445: u32 = 0;
    let mut x446: fiat_p384_scalar_u1 = 0;
    let (x445, x446) = fiat_p384_scalar_addcarryx_u32(0x0, x444, x441);
    let mut x447: u32 = 0;
    let mut x448: fiat_p384_scalar_u1 = 0;
    let (x447, x448) = fiat_p384_scalar_addcarryx_u32(x446, x442, x439);
    let mut x449: u32 = 0;
    let mut x450: fiat_p384_scalar_u1 = 0;
    let (x449, x450) = fiat_p384_scalar_addcarryx_u32(x448, x440, x437);
    let mut x451: u32 = 0;
    let mut x452: fiat_p384_scalar_u1 = 0;
    let (x451, x452) = fiat_p384_scalar_addcarryx_u32(x450, x438, x435);
    let mut x453: u32 = 0;
    let mut x454: fiat_p384_scalar_u1 = 0;
    let (x453, x454) = fiat_p384_scalar_addcarryx_u32(x452, x436, x433);
    let mut x455: u32 = 0;
    let mut x456: fiat_p384_scalar_u1 = 0;
    let (x455, x456) = fiat_p384_scalar_addcarryx_u32(x454, x434, x431);
    let mut x457: u32 = 0;
    let mut x458: fiat_p384_scalar_u1 = 0;
    let (x457, x458) = fiat_p384_scalar_addcarryx_u32(x456, x432, x429);
    let mut x459: u32 = 0;
    let mut x460: fiat_p384_scalar_u1 = 0;
    let (x459, x460) = fiat_p384_scalar_addcarryx_u32(x458, x430, x427);
    let mut x461: u32 = 0;
    let mut x462: fiat_p384_scalar_u1 = 0;
    let (x461, x462) = fiat_p384_scalar_addcarryx_u32(x460, x428, x425);
    let mut x463: u32 = 0;
    let mut x464: fiat_p384_scalar_u1 = 0;
    let (x463, x464) = fiat_p384_scalar_addcarryx_u32(x462, x426, x423);
    let mut x465: u32 = 0;
    let mut x466: fiat_p384_scalar_u1 = 0;
    let (x465, x466) = fiat_p384_scalar_addcarryx_u32(x464, x424, x421);
    let mut x467: u32 = 0;
    let mut x468: fiat_p384_scalar_u1 = 0;
    let (x467, x468) = fiat_p384_scalar_addcarryx_u32(0x0, x397, x443);
    let mut x469: u32 = 0;
    let mut x470: fiat_p384_scalar_u1 = 0;
    let (x469, x470) = fiat_p384_scalar_addcarryx_u32(x468, x399, x445);
    let mut x471: u32 = 0;
    let mut x472: fiat_p384_scalar_u1 = 0;
    let (x471, x472) = fiat_p384_scalar_addcarryx_u32(x470, x401, x447);
    let mut x473: u32 = 0;
    let mut x474: fiat_p384_scalar_u1 = 0;
    let (x473, x474) = fiat_p384_scalar_addcarryx_u32(x472, x403, x449);
    let mut x475: u32 = 0;
    let mut x476: fiat_p384_scalar_u1 = 0;
    let (x475, x476) = fiat_p384_scalar_addcarryx_u32(x474, x405, x451);
    let mut x477: u32 = 0;
    let mut x478: fiat_p384_scalar_u1 = 0;
    let (x477, x478) = fiat_p384_scalar_addcarryx_u32(x476, x407, x453);
    let mut x479: u32 = 0;
    let mut x480: fiat_p384_scalar_u1 = 0;
    let (x479, x480) = fiat_p384_scalar_addcarryx_u32(x478, x409, x455);
    let mut x481: u32 = 0;
    let mut x482: fiat_p384_scalar_u1 = 0;
    let (x481, x482) = fiat_p384_scalar_addcarryx_u32(x480, x411, x457);
    let mut x483: u32 = 0;
    let mut x484: fiat_p384_scalar_u1 = 0;
    let (x483, x484) = fiat_p384_scalar_addcarryx_u32(x482, x413, x459);
    let mut x485: u32 = 0;
    let mut x486: fiat_p384_scalar_u1 = 0;
    let (x485, x486) = fiat_p384_scalar_addcarryx_u32(x484, x415, x461);
    let mut x487: u32 = 0;
    let mut x488: fiat_p384_scalar_u1 = 0;
    let (x487, x488) = fiat_p384_scalar_addcarryx_u32(x486, x417, x463);
    let mut x489: u32 = 0;
    let mut x490: fiat_p384_scalar_u1 = 0;
    let (x489, x490) = fiat_p384_scalar_addcarryx_u32(x488, x419, x465);
    let mut x491: u32 = 0;
    let mut x492: u32 = 0;
    let (x491, x492) = fiat_p384_scalar_mulx_u32(x467, 0xe88fdc45);
    let mut x493: u32 = 0;
    let mut x494: u32 = 0;
    let (x493, x494) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let mut x495: u32 = 0;
    let mut x496: u32 = 0;
    let (x495, x496) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let mut x497: u32 = 0;
    let mut x498: u32 = 0;
    let (x497, x498) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let mut x499: u32 = 0;
    let mut x500: u32 = 0;
    let (x499, x500) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let mut x501: u32 = 0;
    let mut x502: u32 = 0;
    let (x501, x502) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let mut x503: u32 = 0;
    let mut x504: u32 = 0;
    let (x503, x504) = fiat_p384_scalar_mulx_u32(x491, 0xffffffff);
    let mut x505: u32 = 0;
    let mut x506: u32 = 0;
    let (x505, x506) = fiat_p384_scalar_mulx_u32(x491, 0xc7634d81);
    let mut x507: u32 = 0;
    let mut x508: u32 = 0;
    let (x507, x508) = fiat_p384_scalar_mulx_u32(x491, 0xf4372ddf);
    let mut x509: u32 = 0;
    let mut x510: u32 = 0;
    let (x509, x510) = fiat_p384_scalar_mulx_u32(x491, 0x581a0db2);
    let mut x511: u32 = 0;
    let mut x512: u32 = 0;
    let (x511, x512) = fiat_p384_scalar_mulx_u32(x491, 0x48b0a77a);
    let mut x513: u32 = 0;
    let mut x514: u32 = 0;
    let (x513, x514) = fiat_p384_scalar_mulx_u32(x491, 0xecec196a);
    let mut x515: u32 = 0;
    let mut x516: u32 = 0;
    let (x515, x516) = fiat_p384_scalar_mulx_u32(x491, 0xccc52973);
    let mut x517: u32 = 0;
    let mut x518: fiat_p384_scalar_u1 = 0;
    let (x517, x518) = fiat_p384_scalar_addcarryx_u32(0x0, x516, x513);
    let mut x519: u32 = 0;
    let mut x520: fiat_p384_scalar_u1 = 0;
    let (x519, x520) = fiat_p384_scalar_addcarryx_u32(x518, x514, x511);
    let mut x521: u32 = 0;
    let mut x522: fiat_p384_scalar_u1 = 0;
    let (x521, x522) = fiat_p384_scalar_addcarryx_u32(x520, x512, x509);
    let mut x523: u32 = 0;
    let mut x524: fiat_p384_scalar_u1 = 0;
    let (x523, x524) = fiat_p384_scalar_addcarryx_u32(x522, x510, x507);
    let mut x525: u32 = 0;
    let mut x526: fiat_p384_scalar_u1 = 0;
    let (x525, x526) = fiat_p384_scalar_addcarryx_u32(x524, x508, x505);
    let mut x527: u32 = 0;
    let mut x528: fiat_p384_scalar_u1 = 0;
    let (x527, x528) = fiat_p384_scalar_addcarryx_u32(x526, x506, x503);
    let mut x529: u32 = 0;
    let mut x530: fiat_p384_scalar_u1 = 0;
    let (x529, x530) = fiat_p384_scalar_addcarryx_u32(x528, x504, x501);
    let mut x531: u32 = 0;
    let mut x532: fiat_p384_scalar_u1 = 0;
    let (x531, x532) = fiat_p384_scalar_addcarryx_u32(x530, x502, x499);
    let mut x533: u32 = 0;
    let mut x534: fiat_p384_scalar_u1 = 0;
    let (x533, x534) = fiat_p384_scalar_addcarryx_u32(x532, x500, x497);
    let mut x535: u32 = 0;
    let mut x536: fiat_p384_scalar_u1 = 0;
    let (x535, x536) = fiat_p384_scalar_addcarryx_u32(x534, x498, x495);
    let mut x537: u32 = 0;
    let mut x538: fiat_p384_scalar_u1 = 0;
    let (x537, x538) = fiat_p384_scalar_addcarryx_u32(x536, x496, x493);
    let mut x539: u32 = 0;
    let mut x540: fiat_p384_scalar_u1 = 0;
    let (x539, x540) = fiat_p384_scalar_addcarryx_u32(0x0, x467, x515);
    let mut x541: u32 = 0;
    let mut x542: fiat_p384_scalar_u1 = 0;
    let (x541, x542) = fiat_p384_scalar_addcarryx_u32(x540, x469, x517);
    let mut x543: u32 = 0;
    let mut x544: fiat_p384_scalar_u1 = 0;
    let (x543, x544) = fiat_p384_scalar_addcarryx_u32(x542, x471, x519);
    let mut x545: u32 = 0;
    let mut x546: fiat_p384_scalar_u1 = 0;
    let (x545, x546) = fiat_p384_scalar_addcarryx_u32(x544, x473, x521);
    let mut x547: u32 = 0;
    let mut x548: fiat_p384_scalar_u1 = 0;
    let (x547, x548) = fiat_p384_scalar_addcarryx_u32(x546, x475, x523);
    let mut x549: u32 = 0;
    let mut x550: fiat_p384_scalar_u1 = 0;
    let (x549, x550) = fiat_p384_scalar_addcarryx_u32(x548, x477, x525);
    let mut x551: u32 = 0;
    let mut x552: fiat_p384_scalar_u1 = 0;
    let (x551, x552) = fiat_p384_scalar_addcarryx_u32(x550, x479, x527);
    let mut x553: u32 = 0;
    let mut x554: fiat_p384_scalar_u1 = 0;
    let (x553, x554) = fiat_p384_scalar_addcarryx_u32(x552, x481, x529);
    let mut x555: u32 = 0;
    let mut x556: fiat_p384_scalar_u1 = 0;
    let (x555, x556) = fiat_p384_scalar_addcarryx_u32(x554, x483, x531);
    let mut x557: u32 = 0;
    let mut x558: fiat_p384_scalar_u1 = 0;
    let (x557, x558) = fiat_p384_scalar_addcarryx_u32(x556, x485, x533);
    let mut x559: u32 = 0;
    let mut x560: fiat_p384_scalar_u1 = 0;
    let (x559, x560) = fiat_p384_scalar_addcarryx_u32(x558, x487, x535);
    let mut x561: u32 = 0;
    let mut x562: fiat_p384_scalar_u1 = 0;
    let (x561, x562) = fiat_p384_scalar_addcarryx_u32(x560, x489, x537);
    let mut x563: u32 = 0;
    let mut x564: fiat_p384_scalar_u1 = 0;
    let (x563, x564) = fiat_p384_scalar_addcarryx_u32(
        x562,
        (((x490 as u32) + (x420 as u32)) + ((x466 as u32) + x422)),
        ((x538 as u32) + x494),
    );
    let mut x565: u32 = 0;
    let mut x566: u32 = 0;
    let (x565, x566) = fiat_p384_scalar_mulx_u32(x4, 0xc84ee01);
    let mut x567: u32 = 0;
    let mut x568: u32 = 0;
    let (x567, x568) = fiat_p384_scalar_mulx_u32(x4, 0x2b39bf21);
    let mut x569: u32 = 0;
    let mut x570: u32 = 0;
    let (x569, x570) = fiat_p384_scalar_mulx_u32(x4, 0x3fb05b7a);
    let mut x571: u32 = 0;
    let mut x572: u32 = 0;
    let (x571, x572) = fiat_p384_scalar_mulx_u32(x4, 0x28266895);
    let mut x573: u32 = 0;
    let mut x574: u32 = 0;
    let (x573, x574) = fiat_p384_scalar_mulx_u32(x4, 0xd40d4917);
    let mut x575: u32 = 0;
    let mut x576: u32 = 0;
    let (x575, x576) = fiat_p384_scalar_mulx_u32(x4, 0x4aab1cc5);
    let mut x577: u32 = 0;
    let mut x578: u32 = 0;
    let (x577, x578) = fiat_p384_scalar_mulx_u32(x4, 0xbc3e483a);
    let mut x579: u32 = 0;
    let mut x580: u32 = 0;
    let (x579, x580) = fiat_p384_scalar_mulx_u32(x4, 0xfcb82947);
    let mut x581: u32 = 0;
    let mut x582: u32 = 0;
    let (x581, x582) = fiat_p384_scalar_mulx_u32(x4, 0xff3d81e5);
    let mut x583: u32 = 0;
    let mut x584: u32 = 0;
    let (x583, x584) = fiat_p384_scalar_mulx_u32(x4, 0xdf1aa419);
    let mut x585: u32 = 0;
    let mut x586: u32 = 0;
    let (x585, x586) = fiat_p384_scalar_mulx_u32(x4, 0x2d319b24);
    let mut x587: u32 = 0;
    let mut x588: u32 = 0;
    let (x587, x588) = fiat_p384_scalar_mulx_u32(x4, 0x19b409a9);
    let mut x589: u32 = 0;
    let mut x590: fiat_p384_scalar_u1 = 0;
    let (x589, x590) = fiat_p384_scalar_addcarryx_u32(0x0, x588, x585);
    let mut x591: u32 = 0;
    let mut x592: fiat_p384_scalar_u1 = 0;
    let (x591, x592) = fiat_p384_scalar_addcarryx_u32(x590, x586, x583);
    let mut x593: u32 = 0;
    let mut x594: fiat_p384_scalar_u1 = 0;
    let (x593, x594) = fiat_p384_scalar_addcarryx_u32(x592, x584, x581);
    let mut x595: u32 = 0;
    let mut x596: fiat_p384_scalar_u1 = 0;
    let (x595, x596) = fiat_p384_scalar_addcarryx_u32(x594, x582, x579);
    let mut x597: u32 = 0;
    let mut x598: fiat_p384_scalar_u1 = 0;
    let (x597, x598) = fiat_p384_scalar_addcarryx_u32(x596, x580, x577);
    let mut x599: u32 = 0;
    let mut x600: fiat_p384_scalar_u1 = 0;
    let (x599, x600) = fiat_p384_scalar_addcarryx_u32(x598, x578, x575);
    let mut x601: u32 = 0;
    let mut x602: fiat_p384_scalar_u1 = 0;
    let (x601, x602) = fiat_p384_scalar_addcarryx_u32(x600, x576, x573);
    let mut x603: u32 = 0;
    let mut x604: fiat_p384_scalar_u1 = 0;
    let (x603, x604) = fiat_p384_scalar_addcarryx_u32(x602, x574, x571);
    let mut x605: u32 = 0;
    let mut x606: fiat_p384_scalar_u1 = 0;
    let (x605, x606) = fiat_p384_scalar_addcarryx_u32(x604, x572, x569);
    let mut x607: u32 = 0;
    let mut x608: fiat_p384_scalar_u1 = 0;
    let (x607, x608) = fiat_p384_scalar_addcarryx_u32(x606, x570, x567);
    let mut x609: u32 = 0;
    let mut x610: fiat_p384_scalar_u1 = 0;
    let (x609, x610) = fiat_p384_scalar_addcarryx_u32(x608, x568, x565);
    let mut x611: u32 = 0;
    let mut x612: fiat_p384_scalar_u1 = 0;
    let (x611, x612) = fiat_p384_scalar_addcarryx_u32(0x0, x541, x587);
    let mut x613: u32 = 0;
    let mut x614: fiat_p384_scalar_u1 = 0;
    let (x613, x614) = fiat_p384_scalar_addcarryx_u32(x612, x543, x589);
    let mut x615: u32 = 0;
    let mut x616: fiat_p384_scalar_u1 = 0;
    let (x615, x616) = fiat_p384_scalar_addcarryx_u32(x614, x545, x591);
    let mut x617: u32 = 0;
    let mut x618: fiat_p384_scalar_u1 = 0;
    let (x617, x618) = fiat_p384_scalar_addcarryx_u32(x616, x547, x593);
    let mut x619: u32 = 0;
    let mut x620: fiat_p384_scalar_u1 = 0;
    let (x619, x620) = fiat_p384_scalar_addcarryx_u32(x618, x549, x595);
    let mut x621: u32 = 0;
    let mut x622: fiat_p384_scalar_u1 = 0;
    let (x621, x622) = fiat_p384_scalar_addcarryx_u32(x620, x551, x597);
    let mut x623: u32 = 0;
    let mut x624: fiat_p384_scalar_u1 = 0;
    let (x623, x624) = fiat_p384_scalar_addcarryx_u32(x622, x553, x599);
    let mut x625: u32 = 0;
    let mut x626: fiat_p384_scalar_u1 = 0;
    let (x625, x626) = fiat_p384_scalar_addcarryx_u32(x624, x555, x601);
    let mut x627: u32 = 0;
    let mut x628: fiat_p384_scalar_u1 = 0;
    let (x627, x628) = fiat_p384_scalar_addcarryx_u32(x626, x557, x603);
    let mut x629: u32 = 0;
    let mut x630: fiat_p384_scalar_u1 = 0;
    let (x629, x630) = fiat_p384_scalar_addcarryx_u32(x628, x559, x605);
    let mut x631: u32 = 0;
    let mut x632: fiat_p384_scalar_u1 = 0;
    let (x631, x632) = fiat_p384_scalar_addcarryx_u32(x630, x561, x607);
    let mut x633: u32 = 0;
    let mut x634: fiat_p384_scalar_u1 = 0;
    let (x633, x634) = fiat_p384_scalar_addcarryx_u32(x632, x563, x609);
    let mut x635: u32 = 0;
    let mut x636: u32 = 0;
    let (x635, x636) = fiat_p384_scalar_mulx_u32(x611, 0xe88fdc45);
    let mut x637: u32 = 0;
    let mut x638: u32 = 0;
    let (x637, x638) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let mut x639: u32 = 0;
    let mut x640: u32 = 0;
    let (x639, x640) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let mut x641: u32 = 0;
    let mut x642: u32 = 0;
    let (x641, x642) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let mut x643: u32 = 0;
    let mut x644: u32 = 0;
    let (x643, x644) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let mut x645: u32 = 0;
    let mut x646: u32 = 0;
    let (x645, x646) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let mut x647: u32 = 0;
    let mut x648: u32 = 0;
    let (x647, x648) = fiat_p384_scalar_mulx_u32(x635, 0xffffffff);
    let mut x649: u32 = 0;
    let mut x650: u32 = 0;
    let (x649, x650) = fiat_p384_scalar_mulx_u32(x635, 0xc7634d81);
    let mut x651: u32 = 0;
    let mut x652: u32 = 0;
    let (x651, x652) = fiat_p384_scalar_mulx_u32(x635, 0xf4372ddf);
    let mut x653: u32 = 0;
    let mut x654: u32 = 0;
    let (x653, x654) = fiat_p384_scalar_mulx_u32(x635, 0x581a0db2);
    let mut x655: u32 = 0;
    let mut x656: u32 = 0;
    let (x655, x656) = fiat_p384_scalar_mulx_u32(x635, 0x48b0a77a);
    let mut x657: u32 = 0;
    let mut x658: u32 = 0;
    let (x657, x658) = fiat_p384_scalar_mulx_u32(x635, 0xecec196a);
    let mut x659: u32 = 0;
    let mut x660: u32 = 0;
    let (x659, x660) = fiat_p384_scalar_mulx_u32(x635, 0xccc52973);
    let mut x661: u32 = 0;
    let mut x662: fiat_p384_scalar_u1 = 0;
    let (x661, x662) = fiat_p384_scalar_addcarryx_u32(0x0, x660, x657);
    let mut x663: u32 = 0;
    let mut x664: fiat_p384_scalar_u1 = 0;
    let (x663, x664) = fiat_p384_scalar_addcarryx_u32(x662, x658, x655);
    let mut x665: u32 = 0;
    let mut x666: fiat_p384_scalar_u1 = 0;
    let (x665, x666) = fiat_p384_scalar_addcarryx_u32(x664, x656, x653);
    let mut x667: u32 = 0;
    let mut x668: fiat_p384_scalar_u1 = 0;
    let (x667, x668) = fiat_p384_scalar_addcarryx_u32(x666, x654, x651);
    let mut x669: u32 = 0;
    let mut x670: fiat_p384_scalar_u1 = 0;
    let (x669, x670) = fiat_p384_scalar_addcarryx_u32(x668, x652, x649);
    let mut x671: u32 = 0;
    let mut x672: fiat_p384_scalar_u1 = 0;
    let (x671, x672) = fiat_p384_scalar_addcarryx_u32(x670, x650, x647);
    let mut x673: u32 = 0;
    let mut x674: fiat_p384_scalar_u1 = 0;
    let (x673, x674) = fiat_p384_scalar_addcarryx_u32(x672, x648, x645);
    let mut x675: u32 = 0;
    let mut x676: fiat_p384_scalar_u1 = 0;
    let (x675, x676) = fiat_p384_scalar_addcarryx_u32(x674, x646, x643);
    let mut x677: u32 = 0;
    let mut x678: fiat_p384_scalar_u1 = 0;
    let (x677, x678) = fiat_p384_scalar_addcarryx_u32(x676, x644, x641);
    let mut x679: u32 = 0;
    let mut x680: fiat_p384_scalar_u1 = 0;
    let (x679, x680) = fiat_p384_scalar_addcarryx_u32(x678, x642, x639);
    let mut x681: u32 = 0;
    let mut x682: fiat_p384_scalar_u1 = 0;
    let (x681, x682) = fiat_p384_scalar_addcarryx_u32(x680, x640, x637);
    let mut x683: u32 = 0;
    let mut x684: fiat_p384_scalar_u1 = 0;
    let (x683, x684) = fiat_p384_scalar_addcarryx_u32(0x0, x611, x659);
    let mut x685: u32 = 0;
    let mut x686: fiat_p384_scalar_u1 = 0;
    let (x685, x686) = fiat_p384_scalar_addcarryx_u32(x684, x613, x661);
    let mut x687: u32 = 0;
    let mut x688: fiat_p384_scalar_u1 = 0;
    let (x687, x688) = fiat_p384_scalar_addcarryx_u32(x686, x615, x663);
    let mut x689: u32 = 0;
    let mut x690: fiat_p384_scalar_u1 = 0;
    let (x689, x690) = fiat_p384_scalar_addcarryx_u32(x688, x617, x665);
    let mut x691: u32 = 0;
    let mut x692: fiat_p384_scalar_u1 = 0;
    let (x691, x692) = fiat_p384_scalar_addcarryx_u32(x690, x619, x667);
    let mut x693: u32 = 0;
    let mut x694: fiat_p384_scalar_u1 = 0;
    let (x693, x694) = fiat_p384_scalar_addcarryx_u32(x692, x621, x669);
    let mut x695: u32 = 0;
    let mut x696: fiat_p384_scalar_u1 = 0;
    let (x695, x696) = fiat_p384_scalar_addcarryx_u32(x694, x623, x671);
    let mut x697: u32 = 0;
    let mut x698: fiat_p384_scalar_u1 = 0;
    let (x697, x698) = fiat_p384_scalar_addcarryx_u32(x696, x625, x673);
    let mut x699: u32 = 0;
    let mut x700: fiat_p384_scalar_u1 = 0;
    let (x699, x700) = fiat_p384_scalar_addcarryx_u32(x698, x627, x675);
    let mut x701: u32 = 0;
    let mut x702: fiat_p384_scalar_u1 = 0;
    let (x701, x702) = fiat_p384_scalar_addcarryx_u32(x700, x629, x677);
    let mut x703: u32 = 0;
    let mut x704: fiat_p384_scalar_u1 = 0;
    let (x703, x704) = fiat_p384_scalar_addcarryx_u32(x702, x631, x679);
    let mut x705: u32 = 0;
    let mut x706: fiat_p384_scalar_u1 = 0;
    let (x705, x706) = fiat_p384_scalar_addcarryx_u32(x704, x633, x681);
    let mut x707: u32 = 0;
    let mut x708: fiat_p384_scalar_u1 = 0;
    let (x707, x708) = fiat_p384_scalar_addcarryx_u32(
        x706,
        (((x634 as u32) + (x564 as u32)) + ((x610 as u32) + x566)),
        ((x682 as u32) + x638),
    );
    let mut x709: u32 = 0;
    let mut x710: u32 = 0;
    let (x709, x710) = fiat_p384_scalar_mulx_u32(x5, 0xc84ee01);
    let mut x711: u32 = 0;
    let mut x712: u32 = 0;
    let (x711, x712) = fiat_p384_scalar_mulx_u32(x5, 0x2b39bf21);
    let mut x713: u32 = 0;
    let mut x714: u32 = 0;
    let (x713, x714) = fiat_p384_scalar_mulx_u32(x5, 0x3fb05b7a);
    let mut x715: u32 = 0;
    let mut x716: u32 = 0;
    let (x715, x716) = fiat_p384_scalar_mulx_u32(x5, 0x28266895);
    let mut x717: u32 = 0;
    let mut x718: u32 = 0;
    let (x717, x718) = fiat_p384_scalar_mulx_u32(x5, 0xd40d4917);
    let mut x719: u32 = 0;
    let mut x720: u32 = 0;
    let (x719, x720) = fiat_p384_scalar_mulx_u32(x5, 0x4aab1cc5);
    let mut x721: u32 = 0;
    let mut x722: u32 = 0;
    let (x721, x722) = fiat_p384_scalar_mulx_u32(x5, 0xbc3e483a);
    let mut x723: u32 = 0;
    let mut x724: u32 = 0;
    let (x723, x724) = fiat_p384_scalar_mulx_u32(x5, 0xfcb82947);
    let mut x725: u32 = 0;
    let mut x726: u32 = 0;
    let (x725, x726) = fiat_p384_scalar_mulx_u32(x5, 0xff3d81e5);
    let mut x727: u32 = 0;
    let mut x728: u32 = 0;
    let (x727, x728) = fiat_p384_scalar_mulx_u32(x5, 0xdf1aa419);
    let mut x729: u32 = 0;
    let mut x730: u32 = 0;
    let (x729, x730) = fiat_p384_scalar_mulx_u32(x5, 0x2d319b24);
    let mut x731: u32 = 0;
    let mut x732: u32 = 0;
    let (x731, x732) = fiat_p384_scalar_mulx_u32(x5, 0x19b409a9);
    let mut x733: u32 = 0;
    let mut x734: fiat_p384_scalar_u1 = 0;
    let (x733, x734) = fiat_p384_scalar_addcarryx_u32(0x0, x732, x729);
    let mut x735: u32 = 0;
    let mut x736: fiat_p384_scalar_u1 = 0;
    let (x735, x736) = fiat_p384_scalar_addcarryx_u32(x734, x730, x727);
    let mut x737: u32 = 0;
    let mut x738: fiat_p384_scalar_u1 = 0;
    let (x737, x738) = fiat_p384_scalar_addcarryx_u32(x736, x728, x725);
    let mut x739: u32 = 0;
    let mut x740: fiat_p384_scalar_u1 = 0;
    let (x739, x740) = fiat_p384_scalar_addcarryx_u32(x738, x726, x723);
    let mut x741: u32 = 0;
    let mut x742: fiat_p384_scalar_u1 = 0;
    let (x741, x742) = fiat_p384_scalar_addcarryx_u32(x740, x724, x721);
    let mut x743: u32 = 0;
    let mut x744: fiat_p384_scalar_u1 = 0;
    let (x743, x744) = fiat_p384_scalar_addcarryx_u32(x742, x722, x719);
    let mut x745: u32 = 0;
    let mut x746: fiat_p384_scalar_u1 = 0;
    let (x745, x746) = fiat_p384_scalar_addcarryx_u32(x744, x720, x717);
    let mut x747: u32 = 0;
    let mut x748: fiat_p384_scalar_u1 = 0;
    let (x747, x748) = fiat_p384_scalar_addcarryx_u32(x746, x718, x715);
    let mut x749: u32 = 0;
    let mut x750: fiat_p384_scalar_u1 = 0;
    let (x749, x750) = fiat_p384_scalar_addcarryx_u32(x748, x716, x713);
    let mut x751: u32 = 0;
    let mut x752: fiat_p384_scalar_u1 = 0;
    let (x751, x752) = fiat_p384_scalar_addcarryx_u32(x750, x714, x711);
    let mut x753: u32 = 0;
    let mut x754: fiat_p384_scalar_u1 = 0;
    let (x753, x754) = fiat_p384_scalar_addcarryx_u32(x752, x712, x709);
    let mut x755: u32 = 0;
    let mut x756: fiat_p384_scalar_u1 = 0;
    let (x755, x756) = fiat_p384_scalar_addcarryx_u32(0x0, x685, x731);
    let mut x757: u32 = 0;
    let mut x758: fiat_p384_scalar_u1 = 0;
    let (x757, x758) = fiat_p384_scalar_addcarryx_u32(x756, x687, x733);
    let mut x759: u32 = 0;
    let mut x760: fiat_p384_scalar_u1 = 0;
    let (x759, x760) = fiat_p384_scalar_addcarryx_u32(x758, x689, x735);
    let mut x761: u32 = 0;
    let mut x762: fiat_p384_scalar_u1 = 0;
    let (x761, x762) = fiat_p384_scalar_addcarryx_u32(x760, x691, x737);
    let mut x763: u32 = 0;
    let mut x764: fiat_p384_scalar_u1 = 0;
    let (x763, x764) = fiat_p384_scalar_addcarryx_u32(x762, x693, x739);
    let mut x765: u32 = 0;
    let mut x766: fiat_p384_scalar_u1 = 0;
    let (x765, x766) = fiat_p384_scalar_addcarryx_u32(x764, x695, x741);
    let mut x767: u32 = 0;
    let mut x768: fiat_p384_scalar_u1 = 0;
    let (x767, x768) = fiat_p384_scalar_addcarryx_u32(x766, x697, x743);
    let mut x769: u32 = 0;
    let mut x770: fiat_p384_scalar_u1 = 0;
    let (x769, x770) = fiat_p384_scalar_addcarryx_u32(x768, x699, x745);
    let mut x771: u32 = 0;
    let mut x772: fiat_p384_scalar_u1 = 0;
    let (x771, x772) = fiat_p384_scalar_addcarryx_u32(x770, x701, x747);
    let mut x773: u32 = 0;
    let mut x774: fiat_p384_scalar_u1 = 0;
    let (x773, x774) = fiat_p384_scalar_addcarryx_u32(x772, x703, x749);
    let mut x775: u32 = 0;
    let mut x776: fiat_p384_scalar_u1 = 0;
    let (x775, x776) = fiat_p384_scalar_addcarryx_u32(x774, x705, x751);
    let mut x777: u32 = 0;
    let mut x778: fiat_p384_scalar_u1 = 0;
    let (x777, x778) = fiat_p384_scalar_addcarryx_u32(x776, x707, x753);
    let mut x779: u32 = 0;
    let mut x780: u32 = 0;
    let (x779, x780) = fiat_p384_scalar_mulx_u32(x755, 0xe88fdc45);
    let mut x781: u32 = 0;
    let mut x782: u32 = 0;
    let (x781, x782) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let mut x783: u32 = 0;
    let mut x784: u32 = 0;
    let (x783, x784) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let mut x785: u32 = 0;
    let mut x786: u32 = 0;
    let (x785, x786) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let mut x787: u32 = 0;
    let mut x788: u32 = 0;
    let (x787, x788) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let mut x789: u32 = 0;
    let mut x790: u32 = 0;
    let (x789, x790) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let mut x791: u32 = 0;
    let mut x792: u32 = 0;
    let (x791, x792) = fiat_p384_scalar_mulx_u32(x779, 0xffffffff);
    let mut x793: u32 = 0;
    let mut x794: u32 = 0;
    let (x793, x794) = fiat_p384_scalar_mulx_u32(x779, 0xc7634d81);
    let mut x795: u32 = 0;
    let mut x796: u32 = 0;
    let (x795, x796) = fiat_p384_scalar_mulx_u32(x779, 0xf4372ddf);
    let mut x797: u32 = 0;
    let mut x798: u32 = 0;
    let (x797, x798) = fiat_p384_scalar_mulx_u32(x779, 0x581a0db2);
    let mut x799: u32 = 0;
    let mut x800: u32 = 0;
    let (x799, x800) = fiat_p384_scalar_mulx_u32(x779, 0x48b0a77a);
    let mut x801: u32 = 0;
    let mut x802: u32 = 0;
    let (x801, x802) = fiat_p384_scalar_mulx_u32(x779, 0xecec196a);
    let mut x803: u32 = 0;
    let mut x804: u32 = 0;
    let (x803, x804) = fiat_p384_scalar_mulx_u32(x779, 0xccc52973);
    let mut x805: u32 = 0;
    let mut x806: fiat_p384_scalar_u1 = 0;
    let (x805, x806) = fiat_p384_scalar_addcarryx_u32(0x0, x804, x801);
    let mut x807: u32 = 0;
    let mut x808: fiat_p384_scalar_u1 = 0;
    let (x807, x808) = fiat_p384_scalar_addcarryx_u32(x806, x802, x799);
    let mut x809: u32 = 0;
    let mut x810: fiat_p384_scalar_u1 = 0;
    let (x809, x810) = fiat_p384_scalar_addcarryx_u32(x808, x800, x797);
    let mut x811: u32 = 0;
    let mut x812: fiat_p384_scalar_u1 = 0;
    let (x811, x812) = fiat_p384_scalar_addcarryx_u32(x810, x798, x795);
    let mut x813: u32 = 0;
    let mut x814: fiat_p384_scalar_u1 = 0;
    let (x813, x814) = fiat_p384_scalar_addcarryx_u32(x812, x796, x793);
    let mut x815: u32 = 0;
    let mut x816: fiat_p384_scalar_u1 = 0;
    let (x815, x816) = fiat_p384_scalar_addcarryx_u32(x814, x794, x791);
    let mut x817: u32 = 0;
    let mut x818: fiat_p384_scalar_u1 = 0;
    let (x817, x818) = fiat_p384_scalar_addcarryx_u32(x816, x792, x789);
    let mut x819: u32 = 0;
    let mut x820: fiat_p384_scalar_u1 = 0;
    let (x819, x820) = fiat_p384_scalar_addcarryx_u32(x818, x790, x787);
    let mut x821: u32 = 0;
    let mut x822: fiat_p384_scalar_u1 = 0;
    let (x821, x822) = fiat_p384_scalar_addcarryx_u32(x820, x788, x785);
    let mut x823: u32 = 0;
    let mut x824: fiat_p384_scalar_u1 = 0;
    let (x823, x824) = fiat_p384_scalar_addcarryx_u32(x822, x786, x783);
    let mut x825: u32 = 0;
    let mut x826: fiat_p384_scalar_u1 = 0;
    let (x825, x826) = fiat_p384_scalar_addcarryx_u32(x824, x784, x781);
    let mut x827: u32 = 0;
    let mut x828: fiat_p384_scalar_u1 = 0;
    let (x827, x828) = fiat_p384_scalar_addcarryx_u32(0x0, x755, x803);
    let mut x829: u32 = 0;
    let mut x830: fiat_p384_scalar_u1 = 0;
    let (x829, x830) = fiat_p384_scalar_addcarryx_u32(x828, x757, x805);
    let mut x831: u32 = 0;
    let mut x832: fiat_p384_scalar_u1 = 0;
    let (x831, x832) = fiat_p384_scalar_addcarryx_u32(x830, x759, x807);
    let mut x833: u32 = 0;
    let mut x834: fiat_p384_scalar_u1 = 0;
    let (x833, x834) = fiat_p384_scalar_addcarryx_u32(x832, x761, x809);
    let mut x835: u32 = 0;
    let mut x836: fiat_p384_scalar_u1 = 0;
    let (x835, x836) = fiat_p384_scalar_addcarryx_u32(x834, x763, x811);
    let mut x837: u32 = 0;
    let mut x838: fiat_p384_scalar_u1 = 0;
    let (x837, x838) = fiat_p384_scalar_addcarryx_u32(x836, x765, x813);
    let mut x839: u32 = 0;
    let mut x840: fiat_p384_scalar_u1 = 0;
    let (x839, x840) = fiat_p384_scalar_addcarryx_u32(x838, x767, x815);
    let mut x841: u32 = 0;
    let mut x842: fiat_p384_scalar_u1 = 0;
    let (x841, x842) = fiat_p384_scalar_addcarryx_u32(x840, x769, x817);
    let mut x843: u32 = 0;
    let mut x844: fiat_p384_scalar_u1 = 0;
    let (x843, x844) = fiat_p384_scalar_addcarryx_u32(x842, x771, x819);
    let mut x845: u32 = 0;
    let mut x846: fiat_p384_scalar_u1 = 0;
    let (x845, x846) = fiat_p384_scalar_addcarryx_u32(x844, x773, x821);
    let mut x847: u32 = 0;
    let mut x848: fiat_p384_scalar_u1 = 0;
    let (x847, x848) = fiat_p384_scalar_addcarryx_u32(x846, x775, x823);
    let mut x849: u32 = 0;
    let mut x850: fiat_p384_scalar_u1 = 0;
    let (x849, x850) = fiat_p384_scalar_addcarryx_u32(x848, x777, x825);
    let mut x851: u32 = 0;
    let mut x852: fiat_p384_scalar_u1 = 0;
    let (x851, x852) = fiat_p384_scalar_addcarryx_u32(
        x850,
        (((x778 as u32) + (x708 as u32)) + ((x754 as u32) + x710)),
        ((x826 as u32) + x782),
    );
    let mut x853: u32 = 0;
    let mut x854: u32 = 0;
    let (x853, x854) = fiat_p384_scalar_mulx_u32(x6, 0xc84ee01);
    let mut x855: u32 = 0;
    let mut x856: u32 = 0;
    let (x855, x856) = fiat_p384_scalar_mulx_u32(x6, 0x2b39bf21);
    let mut x857: u32 = 0;
    let mut x858: u32 = 0;
    let (x857, x858) = fiat_p384_scalar_mulx_u32(x6, 0x3fb05b7a);
    let mut x859: u32 = 0;
    let mut x860: u32 = 0;
    let (x859, x860) = fiat_p384_scalar_mulx_u32(x6, 0x28266895);
    let mut x861: u32 = 0;
    let mut x862: u32 = 0;
    let (x861, x862) = fiat_p384_scalar_mulx_u32(x6, 0xd40d4917);
    let mut x863: u32 = 0;
    let mut x864: u32 = 0;
    let (x863, x864) = fiat_p384_scalar_mulx_u32(x6, 0x4aab1cc5);
    let mut x865: u32 = 0;
    let mut x866: u32 = 0;
    let (x865, x866) = fiat_p384_scalar_mulx_u32(x6, 0xbc3e483a);
    let mut x867: u32 = 0;
    let mut x868: u32 = 0;
    let (x867, x868) = fiat_p384_scalar_mulx_u32(x6, 0xfcb82947);
    let mut x869: u32 = 0;
    let mut x870: u32 = 0;
    let (x869, x870) = fiat_p384_scalar_mulx_u32(x6, 0xff3d81e5);
    let mut x871: u32 = 0;
    let mut x872: u32 = 0;
    let (x871, x872) = fiat_p384_scalar_mulx_u32(x6, 0xdf1aa419);
    let mut x873: u32 = 0;
    let mut x874: u32 = 0;
    let (x873, x874) = fiat_p384_scalar_mulx_u32(x6, 0x2d319b24);
    let mut x875: u32 = 0;
    let mut x876: u32 = 0;
    let (x875, x876) = fiat_p384_scalar_mulx_u32(x6, 0x19b409a9);
    let mut x877: u32 = 0;
    let mut x878: fiat_p384_scalar_u1 = 0;
    let (x877, x878) = fiat_p384_scalar_addcarryx_u32(0x0, x876, x873);
    let mut x879: u32 = 0;
    let mut x880: fiat_p384_scalar_u1 = 0;
    let (x879, x880) = fiat_p384_scalar_addcarryx_u32(x878, x874, x871);
    let mut x881: u32 = 0;
    let mut x882: fiat_p384_scalar_u1 = 0;
    let (x881, x882) = fiat_p384_scalar_addcarryx_u32(x880, x872, x869);
    let mut x883: u32 = 0;
    let mut x884: fiat_p384_scalar_u1 = 0;
    let (x883, x884) = fiat_p384_scalar_addcarryx_u32(x882, x870, x867);
    let mut x885: u32 = 0;
    let mut x886: fiat_p384_scalar_u1 = 0;
    let (x885, x886) = fiat_p384_scalar_addcarryx_u32(x884, x868, x865);
    let mut x887: u32 = 0;
    let mut x888: fiat_p384_scalar_u1 = 0;
    let (x887, x888) = fiat_p384_scalar_addcarryx_u32(x886, x866, x863);
    let mut x889: u32 = 0;
    let mut x890: fiat_p384_scalar_u1 = 0;
    let (x889, x890) = fiat_p384_scalar_addcarryx_u32(x888, x864, x861);
    let mut x891: u32 = 0;
    let mut x892: fiat_p384_scalar_u1 = 0;
    let (x891, x892) = fiat_p384_scalar_addcarryx_u32(x890, x862, x859);
    let mut x893: u32 = 0;
    let mut x894: fiat_p384_scalar_u1 = 0;
    let (x893, x894) = fiat_p384_scalar_addcarryx_u32(x892, x860, x857);
    let mut x895: u32 = 0;
    let mut x896: fiat_p384_scalar_u1 = 0;
    let (x895, x896) = fiat_p384_scalar_addcarryx_u32(x894, x858, x855);
    let mut x897: u32 = 0;
    let mut x898: fiat_p384_scalar_u1 = 0;
    let (x897, x898) = fiat_p384_scalar_addcarryx_u32(x896, x856, x853);
    let mut x899: u32 = 0;
    let mut x900: fiat_p384_scalar_u1 = 0;
    let (x899, x900) = fiat_p384_scalar_addcarryx_u32(0x0, x829, x875);
    let mut x901: u32 = 0;
    let mut x902: fiat_p384_scalar_u1 = 0;
    let (x901, x902) = fiat_p384_scalar_addcarryx_u32(x900, x831, x877);
    let mut x903: u32 = 0;
    let mut x904: fiat_p384_scalar_u1 = 0;
    let (x903, x904) = fiat_p384_scalar_addcarryx_u32(x902, x833, x879);
    let mut x905: u32 = 0;
    let mut x906: fiat_p384_scalar_u1 = 0;
    let (x905, x906) = fiat_p384_scalar_addcarryx_u32(x904, x835, x881);
    let mut x907: u32 = 0;
    let mut x908: fiat_p384_scalar_u1 = 0;
    let (x907, x908) = fiat_p384_scalar_addcarryx_u32(x906, x837, x883);
    let mut x909: u32 = 0;
    let mut x910: fiat_p384_scalar_u1 = 0;
    let (x909, x910) = fiat_p384_scalar_addcarryx_u32(x908, x839, x885);
    let mut x911: u32 = 0;
    let mut x912: fiat_p384_scalar_u1 = 0;
    let (x911, x912) = fiat_p384_scalar_addcarryx_u32(x910, x841, x887);
    let mut x913: u32 = 0;
    let mut x914: fiat_p384_scalar_u1 = 0;
    let (x913, x914) = fiat_p384_scalar_addcarryx_u32(x912, x843, x889);
    let mut x915: u32 = 0;
    let mut x916: fiat_p384_scalar_u1 = 0;
    let (x915, x916) = fiat_p384_scalar_addcarryx_u32(x914, x845, x891);
    let mut x917: u32 = 0;
    let mut x918: fiat_p384_scalar_u1 = 0;
    let (x917, x918) = fiat_p384_scalar_addcarryx_u32(x916, x847, x893);
    let mut x919: u32 = 0;
    let mut x920: fiat_p384_scalar_u1 = 0;
    let (x919, x920) = fiat_p384_scalar_addcarryx_u32(x918, x849, x895);
    let mut x921: u32 = 0;
    let mut x922: fiat_p384_scalar_u1 = 0;
    let (x921, x922) = fiat_p384_scalar_addcarryx_u32(x920, x851, x897);
    let mut x923: u32 = 0;
    let mut x924: u32 = 0;
    let (x923, x924) = fiat_p384_scalar_mulx_u32(x899, 0xe88fdc45);
    let mut x925: u32 = 0;
    let mut x926: u32 = 0;
    let (x925, x926) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let mut x927: u32 = 0;
    let mut x928: u32 = 0;
    let (x927, x928) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let mut x929: u32 = 0;
    let mut x930: u32 = 0;
    let (x929, x930) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let mut x931: u32 = 0;
    let mut x932: u32 = 0;
    let (x931, x932) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let mut x933: u32 = 0;
    let mut x934: u32 = 0;
    let (x933, x934) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let mut x935: u32 = 0;
    let mut x936: u32 = 0;
    let (x935, x936) = fiat_p384_scalar_mulx_u32(x923, 0xffffffff);
    let mut x937: u32 = 0;
    let mut x938: u32 = 0;
    let (x937, x938) = fiat_p384_scalar_mulx_u32(x923, 0xc7634d81);
    let mut x939: u32 = 0;
    let mut x940: u32 = 0;
    let (x939, x940) = fiat_p384_scalar_mulx_u32(x923, 0xf4372ddf);
    let mut x941: u32 = 0;
    let mut x942: u32 = 0;
    let (x941, x942) = fiat_p384_scalar_mulx_u32(x923, 0x581a0db2);
    let mut x943: u32 = 0;
    let mut x944: u32 = 0;
    let (x943, x944) = fiat_p384_scalar_mulx_u32(x923, 0x48b0a77a);
    let mut x945: u32 = 0;
    let mut x946: u32 = 0;
    let (x945, x946) = fiat_p384_scalar_mulx_u32(x923, 0xecec196a);
    let mut x947: u32 = 0;
    let mut x948: u32 = 0;
    let (x947, x948) = fiat_p384_scalar_mulx_u32(x923, 0xccc52973);
    let mut x949: u32 = 0;
    let mut x950: fiat_p384_scalar_u1 = 0;
    let (x949, x950) = fiat_p384_scalar_addcarryx_u32(0x0, x948, x945);
    let mut x951: u32 = 0;
    let mut x952: fiat_p384_scalar_u1 = 0;
    let (x951, x952) = fiat_p384_scalar_addcarryx_u32(x950, x946, x943);
    let mut x953: u32 = 0;
    let mut x954: fiat_p384_scalar_u1 = 0;
    let (x953, x954) = fiat_p384_scalar_addcarryx_u32(x952, x944, x941);
    let mut x955: u32 = 0;
    let mut x956: fiat_p384_scalar_u1 = 0;
    let (x955, x956) = fiat_p384_scalar_addcarryx_u32(x954, x942, x939);
    let mut x957: u32 = 0;
    let mut x958: fiat_p384_scalar_u1 = 0;
    let (x957, x958) = fiat_p384_scalar_addcarryx_u32(x956, x940, x937);
    let mut x959: u32 = 0;
    let mut x960: fiat_p384_scalar_u1 = 0;
    let (x959, x960) = fiat_p384_scalar_addcarryx_u32(x958, x938, x935);
    let mut x961: u32 = 0;
    let mut x962: fiat_p384_scalar_u1 = 0;
    let (x961, x962) = fiat_p384_scalar_addcarryx_u32(x960, x936, x933);
    let mut x963: u32 = 0;
    let mut x964: fiat_p384_scalar_u1 = 0;
    let (x963, x964) = fiat_p384_scalar_addcarryx_u32(x962, x934, x931);
    let mut x965: u32 = 0;
    let mut x966: fiat_p384_scalar_u1 = 0;
    let (x965, x966) = fiat_p384_scalar_addcarryx_u32(x964, x932, x929);
    let mut x967: u32 = 0;
    let mut x968: fiat_p384_scalar_u1 = 0;
    let (x967, x968) = fiat_p384_scalar_addcarryx_u32(x966, x930, x927);
    let mut x969: u32 = 0;
    let mut x970: fiat_p384_scalar_u1 = 0;
    let (x969, x970) = fiat_p384_scalar_addcarryx_u32(x968, x928, x925);
    let mut x971: u32 = 0;
    let mut x972: fiat_p384_scalar_u1 = 0;
    let (x971, x972) = fiat_p384_scalar_addcarryx_u32(0x0, x899, x947);
    let mut x973: u32 = 0;
    let mut x974: fiat_p384_scalar_u1 = 0;
    let (x973, x974) = fiat_p384_scalar_addcarryx_u32(x972, x901, x949);
    let mut x975: u32 = 0;
    let mut x976: fiat_p384_scalar_u1 = 0;
    let (x975, x976) = fiat_p384_scalar_addcarryx_u32(x974, x903, x951);
    let mut x977: u32 = 0;
    let mut x978: fiat_p384_scalar_u1 = 0;
    let (x977, x978) = fiat_p384_scalar_addcarryx_u32(x976, x905, x953);
    let mut x979: u32 = 0;
    let mut x980: fiat_p384_scalar_u1 = 0;
    let (x979, x980) = fiat_p384_scalar_addcarryx_u32(x978, x907, x955);
    let mut x981: u32 = 0;
    let mut x982: fiat_p384_scalar_u1 = 0;
    let (x981, x982) = fiat_p384_scalar_addcarryx_u32(x980, x909, x957);
    let mut x983: u32 = 0;
    let mut x984: fiat_p384_scalar_u1 = 0;
    let (x983, x984) = fiat_p384_scalar_addcarryx_u32(x982, x911, x959);
    let mut x985: u32 = 0;
    let mut x986: fiat_p384_scalar_u1 = 0;
    let (x985, x986) = fiat_p384_scalar_addcarryx_u32(x984, x913, x961);
    let mut x987: u32 = 0;
    let mut x988: fiat_p384_scalar_u1 = 0;
    let (x987, x988) = fiat_p384_scalar_addcarryx_u32(x986, x915, x963);
    let mut x989: u32 = 0;
    let mut x990: fiat_p384_scalar_u1 = 0;
    let (x989, x990) = fiat_p384_scalar_addcarryx_u32(x988, x917, x965);
    let mut x991: u32 = 0;
    let mut x992: fiat_p384_scalar_u1 = 0;
    let (x991, x992) = fiat_p384_scalar_addcarryx_u32(x990, x919, x967);
    let mut x993: u32 = 0;
    let mut x994: fiat_p384_scalar_u1 = 0;
    let (x993, x994) = fiat_p384_scalar_addcarryx_u32(x992, x921, x969);
    let mut x995: u32 = 0;
    let mut x996: fiat_p384_scalar_u1 = 0;
    let (x995, x996) = fiat_p384_scalar_addcarryx_u32(
        x994,
        (((x922 as u32) + (x852 as u32)) + ((x898 as u32) + x854)),
        ((x970 as u32) + x926),
    );
    let mut x997: u32 = 0;
    let mut x998: u32 = 0;
    let (x997, x998) = fiat_p384_scalar_mulx_u32(x7, 0xc84ee01);
    let mut x999: u32 = 0;
    let mut x1000: u32 = 0;
    let (x999, x1000) = fiat_p384_scalar_mulx_u32(x7, 0x2b39bf21);
    let mut x1001: u32 = 0;
    let mut x1002: u32 = 0;
    let (x1001, x1002) = fiat_p384_scalar_mulx_u32(x7, 0x3fb05b7a);
    let mut x1003: u32 = 0;
    let mut x1004: u32 = 0;
    let (x1003, x1004) = fiat_p384_scalar_mulx_u32(x7, 0x28266895);
    let mut x1005: u32 = 0;
    let mut x1006: u32 = 0;
    let (x1005, x1006) = fiat_p384_scalar_mulx_u32(x7, 0xd40d4917);
    let mut x1007: u32 = 0;
    let mut x1008: u32 = 0;
    let (x1007, x1008) = fiat_p384_scalar_mulx_u32(x7, 0x4aab1cc5);
    let mut x1009: u32 = 0;
    let mut x1010: u32 = 0;
    let (x1009, x1010) = fiat_p384_scalar_mulx_u32(x7, 0xbc3e483a);
    let mut x1011: u32 = 0;
    let mut x1012: u32 = 0;
    let (x1011, x1012) = fiat_p384_scalar_mulx_u32(x7, 0xfcb82947);
    let mut x1013: u32 = 0;
    let mut x1014: u32 = 0;
    let (x1013, x1014) = fiat_p384_scalar_mulx_u32(x7, 0xff3d81e5);
    let mut x1015: u32 = 0;
    let mut x1016: u32 = 0;
    let (x1015, x1016) = fiat_p384_scalar_mulx_u32(x7, 0xdf1aa419);
    let mut x1017: u32 = 0;
    let mut x1018: u32 = 0;
    let (x1017, x1018) = fiat_p384_scalar_mulx_u32(x7, 0x2d319b24);
    let mut x1019: u32 = 0;
    let mut x1020: u32 = 0;
    let (x1019, x1020) = fiat_p384_scalar_mulx_u32(x7, 0x19b409a9);
    let mut x1021: u32 = 0;
    let mut x1022: fiat_p384_scalar_u1 = 0;
    let (x1021, x1022) = fiat_p384_scalar_addcarryx_u32(0x0, x1020, x1017);
    let mut x1023: u32 = 0;
    let mut x1024: fiat_p384_scalar_u1 = 0;
    let (x1023, x1024) = fiat_p384_scalar_addcarryx_u32(x1022, x1018, x1015);
    let mut x1025: u32 = 0;
    let mut x1026: fiat_p384_scalar_u1 = 0;
    let (x1025, x1026) = fiat_p384_scalar_addcarryx_u32(x1024, x1016, x1013);
    let mut x1027: u32 = 0;
    let mut x1028: fiat_p384_scalar_u1 = 0;
    let (x1027, x1028) = fiat_p384_scalar_addcarryx_u32(x1026, x1014, x1011);
    let mut x1029: u32 = 0;
    let mut x1030: fiat_p384_scalar_u1 = 0;
    let (x1029, x1030) = fiat_p384_scalar_addcarryx_u32(x1028, x1012, x1009);
    let mut x1031: u32 = 0;
    let mut x1032: fiat_p384_scalar_u1 = 0;
    let (x1031, x1032) = fiat_p384_scalar_addcarryx_u32(x1030, x1010, x1007);
    let mut x1033: u32 = 0;
    let mut x1034: fiat_p384_scalar_u1 = 0;
    let (x1033, x1034) = fiat_p384_scalar_addcarryx_u32(x1032, x1008, x1005);
    let mut x1035: u32 = 0;
    let mut x1036: fiat_p384_scalar_u1 = 0;
    let (x1035, x1036) = fiat_p384_scalar_addcarryx_u32(x1034, x1006, x1003);
    let mut x1037: u32 = 0;
    let mut x1038: fiat_p384_scalar_u1 = 0;
    let (x1037, x1038) = fiat_p384_scalar_addcarryx_u32(x1036, x1004, x1001);
    let mut x1039: u32 = 0;
    let mut x1040: fiat_p384_scalar_u1 = 0;
    let (x1039, x1040) = fiat_p384_scalar_addcarryx_u32(x1038, x1002, x999);
    let mut x1041: u32 = 0;
    let mut x1042: fiat_p384_scalar_u1 = 0;
    let (x1041, x1042) = fiat_p384_scalar_addcarryx_u32(x1040, x1000, x997);
    let mut x1043: u32 = 0;
    let mut x1044: fiat_p384_scalar_u1 = 0;
    let (x1043, x1044) = fiat_p384_scalar_addcarryx_u32(0x0, x973, x1019);
    let mut x1045: u32 = 0;
    let mut x1046: fiat_p384_scalar_u1 = 0;
    let (x1045, x1046) = fiat_p384_scalar_addcarryx_u32(x1044, x975, x1021);
    let mut x1047: u32 = 0;
    let mut x1048: fiat_p384_scalar_u1 = 0;
    let (x1047, x1048) = fiat_p384_scalar_addcarryx_u32(x1046, x977, x1023);
    let mut x1049: u32 = 0;
    let mut x1050: fiat_p384_scalar_u1 = 0;
    let (x1049, x1050) = fiat_p384_scalar_addcarryx_u32(x1048, x979, x1025);
    let mut x1051: u32 = 0;
    let mut x1052: fiat_p384_scalar_u1 = 0;
    let (x1051, x1052) = fiat_p384_scalar_addcarryx_u32(x1050, x981, x1027);
    let mut x1053: u32 = 0;
    let mut x1054: fiat_p384_scalar_u1 = 0;
    let (x1053, x1054) = fiat_p384_scalar_addcarryx_u32(x1052, x983, x1029);
    let mut x1055: u32 = 0;
    let mut x1056: fiat_p384_scalar_u1 = 0;
    let (x1055, x1056) = fiat_p384_scalar_addcarryx_u32(x1054, x985, x1031);
    let mut x1057: u32 = 0;
    let mut x1058: fiat_p384_scalar_u1 = 0;
    let (x1057, x1058) = fiat_p384_scalar_addcarryx_u32(x1056, x987, x1033);
    let mut x1059: u32 = 0;
    let mut x1060: fiat_p384_scalar_u1 = 0;
    let (x1059, x1060) = fiat_p384_scalar_addcarryx_u32(x1058, x989, x1035);
    let mut x1061: u32 = 0;
    let mut x1062: fiat_p384_scalar_u1 = 0;
    let (x1061, x1062) = fiat_p384_scalar_addcarryx_u32(x1060, x991, x1037);
    let mut x1063: u32 = 0;
    let mut x1064: fiat_p384_scalar_u1 = 0;
    let (x1063, x1064) = fiat_p384_scalar_addcarryx_u32(x1062, x993, x1039);
    let mut x1065: u32 = 0;
    let mut x1066: fiat_p384_scalar_u1 = 0;
    let (x1065, x1066) = fiat_p384_scalar_addcarryx_u32(x1064, x995, x1041);
    let mut x1067: u32 = 0;
    let mut x1068: u32 = 0;
    let (x1067, x1068) = fiat_p384_scalar_mulx_u32(x1043, 0xe88fdc45);
    let mut x1069: u32 = 0;
    let mut x1070: u32 = 0;
    let (x1069, x1070) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let mut x1071: u32 = 0;
    let mut x1072: u32 = 0;
    let (x1071, x1072) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let mut x1073: u32 = 0;
    let mut x1074: u32 = 0;
    let (x1073, x1074) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let mut x1075: u32 = 0;
    let mut x1076: u32 = 0;
    let (x1075, x1076) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let mut x1077: u32 = 0;
    let mut x1078: u32 = 0;
    let (x1077, x1078) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let mut x1079: u32 = 0;
    let mut x1080: u32 = 0;
    let (x1079, x1080) = fiat_p384_scalar_mulx_u32(x1067, 0xffffffff);
    let mut x1081: u32 = 0;
    let mut x1082: u32 = 0;
    let (x1081, x1082) = fiat_p384_scalar_mulx_u32(x1067, 0xc7634d81);
    let mut x1083: u32 = 0;
    let mut x1084: u32 = 0;
    let (x1083, x1084) = fiat_p384_scalar_mulx_u32(x1067, 0xf4372ddf);
    let mut x1085: u32 = 0;
    let mut x1086: u32 = 0;
    let (x1085, x1086) = fiat_p384_scalar_mulx_u32(x1067, 0x581a0db2);
    let mut x1087: u32 = 0;
    let mut x1088: u32 = 0;
    let (x1087, x1088) = fiat_p384_scalar_mulx_u32(x1067, 0x48b0a77a);
    let mut x1089: u32 = 0;
    let mut x1090: u32 = 0;
    let (x1089, x1090) = fiat_p384_scalar_mulx_u32(x1067, 0xecec196a);
    let mut x1091: u32 = 0;
    let mut x1092: u32 = 0;
    let (x1091, x1092) = fiat_p384_scalar_mulx_u32(x1067, 0xccc52973);
    let mut x1093: u32 = 0;
    let mut x1094: fiat_p384_scalar_u1 = 0;
    let (x1093, x1094) = fiat_p384_scalar_addcarryx_u32(0x0, x1092, x1089);
    let mut x1095: u32 = 0;
    let mut x1096: fiat_p384_scalar_u1 = 0;
    let (x1095, x1096) = fiat_p384_scalar_addcarryx_u32(x1094, x1090, x1087);
    let mut x1097: u32 = 0;
    let mut x1098: fiat_p384_scalar_u1 = 0;
    let (x1097, x1098) = fiat_p384_scalar_addcarryx_u32(x1096, x1088, x1085);
    let mut x1099: u32 = 0;
    let mut x1100: fiat_p384_scalar_u1 = 0;
    let (x1099, x1100) = fiat_p384_scalar_addcarryx_u32(x1098, x1086, x1083);
    let mut x1101: u32 = 0;
    let mut x1102: fiat_p384_scalar_u1 = 0;
    let (x1101, x1102) = fiat_p384_scalar_addcarryx_u32(x1100, x1084, x1081);
    let mut x1103: u32 = 0;
    let mut x1104: fiat_p384_scalar_u1 = 0;
    let (x1103, x1104) = fiat_p384_scalar_addcarryx_u32(x1102, x1082, x1079);
    let mut x1105: u32 = 0;
    let mut x1106: fiat_p384_scalar_u1 = 0;
    let (x1105, x1106) = fiat_p384_scalar_addcarryx_u32(x1104, x1080, x1077);
    let mut x1107: u32 = 0;
    let mut x1108: fiat_p384_scalar_u1 = 0;
    let (x1107, x1108) = fiat_p384_scalar_addcarryx_u32(x1106, x1078, x1075);
    let mut x1109: u32 = 0;
    let mut x1110: fiat_p384_scalar_u1 = 0;
    let (x1109, x1110) = fiat_p384_scalar_addcarryx_u32(x1108, x1076, x1073);
    let mut x1111: u32 = 0;
    let mut x1112: fiat_p384_scalar_u1 = 0;
    let (x1111, x1112) = fiat_p384_scalar_addcarryx_u32(x1110, x1074, x1071);
    let mut x1113: u32 = 0;
    let mut x1114: fiat_p384_scalar_u1 = 0;
    let (x1113, x1114) = fiat_p384_scalar_addcarryx_u32(x1112, x1072, x1069);
    let mut x1115: u32 = 0;
    let mut x1116: fiat_p384_scalar_u1 = 0;
    let (x1115, x1116) = fiat_p384_scalar_addcarryx_u32(0x0, x1043, x1091);
    let mut x1117: u32 = 0;
    let mut x1118: fiat_p384_scalar_u1 = 0;
    let (x1117, x1118) = fiat_p384_scalar_addcarryx_u32(x1116, x1045, x1093);
    let mut x1119: u32 = 0;
    let mut x1120: fiat_p384_scalar_u1 = 0;
    let (x1119, x1120) = fiat_p384_scalar_addcarryx_u32(x1118, x1047, x1095);
    let mut x1121: u32 = 0;
    let mut x1122: fiat_p384_scalar_u1 = 0;
    let (x1121, x1122) = fiat_p384_scalar_addcarryx_u32(x1120, x1049, x1097);
    let mut x1123: u32 = 0;
    let mut x1124: fiat_p384_scalar_u1 = 0;
    let (x1123, x1124) = fiat_p384_scalar_addcarryx_u32(x1122, x1051, x1099);
    let mut x1125: u32 = 0;
    let mut x1126: fiat_p384_scalar_u1 = 0;
    let (x1125, x1126) = fiat_p384_scalar_addcarryx_u32(x1124, x1053, x1101);
    let mut x1127: u32 = 0;
    let mut x1128: fiat_p384_scalar_u1 = 0;
    let (x1127, x1128) = fiat_p384_scalar_addcarryx_u32(x1126, x1055, x1103);
    let mut x1129: u32 = 0;
    let mut x1130: fiat_p384_scalar_u1 = 0;
    let (x1129, x1130) = fiat_p384_scalar_addcarryx_u32(x1128, x1057, x1105);
    let mut x1131: u32 = 0;
    let mut x1132: fiat_p384_scalar_u1 = 0;
    let (x1131, x1132) = fiat_p384_scalar_addcarryx_u32(x1130, x1059, x1107);
    let mut x1133: u32 = 0;
    let mut x1134: fiat_p384_scalar_u1 = 0;
    let (x1133, x1134) = fiat_p384_scalar_addcarryx_u32(x1132, x1061, x1109);
    let mut x1135: u32 = 0;
    let mut x1136: fiat_p384_scalar_u1 = 0;
    let (x1135, x1136) = fiat_p384_scalar_addcarryx_u32(x1134, x1063, x1111);
    let mut x1137: u32 = 0;
    let mut x1138: fiat_p384_scalar_u1 = 0;
    let (x1137, x1138) = fiat_p384_scalar_addcarryx_u32(x1136, x1065, x1113);
    let mut x1139: u32 = 0;
    let mut x1140: fiat_p384_scalar_u1 = 0;
    let (x1139, x1140) = fiat_p384_scalar_addcarryx_u32(
        x1138,
        (((x1066 as u32) + (x996 as u32)) + ((x1042 as u32) + x998)),
        ((x1114 as u32) + x1070),
    );
    let mut x1141: u32 = 0;
    let mut x1142: u32 = 0;
    let (x1141, x1142) = fiat_p384_scalar_mulx_u32(x8, 0xc84ee01);
    let mut x1143: u32 = 0;
    let mut x1144: u32 = 0;
    let (x1143, x1144) = fiat_p384_scalar_mulx_u32(x8, 0x2b39bf21);
    let mut x1145: u32 = 0;
    let mut x1146: u32 = 0;
    let (x1145, x1146) = fiat_p384_scalar_mulx_u32(x8, 0x3fb05b7a);
    let mut x1147: u32 = 0;
    let mut x1148: u32 = 0;
    let (x1147, x1148) = fiat_p384_scalar_mulx_u32(x8, 0x28266895);
    let mut x1149: u32 = 0;
    let mut x1150: u32 = 0;
    let (x1149, x1150) = fiat_p384_scalar_mulx_u32(x8, 0xd40d4917);
    let mut x1151: u32 = 0;
    let mut x1152: u32 = 0;
    let (x1151, x1152) = fiat_p384_scalar_mulx_u32(x8, 0x4aab1cc5);
    let mut x1153: u32 = 0;
    let mut x1154: u32 = 0;
    let (x1153, x1154) = fiat_p384_scalar_mulx_u32(x8, 0xbc3e483a);
    let mut x1155: u32 = 0;
    let mut x1156: u32 = 0;
    let (x1155, x1156) = fiat_p384_scalar_mulx_u32(x8, 0xfcb82947);
    let mut x1157: u32 = 0;
    let mut x1158: u32 = 0;
    let (x1157, x1158) = fiat_p384_scalar_mulx_u32(x8, 0xff3d81e5);
    let mut x1159: u32 = 0;
    let mut x1160: u32 = 0;
    let (x1159, x1160) = fiat_p384_scalar_mulx_u32(x8, 0xdf1aa419);
    let mut x1161: u32 = 0;
    let mut x1162: u32 = 0;
    let (x1161, x1162) = fiat_p384_scalar_mulx_u32(x8, 0x2d319b24);
    let mut x1163: u32 = 0;
    let mut x1164: u32 = 0;
    let (x1163, x1164) = fiat_p384_scalar_mulx_u32(x8, 0x19b409a9);
    let mut x1165: u32 = 0;
    let mut x1166: fiat_p384_scalar_u1 = 0;
    let (x1165, x1166) = fiat_p384_scalar_addcarryx_u32(0x0, x1164, x1161);
    let mut x1167: u32 = 0;
    let mut x1168: fiat_p384_scalar_u1 = 0;
    let (x1167, x1168) = fiat_p384_scalar_addcarryx_u32(x1166, x1162, x1159);
    let mut x1169: u32 = 0;
    let mut x1170: fiat_p384_scalar_u1 = 0;
    let (x1169, x1170) = fiat_p384_scalar_addcarryx_u32(x1168, x1160, x1157);
    let mut x1171: u32 = 0;
    let mut x1172: fiat_p384_scalar_u1 = 0;
    let (x1171, x1172) = fiat_p384_scalar_addcarryx_u32(x1170, x1158, x1155);
    let mut x1173: u32 = 0;
    let mut x1174: fiat_p384_scalar_u1 = 0;
    let (x1173, x1174) = fiat_p384_scalar_addcarryx_u32(x1172, x1156, x1153);
    let mut x1175: u32 = 0;
    let mut x1176: fiat_p384_scalar_u1 = 0;
    let (x1175, x1176) = fiat_p384_scalar_addcarryx_u32(x1174, x1154, x1151);
    let mut x1177: u32 = 0;
    let mut x1178: fiat_p384_scalar_u1 = 0;
    let (x1177, x1178) = fiat_p384_scalar_addcarryx_u32(x1176, x1152, x1149);
    let mut x1179: u32 = 0;
    let mut x1180: fiat_p384_scalar_u1 = 0;
    let (x1179, x1180) = fiat_p384_scalar_addcarryx_u32(x1178, x1150, x1147);
    let mut x1181: u32 = 0;
    let mut x1182: fiat_p384_scalar_u1 = 0;
    let (x1181, x1182) = fiat_p384_scalar_addcarryx_u32(x1180, x1148, x1145);
    let mut x1183: u32 = 0;
    let mut x1184: fiat_p384_scalar_u1 = 0;
    let (x1183, x1184) = fiat_p384_scalar_addcarryx_u32(x1182, x1146, x1143);
    let mut x1185: u32 = 0;
    let mut x1186: fiat_p384_scalar_u1 = 0;
    let (x1185, x1186) = fiat_p384_scalar_addcarryx_u32(x1184, x1144, x1141);
    let mut x1187: u32 = 0;
    let mut x1188: fiat_p384_scalar_u1 = 0;
    let (x1187, x1188) = fiat_p384_scalar_addcarryx_u32(0x0, x1117, x1163);
    let mut x1189: u32 = 0;
    let mut x1190: fiat_p384_scalar_u1 = 0;
    let (x1189, x1190) = fiat_p384_scalar_addcarryx_u32(x1188, x1119, x1165);
    let mut x1191: u32 = 0;
    let mut x1192: fiat_p384_scalar_u1 = 0;
    let (x1191, x1192) = fiat_p384_scalar_addcarryx_u32(x1190, x1121, x1167);
    let mut x1193: u32 = 0;
    let mut x1194: fiat_p384_scalar_u1 = 0;
    let (x1193, x1194) = fiat_p384_scalar_addcarryx_u32(x1192, x1123, x1169);
    let mut x1195: u32 = 0;
    let mut x1196: fiat_p384_scalar_u1 = 0;
    let (x1195, x1196) = fiat_p384_scalar_addcarryx_u32(x1194, x1125, x1171);
    let mut x1197: u32 = 0;
    let mut x1198: fiat_p384_scalar_u1 = 0;
    let (x1197, x1198) = fiat_p384_scalar_addcarryx_u32(x1196, x1127, x1173);
    let mut x1199: u32 = 0;
    let mut x1200: fiat_p384_scalar_u1 = 0;
    let (x1199, x1200) = fiat_p384_scalar_addcarryx_u32(x1198, x1129, x1175);
    let mut x1201: u32 = 0;
    let mut x1202: fiat_p384_scalar_u1 = 0;
    let (x1201, x1202) = fiat_p384_scalar_addcarryx_u32(x1200, x1131, x1177);
    let mut x1203: u32 = 0;
    let mut x1204: fiat_p384_scalar_u1 = 0;
    let (x1203, x1204) = fiat_p384_scalar_addcarryx_u32(x1202, x1133, x1179);
    let mut x1205: u32 = 0;
    let mut x1206: fiat_p384_scalar_u1 = 0;
    let (x1205, x1206) = fiat_p384_scalar_addcarryx_u32(x1204, x1135, x1181);
    let mut x1207: u32 = 0;
    let mut x1208: fiat_p384_scalar_u1 = 0;
    let (x1207, x1208) = fiat_p384_scalar_addcarryx_u32(x1206, x1137, x1183);
    let mut x1209: u32 = 0;
    let mut x1210: fiat_p384_scalar_u1 = 0;
    let (x1209, x1210) = fiat_p384_scalar_addcarryx_u32(x1208, x1139, x1185);
    let mut x1211: u32 = 0;
    let mut x1212: u32 = 0;
    let (x1211, x1212) = fiat_p384_scalar_mulx_u32(x1187, 0xe88fdc45);
    let mut x1213: u32 = 0;
    let mut x1214: u32 = 0;
    let (x1213, x1214) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let mut x1215: u32 = 0;
    let mut x1216: u32 = 0;
    let (x1215, x1216) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let mut x1217: u32 = 0;
    let mut x1218: u32 = 0;
    let (x1217, x1218) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let mut x1219: u32 = 0;
    let mut x1220: u32 = 0;
    let (x1219, x1220) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let mut x1221: u32 = 0;
    let mut x1222: u32 = 0;
    let (x1221, x1222) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let mut x1223: u32 = 0;
    let mut x1224: u32 = 0;
    let (x1223, x1224) = fiat_p384_scalar_mulx_u32(x1211, 0xffffffff);
    let mut x1225: u32 = 0;
    let mut x1226: u32 = 0;
    let (x1225, x1226) = fiat_p384_scalar_mulx_u32(x1211, 0xc7634d81);
    let mut x1227: u32 = 0;
    let mut x1228: u32 = 0;
    let (x1227, x1228) = fiat_p384_scalar_mulx_u32(x1211, 0xf4372ddf);
    let mut x1229: u32 = 0;
    let mut x1230: u32 = 0;
    let (x1229, x1230) = fiat_p384_scalar_mulx_u32(x1211, 0x581a0db2);
    let mut x1231: u32 = 0;
    let mut x1232: u32 = 0;
    let (x1231, x1232) = fiat_p384_scalar_mulx_u32(x1211, 0x48b0a77a);
    let mut x1233: u32 = 0;
    let mut x1234: u32 = 0;
    let (x1233, x1234) = fiat_p384_scalar_mulx_u32(x1211, 0xecec196a);
    let mut x1235: u32 = 0;
    let mut x1236: u32 = 0;
    let (x1235, x1236) = fiat_p384_scalar_mulx_u32(x1211, 0xccc52973);
    let mut x1237: u32 = 0;
    let mut x1238: fiat_p384_scalar_u1 = 0;
    let (x1237, x1238) = fiat_p384_scalar_addcarryx_u32(0x0, x1236, x1233);
    let mut x1239: u32 = 0;
    let mut x1240: fiat_p384_scalar_u1 = 0;
    let (x1239, x1240) = fiat_p384_scalar_addcarryx_u32(x1238, x1234, x1231);
    let mut x1241: u32 = 0;
    let mut x1242: fiat_p384_scalar_u1 = 0;
    let (x1241, x1242) = fiat_p384_scalar_addcarryx_u32(x1240, x1232, x1229);
    let mut x1243: u32 = 0;
    let mut x1244: fiat_p384_scalar_u1 = 0;
    let (x1243, x1244) = fiat_p384_scalar_addcarryx_u32(x1242, x1230, x1227);
    let mut x1245: u32 = 0;
    let mut x1246: fiat_p384_scalar_u1 = 0;
    let (x1245, x1246) = fiat_p384_scalar_addcarryx_u32(x1244, x1228, x1225);
    let mut x1247: u32 = 0;
    let mut x1248: fiat_p384_scalar_u1 = 0;
    let (x1247, x1248) = fiat_p384_scalar_addcarryx_u32(x1246, x1226, x1223);
    let mut x1249: u32 = 0;
    let mut x1250: fiat_p384_scalar_u1 = 0;
    let (x1249, x1250) = fiat_p384_scalar_addcarryx_u32(x1248, x1224, x1221);
    let mut x1251: u32 = 0;
    let mut x1252: fiat_p384_scalar_u1 = 0;
    let (x1251, x1252) = fiat_p384_scalar_addcarryx_u32(x1250, x1222, x1219);
    let mut x1253: u32 = 0;
    let mut x1254: fiat_p384_scalar_u1 = 0;
    let (x1253, x1254) = fiat_p384_scalar_addcarryx_u32(x1252, x1220, x1217);
    let mut x1255: u32 = 0;
    let mut x1256: fiat_p384_scalar_u1 = 0;
    let (x1255, x1256) = fiat_p384_scalar_addcarryx_u32(x1254, x1218, x1215);
    let mut x1257: u32 = 0;
    let mut x1258: fiat_p384_scalar_u1 = 0;
    let (x1257, x1258) = fiat_p384_scalar_addcarryx_u32(x1256, x1216, x1213);
    let mut x1259: u32 = 0;
    let mut x1260: fiat_p384_scalar_u1 = 0;
    let (x1259, x1260) = fiat_p384_scalar_addcarryx_u32(0x0, x1187, x1235);
    let mut x1261: u32 = 0;
    let mut x1262: fiat_p384_scalar_u1 = 0;
    let (x1261, x1262) = fiat_p384_scalar_addcarryx_u32(x1260, x1189, x1237);
    let mut x1263: u32 = 0;
    let mut x1264: fiat_p384_scalar_u1 = 0;
    let (x1263, x1264) = fiat_p384_scalar_addcarryx_u32(x1262, x1191, x1239);
    let mut x1265: u32 = 0;
    let mut x1266: fiat_p384_scalar_u1 = 0;
    let (x1265, x1266) = fiat_p384_scalar_addcarryx_u32(x1264, x1193, x1241);
    let mut x1267: u32 = 0;
    let mut x1268: fiat_p384_scalar_u1 = 0;
    let (x1267, x1268) = fiat_p384_scalar_addcarryx_u32(x1266, x1195, x1243);
    let mut x1269: u32 = 0;
    let mut x1270: fiat_p384_scalar_u1 = 0;
    let (x1269, x1270) = fiat_p384_scalar_addcarryx_u32(x1268, x1197, x1245);
    let mut x1271: u32 = 0;
    let mut x1272: fiat_p384_scalar_u1 = 0;
    let (x1271, x1272) = fiat_p384_scalar_addcarryx_u32(x1270, x1199, x1247);
    let mut x1273: u32 = 0;
    let mut x1274: fiat_p384_scalar_u1 = 0;
    let (x1273, x1274) = fiat_p384_scalar_addcarryx_u32(x1272, x1201, x1249);
    let mut x1275: u32 = 0;
    let mut x1276: fiat_p384_scalar_u1 = 0;
    let (x1275, x1276) = fiat_p384_scalar_addcarryx_u32(x1274, x1203, x1251);
    let mut x1277: u32 = 0;
    let mut x1278: fiat_p384_scalar_u1 = 0;
    let (x1277, x1278) = fiat_p384_scalar_addcarryx_u32(x1276, x1205, x1253);
    let mut x1279: u32 = 0;
    let mut x1280: fiat_p384_scalar_u1 = 0;
    let (x1279, x1280) = fiat_p384_scalar_addcarryx_u32(x1278, x1207, x1255);
    let mut x1281: u32 = 0;
    let mut x1282: fiat_p384_scalar_u1 = 0;
    let (x1281, x1282) = fiat_p384_scalar_addcarryx_u32(x1280, x1209, x1257);
    let mut x1283: u32 = 0;
    let mut x1284: fiat_p384_scalar_u1 = 0;
    let (x1283, x1284) = fiat_p384_scalar_addcarryx_u32(
        x1282,
        (((x1210 as u32) + (x1140 as u32)) + ((x1186 as u32) + x1142)),
        ((x1258 as u32) + x1214),
    );
    let mut x1285: u32 = 0;
    let mut x1286: u32 = 0;
    let (x1285, x1286) = fiat_p384_scalar_mulx_u32(x9, 0xc84ee01);
    let mut x1287: u32 = 0;
    let mut x1288: u32 = 0;
    let (x1287, x1288) = fiat_p384_scalar_mulx_u32(x9, 0x2b39bf21);
    let mut x1289: u32 = 0;
    let mut x1290: u32 = 0;
    let (x1289, x1290) = fiat_p384_scalar_mulx_u32(x9, 0x3fb05b7a);
    let mut x1291: u32 = 0;
    let mut x1292: u32 = 0;
    let (x1291, x1292) = fiat_p384_scalar_mulx_u32(x9, 0x28266895);
    let mut x1293: u32 = 0;
    let mut x1294: u32 = 0;
    let (x1293, x1294) = fiat_p384_scalar_mulx_u32(x9, 0xd40d4917);
    let mut x1295: u32 = 0;
    let mut x1296: u32 = 0;
    let (x1295, x1296) = fiat_p384_scalar_mulx_u32(x9, 0x4aab1cc5);
    let mut x1297: u32 = 0;
    let mut x1298: u32 = 0;
    let (x1297, x1298) = fiat_p384_scalar_mulx_u32(x9, 0xbc3e483a);
    let mut x1299: u32 = 0;
    let mut x1300: u32 = 0;
    let (x1299, x1300) = fiat_p384_scalar_mulx_u32(x9, 0xfcb82947);
    let mut x1301: u32 = 0;
    let mut x1302: u32 = 0;
    let (x1301, x1302) = fiat_p384_scalar_mulx_u32(x9, 0xff3d81e5);
    let mut x1303: u32 = 0;
    let mut x1304: u32 = 0;
    let (x1303, x1304) = fiat_p384_scalar_mulx_u32(x9, 0xdf1aa419);
    let mut x1305: u32 = 0;
    let mut x1306: u32 = 0;
    let (x1305, x1306) = fiat_p384_scalar_mulx_u32(x9, 0x2d319b24);
    let mut x1307: u32 = 0;
    let mut x1308: u32 = 0;
    let (x1307, x1308) = fiat_p384_scalar_mulx_u32(x9, 0x19b409a9);
    let mut x1309: u32 = 0;
    let mut x1310: fiat_p384_scalar_u1 = 0;
    let (x1309, x1310) = fiat_p384_scalar_addcarryx_u32(0x0, x1308, x1305);
    let mut x1311: u32 = 0;
    let mut x1312: fiat_p384_scalar_u1 = 0;
    let (x1311, x1312) = fiat_p384_scalar_addcarryx_u32(x1310, x1306, x1303);
    let mut x1313: u32 = 0;
    let mut x1314: fiat_p384_scalar_u1 = 0;
    let (x1313, x1314) = fiat_p384_scalar_addcarryx_u32(x1312, x1304, x1301);
    let mut x1315: u32 = 0;
    let mut x1316: fiat_p384_scalar_u1 = 0;
    let (x1315, x1316) = fiat_p384_scalar_addcarryx_u32(x1314, x1302, x1299);
    let mut x1317: u32 = 0;
    let mut x1318: fiat_p384_scalar_u1 = 0;
    let (x1317, x1318) = fiat_p384_scalar_addcarryx_u32(x1316, x1300, x1297);
    let mut x1319: u32 = 0;
    let mut x1320: fiat_p384_scalar_u1 = 0;
    let (x1319, x1320) = fiat_p384_scalar_addcarryx_u32(x1318, x1298, x1295);
    let mut x1321: u32 = 0;
    let mut x1322: fiat_p384_scalar_u1 = 0;
    let (x1321, x1322) = fiat_p384_scalar_addcarryx_u32(x1320, x1296, x1293);
    let mut x1323: u32 = 0;
    let mut x1324: fiat_p384_scalar_u1 = 0;
    let (x1323, x1324) = fiat_p384_scalar_addcarryx_u32(x1322, x1294, x1291);
    let mut x1325: u32 = 0;
    let mut x1326: fiat_p384_scalar_u1 = 0;
    let (x1325, x1326) = fiat_p384_scalar_addcarryx_u32(x1324, x1292, x1289);
    let mut x1327: u32 = 0;
    let mut x1328: fiat_p384_scalar_u1 = 0;
    let (x1327, x1328) = fiat_p384_scalar_addcarryx_u32(x1326, x1290, x1287);
    let mut x1329: u32 = 0;
    let mut x1330: fiat_p384_scalar_u1 = 0;
    let (x1329, x1330) = fiat_p384_scalar_addcarryx_u32(x1328, x1288, x1285);
    let mut x1331: u32 = 0;
    let mut x1332: fiat_p384_scalar_u1 = 0;
    let (x1331, x1332) = fiat_p384_scalar_addcarryx_u32(0x0, x1261, x1307);
    let mut x1333: u32 = 0;
    let mut x1334: fiat_p384_scalar_u1 = 0;
    let (x1333, x1334) = fiat_p384_scalar_addcarryx_u32(x1332, x1263, x1309);
    let mut x1335: u32 = 0;
    let mut x1336: fiat_p384_scalar_u1 = 0;
    let (x1335, x1336) = fiat_p384_scalar_addcarryx_u32(x1334, x1265, x1311);
    let mut x1337: u32 = 0;
    let mut x1338: fiat_p384_scalar_u1 = 0;
    let (x1337, x1338) = fiat_p384_scalar_addcarryx_u32(x1336, x1267, x1313);
    let mut x1339: u32 = 0;
    let mut x1340: fiat_p384_scalar_u1 = 0;
    let (x1339, x1340) = fiat_p384_scalar_addcarryx_u32(x1338, x1269, x1315);
    let mut x1341: u32 = 0;
    let mut x1342: fiat_p384_scalar_u1 = 0;
    let (x1341, x1342) = fiat_p384_scalar_addcarryx_u32(x1340, x1271, x1317);
    let mut x1343: u32 = 0;
    let mut x1344: fiat_p384_scalar_u1 = 0;
    let (x1343, x1344) = fiat_p384_scalar_addcarryx_u32(x1342, x1273, x1319);
    let mut x1345: u32 = 0;
    let mut x1346: fiat_p384_scalar_u1 = 0;
    let (x1345, x1346) = fiat_p384_scalar_addcarryx_u32(x1344, x1275, x1321);
    let mut x1347: u32 = 0;
    let mut x1348: fiat_p384_scalar_u1 = 0;
    let (x1347, x1348) = fiat_p384_scalar_addcarryx_u32(x1346, x1277, x1323);
    let mut x1349: u32 = 0;
    let mut x1350: fiat_p384_scalar_u1 = 0;
    let (x1349, x1350) = fiat_p384_scalar_addcarryx_u32(x1348, x1279, x1325);
    let mut x1351: u32 = 0;
    let mut x1352: fiat_p384_scalar_u1 = 0;
    let (x1351, x1352) = fiat_p384_scalar_addcarryx_u32(x1350, x1281, x1327);
    let mut x1353: u32 = 0;
    let mut x1354: fiat_p384_scalar_u1 = 0;
    let (x1353, x1354) = fiat_p384_scalar_addcarryx_u32(x1352, x1283, x1329);
    let mut x1355: u32 = 0;
    let mut x1356: u32 = 0;
    let (x1355, x1356) = fiat_p384_scalar_mulx_u32(x1331, 0xe88fdc45);
    let mut x1357: u32 = 0;
    let mut x1358: u32 = 0;
    let (x1357, x1358) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let mut x1359: u32 = 0;
    let mut x1360: u32 = 0;
    let (x1359, x1360) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let mut x1361: u32 = 0;
    let mut x1362: u32 = 0;
    let (x1361, x1362) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let mut x1363: u32 = 0;
    let mut x1364: u32 = 0;
    let (x1363, x1364) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let mut x1365: u32 = 0;
    let mut x1366: u32 = 0;
    let (x1365, x1366) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let mut x1367: u32 = 0;
    let mut x1368: u32 = 0;
    let (x1367, x1368) = fiat_p384_scalar_mulx_u32(x1355, 0xffffffff);
    let mut x1369: u32 = 0;
    let mut x1370: u32 = 0;
    let (x1369, x1370) = fiat_p384_scalar_mulx_u32(x1355, 0xc7634d81);
    let mut x1371: u32 = 0;
    let mut x1372: u32 = 0;
    let (x1371, x1372) = fiat_p384_scalar_mulx_u32(x1355, 0xf4372ddf);
    let mut x1373: u32 = 0;
    let mut x1374: u32 = 0;
    let (x1373, x1374) = fiat_p384_scalar_mulx_u32(x1355, 0x581a0db2);
    let mut x1375: u32 = 0;
    let mut x1376: u32 = 0;
    let (x1375, x1376) = fiat_p384_scalar_mulx_u32(x1355, 0x48b0a77a);
    let mut x1377: u32 = 0;
    let mut x1378: u32 = 0;
    let (x1377, x1378) = fiat_p384_scalar_mulx_u32(x1355, 0xecec196a);
    let mut x1379: u32 = 0;
    let mut x1380: u32 = 0;
    let (x1379, x1380) = fiat_p384_scalar_mulx_u32(x1355, 0xccc52973);
    let mut x1381: u32 = 0;
    let mut x1382: fiat_p384_scalar_u1 = 0;
    let (x1381, x1382) = fiat_p384_scalar_addcarryx_u32(0x0, x1380, x1377);
    let mut x1383: u32 = 0;
    let mut x1384: fiat_p384_scalar_u1 = 0;
    let (x1383, x1384) = fiat_p384_scalar_addcarryx_u32(x1382, x1378, x1375);
    let mut x1385: u32 = 0;
    let mut x1386: fiat_p384_scalar_u1 = 0;
    let (x1385, x1386) = fiat_p384_scalar_addcarryx_u32(x1384, x1376, x1373);
    let mut x1387: u32 = 0;
    let mut x1388: fiat_p384_scalar_u1 = 0;
    let (x1387, x1388) = fiat_p384_scalar_addcarryx_u32(x1386, x1374, x1371);
    let mut x1389: u32 = 0;
    let mut x1390: fiat_p384_scalar_u1 = 0;
    let (x1389, x1390) = fiat_p384_scalar_addcarryx_u32(x1388, x1372, x1369);
    let mut x1391: u32 = 0;
    let mut x1392: fiat_p384_scalar_u1 = 0;
    let (x1391, x1392) = fiat_p384_scalar_addcarryx_u32(x1390, x1370, x1367);
    let mut x1393: u32 = 0;
    let mut x1394: fiat_p384_scalar_u1 = 0;
    let (x1393, x1394) = fiat_p384_scalar_addcarryx_u32(x1392, x1368, x1365);
    let mut x1395: u32 = 0;
    let mut x1396: fiat_p384_scalar_u1 = 0;
    let (x1395, x1396) = fiat_p384_scalar_addcarryx_u32(x1394, x1366, x1363);
    let mut x1397: u32 = 0;
    let mut x1398: fiat_p384_scalar_u1 = 0;
    let (x1397, x1398) = fiat_p384_scalar_addcarryx_u32(x1396, x1364, x1361);
    let mut x1399: u32 = 0;
    let mut x1400: fiat_p384_scalar_u1 = 0;
    let (x1399, x1400) = fiat_p384_scalar_addcarryx_u32(x1398, x1362, x1359);
    let mut x1401: u32 = 0;
    let mut x1402: fiat_p384_scalar_u1 = 0;
    let (x1401, x1402) = fiat_p384_scalar_addcarryx_u32(x1400, x1360, x1357);
    let mut x1403: u32 = 0;
    let mut x1404: fiat_p384_scalar_u1 = 0;
    let (x1403, x1404) = fiat_p384_scalar_addcarryx_u32(0x0, x1331, x1379);
    let mut x1405: u32 = 0;
    let mut x1406: fiat_p384_scalar_u1 = 0;
    let (x1405, x1406) = fiat_p384_scalar_addcarryx_u32(x1404, x1333, x1381);
    let mut x1407: u32 = 0;
    let mut x1408: fiat_p384_scalar_u1 = 0;
    let (x1407, x1408) = fiat_p384_scalar_addcarryx_u32(x1406, x1335, x1383);
    let mut x1409: u32 = 0;
    let mut x1410: fiat_p384_scalar_u1 = 0;
    let (x1409, x1410) = fiat_p384_scalar_addcarryx_u32(x1408, x1337, x1385);
    let mut x1411: u32 = 0;
    let mut x1412: fiat_p384_scalar_u1 = 0;
    let (x1411, x1412) = fiat_p384_scalar_addcarryx_u32(x1410, x1339, x1387);
    let mut x1413: u32 = 0;
    let mut x1414: fiat_p384_scalar_u1 = 0;
    let (x1413, x1414) = fiat_p384_scalar_addcarryx_u32(x1412, x1341, x1389);
    let mut x1415: u32 = 0;
    let mut x1416: fiat_p384_scalar_u1 = 0;
    let (x1415, x1416) = fiat_p384_scalar_addcarryx_u32(x1414, x1343, x1391);
    let mut x1417: u32 = 0;
    let mut x1418: fiat_p384_scalar_u1 = 0;
    let (x1417, x1418) = fiat_p384_scalar_addcarryx_u32(x1416, x1345, x1393);
    let mut x1419: u32 = 0;
    let mut x1420: fiat_p384_scalar_u1 = 0;
    let (x1419, x1420) = fiat_p384_scalar_addcarryx_u32(x1418, x1347, x1395);
    let mut x1421: u32 = 0;
    let mut x1422: fiat_p384_scalar_u1 = 0;
    let (x1421, x1422) = fiat_p384_scalar_addcarryx_u32(x1420, x1349, x1397);
    let mut x1423: u32 = 0;
    let mut x1424: fiat_p384_scalar_u1 = 0;
    let (x1423, x1424) = fiat_p384_scalar_addcarryx_u32(x1422, x1351, x1399);
    let mut x1425: u32 = 0;
    let mut x1426: fiat_p384_scalar_u1 = 0;
    let (x1425, x1426) = fiat_p384_scalar_addcarryx_u32(x1424, x1353, x1401);
    let mut x1427: u32 = 0;
    let mut x1428: fiat_p384_scalar_u1 = 0;
    let (x1427, x1428) = fiat_p384_scalar_addcarryx_u32(
        x1426,
        (((x1354 as u32) + (x1284 as u32)) + ((x1330 as u32) + x1286)),
        ((x1402 as u32) + x1358),
    );
    let mut x1429: u32 = 0;
    let mut x1430: u32 = 0;
    let (x1429, x1430) = fiat_p384_scalar_mulx_u32(x10, 0xc84ee01);
    let mut x1431: u32 = 0;
    let mut x1432: u32 = 0;
    let (x1431, x1432) = fiat_p384_scalar_mulx_u32(x10, 0x2b39bf21);
    let mut x1433: u32 = 0;
    let mut x1434: u32 = 0;
    let (x1433, x1434) = fiat_p384_scalar_mulx_u32(x10, 0x3fb05b7a);
    let mut x1435: u32 = 0;
    let mut x1436: u32 = 0;
    let (x1435, x1436) = fiat_p384_scalar_mulx_u32(x10, 0x28266895);
    let mut x1437: u32 = 0;
    let mut x1438: u32 = 0;
    let (x1437, x1438) = fiat_p384_scalar_mulx_u32(x10, 0xd40d4917);
    let mut x1439: u32 = 0;
    let mut x1440: u32 = 0;
    let (x1439, x1440) = fiat_p384_scalar_mulx_u32(x10, 0x4aab1cc5);
    let mut x1441: u32 = 0;
    let mut x1442: u32 = 0;
    let (x1441, x1442) = fiat_p384_scalar_mulx_u32(x10, 0xbc3e483a);
    let mut x1443: u32 = 0;
    let mut x1444: u32 = 0;
    let (x1443, x1444) = fiat_p384_scalar_mulx_u32(x10, 0xfcb82947);
    let mut x1445: u32 = 0;
    let mut x1446: u32 = 0;
    let (x1445, x1446) = fiat_p384_scalar_mulx_u32(x10, 0xff3d81e5);
    let mut x1447: u32 = 0;
    let mut x1448: u32 = 0;
    let (x1447, x1448) = fiat_p384_scalar_mulx_u32(x10, 0xdf1aa419);
    let mut x1449: u32 = 0;
    let mut x1450: u32 = 0;
    let (x1449, x1450) = fiat_p384_scalar_mulx_u32(x10, 0x2d319b24);
    let mut x1451: u32 = 0;
    let mut x1452: u32 = 0;
    let (x1451, x1452) = fiat_p384_scalar_mulx_u32(x10, 0x19b409a9);
    let mut x1453: u32 = 0;
    let mut x1454: fiat_p384_scalar_u1 = 0;
    let (x1453, x1454) = fiat_p384_scalar_addcarryx_u32(0x0, x1452, x1449);
    let mut x1455: u32 = 0;
    let mut x1456: fiat_p384_scalar_u1 = 0;
    let (x1455, x1456) = fiat_p384_scalar_addcarryx_u32(x1454, x1450, x1447);
    let mut x1457: u32 = 0;
    let mut x1458: fiat_p384_scalar_u1 = 0;
    let (x1457, x1458) = fiat_p384_scalar_addcarryx_u32(x1456, x1448, x1445);
    let mut x1459: u32 = 0;
    let mut x1460: fiat_p384_scalar_u1 = 0;
    let (x1459, x1460) = fiat_p384_scalar_addcarryx_u32(x1458, x1446, x1443);
    let mut x1461: u32 = 0;
    let mut x1462: fiat_p384_scalar_u1 = 0;
    let (x1461, x1462) = fiat_p384_scalar_addcarryx_u32(x1460, x1444, x1441);
    let mut x1463: u32 = 0;
    let mut x1464: fiat_p384_scalar_u1 = 0;
    let (x1463, x1464) = fiat_p384_scalar_addcarryx_u32(x1462, x1442, x1439);
    let mut x1465: u32 = 0;
    let mut x1466: fiat_p384_scalar_u1 = 0;
    let (x1465, x1466) = fiat_p384_scalar_addcarryx_u32(x1464, x1440, x1437);
    let mut x1467: u32 = 0;
    let mut x1468: fiat_p384_scalar_u1 = 0;
    let (x1467, x1468) = fiat_p384_scalar_addcarryx_u32(x1466, x1438, x1435);
    let mut x1469: u32 = 0;
    let mut x1470: fiat_p384_scalar_u1 = 0;
    let (x1469, x1470) = fiat_p384_scalar_addcarryx_u32(x1468, x1436, x1433);
    let mut x1471: u32 = 0;
    let mut x1472: fiat_p384_scalar_u1 = 0;
    let (x1471, x1472) = fiat_p384_scalar_addcarryx_u32(x1470, x1434, x1431);
    let mut x1473: u32 = 0;
    let mut x1474: fiat_p384_scalar_u1 = 0;
    let (x1473, x1474) = fiat_p384_scalar_addcarryx_u32(x1472, x1432, x1429);
    let mut x1475: u32 = 0;
    let mut x1476: fiat_p384_scalar_u1 = 0;
    let (x1475, x1476) = fiat_p384_scalar_addcarryx_u32(0x0, x1405, x1451);
    let mut x1477: u32 = 0;
    let mut x1478: fiat_p384_scalar_u1 = 0;
    let (x1477, x1478) = fiat_p384_scalar_addcarryx_u32(x1476, x1407, x1453);
    let mut x1479: u32 = 0;
    let mut x1480: fiat_p384_scalar_u1 = 0;
    let (x1479, x1480) = fiat_p384_scalar_addcarryx_u32(x1478, x1409, x1455);
    let mut x1481: u32 = 0;
    let mut x1482: fiat_p384_scalar_u1 = 0;
    let (x1481, x1482) = fiat_p384_scalar_addcarryx_u32(x1480, x1411, x1457);
    let mut x1483: u32 = 0;
    let mut x1484: fiat_p384_scalar_u1 = 0;
    let (x1483, x1484) = fiat_p384_scalar_addcarryx_u32(x1482, x1413, x1459);
    let mut x1485: u32 = 0;
    let mut x1486: fiat_p384_scalar_u1 = 0;
    let (x1485, x1486) = fiat_p384_scalar_addcarryx_u32(x1484, x1415, x1461);
    let mut x1487: u32 = 0;
    let mut x1488: fiat_p384_scalar_u1 = 0;
    let (x1487, x1488) = fiat_p384_scalar_addcarryx_u32(x1486, x1417, x1463);
    let mut x1489: u32 = 0;
    let mut x1490: fiat_p384_scalar_u1 = 0;
    let (x1489, x1490) = fiat_p384_scalar_addcarryx_u32(x1488, x1419, x1465);
    let mut x1491: u32 = 0;
    let mut x1492: fiat_p384_scalar_u1 = 0;
    let (x1491, x1492) = fiat_p384_scalar_addcarryx_u32(x1490, x1421, x1467);
    let mut x1493: u32 = 0;
    let mut x1494: fiat_p384_scalar_u1 = 0;
    let (x1493, x1494) = fiat_p384_scalar_addcarryx_u32(x1492, x1423, x1469);
    let mut x1495: u32 = 0;
    let mut x1496: fiat_p384_scalar_u1 = 0;
    let (x1495, x1496) = fiat_p384_scalar_addcarryx_u32(x1494, x1425, x1471);
    let mut x1497: u32 = 0;
    let mut x1498: fiat_p384_scalar_u1 = 0;
    let (x1497, x1498) = fiat_p384_scalar_addcarryx_u32(x1496, x1427, x1473);
    let mut x1499: u32 = 0;
    let mut x1500: u32 = 0;
    let (x1499, x1500) = fiat_p384_scalar_mulx_u32(x1475, 0xe88fdc45);
    let mut x1501: u32 = 0;
    let mut x1502: u32 = 0;
    let (x1501, x1502) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let mut x1503: u32 = 0;
    let mut x1504: u32 = 0;
    let (x1503, x1504) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let mut x1505: u32 = 0;
    let mut x1506: u32 = 0;
    let (x1505, x1506) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let mut x1507: u32 = 0;
    let mut x1508: u32 = 0;
    let (x1507, x1508) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let mut x1509: u32 = 0;
    let mut x1510: u32 = 0;
    let (x1509, x1510) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let mut x1511: u32 = 0;
    let mut x1512: u32 = 0;
    let (x1511, x1512) = fiat_p384_scalar_mulx_u32(x1499, 0xffffffff);
    let mut x1513: u32 = 0;
    let mut x1514: u32 = 0;
    let (x1513, x1514) = fiat_p384_scalar_mulx_u32(x1499, 0xc7634d81);
    let mut x1515: u32 = 0;
    let mut x1516: u32 = 0;
    let (x1515, x1516) = fiat_p384_scalar_mulx_u32(x1499, 0xf4372ddf);
    let mut x1517: u32 = 0;
    let mut x1518: u32 = 0;
    let (x1517, x1518) = fiat_p384_scalar_mulx_u32(x1499, 0x581a0db2);
    let mut x1519: u32 = 0;
    let mut x1520: u32 = 0;
    let (x1519, x1520) = fiat_p384_scalar_mulx_u32(x1499, 0x48b0a77a);
    let mut x1521: u32 = 0;
    let mut x1522: u32 = 0;
    let (x1521, x1522) = fiat_p384_scalar_mulx_u32(x1499, 0xecec196a);
    let mut x1523: u32 = 0;
    let mut x1524: u32 = 0;
    let (x1523, x1524) = fiat_p384_scalar_mulx_u32(x1499, 0xccc52973);
    let mut x1525: u32 = 0;
    let mut x1526: fiat_p384_scalar_u1 = 0;
    let (x1525, x1526) = fiat_p384_scalar_addcarryx_u32(0x0, x1524, x1521);
    let mut x1527: u32 = 0;
    let mut x1528: fiat_p384_scalar_u1 = 0;
    let (x1527, x1528) = fiat_p384_scalar_addcarryx_u32(x1526, x1522, x1519);
    let mut x1529: u32 = 0;
    let mut x1530: fiat_p384_scalar_u1 = 0;
    let (x1529, x1530) = fiat_p384_scalar_addcarryx_u32(x1528, x1520, x1517);
    let mut x1531: u32 = 0;
    let mut x1532: fiat_p384_scalar_u1 = 0;
    let (x1531, x1532) = fiat_p384_scalar_addcarryx_u32(x1530, x1518, x1515);
    let mut x1533: u32 = 0;
    let mut x1534: fiat_p384_scalar_u1 = 0;
    let (x1533, x1534) = fiat_p384_scalar_addcarryx_u32(x1532, x1516, x1513);
    let mut x1535: u32 = 0;
    let mut x1536: fiat_p384_scalar_u1 = 0;
    let (x1535, x1536) = fiat_p384_scalar_addcarryx_u32(x1534, x1514, x1511);
    let mut x1537: u32 = 0;
    let mut x1538: fiat_p384_scalar_u1 = 0;
    let (x1537, x1538) = fiat_p384_scalar_addcarryx_u32(x1536, x1512, x1509);
    let mut x1539: u32 = 0;
    let mut x1540: fiat_p384_scalar_u1 = 0;
    let (x1539, x1540) = fiat_p384_scalar_addcarryx_u32(x1538, x1510, x1507);
    let mut x1541: u32 = 0;
    let mut x1542: fiat_p384_scalar_u1 = 0;
    let (x1541, x1542) = fiat_p384_scalar_addcarryx_u32(x1540, x1508, x1505);
    let mut x1543: u32 = 0;
    let mut x1544: fiat_p384_scalar_u1 = 0;
    let (x1543, x1544) = fiat_p384_scalar_addcarryx_u32(x1542, x1506, x1503);
    let mut x1545: u32 = 0;
    let mut x1546: fiat_p384_scalar_u1 = 0;
    let (x1545, x1546) = fiat_p384_scalar_addcarryx_u32(x1544, x1504, x1501);
    let mut x1547: u32 = 0;
    let mut x1548: fiat_p384_scalar_u1 = 0;
    let (x1547, x1548) = fiat_p384_scalar_addcarryx_u32(0x0, x1475, x1523);
    let mut x1549: u32 = 0;
    let mut x1550: fiat_p384_scalar_u1 = 0;
    let (x1549, x1550) = fiat_p384_scalar_addcarryx_u32(x1548, x1477, x1525);
    let mut x1551: u32 = 0;
    let mut x1552: fiat_p384_scalar_u1 = 0;
    let (x1551, x1552) = fiat_p384_scalar_addcarryx_u32(x1550, x1479, x1527);
    let mut x1553: u32 = 0;
    let mut x1554: fiat_p384_scalar_u1 = 0;
    let (x1553, x1554) = fiat_p384_scalar_addcarryx_u32(x1552, x1481, x1529);
    let mut x1555: u32 = 0;
    let mut x1556: fiat_p384_scalar_u1 = 0;
    let (x1555, x1556) = fiat_p384_scalar_addcarryx_u32(x1554, x1483, x1531);
    let mut x1557: u32 = 0;
    let mut x1558: fiat_p384_scalar_u1 = 0;
    let (x1557, x1558) = fiat_p384_scalar_addcarryx_u32(x1556, x1485, x1533);
    let mut x1559: u32 = 0;
    let mut x1560: fiat_p384_scalar_u1 = 0;
    let (x1559, x1560) = fiat_p384_scalar_addcarryx_u32(x1558, x1487, x1535);
    let mut x1561: u32 = 0;
    let mut x1562: fiat_p384_scalar_u1 = 0;
    let (x1561, x1562) = fiat_p384_scalar_addcarryx_u32(x1560, x1489, x1537);
    let mut x1563: u32 = 0;
    let mut x1564: fiat_p384_scalar_u1 = 0;
    let (x1563, x1564) = fiat_p384_scalar_addcarryx_u32(x1562, x1491, x1539);
    let mut x1565: u32 = 0;
    let mut x1566: fiat_p384_scalar_u1 = 0;
    let (x1565, x1566) = fiat_p384_scalar_addcarryx_u32(x1564, x1493, x1541);
    let mut x1567: u32 = 0;
    let mut x1568: fiat_p384_scalar_u1 = 0;
    let (x1567, x1568) = fiat_p384_scalar_addcarryx_u32(x1566, x1495, x1543);
    let mut x1569: u32 = 0;
    let mut x1570: fiat_p384_scalar_u1 = 0;
    let (x1569, x1570) = fiat_p384_scalar_addcarryx_u32(x1568, x1497, x1545);
    let mut x1571: u32 = 0;
    let mut x1572: fiat_p384_scalar_u1 = 0;
    let (x1571, x1572) = fiat_p384_scalar_addcarryx_u32(
        x1570,
        (((x1498 as u32) + (x1428 as u32)) + ((x1474 as u32) + x1430)),
        ((x1546 as u32) + x1502),
    );
    let mut x1573: u32 = 0;
    let mut x1574: u32 = 0;
    let (x1573, x1574) = fiat_p384_scalar_mulx_u32(x11, 0xc84ee01);
    let mut x1575: u32 = 0;
    let mut x1576: u32 = 0;
    let (x1575, x1576) = fiat_p384_scalar_mulx_u32(x11, 0x2b39bf21);
    let mut x1577: u32 = 0;
    let mut x1578: u32 = 0;
    let (x1577, x1578) = fiat_p384_scalar_mulx_u32(x11, 0x3fb05b7a);
    let mut x1579: u32 = 0;
    let mut x1580: u32 = 0;
    let (x1579, x1580) = fiat_p384_scalar_mulx_u32(x11, 0x28266895);
    let mut x1581: u32 = 0;
    let mut x1582: u32 = 0;
    let (x1581, x1582) = fiat_p384_scalar_mulx_u32(x11, 0xd40d4917);
    let mut x1583: u32 = 0;
    let mut x1584: u32 = 0;
    let (x1583, x1584) = fiat_p384_scalar_mulx_u32(x11, 0x4aab1cc5);
    let mut x1585: u32 = 0;
    let mut x1586: u32 = 0;
    let (x1585, x1586) = fiat_p384_scalar_mulx_u32(x11, 0xbc3e483a);
    let mut x1587: u32 = 0;
    let mut x1588: u32 = 0;
    let (x1587, x1588) = fiat_p384_scalar_mulx_u32(x11, 0xfcb82947);
    let mut x1589: u32 = 0;
    let mut x1590: u32 = 0;
    let (x1589, x1590) = fiat_p384_scalar_mulx_u32(x11, 0xff3d81e5);
    let mut x1591: u32 = 0;
    let mut x1592: u32 = 0;
    let (x1591, x1592) = fiat_p384_scalar_mulx_u32(x11, 0xdf1aa419);
    let mut x1593: u32 = 0;
    let mut x1594: u32 = 0;
    let (x1593, x1594) = fiat_p384_scalar_mulx_u32(x11, 0x2d319b24);
    let mut x1595: u32 = 0;
    let mut x1596: u32 = 0;
    let (x1595, x1596) = fiat_p384_scalar_mulx_u32(x11, 0x19b409a9);
    let mut x1597: u32 = 0;
    let mut x1598: fiat_p384_scalar_u1 = 0;
    let (x1597, x1598) = fiat_p384_scalar_addcarryx_u32(0x0, x1596, x1593);
    let mut x1599: u32 = 0;
    let mut x1600: fiat_p384_scalar_u1 = 0;
    let (x1599, x1600) = fiat_p384_scalar_addcarryx_u32(x1598, x1594, x1591);
    let mut x1601: u32 = 0;
    let mut x1602: fiat_p384_scalar_u1 = 0;
    let (x1601, x1602) = fiat_p384_scalar_addcarryx_u32(x1600, x1592, x1589);
    let mut x1603: u32 = 0;
    let mut x1604: fiat_p384_scalar_u1 = 0;
    let (x1603, x1604) = fiat_p384_scalar_addcarryx_u32(x1602, x1590, x1587);
    let mut x1605: u32 = 0;
    let mut x1606: fiat_p384_scalar_u1 = 0;
    let (x1605, x1606) = fiat_p384_scalar_addcarryx_u32(x1604, x1588, x1585);
    let mut x1607: u32 = 0;
    let mut x1608: fiat_p384_scalar_u1 = 0;
    let (x1607, x1608) = fiat_p384_scalar_addcarryx_u32(x1606, x1586, x1583);
    let mut x1609: u32 = 0;
    let mut x1610: fiat_p384_scalar_u1 = 0;
    let (x1609, x1610) = fiat_p384_scalar_addcarryx_u32(x1608, x1584, x1581);
    let mut x1611: u32 = 0;
    let mut x1612: fiat_p384_scalar_u1 = 0;
    let (x1611, x1612) = fiat_p384_scalar_addcarryx_u32(x1610, x1582, x1579);
    let mut x1613: u32 = 0;
    let mut x1614: fiat_p384_scalar_u1 = 0;
    let (x1613, x1614) = fiat_p384_scalar_addcarryx_u32(x1612, x1580, x1577);
    let mut x1615: u32 = 0;
    let mut x1616: fiat_p384_scalar_u1 = 0;
    let (x1615, x1616) = fiat_p384_scalar_addcarryx_u32(x1614, x1578, x1575);
    let mut x1617: u32 = 0;
    let mut x1618: fiat_p384_scalar_u1 = 0;
    let (x1617, x1618) = fiat_p384_scalar_addcarryx_u32(x1616, x1576, x1573);
    let mut x1619: u32 = 0;
    let mut x1620: fiat_p384_scalar_u1 = 0;
    let (x1619, x1620) = fiat_p384_scalar_addcarryx_u32(0x0, x1549, x1595);
    let mut x1621: u32 = 0;
    let mut x1622: fiat_p384_scalar_u1 = 0;
    let (x1621, x1622) = fiat_p384_scalar_addcarryx_u32(x1620, x1551, x1597);
    let mut x1623: u32 = 0;
    let mut x1624: fiat_p384_scalar_u1 = 0;
    let (x1623, x1624) = fiat_p384_scalar_addcarryx_u32(x1622, x1553, x1599);
    let mut x1625: u32 = 0;
    let mut x1626: fiat_p384_scalar_u1 = 0;
    let (x1625, x1626) = fiat_p384_scalar_addcarryx_u32(x1624, x1555, x1601);
    let mut x1627: u32 = 0;
    let mut x1628: fiat_p384_scalar_u1 = 0;
    let (x1627, x1628) = fiat_p384_scalar_addcarryx_u32(x1626, x1557, x1603);
    let mut x1629: u32 = 0;
    let mut x1630: fiat_p384_scalar_u1 = 0;
    let (x1629, x1630) = fiat_p384_scalar_addcarryx_u32(x1628, x1559, x1605);
    let mut x1631: u32 = 0;
    let mut x1632: fiat_p384_scalar_u1 = 0;
    let (x1631, x1632) = fiat_p384_scalar_addcarryx_u32(x1630, x1561, x1607);
    let mut x1633: u32 = 0;
    let mut x1634: fiat_p384_scalar_u1 = 0;
    let (x1633, x1634) = fiat_p384_scalar_addcarryx_u32(x1632, x1563, x1609);
    let mut x1635: u32 = 0;
    let mut x1636: fiat_p384_scalar_u1 = 0;
    let (x1635, x1636) = fiat_p384_scalar_addcarryx_u32(x1634, x1565, x1611);
    let mut x1637: u32 = 0;
    let mut x1638: fiat_p384_scalar_u1 = 0;
    let (x1637, x1638) = fiat_p384_scalar_addcarryx_u32(x1636, x1567, x1613);
    let mut x1639: u32 = 0;
    let mut x1640: fiat_p384_scalar_u1 = 0;
    let (x1639, x1640) = fiat_p384_scalar_addcarryx_u32(x1638, x1569, x1615);
    let mut x1641: u32 = 0;
    let mut x1642: fiat_p384_scalar_u1 = 0;
    let (x1641, x1642) = fiat_p384_scalar_addcarryx_u32(x1640, x1571, x1617);
    let mut x1643: u32 = 0;
    let mut x1644: u32 = 0;
    let (x1643, x1644) = fiat_p384_scalar_mulx_u32(x1619, 0xe88fdc45);
    let mut x1645: u32 = 0;
    let mut x1646: u32 = 0;
    let (x1645, x1646) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let mut x1647: u32 = 0;
    let mut x1648: u32 = 0;
    let (x1647, x1648) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let mut x1649: u32 = 0;
    let mut x1650: u32 = 0;
    let (x1649, x1650) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let mut x1651: u32 = 0;
    let mut x1652: u32 = 0;
    let (x1651, x1652) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let mut x1653: u32 = 0;
    let mut x1654: u32 = 0;
    let (x1653, x1654) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let mut x1655: u32 = 0;
    let mut x1656: u32 = 0;
    let (x1655, x1656) = fiat_p384_scalar_mulx_u32(x1643, 0xffffffff);
    let mut x1657: u32 = 0;
    let mut x1658: u32 = 0;
    let (x1657, x1658) = fiat_p384_scalar_mulx_u32(x1643, 0xc7634d81);
    let mut x1659: u32 = 0;
    let mut x1660: u32 = 0;
    let (x1659, x1660) = fiat_p384_scalar_mulx_u32(x1643, 0xf4372ddf);
    let mut x1661: u32 = 0;
    let mut x1662: u32 = 0;
    let (x1661, x1662) = fiat_p384_scalar_mulx_u32(x1643, 0x581a0db2);
    let mut x1663: u32 = 0;
    let mut x1664: u32 = 0;
    let (x1663, x1664) = fiat_p384_scalar_mulx_u32(x1643, 0x48b0a77a);
    let mut x1665: u32 = 0;
    let mut x1666: u32 = 0;
    let (x1665, x1666) = fiat_p384_scalar_mulx_u32(x1643, 0xecec196a);
    let mut x1667: u32 = 0;
    let mut x1668: u32 = 0;
    let (x1667, x1668) = fiat_p384_scalar_mulx_u32(x1643, 0xccc52973);
    let mut x1669: u32 = 0;
    let mut x1670: fiat_p384_scalar_u1 = 0;
    let (x1669, x1670) = fiat_p384_scalar_addcarryx_u32(0x0, x1668, x1665);
    let mut x1671: u32 = 0;
    let mut x1672: fiat_p384_scalar_u1 = 0;
    let (x1671, x1672) = fiat_p384_scalar_addcarryx_u32(x1670, x1666, x1663);
    let mut x1673: u32 = 0;
    let mut x1674: fiat_p384_scalar_u1 = 0;
    let (x1673, x1674) = fiat_p384_scalar_addcarryx_u32(x1672, x1664, x1661);
    let mut x1675: u32 = 0;
    let mut x1676: fiat_p384_scalar_u1 = 0;
    let (x1675, x1676) = fiat_p384_scalar_addcarryx_u32(x1674, x1662, x1659);
    let mut x1677: u32 = 0;
    let mut x1678: fiat_p384_scalar_u1 = 0;
    let (x1677, x1678) = fiat_p384_scalar_addcarryx_u32(x1676, x1660, x1657);
    let mut x1679: u32 = 0;
    let mut x1680: fiat_p384_scalar_u1 = 0;
    let (x1679, x1680) = fiat_p384_scalar_addcarryx_u32(x1678, x1658, x1655);
    let mut x1681: u32 = 0;
    let mut x1682: fiat_p384_scalar_u1 = 0;
    let (x1681, x1682) = fiat_p384_scalar_addcarryx_u32(x1680, x1656, x1653);
    let mut x1683: u32 = 0;
    let mut x1684: fiat_p384_scalar_u1 = 0;
    let (x1683, x1684) = fiat_p384_scalar_addcarryx_u32(x1682, x1654, x1651);
    let mut x1685: u32 = 0;
    let mut x1686: fiat_p384_scalar_u1 = 0;
    let (x1685, x1686) = fiat_p384_scalar_addcarryx_u32(x1684, x1652, x1649);
    let mut x1687: u32 = 0;
    let mut x1688: fiat_p384_scalar_u1 = 0;
    let (x1687, x1688) = fiat_p384_scalar_addcarryx_u32(x1686, x1650, x1647);
    let mut x1689: u32 = 0;
    let mut x1690: fiat_p384_scalar_u1 = 0;
    let (x1689, x1690) = fiat_p384_scalar_addcarryx_u32(x1688, x1648, x1645);
    let mut x1691: u32 = 0;
    let mut x1692: fiat_p384_scalar_u1 = 0;
    let (x1691, x1692) = fiat_p384_scalar_addcarryx_u32(0x0, x1619, x1667);
    let mut x1693: u32 = 0;
    let mut x1694: fiat_p384_scalar_u1 = 0;
    let (x1693, x1694) = fiat_p384_scalar_addcarryx_u32(x1692, x1621, x1669);
    let mut x1695: u32 = 0;
    let mut x1696: fiat_p384_scalar_u1 = 0;
    let (x1695, x1696) = fiat_p384_scalar_addcarryx_u32(x1694, x1623, x1671);
    let mut x1697: u32 = 0;
    let mut x1698: fiat_p384_scalar_u1 = 0;
    let (x1697, x1698) = fiat_p384_scalar_addcarryx_u32(x1696, x1625, x1673);
    let mut x1699: u32 = 0;
    let mut x1700: fiat_p384_scalar_u1 = 0;
    let (x1699, x1700) = fiat_p384_scalar_addcarryx_u32(x1698, x1627, x1675);
    let mut x1701: u32 = 0;
    let mut x1702: fiat_p384_scalar_u1 = 0;
    let (x1701, x1702) = fiat_p384_scalar_addcarryx_u32(x1700, x1629, x1677);
    let mut x1703: u32 = 0;
    let mut x1704: fiat_p384_scalar_u1 = 0;
    let (x1703, x1704) = fiat_p384_scalar_addcarryx_u32(x1702, x1631, x1679);
    let mut x1705: u32 = 0;
    let mut x1706: fiat_p384_scalar_u1 = 0;
    let (x1705, x1706) = fiat_p384_scalar_addcarryx_u32(x1704, x1633, x1681);
    let mut x1707: u32 = 0;
    let mut x1708: fiat_p384_scalar_u1 = 0;
    let (x1707, x1708) = fiat_p384_scalar_addcarryx_u32(x1706, x1635, x1683);
    let mut x1709: u32 = 0;
    let mut x1710: fiat_p384_scalar_u1 = 0;
    let (x1709, x1710) = fiat_p384_scalar_addcarryx_u32(x1708, x1637, x1685);
    let mut x1711: u32 = 0;
    let mut x1712: fiat_p384_scalar_u1 = 0;
    let (x1711, x1712) = fiat_p384_scalar_addcarryx_u32(x1710, x1639, x1687);
    let mut x1713: u32 = 0;
    let mut x1714: fiat_p384_scalar_u1 = 0;
    let (x1713, x1714) = fiat_p384_scalar_addcarryx_u32(x1712, x1641, x1689);
    let mut x1715: u32 = 0;
    let mut x1716: fiat_p384_scalar_u1 = 0;
    let (x1715, x1716) = fiat_p384_scalar_addcarryx_u32(
        x1714,
        (((x1642 as u32) + (x1572 as u32)) + ((x1618 as u32) + x1574)),
        ((x1690 as u32) + x1646),
    );
    let mut x1717: u32 = 0;
    let mut x1718: fiat_p384_scalar_u1 = 0;
    let (x1717, x1718) = fiat_p384_scalar_subborrowx_u32(0x0, x1693, 0xccc52973);
    let mut x1719: u32 = 0;
    let mut x1720: fiat_p384_scalar_u1 = 0;
    let (x1719, x1720) = fiat_p384_scalar_subborrowx_u32(x1718, x1695, 0xecec196a);
    let mut x1721: u32 = 0;
    let mut x1722: fiat_p384_scalar_u1 = 0;
    let (x1721, x1722) = fiat_p384_scalar_subborrowx_u32(x1720, x1697, 0x48b0a77a);
    let mut x1723: u32 = 0;
    let mut x1724: fiat_p384_scalar_u1 = 0;
    let (x1723, x1724) = fiat_p384_scalar_subborrowx_u32(x1722, x1699, 0x581a0db2);
    let mut x1725: u32 = 0;
    let mut x1726: fiat_p384_scalar_u1 = 0;
    let (x1725, x1726) = fiat_p384_scalar_subborrowx_u32(x1724, x1701, 0xf4372ddf);
    let mut x1727: u32 = 0;
    let mut x1728: fiat_p384_scalar_u1 = 0;
    let (x1727, x1728) = fiat_p384_scalar_subborrowx_u32(x1726, x1703, 0xc7634d81);
    let mut x1729: u32 = 0;
    let mut x1730: fiat_p384_scalar_u1 = 0;
    let (x1729, x1730) = fiat_p384_scalar_subborrowx_u32(x1728, x1705, 0xffffffff);
    let mut x1731: u32 = 0;
    let mut x1732: fiat_p384_scalar_u1 = 0;
    let (x1731, x1732) = fiat_p384_scalar_subborrowx_u32(x1730, x1707, 0xffffffff);
    let mut x1733: u32 = 0;
    let mut x1734: fiat_p384_scalar_u1 = 0;
    let (x1733, x1734) = fiat_p384_scalar_subborrowx_u32(x1732, x1709, 0xffffffff);
    let mut x1735: u32 = 0;
    let mut x1736: fiat_p384_scalar_u1 = 0;
    let (x1735, x1736) = fiat_p384_scalar_subborrowx_u32(x1734, x1711, 0xffffffff);
    let mut x1737: u32 = 0;
    let mut x1738: fiat_p384_scalar_u1 = 0;
    let (x1737, x1738) = fiat_p384_scalar_subborrowx_u32(x1736, x1713, 0xffffffff);
    let mut x1739: u32 = 0;
    let mut x1740: fiat_p384_scalar_u1 = 0;
    let (x1739, x1740) = fiat_p384_scalar_subborrowx_u32(x1738, x1715, 0xffffffff);
    let mut x1741: u32 = 0;
    let mut x1742: fiat_p384_scalar_u1 = 0;
    let (x1741, x1742) = fiat_p384_scalar_subborrowx_u32(x1740, (x1716 as u32), (0x0 as u32));
    let mut x1743: u32 = 0;
    let (x1743) = fiat_p384_scalar_cmovznz_u32(x1742, x1717, x1693);
    let mut x1744: u32 = 0;
    let (x1744) = fiat_p384_scalar_cmovznz_u32(x1742, x1719, x1695);
    let mut x1745: u32 = 0;
    let (x1745) = fiat_p384_scalar_cmovznz_u32(x1742, x1721, x1697);
    let mut x1746: u32 = 0;
    let (x1746) = fiat_p384_scalar_cmovznz_u32(x1742, x1723, x1699);
    let mut x1747: u32 = 0;
    let (x1747) = fiat_p384_scalar_cmovznz_u32(x1742, x1725, x1701);
    let mut x1748: u32 = 0;
    let (x1748) = fiat_p384_scalar_cmovznz_u32(x1742, x1727, x1703);
    let mut x1749: u32 = 0;
    let (x1749) = fiat_p384_scalar_cmovznz_u32(x1742, x1729, x1705);
    let mut x1750: u32 = 0;
    let (x1750) = fiat_p384_scalar_cmovznz_u32(x1742, x1731, x1707);
    let mut x1751: u32 = 0;
    let (x1751) = fiat_p384_scalar_cmovznz_u32(x1742, x1733, x1709);
    let mut x1752: u32 = 0;
    let (x1752) = fiat_p384_scalar_cmovznz_u32(x1742, x1735, x1711);
    let mut x1753: u32 = 0;
    let (x1753) = fiat_p384_scalar_cmovznz_u32(x1742, x1737, x1713);
    let mut x1754: u32 = 0;
    let (x1754) = fiat_p384_scalar_cmovznz_u32(x1742, x1739, x1715);
    out1[0] = x1743;
    out1[1] = x1744;
    out1[2] = x1745;
    out1[3] = x1746;
    out1[4] = x1747;
    out1[5] = x1748;
    out1[6] = x1749;
    out1[7] = x1750;
    out1[8] = x1751;
    out1[9] = x1752;
    out1[10] = x1753;
    out1[11] = x1754;
    out1
}
#[doc = " The function fiat_p384_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p384_scalar_nonzero(arg1: &[u32; 12]) -> u32 {
    let mut out1: u32 = 0;
    let x1: u32 = ((arg1[0])
        | ((arg1[1])
            | ((arg1[2])
                | ((arg1[3])
                    | ((arg1[4])
                        | ((arg1[5])
                            | ((arg1[6])
                                | ((arg1[7])
                                    | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | (arg1[11]))))))))))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p384_scalar_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_selectznz(
    arg1: fiat_p384_scalar_u1,
    arg2: &[u32; 12],
    arg3: &[u32; 12],
) -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    let mut x1: u32 = 0;
    let (x1) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[0]), (arg3[0]));
    let mut x2: u32 = 0;
    let (x2) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[1]), (arg3[1]));
    let mut x3: u32 = 0;
    let (x3) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[2]), (arg3[2]));
    let mut x4: u32 = 0;
    let (x4) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[3]), (arg3[3]));
    let mut x5: u32 = 0;
    let (x5) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[4]), (arg3[4]));
    let mut x6: u32 = 0;
    let (x6) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[5]), (arg3[5]));
    let mut x7: u32 = 0;
    let (x7) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[6]), (arg3[6]));
    let mut x8: u32 = 0;
    let (x8) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[7]), (arg3[7]));
    let mut x9: u32 = 0;
    let (x9) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[8]), (arg3[8]));
    let mut x10: u32 = 0;
    let (x10) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[9]), (arg3[9]));
    let mut x11: u32 = 0;
    let (x11) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[10]), (arg3[10]));
    let mut x12: u32 = 0;
    let (x12) = fiat_p384_scalar_cmovznz_u32(arg1, (arg2[11]), (arg3[11]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
    out1
}
#[doc = " The function fiat_p384_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[inline]
pub const fn fiat_p384_scalar_to_bytes(arg1: &[u32; 12]) -> [u8; 48] {
    let mut out1: [u8; 48] = [0; 48];
    let x1: u32 = (arg1[11]);
    let x2: u32 = (arg1[10]);
    let x3: u32 = (arg1[9]);
    let x4: u32 = (arg1[8]);
    let x5: u32 = (arg1[7]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[5]);
    let x8: u32 = (arg1[4]);
    let x9: u32 = (arg1[3]);
    let x10: u32 = (arg1[2]);
    let x11: u32 = (arg1[1]);
    let x12: u32 = (arg1[0]);
    let x13: u8 = ((x12 & (0xff as u32)) as u8);
    let x14: u32 = (x12 >> 8);
    let x15: u8 = ((x14 & (0xff as u32)) as u8);
    let x16: u32 = (x14 >> 8);
    let x17: u8 = ((x16 & (0xff as u32)) as u8);
    let x18: u8 = ((x16 >> 8) as u8);
    let x19: u8 = ((x11 & (0xff as u32)) as u8);
    let x20: u32 = (x11 >> 8);
    let x21: u8 = ((x20 & (0xff as u32)) as u8);
    let x22: u32 = (x20 >> 8);
    let x23: u8 = ((x22 & (0xff as u32)) as u8);
    let x24: u8 = ((x22 >> 8) as u8);
    let x25: u8 = ((x10 & (0xff as u32)) as u8);
    let x26: u32 = (x10 >> 8);
    let x27: u8 = ((x26 & (0xff as u32)) as u8);
    let x28: u32 = (x26 >> 8);
    let x29: u8 = ((x28 & (0xff as u32)) as u8);
    let x30: u8 = ((x28 >> 8) as u8);
    let x31: u8 = ((x9 & (0xff as u32)) as u8);
    let x32: u32 = (x9 >> 8);
    let x33: u8 = ((x32 & (0xff as u32)) as u8);
    let x34: u32 = (x32 >> 8);
    let x35: u8 = ((x34 & (0xff as u32)) as u8);
    let x36: u8 = ((x34 >> 8) as u8);
    let x37: u8 = ((x8 & (0xff as u32)) as u8);
    let x38: u32 = (x8 >> 8);
    let x39: u8 = ((x38 & (0xff as u32)) as u8);
    let x40: u32 = (x38 >> 8);
    let x41: u8 = ((x40 & (0xff as u32)) as u8);
    let x42: u8 = ((x40 >> 8) as u8);
    let x43: u8 = ((x7 & (0xff as u32)) as u8);
    let x44: u32 = (x7 >> 8);
    let x45: u8 = ((x44 & (0xff as u32)) as u8);
    let x46: u32 = (x44 >> 8);
    let x47: u8 = ((x46 & (0xff as u32)) as u8);
    let x48: u8 = ((x46 >> 8) as u8);
    let x49: u8 = ((x6 & (0xff as u32)) as u8);
    let x50: u32 = (x6 >> 8);
    let x51: u8 = ((x50 & (0xff as u32)) as u8);
    let x52: u32 = (x50 >> 8);
    let x53: u8 = ((x52 & (0xff as u32)) as u8);
    let x54: u8 = ((x52 >> 8) as u8);
    let x55: u8 = ((x5 & (0xff as u32)) as u8);
    let x56: u32 = (x5 >> 8);
    let x57: u8 = ((x56 & (0xff as u32)) as u8);
    let x58: u32 = (x56 >> 8);
    let x59: u8 = ((x58 & (0xff as u32)) as u8);
    let x60: u8 = ((x58 >> 8) as u8);
    let x61: u8 = ((x4 & (0xff as u32)) as u8);
    let x62: u32 = (x4 >> 8);
    let x63: u8 = ((x62 & (0xff as u32)) as u8);
    let x64: u32 = (x62 >> 8);
    let x65: u8 = ((x64 & (0xff as u32)) as u8);
    let x66: u8 = ((x64 >> 8) as u8);
    let x67: u8 = ((x3 & (0xff as u32)) as u8);
    let x68: u32 = (x3 >> 8);
    let x69: u8 = ((x68 & (0xff as u32)) as u8);
    let x70: u32 = (x68 >> 8);
    let x71: u8 = ((x70 & (0xff as u32)) as u8);
    let x72: u8 = ((x70 >> 8) as u8);
    let x73: u8 = ((x2 & (0xff as u32)) as u8);
    let x74: u32 = (x2 >> 8);
    let x75: u8 = ((x74 & (0xff as u32)) as u8);
    let x76: u32 = (x74 >> 8);
    let x77: u8 = ((x76 & (0xff as u32)) as u8);
    let x78: u8 = ((x76 >> 8) as u8);
    let x79: u8 = ((x1 & (0xff as u32)) as u8);
    let x80: u32 = (x1 >> 8);
    let x81: u8 = ((x80 & (0xff as u32)) as u8);
    let x82: u32 = (x80 >> 8);
    let x83: u8 = ((x82 & (0xff as u32)) as u8);
    let x84: u8 = ((x82 >> 8) as u8);
    out1[0] = x13;
    out1[1] = x15;
    out1[2] = x17;
    out1[3] = x18;
    out1[4] = x19;
    out1[5] = x21;
    out1[6] = x23;
    out1[7] = x24;
    out1[8] = x25;
    out1[9] = x27;
    out1[10] = x29;
    out1[11] = x30;
    out1[12] = x31;
    out1[13] = x33;
    out1[14] = x35;
    out1[15] = x36;
    out1[16] = x37;
    out1[17] = x39;
    out1[18] = x41;
    out1[19] = x42;
    out1[20] = x43;
    out1[21] = x45;
    out1[22] = x47;
    out1[23] = x48;
    out1[24] = x49;
    out1[25] = x51;
    out1[26] = x53;
    out1[27] = x54;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
    out1[32] = x61;
    out1[33] = x63;
    out1[34] = x65;
    out1[35] = x66;
    out1[36] = x67;
    out1[37] = x69;
    out1[38] = x71;
    out1[39] = x72;
    out1[40] = x73;
    out1[41] = x75;
    out1[42] = x77;
    out1[43] = x78;
    out1[44] = x79;
    out1[45] = x81;
    out1[46] = x83;
    out1[47] = x84;
    out1
}
#[doc = " The function fiat_p384_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_from_bytes(arg1: &[u8; 48]) -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    let x1: u32 = (((arg1[47]) as u32) << 24);
    let x2: u32 = (((arg1[46]) as u32) << 16);
    let x3: u32 = (((arg1[45]) as u32) << 8);
    let x4: u8 = (arg1[44]);
    let x5: u32 = (((arg1[43]) as u32) << 24);
    let x6: u32 = (((arg1[42]) as u32) << 16);
    let x7: u32 = (((arg1[41]) as u32) << 8);
    let x8: u8 = (arg1[40]);
    let x9: u32 = (((arg1[39]) as u32) << 24);
    let x10: u32 = (((arg1[38]) as u32) << 16);
    let x11: u32 = (((arg1[37]) as u32) << 8);
    let x12: u8 = (arg1[36]);
    let x13: u32 = (((arg1[35]) as u32) << 24);
    let x14: u32 = (((arg1[34]) as u32) << 16);
    let x15: u32 = (((arg1[33]) as u32) << 8);
    let x16: u8 = (arg1[32]);
    let x17: u32 = (((arg1[31]) as u32) << 24);
    let x18: u32 = (((arg1[30]) as u32) << 16);
    let x19: u32 = (((arg1[29]) as u32) << 8);
    let x20: u8 = (arg1[28]);
    let x21: u32 = (((arg1[27]) as u32) << 24);
    let x22: u32 = (((arg1[26]) as u32) << 16);
    let x23: u32 = (((arg1[25]) as u32) << 8);
    let x24: u8 = (arg1[24]);
    let x25: u32 = (((arg1[23]) as u32) << 24);
    let x26: u32 = (((arg1[22]) as u32) << 16);
    let x27: u32 = (((arg1[21]) as u32) << 8);
    let x28: u8 = (arg1[20]);
    let x29: u32 = (((arg1[19]) as u32) << 24);
    let x30: u32 = (((arg1[18]) as u32) << 16);
    let x31: u32 = (((arg1[17]) as u32) << 8);
    let x32: u8 = (arg1[16]);
    let x33: u32 = (((arg1[15]) as u32) << 24);
    let x34: u32 = (((arg1[14]) as u32) << 16);
    let x35: u32 = (((arg1[13]) as u32) << 8);
    let x36: u8 = (arg1[12]);
    let x37: u32 = (((arg1[11]) as u32) << 24);
    let x38: u32 = (((arg1[10]) as u32) << 16);
    let x39: u32 = (((arg1[9]) as u32) << 8);
    let x40: u8 = (arg1[8]);
    let x41: u32 = (((arg1[7]) as u32) << 24);
    let x42: u32 = (((arg1[6]) as u32) << 16);
    let x43: u32 = (((arg1[5]) as u32) << 8);
    let x44: u8 = (arg1[4]);
    let x45: u32 = (((arg1[3]) as u32) << 24);
    let x46: u32 = (((arg1[2]) as u32) << 16);
    let x47: u32 = (((arg1[1]) as u32) << 8);
    let x48: u8 = (arg1[0]);
    let x49: u32 = (x47 + (x48 as u32));
    let x50: u32 = (x46 + x49);
    let x51: u32 = (x45 + x50);
    let x52: u32 = (x43 + (x44 as u32));
    let x53: u32 = (x42 + x52);
    let x54: u32 = (x41 + x53);
    let x55: u32 = (x39 + (x40 as u32));
    let x56: u32 = (x38 + x55);
    let x57: u32 = (x37 + x56);
    let x58: u32 = (x35 + (x36 as u32));
    let x59: u32 = (x34 + x58);
    let x60: u32 = (x33 + x59);
    let x61: u32 = (x31 + (x32 as u32));
    let x62: u32 = (x30 + x61);
    let x63: u32 = (x29 + x62);
    let x64: u32 = (x27 + (x28 as u32));
    let x65: u32 = (x26 + x64);
    let x66: u32 = (x25 + x65);
    let x67: u32 = (x23 + (x24 as u32));
    let x68: u32 = (x22 + x67);
    let x69: u32 = (x21 + x68);
    let x70: u32 = (x19 + (x20 as u32));
    let x71: u32 = (x18 + x70);
    let x72: u32 = (x17 + x71);
    let x73: u32 = (x15 + (x16 as u32));
    let x74: u32 = (x14 + x73);
    let x75: u32 = (x13 + x74);
    let x76: u32 = (x11 + (x12 as u32));
    let x77: u32 = (x10 + x76);
    let x78: u32 = (x9 + x77);
    let x79: u32 = (x7 + (x8 as u32));
    let x80: u32 = (x6 + x79);
    let x81: u32 = (x5 + x80);
    let x82: u32 = (x3 + (x4 as u32));
    let x83: u32 = (x2 + x82);
    let x84: u32 = (x1 + x83);
    out1[0] = x51;
    out1[1] = x54;
    out1[2] = x57;
    out1[3] = x60;
    out1[4] = x63;
    out1[5] = x66;
    out1[6] = x69;
    out1[7] = x72;
    out1[8] = x75;
    out1[9] = x78;
    out1[10] = x81;
    out1[11] = x84;
    out1
}
#[doc = " The function fiat_p384_scalar_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_scalar_set_one() -> fiat_p384_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p384_scalar_montgomery_domain_field_element = [0; 12];
    out1[0] = 0x333ad68d;
    out1[1] = 0x1313e695;
    out1[2] = 0xb74f5885;
    out1[3] = 0xa7e5f24d;
    out1[4] = 0xbc8d220;
    out1[5] = 0x389cb27e;
    out1[6] = (0x0 as u32);
    out1[7] = (0x0 as u32);
    out1[8] = (0x0 as u32);
    out1[9] = (0x0 as u32);
    out1[10] = (0x0 as u32);
    out1[11] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p384_scalar_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_msat() -> [u32; 13] {
    let mut out1: [u32; 13] = [0; 13];
    out1[0] = 0xccc52973;
    out1[1] = 0xecec196a;
    out1[2] = 0x48b0a77a;
    out1[3] = 0x581a0db2;
    out1[4] = 0xf4372ddf;
    out1[5] = 0xc7634d81;
    out1[6] = 0xffffffff;
    out1[7] = 0xffffffff;
    out1[8] = 0xffffffff;
    out1[9] = 0xffffffff;
    out1[10] = 0xffffffff;
    out1[11] = 0xffffffff;
    out1[12] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p384_scalar_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_divstep(
    arg1: u32,
    arg2: &[u32; 13],
    arg3: &[u32; 13],
    arg4: &[u32; 12],
    arg5: &[u32; 12],
) -> (u32, [u32; 13], [u32; 13], [u32; 12], [u32; 12]) {
    let mut out1: u32 = 0;
    let mut out2: [u32; 13] = [0; 13];
    let mut out3: [u32; 13] = [0; 13];
    let mut out4: [u32; 12] = [0; 12];
    let mut out5: [u32; 12] = [0; 12];
    let mut x1: u32 = 0;
    let mut x2: fiat_p384_scalar_u1 = 0;
    let (x1, x2) = fiat_p384_scalar_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let x3: fiat_p384_scalar_u1 =
        (((x1 >> 31) as fiat_p384_scalar_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p384_scalar_u1));
    let mut x4: u32 = 0;
    let mut x5: fiat_p384_scalar_u1 = 0;
    let (x4, x5) = fiat_p384_scalar_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let mut x6: u32 = 0;
    let (x6) = fiat_p384_scalar_cmovznz_u32(x3, arg1, x4);
    let mut x7: u32 = 0;
    let (x7) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[0]), (arg3[0]));
    let mut x8: u32 = 0;
    let (x8) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[1]), (arg3[1]));
    let mut x9: u32 = 0;
    let (x9) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[2]), (arg3[2]));
    let mut x10: u32 = 0;
    let (x10) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[3]), (arg3[3]));
    let mut x11: u32 = 0;
    let (x11) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[4]), (arg3[4]));
    let mut x12: u32 = 0;
    let (x12) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[5]), (arg3[5]));
    let mut x13: u32 = 0;
    let (x13) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[6]), (arg3[6]));
    let mut x14: u32 = 0;
    let (x14) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[7]), (arg3[7]));
    let mut x15: u32 = 0;
    let (x15) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[8]), (arg3[8]));
    let mut x16: u32 = 0;
    let (x16) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[9]), (arg3[9]));
    let mut x17: u32 = 0;
    let (x17) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[10]), (arg3[10]));
    let mut x18: u32 = 0;
    let (x18) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[11]), (arg3[11]));
    let mut x19: u32 = 0;
    let (x19) = fiat_p384_scalar_cmovznz_u32(x3, (arg2[12]), (arg3[12]));
    let mut x20: u32 = 0;
    let mut x21: fiat_p384_scalar_u1 = 0;
    let (x20, x21) = fiat_p384_scalar_addcarryx_u32(0x0, (0x1 as u32), (!(arg2[0])));
    let mut x22: u32 = 0;
    let mut x23: fiat_p384_scalar_u1 = 0;
    let (x22, x23) = fiat_p384_scalar_addcarryx_u32(x21, (0x0 as u32), (!(arg2[1])));
    let mut x24: u32 = 0;
    let mut x25: fiat_p384_scalar_u1 = 0;
    let (x24, x25) = fiat_p384_scalar_addcarryx_u32(x23, (0x0 as u32), (!(arg2[2])));
    let mut x26: u32 = 0;
    let mut x27: fiat_p384_scalar_u1 = 0;
    let (x26, x27) = fiat_p384_scalar_addcarryx_u32(x25, (0x0 as u32), (!(arg2[3])));
    let mut x28: u32 = 0;
    let mut x29: fiat_p384_scalar_u1 = 0;
    let (x28, x29) = fiat_p384_scalar_addcarryx_u32(x27, (0x0 as u32), (!(arg2[4])));
    let mut x30: u32 = 0;
    let mut x31: fiat_p384_scalar_u1 = 0;
    let (x30, x31) = fiat_p384_scalar_addcarryx_u32(x29, (0x0 as u32), (!(arg2[5])));
    let mut x32: u32 = 0;
    let mut x33: fiat_p384_scalar_u1 = 0;
    let (x32, x33) = fiat_p384_scalar_addcarryx_u32(x31, (0x0 as u32), (!(arg2[6])));
    let mut x34: u32 = 0;
    let mut x35: fiat_p384_scalar_u1 = 0;
    let (x34, x35) = fiat_p384_scalar_addcarryx_u32(x33, (0x0 as u32), (!(arg2[7])));
    let mut x36: u32 = 0;
    let mut x37: fiat_p384_scalar_u1 = 0;
    let (x36, x37) = fiat_p384_scalar_addcarryx_u32(x35, (0x0 as u32), (!(arg2[8])));
    let mut x38: u32 = 0;
    let mut x39: fiat_p384_scalar_u1 = 0;
    let (x38, x39) = fiat_p384_scalar_addcarryx_u32(x37, (0x0 as u32), (!(arg2[9])));
    let mut x40: u32 = 0;
    let mut x41: fiat_p384_scalar_u1 = 0;
    let (x40, x41) = fiat_p384_scalar_addcarryx_u32(x39, (0x0 as u32), (!(arg2[10])));
    let mut x42: u32 = 0;
    let mut x43: fiat_p384_scalar_u1 = 0;
    let (x42, x43) = fiat_p384_scalar_addcarryx_u32(x41, (0x0 as u32), (!(arg2[11])));
    let mut x44: u32 = 0;
    let mut x45: fiat_p384_scalar_u1 = 0;
    let (x44, x45) = fiat_p384_scalar_addcarryx_u32(x43, (0x0 as u32), (!(arg2[12])));
    let mut x46: u32 = 0;
    let (x46) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[0]), x20);
    let mut x47: u32 = 0;
    let (x47) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[1]), x22);
    let mut x48: u32 = 0;
    let (x48) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[2]), x24);
    let mut x49: u32 = 0;
    let (x49) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[3]), x26);
    let mut x50: u32 = 0;
    let (x50) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[4]), x28);
    let mut x51: u32 = 0;
    let (x51) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[5]), x30);
    let mut x52: u32 = 0;
    let (x52) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[6]), x32);
    let mut x53: u32 = 0;
    let (x53) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[7]), x34);
    let mut x54: u32 = 0;
    let (x54) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[8]), x36);
    let mut x55: u32 = 0;
    let (x55) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[9]), x38);
    let mut x56: u32 = 0;
    let (x56) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[10]), x40);
    let mut x57: u32 = 0;
    let (x57) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[11]), x42);
    let mut x58: u32 = 0;
    let (x58) = fiat_p384_scalar_cmovznz_u32(x3, (arg3[12]), x44);
    let mut x59: u32 = 0;
    let (x59) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[0]), (arg5[0]));
    let mut x60: u32 = 0;
    let (x60) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[1]), (arg5[1]));
    let mut x61: u32 = 0;
    let (x61) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[2]), (arg5[2]));
    let mut x62: u32 = 0;
    let (x62) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[3]), (arg5[3]));
    let mut x63: u32 = 0;
    let (x63) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[4]), (arg5[4]));
    let mut x64: u32 = 0;
    let (x64) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[5]), (arg5[5]));
    let mut x65: u32 = 0;
    let (x65) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[6]), (arg5[6]));
    let mut x66: u32 = 0;
    let (x66) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[7]), (arg5[7]));
    let mut x67: u32 = 0;
    let (x67) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[8]), (arg5[8]));
    let mut x68: u32 = 0;
    let (x68) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[9]), (arg5[9]));
    let mut x69: u32 = 0;
    let (x69) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[10]), (arg5[10]));
    let mut x70: u32 = 0;
    let (x70) = fiat_p384_scalar_cmovznz_u32(x3, (arg4[11]), (arg5[11]));
    let mut x71: u32 = 0;
    let mut x72: fiat_p384_scalar_u1 = 0;
    let (x71, x72) = fiat_p384_scalar_addcarryx_u32(0x0, x59, x59);
    let mut x73: u32 = 0;
    let mut x74: fiat_p384_scalar_u1 = 0;
    let (x73, x74) = fiat_p384_scalar_addcarryx_u32(x72, x60, x60);
    let mut x75: u32 = 0;
    let mut x76: fiat_p384_scalar_u1 = 0;
    let (x75, x76) = fiat_p384_scalar_addcarryx_u32(x74, x61, x61);
    let mut x77: u32 = 0;
    let mut x78: fiat_p384_scalar_u1 = 0;
    let (x77, x78) = fiat_p384_scalar_addcarryx_u32(x76, x62, x62);
    let mut x79: u32 = 0;
    let mut x80: fiat_p384_scalar_u1 = 0;
    let (x79, x80) = fiat_p384_scalar_addcarryx_u32(x78, x63, x63);
    let mut x81: u32 = 0;
    let mut x82: fiat_p384_scalar_u1 = 0;
    let (x81, x82) = fiat_p384_scalar_addcarryx_u32(x80, x64, x64);
    let mut x83: u32 = 0;
    let mut x84: fiat_p384_scalar_u1 = 0;
    let (x83, x84) = fiat_p384_scalar_addcarryx_u32(x82, x65, x65);
    let mut x85: u32 = 0;
    let mut x86: fiat_p384_scalar_u1 = 0;
    let (x85, x86) = fiat_p384_scalar_addcarryx_u32(x84, x66, x66);
    let mut x87: u32 = 0;
    let mut x88: fiat_p384_scalar_u1 = 0;
    let (x87, x88) = fiat_p384_scalar_addcarryx_u32(x86, x67, x67);
    let mut x89: u32 = 0;
    let mut x90: fiat_p384_scalar_u1 = 0;
    let (x89, x90) = fiat_p384_scalar_addcarryx_u32(x88, x68, x68);
    let mut x91: u32 = 0;
    let mut x92: fiat_p384_scalar_u1 = 0;
    let (x91, x92) = fiat_p384_scalar_addcarryx_u32(x90, x69, x69);
    let mut x93: u32 = 0;
    let mut x94: fiat_p384_scalar_u1 = 0;
    let (x93, x94) = fiat_p384_scalar_addcarryx_u32(x92, x70, x70);
    let mut x95: u32 = 0;
    let mut x96: fiat_p384_scalar_u1 = 0;
    let (x95, x96) = fiat_p384_scalar_subborrowx_u32(0x0, x71, 0xccc52973);
    let mut x97: u32 = 0;
    let mut x98: fiat_p384_scalar_u1 = 0;
    let (x97, x98) = fiat_p384_scalar_subborrowx_u32(x96, x73, 0xecec196a);
    let mut x99: u32 = 0;
    let mut x100: fiat_p384_scalar_u1 = 0;
    let (x99, x100) = fiat_p384_scalar_subborrowx_u32(x98, x75, 0x48b0a77a);
    let mut x101: u32 = 0;
    let mut x102: fiat_p384_scalar_u1 = 0;
    let (x101, x102) = fiat_p384_scalar_subborrowx_u32(x100, x77, 0x581a0db2);
    let mut x103: u32 = 0;
    let mut x104: fiat_p384_scalar_u1 = 0;
    let (x103, x104) = fiat_p384_scalar_subborrowx_u32(x102, x79, 0xf4372ddf);
    let mut x105: u32 = 0;
    let mut x106: fiat_p384_scalar_u1 = 0;
    let (x105, x106) = fiat_p384_scalar_subborrowx_u32(x104, x81, 0xc7634d81);
    let mut x107: u32 = 0;
    let mut x108: fiat_p384_scalar_u1 = 0;
    let (x107, x108) = fiat_p384_scalar_subborrowx_u32(x106, x83, 0xffffffff);
    let mut x109: u32 = 0;
    let mut x110: fiat_p384_scalar_u1 = 0;
    let (x109, x110) = fiat_p384_scalar_subborrowx_u32(x108, x85, 0xffffffff);
    let mut x111: u32 = 0;
    let mut x112: fiat_p384_scalar_u1 = 0;
    let (x111, x112) = fiat_p384_scalar_subborrowx_u32(x110, x87, 0xffffffff);
    let mut x113: u32 = 0;
    let mut x114: fiat_p384_scalar_u1 = 0;
    let (x113, x114) = fiat_p384_scalar_subborrowx_u32(x112, x89, 0xffffffff);
    let mut x115: u32 = 0;
    let mut x116: fiat_p384_scalar_u1 = 0;
    let (x115, x116) = fiat_p384_scalar_subborrowx_u32(x114, x91, 0xffffffff);
    let mut x117: u32 = 0;
    let mut x118: fiat_p384_scalar_u1 = 0;
    let (x117, x118) = fiat_p384_scalar_subborrowx_u32(x116, x93, 0xffffffff);
    let mut x119: u32 = 0;
    let mut x120: fiat_p384_scalar_u1 = 0;
    let (x119, x120) = fiat_p384_scalar_subborrowx_u32(x118, (x94 as u32), (0x0 as u32));
    let x121: u32 = (arg4[11]);
    let x122: u32 = (arg4[10]);
    let x123: u32 = (arg4[9]);
    let x124: u32 = (arg4[8]);
    let x125: u32 = (arg4[7]);
    let x126: u32 = (arg4[6]);
    let x127: u32 = (arg4[5]);
    let x128: u32 = (arg4[4]);
    let x129: u32 = (arg4[3]);
    let x130: u32 = (arg4[2]);
    let x131: u32 = (arg4[1]);
    let x132: u32 = (arg4[0]);
    let mut x133: u32 = 0;
    let mut x134: fiat_p384_scalar_u1 = 0;
    let (x133, x134) = fiat_p384_scalar_subborrowx_u32(0x0, (0x0 as u32), x132);
    let mut x135: u32 = 0;
    let mut x136: fiat_p384_scalar_u1 = 0;
    let (x135, x136) = fiat_p384_scalar_subborrowx_u32(x134, (0x0 as u32), x131);
    let mut x137: u32 = 0;
    let mut x138: fiat_p384_scalar_u1 = 0;
    let (x137, x138) = fiat_p384_scalar_subborrowx_u32(x136, (0x0 as u32), x130);
    let mut x139: u32 = 0;
    let mut x140: fiat_p384_scalar_u1 = 0;
    let (x139, x140) = fiat_p384_scalar_subborrowx_u32(x138, (0x0 as u32), x129);
    let mut x141: u32 = 0;
    let mut x142: fiat_p384_scalar_u1 = 0;
    let (x141, x142) = fiat_p384_scalar_subborrowx_u32(x140, (0x0 as u32), x128);
    let mut x143: u32 = 0;
    let mut x144: fiat_p384_scalar_u1 = 0;
    let (x143, x144) = fiat_p384_scalar_subborrowx_u32(x142, (0x0 as u32), x127);
    let mut x145: u32 = 0;
    let mut x146: fiat_p384_scalar_u1 = 0;
    let (x145, x146) = fiat_p384_scalar_subborrowx_u32(x144, (0x0 as u32), x126);
    let mut x147: u32 = 0;
    let mut x148: fiat_p384_scalar_u1 = 0;
    let (x147, x148) = fiat_p384_scalar_subborrowx_u32(x146, (0x0 as u32), x125);
    let mut x149: u32 = 0;
    let mut x150: fiat_p384_scalar_u1 = 0;
    let (x149, x150) = fiat_p384_scalar_subborrowx_u32(x148, (0x0 as u32), x124);
    let mut x151: u32 = 0;
    let mut x152: fiat_p384_scalar_u1 = 0;
    let (x151, x152) = fiat_p384_scalar_subborrowx_u32(x150, (0x0 as u32), x123);
    let mut x153: u32 = 0;
    let mut x154: fiat_p384_scalar_u1 = 0;
    let (x153, x154) = fiat_p384_scalar_subborrowx_u32(x152, (0x0 as u32), x122);
    let mut x155: u32 = 0;
    let mut x156: fiat_p384_scalar_u1 = 0;
    let (x155, x156) = fiat_p384_scalar_subborrowx_u32(x154, (0x0 as u32), x121);
    let mut x157: u32 = 0;
    let (x157) = fiat_p384_scalar_cmovznz_u32(x156, (0x0 as u32), 0xffffffff);
    let mut x158: u32 = 0;
    let mut x159: fiat_p384_scalar_u1 = 0;
    let (x158, x159) = fiat_p384_scalar_addcarryx_u32(0x0, x133, (x157 & 0xccc52973));
    let mut x160: u32 = 0;
    let mut x161: fiat_p384_scalar_u1 = 0;
    let (x160, x161) = fiat_p384_scalar_addcarryx_u32(x159, x135, (x157 & 0xecec196a));
    let mut x162: u32 = 0;
    let mut x163: fiat_p384_scalar_u1 = 0;
    let (x162, x163) = fiat_p384_scalar_addcarryx_u32(x161, x137, (x157 & 0x48b0a77a));
    let mut x164: u32 = 0;
    let mut x165: fiat_p384_scalar_u1 = 0;
    let (x164, x165) = fiat_p384_scalar_addcarryx_u32(x163, x139, (x157 & 0x581a0db2));
    let mut x166: u32 = 0;
    let mut x167: fiat_p384_scalar_u1 = 0;
    let (x166, x167) = fiat_p384_scalar_addcarryx_u32(x165, x141, (x157 & 0xf4372ddf));
    let mut x168: u32 = 0;
    let mut x169: fiat_p384_scalar_u1 = 0;
    let (x168, x169) = fiat_p384_scalar_addcarryx_u32(x167, x143, (x157 & 0xc7634d81));
    let mut x170: u32 = 0;
    let mut x171: fiat_p384_scalar_u1 = 0;
    let (x170, x171) = fiat_p384_scalar_addcarryx_u32(x169, x145, x157);
    let mut x172: u32 = 0;
    let mut x173: fiat_p384_scalar_u1 = 0;
    let (x172, x173) = fiat_p384_scalar_addcarryx_u32(x171, x147, x157);
    let mut x174: u32 = 0;
    let mut x175: fiat_p384_scalar_u1 = 0;
    let (x174, x175) = fiat_p384_scalar_addcarryx_u32(x173, x149, x157);
    let mut x176: u32 = 0;
    let mut x177: fiat_p384_scalar_u1 = 0;
    let (x176, x177) = fiat_p384_scalar_addcarryx_u32(x175, x151, x157);
    let mut x178: u32 = 0;
    let mut x179: fiat_p384_scalar_u1 = 0;
    let (x178, x179) = fiat_p384_scalar_addcarryx_u32(x177, x153, x157);
    let mut x180: u32 = 0;
    let mut x181: fiat_p384_scalar_u1 = 0;
    let (x180, x181) = fiat_p384_scalar_addcarryx_u32(x179, x155, x157);
    let mut x182: u32 = 0;
    let (x182) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[0]), x158);
    let mut x183: u32 = 0;
    let (x183) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[1]), x160);
    let mut x184: u32 = 0;
    let (x184) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[2]), x162);
    let mut x185: u32 = 0;
    let (x185) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[3]), x164);
    let mut x186: u32 = 0;
    let (x186) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[4]), x166);
    let mut x187: u32 = 0;
    let (x187) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[5]), x168);
    let mut x188: u32 = 0;
    let (x188) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[6]), x170);
    let mut x189: u32 = 0;
    let (x189) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[7]), x172);
    let mut x190: u32 = 0;
    let (x190) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[8]), x174);
    let mut x191: u32 = 0;
    let (x191) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[9]), x176);
    let mut x192: u32 = 0;
    let (x192) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[10]), x178);
    let mut x193: u32 = 0;
    let (x193) = fiat_p384_scalar_cmovznz_u32(x3, (arg5[11]), x180);
    let x194: fiat_p384_scalar_u1 = ((x46 & (0x1 as u32)) as fiat_p384_scalar_u1);
    let mut x195: u32 = 0;
    let (x195) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x7);
    let mut x196: u32 = 0;
    let (x196) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x8);
    let mut x197: u32 = 0;
    let (x197) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x9);
    let mut x198: u32 = 0;
    let (x198) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x10);
    let mut x199: u32 = 0;
    let (x199) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x11);
    let mut x200: u32 = 0;
    let (x200) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x12);
    let mut x201: u32 = 0;
    let (x201) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x13);
    let mut x202: u32 = 0;
    let (x202) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x14);
    let mut x203: u32 = 0;
    let (x203) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x15);
    let mut x204: u32 = 0;
    let (x204) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x16);
    let mut x205: u32 = 0;
    let (x205) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x17);
    let mut x206: u32 = 0;
    let (x206) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x18);
    let mut x207: u32 = 0;
    let (x207) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x19);
    let mut x208: u32 = 0;
    let mut x209: fiat_p384_scalar_u1 = 0;
    let (x208, x209) = fiat_p384_scalar_addcarryx_u32(0x0, x46, x195);
    let mut x210: u32 = 0;
    let mut x211: fiat_p384_scalar_u1 = 0;
    let (x210, x211) = fiat_p384_scalar_addcarryx_u32(x209, x47, x196);
    let mut x212: u32 = 0;
    let mut x213: fiat_p384_scalar_u1 = 0;
    let (x212, x213) = fiat_p384_scalar_addcarryx_u32(x211, x48, x197);
    let mut x214: u32 = 0;
    let mut x215: fiat_p384_scalar_u1 = 0;
    let (x214, x215) = fiat_p384_scalar_addcarryx_u32(x213, x49, x198);
    let mut x216: u32 = 0;
    let mut x217: fiat_p384_scalar_u1 = 0;
    let (x216, x217) = fiat_p384_scalar_addcarryx_u32(x215, x50, x199);
    let mut x218: u32 = 0;
    let mut x219: fiat_p384_scalar_u1 = 0;
    let (x218, x219) = fiat_p384_scalar_addcarryx_u32(x217, x51, x200);
    let mut x220: u32 = 0;
    let mut x221: fiat_p384_scalar_u1 = 0;
    let (x220, x221) = fiat_p384_scalar_addcarryx_u32(x219, x52, x201);
    let mut x222: u32 = 0;
    let mut x223: fiat_p384_scalar_u1 = 0;
    let (x222, x223) = fiat_p384_scalar_addcarryx_u32(x221, x53, x202);
    let mut x224: u32 = 0;
    let mut x225: fiat_p384_scalar_u1 = 0;
    let (x224, x225) = fiat_p384_scalar_addcarryx_u32(x223, x54, x203);
    let mut x226: u32 = 0;
    let mut x227: fiat_p384_scalar_u1 = 0;
    let (x226, x227) = fiat_p384_scalar_addcarryx_u32(x225, x55, x204);
    let mut x228: u32 = 0;
    let mut x229: fiat_p384_scalar_u1 = 0;
    let (x228, x229) = fiat_p384_scalar_addcarryx_u32(x227, x56, x205);
    let mut x230: u32 = 0;
    let mut x231: fiat_p384_scalar_u1 = 0;
    let (x230, x231) = fiat_p384_scalar_addcarryx_u32(x229, x57, x206);
    let mut x232: u32 = 0;
    let mut x233: fiat_p384_scalar_u1 = 0;
    let (x232, x233) = fiat_p384_scalar_addcarryx_u32(x231, x58, x207);
    let mut x234: u32 = 0;
    let (x234) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x59);
    let mut x235: u32 = 0;
    let (x235) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x60);
    let mut x236: u32 = 0;
    let (x236) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x61);
    let mut x237: u32 = 0;
    let (x237) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x62);
    let mut x238: u32 = 0;
    let (x238) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x63);
    let mut x239: u32 = 0;
    let (x239) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x64);
    let mut x240: u32 = 0;
    let (x240) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x65);
    let mut x241: u32 = 0;
    let (x241) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x66);
    let mut x242: u32 = 0;
    let (x242) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x67);
    let mut x243: u32 = 0;
    let (x243) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x68);
    let mut x244: u32 = 0;
    let (x244) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x69);
    let mut x245: u32 = 0;
    let (x245) = fiat_p384_scalar_cmovznz_u32(x194, (0x0 as u32), x70);
    let mut x246: u32 = 0;
    let mut x247: fiat_p384_scalar_u1 = 0;
    let (x246, x247) = fiat_p384_scalar_addcarryx_u32(0x0, x182, x234);
    let mut x248: u32 = 0;
    let mut x249: fiat_p384_scalar_u1 = 0;
    let (x248, x249) = fiat_p384_scalar_addcarryx_u32(x247, x183, x235);
    let mut x250: u32 = 0;
    let mut x251: fiat_p384_scalar_u1 = 0;
    let (x250, x251) = fiat_p384_scalar_addcarryx_u32(x249, x184, x236);
    let mut x252: u32 = 0;
    let mut x253: fiat_p384_scalar_u1 = 0;
    let (x252, x253) = fiat_p384_scalar_addcarryx_u32(x251, x185, x237);
    let mut x254: u32 = 0;
    let mut x255: fiat_p384_scalar_u1 = 0;
    let (x254, x255) = fiat_p384_scalar_addcarryx_u32(x253, x186, x238);
    let mut x256: u32 = 0;
    let mut x257: fiat_p384_scalar_u1 = 0;
    let (x256, x257) = fiat_p384_scalar_addcarryx_u32(x255, x187, x239);
    let mut x258: u32 = 0;
    let mut x259: fiat_p384_scalar_u1 = 0;
    let (x258, x259) = fiat_p384_scalar_addcarryx_u32(x257, x188, x240);
    let mut x260: u32 = 0;
    let mut x261: fiat_p384_scalar_u1 = 0;
    let (x260, x261) = fiat_p384_scalar_addcarryx_u32(x259, x189, x241);
    let mut x262: u32 = 0;
    let mut x263: fiat_p384_scalar_u1 = 0;
    let (x262, x263) = fiat_p384_scalar_addcarryx_u32(x261, x190, x242);
    let mut x264: u32 = 0;
    let mut x265: fiat_p384_scalar_u1 = 0;
    let (x264, x265) = fiat_p384_scalar_addcarryx_u32(x263, x191, x243);
    let mut x266: u32 = 0;
    let mut x267: fiat_p384_scalar_u1 = 0;
    let (x266, x267) = fiat_p384_scalar_addcarryx_u32(x265, x192, x244);
    let mut x268: u32 = 0;
    let mut x269: fiat_p384_scalar_u1 = 0;
    let (x268, x269) = fiat_p384_scalar_addcarryx_u32(x267, x193, x245);
    let mut x270: u32 = 0;
    let mut x271: fiat_p384_scalar_u1 = 0;
    let (x270, x271) = fiat_p384_scalar_subborrowx_u32(0x0, x246, 0xccc52973);
    let mut x272: u32 = 0;
    let mut x273: fiat_p384_scalar_u1 = 0;
    let (x272, x273) = fiat_p384_scalar_subborrowx_u32(x271, x248, 0xecec196a);
    let mut x274: u32 = 0;
    let mut x275: fiat_p384_scalar_u1 = 0;
    let (x274, x275) = fiat_p384_scalar_subborrowx_u32(x273, x250, 0x48b0a77a);
    let mut x276: u32 = 0;
    let mut x277: fiat_p384_scalar_u1 = 0;
    let (x276, x277) = fiat_p384_scalar_subborrowx_u32(x275, x252, 0x581a0db2);
    let mut x278: u32 = 0;
    let mut x279: fiat_p384_scalar_u1 = 0;
    let (x278, x279) = fiat_p384_scalar_subborrowx_u32(x277, x254, 0xf4372ddf);
    let mut x280: u32 = 0;
    let mut x281: fiat_p384_scalar_u1 = 0;
    let (x280, x281) = fiat_p384_scalar_subborrowx_u32(x279, x256, 0xc7634d81);
    let mut x282: u32 = 0;
    let mut x283: fiat_p384_scalar_u1 = 0;
    let (x282, x283) = fiat_p384_scalar_subborrowx_u32(x281, x258, 0xffffffff);
    let mut x284: u32 = 0;
    let mut x285: fiat_p384_scalar_u1 = 0;
    let (x284, x285) = fiat_p384_scalar_subborrowx_u32(x283, x260, 0xffffffff);
    let mut x286: u32 = 0;
    let mut x287: fiat_p384_scalar_u1 = 0;
    let (x286, x287) = fiat_p384_scalar_subborrowx_u32(x285, x262, 0xffffffff);
    let mut x288: u32 = 0;
    let mut x289: fiat_p384_scalar_u1 = 0;
    let (x288, x289) = fiat_p384_scalar_subborrowx_u32(x287, x264, 0xffffffff);
    let mut x290: u32 = 0;
    let mut x291: fiat_p384_scalar_u1 = 0;
    let (x290, x291) = fiat_p384_scalar_subborrowx_u32(x289, x266, 0xffffffff);
    let mut x292: u32 = 0;
    let mut x293: fiat_p384_scalar_u1 = 0;
    let (x292, x293) = fiat_p384_scalar_subborrowx_u32(x291, x268, 0xffffffff);
    let mut x294: u32 = 0;
    let mut x295: fiat_p384_scalar_u1 = 0;
    let (x294, x295) = fiat_p384_scalar_subborrowx_u32(x293, (x269 as u32), (0x0 as u32));
    let mut x296: u32 = 0;
    let mut x297: fiat_p384_scalar_u1 = 0;
    let (x296, x297) = fiat_p384_scalar_addcarryx_u32(0x0, x6, (0x1 as u32));
    let x298: u32 = ((x208 >> 1) | ((x210 << 31) & 0xffffffff));
    let x299: u32 = ((x210 >> 1) | ((x212 << 31) & 0xffffffff));
    let x300: u32 = ((x212 >> 1) | ((x214 << 31) & 0xffffffff));
    let x301: u32 = ((x214 >> 1) | ((x216 << 31) & 0xffffffff));
    let x302: u32 = ((x216 >> 1) | ((x218 << 31) & 0xffffffff));
    let x303: u32 = ((x218 >> 1) | ((x220 << 31) & 0xffffffff));
    let x304: u32 = ((x220 >> 1) | ((x222 << 31) & 0xffffffff));
    let x305: u32 = ((x222 >> 1) | ((x224 << 31) & 0xffffffff));
    let x306: u32 = ((x224 >> 1) | ((x226 << 31) & 0xffffffff));
    let x307: u32 = ((x226 >> 1) | ((x228 << 31) & 0xffffffff));
    let x308: u32 = ((x228 >> 1) | ((x230 << 31) & 0xffffffff));
    let x309: u32 = ((x230 >> 1) | ((x232 << 31) & 0xffffffff));
    let x310: u32 = ((x232 & 0x80000000) | (x232 >> 1));
    let mut x311: u32 = 0;
    let (x311) = fiat_p384_scalar_cmovznz_u32(x120, x95, x71);
    let mut x312: u32 = 0;
    let (x312) = fiat_p384_scalar_cmovznz_u32(x120, x97, x73);
    let mut x313: u32 = 0;
    let (x313) = fiat_p384_scalar_cmovznz_u32(x120, x99, x75);
    let mut x314: u32 = 0;
    let (x314) = fiat_p384_scalar_cmovznz_u32(x120, x101, x77);
    let mut x315: u32 = 0;
    let (x315) = fiat_p384_scalar_cmovznz_u32(x120, x103, x79);
    let mut x316: u32 = 0;
    let (x316) = fiat_p384_scalar_cmovznz_u32(x120, x105, x81);
    let mut x317: u32 = 0;
    let (x317) = fiat_p384_scalar_cmovznz_u32(x120, x107, x83);
    let mut x318: u32 = 0;
    let (x318) = fiat_p384_scalar_cmovznz_u32(x120, x109, x85);
    let mut x319: u32 = 0;
    let (x319) = fiat_p384_scalar_cmovznz_u32(x120, x111, x87);
    let mut x320: u32 = 0;
    let (x320) = fiat_p384_scalar_cmovznz_u32(x120, x113, x89);
    let mut x321: u32 = 0;
    let (x321) = fiat_p384_scalar_cmovznz_u32(x120, x115, x91);
    let mut x322: u32 = 0;
    let (x322) = fiat_p384_scalar_cmovznz_u32(x120, x117, x93);
    let mut x323: u32 = 0;
    let (x323) = fiat_p384_scalar_cmovznz_u32(x295, x270, x246);
    let mut x324: u32 = 0;
    let (x324) = fiat_p384_scalar_cmovznz_u32(x295, x272, x248);
    let mut x325: u32 = 0;
    let (x325) = fiat_p384_scalar_cmovznz_u32(x295, x274, x250);
    let mut x326: u32 = 0;
    let (x326) = fiat_p384_scalar_cmovznz_u32(x295, x276, x252);
    let mut x327: u32 = 0;
    let (x327) = fiat_p384_scalar_cmovznz_u32(x295, x278, x254);
    let mut x328: u32 = 0;
    let (x328) = fiat_p384_scalar_cmovznz_u32(x295, x280, x256);
    let mut x329: u32 = 0;
    let (x329) = fiat_p384_scalar_cmovznz_u32(x295, x282, x258);
    let mut x330: u32 = 0;
    let (x330) = fiat_p384_scalar_cmovznz_u32(x295, x284, x260);
    let mut x331: u32 = 0;
    let (x331) = fiat_p384_scalar_cmovznz_u32(x295, x286, x262);
    let mut x332: u32 = 0;
    let (x332) = fiat_p384_scalar_cmovznz_u32(x295, x288, x264);
    let mut x333: u32 = 0;
    let (x333) = fiat_p384_scalar_cmovznz_u32(x295, x290, x266);
    let mut x334: u32 = 0;
    let (x334) = fiat_p384_scalar_cmovznz_u32(x295, x292, x268);
    out1 = x296;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out2[5] = x12;
    out2[6] = x13;
    out2[7] = x14;
    out2[8] = x15;
    out2[9] = x16;
    out2[10] = x17;
    out2[11] = x18;
    out2[12] = x19;
    out3[0] = x298;
    out3[1] = x299;
    out3[2] = x300;
    out3[3] = x301;
    out3[4] = x302;
    out3[5] = x303;
    out3[6] = x304;
    out3[7] = x305;
    out3[8] = x306;
    out3[9] = x307;
    out3[10] = x308;
    out3[11] = x309;
    out3[12] = x310;
    out4[0] = x311;
    out4[1] = x312;
    out4[2] = x313;
    out4[3] = x314;
    out4[4] = x315;
    out4[5] = x316;
    out4[6] = x317;
    out4[7] = x318;
    out4[8] = x319;
    out4[9] = x320;
    out4[10] = x321;
    out4[11] = x322;
    out5[0] = x323;
    out5[1] = x324;
    out5[2] = x325;
    out5[3] = x326;
    out5[4] = x327;
    out5[5] = x328;
    out5[6] = x329;
    out5[7] = x330;
    out5[8] = x331;
    out5[9] = x332;
    out5[10] = x333;
    out5[11] = x334;
    (out1, out2, out3, out4, out5)
}
#[doc = " The function fiat_p384_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p384_scalar_divstep_precomp() -> [u32; 12] {
    let mut out1: [u32; 12] = [0; 12];
    out1[0] = 0xe6045b6a;
    out1[1] = 0x49589ae0;
    out1[2] = 0x870040ed;
    out1[3] = 0x3c9a5352;
    out1[4] = 0x977dc242;
    out1[5] = 0xdacb097e;
    out1[6] = 0xd1ecbe36;
    out1[7] = 0xb5ab30a6;
    out1[8] = 0x1f959973;
    out1[9] = 0x97d7a108;
    out1[10] = 0xd27192bc;
    out1[11] = 0x2ba012f8;
    out1
}
