.TH tfmtodit @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
tfmtodit \- adapt TeX Font Metrics files for use with
.I groff
and
.I grodvi
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_tfmtodit_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.\" Definitions
.\" ====================================================================
.
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY tfmtodit
.RB [ \-s ]
.RB [ \-g\~\c
.IR gf-file ]
.RB [ \-k\~\c
.IR skew-char ]
.I tfm-file
.I map-file
.I font-description
.YS
.
.
.SY tfmtodit
.B \-\-help
.YS
.
.
.SY tfmtodit
.B \-v
.
.SY tfmtodit
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I tfmtodit
creates a font description file for use with
.MR groff @MAN1EXT@ 's
.B dvi
output device.
.
.I tfm-file
is the name of the \*(tx font metric file for the font.
.
.I map-file
assigns
.I groff
ordinary or special character identifiers to glyph indices in the font;
it should consist of a sequence of lines of the form
.
.RS
.IR "i c1" \~\&.\|.\|.\&\~ cn
.RE
.
where
.I i
is a position of the glyph in the font in decimal,
and
.I c1
through
.I cn
are glyph identifiers in the form used by
.I groff
font descriptions.
.
If a glyph has no
.I groff
names but exists in
.I tfm-file,
it is put in the
.I groff
font description file as an unnamed glyph.
.
Output is written in
.MR groff_font @MAN5EXT@
format to
.I font-description,
a file named for the intended
.I groff
font name.
.
.
.P
If the font is \[lq]special\[rq],
meaning that
.I groff
should search it whenever a glyph is not found in the current font,
use the
.B \-s
option and name
.I font-description
in the
.B fonts
directive in the output device's
.I DESC
file.
.
.
.P
To do a good job of math typesetting,
.I groff
requires font metric information not present in
.I tfm-file.
.
This is because \*(tx has separate math italic fonts,
whereas
.I groff
uses normal italic fonts for math.
.
The additional information required by
.I groff
is given by the two arguments to the
.B math_fit
macro in the Metafont programs for the Computer Modern fonts.
.
In a text font (a font for which
.B math_fit
is false),
Metafont normally ignores these two arguments.
.
Metafont can be made to put this information into the GF
(\[lq]generic font\[rq])
files it produces by loading the following definition after
.B cmbase
when creating
.IR cm.base .
.
.RS
.EX
def ignore_math_fit(expr left_adjustment,right_adjustment) =
    special "adjustment";
    numspecial left_adjustment*16/designsize;
    numspecial right_adjustment*16/designsize;
    enddef;
.EE
.RE
.
For the EC font family,
load the following definition after
.BR exbase ;
consider patching
.I exbase.mf
locally.
.
.RS
.EX
def ignore_math_fit(expr left_adjustment,right_adjustment) =
    ori_special "adjustment";
    ori_numspecial left_adjustment*16/designsize;
    ori_numspecial right_adjustment*16/designsize;
    enddef;
.EE
.RE
.
The only difference from the previous example is the \[lq]ori_\[rq]
prefix to \[lq]special\[rq] and \[lq]numspecial\[rq].
.
The GF file created using this modified
.I cm.base
or
.I exbase.mf
should be specified with the
.B \-g
option,
which should
.I not
be given for a font for which
.B math_fit
is true.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-g \~gf-file
Use the
.I gf-file
produced by Metafont containing
.RB \[lq] special \[rq]
and
.RB \[lq] numspecial \[rq]
commands to obtain additional font metric information.
.
.
.TP
.BI \-k \~skew-char
The skew character of this font is at position
.I skew-char.
.
.I skew-char
should be an integer;
it may be given in decimal,
with a leading 0 in octal,
or with a leading 0x in hexadecimal.
.
Any kerns whose second component is
.I skew-char
are ignored.
.
.
.TP
.B \-s
Add the
.B special
directive to the font description file.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devdvi/\:DESC
describes the
.B dvi
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devdvi/ F
describes the font known
.RI as\~ F
on device
.BR dvi .
.
.
.TP
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%ec.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%msam.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%msbm.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%tc.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texb.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texex.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texi.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texitt.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texmi.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texr.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%texsy.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%textex.map
.TQ
.I @FONTDIR@/\:\%devdvi/\:\%generate/\:\%textt.map
map glyph indices in \*[tx] fonts to
.I groff
ordinary and special character identifiers.
.
.I \%ec.map
is used for
.BR TREC ,
.BR TIEC ,
.BR TBEC ,
.BR TBIEC ,
.BR HREC ,
.BR HIEC ,
.BR HBEC ,
.BR HBIEC ,
.BR CWEC ,
and
.BR CWIEC ;
.I \%msam.map
for
.BR SA ;
.I \%msbm.map
for
.BR SB ;
.I \%tc.map
for
.BR TRTC ,
.BR TITC ,
.BR TBTC ,
.BR TBITC ,
.BR HRTC ,
.BR HITC ,
.BR HBTC ,
.BR HBITC ,
.BR CWTC ,
and
.BR CWITC ;
.I \%texb.map
for
.BR TB ,
.BR HR ,
.BR HI ,
.BR HB ,
and
.BR HBI ;
.I \%texex.map
for
.BR EX ;
.I \%texi.map
for
.B TI
and
.BR TBI ;
.I \%texitt.map
for
.BR CWI ;
.I \%texmi.map
for
.BR MI ;
.I \%texr.map
for
.BR TR ;
.I \%texsy.map
for
.BR S ;
.I \%textex.map
for
.BR SC ;
and
.I \%textt.map
for
.BR CW .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR groff @MAN1EXT@ ,
.MR grodvi @MAN1EXT@ ,
.MR groff_font @MAN5EXT@
.
.
.\" Clean up.
.rm tx
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_tfmtodit_1_man_C]
.do rr *groff_tfmtodit_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
