/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.load;

import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.SequenceResolver;
import com.thaiopensource.resolver.load.ResolverLoadException;
import com.thaiopensource.resolver.xml.sax.SAX;
import com.thaiopensource.resolver.xml.transform.Transform;
import javax.xml.transform.URIResolver;
import org.xml.sax.EntityResolver;

public class ResolverLoader {
    public static Resolver loadResolver(String string, ClassLoader classLoader) throws ResolverLoadException {
        Object obj;
        try {
            if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null && (classLoader = ClassLoader.getSystemClassLoader()) == null) {
                throw new ResolverLoadException("no class loader");
            }
            obj = classLoader.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            throw new ResolverLoadException(exception);
        }
        if (obj instanceof Resolver) {
            return (Resolver)obj;
        }
        Resolver resolver = null;
        Resolver resolver2 = null;
        if (obj instanceof URIResolver) {
            resolver2 = Transform.createResolver((URIResolver)obj);
        }
        if (obj instanceof EntityResolver) {
            resolver = SAX.createResolver((EntityResolver)obj, resolver2 == null);
        }
        if (resolver2 == null) {
            if (resolver == null) {
                throw new ResolverLoadException(string + " not an instance of javax.xml.transform.URIResolver or org.xml.sax.EntityResolver");
            }
            return resolver;
        }
        if (resolver == null) {
            return resolver2;
        }
        return new SequenceResolver(resolver, resolver2);
    }
}

