// Copyright (C) 2024 The Qt Company Ltd.
// Copyright (C) 2010 Kolja21
// SPDX-License-Identifier: CC-BY-3.0
// Generated from: assets/Europe.svg
import QtQuick
import QtQuick.Shapes

Item {
    // viewBox 1754, 161 6480.48x6957.59
    // size 443x455
    implicitWidth: 443
    implicitHeight: 455
    // START Europakarte type: DOC 0
    Item { // structure node
        transform: [
            Translate { x: -1754; y: -161 },
            Scale { xScale: width / 6480.48; yScale: height / 6957.59 }
        ]
        objectName: "Europakarte"
        // skipping DEFS "defs"
        // START countries type: G 1
        Item { // structure node
            objectName: "countries"
            // Translate -1630.41, -991.638
            x: -1630.41
            y: -991.638
            // PATH visit fi count: 485
            DemoShape {
                objectName: "fi"
                ShapePath {
                    objectName: "svg_path:fi"
                    // boundingRect: 6920, 1421.37 1086.48x1971.11
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7814.3 3152.63 C 7822.9 3119.67 7850.13 3085.28 7867.33 3056.61 C 7911.75 2977.79 7938.98 2887.5 7969.08 2802.94 C 7992.01 2741.32 7999.18 2725.55 8002.04 2659.63 C 8003.48 2649.59 8009.21 2638.13 8004.91 2628.1 C 7993.44 2595.13 7865.89 2547.84 7832.93 2524.91 C 7828.63 2522.04 7880.22 2443.22 7844.39 2415.99 C 7831.5 2405.96 7804.27 2415.99 7795.67 2401.66 C 7758.4 2337.16 7804.27 2367.26 7792.8 2348.63 C 7775.6 2322.83 7756.97 2342.9 7735.47 2317.1 C 7716.84 2295.6 7729.74 2294.17 7739.77 2274.1 C 7745.51 2261.21 7711.11 2261.21 7711.11 2255.47 C 7712.54 2245.44 7712.54 2193.85 7712.54 2192.41 C 7682.45 2166.62 7718.28 2182.38 7726.88 2172.35 C 7732.61 2163.75 7696.78 2112.16 7692.48 2106.42 C 7668.12 2073.46 7640.89 2034.77 7612.22 2006.1 C 7607.92 2001.8 7584.99 1984.6 7580.69 1976.01 C 7559.19 1935.88 7627.99 1834.12 7600.76 1809.76 C 7593.59 1801.16 7580.69 1801.16 7572.09 1795.43 C 7556.33 1783.96 7549.16 1763.9 7533.4 1753.86 C 7531.96 1753.86 7483.24 1746.7 7481.8 1746.7 C 7473.2 1739.53 7470.34 1728.07 7464.61 1718.04 C 7433.08 1666.44 7470.34 1670.74 7454.57 1633.48 C 7447.41 1616.28 7420.18 1632.05 7425.91 1622.01 C 7433.08 1609.12 7443.11 1600.52 7451.71 1589.05 C 7405.85 1567.55 7466.04 1533.16 7447.41 1501.63 C 7418.74 1451.47 7374.32 1470.1 7337.05 1429.97 L 7335.62 1422.8 C 7334.19 1422.8 7332.75 1422.8 7331.32 1424.24 C 7331.32 1422.8 7329.89 1422.8 7329.89 1421.37 L 7329.89 1424.24 C 7301.22 1429.97 7306.96 1462.93 7282.59 1470.1 C 7261.1 1475.83 7269.7 1445.73 7245.33 1472.96 C 7242.47 1477.26 7245.33 1484.43 7243.9 1490.16 C 7242.47 1491.6 7226.7 1521.69 7226.7 1523.13 C 7222.4 1534.59 7231 1571.85 7232.43 1581.89 C 7232.43 1586.18 7229.57 1589.05 7229.57 1593.35 C 7229.57 1601.95 7231 1609.12 7232.43 1617.71 C 7236.73 1629.18 7246.76 1637.78 7248.2 1649.24 C 7255.36 1699.4 7242.47 1665.01 7225.27 1680.77 C 7205.2 1700.84 7223.83 1706.57 7218.1 1730.93 C 7216.67 1736.67 7210.94 1739.53 7209.5 1745.27 C 7209.5 1746.7 7190.87 1729.5 7188 1728.07 C 7183.71 1725.2 7130.68 1706.57 7126.38 1712.3 C 7120.65 1718.04 7124.95 1729.5 7120.65 1735.23 C 7103.45 1765.33 7080.52 1746.7 7056.15 1751 C 7048.99 1751 7041.82 1755.3 7036.09 1753.86 L 7030.36 1749.57 C 7027.49 1743.83 7027.49 1735.23 7024.62 1729.5 C 7014.59 1712.3 6981.63 1667.87 6964.43 1657.84 C 6927.17 1636.35 6925.74 1666.44 6928.6 1689.37 L 6920 1719.47 C 6920 1719.47 6921.44 1719.47 6921.44 1719.47 L 6920 1720.9 L 6925.74 1728.07 C 6924.3 1730.93 6918.57 1732.37 6925.74 1736.67 C 6950.1 1755.3 6991.66 1789.69 7017.46 1801.16 C 7047.55 1814.06 7071.92 1802.59 7099.15 1829.82 C 7104.88 1834.12 7100.58 1847.02 7106.31 1849.89 C 7110.61 1851.32 7113.48 1844.15 7116.35 1845.59 C 7127.81 1849.89 7132.11 1864.22 7140.71 1872.82 C 7143.58 1875.68 7152.18 1875.68 7150.74 1879.98 C 7134.98 1910.08 7152.18 1911.51 7156.48 1945.91 C 7157.91 1951.64 7152.18 1957.37 7152.18 1963.11 C 7150.74 1964.54 7150.74 1964.54 7150.74 1964.54 C 7150.74 1978.87 7172.24 1967.41 7177.97 1973.14 C 7196.6 1987.47 7166.51 2007.54 7175.11 2021.87 C 7183.71 2041.93 7218.1 2060.56 7220.97 2083.49 C 7222.4 2100.69 7209.5 2155.15 7210.94 2162.32 C 7223.83 2208.18 7255.36 2223.94 7272.56 2261.21 C 7278.29 2251.17 7285.46 2242.57 7305.52 2254.04 C 7315.56 2259.77 7309.82 2279.84 7319.86 2285.57 C 7328.45 2291.3 7339.92 2279.84 7349.95 2282.7 C 7354.25 2282.7 7354.25 2291.3 7357.12 2294.17 C 7365.72 2298.47 7365.72 2281.27 7374.32 2295.6 C 7390.08 2328.56 7378.62 2357.23 7384.35 2371.56 C 7388.65 2384.46 7427.34 2355.79 7410.15 2397.36 C 7405.85 2407.39 7391.51 2404.52 7382.92 2410.25 C 7374.32 2415.99 7364.28 2420.29 7358.55 2428.89 C 7355.69 2431.75 7359.98 2438.92 7357.12 2441.78 C 7354.25 2444.65 7347.09 2437.49 7345.65 2440.35 C 7341.35 2450.38 7339.92 2463.28 7339.92 2474.75 C 7339.92 2481.91 7344.22 2489.08 7341.35 2496.24 C 7339.92 2509.14 7322.72 2514.88 7319.86 2526.34 C 7316.99 2534.94 7324.16 2544.97 7321.29 2552.14 C 7314.12 2567.9 7298.36 2565.04 7296.93 2586.53 C 7295.49 2590.83 7304.09 2595.13 7304.09 2600.87 C 7299.79 2628.1 7261.1 2623.8 7259.66 2648.16 C 7258.23 2658.19 7251.06 2683.99 7249.63 2685.42 C 7243.9 2685.42 7236.73 2671.09 7231 2675.39 C 7218.1 2686.86 7238.17 2715.52 7225.27 2724.12 C 7220.97 2726.98 7212.37 2708.35 7213.8 2714.09 C 7213.8 2721.25 7223.83 2724.12 7226.7 2731.28 C 7239.6 2778.58 7222.4 2747.05 7202.34 2769.98 C 7198.04 2775.71 7206.64 2790.04 7200.9 2790.04 C 7192.3 2788.61 7196.6 2771.41 7189.44 2769.98 C 7177.97 2767.11 7163.64 2771.41 7157.91 2781.44 C 7134.98 2820.14 7183.71 2792.91 7180.84 2815.84 C 7177.97 2830.17 7140.71 2854.54 7139.28 2870.3 C 7132.11 2964.89 7140.71 2867.43 7155.04 2903.26 C 7156.48 2904.7 7142.14 2930.49 7153.61 2937.66 C 7155.04 2939.09 7157.91 2931.93 7159.34 2933.36 C 7162.21 2937.66 7157.91 2947.69 7163.64 2949.13 C 7166.51 2950.56 7160.77 2936.23 7165.07 2936.23 C 7169.37 2934.79 7170.81 2940.53 7172.24 2944.83 C 7180.84 2967.76 7170.81 3005.02 7175.11 3013.62 C 7177.97 3019.35 7186.57 3016.48 7190.87 3020.78 C 7196.6 3027.95 7199.47 3036.55 7203.77 3043.71 C 7205.2 3046.58 7202.34 3050.88 7203.77 3053.75 C 7206.64 3058.05 7212.37 3058.05 7215.23 3060.91 C 7216.67 3062.35 7209.5 3060.91 7209.5 3062.35 C 7208.07 3065.21 7210.94 3068.08 7212.37 3070.94 C 7219.53 3079.54 7235.3 3083.84 7233.87 3093.87 C 7232.43 3102.47 7209.5 3095.31 7208.07 3103.91 C 7205.2 3115.37 7222.4 3122.54 7225.27 3132.57 C 7226.7 3136.87 7219.53 3141.17 7220.97 3146.9 C 7222.4 3149.77 7231 3149.77 7231 3154.07 C 7229.57 3172.7 7215.23 3152.63 7220.97 3168.4 C 7222.4 3174.13 7229.57 3178.43 7228.13 3182.73 C 7226.7 3188.46 7212.37 3181.3 7210.94 3185.6 C 7209.5 3222.86 7225.27 3227.16 7236.73 3242.92 C 7239.6 3245.79 7225.27 3248.66 7228.13 3252.96 C 7229.57 3260.12 7232.43 3265.85 7236.73 3271.59 C 7268.26 3313.15 7243.9 3270.15 7273.99 3264.42 C 7279.73 3264.42 7268.26 3280.19 7273.99 3284.49 C 7282.59 3288.79 7292.63 3281.62 7302.66 3281.62 C 7311.26 3283.05 7315.56 3297.38 7322.72 3297.38 C 7329.89 3297.38 7332.75 3288.79 7338.49 3288.79 C 7341.35 3287.35 7338.49 3293.08 7339.92 3294.52 C 7344.22 3295.95 7347.09 3294.52 7351.39 3293.08 C 7352.82 3291.65 7352.82 3283.05 7354.25 3285.92 C 7368.58 3317.45 7345.65 3323.18 7351.39 3324.61 C 7354.25 3324.61 7387.21 3300.25 7391.51 3297.38 C 7392.95 3295.95 7395.81 3288.79 7397.25 3287.35 C 7390.08 3308.85 7371.45 3333.21 7405.85 3346.11 C 7411.58 3348.98 7423.04 3336.08 7425.91 3341.81 C 7428.78 3350.41 7405.85 3363.31 7414.44 3366.18 C 7423.04 3370.48 7421.61 3346.11 7430.21 3344.68 C 7437.38 3343.25 7431.64 3359.01 7428.78 3364.74 C 7424.48 3371.91 7415.88 3374.78 7408.71 3380.51 C 7405.85 3384.81 7394.38 3394.84 7398.68 3391.97 C 7443.11 3374.78 7425.91 3346.11 7448.84 3331.78 C 7456.01 3327.48 7437.38 3350.41 7444.54 3354.71 C 7454.57 3360.44 7467.47 3353.28 7477.5 3347.55 C 7484.67 3344.68 7487.54 3333.21 7493.27 3328.91 C 7501.87 3321.75 7540.56 3317.45 7544.86 3311.72 C 7549.16 3307.42 7534.83 3300.25 7539.13 3295.95 C 7546.3 3290.22 7557.76 3294.52 7567.79 3293.08 C 7570.66 3293.08 7576.39 3294.52 7577.83 3291.65 C 7580.69 3287.35 7574.96 3281.62 7576.39 3278.75 C 7577.83 3275.89 7577.83 3285.92 7580.69 3287.35 C 7582.13 3288.79 7619.39 3265.85 7622.25 3261.56 C 7623.69 3260.12 7616.52 3231.46 7630.85 3234.33 C 7633.72 3234.33 7686.75 3283.05 7673.85 3230.03 C 7670.98 3219.99 7645.18 3218.56 7649.48 3207.1 C 7652.35 3197.06 7670.98 3202.8 7681.01 3205.66 C 7686.75 3207.1 7686.75 3222.86 7692.48 3219.99 C 7706.81 3209.96 7685.31 3161.23 7702.51 3171.27 C 7716.84 3181.3 7678.15 3217.13 7722.58 3202.8 C 7791.37 3179.86 7732.61 3194.2 7746.94 3172.7 C 7748.37 3171.27 7749.81 3175.57 7752.67 3175.57 C 7755.54 3175.57 7759.84 3175.57 7761.27 3172.7 C 7762.7 3169.83 7756.97 3159.8 7761.27 3159.8 C 7762.7 3159.8 7785.63 3179.86 7792.8 3177 C 7802.83 3174.13 7810 3165.53 7815.73 3158.37 C 7817.16 3158.37 7817.16 3156.93 7817.16 3155.5 L 7814.3 3152.63 " }
                }
            }
            // PATH visit se count: 926
            DemoShape {
                objectName: "se"
                ShapePath {
                    objectName: "svg_path:se"
                    // boundingRect: 6292.28, 1712.3 980.285x2639.89
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6447.06 4352.19 C 6449.92 4343.6 6444.19 4339.3 6435.59 4335 L 6429.86 4320.66 C 6441.33 4327.83 6459.96 4332.13 6454.22 4345.03 C 6454.22 4347.89 6451.36 4350.76 6447.06 4352.19 M 6452.79 4286.27 C 6472.86 4263.34 6449.92 4264.77 6448.49 4236.11 C 6448.49 4227.51 6457.09 4221.78 6458.52 4213.18 C 6458.52 4210.31 6452.79 4207.44 6451.36 4204.58 C 6432.73 4201.71 6408.36 4195.98 6392.6 4207.44 C 6408.36 4187.38 6435.59 4193.11 6457.09 4197.41 C 6445.63 4178.78 6438.46 4164.45 6441.33 4161.58 C 6447.06 4148.68 6467.12 4177.35 6480.02 4171.62 C 6491.49 4167.32 6451.36 4150.12 6457.09 4138.65 C 6461.39 4128.62 6481.45 4140.09 6485.75 4131.49 C 6492.92 4121.45 6488.62 4107.12 6482.89 4097.09 C 6480.02 4091.36 6471.42 4095.66 6465.69 4094.22 C 6454.22 4089.93 6457.09 4069.86 6448.49 4059.83 C 6442.76 4052.66 6431.29 4052.66 6425.56 4045.5 C 6422.69 4039.76 6426.99 4032.6 6424.13 4026.87 C 6421.26 4019.7 6404.06 3996.77 6404.06 3995.34 C 6404.06 3992.47 6409.8 3991.04 6408.36 3989.6 C 6406.93 3986.74 6401.2 3988.17 6398.33 3986.74 C 6391.16 3981 6385.43 3972.41 6381.13 3965.24 C 6373.97 3952.34 6382.57 3917.95 6372.53 3902.18 C 6369.67 3897.88 6359.63 3903.61 6355.34 3899.31 C 6351.04 3893.58 6352.47 3883.55 6352.47 3874.95 C 6349.6 3853.45 6389.73 3803.29 6371.1 3780.36 C 6345.3 3747.4 6359.63 3836.25 6305.17 3781.79 C 6296.58 3773.2 6310.91 3747.4 6310.91 3737.37 C 6309.47 3720.17 6292.28 3655.68 6292.28 3655.68 C 6298.01 3648.51 6312.34 3661.41 6320.94 3659.98 C 6325.24 3674.31 6330.97 3688.64 6343.87 3670.01 C 6375.4 3625.58 6335.27 3568.25 6343.87 3542.46 C 6346.74 3532.42 6361.07 3530.99 6365.37 3522.39 C 6368.23 3516.66 6365.37 3509.49 6362.5 3503.76 C 6362.5 3499.46 6355.34 3498.03 6356.77 3495.16 C 6359.63 3485.13 6405.5 3482.26 6418.39 3449.3 L 6416.96 3407.74 C 6432.73 3326.05 6395.46 3341.81 6388.3 3280.19 C 6386.87 3265.85 6415.53 3273.02 6426.99 3262.99 L 6442.76 3205.66 C 6437.03 3169.83 6382.57 3172.7 6373.97 3139.74 C 6366.8 3109.64 6389.73 3069.51 6386.87 3037.98 C 6384 3016.48 6361.07 2997.85 6359.63 2976.36 C 6358.2 2967.76 6365.37 2957.72 6365.37 2949.13 C 6363.93 2939.09 6358.2 2930.49 6359.63 2920.46 C 6359.63 2911.86 6369.67 2906.13 6369.67 2897.53 C 6369.67 2724.12 6348.17 3025.08 6348.17 2851.67 C 6348.17 2835.91 6368.23 2825.87 6369.67 2810.11 C 6371.1 2804.38 6362.5 2798.64 6363.93 2791.48 C 6368.23 2768.55 6399.76 2719.82 6418.39 2708.35 C 6477.15 2671.09 6515.85 2738.45 6525.88 2671.09 C 6535.91 2600.87 6475.72 2615.2 6484.32 2589.4 C 6497.22 2549.27 6517.28 2509.14 6530.18 2470.45 C 6531.61 2464.72 6538.78 2463.28 6540.21 2457.55 L 6535.91 2404.52 C 6535.91 2403.09 6543.08 2360.09 6543.08 2360.09 L 6528.75 2304.2 C 6534.48 2291.3 6557.41 2304.2 6568.88 2298.47 L 6600.41 2271.24 C 6604.71 2258.34 6586.08 2246.87 6588.94 2233.98 C 6597.54 2208.18 6644.83 2152.29 6653.43 2127.92 C 6669.2 2089.23 6631.94 2086.36 6626.2 2054.83 C 6621.9 2029.03 6637.67 2044.8 6646.27 2034.77 C 6657.73 2020.43 6657.73 2000.37 6660.6 1984.6 C 6662.03 1973.14 6689.26 1922.98 6697.86 1922.98 L 6743.72 1943.04 C 6772.39 1931.58 6736.56 1849.89 6745.16 1838.42 C 6765.22 1812.62 6864.11 1861.35 6877.01 1852.75 C 6924.3 1822.66 6874.14 1825.52 6872.71 1812.62 C 6868.41 1795.43 6892.77 1782.53 6892.77 1765.33 C 6892.77 1755.3 6889.91 1745.27 6885.61 1736.67 C 6881.31 1729.5 6862.68 1725.2 6866.98 1718.04 C 6872.71 1708 6888.47 1715.17 6899.94 1712.3 L 6902.8 1712.3 C 6907.1 1715.17 6914.27 1715.17 6920 1719.47 C 6937.2 1730.93 6914.27 1729.5 6925.74 1736.67 C 6950.1 1755.3 6991.66 1789.69 7017.46 1801.16 C 7047.55 1814.06 7071.92 1802.59 7099.15 1829.82 C 7104.88 1834.12 7100.58 1847.02 7106.31 1849.89 C 7110.61 1851.32 7113.48 1844.15 7116.35 1845.59 C 7127.81 1849.89 7132.11 1864.22 7140.71 1872.82 C 7143.58 1875.68 7152.18 1875.68 7150.74 1879.98 C 7134.98 1910.08 7152.18 1911.51 7156.48 1945.91 C 7157.91 1951.64 7152.18 1957.37 7152.18 1963.11 C 7149.31 1980.31 7170.81 1967.41 7177.97 1973.14 C 7196.6 1987.47 7166.51 2007.54 7175.11 2021.87 C 7183.71 2041.93 7218.1 2060.56 7220.97 2083.49 C 7222.4 2100.69 7209.5 2155.15 7210.94 2162.32 C 7223.83 2208.18 7255.36 2223.94 7272.56 2261.21 C 7268.26 2266.94 7263.96 2274.1 7258.23 2276.97 C 7252.5 2279.84 7248.2 2265.51 7241.03 2266.94 C 7238.17 2268.37 7236.73 2275.54 7233.87 2275.54 C 7222.4 2276.97 7209.5 2266.94 7199.47 2272.67 C 7192.3 2276.97 7203.77 2294.17 7196.6 2298.47 C 7166.51 2317.1 7156.48 2282.7 7134.98 2278.4 C 7132.11 2278.4 7137.84 2287 7137.84 2291.3 C 7137.84 2294.17 7139.28 2297.03 7137.84 2299.9 C 7136.41 2309.93 7127.81 2318.53 7130.68 2327.13 C 7130.68 2328.56 7131.71 2330.54 7130.1 2330.49 C 7123.87 2330.33 7113.48 2327.13 7104.88 2322.83 C 7100.58 2321.4 7096.28 2309.93 7094.85 2314.23 C 7091.98 2330 7130.68 2324.26 7133.54 2340.03 C 7136.41 2348.63 7116.35 2342.9 7107.75 2347.2 C 7106.31 2348.63 7112.05 2348.63 7114.91 2348.63 C 7116.35 2350.06 7132.11 2360.09 7123.51 2367.26 C 7122.08 2368.69 7120.65 2360.09 7117.78 2361.53 C 7116.35 2362.96 7122.08 2368.69 7119.21 2370.13 C 7107.75 2377.29 7074.78 2370.13 7069.05 2391.62 C 7069.05 2395.92 7077.65 2391.62 7080.52 2393.06 C 7090.55 2400.22 7099.15 2410.25 7103.45 2421.72 C 7112.05 2447.52 7069.05 2458.98 7067.62 2487.65 C 7066.19 2522.04 7113.48 2524.91 7124.95 2550.71 C 7126.38 2552.14 7096.28 2589.4 7090.55 2602.3 C 7081.95 2619.5 7079.08 2689.72 7061.89 2692.59 C 7059.02 2692.59 7059.02 2682.56 7056.15 2683.99 C 7046.12 2685.42 7060.45 2708.35 7050.42 2712.65 C 7046.12 2715.52 7047.55 2695.45 7043.25 2698.32 C 7041.82 2698.32 7041.82 2699.75 7041.82 2701.19 L 7040.39 2701.19 C 7037.52 2705.49 7043.25 2714.09 7038.96 2716.95 C 7034.66 2722.69 7017.46 2719.82 7013.16 2728.42 C 7008.86 2734.15 7010.29 2745.62 7003.13 2748.48 C 6994.53 2751.35 6981.63 2735.58 6975.9 2742.75 C 6970.16 2751.35 6991.66 2762.81 6987.36 2772.85 C 6983.06 2780.01 6973.03 2758.51 6967.3 2762.81 C 6960.13 2768.55 6968.73 2780.01 6967.3 2788.61 C 6965.86 2798.64 6964.43 2812.97 6954.4 2818.71 C 6945.8 2823.01 6935.77 2808.67 6925.74 2810.11 C 6920 2810.11 6938.63 2814.41 6940.07 2820.14 C 6941.5 2823.01 6934.33 2824.44 6931.47 2824.44 C 6928.6 2824.44 6935.77 2817.27 6932.9 2814.41 C 6930.03 2812.97 6924.3 2812.97 6922.87 2815.84 C 6921.44 2820.14 6931.47 2824.44 6928.6 2828.74 C 6925.74 2831.61 6917.14 2823.01 6912.84 2827.31 C 6909.97 2830.17 6920 2831.61 6921.44 2835.91 C 6921.44 2837.34 6915.7 2834.47 6914.27 2835.91 C 6911.4 2841.64 6914.27 2851.67 6909.97 2855.97 C 6904.24 2861.7 6882.74 2857.4 6888.47 2861.7 C 6897.07 2868.87 6922.87 2857.4 6920 2867.43 C 6915.7 2878.9 6902.8 2886.07 6895.64 2896.1 C 6892.77 2898.96 6889.91 2904.7 6885.61 2906.13 C 6881.31 2907.56 6872.71 2906.13 6872.71 2901.83 C 6874.14 2897.53 6884.17 2900.4 6885.61 2896.1 C 6889.91 2887.5 6874.14 2898.96 6868.41 2900.4 C 6869.84 2904.7 6872.71 2909 6875.57 2913.3 C 6879.87 2923.33 6887.04 2950.56 6875.57 2947.69 C 6872.71 2947.69 6874.14 2933.36 6871.28 2936.23 C 6866.98 2943.39 6872.71 2954.86 6866.98 2962.02 C 6865.54 2966.32 6858.38 2960.59 6854.08 2960.59 C 6844.04 2962.02 6831.15 2960.59 6822.55 2966.32 C 6799.62 2983.52 6838.31 2990.69 6855.51 3010.75 C 6856.94 3012.18 6849.78 3013.62 6848.34 3012.18 C 6848.34 3010.75 6844.04 3010.75 6844.04 3012.18 C 6842.61 3023.65 6845.48 3035.12 6844.04 3046.58 C 6842.61 3053.75 6836.88 3059.48 6835.45 3066.64 C 6834.01 3075.24 6834.01 3083.84 6836.88 3092.44 C 6836.88 3093.87 6841.18 3089.58 6842.61 3091.01 C 6848.34 3101.04 6864.11 3115.37 6855.51 3123.97 C 6846.91 3132.57 6834.01 3108.21 6822.55 3112.51 C 6789.58 3123.97 6845.48 3154.07 6841.18 3185.6 C 6841.18 3191.33 6826.85 3182.73 6826.85 3187.03 C 6825.41 3194.2 6836.88 3195.63 6838.31 3201.36 C 6839.75 3204.23 6832.58 3202.8 6832.58 3205.66 C 6832.58 3211.39 6832.58 3218.56 6835.45 3224.29 C 6836.88 3230.03 6835.45 3237.19 6838.31 3242.92 C 6839.75 3245.79 6845.48 3240.06 6845.48 3242.92 C 6846.91 3244.36 6839.75 3244.36 6838.31 3245.79 C 6836.88 3248.66 6836.88 3252.96 6838.31 3255.82 C 6841.18 3262.99 6851.21 3267.29 6852.64 3275.89 C 6854.08 3284.49 6845.48 3293.08 6846.91 3301.68 C 6846.91 3304.55 6851.21 3300.25 6854.08 3301.68 C 6858.38 3303.12 6855.51 3313.15 6859.81 3313.15 C 6875.57 3313.15 6905.67 3304.55 6920 3313.15 C 6925.74 3316.02 6920 3326.05 6922.87 3331.78 C 6927.17 3340.38 6935.77 3346.11 6944.37 3351.84 C 6945.8 3353.28 6951.53 3347.55 6952.97 3350.41 C 6955.83 3353.28 6948.67 3359.01 6951.53 3360.44 C 6952.97 3360.44 7026.06 3331.78 6987.36 3374.78 C 6981.63 3381.94 6968.73 3361.88 6960.13 3364.74 C 6952.97 3367.61 6970.16 3373.34 6974.46 3379.07 C 6980.2 3387.67 6981.63 3400.57 6990.23 3406.3 C 6994.53 3407.74 6997.39 3391.97 7003.13 3394.84 C 7010.29 3397.71 7005.99 3410.6 7011.73 3414.9 C 7033.22 3439.27 7048.99 3423.5 7044.69 3462.2 C 7043.25 3476.53 7030.36 3460.77 7028.92 3460.77 C 7021.76 3462.2 7020.32 3470.8 7014.59 3475.1 C 7001.69 3489.43 7014.59 3502.33 6974.46 3520.96 C 6973.03 3522.39 6981.63 3535.29 6981.63 3536.72 C 6978.76 3541.02 6971.6 3533.86 6965.86 3535.29 C 6955.83 3536.72 6945.8 3545.32 6934.33 3545.32 C 6922.87 3545.32 6932.9 3523.82 6932.9 3513.79 C 6934.33 3503.76 6925.74 3505.19 6921.44 3499.46 C 6921.44 3498.03 6922.87 3495.16 6921.44 3492.29 C 6915.7 3483.7 6914.27 3470.8 6904.24 3466.5 C 6897.07 3463.63 6887.04 3470.8 6882.74 3477.96 C 6881.31 3482.26 6894.21 3476.53 6895.64 3479.4 C 6901.37 3489.43 6897.07 3502.33 6902.8 3510.93 C 6907.1 3518.09 6928.6 3516.66 6924.3 3523.82 C 6907.1 3556.79 6865.54 3506.63 6856.94 3509.49 C 6845.48 3512.36 6839.75 3528.12 6826.85 3528.12 C 6818.25 3528.12 6816.81 3509.49 6808.22 3510.93 C 6801.05 3512.36 6808.22 3526.69 6803.92 3533.86 C 6802.48 3536.72 6798.18 3530.99 6793.88 3530.99 C 6782.42 3532.42 6769.52 3532.42 6759.49 3538.16 C 6756.62 3539.59 6763.79 3543.89 6766.65 3546.76 C 6778.12 3553.92 6792.45 3542.46 6801.05 3539.59 C 6815.38 3538.16 6829.71 3556.79 6842.61 3552.49 C 6848.34 3549.62 6831.15 3532.42 6838.31 3533.86 C 6846.91 3533.86 6849.78 3549.62 6858.38 3553.92 C 6866.98 3556.79 6879.87 3546.76 6887.04 3553.92 C 6891.34 3558.22 6875.57 3566.82 6878.44 3573.99 C 6881.31 3578.28 6892.77 3575.42 6897.07 3571.12 C 6899.94 3568.25 6888.47 3561.09 6891.34 3559.65 C 6898.51 3556.79 6904.24 3565.39 6909.97 3566.82 C 6921.44 3569.69 6931.47 3576.85 6941.5 3572.55 C 6948.67 3569.69 6942.93 3553.92 6948.67 3549.62 C 6955.83 3545.32 6965.86 3553.92 6973.03 3549.62 C 6983.06 3545.32 6984.5 3526.69 6995.96 3525.26 C 7004.56 3523.82 7018.89 3538.16 7014.59 3545.32 C 7007.43 3555.35 6990.23 3545.32 6978.76 3549.62 C 6977.33 3549.62 6981.63 3553.92 6983.06 3555.35 C 6987.36 3563.95 6995.96 3572.55 6995.96 3582.58 C 6997.39 3585.45 6988.79 3581.15 6985.93 3584.02 C 6975.9 3589.75 6964.43 3595.48 6958.7 3605.52 C 6952.97 3615.55 6957.26 3628.45 6952.97 3638.48 C 6950.1 3644.21 6945.8 3616.98 6938.63 3619.85 C 6934.33 3622.71 6945.8 3638.48 6941.5 3635.61 C 6927.17 3629.88 6947.23 3581.15 6924.3 3584.02 C 6924.3 3584.02 6928.6 3647.08 6902.8 3665.71 C 6894.21 3671.44 6881.31 3667.14 6871.28 3668.57 C 6866.98 3670.01 6882.74 3672.87 6882.74 3677.17 C 6888.47 3694.37 6866.98 3682.91 6864.11 3685.77 C 6861.24 3687.21 6872.71 3687.21 6872.71 3691.51 C 6874.14 3692.94 6868.41 3690.07 6865.54 3691.51 C 6864.11 3692.94 6862.68 3695.8 6861.24 3695.8 C 6858.38 3695.8 6785.29 3685.77 6791.02 3698.67 C 6792.45 3701.54 6796.75 3701.54 6801.05 3701.54 C 6802.48 3701.54 6803.92 3697.24 6805.35 3697.24 C 6808.22 3698.67 6808.22 3707.27 6812.52 3705.84 C 6815.38 3705.84 6811.08 3697.24 6815.38 3697.24 C 6838.31 3691.51 6856.94 3697.24 6866.98 3720.17 C 6866.98 3723.03 6859.81 3718.74 6858.38 3720.17 C 6852.64 3725.9 6865.54 3734.5 6849.78 3734.5 C 6838.31 3734.5 6823.98 3718.74 6816.81 3727.33 C 6809.65 3735.93 6838.31 3731.63 6846.91 3737.37 C 6852.64 3741.67 6864.11 3767.46 6859.81 3774.63 C 6856.94 3780.36 6842.61 3770.33 6841.18 3776.06 C 6839.75 3783.23 6871.28 3821.92 6861.24 3834.82 C 6854.08 3843.42 6836.88 3830.52 6826.85 3834.82 C 6822.55 3834.82 6828.28 3840.55 6831.15 3843.42 C 6836.88 3850.59 6859.81 3857.75 6859.81 3869.22 C 6859.81 3879.25 6841.18 3884.98 6842.61 3896.45 C 6842.61 3905.05 6856.94 3905.05 6862.68 3912.21 C 6864.11 3915.08 6856.94 3915.08 6855.51 3916.51 C 6849.78 3926.54 6844.04 3938.01 6842.61 3949.47 C 6839.75 3958.07 6859.81 3989.6 6858.38 3992.47 C 6855.51 3995.34 6848.34 3989.6 6844.04 3993.9 C 6832.58 4005.37 6856.94 4028.3 6852.64 4046.93 C 6852.64 4051.23 6841.18 4046.93 6839.75 4051.23 C 6836.88 4055.53 6846.91 4061.26 6844.04 4065.56 C 6828.28 4112.86 6835.45 4031.17 6828.28 4079.89 C 6823.98 4109.99 6822.55 4157.28 6798.18 4180.21 C 6796.75 4181.65 6792.45 4180.21 6791.02 4177.35 C 6791.02 4174.48 6795.32 4171.62 6793.88 4168.75 C 6793.88 4164.45 6769.52 4167.32 6769.52 4167.32 C 6768.09 4165.88 6772.39 4160.15 6770.95 4160.15 C 6756.62 4161.58 6755.19 4168.75 6748.02 4175.91 C 6735.12 4185.95 6743.72 4164.45 6739.42 4165.88 C 6729.39 4171.62 6716.49 4174.48 6713.63 4174.48 C 6706.46 4175.91 6700.73 4173.05 6693.56 4173.05 C 6687.83 4173.05 6679.23 4168.75 6677.8 4174.48 C 6674.93 4183.08 6690.7 4191.68 6686.4 4198.85 C 6679.23 4206.01 6666.33 4197.41 6656.3 4200.28 C 6647.7 4203.15 6646.27 4213.18 6641.97 4220.34 C 6604.71 4274.8 6652 4257.61 6650.57 4294.87 C 6649.13 4306.33 6641.97 4316.37 6633.37 4324.96 C 6626.2 4332.13 6603.27 4317.8 6598.97 4317.8 C 6564.58 4314.93 6574.61 4339.3 6538.78 4339.3 C 6527.32 4339.3 6517.28 4332.13 6507.25 4330.7 C 6501.52 4330.7 6492.92 4335 6487.19 4332.13 C 6477.15 4326.4 6502.95 4322.1 6502.95 4322.1 C 6502.95 4313.5 6494.35 4306.33 6495.79 4297.73 C 6495.79 4289.14 6507.25 4284.84 6510.12 4277.67 C 6510.12 4277.67 6484.32 4241.84 6464.26 4210.31 C 6462.82 4216.04 6455.66 4221.78 6455.66 4228.94 C 6457.09 4259.04 6485.75 4256.17 6454.22 4284.84 C 6454.22 4286.27 6454.22 4286.27 6452.79 4286.27 M 6901.37 3930.84 C 6904.24 3926.54 6909.97 3927.98 6914.27 3926.54 C 6904.24 3949.47 6884.17 4048.36 6879.87 4078.46 C 6878.44 4085.63 6884.17 4141.52 6865.54 4142.95 C 6862.68 4142.95 6856.94 4078.46 6856.94 4074.16 C 6859.81 4032.6 6888.47 4011.1 6895.64 3972.41 C 6898.51 3955.21 6888.47 3948.04 6901.37 3930.84 M 7094.85 3892.15 C 7094.85 3900.75 7083.38 3902.18 7077.65 3907.91 C 7059.02 3929.41 7091.98 3913.65 7064.75 3935.14 C 7043.25 3950.91 7056.15 3950.91 7044.69 3972.41 C 7040.39 3979.57 7030.36 4001.07 7026.06 3992.47 C 7021.76 3983.87 7033.22 3972.41 7037.52 3962.37 C 7036.09 3963.81 7034.66 3966.67 7033.22 3966.67 C 7031.79 3966.67 7031.79 3962.37 7031.79 3960.94 C 7030.36 3950.91 7016.02 3933.71 7016.02 3930.84 C 7016.02 3922.24 7021.76 3913.65 7021.76 3905.05 C 7020.32 3895.01 7011.73 3887.85 7011.73 3877.82 C 7010.29 3870.65 7053.29 3801.86 7059.02 3798.99 C 7069.05 3794.69 7080.52 3798.99 7090.55 3797.56 C 7106.31 3820.49 7087.68 3823.36 7074.78 3853.45 C 7059.02 3890.72 7094.85 3879.25 7094.85 3892.15 M 7044.69 2716.95 C 7044.69 2719.82 7044.69 2715.52 7043.25 2711.22 C 7044.69 2712.65 7044.69 2715.52 7044.69 2716.95 M 6404.06 4257.61 L 6402.63 4253.31 C 6402.63 4244.71 6399.76 4238.97 6395.46 4236.11 L 6394.03 4230.38 C 6396.9 4230.38 6399.76 4231.81 6401.2 4234.67 C 6402.63 4240.41 6404.06 4249.01 6404.06 4257.61 " }
                }
            }
            // PATH visit dk count: 398
            DemoShape {
                objectName: "dk"
                ShapePath {
                    objectName: "svg_path:dk"
                    // boundingRect: 5979.04, 3895.01 481.94x581.976
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6123.16 4443.92 C 6104.53 4441.05 6085.9 4431.02 6067.27 4428.15 C 6062.97 4428.15 6045.77 4429.59 6035.74 4428.15 C 6035.74 4420.99 6035.74 4413.82 6037.17 4405.22 C 6037.17 4398.06 6048.64 4389.46 6042.91 4383.72 C 6048.64 4376.56 6040.04 4365.09 6040.04 4355.06 C 6038.61 4346.46 6042.91 4333.56 6037.17 4327.83 C 6024.27 4314.93 5987.01 4329.26 5979.85 4303.47 C 5975.55 4287.7 5989.88 4270.5 5989.88 4251.87 L 5992.74 4254.74 C 6037.17 4276.24 6008.51 4218.91 6005.64 4213.18 C 6004.21 4210.31 6002.78 4201.71 5998.48 4204.58 C 5991.31 4207.44 5992.74 4220.34 5985.58 4221.78 C 5981.28 4223.21 5984.15 4211.74 5984.15 4207.44 C 5985.58 4197.41 5988.45 4187.38 5988.45 4178.78 C 5989.88 4170.18 5981.28 4158.72 5988.45 4152.98 C 5989.88 4151.55 5992.74 4150.12 5994.18 4150.12 C 5992.74 4147.25 5987.01 4085.63 6001.34 4091.36 C 6009.94 4094.22 6004.21 4108.56 6008.51 4115.72 C 6021.41 4145.82 6083.03 4071.29 6085.9 4071.29 C 6116 4062.69 6081.6 4109.99 6087.33 4117.16 C 6093.07 4124.32 6104.53 4118.59 6114.56 4115.72 C 6111.7 4115.72 6110.26 4115.72 6110.26 4114.29 C 6107.4 4107.12 6116 4098.52 6111.7 4092.79 C 6108.83 4088.49 6100.23 4099.96 6098.8 4095.66 C 6095.93 4089.93 6107.4 4085.63 6107.4 4079.89 C 6108.83 4046.93 6087.33 4056.96 6114.56 4036.9 C 6120.3 4031.17 6137.49 4032.6 6141.79 4036.9 C 6144.66 4039.76 6137.49 4052.66 6140.36 4049.8 C 6146.09 4044.06 6146.09 4031.17 6153.26 4026.87 C 6158.99 4024 6166.16 4026.87 6171.89 4026.87 C 6179.06 4031.17 6213.45 4039.76 6213.45 4039.76 C 6216.32 4048.36 6209.15 4058.4 6210.59 4068.43 C 6210.59 4075.59 6222.05 4082.76 6219.18 4089.93 C 6216.32 4095.66 6206.29 4088.49 6200.55 4089.93 C 6191.95 4091.36 6222.05 4097.09 6220.62 4105.69 C 6220.62 4108.56 6219.18 4109.99 6219.18 4111.42 C 6224.92 4112.86 6226.35 4125.75 6233.52 4127.19 C 6250.71 4131.49 6276.51 4107.12 6283.68 4140.09 C 6286.54 4151.55 6252.15 4208.88 6240.68 4203.15 C 6230.65 4197.41 6230.65 4178.78 6219.18 4174.48 C 6206.29 4170.18 6207.72 4244.71 6203.42 4253.31 C 6196.25 4271.94 6184.79 4284.84 6164.72 4284.84 C 6154.69 4284.84 6133.19 4269.07 6136.06 4279.1 C 6140.36 4289.13 6163.29 4283.4 6169.02 4294.87 L 6169.02 4299.17 L 6171.89 4299.17 C 6177.62 4299.17 6179.06 4309.2 6183.36 4309.2 C 6199.12 4304.9 6210.59 4280.54 6226.35 4286.27 C 6234.95 4290.57 6239.25 4303.47 6249.28 4304.9 C 6255.01 4306.33 6256.45 4296.3 6260.75 4293.43 C 6286.54 4346.46 6255.01 4300.6 6265.05 4320.66 C 6273.64 4336.43 6300.88 4402.36 6247.85 4396.62 C 6236.38 4395.19 6226.35 4386.59 6214.89 4383.72 C 6210.59 4383.72 6203.42 4390.89 6199.12 4386.59 C 6187.65 4377.99 6227.78 4380.86 6204.85 4367.96 C 6169.02 4349.33 6204.85 4380.86 6193.39 4380.86 C 6189.09 4380.86 6179.06 4337.86 6179.06 4336.43 C 6174.76 4326.4 6160.42 4320.66 6157.56 4309.2 C 6157.56 4307.77 6158.99 4307.77 6158.99 4307.77 C 6147.53 4312.07 6131.76 4314.93 6131.76 4316.37 C 6128.9 4322.1 6146.09 4316.37 6148.96 4322.1 C 6150.39 4326.4 6140.36 4327.83 6140.36 4332.13 C 6138.93 4340.73 6140.36 4349.33 6143.23 4356.49 C 6144.66 4360.79 6151.83 4362.23 6151.83 4366.53 C 6151.83 4382.29 6126.03 4388.02 6123.16 4403.79 C 6123.16 4409.52 6134.63 4400.92 6138.93 4403.79 C 6148.96 4410.95 6157.56 4420.99 6158.99 4432.45 C 6160.42 4438.18 6148.96 4420.99 6143.23 4422.42 C 6136.06 4425.29 6127.46 4438.18 6123.16 4443.92 M 6394.03 4206.01 L 6394.03 4207.44 C 6409.8 4195.98 6434.16 4201.71 6451.36 4204.58 C 6452.79 4207.44 6458.52 4210.31 6458.52 4213.18 C 6457.09 4221.78 6448.49 4227.51 6448.49 4236.11 C 6449.92 4264.77 6472.86 4263.34 6452.79 4286.27 C 6445.63 4293.43 6434.16 4294.87 6426.99 4302.03 C 6414.1 4316.37 6429.86 4320.66 6442.76 4327.83 L 6451.36 4349.33 C 6439.89 4359.36 6408.36 4355.06 6408.36 4367.96 C 6409.8 4383.72 6444.19 4405.22 6408.36 4406.65 C 6395.46 4406.65 6385.43 4398.06 6373.97 4392.32 C 6379.7 4395.19 6386.87 4398.06 6388.3 4393.76 C 6391.16 4383.72 6382.57 4372.26 6375.4 4363.66 C 6372.53 4360.79 6371.1 4369.39 6368.23 4369.39 C 6359.64 4369.39 6353.9 4362.23 6346.74 4360.79 C 6339.57 4359.36 6332.4 4365.09 6326.67 4363.66 C 6323.81 4363.66 6323.81 4359.36 6323.81 4357.93 C 6332.4 4335 6306.61 4340.73 6308.04 4336.43 C 6309.47 4330.7 6319.51 4332.13 6320.94 4326.4 C 6326.67 4284.84 6313.77 4296.3 6290.84 4276.24 C 6287.98 4273.37 6279.38 4266.2 6283.68 4264.77 C 6296.58 4257.61 6365.37 4273.37 6352.47 4228.94 C 6349.6 4218.91 6333.84 4221.78 6325.24 4216.04 C 6320.94 4213.18 6335.27 4218.91 6339.57 4218.91 C 6346.74 4221.78 6353.9 4224.64 6361.07 4224.64 C 6382.57 4224.64 6416.96 4214.61 6409.8 4259.04 C 6408.36 4266.2 6389.73 4273.37 6395.46 4277.67 C 6421.26 4299.17 6412.66 4247.57 6408.36 4227.51 C 6406.93 4218.91 6384 4226.08 6386.87 4218.91 C 6388.3 4213.18 6391.16 4210.31 6394.03 4206.01 M 6422.69 4435.32 L 6415.53 4435.32 L 6415.53 4438.18 C 6416.96 4441.05 6415.53 4442.48 6415.53 4443.92 C 6411.23 4446.78 6405.5 4451.08 6404.06 4453.95 C 6399.76 4456.82 6396.9 4459.68 6395.46 4463.98 L 6394.03 4465.41 L 6394.03 4466.85 L 6394.03 4463.98 C 6385.43 4463.98 6375.4 4462.55 6371.1 4463.98 C 6363.93 4465.41 6358.2 4478.31 6349.6 4476.88 C 6338.14 4475.45 6332.4 4461.12 6322.37 4455.38 C 6315.21 4451.08 6305.17 4448.22 6299.44 4442.48 C 6295.14 4439.62 6310.91 4436.75 6325.24 4410.95 C 6345.3 4428.15 6375.4 4432.45 6392.6 4446.78 L 6394.03 4448.22 C 6385.43 4435.32 6366.8 4425.29 6373.97 4413.82 C 6376.83 4408.09 6385.43 4410.95 6389.73 4409.52 C 6399.76 4419.55 6421.26 4418.12 6424.13 4431.02 C 6424.13 4432.45 6424.13 4433.88 6422.69 4435.32 M 5989.88 4226.08 L 5989.88 4237.54 C 5988.45 4228.94 5988.45 4220.34 5989.88 4226.08 M 6240.68 3952.34 C 6244.98 3968.11 6230.65 4045.5 6204.85 4036.9 C 6196.25 4034.03 6189.09 4024 6179.06 4024 C 6189.09 4011.1 6146.09 4021.13 6134.63 4024 C 6124.6 4026.87 6116 4035.46 6105.96 4036.9 C 6101.67 4036.9 6098.8 4029.73 6094.5 4029.73 C 6083.03 4028.3 6071.57 4029.73 6061.54 4032.6 C 6057.24 4034.03 6060.1 4042.63 6055.8 4045.5 C 6035.74 4054.1 6057.24 3996.77 6028.57 4072.73 C 6027.14 4074.16 6035.74 4114.29 6034.31 4114.29 C 5987.01 4112.86 6012.81 4024 6040.04 4013.97 C 6064.4 4002.5 6098.8 4015.4 6123.16 4005.37 C 6156.13 3989.6 6148.96 3943.74 6179.06 3926.54 C 6189.09 3922.24 6201.99 3925.11 6212.02 3920.81 C 6222.05 3915.08 6227.78 3895.01 6239.25 3895.01 C 6260.75 3895.01 6227.78 3910.78 6226.35 3923.68 C 6223.48 3943.74 6233.52 3930.84 6240.68 3952.34 M 6372.53 4439.62 L 6359.64 4441.05 C 6369.67 4443.92 6378.27 4448.22 6385.43 4455.38 L 6386.87 4455.38 C 6382.57 4449.65 6376.83 4445.35 6372.53 4439.62 " }
                }
            }
            // START gb type: G 1
            Item { // structure node
                objectName: "gb"
                // PATH visit gb-nir count: 74
                DemoShape {
                    objectName: "gb-nir"
                    // Translate -2.36538e-05, 0
                    x: -2.36538e-05
                    y: 0
                    ShapePath {
                        objectName: "svg_path:gb-nir"
                        // boundingRect: 4213.87, 4152.48 293.249x235.614
                        strokeColor: "#aa805d"
                        strokeWidth: 4.58365
                        fillColor: "#fffff7df"
                        fillRule: ShapePath.WindingFill
                        PathSvg { path: "M 4338.97 4169.72 C 4343.27 4175.45 4349 4179.75 4354.73 4176.88 C 4363.33 4172.58 4366.2 4158.25 4374.8 4153.95 C 4383.4 4148.22 4393.43 4161.12 4402.03 4159.69 C 4412.06 4159.69 4419.23 4152.52 4427.82 4153.95 C 4437.86 4155.39 4443.59 4165.42 4452.19 4168.29 C 4456.49 4171.15 4465.09 4165.42 4466.52 4169.72 C 4472.25 4179.75 4475.12 4194.08 4472.25 4205.55 C 4472.25 4209.85 4466.52 4211.28 4466.52 4214.15 C 4482.28 4275.77 4475.12 4195.52 4492.32 4249.98 C 4498.05 4265.74 4460.79 4287.24 4460.79 4287.24 C 4485.15 4281.51 4510.95 4262.87 4506.65 4320.2 C 4500.92 4376.09 4460.79 4346 4449.32 4358.9 C 4439.29 4368.93 4446.46 4391.86 4420.66 4387.56 C 4414.93 4387.56 4410.63 4381.83 4406.33 4377.53 L 4400.59 4370.36 C 4379.1 4357.46 4409.19 4390.43 4360.47 4373.23 C 4353.3 4371.8 4363.33 4358.9 4366.2 4351.73 C 4367.63 4341.7 4353.3 4344.56 4350.43 4338.83 C 4343.27 4324.5 4350.43 4290.1 4334.67 4292.97 C 4273.04 4301.57 4351.87 4330.23 4285.94 4335.97 C 4264.44 4337.4 4208.55 4262.87 4214.28 4255.71 C 4215.72 4255.71 4271.61 4241.38 4271.61 4241.38 C 4274.48 4232.78 4255.84 4228.48 4254.41 4219.88 C 4251.54 4211.28 4288.81 4222.75 4293.11 4219.88 C 4316.04 4205.55 4307.44 4169.72 4338.97 4169.72 " }
                    }
                }
                // PATH visit gb-main count: 901
                DemoShape {
                    objectName: "gb-main"
                    ShapePath {
                        objectName: "svg_path:gb-main"
                        // boundingRect: 4309.6, 3292.84 941.871x1863.96
                        strokeColor: "#aa805d"
                        strokeWidth: 4.58365
                        fillColor: "#fffff7df"
                        fillRule: ShapePath.WindingFill
                        PathSvg { path: "M 4586.2 4531.94 C 4611.99 4552.01 4633.49 4563.47 4606.26 4576.37 M 4590.5 4583.54 C 4586.2 4586.4 4581.9 4587.84 4577.6 4587.84 C 4573.3 4587.84 4581.9 4582.1 4580.46 4579.24 C 4571.87 4549.14 4550.37 4543.41 4586.2 4531.94 M 4733.81 3558.82 C 4742.41 3563.12 4761.04 3571.72 4762.48 3581.75 C 4762.48 3588.92 4742.41 3601.82 4748.14 3597.52 C 4756.74 3591.79 4759.61 3574.59 4769.64 3576.02 C 4778.24 3578.89 4768.21 3597.52 4775.38 3603.25 C 4781.11 3607.55 4783.97 3591.79 4789.71 3590.35 C 4811.2 3584.62 4859.93 3593.22 4888.6 3597.52 C 4900.06 3598.95 4915.83 3588.92 4922.99 3597.52 C 4930.16 3604.69 4911.53 3611.85 4907.23 3620.45 C 4904.36 3629.05 4907.23 3637.65 4904.36 3646.25 C 4901.49 3653.41 4811.2 3707.87 4794.01 3720.77 C 4765.34 3742.27 4806.9 3717.91 4821.24 3729.37 C 4826.97 3732.24 4814.07 3737.97 4808.34 3742.27 C 4804.04 3746.57 4801.17 3753.73 4794.01 3755.17 C 4791.14 3755.17 4794.01 3745.14 4791.14 3745.14 C 4785.41 3743.7 4781.11 3749.44 4776.81 3750.87 C 4766.78 3755.17 4765.34 3743.7 4761.04 3753.73 C 4749.58 3779.53 4776.81 3788.13 4783.97 3779.53 C 4785.41 3776.67 4778.24 3772.37 4781.11 3772.37 C 4788.27 3770.93 4795.44 3776.67 4804.04 3776.67 C 4819.8 3775.23 4839.87 3758.03 4859.93 3762.33 C 4869.96 3763.77 4878.56 3773.8 4888.6 3776.67 C 4912.96 3783.83 4993.22 3782.4 5006.11 3811.06 C 5008.98 3819.66 5010.41 3828.26 5007.55 3836.86 L 4974.58 3869.82 C 4970.29 3875.55 4967.42 3882.72 4965.99 3889.89 C 4964.55 3892.75 4967.42 3895.62 4965.99 3897.05 C 4954.52 3918.55 4894.33 4003.11 4875.7 4004.54 C 4847.03 4007.41 4837 3993.07 4812.64 4011.7 C 4808.34 4014.57 4821.24 4016 4825.54 4014.57 C 4837 4013.14 4847.03 4005.97 4857.07 4004.54 C 4877.13 4003.11 4861.37 4017.44 4862.8 4021.74 C 4867.1 4031.77 4885.73 4034.64 4884.3 4044.67 C 4880 4076.2 4849.9 4048.97 4841.3 4050.4 C 4796.87 4057.57 4877.13 4076.2 4783.97 4069.03 C 4782.54 4069.03 4782.54 4084.8 4783.97 4084.8 C 4794.01 4089.1 4782.54 4080.5 4792.57 4081.93 C 4804.04 4084.8 4828.4 4103.43 4841.3 4094.83 C 4847.03 4090.53 4848.47 4080.5 4854.2 4077.63 C 4857.07 4076.2 4911.53 4116.33 4917.26 4122.06 C 4927.29 4129.22 4931.59 4165.05 4941.62 4176.52 C 4947.35 4182.25 4955.95 4183.68 4960.25 4189.42 C 4961.69 4192.28 4958.82 4195.15 4958.82 4199.45 C 4957.39 4208.05 4957.39 4218.08 4957.39 4226.68 C 4958.82 4252.48 4968.85 4358.53 4977.45 4380.03 C 4978.88 4382.89 4981.75 4374.3 4984.62 4375.73 C 4990.35 4377.16 4994.65 4384.33 5000.38 4387.19 C 5026.18 4402.96 5020.45 4390.06 5044.81 4420.16 C 5053.41 4430.19 5049.11 4447.39 5056.28 4458.85 C 5063.44 4474.62 5083.51 4460.29 5083.51 4488.95 C 5083.51 4497.55 5067.74 4497.55 5066.31 4506.15 C 5060.57 4529.08 5087.81 4562.04 5093.54 4582.1 C 5100.7 4609.33 5077.77 4569.21 5076.34 4599.3 C 5076.34 4606.47 5127.93 4660.93 5102.14 4688.16 C 5082.07 4708.22 5073.47 4685.29 5059.14 4721.12 C 5057.71 4725.42 5069.17 4719.69 5072.04 4722.55 C 5077.77 4726.85 5079.21 4735.45 5083.51 4739.75 C 5087.81 4744.05 5094.97 4751.22 5099.27 4748.35 C 5127.93 4729.72 5106.44 4711.09 5136.53 4715.39 C 5185.26 4722.55 5264.08 4744.05 5249.75 4821.44 C 5245.45 4845.81 5212.49 4910.3 5188.13 4918.9 C 5179.53 4921.76 5166.63 4904.57 5163.76 4911.73 C 5150.86 4937.53 5218.22 4930.36 5160.9 4946.13 C 5156.6 4947.56 5153.73 4944.7 5149.43 4941.83 C 5148 4941.83 5148 4938.96 5146.56 4938.96 C 5135.1 4940.4 5117.9 4937.53 5112.17 4946.13 C 5107.87 4954.73 5133.67 4943.26 5139.4 4950.43 C 5145.13 4956.16 5140.83 4967.63 5136.53 4974.79 C 5125.07 4993.42 5093.54 4980.52 5077.77 4986.26 C 5073.47 4987.69 5062.01 4991.99 5066.31 4994.86 C 5067.74 4994.86 5109.3 4981.96 5107.87 5000.59 C 5106.44 5007.75 5090.67 4999.16 5084.94 5003.46 C 5080.64 5007.75 5096.4 5014.92 5102.14 5012.05 C 5105 5009.19 5105 5000.59 5109.3 5000.59 C 5115.04 4999.16 5120.77 5004.89 5126.5 5009.19 C 5146.56 5027.82 5084.94 5017.79 5126.5 5024.95 C 5146.56 5027.82 5168.06 5012.05 5189.56 5020.65 C 5195.29 5022.09 5180.96 5029.25 5179.53 5034.98 C 5176.66 5045.02 5178.09 5055.05 5176.66 5066.51 C 5172.36 5080.85 5146.56 5075.11 5132.23 5082.28 C 5126.5 5086.58 5130.8 5100.91 5123.63 5103.78 C 5097.84 5112.38 5110.74 5089.45 5094.97 5099.48 C 5079.21 5109.51 5064.87 5105.21 5049.11 5112.38 C 5041.94 5115.24 5039.08 5126.71 5030.48 5126.71 C 5017.58 5126.71 4994.65 5102.34 4981.75 5099.48 C 4971.72 5098.04 4900.06 5115.24 4895.76 5099.48 C 4894.33 5092.31 4914.39 5098.04 4900.06 5088.01 C 4891.46 5082.28 4895.76 5095.18 4892.89 5099.48 C 4890.03 5100.91 4885.73 5098.04 4884.3 5095.18 C 4884.3 5090.88 4894.33 5086.58 4890.03 5086.58 C 4885.73 5085.15 4881.43 5095.18 4877.13 5093.74 C 4872.83 5092.31 4881.43 5085.15 4878.56 5080.85 C 4868.53 5067.95 4874.26 5093.74 4869.96 5092.31 C 4852.77 5086.58 4839.87 5057.92 4835.57 5062.21 C 4829.84 5069.38 4847.03 5079.41 4845.6 5088.01 C 4844.17 5102.34 4763.91 5083.71 4761.04 5088.01 C 4756.74 5095.18 4771.08 5105.21 4769.64 5113.81 C 4768.21 5118.11 4761.04 5112.38 4756.74 5112.38 L 4755.31 5112.38 C 4748.14 5108.08 4725.21 5092.31 4718.05 5095.18 C 4709.45 5099.48 4712.32 5112.38 4708.02 5119.54 C 4705.15 5122.41 4710.88 5110.94 4709.45 5106.64 C 4706.58 5099.48 4699.42 5093.74 4692.25 5088.01 C 4673.62 5069.38 4619.16 5056.48 4593.36 5066.51 C 4593.36 5066.51 4577.6 5135.31 4556.1 5145.34 C 4538.9 5152.5 4508.81 5110.94 4497.34 5105.21 C 4490.17 5100.91 4511.67 5118.11 4493.04 5113.81 C 4475.84 5109.51 4451.48 5092.31 4431.42 5098.04 C 4424.25 5099.48 4427.12 5112.38 4421.38 5115.24 C 4412.78 5118.11 4402.75 5112.38 4392.72 5112.38 C 4391.29 5112.38 4389.85 5112.38 4388.42 5113.81 C 4385.55 5120.97 4368.36 5156.8 4362.62 5156.8 C 4354.02 5155.37 4358.32 5136.74 4352.59 5129.57 C 4343.99 5115.24 4309.6 5125.27 4309.6 5109.51 C 4309.6 5099.48 4366.92 5096.61 4368.36 5096.61 C 4374.09 5095.18 4379.82 5089.45 4384.12 5083.71 C 4386.99 5082.28 4384.12 5076.55 4386.99 5075.11 C 4389.85 5072.25 4395.59 5076.55 4398.45 5075.11 C 4408.48 5066.51 4411.35 5053.62 4421.38 5046.45 C 4425.68 5043.58 4432.85 5049.32 4437.15 5047.88 C 4441.45 5045.02 4440.01 5039.28 4444.31 5036.42 C 4451.48 5029.25 4464.38 5027.82 4471.54 5019.22 C 4475.84 5013.49 4474.41 4980.52 4484.44 4976.22 C 4490.17 4974.79 4495.91 4986.26 4501.64 4987.69 C 4534.6 4990.56 4495.91 4940.4 4576.16 4954.73 C 4603.4 4959.03 4639.22 4996.29 4666.45 4974.79 C 4675.05 4967.63 4672.19 4953.29 4676.49 4944.7 C 4677.92 4941.83 4746.71 4898.83 4755.31 4888.8 C 4763.91 4878.77 4718.05 4908.87 4712.32 4913.17 C 4705.15 4916.03 4697.98 4917.47 4690.82 4918.9 C 4686.52 4918.9 4683.65 4911.73 4679.35 4913.17 C 4643.52 4923.2 4652.12 4953.29 4609.13 4928.93 C 4594.8 4918.9 4597.66 4894.53 4584.76 4881.64 C 4573.3 4870.17 4551.8 4895.97 4537.47 4888.8 C 4534.6 4887.37 4531.74 4842.94 4530.3 4838.64 C 4528.87 4835.77 4527.44 4844.37 4524.57 4844.37 C 4514.54 4845.81 4527.44 4834.34 4493.04 4844.37 C 4488.74 4844.37 4490.17 4852.97 4487.31 4855.84 C 4478.71 4858.71 4467.24 4861.57 4458.65 4858.71 C 4451.48 4857.27 4438.58 4848.67 4441.45 4842.94 C 4445.75 4834.34 4460.08 4840.07 4468.68 4838.64 C 4472.98 4837.21 4432.85 4835.77 4428.55 4830.04 C 4422.82 4821.44 4425.68 4809.98 4425.68 4799.95 C 4425.68 4771.28 4478.71 4787.05 4485.88 4784.18 C 4494.47 4781.31 4495.91 4766.98 4505.94 4765.55 C 4513.11 4765.55 4520.27 4772.72 4527.44 4771.28 C 4550.37 4765.55 4596.23 4726.85 4604.83 4706.79 C 4607.69 4701.06 4601.96 4645.16 4593.36 4636.56 C 4569 4606.47 4541.77 4692.46 4531.74 4633.7 C 4528.87 4623.67 4558.97 4622.23 4577.6 4607.9 C 4580.46 4603.6 4579.03 4596.44 4581.9 4592.14 C 4584.76 4587.84 4587.63 4584.97 4590.5 4583.54 C 4596.23 4579.24 4601.96 4577.8 4606.26 4576.37 C 4616.29 4576.37 4624.89 4580.67 4644.96 4573.51 C 4647.82 4572.07 4639.22 4562.04 4643.52 4563.47 C 4653.56 4564.91 4659.29 4576.37 4669.32 4577.8 C 4689.39 4580.67 4693.68 4562.04 4708.02 4574.94 C 4715.18 4582.1 4718.05 4603.6 4726.65 4597.87 C 4735.25 4592.14 4719.48 4576.37 4722.35 4566.34 C 4723.78 4560.61 4749.58 4563.47 4768.21 4586.4 C 4772.51 4590.7 4756.74 4586.4 4751.01 4583.54 C 4738.11 4576.37 4732.38 4554.87 4735.25 4539.11 C 4736.68 4530.51 4745.28 4523.34 4752.44 4517.61 C 4758.18 4513.31 4772.51 4517.61 4771.08 4510.45 C 4768.21 4501.85 4751.01 4501.85 4748.14 4493.25 C 4729.51 4453.12 4778.24 4484.65 4778.24 4467.45 C 4779.67 4458.85 4768.21 4463.15 4772.51 4453.12 C 4776.81 4443.09 4789.71 4435.92 4788.27 4424.46 C 4786.84 4402.96 4769.64 4441.65 4749.58 4443.09 C 4736.68 4443.09 4753.88 4415.86 4749.58 4404.39 C 4746.71 4398.66 4739.55 4415.86 4733.81 4414.42 C 4716.62 4408.69 4730.95 4392.93 4729.51 4384.33 L 4712.32 4348.5 C 4710.88 4331.3 4758.18 4284.01 4759.61 4284.01 C 4762.48 4285.44 4761.04 4292.6 4763.91 4291.17 C 4775.38 4288.31 4791.14 4285.44 4794.01 4275.41 C 4796.87 4266.81 4776.81 4275.41 4768.21 4273.97 C 4762.48 4272.54 4756.74 4265.37 4749.58 4266.81 C 4740.98 4269.67 4736.68 4281.14 4728.08 4284.01 C 4720.91 4286.87 4712.32 4281.14 4705.15 4282.57 C 4696.55 4285.44 4692.25 4292.6 4685.09 4295.47 C 4682.22 4296.9 4677.92 4296.9 4676.49 4294.04 C 4675.05 4289.74 4683.65 4282.57 4679.35 4281.14 C 4675.05 4279.71 4676.49 4289.74 4673.62 4292.6 C 4672.19 4294.04 4669.32 4292.6 4667.89 4291.17 C 4660.72 4282.57 4660.72 4261.08 4644.96 4258.21 C 4624.89 4253.91 4652.12 4278.27 4637.79 4301.2 C 4632.06 4309.8 4624.89 4286.87 4619.16 4278.27 C 4577.6 4223.81 4620.59 4286.87 4564.7 4253.91 C 4550.37 4245.31 4584.76 4252.48 4583.33 4245.31 C 4581.9 4212.35 4587.63 4215.21 4607.69 4192.28 C 4644.96 4150.72 4581.9 4199.45 4627.76 4157.89 C 4632.06 4153.59 4642.09 4153.59 4644.96 4147.86 C 4650.69 4137.82 4623.46 4104.86 4622.03 4101.99 C 4620.59 4097.69 4629.19 4097.69 4630.63 4093.39 C 4634.92 4083.36 4630.63 4070.46 4634.92 4059 C 4640.66 4046.1 4652.12 4060.43 4665.02 4066.16 C 4712.32 4087.66 4640.66 4053.27 4640.66 4050.4 C 4636.36 4041.8 4640.66 4030.34 4642.09 4018.87 C 4642.09 4011.7 4647.82 4003.11 4643.52 3997.37 C 4642.09 3995.94 4584.76 4027.47 4580.46 4031.77 C 4569 4041.8 4587.63 4061.87 4584.76 4077.63 C 4583.33 4083.36 4571.87 4081.93 4567.57 4086.23 C 4564.7 4089.1 4561.83 4093.39 4561.83 4097.69 C 4560.4 4101.99 4563.27 4107.73 4561.83 4110.59 C 4557.53 4122.06 4546.07 4127.79 4541.77 4139.26 C 4540.34 4142.12 4548.93 4147.86 4546.07 4149.29 C 4536.04 4155.02 4523.14 4159.32 4511.67 4155.02 C 4503.07 4150.72 4523.14 4139.26 4527.44 4132.09 C 4536.04 4120.62 4533.17 4101.99 4541.77 4090.53 L 4571.87 4064.73 C 4569 4057.57 4553.23 4067.6 4550.37 4060.43 C 4547.5 4054.7 4589.06 4030.34 4569 4026.04 C 4560.4 4023.17 4556.1 4044.67 4548.93 4040.37 C 4540.34 4033.2 4569 4027.47 4574.73 4017.44 C 4580.46 4005.97 4576.16 3980.17 4580.46 3970.14 C 4583.33 3961.54 4590.5 3952.94 4597.66 3951.51 C 4604.83 3950.08 4617.73 3965.84 4617.73 3958.68 C 4617.73 3951.51 4601.96 3951.51 4597.66 3944.35 C 4587.63 3924.28 4646.39 3914.25 4647.82 3914.25 C 4652.12 3909.95 4629.19 3915.68 4629.19 3909.95 C 4629.19 3901.35 4643.52 3899.92 4646.39 3891.32 C 4649.26 3887.02 4637.79 3894.18 4633.49 3898.48 C 4623.46 3905.65 4624.89 3908.52 4616.29 3912.82 C 4597.66 3922.85 4580.46 3938.61 4567.57 3932.88 C 4569 3935.75 4570.43 3937.18 4573.3 3938.61 C 4574.73 3941.48 4580.46 3944.35 4577.6 3947.21 C 4566.13 3957.24 4508.81 3977.31 4498.77 3957.24 C 4497.34 3955.81 4498.77 3951.51 4500.21 3951.51 C 4528.87 3940.05 4505.94 3983.04 4541.77 3934.31 C 4564.7 3904.22 4474.41 3919.98 4538.9 3898.48 C 4541.77 3904.22 4544.64 3909.95 4548.93 3914.25 C 4550.37 3917.12 4553.23 3919.98 4556.1 3921.41 C 4553.23 3917.12 4550.37 3911.38 4548.93 3904.22 C 4547.5 3899.92 4558.97 3904.22 4563.27 3904.22 C 4574.73 3904.22 4586.2 3909.95 4596.23 3905.65 C 4609.13 3899.92 4518.84 3901.35 4530.3 3884.15 C 4538.9 3872.69 4576.16 3888.45 4579.03 3882.72 C 4584.76 3868.39 4543.2 3851.19 4583.33 3841.16 C 4593.36 3838.29 4603.4 3851.19 4614.86 3848.32 C 4653.56 3839.72 4604.83 3813.93 4604.83 3813.93 C 4609.13 3803.9 4630.63 3816.79 4637.79 3808.19 C 4644.96 3799.6 4639.22 3785.26 4639.22 3773.8 C 4639.22 3765.2 4640.66 3756.6 4637.79 3750.87 C 4636.36 3748 4589.06 3697.84 4620.59 3684.94 C 4627.76 3680.64 4629.19 3707.87 4637.79 3705.01 C 4649.26 3702.14 4633.49 3669.18 4650.69 3679.21 C 4673.62 3692.11 4675.05 3693.54 4675.05 3692.11 C 4679.35 3673.48 4663.59 3672.04 4665.02 3653.41 C 4665.02 3646.25 4683.65 3662.01 4686.52 3654.85 C 4692.25 3644.81 4679.35 3631.92 4680.79 3621.88 C 4680.79 3617.58 4685.09 3629.05 4689.39 3629.05 C 4699.42 3633.35 4715.18 3641.95 4722.35 3633.35 C 4728.08 3626.18 4708.02 3619.02 4705.15 3610.42 C 4697.98 3586.05 4719.48 3604.69 4719.48 3604.69 C 4722.35 3601.82 4715.18 3596.09 4716.62 3593.22 C 4719.48 3591.79 4726.65 3598.95 4726.65 3596.09 C 4726.65 3591.79 4716.62 3588.92 4718.05 3584.62 C 4719.48 3574.59 4728.08 3567.42 4733.81 3558.82 M 5155.5 3296.15 C 5158.49 3298.25 5158.23 3295.42 5159.46 3297.99 C 5160.85 3300.88 5162.19 3300.6 5162 3295.34 C 5161.79 3292.55 5163.76 3292.26 5170.93 3293.69 C 5175.23 3295.12 5163.76 3300.85 5160.9 3305.15 C 5160.9 3306.59 5166.63 3310.89 5165.2 3312.32 C 5162.33 3313.75 5156.6 3306.59 5155.16 3310.89 C 5155.16 3313.75 5163.76 3313.75 5163.76 3318.05 C 5165.2 3330.95 5146.56 3326.65 5148 3330.95 C 5149.43 3349.58 5163.65 3347.35 5134.99 3377.45 C 5133.55 3380.32 5128.43 3376.13 5129.87 3373.27 C 5138.46 3354.63 5149.43 3335.25 5142.27 3330.95 C 5136.53 3325.22 5133.82 3338.96 5126.66 3334.66 C 5116.63 3330.36 5121.66 3330.43 5118.8 3320.39 C 5117.36 3317.53 5123.41 3314.24 5126.27 3312.8 C 5137.74 3311.37 5135.46 3314.11 5145.5 3309.81 C 5152.66 3305.51 5151.2 3303.32 5155.5 3296.15 M 4967.42 3545.93 C 4948.79 3583.19 4862.8 3502.93 4922.99 3498.63 C 4931.59 3498.63 4940.19 3508.66 4940.19 3518.7 C 4941.62 3524.43 4922.99 3522.99 4925.86 3527.29 C 4930.16 3535.89 4943.06 3535.89 4951.65 3538.76 C 4955.95 3541.63 4961.69 3543.06 4967.42 3545.93 M 4611.99 3576.02 C 4604.83 3587.49 4584.76 3598.95 4581.9 3607.55 C 4580.46 3614.72 4579.03 3654.85 4560.4 3654.85 C 4550.37 3653.41 4551.8 3637.65 4544.64 3630.48 C 4536.04 3624.75 4547.5 3654.85 4538.9 3659.15 C 4534.6 3660.58 4528.87 3653.41 4526 3656.28 C 4515.97 3662.01 4514.54 3682.08 4503.07 3682.08 C 4493.04 3682.08 4484.44 3664.88 4490.17 3656.28 C 4495.91 3646.25 4520.27 3663.45 4524.57 3651.98 C 4528.87 3641.95 4504.51 3640.51 4500.21 3629.05 C 4498.77 3624.75 4510.24 3626.18 4513.11 3623.32 C 4514.54 3621.88 4508.81 3623.32 4508.81 3621.88 C 4505.94 3616.15 4504.51 3610.42 4505.94 3604.69 C 4518.84 3568.86 4528.87 3601.82 4548.93 3606.12 C 4550.37 3606.12 4541.77 3584.62 4546.07 3580.32 C 4560.4 3563.12 4560.4 3578.89 4574.73 3577.46 C 4576.16 3576.02 4576.16 3571.72 4577.6 3571.72 C 4586.2 3564.56 4594.8 3553.09 4604.83 3554.52 C 4611.99 3555.96 4609.13 3568.86 4611.99 3576.02 " }
                    }
                }
            } // END gb type: G 1
            // PATH visit ie count: 395
            DemoShape {
                objectName: "ie"
                ShapePath {
                    objectName: "svg_path:ie"
                    // boundingRect: 3847.16, 4125.47 570.555x643.865
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 4406.23 4375.13 C 4409.1 4382.29 4421.99 4389.46 4416.26 4395.19 C 4410.53 4403.79 4393.33 4396.62 4384.73 4402.36 C 4380.43 4406.65 4396.2 4409.52 4396.2 4415.25 C 4397.63 4426.72 4390.47 4438.18 4390.47 4449.65 C 4391.9 4459.68 4401.93 4465.41 4401.93 4475.45 C 4401.93 4482.61 4390.47 4486.91 4390.47 4495.51 C 4389.03 4501.24 4400.5 4506.98 4397.63 4512.71 C 4393.33 4518.44 4381.87 4505.54 4379 4511.28 C 4374.7 4517.01 4386.17 4522.74 4387.6 4529.91 C 4387.6 4532.77 4384.73 4535.64 4384.73 4538.51 C 4386.17 4557.14 4391.9 4568.6 4386.17 4587.23 C 4381.87 4600.13 4331.71 4673.22 4323.11 4680.39 C 4320.24 4683.26 4313.07 4684.69 4311.64 4690.42 C 4308.77 4700.45 4313.07 4711.92 4311.64 4721.95 C 4311.64 4723.38 4308.77 4723.38 4308.77 4721.95 C 4304.48 4711.92 4301.61 4724.82 4287.28 4719.08 C 4281.54 4717.65 4281.54 4709.05 4275.81 4707.62 C 4265.78 4704.75 4234.25 4720.52 4227.08 4711.92 C 4225.65 4709.05 4232.82 4709.05 4232.82 4706.19 C 4234.25 4701.89 4222.78 4710.49 4218.49 4709.05 C 4196.99 4707.62 4189.82 4696.15 4169.76 4703.32 C 4166.89 4704.75 4175.49 4710.49 4175.49 4714.79 C 4174.06 4721.95 4148.26 4727.68 4148.26 4727.68 C 4142.53 4727.68 4139.66 4719.08 4133.93 4720.52 C 4123.9 4724.82 4119.6 4737.72 4111 4743.45 C 4080.9 4759.21 4099.53 4716.22 4072.3 4720.52 C 4063.7 4721.95 4079.47 4737.72 4076.6 4744.88 C 4072.3 4750.61 4062.27 4750.61 4055.1 4754.91 C 4050.81 4757.78 4047.94 4766.38 4042.21 4767.81 C 4039.34 4767.81 4040.77 4762.08 4037.91 4760.65 C 4035.04 4757.78 4030.74 4754.91 4026.44 4756.35 C 4023.57 4759.21 4026.44 4767.81 4022.14 4769.25 C 4007.81 4770.68 3982.01 4753.48 3973.41 4754.91 C 3961.95 4756.35 3953.35 4764.95 3943.32 4766.38 C 3914.65 4769.25 3959.08 4746.31 3936.15 4750.61 C 3927.55 4753.48 3893.16 4757.78 3890.29 4754.91 C 3884.56 4746.31 3939.02 4730.55 3944.75 4717.65 C 3946.18 4714.79 3940.45 4714.79 3937.59 4713.35 C 3936.15 4710.49 3903.19 4717.65 3861.63 4713.35 C 3860.19 4713.35 3864.49 4711.92 3883.12 4706.19 C 3885.99 4706.19 3888.86 4704.75 3888.86 4701.89 C 3888.86 4700.45 3884.56 4699.02 3885.99 4697.59 C 3898.89 4686.12 3893.16 4704.75 3910.35 4697.59 C 3918.95 4694.72 3943.32 4693.29 3937.59 4686.12 C 3936.15 4684.69 3871.66 4693.29 3868.79 4693.29 C 3855.89 4690.42 3845.86 4670.36 3847.3 4656.03 C 3848.73 4650.29 3860.19 4661.76 3864.49 4658.89 C 3868.79 4656.03 3861.63 4651.73 3861.63 4647.43 C 3864.49 4634.53 3887.42 4641.69 3900.32 4638.83 C 3910.35 4637.39 3923.25 4638.83 3930.42 4631.66 C 3936.15 4627.36 3916.09 4617.33 3908.92 4621.63 C 3907.49 4624.5 3911.79 4630.23 3908.92 4631.66 C 3907.49 4633.09 3864.49 4611.6 3855.89 4600.13 C 3854.46 4597.27 3864.49 4604.43 3867.36 4603 C 3870.23 4601.57 3867.36 4595.83 3870.23 4594.4 C 3877.39 4590.1 3897.46 4591.53 3907.49 4592.97 C 3920.39 4592.97 3928.99 4605.86 3940.45 4611.6 C 3951.92 4617.33 3918.95 4588.67 3924.69 4577.2 C 3928.99 4567.17 3946.18 4574.34 3956.22 4570.04 C 3961.95 4567.17 3961.95 4558.57 3967.68 4557.14 C 3969.11 4557.14 4060.84 4572.9 4070.87 4567.17 C 4078.04 4562.87 4052.24 4564.3 4047.94 4557.14 C 4046.51 4552.84 4052.24 4545.67 4050.8 4541.37 C 4049.37 4538.51 4020.71 4567.17 4006.38 4565.74 C 4003.51 4564.3 4014.98 4557.14 4010.68 4555.7 C 4006.38 4554.27 4000.64 4560 3994.91 4558.57 C 3989.18 4557.14 3984.88 4552.84 3982.01 4548.54 C 3980.58 4545.67 3983.45 4542.81 3982.01 4541.37 C 3982.01 4541.37 3940.45 4549.97 3934.72 4547.1 C 3930.42 4545.67 3944.75 4547.1 3949.05 4545.67 C 3960.52 4539.94 3969.11 4532.77 3980.58 4528.47 C 3983.45 4525.61 3989.18 4529.91 3992.05 4528.47 C 3997.78 4522.74 3999.21 4512.71 4006.38 4505.54 C 4009.24 4502.68 4013.54 4501.24 4017.84 4499.81 C 4020.71 4496.94 4007.81 4499.81 4004.94 4495.51 C 3999.21 4488.35 4017.84 4482.61 4023.57 4476.88 C 4027.87 4471.15 4030.74 4463.98 4037.91 4462.55 C 4042.21 4461.12 4043.64 4472.58 4047.94 4471.15 C 4059.4 4471.15 4070.87 4466.85 4080.9 4461.12 C 4083.77 4459.68 4069.44 4462.55 4069.44 4458.25 C 4069.44 4453.95 4079.47 4455.38 4079.47 4451.08 C 4078.04 4446.78 4049.37 4452.52 4017.84 4443.92 C 3987.75 4435.32 4017.84 4436.75 4010.68 4412.39 C 4003.51 4386.59 3963.38 4405.22 3951.92 4388.02 C 3920.39 4346.46 3979.15 4363.66 3980.58 4363.66 C 3982.01 4362.23 3974.85 4357.93 3976.28 4356.49 C 3982.01 4346.46 3989.18 4336.43 4000.64 4333.56 C 4010.68 4330.7 4022.14 4339.3 4033.61 4339.3 C 4036.47 4339.3 4039.34 4337.86 4040.77 4335 C 4059.4 4290.57 4006.38 4323.53 4003.51 4310.63 C 4000.64 4304.9 4016.41 4310.63 4020.71 4306.33 C 4029.31 4300.6 4014.98 4286.27 4013.54 4284.84 C 4013.54 4274.8 4026.44 4261.9 4019.28 4253.31 C 4013.54 4247.57 4002.08 4269.07 3996.34 4263.34 C 3990.61 4257.61 4004.94 4250.44 4007.81 4243.27 C 4009.24 4237.54 3994.91 4238.97 4007.81 4236.11 C 4020.71 4233.24 4088.07 4233.24 4095.23 4251.87 C 4099.53 4261.9 4093.8 4277.67 4102.4 4280.54 C 4111 4283.4 4111 4266.2 4118.16 4261.9 C 4131.06 4254.74 4168.32 4297.73 4169.76 4293.43 C 4174.06 4283.4 4159.73 4271.94 4161.16 4260.47 C 4164.03 4247.57 4207.02 4251.87 4207.02 4250.44 C 4218.49 4246.14 4227.08 4237.54 4234.25 4228.94 C 4238.55 4223.21 4212.75 4228.94 4212.75 4226.08 C 4208.45 4210.31 4212.75 4231.81 4194.12 4230.38 C 4191.26 4230.38 4195.55 4224.64 4195.55 4221.78 C 4195.55 4220.34 4195.55 4217.48 4194.12 4217.48 C 4188.39 4214.61 4159.73 4213.18 4164.03 4195.98 C 4172.62 4167.32 4201.29 4198.85 4209.89 4195.98 C 4215.62 4193.11 4192.69 4184.51 4196.99 4178.78 C 4202.72 4173.05 4214.19 4184.51 4221.35 4183.08 C 4228.52 4181.65 4215.62 4171.62 4211.32 4167.32 C 4208.45 4164.45 4221.35 4164.45 4222.78 4160.15 C 4228.52 4135.79 4166.89 4160.15 4241.42 4125.75 C 4245.72 4124.32 4251.45 4128.62 4257.18 4130.05 C 4277.25 4135.79 4300.18 4134.35 4317.37 4145.82 C 4327.41 4152.98 4291.58 4167.32 4297.31 4177.35 C 4303.04 4183.08 4314.51 4173.05 4321.67 4165.88 C 4324.54 4163.02 4317.37 4150.12 4323.11 4150.12 C 4331.71 4152.98 4337.44 4164.45 4343.17 4171.62 C 4311.64 4171.62 4320.24 4207.44 4297.31 4221.78 C 4293.01 4224.64 4255.75 4213.18 4258.61 4221.78 C 4260.05 4230.38 4278.68 4234.67 4275.81 4243.27 C 4275.81 4243.27 4219.92 4257.61 4218.49 4257.61 C 4212.75 4264.77 4268.65 4339.3 4290.14 4337.86 C 4356.07 4332.13 4277.25 4303.47 4338.87 4294.87 C 4354.64 4292 4347.47 4326.4 4354.64 4340.73 C 4357.5 4346.46 4371.83 4343.6 4370.4 4353.63 C 4367.53 4360.79 4357.5 4373.69 4364.67 4375.13 C 4413.4 4392.32 4383.3 4359.36 4404.8 4372.26 L 4410.53 4379.42 C 4409.1 4377.99 4407.66 4376.56 4406.23 4375.13 " }
                }
            }
            // PATH visit nl count: 240
            DemoShape {
                objectName: "nl"
                ShapePath {
                    objectName: "svg_path:nl"
                    // boundingRect: 5402.28, 4689.92 473.179x508.107
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5655.95 4754.91 L 5630.15 4774.69 C 5615.82 4824.85 5678.88 4800.78 5655.95 4817.97 C 5645.92 4825.14 5630.15 4822.27 5624.42 4832.3 C 5617.26 4842.34 5639.95 4851.49 5631.35 4860.08 C 5628.48 4864.38 5610.09 4873.87 5612.96 4878.17 C 5612.96 4878.17 5630.92 4885 5630.92 4885 C 5639.52 4885 5671.19 4827.02 5694.55 4840.9 C 5703.26 4846.08 5691.78 4836.6 5688.91 4826.57 C 5686.05 4816.54 5708.98 4806.51 5704.68 4796.48 C 5698.95 4783.58 5664.55 4800.78 5664.55 4787.88 C 5665.98 4777.84 5671.72 4769.25 5673.15 4759.21 C 5673.15 4756.35 5670.28 4753.48 5668.85 4750.61 C 5667.42 4747.75 5651.37 4763.46 5657.1 4756.29 L 5628.72 4773.55 C 5618.69 4776.41 5607.22 4772.11 5597.19 4772.11 C 5592.89 4772.11 5588.59 4769.25 5587.16 4770.68 C 5568.53 4793.61 5574.26 4839.47 5565.66 4863.83 C 5557.06 4885.33 5539.86 4909.7 5524.1 4926.89 C 5518.37 4934.06 5514.07 4942.66 5506.9 4946.96 C 5502.6 4949.82 5492.57 4944.09 5491.14 4949.82 C 5488.27 4958.42 5501.17 4969.89 5496.87 4978.49 C 5482.54 5001.42 5438.11 4989.95 5448.14 4995.69 C 5459.61 5002.85 5468.21 5012.88 5481.1 5018.62 C 5486.84 5020.05 5492.57 5011.45 5496.87 5012.88 C 5502.6 5014.32 5512.63 5022.92 5508.33 5027.22 C 5501.17 5031.51 5482.54 5015.75 5482.54 5024.35 C 5483.97 5037.25 5521.23 5035.81 5514.07 5045.85 C 5492.57 5074.51 5472.51 5021.48 5463.91 5020.05 C 5436.68 5012.88 5410.88 5017.18 5415.18 5027.22 C 5415.18 5028.65 5459.61 5058.75 5468.21 5057.31 C 5471.07 5057.31 5469.64 5051.58 5472.51 5048.71 C 5478.24 5044.41 5483.97 5054.45 5489.7 5055.88 C 5495.44 5058.74 5504.04 5053.01 5509.77 5058.74 C 5512.63 5061.61 5515.5 5065.91 5516.93 5070.21 C 5521.23 5071.64 5524.1 5073.08 5528.4 5071.64 C 5538.43 5071.64 5511.2 5038.68 5545.6 5048.71 C 5548.46 5048.71 5542.73 5055.88 5544.16 5057.31 C 5561.36 5071.64 5565.66 5037.25 5578.56 5047.28 C 5582.86 5051.58 5567.09 5060.18 5571.39 5063.04 C 5604.36 5080.24 5575.69 5058.75 5601.49 5053.01 C 5605.79 5051.58 5612.96 5093.14 5622.99 5094.57 C 5645.92 5098.87 5676.01 5097.44 5694.65 5121.8 C 5696.08 5124.67 5688.91 5127.54 5687.48 5130.4 C 5684.61 5139 5677.45 5146.17 5676.01 5154.77 C 5676.01 5157.63 5683.18 5156.2 5681.75 5159.07 C 5680.31 5163.37 5673.15 5164.8 5671.72 5170.53 C 5661.68 5206.36 5686.05 5196.33 5708.98 5197.76 L 5710.41 5197.76 C 5707.54 5193.46 5706.11 5189.16 5706.11 5187.73 C 5707.54 5182 5717.58 5182 5719.01 5176.26 C 5723.31 5151.9 5681.75 5143.3 5694.65 5140.44 C 5698.95 5139 5701.81 5144.73 5704.68 5144.73 C 5704.68 5144.73 5731.91 5120.37 5731.91 5120.37 C 5733.34 5113.21 5714.71 5121.8 5720.44 5110.34 C 5724.74 5100.31 5734.77 5093.14 5739.07 5083.11 C 5751.97 5051.58 5720.44 5028.65 5711.84 5012.88 C 5710.41 5010.02 5713.28 5005.72 5714.71 5002.85 C 5714.71 4999.99 5711.84 4995.69 5714.71 4994.25 C 5721.88 4989.95 5730.48 4994.25 5739.07 4991.39 C 5741.94 4989.95 5736.21 4981.35 5739.07 4982.79 C 5747.67 4985.65 5753.41 4995.69 5763.44 4995.69 C 5773.47 4997.12 5812.17 4984.22 5816.47 4974.19 C 5820.76 4964.16 5789.24 4962.72 5802.13 4954.12 C 5825.06 4938.36 5852.29 4932.63 5846.56 4896.8 C 5845.13 4876.73 5792.1 4885.33 5805 4863.83 C 5806.43 4859.54 5813.6 4863.83 5813.6 4860.97 C 5815.03 4856.67 5807.87 4852.37 5809.3 4848.07 C 5809.3 4845.2 5813.6 4845.2 5816.47 4845.2 C 5826.5 4845.2 5835.1 4849.5 5845.13 4849.5 C 5856.59 4849.5 5846.56 4826.57 5850.86 4815.11 C 5853.73 4805.07 5878.09 4759.21 5875.23 4734.85 C 5846.56 4749.18 5843.7 4696.15 5819.33 4690.42 C 5797.83 4686.12 5684.61 4710.49 5671.72 4730.55 C 5664.55 4739.15 5661.68 4747.75 5655.95 4754.91 M 5405.15 5058.74 C 5402.28 5096.01 5432.38 5071.64 5453.87 5081.68 C 5456.74 5083.11 5451.01 5088.84 5453.87 5091.71 C 5471.07 5103.17 5485.4 5083.11 5496.87 5073.08 C 5489.7 5065.91 5481.1 5060.18 5478.24 5058.74 C 5471.07 5057.31 5469.64 5070.21 5462.47 5070.21 C 5438.11 5070.21 5453.87 5055.88 5425.21 5051.58 C 5418.05 5050.15 5410.88 5050.15 5402.28 5053.01 L 5405.15 5058.74 " }
                }
            }
            // PATH visit be count: 157
            DemoShape {
                objectName: "be"
                ShapePath {
                    objectName: "svg_path:be"
                    // boundingRect: 5301.96, 5045.41 450.877x384.166
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5671.72 5427.07 C 5667.42 5425.64 5663.12 5424.2 5658.82 5424.2 C 5648.78 5422.77 5638.75 5432.8 5630.15 5428.5 C 5622.99 5425.64 5628.72 5412.74 5624.42 5407 C 5621.55 5402.7 5614.39 5405.57 5610.09 5402.7 C 5608.66 5401.27 5615.82 5398.41 5615.82 5396.97 C 5614.39 5394.11 5612.96 5391.24 5610.09 5389.81 C 5607.22 5388.37 5602.92 5394.11 5601.49 5392.67 C 5595.76 5388.37 5594.32 5379.77 5588.59 5375.47 C 5578.56 5371.18 5564.23 5375.47 5558.5 5366.88 C 5552.76 5361.14 5564.23 5352.54 5564.23 5345.38 C 5562.79 5339.65 5554.2 5338.21 5554.2 5332.48 C 5554.2 5325.31 5559.93 5319.58 5561.36 5313.85 C 5562.79 5309.55 5569.96 5305.25 5567.09 5302.38 C 5557.06 5293.78 5548.46 5319.58 5538.43 5328.18 C 5518.37 5346.81 5471.07 5335.35 5475.37 5326.75 C 5479.67 5319.58 5486.84 5315.28 5486.84 5308.12 C 5486.84 5303.82 5475.37 5303.82 5476.8 5298.08 C 5476.8 5289.48 5488.27 5282.32 5488.27 5273.72 C 5485.4 5249.36 5426.64 5263.69 5423.78 5252.22 C 5422.34 5246.49 5426.64 5239.32 5425.21 5233.59 C 5420.91 5210.66 5389.38 5233.59 5380.78 5213.53 C 5375.05 5202.06 5383.65 5169.1 5365.02 5161.93 C 5356.42 5157.63 5349.25 5177.7 5337.79 5177.7 C 5306.26 5177.7 5304.82 5123.24 5301.96 5103.17 C 5303.39 5101.74 5303.39 5101.74 5303.39 5101.74 C 5329.19 5094.57 5369.32 5063.04 5402.28 5053.01 L 5405.15 5058.74 C 5402.28 5096.01 5432.38 5071.64 5453.87 5081.68 C 5456.74 5083.11 5451.01 5088.84 5453.87 5091.71 C 5471.07 5103.17 5485.4 5083.11 5496.87 5073.08 C 5505.47 5080.24 5514.07 5085.98 5516.93 5084.54 C 5521.23 5081.68 5519.8 5075.94 5516.93 5070.21 C 5521.23 5071.64 5524.1 5073.08 5528.4 5071.64 C 5538.43 5071.64 5511.2 5038.68 5545.6 5048.71 C 5548.46 5048.71 5542.73 5055.88 5544.16 5057.31 C 5561.36 5071.64 5565.66 5037.25 5578.56 5047.28 C 5582.86 5051.58 5567.09 5060.18 5571.39 5063.04 C 5604.36 5080.24 5575.69 5058.74 5601.49 5053.01 C 5605.79 5051.58 5612.96 5093.14 5622.99 5094.57 C 5645.92 5098.87 5676.01 5097.44 5694.65 5121.8 C 5696.08 5124.67 5688.91 5127.54 5687.48 5130.4 C 5684.61 5139 5677.45 5146.17 5676.01 5154.77 C 5676.01 5157.63 5683.18 5156.2 5681.75 5159.07 C 5680.31 5163.37 5673.15 5164.8 5671.72 5170.53 C 5661.68 5206.36 5686.05 5196.33 5708.98 5197.76 L 5710.41 5197.76 C 5716.14 5207.79 5724.74 5223.56 5726.18 5223.56 C 5729.04 5226.43 5737.64 5220.69 5737.64 5224.99 C 5739.07 5230.72 5727.61 5236.46 5729.04 5242.19 C 5731.91 5250.79 5744.81 5249.36 5749.11 5256.52 C 5764.87 5282.32 5726.18 5286.62 5716.14 5313.85 C 5700.38 5286.62 5671.72 5339.65 5665.98 5355.41 C 5661.68 5368.31 5704.68 5424.2 5673.15 5421.34 L 5671.72 5427.07 " }
                }
            }
            // PATH visit lu count: 29
            DemoShape {
                objectName: "lu"
                ShapePath {
                    objectName: "svg_path:lu"
                    // boundingRect: 5665.68, 5306.2 99.2084x135.428
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5739.07 5441.4 C 5731.91 5438.53 5723.31 5434.23 5714.71 5434.23 C 5707.54 5434.23 5700.38 5441.4 5691.78 5441.4 C 5690.35 5442.83 5691.78 5437.1 5690.35 5435.67 C 5684.61 5432.8 5678.88 5429.93 5671.72 5427.07 L 5673.15 5421.34 C 5704.68 5424.2 5661.68 5368.31 5665.98 5355.41 C 5671.72 5339.65 5700.38 5286.62 5716.14 5313.85 C 5714.71 5321.01 5713.28 5328.18 5716.14 5339.65 C 5723.31 5369.74 5757.71 5372.61 5760.57 5376.91 C 5780.64 5401.27 5723.31 5412.74 5739.07 5441.4 " }
                }
            }
            // PATH visit de count: 584
            DemoShape {
                objectName: "de"
                ShapePath {
                    objectName: "svg_path:de"
                    // boundingRect: 5692.15, 4428.15 1080.38x1437.92
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6657.73 4638.83 C 6660.6 4661.76 6683.53 4706.19 6686.4 4720.52 C 6690.7 4754.91 6644.83 4777.84 6654.87 4805.07 C 6660.6 4822.27 6715.06 4829.44 6715.06 4850.94 C 6715.06 4872.43 6697.86 4879.6 6710.76 4895.36 C 6715.06 4902.53 6725.09 4905.4 6727.96 4914 C 6732.26 4921.16 6726.53 4931.19 6727.96 4938.36 C 6729.39 4942.66 6735.12 4941.23 6736.56 4944.09 C 6743.72 4954.12 6726.53 4978.49 6722.23 4987.09 C 6713.63 4999.99 6735.12 5007.15 6739.42 5020.05 C 6742.29 5027.22 6732.26 5035.81 6736.56 5041.55 C 6742.29 5050.15 6755.19 5047.28 6760.92 5053.01 C 6780.99 5071.64 6772.39 5176.26 6755.19 5179.13 C 6736.56 5183.43 6706.46 5104.61 6690.7 5149.03 C 6687.83 5156.2 6713.63 5161.93 6707.89 5166.23 C 6690.7 5180.56 6666.33 5182 6649.13 5192.03 C 6646.27 5193.46 6649.13 5200.63 6646.27 5202.06 C 6634.8 5207.79 6619.04 5199.2 6610.44 5206.36 C 6603.27 5212.09 6606.14 5223.56 6598.97 5229.29 C 6596.11 5232.16 6593.24 5222.13 6588.94 5223.56 C 6576.04 5226.43 6574.61 5243.62 6566.01 5249.36 C 6561.71 5253.66 6553.11 5246.49 6548.81 5250.79 C 6544.51 5253.66 6548.81 5262.25 6544.51 5266.55 C 6538.78 5273.72 6523.02 5260.82 6518.72 5260.82 C 6482.89 5266.55 6477.15 5293.78 6465.69 5316.71 C 6462.82 5322.45 6462.82 5302.38 6457.09 5298.08 C 6452.79 5292.35 6444.19 5290.92 6437.03 5289.48 C 6424.13 5286.62 6451.36 5332.48 6480.02 5351.11 C 6482.89 5352.54 6492.92 5353.98 6494.35 5362.58 C 6498.65 5382.64 6480.02 5375.47 6477.15 5391.24 C 6475.72 5395.54 6507.25 5448.57 6511.55 5452.87 C 6535.91 5477.23 6541.65 5460.03 6557.41 5475.8 C 6567.44 5485.83 6568.88 5501.59 6578.91 5510.19 C 6601.84 5525.96 6663.47 5547.45 6662.03 5584.72 C 6660.6 5623.41 6652 5614.81 6621.9 5607.65 C 6619.04 5607.65 6616.17 5609.08 6614.74 5611.95 C 6611.87 5626.28 6620.47 5642.04 6606.14 5653.51 C 6593.24 5663.54 6533.05 5677.87 6531.61 5700.8 C 6531.61 5700.8 6566.01 5748.1 6566.01 5749.53 C 6567.44 5750.96 6547.38 5768.16 6554.55 5773.89 C 6570.31 5788.23 6586.08 5766.73 6573.18 5814.02 C 6573.18 5816.89 6570.31 5821.19 6567.44 5821.19 C 6521.58 5808.29 6557.41 5785.36 6535.91 5783.93 C 6524.45 5783.93 6514.42 5793.96 6502.95 5792.53 C 6497.22 5791.09 6498.65 5781.06 6494.35 5779.63 C 6485.75 5776.76 6477.15 5783.93 6469.99 5781.06 C 6467.12 5779.63 6472.86 5771.03 6469.99 5771.03 C 6452.79 5772.46 6468.56 5795.39 6464.26 5796.83 C 6444.19 5802.56 6411.23 5793.96 6392.6 5801.12 C 6386.87 5803.99 6389.73 5814.02 6384 5816.89 C 6378.27 5821.19 6371.1 5814.02 6365.37 5818.32 C 6361.07 5819.76 6366.8 5826.92 6363.93 5829.79 C 6362.5 5831.22 6313.77 5844.12 6308.04 5841.25 C 6305.17 5838.39 6308.04 5831.22 6305.17 5828.35 C 6303.74 5825.49 6296.58 5825.49 6295.14 5822.62 C 6293.71 5819.76 6302.31 5821.19 6300.88 5818.32 C 6295.14 5799.69 6255.01 5822.62 6243.55 5809.72 C 6243.55 5809.72 6246.41 5808.29 6246.41 5806.86 C 6237.82 5801.12 6246.41 5825.49 6243.55 5835.52 C 6243.55 5841.25 6216.32 5874.22 6206.29 5864.18 C 6200.55 5858.45 6216.32 5849.85 6212.02 5844.12 C 6210.59 5842.69 6206.29 5848.42 6203.42 5848.42 C 6200.55 5848.42 6196.25 5846.99 6194.82 5844.12 C 6191.95 5839.82 6201.99 5834.09 6194.82 5828.35 C 6189.09 5824.06 6186.22 5816.89 6180.49 5814.02 C 6176.19 5811.16 6170.46 5818.32 6164.72 5816.89 C 6161.86 5814.02 6164.72 5806.86 6161.86 5803.99 C 6154.69 5798.26 6156.13 5824.06 6133.19 5816.89 C 6117.43 5811.16 6107.4 5795.39 6091.63 5791.09 C 6090.2 5791.09 6042.91 5793.96 6042.91 5793.96 C 6037.17 5791.09 6037.17 5781.06 6031.44 5778.19 C 6030.01 5775.33 6034.31 5785.36 6031.44 5786.79 C 6028.57 5788.23 6022.84 5786.79 6021.41 5783.93 C 6019.97 5779.63 6027.14 5773.89 6024.27 5771.03 C 6002.78 5749.53 5978.41 5788.23 5982.71 5789.66 C 5991.31 5791.09 5999.91 5788.23 6008.51 5789.66 C 6014.24 5791.09 5998.48 5792.53 5994.18 5795.39 C 5991.31 5796.83 5995.61 5803.99 5994.18 5805.42 C 5958.35 5824.06 5984.15 5796.83 5955.48 5798.26 C 5951.18 5798.26 5885.26 5814.02 5880.96 5805.42 C 5879.52 5802.56 5889.56 5801.12 5888.12 5799.69 C 5875.22 5789.66 5869.49 5832.65 5869.49 5782.49 C 5868.06 5762.43 5882.39 5743.8 5883.82 5723.73 C 5883.82 5720.87 5878.09 5720.87 5878.09 5716.57 C 5876.66 5709.4 5879.52 5702.24 5882.39 5695.07 C 5882.39 5695.07 5902.46 5662.11 5902.46 5662.11 C 5903.89 5653.51 5905.32 5621.98 5909.62 5611.95 C 5921.09 5589.02 5949.75 5571.82 5965.51 5544.59 C 5971.25 5534.56 5885.26 5524.52 5879.52 5520.22 C 5875.22 5515.92 5878.09 5507.33 5873.79 5503.03 C 5866.63 5497.29 5820.76 5515.92 5817.9 5511.63 C 5816.47 5507.33 5822.2 5501.59 5819.33 5498.73 C 5776.34 5460.03 5805 5518.79 5787.8 5500.16 C 5773.47 5485.83 5766.3 5452.87 5754.84 5445.7 C 5750.54 5441.4 5741.94 5445.7 5739.07 5441.4 C 5723.31 5412.74 5780.64 5401.27 5760.57 5376.91 C 5757.71 5372.61 5723.31 5369.74 5716.14 5339.65 C 5703.24 5286.62 5769.17 5289.48 5749.11 5256.52 C 5744.81 5249.36 5731.91 5250.79 5729.04 5242.19 C 5727.61 5236.46 5739.07 5230.72 5737.64 5224.99 C 5737.64 5220.69 5729.04 5226.43 5726.18 5223.56 C 5724.74 5222.13 5704.68 5192.03 5706.11 5187.73 C 5707.54 5182 5717.58 5182 5719.01 5176.26 C 5723.31 5151.9 5681.75 5143.3 5694.65 5140.44 C 5698.95 5139 5701.81 5144.73 5704.68 5144.73 C 5704.68 5144.73 5731.91 5120.37 5731.91 5120.37 C 5733.34 5113.21 5714.71 5121.8 5720.44 5110.34 C 5724.74 5100.31 5734.77 5093.14 5739.07 5083.11 C 5751.97 5051.58 5720.44 5028.65 5711.84 5012.88 C 5710.41 5010.02 5713.28 5005.72 5714.71 5002.85 C 5714.71 4999.99 5711.84 4995.69 5714.71 4994.25 C 5721.88 4989.95 5730.48 4994.25 5739.07 4991.39 C 5741.94 4989.95 5736.21 4981.35 5739.07 4982.79 C 5747.67 4985.65 5753.41 4995.69 5763.44 4995.69 C 5773.47 4997.12 5812.17 4984.22 5816.47 4974.19 C 5820.76 4964.16 5789.24 4962.72 5802.13 4954.12 C 5825.06 4938.36 5852.29 4932.63 5846.56 4896.8 C 5845.13 4876.73 5792.1 4885.33 5805 4863.83 C 5806.43 4859.54 5813.6 4863.83 5813.6 4860.97 C 5815.03 4856.67 5807.87 4852.37 5809.3 4848.07 C 5809.3 4845.2 5813.6 4845.2 5816.47 4845.2 C 5826.5 4845.2 5835.1 4849.5 5845.13 4849.5 C 5856.59 4849.5 5846.56 4826.57 5850.86 4815.11 C 5853.73 4805.07 5878.09 4759.21 5875.23 4734.85 C 5879.52 4733.42 5883.82 4730.55 5888.12 4724.82 C 5893.86 4719.08 5880.96 4721.95 5868.06 4721.95 C 5865.19 4719.08 5860.89 4720.52 5858.03 4720.52 C 5855.16 4720.52 5853.73 4719.08 5852.29 4717.65 C 5840.83 4703.32 5872.36 4658.89 5883.82 4653.16 C 5890.99 4648.86 5899.59 4657.46 5906.75 4657.46 C 6014.24 4653.16 5794.97 4644.56 5958.35 4648.86 C 5959.78 4648.86 5964.08 4650.29 5965.51 4651.73 C 5974.11 4667.49 5979.85 4733.42 6015.68 4719.08 C 6027.14 4714.79 6004.21 4615.9 6037.17 4615.9 C 6040.04 4615.9 6040.04 4624.5 6044.34 4625.93 C 6048.64 4628.8 6055.8 4628.8 6061.54 4628.8 C 6075.87 4631.66 6091.63 4617.33 6104.53 4623.06 C 6114.56 4627.36 6114.56 4641.69 6120.3 4650.29 C 6127.46 4661.76 6166.16 4734.85 6166.16 4686.12 C 6166.16 4676.09 6144.66 4678.96 6136.06 4670.36 C 6121.73 4657.46 6124.6 4624.5 6097.37 4620.2 C 6093.07 4620.2 6060.1 4627.36 6062.97 4607.3 C 6064.4 4594.4 6084.47 4554.27 6071.57 4538.51 C 6067.27 4534.21 6035.74 4549.97 6031.44 4534.21 C 6030.01 4531.34 6040.04 4534.21 6041.47 4531.34 C 6044.34 4528.47 6031.44 4522.74 6034.31 4522.74 C 6048.64 4518.44 6073 4532.77 6077.3 4504.11 C 6077.3 4501.24 6044.34 4465.41 6041.47 4459.68 C 6037.17 4449.65 6035.74 4438.18 6035.74 4428.15 C 6045.77 4429.59 6062.97 4428.15 6067.27 4428.15 C 6085.9 4431.02 6104.53 4441.05 6123.16 4443.92 C 6121.73 4448.22 6121.73 4449.65 6124.6 4448.22 C 6130.33 4443.92 6133.19 4436.75 6138.93 4435.32 C 6141.79 4435.32 6137.49 4442.48 6138.93 4445.35 C 6143.23 4448.22 6148.96 4446.78 6153.26 4448.22 C 6163.29 4449.65 6173.32 4449.65 6180.49 4453.95 C 6184.79 4456.82 6186.22 4462.55 6186.22 4466.85 C 6186.22 4468.28 6183.36 4466.85 6183.36 4466.85 C 6180.49 4468.28 6174.76 4471.15 6177.62 4472.58 C 6179.06 4475.45 6186.22 4469.71 6187.66 4472.58 C 6191.95 4479.75 6190.52 4488.35 6187.66 4495.51 C 6184.79 4502.68 6164.72 4506.98 6170.46 4514.14 C 6177.62 4524.17 6204.85 4498.38 6206.29 4511.28 C 6207.72 4519.87 6191.95 4535.64 6200.55 4538.51 C 6210.59 4542.81 6210.59 4518.44 6220.62 4517.01 C 6229.22 4515.58 6262.18 4544.24 6269.35 4541.37 C 6270.78 4541.37 6299.44 4508.41 6309.47 4525.61 C 6329.54 4562.87 6229.22 4601.57 6283.68 4607.3 C 6295.14 4608.73 6303.74 4594.4 6315.21 4594.4 C 6329.54 4595.83 6313.77 4637.39 6345.3 4615.9 C 6352.47 4611.6 6356.77 4575.77 6369.67 4568.6 C 6388.3 4558.57 6408.36 4554.27 6416.96 4574.34 C 6415.53 4570.04 6414.1 4562.87 6415.53 4561.44 C 6424.13 4551.4 6435.59 4547.1 6442.76 4538.51 C 6451.36 4528.47 6452.79 4512.71 6461.39 4502.68 C 6464.26 4499.81 6482.89 4506.98 6500.09 4512.71 C 6507.25 4511.28 6514.42 4509.84 6517.28 4509.84 C 6527.32 4509.84 6521.58 4529.91 6527.32 4538.51 C 6531.61 4544.24 6541.65 4541.37 6545.95 4547.1 C 6554.55 4554.27 6558.84 4574.34 6571.74 4572.9 C 6581.78 4572.9 6593.24 4565.74 6604.71 4568.6 C 6609.01 4570.04 6598.97 4577.2 6598.97 4581.5 C 6600.41 4592.97 6604.71 4604.43 6609.01 4615.9 C 6613.31 4627.36 6627.64 4631.66 6639.1 4635.96 C 6647.7 4638.83 6653.43 4640.26 6657.73 4638.83 M 6527.32 4528.47 C 6530.18 4515.58 6524.45 4499.81 6528.75 4486.91 C 6533.05 4474.01 6576.04 4511.28 6567.44 4498.38 C 6561.71 4489.78 6543.08 4494.08 6538.78 4484.05 C 6537.35 4475.45 6550.25 4468.28 6555.98 4461.12 C 6561.71 4456.82 6551.68 4478.31 6557.41 4479.75 C 6567.44 4482.61 6577.48 4478.31 6586.08 4481.18 C 6594.67 4484.05 6574.61 4495.51 6577.48 4504.11 C 6580.34 4514.14 6593.24 4515.58 6597.54 4525.61 C 6600.41 4528.47 6581.78 4542.81 6558.84 4548.54 C 6547.38 4552.84 6537.35 4535.64 6527.32 4528.47 " }
                }
            }
            // PATH visit fr count: 891
            DemoShape {
                objectName: "fr"
                ShapePath {
                    objectName: "svg_path:fr"
                    // boundingRect: 4338.59, 5103.17 1784.64x1875.74
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5301.96 5103.17 C 5304.82 5123.24 5306.26 5177.7 5337.79 5177.7 C 5349.25 5177.7 5356.42 5157.63 5365.02 5161.93 C 5383.65 5169.1 5375.05 5202.06 5380.78 5213.53 C 5389.38 5233.59 5420.91 5210.66 5425.21 5233.59 C 5426.64 5239.32 5422.34 5246.49 5423.78 5252.22 C 5426.64 5263.69 5485.4 5249.36 5488.27 5273.72 C 5488.27 5282.32 5476.8 5289.48 5476.8 5298.08 C 5475.37 5303.82 5486.84 5303.82 5486.84 5308.12 C 5486.84 5315.28 5479.67 5319.58 5475.37 5326.75 C 5471.07 5335.35 5518.37 5346.81 5538.43 5328.18 C 5548.46 5319.58 5557.06 5293.78 5567.09 5302.38 C 5569.96 5305.25 5562.79 5309.55 5561.36 5313.85 C 5559.93 5319.58 5554.2 5325.31 5554.2 5332.48 C 5554.2 5338.21 5562.79 5339.65 5564.23 5345.38 C 5564.23 5352.54 5552.76 5361.14 5558.5 5366.88 C 5564.23 5375.47 5578.56 5371.18 5588.59 5375.47 C 5594.32 5379.77 5595.76 5388.37 5601.49 5392.67 C 5602.92 5394.11 5607.22 5388.37 5610.09 5389.81 C 5612.96 5391.24 5614.39 5394.11 5615.82 5396.97 C 5615.82 5398.41 5608.66 5401.27 5610.09 5402.7 C 5614.39 5405.57 5621.55 5402.7 5624.42 5407 C 5628.72 5412.74 5622.99 5425.64 5630.15 5428.5 C 5638.75 5432.8 5648.78 5422.77 5658.82 5424.2 C 5663.12 5424.2 5667.42 5425.64 5671.72 5427.07 C 5678.88 5429.93 5684.61 5432.8 5690.35 5435.67 C 5691.78 5437.1 5690.35 5442.83 5691.78 5441.4 C 5700.38 5441.4 5707.54 5434.23 5714.71 5434.23 C 5723.31 5434.23 5731.91 5438.53 5739.07 5441.4 C 5741.94 5445.7 5750.54 5441.4 5754.84 5445.7 C 5766.3 5452.87 5773.47 5485.83 5787.8 5500.16 C 5805 5518.79 5776.34 5460.03 5819.33 5498.73 C 5822.2 5501.59 5816.47 5507.33 5817.9 5511.63 C 5820.76 5515.92 5866.63 5497.29 5873.79 5503.03 C 5878.09 5507.33 5875.23 5515.92 5879.52 5520.22 C 5885.26 5524.52 5971.25 5534.56 5965.51 5544.59 C 5949.75 5571.82 5921.09 5589.02 5909.62 5611.95 C 5905.32 5621.98 5903.89 5653.51 5902.46 5662.11 L 5882.39 5695.07 C 5879.52 5702.24 5876.66 5709.4 5878.09 5716.57 C 5878.09 5720.87 5883.82 5720.87 5883.82 5723.73 C 5882.39 5743.8 5868.06 5762.43 5869.49 5782.49 C 5869.49 5801.12 5869.49 5806.86 5870.93 5806.86 C 5822.2 5857.02 5839.4 5802.56 5799.27 5814.02 C 5796.4 5815.46 5802.13 5821.19 5802.13 5824.06 C 5802.13 5825.49 5799.27 5824.06 5799.27 5824.06 C 5794.97 5829.79 5783.5 5835.52 5786.37 5842.69 C 5787.8 5849.85 5809.3 5835.52 5809.3 5842.69 C 5807.87 5862.75 5800.7 5846.99 5793.53 5852.72 C 5780.64 5862.75 5769.17 5891.41 5759.14 5900.01 C 5750.54 5910.05 5730.48 5905.75 5724.74 5917.21 C 5720.44 5927.24 5729.04 5940.14 5724.74 5948.74 C 5719.01 5964.51 5693.21 5964.51 5683.18 5978.84 C 5665.98 6000.33 5684.61 6020.4 5677.45 6043.33 C 5676.01 6047.63 5661.68 6040.46 5661.68 6059.09 C 5661.68 6061.96 5654.52 6064.83 5655.95 6064.83 C 5673.15 6069.13 5693.21 6061.96 5701.81 6044.76 C 5703.24 6041.9 5696.08 6039.03 5694.65 6036.16 C 5694.65 6031.86 5693.21 6029 5696.08 6026.13 C 5708.98 6006.07 5749.11 6006.07 5767.74 6014.67 C 5773.47 6016.1 5762 6024.7 5763.44 6029 C 5763.44 6036.16 5772.04 6039.03 5773.47 6046.2 C 5774.9 6054.8 5754.84 6053.36 5763.44 6067.69 C 5766.3 6070.56 5774.9 6066.26 5776.34 6070.56 C 5779.2 6074.86 5772.04 6082.03 5773.47 6086.32 C 5774.9 6089.19 5780.64 6080.59 5782.07 6083.46 C 5789.23 6090.62 5789.23 6100.66 5794.97 6109.26 C 5729.04 6147.95 5766.3 6130.75 5786.37 6165.15 C 5789.23 6170.88 5783.5 6180.91 5787.8 6186.65 C 5792.1 6196.68 5806.43 6198.11 5810.73 6206.71 C 5817.9 6219.61 5772.04 6256.87 5764.87 6258.3 C 5760.57 6259.74 5757.71 6251.14 5753.41 6251.14 C 5746.24 6252.57 5733.34 6252.57 5733.34 6259.74 C 5730.48 6282.67 5777.77 6301.3 5784.94 6312.77 C 5789.23 6321.36 5790.67 6332.83 5790.67 6344.29 C 5789.23 6348.59 5776.34 6341.43 5774.9 6345.73 C 5773.47 6348.59 5777.77 6351.46 5776.34 6352.89 C 5772.04 6360.06 5764.87 6364.36 5759.14 6370.09 C 5754.84 6378.69 5769.17 6382.99 5770.6 6387.29 C 5770.6 6390.16 5763.44 6390.16 5763.44 6393.02 C 5762 6413.09 5799.27 6440.32 5815.03 6444.62 C 5823.63 6447.48 5833.66 6443.18 5842.26 6443.18 C 5850.86 6441.75 5860.89 6436.02 5868.06 6440.32 C 5889.56 6456.08 5840.83 6489.04 5847.99 6514.84 C 5846.56 6514.84 5822.2 6523.44 5819.33 6526.31 C 5817.9 6527.74 5822.2 6533.47 5819.33 6533.47 C 5817.9 6532.04 5819.33 6526.31 5817.9 6526.31 C 5809.3 6527.74 5799.27 6529.17 5793.53 6534.91 C 5789.23 6539.21 5796.4 6549.24 5790.67 6553.54 C 5784.94 6557.84 5774.9 6552.1 5767.74 6556.4 C 5762 6560.7 5763.44 6572.17 5756.27 6577.9 C 5750.54 6580.77 5743.37 6573.6 5737.64 6576.47 C 5733.34 6577.9 5736.21 6585.07 5731.91 6589.37 C 5727.61 6595.1 5716.14 6596.53 5713.28 6603.7 C 5711.84 6609.43 5724.74 6618.03 5719.01 6622.33 C 5711.84 6629.49 5697.51 6622.33 5687.48 6623.76 C 5674.58 6626.63 5665.98 6639.53 5654.52 6643.83 C 5641.62 6648.13 5651.65 6628.06 5622.99 6626.63 C 5604.36 6625.2 5624.42 6633.79 5621.55 6636.66 C 5618.69 6639.53 5612.96 6639.53 5608.66 6638.09 C 5604.36 6638.09 5600.06 6638.09 5598.62 6635.23 C 5598.62 6632.36 5608.66 6625.2 5588.59 6615.16 C 5584.29 6613.73 5579.99 6615.16 5574.26 6615.16 C 5564.23 6612.3 5552.76 6613.73 5545.6 6606.56 C 5538.43 6599.4 5545.6 6585.07 5539.86 6577.9 C 5537 6573.6 5531.27 6583.63 5525.53 6583.63 C 5516.93 6583.63 5499.74 6586.5 5501.17 6577.9 C 5502.6 6566.44 5528.4 6570.73 5529.83 6559.27 C 5529.83 6547.8 5514.07 6539.21 5504.04 6540.64 C 5495.44 6542.07 5511.2 6557.84 5506.9 6563.57 C 5499.74 6570.73 5488.27 6575.03 5478.24 6573.6 C 5455.31 6572.17 5462.47 6532.04 5458.17 6537.77 C 5438.11 6560.7 5482.54 6570.73 5469.64 6576.47 C 5423.78 6595.1 5443.84 6565 5442.41 6559.27 C 5440.98 6553.54 5390.81 6547.8 5386.52 6544.94 C 5375.05 6539.21 5360.72 6520.57 5346.39 6529.17 C 5330.62 6537.77 5307.69 6566.44 5291.93 6575.03 C 5277.59 6582.2 5248.93 6576.47 5231.73 6600.83 C 5228.87 6603.7 5236.03 6609.43 5236.03 6613.73 C 5233.17 6628.06 5214.54 6636.66 5213.1 6652.43 C 5213.1 6656.72 5223.13 6655.29 5224.57 6659.59 C 5231.73 6685.39 5213.1 6678.22 5223.13 6706.89 C 5226 6715.48 5234.6 6722.65 5243.2 6729.82 L 5237.47 6729.82 C 5214.54 6724.08 5188.74 6711.19 5167.24 6725.52 C 5162.94 6728.38 5168.67 6739.85 5162.94 6741.28 C 5148.61 6745.58 5124.25 6716.92 5109.91 6716.92 C 5097.02 6716.92 5086.98 6724.08 5075.52 6725.52 C 5066.92 6726.95 5065.49 6711.19 5062.62 6708.32 C 5055.45 6702.59 5043.99 6699.72 5033.96 6695.42 C 5048.29 6676.79 5045.42 6658.16 5008.16 6661.02 C 5006.73 6661.02 5002.43 6666.76 4999.56 6673.92 L 4999.56 6672.49 C 4992.39 6668.19 4996.69 6655.29 4989.53 6649.56 C 4985.23 6645.26 4976.63 6645.26 4969.46 6643.83 C 4966.6 6643.83 4962.3 6645.26 4960.87 6643.83 C 4945.1 6629.49 4930.77 6612.3 4906.4 6608 C 4889.21 6605.13 4896.37 6638.09 4896.37 6638.09 C 4880.61 6636.66 4867.71 6625.2 4853.38 6626.63 C 4849.08 6626.63 4849.08 6635.23 4844.78 6635.23 C 4836.18 6633.79 4831.88 6623.76 4823.28 6622.33 C 4814.68 6620.9 4808.95 6629.49 4800.35 6628.06 C 4781.72 6628.06 4788.89 6609.43 4778.85 6600.83 C 4758.79 6583.63 4740.16 6609.43 4721.53 6595.1 C 4720.09 6595.1 4705.76 6562.14 4704.33 6560.7 C 4685.7 6546.37 4654.17 6553.54 4634.1 6534.91 C 4631.24 6532.04 4635.54 6524.87 4634.1 6522.01 C 4631.24 6519.14 4622.64 6534.91 4614.04 6532.04 C 4595.41 6523.44 4636.97 6506.24 4624.07 6491.91 C 4619.77 6486.18 4611.17 6483.31 4604.01 6481.88 C 4602.57 6481.88 4604.01 6489.04 4601.14 6487.61 C 4601.14 6487.61 4585.38 6473.28 4576.78 6464.68 C 4585.38 6463.25 4591.11 6461.81 4596.84 6458.95 C 4638.4 6438.88 4655.6 6301.3 4671.37 6258.3 C 4674.23 6251.14 4677.1 6241.11 4684.26 6238.24 C 4690 6235.37 4702.9 6248.27 4705.76 6241.11 C 4710.06 6233.94 4700.03 6222.48 4691.43 6221.04 C 4684.26 6219.61 4682.83 6239.67 4675.67 6236.81 C 4661.33 6232.51 4682.83 6209.58 4685.7 6195.25 C 4691.43 6172.31 4707.19 6087.76 4722.96 6076.29 C 4728.69 6073.43 4748.76 6104.96 4754.49 6119.29 C 4774.55 6162.28 4747.32 6122.15 4761.66 6168.02 C 4764.52 6176.61 4773.12 6183.78 4775.99 6192.38 C 4777.42 6196.68 4771.69 6209.58 4775.99 6208.14 C 4783.15 6206.71 4787.45 6196.68 4786.02 6190.95 C 4783.15 6182.35 4773.12 6179.48 4767.39 6172.31 C 4755.92 6153.68 4771.69 6119.29 4760.22 6097.79 C 4754.49 6086.32 4744.46 6076.29 4735.86 6066.26 C 4730.13 6059.09 4722.96 6051.93 4714.36 6046.2 C 4722.96 6049.06 4732.99 6051.93 4741.59 6047.63 C 4751.62 6041.9 4720.09 6027.57 4722.96 6016.1 C 4725.83 6004.63 4738.72 5998.9 4740.16 5987.44 C 4741.59 5978.84 4731.56 5971.67 4731.56 5963.07 C 4731.56 5953.04 4740.16 5943.01 4740.16 5932.98 C 4740.16 5930.11 4732.99 5930.11 4728.69 5931.54 C 4725.83 5932.98 4728.69 5941.58 4725.83 5940.14 C 4718.66 5937.28 4717.23 5925.81 4711.49 5921.51 C 4707.19 5920.08 4701.46 5925.81 4697.16 5922.94 C 4692.86 5920.08 4697.16 5910.05 4692.86 5907.18 C 4667.07 5882.82 4681.4 5935.84 4657.03 5888.55 C 4655.6 5884.25 4654.17 5852.72 4648.44 5845.55 C 4647 5844.12 4642.7 5845.55 4641.27 5844.12 C 4635.54 5835.52 4628.37 5825.49 4624.07 5815.46 C 4618.34 5801.12 4647 5786.79 4649.87 5781.06 C 4655.6 5768.16 4621.2 5759.56 4621.2 5758.13 C 4618.34 5748.1 4618.34 5742.37 4619.77 5738.07 L 4618.34 5738.07 C 4559.58 5732.33 4614.04 5718 4615.47 5686.47 C 4616.91 5667.84 4556.71 5683.61 4555.28 5676.44 C 4552.41 5664.97 4569.61 5660.67 4578.21 5654.94 C 4579.64 5653.51 4571.04 5657.81 4569.61 5656.38 C 4568.18 5654.94 4569.61 5650.64 4568.18 5649.21 C 4563.88 5649.21 4562.45 5653.51 4558.15 5654.94 C 4546.68 5654.94 4535.21 5646.34 4525.18 5650.64 C 4523.75 5652.08 4522.32 5653.51 4522.32 5654.94 L 4522.32 5653.51 C 4525.18 5634.88 4539.51 5616.25 4509.42 5613.38 C 4493.65 5611.95 4497.95 5632.01 4486.49 5624.85 C 4477.89 5619.11 4466.42 5600.48 4457.82 5596.18 C 4452.09 5594.75 4444.93 5600.48 4440.63 5596.18 C 4421.99 5581.85 4444.93 5564.65 4409.1 5567.52 C 4406.23 5568.95 4411.96 5576.12 4409.1 5577.55 C 4399.06 5581.85 4384.73 5590.45 4376.13 5583.28 C 4367.53 5577.55 4376.13 5561.79 4373.27 5551.75 C 4368.97 5534.56 4350.34 5538.86 4338.87 5531.69 C 4337.44 5530.26 4341.74 5525.96 4344.6 5525.96 C 4358.94 5523.09 4373.27 5524.52 4387.6 5524.52 C 4390.47 5524.52 4397.63 5530.26 4397.63 5527.39 C 4397.63 5524.52 4384.73 5504.46 4376.13 5490.13 L 4377.57 5491.56 C 4384.73 5494.43 4393.33 5491.56 4401.93 5492.99 C 4407.66 5492.99 4420.56 5498.73 4416.26 5495.86 C 4406.23 5490.13 4389.03 5492.99 4384.73 5482.96 C 4381.87 5474.36 4404.8 5477.23 4406.23 5468.63 C 4410.53 5451.43 4320.24 5517.36 4350.34 5439.97 C 4351.77 5439.97 4399.06 5421.34 4411.96 5421.34 C 4427.73 5421.34 4391.9 5439.97 4426.29 5429.93 C 4436.33 5428.5 4446.36 5417.04 4456.39 5419.9 C 4464.99 5422.77 4460.69 5439.97 4469.29 5442.83 C 4475.02 5442.83 4470.72 5425.64 4476.46 5424.2 C 4486.49 5424.2 4493.65 5442.83 4503.69 5439.97 C 4512.28 5437.1 4506.55 5418.47 4515.15 5412.74 C 4518.02 5409.87 4523.75 5418.47 4528.05 5418.47 C 4536.65 5418.47 4546.68 5409.87 4553.85 5414.17 C 4561.01 5418.47 4555.28 5432.8 4562.45 5437.1 C 4566.74 5439.97 4566.74 5429.93 4571.04 5427.07 C 4578.21 5421.34 4601.14 5482.96 4606.87 5494.43 C 4608.31 5495.86 4608.31 5488.69 4611.17 5488.69 C 4619.77 5482.96 4628.37 5481.53 4638.4 5477.23 C 4645.57 5472.93 4651.3 5461.46 4658.47 5464.33 C 4671.37 5470.06 4659.9 5520.22 4694.3 5505.89 C 4704.33 5501.59 4698.6 5482.96 4705.76 5472.93 C 4712.93 5462.9 4714.36 5492.99 4722.96 5494.43 C 4731.56 5495.86 4738.72 5491.56 4747.32 5492.99 C 4755.92 5492.99 4773.12 5505.89 4775.99 5497.29 C 4778.85 5481.53 4745.89 5470.06 4750.19 5454.3 C 4753.06 5444.27 4755.92 5434.23 4760.22 5424.2 C 4757.36 5424.2 4754.49 5422.77 4755.92 5417.04 C 4758.79 5407 4767.39 5395.54 4767.39 5384.07 C 4767.39 5381.21 4758.79 5385.51 4757.36 5382.64 C 4754.49 5375.47 4757.36 5364.01 4753.06 5356.84 C 4751.62 5352.54 4743.02 5352.54 4740.16 5348.24 C 4737.29 5339.65 4735.86 5328.18 4737.29 5319.58 C 4737.29 5315.28 4744.46 5313.85 4744.46 5310.98 C 4744.46 5300.95 4738.72 5290.92 4737.29 5280.89 C 4737.29 5278.02 4740.16 5286.62 4741.59 5288.05 C 4753.06 5293.78 4763.09 5299.52 4774.55 5302.38 C 4777.42 5303.82 4781.72 5300.95 4784.59 5300.95 C 4796.05 5300.95 4807.52 5295.22 4817.55 5300.95 C 4823.28 5302.38 4820.41 5310.98 4817.55 5316.71 C 4816.12 5319.58 4811.82 5318.15 4808.95 5321.01 C 4804.65 5325.31 4820.41 5371.18 4821.85 5371.18 C 4880.61 5379.77 4796.05 5343.95 4841.91 5361.14 C 4863.41 5369.74 4890.64 5374.04 4910.7 5384.07 C 4917.87 5388.37 4922.17 5398.41 4929.34 5399.84 C 4962.3 5404.14 4955.13 5385.51 4979.5 5378.34 C 4985.23 5376.91 4990.96 5376.91 4998.13 5376.91 C 4982.36 5374.04 4968.03 5364.01 4988.1 5329.61 C 5002.43 5306.68 5098.45 5303.82 5124.25 5289.48 C 5134.28 5285.19 5141.44 5276.59 5151.48 5270.85 C 5160.08 5266.55 5175.84 5267.99 5180.14 5259.39 C 5184.44 5250.79 5168.67 5246.49 5167.24 5237.89 C 5165.81 5233.59 5167.24 5226.43 5170.11 5223.56 C 5172.97 5220.69 5178.71 5226.43 5178.71 5223.56 C 5178.71 5220.69 5171.54 5220.69 5171.54 5216.39 C 5171.54 5206.36 5183.01 5137.57 5185.87 5130.4 C 5191.6 5113.21 5238.9 5110.34 5251.8 5108.91 C 5269 5107.47 5286.19 5106.04 5301.96 5103.17 M 6105.96 6666.76 C 6126.03 6681.09 6106.97 6713.83 6106.97 6729.59 C 6113.9 6739.57 6115.28 6745.68 6118.86 6754.18 C 6123.16 6764.21 6123.16 6795.74 6123.16 6804.34 C 6124.6 6828.7 6100.23 6847.34 6100.23 6864.53 C 6100.23 6883.16 6107.4 6908.96 6091.63 6926.16 C 6090.2 6929.03 6083.03 6926.16 6083.03 6929.03 C 6083.03 6933.33 6093.07 6929.03 6091.63 6931.89 C 6091.63 6937.63 6083.03 6937.63 6080.17 6941.92 C 6075.87 6951.96 6080.17 6964.86 6073 6973.45 C 6052.94 6993.52 6058.67 6951.96 6054.37 6950.52 C 6035.74 6944.79 6024.27 6959.12 6011.38 6937.63 C 6008.51 6933.33 6017.11 6927.59 6014.24 6921.86 C 6009.94 6913.26 5992.74 6910.4 5994.18 6900.36 C 5994.18 6888.9 6017.11 6883.16 6015.68 6871.7 C 6014.24 6863.1 5991.31 6880.3 5989.88 6871.7 C 5987.01 6860.23 6009.94 6854.5 6008.51 6844.47 C 6007.08 6833 5985.58 6835.87 5982.71 6824.41 C 5981.28 6815.81 5999.91 6812.94 5999.91 6802.91 C 5999.91 6794.31 5985.58 6790.01 5981.28 6781.41 C 5979.85 6775.68 5995.61 6779.98 5998.48 6775.68 C 6001.34 6765.65 5999.91 6752.75 6005.64 6744.15 C 6007.08 6741.28 6009.94 6751.31 6012.81 6749.88 C 6019.97 6748.45 6021.41 6738.42 6028.57 6735.55 C 6034.31 6732.68 6041.47 6738.42 6047.2 6735.55 C 6054.37 6731.25 6054.37 6718.35 6061.54 6716.92 C 6070.14 6715.48 6077.3 6726.95 6087.33 6726.95 C 6095.93 6726.95 6085.9 6708.32 6087.33 6698.29 C 6088.77 6686.82 6100.23 6678.22 6105.96 6666.76 M 5774.9 6543.5 C 5786.37 6543.5 5796.4 6533.47 5796.4 6523.44 C 5796.4 6513.41 5786.37 6504.81 5774.9 6504.81 C 5763.44 6504.81 5753.41 6513.41 5753.41 6523.44 C 5753.41 6533.47 5763.44 6543.5 5774.9 6543.5 C 5786.37 6543.5 5763.44 6543.5 5774.9 6543.5 " }
                }
            }
            // PATH visit es count: 617
            DemoShape {
                objectName: "es"
                ShapePath {
                    objectName: "svg_path:es"
                    // boundingRect: 3543.69, 6217.38 1812.65x1726.33
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5033.96 6695.42 C 5043.99 6699.72 5055.45 6702.59 5062.62 6708.32 C 5065.49 6711.18 5066.92 6726.95 5075.52 6725.52 C 5086.98 6724.08 5097.02 6716.92 5109.91 6716.92 C 5124.25 6716.92 5148.61 6745.58 5162.94 6741.28 C 5168.67 6739.85 5162.94 6728.38 5167.24 6725.52 C 5188.74 6711.19 5214.54 6724.08 5237.47 6729.82 L 5243.2 6729.82 C 5250.36 6736.98 5256.1 6744.15 5253.23 6752.75 C 5250.36 6764.21 5231.73 6761.35 5224.57 6768.51 C 5218.84 6774.24 5241.77 6807.21 5227.43 6831.57 C 5220.27 6847.34 5158.64 6871.7 5141.44 6878.87 C 5125.68 6884.6 5101.32 6890.33 5089.85 6900.36 C 5081.25 6906.1 5068.35 6927.59 5055.45 6930.46 C 5006.73 6944.79 4919.3 6934.76 4880.61 6966.29 C 4870.58 6974.89 4850.51 6982.05 4853.38 6994.95 C 4857.68 7004.98 4879.17 7003.55 4877.74 7013.58 C 4877.74 7017.88 4833.31 7027.91 4830.45 7029.35 C 4813.25 7042.25 4807.52 7066.61 4793.18 7080.94 C 4753.06 7122.5 4700.03 7162.63 4674.23 7215.66 C 4662.77 7237.16 4678.53 7305.95 4691.43 7324.58 C 4695.73 7330.31 4748.76 7360.41 4735.86 7369.01 C 4725.83 7377.61 4701.46 7380.47 4691.43 7387.64 C 4688.56 7390.51 4688.56 7397.67 4685.7 7399.1 C 4682.83 7401.97 4678.53 7397.67 4675.67 7397.67 C 4664.2 7400.54 4651.3 7401.97 4641.27 7409.14 C 4636.97 7413.44 4639.84 7423.47 4634.1 7427.77 C 4629.8 7430.63 4622.64 7424.9 4619.77 7427.77 C 4614.04 7434.93 4618.34 7446.4 4614.04 7452.13 C 4608.31 7457.86 4596.84 7452.13 4592.54 7459.3 C 4586.81 7467.9 4595.41 7480.79 4591.11 7489.39 C 4579.64 7518.06 4553.85 7485.09 4552.41 7530.96 C 4552.41 7542.42 4575.34 7546.72 4572.48 7556.75 C 4568.18 7566.78 4552.41 7565.35 4540.95 7563.92 C 4533.78 7563.92 4526.62 7556.75 4519.45 7555.32 C 4489.35 7546.72 4453.52 7561.05 4427.73 7578.25 C 4383.3 7606.91 4383.3 7662.81 4337.44 7685.74 C 4320.24 7695.77 4314.51 7648.48 4271.51 7659.94 C 4262.91 7662.81 4258.61 7674.27 4248.58 7677.14 C 4235.68 7681.44 4205.59 7657.07 4192.69 7655.64 C 4175.49 7651.34 4156.86 7661.37 4138.23 7658.51 C 4128.2 7655.64 4122.46 7647.04 4112.43 7644.18 C 4093.8 7637.01 4009.24 7624.11 3993.48 7626.98 C 3976.28 7631.28 3967.68 7652.77 3951.92 7659.94 C 3928.99 7668.54 3900.32 7642.74 3868.79 7658.51 C 3843 7671.41 3845.86 7682.87 3832.96 7701.5 C 3831.53 7702.94 3822.93 7694.34 3817.2 7698.64 C 3808.6 7705.8 3801.43 7717.27 3789.97 7721.57 C 3785.67 7723 3785.67 7712.97 3781.37 7710.1 C 3775.64 7705.8 3767.04 7704.37 3762.74 7700.07 C 3757.01 7692.9 3755.57 7682.87 3748.41 7677.14 C 3744.11 7672.84 3735.51 7677.14 3731.21 7672.84 C 3721.18 7662.81 3706.85 7615.51 3703.98 7601.18 C 3703.98 7599.75 3725.48 7621.25 3722.61 7608.35 C 3722.61 7604.05 3714.01 7608.35 3712.58 7605.48 C 3711.14 7602.61 3718.31 7599.75 3716.88 7596.88 C 3712.58 7572.52 3691.08 7601.18 3692.51 7559.62 C 3692.51 7559.62 3748.41 7533.82 3735.51 7530.96 C 3724.04 7528.09 3716.88 7552.45 3705.41 7549.59 C 3695.38 7548.15 3699.68 7530.96 3695.38 7522.36 C 3691.08 7513.76 3685.35 7506.59 3679.62 7499.43 C 3679.62 7499.43 3640.92 7462.16 3640.92 7462.16 C 3640.92 7460.73 3640.92 7460.73 3640.92 7459.3 C 3639.49 7462.16 3638.05 7463.6 3635.19 7463.6 C 3626.59 7465.03 3622.29 7453.56 3615.12 7449.27 C 3609.39 7446.4 3583.59 7442.1 3564.96 7442.1 C 3567.83 7381.91 3553.5 7371.87 3600.79 7330.31 C 3609.39 7323.15 3607.96 7307.38 3616.56 7303.08 C 3619.42 7301.65 3689.65 7300.22 3672.45 7271.55 C 3668.15 7264.39 3653.82 7275.85 3646.65 7271.55 C 3639.49 7265.82 3640.92 7254.35 3638.05 7245.76 C 3635.19 7237.16 3635.19 7227.12 3629.45 7219.96 C 3628.02 7217.09 3619.42 7219.96 3619.42 7217.09 C 3623.72 7207.06 3633.75 7199.89 3638.05 7189.86 C 3646.65 7172.66 3622.29 7185.56 3646.65 7165.5 C 3668.15 7148.3 3696.81 7151.17 3699.68 7113.9 C 3699.68 7111.04 3672.45 7092.41 3666.72 7080.94 C 3658.12 7062.31 3668.15 7032.21 3668.15 7029.35 C 3666.72 7027.91 3643.79 6983.49 3643.79 6982.05 C 3642.35 6979.19 3648.09 6983.49 3650.95 6983.49 C 3663.85 6987.79 3672.45 6989.22 3685.35 6992.09 C 3718.31 7000.68 3725.48 7003.55 3742.67 6970.59 C 3762.74 6930.46 3741.24 6944.79 3736.94 6914.69 C 3732.64 6887.46 3777.07 6900.36 3778.5 6880.3 C 3779.94 6865.97 3764.17 6878.87 3772.77 6861.67 C 3774.2 6858.8 3779.94 6858.8 3781.37 6854.5 C 3785.67 6844.47 3785.67 6834.44 3787.1 6824.41 C 3788.54 6812.94 3797.13 6801.47 3795.7 6790.01 C 3795.7 6790.01 3782.8 6755.61 3782.8 6755.61 C 3787.1 6751.31 3797.13 6759.91 3802.87 6757.05 C 3802.87 6757.05 3832.96 6725.52 3832.96 6725.52 C 3854.46 6714.05 3894.59 6712.62 3906.06 6681.09 C 3914.65 6652.43 3877.39 6655.29 3867.36 6653.86 C 3860.19 6652.43 3873.09 6597.97 3867.36 6595.1 C 3840.13 6580.77 3834.4 6593.67 3801.43 6580.77 C 3795.7 6577.9 3797.13 6563.57 3784.24 6572.17 C 3781.37 6575.03 3787.1 6582.2 3784.24 6585.07 C 3764.17 6602.26 3742.67 6582.2 3736.94 6580.77 C 3731.21 6577.9 3724.04 6585.07 3719.74 6582.2 C 3716.88 6580.77 3728.34 6577.9 3725.48 6575.03 C 3724.04 6569.3 3716.88 6567.87 3711.14 6567.87 C 3702.55 6566.44 3692.51 6569.3 3683.91 6567.87 C 3682.48 6566.44 3685.35 6563.57 3685.35 6560.7 C 3685.35 6559.27 3686.78 6553.54 3685.35 6554.97 C 3678.18 6556.4 3660.98 6576.47 3648.09 6567.87 C 3613.69 6543.5 3681.05 6537.77 3663.85 6520.57 C 3660.98 6517.71 3655.25 6520.57 3652.38 6517.71 C 3650.95 6514.84 3658.12 6509.11 3655.25 6507.68 C 3629.45 6501.94 3593.63 6510.54 3572.13 6522.01 C 3574.99 6510.54 3559.23 6500.51 3559.23 6489.04 C 3557.8 6484.74 3566.4 6494.78 3569.26 6491.91 C 3572.13 6490.48 3566.4 6484.74 3567.83 6481.88 C 3570.69 6468.98 3592.19 6473.28 3602.22 6464.68 C 3605.09 6463.25 3610.82 6456.08 3606.52 6457.51 C 3597.92 6458.95 3589.33 6467.55 3580.73 6468.98 C 3573.56 6470.41 3570.69 6457.51 3576.43 6451.78 C 3585.03 6446.05 3603.66 6450.35 3606.52 6440.32 C 3607.96 6431.72 3587.89 6443.18 3580.73 6440.32 C 3574.99 6437.45 3570.69 6430.28 3569.26 6424.55 C 3567.83 6410.22 3582.16 6428.85 3583.59 6427.42 C 3586.46 6421.69 3583.59 6414.52 3587.89 6408.79 C 3592.19 6401.62 3605.09 6400.19 3606.52 6391.59 C 3613.69 6321.36 3556.36 6401.62 3544.9 6332.83 C 3536.3 6285.53 3576.43 6299.87 3577.86 6292.7 C 3579.29 6288.4 3566.4 6292.7 3562.1 6289.83 C 3560.66 6286.97 3566.4 6284.1 3567.83 6284.1 C 3583.59 6281.24 3592.19 6285.53 3603.66 6284.1 C 3640.92 6281.24 3691.08 6249.71 3725.48 6235.37 C 3738.37 6229.64 3752.71 6211.01 3765.61 6219.61 C 3771.34 6223.91 3757.01 6241.11 3764.17 6242.54 C 3775.64 6243.97 3782.8 6223.91 3794.27 6223.91 C 3832.96 6223.91 3830.1 6291.27 3865.93 6299.87 C 3873.09 6301.3 3875.96 6285.53 3883.12 6286.97 C 3923.25 6297 3901.76 6298.43 3941.88 6304.17 C 3951.92 6305.6 3970.55 6301.3 3979.15 6302.73 C 3987.75 6305.6 3992.05 6314.2 4000.64 6314.2 C 4012.11 6314.2 4022.14 6299.87 4033.61 6302.73 C 4043.64 6305.6 4045.07 6322.8 4053.67 6329.96 C 4062.27 6337.13 4079.47 6328.53 4088.07 6337.13 C 4090.93 6340 4082.33 6344.29 4085.2 6345.73 C 4088.07 6350.03 4096.67 6340 4100.97 6342.86 C 4136.8 6367.23 4229.95 6413.09 4277.25 6398.75 C 4280.11 6397.32 4280.11 6391.59 4282.98 6390.16 C 4288.71 6388.72 4294.44 6390.16 4300.18 6390.16 C 4311.64 6391.59 4341.74 6388.72 4350.34 6405.92 C 4350.34 6407.35 4348.9 6410.22 4347.47 6411.65 C 4358.94 6414.52 4390.47 6444.62 4401.93 6444.62 C 4406.23 6444.62 4399.06 6434.58 4401.93 6431.72 C 4404.8 6427.42 4410.53 6425.99 4416.26 6424.55 C 4457.82 6418.82 4430.59 6423.12 4447.79 6443.18 C 4453.52 6448.92 4464.99 6440.32 4470.72 6444.62 C 4479.32 6448.92 4483.62 6458.95 4490.79 6463.25 C 4509.42 6473.28 4549.55 6471.85 4576.78 6464.68 C 4585.38 6473.28 4601.14 6487.61 4601.14 6487.61 C 4604.01 6489.04 4602.57 6481.88 4604.01 6481.88 C 4611.17 6483.31 4619.77 6486.18 4624.07 6491.91 C 4636.97 6506.24 4595.41 6523.44 4614.04 6532.04 C 4622.64 6534.91 4631.24 6519.14 4634.1 6522.01 C 4635.54 6524.87 4631.24 6532.04 4634.1 6534.91 C 4654.17 6553.54 4685.7 6546.37 4704.33 6560.7 C 4705.76 6562.14 4720.09 6595.1 4721.53 6595.1 C 4740.16 6609.43 4758.79 6583.63 4778.85 6600.83 C 4788.89 6609.43 4781.72 6628.06 4800.35 6628.06 C 4808.95 6629.49 4814.68 6620.9 4823.28 6622.33 C 4831.88 6623.76 4836.18 6633.79 4844.78 6635.23 C 4849.08 6635.23 4849.08 6626.63 4853.38 6626.63 C 4867.71 6625.19 4880.61 6636.66 4896.37 6638.09 C 4896.37 6638.09 4889.21 6605.13 4906.4 6608 C 4930.77 6612.3 4945.1 6629.49 4960.87 6643.83 C 4962.3 6645.26 4966.6 6643.83 4969.46 6643.83 C 4976.63 6645.26 4985.23 6645.26 4989.53 6649.56 C 4996.69 6655.29 4992.39 6668.19 4999.56 6672.49 L 4999.56 6673.92 C 4992.39 6688.25 4989.53 6708.32 5033.96 6695.42 M 3785.67 7755.96 L 3795.7 7797.52 L 3827.23 7797.52 C 3827.23 7793.23 3825.8 7790.36 3825.8 7786.06 C 3824.36 7777.46 3821.5 7768.86 3824.36 7760.26 C 3825.8 7755.96 3838.7 7754.53 3837.26 7750.23 C 3828.66 7730.17 3788.54 7754.53 3785.67 7755.96 M 4155.43 7929.38 L 4176.92 7943.71 C 4176.92 7930.81 4179.79 7916.48 4178.36 7905.01 C 4175.49 7893.55 4164.03 7922.21 4155.43 7929.38 M 4182.66 7940.84 L 4185.52 7936.54 C 4184.09 7936.54 4182.66 7936.54 4182.66 7939.41 C 4182.66 7940.84 4182.66 7940.84 4182.66 7940.84 M 5193.04 7188.43 C 5171.54 7261.52 5197.34 7209.93 5233.17 7240.02 C 5243.2 7248.62 5170.11 7318.85 5164.37 7317.41 C 5157.21 7317.41 5158.64 7301.65 5151.48 7297.35 C 5129.98 7284.45 5128.55 7307.38 5121.38 7285.88 C 5118.51 7275.85 5121.38 7262.95 5114.21 7257.22 C 5108.48 7251.49 5099.88 7261.52 5094.15 7260.09 C 5084.12 7258.65 5074.09 7254.35 5065.49 7248.62 C 5064.05 7247.19 5066.92 7244.32 5068.35 7242.89 C 5104.18 7215.66 5148.61 7197.03 5193.04 7188.43 M 5343.52 7189.86 C 5376.48 7272.99 5337.79 7215.66 5317.72 7205.63 C 5309.12 7202.76 5297.66 7209.93 5289.06 7204.19 C 5253.23 7179.83 5300.53 7169.8 5343.52 7189.86 M 5088.42 7324.58 C 5079.82 7333.18 5066.92 7333.18 5066.92 7340.34 C 5066.92 7346.08 5072.65 7357.54 5079.82 7357.54 C 5088.42 7357.54 5094.15 7357.54 5105.61 7347.51 C 5117.08 7337.48 5105.61 7330.31 5105.61 7330.31 L 5089.85 7324.58 L 5088.42 7324.58 M 5054.02 7281.59 C 5042.56 7284.45 5039.69 7291.62 5033.96 7298.78 C 5028.22 7307.38 5019.63 7320.28 5032.52 7326.01 C 5039.69 7330.31 5061.19 7318.85 5065.49 7310.25 C 5068.35 7303.08 5076.95 7301.65 5076.95 7293.05 C 5076.95 7285.88 5066.92 7280.15 5066.92 7280.15 L 5054.02 7281.59 " }
                }
            }
            // PATH visit pt count: 265
            DemoShape {
                objectName: "pt"
                ShapePath {
                    objectName: "svg_path:pt"
                    // boundingRect: 3325.32, 6505.85 582.011x959.21
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 3564.96 7442.1 C 3567.83 7381.91 3553.5 7371.87 3600.79 7330.31 C 3609.39 7323.15 3607.96 7307.38 3616.56 7303.08 C 3619.42 7301.65 3689.65 7300.22 3672.45 7271.55 C 3668.15 7264.39 3653.82 7275.85 3646.65 7271.55 C 3639.49 7265.82 3640.92 7254.35 3638.05 7245.76 C 3635.19 7237.16 3635.19 7227.12 3629.45 7219.96 C 3628.02 7217.09 3619.42 7219.96 3619.42 7217.09 C 3623.72 7207.06 3633.75 7199.89 3638.05 7189.86 C 3646.65 7172.66 3622.29 7185.56 3646.65 7165.5 C 3668.15 7148.3 3696.81 7151.17 3699.68 7113.9 C 3699.68 7111.04 3672.45 7092.41 3666.72 7080.94 C 3658.12 7062.31 3668.15 7032.21 3668.15 7029.35 C 3666.72 7027.91 3643.79 6983.49 3643.79 6982.05 C 3642.35 6979.19 3648.09 6983.49 3650.95 6983.49 C 3663.85 6987.79 3672.45 6989.22 3685.35 6992.09 C 3718.31 7000.68 3725.48 7003.55 3742.67 6970.59 C 3762.74 6930.46 3741.24 6944.79 3736.94 6914.69 C 3732.64 6887.46 3777.07 6900.36 3778.5 6880.3 C 3779.94 6865.97 3764.17 6878.87 3772.77 6861.67 C 3774.2 6858.8 3779.94 6858.8 3781.37 6854.5 C 3785.67 6844.47 3785.67 6834.44 3787.1 6824.41 C 3788.54 6812.94 3797.13 6801.47 3795.7 6790.01 C 3795.7 6790.01 3782.8 6755.61 3782.8 6755.61 C 3787.1 6751.31 3797.13 6759.91 3802.87 6757.05 C 3802.87 6757.05 3832.96 6725.52 3832.96 6725.52 C 3854.46 6714.05 3894.59 6712.62 3906.06 6681.09 C 3914.65 6652.43 3877.39 6655.29 3867.36 6653.86 C 3860.19 6652.43 3873.09 6597.97 3867.36 6595.1 C 3840.13 6580.77 3834.4 6593.67 3801.43 6580.77 C 3795.7 6577.9 3797.13 6563.57 3784.24 6572.17 C 3781.37 6575.03 3787.1 6582.2 3784.24 6585.07 C 3764.17 6602.26 3742.67 6582.2 3736.94 6580.77 C 3731.21 6577.9 3724.04 6585.07 3719.74 6582.2 C 3716.88 6580.77 3728.34 6577.9 3725.48 6575.03 C 3724.04 6569.3 3716.88 6567.87 3711.14 6567.87 C 3702.55 6566.44 3692.51 6569.3 3683.91 6567.87 C 3682.48 6566.44 3685.35 6563.57 3685.35 6560.7 C 3685.35 6559.27 3686.78 6553.54 3685.35 6554.97 C 3678.18 6556.4 3660.98 6576.47 3648.09 6567.87 C 3613.69 6543.5 3681.05 6537.77 3663.85 6520.57 C 3660.98 6517.71 3655.25 6520.57 3652.38 6517.71 C 3650.95 6514.84 3658.12 6509.11 3655.25 6507.68 C 3629.45 6501.94 3593.63 6510.54 3572.13 6522.01 C 3569.26 6536.34 3533.43 6543.5 3542.03 6556.4 C 3547.76 6563.57 3564.96 6560.7 3567.83 6569.3 C 3570.69 6576.47 3552.06 6567.87 3547.76 6573.6 C 3539.17 6586.5 3540.6 6648.13 3543.46 6663.89 C 3543.46 6668.19 3550.63 6669.62 3550.63 6675.36 C 3549.2 6699.72 3539.17 6714.05 3529.13 6734.12 C 3524.83 6742.71 3506.2 6761.35 3516.23 6759.91 C 3526.27 6757.05 3526.27 6735.55 3536.3 6732.68 C 3543.46 6731.25 3547.76 6745.58 3544.9 6751.31 C 3537.73 6761.35 3517.67 6757.05 3510.5 6768.51 C 3500.47 6785.71 3494.74 6805.77 3483.27 6822.97 C 3478.97 6830.14 3470.37 6834.44 3471.81 6841.6 C 3471.81 6848.77 3484.7 6851.64 3487.57 6858.8 C 3489 6861.67 3480.41 6850.2 3476.11 6853.07 C 3468.94 6857.37 3466.07 6868.83 3460.34 6877.43 C 3446.01 6900.36 3430.24 6929.03 3413.05 6949.09 C 3408.75 6954.82 3400.15 6956.26 3394.42 6963.42 C 3392.98 6964.86 3401.58 6969.15 3398.71 6970.59 C 3387.25 6973.45 3372.92 6963.42 3365.75 6970.59 C 3358.59 6977.75 3371.48 6989.22 3368.62 6997.82 C 3364.32 7012.15 3321.32 7072.34 3325.62 7086.67 C 3328.49 7096.71 3335.66 7105.31 3341.39 7115.34 C 3355.72 7139.7 3349.99 7151.17 3349.99 7151.17 C 3361.45 7154.03 3374.35 7152.6 3385.82 7151.17 C 3391.55 7151.17 3394.42 7144 3400.15 7145.43 C 3405.88 7145.43 3408.75 7154.03 3415.91 7155.47 C 3420.21 7156.9 3420.21 7136.84 3423.08 7141.13 C 3427.38 7148.3 3420.21 7158.33 3423.08 7164.07 C 3427.38 7169.8 3447.44 7172.66 3441.71 7175.53 C 3403.01 7194.16 3425.94 7145.43 3394.42 7149.73 C 3385.82 7151.17 3404.45 7162.63 3407.31 7169.8 C 3408.75 7178.4 3407.31 7188.43 3405.88 7198.46 C 3403.01 7217.09 3378.65 7234.29 3378.65 7248.62 C 3378.65 7254.35 3387.25 7258.65 3387.25 7264.39 C 3388.68 7274.42 3372.92 7293.05 3382.95 7295.92 C 3385.82 7295.92 3395.85 7291.62 3392.98 7294.48 C 3390.12 7298.78 3381.52 7295.92 3378.65 7300.22 C 3371.48 7314.55 3375.78 7331.75 3368.62 7346.08 C 3362.89 7357.54 3328.49 7404.84 3331.36 7420.6 C 3332.79 7426.33 3342.82 7414.87 3348.55 7414.87 C 3357.15 7413.44 3365.75 7416.3 3374.35 7414.87 C 3378.65 7414.87 3382.95 7410.57 3387.25 7412 C 3410.18 7417.74 3484.7 7466.46 3494.74 7465.03 C 3499.04 7465.03 3543.46 7443.53 3546.33 7442.1 C 3550.63 7442.1 3557.8 7442.1 3564.96 7442.1 " }
                }
            }
            // PATH visit at count: 269
            DemoShape {
                objectName: "at"
                ShapePath {
                    objectName: "svg_path:at"
                    // boundingRect: 6123.16, 5513.73 961.654x499.661
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6128.9 5816.89 C 6128.9 5826.92 6147.53 5829.79 6141.79 5844.12 C 6140.36 5846.99 6134.63 5845.55 6133.19 5846.99 C 6131.76 5851.29 6127.46 5862.75 6123.16 5875.65 L 6130.33 5891.41 L 6130.33 5908.61 C 6144.66 5910.05 6167.59 5912.91 6169.02 5912.91 C 6171.89 5915.78 6164.72 5920.08 6167.59 5922.94 C 6174.76 5931.54 6183.36 5937.28 6193.39 5941.58 C 6216.32 5953.04 6220.62 5914.34 6236.38 5917.21 C 6266.48 5921.51 6234.95 5937.28 6244.98 5941.58 C 6267.91 5953.04 6247.85 5938.71 6270.78 5941.58 C 6282.24 5943.01 6293.71 5973.1 6316.64 5960.21 C 6316.64 5960.21 6335.27 5921.51 6335.27 5921.51 C 6346.74 5912.91 6396.9 5918.64 6409.8 5917.21 C 6431.29 5915.78 6448.49 5897.15 6469.99 5897.15 C 6475.72 5897.15 6459.96 5904.31 6458.52 5910.05 C 6451.36 5940.14 6469.99 5920.08 6481.45 5937.28 C 6484.32 5941.58 6477.15 5947.31 6480.02 5953.04 C 6481.45 5955.91 6485.75 5950.17 6488.62 5953.04 C 6515.85 5973.1 6523.02 5975.97 6560.28 5981.7 C 6603.27 5987.44 6647.7 5988.87 6692.13 5996.04 C 6703.59 5997.47 6715.06 6006.07 6726.53 6007.5 C 6737.99 6008.93 6749.46 6000.33 6760.92 6001.77 C 6768.09 6003.2 6772.39 6013.23 6779.55 6013.23 C 6782.42 6014.67 6780.99 6006.07 6783.85 6004.63 C 6791.02 5997.47 6802.48 5994.6 6809.65 5986 C 6815.38 5981.7 6811.08 5971.67 6815.38 5967.37 C 6842.61 5945.87 6871.28 5973.1 6897.07 5961.64 C 6905.67 5957.34 6907.1 5944.44 6915.7 5941.58 C 6917.14 5940.14 6964.43 5947.31 6965.86 5945.87 C 6970.16 5944.44 6961.56 5938.71 6960.13 5934.41 C 6957.26 5920.08 6963 5911.48 6973.03 5908.61 C 6998.83 5879.95 7010.29 5875.65 7023.19 5854.15 C 7026.06 5848.42 7000.26 5818.32 7007.43 5803.99 C 7017.46 5783.93 7041.82 5805.42 7038.96 5776.76 C 7037.52 5752.4 6994.53 5755.26 7003.13 5748.1 C 7023.19 5730.9 7074.78 5753.83 7083.38 5738.07 C 7084.82 5732.33 7064.75 5686.47 7084.82 5677.87 C 7067.62 5659.24 7053.29 5640.61 7040.39 5619.11 C 7028.92 5600.48 7070.49 5570.39 7040.39 5548.89 C 7036.09 5546.02 7030.36 5554.62 7026.06 5554.62 C 7018.89 5553.19 7004.56 5534.56 6994.53 5537.42 C 6987.36 5540.29 6984.5 5551.75 6975.9 5556.05 C 6970.16 5557.49 6963 5554.62 6957.26 5554.62 C 6918.57 5550.32 6885.61 5518.79 6844.04 5518.79 C 6836.88 5518.79 6831.15 5527.39 6823.98 5527.39 C 6821.11 5525.96 6823.98 5518.79 6821.11 5517.36 C 6815.38 5514.49 6806.78 5511.63 6802.48 5515.92 C 6801.05 5518.79 6803.92 5560.35 6801.05 5563.22 C 6798.18 5567.52 6788.15 5557.49 6782.42 5561.79 C 6782.42 5561.79 6770.95 5599.05 6770.95 5599.05 C 6760.92 5601.91 6750.89 5589.02 6740.86 5589.02 C 6735.12 5589.02 6736.56 5600.48 6730.82 5601.91 C 6700.73 5613.38 6683.53 5583.28 6660.6 5571.82 L 6659.17 5571.82 C 6660.6 5576.12 6662.03 5580.42 6662.03 5584.72 C 6660.6 5623.41 6652 5614.81 6621.9 5607.65 C 6619.04 5607.65 6616.17 5609.08 6614.74 5611.95 C 6611.87 5626.28 6620.47 5642.04 6606.14 5653.51 C 6593.24 5663.54 6533.05 5677.87 6531.61 5700.8 C 6531.61 5700.8 6566.01 5748.1 6566.01 5749.53 C 6567.44 5750.96 6547.38 5768.16 6554.55 5773.89 C 6570.31 5788.23 6586.08 5766.73 6573.18 5814.02 C 6573.18 5816.89 6570.31 5821.19 6567.44 5821.19 C 6521.58 5808.29 6557.41 5785.36 6535.91 5783.93 C 6524.45 5783.93 6514.42 5793.96 6502.95 5792.53 C 6497.22 5791.09 6498.65 5781.06 6494.35 5779.63 C 6485.75 5776.76 6477.15 5783.93 6469.99 5781.06 C 6467.12 5779.63 6472.86 5771.03 6469.99 5771.03 C 6452.79 5772.46 6468.56 5795.39 6464.26 5796.83 C 6444.19 5802.56 6411.23 5793.96 6392.6 5801.12 C 6386.87 5803.99 6389.73 5814.02 6384 5816.89 C 6378.27 5821.19 6371.1 5814.02 6365.37 5818.32 C 6361.07 5819.76 6366.8 5826.92 6363.93 5829.79 C 6362.5 5831.22 6313.77 5844.12 6308.04 5841.25 C 6305.17 5838.39 6308.04 5831.22 6305.17 5828.35 C 6303.74 5825.49 6296.58 5825.49 6295.14 5822.62 C 6293.71 5819.76 6302.31 5821.19 6300.88 5818.32 C 6295.14 5799.69 6255.01 5822.62 6243.55 5809.72 C 6243.55 5809.72 6246.41 5808.29 6246.41 5806.86 C 6237.82 5801.12 6246.41 5825.49 6243.55 5835.52 C 6243.55 5841.25 6216.32 5874.22 6206.29 5864.18 C 6200.55 5858.45 6216.32 5849.85 6212.02 5844.12 C 6210.59 5842.69 6206.29 5848.42 6203.42 5848.42 C 6200.55 5848.42 6196.25 5846.99 6194.82 5844.12 C 6191.95 5839.82 6201.99 5834.09 6194.82 5828.35 C 6189.09 5824.06 6186.22 5816.89 6180.49 5814.02 C 6176.19 5811.16 6170.46 5818.32 6164.72 5816.89 C 6161.86 5814.02 6164.72 5806.86 6161.86 5803.99 C 6154.69 5798.26 6156.13 5824.06 6133.19 5816.89 C 6131.76 5815.46 6130.33 5815.46 6128.9 5815.46 L 6128.9 5816.89 " }
                }
            }
            // PATH visit it count: 711
            DemoShape {
                objectName: "it"
                ShapePath {
                    objectName: "svg_path:it"
                    // boundingRect: 5733.22, 5897.15 1686.97x1929.69
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7023.19 7523.79 C 7004.56 7533.82 6942.93 7682.87 6957.27 7702.94 C 6963 7711.53 6991.66 7711.53 6983.06 7717.27 C 6975.9 7721.57 6977.33 7707.24 6973.03 7717.27 C 6973.03 7720.13 6970.16 7723 6971.6 7727.3 C 6974.46 7738.76 6991.66 7744.5 6995.96 7755.96 C 6997.39 7758.83 6991.66 7757.4 6988.79 7760.26 C 6981.63 7764.56 6974.46 7768.86 6970.16 7776.03 C 6965.86 7783.19 6964.43 7791.79 6963 7798.96 C 6961.56 7807.56 6967.3 7819.02 6963 7826.19 C 6960.13 7830.49 6955.83 7811.86 6928.6 7813.29 C 6898.51 7816.16 6911.4 7826.19 6871.28 7807.56 C 6854.08 7800.39 6849.78 7768.86 6831.15 7757.4 C 6805.35 7741.63 6782.42 7757.4 6753.76 7745.93 C 6749.46 7744.5 6745.16 7743.06 6740.86 7740.2 C 6735.12 7735.9 6732.26 7725.87 6725.09 7723 C 6719.36 7718.7 6712.19 7723 6705.03 7720.13 C 6676.36 7710.1 6656.3 7682.87 6624.77 7674.27 C 6611.87 7671.41 6597.54 7684.3 6584.64 7678.57 C 6581.78 7677.14 6547.38 7639.88 6548.81 7634.14 C 6548.81 7628.41 6557.41 7625.54 6557.41 7621.25 C 6558.84 7616.95 6553.11 7615.51 6553.11 7611.21 C 6553.11 7605.48 6555.98 7598.31 6560.28 7592.58 C 6564.58 7586.85 6573.18 7585.42 6578.91 7579.68 C 6586.08 7573.95 6593.24 7552.45 6598.97 7559.62 C 6601.84 7563.92 6606.14 7592.58 6619.04 7591.15 C 6667.77 7583.98 6619.04 7548.15 6680.66 7551.02 C 6696.43 7551.02 6683.53 7568.22 6692.13 7572.52 C 6697.86 7575.38 6706.46 7568.22 6713.63 7571.08 C 6717.93 7572.52 6716.49 7581.12 6719.36 7582.55 C 6727.96 7588.28 6739.42 7594.02 6749.46 7594.02 C 6750.89 7594.02 6786.72 7576.82 6786.72 7576.82 C 6798.18 7575.38 6822.55 7583.98 6839.75 7579.68 C 6875.57 7572.52 6874.14 7558.19 6892.77 7548.15 C 6935.77 7525.22 6904.24 7556.75 6945.8 7553.89 C 6974.46 7552.45 6954.4 7536.69 6965.86 7525.22 C 6970.16 7520.92 6970.16 7538.12 6974.46 7536.69 C 7000.26 7530.96 7000.26 7508.03 7023.19 7523.79 M 6077.3 6994.95 C 6081.6 7015.02 6144.66 7010.72 6136.06 7042.25 C 6134.63 7050.85 6110.26 7047.98 6113.13 7058.01 C 6116 7068.04 6136.06 7065.18 6143.23 7073.78 C 6146.09 7076.64 6136.06 7078.08 6136.06 7082.37 C 6144.66 7133.97 6157.56 7060.88 6160.42 7129.67 C 6161.86 7154.03 6136.06 7162.63 6128.9 7182.7 C 6121.73 7201.33 6143.23 7201.33 6146.09 7217.09 C 6146.09 7222.83 6138.93 7228.56 6138.93 7235.72 C 6134.63 7283.02 6140.36 7348.94 6113.13 7396.24 C 6111.7 7399.1 6113.13 7391.94 6110.26 7390.51 C 6090.2 7383.34 6064.4 7363.28 6040.04 7364.71 C 6035.74 7364.71 6050.07 7370.44 6050.07 7374.74 C 6048.64 7380.47 6041.47 7383.34 6040.04 7390.51 C 6031.44 7423.47 6054.37 7417.74 6014.24 7436.37 C 5958.35 7462.16 5992.74 7409.14 5965.51 7397.67 C 5972.45 7414.82 5952.05 7381.82 5944.02 7373.31 C 5935.42 7344.64 5955.48 7326.01 5959.78 7301.65 C 5961.21 7291.62 5955.48 7283.02 5958.35 7272.99 C 5959.78 7264.39 5975.55 7260.09 5972.68 7251.49 C 5971.25 7244.32 5955.48 7251.49 5951.18 7245.76 C 5946.88 7238.59 5954.05 7229.99 5954.05 7222.83 C 5954.05 7221.39 5948.32 7221.39 5949.75 7219.96 C 5952.62 7215.66 5961.21 7217.09 5964.08 7211.36 C 5969.81 7197.03 5948.32 7126.8 5939.72 7116.77 C 5922.52 7098.14 5911.05 7159.77 5915.35 7088.11 C 5916.79 7078.08 5926.82 7070.91 5928.25 7060.88 C 5929.69 7055.14 5922.52 7049.41 5926.82 7045.11 C 5928.25 7043.68 5938.28 7073.78 5964.08 7073.78 C 5985.58 7075.21 6064.4 7010.72 6077.3 6994.95 M 6667.77 5991.74 C 6664.9 6020.4 6629.07 6014.67 6626.2 6037.6 C 6623.34 6054.8 6656.3 6051.93 6663.47 6057.66 C 6673.5 6066.26 6646.27 6077.73 6641.97 6090.62 C 6636.24 6109.26 6659.17 6089.19 6662.03 6096.36 C 6664.9 6103.52 6649.13 6122.15 6659.17 6127.89 C 6673.5 6136.49 6730.82 6170.88 6680.66 6168.02 C 6683.53 6160.85 6683.53 6155.12 6677.8 6147.95 C 6650.57 6122.15 6651.2 6140.92 6640.24 6150.79 C 6637.93 6153.84 6637.67 6150.82 6637.67 6150.82 C 6637.67 6136.49 6610.44 6133.62 6597.54 6139.35 C 6590.37 6143.65 6597.54 6159.42 6591.81 6165.15 C 6586.08 6170.88 6576.04 6166.58 6567.44 6169.45 C 6547.38 6178.05 6528.75 6200.98 6505.82 6205.28 C 6498.65 6206.71 6491.49 6199.55 6485.75 6203.84 C 6480.02 6205.28 6485.75 6213.88 6482.89 6219.61 C 6481.45 6223.91 6477.15 6229.64 6474.29 6233.94 C 6475.72 6232.51 6475.72 6231.07 6477.15 6231.07 C 6484.32 6231.07 6478.59 6246.84 6484.32 6249.71 C 6487.19 6251.14 6488.62 6241.11 6491.49 6243.97 C 6494.35 6249.71 6500.09 6261.17 6494.35 6265.47 C 6491.49 6266.9 6490.05 6269.77 6491.49 6272.64 C 6492.92 6274.07 6495.79 6271.2 6498.65 6271.2 C 6507.25 6278.37 6521.58 6282.67 6523.02 6292.7 C 6531.61 6332.83 6497.22 6317.06 6487.19 6341.43 C 6484.32 6348.59 6502.95 6425.99 6507.25 6434.58 C 6515.85 6448.92 6616.17 6520.57 6636.24 6532.04 C 6656.3 6543.5 6662.03 6536.34 6680.66 6552.1 C 6700.73 6569.3 6727.96 6682.52 6743.72 6711.19 C 6759.49 6741.28 6792.45 6768.51 6818.25 6788.58 C 6826.85 6794.31 6839.75 6795.74 6846.91 6802.91 C 6851.21 6805.77 6846.91 6814.37 6849.78 6817.24 C 6888.47 6857.37 6961.56 6844.47 7007.43 6837.3 C 7017.46 6835.87 7038.96 6820.11 7051.85 6834.44 C 7087.68 6874.57 6980.2 6888.9 7034.66 6926.16 C 7086.25 6960.56 7157.91 6957.69 7210.94 6984.92 C 7229.57 6994.95 7236.73 7010.72 7258.23 7017.88 C 7275.43 7025.05 7322.72 7032.21 7337.05 7043.68 C 7342.79 7047.98 7337.05 7058.01 7341.35 7062.31 C 7358.55 7086.67 7404.41 7082.37 7418.74 7132.54 C 7424.48 7151.17 7411.58 7145.43 7407.28 7158.33 C 7404.41 7165.5 7408.71 7194.16 7402.98 7197.03 C 7397.25 7201.33 7387.21 7197.03 7378.62 7192.73 C 7334.19 7175.53 7352.82 7149.73 7329.89 7119.64 C 7316.99 7102.44 7275.43 7119.64 7253.93 7112.47 C 7225.27 7102.44 7209.5 7069.48 7182.27 7098.14 C 7179.41 7102.44 7143.58 7174.1 7143.58 7176.96 C 7143.58 7181.26 7150.74 7185.56 7149.31 7191.3 C 7143.58 7218.53 7114.91 7217.09 7139.28 7248.62 C 7153.61 7265.82 7157.91 7250.06 7173.67 7254.35 C 7190.87 7260.09 7202.34 7277.29 7218.1 7284.45 C 7223.83 7287.32 7232.43 7284.45 7235.3 7290.18 C 7238.17 7294.48 7229.57 7300.22 7229.57 7305.95 C 7231 7346.08 7249.63 7308.82 7246.76 7360.41 C 7245.33 7390.51 7188 7379.04 7162.21 7409.14 C 7143.58 7430.63 7167.94 7452.13 7162.21 7477.93 C 7157.91 7499.43 7143.58 7493.69 7129.24 7505.16 C 7094.85 7535.26 7119.21 7604.05 7047.55 7583.98 C 7033.22 7579.68 7017.46 7542.42 7026.06 7526.66 C 7031.79 7518.06 7046.12 7519.49 7053.29 7512.32 C 7057.59 7506.59 7057.59 7497.99 7059.02 7490.83 C 7060.45 7483.66 7066.19 7477.93 7064.75 7470.76 C 7063.32 7462.16 7048.99 7457.86 7050.42 7449.27 C 7056.15 7423.47 7090.55 7437.8 7100.58 7423.47 C 7124.95 7394.81 7096.28 7390.51 7084.82 7374.74 C 7073.35 7357.54 7079.08 7333.18 7070.49 7314.55 C 7066.19 7303.08 7060.45 7293.05 7053.29 7284.45 C 7051.85 7281.59 7046.12 7281.59 7043.26 7278.72 C 7017.46 7240.02 7044.69 7262.95 7027.49 7219.96 C 7005.99 7165.5 6993.09 7192.73 6950.1 7195.6 C 6948.67 7195.6 6951.53 7191.3 6950.1 7188.43 C 6944.37 7182.7 6937.2 7175.53 6928.6 7171.23 C 6920 7166.93 6902.8 7171.23 6897.07 7161.2 C 6891.34 7151.17 6908.54 7141.13 6907.1 7129.67 C 6905.67 7118.2 6897.07 7108.17 6891.34 7099.57 C 6856.94 7052.28 6851.21 7118.2 6811.08 7103.87 C 6806.78 7102.44 6838.31 7079.51 6823.98 7069.48 C 6772.39 7032.21 6822.55 7070.91 6766.65 7063.74 C 6762.35 7062.31 6766.65 7055.14 6765.22 7050.85 C 6759.49 7033.65 6729.39 6987.79 6715.06 6982.05 C 6676.36 6967.72 6706.46 6994.95 6693.56 6992.09 C 6680.66 6989.22 6669.2 6973.45 6654.87 6974.89 C 6641.97 6977.75 6631.94 6994.95 6620.47 6992.09 C 6607.57 6989.22 6609.01 6970.59 6600.41 6961.99 C 6590.37 6953.39 6564.58 6956.26 6555.98 6950.52 L 6534.48 6920.43 C 6524.45 6911.83 6508.68 6910.4 6500.09 6900.36 C 6482.89 6874.57 6502.95 6878.87 6482.89 6863.1 C 6474.29 6855.93 6464.26 6850.2 6454.22 6844.47 C 6451.36 6843.04 6445.62 6847.34 6442.76 6845.9 C 6426.99 6833 6426.99 6808.64 6411.23 6795.74 C 6384 6772.81 6366.8 6790.01 6338.14 6778.54 C 6333.84 6777.11 6345.3 6772.81 6348.17 6769.94 C 6356.77 6758.48 6339.57 6739.85 6335.27 6735.55 C 6332.4 6732.68 6326.67 6735.55 6323.81 6732.68 C 6319.51 6726.95 6319.51 6718.35 6313.77 6714.05 C 6306.61 6708.32 6292.28 6712.62 6286.54 6704.02 C 6282.24 6698.29 6295.14 6686.82 6287.98 6682.52 C 6279.38 6675.36 6265.05 6683.95 6253.58 6679.66 C 6246.41 6676.79 6257.88 6663.89 6257.88 6655.29 C 6262.18 6626.63 6257.88 6616.6 6242.12 6592.23 C 6212.02 6549.24 6233.52 6510.54 6197.69 6477.58 C 6194.82 6473.28 6189.09 6471.85 6184.79 6470.41 C 6183.36 6470.41 6181.92 6474.71 6180.49 6473.28 C 6173.32 6470.41 6169.02 6461.81 6161.86 6461.81 C 6157.56 6461.81 6166.16 6474.71 6161.86 6473.28 C 6150.39 6470.41 6141.79 6461.81 6131.76 6454.65 C 6127.46 6451.78 6091.63 6414.52 6080.17 6414.52 C 6077.3 6414.52 6081.6 6421.69 6078.73 6423.12 C 6075.87 6424.55 6071.57 6423.12 6070.14 6420.25 C 6062.97 6411.65 6032.87 6397.32 6018.54 6397.32 C 6012.81 6397.32 5975.55 6418.82 5972.68 6424.55 C 5969.81 6430.28 5974.11 6438.88 5969.81 6443.18 C 5965.51 6448.92 5954.05 6447.48 5949.75 6451.78 C 5939.72 6461.81 5932.55 6484.74 5921.09 6494.78 C 5902.46 6513.41 5869.49 6511.98 5847.99 6514.84 C 5840.83 6489.04 5889.56 6456.08 5868.06 6440.32 C 5860.89 6436.02 5850.86 6441.75 5842.26 6443.18 C 5833.66 6443.18 5823.63 6447.48 5815.03 6444.62 C 5799.27 6440.32 5762 6413.09 5763.44 6393.02 C 5763.44 6390.16 5770.6 6390.16 5770.6 6387.29 C 5769.17 6382.99 5754.84 6378.69 5759.14 6370.09 C 5764.87 6364.36 5772.04 6360.06 5776.34 6352.89 C 5777.77 6351.46 5773.47 6348.59 5774.9 6345.73 C 5776.34 6341.43 5789.23 6348.59 5790.67 6344.29 C 5790.67 6332.83 5789.23 6321.36 5784.94 6312.77 C 5777.77 6301.3 5730.48 6282.67 5733.34 6259.74 C 5733.34 6252.57 5746.24 6252.57 5753.41 6251.14 C 5757.71 6251.14 5760.57 6259.74 5764.87 6258.3 C 5772.04 6256.87 5817.9 6219.61 5810.73 6206.71 C 5806.43 6198.11 5792.1 6196.68 5787.8 6186.65 C 5783.5 6180.91 5789.24 6170.88 5786.37 6165.15 C 5766.3 6130.75 5729.04 6147.95 5794.97 6109.26 C 5809.3 6135.05 5847.99 6106.39 5866.63 6102.09 C 5879.52 6099.22 5889.56 6116.42 5902.46 6116.42 C 5903.89 6116.42 5944.02 6074.86 5944.02 6067.69 C 5945.45 6060.53 5932.55 6057.66 5933.98 6051.93 C 5936.85 6043.33 5948.32 6040.46 5955.48 6034.73 C 5962.65 6029 5968.38 6023.27 5975.55 6017.53 C 5978.41 6016.1 5981.28 6013.23 5982.71 6014.67 C 5985.58 6023.27 5984.15 6031.86 5984.15 6040.46 C 5984.15 6044.76 5979.85 6050.5 5981.28 6056.23 C 5991.31 6074.86 6014.24 6079.16 6030.01 6084.89 C 6031.44 6084.89 6034.31 6087.76 6034.31 6090.62 C 6032.87 6096.36 6022.84 6100.66 6024.27 6106.39 C 6025.71 6112.12 6035.74 6109.26 6040.04 6113.56 C 6045.77 6120.72 6048.64 6145.08 6057.24 6137.92 C 6081.6 6119.29 6052.94 6125.02 6052.94 6110.69 C 6052.94 6079.16 6087.33 6070.56 6093.07 6044.76 C 6093.07 6041.9 6077.3 6003.2 6101.67 6007.5 C 6120.3 6010.37 6097.37 6039.03 6134.63 6047.63 C 6157.56 6054.8 6138.93 6026.13 6177.62 6033.3 C 6189.09 6034.73 6183.36 6057.66 6193.39 6063.39 C 6199.12 6066.26 6210.59 6060.53 6209.15 6054.8 C 6206.29 6050.5 6200.55 6047.63 6199.12 6041.9 C 6199.12 6036.16 6207.72 6031.86 6206.29 6026.13 C 6203.42 6018.97 6177.62 6003.2 6197.69 5988.87 C 6223.48 5970.24 6213.45 6011.8 6243.55 6004.63 C 6260.75 5998.9 6233.52 5978.84 6233.52 5975.97 C 6236.38 5970.24 6240.68 5965.94 6242.12 5960.21 C 6244.98 5954.47 6243.55 5947.31 6244.98 5941.58 C 6267.91 5953.04 6247.85 5938.71 6270.78 5941.58 C 6282.24 5943.01 6293.71 5973.1 6316.64 5960.21 L 6335.27 5921.51 C 6346.74 5912.91 6396.9 5918.64 6409.8 5917.21 C 6431.29 5915.78 6448.49 5897.15 6469.99 5897.15 C 6475.72 5897.15 6459.96 5904.31 6458.52 5910.05 C 6451.36 5940.14 6469.99 5920.08 6481.45 5937.28 C 6484.32 5941.58 6477.15 5947.31 6480.02 5953.04 C 6481.45 5955.91 6485.75 5950.17 6488.62 5953.04 C 6515.85 5973.1 6523.02 5975.97 6560.28 5981.7 C 6596.11 5986 6631.94 5988.87 6667.77 5991.74 L 6667.77 5991.74 " }
                }
            }
            // PATH visit gr count: 707
            DemoShape {
                objectName: "gr"
                ShapePath {
                    objectName: "svg_path:gr"
                    // boundingRect: 7642.32, 6646.69 1068.32x1299.36
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 8708.59 7823.32 C 8692.83 7853.42 8721.49 7833.35 8705.73 7877.78 C 8704.29 7882.08 8588.21 7907.88 8576.74 7912.18 C 8568.14 7915.04 8487.89 7952.31 8479.29 7945.14 C 8453.49 7916.48 8499.35 7919.34 8417.66 7909.31 C 8334.54 7899.28 8437.73 7919.34 8367.5 7919.34 C 8363.2 7919.34 8361.77 7912.18 8357.47 7912.18 C 8348.87 7910.74 8338.84 7912.18 8328.8 7913.61 C 8318.77 7916.48 8307.31 7922.21 8297.27 7923.64 C 8275.78 7923.64 8284.38 7896.41 8285.81 7887.81 C 8285.81 7876.35 8281.51 7863.45 8285.81 7853.42 C 8301.57 7808.99 8315.91 7859.15 8325.94 7863.45 C 8335.97 7867.75 8347.44 7862.02 8357.47 7857.72 C 8364.63 7854.85 8368.93 7836.22 8374.67 7841.95 C 8381.83 7847.69 8357.47 7853.42 8360.33 7860.58 C 8361.77 7867.75 8374.67 7863.45 8381.83 7866.32 C 8389 7869.18 8394.73 7879.22 8403.33 7880.65 C 8410.5 7882.08 8416.23 7876.35 8423.39 7873.48 C 8437.73 7869.18 8447.76 7857.72 8460.66 7853.42 C 8476.42 7849.12 8492.19 7850.55 8507.95 7847.69 C 8517.98 7844.82 8509.38 7856.28 8517.98 7857.72 C 8533.75 7862.02 8549.51 7849.12 8566.71 7850.55 C 8571.01 7850.55 8573.88 7859.15 8578.18 7857.72 C 8585.34 7856.28 8611.14 7834.79 8624.04 7837.65 C 8626.9 7839.09 8602.54 7869.18 8636.94 7879.22 C 8644.1 7882.08 8644.1 7866.32 8649.83 7862.02 C 8679.93 7831.92 8675.63 7870.62 8708.59 7823.32 M 8413.36 6738.42 L 8414.79 6736.98 L 8416.23 6736.98 C 8417.66 6736.98 8462.09 6722.65 8462.09 6722.65 C 8493.62 6698.29 8403.33 6658.16 8459.22 6646.69 L 8460.66 6646.69 L 8464.96 6646.69 L 8466.39 6646.69 L 8467.82 6646.69 C 8470.69 6646.69 8473.55 6646.69 8474.99 6648.13 L 8477.85 6648.13 C 8509.38 6655.29 8552.38 6685.39 8530.88 6711.19 C 8515.12 6728.38 8499.35 6719.78 8493.62 6748.45 L 8505.08 6790.01 C 8503.65 6800.04 8483.59 6833 8473.55 6838.74 L 8472.12 6854.5 C 8447.76 6841.6 8493.62 6840.17 8470.69 6820.11 C 8459.22 6811.51 8413.36 6831.57 8399.03 6830.14 C 8353.17 6827.27 8347.44 6797.18 8317.34 6834.44 C 8310.17 6843.04 8303.01 6850.2 8294.41 6855.93 C 8254.28 6877.43 8275.78 6827.27 8235.65 6851.64 C 8219.88 6861.67 8231.35 6886.03 8199.82 6900.36 C 8172.59 6911.83 8169.72 6877.43 8143.93 6910.4 C 8133.89 6923.29 8151.09 6921.86 8155.39 6924.73 C 8168.29 6931.89 8166.86 6953.39 8178.32 6964.86 C 8181.19 6967.72 8186.92 6966.29 8192.65 6964.86 C 8194.09 6964.86 8195.52 6963.42 8196.95 6960.56 C 8196.95 6957.69 8191.22 6951.96 8195.52 6951.96 C 8201.25 6950.52 8201.25 6963.42 8206.99 6964.86 C 8222.75 6969.15 8255.71 6974.89 8261.45 6996.39 C 8272.91 7037.95 8224.18 6977.75 8224.18 6977.75 C 8208.42 6969.15 8162.56 6963.42 8158.26 6990.65 C 8153.96 7007.85 8191.22 7002.12 8202.69 7013.58 C 8211.28 7022.18 8209.85 7050.85 8199.82 7046.55 C 8176.89 7037.95 8175.46 7012.15 8152.53 7000.68 C 8146.79 6999.25 8141.06 7002.12 8135.33 7000.68 C 8128.16 7000.68 8119.56 6993.52 8115.26 6999.25 C 8082.3 7035.08 8178.32 7045.11 8171.16 7058.01 C 8168.29 7062.31 8131.03 7060.88 8119.56 7058.01 C 8115.26 7056.58 8105.23 7010.72 8105.23 7010.72 C 8093.77 6996.39 8053.64 7004.98 8037.87 6993.52 C 8007.78 6970.59 8037.87 6974.89 8037.87 6946.22 C 8037.87 6940.49 8022.11 6956.26 8013.51 6963.42 C 8006.34 6970.59 7994.88 6976.32 7993.44 6986.35 C 7992.01 6993.52 8006.34 6994.95 8007.78 7002.12 L 7997.74 7045.11 C 8002.04 7072.34 8035.01 7085.24 8050.77 7102.44 L 8069.4 7139.7 C 8079.43 7149.73 8152.53 7185.56 8141.06 7202.76 C 8138.19 7207.06 8082.3 7178.4 8078 7179.83 C 8073.7 7179.83 8078 7188.43 8078 7192.73 C 8075.13 7202.76 8059.37 7224.26 8069.4 7222.83 C 8072.27 7221.39 8070.83 7214.23 8073.7 7215.66 C 8078 7217.09 8076.57 7224.26 8080.87 7227.12 C 8090.9 7234.29 8122.43 7234.29 8098.06 7255.79 C 8078 7272.99 8057.94 7274.42 8030.71 7285.88 C 8026.41 7287.32 8039.31 7291.62 8043.6 7290.18 C 8047.9 7288.75 8050.77 7281.59 8056.5 7281.59 C 8062.24 7281.59 8062.24 7290.18 8066.54 7293.05 C 8069.4 7294.48 8072.27 7291.62 8075.13 7290.18 C 8086.6 7290.18 8098.06 7287.32 8108.1 7291.62 C 8116.7 7294.48 8115.26 7308.82 8123.86 7310.25 C 8133.89 7313.11 8143.93 7297.35 8152.53 7301.65 C 8161.12 7305.95 8151.09 7324.58 8159.69 7328.88 C 8171.16 7336.05 8185.49 7315.98 8195.52 7323.15 C 8201.25 7326.01 8195.52 7348.94 8218.45 7350.38 C 8247.11 7351.81 8255.71 7341.78 8275.78 7364.71 C 8291.54 7381.91 8267.18 7374.74 8267.18 7384.77 C 8267.18 7391.94 8275.78 7396.24 8277.21 7401.97 C 8280.08 7409.14 8275.78 7417.74 8278.64 7423.47 C 8285.81 7436.37 8304.44 7442.1 8288.68 7466.46 C 8285.81 7470.76 8280.08 7467.9 8275.78 7466.46 C 8272.91 7463.6 8275.78 7459.3 8274.34 7456.43 C 8272.91 7453.56 8255.71 7442.1 8254.28 7442.1 C 8251.41 7440.67 8249.98 7447.83 8247.11 7446.4 C 8237.08 7439.23 8221.32 7410.57 8206.99 7406.27 C 8188.35 7400.54 8198.39 7422.04 8188.35 7424.9 C 8171.16 7430.63 8122.43 7444.97 8126.73 7452.13 C 8131.03 7462.16 8148.23 7457.86 8158.26 7462.16 C 8162.56 7463.6 8149.66 7466.46 8149.66 7470.76 C 8149.66 7475.06 8156.82 7475.06 8158.26 7477.93 C 8161.12 7483.66 8156.82 7492.26 8161.12 7496.56 C 8176.89 7512.32 8204.12 7503.73 8218.45 7520.92 C 8227.05 7530.96 8195.52 7533.82 8182.62 7533.82 C 8162.56 7535.26 8146.79 7533.82 8141.06 7532.39 C 8136.76 7530.96 8139.63 7523.79 8136.76 7519.49 C 8135.33 7518.06 8131.03 7518.06 8129.59 7518.06 C 8118.13 7518.06 8102.36 7509.46 8095.2 7518.06 C 8083.73 7533.82 8131.03 7569.65 8136.76 7579.68 C 8138.19 7585.42 8133.89 7591.15 8135.33 7595.45 C 8138.19 7599.75 8146.79 7595.45 8149.66 7599.75 C 8155.39 7609.78 8172.59 7641.31 8178.32 7654.21 C 8184.05 7667.11 8166.86 7658.51 8166.86 7662.81 C 8166.86 7667.11 8172.59 7668.54 8174.02 7671.41 C 8174.02 7674.27 8168.29 7678.57 8169.72 7681.44 C 8171.16 7684.3 8204.12 7702.94 8201.25 7714.4 C 8198.39 7718.7 8188.35 7718.7 8182.62 7717.27 C 8178.32 7714.4 8179.76 7705.8 8175.46 7702.94 C 8172.59 7700.07 8166.86 7707.24 8162.56 7704.37 C 8138.19 7685.74 8128.16 7628.41 8092.33 7678.57 C 8090.9 7681.44 8093.77 7711.53 8096.63 7728.73 C 8098.06 7733.03 8098.06 7743.06 8093.77 7741.63 C 8057.94 7737.33 8080.87 7701.5 8069.4 7685.74 C 8067.97 7684.3 8063.67 7685.74 8062.24 7684.3 C 8053.64 7675.71 8049.34 7665.67 8042.17 7655.64 C 8037.87 7648.48 8035.01 7635.58 8026.41 7634.14 C 7957.61 7618.38 8019.24 7684.3 7994.88 7695.77 C 7953.32 7714.4 7964.78 7667.11 7963.35 7657.07 C 7963.35 7654.21 7959.05 7654.21 7957.61 7654.21 C 7944.72 7655.64 7937.55 7638.44 7934.68 7622.68 C 7931.82 7601.18 7949.02 7625.54 7951.88 7592.58 C 7953.32 7569.65 7916.05 7540.99 7897.42 7535.26 C 7893.12 7533.82 7888.82 7543.85 7885.96 7539.55 C 7880.22 7532.39 7885.96 7519.49 7878.79 7512.32 C 7870.19 7503.73 7831.5 7515.19 7851.56 7487.96 C 7852.99 7486.53 7858.73 7489.39 7860.16 7486.53 C 7883.09 7470.76 7871.62 7457.86 7878.79 7430.63 C 7878.79 7427.77 7881.66 7436.37 7884.52 7436.37 C 7885.96 7436.37 7881.66 7430.63 7883.09 7430.63 C 7897.42 7430.63 7911.75 7444.97 7923.22 7433.5 C 7938.98 7417.74 7917.49 7416.3 7946.15 7397.67 C 7966.21 7384.77 7980.55 7406.27 7996.31 7412 C 8019.24 7420.6 8046.47 7417.74 8070.83 7424.9 C 8085.17 7427.77 8093.77 7444.97 8108.1 7446.4 C 8113.83 7447.83 8125.3 7440.67 8123.86 7433.5 C 8121 7427.77 8105.23 7434.93 8102.36 7427.77 C 8088.03 7394.81 8138.19 7443.53 8155.39 7396.24 C 8156.82 7391.94 8145.36 7399.1 8139.63 7396.24 C 8136.76 7394.81 8139.63 7387.64 8136.76 7387.64 C 8133.89 7387.64 8132.46 7404.84 8125.3 7396.24 C 8113.83 7381.91 8105.23 7401.97 8086.6 7393.37 C 8076.57 7387.64 8073.7 7370.44 8062.24 7369.01 C 8055.07 7367.58 8059.37 7390.51 8050.77 7390.51 C 8024.97 7389.07 8042.17 7330.31 8023.54 7363.28 C 8020.67 7369.01 8030.71 7380.47 8024.97 7384.77 C 8014.94 7394.81 7969.08 7376.17 7959.05 7380.47 C 7940.42 7387.64 7926.09 7404.84 7898.85 7412 C 7883.09 7416.3 7878.79 7391.94 7870.19 7387.64 C 7865.89 7386.21 7871.62 7397.67 7868.76 7400.54 C 7863.03 7409.14 7852.99 7416.3 7844.39 7420.6 C 7841.53 7422.04 7842.96 7414.87 7841.53 7414.87 C 7825.76 7407.7 7841.53 7394.81 7831.5 7379.04 C 7825.76 7370.44 7818.6 7361.84 7810 7356.11 C 7807.13 7354.68 7802.83 7360.41 7801.4 7357.54 C 7794.23 7351.81 7797.1 7338.91 7789.93 7334.61 C 7775.6 7324.58 7749.81 7363.28 7771.3 7310.25 C 7768.44 7308.82 7765.57 7307.38 7761.27 7304.52 C 7756.97 7300.22 7759.84 7293.05 7756.97 7288.75 C 7741.21 7268.69 7701.08 7250.06 7683.88 7235.72 C 7678.15 7232.86 7686.75 7218.53 7682.45 7214.23 C 7678.15 7209.93 7656.65 7225.69 7642.32 7191.3 C 7643.75 7189.86 7643.75 7189.86 7645.18 7188.43 C 7646.62 7187 7643.75 7185.56 7645.18 7185.56 C 7669.55 7181.26 7685.31 7201.33 7683.88 7164.07 C 7683.88 7155.47 7703.94 7168.36 7699.64 7155.47 L 7681.01 7126.8 C 7682.45 7116.77 7726.88 7102.44 7729.74 7098.14 C 7729.74 7096.71 7738.34 7039.38 7738.34 7039.38 C 7748.37 7000.68 7756.97 7047.98 7771.3 6993.52 C 7775.6 6976.32 7755.54 6970.59 7755.54 6951.96 C 7765.57 6953.39 7861.59 6923.29 7867.33 6918.99 C 7883.09 6901.8 7871.62 6878.87 7900.29 6868.83 C 7910.32 6864.53 7966.21 6871.7 7974.81 6865.97 C 7979.11 6863.1 7977.68 6854.5 7981.98 6851.64 C 7984.84 6850.2 7989.14 6858.8 7992.01 6855.93 C 8009.08 6842.57 8015.32 6824.48 8011.68 6807.71 C 8017.85 6823.69 8018.06 6796.74 8017.81 6794.31 C 8016.62 6813.43 8016.88 6812.94 8035.01 6812.94 C 8040.74 6812.94 8047.9 6817.24 8052.2 6812.94 C 8057.94 6810.07 8057.94 6798.61 8063.67 6795.74 C 8079.43 6785.71 8100.93 6791.44 8118.13 6785.71 C 8158.26 6771.38 8168.29 6754.18 8194.09 6738.42 C 8198.39 6735.55 8205.55 6747.01 8211.29 6744.15 C 8219.88 6742.71 8224.18 6728.38 8232.78 6731.25 C 8244.25 6732.68 8247.11 6748.45 8257.15 6754.18 C 8258.58 6757.05 8262.88 6751.31 8265.75 6752.75 C 8270.04 6754.18 8272.91 6764.21 8277.21 6762.78 C 8282.94 6761.35 8282.94 6749.88 8288.68 6748.45 C 8304.44 6744.15 8323.07 6752.75 8337.4 6759.91 C 8340.27 6761.35 8337.4 6768.51 8341.7 6768.51 C 8361.77 6769.94 8393.3 6745.58 8413.36 6738.42 M 7830.06 7293.05 C 7847.26 7261.52 7804.27 7295.92 7802.83 7294.48 C 7792.8 7290.18 7784.2 7271.55 7775.6 7277.29 C 7772.74 7277.29 7782.77 7298.78 7781.34 7307.38 C 7795.67 7307.38 7821.46 7307.38 7830.06 7293.05 M 7805.7 7463.6 C 7794.23 7473.63 7789.93 7459.3 7779.9 7457.86 C 7774.17 7457.86 7768.44 7465.03 7762.7 7463.6 C 7752.67 7460.73 7756.97 7427.77 7748.37 7434.93 C 7744.07 7437.8 7751.24 7447.83 7748.37 7453.56 C 7736.91 7477.93 7729.74 7436.37 7761.27 7394.81 C 7765.57 7401.97 7771.3 7409.14 7774.17 7417.74 C 7774.17 7419.17 7769.87 7432.07 7777.04 7433.5 C 7784.2 7434.93 7821.46 7450.7 7805.7 7463.6 M 8295.84 7341.78 C 8288.68 7333.18 8278.64 7326.01 8267.18 7321.71 C 8249.98 7315.98 8225.62 7343.21 8206.99 7324.58 C 8204.12 7320.28 8212.72 7314.55 8209.85 7310.25 C 8205.55 7297.35 8121 7257.22 8105.23 7260.09 C 8096.63 7262.95 8092.33 7272.99 8085.17 7277.29 C 8080.87 7278.72 8088.03 7268.69 8090.9 7265.82 C 8095.2 7261.52 8100.93 7257.22 8105.23 7252.92 C 8110.96 7247.19 8115.26 7242.89 8121 7238.59 C 8129.59 7232.86 8138.19 7228.56 8146.79 7224.26 C 8171.16 7237.16 8168.29 7250.06 8192.65 7262.95 C 8196.95 7265.82 8202.69 7267.25 8208.42 7267.25 C 8211.28 7267.25 8212.72 7261.52 8215.58 7262.95 C 8222.75 7265.82 8228.48 7274.42 8237.08 7277.29 C 8245.68 7278.72 8275.78 7261.52 8281.51 7271.55 C 8282.94 7272.99 8280.08 7274.42 8280.08 7275.85 C 8278.64 7277.29 8277.21 7280.15 8278.64 7281.59 C 8284.38 7287.32 8294.41 7287.32 8298.71 7294.48 C 8298.71 7295.92 8295.84 7338.91 8310.17 7348.94 C 8325.94 7360.41 8390.43 7338.91 8364.63 7381.91 C 8350.3 7404.84 8311.61 7376.17 8303.01 7366.14 C 8301.57 7363.28 8307.31 7361.84 8307.31 7358.98 C 8305.87 7354.68 8301.57 7350.38 8297.27 7347.51 C 8294.41 7347.51 8291.54 7354.68 8290.11 7351.81 C 8290.11 7348.94 8298.71 7344.64 8295.84 7341.78 " }
                }
            }
            // PATH visit ee count: 241
            DemoShape {
                objectName: "ee"
                ShapePath {
                    objectName: "svg_path:ee"
                    // boundingRect: 7343.68, 3343.25 605.443x415.507
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7607.92 3723.03 C 7619.39 3720.17 7663.82 3678.61 7676.71 3668.57 C 7685.31 3662.84 7701.08 3690.07 7696.78 3671.44 C 7696.78 3670.01 7695.35 3670.01 7695.35 3668.57 C 7695.35 3665.71 7692.48 3661.41 7695.35 3661.41 C 7708.24 3661.41 7724.01 3682.91 7732.61 3685.77 C 7736.91 3687.21 7741.21 3678.61 7745.51 3678.61 C 7749.81 3680.04 7748.37 3688.64 7752.67 3690.07 C 7761.27 3692.94 7769.87 3684.34 7778.47 3687.21 C 7782.77 3688.64 7777.04 3697.24 7779.9 3700.1 C 7785.63 3708.7 7831.5 3738.8 7841.53 3737.37 C 7842.96 3737.37 7870.19 3707.27 7870.19 3707.27 C 7875.92 3705.84 7918.92 3721.6 7920.35 3714.44 C 7923.22 3707.27 7913.19 3687.21 7917.49 3682.91 C 7920.35 3680.04 7927.52 3680.04 7928.95 3675.74 C 7930.38 3672.87 7924.65 3671.44 7924.65 3667.14 C 7923.22 3664.27 7923.22 3659.98 7924.65 3657.11 C 7941.85 3642.78 7943.28 3658.54 7949.02 3641.34 C 7950.45 3637.04 7937.55 3639.91 7933.25 3635.61 C 7923.22 3625.58 7928.95 3618.41 7926.09 3608.38 C 7924.65 3604.08 7901.72 3591.18 7897.42 3586.88 C 7885.96 3566.82 7898.85 3575.42 7898.85 3556.79 C 7898.85 3530.99 7870.19 3503.76 7865.89 3477.96 C 7864.46 3462.2 7881.66 3450.73 7885.96 3439.27 C 7885.96 3439.27 7887.39 3403.44 7887.39 3403.44 C 7887.39 3396.27 7881.66 3387.67 7885.96 3381.94 C 7900.29 3351.84 7924.65 3364.74 7890.26 3343.25 C 7888.82 3348.98 7885.96 3354.71 7875.92 3360.44 C 7863.03 3369.04 7728.31 3370.48 7705.38 3367.61 C 7701.08 3367.61 7698.21 3360.44 7692.48 3361.88 C 7665.25 3367.61 7726.88 3383.37 7681.01 3377.64 C 7673.85 3376.21 7672.41 3360.44 7665.25 3361.88 C 7659.52 3363.31 7669.55 3374.78 7666.68 3380.51 C 7662.38 3389.11 7653.78 3397.71 7645.18 3402.01 C 7630.85 3409.17 7615.09 3412.04 7599.32 3409.17 C 7593.59 3407.74 7589.29 3396.27 7584.99 3399.14 C 7577.83 3403.44 7595.02 3419.2 7587.86 3420.64 C 7573.53 3424.94 7530.53 3426.37 7521.93 3447.87 C 7519.07 3455.03 7534.83 3462.2 7530.53 3467.93 C 7523.37 3479.4 7480.37 3476.53 7474.64 3489.43 C 7454.57 3543.89 7491.84 3509.49 7500.43 3532.42 C 7504.73 3545.32 7483.24 3561.09 7488.97 3573.99 C 7494.7 3589.75 7517.63 3605.51 7520.5 3611.25 C 7529.1 3624.15 7514.77 3638.48 7533.4 3648.51 C 7540.56 3651.38 7549.16 3644.21 7556.33 3647.08 C 7563.49 3648.51 7567.79 3662.84 7574.96 3658.54 C 7584.99 3652.81 7584.99 3598.35 7615.09 3634.18 C 7617.95 3638.48 7607.92 3642.78 7607.92 3648.51 C 7607.92 3659.98 7613.66 3671.44 7613.66 3682.91 C 7613.66 3711.57 7602.19 3695.8 7605.06 3721.6 L 7607.92 3723.03 M 7451.71 3612.68 C 7470.34 3625.58 7468.91 3627.01 7491.84 3637.04 C 7501.87 3642.78 7474.64 3624.15 7480.37 3635.61 C 7486.1 3648.51 7481.8 3629.88 7471.77 3631.31 C 7463.17 3632.75 7471.77 3651.38 7464.61 3658.54 C 7463.17 3659.98 7457.44 3651.38 7456.01 3654.24 C 7453.14 3657.11 7457.44 3664.27 7456.01 3670.01 C 7448.84 3688.64 7434.51 3682.91 7430.21 3684.34 C 7427.34 3684.34 7427.34 3690.07 7424.48 3691.51 C 7415.88 3695.8 7405.85 3698.67 7398.68 3702.97 C 7397.25 3702.97 7397.25 3704.4 7397.25 3705.84 C 7397.25 3717.3 7400.11 3730.2 7397.25 3741.67 C 7394.38 3748.83 7384.35 3763.16 7378.62 3757.43 C 7361.42 3737.37 7394.38 3725.9 7391.51 3710.14 C 7390.08 3705.84 7382.92 3711.57 7378.62 3708.7 C 7370.02 3704.4 7357.12 3701.54 7352.82 3691.51 C 7349.95 3685.77 7365.72 3682.91 7364.28 3677.17 C 7362.85 3665.71 7339.92 3661.41 7344.22 3651.38 C 7347.09 3642.78 7361.42 3662.84 7371.45 3662.84 C 7380.05 3662.84 7367.15 3639.91 7375.75 3635.61 C 7380.05 3634.18 7385.78 3648.51 7387.21 3644.21 C 7397.25 3609.81 7418.74 3622.71 7451.71 3612.68 M 7400.11 3529.56 C 7402.98 3529.56 7407.28 3528.12 7408.71 3530.99 C 7411.58 3533.86 7407.28 3541.02 7411.58 3543.89 C 7417.31 3546.76 7427.34 3539.59 7433.08 3542.46 C 7481.8 3571.12 7435.94 3565.39 7433.08 3571.12 C 7421.61 3598.35 7461.74 3575.42 7408.71 3605.51 C 7392.95 3614.11 7391.51 3579.72 7391.51 3579.72 C 7385.78 3563.95 7359.98 3569.69 7349.95 3566.82 C 7339.92 3565.39 7371.45 3561.09 7381.48 3558.22 C 7394.38 3555.35 7397.25 3538.16 7400.11 3529.56 " }
                }
            }
            // PATH visit lv count: 185
            DemoShape {
                objectName: "lv"
                ShapePath {
                    objectName: "svg_path:lv"
                    // boundingRect: 7317.75, 3661.41 750.748x453.11
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7341.35 4114.29 C 7347.09 4114.29 7352.82 4115.72 7357.12 4111.42 C 7362.85 4102.82 7361.42 4089.93 7367.15 4081.33 C 7378.62 4066.99 7424.48 4038.33 7441.68 4034.03 C 7451.71 4031.17 7497.57 4034.03 7507.6 4031.17 C 7513.33 4029.73 7517.63 4018.27 7523.37 4018.27 C 7533.4 4019.7 7539.13 4044.06 7544.86 4036.9 C 7549.16 4034.03 7547.73 4026.87 7552.03 4022.57 C 7564.93 4009.67 7570.66 4024 7586.42 4022.57 C 7595.02 4021.13 7599.32 4012.53 7607.92 4012.53 C 7609.36 4011.1 7652.35 4022.57 7653.78 4021.13 C 7660.95 4019.7 7663.82 4009.67 7670.98 4008.23 C 7683.88 4005.37 7683.88 4026.87 7695.35 4009.67 C 7703.94 3999.64 7703.94 3975.27 7721.14 3972.41 C 7735.47 3969.54 7741.21 4015.4 7759.84 4015.4 C 7778.47 4015.4 7797.1 4003.94 7815.73 4009.67 C 7842.96 4016.83 7885.96 4069.86 7918.92 4075.59 C 7954.75 4081.33 7956.18 4026.87 7977.68 4028.3 C 7984.84 4028.3 7989.14 4036.9 7994.88 4036.9 C 7999.18 4036.9 7996.31 4026.87 7999.18 4025.43 C 8007.78 4022.57 8019.24 4031.17 8026.41 4025.43 C 8026.41 4025.43 8033.57 3982.44 8036.44 3978.14 C 8039.31 3969.54 8066.54 3948.04 8066.54 3946.61 C 8078 3905.05 8036.44 3866.35 8012.08 3846.29 C 8002.04 3839.12 8022.11 3826.22 8002.04 3823.36 C 7994.88 3821.92 7989.14 3833.39 7981.98 3831.96 C 7979.11 3831.96 7981.98 3827.66 7981.98 3824.79 C 7981.98 3823.36 7983.41 3820.49 7983.41 3819.06 C 7983.41 3809.02 7986.28 3798.99 7984.84 3788.96 C 7983.41 3784.66 7973.38 3786.09 7973.38 3781.79 C 7973.38 3763.16 8007.78 3751.7 7960.48 3734.5 C 7954.75 3733.07 7946.15 3733.07 7941.85 3728.77 C 7937.55 3723.03 7944.72 3713 7938.98 3710.14 C 7933.25 3705.84 7927.52 3713 7920.35 3714.44 C 7918.92 3721.6 7875.92 3705.84 7870.19 3707.27 C 7870.19 3707.27 7842.96 3737.37 7841.53 3737.37 C 7831.5 3738.8 7785.63 3708.7 7779.9 3700.1 C 7777.04 3697.24 7782.77 3688.64 7778.47 3687.21 C 7769.87 3684.34 7761.27 3692.94 7752.67 3690.07 C 7748.37 3688.64 7749.81 3680.04 7745.51 3678.61 C 7741.21 3678.61 7736.91 3687.21 7732.61 3685.77 C 7724.01 3682.91 7708.24 3661.41 7695.35 3661.41 C 7692.48 3661.41 7695.35 3665.71 7695.35 3668.57 C 7695.35 3670.01 7696.78 3670.01 7696.78 3671.44 C 7701.08 3690.07 7685.31 3662.84 7676.71 3668.57 C 7663.82 3678.61 7619.39 3720.17 7607.92 3723.03 L 7605.06 3721.6 C 7606.49 3724.47 7606.49 3728.77 7606.49 3733.07 C 7612.22 3763.16 7649.48 3804.73 7640.89 3837.69 C 7636.59 3857.75 7602.19 3899.31 7580.69 3902.18 C 7572.09 3903.61 7566.36 3895.01 7559.19 3893.58 C 7544.86 3889.28 7542 3899.31 7533.4 3884.98 C 7523.37 3870.65 7523.37 3850.59 7510.47 3839.12 C 7497.57 3826.22 7467.47 3820.49 7453.14 3807.59 C 7444.54 3800.43 7453.14 3781.79 7444.54 3777.49 C 7431.64 3771.76 7421.61 3791.83 7410.15 3798.99 C 7395.81 3810.46 7375.75 3813.32 7362.85 3827.66 C 7328.45 3863.48 7358.55 3905.05 7345.65 3940.88 C 7341.35 3955.21 7322.72 3960.94 7318.42 3975.27 C 7315.56 3983.87 7322.72 3992.47 7322.72 4002.5 C 7322.72 4012.53 7318.42 4022.57 7321.29 4031.17 C 7321.29 4032.6 7322.72 4034.03 7324.16 4034.03 C 7309.82 4051.23 7332.75 4094.22 7341.35 4114.29 " }
                }
            }
            // PATH visit lt count: 204
            DemoShape {
                objectName: "lt"
                ShapePath {
                    objectName: "svg_path:lt"
                    // boundingRect: 7341.35, 3972.28 628.209x494.871
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7579.26 4400.92 C 7582.13 4398.06 7582.13 4392.32 7586.42 4390.89 C 7607.92 4383.72 7597.89 4402.36 7612.22 4408.09 C 7652.35 4425.29 7636.59 4393.76 7662.38 4431.02 C 7670.98 4442.48 7662.38 4458.25 7670.98 4463.98 C 7688.18 4475.45 7729.74 4452.52 7741.21 4446.78 C 7752.67 4442.48 7758.4 4468.28 7771.3 4456.82 C 7779.9 4451.08 7781.34 4436.75 7789.93 4431.02 C 7797.1 4426.72 7805.7 4431.02 7812.86 4429.59 C 7820.03 4426.72 7799.97 4410.95 7805.7 4405.22 C 7812.86 4396.62 7827.2 4399.49 7837.23 4395.19 C 7860.16 4382.29 7828.63 4383.72 7844.39 4367.96 C 7848.69 4362.23 7881.66 4346.46 7884.52 4365.09 C 7885.96 4369.39 7878.79 4372.26 7878.79 4376.56 C 7877.36 4389.46 7906.02 4379.42 7908.89 4372.26 C 7921.79 4340.73 7877.36 4349.33 7877.36 4343.6 C 7875.92 4337.86 7890.26 4297.73 7890.26 4296.3 C 7890.26 4296.3 7877.36 4256.17 7877.36 4256.17 C 7877.36 4254.74 7883.09 4254.74 7883.09 4251.87 C 7900.29 4198.85 7887.39 4254.74 7914.62 4211.74 C 7921.79 4203.15 7914.62 4188.81 7920.35 4178.78 C 7927.52 4168.75 7949.02 4183.08 7957.61 4173.05 C 7961.91 4167.32 7956.18 4158.72 7957.61 4152.98 C 7960.48 4148.68 7967.65 4148.68 7969.08 4144.39 C 7974.81 4124.32 7927.52 4150.12 7928.95 4137.22 C 7930.38 4115.72 7940.42 4097.09 7931.82 4075.59 L 7931.82 4074.16 C 7927.52 4075.59 7923.22 4075.59 7918.92 4075.59 C 7885.96 4069.86 7842.96 4016.83 7815.73 4009.67 C 7797.1 4003.94 7778.47 4015.4 7759.84 4015.4 C 7741.21 4015.4 7735.47 3969.54 7721.14 3972.41 C 7703.94 3975.27 7703.94 3999.64 7695.35 4009.67 C 7683.88 4026.87 7683.88 4005.37 7670.98 4008.23 C 7663.82 4009.67 7660.95 4019.7 7653.78 4021.13 C 7652.35 4022.57 7609.36 4011.1 7607.92 4012.53 C 7599.32 4012.53 7595.02 4021.13 7586.42 4022.57 C 7570.66 4024 7564.93 4009.67 7552.03 4022.57 C 7547.73 4026.87 7549.16 4034.03 7544.86 4036.9 C 7539.13 4044.06 7533.4 4019.7 7523.37 4018.27 C 7517.63 4018.27 7513.33 4029.73 7507.6 4031.17 C 7497.57 4034.03 7451.71 4031.17 7441.67 4034.03 C 7424.48 4038.33 7378.62 4066.99 7367.15 4081.33 C 7361.42 4089.93 7362.85 4102.82 7357.12 4111.42 C 7352.82 4115.72 7347.09 4114.29 7341.35 4114.29 C 7342.79 4117.16 7342.79 4118.59 7344.22 4120.02 C 7354.25 4157.28 7337.05 4134.35 7351.39 4170.18 C 7352.82 4173.05 7354.25 4175.91 7357.12 4178.78 C 7359.98 4184.51 7362.85 4188.81 7365.72 4193.11 C 7372.88 4203.15 7378.62 4214.61 7380.05 4226.08 C 7381.48 4234.67 7375.75 4243.27 7377.18 4251.87 C 7378.62 4254.74 7380.05 4244.71 7382.92 4244.71 C 7388.65 4243.27 7388.65 4254.74 7390.08 4259.04 C 7390.08 4261.9 7390.08 4263.34 7390.08 4264.77 C 7394.38 4263.34 7395.81 4257.61 7400.11 4257.61 C 7404.41 4259.04 7404.41 4266.2 7408.71 4269.07 C 7425.91 4279.1 7454.57 4277.67 7473.2 4283.4 C 7476.07 4284.84 7471.77 4289.13 7474.64 4289.13 C 7496.14 4289.13 7516.2 4270.5 7536.26 4276.24 C 7542 4277.67 7539.13 4289.13 7544.86 4293.43 C 7546.3 4294.87 7550.6 4290.57 7553.46 4292 C 7559.19 4294.87 7564.93 4299.17 7569.23 4304.9 C 7577.83 4319.23 7547.73 4357.93 7579.26 4400.92 M 7357.12 4178.78 C 7355.69 4180.21 7355.69 4181.65 7355.69 4181.65 C 7351.39 4193.11 7361.42 4204.58 7362.85 4216.04 C 7364.28 4230.38 7361.42 4246.14 7355.69 4263.34 C 7355.69 4263.34 7357.12 4263.34 7357.12 4263.34 C 7361.42 4254.74 7362.85 4246.14 7364.28 4234.67 C 7364.28 4228.94 7365.72 4208.88 7365.72 4193.11 C 7365.72 4174.48 7364.28 4161.58 7357.12 4178.78 " }
                }
            }
            // PATH visit pl count: 369
            DemoShape {
                objectName: "pl"
                ShapePath {
                    objectName: "svg_path:pl"
                    // boundingRect: 6620.47, 4386.96 1245.42x1032.41
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6763.79 5169.1 C 6802.48 5163.37 6756.62 5131.84 6796.75 5139 C 6822.55 5141.87 6801.05 5153.33 6816.81 5164.8 C 6839.75 5183.43 6858.38 5170.53 6877.01 5182 C 6882.74 5186.3 6881.31 5193.46 6884.17 5197.76 C 6887.04 5199.2 6888.47 5194.9 6889.91 5194.9 C 6894.21 5193.46 6898.51 5190.6 6899.94 5193.46 C 6904.24 5197.76 6899.94 5204.93 6904.24 5209.23 C 6904.24 5209.23 6935.77 5192.03 6942.93 5196.33 C 6981.63 5214.96 6927.17 5222.13 6930.03 5240.76 C 6930.03 5240.76 6963 5260.82 6963 5260.82 C 6967.3 5266.55 6975.9 5303.82 6997.39 5295.22 C 7003.13 5292.35 7001.69 5282.32 7005.99 5278.02 C 7013.16 5272.29 7027.49 5275.15 7031.79 5266.55 C 7033.22 5263.69 7001.69 5232.16 7010.29 5230.72 C 7031.79 5227.86 7056.15 5249.36 7069.05 5253.66 C 7074.78 5255.09 7081.95 5252.22 7087.68 5252.22 C 7093.42 5252.22 7100.58 5255.09 7106.31 5252.22 C 7109.18 5250.79 7107.75 5245.06 7109.18 5242.19 C 7110.61 5240.76 7113.48 5240.76 7113.48 5242.19 C 7130.68 5276.59 7119.21 5255.09 7100.58 5272.29 C 7094.85 5276.59 7114.91 5278.02 7120.65 5282.32 C 7124.95 5286.62 7123.51 5293.78 7127.81 5298.08 C 7130.68 5300.95 7134.98 5302.38 7137.84 5302.38 C 7179.41 5298.08 7132.11 5295.22 7156.48 5285.19 C 7159.34 5283.75 7159.34 5289.48 7162.21 5290.92 C 7167.94 5295.22 7183.71 5299.52 7190.87 5300.95 C 7199.47 5303.82 7212.37 5299.52 7219.53 5305.25 C 7220.97 5306.68 7233.87 5341.08 7235.3 5342.51 C 7241.03 5346.81 7252.5 5342.51 7258.23 5348.24 C 7263.96 5355.41 7259.66 5368.31 7265.4 5375.47 C 7268.26 5379.77 7278.29 5372.61 7282.59 5376.91 C 7286.89 5381.21 7279.73 5391.24 7284.03 5395.54 C 7306.96 5414.17 7325.59 5341.08 7339.92 5351.11 C 7348.52 5356.84 7348.52 5369.74 7355.69 5376.91 C 7357.12 5378.34 7362.85 5374.04 7364.28 5375.47 C 7365.72 5378.34 7359.98 5384.07 7362.85 5385.51 C 7370.02 5386.94 7377.18 5379.77 7382.92 5382.64 C 7392.95 5386.94 7384.35 5414.17 7384.35 5417.04 C 7384.35 5424.2 7397.25 5412.74 7404.41 5411.3 C 7410.15 5409.87 7415.88 5421.34 7421.61 5418.47 C 7423.04 5417.04 7440.24 5372.61 7460.31 5368.31 C 7466.04 5366.88 7471.77 5372.61 7477.5 5372.61 C 7483.24 5371.18 7486.1 5362.58 7491.84 5364.01 C 7503.3 5365.44 7510.47 5381.21 7521.93 5381.21 C 7530.53 5381.21 7537.7 5372.61 7542 5365.44 C 7543.43 5362.58 7534.83 5362.58 7534.83 5359.71 C 7539.13 5339.65 7547.73 5359.71 7553.46 5356.84 C 7557.76 5355.41 7557.76 5346.81 7562.06 5346.81 C 7583.56 5341.08 7632.29 5342.51 7650.92 5356.84 C 7655.22 5361.14 7653.78 5371.18 7659.52 5374.04 C 7668.12 5379.77 7678.15 5379.77 7688.18 5382.64 C 7706.81 5388.37 7724.01 5389.81 7741.21 5392.67 C 7748.37 5392.67 7755.54 5389.81 7762.7 5391.24 C 7765.57 5392.67 7771.3 5399.84 7769.87 5396.97 C 7752.67 5342.51 7767 5399.84 7742.64 5369.74 C 7736.91 5364.01 7748.37 5353.98 7746.94 5346.81 C 7742.64 5332.48 7728.31 5321.01 7725.44 5305.25 C 7721.14 5293.78 7808.57 5131.84 7820.03 5121.8 C 7845.83 5100.31 7861.59 5131.84 7865.89 5080.24 C 7865.89 5068.78 7837.23 5042.98 7835.8 5041.55 C 7828.63 5027.22 7861.59 5028.65 7857.29 5024.35 C 7834.36 5007.15 7792.8 4979.92 7779.9 4952.69 C 7777.04 4945.52 7782.77 4935.49 7779.9 4926.89 C 7775.6 4916.86 7762.7 4909.7 7758.4 4899.66 C 7746.94 4873.87 7777.04 4825.14 7748.37 4802.21 C 7736.91 4793.61 7722.58 4789.31 7709.68 4787.88 C 7706.81 4786.44 7703.94 4793.61 7701.08 4792.18 C 7659.52 4776.41 7749.81 4700.45 7759.84 4690.42 C 7761.27 4688.99 7764.14 4686.12 7764.14 4683.26 C 7759.84 4604.43 7696.78 4537.07 7670.98 4463.98 C 7662.38 4458.25 7670.98 4442.48 7662.38 4431.02 C 7636.59 4393.76 7652.35 4425.29 7612.22 4408.09 C 7597.89 4402.36 7607.92 4383.72 7586.42 4390.89 C 7582.13 4392.32 7582.13 4399.49 7577.83 4402.36 C 7511.9 4441.05 7318.42 4448.22 7236.73 4436.75 C 7210.94 4463.98 7170.81 4479.75 7137.84 4466.85 C 7109.18 4455.38 7114.91 4428.15 7106.31 4410.95 C 7103.45 4406.65 7093.42 4395.19 7099.15 4396.62 C 7103.45 4396.62 7107.75 4396.62 7110.61 4398.06 C 7103.45 4393.76 7094.85 4389.46 7086.25 4388.02 C 7034.66 4379.42 6977.33 4425.29 6938.63 4448.22 C 6925.74 4455.38 6909.97 4452.52 6899.94 4461.12 C 6875.57 4482.61 6869.84 4517.01 6862.68 4518.44 C 6809.65 4531.34 6759.49 4554.27 6709.33 4574.34 C 6696.43 4580.07 6687.83 4595.83 6674.93 4598.7 C 6667.77 4601.57 6660.6 4594.4 6653.43 4597.27 C 6640.54 4604.43 6670.63 4635.96 6657.73 4638.83 C 6660.6 4661.76 6683.53 4706.19 6686.4 4720.52 C 6690.7 4754.91 6644.83 4777.84 6654.87 4805.07 C 6660.6 4822.27 6715.06 4829.44 6715.06 4850.94 C 6715.06 4872.43 6697.86 4879.6 6710.76 4895.36 C 6715.06 4902.53 6725.09 4905.4 6727.96 4914 C 6732.26 4921.16 6726.53 4931.19 6727.96 4938.36 C 6729.39 4942.66 6735.12 4941.23 6736.56 4944.09 C 6743.72 4954.12 6726.53 4978.49 6722.23 4987.09 C 6713.63 4999.99 6735.12 5007.15 6739.42 5020.05 C 6742.29 5027.22 6732.26 5035.81 6736.56 5041.55 C 6742.29 5050.15 6755.19 5047.28 6760.92 5053.01 C 6778.12 5068.78 6775.25 5141.87 6763.79 5169.1 M 6620.47 4628.8 C 6620.47 4628.8 6621.9 4628.8 6621.9 4628.8 M 6621.9 4628.8 C 6623.34 4630.23 6624.77 4630.23 6626.2 4631.66 C 6624.77 4630.23 6623.34 4630.23 6621.9 4628.8 M 6629.07 4631.66 C 6629.07 4633.09 6629.07 4633.09 6629.07 4633.09 C 6630.5 4633.09 6630.5 4633.09 6630.5 4633.09 M 6630.5 4633.09 C 6630.5 4633.09 6630.5 4633.09 6631.94 4633.09 C 6630.5 4633.09 6630.5 4633.09 6630.5 4633.09 M 6633.37 4633.09 C 6633.37 4633.09 6633.37 4634.53 6634.8 4634.53 C 6633.37 4634.53 6633.37 4633.09 6633.37 4633.09 M 6634.8 4634.53 C 6636.24 4634.53 6636.24 4634.53 6636.24 4634.53 M 6636.24 4634.53 C 6637.67 4634.53 6637.67 4634.53 6637.67 4635.96 C 6637.67 4634.53 6637.67 4634.53 6636.24 4634.53 M 6637.67 4635.96 C 6639.1 4635.96 6639.1 4635.96 6639.1 4635.96 M 6639.1 4635.96 C 6640.54 4635.96 6640.54 4635.96 6640.54 4635.96 C 6640.54 4635.96 6640.54 4635.96 6639.1 4635.96 M 6652 4638.83 C 6652 4638.83 6652 4638.83 6653.43 4638.83 C 6653.43 4638.83 6652 4638.83 6652 4638.83 M 7129.24 4408.09 C 7134.98 4410.95 7140.71 4413.82 7145.01 4419.55 C 7146.44 4420.99 7146.44 4426.72 7143.58 4425.29 C 7133.54 4418.12 7130.68 4412.39 7129.24 4408.09 " }
                }
            }
            // PATH visit cz count: 218
            DemoShape {
                objectName: "cz"
                ShapePath {
                    objectName: "svg_path:cz"
                    // boundingRect: 6433.73, 5135.41 831.662x469.065
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7050.42 5566.09 C 7071.92 5481.53 7119.21 5553.19 7162.21 5498.73 C 7165.07 5494.43 7160.77 5487.26 7163.64 5482.96 C 7167.94 5477.23 7177.97 5480.1 7182.27 5474.36 C 7182.27 5474.36 7193.74 5429.93 7193.74 5428.5 C 7206.64 5405.57 7241.03 5386.94 7265.4 5375.47 C 7259.66 5368.31 7263.96 5355.41 7258.23 5348.24 C 7252.5 5342.51 7241.03 5346.81 7235.3 5342.51 C 7233.87 5341.08 7220.97 5306.68 7219.53 5305.25 C 7212.37 5299.52 7199.47 5303.82 7190.87 5300.95 C 7183.71 5299.52 7167.94 5295.22 7162.21 5290.92 C 7159.34 5289.48 7159.34 5283.75 7156.48 5285.19 C 7132.11 5295.22 7179.41 5298.08 7137.84 5302.38 C 7134.98 5302.38 7130.68 5300.95 7127.81 5298.08 C 7123.51 5293.78 7124.95 5286.62 7120.65 5282.32 C 7114.91 5278.02 7094.85 5276.59 7100.58 5272.29 C 7119.21 5255.09 7130.68 5276.59 7113.48 5242.19 C 7113.48 5240.76 7110.61 5240.76 7109.18 5242.19 C 7107.75 5245.06 7109.18 5250.79 7106.31 5252.22 C 7100.58 5255.09 7093.42 5252.22 7087.68 5252.22 C 7081.95 5252.22 7074.78 5255.09 7069.05 5253.66 C 7056.15 5249.36 7031.79 5227.86 7010.29 5230.72 C 7001.69 5232.16 7033.22 5263.69 7031.79 5266.55 C 7027.49 5275.15 7013.16 5272.29 7005.99 5278.02 C 7001.69 5282.32 7003.13 5292.35 6997.39 5295.22 C 6975.9 5303.82 6967.3 5266.55 6963 5260.82 C 6963 5260.82 6930.03 5240.76 6930.03 5240.76 C 6927.17 5222.13 6981.63 5214.96 6942.93 5196.33 C 6935.77 5192.03 6904.24 5209.23 6904.24 5209.23 C 6899.94 5204.93 6904.24 5197.76 6899.94 5193.46 C 6898.51 5190.6 6894.21 5193.46 6889.91 5194.9 C 6888.47 5194.9 6887.04 5199.2 6884.17 5197.76 C 6881.31 5193.46 6882.74 5186.3 6877.01 5182 C 6858.38 5170.53 6839.75 5183.43 6816.81 5164.8 C 6801.05 5153.33 6822.55 5141.87 6796.75 5139 C 6756.62 5131.84 6802.48 5163.37 6763.79 5169.1 C 6760.92 5174.83 6759.49 5179.13 6755.19 5179.13 C 6736.56 5183.43 6706.46 5104.61 6690.7 5149.03 C 6687.83 5156.2 6713.63 5161.93 6707.89 5166.23 C 6690.7 5180.56 6666.33 5182 6649.13 5192.03 C 6646.27 5193.46 6649.13 5200.63 6646.27 5202.06 C 6634.8 5207.79 6619.04 5199.2 6610.44 5206.36 C 6603.27 5212.09 6606.14 5223.56 6598.97 5229.29 C 6596.11 5232.16 6593.24 5222.13 6588.94 5223.56 C 6576.04 5226.43 6574.61 5243.62 6566.01 5249.36 C 6561.71 5253.66 6553.11 5246.49 6548.81 5250.79 C 6544.51 5253.66 6548.81 5262.25 6544.51 5266.55 C 6538.78 5273.72 6523.02 5260.82 6518.72 5260.82 C 6482.89 5266.55 6477.15 5293.78 6465.69 5316.71 C 6462.82 5322.45 6462.82 5302.38 6457.09 5298.08 C 6452.79 5292.35 6444.19 5290.92 6437.03 5289.48 C 6424.13 5286.62 6451.36 5332.48 6480.02 5351.11 C 6482.89 5352.54 6492.92 5353.98 6494.35 5362.58 C 6498.65 5382.64 6480.02 5375.47 6477.15 5391.24 C 6475.72 5395.54 6507.25 5448.57 6511.55 5452.87 C 6535.91 5477.23 6541.65 5460.03 6557.41 5475.8 C 6567.44 5485.83 6568.88 5501.59 6578.91 5510.19 C 6598.97 5524.52 6649.13 5543.16 6659.17 5571.82 L 6660.6 5571.82 C 6683.53 5583.28 6700.73 5613.38 6730.82 5601.91 C 6736.56 5600.48 6735.12 5589.02 6740.86 5589.02 C 6750.89 5589.02 6760.92 5601.91 6770.95 5599.05 C 6770.95 5599.05 6782.42 5561.79 6782.42 5561.79 C 6788.15 5557.49 6798.18 5567.52 6801.05 5563.22 C 6803.92 5560.35 6801.05 5518.79 6802.48 5515.92 C 6806.78 5511.63 6815.38 5514.49 6821.11 5517.36 C 6823.98 5518.79 6821.11 5525.96 6823.98 5527.39 C 6831.15 5527.39 6836.88 5518.79 6844.05 5518.79 C 6885.61 5518.79 6918.57 5550.32 6957.27 5554.62 C 6963 5554.62 6970.16 5557.49 6975.9 5556.05 C 6984.5 5551.75 6987.36 5540.29 6994.53 5537.42 C 7004.56 5534.56 7018.89 5553.19 7026.06 5554.62 C 7030.36 5554.62 7036.09 5546.02 7040.39 5548.89 C 7047.55 5554.62 7050.42 5560.35 7050.42 5566.09 " }
                }
            }
            // PATH visit sk count: 145
            DemoShape {
                objectName: "sk"
                ShapePath {
                    objectName: "svg_path:sk"
                    // boundingRect: 7038.35, 5343.67 688.663x378.89
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7726.88 5389.81 C 7728.31 5404.14 7718.28 5424.2 7716.84 5438.53 C 7715.41 5448.57 7716.84 5458.6 7712.54 5467.2 C 7708.24 5477.23 7695.35 5480.1 7693.91 5490.13 C 7691.05 5500.16 7698.21 5510.19 7698.21 5521.66 C 7698.21 5533.12 7676.71 5533.12 7665.25 5535.99 C 7659.52 5537.42 7653.78 5544.59 7649.48 5541.72 C 7622.25 5533.12 7643.75 5505.89 7607.92 5504.46 C 7593.59 5504.46 7584.99 5524.52 7570.66 5525.96 C 7546.3 5530.26 7514.77 5504.46 7493.27 5531.69 C 7484.67 5543.15 7490.4 5581.85 7474.64 5589.02 C 7468.91 5590.45 7460.31 5584.72 7454.57 5587.58 C 7431.64 5601.91 7464.61 5611.95 7428.78 5617.68 C 7417.31 5619.11 7391.51 5587.58 7380.05 5607.65 C 7375.75 5614.81 7382.92 5627.71 7377.18 5633.44 C 7361.42 5649.21 7316.99 5639.18 7296.93 5653.51 C 7278.29 5664.97 7298.36 5685.04 7304.09 5693.64 C 7309.82 5703.67 7188 5725.17 7170.81 5722.3 C 7143.58 5716.57 7123.51 5679.31 7097.72 5676.44 C 7091.98 5675.01 7087.68 5676.44 7084.82 5677.87 C 7067.62 5659.24 7053.29 5640.61 7040.39 5619.11 C 7031.79 5604.78 7053.29 5584.72 7051.85 5566.09 C 7071.92 5481.53 7119.21 5551.75 7162.21 5498.73 C 7165.07 5494.43 7160.77 5487.26 7163.64 5482.96 C 7167.94 5477.23 7177.97 5480.1 7182.27 5474.36 C 7182.27 5474.36 7193.74 5429.93 7193.74 5428.5 C 7206.64 5405.57 7241.03 5386.94 7265.4 5375.47 C 7268.26 5379.77 7278.29 5372.61 7282.59 5376.91 C 7286.89 5381.21 7279.73 5391.24 7284.03 5395.54 C 7306.96 5414.17 7325.59 5341.08 7339.92 5351.11 C 7348.52 5356.84 7348.52 5369.74 7355.69 5376.91 C 7357.12 5378.34 7362.85 5374.04 7364.28 5375.47 C 7365.72 5378.34 7359.98 5384.07 7362.85 5385.51 C 7370.02 5386.94 7377.18 5379.77 7382.92 5382.64 C 7392.95 5386.94 7384.35 5414.17 7384.35 5417.04 C 7384.35 5424.2 7397.25 5412.74 7404.41 5411.3 C 7410.15 5409.87 7415.88 5421.34 7421.61 5418.47 C 7423.04 5417.04 7440.24 5372.61 7460.31 5368.31 C 7466.04 5366.88 7471.77 5372.61 7477.5 5372.61 C 7483.24 5371.18 7486.1 5362.58 7491.84 5364.01 C 7503.3 5365.44 7510.47 5381.21 7521.93 5381.21 C 7530.53 5381.21 7537.7 5372.61 7542 5365.44 C 7543.43 5362.58 7534.83 5362.58 7534.83 5359.71 C 7539.13 5339.65 7547.73 5359.71 7553.46 5356.84 C 7557.76 5355.41 7557.76 5346.81 7562.06 5346.81 C 7583.56 5341.08 7632.29 5342.51 7650.92 5356.84 C 7655.22 5361.14 7653.78 5371.18 7659.52 5374.04 C 7668.12 5379.77 7678.15 5379.77 7688.18 5382.64 C 7701.08 5386.94 7713.98 5388.37 7726.88 5389.81 " }
                }
            }
            // PATH visit si count: 115
            DemoShape {
                objectName: "si"
                ShapePath {
                    objectName: "svg_path:si"
                    // boundingRect: 6626.03, 5905.75 415.794x290.052
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7041.82 5974.54 C 7031.79 5973.1 7007.43 5967.37 7001.69 5968.81 C 6985.93 5971.67 7007.43 5991.74 6998.83 5997.47 C 6991.66 6000.33 6983.06 5996.04 6975.9 5998.9 C 6973.03 6000.33 6977.33 6006.07 6974.46 6008.93 C 6960.13 6020.4 6937.2 6021.83 6922.87 6034.73 C 6905.67 6050.5 6954.4 6090.62 6932.9 6106.39 C 6882.74 6142.22 6914.27 6082.03 6881.31 6129.32 C 6877.01 6135.05 6894.21 6136.49 6897.07 6143.65 C 6899.94 6149.38 6882.74 6147.95 6882.74 6153.68 C 6882.74 6156.55 6897.07 6175.18 6891.34 6182.35 C 6875.57 6198.11 6852.64 6173.75 6838.31 6173.75 C 6816.81 6173.75 6858.38 6193.81 6822.55 6183.78 C 6812.52 6180.91 6799.62 6165.15 6795.32 6156.55 C 6792.45 6153.68 6789.58 6145.08 6788.15 6147.95 C 6782.42 6156.55 6783.85 6166.58 6778.12 6173.75 C 6759.49 6198.11 6733.69 6173.75 6712.19 6180.91 C 6709.33 6182.35 6715.06 6188.08 6712.19 6190.95 C 6699.3 6198.11 6673.5 6196.68 6660.6 6190.95 C 6660.6 6190.95 6660.6 6189.51 6662.03 6189.51 C 6669.2 6182.35 6677.8 6175.18 6680.66 6168.02 C 6730.82 6170.88 6673.5 6136.49 6659.17 6127.89 C 6649.13 6122.15 6664.9 6103.52 6662.03 6096.36 C 6659.17 6089.19 6636.24 6109.26 6641.97 6090.62 C 6646.27 6077.73 6673.5 6066.26 6663.47 6057.66 C 6656.3 6051.93 6623.34 6054.8 6626.2 6037.6 C 6642.26 6003.66 6667.17 5992.19 6692.13 5996.04 C 6703.59 5997.47 6715.06 6006.07 6726.53 6007.5 C 6737.99 6008.93 6749.46 6000.33 6760.92 6001.77 C 6768.09 6003.2 6772.39 6013.23 6779.55 6013.23 C 6782.42 6014.67 6780.99 6006.07 6783.85 6004.63 C 6791.02 5997.47 6802.48 5994.6 6809.65 5986 C 6815.38 5981.7 6811.08 5971.67 6815.38 5967.37 C 6842.61 5945.87 6871.28 5973.1 6897.07 5961.64 C 6905.67 5957.34 6907.1 5944.44 6915.7 5941.58 C 6917.14 5940.14 6964.43 5947.31 6965.86 5945.87 C 6970.16 5944.44 6961.56 5938.71 6960.13 5934.41 C 6955.83 5911.48 6973.03 5905.75 6994.53 5905.75 C 7000.26 5905.75 7011.73 5950.17 7041.82 5974.54 " }
                }
            }
            // PATH visit hu count: 167
            DemoShape {
                objectName: "hu"
                ShapePath {
                    objectName: "svg_path:hu"
                    // boundingRect: 6971.6, 5504.46 834.102x584.228
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6994.53 5905.75 C 7000.26 5905.75 7011.73 5950.17 7041.82 5974.54 C 7080.52 6006.07 7113.48 6023.27 7143.58 6061.96 C 7147.88 6067.69 7176.54 6063.39 7179.41 6064.83 C 7190.87 6069.13 7199.47 6079.16 7209.5 6083.46 C 7229.57 6092.06 7292.63 6090.62 7311.26 6074.86 C 7314.12 6071.99 7315.56 6051.93 7325.59 6051.93 C 7352.82 6047.63 7348.52 6053.36 7372.88 6026.13 C 7377.18 6021.83 7382.92 6036.16 7395.81 6026.13 C 7408.71 6016.1 7417.31 5998.9 7433.08 5990.3 C 7466.04 5968.81 7438.81 5990.3 7463.17 5991.74 C 7464.61 5991.74 7501.87 5980.27 7503.3 5980.27 C 7510.47 5980.27 7517.63 5987.44 7524.8 5987.44 C 7527.66 5986 7529.1 5980.27 7531.96 5978.84 C 7540.56 5975.97 7583.56 5971.67 7586.42 5961.64 C 7589.29 5955.91 7567.79 5948.74 7593.59 5944.44 C 7603.62 5943.01 7613.65 5953.04 7622.25 5950.17 C 7649.48 5940.14 7640.89 5888.55 7648.05 5872.78 C 7650.92 5868.48 7658.08 5868.48 7660.95 5864.18 C 7660.95 5864.18 7676.71 5814.02 7676.71 5814.02 C 7679.58 5806.86 7683.88 5801.12 7683.88 5793.96 C 7683.88 5791.09 7676.71 5791.09 7676.71 5788.23 C 7678.15 5775.33 7693.91 5735.2 7701.08 5723.73 C 7703.94 5720.87 7711.11 5723.73 7711.11 5719.43 C 7718.28 5692.2 7708.24 5672.14 7739.77 5642.04 C 7749.81 5630.58 7761.27 5637.74 7777.04 5632.01 C 7792.8 5624.85 7794.23 5603.35 7805.7 5591.88 C 7788.5 5577.55 7811.43 5580.42 7792.8 5567.52 C 7789.93 5566.09 7785.63 5563.22 7781.34 5563.22 C 7775.6 5564.65 7771.3 5571.82 7765.57 5570.39 C 7756.97 5564.65 7755.54 5550.32 7746.94 5544.59 C 7742.64 5541.72 7736.91 5548.89 7732.61 5547.45 C 7709.68 5538.86 7731.17 5523.09 7698.21 5521.66 C 7698.21 5533.12 7676.71 5533.12 7665.25 5535.99 C 7659.52 5537.42 7653.78 5544.59 7649.48 5541.72 C 7622.25 5533.12 7643.75 5505.89 7607.92 5504.46 C 7593.59 5504.46 7584.99 5524.52 7570.66 5525.96 C 7546.3 5530.26 7514.77 5504.46 7493.27 5531.69 C 7484.67 5543.15 7490.4 5581.85 7474.64 5589.02 C 7468.91 5590.45 7460.31 5584.72 7454.57 5587.58 C 7431.64 5601.91 7464.61 5611.95 7428.78 5617.68 C 7417.31 5619.11 7391.51 5587.58 7380.05 5607.65 C 7375.75 5614.81 7382.92 5627.71 7377.18 5633.44 C 7361.42 5649.21 7316.99 5639.18 7296.93 5653.51 C 7278.29 5664.97 7298.36 5685.04 7304.09 5693.64 C 7309.82 5703.67 7188 5725.17 7170.81 5722.3 C 7143.58 5716.57 7123.51 5679.31 7097.72 5676.44 C 7091.98 5675.01 7087.68 5676.44 7084.82 5677.87 C 7064.75 5686.47 7084.82 5732.33 7083.38 5738.07 C 7074.78 5753.83 7023.19 5730.9 7003.13 5748.1 C 6994.53 5755.26 7037.52 5752.4 7038.96 5776.76 C 7041.82 5805.42 7017.46 5783.93 7007.43 5803.99 C 7000.26 5818.32 7026.06 5848.42 7023.19 5854.15 C 7010.29 5875.65 6998.83 5879.95 6973.03 5908.61 C 6973.03 5908.61 6973.03 5908.61 6971.6 5910.05 C 6974.46 5908.61 6975.9 5907.18 6978.76 5907.18 L 6994.53 5905.75 " }
                }
            }
            // PATH visit ro count: 264
            DemoShape {
                objectName: "ro"
                ShapePath {
                    objectName: "svg_path:ro"
                    // boundingRect: 7524.8, 5424.2 1255.45x932.997
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 8695.69 6202.41 C 8672.76 6206.71 8635.5 6219.61 8614 6200.98 C 8606.84 6195.25 8605.41 6175.18 8596.81 6179.48 C 8592.51 6180.91 8589.64 6186.65 8585.34 6188.08 C 8550.95 6206.71 8596.81 6178.05 8559.54 6179.48 C 8548.08 6179.48 8539.48 6192.38 8528.01 6193.81 C 8503.65 6196.68 8523.72 6162.28 8459.22 6186.65 C 8431.99 6198.11 8381.83 6221.04 8360.33 6242.54 C 8335.97 6266.9 8331.67 6297 8300.14 6317.06 C 8271.48 6334.26 8249.98 6322.8 8221.32 6321.36 C 8198.39 6319.93 8174.02 6318.5 8152.53 6325.66 C 8143.93 6328.53 8141.06 6340 8132.46 6342.86 C 8092.33 6357.19 8045.04 6334.26 8004.91 6338.56 C 7973.38 6341.43 7963.35 6367.23 7928.95 6352.89 C 7904.59 6342.86 7959.05 6311.33 7946.15 6305.6 C 7923.22 6295.57 7854.43 6281.24 7858.73 6243.97 C 7860.16 6231.07 7907.45 6229.64 7893.12 6222.48 C 7741.21 6146.52 7877.36 6215.31 7815.73 6251.14 C 7805.7 6258.3 7799.97 6232.51 7789.93 6228.21 C 7782.77 6223.91 7772.74 6228.21 7765.57 6228.21 C 7756.97 6228.21 7748.37 6232.51 7739.77 6229.64 C 7735.47 6226.77 7738.34 6219.61 7735.47 6213.88 C 7728.31 6199.54 7666.68 6222.48 7701.08 6198.11 C 7709.68 6192.38 7731.17 6186.65 7724.01 6180.91 C 7716.84 6176.61 7702.51 6180.91 7699.64 6172.31 C 7698.21 6163.72 7728.31 6147.95 7708.24 6136.49 C 7681.01 6120.72 7626.55 6127.89 7607.92 6094.92 C 7603.62 6087.76 7603.62 6053.36 7603.62 6044.76 L 7603.62 6041.9 C 7599.32 6043.33 7596.46 6051.93 7593.59 6049.06 C 7583.56 6043.33 7582.13 6027.56 7573.53 6020.4 C 7564.93 6014.67 7552.03 6016.1 7543.43 6008.93 C 7534.83 6004.63 7530.53 5994.6 7524.8 5987.44 C 7527.66 5986 7529.1 5980.27 7531.96 5978.84 C 7540.56 5975.97 7583.56 5971.67 7586.42 5961.64 C 7589.29 5955.91 7567.79 5948.74 7593.59 5944.44 C 7603.62 5943.01 7613.65 5953.04 7622.25 5950.17 C 7649.48 5940.14 7640.89 5888.55 7648.05 5872.78 C 7650.92 5868.48 7658.08 5868.48 7660.95 5864.18 L 7676.71 5814.02 C 7679.58 5806.86 7683.88 5801.12 7683.88 5793.96 C 7683.88 5791.09 7676.71 5791.09 7676.71 5788.23 C 7678.15 5775.33 7693.91 5735.2 7701.08 5723.73 C 7703.94 5720.87 7711.11 5723.73 7711.11 5719.43 C 7718.28 5692.2 7708.24 5672.14 7739.77 5642.04 C 7749.81 5630.58 7761.27 5637.74 7777.04 5632.01 C 7792.8 5624.85 7794.23 5603.35 7805.7 5591.88 C 7810 5594.75 7818.6 5589.02 7828.63 5561.79 C 7830.06 5558.92 7830.06 5554.62 7832.93 5554.62 C 7837.23 5554.62 7873.06 5571.82 7877.36 5571.82 C 7880.22 5571.82 7881.66 5564.65 7884.52 5563.22 C 7903.15 5556.05 7950.45 5574.68 7973.38 5568.95 C 7986.28 5564.65 7994.88 5553.19 8007.78 5551.75 C 8030.71 5550.32 8046.47 5580.42 8062.24 5584.72 C 8083.73 5591.88 8090.9 5551.75 8096.63 5546.02 C 8122.43 5518.79 8188.35 5521.66 8208.42 5501.59 C 8247.11 5464.33 8191.22 5495.86 8218.45 5460.03 C 8225.62 5451.43 8237.08 5444.27 8248.55 5441.4 L 8249.98 5437.1 L 8255.71 5424.2 C 8254.28 5427.07 8254.28 5432.8 8254.28 5435.67 C 8274.34 5425.64 8287.24 5434.23 8303.01 5447.13 C 8333.1 5468.63 8338.84 5504.46 8363.2 5528.82 C 8403.33 5567.52 8512.25 5636.31 8525.15 5692.2 C 8535.18 5728.03 8522.28 5768.16 8530.88 5803.99 C 8533.75 5819.76 8559.54 5855.59 8558.11 5871.35 C 8558.11 5877.08 8546.65 5878.52 8548.08 5884.25 C 8549.51 5889.98 8558.11 5887.11 8562.41 5889.98 C 8566.71 5892.85 8566.71 5902.88 8572.44 5902.88 C 8575.31 5904.31 8579.61 5901.45 8582.47 5904.31 C 8586.77 5908.61 8585.34 5917.21 8591.07 5921.51 C 8596.81 5927.24 8658.43 5930.11 8657 5922.94 C 8657 5921.51 8636.94 5917.21 8651.27 5908.61 C 8659.87 5904.31 8669.9 5905.75 8678.5 5901.45 C 8692.83 5894.28 8698.56 5874.22 8714.33 5868.48 C 8745.86 5857.02 8761.62 5868.48 8768.79 5895.71 C 8767.35 5897.15 8763.05 5895.71 8763.05 5897.15 C 8763.05 5901.45 8765.92 5904.31 8768.79 5905.75 C 8771.65 5907.18 8774.52 5901.45 8775.95 5904.31 C 8778.82 5910.05 8780.25 5958.77 8780.25 5964.51 C 8778.82 5983.14 8735.82 5984.57 8724.36 5993.17 C 8717.19 5998.9 8717.19 6018.97 8708.59 6017.53 C 8707.16 6016.1 8718.63 5968.81 8698.56 5957.34 C 8691.4 5954.47 8682.8 5965.94 8678.5 5973.1 C 8672.76 5983.14 8698.56 5991.74 8697.13 6003.2 C 8697.13 6014.67 8675.63 6021.83 8681.36 6030.43 C 8687.1 6039.03 8698.28 6018.2 8708.31 6018.2 C 8711.18 6016.77 8707.16 6024.7 8704.29 6027.56 C 8700.9 6029.41 8703.48 6030 8702.86 6031.86 C 8711.46 6039.03 8677.06 6094.92 8677.06 6096.36 C 8678.5 6106.39 8691.4 6156.55 8698.56 6202.41 L 8695.69 6202.41 " }
                }
            }
            // PATH visit bg count: 211
            DemoShape {
                objectName: "bg"
                ShapePath {
                    objectName: "svg_path:bg"
                    // boundingRect: 7863.73, 6177.87 840.036x636.981
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 8477.85 6648.13 C 8470.69 6646.69 8463.52 6646.69 8459.22 6646.69 C 8403.33 6658.16 8493.62 6698.29 8462.09 6722.65 C 8462.09 6722.65 8417.66 6736.98 8416.23 6736.98 C 8396.16 6744.15 8363.2 6769.94 8341.7 6768.51 C 8337.4 6768.51 8340.27 6761.35 8337.4 6759.91 C 8323.07 6752.75 8304.44 6744.15 8288.68 6748.45 C 8282.94 6749.88 8282.94 6761.35 8277.21 6762.78 C 8272.91 6764.21 8270.04 6754.18 8265.75 6752.75 C 8262.88 6751.31 8258.58 6757.05 8257.15 6754.18 C 8247.11 6748.45 8244.25 6732.68 8232.78 6731.25 C 8224.18 6728.38 8219.88 6742.71 8211.29 6744.15 C 8205.55 6747.01 8198.39 6735.55 8194.09 6738.42 C 8168.29 6754.18 8158.26 6771.38 8118.13 6785.71 C 8100.93 6791.44 8079.43 6785.71 8063.67 6795.74 C 8057.94 6798.61 8057.94 6810.07 8052.2 6812.94 C 8047.9 6817.24 8040.74 6812.94 8035.01 6812.94 C 8000.45 6809.98 8017.43 6764.43 8014.94 6734.12 C 8004.91 6724.08 7989.14 6695.42 7976.25 6686.82 C 7969.08 6682.52 7959.05 6686.82 7950.45 6682.52 C 7947.58 6681.09 7908.89 6650.99 7908.89 6648.13 C 7916.05 6635.23 7936.12 6632.36 7928.95 6613.73 C 7927.52 6608 7923.22 6605.13 7918.92 6602.26 C 7916.05 6600.83 7911.75 6603.7 7910.32 6600.83 C 7908.89 6593.67 7910.32 6586.5 7910.32 6579.33 C 7908.89 6570.73 7898.85 6562.14 7903.15 6554.97 C 7944.72 6486.18 7897.42 6570.73 7943.28 6534.91 C 7947.58 6530.61 7977.68 6477.58 7969.08 6468.98 C 7957.61 6460.38 7903.15 6434.58 7900.29 6431.72 C 7883.09 6417.39 7855.86 6357.19 7865.89 6335.7 C 7870.19 6325.66 7885.96 6327.1 7891.69 6318.5 C 7895.99 6308.47 7890.26 6295.57 7894.56 6285.53 C 7913.19 6294.13 7936.12 6299.87 7946.15 6305.6 C 7959.05 6311.33 7904.59 6342.86 7928.95 6352.89 C 7963.35 6367.23 7973.38 6341.43 8004.91 6338.56 C 8045.04 6334.26 8092.33 6357.19 8132.46 6342.86 C 8141.06 6340 8143.93 6328.53 8152.53 6325.66 C 8174.02 6318.5 8198.39 6319.93 8221.32 6321.36 C 8249.98 6322.8 8271.48 6334.26 8300.14 6317.06 C 8331.67 6297 8335.97 6266.9 8360.33 6242.54 C 8381.83 6221.04 8431.99 6198.11 8459.22 6186.65 C 8523.72 6162.28 8503.65 6196.68 8528.01 6193.81 C 8539.48 6192.38 8548.08 6179.48 8559.54 6179.48 C 8596.81 6178.05 8550.95 6206.71 8585.34 6188.08 C 8589.64 6186.65 8592.51 6180.91 8596.81 6179.48 C 8605.41 6175.18 8606.84 6195.25 8614 6200.98 C 8635.5 6219.61 8672.76 6206.71 8695.69 6202.41 L 8698.56 6202.41 C 8704.29 6238.24 8707.16 6271.2 8697.13 6276.94 C 8691.4 6279.8 8684.23 6269.77 8677.06 6271.2 C 8624.04 6285.53 8658.43 6284.1 8642.67 6315.63 C 8641.23 6321.36 8631.2 6321.36 8628.34 6325.66 C 8628.34 6328.53 8636.94 6327.1 8636.94 6329.96 C 8639.8 6352.89 8638.37 6367.23 8644.1 6390.16 C 8645.53 6398.75 8654.13 6410.22 8649.83 6417.39 C 8645.53 6424.55 8632.64 6420.25 8625.47 6424.55 C 8624.04 6424.55 8629.77 6427.42 8629.77 6428.85 C 8626.9 6434.58 8619.74 6436.02 8618.3 6441.75 C 8616.87 6446.05 8625.47 6450.35 8622.6 6453.22 C 8616.87 6461.81 8603.97 6464.68 8598.24 6473.28 C 8572.44 6507.68 8635.5 6456.08 8651.27 6494.78 C 8652.7 6497.64 8648.4 6501.94 8648.4 6504.81 C 8649.83 6506.24 8681.36 6524.87 8688.53 6530.61 C 8692.83 6536.34 8697.13 6540.64 8698.56 6544.94 L 8695.7 6544.94 C 8687.1 6546.37 8678.5 6544.94 8669.9 6547.8 C 8658.43 6552.1 8649.83 6562.14 8639.8 6569.3 C 8636.94 6570.73 8639.8 6576.47 8638.37 6575.03 C 8605.41 6567.87 8595.37 6542.07 8562.41 6559.27 L 8538.05 6586.5 C 8528.01 6590.8 8515.12 6583.63 8507.95 6590.8 C 8499.35 6597.96 8507.95 6612.3 8502.22 6620.9 C 8493.62 6630.93 8464.96 6626.63 8477.85 6648.13 " }
                }
            }
            // PATH visit cy count: 64
            DemoShape {
                objectName: "cy"
                ShapePath {
                    objectName: "svg_path:cy"
                    // boundingRect: 9613.09, 7409.12 313.697x281.029
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 9926.78 7409.14 C 9925.35 7432.07 9860.86 7487.96 9849.39 7513.76 C 9836.49 7545.29 9900.99 7549.59 9893.82 7561.05 C 9889.52 7566.78 9878.06 7559.62 9872.32 7562.49 C 9866.59 7563.92 9865.16 7572.52 9859.43 7575.38 C 9850.83 7581.12 9836.49 7575.38 9829.33 7582.55 C 9823.6 7589.72 9830.76 7602.61 9826.46 7609.78 C 9815 7629.84 9764.84 7644.18 9753.37 7659.94 C 9749.07 7665.67 9757.67 7675.71 9753.37 7682.87 C 9741.91 7704.37 9730.44 7671.41 9726.14 7671.41 C 9717.54 7671.41 9711.81 7682.87 9703.21 7685.74 C 9698.91 7687.17 9651.62 7680.01 9650.18 7680.01 C 9645.88 7677.14 9647.32 7669.97 9644.45 7665.67 C 9640.15 7661.37 9602.89 7621.25 9615.79 7622.68 C 9622.95 7622.68 9627.25 7629.84 9634.42 7629.84 C 9647.32 7628.41 9650.18 7602.61 9653.05 7598.31 C 9663.08 7582.55 9690.31 7594.02 9700.34 7585.42 C 9707.51 7581.12 9706.08 7569.65 9704.64 7561.05 C 9703.21 7553.89 9690.31 7545.29 9696.04 7538.12 C 9700.34 7532.39 9711.81 7540.99 9720.41 7539.55 C 9737.61 7538.12 9779.17 7528.09 9794.93 7519.49 C 9815 7508.03 9925.35 7407.7 9926.78 7409.14 " }
                }
            }
            // PATH visit mt count: 16
            DemoShape {
                objectName: "mt"
                ShapePath {
                    objectName: "svg_path:mt"
                    // boundingRect: 6811.81, 7968.28 95.416x55.3057
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6829.95 7968.49 C 6819.72 7970.54 6811.81 7987.11 6811.81 7987.11 C 6830 7987.11 6837.23 7979.49 6829.95 8008.6 C 6822.67 8037.71 6917.26 8019.74 6906.35 7994.27 C 6895.43 7968.8 6855.01 7986.86 6840.46 7972.31 C 6836.82 7968.67 6833.36 7967.81 6829.95 7968.49 " }
                }
            }
            // PATH visit hr count: 339
            DemoShape {
                objectName: "hr"
                ShapePath {
                    objectName: "svg_path:hr"
                    // boundingRect: 6647.7, 5968.58 787.166x732.576
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7367.15 6701.15 L 7364.28 6691.12 C 7347.09 6662.46 7319.86 6672.49 7288.33 6648.13 C 7279.73 6640.96 7276.86 6628.06 7266.83 6625.2 C 7261.1 6622.33 7253.93 6628.06 7246.76 6629.49 C 7249.63 6630.93 7251.06 6630.93 7253.93 6632.36 C 7256.8 6633.79 7259.66 6642.39 7256.8 6642.39 C 7233.87 6640.96 7216.67 6619.46 7193.74 6616.6 C 7183.71 6615.16 7172.24 6618.03 7162.21 6616.6 C 7159.34 6616.6 7156.48 6609.43 7155.04 6610.86 C 7152.18 6612.3 7152.18 6619.46 7155.04 6620.9 C 7163.64 6623.76 7173.67 6619.46 7183.71 6620.9 C 7192.3 6622.33 7202.34 6625.2 7212.37 6630.93 C 7215.23 6632.36 7213.8 6638.09 7216.67 6639.53 C 7265.4 6665.32 7255.36 6623.76 7331.32 6683.95 C 7341.35 6691.12 7354.25 6698.29 7367.15 6701.15 M 7391.51 6241.11 C 7378.62 6226.78 7400.11 6233.94 7405.85 6223.91 C 7407.28 6222.48 7407.28 6219.61 7405.85 6218.18 C 7387.21 6199.55 7400.11 6192.38 7401.55 6173.75 C 7402.98 6166.58 7438.81 6195.25 7434.51 6166.58 C 7414.44 6166.58 7391.51 6160.85 7374.32 6149.38 C 7367.15 6143.65 7380.05 6140.79 7380.05 6139.35 C 7380.05 6135.05 7365.72 6132.19 7374.32 6123.59 C 7375.75 6122.15 7385.78 6130.75 7387.21 6122.15 C 7388.65 6106.39 7358.55 6125.02 7358.55 6110.69 C 7361.42 6077.73 7367.15 6086.32 7342.79 6051.93 L 7341.35 6049.06 C 7337.05 6050.5 7332.75 6050.5 7325.59 6051.93 C 7315.56 6051.93 7314.12 6071.99 7311.26 6074.86 C 7292.63 6090.62 7229.57 6092.06 7209.5 6083.46 C 7199.47 6079.16 7190.87 6069.13 7179.41 6064.83 C 7176.54 6063.39 7147.88 6067.69 7143.58 6061.96 C 7113.48 6023.27 7080.52 6006.07 7041.82 5974.54 C 7031.79 5973.1 7007.43 5967.37 7001.69 5968.81 C 6985.93 5971.67 7007.43 5991.74 6998.83 5997.47 C 6991.66 6000.33 6983.06 5996.04 6975.9 5998.9 C 6973.03 6000.33 6977.33 6006.07 6974.46 6008.93 C 6960.13 6020.4 6937.2 6021.83 6922.87 6034.73 C 6905.67 6050.5 6954.4 6090.62 6932.9 6106.39 C 6882.74 6142.22 6914.27 6082.03 6881.31 6129.32 C 6877.01 6135.05 6894.21 6136.49 6897.07 6143.65 C 6899.94 6149.38 6882.74 6147.95 6882.74 6153.68 C 6882.74 6156.55 6897.07 6175.18 6891.34 6182.35 C 6875.57 6198.11 6852.64 6173.75 6838.31 6173.75 C 6816.81 6173.75 6858.38 6193.81 6822.55 6183.78 C 6812.52 6180.91 6799.62 6165.15 6795.32 6156.55 C 6792.45 6153.68 6789.58 6145.08 6788.15 6147.95 C 6782.42 6156.55 6783.85 6166.58 6778.12 6173.75 C 6759.49 6198.11 6733.69 6173.75 6712.19 6180.91 C 6709.33 6182.35 6715.06 6188.08 6712.19 6190.95 C 6699.3 6198.11 6673.5 6196.68 6660.6 6190.95 C 6656.3 6190.95 6647.7 6186.65 6647.7 6190.95 C 6649.13 6202.41 6659.17 6211.01 6663.47 6221.04 C 6663.47 6222.48 6660.6 6222.48 6660.6 6223.91 C 6662.03 6235.37 6659.17 6246.84 6664.9 6255.44 C 6664.9 6255.44 6666.33 6255.44 6666.33 6256.87 C 6660.6 6265.47 6683.53 6275.5 6690.7 6285.53 C 6696.43 6294.13 6700.73 6331.4 6707.89 6322.8 C 6715.06 6314.2 6719.36 6302.73 6725.09 6292.7 C 6726.53 6288.4 6727.96 6284.1 6727.96 6279.8 C 6727.96 6278.37 6723.66 6279.8 6723.66 6276.94 C 6723.66 6275.5 6723.66 6269.77 6725.09 6271.2 C 6730.82 6272.64 6726.53 6305.6 6742.29 6279.8 C 6745.16 6272.64 6745.16 6265.47 6745.16 6256.87 C 6745.16 6255.44 6742.29 6254.01 6742.29 6251.14 C 6742.29 6249.71 6743.72 6255.44 6745.16 6254.01 C 6756.62 6248.27 6746.59 6209.58 6759.49 6209.58 C 6801.05 6206.71 6786.72 6222.48 6812.52 6243.97 C 6818.25 6248.27 6826.85 6243.97 6831.15 6248.27 C 6856.94 6278.37 6826.85 6315.63 6855.51 6347.16 C 6864.11 6357.19 6888.47 6378.69 6898.51 6385.86 C 6909.97 6391.59 6945.8 6397.32 6934.33 6401.62 C 6914.27 6407.35 6877.01 6365.79 6882.74 6420.25 C 6884.17 6437.45 6950.1 6474.71 6960.13 6487.61 C 6963 6489.04 6948.67 6483.31 6951.53 6484.74 C 6960.13 6490.48 6997.39 6501.94 6998.83 6506.24 C 7001.69 6516.27 6993.09 6532.04 7000.26 6540.64 C 7004.56 6543.5 7048.99 6527.74 7050.42 6526.31 C 7079.08 6520.57 7059.02 6532.04 7094.85 6544.94 C 7106.31 6547.8 7119.21 6543.5 7130.68 6547.8 C 7146.44 6553.54 7156.48 6579.33 7173.67 6587.93 C 7193.74 6596.53 7206.64 6602.26 7212.37 6608 C 7212.37 6609.43 7213.8 6608 7213.8 6608 C 7216.67 6608 7219.53 6605.13 7220.97 6608 C 7226.7 6618.03 7218.1 6618.03 7231 6623.76 C 7235.3 6619.46 7245.33 6619.46 7246.76 6613.73 C 7253.93 6595.1 7192.3 6570.73 7186.57 6560.7 C 7180.84 6552.1 7185.14 6539.21 7179.41 6530.61 C 7175.11 6524.87 7165.07 6526.31 7157.91 6523.44 C 7127.81 6504.81 7109.18 6470.41 7083.38 6448.92 C 7074.78 6443.18 7041.82 6410.22 7031.79 6405.92 C 7027.49 6404.49 7021.76 6410.22 7017.46 6407.35 C 7010.29 6400.19 7027.49 6384.42 7027.49 6381.56 C 7026.06 6375.82 7018.89 6374.39 7014.59 6370.09 C 7003.13 6352.89 6998.83 6329.96 6983.06 6315.63 C 6977.33 6308.47 6965.86 6308.47 6958.7 6302.73 C 6952.97 6298.43 6942.93 6215.31 6974.46 6216.74 C 6988.79 6216.74 7013.16 6248.27 7026.06 6255.44 L 7037.52 6254.01 L 7026.06 6255.44 C 7043.25 6254.01 7040.39 6226.77 7048.99 6215.31 C 7064.75 6196.68 7071.92 6219.61 7091.98 6215.31 C 7097.72 6213.88 7097.72 6202.41 7103.45 6198.11 C 7103.45 6198.11 7112.05 6206.71 7136.41 6213.88 C 7139.28 6215.31 7143.58 6216.74 7147.88 6215.31 C 7150.74 6215.31 7152.18 6209.58 7156.48 6208.14 C 7173.67 6206.71 7212.37 6228.21 7231 6225.34 C 7235.3 6225.34 7239.6 6222.48 7241.03 6218.18 C 7245.33 6215.31 7243.9 6205.28 7249.63 6205.28 C 7258.23 6203.84 7263.96 6212.44 7272.56 6215.31 C 7288.33 6219.61 7269.7 6208.14 7278.29 6205.28 C 7286.89 6202.41 7296.93 6202.41 7305.52 6205.28 C 7311.26 6206.71 7315.56 6215.31 7321.29 6215.31 C 7325.59 6215.31 7321.29 6205.28 7325.59 6205.28 C 7358.55 6206.71 7349.95 6242.54 7365.72 6245.41 C 7375.75 6246.84 7384.35 6243.97 7391.51 6241.11 " }
                }
            }
            // PATH visit ba count: 150
            DemoShape {
                objectName: "ba"
                ShapePath {
                    objectName: "svg_path:ba"
                    // boundingRect: 6952.52, 6198.11 537.243x503.041
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7430.21 6546.37 C 7415.88 6536.34 7415.88 6526.31 7400.11 6527.74 L 7402.98 6523.44 L 7400.11 6527.74 C 7380.05 6550.67 7382.92 6583.63 7377.18 6590.8 C 7365.72 6605.13 7361.42 6583.63 7357.12 6605.13 C 7349.95 6646.69 7394.38 6648.13 7361.42 6679.66 L 7368.58 6678.22 L 7370.02 6701.15 C 7352.82 6659.59 7324.16 6673.92 7288.33 6648.13 C 7279.73 6640.96 7276.86 6628.06 7266.83 6625.19 C 7259.66 6622.33 7251.06 6630.93 7242.47 6630.93 C 7238.17 6630.93 7228.13 6629.49 7229.57 6625.19 C 7232.43 6619.46 7245.33 6620.9 7246.76 6613.73 C 7253.93 6595.1 7192.3 6570.73 7186.57 6560.7 C 7180.84 6552.1 7185.14 6539.21 7179.41 6530.61 C 7175.11 6524.87 7165.07 6526.31 7157.91 6523.44 C 7127.81 6504.81 7109.18 6470.41 7083.38 6448.92 C 7074.78 6443.18 7041.82 6410.22 7031.79 6405.92 C 7027.49 6404.49 7021.76 6410.22 7017.46 6407.35 C 7010.29 6400.19 7027.49 6384.42 7027.49 6381.56 C 7026.06 6375.82 7018.89 6374.39 7014.59 6370.09 C 7003.13 6352.89 6998.83 6329.96 6983.06 6315.63 C 6977.33 6308.47 6965.86 6308.47 6958.7 6302.73 C 6952.97 6298.43 6942.93 6215.31 6974.46 6216.74 C 6988.79 6216.74 7013.16 6248.27 7026.06 6255.44 L 7037.52 6254.01 L 7026.06 6255.44 C 7043.25 6254.01 7040.39 6226.77 7048.99 6215.31 C 7064.75 6196.68 7071.92 6219.61 7091.98 6215.31 C 7097.72 6213.88 7097.72 6202.41 7103.45 6198.11 C 7103.45 6198.11 7112.05 6206.71 7136.41 6213.88 C 7139.28 6215.31 7143.58 6216.74 7147.88 6215.31 C 7150.74 6215.31 7152.18 6209.58 7156.48 6208.14 C 7173.67 6206.71 7212.37 6228.21 7231 6225.34 C 7235.3 6225.34 7239.6 6222.48 7241.03 6218.18 C 7245.33 6215.31 7243.9 6205.28 7249.63 6205.28 C 7258.23 6203.84 7263.96 6212.44 7272.56 6215.31 C 7288.33 6219.61 7269.7 6208.14 7278.29 6205.28 C 7286.89 6202.41 7296.93 6202.41 7305.52 6205.28 C 7311.26 6206.71 7315.56 6215.31 7321.29 6215.31 C 7325.59 6215.31 7321.29 6205.28 7325.59 6205.28 C 7358.55 6206.71 7349.95 6242.54 7365.72 6245.41 C 7392.95 6248.27 7407.28 6228.21 7433.08 6229.64 C 7433.08 6274.07 7407.28 6304.17 7411.58 6331.4 C 7417.31 6362.93 7425.91 6340 7445.97 6348.59 C 7458.87 6354.33 7461.74 6372.96 7474.64 6380.12 C 7478.94 6381.56 7493.27 6377.26 7488.97 6390.16 C 7480.37 6418.82 7444.54 6387.29 7437.38 6397.32 C 7437.38 6397.32 7501.87 6457.51 7484.67 6476.15 C 7478.94 6480.45 7471.77 6466.11 7464.61 6468.98 C 7456.01 6471.85 7454.57 6483.31 7448.84 6490.48 C 7438.81 6493.34 7411.58 6487.61 7410.15 6494.78 C 7405.85 6514.84 7441.67 6516.27 7430.21 6546.37 L 7424.48 6546.37 L 7430.21 6546.37 " }
                }
            }
            // PATH visit me count: 95
            DemoShape {
                objectName: "me"
                ShapePath {
                    objectName: "svg_path:me"
                    // boundingRect: 7357.01, 6465.39 262.356x329.8
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7364.97 6687.77 L 7367.84 6697.8 C 7375.01 6699.23 7380.74 6699.23 7387.9 6699.23 C 7385.04 6702.09 7382.17 6704.96 7383.61 6709.26 C 7403.67 6753.66 7407.97 6712.12 7428.03 6722.15 C 7432.33 6725.01 7429.47 6730.74 7432.33 6735.04 C 7443.8 6749.36 7458.13 6746.49 7468.16 6762.25 C 7471.03 6766.55 7468.16 6775.14 7472.46 6779.44 C 7481.06 6788.03 7492.53 6792.33 7503.99 6795.19 C 7503.99 6785.17 7503.99 6775.14 7503.99 6766.55 C 7503.99 6760.82 7506.86 6753.66 7503.99 6747.93 C 7499.69 6740.77 7486.79 6740.77 7485.36 6733.6 C 7485.36 6732.17 7531.22 6639.08 7535.52 6636.21 C 7536.95 6634.78 7544.12 6670.59 7555.59 6672.02 C 7555.59 6672.02 7588.55 6646.95 7588.55 6646.95 C 7585.54 6631.87 7588.54 6632.67 7583.46 6618.14 C 7580.05 6608.4 7591.54 6613.99 7599.36 6607.55 C 7602.79 6604.72 7601.08 6600.33 7596.56 6595.16 C 7591.96 6589.89 7626.09 6589.56 7618.17 6583.5 C 7602.45 6571.48 7583.24 6550.99 7567.94 6543.88 C 7558.06 6539.29 7570.45 6519.73 7560.82 6510.26 C 7542.78 6492.52 7499.02 6481.72 7485.36 6472.93 C 7479.63 6477.23 7472.46 6462.91 7465.3 6465.77 C 7456.7 6468.64 7455.26 6480.1 7449.53 6487.26 C 7439.5 6490.12 7412.27 6484.39 7410.84 6491.55 C 7406.54 6511.61 7442.36 6513.04 7430.9 6543.11 L 7425.17 6543.11 L 7430.9 6543.11 C 7416.57 6533.09 7416.57 6523.06 7400.8 6524.5 L 7403.67 6520.2 L 7400.8 6524.5 C 7380.74 6547.41 7383.61 6580.35 7377.87 6587.51 C 7366.41 6601.84 7362.11 6580.35 7357.81 6601.84 C 7350.64 6643.37 7395.07 6644.8 7362.11 6676.31 L 7369.27 6674.88 L 7370.71 6697.8 C 7369.27 6693.5 7367.84 6690.64 7364.97 6687.77 " }
                }
            }
            // PATH visit rs count: 210
            DemoShape {
                objectName: "rs"
                ShapePath {
                    objectName: "svg_path:rs"
                    // boundingRect: 7329.87, 5973.8 653.296x724.318
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7686.47 6519.21 C 7710.27 6519.21 7743.85 6594.24 7757.24 6601.67 C 7761.71 6604.65 7793.42 6622.31 7799.37 6623.8 C 7809.79 6626.77 7800.22 6642.13 7807.66 6649.57 C 7827 6670.39 7807.61 6669.72 7803.14 6690.54 C 7803.14 6690.54 7802.46 6680.35 7802.46 6680.35 L 7798.59 6688.08 C 7835.79 6713.35 7799.84 6683.67 7808.77 6677.72 C 7825.14 6667.31 7792.71 6681.11 7812.05 6679.62 C 7819.49 6679.62 7806.4 6677.77 7809.37 6670.34 C 7810.86 6664.39 7800.51 6689.04 7802 6684.58 C 7815.39 6651.86 7783.7 6698.19 7811.97 6693.73 C 7835.77 6689.27 7899.74 6648.87 7919.08 6666.72 C 7926.52 6653.34 7947.35 6650.36 7939.91 6631.03 C 7938.42 6625.08 7933.96 6622.11 7929.49 6619.14 C 7926.52 6617.65 7922.05 6620.62 7920.57 6617.65 C 7919.08 6610.21 7920.57 6602.78 7920.57 6595.34 C 7919.08 6586.42 7908.66 6577.5 7913.13 6570.07 C 7956.28 6498.69 7907.18 6586.42 7954.79 6549.25 C 7959.25 6544.79 7990.5 6489.77 7981.57 6480.85 C 7969.67 6471.93 7913.13 6445.16 7910.15 6442.19 C 7892.3 6427.32 7864.03 6364.87 7874.44 6342.56 C 7878.91 6332.16 7895.27 6333.64 7901.22 6324.72 C 7905.69 6314.31 7899.74 6300.93 7904.2 6290.52 C 7883.37 6281.6 7864.03 6268.22 7867 6247.4 C 7868.49 6234.02 7917.59 6232.53 7902.71 6225.1 C 7745 6146.29 7886.35 6217.66 7822.37 6254.83 C 7811.95 6262.27 7806 6235.5 7795.58 6231.04 C 7788.14 6226.58 7777.73 6231.04 7770.29 6231.04 C 7761.36 6231.04 7752.43 6235.5 7743.51 6232.53 C 7739.04 6229.56 7742.02 6222.12 7739.04 6216.17 C 7731.6 6201.3 7667.62 6225.1 7703.33 6199.82 C 7712.26 6193.87 7734.58 6187.92 7727.14 6181.97 C 7719.7 6177.51 7704.82 6181.97 7701.85 6173.05 C 7700.36 6164.13 7731.6 6147.77 7710.77 6135.88 C 7682.5 6119.52 7625.96 6126.96 7606.62 6092.76 C 7602.16 6085.32 7602.16 6049.64 7602.16 6040.71 C 7602.16 6039.23 7602.16 6037.74 7602.16 6037.74 C 7597.69 6039.23 7594.72 6048.15 7591.74 6045.17 C 7581.33 6039.23 7579.84 6022.87 7570.91 6015.44 C 7561.98 6009.49 7548.59 6010.98 7539.67 6003.54 C 7530.74 5999.08 7526.27 5988.67 7520.32 5981.24 C 7512.88 5981.24 7505.44 5973.8 7498 5973.8 C 7496.52 5973.8 7457.83 5985.7 7456.34 5985.7 C 7431.05 5984.21 7459.32 5961.91 7425.1 5984.21 C 7408.73 5993.13 7399.8 6010.98 7386.41 6021.38 C 7373.02 6031.79 7367.07 6016.92 7362.6 6021.38 C 7343.26 6043.69 7341.77 6045.17 7329.87 6045.17 L 7331.36 6048.15 C 7356.65 6083.84 7350.7 6074.91 7347.73 6109.11 C 7347.73 6123.98 7378.97 6104.65 7377.48 6121.01 C 7376 6129.93 7365.58 6121.01 7364.09 6122.5 C 7355.17 6131.42 7370.04 6134.39 7370.04 6138.85 C 7370.04 6140.34 7356.65 6143.31 7364.09 6149.26 C 7381.95 6161.16 7405.75 6167.1 7426.58 6167.1 C 7431.05 6196.84 7393.85 6167.1 7392.36 6174.54 C 7390.88 6193.87 7377.48 6201.3 7396.83 6220.63 C 7398.31 6222.12 7398.31 6225.1 7396.83 6226.58 C 7390.88 6236.99 7368.56 6229.56 7381.95 6244.43 C 7396.83 6239.96 7408.73 6231.04 7425.1 6232.53 C 7425.1 6278.63 7398.31 6309.85 7402.78 6338.1 C 7408.73 6370.82 7417.66 6347.02 7438.49 6355.95 C 7451.88 6361.89 7454.85 6381.22 7468.25 6388.66 C 7472.71 6390.15 7487.59 6385.69 7483.13 6399.07 C 7474.2 6428.81 7437 6396.09 7429.56 6406.5 C 7429.56 6406.5 7496.52 6468.95 7478.66 6488.28 C 7513.64 6506.5 7496.1 6499.47 7550.63 6522.44 C 7569.16 6528.4 7551.87 6560.03 7568.26 6566.54 C 7594.22 6576.84 7585.73 6586.82 7603.45 6596.18 C 7619.99 6604.9 7586.21 6581.29 7596.56 6588.65 C 7613.68 6600.84 7622.04 6574.55 7619 6582.51 C 7640.91 6586.18 7688.39 6511.04 7686.47 6519.21 " }
                }
            }
            // PATH visit rs-km count: 77
            DemoShape {
                objectName: "rs-km"
                ShapePath {
                    objectName: "svg_path:rs-km"
                    // boundingRect: 7585.83, 6524.48 229.594x247.068
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7673.25 6767.22 C 7673.25 6767.22 7679.97 6731.22 7667.49 6711.54 C 7655 6691.86 7618.04 6686.58 7618.04 6686.58 L 7601.24 6653.93 L 7589.72 6642.41 C 7589.72 6642.41 7582.04 6612.65 7588.28 6613.61 C 7591.4 6614.09 7596.27 6613.15 7599.01 6609.48 C 7601.74 6605.81 7603.51 6599.41 7612.11 6593.65 C 7619.29 6588.84 7636.24 6580.56 7639.48 6577.69 C 7647.63 6570.47 7659.58 6559.6 7659.58 6559.6 C 7659.58 6559.6 7684.51 6528.38 7687.01 6525.43 C 7693.08 6518.26 7715.44 6553.98 7718.92 6555.67 C 7726.84 6559.51 7749.14 6604.1 7752.98 6605.06 C 7756.82 6606.02 7796.14 6627.05 7799.02 6628.01 C 7801.9 6628.97 7805.74 6637.61 7802.86 6640.49 C 7799.98 6643.37 7816.78 6658.25 7815.34 6661.61 C 7813.9 6664.97 7814.38 6676.01 7811.02 6678.41 C 7807.66 6680.81 7815.76 6695.1 7811.92 6696.06 C 7808.08 6697.02 7797.1 6688.5 7797.1 6688.5 L 7793.92 6681.24 C 7793.92 6681.24 7788.46 6675.05 7780.3 6680.33 C 7772.14 6685.62 7763.02 6700.5 7765.42 6703.86 C 7767.82 6707.22 7773.58 6710.1 7771.66 6712.5 C 7769.74 6714.9 7763.5 6703.38 7751.01 6702.42 C 7738.53 6701.46 7708.77 6715.38 7706.37 6718.74 C 7703.97 6722.1 7700.13 6724.98 7698.69 6726.9 C 7697.25 6728.82 7695.33 6748.5 7695.33 6752.34 C 7695.33 6756.18 7691.01 6771.54 7691.01 6771.54 L 7673.25 6767.22 " }
                }
            }
            // PATH visit mk count: 74
            DemoShape {
                objectName: "mk"
                ShapePath {
                    objectName: "svg_path:mk"
                    // boundingRect: 7665.12, 6644.19 351.987x307.82
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7669.54 6768.51 C 7668.11 6778.54 7666.68 6788.58 7668.11 6797.18 C 7668.11 6807.21 7676.71 6815.81 7676.71 6824.41 C 7675.28 6828.71 7663.81 6828.71 7665.24 6833 C 7666.68 6843.04 7681.01 6848.77 7682.44 6858.8 C 7683.88 6863.1 7675.28 6867.4 7675.28 6871.7 C 7675.28 6883.17 7712.54 6936.19 7718.27 6944.79 C 7726.87 6954.82 7732.6 6939.06 7736.9 6939.06 C 7742.64 6937.63 7749.8 6939.06 7754.1 6941.93 C 7756.97 6944.79 7752.67 6951.96 7755.53 6951.96 C 7765.57 6953.39 7861.59 6923.29 7867.32 6918.99 C 7883.09 6901.8 7871.62 6878.87 7900.28 6868.83 C 7910.32 6864.53 7966.21 6871.7 7974.81 6865.97 C 7979.11 6863.1 7977.68 6854.5 7981.97 6851.64 C 7984.84 6850.2 7989.14 6858.8 7992.01 6855.94 C 8009.71 6803.88 8022.37 6809.24 8014.94 6734.12 C 8004.91 6724.08 7989.14 6695.42 7976.24 6686.82 C 7969.08 6682.52 7959.04 6686.82 7950.44 6682.52 C 7947.58 6681.09 7908.88 6650.99 7908.88 6648.13 C 7890.25 6630.93 7844.39 6675.36 7821.46 6679.66 C 7794.23 6683.96 7776.33 6672.35 7763.43 6703.88 C 7761.99 6708.18 7774.17 6706.89 7772.73 6712.62 C 7769.87 6719.78 7756.97 6702.59 7749.8 6702.59 C 7731.17 6704.02 7713.97 6716.92 7698.21 6726.95 C 7689.61 6732.68 7709.67 6792.88 7673.84 6768.51 L 7669.54 6768.51 " }
                }
            }
            // PATH visit al count: 145
            DemoShape {
                objectName: "al"
                ShapePath {
                    objectName: "svg_path:al"
                    // boundingRect: 7484.67, 6639.48 287.237x551.811
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7755.54 6951.96 C 7755.54 6970.59 7775.6 6976.32 7771.3 6993.52 C 7756.97 7047.98 7748.37 7000.68 7738.34 7039.38 C 7738.34 7039.38 7729.74 7096.71 7729.74 7098.14 C 7726.88 7102.44 7682.45 7116.77 7681.01 7126.8 C 7681.01 7126.8 7699.64 7155.47 7699.64 7155.47 C 7703.94 7168.36 7683.88 7155.47 7683.88 7164.07 C 7685.31 7201.33 7669.55 7181.26 7645.18 7185.56 C 7643.75 7185.56 7646.62 7187 7645.18 7188.43 C 7643.75 7189.86 7643.75 7189.86 7642.32 7191.3 C 7640.89 7189.86 7640.89 7188.43 7639.45 7185.56 C 7639.45 7182.7 7639.45 7179.83 7639.45 7176.96 C 7639.45 7168.36 7643.75 7161.2 7640.89 7154.03 C 7638.02 7149.73 7629.42 7154.03 7626.55 7149.73 C 7619.39 7144 7620.82 7132.54 7615.09 7126.8 C 7605.06 7113.9 7513.33 7089.54 7523.37 7066.61 C 7527.67 7056.58 7547.73 7068.04 7552.03 7059.44 C 7553.46 7056.58 7524.8 7037.95 7520.5 7022.18 C 7519.07 7017.88 7526.23 7016.45 7526.23 7012.15 C 7527.67 7006.42 7526.23 6999.25 7527.67 6993.52 C 7527.67 6986.35 7523.37 6979.19 7527.67 6974.89 C 7530.53 6969.15 7542 6973.45 7546.3 6969.15 C 7549.16 6964.86 7546.3 6953.39 7542 6953.39 C 7536.26 6954.82 7540.56 6966.29 7536.26 6970.59 C 7527.67 6977.75 7536.26 6921.86 7537.7 6907.53 C 7540.56 6890.33 7516.2 6898.93 7516.2 6881.73 C 7516.2 6868.83 7514.77 6855.93 7521.93 6845.9 C 7526.23 6840.17 7539.13 6845.9 7544.86 6840.17 C 7547.73 6837.3 7537.7 6835.87 7536.26 6831.57 C 7534.83 6821.54 7544.86 6807.21 7537.7 6800.04 C 7529.1 6791.44 7514.77 6801.47 7503.3 6798.61 C 7503.3 6788.58 7503.3 6778.54 7503.3 6769.94 C 7503.3 6764.21 7506.17 6757.05 7503.3 6751.31 C 7499 6744.15 7486.1 6744.15 7484.67 6736.98 C 7484.67 6735.55 7530.53 6642.39 7534.83 6639.53 C 7536.26 6638.09 7543.43 6673.92 7554.9 6675.36 C 7554.9 6675.36 7584.99 6650.99 7584.99 6650.99 C 7607.92 6650.99 7603.62 6686.82 7616.52 6693.99 C 7620.82 6696.85 7625.12 6691.12 7630.85 6692.55 C 7640.89 6695.42 7650.92 6699.72 7658.08 6706.89 C 7685.31 6736.98 7665.25 6767.08 7668.12 6797.18 C 7668.12 6807.21 7676.71 6815.81 7676.71 6824.41 C 7675.28 6828.7 7663.82 6828.7 7665.25 6833 C 7666.68 6843.04 7681.01 6848.77 7682.45 6858.8 C 7683.88 6863.1 7675.28 6867.4 7675.28 6871.7 C 7675.28 6883.16 7712.54 6936.19 7718.28 6944.79 C 7726.88 6954.82 7732.61 6939.06 7736.91 6939.06 C 7742.64 6937.63 7749.81 6939.06 7754.11 6941.92 C 7756.97 6944.79 7752.67 6951.96 7755.54 6951.96 " }
                }
            }
            // PATH visit is count: 553
            DemoShape {
                objectName: "is"
                ShapePath {
                    objectName: "svg_path:is"
                    // boundingRect: 3559.94, 1656.42 811.066x675.17
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 3676.75 2152.28 C 3672.45 2150.85 3580.73 2106.42 3576.43 2103.56 C 3570.69 2099.26 3589.33 2093.53 3593.63 2087.79 C 3597.92 2080.63 3593.63 2059.13 3600.79 2062 C 3612.26 2066.3 3605.09 2084.93 3612.26 2093.53 C 3613.69 2096.39 3615.12 2086.36 3619.42 2086.36 C 3630.89 2084.93 3643.79 2094.96 3653.82 2090.66 C 3698.25 2073.46 3639.49 2057.7 3693.95 2053.4 C 3703.98 2053.4 3714.01 2060.56 3724.04 2062 C 3731.21 2063.43 3712.58 2051.96 3706.85 2049.1 C 3703.98 2049.1 3701.11 2049.1 3698.25 2049.1 C 3686.78 2047.66 3675.32 2050.53 3665.28 2046.23 C 3658.12 2041.93 3682.48 2049.1 3688.21 2043.36 C 3691.08 2040.5 3676.75 2039.06 3678.18 2034.77 C 3678.18 2027.6 3683.91 2021.87 3691.08 2019 C 3695.38 2017.57 3702.55 2021.87 3708.28 2021.87 C 3718.31 2020.43 3729.78 2019 3738.37 2011.83 C 3742.67 2008.97 3726.91 2010.4 3722.61 2007.54 C 3718.31 2006.1 3682.48 2023.3 3672.45 2021.87 C 3665.28 2020.43 3676.75 2006.1 3678.18 1998.94 C 3678.18 1990.34 3672.45 1983.17 3673.88 1974.57 C 3675.32 1965.97 3691.08 1960.24 3688.21 1950.21 C 3686.78 1944.48 3673.88 1953.08 3668.15 1950.21 C 3663.85 1948.78 3665.28 1937.31 3660.98 1940.18 C 3659.55 1941.61 3665.28 1948.78 3662.42 1947.34 C 3650.95 1941.61 3639.49 1922.98 3629.45 1915.81 C 3628.02 1912.95 3623.72 1914.38 3620.86 1914.38 C 3617.99 1914.38 3615.12 1918.68 3613.69 1917.25 C 3610.82 1915.81 3612.26 1908.65 3607.96 1907.21 C 3602.22 1904.35 3523.4 1904.35 3580.73 1877.12 C 3596.49 1869.95 3593.63 1884.28 3607.96 1892.88 C 3620.86 1900.05 3640.92 1881.42 3653.82 1888.58 C 3659.55 1891.45 3643.79 1902.91 3649.52 1907.21 C 3653.82 1911.51 3656.68 1898.61 3662.42 1897.18 C 3672.45 1894.32 3683.91 1888.58 3692.51 1894.32 C 3698.25 1900.05 3689.65 1911.51 3691.08 1918.68 C 3691.08 1922.98 3691.08 1911.51 3692.51 1910.08 C 3699.68 1901.48 3807.17 1971.71 3769.9 1910.08 C 3764.17 1901.48 3749.84 1917.25 3738.37 1915.81 C 3725.48 1914.38 3715.44 1898.61 3709.71 1887.15 C 3709.71 1887.15 3711.14 1885.72 3712.58 1884.28 C 3728.34 1872.82 3754.14 1869.95 3771.34 1868.52 C 3779.94 1868.52 3789.97 1877.12 3795.7 1869.95 C 3807.17 1859.92 3752.71 1864.22 3754.14 1848.45 C 3755.57 1838.42 3782.8 1842.72 3782.8 1831.26 C 3781.37 1763.9 3732.64 1838.42 3729.78 1825.52 C 3728.34 1816.92 3735.51 1808.33 3732.64 1801.16 C 3731.21 1798.29 3726.91 1806.89 3724.04 1806.89 C 3721.18 1806.89 3726.91 1799.73 3724.04 1799.73 C 3714.01 1802.59 3714.01 1819.79 3706.85 1801.16 C 3705.41 1799.73 3708.28 1793.99 3706.85 1793.99 C 3701.11 1798.29 3701.11 1808.33 3693.95 1809.76 C 3689.65 1809.76 3691.08 1799.73 3686.78 1798.29 C 3678.18 1795.43 3638.05 1815.49 3636.62 1792.56 C 3636.62 1788.26 3643.79 1788.26 3643.79 1783.96 C 3639.49 1771.06 3605.09 1772.5 3607.96 1758.16 C 3619.42 1697.97 3653.82 1783.96 3660.98 1779.66 C 3681.05 1766.76 3638.05 1725.2 3666.72 1725.2 C 3692.51 1723.77 3675.32 1821.22 3708.28 1776.8 C 3712.58 1771.06 3691.08 1763.9 3696.81 1759.6 C 3702.55 1752.43 3718.31 1768.2 3725.48 1761.03 C 3729.78 1753.86 3706.85 1761.03 3701.11 1755.3 C 3692.51 1746.7 3689.65 1733.8 3688.21 1722.34 C 3682.48 1673.61 3715.44 1766.76 3728.34 1752.43 C 3732.64 1748.13 3683.91 1709.44 3705.41 1699.4 C 3715.44 1695.11 3722.61 1722.34 3732.64 1718.04 C 3738.37 1713.74 3705.41 1667.87 3746.97 1682.21 C 3781.37 1695.11 3742.67 1755.3 3781.37 1779.66 C 3781.37 1781.1 3805.73 1769.63 3807.17 1740.97 C 3807.17 1735.23 3798.57 1738.1 3795.7 1733.8 C 3791.4 1729.5 3775.64 1702.27 3781.37 1693.67 C 3791.4 1682.21 3811.47 1703.7 3825.8 1710.87 C 3830.1 1712.3 3812.9 1708 3812.9 1703.7 C 3811.47 1699.4 3820.07 1700.84 3822.93 1699.4 C 3824.36 1697.97 3824.36 1695.11 3822.93 1695.11 C 3804.3 1696.54 3805.73 1725.2 3784.24 1677.91 C 3765.61 1636.35 3805.73 1667.87 3807.17 1667.87 C 3807.17 1667.87 3808.6 1666.44 3808.6 1665.01 C 3808.6 1662.14 3805.73 1656.41 3808.6 1657.84 C 3812.9 1662.14 3812.9 1670.74 3818.63 1675.04 C 3824.36 1679.34 3834.4 1677.91 3840.13 1682.21 C 3854.46 1693.67 3832.96 1708 3834.4 1715.17 C 3834.4 1718.04 3841.56 1715.17 3844.43 1716.6 C 3845.86 1718.04 3855.89 1726.63 3853.03 1732.37 C 3850.16 1733.8 3843 1732.37 3844.43 1735.23 C 3847.3 1740.97 3858.76 1739.53 3858.76 1746.7 C 3860.19 1756.73 3845.86 1766.76 3848.73 1776.8 C 3851.59 1785.39 3873.09 1779.66 3871.66 1788.26 C 3871.66 1796.86 3850.16 1782.53 3847.3 1789.69 C 3845.86 1796.86 3911.79 1825.52 3845.86 1835.56 C 3834.4 1838.42 3830.1 1818.36 3818.63 1814.06 C 3814.33 1812.62 3820.07 1822.66 3822.93 1826.96 C 3825.8 1838.42 3838.7 1848.45 3835.83 1858.49 C 3832.96 1869.95 3811.47 1869.95 3810.03 1881.42 C 3807.17 1888.58 3827.23 1884.28 3828.66 1891.45 C 3831.53 1898.61 3820.07 1905.78 3817.2 1912.95 C 3814.33 1921.55 3804.3 1938.74 3812.9 1940.18 C 3843 1945.91 3841.56 1885.72 3860.19 1875.68 C 3918.95 1844.15 3878.83 1884.28 3877.39 1890.02 C 3868.79 1925.84 3911.79 1887.15 3914.65 1884.28 C 3933.29 1864.22 3926.12 1806.89 3940.45 1808.33 C 3990.61 1812.62 3946.18 1875.68 3974.85 1898.61 C 3997.78 1918.68 3984.88 1872.82 3990.61 1861.35 C 3992.05 1854.19 3997.78 1845.59 4004.94 1842.72 C 4009.24 1841.29 4014.98 1844.15 4020.71 1847.02 C 4022.14 1848.45 4022.14 1852.75 4023.57 1852.75 C 4035.04 1849.89 4046.51 1834.12 4056.54 1839.85 C 4066.57 1844.15 4065.14 1859.92 4066.57 1871.38 C 4066.57 1878.55 4057.97 1882.85 4059.4 1890.02 C 4066.57 1925.84 4083.77 1864.22 4073.74 1917.25 C 4069.44 1947.34 4059.4 1931.58 4066.57 1958.81 C 4078.04 2007.54 4078.04 1865.65 4092.37 1862.79 C 4129.63 1852.75 4121.03 1914.38 4123.9 1928.71 C 4123.9 1931.58 4123.9 1921.55 4126.76 1920.11 C 4128.2 1918.68 4133.93 1920.11 4132.5 1918.68 C 4123.9 1900.05 4135.36 1927.28 4135.36 1927.28 C 4136.79 1927.28 4136.79 1922.98 4138.23 1921.55 C 4145.39 1910.08 4159.73 1890.02 4175.49 1888.58 C 4191.26 1887.15 4189.82 1920.11 4202.72 1928.71 C 4208.45 1931.58 4199.85 1915.81 4204.15 1911.51 C 4212.75 1901.48 4218.49 1924.41 4218.49 1924.41 C 4219.92 1927.28 4217.05 1917.25 4218.49 1914.38 C 4221.35 1910.08 4228.52 1907.21 4229.95 1901.48 C 4232.82 1895.75 4229.95 1888.58 4229.95 1881.42 C 4231.38 1872.82 4229.95 1861.35 4237.12 1857.05 C 4247.15 1852.75 4257.18 1859.92 4267.21 1862.79 C 4293.01 1868.52 4271.51 1879.98 4274.38 1890.02 C 4277.25 1895.75 4285.84 1894.32 4288.71 1898.61 C 4298.74 1920.11 4245.72 1925.84 4293.01 1951.64 C 4298.74 1954.51 4298.74 1938.74 4304.48 1935.88 C 4310.21 1933.01 4317.37 1938.74 4323.11 1935.88 C 4336.01 1931.58 4350.34 1900.05 4368.97 1934.44 C 4371.83 1940.18 4356.07 1937.31 4348.9 1938.74 C 4327.41 1943.04 4318.81 1940.18 4304.48 1963.11 C 4303.04 1965.97 4311.64 1965.97 4311.64 1968.84 C 4313.07 1973.14 4304.48 1976.01 4307.34 1977.44 C 4314.51 1983.17 4327.41 1978.87 4334.57 1984.6 C 4357.5 2001.8 4303.04 2033.33 4300.18 2036.2 C 4297.31 2037.63 4305.91 2031.9 4310.21 2033.33 C 4320.24 2036.2 4330.27 2043.36 4338.87 2050.53 C 4340.3 2051.96 4331.71 2051.96 4331.71 2054.83 C 4331.71 2059.13 4338.87 2063.43 4338.87 2067.73 C 4338.87 2070.59 4333.14 2066.3 4331.71 2067.73 C 4321.67 2073.46 4294.44 2084.93 4304.48 2089.23 C 4317.37 2093.53 4328.84 2062 4338.87 2070.59 C 4343.17 2076.33 4347.47 2082.06 4353.2 2086.36 C 4356.07 2089.23 4361.8 2083.49 4363.24 2087.79 C 4370.4 2100.69 4377.57 2125.05 4360.37 2136.52 C 4351.77 2142.25 4338.87 2140.82 4330.27 2145.12 C 4325.97 2147.99 4320.24 2153.72 4323.11 2156.58 C 4327.41 2160.88 4401.93 2169.48 4343.17 2203.88 C 4330.27 2211.04 4297.31 2180.95 4297.31 2179.52 C 4287.28 2166.62 4343.17 2202.45 4328.84 2215.34 C 4321.67 2221.08 4310.21 2201.01 4303.04 2206.75 C 4297.31 2211.04 4317.37 2215.34 4320.24 2222.51 C 4321.67 2225.38 4314.51 2228.24 4311.64 2229.68 C 4298.74 2235.41 4281.54 2251.17 4271.51 2241.14 C 4264.35 2233.98 4265.78 2205.31 4258.61 2212.48 C 4251.45 2221.08 4274.38 2233.98 4268.65 2244.01 C 4264.35 2252.61 4245.72 2242.57 4238.55 2249.74 C 4229.95 2256.91 4235.68 2274.1 4228.52 2282.7 C 4225.65 2287 4217.05 2278.4 4212.75 2279.84 C 4202.72 2282.7 4196.99 2295.6 4186.96 2297.03 C 4178.36 2298.47 4182.66 2261.21 4159.73 2255.47 C 4152.56 2254.04 4161.16 2271.24 4156.86 2278.4 C 4155.43 2281.27 4149.69 2275.54 4146.83 2278.4 C 4145.39 2278.4 4152.56 2282.7 4151.13 2282.7 C 4112.43 2289.87 4133.93 2279.84 4098.1 2285.57 C 4079.47 2288.44 4063.7 2304.2 4045.07 2311.37 C 4042.21 2312.8 4036.47 2314.23 4033.61 2312.8 C 4023.57 2308.5 4020.71 2292.74 4010.68 2292.74 C 4002.08 2294.17 4004.94 2312.8 3997.78 2315.67 C 3992.05 2317.1 3990.61 2305.63 3984.88 2302.77 C 3976.28 2299.9 3944.75 2298.47 3933.29 2294.17 C 3913.22 2288.44 3911.79 2322.83 3907.49 2327.13 C 3897.46 2335.73 3844.43 2330 3834.4 2325.7 C 3808.6 2317.1 3787.1 2275.54 3774.2 2262.64 C 3755.57 2246.87 3739.81 2259.77 3729.78 2231.11 C 3728.34 2223.94 3721.18 2215.34 3724.04 2208.18 C 3726.91 2198.15 3754.14 2193.85 3745.54 2189.55 C 3736.94 2185.25 3729.78 2212.48 3722.61 2206.75 C 3714.01 2199.58 3732.64 2183.81 3726.91 2173.78 C 3724.04 2168.05 3716.88 2186.68 3711.14 2183.81 C 3701.11 2178.08 3701.11 2163.75 3692.51 2156.58 C 3688.21 2152.29 3682.48 2153.72 3676.75 2152.28 " }
                }
            }
            // PATH visit by count: 321
            DemoShape {
                objectName: "by"
                ShapePath {
                    objectName: "svg_path:by"
                    // boundingRect: 7670.98, 3935.51 1022.16x977.052
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7768.44 4911.13 C 7785.63 4906.83 7751.24 4893.93 7774.17 4886.77 C 7781.34 4883.9 7791.37 4883.9 7799.97 4885.33 C 7802.83 4885.33 7802.83 4892.5 7807.13 4893.93 C 7821.46 4898.23 7841.53 4830.87 7847.26 4826.57 C 7858.73 4820.84 7873.06 4823.71 7884.52 4819.41 C 7901.72 4812.24 7914.62 4797.91 7933.25 4792.18 C 7940.42 4790.74 7947.58 4793.61 7954.75 4793.61 C 7961.91 4793.61 7969.08 4793.61 7976.25 4793.61 C 7997.74 4790.74 8017.81 4777.84 8037.87 4779.28 C 8042.17 4779.28 8043.6 4785.01 8047.9 4786.44 C 8083.73 4790.74 8128.16 4786.44 8161.12 4777.84 C 8176.89 4773.55 8165.42 4787.88 8174.02 4795.04 C 8176.89 4796.48 8182.62 4789.31 8185.49 4792.18 C 8188.35 4795.04 8179.76 4803.64 8184.05 4805.07 C 8219.88 4819.41 8194.09 4796.48 8211.29 4792.18 C 8268.61 4776.41 8217.02 4800.78 8235.65 4810.81 C 8238.52 4813.67 8242.81 4817.97 8244.25 4815.11 C 8251.41 4810.81 8244.25 4785.01 8251.41 4785.01 C 8258.58 4783.58 8271.48 4796.48 8280.08 4786.44 C 8285.81 4780.71 8285.81 4759.21 8294.41 4763.51 C 8307.31 4772.11 8275.78 4785.01 8311.61 4785.01 C 8324.51 4785.01 8317.34 4756.35 8337.4 4770.68 C 8374.67 4796.48 8330.24 4787.88 8360.33 4795.04 C 8368.93 4796.48 8357.47 4774.98 8363.2 4767.81 C 8371.8 4756.35 8384.7 4736.28 8396.16 4742.02 C 8407.63 4747.75 8419.09 4787.88 8430.56 4785.01 C 8450.62 4779.28 8437.73 4754.91 8460.66 4749.18 C 8469.25 4747.75 8476.42 4757.78 8483.59 4756.35 C 8530.88 4747.75 8452.06 4731.98 8517.98 4736.28 C 8550.95 4739.15 8533.75 4774.98 8571.01 4766.38 C 8606.84 4759.21 8549.51 4720.52 8549.51 4704.75 C 8549.51 4693.29 8552.38 4666.06 8553.81 4656.03 C 8560.98 4615.9 8571.01 4601.57 8576.74 4600.13 C 8586.77 4597.27 8598.24 4601.57 8606.84 4597.27 C 8612.57 4594.4 8609.71 4584.37 8615.44 4581.5 C 8628.34 4572.9 8646.97 4574.34 8662.73 4570.04 C 8658.43 4567.17 8661.3 4561.44 8658.43 4557.14 C 8658.43 4557.14 8628.34 4538.51 8628.34 4537.07 C 8626.9 4534.21 8632.64 4529.91 8631.2 4527.04 C 8626.9 4517.01 8616.87 4511.28 8615.44 4502.68 C 8614 4498.38 8622.6 4496.94 8622.6 4492.64 C 8619.74 4482.61 8599.67 4482.61 8598.24 4471.15 C 8596.81 4466.85 8605.41 4465.41 8606.84 4461.11 C 8611.14 4443.92 8559.54 4433.88 8555.24 4422.42 C 8549.51 4410.95 8559.54 4396.62 8558.11 4383.72 C 8558.11 4360.79 8626.9 4390.89 8645.53 4379.42 C 8658.43 4372.26 8672.76 4345.03 8671.33 4330.7 C 8671.33 4329.26 8665.6 4330.7 8667.03 4329.26 C 8674.2 4322.1 8687.1 4319.23 8691.4 4310.63 C 8695.7 4304.9 8691.4 4292 8685.66 4289.13 C 8661.3 4280.54 8658.43 4290.57 8645.53 4276.24 C 8641.23 4270.5 8655.57 4250.44 8639.8 4251.87 C 8622.6 4253.31 8614 4247.57 8589.64 4254.74 C 8581.04 4257.61 8572.44 4266.2 8563.84 4263.34 C 8556.68 4260.47 8569.58 4220.34 8556.68 4211.74 C 8552.38 4208.88 8507.95 4208.88 8493.62 4198.85 C 8470.69 4184.51 8485.02 4170.18 8452.06 4160.15 C 8446.32 4157.28 8460.66 4132.92 8454.92 4131.49 C 8434.86 4131.49 8427.69 4130.05 8404.76 4114.29 C 8394.73 4108.56 8413.36 4078.46 8410.5 4072.73 C 8401.9 4059.83 8421.96 4069.86 8416.23 4061.26 C 8411.93 4054.1 8377.53 4026.87 8378.97 4019.7 C 8384.7 3999.64 8387.56 3985.3 8376.1 3965.24 C 8373.23 3959.51 8364.63 3970.97 8358.9 3970.97 C 8357.47 3970.97 8311.61 3942.31 8311.61 3942.31 C 8275.78 3927.98 8301.57 3939.44 8281.51 3948.04 C 8278.64 3949.47 8261.45 3946.61 8257.15 3950.91 C 8249.98 3960.94 8238.52 3988.17 8227.05 3993.9 C 8204.12 4005.37 8205.55 3946.61 8205.55 3946.61 C 8161.12 3936.58 8169.72 3942.31 8139.63 3965.24 C 8132.46 3970.97 8126.73 3950.91 8119.56 3945.18 C 8095.2 3927.98 8102.36 3975.27 8066.54 3946.61 C 8066.54 3948.04 8039.31 3969.54 8036.44 3978.14 C 8033.57 3982.44 8026.41 4025.43 8026.41 4025.43 C 8019.24 4031.17 8007.78 4022.57 7999.18 4025.43 C 7996.31 4026.87 7999.18 4036.9 7994.88 4036.9 C 7989.14 4036.9 7984.84 4028.3 7977.68 4028.3 C 7959.05 4026.87 7956.18 4068.43 7931.82 4074.16 L 7931.82 4075.59 C 7940.42 4097.09 7930.38 4115.72 7928.95 4137.22 C 7927.52 4150.12 7974.81 4124.32 7969.08 4144.39 C 7967.65 4148.68 7960.48 4148.68 7957.61 4152.98 C 7956.18 4158.72 7961.91 4167.32 7957.61 4173.05 C 7949.02 4183.08 7927.52 4168.75 7920.35 4178.78 C 7914.62 4188.81 7921.79 4203.15 7914.62 4211.74 C 7887.39 4254.74 7900.29 4198.85 7883.09 4251.87 C 7883.09 4254.74 7877.36 4254.74 7877.36 4256.17 C 7877.36 4256.17 7890.26 4296.3 7890.26 4296.3 C 7890.26 4297.73 7875.92 4337.86 7877.36 4343.6 C 7877.36 4349.33 7921.79 4340.73 7908.89 4372.26 C 7906.02 4379.42 7877.36 4389.46 7878.79 4376.56 C 7878.79 4372.26 7885.96 4369.39 7884.52 4365.09 C 7881.66 4346.46 7848.69 4362.23 7844.39 4367.96 C 7828.63 4383.72 7860.16 4382.29 7837.23 4395.19 C 7827.2 4399.49 7812.86 4396.62 7805.7 4405.22 C 7799.97 4410.95 7820.03 4426.72 7812.86 4429.59 C 7805.7 4431.02 7797.1 4426.72 7789.93 4431.02 C 7781.34 4436.75 7779.9 4451.08 7771.3 4456.82 C 7758.4 4468.28 7752.67 4442.48 7741.21 4446.78 C 7729.74 4452.52 7688.18 4475.45 7670.98 4463.98 C 7696.78 4537.07 7759.84 4604.43 7764.14 4683.26 C 7764.14 4686.12 7761.27 4688.99 7759.84 4690.42 C 7749.81 4700.45 7659.52 4776.41 7701.08 4792.18 C 7703.94 4793.61 7706.81 4786.44 7709.68 4787.88 C 7722.58 4789.31 7736.91 4793.61 7748.37 4802.21 C 7777.04 4825.14 7746.94 4873.87 7758.4 4899.66 C 7759.84 4903.96 7764.14 4908.26 7767 4912.56 L 7768.44 4911.13 " }
                }
            }
            // PATH visit no count: 1982
            DemoShape {
                objectName: "no"
                ShapePath {
                    objectName: "svg_path:no"
                    // boundingRect: 5717.75, 1239.32 1829.56x2604.54
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6918.57 1718.04 C 6920 1718.04 6920 1718.04 6920 1719.47 M 7152.18 1963.11 L 7150.74 1963.11 M 7529.1 1421.37 C 7537.7 1432.84 7557.76 1460.07 7540.56 1465.8 C 7523.37 1471.53 7478.94 1448.6 7493.27 1461.5 C 7520.5 1484.43 7466.04 1517.39 7458.87 1534.59 C 7458.87 1536.02 7476.07 1597.65 7456.01 1590.48 C 7401.55 1568.99 7466.04 1533.16 7447.41 1501.63 C 7418.74 1451.47 7374.32 1470.1 7337.05 1429.97 L 7335.62 1422.8 C 7334.19 1422.8 7332.75 1422.8 7331.32 1424.24 C 7331.32 1422.8 7329.89 1422.8 7329.89 1421.37 L 7329.89 1424.24 C 7301.22 1429.97 7306.96 1462.93 7282.59 1470.1 C 7261.1 1475.83 7269.7 1445.73 7245.33 1472.96 C 7242.47 1477.26 7245.33 1484.43 7243.9 1490.16 C 7242.47 1491.6 7226.7 1521.69 7226.7 1523.13 C 7222.4 1534.59 7231 1571.85 7232.43 1581.89 C 7232.43 1586.18 7229.57 1589.05 7229.57 1593.35 C 7229.57 1601.95 7231 1609.12 7232.43 1617.71 C 7236.73 1629.18 7246.76 1637.78 7248.2 1649.24 C 7255.36 1699.4 7242.47 1665.01 7225.27 1680.77 C 7205.2 1700.84 7223.83 1706.57 7218.1 1730.93 C 7216.67 1736.67 7210.94 1739.53 7209.5 1745.27 C 7209.5 1746.7 7190.87 1729.5 7188 1728.07 C 7183.71 1725.2 7130.68 1706.57 7126.38 1712.3 C 7120.65 1718.04 7124.95 1729.5 7120.65 1735.23 C 7103.45 1765.33 7080.52 1746.7 7056.15 1751 C 7048.99 1751 7038.96 1758.16 7033.22 1753.86 C 7026.06 1748.13 7028.92 1736.67 7024.62 1729.5 C 7014.59 1712.3 6981.63 1667.87 6964.43 1657.84 C 6907.1 1624.88 6932.9 1710.87 6932.9 1710.87 C 6924.3 1712.3 6917.14 1702.27 6908.54 1702.27 C 6904.24 1702.27 6897.07 1706.57 6898.51 1709.44 C 6899.94 1710.87 6901.37 1712.3 6902.8 1712.3 L 6899.94 1712.3 C 6888.47 1715.17 6872.71 1708 6866.98 1718.04 C 6862.68 1725.2 6881.31 1729.5 6885.61 1736.67 C 6889.91 1745.27 6892.77 1755.3 6892.77 1765.33 C 6892.77 1782.53 6868.41 1795.43 6872.71 1812.62 C 6874.14 1825.52 6924.3 1822.66 6877.01 1852.75 C 6864.11 1861.35 6765.22 1812.62 6745.16 1838.42 C 6736.56 1849.89 6772.39 1931.58 6743.72 1943.04 L 6697.86 1922.98 C 6689.26 1922.98 6662.03 1973.14 6660.6 1984.6 C 6657.73 2000.37 6657.73 2020.43 6646.27 2034.77 C 6637.67 2044.8 6621.9 2029.03 6626.2 2054.83 C 6631.94 2086.36 6669.2 2089.23 6653.43 2127.92 C 6644.83 2152.28 6597.54 2208.18 6588.94 2233.98 C 6586.08 2246.87 6604.71 2258.34 6600.41 2271.24 L 6568.88 2298.47 C 6557.41 2304.2 6534.48 2291.3 6528.75 2304.2 L 6543.08 2360.09 C 6543.08 2360.09 6535.91 2403.09 6535.91 2404.52 L 6540.21 2457.55 C 6538.78 2463.28 6531.61 2464.72 6530.18 2470.45 C 6517.28 2509.14 6497.22 2549.27 6484.32 2589.4 C 6475.72 2615.2 6535.91 2600.87 6525.88 2671.09 C 6515.85 2738.45 6477.15 2671.09 6418.39 2708.35 C 6399.76 2719.82 6368.23 2768.55 6363.93 2791.48 C 6362.5 2798.64 6371.1 2804.38 6369.67 2810.11 C 6368.23 2825.87 6348.17 2835.91 6348.17 2851.67 C 6348.17 3025.08 6369.67 2724.12 6369.67 2897.53 C 6369.67 2906.13 6359.64 2911.86 6359.64 2920.46 C 6358.2 2930.49 6363.93 2939.09 6365.37 2949.13 C 6365.37 2957.72 6358.2 2967.76 6359.64 2976.36 C 6361.07 2997.85 6384 3016.48 6386.87 3037.98 C 6389.73 3069.51 6366.8 3109.64 6373.97 3139.74 C 6382.57 3172.7 6437.03 3169.83 6442.76 3205.66 L 6426.99 3262.99 C 6415.53 3273.02 6386.87 3265.85 6388.3 3280.19 C 6395.46 3341.81 6432.73 3326.05 6416.96 3407.74 L 6418.39 3449.3 C 6405.5 3482.26 6359.64 3485.13 6356.77 3495.16 C 6355.34 3498.03 6362.5 3499.46 6362.5 3503.76 C 6365.37 3509.49 6368.23 3516.66 6365.37 3522.39 C 6361.07 3530.99 6346.74 3532.42 6343.87 3542.46 C 6335.27 3568.25 6375.4 3625.58 6343.87 3670.01 C 6330.97 3688.64 6325.24 3674.31 6320.94 3659.98 C 6322.37 3659.98 6322.37 3659.98 6323.81 3658.54 C 6329.54 3654.24 6320.94 3642.78 6316.64 3637.04 C 6286.54 3589.75 6302.31 3659.98 6255.01 3615.55 C 6250.71 3611.25 6259.31 3602.65 6259.31 3596.92 C 6259.31 3588.32 6250.71 3596.92 6250.71 3596.92 C 6242.12 3584.02 6244.98 3562.52 6247.85 3565.39 C 6247.85 3562.52 6246.41 3561.09 6246.41 3559.65 C 6243.55 3545.32 6239.25 3532.42 6236.38 3518.09 C 6234.95 3509.49 6247.85 3490.86 6237.82 3490.86 C 6201.99 3490.86 6263.61 3535.29 6227.78 3559.65 C 6226.35 3559.65 6224.92 3558.22 6224.92 3556.79 C 6223.48 3548.19 6227.78 3538.16 6224.92 3530.99 C 6220.62 3523.82 6206.29 3510.93 6204.85 3518.09 C 6203.42 3529.56 6217.75 3536.72 6222.05 3546.76 C 6224.92 3552.49 6216.32 3565.39 6219.18 3572.55 C 6230.65 3602.65 6239.25 3586.88 6230.65 3606.95 C 6230.65 3608.38 6230.65 3612.68 6227.78 3612.68 C 6224.92 3612.68 6222.05 3604.08 6219.18 3606.95 C 6209.15 3625.58 6222.05 3649.94 6210.59 3649.94 C 6204.85 3649.94 6212.02 3631.31 6207.72 3634.18 C 6183.36 3649.94 6229.22 3665.71 6169.02 3665.71 C 6161.86 3665.71 6169.02 3651.38 6163.29 3647.08 C 6156.13 3642.78 6143.23 3627.01 6138.93 3634.18 C 6134.63 3644.21 6153.26 3649.94 6157.56 3659.98 C 6158.99 3664.27 6120.3 3667.14 6116 3681.47 C 6114.56 3687.21 6130.33 3692.94 6126.03 3697.24 C 6118.86 3705.84 6100.23 3698.67 6093.07 3705.84 C 6088.77 3711.57 6107.4 3713 6105.96 3718.73 C 6097.37 3777.49 6085.9 3701.54 6078.73 3731.63 C 6077.3 3734.5 6083.03 3737.37 6081.6 3740.23 C 6074.43 3750.26 6037.17 3794.69 6035.74 3796.13 C 6032.87 3798.99 6028.57 3790.39 6025.71 3793.26 C 6017.11 3800.43 6018.54 3819.06 6007.08 3820.49 C 5998.48 3823.36 5997.04 3798.99 5987.01 3801.86 C 5976.98 3804.72 5981.28 3823.36 5974.11 3829.09 C 5968.38 3833.39 5958.35 3826.22 5952.62 3829.09 C 5948.32 3830.52 5946.88 3836.25 5942.58 3837.69 C 5928.25 3846.29 5932.55 3833.39 5912.49 3833.39 C 5902.46 3833.39 5890.99 3849.15 5885.26 3841.99 C 5879.52 3834.82 5903.89 3829.09 5901.02 3820.49 C 5896.72 3813.32 5888.12 3831.96 5879.52 3831.96 C 5868.06 3833.39 5856.59 3829.09 5845.13 3824.79 C 5820.76 3813.32 5868.06 3797.56 5872.36 3787.53 C 5873.79 3781.79 5863.76 3776.06 5858.03 3777.49 C 5852.29 3778.93 5853.73 3791.83 5846.56 3793.26 C 5837.96 3794.69 5829.36 3788.96 5820.76 3784.66 C 5803.57 3777.49 5793.53 3751.7 5784.94 3745.97 C 5780.64 3741.67 5772.04 3744.53 5766.3 3741.67 C 5756.27 3735.93 5739.07 3698.67 5740.51 3688.64 C 5740.51 3680.04 5750.54 3674.31 5753.41 3664.27 C 5754.84 3655.68 5743.37 3634.18 5753.41 3637.04 C 5764.87 3639.91 5756.27 3664.27 5767.74 3668.57 C 5773.47 3672.87 5774.9 3654.24 5782.07 3651.38 C 5784.94 3648.51 5787.8 3651.38 5790.67 3654.24 C 5787.8 3647.08 5786.37 3639.91 5783.5 3632.75 C 5782.07 3622.71 5803.57 3625.58 5809.3 3618.41 C 5812.17 3615.55 5796.4 3618.41 5797.83 3614.11 C 5800.7 3606.95 5807.87 3602.65 5815.03 3599.78 C 5823.63 3594.05 5840.83 3598.35 5845.13 3588.32 C 5850.86 3575.42 5810.73 3594.05 5802.13 3585.45 C 5796.4 3592.62 5793.53 3592.62 5793.53 3579.72 C 5794.97 3568.25 5819.33 3565.39 5816.47 3555.35 C 5812.17 3543.89 5794.97 3541.02 5783.5 3543.89 C 5764.87 3549.62 5772.04 3594.05 5753.41 3592.62 C 5743.37 3592.62 5750.54 3573.99 5746.24 3566.82 C 5743.37 3562.52 5737.64 3559.65 5731.91 3556.79 C 5731.91 3556.79 5731.91 3558.22 5733.34 3558.22 C 5731.91 3558.22 5731.91 3558.22 5730.48 3559.65 C 5730.48 3558.22 5731.91 3556.79 5731.91 3556.79 C 5727.61 3553.92 5723.31 3551.05 5723.31 3546.76 C 5723.31 3539.59 5740.51 3552.49 5746.24 3548.19 C 5754.84 3541.02 5751.97 3522.39 5762 3518.09 C 5769.17 3513.79 5773.47 3529.56 5780.64 3530.99 C 5783.5 3532.42 5779.2 3523.82 5782.07 3522.39 C 5784.94 3519.53 5789.24 3523.82 5792.1 3522.39 C 5797.83 3520.96 5777.77 3520.96 5779.2 3515.23 C 5779.2 3513.79 5837.96 3488 5833.66 3488 C 5787.8 3485.13 5816.47 3523.82 5772.04 3483.7 C 5770.6 3482.26 5779.2 3483.7 5780.64 3480.83 C 5783.5 3477.96 5780.64 3470.8 5784.94 3469.36 C 5790.67 3465.06 5797.83 3470.8 5803.57 3466.5 C 5806.43 3465.06 5802.13 3460.77 5802.13 3457.9 C 5805 3452.17 5807.87 3447.87 5810.73 3445 C 5817.9 3440.7 5833.66 3445 5835.1 3437.83 C 5836.53 3429.24 5816.47 3430.67 5816.47 3423.5 C 5815.03 3420.64 5817.9 3416.34 5820.76 3412.04 C 5817.9 3412.04 5813.6 3404.87 5810.73 3407.74 C 5803.57 3412.04 5799.27 3419.2 5794.97 3424.94 C 5789.24 3436.4 5792.1 3450.73 5783.5 3459.33 C 5779.2 3463.63 5780.64 3447.87 5779.2 3443.57 C 5770.6 3427.8 5763.44 3432.1 5769.17 3417.77 C 5774.9 3406.3 5797.83 3380.51 5784.94 3383.37 C 5770.6 3387.67 5760.57 3450.73 5743.37 3419.2 C 5739.07 3409.17 5734.77 3397.71 5731.91 3386.24 C 5730.48 3374.78 5751.97 3386.24 5777.77 3377.64 C 5783.5 3376.21 5786.37 3370.48 5787.8 3363.31 C 5777.77 3373.34 5759.14 3351.84 5759.14 3346.11 C 5759.14 3333.21 5779.2 3330.35 5790.67 3324.61 C 5787.8 3308.85 5774.9 3323.18 5763.44 3336.08 C 5763.44 3336.08 5762 3336.08 5762 3334.65 C 5760.57 3333.21 5759.14 3330.35 5756.27 3327.48 C 5760.57 3331.78 5762 3337.51 5763.44 3336.08 C 5756.27 3343.25 5750.54 3348.98 5746.24 3350.41 C 5739.07 3350.41 5741.94 3336.08 5739.07 3330.35 C 5737.64 3327.48 5711.84 3301.68 5719.01 3300.25 C 5729.04 3300.25 5737.64 3308.85 5746.24 3316.02 C 5746.24 3314.58 5744.81 3311.72 5746.24 3308.85 C 5749.11 3298.82 5766.3 3298.82 5774.9 3291.65 C 5776.34 3290.22 5773.47 3284.49 5770.6 3285.92 C 5759.14 3287.35 5740.51 3301.68 5730.48 3295.95 C 5717.58 3288.79 5727.61 3255.82 5734.77 3251.52 C 5744.81 3244.36 5756.27 3265.85 5769.17 3265.85 C 5770.6 3267.29 5799.27 3232.89 5830.8 3248.66 C 5840.83 3252.96 5842.26 3267.29 5852.29 3271.59 C 5862.33 3275.89 5843.7 3250.09 5876.66 3241.49 C 5918.22 3230.03 5875.22 3303.12 5919.65 3300.25 C 5946.88 3297.38 5909.62 3274.45 5911.05 3255.82 C 5912.49 3235.76 5985.58 3283.05 5975.55 3232.89 C 5974.11 3222.86 5955.48 3241.49 5946.88 3238.62 C 5941.15 3237.19 5939.72 3228.59 5939.72 3222.86 C 5939.72 3207.09 5979.85 3191.33 5965.51 3185.6 C 5929.69 3171.27 5941.15 3237.19 5938.28 3244.36 C 5938.28 3245.79 5921.09 3250.09 5906.75 3251.52 C 5903.89 3252.96 5905.32 3247.22 5903.89 3245.79 C 5893.86 3240.06 5882.39 3237.19 5872.36 3231.46 L 5870.93 3230.03 C 5866.63 3240.06 5862.33 3247.22 5859.46 3250.09 C 5858.03 3251.52 5813.6 3231.46 5802.13 3231.46 C 5797.83 3230.03 5800.7 3238.62 5797.83 3240.06 C 5782.07 3247.22 5763.44 3250.09 5747.67 3245.79 C 5744.81 3245.79 5723.31 3221.43 5726.18 3217.13 C 5733.34 3207.09 5746.24 3202.8 5756.27 3199.93 C 5767.74 3197.06 5789.23 3209.96 5789.23 3198.5 C 5790.67 3188.46 5767.74 3195.63 5756.27 3197.06 C 5749.11 3197.06 5743.37 3207.09 5736.21 3204.23 C 5706.11 3192.76 5741.94 3177 5750.54 3177 C 5764.87 3178.43 5789.23 3195.63 5806.43 3184.16 C 5823.63 3171.27 5756.27 3188.46 5747.67 3168.4 C 5744.81 3159.8 5780.64 3161.23 5773.47 3156.93 C 5764.87 3152.63 5751.97 3158.37 5744.81 3151.2 C 5721.88 3132.57 5756.27 3095.31 5777.77 3093.87 C 5793.53 3093.87 5813.6 3096.74 5822.2 3109.64 C 5826.5 3115.37 5813.6 3125.4 5817.9 3131.14 C 5822.2 3136.87 5819.33 3113.94 5825.06 3112.51 C 5832.23 3111.07 5835.1 3125.4 5842.26 3126.84 C 5847.99 3126.84 5830.8 3116.81 5833.66 3113.94 C 5840.83 3105.34 5875.22 3135.44 5901.02 3111.07 C 5905.32 3106.77 5893.86 3103.91 5888.12 3103.91 C 5837.96 3101.04 5912.49 3115.37 5870.93 3118.24 C 5863.76 3119.67 5819.33 3098.17 5799.27 3095.31 C 5792.1 3095.31 5786.37 3091.01 5779.2 3091.01 C 5770.6 3091.01 5754.84 3103.91 5753.41 3095.31 C 5751.97 3085.28 5774.9 3085.28 5777.77 3075.24 C 5780.64 3062.35 5751.97 3056.61 5751.97 3042.28 C 5751.97 3036.55 5766.3 3042.28 5769.17 3046.58 C 5773.47 3053.75 5773.47 3070.94 5782.07 3069.51 C 5790.67 3068.08 5772.04 3045.15 5780.64 3043.71 C 5792.1 3042.28 5797.83 3065.21 5809.3 3065.21 C 5817.9 3065.21 5815.03 3037.98 5820.76 3043.71 C 5827.93 3049.45 5817.9 3062.35 5817.9 3072.38 C 5817.9 3073.81 5815.03 3078.11 5816.47 3078.11 C 5825.06 3075.24 5820.76 3056.61 5829.36 3056.61 C 5833.66 3056.61 5830.8 3066.64 5835.1 3069.51 C 5843.7 3073.81 5858.03 3082.41 5862.33 3073.81 C 5865.19 3066.64 5843.7 3069.51 5839.4 3063.78 C 5832.23 3055.18 5829.36 3045.15 5829.36 3035.12 C 5827.93 3022.22 5849.43 3012.18 5862.33 3015.05 C 5868.06 3016.48 5865.19 3027.95 5868.06 3033.68 C 5872.36 3042.28 5879.52 3048.01 5882.39 3056.61 C 5882.39 3059.48 5875.22 3065.21 5878.09 3065.21 C 5882.39 3065.21 5883.82 3059.48 5883.82 3056.61 C 5878.09 3027.95 5846.56 3009.32 5896.72 3000.72 C 5913.92 2997.85 5916.79 3022.22 5916.79 3045.15 C 5918.22 3042.28 5919.65 3037.98 5922.52 3036.55 C 5931.12 3029.38 5955.48 3045.15 5952.62 3035.12 C 5949.75 3023.65 5929.69 3033.68 5919.65 3026.52 C 5912.49 3020.78 5915.35 3007.88 5909.62 3000.72 C 5902.46 2990.69 5863.76 2977.79 5858.03 2973.49 C 5856.59 2972.06 5862.33 2967.76 5866.63 2967.76 C 5872.36 2966.32 5879.52 2966.32 5885.26 2969.19 C 5888.12 2970.62 5886.69 2977.79 5889.56 2977.79 C 5893.86 2979.22 5911.05 2949.13 5931.12 2964.89 C 5936.85 2969.19 5928.25 2983.52 5935.42 2986.39 C 5941.15 2989.25 5932.55 2970.62 5938.28 2967.76 C 5948.32 2962.02 5969.81 2993.55 5969.81 2994.99 C 5978.41 2996.42 5995.61 2989.25 5991.31 2982.09 C 5987.01 2973.49 5969.81 2987.82 5962.65 2982.09 C 5952.62 2973.49 5972.68 2957.72 5988.45 2951.99 C 5976.98 2956.29 5966.95 2959.16 5956.92 2959.16 C 5870.93 2960.59 5946.88 2950.56 5944.02 2933.36 C 5942.58 2921.89 5923.95 2923.33 5916.79 2913.3 C 5906.75 2901.83 5911.05 2891.8 5949.75 2896.1 C 5958.35 2897.53 5958.35 2913.3 5966.95 2916.16 C 5972.68 2917.6 5976.98 2907.56 5982.71 2907.56 C 5991.31 2906.13 5998.48 2906.13 6007.08 2907.56 C 6005.64 2906.13 6004.21 2903.26 6002.78 2901.83 C 6001.34 2893.23 6012.81 2884.63 6021.41 2883.2 C 6025.71 2881.77 6021.41 2891.8 6024.27 2896.1 C 6028.57 2901.83 6038.61 2901.83 6041.47 2909 C 6044.34 2914.73 6035.74 2923.33 6041.47 2927.63 C 6048.64 2934.79 6067.27 2947.69 6073 2937.66 C 6077.3 2927.63 6050.07 2923.33 6048.64 2911.86 C 6048.64 2904.7 6064.4 2910.43 6070.14 2906.13 C 6073 2903.26 6060.1 2909 6057.24 2906.13 C 6055.8 2904.7 6065.84 2898.96 6062.97 2900.4 C 6055.8 2901.83 6050.07 2911.86 6044.34 2909 C 6034.31 2903.26 6031.44 2890.37 6028.57 2880.33 C 6025.71 2876.03 6035.74 2884.63 6040.04 2886.07 C 6044.34 2888.93 6025.71 2871.73 6040.04 2874.6 C 6041.47 2874.6 6098.8 2904.7 6093.07 2866 C 6087.33 2818.71 6047.2 2907.56 6055.8 2845.94 C 6057.24 2833.04 6091.63 2810.11 6101.67 2815.84 C 6110.26 2820.14 6100.23 2838.77 6107.4 2847.37 C 6110.26 2851.67 6114.56 2840.2 6118.86 2837.34 C 6126.03 2834.47 6146.09 2834.47 6140.36 2828.74 C 6136.06 2823.01 6116 2843.07 6117.43 2834.47 C 6117.43 2824.44 6133.19 2821.57 6140.36 2812.97 C 6148.96 2804.38 6148.96 2787.18 6160.42 2785.74 C 6169.02 2782.88 6164.72 2800.08 6169.02 2807.24 C 6171.89 2812.97 6181.92 2815.84 6181.92 2823.01 C 6181.92 2831.61 6169.02 2835.91 6170.46 2844.5 C 6171.89 2850.24 6179.06 2837.34 6184.79 2838.77 C 6193.39 2840.2 6203.42 2861.7 6207.72 2854.54 C 6212.02 2843.07 6190.52 2834.47 6191.95 2823.01 C 6191.95 2811.54 6250.71 2825.87 6252.15 2825.87 C 6262.18 2818.71 6263.61 2802.94 6262.18 2791.48 C 6260.75 2785.74 6243.55 2797.21 6244.98 2791.48 C 6249.28 2772.85 6308.04 2769.98 6305.17 2755.65 C 6303.74 2744.18 6269.35 2744.18 6276.51 2734.15 C 6282.24 2724.12 6308.04 2726.98 6309.47 2715.52 C 6313.77 2658.19 6262.18 2728.42 6250.71 2738.45 C 6244.98 2742.75 6227.78 2747.05 6232.08 2754.21 C 6237.82 2764.25 6255.01 2758.51 6265.05 2762.81 C 6266.48 2762.81 6262.18 2764.25 6260.75 2765.68 C 6253.58 2769.98 6244.98 2772.85 6237.82 2778.58 C 6230.65 2784.31 6194.82 2815.84 6183.36 2812.97 C 6176.19 2811.54 6179.06 2800.08 6176.19 2794.34 C 6173.32 2788.61 6163.29 2784.31 6166.16 2778.58 C 6170.46 2768.55 6184.79 2767.11 6193.39 2759.95 C 6194.82 2758.51 6187.66 2764.25 6184.79 2762.81 C 6181.92 2762.81 6189.09 2755.65 6187.66 2757.08 C 6177.62 2761.38 6161.86 2784.31 6147.53 2778.58 C 6126.03 2769.98 6157.56 2751.35 6173.32 2741.32 C 6181.92 2737.02 6193.39 2737.02 6199.12 2728.42 C 6203.42 2724.12 6186.22 2732.72 6180.49 2731.28 C 6177.62 2731.28 6179.06 2728.42 6179.06 2725.55 C 6180.49 2715.52 6179.06 2705.49 6184.79 2696.89 C 6187.65 2692.59 6196.25 2699.75 6200.55 2696.89 C 6203.42 2696.89 6194.82 2696.89 6194.82 2694.02 C 6194.82 2689.72 6196.25 2685.42 6197.69 2681.12 C 6201.99 2676.82 6212.02 2686.86 6214.89 2681.12 C 6217.75 2676.82 6213.45 2668.22 6217.75 2662.49 C 6222.05 2656.76 6234.95 2658.19 6237.82 2649.59 C 6239.25 2643.86 6219.18 2636.69 6224.92 2635.26 C 6234.95 2632.4 6243.55 2649.59 6253.58 2646.73 C 6260.75 2645.29 6242.12 2638.13 6237.82 2630.96 C 6230.65 2620.93 6252.15 2609.46 6263.61 2602.3 C 6275.08 2595.13 6279.38 2628.1 6293.71 2633.83 C 6302.31 2636.69 6313.77 2633.83 6319.51 2626.66 C 6322.37 2622.36 6299.44 2626.66 6302.31 2620.93 C 6306.61 2612.33 6325.24 2613.76 6329.54 2605.17 C 6336.7 2585.1 6285.11 2638.13 6298.01 2583.67 C 6299.44 2575.07 6302.31 2569.34 6303.74 2566.47 C 6298.01 2570.77 6292.28 2575.07 6285.11 2577.94 C 6263.61 2587.97 6325.24 2550.7 6320.94 2544.97 C 6319.51 2542.11 6316.64 2542.11 6312.34 2543.54 L 6312.34 2542.11 C 6312.34 2539.24 6302.31 2542.11 6303.74 2539.24 C 6308.04 2529.21 6352.47 2532.07 6359.63 2529.21 C 6362.5 2526.34 6356.77 2519.18 6359.63 2516.31 C 6381.13 2496.24 6409.8 2509.14 6416.96 2467.58 C 6416.96 2460.42 6405.5 2474.75 6399.76 2477.61 C 6392.6 2479.05 6385.43 2477.61 6378.27 2477.61 C 6372.53 2479.05 6362.5 2487.65 6362.5 2481.91 C 6365.37 2463.28 6416.96 2463.28 6402.63 2438.92 C 6401.2 2434.62 6388.3 2437.48 6378.27 2437.48 C 6379.7 2440.35 6382.57 2443.22 6385.43 2448.95 C 6378.27 2456.12 6372.53 2464.72 6365.37 2471.88 C 6362.5 2473.31 6356.77 2481.91 6355.34 2477.61 C 6353.9 2470.45 6353.9 2430.32 6365.37 2428.89 C 6365.37 2424.59 6365.37 2421.72 6368.23 2415.99 C 6372.53 2404.52 6391.16 2410.25 6401.2 2404.52 C 6404.06 2403.09 6394.03 2404.52 6392.6 2403.09 C 6388.3 2397.36 6384 2390.19 6382.57 2384.46 C 6381.13 2375.86 6394.03 2342.9 6402.63 2342.9 C 6414.1 2341.46 6419.83 2360.09 6431.29 2362.96 C 6435.59 2364.39 6426.99 2352.93 6425.56 2347.2 C 6422.69 2340.03 6424.13 2327.13 6416.96 2322.83 C 6409.8 2318.53 6396.9 2330 6389.73 2324.26 C 6366.8 2305.63 6414.1 2312.8 6421.26 2309.93 C 6434.16 2304.2 6435.59 2285.57 6455.66 2289.87 C 6464.26 2292.74 6468.56 2304.2 6477.15 2304.2 C 6484.32 2304.2 6465.69 2295.6 6464.26 2289.87 L 6464.26 2288.44 C 6462.82 2288.44 6461.39 2289.87 6459.96 2289.87 C 6457.09 2289.87 6459.96 2281.27 6457.09 2279.84 C 6442.76 2276.97 6432.73 2302.77 6416.96 2301.33 C 6366.8 2294.17 6444.19 2284.14 6452.79 2276.97 C 6455.66 2275.54 6447.06 2275.54 6442.76 2275.54 C 6432.73 2274.1 6424.13 2278.4 6414.1 2276.97 C 6401.2 2274.1 6405.5 2251.17 6408.36 2239.71 C 6418.39 2186.68 6439.89 2209.61 6475.72 2195.28 C 6495.79 2186.68 6452.79 2172.35 6447.06 2162.32 C 6444.19 2156.58 6459.96 2160.88 6465.69 2158.02 C 6471.42 2155.15 6441.33 2133.65 6477.15 2145.12 C 6480.02 2145.12 6472.86 2150.85 6472.86 2153.72 C 6474.29 2173.78 6481.45 2143.69 6481.45 2140.82 C 6481.45 2139.39 6484.32 2132.22 6485.75 2135.09 C 6490.05 2139.39 6484.32 2152.28 6491.49 2153.72 C 6502.95 2155.15 6518.72 2149.42 6521.58 2139.39 C 6525.88 2129.35 6505.82 2125.05 6504.38 2115.02 C 6504.38 2113.59 6538.78 2093.53 6550.25 2099.26 C 6557.41 2102.12 6543.08 2125.05 6551.68 2123.62 C 6560.28 2123.62 6550.25 2103.56 6557.41 2099.26 C 6558.84 2097.82 6558.84 2097.82 6560.28 2096.39 C 6558.84 2094.96 6557.41 2093.53 6555.98 2092.09 C 6551.68 2089.23 6564.58 2080.63 6560.28 2079.19 C 6555.98 2077.76 6553.11 2087.79 6547.38 2090.66 C 6533.05 2096.39 6515.85 2107.86 6501.52 2099.26 C 6495.79 2094.96 6512.98 2086.36 6517.28 2079.19 C 6525.88 2060.56 6528.75 2017.57 6550.25 2033.33 C 6557.41 2039.06 6528.75 2047.66 6535.91 2053.4 C 6541.65 2059.13 6550.25 2043.36 6560.28 2041.93 C 6567.44 2041.93 6574.61 2044.8 6580.34 2050.53 C 6588.94 2059.13 6604.71 2090.66 6600.41 2079.19 C 6597.54 2069.16 6583.21 2060.56 6586.08 2049.1 C 6587.51 2039.06 6604.71 2037.63 6610.44 2029.03 C 6613.31 2024.73 6601.84 2031.9 6597.54 2033.33 C 6576.04 2040.5 6568.88 2050.53 6558.84 2023.3 C 6553.11 2008.97 6566.01 2017.57 6567.44 2010.4 C 6568.88 2008.97 6563.14 2011.83 6563.14 2010.4 C 6558.84 1997.5 6598.97 2017.57 6604.71 2010.4 C 6614.74 1993.2 6570.31 1978.87 6567.44 1978.87 C 6564.58 1978.87 6570.31 1984.6 6568.88 1987.47 C 6564.58 1996.07 6540.21 2026.17 6531.61 2021.87 C 6521.58 2017.57 6520.15 2001.8 6524.45 1991.77 C 6527.32 1983.17 6541.65 1988.9 6547.38 1983.17 C 6551.68 1978.87 6534.48 1988.9 6531.61 1984.6 C 6525.88 1976.01 6550.25 1970.27 6557.41 1976.01 C 6560.28 1977.44 6554.55 1984.6 6555.98 1983.17 C 6578.91 1960.24 6616.17 1974.57 6613.31 1943.04 C 6613.31 1938.74 6604.71 1947.34 6600.41 1944.48 C 6597.54 1943.04 6601.84 1937.31 6598.97 1935.88 C 6597.54 1934.44 6597.54 1941.61 6596.11 1941.61 C 6590.37 1944.48 6586.08 1943.04 6581.78 1943.04 C 6573.18 1944.48 6561.71 1951.64 6558.84 1944.48 C 6540.21 1907.21 6596.11 1933.01 6597.54 1933.01 C 6606.14 1925.84 6598.97 1910.08 6603.27 1900.05 C 6604.71 1895.75 6607.57 1910.08 6609.01 1915.81 C 6610.44 1917.25 6614.74 1914.38 6614.74 1915.81 C 6614.74 1924.41 6609.01 1933.01 6611.87 1940.18 C 6611.87 1943.04 6643.4 1988.9 6650.57 1980.31 C 6667.77 1960.24 6596.11 1897.18 6617.6 1887.15 C 6624.77 1882.85 6639.1 1894.32 6650.57 1904.35 C 6649.13 1900.05 6649.13 1895.75 6646.27 1892.88 C 6639.1 1887.15 6617.6 1890.02 6620.47 1879.98 C 6621.9 1868.52 6640.54 1869.95 6652 1868.52 C 6713.63 1858.49 6662.03 1888.58 6700.73 1907.21 C 6727.96 1920.11 6669.2 1862.79 6695 1862.79 C 6702.16 1862.79 6706.46 1871.38 6712.19 1871.38 C 6720.79 1869.95 6733.69 1869.95 6732.26 1862.79 C 6723.66 1802.59 6687.83 1862.79 6673.5 1859.92 C 6670.63 1858.49 6679.23 1855.62 6677.8 1852.75 C 6677.8 1849.89 6673.5 1845.59 6670.63 1847.02 C 6666.33 1848.45 6666.33 1857.05 6660.6 1857.05 C 6652 1858.49 6637.67 1859.92 6633.37 1851.32 C 6630.5 1845.59 6631.94 1838.42 6634.8 1832.69 C 6627.64 1834.12 6619.04 1835.56 6614.74 1839.85 C 6607.57 1847.02 6614.74 1865.65 6606.14 1871.38 C 6600.41 1875.68 6606.14 1854.19 6600.41 1849.89 C 6593.24 1845.59 6584.64 1847.02 6577.48 1848.45 C 6571.74 1849.89 6574.61 1861.35 6570.31 1865.65 C 6566.01 1869.95 6560.28 1874.25 6555.98 1878.55 C 6550.25 1884.28 6545.95 1890.02 6541.65 1895.75 L 6541.65 1890.02 C 6545.95 1879.98 6554.55 1869.95 6555.98 1859.92 C 6557.41 1854.19 6550.25 1847.02 6553.11 1841.29 C 6560.28 1834.12 6574.61 1836.99 6581.78 1829.82 C 6611.87 1801.16 6534.48 1809.76 6576.04 1765.33 C 6606.14 1730.93 6600.41 1795.43 6593.24 1826.96 C 6596.11 1821.22 6600.41 1816.92 6604.71 1815.49 C 6607.57 1814.06 6610.44 1824.09 6611.87 1821.22 C 6616.17 1814.06 6609 1745.27 6633.37 1778.23 C 6646.27 1795.43 6650.57 1808.33 6650.57 1815.49 C 6656.3 1812.62 6660.6 1809.76 6664.9 1809.76 C 6670.63 1809.76 6673.5 1821.22 6679.23 1821.22 C 6690.7 1822.66 6703.59 1819.79 6713.63 1814.06 C 6727.96 1805.46 6683.53 1816.92 6680.66 1798.29 C 6680.66 1792.56 6687.83 1785.39 6695 1785.39 L 6697.86 1785.39 C 6696.43 1783.96 6695 1783.96 6695 1781.1 C 6695 1772.5 6712.19 1775.36 6719.36 1769.63 C 6720.79 1768.2 6713.63 1768.2 6712.19 1766.76 C 6702.16 1759.6 6697.86 1743.83 6700.73 1730.93 C 6702.16 1719.47 6730.82 1729.5 6733.69 1718.04 C 6736.56 1709.44 6729.39 1700.84 6726.53 1692.24 C 6726.53 1702.27 6725.09 1708 6723.66 1709.44 C 6713.63 1709.44 6703.59 1700.84 6695 1706.57 C 6680.66 1712.3 6677.8 1730.93 6669.2 1743.83 C 6662.03 1739.53 6649.13 1739.53 6649.13 1732.37 C 6652 1720.9 6670.63 1719.47 6673.5 1708 C 6676.36 1702.27 6657.73 1715.17 6656.3 1709.44 C 6653.43 1700.84 6669.2 1693.67 6667.77 1683.64 C 6667.77 1677.91 6647.7 1685.07 6652 1682.21 C 6672.07 1672.17 6705.03 1680.77 6690.7 1662.14 C 6684.96 1656.41 6663.47 1659.28 6669.2 1654.98 C 6676.36 1650.68 6687.83 1663.58 6696.43 1659.28 C 6705.03 1653.54 6700.73 1634.91 6709.33 1632.05 C 6723.66 1627.75 6726.53 1654.98 6727.96 1677.91 C 6727.96 1669.31 6730.82 1662.14 6733.69 1654.98 C 6740.86 1643.51 6743.72 1683.64 6753.76 1689.37 C 6763.79 1695.11 6776.69 1689.37 6786.72 1685.07 C 6788.15 1685.07 6743.72 1669.31 6746.59 1659.28 C 6749.46 1649.24 6759.49 1636.35 6769.52 1637.78 C 6779.55 1637.78 6778.12 1656.41 6785.29 1663.58 C 6792.45 1670.74 6802.48 1669.31 6811.08 1676.47 C 6815.38 1680.77 6819.68 1699.4 6822.55 1693.67 C 6834.01 1659.28 6749.46 1667.87 6780.99 1600.52 C 6786.72 1589.05 6811.08 1574.72 6822.55 1583.32 C 6832.58 1589.05 6819.68 1656.41 6819.68 1659.28 C 6822.55 1662.14 6826.85 1654.98 6828.28 1650.68 C 6829.71 1642.08 6822.55 1630.61 6828.28 1623.45 C 6832.58 1616.28 6851.21 1627.75 6852.64 1619.15 C 6852.64 1610.55 6832.58 1611.98 6829.71 1603.38 C 6826.85 1596.22 6841.18 1534.59 6862.68 1560.39 C 6868.41 1568.99 6862.68 1649.24 6862.68 1652.11 C 6859.81 1662.14 6841.18 1679.34 6851.21 1682.21 C 6877.01 1690.81 6864.11 1640.64 6872.71 1634.91 C 6881.31 1629.18 6894.21 1634.91 6902.8 1630.61 C 6907.1 1627.75 6895.64 1624.88 6892.77 1622.01 C 6882.74 1613.41 6861.24 1601.95 6869.84 1581.89 C 6907.1 1498.76 6869.84 1593.35 6912.84 1564.69 C 6924.3 1557.52 6912.84 1536.02 6921.44 1525.99 C 6924.3 1523.13 6928.6 1527.42 6931.47 1530.29 C 6934.33 1533.16 6932.9 1538.89 6935.77 1541.76 C 6942.93 1547.49 6951.53 1548.92 6958.7 1554.65 C 6964.43 1558.95 6968.73 1567.55 6975.9 1570.42 C 6983.06 1571.85 6963 1560.39 6960.13 1553.22 C 6960.13 1551.79 6965.86 1551.79 6965.86 1548.92 C 6968.73 1528.86 6964.43 1498.76 6961.56 1500.19 C 6954.4 1500.19 6912.84 1536.02 6901.37 1494.46 C 6895.64 1471.53 6937.2 1461.5 6948.67 1464.37 C 6958.7 1465.8 6964.43 1478.7 6974.46 1481.56 C 6977.33 1481.56 6973.03 1472.96 6975.9 1471.53 C 6978.76 1468.66 6984.5 1471.53 6987.36 1472.96 C 6995.96 1472.96 7005.99 1471.53 7013.16 1474.4 C 7031.79 1480.13 7007.43 1521.69 7046.12 1518.83 C 7053.29 1517.39 7057.59 1507.36 7056.15 1500.19 C 7056.15 1495.9 7047.55 1501.63 7043.26 1500.19 C 7038.96 1498.76 7031.79 1497.33 7031.79 1493.03 C 7031.79 1487.3 7048.99 1490.16 7043.26 1480.13 C 7037.52 1471.53 7036.09 1462.93 7041.82 1435.7 L 7041.82 1432.84 C 7038.96 1438.57 7034.66 1444.3 7030.36 1451.47 C 7023.19 1444.3 7010.29 1440 7007.43 1431.4 C 7000.26 1405.61 7086.25 1343.98 7053.29 1412.77 C 7066.19 1401.31 7084.82 1414.2 7089.12 1409.91 C 7096.28 1405.61 7073.35 1405.61 7070.49 1398.44 C 7060.45 1374.08 7103.45 1378.38 7106.31 1374.08 C 7112.05 1361.18 7067.62 1345.41 7067.62 1341.11 C 7069.05 1332.51 7089.12 1352.58 7091.98 1345.41 C 7097.72 1335.38 7079.08 1323.92 7081.95 1312.45 C 7086.25 1300.98 7165.07 1308.15 7166.51 1312.45 C 7169.37 1316.75 7130.68 1386.97 7132.11 1391.27 C 7132.11 1392.71 7133.54 1392.71 7134.98 1392.71 C 7132.11 1392.71 7130.68 1392.71 7130.68 1394.14 C 7133.54 1398.44 7142.14 1391.27 7146.44 1394.14 C 7165.07 1407.04 7122.08 1412.77 7146.44 1419.94 C 7155.04 1422.8 7140.71 1435.7 7139.28 1444.3 C 7139.28 1447.17 7136.41 1488.73 7160.77 1464.37 C 7165.07 1460.07 7160.77 1451.47 7162.21 1445.73 C 7163.64 1437.14 7167.94 1431.4 7170.81 1424.24 C 7173.67 1415.64 7157.91 1425.67 7162.21 1412.77 C 7170.81 1388.41 7193.74 1293.82 7209.5 1285.22 C 7209.5 1285.22 7219.53 1322.48 7219.53 1325.35 C 7216.67 1333.95 7202.34 1338.25 7203.77 1348.28 C 7205.2 1354.01 7218.1 1338.25 7222.4 1343.98 C 7228.13 1351.15 7216.67 1369.78 7225.27 1374.08 C 7235.3 1381.24 7249.63 1374.08 7258.23 1366.91 C 7263.96 1361.18 7245.33 1356.88 7245.33 1349.71 C 7245.33 1339.68 7241.03 1326.78 7246.76 1318.18 C 7251.06 1308.15 7265.4 1306.72 7272.56 1298.12 C 7275.43 1295.25 7265.4 1298.12 7262.53 1296.69 C 7252.5 1292.39 7235.3 1289.52 7235.3 1278.05 C 7233.87 1269.45 7256.8 1279.49 7261.1 1272.32 C 7266.83 1262.29 7253.93 1250.82 7256.8 1240.79 C 7258.23 1233.63 7268.26 1255.12 7275.43 1250.82 C 7286.89 1246.52 7295.49 1236.49 7318.42 1252.26 C 7335.62 1263.72 7288.33 1325.35 7284.03 1333.95 C 7282.59 1336.81 7292.63 1329.65 7294.06 1326.78 C 7302.66 1319.62 7306.96 1303.85 7316.99 1300.98 C 7324.16 1299.55 7319.86 1313.88 7318.42 1321.05 C 7314.12 1331.08 7296.93 1341.11 7302.66 1351.15 C 7308.39 1359.74 7322.72 1333.95 7331.32 1339.68 C 7332.75 1341.11 7334.19 1342.55 7334.19 1343.98 C 7337.05 1342.55 7342.79 1346.85 7345.65 1345.41 C 7354.25 1336.81 7332.75 1329.65 7332.75 1329.65 C 7331.32 1323.92 7329.89 1275.19 7335.62 1266.59 C 7361.42 1233.63 7378.62 1296.69 7380.05 1296.69 C 7473.2 1300.98 7332.75 1240.79 7424.48 1269.45 C 7471.77 1283.79 7437.38 1285.22 7430.21 1303.85 C 7428.78 1306.72 7437.38 1305.28 7440.24 1303.85 C 7448.84 1300.98 7456.01 1293.82 7464.61 1292.39 C 7467.47 1292.39 7464.61 1298.12 7466.04 1299.55 C 7470.34 1302.42 7476.07 1302.42 7480.37 1303.85 C 7481.8 1305.28 7483.24 1308.15 7486.1 1309.58 C 7493.27 1315.32 7504.73 1319.62 7510.47 1328.21 C 7511.9 1331.08 7504.73 1331.08 7501.87 1333.95 C 7494.7 1338.25 7484.67 1339.68 7480.37 1346.85 C 7471.77 1358.31 7478.94 1378.38 7467.47 1384.11 C 7435.94 1399.87 7397.25 1378.38 7371.45 1407.04 C 7367.15 1409.91 7380.05 1402.74 7385.78 1402.74 C 7392.95 1402.74 7398.68 1404.17 7405.85 1405.61 C 7407.28 1407.04 7408.71 1408.47 7410.15 1408.47 C 7421.61 1409.91 7437.38 1401.31 7444.54 1411.34 C 7450.27 1418.5 7427.34 1428.54 7431.64 1437.14 C 7435.94 1444.3 7441.68 1417.07 7450.27 1418.5 C 7460.31 1421.37 7457.44 1444.3 7453.14 1458.63 C 7454.57 1455.77 7456.01 1454.33 7457.44 1452.9 C 7467.47 1448.6 7481.8 1455.77 7493.27 1451.47 C 7496.14 1450.03 7484.67 1445.73 7484.67 1441.43 C 7483.24 1431.4 7484.67 1422.8 7487.54 1414.2 C 7488.97 1411.34 7486.1 1422.8 7490.4 1422.8 C 7501.87 1425.67 7513.33 1422.8 7524.8 1421.37 L 7529.1 1421.37 M 6914.27 1716.6 L 6915.7 1716.6 L 6914.27 1716.6 M 7175.11 1278.05 C 7176.54 1289.52 7156.48 1292.39 7149.31 1300.98 C 7091.98 1245.09 7169.37 1245.09 7175.11 1278.05 M 6957.27 1389.84 C 6963 1389.84 6965.86 1399.87 6970.16 1397.01 C 6975.9 1392.71 6960.13 1376.94 6965.86 1378.38 C 6968.73 1379.81 6968.73 1386.97 6973.03 1386.97 C 6975.9 1385.54 6970.16 1378.38 6973.03 1376.94 C 6985.93 1371.21 6980.2 1407.04 6993.09 1388.41 C 6995.96 1385.54 6985.93 1379.81 6988.79 1376.94 C 6997.39 1365.48 7011.73 1361.18 7024.62 1352.58 C 7024.62 1354.01 7023.19 1354.01 7023.19 1354.01 C 7023.19 1355.44 7028.92 1355.44 7028.92 1356.88 C 7027.49 1362.61 7021.76 1368.34 7018.89 1374.08 C 7007.43 1405.61 6991.66 1418.5 6957.27 1424.24 C 6960.13 1415.64 6970.16 1405.61 6965.86 1397.01 C 6964.43 1395.57 6961.56 1394.14 6958.7 1394.14 C 6958.7 1392.71 6955.83 1389.84 6957.27 1389.84 M 6947.23 1395.57 L 6941.5 1395.57 C 6938.63 1394.14 6941.5 1395.57 6947.23 1395.57 M 6861.24 1497.33 C 6864.11 1491.6 6872.71 1488.73 6879.87 1485.86 C 6881.31 1484.43 6885.61 1485.86 6884.17 1487.3 C 6879.87 1498.76 6872.71 1508.79 6866.98 1518.83 C 6865.54 1511.66 6858.38 1504.49 6861.24 1497.33 M 6834.01 1533.16 L 6835.45 1536.02 C 6835.45 1537.46 6834.01 1538.89 6834.01 1540.32 C 6834.01 1537.46 6832.58 1536.02 6834.01 1533.16 M 6758.06 1560.39 C 6769.52 1528.86 6884.17 1536.02 6785.29 1581.89 C 6778.12 1573.29 6755.19 1570.42 6758.06 1560.39 M 6558.84 1793.99 C 6561.71 1796.86 6553.11 1799.73 6554.55 1804.03 C 6557.41 1819.79 6594.67 1818.36 6543.08 1839.85 C 6537.35 1841.29 6531.61 1834.12 6524.45 1831.26 C 6561.71 1801.16 6540.21 1796.86 6540.21 1805.46 C 6541.65 1822.66 6523.02 1811.19 6514.42 1816.92 C 6507.25 1819.79 6501.52 1844.15 6500.09 1835.56 C 6495.79 1811.19 6533.05 1769.63 6558.84 1793.99 M 6444.19 1924.41 C 6447.06 1915.81 6441.33 1900.05 6449.92 1898.61 C 6502.95 1888.58 6455.66 1938.74 6438.46 1943.04 C 6438.46 1941.61 6435.59 1941.61 6435.59 1940.18 C 6438.46 1934.44 6442.76 1930.14 6444.19 1924.41 M 6090.2 2742.75 C 6097.37 2744.18 6093.07 2754.21 6094.5 2761.38 C 6093.07 2762.81 6090.2 2764.25 6088.77 2764.25 C 6083.03 2765.68 6075.87 2765.68 6070.14 2767.11 C 6009.94 2775.71 6088.77 2741.32 6090.2 2742.75 M 5823.63 3010.75 C 5829.36 3007.88 5836.53 3010.75 5843.7 3012.18 C 5843.7 3010.75 5843.7 3009.32 5845.13 3009.32 C 5845.13 3007.88 5846.56 3010.75 5846.56 3012.18 C 5845.13 3013.62 5843.7 3013.62 5842.26 3015.05 L 5843.7 3013.62 C 5837.96 3016.48 5832.23 3023.65 5826.5 3023.65 C 5822.2 3023.65 5820.76 3013.62 5823.63 3010.75 M 5730.48 3561.09 L 5733.34 3558.22 C 5736.21 3572.55 5741.94 3588.32 5734.77 3602.65 C 5719.01 3631.31 5727.61 3578.28 5730.48 3561.09 M 5753.41 3455.03 L 5753.41 3453.6 L 5753.41 3452.17 C 5756.27 3455.03 5760.57 3456.47 5760.57 3459.33 C 5769.17 3520.96 5737.64 3476.53 5750.54 3456.47 C 5750.54 3456.47 5750.54 3457.9 5749.11 3459.33 C 5750.54 3457.9 5753.41 3456.47 5753.41 3455.03 M 6303.74 2546.41 C 6298.01 2547.84 6293.71 2549.27 6289.41 2549.27 C 6279.38 2547.84 6292.28 2547.84 6303.74 2546.41 M 7145.01 1391.27 C 7142.14 1392.71 7137.84 1392.71 7134.98 1392.71 C 7139.28 1392.71 7147.88 1389.84 7145.01 1391.27 M 6902.8 1713.74 L 6904.24 1713.74 L 6902.8 1713.74 M 6907.1 1715.17 L 6909.97 1715.17 L 6907.1 1715.17 M 6911.4 1715.17 C 6911.4 1716.6 6911.4 1716.6 6912.84 1716.6 C 6911.4 1716.6 6911.4 1716.6 6911.4 1715.17 " }
                }
            }
            // PATH visit ua count: 886
            DemoShape {
                objectName: "ua"
                ShapePath {
                    objectName: "svg_path:ua"
                    // boundingRect: 7693.24, 4446.56 2146.03x1480.63
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 9710.38 5187.73 L 9710.38 5186.3 C 9698.91 5173.4 9706.08 5169.1 9708.94 5156.2 C 9711.81 5140.44 9691.75 5160.5 9691.75 5151.9 C 9693.18 5141.87 9684.58 5107.47 9688.88 5098.87 C 9690.31 5098.87 9731.87 5060.18 9731.87 5060.18 C 9734.74 5054.45 9727.57 5047.28 9727.57 5041.55 C 9726.14 5035.81 9724.71 5028.65 9729.01 5022.92 C 9750.51 4997.12 9817.86 5008.58 9837.93 4978.49 C 9842.23 4972.76 9835.06 4964.16 9832.2 4956.99 C 9830.76 4954.12 9825.03 4952.69 9825.03 4949.82 C 9825.03 4945.53 9833.63 4945.53 9833.63 4942.66 C 9833.63 4938.36 9827.9 4935.49 9826.46 4931.19 C 9825.03 4924.03 9826.46 4915.43 9827.9 4906.83 C 9827.9 4903.96 9832.2 4901.1 9832.2 4898.23 C 9837.93 4881.03 9812.13 4896.8 9812.13 4896.8 C 9807.83 4893.93 9816.43 4886.77 9815 4881.03 C 9809.26 4871 9800.67 4860.97 9793.5 4852.37 C 9783.47 4842.34 9767.7 4866.7 9766.27 4850.94 C 9759.1 4805.07 9763.4 4817.97 9789.2 4806.51 C 9790.63 4805.07 9802.1 4780.71 9793.5 4783.58 C 9773.44 4787.88 9763.4 4802.21 9746.21 4787.88 C 9727.57 4772.11 9760.54 4767.81 9764.84 4760.65 C 9769.14 4756.35 9763.4 4749.18 9764.84 4744.88 C 9769.14 4726.25 9786.33 4716.22 9769.14 4697.59 C 9763.4 4690.42 9753.37 4688.99 9747.64 4683.26 C 9740.47 4674.66 9757.67 4656.03 9746.21 4654.59 C 9718.98 4653.16 9736.17 4676.09 9714.68 4680.39 C 9641.58 4691.85 9733.31 4670.36 9674.55 4660.32 C 9655.92 4657.46 9654.48 4678.96 9638.72 4668.92 C 9632.99 4666.06 9628.69 4658.89 9624.39 4654.59 C 9611.49 4645.99 9617.22 4678.96 9601.46 4678.96 C 9591.42 4678.96 9581.39 4676.09 9571.36 4671.79 C 9567.06 4668.92 9564.19 4658.89 9558.46 4660.32 C 9551.29 4660.32 9548.43 4674.66 9539.83 4674.66 C 9529.8 4674.66 9522.63 4664.62 9511.17 4663.19 C 9473.9 4657.46 9529.8 4713.35 9491.1 4706.19 C 9481.07 4704.75 9478.2 4691.85 9469.6 4687.56 C 9463.87 4684.69 9455.27 4688.99 9448.11 4686.12 C 9426.61 4678.96 9410.84 4651.73 9392.21 4637.39 C 9386.48 4633.09 9333.45 4687.56 9314.82 4713.35 C 9309.09 4721.95 9294.76 4706.19 9284.73 4704.75 C 9278.99 4704.75 9278.99 4713.35 9274.69 4716.22 C 9267.53 4720.52 9261.8 4703.32 9253.2 4700.45 C 9218.8 4691.85 9211.63 4742.02 9187.27 4729.12 C 9177.24 4724.82 9168.64 4719.08 9161.47 4711.92 C 9155.74 4706.19 9150.01 4699.02 9148.58 4690.42 C 9148.58 4686.12 9157.17 4684.69 9155.74 4680.39 C 9155.74 4674.66 9118.48 4641.69 9117.05 4637.39 C 9115.61 4633.09 9124.21 4625.93 9121.35 4623.06 C 9119.91 4621.63 9117.05 4621.63 9115.61 4621.63 C 9109.88 4623.06 9105.58 4627.36 9099.85 4627.36 C 9089.82 4628.8 9088.38 4611.6 9082.65 4604.43 C 9081.22 4601.57 9078.35 4601.57 9075.48 4603 C 9069.75 4605.86 9039.65 4624.5 9033.92 4624.5 C 9031.06 4625.93 9031.06 4617.33 9026.76 4617.33 C 9016.72 4617.33 9006.69 4618.76 8998.09 4621.63 C 8995.23 4623.06 8986.63 4643.13 8979.46 4628.8 C 8978.03 4625.93 8983.76 4623.06 8983.76 4620.2 C 8985.19 4615.9 8985.19 4610.16 8982.33 4607.3 C 8978.03 4603 8972.3 4605.86 8968 4601.57 C 8960.83 4597.27 8969.43 4582.93 8963.7 4577.2 C 8957.96 4570.04 8937.9 4565.74 8942.2 4557.14 C 8947.93 4549.97 8980.9 4542.81 8972.3 4529.91 C 8960.83 4512.71 8933.6 4514.14 8925 4506.98 C 8919.27 4502.68 8914.97 4496.94 8913.54 4491.21 C 8910.67 4485.48 8914.97 4478.31 8912.1 4475.45 C 8906.37 4469.71 8897.77 4469.71 8892.04 4465.41 C 8883.44 4459.68 8879.14 4448.22 8869.11 4446.78 C 8857.64 4443.92 8853.34 4469.71 8840.44 4469.71 C 8836.15 4469.71 8837.58 4459.68 8833.28 4459.68 C 8777.39 4455.38 8811.78 4486.91 8778.82 4501.24 C 8778.82 4501.24 8717.19 4505.54 8715.76 4505.54 C 8712.89 4505.54 8722.93 4548.54 8710.03 4561.44 C 8701.43 4568.6 8691.4 4575.77 8679.93 4577.2 C 8675.63 4577.2 8677.06 4568.6 8672.76 4565.74 C 8669.9 4564.3 8665.6 4571.47 8662.73 4570.04 C 8646.97 4574.33 8628.34 4572.9 8615.44 4581.5 C 8609.7 4584.37 8612.57 4594.4 8606.84 4597.27 C 8598.24 4601.57 8586.77 4597.27 8576.74 4600.13 C 8571.01 4601.57 8560.98 4615.9 8553.81 4656.03 C 8552.38 4666.06 8549.51 4693.29 8549.51 4704.75 C 8549.51 4720.52 8606.84 4759.21 8571.01 4766.38 C 8533.75 4774.98 8550.95 4739.15 8517.98 4736.28 C 8452.06 4731.98 8530.88 4747.75 8483.59 4756.35 C 8476.42 4757.78 8469.25 4747.75 8460.66 4749.18 C 8437.73 4754.91 8450.62 4779.28 8430.56 4785.01 C 8419.09 4787.88 8407.63 4747.75 8396.16 4742.02 C 8384.7 4736.28 8371.8 4756.35 8363.2 4767.81 C 8357.47 4774.98 8368.93 4796.48 8360.33 4795.04 C 8330.24 4787.88 8374.67 4796.48 8337.4 4770.68 C 8317.34 4756.35 8324.51 4785.01 8311.61 4785.01 C 8275.78 4785.01 8307.31 4772.11 8294.41 4763.51 C 8285.81 4759.21 8285.81 4780.71 8280.08 4786.44 C 8271.48 4796.48 8258.58 4783.58 8251.41 4785.01 C 8244.25 4785.01 8251.41 4810.81 8244.25 4815.11 C 8242.81 4817.97 8238.52 4813.67 8235.65 4810.81 C 8217.02 4800.78 8268.61 4776.41 8211.28 4792.18 C 8194.09 4796.48 8219.88 4819.41 8184.05 4805.07 C 8179.76 4803.64 8188.35 4795.04 8185.49 4792.18 C 8182.62 4789.31 8176.89 4796.48 8174.02 4795.04 C 8165.42 4787.88 8176.89 4773.55 8161.12 4777.84 C 8128.16 4786.44 8083.73 4790.74 8047.9 4786.44 C 8043.6 4785.01 8042.17 4779.28 8037.87 4779.28 C 8017.81 4777.84 7997.74 4790.74 7976.25 4793.61 C 7969.08 4793.61 7961.91 4793.61 7954.75 4793.61 C 7947.58 4793.61 7940.42 4790.74 7933.25 4792.18 C 7914.62 4797.91 7901.72 4812.24 7884.52 4819.41 C 7873.06 4823.71 7858.73 4820.84 7847.26 4826.57 C 7841.53 4830.87 7821.46 4898.23 7807.13 4893.93 C 7802.83 4892.5 7802.83 4885.33 7799.97 4885.33 C 7791.37 4883.9 7781.34 4883.9 7774.17 4886.77 C 7751.24 4893.93 7785.63 4906.83 7768.44 4911.13 L 7767 4912.56 C 7767 4912.56 7767 4911.13 7767 4911.13 C 7771.3 4916.86 7777.04 4921.16 7779.9 4926.89 C 7782.77 4935.49 7777.04 4945.52 7779.9 4952.69 C 7792.8 4979.92 7834.36 5007.15 7857.29 5024.35 C 7861.59 5028.65 7828.63 5027.22 7835.8 5041.55 C 7837.23 5042.98 7865.89 5068.78 7865.89 5080.24 C 7861.59 5131.84 7845.83 5100.31 7820.03 5121.8 C 7808.57 5131.84 7721.14 5293.78 7725.44 5305.25 C 7728.31 5321.01 7742.64 5332.48 7746.94 5346.81 C 7748.37 5353.98 7736.91 5364.01 7742.64 5369.74 C 7767 5399.84 7752.67 5342.51 7769.87 5396.97 C 7771.3 5399.84 7765.57 5392.67 7762.7 5391.24 C 7755.54 5389.81 7748.37 5392.67 7741.21 5392.67 C 7736.91 5391.24 7731.17 5391.24 7726.88 5389.81 C 7728.31 5404.14 7718.28 5424.2 7716.84 5438.53 C 7715.41 5448.57 7716.84 5458.6 7712.54 5467.2 C 7708.24 5477.23 7695.35 5480.1 7693.91 5490.13 C 7691.05 5500.16 7698.21 5510.19 7698.21 5521.66 C 7731.17 5523.09 7709.68 5538.86 7732.61 5547.45 C 7736.91 5548.89 7742.64 5541.72 7746.94 5544.59 C 7755.54 5550.32 7756.97 5564.65 7765.57 5570.39 C 7771.3 5571.82 7775.6 5564.65 7781.34 5563.22 C 7785.63 5563.22 7789.93 5566.09 7792.8 5567.52 C 7811.43 5580.42 7788.5 5577.55 7805.7 5591.88 C 7810 5594.75 7818.6 5589.02 7828.63 5561.79 C 7830.06 5558.92 7830.06 5554.62 7832.93 5554.62 C 7837.23 5554.62 7873.06 5571.82 7877.36 5571.82 C 7880.22 5571.82 7881.66 5564.65 7884.52 5563.22 C 7903.15 5556.05 7950.45 5574.68 7973.38 5568.95 C 7986.28 5564.65 7994.88 5553.19 8007.78 5551.75 C 8030.71 5550.32 8046.47 5580.42 8062.24 5584.72 C 8083.73 5591.88 8090.9 5551.75 8096.63 5546.02 C 8122.43 5518.79 8188.35 5521.66 8208.42 5501.59 C 8247.11 5464.33 8191.22 5495.86 8218.45 5460.03 C 8225.62 5451.43 8237.08 5444.27 8248.55 5441.4 L 8249.98 5437.1 L 8255.71 5424.2 C 8255.71 5422.77 8255.71 5421.34 8255.71 5421.34 L 8257.15 5415.6 L 8271.48 5418.47 C 8270.04 5415.6 8267.18 5412.74 8267.18 5409.87 C 8267.18 5408.44 8321.64 5401.27 8324.51 5399.84 C 8351.74 5386.94 8343.14 5365.44 8381.83 5368.31 C 8397.6 5369.74 8414.79 5375.47 8427.69 5385.51 C 8431.99 5388.37 8427.69 5398.41 8431.99 5398.41 C 8442.02 5398.41 8452.06 5388.37 8463.52 5386.94 C 8469.25 5385.51 8462.09 5399.84 8463.52 5405.57 C 8466.39 5417.04 8473.55 5395.54 8476.42 5398.41 C 8480.72 5404.14 8480.72 5411.3 8485.02 5415.6 C 8490.75 5421.34 8485.02 5396.97 8493.62 5394.11 C 8542.35 5381.21 8520.85 5409.87 8555.24 5424.2 C 8569.58 5429.93 8559.54 5401.27 8572.44 5408.44 C 8605.41 5429.93 8582.47 5460.03 8592.51 5491.56 C 8593.94 5498.73 8629.77 5524.52 8638.37 5527.39 C 8655.57 5533.12 8634.07 5501.59 8654.13 5513.06 C 8679.93 5527.39 8646.97 5567.52 8665.6 5556.05 C 8672.76 5551.75 8668.46 5574.68 8674.2 5580.42 C 8682.8 5586.15 8718.63 5587.58 8727.22 5594.75 L 8741.56 5639.18 C 8741.56 5642.04 8732.96 5642.04 8734.39 5644.91 C 8737.26 5654.94 8770.22 5659.24 8770.22 5660.67 C 8761.62 5666.41 8751.59 5667.84 8744.42 5673.57 C 8741.56 5676.44 8742.99 5679.31 8741.56 5682.17 C 8734.39 5689.34 8727.22 5662.11 8715.76 5662.11 C 8707.16 5662.11 8715.76 5689.34 8707.16 5687.9 C 8701.43 5686.47 8682.8 5672.14 8682.8 5672.14 C 8679.93 5676.44 8681.36 5685.04 8675.63 5686.47 C 8672.76 5687.9 8671.33 5676.44 8669.9 5679.31 C 8662.73 5685.04 8664.17 5695.07 8659.87 5700.8 C 8658.43 5702.24 8655.57 5700.8 8654.13 5699.37 C 8654.13 5696.5 8657 5695.07 8657 5692.2 C 8655.57 5685.04 8652.7 5677.87 8649.83 5672.14 C 8644.1 5662.11 8631.2 5683.61 8624.04 5692.2 C 8603.97 5715.13 8639.8 5726.6 8642.67 5738.07 C 8644.1 5745.23 8636.94 5752.4 8636.94 5759.56 C 8636.94 5766.73 8645.53 5772.46 8642.67 5778.19 C 8639.8 5783.93 8629.77 5783.93 8624.04 5789.66 C 8611.14 5799.69 8631.2 5805.42 8624.04 5815.46 C 8618.3 5822.62 8609.7 5826.92 8605.41 5832.65 C 8592.51 5852.72 8614 5884.25 8603.97 5885.68 C 8596.81 5887.11 8589.64 5884.25 8582.47 5885.68 L 8583.91 5885.68 L 8576.74 5895.71 C 8576.74 5900.01 8575.31 5904.31 8572.44 5902.88 C 8575.31 5904.31 8579.61 5901.45 8582.47 5904.31 C 8586.77 5908.61 8585.34 5917.21 8591.07 5921.51 C 8596.81 5927.24 8658.43 5930.11 8657 5922.94 C 8657 5921.51 8636.94 5917.21 8651.27 5908.61 C 8659.87 5904.31 8669.9 5905.75 8678.5 5901.45 C 8692.83 5894.28 8698.56 5874.22 8714.33 5868.48 C 8745.86 5857.02 8761.62 5868.48 8768.79 5895.71 C 8771.65 5887.11 8783.12 5854.15 8765.92 5848.42 C 8763.05 5846.99 8767.35 5854.15 8764.49 5854.15 C 8763.05 5855.59 8763.05 5849.85 8761.62 5848.42 C 8753.02 5845.55 8758.75 5871.35 8748.72 5852.72 C 8740.12 5839.82 8741.56 5819.76 8740.12 5805.42 C 8740.12 5799.69 8730.09 5785.36 8735.82 5788.23 C 8748.72 5792.53 8745.86 5825.49 8758.75 5821.19 C 8801.75 5803.99 8773.09 5799.69 8773.09 5781.06 C 8773.09 5778.19 8775.95 5786.79 8778.82 5785.36 C 8783.12 5783.93 8771.65 5772.46 8775.95 5769.6 C 8783.12 5766.73 8791.72 5772.46 8798.88 5769.6 C 8804.62 5768.16 8808.92 5762.43 8811.78 5756.7 C 8823.25 5730.9 8836.15 5699.37 8844.74 5670.71 C 8846.18 5664.97 8834.71 5659.24 8837.58 5653.51 C 8839.01 5649.21 8847.61 5647.78 8850.48 5643.48 C 8860.51 5624.85 8831.85 5627.71 8843.31 5611.95 C 8874.84 5571.82 8917.84 5589.02 8917.84 5576.12 C 8919.27 5564.65 8903.5 5548.89 8913.54 5541.72 C 8920.7 5535.99 8916.4 5564.65 8926.43 5570.39 C 8930.73 5574.68 8936.47 5563.22 8943.63 5561.79 C 8950.8 5560.35 8959.4 5561.79 8968 5560.35 C 8986.63 5557.49 8963.7 5525.96 8963.7 5525.96 C 8962.26 5508.76 8976.6 5511.63 8968 5497.29 C 8972.3 5497.29 8976.6 5495.86 8976.6 5498.73 C 8978.03 5581.85 9025.32 5554.62 9069.75 5524.52 C 9075.48 5520.22 9056.85 5534.56 9051.12 5540.29 C 9043.95 5548.89 9053.99 5564.65 9041.09 5566.09 C 9016.72 5570.39 8989.49 5571.82 8965.13 5574.68 C 8963.7 5574.68 8927.87 5574.68 8932.17 5578.98 C 8940.77 5586.15 8949.37 5596.18 8960.83 5599.05 C 8965.13 5600.48 8957.96 5587.58 8962.26 5586.15 C 8970.86 5581.85 8980.9 5587.58 8990.93 5586.15 C 8993.79 5586.15 9005.26 5578.98 9006.69 5587.58 C 9009.56 5601.91 8973.73 5611.95 8983.76 5621.98 C 8988.06 5627.71 9038.22 5616.25 9045.39 5617.68 C 9049.69 5619.11 9045.39 5629.15 9049.69 5630.58 C 9059.72 5634.88 9072.62 5636.31 9084.08 5632.01 C 9095.55 5629.15 9101.28 5614.81 9111.31 5610.51 C 9121.35 5604.78 9134.24 5607.65 9142.84 5603.35 C 9145.71 5601.91 9139.98 5594.75 9142.84 5593.32 C 9145.71 5590.45 9151.44 5597.62 9154.31 5596.18 C 9161.47 5593.32 9157.17 5573.25 9164.34 5576.12 C 9177.24 5578.98 9188.7 5606.21 9198.74 5597.62 C 9205.9 5590.45 9204.47 5577.55 9213.07 5571.82 C 9237.43 5557.49 9211.63 5596.18 9227.4 5610.51 C 9233.13 5614.81 9247.46 5597.62 9246.03 5604.78 C 9246.03 5609.08 9201.6 5654.94 9193 5659.24 C 9188.7 5660.67 9184.4 5653.51 9180.1 5656.38 C 9178.67 5659.24 9187.27 5662.11 9185.84 5664.97 C 9185.84 5664.97 9155.74 5692.2 9154.31 5692.2 C 9151.44 5695.07 9148.58 5699.37 9147.14 5703.67 C 9147.14 5706.54 9151.44 5707.97 9151.44 5709.4 C 9150.01 5710.84 9098.41 5746.66 9117.05 5753.83 C 9152.87 5768.16 9145.71 5743.8 9175.81 5743.8 C 9185.84 5745.23 9217.37 5771.03 9227.4 5766.73 C 9240.3 5762.43 9250.33 5746.66 9267.53 5763.86 C 9306.22 5803.99 9273.26 5798.26 9280.43 5821.19 C 9287.59 5841.25 9297.62 5848.42 9296.19 5849.85 C 9290.46 5855.59 9270.39 5855.59 9273.26 5864.18 C 9277.56 5874.22 9296.19 5868.48 9306.22 5872.78 C 9316.26 5875.65 9316.26 5885.68 9329.15 5885.68 C 9400.81 5877.08 9386.48 5793.96 9432.34 5762.43 C 9440.94 5755.26 9449.54 5749.53 9461.01 5748.1 C 9466.74 5748.1 9473.9 5755.26 9478.2 5752.4 C 9488.24 5742.37 9479.64 5722.3 9489.67 5713.7 C 9499.7 5706.54 9505.43 5709.4 9508.3 5696.5 C 9509.73 5695.07 9505.43 5696.5 9504 5695.07 C 9496.83 5687.9 9508.3 5673.57 9512.6 5672.14 C 9519.77 5667.84 9529.8 5667.84 9538.4 5669.27 C 9547 5670.71 9552.73 5682.17 9561.33 5680.74 C 9571.36 5679.31 9574.23 5666.41 9582.82 5662.11 C 9589.99 5659.24 9598.59 5662.11 9605.76 5659.24 C 9634.42 5649.21 9611.49 5621.98 9614.35 5599.05 C 9617.22 5587.58 9634.42 5576.12 9627.25 5567.52 C 9627.25 5567.52 9568.49 5578.98 9567.06 5580.42 C 9558.46 5586.15 9565.63 5603.35 9557.03 5607.65 C 9551.29 5610.51 9544.13 5607.65 9538.4 5604.78 C 9534.1 5603.35 9535.53 5594.75 9531.23 5594.75 C 9521.2 5594.75 9529.8 5616.25 9524.06 5624.85 C 9516.9 5632.01 9509.73 5640.61 9499.7 5643.48 C 9475.34 5650.64 9395.08 5573.25 9382.18 5556.05 C 9377.88 5551.75 9357.82 5515.92 9360.68 5513.06 C 9369.28 5507.33 9377.88 5528.82 9387.91 5527.39 C 9420.88 5521.66 9412.28 5455.73 9425.18 5435.67 C 9429.48 5429.93 9438.07 5428.5 9440.94 5422.77 C 9448.11 5412.74 9448.11 5399.84 9455.27 5391.24 C 9476.77 5362.58 9488.24 5365.44 9506.87 5374.04 C 9508.3 5375.47 9508.3 5371.18 9509.73 5369.74 C 9522.63 5355.41 9506.87 5328.18 9541.26 5326.75 C 9552.73 5325.31 9559.89 5348.24 9568.49 5342.51 C 9578.53 5336.78 9565.63 5319.58 9569.93 5308.12 C 9569.93 5305.25 9602.89 5267.99 9604.32 5267.99 C 9610.05 5265.12 9617.22 5279.45 9620.09 5275.15 C 9622.95 5270.85 9624.39 5232.16 9632.99 5224.99 C 9644.45 5216.39 9680.28 5202.06 9694.61 5199.2 C 9698.91 5199.2 9700.34 5213.53 9703.21 5209.23 C 9707.51 5203.49 9706.08 5193.46 9710.38 5187.73 " }
                }
            }
            // PATH visit ch count: 232
            DemoShape {
                objectName: "ch"
                ShapePath {
                    objectName: "svg_path:ch"
                    // boundingRect: 5655.76, 5764.54 593.483x374.682
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6244.98 5941.58 C 6243.55 5947.31 6244.98 5954.47 6242.12 5960.21 C 6240.68 5965.94 6236.38 5970.24 6233.52 5975.97 C 6233.52 5978.84 6260.75 5998.9 6243.55 6004.63 C 6213.45 6011.8 6223.48 5970.24 6197.69 5988.87 C 6177.62 6003.2 6203.42 6018.97 6206.29 6026.13 C 6207.72 6031.86 6199.12 6036.16 6199.12 6041.9 C 6200.55 6047.63 6206.29 6050.5 6209.15 6054.8 C 6210.59 6060.53 6199.12 6066.26 6193.39 6063.39 C 6183.36 6057.66 6189.09 6034.73 6177.62 6033.3 C 6138.93 6026.13 6157.56 6054.8 6134.63 6047.63 C 6097.37 6039.03 6120.3 6010.37 6101.67 6007.5 C 6077.3 6003.2 6093.07 6041.9 6093.07 6044.76 C 6087.33 6070.56 6052.94 6079.16 6052.94 6110.69 C 6052.94 6125.02 6081.6 6119.29 6057.24 6137.92 C 6048.64 6145.08 6045.77 6120.72 6040.04 6113.56 C 6035.74 6109.26 6025.71 6112.12 6024.27 6106.39 C 6022.84 6100.66 6032.87 6096.36 6034.31 6090.62 C 6034.31 6087.76 6031.44 6084.89 6030.01 6084.89 C 6014.24 6079.16 5991.31 6074.86 5981.28 6056.23 C 5979.85 6050.5 5984.15 6044.76 5984.15 6040.46 C 5984.15 6031.86 5985.58 6023.27 5982.71 6014.67 C 5981.28 6013.23 5978.41 6016.1 5975.55 6017.53 C 5968.38 6023.27 5962.65 6029 5955.48 6034.73 C 5948.32 6040.46 5936.85 6043.33 5933.98 6051.93 C 5932.55 6057.66 5945.45 6060.53 5944.02 6067.69 C 5944.02 6074.86 5903.89 6116.42 5902.46 6116.42 C 5889.56 6116.42 5879.52 6099.22 5866.63 6102.09 C 5847.99 6106.39 5809.3 6135.05 5794.97 6109.26 C 5789.23 6100.66 5789.23 6090.62 5782.07 6083.46 C 5780.64 6080.59 5774.9 6089.19 5773.47 6086.32 C 5772.04 6082.03 5779.2 6074.86 5776.34 6070.56 C 5774.9 6066.26 5766.3 6070.56 5763.44 6067.69 C 5754.84 6053.36 5774.9 6054.8 5773.47 6046.2 C 5772.04 6039.03 5763.44 6036.16 5763.44 6029 C 5762 6024.7 5773.47 6016.1 5767.74 6014.67 C 5749.11 6006.07 5708.98 6006.07 5696.08 6026.13 C 5693.21 6029 5694.65 6031.86 5694.65 6036.16 C 5696.08 6039.03 5703.24 6041.9 5701.81 6044.76 C 5693.21 6061.96 5673.15 6069.13 5655.95 6064.83 C 5654.52 6064.83 5661.68 6061.96 5661.68 6059.09 C 5661.68 6040.46 5676.01 6047.63 5677.45 6043.33 C 5684.61 6020.4 5665.98 6000.33 5683.18 5978.84 C 5693.21 5964.51 5719.01 5964.51 5724.74 5948.74 C 5729.04 5940.14 5720.44 5927.24 5724.74 5917.21 C 5730.48 5905.75 5750.54 5910.05 5759.14 5900.01 C 5769.17 5891.41 5780.64 5862.75 5793.53 5852.72 C 5800.7 5846.99 5807.87 5862.75 5809.3 5842.69 C 5809.3 5835.52 5787.8 5849.85 5786.37 5842.69 C 5783.5 5835.52 5794.97 5829.79 5799.27 5824.06 C 5799.27 5824.06 5802.13 5825.49 5802.13 5824.06 C 5802.13 5821.19 5796.4 5815.46 5799.27 5814.02 C 5839.4 5802.56 5822.2 5857.02 5870.93 5806.86 C 5872.36 5806.86 5875.22 5803.99 5876.66 5801.12 L 5879.52 5798.26 C 5882.39 5796.83 5885.26 5796.83 5888.12 5799.69 C 5889.56 5801.12 5879.52 5802.56 5880.96 5805.42 C 5885.26 5814.02 5951.18 5798.26 5955.48 5798.26 C 5984.15 5796.83 5958.35 5824.06 5994.18 5805.42 C 5995.61 5803.99 5991.31 5796.83 5994.18 5795.39 C 5998.48 5792.53 6014.24 5791.09 6008.51 5789.66 C 5999.91 5788.23 5991.31 5791.09 5982.71 5789.66 C 5978.41 5788.23 6002.78 5749.53 6024.27 5771.03 C 6027.14 5773.89 6019.97 5779.63 6021.41 5783.93 C 6022.84 5786.79 6028.57 5788.23 6031.44 5786.79 C 6034.31 5785.36 6030.01 5775.33 6031.44 5778.19 C 6037.17 5781.06 6037.17 5791.09 6042.91 5793.96 C 6042.91 5793.96 6090.2 5791.09 6091.63 5791.09 C 6105.96 5793.96 6116 5808.29 6128.9 5815.46 L 6128.9 5816.89 C 6128.9 5826.92 6147.53 5829.79 6141.79 5844.12 C 6140.36 5846.99 6134.63 5845.55 6133.19 5846.99 C 6128.9 5854.15 6114.56 5905.75 6117.43 5907.18 C 6120.3 5908.61 6167.59 5912.91 6169.02 5912.91 C 6171.89 5915.78 6164.72 5920.08 6167.59 5922.94 C 6174.76 5931.54 6183.36 5937.28 6193.39 5941.58 C 6216.32 5953.04 6220.62 5914.34 6236.38 5917.21 C 6240.68 5917.21 6243.55 5918.64 6246.41 5920.08 L 6244.98 5932.98 C 6243.55 5937.28 6242.12 5940.14 6244.98 5941.58 " }
                }
            }
            // PATH visit md count: 155
            DemoShape {
                objectName: "md"
                ShapePath {
                    objectName: "svg_path:md"
                    // boundingRect: 8254.28, 5368.05 515.94x534.916
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 8254.28 5435.67 C 8274.34 5425.64 8287.24 5434.23 8303.01 5447.13 C 8333.1 5468.63 8338.84 5504.46 8363.2 5528.82 C 8403.33 5567.52 8512.25 5636.31 8525.15 5692.2 C 8535.18 5728.03 8522.28 5768.16 8530.88 5803.99 C 8533.75 5819.76 8559.54 5855.59 8558.11 5871.35 C 8558.11 5877.08 8546.65 5878.52 8548.08 5884.25 C 8549.51 5889.98 8558.11 5887.11 8562.41 5889.98 C 8566.71 5892.85 8566.71 5902.88 8572.44 5902.88 C 8579.61 5904.31 8573.88 5887.11 8579.61 5885.68 C 8588.21 5884.25 8596.81 5887.11 8603.97 5885.68 C 8614 5884.25 8592.51 5852.72 8605.41 5832.65 C 8609.71 5826.92 8618.3 5822.62 8624.04 5815.46 C 8631.2 5805.42 8611.14 5799.69 8624.04 5789.66 C 8629.77 5783.93 8639.8 5783.93 8642.67 5778.19 C 8645.53 5772.46 8636.94 5766.73 8636.94 5759.56 C 8636.94 5752.4 8644.1 5745.23 8642.67 5738.07 C 8639.8 5726.6 8603.97 5715.13 8624.04 5692.2 C 8631.2 5683.61 8644.1 5662.11 8649.83 5672.14 C 8652.7 5677.87 8655.57 5685.04 8657 5692.2 C 8657 5695.07 8654.13 5696.5 8654.13 5699.37 C 8655.57 5700.8 8658.43 5702.24 8659.87 5700.8 C 8664.17 5695.07 8662.73 5685.04 8669.9 5679.31 C 8671.33 5676.44 8672.76 5687.9 8675.63 5686.47 C 8681.36 5685.04 8679.93 5676.44 8682.8 5672.14 C 8682.8 5672.14 8701.43 5686.47 8707.16 5687.9 C 8715.76 5689.34 8707.16 5662.11 8715.76 5662.11 C 8727.22 5662.11 8734.39 5689.34 8741.56 5682.17 C 8742.99 5679.31 8741.56 5676.44 8744.42 5673.57 C 8751.59 5667.84 8761.62 5666.41 8770.22 5660.67 C 8770.22 5659.24 8737.26 5654.94 8734.39 5644.91 C 8732.96 5642.04 8741.56 5642.04 8741.56 5639.18 L 8727.22 5594.75 C 8718.63 5587.58 8682.8 5586.15 8674.2 5580.42 C 8668.46 5574.68 8672.76 5551.75 8665.6 5556.05 C 8646.97 5567.52 8679.93 5527.39 8654.13 5513.06 C 8634.07 5501.59 8655.57 5533.12 8638.37 5527.39 C 8629.77 5524.52 8593.94 5498.73 8592.51 5491.56 C 8582.47 5460.03 8605.41 5429.93 8572.44 5408.44 C 8559.54 5401.27 8569.58 5429.93 8555.24 5424.2 C 8520.85 5409.87 8542.35 5381.21 8493.62 5394.11 C 8485.02 5396.97 8490.75 5421.34 8485.02 5415.6 C 8480.72 5411.3 8480.72 5404.14 8476.42 5398.41 C 8473.55 5395.54 8466.39 5417.04 8463.52 5405.57 C 8462.09 5399.84 8469.25 5385.51 8463.52 5386.94 C 8452.06 5388.37 8442.02 5398.41 8431.99 5398.41 C 8427.69 5398.41 8431.99 5388.37 8427.69 5385.51 C 8414.79 5375.47 8397.6 5369.74 8381.83 5368.31 C 8343.14 5365.44 8351.74 5386.94 8324.51 5399.84 C 8321.64 5401.27 8267.18 5408.44 8267.18 5409.87 C 8267.18 5415.6 8274.34 5418.47 8274.34 5424.2 C 8275.78 5429.93 8262.88 5415.6 8258.58 5418.47 C 8252.85 5421.34 8255.71 5429.93 8254.28 5435.67 " }
                }
            }
            // PATH visit ad count: 7
            DemoShape {
                objectName: "ad"
                ShapePath {
                    objectName: "svg_path:ad"
                    // boundingRect: 4995.66, 6660.73 46.2837x38.6574
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5033.96 6695.42 C 4969.46 6714.05 5005.29 6661.02 5008.16 6661.02 C 5045.42 6658.16 5048.29 6676.79 5033.96 6695.42 " }
                }
            }
            // PATH visit mc count: 16
            DemoShape {
                objectName: "mc"
                ShapePath {
                    objectName: "svg_path:mc"
                    // boundingRect: 5753.41, 6504.81 42.995x38.6956
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 5774.9 6543.5 C 5786.37 6543.5 5796.4 6533.47 5796.4 6523.44 C 5796.4 6513.41 5786.37 6504.81 5774.9 6504.81 C 5763.44 6504.81 5753.41 6513.41 5753.41 6523.44 C 5753.41 6533.47 5763.44 6543.5 5774.9 6543.5 C 5786.37 6543.5 5763.44 6543.5 5774.9 6543.5 " }
                }
            }
            // PATH visit li count: 9
            DemoShape {
                objectName: "li"
                ShapePath {
                    objectName: "svg_path:li"
                    // boundingRect: 6117.15, 5875.65 13.1832x32.9627
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 6123.16 5875.65 L 6130.33 5891.41 L 6130.33 5908.61 C 6123.16 5908.61 6118.86 5907.18 6117.43 5907.18 C 6116 5905.75 6120.3 5891.41 6123.16 5875.65 " }
                }
            }
            // PATH visit ru-kgd count: 71
            DemoShape {
                objectName: "ru-kgd"
                ShapePath {
                    objectName: "svg_path:ru-kgd"
                    // boundingRect: 7236.73, 4257.61 342.527x184.111
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 7579.26 4400.92 C 7547.73 4357.93 7577.83 4319.23 7569.23 4304.9 C 7564.93 4299.17 7559.2 4294.87 7553.46 4292 C 7550.6 4290.57 7546.3 4294.87 7544.87 4293.44 C 7539.13 4289.14 7542 4277.67 7536.27 4276.24 C 7516.2 4270.51 7496.14 4289.14 7474.64 4289.14 C 7471.77 4289.14 7476.07 4284.84 7473.21 4283.4 C 7454.58 4277.67 7425.91 4279.1 7408.71 4269.07 C 7404.41 4266.21 7404.41 4259.04 7400.12 4257.61 C 7395.82 4257.61 7394.38 4263.34 7390.08 4264.77 C 7391.52 4269.07 7391.52 4271.94 7390.08 4274.8 C 7388.65 4277.67 7381.48 4273.37 7381.48 4276.24 C 7380.05 4292 7400.12 4306.33 7395.82 4322.1 C 7391.52 4340.73 7315.56 4339.3 7318.43 4330.7 C 7319.86 4327.83 7321.29 4324.97 7322.72 4322.1 C 7306.96 4339.3 7289.76 4336.43 7266.83 4342.16 C 7263.96 4342.16 7259.67 4340.73 7259.67 4343.6 C 7258.23 4355.06 7263.96 4366.53 7263.96 4377.99 C 7263.96 4398.06 7253.93 4419.55 7236.73 4436.75 C 7318.43 4448.22 7511.9 4441.05 7577.83 4402.36 C 7577.83 4402.36 7577.83 4402.36 7579.26 4400.92 M 7357.12 4263.34 C 7357.12 4263.34 7355.69 4263.34 7355.69 4263.34 C 7354.25 4267.64 7351.39 4273.37 7349.95 4277.67 C 7352.82 4273.37 7355.69 4267.64 7357.12 4263.34 " }
                }
            }
            // PATH visit im count: 10
            DemoShape {
                objectName: "im"
                ShapePath {
                    objectName: "svg_path:im"
                    // boundingRect: 4575.97, 4351.37 54.7176x60.3339
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 4630.62 4351.37 C 4623.46 4352.8 4616.29 4352.8 4609.13 4357.1 C 4603.39 4361.4 4601.96 4371.43 4596.23 4377.16 C 4534.6 4433.06 4633.49 4418.73 4630.62 4351.37 " }
                }
            }
            // PATH visit fo count: 26
            DemoShape {
                objectName: "fo"
                ShapePath {
                    objectName: "svg_path:fo"
                    // boundingRect: 4732.49, 2985.47 44.4281x176.62
                    strokeColor: "#aa805d"
                    strokeWidth: 4.58365
                    fillColor: "#fffff7df"
                    fillRule: ShapePath.WindingFill
                    PathSvg { path: "M 4736.79 3126.26 C 4735.36 3139.16 4732.49 3162.09 4732.49 3162.09 C 4732.49 3162.09 4735.36 3139.16 4736.79 3126.26 M 4758.29 2985.81 C 4741.09 3021.64 4765.45 2977.21 4769.75 2998.71 C 4769.75 3001.58 4762.59 3001.58 4762.59 3003.01 C 4765.45 3008.74 4776.92 3007.31 4776.92 3013.04 C 4776.92 3023.07 4774.05 3040.27 4764.02 3040.27 C 4755.42 3038.84 4765.45 3021.64 4764.02 3013.04 C 4759.72 2998.71 4716.72 2982.95 4758.29 2985.81 " }
                }
            }
        } // END countries type: G 1
    } // END Europakarte type: DOC 0
}
