.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XmbResetIC __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XmbResetIC, XwcResetIC, Xutf8ResetIC \- reset the state of an input context
.SH SYNTAX
.HP
char *XmbResetIC\^(\^XIC \fIic\fP\^);
.HP
wchar_t *XwcResetIC\^(\^XIC \fIic\fP\^);
.HP
char *Xutf8ResetIC\^(\^XIC \fIic\fP\^);
.SH ARGUMENTS
.IP \fIic\fP 1i
Specifies the input context.
.SH DESCRIPTION
When
.B XNResetState
is set to
.BR XIMInitialState ,
.BR XmbResetIC ,
.B XwcResetIC
and
.B Xutf8ResetIC
reset an input context to its initial state;
when
.B XNResetState
is set to
.BR XIMPreserveState ,
the current input context state is preserved.
In both cases, any input pending on that context is deleted.
The input method is required to clear the preedit area, if any,
and update the status accordingly.
Calling
.BR XmbResetIC ,
.B XwcResetIC
or
.B Xutf8ResetIC
does not change the focus.
.LP
The return value of
.B XmbResetIC
is its current preedit string as a multibyte string.
The return value of
.B XwcResetIC
is its current preedit string as a wide character string.
The return value of
.B Xutf8ResetIC
is its current preedit string as an UTF-8 string.
If there is any preedit text drawn or visible to the user,
then these procedures must return a non-NULL string.
If there is no visible preedit text,
then it is input method implementation-dependent
whether these procedures return a non-NULL string or NULL.
.LP
The client should free the returned string by calling
.BR XFree .
.LP
The function
.B Xutf8ResetIC
is an extension introduced by The XFree86 Project, Inc., in their 4.0.2
release.
Its presence is
indicated by the macro
.BR X_HAVE_UTF8_STRING .
.SH "SEE ALSO"
XCreateIC(__libmansuffix__),
XOpenIM(__libmansuffix__),
XSetICFocus(__libmansuffix__),
XSetICValues(__libmansuffix__)
.br
\fI\*(xL\fP
