// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'S'.
class PartS {
  /// Applies the STIX Two Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/STIX+Two+Text
  static TextStyle stixTwoText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24ad64547c631567b7ff14ec26ae12d32e541f7111a6b4aed8d1efcd613a8b49',
        190612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84b2e65c8870db1dda4216f8268436d5bf82cf73b8fc9b184044a7452dec3fa3',
        190796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b9f0127eab8b518c2bf1703bfb6bdafc96dc88da217232b3657b978a9f9b462',
        191132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8e2731ac330574464ae7e4e70bf2a572a1b98b7800146a31b55199d9d2b46e5c',
        190920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f549108cb89539ef67015b8b3bd5ca13ecb213a89932fb7b8540d74998def1bf',
        205616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc87f1b58336788fd77092e22ea6a013134fef02788ccb1fc472b8bdb21efebf',
        206312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df543b71b2a5951063a37eed9a18da79d610b00c65bc5856aa6a8dcea441a284',
        206264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66e77740927bd076deb43398326c3675d90eead9b4c02fbb2d301135f330cf99',
        205792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'STIXTwoText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the STIX Two Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/STIX+Two+Text
  static TextTheme stixTwoTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stixTwoText(textStyle: textTheme.displayLarge),
      displayMedium: stixTwoText(textStyle: textTheme.displayMedium),
      displaySmall: stixTwoText(textStyle: textTheme.displaySmall),
      headlineLarge: stixTwoText(textStyle: textTheme.headlineLarge),
      headlineMedium: stixTwoText(textStyle: textTheme.headlineMedium),
      headlineSmall: stixTwoText(textStyle: textTheme.headlineSmall),
      titleLarge: stixTwoText(textStyle: textTheme.titleLarge),
      titleMedium: stixTwoText(textStyle: textTheme.titleMedium),
      titleSmall: stixTwoText(textStyle: textTheme.titleSmall),
      bodyLarge: stixTwoText(textStyle: textTheme.bodyLarge),
      bodyMedium: stixTwoText(textStyle: textTheme.bodyMedium),
      bodySmall: stixTwoText(textStyle: textTheme.bodySmall),
      labelLarge: stixTwoText(textStyle: textTheme.labelLarge),
      labelMedium: stixTwoText(textStyle: textTheme.labelMedium),
      labelSmall: stixTwoText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sacramento font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sacramento
  static TextStyle sacramento({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2ac3b23b9f02037325e0c3bc513c2e27e7435b26bbd8a2c69a3679b7328913a',
        63680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sacramento',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sacramento font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sacramento
  static TextTheme sacramentoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sacramento(textStyle: textTheme.displayLarge),
      displayMedium: sacramento(textStyle: textTheme.displayMedium),
      displaySmall: sacramento(textStyle: textTheme.displaySmall),
      headlineLarge: sacramento(textStyle: textTheme.headlineLarge),
      headlineMedium: sacramento(textStyle: textTheme.headlineMedium),
      headlineSmall: sacramento(textStyle: textTheme.headlineSmall),
      titleLarge: sacramento(textStyle: textTheme.titleLarge),
      titleMedium: sacramento(textStyle: textTheme.titleMedium),
      titleSmall: sacramento(textStyle: textTheme.titleSmall),
      bodyLarge: sacramento(textStyle: textTheme.bodyLarge),
      bodyMedium: sacramento(textStyle: textTheme.bodyMedium),
      bodySmall: sacramento(textStyle: textTheme.bodySmall),
      labelLarge: sacramento(textStyle: textTheme.labelLarge),
      labelMedium: sacramento(textStyle: textTheme.labelMedium),
      labelSmall: sacramento(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sahitya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sahitya
  static TextStyle sahitya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd94bb156ce197b27aa1666405ea700150d9511b1957828fdd58fb878b712244c',
        161600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53b872f5c843e64b39d7628c6a3c7462fc6799af8b32cabacb3c72d377cc8444',
        161516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sahitya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sahitya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sahitya
  static TextTheme sahityaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sahitya(textStyle: textTheme.displayLarge),
      displayMedium: sahitya(textStyle: textTheme.displayMedium),
      displaySmall: sahitya(textStyle: textTheme.displaySmall),
      headlineLarge: sahitya(textStyle: textTheme.headlineLarge),
      headlineMedium: sahitya(textStyle: textTheme.headlineMedium),
      headlineSmall: sahitya(textStyle: textTheme.headlineSmall),
      titleLarge: sahitya(textStyle: textTheme.titleLarge),
      titleMedium: sahitya(textStyle: textTheme.titleMedium),
      titleSmall: sahitya(textStyle: textTheme.titleSmall),
      bodyLarge: sahitya(textStyle: textTheme.bodyLarge),
      bodyMedium: sahitya(textStyle: textTheme.bodyMedium),
      bodySmall: sahitya(textStyle: textTheme.bodySmall),
      labelLarge: sahitya(textStyle: textTheme.labelLarge),
      labelMedium: sahitya(textStyle: textTheme.labelMedium),
      labelSmall: sahitya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sail font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sail
  static TextStyle sail({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0a7f27908ad91eef920c40c5db191c8432b8b59824726eaca2304aae331062b',
        30792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sail',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sail font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sail
  static TextTheme sailTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sail(textStyle: textTheme.displayLarge),
      displayMedium: sail(textStyle: textTheme.displayMedium),
      displaySmall: sail(textStyle: textTheme.displaySmall),
      headlineLarge: sail(textStyle: textTheme.headlineLarge),
      headlineMedium: sail(textStyle: textTheme.headlineMedium),
      headlineSmall: sail(textStyle: textTheme.headlineSmall),
      titleLarge: sail(textStyle: textTheme.titleLarge),
      titleMedium: sail(textStyle: textTheme.titleMedium),
      titleSmall: sail(textStyle: textTheme.titleSmall),
      bodyLarge: sail(textStyle: textTheme.bodyLarge),
      bodyMedium: sail(textStyle: textTheme.bodyMedium),
      bodySmall: sail(textStyle: textTheme.bodySmall),
      labelLarge: sail(textStyle: textTheme.labelLarge),
      labelMedium: sail(textStyle: textTheme.labelMedium),
      labelSmall: sail(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Saira font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira
  static TextStyle saira({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '649b2b9b8ceab01e4825bdcf2c72794f0528b76c94cf37097e93b66434ce257c',
        67872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a225dbb95554dfa907815f9f22896ae3ab5924437ffafe9e78c14edfa37ddc6',
        67984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d5c7b7bbd91df2ce9bbb9331c23d3091bacff50c4f128e268b06be4956176e3',
        68444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0aed0c0dffadd793d7660d5cc2e2df0cddb787389ed195c1dcb2f37872887eeb',
        70292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b91469390b32a0c83f8a1ecdb1ad4410bb90de7d5f4da05795538c9457b46f67',
        70352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04cd6ec416fc3b9d6c733ac919c7aea731fc6f01f79a5ca9e3c4f3b4cfa12792',
        70256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56cb53f8078372e9772c9fc26489d85d2fe2fd4c66e58682175d13ff76ee9f32',
        70172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0febf2956af68c058d6f4ec8c11240ec5ae31f47998e103e09cbdcaca74756db',
        70336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '257c5a99e1066f346722e92f34b191352e70f31f7a5f5c0d9e4d0f34d69fd88e',
        70184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5d0c914d989da69c5085c8896e3f8ded84d90c5863662be8f74dcb4c1954961f',
        71160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e4feb5c44b4bb69ca8ecb620abe2884b7b6f16f60dd5d50d8a1d2562276c4a88',
        71480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9dd557ea6e88c91816c38b3527894db6eb4aa657daa72079b841dee84c526aef',
        72060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e1bd185f7702e1bc213354bea3c0cfe163e9e09801b31f76c5025be2de6e5c78',
        73816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0cbd793a8fcfa4859a13aa3d5661bc76bf67040b21519e8e4649e8c8c87999e4',
        73920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8c54d7255b285f38d00598e7f5564fc2b3a72cb74ff58f3a54aa452bf41c82fc',
        73892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cc1b9f9b1aff0db841554d2f4f317fca275d12819a9319a216038c318dc5299c',
        73752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4b37e4e2636edf3e65db7f98d7eb2a8c6a83e722896bce8df0726a283d890e16',
        73764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9e7d62450ac41dfa188612ecac2c4402291fab4029fa6a8ef5f6fe78e3e598dd',
        73496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Saira',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Saira font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira
  static TextTheme sairaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: saira(textStyle: textTheme.displayLarge),
      displayMedium: saira(textStyle: textTheme.displayMedium),
      displaySmall: saira(textStyle: textTheme.displaySmall),
      headlineLarge: saira(textStyle: textTheme.headlineLarge),
      headlineMedium: saira(textStyle: textTheme.headlineMedium),
      headlineSmall: saira(textStyle: textTheme.headlineSmall),
      titleLarge: saira(textStyle: textTheme.titleLarge),
      titleMedium: saira(textStyle: textTheme.titleMedium),
      titleSmall: saira(textStyle: textTheme.titleSmall),
      bodyLarge: saira(textStyle: textTheme.bodyLarge),
      bodyMedium: saira(textStyle: textTheme.bodyMedium),
      bodySmall: saira(textStyle: textTheme.bodySmall),
      labelLarge: saira(textStyle: textTheme.labelLarge),
      labelMedium: saira(textStyle: textTheme.labelMedium),
      labelSmall: saira(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Saira Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Condensed
  static TextStyle sairaCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bd7c04654439ad4ede16cbe7e25fff807d0a732ce13bbd6d5328c2638b2a2a4',
        57928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e75d42919ca5776d296f39edf46fc23d059279bd5cfdcd319767d34b13dcc667',
        58320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1282a64cb71b9d1fbc9f4d3eb86bc1a92fe708325fe7de4a4cb109d07195ad9a',
        58164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '682a0813bf1a1d5db0a6c2f880ca16529d1053edaac2034cb37dd763fd39f998',
        58252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8007271cdf4b39f28b9b6d13065584286bc9c7d297dd1db90fb07f54941e363b',
        58140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8795e4b23035b87d0a4c585b2ece1f70d70c5893b343f8aa7a64d9751eb10b85',
        58148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd3382129b07316ebd6c13cdcb9f29c5636a9f6a816bf057785a43955ee68d93',
        57916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9801cbd53c79fae6796f33e110eb24e07d9aaa4acf55110ee9062ac46d17f57e',
        57980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40af651a1d26b4eebc37bab6782612d7d64a97117e3fb2496ba635f295fda376',
        57812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SairaCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Saira Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Condensed
  static TextTheme sairaCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sairaCondensed(textStyle: textTheme.displayLarge),
      displayMedium: sairaCondensed(textStyle: textTheme.displayMedium),
      displaySmall: sairaCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: sairaCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: sairaCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: sairaCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: sairaCondensed(textStyle: textTheme.titleLarge),
      titleMedium: sairaCondensed(textStyle: textTheme.titleMedium),
      titleSmall: sairaCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: sairaCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: sairaCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: sairaCondensed(textStyle: textTheme.bodySmall),
      labelLarge: sairaCondensed(textStyle: textTheme.labelLarge),
      labelMedium: sairaCondensed(textStyle: textTheme.labelMedium),
      labelSmall: sairaCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Saira Extra Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Extra+Condensed
  static TextStyle sairaExtraCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3796737faca71cba433ae78ef1f9949d414aed5560ae56bd126ed89e13873ba3',
        57624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e7e85c342c196bb893f124e67c188fea8f417654f6b63c1a0d917b311152b8d',
        58308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18eb0e347c8c9efe661764023e19eaaec0fbc559b1e3a69cd5e3084d5777bdf3',
        58140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7629f2b848bef37b94812b512c24ad3a2770bc41f85d553a5810ca93f2ff6766',
        58032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba128e0d942a7915738d0904da49fd6a50e7f88d8ea5de0b15e8fd8af8cc8a60',
        57976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee35fb27bcffbde7016821897044738ff0d5a218c0aceda9009925c2f500762a',
        58076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ecada2d2537033597e9db104ed111ece665f69dca4b44acdcdca88ad2da5bcf',
        58068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '53c5ff118e29afd0421df65637391a6c2641a809a795743fdfd38474c0b39246',
        58036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd7a76a782ef1d463dd117e62117d5153f53f162c43a893376d7f95831a863f4',
        57748,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SairaExtraCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Saira Extra Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Extra+Condensed
  static TextTheme sairaExtraCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sairaExtraCondensed(textStyle: textTheme.displayLarge),
      displayMedium: sairaExtraCondensed(textStyle: textTheme.displayMedium),
      displaySmall: sairaExtraCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: sairaExtraCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: sairaExtraCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: sairaExtraCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: sairaExtraCondensed(textStyle: textTheme.titleLarge),
      titleMedium: sairaExtraCondensed(textStyle: textTheme.titleMedium),
      titleSmall: sairaExtraCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: sairaExtraCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: sairaExtraCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: sairaExtraCondensed(textStyle: textTheme.bodySmall),
      labelLarge: sairaExtraCondensed(textStyle: textTheme.labelLarge),
      labelMedium: sairaExtraCondensed(textStyle: textTheme.labelMedium),
      labelSmall: sairaExtraCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Saira Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Semi+Condensed
  static TextStyle sairaSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12b86d116b1a729f388443b41403369d8097912bfb3b6dea5d2c4ed8e75808a6',
        58324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4fb32f05984aa99e102e5a54a84f8450ade6cdb57a8fd714161b1459f0f4a15f',
        58784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a81b255cc4d9a13844b0458c33c966fe3fa3c5b0f35df89e4b5d348d88aeceb1',
        58720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe1bf0dec27744124d25c70fb5d658382d09d0de5fadb9efc809b7bb9c252a7c',
        58584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '042c1546d7e62c55d77808e5d1624a299067247d8bfec7e5329e374c1cb2871a',
        58720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6bba233b410727811e9635e0d0f61289c3e7179e71e84c04acd43fe93d06aecf',
        58408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cde5497ee33030c0e7e66738b2ba4bfbbd1562dcb36027e748da934a90303bd5',
        58304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1c5259958b29b58c88b93eb6038c714f08dc90fb4f873f236e7a570790f6a00',
        58308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0966a91881c261457112d717536a87ef2b9435fe9e324f5febdb9c840eba90f5',
        58048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SairaSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Saira Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Semi+Condensed
  static TextTheme sairaSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sairaSemiCondensed(textStyle: textTheme.displayLarge),
      displayMedium: sairaSemiCondensed(textStyle: textTheme.displayMedium),
      displaySmall: sairaSemiCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: sairaSemiCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: sairaSemiCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: sairaSemiCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: sairaSemiCondensed(textStyle: textTheme.titleLarge),
      titleMedium: sairaSemiCondensed(textStyle: textTheme.titleMedium),
      titleSmall: sairaSemiCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: sairaSemiCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: sairaSemiCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: sairaSemiCondensed(textStyle: textTheme.bodySmall),
      labelLarge: sairaSemiCondensed(textStyle: textTheme.labelLarge),
      labelMedium: sairaSemiCondensed(textStyle: textTheme.labelMedium),
      labelSmall: sairaSemiCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Saira Stencil One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Stencil+One
  static TextStyle sairaStencilOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1e3f7ae150fbe7ee82028bd1f61c1cfe28f94350fff5e95246547ecf3b4ec60',
        67460,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SairaStencilOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Saira Stencil One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Saira+Stencil+One
  static TextTheme sairaStencilOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sairaStencilOne(textStyle: textTheme.displayLarge),
      displayMedium: sairaStencilOne(textStyle: textTheme.displayMedium),
      displaySmall: sairaStencilOne(textStyle: textTheme.displaySmall),
      headlineLarge: sairaStencilOne(textStyle: textTheme.headlineLarge),
      headlineMedium: sairaStencilOne(textStyle: textTheme.headlineMedium),
      headlineSmall: sairaStencilOne(textStyle: textTheme.headlineSmall),
      titleLarge: sairaStencilOne(textStyle: textTheme.titleLarge),
      titleMedium: sairaStencilOne(textStyle: textTheme.titleMedium),
      titleSmall: sairaStencilOne(textStyle: textTheme.titleSmall),
      bodyLarge: sairaStencilOne(textStyle: textTheme.bodyLarge),
      bodyMedium: sairaStencilOne(textStyle: textTheme.bodyMedium),
      bodySmall: sairaStencilOne(textStyle: textTheme.bodySmall),
      labelLarge: sairaStencilOne(textStyle: textTheme.labelLarge),
      labelMedium: sairaStencilOne(textStyle: textTheme.labelMedium),
      labelSmall: sairaStencilOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Salsa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Salsa
  static TextStyle salsa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fb67770f4222e83969a94d5a8d7fb60f1aa9f7b06d2ffa9d3d0c3179f378844',
        36324,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Salsa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Salsa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Salsa
  static TextTheme salsaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: salsa(textStyle: textTheme.displayLarge),
      displayMedium: salsa(textStyle: textTheme.displayMedium),
      displaySmall: salsa(textStyle: textTheme.displaySmall),
      headlineLarge: salsa(textStyle: textTheme.headlineLarge),
      headlineMedium: salsa(textStyle: textTheme.headlineMedium),
      headlineSmall: salsa(textStyle: textTheme.headlineSmall),
      titleLarge: salsa(textStyle: textTheme.titleLarge),
      titleMedium: salsa(textStyle: textTheme.titleMedium),
      titleSmall: salsa(textStyle: textTheme.titleSmall),
      bodyLarge: salsa(textStyle: textTheme.bodyLarge),
      bodyMedium: salsa(textStyle: textTheme.bodyMedium),
      bodySmall: salsa(textStyle: textTheme.bodySmall),
      labelLarge: salsa(textStyle: textTheme.labelLarge),
      labelMedium: salsa(textStyle: textTheme.labelMedium),
      labelSmall: salsa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sanchez font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sanchez
  static TextStyle sanchez({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd90194567418af4c0449bdad7900d3a768bd21fbc0e7c8e9ecb501118fd5297',
        62352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '30b6ace343c234d614beb53ac06b226122e73a71ba291af5fac407123dbf34d1',
        68532,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sanchez',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sanchez font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sanchez
  static TextTheme sanchezTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sanchez(textStyle: textTheme.displayLarge),
      displayMedium: sanchez(textStyle: textTheme.displayMedium),
      displaySmall: sanchez(textStyle: textTheme.displaySmall),
      headlineLarge: sanchez(textStyle: textTheme.headlineLarge),
      headlineMedium: sanchez(textStyle: textTheme.headlineMedium),
      headlineSmall: sanchez(textStyle: textTheme.headlineSmall),
      titleLarge: sanchez(textStyle: textTheme.titleLarge),
      titleMedium: sanchez(textStyle: textTheme.titleMedium),
      titleSmall: sanchez(textStyle: textTheme.titleSmall),
      bodyLarge: sanchez(textStyle: textTheme.bodyLarge),
      bodyMedium: sanchez(textStyle: textTheme.bodyMedium),
      bodySmall: sanchez(textStyle: textTheme.bodySmall),
      labelLarge: sanchez(textStyle: textTheme.labelLarge),
      labelMedium: sanchez(textStyle: textTheme.labelMedium),
      labelSmall: sanchez(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sancreek font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sancreek
  static TextStyle sancreek({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84122e9d64b2ef32a1776cecb74996b20f3e4e9eeeeef23742c77de6b472363e',
        47432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sancreek',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sancreek font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sancreek
  static TextTheme sancreekTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sancreek(textStyle: textTheme.displayLarge),
      displayMedium: sancreek(textStyle: textTheme.displayMedium),
      displaySmall: sancreek(textStyle: textTheme.displaySmall),
      headlineLarge: sancreek(textStyle: textTheme.headlineLarge),
      headlineMedium: sancreek(textStyle: textTheme.headlineMedium),
      headlineSmall: sancreek(textStyle: textTheme.headlineSmall),
      titleLarge: sancreek(textStyle: textTheme.titleLarge),
      titleMedium: sancreek(textStyle: textTheme.titleMedium),
      titleSmall: sancreek(textStyle: textTheme.titleSmall),
      bodyLarge: sancreek(textStyle: textTheme.bodyLarge),
      bodyMedium: sancreek(textStyle: textTheme.bodyMedium),
      bodySmall: sancreek(textStyle: textTheme.bodySmall),
      labelLarge: sancreek(textStyle: textTheme.labelLarge),
      labelMedium: sancreek(textStyle: textTheme.labelMedium),
      labelSmall: sancreek(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sansita font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sansita
  static TextStyle sansita({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a959b67ad71f2a1b722f6785111518ea581d0d0d3fdd1033909071c197f8912',
        43160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ffb4711bbae77716ac6eade3817c6f301ade1bee0cffd4ab909a3a53876315dd',
        48212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db2c932f0b94e849053cc974350390cf949bd9df5cebed3a2932ea4ede530964',
        43472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8281fcdba576290501cefdd2bb1b16ab57ccf26c08863371633fd97599fd7bd6',
        48232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec54e4974f3a75fd61d9a6b93557e9d078a74f5c774c8598b9d832bafc4e3ef1',
        43468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2fc1fdb1cdfe0dd6e4cc89f6bf41ec78005b4cb7b215ceed94081d8954b2b75a',
        48176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '322faca404d64944f6c59d324586ac3749a0776ed28aaefd6066812b9c4b8023',
        43768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2172f053e379984a9b862eae2c49a4df1c01757f8d67883a81090d2ae38daafb',
        48916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sansita',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sansita font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sansita
  static TextTheme sansitaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sansita(textStyle: textTheme.displayLarge),
      displayMedium: sansita(textStyle: textTheme.displayMedium),
      displaySmall: sansita(textStyle: textTheme.displaySmall),
      headlineLarge: sansita(textStyle: textTheme.headlineLarge),
      headlineMedium: sansita(textStyle: textTheme.headlineMedium),
      headlineSmall: sansita(textStyle: textTheme.headlineSmall),
      titleLarge: sansita(textStyle: textTheme.titleLarge),
      titleMedium: sansita(textStyle: textTheme.titleMedium),
      titleSmall: sansita(textStyle: textTheme.titleSmall),
      bodyLarge: sansita(textStyle: textTheme.bodyLarge),
      bodyMedium: sansita(textStyle: textTheme.bodyMedium),
      bodySmall: sansita(textStyle: textTheme.bodySmall),
      labelLarge: sansita(textStyle: textTheme.labelLarge),
      labelMedium: sansita(textStyle: textTheme.labelMedium),
      labelSmall: sansita(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sansita Swashed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sansita+Swashed
  static TextStyle sansitaSwashed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b79372a4083382fd753d894edb6d79cf7608c5d929bf33118b1db6ce4455fcd2',
        112152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6bdb514c8a9858e24315291dfb98aef8eb3a5f874d2ba04ed200a175347bb3b2',
        112212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2dd57ec338411ce700ad0257f5c414dc0510ae7622b88fb00de5197f60a66b60',
        112228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e2313bfa6c24d884c319983e869037279e563557167fa7a175abf7640743c87',
        112248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e59b2440c27f9e4d07b83bb92031dbe4be9c6870c6233ca994ad575d1747989',
        112140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce9264528f5987b259fbff0d6a59c0722bd7a68c106e80c49fe67f2aab003e5f',
        112020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd9182e19f7495f4a2beb6b8a5486e3ff0e713b2ed9dec1f381710418fffc79a',
        112172,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SansitaSwashed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sansita Swashed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sansita+Swashed
  static TextTheme sansitaSwashedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sansitaSwashed(textStyle: textTheme.displayLarge),
      displayMedium: sansitaSwashed(textStyle: textTheme.displayMedium),
      displaySmall: sansitaSwashed(textStyle: textTheme.displaySmall),
      headlineLarge: sansitaSwashed(textStyle: textTheme.headlineLarge),
      headlineMedium: sansitaSwashed(textStyle: textTheme.headlineMedium),
      headlineSmall: sansitaSwashed(textStyle: textTheme.headlineSmall),
      titleLarge: sansitaSwashed(textStyle: textTheme.titleLarge),
      titleMedium: sansitaSwashed(textStyle: textTheme.titleMedium),
      titleSmall: sansitaSwashed(textStyle: textTheme.titleSmall),
      bodyLarge: sansitaSwashed(textStyle: textTheme.bodyLarge),
      bodyMedium: sansitaSwashed(textStyle: textTheme.bodyMedium),
      bodySmall: sansitaSwashed(textStyle: textTheme.bodySmall),
      labelLarge: sansitaSwashed(textStyle: textTheme.labelLarge),
      labelMedium: sansitaSwashed(textStyle: textTheme.labelMedium),
      labelSmall: sansitaSwashed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sarabun font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarabun
  static TextStyle sarabun({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8334b59154bf52d2da35c4b147d8cb3095f1c392239b4efe5766a69357f49aa',
        81796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd4c1a397d6404ef2124f602f4cbc6b21a609f886023f1961ba5d4cf8278be102',
        84708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1ab1c07af252e4da2700237f576ef87bcb834838571448ae888e26f248601ab',
        81640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a894af856d5a2cf6320e4b6145b9f2fd72c8d0a321ae5674441e3797a70d573c',
        84708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '90b4f02bbf4be88a48668928688344c21cfc3b4fd6e95aa059110bfe30231593',
        81604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec55f055342ddee7f8e9c6ab1b0c639f1db27132c126331b60cfccd1e5233938',
        84436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '44d9e2aa28d6664bc736a39a68794f8da7b3fe861c9c37cf2ae111bd17416fac',
        81516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9092c7424827de59926a2a7e4198cf8a0c5542d231ee6454c8d9c5903e690cbc',
        84452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '979c6ef064ba5b7c9fb188386ac5ceeeffb5de35311b02bbcd9e2eb801aa1c59',
        81452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c2fa4c9797dee784633b34bf85b7e8c2c64d1197c138cdd8b15e4f1ddee7f63e',
        84484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95878be79373db199477ddcc7a9bf0395abb0fee4f6d62030d32a09075b9012e',
        81328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0320eec903b15616177c6aa1cca78a1e4757a2a3aa7a639ffcb874775fbc91fe',
        84376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0e7b6ad0c9985f2bb3cd16da9f3f0ae8a99739d4640f638b0479034ab3f16d6',
        81028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c7772a96d1e7d282e750485c57f482180f99836d41856aa7ba490314f580911b',
        84068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd37126a39190526c2f66376df026c90a3bb18a704f2702bc758173464c688551',
        81008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'db815816087da79a3b7176aaf2693b4ec0f0ca64af0bdff5cb209012cf94abe0',
        83800,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sarabun',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sarabun font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarabun
  static TextTheme sarabunTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sarabun(textStyle: textTheme.displayLarge),
      displayMedium: sarabun(textStyle: textTheme.displayMedium),
      displaySmall: sarabun(textStyle: textTheme.displaySmall),
      headlineLarge: sarabun(textStyle: textTheme.headlineLarge),
      headlineMedium: sarabun(textStyle: textTheme.headlineMedium),
      headlineSmall: sarabun(textStyle: textTheme.headlineSmall),
      titleLarge: sarabun(textStyle: textTheme.titleLarge),
      titleMedium: sarabun(textStyle: textTheme.titleMedium),
      titleSmall: sarabun(textStyle: textTheme.titleSmall),
      bodyLarge: sarabun(textStyle: textTheme.bodyLarge),
      bodyMedium: sarabun(textStyle: textTheme.bodyMedium),
      bodySmall: sarabun(textStyle: textTheme.bodySmall),
      labelLarge: sarabun(textStyle: textTheme.labelLarge),
      labelMedium: sarabun(textStyle: textTheme.labelMedium),
      labelSmall: sarabun(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sarala font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarala
  static TextStyle sarala({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a8d0d22d2777574f94f919b8fe6ff4e611686aefb3752ac4d9e19d50f592d22',
        143168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c990d46bf92657ba8e23ba521b692f3709ccd3924de4a2f8814a7007756f5b80',
        143504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sarala',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sarala font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarala
  static TextTheme saralaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sarala(textStyle: textTheme.displayLarge),
      displayMedium: sarala(textStyle: textTheme.displayMedium),
      displaySmall: sarala(textStyle: textTheme.displaySmall),
      headlineLarge: sarala(textStyle: textTheme.headlineLarge),
      headlineMedium: sarala(textStyle: textTheme.headlineMedium),
      headlineSmall: sarala(textStyle: textTheme.headlineSmall),
      titleLarge: sarala(textStyle: textTheme.titleLarge),
      titleMedium: sarala(textStyle: textTheme.titleMedium),
      titleSmall: sarala(textStyle: textTheme.titleSmall),
      bodyLarge: sarala(textStyle: textTheme.bodyLarge),
      bodyMedium: sarala(textStyle: textTheme.bodyMedium),
      bodySmall: sarala(textStyle: textTheme.bodySmall),
      labelLarge: sarala(textStyle: textTheme.labelLarge),
      labelMedium: sarala(textStyle: textTheme.labelMedium),
      labelSmall: sarala(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sarina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarina
  static TextStyle sarina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ccc4eef9941094e91bef1121c17517cb37e71c58b3e06c87cc8655ed9338178d',
        91928,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sarina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sarina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarina
  static TextTheme sarinaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sarina(textStyle: textTheme.displayLarge),
      displayMedium: sarina(textStyle: textTheme.displayMedium),
      displaySmall: sarina(textStyle: textTheme.displaySmall),
      headlineLarge: sarina(textStyle: textTheme.headlineLarge),
      headlineMedium: sarina(textStyle: textTheme.headlineMedium),
      headlineSmall: sarina(textStyle: textTheme.headlineSmall),
      titleLarge: sarina(textStyle: textTheme.titleLarge),
      titleMedium: sarina(textStyle: textTheme.titleMedium),
      titleSmall: sarina(textStyle: textTheme.titleSmall),
      bodyLarge: sarina(textStyle: textTheme.bodyLarge),
      bodyMedium: sarina(textStyle: textTheme.bodyMedium),
      bodySmall: sarina(textStyle: textTheme.bodySmall),
      labelLarge: sarina(textStyle: textTheme.labelLarge),
      labelMedium: sarina(textStyle: textTheme.labelMedium),
      labelSmall: sarina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sarpanch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarpanch
  static TextStyle sarpanch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a383066d3e766dac679685a5aa66e51718c200d68a9a0b6ac208a4653ff63a7',
        166584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f254dfabdc514a278d5bdc14a215c17ec000f5d03fb4b602d08777c19d395cf0',
        166152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8f302b320a0a1508322bfc63071de745162311af6996e0f2c1598e0d4bd584d',
        165904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec9b5d4a697bded96d7d3c7e0fe738bb00c89d95783eec84d13dc4d1ca86df4b',
        166700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de319074f78bbaba1c9005c07d0ff2311cba0ab024b8db84c0df89f76048ff33',
        175188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1574260168910861f0a73811b4c5dac0e050a031a05c0af3e075366f6f26e779',
        176452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sarpanch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sarpanch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sarpanch
  static TextTheme sarpanchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sarpanch(textStyle: textTheme.displayLarge),
      displayMedium: sarpanch(textStyle: textTheme.displayMedium),
      displaySmall: sarpanch(textStyle: textTheme.displaySmall),
      headlineLarge: sarpanch(textStyle: textTheme.headlineLarge),
      headlineMedium: sarpanch(textStyle: textTheme.headlineMedium),
      headlineSmall: sarpanch(textStyle: textTheme.headlineSmall),
      titleLarge: sarpanch(textStyle: textTheme.titleLarge),
      titleMedium: sarpanch(textStyle: textTheme.titleMedium),
      titleSmall: sarpanch(textStyle: textTheme.titleSmall),
      bodyLarge: sarpanch(textStyle: textTheme.bodyLarge),
      bodyMedium: sarpanch(textStyle: textTheme.bodyMedium),
      bodySmall: sarpanch(textStyle: textTheme.bodySmall),
      labelLarge: sarpanch(textStyle: textTheme.labelLarge),
      labelMedium: sarpanch(textStyle: textTheme.labelMedium),
      labelSmall: sarpanch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sassy Frass font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sassy+Frass
  static TextStyle sassyFrass({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '561ef5c7d178bb18f50a92a66a1960ed41a28865b5b83d167ec5916f2f06b722',
        107652,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SassyFrass',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sassy Frass font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sassy+Frass
  static TextTheme sassyFrassTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sassyFrass(textStyle: textTheme.displayLarge),
      displayMedium: sassyFrass(textStyle: textTheme.displayMedium),
      displaySmall: sassyFrass(textStyle: textTheme.displaySmall),
      headlineLarge: sassyFrass(textStyle: textTheme.headlineLarge),
      headlineMedium: sassyFrass(textStyle: textTheme.headlineMedium),
      headlineSmall: sassyFrass(textStyle: textTheme.headlineSmall),
      titleLarge: sassyFrass(textStyle: textTheme.titleLarge),
      titleMedium: sassyFrass(textStyle: textTheme.titleMedium),
      titleSmall: sassyFrass(textStyle: textTheme.titleSmall),
      bodyLarge: sassyFrass(textStyle: textTheme.bodyLarge),
      bodyMedium: sassyFrass(textStyle: textTheme.bodyMedium),
      bodySmall: sassyFrass(textStyle: textTheme.bodySmall),
      labelLarge: sassyFrass(textStyle: textTheme.labelLarge),
      labelMedium: sassyFrass(textStyle: textTheme.labelMedium),
      labelSmall: sassyFrass(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Satisfy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Satisfy
  static TextStyle satisfy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd98327d778226876040d49ac2b062424c0a46bb26ae14e2a3e286a94e1de5cc9',
        46204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Satisfy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Satisfy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Satisfy
  static TextTheme satisfyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: satisfy(textStyle: textTheme.displayLarge),
      displayMedium: satisfy(textStyle: textTheme.displayMedium),
      displaySmall: satisfy(textStyle: textTheme.displaySmall),
      headlineLarge: satisfy(textStyle: textTheme.headlineLarge),
      headlineMedium: satisfy(textStyle: textTheme.headlineMedium),
      headlineSmall: satisfy(textStyle: textTheme.headlineSmall),
      titleLarge: satisfy(textStyle: textTheme.titleLarge),
      titleMedium: satisfy(textStyle: textTheme.titleMedium),
      titleSmall: satisfy(textStyle: textTheme.titleSmall),
      bodyLarge: satisfy(textStyle: textTheme.bodyLarge),
      bodyMedium: satisfy(textStyle: textTheme.bodyMedium),
      bodySmall: satisfy(textStyle: textTheme.bodySmall),
      labelLarge: satisfy(textStyle: textTheme.labelLarge),
      labelMedium: satisfy(textStyle: textTheme.labelMedium),
      labelSmall: satisfy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sawarabi Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sawarabi+Gothic
  static TextStyle sawarabiGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8766618d8ebd731de5aeef48dbc61dc7f017c52d5fedd521c1fd2376c2f920ee',
        1895872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SawarabiGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sawarabi Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sawarabi+Gothic
  static TextTheme sawarabiGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sawarabiGothic(textStyle: textTheme.displayLarge),
      displayMedium: sawarabiGothic(textStyle: textTheme.displayMedium),
      displaySmall: sawarabiGothic(textStyle: textTheme.displaySmall),
      headlineLarge: sawarabiGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: sawarabiGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: sawarabiGothic(textStyle: textTheme.headlineSmall),
      titleLarge: sawarabiGothic(textStyle: textTheme.titleLarge),
      titleMedium: sawarabiGothic(textStyle: textTheme.titleMedium),
      titleSmall: sawarabiGothic(textStyle: textTheme.titleSmall),
      bodyLarge: sawarabiGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: sawarabiGothic(textStyle: textTheme.bodyMedium),
      bodySmall: sawarabiGothic(textStyle: textTheme.bodySmall),
      labelLarge: sawarabiGothic(textStyle: textTheme.labelLarge),
      labelMedium: sawarabiGothic(textStyle: textTheme.labelMedium),
      labelSmall: sawarabiGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sawarabi Mincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sawarabi+Mincho
  static TextStyle sawarabiMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9d85674ac4ee2cac13e1321f35867e410d14bacbf8d0c799b678da5ca5b545d',
        1081468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SawarabiMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sawarabi Mincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sawarabi+Mincho
  static TextTheme sawarabiMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sawarabiMincho(textStyle: textTheme.displayLarge),
      displayMedium: sawarabiMincho(textStyle: textTheme.displayMedium),
      displaySmall: sawarabiMincho(textStyle: textTheme.displaySmall),
      headlineLarge: sawarabiMincho(textStyle: textTheme.headlineLarge),
      headlineMedium: sawarabiMincho(textStyle: textTheme.headlineMedium),
      headlineSmall: sawarabiMincho(textStyle: textTheme.headlineSmall),
      titleLarge: sawarabiMincho(textStyle: textTheme.titleLarge),
      titleMedium: sawarabiMincho(textStyle: textTheme.titleMedium),
      titleSmall: sawarabiMincho(textStyle: textTheme.titleSmall),
      bodyLarge: sawarabiMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: sawarabiMincho(textStyle: textTheme.bodyMedium),
      bodySmall: sawarabiMincho(textStyle: textTheme.bodySmall),
      labelLarge: sawarabiMincho(textStyle: textTheme.labelLarge),
      labelMedium: sawarabiMincho(textStyle: textTheme.labelMedium),
      labelSmall: sawarabiMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Scada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Scada
  static TextStyle scada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0a4ddd37d6cc2b29de39f85bb504dc24c608c5eec3b03cd0a7b9cedd3e1308f',
        52588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1dbeadc29e5bf5700c83a5ace7e630cbbe45dc6499d8dfe14c23988bb520e95c',
        55920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '592e8f8debba6f5876fd616256c90d0154c4c0403cd8a547bcec72d73f6d351f',
        52692,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '33f0a5e13fb9907ddac4f6da6792da848d009b809bc9a5a4bf102bcbb12c1261',
        55964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Scada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Scada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Scada
  static TextTheme scadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: scada(textStyle: textTheme.displayLarge),
      displayMedium: scada(textStyle: textTheme.displayMedium),
      displaySmall: scada(textStyle: textTheme.displaySmall),
      headlineLarge: scada(textStyle: textTheme.headlineLarge),
      headlineMedium: scada(textStyle: textTheme.headlineMedium),
      headlineSmall: scada(textStyle: textTheme.headlineSmall),
      titleLarge: scada(textStyle: textTheme.titleLarge),
      titleMedium: scada(textStyle: textTheme.titleMedium),
      titleSmall: scada(textStyle: textTheme.titleSmall),
      bodyLarge: scada(textStyle: textTheme.bodyLarge),
      bodyMedium: scada(textStyle: textTheme.bodyMedium),
      bodySmall: scada(textStyle: textTheme.bodySmall),
      labelLarge: scada(textStyle: textTheme.labelLarge),
      labelMedium: scada(textStyle: textTheme.labelMedium),
      labelSmall: scada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Scheherazade New font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Scheherazade+New
  static TextStyle scheherazadeNew({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18d699ca4092b34d3e5bbb9829aec0f0d883029b1bf0266d475fb0be52ba664c',
        249924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e45a367ba2c7e2770f852c1e4699aa8198d07f363a6ff5cfaa2c1325b538a60',
        499736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aab7e603105a4135c8851abbc950e7e0e1cf1593895506307a880ce98eb100ce',
        506820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5268fd0d8a752010dae3f9e5c5dae552d0b9f69162e5e4f224d2074cb5a85279',
        509036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ScheherazadeNew',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Scheherazade New font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Scheherazade+New
  static TextTheme scheherazadeNewTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: scheherazadeNew(textStyle: textTheme.displayLarge),
      displayMedium: scheherazadeNew(textStyle: textTheme.displayMedium),
      displaySmall: scheherazadeNew(textStyle: textTheme.displaySmall),
      headlineLarge: scheherazadeNew(textStyle: textTheme.headlineLarge),
      headlineMedium: scheherazadeNew(textStyle: textTheme.headlineMedium),
      headlineSmall: scheherazadeNew(textStyle: textTheme.headlineSmall),
      titleLarge: scheherazadeNew(textStyle: textTheme.titleLarge),
      titleMedium: scheherazadeNew(textStyle: textTheme.titleMedium),
      titleSmall: scheherazadeNew(textStyle: textTheme.titleSmall),
      bodyLarge: scheherazadeNew(textStyle: textTheme.bodyLarge),
      bodyMedium: scheherazadeNew(textStyle: textTheme.bodyMedium),
      bodySmall: scheherazadeNew(textStyle: textTheme.bodySmall),
      labelLarge: scheherazadeNew(textStyle: textTheme.labelLarge),
      labelMedium: scheherazadeNew(textStyle: textTheme.labelMedium),
      labelSmall: scheherazadeNew(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Schibsted Grotesk font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Schibsted+Grotesk
  static TextStyle schibstedGrotesk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09a1a39be79004733f325515885f23f890f3a6ad06d1f95127f97189ff82480c',
        93912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75868d47ee68e5b32025909e2affb58ff91273d07f7c6a57b327ebf65ce90eec',
        94200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d40cd1652eb022eedd33000783a1ca4020e55d37d27b9597e14249542c1ec3c',
        94320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9219880e7a0857dc57f3771136480a36bb27c9d57b911ada62571a5d5472a1c',
        94356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '502104e28f052b41f056f05692251aebe5ae67a3b1e763c07209a23fef4d23d2',
        94672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc8dacdb9c44e81fb4f22063764720a7b186e6c8ac422f41f719ac97ccaf1d23',
        94568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '99cd989b834aaa0863f03d13465529f2c164ff648226bd708178c90226073799',
        95752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '165ef072109c8bfe89eabd1c18fb9bc68f56ea952b776552abbc8e5c5a691f46',
        96312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ffcfa8edafad843c5dc7c3b2d16ae639e5cf509a1d541ee244f6a6cdcf31bed8',
        96440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd137c20b780adb6935999b0882306bf137905d615756a4c59da98610f47af300',
        96376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e37cb51fe17049fe41ac6b532300ddfb6d697fd6d55ec9c858d38cee1e152d09',
        96756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7315066684a85daad79ea4f19ed60416d0959570fc141714449ac6038f6a6beb',
        96504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SchibstedGrotesk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Schibsted Grotesk font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Schibsted+Grotesk
  static TextTheme schibstedGroteskTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: schibstedGrotesk(textStyle: textTheme.displayLarge),
      displayMedium: schibstedGrotesk(textStyle: textTheme.displayMedium),
      displaySmall: schibstedGrotesk(textStyle: textTheme.displaySmall),
      headlineLarge: schibstedGrotesk(textStyle: textTheme.headlineLarge),
      headlineMedium: schibstedGrotesk(textStyle: textTheme.headlineMedium),
      headlineSmall: schibstedGrotesk(textStyle: textTheme.headlineSmall),
      titleLarge: schibstedGrotesk(textStyle: textTheme.titleLarge),
      titleMedium: schibstedGrotesk(textStyle: textTheme.titleMedium),
      titleSmall: schibstedGrotesk(textStyle: textTheme.titleSmall),
      bodyLarge: schibstedGrotesk(textStyle: textTheme.bodyLarge),
      bodyMedium: schibstedGrotesk(textStyle: textTheme.bodyMedium),
      bodySmall: schibstedGrotesk(textStyle: textTheme.bodySmall),
      labelLarge: schibstedGrotesk(textStyle: textTheme.labelLarge),
      labelMedium: schibstedGrotesk(textStyle: textTheme.labelMedium),
      labelSmall: schibstedGrotesk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Schoolbell font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Schoolbell
  static TextStyle schoolbell({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6801a0d08960dc1c7662d57e95d870b60f7655aaa9940c94d1d9eda6be6f33f',
        47164,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Schoolbell',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Schoolbell font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Schoolbell
  static TextTheme schoolbellTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: schoolbell(textStyle: textTheme.displayLarge),
      displayMedium: schoolbell(textStyle: textTheme.displayMedium),
      displaySmall: schoolbell(textStyle: textTheme.displaySmall),
      headlineLarge: schoolbell(textStyle: textTheme.headlineLarge),
      headlineMedium: schoolbell(textStyle: textTheme.headlineMedium),
      headlineSmall: schoolbell(textStyle: textTheme.headlineSmall),
      titleLarge: schoolbell(textStyle: textTheme.titleLarge),
      titleMedium: schoolbell(textStyle: textTheme.titleMedium),
      titleSmall: schoolbell(textStyle: textTheme.titleSmall),
      bodyLarge: schoolbell(textStyle: textTheme.bodyLarge),
      bodyMedium: schoolbell(textStyle: textTheme.bodyMedium),
      bodySmall: schoolbell(textStyle: textTheme.bodySmall),
      labelLarge: schoolbell(textStyle: textTheme.labelLarge),
      labelMedium: schoolbell(textStyle: textTheme.labelMedium),
      labelSmall: schoolbell(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Scope One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Scope+One
  static TextStyle scopeOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '612b27ecd6e63baf3daaf8d7461071aebcf9724312240c4be55a9495eec81fb8',
        60168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ScopeOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Scope One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Scope+One
  static TextTheme scopeOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: scopeOne(textStyle: textTheme.displayLarge),
      displayMedium: scopeOne(textStyle: textTheme.displayMedium),
      displaySmall: scopeOne(textStyle: textTheme.displaySmall),
      headlineLarge: scopeOne(textStyle: textTheme.headlineLarge),
      headlineMedium: scopeOne(textStyle: textTheme.headlineMedium),
      headlineSmall: scopeOne(textStyle: textTheme.headlineSmall),
      titleLarge: scopeOne(textStyle: textTheme.titleLarge),
      titleMedium: scopeOne(textStyle: textTheme.titleMedium),
      titleSmall: scopeOne(textStyle: textTheme.titleSmall),
      bodyLarge: scopeOne(textStyle: textTheme.bodyLarge),
      bodyMedium: scopeOne(textStyle: textTheme.bodyMedium),
      bodySmall: scopeOne(textStyle: textTheme.bodySmall),
      labelLarge: scopeOne(textStyle: textTheme.labelLarge),
      labelMedium: scopeOne(textStyle: textTheme.labelMedium),
      labelSmall: scopeOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Seaweed Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Seaweed+Script
  static TextStyle seaweedScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16ff037485a95d43bd8143c484828fcd478171aa24d1e31f3b4a50a5566596c4',
        114804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SeaweedScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Seaweed Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Seaweed+Script
  static TextTheme seaweedScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: seaweedScript(textStyle: textTheme.displayLarge),
      displayMedium: seaweedScript(textStyle: textTheme.displayMedium),
      displaySmall: seaweedScript(textStyle: textTheme.displaySmall),
      headlineLarge: seaweedScript(textStyle: textTheme.headlineLarge),
      headlineMedium: seaweedScript(textStyle: textTheme.headlineMedium),
      headlineSmall: seaweedScript(textStyle: textTheme.headlineSmall),
      titleLarge: seaweedScript(textStyle: textTheme.titleLarge),
      titleMedium: seaweedScript(textStyle: textTheme.titleMedium),
      titleSmall: seaweedScript(textStyle: textTheme.titleSmall),
      bodyLarge: seaweedScript(textStyle: textTheme.bodyLarge),
      bodyMedium: seaweedScript(textStyle: textTheme.bodyMedium),
      bodySmall: seaweedScript(textStyle: textTheme.bodySmall),
      labelLarge: seaweedScript(textStyle: textTheme.labelLarge),
      labelMedium: seaweedScript(textStyle: textTheme.labelMedium),
      labelSmall: seaweedScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Secular One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Secular+One
  static TextStyle secularOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2ffaeec800d20af9ae34f84c4bbfe6eec3b2a8251cb5edadfa837ee814fcccd',
        58144,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SecularOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Secular One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Secular+One
  static TextTheme secularOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: secularOne(textStyle: textTheme.displayLarge),
      displayMedium: secularOne(textStyle: textTheme.displayMedium),
      displaySmall: secularOne(textStyle: textTheme.displaySmall),
      headlineLarge: secularOne(textStyle: textTheme.headlineLarge),
      headlineMedium: secularOne(textStyle: textTheme.headlineMedium),
      headlineSmall: secularOne(textStyle: textTheme.headlineSmall),
      titleLarge: secularOne(textStyle: textTheme.titleLarge),
      titleMedium: secularOne(textStyle: textTheme.titleMedium),
      titleSmall: secularOne(textStyle: textTheme.titleSmall),
      bodyLarge: secularOne(textStyle: textTheme.bodyLarge),
      bodyMedium: secularOne(textStyle: textTheme.bodyMedium),
      bodySmall: secularOne(textStyle: textTheme.bodySmall),
      labelLarge: secularOne(textStyle: textTheme.labelLarge),
      labelMedium: secularOne(textStyle: textTheme.labelMedium),
      labelSmall: secularOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sedgwick Ave font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sedgwick+Ave
  static TextStyle sedgwickAve({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b20adb11d2faba4a6d663ea5cf1b6d963329b9fede0c069ea4d92395283f558f',
        88740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SedgwickAve',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sedgwick Ave font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sedgwick+Ave
  static TextTheme sedgwickAveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sedgwickAve(textStyle: textTheme.displayLarge),
      displayMedium: sedgwickAve(textStyle: textTheme.displayMedium),
      displaySmall: sedgwickAve(textStyle: textTheme.displaySmall),
      headlineLarge: sedgwickAve(textStyle: textTheme.headlineLarge),
      headlineMedium: sedgwickAve(textStyle: textTheme.headlineMedium),
      headlineSmall: sedgwickAve(textStyle: textTheme.headlineSmall),
      titleLarge: sedgwickAve(textStyle: textTheme.titleLarge),
      titleMedium: sedgwickAve(textStyle: textTheme.titleMedium),
      titleSmall: sedgwickAve(textStyle: textTheme.titleSmall),
      bodyLarge: sedgwickAve(textStyle: textTheme.bodyLarge),
      bodyMedium: sedgwickAve(textStyle: textTheme.bodyMedium),
      bodySmall: sedgwickAve(textStyle: textTheme.bodySmall),
      labelLarge: sedgwickAve(textStyle: textTheme.labelLarge),
      labelMedium: sedgwickAve(textStyle: textTheme.labelMedium),
      labelSmall: sedgwickAve(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sedgwick Ave Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sedgwick+Ave+Display
  static TextStyle sedgwickAveDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4537f6fcc9824700ff844df8629942ca81fd8eeeb3537415fc080f48d9601614',
        85088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SedgwickAveDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sedgwick Ave Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sedgwick+Ave+Display
  static TextTheme sedgwickAveDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sedgwickAveDisplay(textStyle: textTheme.displayLarge),
      displayMedium: sedgwickAveDisplay(textStyle: textTheme.displayMedium),
      displaySmall: sedgwickAveDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: sedgwickAveDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: sedgwickAveDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: sedgwickAveDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: sedgwickAveDisplay(textStyle: textTheme.titleLarge),
      titleMedium: sedgwickAveDisplay(textStyle: textTheme.titleMedium),
      titleSmall: sedgwickAveDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: sedgwickAveDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: sedgwickAveDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: sedgwickAveDisplay(textStyle: textTheme.bodySmall),
      labelLarge: sedgwickAveDisplay(textStyle: textTheme.labelLarge),
      labelMedium: sedgwickAveDisplay(textStyle: textTheme.labelMedium),
      labelSmall: sedgwickAveDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sen
  static TextStyle sen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd50da5fc4027aacbaa93340c6e44827ee193c583efef700a8108fd6171229e5',
        33260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43bca19043e32335a3ec5e07957e819182bcd8d215499a5b7545ff933237ad43',
        33368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cbc91606b8dea6525e66327f11ecb3ec6e16a42ba0d4e9d9f0c6f82362c3345',
        33376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff56b97890eba89b6add288a965687b31d95dd5012365801a66f64b7686fc033',
        33256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5afb0a4e7ea1a9cb55868eae3e1bb0f89299bc0310738fd3a7a8cfbb22a4f084',
        33248,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sen
  static TextTheme senTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sen(textStyle: textTheme.displayLarge),
      displayMedium: sen(textStyle: textTheme.displayMedium),
      displaySmall: sen(textStyle: textTheme.displaySmall),
      headlineLarge: sen(textStyle: textTheme.headlineLarge),
      headlineMedium: sen(textStyle: textTheme.headlineMedium),
      headlineSmall: sen(textStyle: textTheme.headlineSmall),
      titleLarge: sen(textStyle: textTheme.titleLarge),
      titleMedium: sen(textStyle: textTheme.titleMedium),
      titleSmall: sen(textStyle: textTheme.titleSmall),
      bodyLarge: sen(textStyle: textTheme.bodyLarge),
      bodyMedium: sen(textStyle: textTheme.bodyMedium),
      bodySmall: sen(textStyle: textTheme.bodySmall),
      labelLarge: sen(textStyle: textTheme.labelLarge),
      labelMedium: sen(textStyle: textTheme.labelMedium),
      labelSmall: sen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Send Flowers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Send+Flowers
  static TextStyle sendFlowers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da3df3966e034bef668f3b905997ca6368975480e58760e5cebe59789a689d60',
        78684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SendFlowers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Send Flowers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Send+Flowers
  static TextTheme sendFlowersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sendFlowers(textStyle: textTheme.displayLarge),
      displayMedium: sendFlowers(textStyle: textTheme.displayMedium),
      displaySmall: sendFlowers(textStyle: textTheme.displaySmall),
      headlineLarge: sendFlowers(textStyle: textTheme.headlineLarge),
      headlineMedium: sendFlowers(textStyle: textTheme.headlineMedium),
      headlineSmall: sendFlowers(textStyle: textTheme.headlineSmall),
      titleLarge: sendFlowers(textStyle: textTheme.titleLarge),
      titleMedium: sendFlowers(textStyle: textTheme.titleMedium),
      titleSmall: sendFlowers(textStyle: textTheme.titleSmall),
      bodyLarge: sendFlowers(textStyle: textTheme.bodyLarge),
      bodyMedium: sendFlowers(textStyle: textTheme.bodyMedium),
      bodySmall: sendFlowers(textStyle: textTheme.bodySmall),
      labelLarge: sendFlowers(textStyle: textTheme.labelLarge),
      labelMedium: sendFlowers(textStyle: textTheme.labelMedium),
      labelSmall: sendFlowers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sevillana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sevillana
  static TextStyle sevillana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd92238a431ac7fdcabf10322adc2cc8e47d436420f067a70e0eef6420ee6be7a',
        40908,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sevillana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sevillana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sevillana
  static TextTheme sevillanaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sevillana(textStyle: textTheme.displayLarge),
      displayMedium: sevillana(textStyle: textTheme.displayMedium),
      displaySmall: sevillana(textStyle: textTheme.displaySmall),
      headlineLarge: sevillana(textStyle: textTheme.headlineLarge),
      headlineMedium: sevillana(textStyle: textTheme.headlineMedium),
      headlineSmall: sevillana(textStyle: textTheme.headlineSmall),
      titleLarge: sevillana(textStyle: textTheme.titleLarge),
      titleMedium: sevillana(textStyle: textTheme.titleMedium),
      titleSmall: sevillana(textStyle: textTheme.titleSmall),
      bodyLarge: sevillana(textStyle: textTheme.bodyLarge),
      bodyMedium: sevillana(textStyle: textTheme.bodyMedium),
      bodySmall: sevillana(textStyle: textTheme.bodySmall),
      labelLarge: sevillana(textStyle: textTheme.labelLarge),
      labelMedium: sevillana(textStyle: textTheme.labelMedium),
      labelSmall: sevillana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Seymour One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Seymour+One
  static TextStyle seymourOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eabc3ca108ed6f87ad349831622e9383205a1656dec4c6e939e4734c998618b5',
        59476,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SeymourOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Seymour One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Seymour+One
  static TextTheme seymourOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: seymourOne(textStyle: textTheme.displayLarge),
      displayMedium: seymourOne(textStyle: textTheme.displayMedium),
      displaySmall: seymourOne(textStyle: textTheme.displaySmall),
      headlineLarge: seymourOne(textStyle: textTheme.headlineLarge),
      headlineMedium: seymourOne(textStyle: textTheme.headlineMedium),
      headlineSmall: seymourOne(textStyle: textTheme.headlineSmall),
      titleLarge: seymourOne(textStyle: textTheme.titleLarge),
      titleMedium: seymourOne(textStyle: textTheme.titleMedium),
      titleSmall: seymourOne(textStyle: textTheme.titleSmall),
      bodyLarge: seymourOne(textStyle: textTheme.bodyLarge),
      bodyMedium: seymourOne(textStyle: textTheme.bodyMedium),
      bodySmall: seymourOne(textStyle: textTheme.bodySmall),
      labelLarge: seymourOne(textStyle: textTheme.labelLarge),
      labelMedium: seymourOne(textStyle: textTheme.labelMedium),
      labelSmall: seymourOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shadows Into Light font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shadows+Into+Light
  static TextStyle shadowsIntoLight({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e2c2b4ab9c801f7fed23823e007ce15b21662848ff75725cb905dbe11f4eede',
        39060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShadowsIntoLight',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shadows Into Light font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shadows+Into+Light
  static TextTheme shadowsIntoLightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shadowsIntoLight(textStyle: textTheme.displayLarge),
      displayMedium: shadowsIntoLight(textStyle: textTheme.displayMedium),
      displaySmall: shadowsIntoLight(textStyle: textTheme.displaySmall),
      headlineLarge: shadowsIntoLight(textStyle: textTheme.headlineLarge),
      headlineMedium: shadowsIntoLight(textStyle: textTheme.headlineMedium),
      headlineSmall: shadowsIntoLight(textStyle: textTheme.headlineSmall),
      titleLarge: shadowsIntoLight(textStyle: textTheme.titleLarge),
      titleMedium: shadowsIntoLight(textStyle: textTheme.titleMedium),
      titleSmall: shadowsIntoLight(textStyle: textTheme.titleSmall),
      bodyLarge: shadowsIntoLight(textStyle: textTheme.bodyLarge),
      bodyMedium: shadowsIntoLight(textStyle: textTheme.bodyMedium),
      bodySmall: shadowsIntoLight(textStyle: textTheme.bodySmall),
      labelLarge: shadowsIntoLight(textStyle: textTheme.labelLarge),
      labelMedium: shadowsIntoLight(textStyle: textTheme.labelMedium),
      labelSmall: shadowsIntoLight(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shadows Into Light Two font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shadows+Into+Light+Two
  static TextStyle shadowsIntoLightTwo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '331b1017f8041b5207c82dd31af64f198c82fdfa740fdd10ba9c342d1668206e',
        33896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShadowsIntoLightTwo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shadows Into Light Two font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shadows+Into+Light+Two
  static TextTheme shadowsIntoLightTwoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shadowsIntoLightTwo(textStyle: textTheme.displayLarge),
      displayMedium: shadowsIntoLightTwo(textStyle: textTheme.displayMedium),
      displaySmall: shadowsIntoLightTwo(textStyle: textTheme.displaySmall),
      headlineLarge: shadowsIntoLightTwo(textStyle: textTheme.headlineLarge),
      headlineMedium: shadowsIntoLightTwo(textStyle: textTheme.headlineMedium),
      headlineSmall: shadowsIntoLightTwo(textStyle: textTheme.headlineSmall),
      titleLarge: shadowsIntoLightTwo(textStyle: textTheme.titleLarge),
      titleMedium: shadowsIntoLightTwo(textStyle: textTheme.titleMedium),
      titleSmall: shadowsIntoLightTwo(textStyle: textTheme.titleSmall),
      bodyLarge: shadowsIntoLightTwo(textStyle: textTheme.bodyLarge),
      bodyMedium: shadowsIntoLightTwo(textStyle: textTheme.bodyMedium),
      bodySmall: shadowsIntoLightTwo(textStyle: textTheme.bodySmall),
      labelLarge: shadowsIntoLightTwo(textStyle: textTheme.labelLarge),
      labelMedium: shadowsIntoLightTwo(textStyle: textTheme.labelMedium),
      labelSmall: shadowsIntoLightTwo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shalimar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shalimar
  static TextStyle shalimar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '093fc58abd56c8f2d938769376be623176ec782b74201973b5668fcdadebbed1',
        86356,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Shalimar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shalimar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shalimar
  static TextTheme shalimarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shalimar(textStyle: textTheme.displayLarge),
      displayMedium: shalimar(textStyle: textTheme.displayMedium),
      displaySmall: shalimar(textStyle: textTheme.displaySmall),
      headlineLarge: shalimar(textStyle: textTheme.headlineLarge),
      headlineMedium: shalimar(textStyle: textTheme.headlineMedium),
      headlineSmall: shalimar(textStyle: textTheme.headlineSmall),
      titleLarge: shalimar(textStyle: textTheme.titleLarge),
      titleMedium: shalimar(textStyle: textTheme.titleMedium),
      titleSmall: shalimar(textStyle: textTheme.titleSmall),
      bodyLarge: shalimar(textStyle: textTheme.bodyLarge),
      bodyMedium: shalimar(textStyle: textTheme.bodyMedium),
      bodySmall: shalimar(textStyle: textTheme.bodySmall),
      labelLarge: shalimar(textStyle: textTheme.labelLarge),
      labelMedium: shalimar(textStyle: textTheme.labelMedium),
      labelSmall: shalimar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shantell Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shantell+Sans
  static TextStyle shantellSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc60c55c891306bf15c932167a4c7011b3716849be776c661f5bb07924232b56',
        390836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5826cb6b3467d97f2b0764caa7127a4c47ea9c476461f90079b957c0fc11f828',
        391104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f823ae8224606e9cae450d538c7f497728c83da3511432efae99cb8686f4c8cc',
        391276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1aad5ddc12e5dcef7caab8d87d40dbbdd2e4e42175158d49029a20cdc646872',
        391328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e903d465cdeaafe7f1f1b35711229eeea424a565468eb1770515cfbdd8ba5c52',
        391204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f20594d6617c8996ea16198c35ce4e9327bfa8e0a7c7e05f985e6ec571e92e1d',
        390664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9335425fdddc651cd5dd90a886841bd496ba68d780c0fea55ddd6fa8d419e8f8',
        400664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0595c30e9b545260bd8058915946f144d3cdfce339ea37e6eb3f14cd611d2647',
        401240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e05a3233f44d0b85b26a790845875639df2df6426ad9f6567e4be2f487bd0e94',
        401476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd1d6be97b88e28bf09b2b418573671eebf16a83516382b61847a8d1bc3e131c4',
        401496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f0fa381b21be3b6e42d6d2e37f5e5c8cc1679c6a12b5e842e734f5f97210b984',
        401428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e7850f59404079d1d22688fcc4272555e22c62bea63f56293f94f40f31f452b',
        400844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShantellSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shantell Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shantell+Sans
  static TextTheme shantellSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shantellSans(textStyle: textTheme.displayLarge),
      displayMedium: shantellSans(textStyle: textTheme.displayMedium),
      displaySmall: shantellSans(textStyle: textTheme.displaySmall),
      headlineLarge: shantellSans(textStyle: textTheme.headlineLarge),
      headlineMedium: shantellSans(textStyle: textTheme.headlineMedium),
      headlineSmall: shantellSans(textStyle: textTheme.headlineSmall),
      titleLarge: shantellSans(textStyle: textTheme.titleLarge),
      titleMedium: shantellSans(textStyle: textTheme.titleMedium),
      titleSmall: shantellSans(textStyle: textTheme.titleSmall),
      bodyLarge: shantellSans(textStyle: textTheme.bodyLarge),
      bodyMedium: shantellSans(textStyle: textTheme.bodyMedium),
      bodySmall: shantellSans(textStyle: textTheme.bodySmall),
      labelLarge: shantellSans(textStyle: textTheme.labelLarge),
      labelMedium: shantellSans(textStyle: textTheme.labelMedium),
      labelSmall: shantellSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shanti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shanti
  static TextStyle shanti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1231602535f6e8b0ca0962780fbc1c75afb5b28b23122391ed290e452f808179',
        47636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Shanti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shanti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shanti
  static TextTheme shantiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shanti(textStyle: textTheme.displayLarge),
      displayMedium: shanti(textStyle: textTheme.displayMedium),
      displaySmall: shanti(textStyle: textTheme.displaySmall),
      headlineLarge: shanti(textStyle: textTheme.headlineLarge),
      headlineMedium: shanti(textStyle: textTheme.headlineMedium),
      headlineSmall: shanti(textStyle: textTheme.headlineSmall),
      titleLarge: shanti(textStyle: textTheme.titleLarge),
      titleMedium: shanti(textStyle: textTheme.titleMedium),
      titleSmall: shanti(textStyle: textTheme.titleSmall),
      bodyLarge: shanti(textStyle: textTheme.bodyLarge),
      bodyMedium: shanti(textStyle: textTheme.bodyMedium),
      bodySmall: shanti(textStyle: textTheme.bodySmall),
      labelLarge: shanti(textStyle: textTheme.labelLarge),
      labelMedium: shanti(textStyle: textTheme.labelMedium),
      labelSmall: shanti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Share font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Share
  static TextStyle share({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '52ed75cf487be12b5ad5fd388efb9fcc02e963f0d69b67f27de8c41d6a34d1c0',
        36888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9bbf214fc0d0317b48a614ffc4d7b52e797a314a1783b95a1a48c19603f2ec25',
        38984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bfb0bddbc5f65585c4ff1d5ac0ac5ce481e6bbe9c51742b9b516e7eea93de47',
        36920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '617437259bb30f12e95ef6fcc26bcedbebda009b352c21dd3c0dd770c720a862',
        39016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Share',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Share font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Share
  static TextTheme shareTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: share(textStyle: textTheme.displayLarge),
      displayMedium: share(textStyle: textTheme.displayMedium),
      displaySmall: share(textStyle: textTheme.displaySmall),
      headlineLarge: share(textStyle: textTheme.headlineLarge),
      headlineMedium: share(textStyle: textTheme.headlineMedium),
      headlineSmall: share(textStyle: textTheme.headlineSmall),
      titleLarge: share(textStyle: textTheme.titleLarge),
      titleMedium: share(textStyle: textTheme.titleMedium),
      titleSmall: share(textStyle: textTheme.titleSmall),
      bodyLarge: share(textStyle: textTheme.bodyLarge),
      bodyMedium: share(textStyle: textTheme.bodyMedium),
      bodySmall: share(textStyle: textTheme.bodySmall),
      labelLarge: share(textStyle: textTheme.labelLarge),
      labelMedium: share(textStyle: textTheme.labelMedium),
      labelSmall: share(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Share Tech font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Share+Tech
  static TextStyle shareTech({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c30486519130cc6fa97ffbc9304817a78db442114600dc90de4454247a1d5c02',
        27964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShareTech',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Share Tech font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Share+Tech
  static TextTheme shareTechTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shareTech(textStyle: textTheme.displayLarge),
      displayMedium: shareTech(textStyle: textTheme.displayMedium),
      displaySmall: shareTech(textStyle: textTheme.displaySmall),
      headlineLarge: shareTech(textStyle: textTheme.headlineLarge),
      headlineMedium: shareTech(textStyle: textTheme.headlineMedium),
      headlineSmall: shareTech(textStyle: textTheme.headlineSmall),
      titleLarge: shareTech(textStyle: textTheme.titleLarge),
      titleMedium: shareTech(textStyle: textTheme.titleMedium),
      titleSmall: shareTech(textStyle: textTheme.titleSmall),
      bodyLarge: shareTech(textStyle: textTheme.bodyLarge),
      bodyMedium: shareTech(textStyle: textTheme.bodyMedium),
      bodySmall: shareTech(textStyle: textTheme.bodySmall),
      labelLarge: shareTech(textStyle: textTheme.labelLarge),
      labelMedium: shareTech(textStyle: textTheme.labelMedium),
      labelSmall: shareTech(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Share Tech Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Share+Tech+Mono
  static TextStyle shareTechMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3e100fbddc4352440e6b9a95f20f790cb0a2ec70d837703141831266b223819',
        24416,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShareTechMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Share Tech Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Share+Tech+Mono
  static TextTheme shareTechMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shareTechMono(textStyle: textTheme.displayLarge),
      displayMedium: shareTechMono(textStyle: textTheme.displayMedium),
      displaySmall: shareTechMono(textStyle: textTheme.displaySmall),
      headlineLarge: shareTechMono(textStyle: textTheme.headlineLarge),
      headlineMedium: shareTechMono(textStyle: textTheme.headlineMedium),
      headlineSmall: shareTechMono(textStyle: textTheme.headlineSmall),
      titleLarge: shareTechMono(textStyle: textTheme.titleLarge),
      titleMedium: shareTechMono(textStyle: textTheme.titleMedium),
      titleSmall: shareTechMono(textStyle: textTheme.titleSmall),
      bodyLarge: shareTechMono(textStyle: textTheme.bodyLarge),
      bodyMedium: shareTechMono(textStyle: textTheme.bodyMedium),
      bodySmall: shareTechMono(textStyle: textTheme.bodySmall),
      labelLarge: shareTechMono(textStyle: textTheme.labelLarge),
      labelMedium: shareTechMono(textStyle: textTheme.labelMedium),
      labelSmall: shareTechMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shippori Antique font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Antique
  static TextStyle shipporiAntique({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93226821bd2ca02cb4f7ad7ac5c88c2bcd3b14bc6ddc208a49914e87e8617520',
        7125988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShipporiAntique',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shippori Antique font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Antique
  static TextTheme shipporiAntiqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shipporiAntique(textStyle: textTheme.displayLarge),
      displayMedium: shipporiAntique(textStyle: textTheme.displayMedium),
      displaySmall: shipporiAntique(textStyle: textTheme.displaySmall),
      headlineLarge: shipporiAntique(textStyle: textTheme.headlineLarge),
      headlineMedium: shipporiAntique(textStyle: textTheme.headlineMedium),
      headlineSmall: shipporiAntique(textStyle: textTheme.headlineSmall),
      titleLarge: shipporiAntique(textStyle: textTheme.titleLarge),
      titleMedium: shipporiAntique(textStyle: textTheme.titleMedium),
      titleSmall: shipporiAntique(textStyle: textTheme.titleSmall),
      bodyLarge: shipporiAntique(textStyle: textTheme.bodyLarge),
      bodyMedium: shipporiAntique(textStyle: textTheme.bodyMedium),
      bodySmall: shipporiAntique(textStyle: textTheme.bodySmall),
      labelLarge: shipporiAntique(textStyle: textTheme.labelLarge),
      labelMedium: shipporiAntique(textStyle: textTheme.labelMedium),
      labelSmall: shipporiAntique(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shippori Antique B1 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Antique+B1
  static TextStyle shipporiAntiqueB1({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca51f4fae60e42b71f7ee64d4a549754ab7430b5aa1ee5ca01be845457f9c6e6',
        12631180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShipporiAntiqueB1',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shippori Antique B1 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Antique+B1
  static TextTheme shipporiAntiqueB1TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shipporiAntiqueB1(textStyle: textTheme.displayLarge),
      displayMedium: shipporiAntiqueB1(textStyle: textTheme.displayMedium),
      displaySmall: shipporiAntiqueB1(textStyle: textTheme.displaySmall),
      headlineLarge: shipporiAntiqueB1(textStyle: textTheme.headlineLarge),
      headlineMedium: shipporiAntiqueB1(textStyle: textTheme.headlineMedium),
      headlineSmall: shipporiAntiqueB1(textStyle: textTheme.headlineSmall),
      titleLarge: shipporiAntiqueB1(textStyle: textTheme.titleLarge),
      titleMedium: shipporiAntiqueB1(textStyle: textTheme.titleMedium),
      titleSmall: shipporiAntiqueB1(textStyle: textTheme.titleSmall),
      bodyLarge: shipporiAntiqueB1(textStyle: textTheme.bodyLarge),
      bodyMedium: shipporiAntiqueB1(textStyle: textTheme.bodyMedium),
      bodySmall: shipporiAntiqueB1(textStyle: textTheme.bodySmall),
      labelLarge: shipporiAntiqueB1(textStyle: textTheme.labelLarge),
      labelMedium: shipporiAntiqueB1(textStyle: textTheme.labelMedium),
      labelSmall: shipporiAntiqueB1(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shippori Mincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Mincho
  static TextStyle shipporiMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b388b1e4f361a5d2f28fd51f45778ad3013024bb69e364b8e38d866a572fe020',
        8344160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7012b5083cc105bab2c3d31c39cdaa99c83f4cecd7005ffca4ced10c107029ef',
        8346164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05827bcff67cad9082048707a04ca26c42cfa066e623446f300ad1440ee39051',
        8316944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1227ef55365f4c64418ba4c593946d307a2431f072b72694219e8dfa254c5ce0',
        8234712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32422702a316877b8169557f0757ee8784f3a7b2f0a9321bd78d991a1978188f',
        8233708,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShipporiMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shippori Mincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Mincho
  static TextTheme shipporiMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shipporiMincho(textStyle: textTheme.displayLarge),
      displayMedium: shipporiMincho(textStyle: textTheme.displayMedium),
      displaySmall: shipporiMincho(textStyle: textTheme.displaySmall),
      headlineLarge: shipporiMincho(textStyle: textTheme.headlineLarge),
      headlineMedium: shipporiMincho(textStyle: textTheme.headlineMedium),
      headlineSmall: shipporiMincho(textStyle: textTheme.headlineSmall),
      titleLarge: shipporiMincho(textStyle: textTheme.titleLarge),
      titleMedium: shipporiMincho(textStyle: textTheme.titleMedium),
      titleSmall: shipporiMincho(textStyle: textTheme.titleSmall),
      bodyLarge: shipporiMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: shipporiMincho(textStyle: textTheme.bodyMedium),
      bodySmall: shipporiMincho(textStyle: textTheme.bodySmall),
      labelLarge: shipporiMincho(textStyle: textTheme.labelLarge),
      labelMedium: shipporiMincho(textStyle: textTheme.labelMedium),
      labelSmall: shipporiMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shippori Mincho B1 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Mincho+B1
  static TextStyle shipporiMinchoB1({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8aed9724c306466df739dbbbbaa89e97035bf5638ce8d85fb47aad1e4c13efc',
        14675264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04d73583edb1d34361fad0c5761dfe2fe9b8b3c7806073c0c0aa45dfc3c873e7',
        14632744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '927031078b00435e608894c9227acd44680a5b5e78a617cfc26f01e4f0482986',
        14606932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4bd711bed8a5ccbf26beeb90e1c3ac8e12a7b0bf447ffc1cb850a55807643617',
        14539612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28a22fae7746b04e3d6f66407442a8c6f94f85ae30464006e7b8a2387b9e99cf',
        14538400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShipporiMinchoB1',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shippori Mincho B1 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shippori+Mincho+B1
  static TextTheme shipporiMinchoB1TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shipporiMinchoB1(textStyle: textTheme.displayLarge),
      displayMedium: shipporiMinchoB1(textStyle: textTheme.displayMedium),
      displaySmall: shipporiMinchoB1(textStyle: textTheme.displaySmall),
      headlineLarge: shipporiMinchoB1(textStyle: textTheme.headlineLarge),
      headlineMedium: shipporiMinchoB1(textStyle: textTheme.headlineMedium),
      headlineSmall: shipporiMinchoB1(textStyle: textTheme.headlineSmall),
      titleLarge: shipporiMinchoB1(textStyle: textTheme.titleLarge),
      titleMedium: shipporiMinchoB1(textStyle: textTheme.titleMedium),
      titleSmall: shipporiMinchoB1(textStyle: textTheme.titleSmall),
      bodyLarge: shipporiMinchoB1(textStyle: textTheme.bodyLarge),
      bodyMedium: shipporiMinchoB1(textStyle: textTheme.bodyMedium),
      bodySmall: shipporiMinchoB1(textStyle: textTheme.bodySmall),
      labelLarge: shipporiMinchoB1(textStyle: textTheme.labelLarge),
      labelMedium: shipporiMinchoB1(textStyle: textTheme.labelMedium),
      labelSmall: shipporiMinchoB1(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shizuru font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shizuru
  static TextStyle shizuru({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9572fb5d220b7b01dbdfaefda8a8c1f50fbed2a865a81cf66c743af23cd22340',
        250660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Shizuru',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shizuru font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shizuru
  static TextTheme shizuruTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shizuru(textStyle: textTheme.displayLarge),
      displayMedium: shizuru(textStyle: textTheme.displayMedium),
      displaySmall: shizuru(textStyle: textTheme.displaySmall),
      headlineLarge: shizuru(textStyle: textTheme.headlineLarge),
      headlineMedium: shizuru(textStyle: textTheme.headlineMedium),
      headlineSmall: shizuru(textStyle: textTheme.headlineSmall),
      titleLarge: shizuru(textStyle: textTheme.titleLarge),
      titleMedium: shizuru(textStyle: textTheme.titleMedium),
      titleSmall: shizuru(textStyle: textTheme.titleSmall),
      bodyLarge: shizuru(textStyle: textTheme.bodyLarge),
      bodyMedium: shizuru(textStyle: textTheme.bodyMedium),
      bodySmall: shizuru(textStyle: textTheme.bodySmall),
      labelLarge: shizuru(textStyle: textTheme.labelLarge),
      labelMedium: shizuru(textStyle: textTheme.labelMedium),
      labelSmall: shizuru(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shojumaru font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shojumaru
  static TextStyle shojumaru({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ec9e735e703b541d8bd58a84e0d704f2667356d222d7d29429837c87036d4b1',
        68804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Shojumaru',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shojumaru font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shojumaru
  static TextTheme shojumaruTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shojumaru(textStyle: textTheme.displayLarge),
      displayMedium: shojumaru(textStyle: textTheme.displayMedium),
      displaySmall: shojumaru(textStyle: textTheme.displaySmall),
      headlineLarge: shojumaru(textStyle: textTheme.headlineLarge),
      headlineMedium: shojumaru(textStyle: textTheme.headlineMedium),
      headlineSmall: shojumaru(textStyle: textTheme.headlineSmall),
      titleLarge: shojumaru(textStyle: textTheme.titleLarge),
      titleMedium: shojumaru(textStyle: textTheme.titleMedium),
      titleSmall: shojumaru(textStyle: textTheme.titleSmall),
      bodyLarge: shojumaru(textStyle: textTheme.bodyLarge),
      bodyMedium: shojumaru(textStyle: textTheme.bodyMedium),
      bodySmall: shojumaru(textStyle: textTheme.bodySmall),
      labelLarge: shojumaru(textStyle: textTheme.labelLarge),
      labelMedium: shojumaru(textStyle: textTheme.labelMedium),
      labelSmall: shojumaru(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Short Stack font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Short+Stack
  static TextStyle shortStack({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2161ac0afc2dacc6241432686edcd5e70f34f0e8e42527ea67b5a4fc7d0ace3',
        62808,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ShortStack',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Short Stack font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Short+Stack
  static TextTheme shortStackTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shortStack(textStyle: textTheme.displayLarge),
      displayMedium: shortStack(textStyle: textTheme.displayMedium),
      displaySmall: shortStack(textStyle: textTheme.displaySmall),
      headlineLarge: shortStack(textStyle: textTheme.headlineLarge),
      headlineMedium: shortStack(textStyle: textTheme.headlineMedium),
      headlineSmall: shortStack(textStyle: textTheme.headlineSmall),
      titleLarge: shortStack(textStyle: textTheme.titleLarge),
      titleMedium: shortStack(textStyle: textTheme.titleMedium),
      titleSmall: shortStack(textStyle: textTheme.titleSmall),
      bodyLarge: shortStack(textStyle: textTheme.bodyLarge),
      bodyMedium: shortStack(textStyle: textTheme.bodyMedium),
      bodySmall: shortStack(textStyle: textTheme.bodySmall),
      labelLarge: shortStack(textStyle: textTheme.labelLarge),
      labelMedium: shortStack(textStyle: textTheme.labelMedium),
      labelSmall: shortStack(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Shrikhand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shrikhand
  static TextStyle shrikhand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a25a23bfc75826f532af68d3b70a9bf4757b22813197d9e16b3cd92263437335',
        212744,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Shrikhand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Shrikhand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Shrikhand
  static TextTheme shrikhandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: shrikhand(textStyle: textTheme.displayLarge),
      displayMedium: shrikhand(textStyle: textTheme.displayMedium),
      displaySmall: shrikhand(textStyle: textTheme.displaySmall),
      headlineLarge: shrikhand(textStyle: textTheme.headlineLarge),
      headlineMedium: shrikhand(textStyle: textTheme.headlineMedium),
      headlineSmall: shrikhand(textStyle: textTheme.headlineSmall),
      titleLarge: shrikhand(textStyle: textTheme.titleLarge),
      titleMedium: shrikhand(textStyle: textTheme.titleMedium),
      titleSmall: shrikhand(textStyle: textTheme.titleSmall),
      bodyLarge: shrikhand(textStyle: textTheme.bodyLarge),
      bodyMedium: shrikhand(textStyle: textTheme.bodyMedium),
      bodySmall: shrikhand(textStyle: textTheme.bodySmall),
      labelLarge: shrikhand(textStyle: textTheme.labelLarge),
      labelMedium: shrikhand(textStyle: textTheme.labelMedium),
      labelSmall: shrikhand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Siemreap font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Siemreap
  static TextStyle siemreap({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b8048e0b74f39fd7a4de93ba979d39fa95b169e9aa11ead21c9532765301fd6',
        166160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Siemreap',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Siemreap font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Siemreap
  static TextTheme siemreapTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: siemreap(textStyle: textTheme.displayLarge),
      displayMedium: siemreap(textStyle: textTheme.displayMedium),
      displaySmall: siemreap(textStyle: textTheme.displaySmall),
      headlineLarge: siemreap(textStyle: textTheme.headlineLarge),
      headlineMedium: siemreap(textStyle: textTheme.headlineMedium),
      headlineSmall: siemreap(textStyle: textTheme.headlineSmall),
      titleLarge: siemreap(textStyle: textTheme.titleLarge),
      titleMedium: siemreap(textStyle: textTheme.titleMedium),
      titleSmall: siemreap(textStyle: textTheme.titleSmall),
      bodyLarge: siemreap(textStyle: textTheme.bodyLarge),
      bodyMedium: siemreap(textStyle: textTheme.bodyMedium),
      bodySmall: siemreap(textStyle: textTheme.bodySmall),
      labelLarge: siemreap(textStyle: textTheme.labelLarge),
      labelMedium: siemreap(textStyle: textTheme.labelMedium),
      labelSmall: siemreap(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sigmar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sigmar
  static TextStyle sigmar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f7139d76fabf0db3e67aa7c95f954f96c36aa85bb3167c7a3ebc0377679f8f7',
        112892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sigmar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sigmar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sigmar
  static TextTheme sigmarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sigmar(textStyle: textTheme.displayLarge),
      displayMedium: sigmar(textStyle: textTheme.displayMedium),
      displaySmall: sigmar(textStyle: textTheme.displaySmall),
      headlineLarge: sigmar(textStyle: textTheme.headlineLarge),
      headlineMedium: sigmar(textStyle: textTheme.headlineMedium),
      headlineSmall: sigmar(textStyle: textTheme.headlineSmall),
      titleLarge: sigmar(textStyle: textTheme.titleLarge),
      titleMedium: sigmar(textStyle: textTheme.titleMedium),
      titleSmall: sigmar(textStyle: textTheme.titleSmall),
      bodyLarge: sigmar(textStyle: textTheme.bodyLarge),
      bodyMedium: sigmar(textStyle: textTheme.bodyMedium),
      bodySmall: sigmar(textStyle: textTheme.bodySmall),
      labelLarge: sigmar(textStyle: textTheme.labelLarge),
      labelMedium: sigmar(textStyle: textTheme.labelMedium),
      labelSmall: sigmar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sigmar One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sigmar+One
  static TextStyle sigmarOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c0d44850e40f2c1a3678b05da980102c138327e7d4909634a06bcbbee152288',
        103600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SigmarOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sigmar One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sigmar+One
  static TextTheme sigmarOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sigmarOne(textStyle: textTheme.displayLarge),
      displayMedium: sigmarOne(textStyle: textTheme.displayMedium),
      displaySmall: sigmarOne(textStyle: textTheme.displaySmall),
      headlineLarge: sigmarOne(textStyle: textTheme.headlineLarge),
      headlineMedium: sigmarOne(textStyle: textTheme.headlineMedium),
      headlineSmall: sigmarOne(textStyle: textTheme.headlineSmall),
      titleLarge: sigmarOne(textStyle: textTheme.titleLarge),
      titleMedium: sigmarOne(textStyle: textTheme.titleMedium),
      titleSmall: sigmarOne(textStyle: textTheme.titleSmall),
      bodyLarge: sigmarOne(textStyle: textTheme.bodyLarge),
      bodyMedium: sigmarOne(textStyle: textTheme.bodyMedium),
      bodySmall: sigmarOne(textStyle: textTheme.bodySmall),
      labelLarge: sigmarOne(textStyle: textTheme.labelLarge),
      labelMedium: sigmarOne(textStyle: textTheme.labelMedium),
      labelSmall: sigmarOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Signika font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Signika
  static TextStyle signika({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e718cdcf0b510646d863d0ab696aa3bd63dadbe29adbb9b8c08305dcdbf696bd',
        198408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c8890b6e5c1a184a287802958dba0c1cb281dc81bcec065f69cffc62349a21b',
        198472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c78d623364d4ffae69a25beb2ee116d4de47417d1856a48e704413bfeff3c08',
        198548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2e211bbc6eb6bbaa4d904aeff2670b6a509586724ae3623d8fd5a6af772ad05',
        198592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05dce205933b37a64059b169e3f5a454c74d20512f4bc4d444a3a1aca7cd6d5b',
        198580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Signika',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Signika font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Signika
  static TextTheme signikaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: signika(textStyle: textTheme.displayLarge),
      displayMedium: signika(textStyle: textTheme.displayMedium),
      displaySmall: signika(textStyle: textTheme.displaySmall),
      headlineLarge: signika(textStyle: textTheme.headlineLarge),
      headlineMedium: signika(textStyle: textTheme.headlineMedium),
      headlineSmall: signika(textStyle: textTheme.headlineSmall),
      titleLarge: signika(textStyle: textTheme.titleLarge),
      titleMedium: signika(textStyle: textTheme.titleMedium),
      titleSmall: signika(textStyle: textTheme.titleSmall),
      bodyLarge: signika(textStyle: textTheme.bodyLarge),
      bodyMedium: signika(textStyle: textTheme.bodyMedium),
      bodySmall: signika(textStyle: textTheme.bodySmall),
      labelLarge: signika(textStyle: textTheme.labelLarge),
      labelMedium: signika(textStyle: textTheme.labelMedium),
      labelSmall: signika(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Signika Negative font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Signika+Negative
  static TextStyle signikaNegative({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '762a478e98f11ececa445a1bb692cd1b3c2e3b294209a9958e3d14796816919b',
        191416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8110557eabc5404fff1b93e3208a6136dc6843cb101ee41c544b4d9b6b07cd6a',
        191744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89f9d74eb6f05182b73439d64ccdee294e52cf667c19ecb288f1dc246ceffdd6',
        191868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1140264c2fc554f45aba0f8960909258248d1c21eabf492d059afecdc9a4cc5',
        191844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca9937dd45708dbf40511e9eeed9197d4d6728bb8e48f20260728744eec2a7bd',
        191888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SignikaNegative',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Signika Negative font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Signika+Negative
  static TextTheme signikaNegativeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: signikaNegative(textStyle: textTheme.displayLarge),
      displayMedium: signikaNegative(textStyle: textTheme.displayMedium),
      displaySmall: signikaNegative(textStyle: textTheme.displaySmall),
      headlineLarge: signikaNegative(textStyle: textTheme.headlineLarge),
      headlineMedium: signikaNegative(textStyle: textTheme.headlineMedium),
      headlineSmall: signikaNegative(textStyle: textTheme.headlineSmall),
      titleLarge: signikaNegative(textStyle: textTheme.titleLarge),
      titleMedium: signikaNegative(textStyle: textTheme.titleMedium),
      titleSmall: signikaNegative(textStyle: textTheme.titleSmall),
      bodyLarge: signikaNegative(textStyle: textTheme.bodyLarge),
      bodyMedium: signikaNegative(textStyle: textTheme.bodyMedium),
      bodySmall: signikaNegative(textStyle: textTheme.bodySmall),
      labelLarge: signikaNegative(textStyle: textTheme.labelLarge),
      labelMedium: signikaNegative(textStyle: textTheme.labelMedium),
      labelSmall: signikaNegative(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Silkscreen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Silkscreen
  static TextStyle silkscreen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17b84a70fa9cae36dccca54c23a449c3d06dc913c141e7d4a6be5a00fb3a9b23',
        15324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5aeeddec9af6597394bbeea02f45b937b4e6d06c436881cec0abdc507099992a',
        14328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Silkscreen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Silkscreen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Silkscreen
  static TextTheme silkscreenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: silkscreen(textStyle: textTheme.displayLarge),
      displayMedium: silkscreen(textStyle: textTheme.displayMedium),
      displaySmall: silkscreen(textStyle: textTheme.displaySmall),
      headlineLarge: silkscreen(textStyle: textTheme.headlineLarge),
      headlineMedium: silkscreen(textStyle: textTheme.headlineMedium),
      headlineSmall: silkscreen(textStyle: textTheme.headlineSmall),
      titleLarge: silkscreen(textStyle: textTheme.titleLarge),
      titleMedium: silkscreen(textStyle: textTheme.titleMedium),
      titleSmall: silkscreen(textStyle: textTheme.titleSmall),
      bodyLarge: silkscreen(textStyle: textTheme.bodyLarge),
      bodyMedium: silkscreen(textStyle: textTheme.bodyMedium),
      bodySmall: silkscreen(textStyle: textTheme.bodySmall),
      labelLarge: silkscreen(textStyle: textTheme.labelLarge),
      labelMedium: silkscreen(textStyle: textTheme.labelMedium),
      labelSmall: silkscreen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Simonetta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Simonetta
  static TextStyle simonetta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e31e16a2e96c354d0faf2ae4372767ff50ec43539d336eb8fb6cacc3c0a93bee',
        32668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '73694b0a49993e86d781d0a1f83e7dbdb8a3ae5cc0bf2d470c72e23d88a4606a',
        29980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f4ca5b79d82756d0225b6cbeb872886a12142bca49138e0fc2dae8b54abb86c',
        44084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c2b4d9e78085949edd3a436d233a73878cdba439568a455ec9135692207b19d3',
        45400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Simonetta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Simonetta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Simonetta
  static TextTheme simonettaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: simonetta(textStyle: textTheme.displayLarge),
      displayMedium: simonetta(textStyle: textTheme.displayMedium),
      displaySmall: simonetta(textStyle: textTheme.displaySmall),
      headlineLarge: simonetta(textStyle: textTheme.headlineLarge),
      headlineMedium: simonetta(textStyle: textTheme.headlineMedium),
      headlineSmall: simonetta(textStyle: textTheme.headlineSmall),
      titleLarge: simonetta(textStyle: textTheme.titleLarge),
      titleMedium: simonetta(textStyle: textTheme.titleMedium),
      titleSmall: simonetta(textStyle: textTheme.titleSmall),
      bodyLarge: simonetta(textStyle: textTheme.bodyLarge),
      bodyMedium: simonetta(textStyle: textTheme.bodyMedium),
      bodySmall: simonetta(textStyle: textTheme.bodySmall),
      labelLarge: simonetta(textStyle: textTheme.labelLarge),
      labelMedium: simonetta(textStyle: textTheme.labelMedium),
      labelSmall: simonetta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Single Day font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Single+Day
  static TextStyle singleDay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6215cf1e8fe70e0e9052edc2c67c86744e2e8ec3e449f31b478828aab80f5bd6',
        638168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SingleDay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Single Day font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Single+Day
  static TextTheme singleDayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: singleDay(textStyle: textTheme.displayLarge),
      displayMedium: singleDay(textStyle: textTheme.displayMedium),
      displaySmall: singleDay(textStyle: textTheme.displaySmall),
      headlineLarge: singleDay(textStyle: textTheme.headlineLarge),
      headlineMedium: singleDay(textStyle: textTheme.headlineMedium),
      headlineSmall: singleDay(textStyle: textTheme.headlineSmall),
      titleLarge: singleDay(textStyle: textTheme.titleLarge),
      titleMedium: singleDay(textStyle: textTheme.titleMedium),
      titleSmall: singleDay(textStyle: textTheme.titleSmall),
      bodyLarge: singleDay(textStyle: textTheme.bodyLarge),
      bodyMedium: singleDay(textStyle: textTheme.bodyMedium),
      bodySmall: singleDay(textStyle: textTheme.bodySmall),
      labelLarge: singleDay(textStyle: textTheme.labelLarge),
      labelMedium: singleDay(textStyle: textTheme.labelMedium),
      labelSmall: singleDay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sintony font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sintony
  static TextStyle sintony({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b56be9bceebd830e6b9edfabff30aea2979e57922d921713b3755d2f64c8b1f1',
        23740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a18db5e3ec2272549b10c4b0272720d9e690ce734fcc58efd999d727fad2d49',
        23540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sintony',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sintony font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sintony
  static TextTheme sintonyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sintony(textStyle: textTheme.displayLarge),
      displayMedium: sintony(textStyle: textTheme.displayMedium),
      displaySmall: sintony(textStyle: textTheme.displaySmall),
      headlineLarge: sintony(textStyle: textTheme.headlineLarge),
      headlineMedium: sintony(textStyle: textTheme.headlineMedium),
      headlineSmall: sintony(textStyle: textTheme.headlineSmall),
      titleLarge: sintony(textStyle: textTheme.titleLarge),
      titleMedium: sintony(textStyle: textTheme.titleMedium),
      titleSmall: sintony(textStyle: textTheme.titleSmall),
      bodyLarge: sintony(textStyle: textTheme.bodyLarge),
      bodyMedium: sintony(textStyle: textTheme.bodyMedium),
      bodySmall: sintony(textStyle: textTheme.bodySmall),
      labelLarge: sintony(textStyle: textTheme.labelLarge),
      labelMedium: sintony(textStyle: textTheme.labelMedium),
      labelSmall: sintony(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sirin Stencil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sirin+Stencil
  static TextStyle sirinStencil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '777be07b0e23790c535d8618a8ede73802dbce2349546b00b7735057e61c25cc',
        32656,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SirinStencil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sirin Stencil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sirin+Stencil
  static TextTheme sirinStencilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sirinStencil(textStyle: textTheme.displayLarge),
      displayMedium: sirinStencil(textStyle: textTheme.displayMedium),
      displaySmall: sirinStencil(textStyle: textTheme.displaySmall),
      headlineLarge: sirinStencil(textStyle: textTheme.headlineLarge),
      headlineMedium: sirinStencil(textStyle: textTheme.headlineMedium),
      headlineSmall: sirinStencil(textStyle: textTheme.headlineSmall),
      titleLarge: sirinStencil(textStyle: textTheme.titleLarge),
      titleMedium: sirinStencil(textStyle: textTheme.titleMedium),
      titleSmall: sirinStencil(textStyle: textTheme.titleSmall),
      bodyLarge: sirinStencil(textStyle: textTheme.bodyLarge),
      bodyMedium: sirinStencil(textStyle: textTheme.bodyMedium),
      bodySmall: sirinStencil(textStyle: textTheme.bodySmall),
      labelLarge: sirinStencil(textStyle: textTheme.labelLarge),
      labelMedium: sirinStencil(textStyle: textTheme.labelMedium),
      labelSmall: sirinStencil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Six Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Six+Caps
  static TextStyle sixCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2d5a21d5af15fe2da2afa482c4341144375beddf29f13756379c6841939cf4f6',
        24736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SixCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Six Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Six+Caps
  static TextTheme sixCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sixCaps(textStyle: textTheme.displayLarge),
      displayMedium: sixCaps(textStyle: textTheme.displayMedium),
      displaySmall: sixCaps(textStyle: textTheme.displaySmall),
      headlineLarge: sixCaps(textStyle: textTheme.headlineLarge),
      headlineMedium: sixCaps(textStyle: textTheme.headlineMedium),
      headlineSmall: sixCaps(textStyle: textTheme.headlineSmall),
      titleLarge: sixCaps(textStyle: textTheme.titleLarge),
      titleMedium: sixCaps(textStyle: textTheme.titleMedium),
      titleSmall: sixCaps(textStyle: textTheme.titleSmall),
      bodyLarge: sixCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: sixCaps(textStyle: textTheme.bodyMedium),
      bodySmall: sixCaps(textStyle: textTheme.bodySmall),
      labelLarge: sixCaps(textStyle: textTheme.labelLarge),
      labelMedium: sixCaps(textStyle: textTheme.labelMedium),
      labelSmall: sixCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sixtyfour font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sixtyfour
  static TextStyle sixtyfour({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '002ea5ecdae9c091804950312535506ee82ef1a71639f4559681578ae1a09ae3',
        47224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sixtyfour',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sixtyfour font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sixtyfour
  static TextTheme sixtyfourTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sixtyfour(textStyle: textTheme.displayLarge),
      displayMedium: sixtyfour(textStyle: textTheme.displayMedium),
      displaySmall: sixtyfour(textStyle: textTheme.displaySmall),
      headlineLarge: sixtyfour(textStyle: textTheme.headlineLarge),
      headlineMedium: sixtyfour(textStyle: textTheme.headlineMedium),
      headlineSmall: sixtyfour(textStyle: textTheme.headlineSmall),
      titleLarge: sixtyfour(textStyle: textTheme.titleLarge),
      titleMedium: sixtyfour(textStyle: textTheme.titleMedium),
      titleSmall: sixtyfour(textStyle: textTheme.titleSmall),
      bodyLarge: sixtyfour(textStyle: textTheme.bodyLarge),
      bodyMedium: sixtyfour(textStyle: textTheme.bodyMedium),
      bodySmall: sixtyfour(textStyle: textTheme.bodySmall),
      labelLarge: sixtyfour(textStyle: textTheme.labelLarge),
      labelMedium: sixtyfour(textStyle: textTheme.labelMedium),
      labelSmall: sixtyfour(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Skranji font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Skranji
  static TextStyle skranji({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5302dc7580813cab3e6ebcbf17c41be6bb9d140b684ff6861fd3aa7d7aca8ad8',
        205504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86f37e5ddcb0825a877639175de5edbbb6856587b12886732d8c30af6e6c6807',
        204836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Skranji',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Skranji font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Skranji
  static TextTheme skranjiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: skranji(textStyle: textTheme.displayLarge),
      displayMedium: skranji(textStyle: textTheme.displayMedium),
      displaySmall: skranji(textStyle: textTheme.displaySmall),
      headlineLarge: skranji(textStyle: textTheme.headlineLarge),
      headlineMedium: skranji(textStyle: textTheme.headlineMedium),
      headlineSmall: skranji(textStyle: textTheme.headlineSmall),
      titleLarge: skranji(textStyle: textTheme.titleLarge),
      titleMedium: skranji(textStyle: textTheme.titleMedium),
      titleSmall: skranji(textStyle: textTheme.titleSmall),
      bodyLarge: skranji(textStyle: textTheme.bodyLarge),
      bodyMedium: skranji(textStyle: textTheme.bodyMedium),
      bodySmall: skranji(textStyle: textTheme.bodySmall),
      labelLarge: skranji(textStyle: textTheme.labelLarge),
      labelMedium: skranji(textStyle: textTheme.labelMedium),
      labelSmall: skranji(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Slabo 13px font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slabo+13px
  static TextStyle slabo13px({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2fce3b1fd2e437eb6e6b41c3beacc2acdab1bb96a8f21f95cff354ed0270a868',
        29428,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Slabo13px',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Slabo 13px font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slabo+13px
  static TextTheme slabo13pxTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: slabo13px(textStyle: textTheme.displayLarge),
      displayMedium: slabo13px(textStyle: textTheme.displayMedium),
      displaySmall: slabo13px(textStyle: textTheme.displaySmall),
      headlineLarge: slabo13px(textStyle: textTheme.headlineLarge),
      headlineMedium: slabo13px(textStyle: textTheme.headlineMedium),
      headlineSmall: slabo13px(textStyle: textTheme.headlineSmall),
      titleLarge: slabo13px(textStyle: textTheme.titleLarge),
      titleMedium: slabo13px(textStyle: textTheme.titleMedium),
      titleSmall: slabo13px(textStyle: textTheme.titleSmall),
      bodyLarge: slabo13px(textStyle: textTheme.bodyLarge),
      bodyMedium: slabo13px(textStyle: textTheme.bodyMedium),
      bodySmall: slabo13px(textStyle: textTheme.bodySmall),
      labelLarge: slabo13px(textStyle: textTheme.labelLarge),
      labelMedium: slabo13px(textStyle: textTheme.labelMedium),
      labelSmall: slabo13px(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Slabo 27px font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slabo+27px
  static TextStyle slabo27px({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0928a358ea71167f7a4db6e01d9ff8a86917372c8040343ef1298f93a755a87',
        31132,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Slabo27px',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Slabo 27px font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slabo+27px
  static TextTheme slabo27pxTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: slabo27px(textStyle: textTheme.displayLarge),
      displayMedium: slabo27px(textStyle: textTheme.displayMedium),
      displaySmall: slabo27px(textStyle: textTheme.displaySmall),
      headlineLarge: slabo27px(textStyle: textTheme.headlineLarge),
      headlineMedium: slabo27px(textStyle: textTheme.headlineMedium),
      headlineSmall: slabo27px(textStyle: textTheme.headlineSmall),
      titleLarge: slabo27px(textStyle: textTheme.titleLarge),
      titleMedium: slabo27px(textStyle: textTheme.titleMedium),
      titleSmall: slabo27px(textStyle: textTheme.titleSmall),
      bodyLarge: slabo27px(textStyle: textTheme.bodyLarge),
      bodyMedium: slabo27px(textStyle: textTheme.bodyMedium),
      bodySmall: slabo27px(textStyle: textTheme.bodySmall),
      labelLarge: slabo27px(textStyle: textTheme.labelLarge),
      labelMedium: slabo27px(textStyle: textTheme.labelMedium),
      labelSmall: slabo27px(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Slackey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slackey
  static TextStyle slackey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28013641a5a02c7b3b6339f8a1aeb4b023e8cbd8a5221d834df90321846c8d3c',
        35960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Slackey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Slackey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slackey
  static TextTheme slackeyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: slackey(textStyle: textTheme.displayLarge),
      displayMedium: slackey(textStyle: textTheme.displayMedium),
      displaySmall: slackey(textStyle: textTheme.displaySmall),
      headlineLarge: slackey(textStyle: textTheme.headlineLarge),
      headlineMedium: slackey(textStyle: textTheme.headlineMedium),
      headlineSmall: slackey(textStyle: textTheme.headlineSmall),
      titleLarge: slackey(textStyle: textTheme.titleLarge),
      titleMedium: slackey(textStyle: textTheme.titleMedium),
      titleSmall: slackey(textStyle: textTheme.titleSmall),
      bodyLarge: slackey(textStyle: textTheme.bodyLarge),
      bodyMedium: slackey(textStyle: textTheme.bodyMedium),
      bodySmall: slackey(textStyle: textTheme.bodySmall),
      labelLarge: slackey(textStyle: textTheme.labelLarge),
      labelMedium: slackey(textStyle: textTheme.labelMedium),
      labelSmall: slackey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Slackside One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slackside+One
  static TextStyle slacksideOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '649b722ef03b453fb4d0f586faa60c7ef4f183e28978f996ca7f0e3b0bcde910',
        171036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SlacksideOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Slackside One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Slackside+One
  static TextTheme slacksideOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: slacksideOne(textStyle: textTheme.displayLarge),
      displayMedium: slacksideOne(textStyle: textTheme.displayMedium),
      displaySmall: slacksideOne(textStyle: textTheme.displaySmall),
      headlineLarge: slacksideOne(textStyle: textTheme.headlineLarge),
      headlineMedium: slacksideOne(textStyle: textTheme.headlineMedium),
      headlineSmall: slacksideOne(textStyle: textTheme.headlineSmall),
      titleLarge: slacksideOne(textStyle: textTheme.titleLarge),
      titleMedium: slacksideOne(textStyle: textTheme.titleMedium),
      titleSmall: slacksideOne(textStyle: textTheme.titleSmall),
      bodyLarge: slacksideOne(textStyle: textTheme.bodyLarge),
      bodyMedium: slacksideOne(textStyle: textTheme.bodyMedium),
      bodySmall: slacksideOne(textStyle: textTheme.bodySmall),
      labelLarge: slacksideOne(textStyle: textTheme.labelLarge),
      labelMedium: slacksideOne(textStyle: textTheme.labelMedium),
      labelSmall: slacksideOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Smokum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smokum
  static TextStyle smokum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '54cc553e3a739c9f80f302763f389d8d4b2aad9efd9a0d9230d538143ce4da05',
        61212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Smokum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Smokum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smokum
  static TextTheme smokumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: smokum(textStyle: textTheme.displayLarge),
      displayMedium: smokum(textStyle: textTheme.displayMedium),
      displaySmall: smokum(textStyle: textTheme.displaySmall),
      headlineLarge: smokum(textStyle: textTheme.headlineLarge),
      headlineMedium: smokum(textStyle: textTheme.headlineMedium),
      headlineSmall: smokum(textStyle: textTheme.headlineSmall),
      titleLarge: smokum(textStyle: textTheme.titleLarge),
      titleMedium: smokum(textStyle: textTheme.titleMedium),
      titleSmall: smokum(textStyle: textTheme.titleSmall),
      bodyLarge: smokum(textStyle: textTheme.bodyLarge),
      bodyMedium: smokum(textStyle: textTheme.bodyMedium),
      bodySmall: smokum(textStyle: textTheme.bodySmall),
      labelLarge: smokum(textStyle: textTheme.labelLarge),
      labelMedium: smokum(textStyle: textTheme.labelMedium),
      labelSmall: smokum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Smooch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smooch
  static TextStyle smooch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '663fe773bacf34f623fa654cfdd96c5d4a28a9d946bf3e3555c9b0e3aaaf8378',
        198980,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Smooch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Smooch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smooch
  static TextTheme smoochTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: smooch(textStyle: textTheme.displayLarge),
      displayMedium: smooch(textStyle: textTheme.displayMedium),
      displaySmall: smooch(textStyle: textTheme.displaySmall),
      headlineLarge: smooch(textStyle: textTheme.headlineLarge),
      headlineMedium: smooch(textStyle: textTheme.headlineMedium),
      headlineSmall: smooch(textStyle: textTheme.headlineSmall),
      titleLarge: smooch(textStyle: textTheme.titleLarge),
      titleMedium: smooch(textStyle: textTheme.titleMedium),
      titleSmall: smooch(textStyle: textTheme.titleSmall),
      bodyLarge: smooch(textStyle: textTheme.bodyLarge),
      bodyMedium: smooch(textStyle: textTheme.bodyMedium),
      bodySmall: smooch(textStyle: textTheme.bodySmall),
      labelLarge: smooch(textStyle: textTheme.labelLarge),
      labelMedium: smooch(textStyle: textTheme.labelMedium),
      labelSmall: smooch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Smooch Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smooch+Sans
  static TextStyle smoochSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24800ed04b51d3c782d510a0628f3fd54b5391cc941b8dcd5a65058cbf766648',
        57932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aeea8afb0808de6f6a39a2de44237ada727bd1fde4f95eb95e0528704a480b3c',
        57948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '44a090fde4b20cc78f4d714758251777ed9e7d3ed09bf0a5a7c844296f72db9a',
        57928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72829c9fa7337520a62fb6b5ea831eb54ba7a15c10fd0be1d82c13946284bc5f',
        57916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe2c242340dd636eec87428f76fc2a5d3b66e4947550dec271a58e93711e3a1e',
        58020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a127d15fc9b2fd094eadfcdaa67ec090cf11d0db948608e2e409c02a5bdb763',
        57988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83ff6b79d3f542760138813c463911f3e02867598c2b47d12dc899c0e37e4f89',
        57920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6ca2eb10f26ac13b11e5bed54db312daeaf75a267ffd7fd2fd61c0da17edd2c',
        58076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5967ff370ad8dc7498e89c43e1e8cbb4f04ff9860049a35b2d375925aba80118',
        57948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SmoochSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Smooch Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smooch+Sans
  static TextTheme smoochSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: smoochSans(textStyle: textTheme.displayLarge),
      displayMedium: smoochSans(textStyle: textTheme.displayMedium),
      displaySmall: smoochSans(textStyle: textTheme.displaySmall),
      headlineLarge: smoochSans(textStyle: textTheme.headlineLarge),
      headlineMedium: smoochSans(textStyle: textTheme.headlineMedium),
      headlineSmall: smoochSans(textStyle: textTheme.headlineSmall),
      titleLarge: smoochSans(textStyle: textTheme.titleLarge),
      titleMedium: smoochSans(textStyle: textTheme.titleMedium),
      titleSmall: smoochSans(textStyle: textTheme.titleSmall),
      bodyLarge: smoochSans(textStyle: textTheme.bodyLarge),
      bodyMedium: smoochSans(textStyle: textTheme.bodyMedium),
      bodySmall: smoochSans(textStyle: textTheme.bodySmall),
      labelLarge: smoochSans(textStyle: textTheme.labelLarge),
      labelMedium: smoochSans(textStyle: textTheme.labelMedium),
      labelSmall: smoochSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Smythe font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smythe
  static TextStyle smythe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0cc64f1ce2b1244b8faab6389df4e79912b139b787b16f882c6600a63e02cd03',
        48020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Smythe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Smythe font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Smythe
  static TextTheme smytheTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: smythe(textStyle: textTheme.displayLarge),
      displayMedium: smythe(textStyle: textTheme.displayMedium),
      displaySmall: smythe(textStyle: textTheme.displaySmall),
      headlineLarge: smythe(textStyle: textTheme.headlineLarge),
      headlineMedium: smythe(textStyle: textTheme.headlineMedium),
      headlineSmall: smythe(textStyle: textTheme.headlineSmall),
      titleLarge: smythe(textStyle: textTheme.titleLarge),
      titleMedium: smythe(textStyle: textTheme.titleMedium),
      titleSmall: smythe(textStyle: textTheme.titleSmall),
      bodyLarge: smythe(textStyle: textTheme.bodyLarge),
      bodyMedium: smythe(textStyle: textTheme.bodyMedium),
      bodySmall: smythe(textStyle: textTheme.bodySmall),
      labelLarge: smythe(textStyle: textTheme.labelLarge),
      labelMedium: smythe(textStyle: textTheme.labelMedium),
      labelSmall: smythe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sniglet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sniglet
  static TextStyle sniglet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f283da78f67cb18afa6381e3b0d7a8a30fd520f2ee1757a232b0c87135f08d8',
        48048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '191567d55ad02188c38e7f4184ec785fd92a8050805af91d95738ca0aaa5ce12',
        51452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sniglet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sniglet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sniglet
  static TextTheme snigletTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sniglet(textStyle: textTheme.displayLarge),
      displayMedium: sniglet(textStyle: textTheme.displayMedium),
      displaySmall: sniglet(textStyle: textTheme.displaySmall),
      headlineLarge: sniglet(textStyle: textTheme.headlineLarge),
      headlineMedium: sniglet(textStyle: textTheme.headlineMedium),
      headlineSmall: sniglet(textStyle: textTheme.headlineSmall),
      titleLarge: sniglet(textStyle: textTheme.titleLarge),
      titleMedium: sniglet(textStyle: textTheme.titleMedium),
      titleSmall: sniglet(textStyle: textTheme.titleSmall),
      bodyLarge: sniglet(textStyle: textTheme.bodyLarge),
      bodyMedium: sniglet(textStyle: textTheme.bodyMedium),
      bodySmall: sniglet(textStyle: textTheme.bodySmall),
      labelLarge: sniglet(textStyle: textTheme.labelLarge),
      labelMedium: sniglet(textStyle: textTheme.labelMedium),
      labelSmall: sniglet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Snippet font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Snippet
  static TextStyle snippet({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2f293fccdbd618851f978ca470df2466cc6d562c431c29a65adafb801449c9b',
        36836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Snippet',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Snippet font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Snippet
  static TextTheme snippetTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: snippet(textStyle: textTheme.displayLarge),
      displayMedium: snippet(textStyle: textTheme.displayMedium),
      displaySmall: snippet(textStyle: textTheme.displaySmall),
      headlineLarge: snippet(textStyle: textTheme.headlineLarge),
      headlineMedium: snippet(textStyle: textTheme.headlineMedium),
      headlineSmall: snippet(textStyle: textTheme.headlineSmall),
      titleLarge: snippet(textStyle: textTheme.titleLarge),
      titleMedium: snippet(textStyle: textTheme.titleMedium),
      titleSmall: snippet(textStyle: textTheme.titleSmall),
      bodyLarge: snippet(textStyle: textTheme.bodyLarge),
      bodyMedium: snippet(textStyle: textTheme.bodyMedium),
      bodySmall: snippet(textStyle: textTheme.bodySmall),
      labelLarge: snippet(textStyle: textTheme.labelLarge),
      labelMedium: snippet(textStyle: textTheme.labelMedium),
      labelSmall: snippet(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Snowburst One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Snowburst+One
  static TextStyle snowburstOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56c8b3fddf7ab2ff8447336f6b51a5dfbf91a77aa463d3be36be8b92f89c74a9',
        50668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SnowburstOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Snowburst One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Snowburst+One
  static TextTheme snowburstOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: snowburstOne(textStyle: textTheme.displayLarge),
      displayMedium: snowburstOne(textStyle: textTheme.displayMedium),
      displaySmall: snowburstOne(textStyle: textTheme.displaySmall),
      headlineLarge: snowburstOne(textStyle: textTheme.headlineLarge),
      headlineMedium: snowburstOne(textStyle: textTheme.headlineMedium),
      headlineSmall: snowburstOne(textStyle: textTheme.headlineSmall),
      titleLarge: snowburstOne(textStyle: textTheme.titleLarge),
      titleMedium: snowburstOne(textStyle: textTheme.titleMedium),
      titleSmall: snowburstOne(textStyle: textTheme.titleSmall),
      bodyLarge: snowburstOne(textStyle: textTheme.bodyLarge),
      bodyMedium: snowburstOne(textStyle: textTheme.bodyMedium),
      bodySmall: snowburstOne(textStyle: textTheme.bodySmall),
      labelLarge: snowburstOne(textStyle: textTheme.labelLarge),
      labelMedium: snowburstOne(textStyle: textTheme.labelMedium),
      labelSmall: snowburstOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sofadi One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofadi+One
  static TextStyle sofadiOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40fc5d9d4077c73125cf72d087667aef1a45465d0573813ca0e9dc2ca618936c',
        32124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SofadiOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sofadi One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofadi+One
  static TextTheme sofadiOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sofadiOne(textStyle: textTheme.displayLarge),
      displayMedium: sofadiOne(textStyle: textTheme.displayMedium),
      displaySmall: sofadiOne(textStyle: textTheme.displaySmall),
      headlineLarge: sofadiOne(textStyle: textTheme.headlineLarge),
      headlineMedium: sofadiOne(textStyle: textTheme.headlineMedium),
      headlineSmall: sofadiOne(textStyle: textTheme.headlineSmall),
      titleLarge: sofadiOne(textStyle: textTheme.titleLarge),
      titleMedium: sofadiOne(textStyle: textTheme.titleMedium),
      titleSmall: sofadiOne(textStyle: textTheme.titleSmall),
      bodyLarge: sofadiOne(textStyle: textTheme.bodyLarge),
      bodyMedium: sofadiOne(textStyle: textTheme.bodyMedium),
      bodySmall: sofadiOne(textStyle: textTheme.bodySmall),
      labelLarge: sofadiOne(textStyle: textTheme.labelLarge),
      labelMedium: sofadiOne(textStyle: textTheme.labelMedium),
      labelSmall: sofadiOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sofia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia
  static TextStyle sofia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a18c05dadae10ae5c7b4dbe5d1393309d267cf820b7f6bafe87225d9190e11dd',
        27816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sofia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sofia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia
  static TextTheme sofiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sofia(textStyle: textTheme.displayLarge),
      displayMedium: sofia(textStyle: textTheme.displayMedium),
      displaySmall: sofia(textStyle: textTheme.displaySmall),
      headlineLarge: sofia(textStyle: textTheme.headlineLarge),
      headlineMedium: sofia(textStyle: textTheme.headlineMedium),
      headlineSmall: sofia(textStyle: textTheme.headlineSmall),
      titleLarge: sofia(textStyle: textTheme.titleLarge),
      titleMedium: sofia(textStyle: textTheme.titleMedium),
      titleSmall: sofia(textStyle: textTheme.titleSmall),
      bodyLarge: sofia(textStyle: textTheme.bodyLarge),
      bodyMedium: sofia(textStyle: textTheme.bodyMedium),
      bodySmall: sofia(textStyle: textTheme.bodySmall),
      labelLarge: sofia(textStyle: textTheme.labelLarge),
      labelMedium: sofia(textStyle: textTheme.labelMedium),
      labelSmall: sofia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sofia Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans
  static TextStyle sofiaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9972c14e33f75b33a422a185a8e1f2274d6aa6ebb27b70b1430fa7bebf74c1e6',
        110720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db7a3f2794e7f3509502d45640eae3597881e44f29c565f3965ec086c432fa6f',
        110816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6cf947332fa6eb23685ceaf4749ae3e6d01148a68736a427d29e276f50a1f3e',
        110752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c297ccf18997a208d83b4965858b053c7148af7ed697a519710d578f8a2e288',
        110600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a442a5b1bc5c3dbfb6a4692b7b7bab3d40dca771a3e12e037d7a76f132fd535',
        110760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85bbc8bbc36f8aff4808363634f0842791359b6c904d33194f452fab5d7a745b',
        110716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '329cb1dc97710eff5dbcf8000f908d727d2dc1ba1b00ba906f30f8f3c561427c',
        110684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3787e3d3370f4ba6e2e39e90ab960df9d30e6233d9fe7a7574d543e78677a723',
        110776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdaab197b1c7d9ce6dd95e803bb3669ca77369c94b3707ab41c91ae6f66e1edb',
        110672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a7deb20dbec0fc5be4055fc52eab937bf4e53ab96c7bd57e7638df62a649ac92',
        100024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2492101344c437fffa90d7e7c06865ab890e20151e13757d73881dc0e7e21a96',
        100128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8c55d8dbfa1e0484bd2100df2dfd19d1bf02613a99db409c7296b316a1c17cd',
        100128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '891ab08d3dbc7faeb0306df127f3d4cf523685648d63d6a2eeae656c43159714',
        99836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3e7fb72268b0f8abc3d4c6cad1c80d0061418a966543cf3748505e229e8e29d7',
        100124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '80970c6146f8ebd5da56b3503841a118bba9c9c0d0ac15739499c30ef36021c1',
        100128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13eb8a1c524ea4e32e80ad8dbc0688858a6250799750fb1bdd06bc9e292f2ce9',
        99980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9ad3a36dd102bfdba4f31e547f76909d4169f347c742a3f3a6853d508181bc56',
        100244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '772c25c1a5bade3f25180d61ef4f49d7068c442193a9157b0c794b414b1527ce',
        100092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SofiaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sofia Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans
  static TextTheme sofiaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sofiaSans(textStyle: textTheme.displayLarge),
      displayMedium: sofiaSans(textStyle: textTheme.displayMedium),
      displaySmall: sofiaSans(textStyle: textTheme.displaySmall),
      headlineLarge: sofiaSans(textStyle: textTheme.headlineLarge),
      headlineMedium: sofiaSans(textStyle: textTheme.headlineMedium),
      headlineSmall: sofiaSans(textStyle: textTheme.headlineSmall),
      titleLarge: sofiaSans(textStyle: textTheme.titleLarge),
      titleMedium: sofiaSans(textStyle: textTheme.titleMedium),
      titleSmall: sofiaSans(textStyle: textTheme.titleSmall),
      bodyLarge: sofiaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: sofiaSans(textStyle: textTheme.bodyMedium),
      bodySmall: sofiaSans(textStyle: textTheme.bodySmall),
      labelLarge: sofiaSans(textStyle: textTheme.labelLarge),
      labelMedium: sofiaSans(textStyle: textTheme.labelMedium),
      labelSmall: sofiaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sofia Sans Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans+Condensed
  static TextStyle sofiaSansCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a59cbe42c610fadd3a3bb30a549d2d6e1daf6673c7069e2c646f599d5512f216',
        108888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '537d4af0b893690161e8d707b0b16558b20dbb3c293303a4518c967bd22e6132',
        109072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ace241ad269771eae10919a7576054cd801c8d18d825cc9a2db7bbc1788126e',
        109036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a5349891ec75920c8c3f8d3e41da095664a216d2dde34aef6de51dc4e3fc500',
        109012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0732007875eadf27e1b566c06a3ca8b783fad6c77c0df69a4b7d9de9b09b3801',
        109024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83d50897343aa645a57c10d02a3bbb6a736ea89d6ee32f8f008bbf41bb354800',
        109136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '879d3667965880d9bca4c814b20d5c8124c0b90ee9f415464d07400f23d85c72',
        109036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30af96c94793c80cdcfc9ce181ac05afaecde6523843c57ca1097b7b096dee3d',
        109168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '004a70e953365e9cf5e38da91e8a4449e90f98245614b23375cf4fe6d3fdbe1e',
        108984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ae7d64419d6fe3d6a01c5e20944b51397855ac600346539646f134635d5d4867',
        98784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '72cadbeb269166a3a31fd2492f11cf38ee22e3f3d0596f9ea631654371643836',
        98896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b8f40b86b77bcc9787355eba0c58d90175cf1fdf8769c05ad10ae8a476e2686',
        98828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b6e69f3a3c03996058ac4c0cf7ef190dc0bf115d3b16e5dd945995919eb053f5',
        98716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2cbce20e05cad804cb5d852bec8c8b320bcd5ee3a0c5e5cc1de3b07e65873561',
        98872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '46e369b43e4f328ff2a71120fceb882b722c5d072420daf4b62b7fefdfb1ea78',
        98924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '953e85747b1ef34ddb600130270f73c9e94f62c917448c52171ddf5f55971ae0',
        98784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a73194c3b3564a97f984c16bda6829f29ccf9c2f167e39728345d4d93690efe',
        98972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd74c365cc49fd43dd727df35ad079708e2d65912f9889dcb8b63739743385d20',
        98948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SofiaSansCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sofia Sans Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans+Condensed
  static TextTheme sofiaSansCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sofiaSansCondensed(textStyle: textTheme.displayLarge),
      displayMedium: sofiaSansCondensed(textStyle: textTheme.displayMedium),
      displaySmall: sofiaSansCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: sofiaSansCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: sofiaSansCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: sofiaSansCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: sofiaSansCondensed(textStyle: textTheme.titleLarge),
      titleMedium: sofiaSansCondensed(textStyle: textTheme.titleMedium),
      titleSmall: sofiaSansCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: sofiaSansCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: sofiaSansCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: sofiaSansCondensed(textStyle: textTheme.bodySmall),
      labelLarge: sofiaSansCondensed(textStyle: textTheme.labelLarge),
      labelMedium: sofiaSansCondensed(textStyle: textTheme.labelMedium),
      labelSmall: sofiaSansCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sofia Sans Extra Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans+Extra+Condensed
  static TextStyle sofiaSansExtraCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ec7b011c649d0bfb9e1de0da25f3388751da7661d7a073f605315eaaa100e62',
        108464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e85fa30aa1bce2a2342af3707a19a9f7b0c3b4934b48ee1ea3a07f8a43d85d77',
        108680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d58701ecdaf4eb27c8934fa8c41cad5187fc590d7e05a9635f6faa71e3dc6ef',
        108664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc9e2b83b383da3f9e261d4115edfe35ad8dca1befe418f384929a2d4c2f8c62',
        108628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17c490056c26dcb1d4f05aaba0c42a273aa3b1342fe4cd6c4b85fb21e2569dc4',
        108712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '460c85d84ee9c2d2e540362f7533f3547a4b90ae214e8d8a9873babd659effb3',
        108764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30ca3cf45f4d218a0536cce7ad088903f9d17af52551480b9f415f37b3d0e134',
        108720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d08467db95a99d95ccd7a8764bba5b94d2e2921e4041d7297702ee1f18da95c',
        108724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca64a500c4f02c909be53ed42188a09ee5f5deacb7b796f53b6af5ab23670e51',
        108672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f221c831eb3bbc5ecf403bd8d4ce0c104bd1c3622168e61ea039251f1a9a7c27',
        96904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '72a8554592144ecd0076b348604d266fdc0dd7d3c51a1d61ad46834409786bfe',
        97004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'feec36edf605d834ff5f727291f14a96433d4ed269c6142901e0370f3b0f5f8f',
        97008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '12de66a0154b355a0dbec286e1c96a54d6f3a76c8a54a97ff34fe8e6cbba2178',
        96804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd24eb5023415b18d6cc7530fb1b8851eb3a54cbeb8b4e438de69b51cdc356699',
        97028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8fea75e8fccf981156f038f4934a7a8e82e9627839b1a36878d76100dc8513e',
        97156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '46f76054c5794ce9b3aa0e6dbc683f7a05ce1b5aca9f2dd2fa5c508be563d7f2',
        97072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a1125b14ce4f4e70e48acfc8be0b8091f289327b9612b615a1e07393d3f4799',
        97284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd4d0fc8d431664e61dfa8cda73807eb868d8c94c5b196977395d025da58e3008',
        97196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SofiaSansExtraCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sofia Sans Extra Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans+Extra+Condensed
  static TextTheme sofiaSansExtraCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sofiaSansExtraCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          sofiaSansExtraCondensed(textStyle: textTheme.displayMedium),
      displaySmall: sofiaSansExtraCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          sofiaSansExtraCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          sofiaSansExtraCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          sofiaSansExtraCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: sofiaSansExtraCondensed(textStyle: textTheme.titleLarge),
      titleMedium: sofiaSansExtraCondensed(textStyle: textTheme.titleMedium),
      titleSmall: sofiaSansExtraCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: sofiaSansExtraCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: sofiaSansExtraCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: sofiaSansExtraCondensed(textStyle: textTheme.bodySmall),
      labelLarge: sofiaSansExtraCondensed(textStyle: textTheme.labelLarge),
      labelMedium: sofiaSansExtraCondensed(textStyle: textTheme.labelMedium),
      labelSmall: sofiaSansExtraCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sofia Sans Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans+Semi+Condensed
  static TextStyle sofiaSansSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '194645f5400c447798cac8854d14d51c26059d09281b8305d9db3d71e5cc5f35',
        110856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d2487814fbd8d5e07abdce289b33930e73965e1cecf7d1cc555d99802dff86f',
        110920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f16307defaa8d7a9ba4fdf77258a3ebf82f5ffdaae864700df943320aa6551f1',
        110884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f576973b7a3763055630a985ecb1000b3075c9c5daa942fc4270ee6ec1a8a1ba',
        110872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10d0f30ead66ecc76999f064d4a682585b25831be535907115e9ec2ce9fd41fa',
        110948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e69a12c3235979879a7cd1f04df591972865bcdb7c0cf05e41170622c58c2fad',
        110960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7b56cc315a3032631343083a8b014e9cc97c6fa2f6b1d37ce8d6d6e898bab3d',
        110920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa7f23df55b1465000ff795dd39838849f38ab790f7f44c091c050b0f59c563d',
        110944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '788e1dd87d2c3329c8233eedcd442ae70666baa2ecf1df3d1af1731b6eea20c4',
        110852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '890357a9a0c39af5a05288e5a32f0ae2a913d5173e9421ffc3b0553d0390a7e6',
        100564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1fe577e1bc3666c24165aac1d000b3881c10056ac0d4d2002c5c244595a0707b',
        100760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b9788f69e5d4c86b19e137354674c484fd01aa6efd89462489b2a1486d82906',
        100652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c7729fa63ae8653fb51206c790cd113566ab6346a50b26b03257f8237e7323a9',
        100440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '93206d18ea2d1fec45399ba9cce72a20a44843641db78c91951c4393cbe01cb2',
        100724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f2cc79cd2dc40b88b5bbb5dc6b5189ca08ec37ba3d3d50581c21cbcab8687996',
        100696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d62d0bd1dfb4e92c8a92395440edab8480dd05e2b06c18dafc140c2a2f4e75f',
        100632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '084f8ddd098c0d4c83d04f157c7cd7f68c2ded56fe7fbc40d9b34bee5b9ae62f',
        100724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df76b51396b86fc820003c9ab23478fb9bc32d386b075eaa7d15fbffd1dd54ce',
        100620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SofiaSansSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sofia Sans Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sofia+Sans+Semi+Condensed
  static TextTheme sofiaSansSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sofiaSansSemiCondensed(textStyle: textTheme.displayLarge),
      displayMedium: sofiaSansSemiCondensed(textStyle: textTheme.displayMedium),
      displaySmall: sofiaSansSemiCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: sofiaSansSemiCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          sofiaSansSemiCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: sofiaSansSemiCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: sofiaSansSemiCondensed(textStyle: textTheme.titleLarge),
      titleMedium: sofiaSansSemiCondensed(textStyle: textTheme.titleMedium),
      titleSmall: sofiaSansSemiCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: sofiaSansSemiCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: sofiaSansSemiCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: sofiaSansSemiCondensed(textStyle: textTheme.bodySmall),
      labelLarge: sofiaSansSemiCondensed(textStyle: textTheme.labelLarge),
      labelMedium: sofiaSansSemiCondensed(textStyle: textTheme.labelMedium),
      labelSmall: sofiaSansSemiCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Solitreo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Solitreo
  static TextStyle solitreo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fca90482e2f284d5b35cab38a3fde1b5387aa1080de012a458e612e7ccf6cda',
        65136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Solitreo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Solitreo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Solitreo
  static TextTheme solitreoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: solitreo(textStyle: textTheme.displayLarge),
      displayMedium: solitreo(textStyle: textTheme.displayMedium),
      displaySmall: solitreo(textStyle: textTheme.displaySmall),
      headlineLarge: solitreo(textStyle: textTheme.headlineLarge),
      headlineMedium: solitreo(textStyle: textTheme.headlineMedium),
      headlineSmall: solitreo(textStyle: textTheme.headlineSmall),
      titleLarge: solitreo(textStyle: textTheme.titleLarge),
      titleMedium: solitreo(textStyle: textTheme.titleMedium),
      titleSmall: solitreo(textStyle: textTheme.titleSmall),
      bodyLarge: solitreo(textStyle: textTheme.bodyLarge),
      bodyMedium: solitreo(textStyle: textTheme.bodyMedium),
      bodySmall: solitreo(textStyle: textTheme.bodySmall),
      labelLarge: solitreo(textStyle: textTheme.labelLarge),
      labelMedium: solitreo(textStyle: textTheme.labelMedium),
      labelSmall: solitreo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Solway font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Solway
  static TextStyle solway({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c525b4c52569f56fd1a208f8b939db3726cdc5e2f0b902d9fc07a0a8f301ef0a',
        34204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acec6761ae85d19050e2130cfc530ed6794fe6de6426ee0d39e1e1db3f0cf258',
        36552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe6240acbd6ea654f61d5c85043a966ba930b4d0f035739ed2729e7ed5250226',
        36552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aba66594e6993d0941b6e6824171973522e5cc596b67792b4aa682729176a677',
        37092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab335061864d156ad23780be407706be73a40e1a39fa1ec7d27552436ae665f8',
        37424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Solway',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Solway font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Solway
  static TextTheme solwayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: solway(textStyle: textTheme.displayLarge),
      displayMedium: solway(textStyle: textTheme.displayMedium),
      displaySmall: solway(textStyle: textTheme.displaySmall),
      headlineLarge: solway(textStyle: textTheme.headlineLarge),
      headlineMedium: solway(textStyle: textTheme.headlineMedium),
      headlineSmall: solway(textStyle: textTheme.headlineSmall),
      titleLarge: solway(textStyle: textTheme.titleLarge),
      titleMedium: solway(textStyle: textTheme.titleMedium),
      titleSmall: solway(textStyle: textTheme.titleSmall),
      bodyLarge: solway(textStyle: textTheme.bodyLarge),
      bodyMedium: solway(textStyle: textTheme.bodyMedium),
      bodySmall: solway(textStyle: textTheme.bodySmall),
      labelLarge: solway(textStyle: textTheme.labelLarge),
      labelMedium: solway(textStyle: textTheme.labelMedium),
      labelSmall: solway(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sometype Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sometype+Mono
  static TextStyle sometypeMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6a7ce9586a1c34e1ec5c3eb48290ecb64c8c470427df8631171d981ca1056b3',
        38308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f02de800d72572fb2e9349e01b44e163d99df7ac914368b02bf3ad38c7b8d7c8',
        38284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50e46b6aa67cab5d7b2949182e68b4fa54e01fc1fbb359bf4a7bfd254b8d7962',
        38248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9446eac594224c6aab36060e1ed13c3c41f457c092aaabd6e20ba0c7bf8ec6d',
        38124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c759945674450c3d6a720aa26efc7d5d2aba0f7fea53638d0eebfc79f9ed071b',
        39132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '14e76747b10c3b494f801e038ee1deaf03354d42b370c3315fd1d99d3c3de8a1',
        39196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ecf7d63b044dbfede60e4cec4ff45c2990d4cecd2ca938ea067b9f72fad24f31',
        39192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '609bb77bfa5035cfb5a950bfaf7919a0f77dc60064a08376005ba1b807fd4b5d',
        39024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SometypeMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sometype Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sometype+Mono
  static TextTheme sometypeMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sometypeMono(textStyle: textTheme.displayLarge),
      displayMedium: sometypeMono(textStyle: textTheme.displayMedium),
      displaySmall: sometypeMono(textStyle: textTheme.displaySmall),
      headlineLarge: sometypeMono(textStyle: textTheme.headlineLarge),
      headlineMedium: sometypeMono(textStyle: textTheme.headlineMedium),
      headlineSmall: sometypeMono(textStyle: textTheme.headlineSmall),
      titleLarge: sometypeMono(textStyle: textTheme.titleLarge),
      titleMedium: sometypeMono(textStyle: textTheme.titleMedium),
      titleSmall: sometypeMono(textStyle: textTheme.titleSmall),
      bodyLarge: sometypeMono(textStyle: textTheme.bodyLarge),
      bodyMedium: sometypeMono(textStyle: textTheme.bodyMedium),
      bodySmall: sometypeMono(textStyle: textTheme.bodySmall),
      labelLarge: sometypeMono(textStyle: textTheme.labelLarge),
      labelMedium: sometypeMono(textStyle: textTheme.labelMedium),
      labelSmall: sometypeMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Song Myung font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Song+Myung
  static TextStyle songMyung({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68c08420ba02124468dda80f84c16023e208309db8e41bf1b398a7309bbde411',
        1202620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SongMyung',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Song Myung font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Song+Myung
  static TextTheme songMyungTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: songMyung(textStyle: textTheme.displayLarge),
      displayMedium: songMyung(textStyle: textTheme.displayMedium),
      displaySmall: songMyung(textStyle: textTheme.displaySmall),
      headlineLarge: songMyung(textStyle: textTheme.headlineLarge),
      headlineMedium: songMyung(textStyle: textTheme.headlineMedium),
      headlineSmall: songMyung(textStyle: textTheme.headlineSmall),
      titleLarge: songMyung(textStyle: textTheme.titleLarge),
      titleMedium: songMyung(textStyle: textTheme.titleMedium),
      titleSmall: songMyung(textStyle: textTheme.titleSmall),
      bodyLarge: songMyung(textStyle: textTheme.bodyLarge),
      bodyMedium: songMyung(textStyle: textTheme.bodyMedium),
      bodySmall: songMyung(textStyle: textTheme.bodySmall),
      labelLarge: songMyung(textStyle: textTheme.labelLarge),
      labelMedium: songMyung(textStyle: textTheme.labelMedium),
      labelSmall: songMyung(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sono
  static TextStyle sono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '631fd4af931aa0797d0d41e578221dcc4ecb774d7fbc92efe7cf9463d7f6a166',
        63092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e638505143269c3f784b04b278f80afcc09d0148742954a312fa2a074b54b4c',
        63296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ebd24fdc02a56dc816e4aa88ea3a4b05cd895250c23834c9255944d134d842f',
        63196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '661749f91e514c7dae5f7dbf44151e736d6bf46711959318c94293f55341daf7',
        63168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ddd6d40211d98c1c99f3571e78813d32eb3189b141e10a7fd0a284171ee82e4',
        63152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c312cd7b07b2b52ff7c0c81b0906056c6c1d49ebf0c5b220c9c67a7fdd224ea4',
        63108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7e6b5bebee95338cb5ff8a8183a1d99917b7c186db66476099270e2c0afba15',
        62984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sono
  static TextTheme sonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sono(textStyle: textTheme.displayLarge),
      displayMedium: sono(textStyle: textTheme.displayMedium),
      displaySmall: sono(textStyle: textTheme.displaySmall),
      headlineLarge: sono(textStyle: textTheme.headlineLarge),
      headlineMedium: sono(textStyle: textTheme.headlineMedium),
      headlineSmall: sono(textStyle: textTheme.headlineSmall),
      titleLarge: sono(textStyle: textTheme.titleLarge),
      titleMedium: sono(textStyle: textTheme.titleMedium),
      titleSmall: sono(textStyle: textTheme.titleSmall),
      bodyLarge: sono(textStyle: textTheme.bodyLarge),
      bodyMedium: sono(textStyle: textTheme.bodyMedium),
      bodySmall: sono(textStyle: textTheme.bodySmall),
      labelLarge: sono(textStyle: textTheme.labelLarge),
      labelMedium: sono(textStyle: textTheme.labelMedium),
      labelSmall: sono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sonsie One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sonsie+One
  static TextStyle sonsieOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77ebb659b444335feb985b00b45ab2881cbcd3c790c9247364a03e5f15360534',
        70196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SonsieOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sonsie One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sonsie+One
  static TextTheme sonsieOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sonsieOne(textStyle: textTheme.displayLarge),
      displayMedium: sonsieOne(textStyle: textTheme.displayMedium),
      displaySmall: sonsieOne(textStyle: textTheme.displaySmall),
      headlineLarge: sonsieOne(textStyle: textTheme.headlineLarge),
      headlineMedium: sonsieOne(textStyle: textTheme.headlineMedium),
      headlineSmall: sonsieOne(textStyle: textTheme.headlineSmall),
      titleLarge: sonsieOne(textStyle: textTheme.titleLarge),
      titleMedium: sonsieOne(textStyle: textTheme.titleMedium),
      titleSmall: sonsieOne(textStyle: textTheme.titleSmall),
      bodyLarge: sonsieOne(textStyle: textTheme.bodyLarge),
      bodyMedium: sonsieOne(textStyle: textTheme.bodyMedium),
      bodySmall: sonsieOne(textStyle: textTheme.bodySmall),
      labelLarge: sonsieOne(textStyle: textTheme.labelLarge),
      labelMedium: sonsieOne(textStyle: textTheme.labelMedium),
      labelSmall: sonsieOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sora font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sora
  static TextStyle sora({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27f75ce32aff114fb894f8f8755f753e5196bfee34ea57bf956cbd3e3b32a7ff',
        46164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4befa6134e5912ca811652cded40d52d0098f818dca3c3937ca96c4099c6587c',
        46272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '65f32c01ae689a9225e5d2775edcf71f044c9e4d4ba2e2080580ac751c8ad4eb',
        46216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd90ca64b1c75f1436fd2580cb582f0eb6cf6826b118fcb8802db4fae2eb43d07',
        46016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '612df8ed44c3d7deb57fe1050ca106a004470c7a9267111fe79d07cae14a5b23',
        46112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33bb28b314da8acd3950f7079a62da19e594138823a1d2ed4f8dba904005d007',
        46192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09087487d0a1e4d97c3f70f861d90045098d713c88f06de88585981810d20b72',
        46128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50abbbf9b5dcbbfa8b487a8f87fccf54cb461c4ea5d16fd6c65edc72c4c6af5c',
        46204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sora',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sora font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sora
  static TextTheme soraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sora(textStyle: textTheme.displayLarge),
      displayMedium: sora(textStyle: textTheme.displayMedium),
      displaySmall: sora(textStyle: textTheme.displaySmall),
      headlineLarge: sora(textStyle: textTheme.headlineLarge),
      headlineMedium: sora(textStyle: textTheme.headlineMedium),
      headlineSmall: sora(textStyle: textTheme.headlineSmall),
      titleLarge: sora(textStyle: textTheme.titleLarge),
      titleMedium: sora(textStyle: textTheme.titleMedium),
      titleSmall: sora(textStyle: textTheme.titleSmall),
      bodyLarge: sora(textStyle: textTheme.bodyLarge),
      bodyMedium: sora(textStyle: textTheme.bodyMedium),
      bodySmall: sora(textStyle: textTheme.bodySmall),
      labelLarge: sora(textStyle: textTheme.labelLarge),
      labelMedium: sora(textStyle: textTheme.labelMedium),
      labelSmall: sora(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sorts Mill Goudy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sorts+Mill+Goudy
  static TextStyle sortsMillGoudy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cdae1f476791b91413d8c634564c75ba77492e9b19bcd57b2beb745f0b1ecf0e',
        77680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd878bc35c9e4dd269292312cec6939f07c267acb3018dd58548783c645811a7b',
        88084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SortsMillGoudy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sorts Mill Goudy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sorts+Mill+Goudy
  static TextTheme sortsMillGoudyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sortsMillGoudy(textStyle: textTheme.displayLarge),
      displayMedium: sortsMillGoudy(textStyle: textTheme.displayMedium),
      displaySmall: sortsMillGoudy(textStyle: textTheme.displaySmall),
      headlineLarge: sortsMillGoudy(textStyle: textTheme.headlineLarge),
      headlineMedium: sortsMillGoudy(textStyle: textTheme.headlineMedium),
      headlineSmall: sortsMillGoudy(textStyle: textTheme.headlineSmall),
      titleLarge: sortsMillGoudy(textStyle: textTheme.titleLarge),
      titleMedium: sortsMillGoudy(textStyle: textTheme.titleMedium),
      titleSmall: sortsMillGoudy(textStyle: textTheme.titleSmall),
      bodyLarge: sortsMillGoudy(textStyle: textTheme.bodyLarge),
      bodyMedium: sortsMillGoudy(textStyle: textTheme.bodyMedium),
      bodySmall: sortsMillGoudy(textStyle: textTheme.bodySmall),
      labelLarge: sortsMillGoudy(textStyle: textTheme.labelLarge),
      labelMedium: sortsMillGoudy(textStyle: textTheme.labelMedium),
      labelSmall: sortsMillGoudy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Source Code Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Source+Code+Pro
  static TextStyle sourceCodePro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76e92dd020bbcace240ed04033f1392b8d89553ef7ad17e6c7146ec7cbaa9560',
        107740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9230a532dba981dfbd6f7b78c7a00e72ead4310f64e8423601a0d132f1c7f1ae',
        108108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '954f0f1582741d0917a4867e6878f280fd6e3f75d7b6817f7f1949cd16ce0133',
        107976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '176c68e66cdf40fe1b1a3985c22695ff8307e44db6f9ed8cf38e65a05efb3cd0',
        107780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c3d57065054168e8cc5cbb84dfb1e2253b196fc03df43c212440cfe2a0648e4',
        107776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3968062e35448d7bef0dda0de775c536898cf752619c6c9242fef07df094fad9',
        107836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '434feddb1dd9737309ebad072694bed192ca80b6055572dab424644fe94fa210',
        107864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec009d54a2acf39c5eb0509e780a3c540c79d7334239ba19fc487cd63cc8e4fa',
        107372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0e1da2d90df0be48acfae1caf9f228b71799670c8ded79d45e3eaba3d49322fe',
        91212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aeb1487bfe6349bbe70e530a9413d9c087d4537e2bc21e272590ae5b1c3b332f',
        91520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f2578474a51da7978b83191b762a9d6d82b5d99208f2b2c661168d7dc3b461bb',
        91332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e09a4ebd483cfdc7b99c9bc22250abe2a29ed469e0bddbe7a9f23162066f0fba',
        91304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5e9e544f22e80a45c1694038da39ea1a3955a9d6f8f7787f35415b6ff5827897',
        91300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4c465165d435bfedce2ce338e13e7dbafb2051b36c8aac757f7204e870252061',
        91292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '58189d3f5bf597e246414af99b99d6ae036281d5bde01726021c7a682069cd26',
        91360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cedde4e0bcba9a0de74feb6d4cd9c57095754b1daffae8ea211694f1ff10c4dc',
        91048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SourceCodePro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Source Code Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Source+Code+Pro
  static TextTheme sourceCodeProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sourceCodePro(textStyle: textTheme.displayLarge),
      displayMedium: sourceCodePro(textStyle: textTheme.displayMedium),
      displaySmall: sourceCodePro(textStyle: textTheme.displaySmall),
      headlineLarge: sourceCodePro(textStyle: textTheme.headlineLarge),
      headlineMedium: sourceCodePro(textStyle: textTheme.headlineMedium),
      headlineSmall: sourceCodePro(textStyle: textTheme.headlineSmall),
      titleLarge: sourceCodePro(textStyle: textTheme.titleLarge),
      titleMedium: sourceCodePro(textStyle: textTheme.titleMedium),
      titleSmall: sourceCodePro(textStyle: textTheme.titleSmall),
      bodyLarge: sourceCodePro(textStyle: textTheme.bodyLarge),
      bodyMedium: sourceCodePro(textStyle: textTheme.bodyMedium),
      bodySmall: sourceCodePro(textStyle: textTheme.bodySmall),
      labelLarge: sourceCodePro(textStyle: textTheme.labelLarge),
      labelMedium: sourceCodePro(textStyle: textTheme.labelMedium),
      labelSmall: sourceCodePro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Source Sans 3 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Source+Sans+3
  static TextStyle sourceSans3({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c5ec4423843e562f9a0bc2b5a1a35b95ca82f5f7125591f72d397dae24dd140',
        233512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '29f5cb05ee34ecf11b13f4e30f55a530e7848110ad8738f6e7625f72edfa17cd',
        234492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91c5fb93b8d4f1f6989f3d48537ae12654b77bc6bddcf1339ea05bd733689798',
        234596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f5b990ffd3ad7620f65632e31769ee253279cbb3fbfeeb7abdf3fbe3ea6b4ff',
        234384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4624fc14488e2eee187e2dea18e49475e166982857c68473d66b68a22f35f068',
        234568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '507b9cb9f582dd1bd653b103dc8432ad05ccfa261535407a7e613678f7092f35',
        234528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27d1d656a780b21b8b3e7f6de6c3c1f5d939de864b92a7a2a5c81b4be46957d6',
        234548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddc932571a6af115db68f910fd77b3928f5acbe138528a5386fda70f0d130cbc',
        233500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a03b86f78fdb6daffdb92adf01295642de3f35d547870826904edebf3895428f',
        208248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9cbfb78b06fe73b2a3a6914227c34fe2c355b85c3ba79bd8e5cced956defc220',
        209416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8830c2020f375e9590ee84fbed51be0a03a905e633b58aae5914c889b9b6d981',
        209264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '637bfd7896218e5222ad81f318745124023478cc3a3cff1228bbde245aac7994',
        209064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'efde87eb138b42a6f760da4b006b72348ad8d7b505ea0f2e9ca2eb6004e085d1',
        209224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '49861da5e4aff04118043410293cd30a47c6b608250325eace122349dc2149cf',
        209244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '22c51e6b36b9d5517df4c571ac9afd671dd232388291bc998c56fed12a1c986e',
        209144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de7fa6e685a12569c9ada67184f280ec95bacd3eae28bc6f8f9438fc1c0944c1',
        207808,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SourceSans3',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Source Sans 3 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Source+Sans+3
  static TextTheme sourceSans3TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sourceSans3(textStyle: textTheme.displayLarge),
      displayMedium: sourceSans3(textStyle: textTheme.displayMedium),
      displaySmall: sourceSans3(textStyle: textTheme.displaySmall),
      headlineLarge: sourceSans3(textStyle: textTheme.headlineLarge),
      headlineMedium: sourceSans3(textStyle: textTheme.headlineMedium),
      headlineSmall: sourceSans3(textStyle: textTheme.headlineSmall),
      titleLarge: sourceSans3(textStyle: textTheme.titleLarge),
      titleMedium: sourceSans3(textStyle: textTheme.titleMedium),
      titleSmall: sourceSans3(textStyle: textTheme.titleSmall),
      bodyLarge: sourceSans3(textStyle: textTheme.bodyLarge),
      bodyMedium: sourceSans3(textStyle: textTheme.bodyMedium),
      bodySmall: sourceSans3(textStyle: textTheme.bodySmall),
      labelLarge: sourceSans3(textStyle: textTheme.labelLarge),
      labelMedium: sourceSans3(textStyle: textTheme.labelMedium),
      labelSmall: sourceSans3(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Source Serif 4 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Source+Serif+4
  static TextStyle sourceSerif4({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66e0755076fe2e8b56fdc081633e141beea1d4c0b553727071a6868e6ae5b5e2',
        194244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1bf84ff891c0c731a64f5ccb9c94a991071869581dd50c000f696ce482c9ef74',
        194396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e0b43fe7ad4aa9483ec6e29ead7818aad3e1353b39fa3fe881054aeb2266704',
        194352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b578aa3ed6e9defed6fd3cda4b8c3b9c46431cc60ce009d384bbdae1b091ec3',
        194604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17b01e5b3607daedddceb4f81c6a8c37498c857d6c48ba51d0bad62e43ab5bb8',
        194688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f683264e6eb08f5ed874b50e414039c9c4cbcba797799bc218873a11b387f74',
        194648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '175dc45444ddeaa8ea49298fc21dc149122f467d7984a441e4a81489170a30d5',
        194684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f3227883e8746e3071144254d58407d468205bd0f72a09a2bf393115026eb14',
        194608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '604d31aeee82565f5d0fc1632cc2e02a046ecac3842726bb8f67a5bd03e83635',
        183460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'caaebd619d6d258ebd1937172b516bae7c8d8cf18dc6bc4b4973f46ad371e1ba',
        183584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3603023b2c4c0d88c72fc70e7412619021859888a802ea4e0797325de9b34395',
        183440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5d05c09c8b141c14e134bbc4b6a37a7943874c69dddb795689b6e473c2b3e63b',
        183604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3fdaa0ae561eb45b7efc94b221ba60e840f09585e06c4f1c2ca88d92cdb6ec7b',
        183576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '98b2977b91c990e6edb97464fffba254b1bad5994576092e1b48dffbe9303dc5',
        183536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8f2abc9c0e805289a76bd7f10d82048e9a1ad5e98cec298e060c88c1f7b9487',
        183648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bae91c928355dabcf508609b6327fc536c6cfdd458f1b6026ce9440ffdda9743',
        183616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SourceSerif4',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Source Serif 4 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Source+Serif+4
  static TextTheme sourceSerif4TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sourceSerif4(textStyle: textTheme.displayLarge),
      displayMedium: sourceSerif4(textStyle: textTheme.displayMedium),
      displaySmall: sourceSerif4(textStyle: textTheme.displaySmall),
      headlineLarge: sourceSerif4(textStyle: textTheme.headlineLarge),
      headlineMedium: sourceSerif4(textStyle: textTheme.headlineMedium),
      headlineSmall: sourceSerif4(textStyle: textTheme.headlineSmall),
      titleLarge: sourceSerif4(textStyle: textTheme.titleLarge),
      titleMedium: sourceSerif4(textStyle: textTheme.titleMedium),
      titleSmall: sourceSerif4(textStyle: textTheme.titleSmall),
      bodyLarge: sourceSerif4(textStyle: textTheme.bodyLarge),
      bodyMedium: sourceSerif4(textStyle: textTheme.bodyMedium),
      bodySmall: sourceSerif4(textStyle: textTheme.bodySmall),
      labelLarge: sourceSerif4(textStyle: textTheme.labelLarge),
      labelMedium: sourceSerif4(textStyle: textTheme.labelMedium),
      labelSmall: sourceSerif4(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Space Grotesk font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Space+Grotesk
  static TextStyle spaceGrotesk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab112809e1154391eea1281bbcbeaeb71400c87aa8563ff012053aa89b992ba9',
        69376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6897af7055705f7f92dedfa8bf0743124d1962a64c1dd0b74bf50b062c7eb936',
        69336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47aa64aa8c6518f662fe0420784fa1e9cea29a4a820c245e6a11da57de7ae133',
        69392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7aa897b1b290336dbf3178a7baa371dc447a19eeb349689c4ed1d929c4c4eca1',
        69332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17d1b2f12f3a57623a66c38fda77109af0c721123e2140577f3293509bf1dc7a',
        69284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SpaceGrotesk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Space Grotesk font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Space+Grotesk
  static TextTheme spaceGroteskTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spaceGrotesk(textStyle: textTheme.displayLarge),
      displayMedium: spaceGrotesk(textStyle: textTheme.displayMedium),
      displaySmall: spaceGrotesk(textStyle: textTheme.displaySmall),
      headlineLarge: spaceGrotesk(textStyle: textTheme.headlineLarge),
      headlineMedium: spaceGrotesk(textStyle: textTheme.headlineMedium),
      headlineSmall: spaceGrotesk(textStyle: textTheme.headlineSmall),
      titleLarge: spaceGrotesk(textStyle: textTheme.titleLarge),
      titleMedium: spaceGrotesk(textStyle: textTheme.titleMedium),
      titleSmall: spaceGrotesk(textStyle: textTheme.titleSmall),
      bodyLarge: spaceGrotesk(textStyle: textTheme.bodyLarge),
      bodyMedium: spaceGrotesk(textStyle: textTheme.bodyMedium),
      bodySmall: spaceGrotesk(textStyle: textTheme.bodySmall),
      labelLarge: spaceGrotesk(textStyle: textTheme.labelLarge),
      labelMedium: spaceGrotesk(textStyle: textTheme.labelMedium),
      labelSmall: spaceGrotesk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Space Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Space+Mono
  static TextStyle spaceMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa54b134023455bae209a7394be5d936eac1bca46d8e605d136c0639440b7acd',
        48212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2cd1e0cf4f0bf5cc7cefa3e04419ab7b7871606eb89fd4546e78d419a7eaac8d',
        54092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4df88257fca899eb832e0c60a09e8ba54295efe311316176cc067e7b742a334',
        47484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82f8ac6ce5362a03d7462a633ff760ee17af98ed4d23952114ef62875269237d',
        51892,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SpaceMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Space Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Space+Mono
  static TextTheme spaceMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spaceMono(textStyle: textTheme.displayLarge),
      displayMedium: spaceMono(textStyle: textTheme.displayMedium),
      displaySmall: spaceMono(textStyle: textTheme.displaySmall),
      headlineLarge: spaceMono(textStyle: textTheme.headlineLarge),
      headlineMedium: spaceMono(textStyle: textTheme.headlineMedium),
      headlineSmall: spaceMono(textStyle: textTheme.headlineSmall),
      titleLarge: spaceMono(textStyle: textTheme.titleLarge),
      titleMedium: spaceMono(textStyle: textTheme.titleMedium),
      titleSmall: spaceMono(textStyle: textTheme.titleSmall),
      bodyLarge: spaceMono(textStyle: textTheme.bodyLarge),
      bodyMedium: spaceMono(textStyle: textTheme.bodyMedium),
      bodySmall: spaceMono(textStyle: textTheme.bodySmall),
      labelLarge: spaceMono(textStyle: textTheme.labelLarge),
      labelMedium: spaceMono(textStyle: textTheme.labelMedium),
      labelSmall: spaceMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Special Elite font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Special+Elite
  static TextStyle specialElite({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ded65eb5905cf9e7d31ff36040588af54d5d8ce32450d92635b002c7e0878041',
        150108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SpecialElite',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Special Elite font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Special+Elite
  static TextTheme specialEliteTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: specialElite(textStyle: textTheme.displayLarge),
      displayMedium: specialElite(textStyle: textTheme.displayMedium),
      displaySmall: specialElite(textStyle: textTheme.displaySmall),
      headlineLarge: specialElite(textStyle: textTheme.headlineLarge),
      headlineMedium: specialElite(textStyle: textTheme.headlineMedium),
      headlineSmall: specialElite(textStyle: textTheme.headlineSmall),
      titleLarge: specialElite(textStyle: textTheme.titleLarge),
      titleMedium: specialElite(textStyle: textTheme.titleMedium),
      titleSmall: specialElite(textStyle: textTheme.titleSmall),
      bodyLarge: specialElite(textStyle: textTheme.bodyLarge),
      bodyMedium: specialElite(textStyle: textTheme.bodyMedium),
      bodySmall: specialElite(textStyle: textTheme.bodySmall),
      labelLarge: specialElite(textStyle: textTheme.labelLarge),
      labelMedium: specialElite(textStyle: textTheme.labelMedium),
      labelSmall: specialElite(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spectral font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spectral
  static TextStyle spectral({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '143489bdb33446843a7f5057dbc54aa03819611f7c51b91eda3d2cfcdb99146c',
        122192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7d1080be325941a08c30c3d3e659edeec80d1e86d42e052154f637253f1dbe41',
        131480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed70c3fdfbe06ee68ddda4f0eb9cff96b861bd00537bce55c21c732f73e2127d',
        130228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aca59f120085a381420ed835342614c602db6a15ec1fca6eb4ea41ff6906d35e',
        140812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26ff588f0b0091d70f199c596f26a37c46ec5974fae68ab83dced38fb4ba7b4a',
        125132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'de3a4052569421b916b26db38fe0debdc53b3105250634af24a8f575ea833856',
        136032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a350df193e643e1d49c5e5321b00290710960594763d9d388f81c5ca98670e8b',
        131832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b14d802583c02441dcaeb4af09b834e079a14835dc700ac6e80fe5bd8def81e5',
        141440,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db7a4efc093ffebca58478681f68167941c380c78c9a953cf287cd57c2ba1b1c',
        131904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b8cb236e60a988e1bd30b9bdb9ed4084eeb8cf408130c662036c1d3c54611f83',
        141264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85aecd0b4d4675b980a374ce588d5020116a5e728439f257f2c867c75439448b',
        131808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a81dc681006f72164f3d2c01e29e8bff6c1af5d29286f8087f340d69b46fbb90',
        141528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5b954075b1430acfd3685291478b568ba1394dcb40da87b89c9aad09a53b510',
        125748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18d3f52ff388af6194a0f0166e64221cc7bf675a9a8d52aef0ca06e7273a916a',
        133316,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Spectral',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spectral font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spectral
  static TextTheme spectralTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spectral(textStyle: textTheme.displayLarge),
      displayMedium: spectral(textStyle: textTheme.displayMedium),
      displaySmall: spectral(textStyle: textTheme.displaySmall),
      headlineLarge: spectral(textStyle: textTheme.headlineLarge),
      headlineMedium: spectral(textStyle: textTheme.headlineMedium),
      headlineSmall: spectral(textStyle: textTheme.headlineSmall),
      titleLarge: spectral(textStyle: textTheme.titleLarge),
      titleMedium: spectral(textStyle: textTheme.titleMedium),
      titleSmall: spectral(textStyle: textTheme.titleSmall),
      bodyLarge: spectral(textStyle: textTheme.bodyLarge),
      bodyMedium: spectral(textStyle: textTheme.bodyMedium),
      bodySmall: spectral(textStyle: textTheme.bodySmall),
      labelLarge: spectral(textStyle: textTheme.labelLarge),
      labelMedium: spectral(textStyle: textTheme.labelMedium),
      labelSmall: spectral(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spectral SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spectral+SC
  static TextStyle spectralSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb4b65c727ef9da65a9efc85f710c4d5a202dd9b9bc77ba602298d038ddccab4',
        111132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd5dac141218d62e6a3a3c42ee6320766d33063f2225ab69129bad0240832e4f2',
        123508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3a808ddb0854bd202a668f8c2d0aa67c28645b46d0e004067d367bb61f9db04',
        127760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '91ab0f7716e797f92eedeee78f7e0acd71037e35d3220b67333bf999d370b4dc',
        133880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'efd0c0d2d3df37e13f8630753e02f6bd21d78180e6955749fc046d32c6a20904',
        125908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1e9e31728f2a0b91a5b7e4f637c5a422901915c36d3b0b01895917f88e29c4ae',
        128120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc7f899027f61f5d3b481fd27b13ee942769d1794f60f9b58184ca69ab77ab2f',
        132684,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15dad6b22d494e11ab5ff630ec4439e08945defafb54982e24d3225a44dbc8ed',
        135288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56d62ffb467d62f0453b745a3b803925be196fab4ae0c7738637323102ea57b6',
        132760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f3b3ba7715e9f1f8545d2c26276c9e949916e67693ef1bec38c7ec5e1f041783',
        135276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9a132853c4e87c300a391bb0364f3d3277e8f2640e4b79dda34b3410a4a3a78',
        132652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '314da550ee2a39143066fd61ba3e0f8e448aee5e58fcdda5d62541857edef8b9',
        135416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b72090a22468df07e11763296411501d85d96f1a9070ff0c5956bfe82c8d9c29',
        126212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f291f55fc740972bc0b25a119946cc3b39435d69fce8cc1f2c95ea11d88be50e',
        130492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SpectralSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spectral SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spectral+SC
  static TextTheme spectralScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spectralSc(textStyle: textTheme.displayLarge),
      displayMedium: spectralSc(textStyle: textTheme.displayMedium),
      displaySmall: spectralSc(textStyle: textTheme.displaySmall),
      headlineLarge: spectralSc(textStyle: textTheme.headlineLarge),
      headlineMedium: spectralSc(textStyle: textTheme.headlineMedium),
      headlineSmall: spectralSc(textStyle: textTheme.headlineSmall),
      titleLarge: spectralSc(textStyle: textTheme.titleLarge),
      titleMedium: spectralSc(textStyle: textTheme.titleMedium),
      titleSmall: spectralSc(textStyle: textTheme.titleSmall),
      bodyLarge: spectralSc(textStyle: textTheme.bodyLarge),
      bodyMedium: spectralSc(textStyle: textTheme.bodyMedium),
      bodySmall: spectralSc(textStyle: textTheme.bodySmall),
      labelLarge: spectralSc(textStyle: textTheme.labelLarge),
      labelMedium: spectralSc(textStyle: textTheme.labelMedium),
      labelSmall: spectralSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spicy Rice font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spicy+Rice
  static TextStyle spicyRice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b32aec7a162c56cd024ebc5edd804b7540e985bb4fde0cd6db6a6108b98766bf',
        64692,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SpicyRice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spicy Rice font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spicy+Rice
  static TextTheme spicyRiceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spicyRice(textStyle: textTheme.displayLarge),
      displayMedium: spicyRice(textStyle: textTheme.displayMedium),
      displaySmall: spicyRice(textStyle: textTheme.displaySmall),
      headlineLarge: spicyRice(textStyle: textTheme.headlineLarge),
      headlineMedium: spicyRice(textStyle: textTheme.headlineMedium),
      headlineSmall: spicyRice(textStyle: textTheme.headlineSmall),
      titleLarge: spicyRice(textStyle: textTheme.titleLarge),
      titleMedium: spicyRice(textStyle: textTheme.titleMedium),
      titleSmall: spicyRice(textStyle: textTheme.titleSmall),
      bodyLarge: spicyRice(textStyle: textTheme.bodyLarge),
      bodyMedium: spicyRice(textStyle: textTheme.bodyMedium),
      bodySmall: spicyRice(textStyle: textTheme.bodySmall),
      labelLarge: spicyRice(textStyle: textTheme.labelLarge),
      labelMedium: spicyRice(textStyle: textTheme.labelMedium),
      labelSmall: spicyRice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spinnaker font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spinnaker
  static TextStyle spinnaker({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0af978a1c594e9e946a9d079c1a4af1ce888d06bbcb095cd9b822ae0ef39d142',
        19608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Spinnaker',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spinnaker font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spinnaker
  static TextTheme spinnakerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spinnaker(textStyle: textTheme.displayLarge),
      displayMedium: spinnaker(textStyle: textTheme.displayMedium),
      displaySmall: spinnaker(textStyle: textTheme.displaySmall),
      headlineLarge: spinnaker(textStyle: textTheme.headlineLarge),
      headlineMedium: spinnaker(textStyle: textTheme.headlineMedium),
      headlineSmall: spinnaker(textStyle: textTheme.headlineSmall),
      titleLarge: spinnaker(textStyle: textTheme.titleLarge),
      titleMedium: spinnaker(textStyle: textTheme.titleMedium),
      titleSmall: spinnaker(textStyle: textTheme.titleSmall),
      bodyLarge: spinnaker(textStyle: textTheme.bodyLarge),
      bodyMedium: spinnaker(textStyle: textTheme.bodyMedium),
      bodySmall: spinnaker(textStyle: textTheme.bodySmall),
      labelLarge: spinnaker(textStyle: textTheme.labelLarge),
      labelMedium: spinnaker(textStyle: textTheme.labelMedium),
      labelSmall: spinnaker(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spirax font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spirax
  static TextStyle spirax({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e3a97f90a754ec544d9ceae7de625b106a472e860d8d1108c22736cc0c413c3',
        46520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Spirax',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spirax font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spirax
  static TextTheme spiraxTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: spirax(textStyle: textTheme.displayLarge),
      displayMedium: spirax(textStyle: textTheme.displayMedium),
      displaySmall: spirax(textStyle: textTheme.displaySmall),
      headlineLarge: spirax(textStyle: textTheme.headlineLarge),
      headlineMedium: spirax(textStyle: textTheme.headlineMedium),
      headlineSmall: spirax(textStyle: textTheme.headlineSmall),
      titleLarge: spirax(textStyle: textTheme.titleLarge),
      titleMedium: spirax(textStyle: textTheme.titleMedium),
      titleSmall: spirax(textStyle: textTheme.titleSmall),
      bodyLarge: spirax(textStyle: textTheme.bodyLarge),
      bodyMedium: spirax(textStyle: textTheme.bodyMedium),
      bodySmall: spirax(textStyle: textTheme.bodySmall),
      labelLarge: spirax(textStyle: textTheme.labelLarge),
      labelMedium: spirax(textStyle: textTheme.labelMedium),
      labelSmall: spirax(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Splash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Splash
  static TextStyle splash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c949f9989891dcefa6876d13148a4166767f770ed9cf21fffd51f8a4fd665ea4',
        781932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Splash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Splash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Splash
  static TextTheme splashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: splash(textStyle: textTheme.displayLarge),
      displayMedium: splash(textStyle: textTheme.displayMedium),
      displaySmall: splash(textStyle: textTheme.displaySmall),
      headlineLarge: splash(textStyle: textTheme.headlineLarge),
      headlineMedium: splash(textStyle: textTheme.headlineMedium),
      headlineSmall: splash(textStyle: textTheme.headlineSmall),
      titleLarge: splash(textStyle: textTheme.titleLarge),
      titleMedium: splash(textStyle: textTheme.titleMedium),
      titleSmall: splash(textStyle: textTheme.titleSmall),
      bodyLarge: splash(textStyle: textTheme.bodyLarge),
      bodyMedium: splash(textStyle: textTheme.bodyMedium),
      bodySmall: splash(textStyle: textTheme.bodySmall),
      labelLarge: splash(textStyle: textTheme.labelLarge),
      labelMedium: splash(textStyle: textTheme.labelMedium),
      labelSmall: splash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spline Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spline+Sans
  static TextStyle splineSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '427b4b0764d03509165f2856956bd19d1422f38d8966c5cc135e56981fdc9078',
        51136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2dd45e4e8253cb7bfa7c61403d904a8929b23ae544fe85ae6133aff693bc3002',
        51328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31a0790e308cbc1ce87497e6e7f63d00c5381c6d76a32dec83ff42a933f7cb5f',
        51308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '248fd2193cbb1a0a6466d18babda305df42883221c440fcdd49e770f0ba948c4',
        51444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30b8a030e9f1c202eda0ee3a4a824bf4b1824b20acf6dd6dee6cd018075af6b9',
        51444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SplineSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spline Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spline+Sans
  static TextTheme splineSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: splineSans(textStyle: textTheme.displayLarge),
      displayMedium: splineSans(textStyle: textTheme.displayMedium),
      displaySmall: splineSans(textStyle: textTheme.displaySmall),
      headlineLarge: splineSans(textStyle: textTheme.headlineLarge),
      headlineMedium: splineSans(textStyle: textTheme.headlineMedium),
      headlineSmall: splineSans(textStyle: textTheme.headlineSmall),
      titleLarge: splineSans(textStyle: textTheme.titleLarge),
      titleMedium: splineSans(textStyle: textTheme.titleMedium),
      titleSmall: splineSans(textStyle: textTheme.titleSmall),
      bodyLarge: splineSans(textStyle: textTheme.bodyLarge),
      bodyMedium: splineSans(textStyle: textTheme.bodyMedium),
      bodySmall: splineSans(textStyle: textTheme.bodySmall),
      labelLarge: splineSans(textStyle: textTheme.labelLarge),
      labelMedium: splineSans(textStyle: textTheme.labelMedium),
      labelSmall: splineSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Spline Sans Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spline+Sans+Mono
  static TextStyle splineSansMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e246be9a17fc6f9e73c6c52052e9d75b3e06e120c41a8e4fb17a199630c3eee',
        37728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0337089ed5003e9ad398d2feefe8b0b497e9ea124098b256f308de77231aeaf',
        37756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '26619a8f281de9d9e3d2698d6bb6e8deb50c2ce98217ebe88362d43019b14ca3',
        37716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de77cdd032f4e01b850d22b6801d236715fbba747d79bf1cc5735fd0d2f3ee59',
        38024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '341c8c0447c12fd308ce43465ae4f5a0eb9d77200bbc84796adbc2df52cea3a5',
        38004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b2129d54e42122bfcd7f7810646d23228da772ee8b8798ed464ef5e3b5c9bfd9',
        37336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e235735ca12c335a768c0248954903d83164e1ffc9d34d8d8bfb17cfd0f90ead',
        37204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4aea987d3949a079800520c727abe16f8b4f4b14de624aa0593d24c400934260',
        37256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '88ea5702a44c32037626df5f206b8e13fd2188ee3f27875316ec19bfdf9947a1',
        37460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '67fa8727d13a05fb50439094ebb7f20a7943666bb060debe8e0d22ef95958874',
        37488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SplineSansMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Spline Sans Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Spline+Sans+Mono
  static TextTheme splineSansMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: splineSansMono(textStyle: textTheme.displayLarge),
      displayMedium: splineSansMono(textStyle: textTheme.displayMedium),
      displaySmall: splineSansMono(textStyle: textTheme.displaySmall),
      headlineLarge: splineSansMono(textStyle: textTheme.headlineLarge),
      headlineMedium: splineSansMono(textStyle: textTheme.headlineMedium),
      headlineSmall: splineSansMono(textStyle: textTheme.headlineSmall),
      titleLarge: splineSansMono(textStyle: textTheme.titleLarge),
      titleMedium: splineSansMono(textStyle: textTheme.titleMedium),
      titleSmall: splineSansMono(textStyle: textTheme.titleSmall),
      bodyLarge: splineSansMono(textStyle: textTheme.bodyLarge),
      bodyMedium: splineSansMono(textStyle: textTheme.bodyMedium),
      bodySmall: splineSansMono(textStyle: textTheme.bodySmall),
      labelLarge: splineSansMono(textStyle: textTheme.labelLarge),
      labelMedium: splineSansMono(textStyle: textTheme.labelMedium),
      labelSmall: splineSansMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Squada One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Squada+One
  static TextStyle squadaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f526f16bed5b296a7bc2a0060a6827423b2e3a954be2ad2f3993b88915daeae6',
        17200,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SquadaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Squada One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Squada+One
  static TextTheme squadaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: squadaOne(textStyle: textTheme.displayLarge),
      displayMedium: squadaOne(textStyle: textTheme.displayMedium),
      displaySmall: squadaOne(textStyle: textTheme.displaySmall),
      headlineLarge: squadaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: squadaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: squadaOne(textStyle: textTheme.headlineSmall),
      titleLarge: squadaOne(textStyle: textTheme.titleLarge),
      titleMedium: squadaOne(textStyle: textTheme.titleMedium),
      titleSmall: squadaOne(textStyle: textTheme.titleSmall),
      bodyLarge: squadaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: squadaOne(textStyle: textTheme.bodyMedium),
      bodySmall: squadaOne(textStyle: textTheme.bodySmall),
      labelLarge: squadaOne(textStyle: textTheme.labelLarge),
      labelMedium: squadaOne(textStyle: textTheme.labelMedium),
      labelSmall: squadaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Square Peg font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Square+Peg
  static TextStyle squarePeg({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7ccc2e51e141c90cecbb0111cc3418c0524dbd483c9690ab1a11b85032c1650',
        88908,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SquarePeg',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Square Peg font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Square+Peg
  static TextTheme squarePegTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: squarePeg(textStyle: textTheme.displayLarge),
      displayMedium: squarePeg(textStyle: textTheme.displayMedium),
      displaySmall: squarePeg(textStyle: textTheme.displaySmall),
      headlineLarge: squarePeg(textStyle: textTheme.headlineLarge),
      headlineMedium: squarePeg(textStyle: textTheme.headlineMedium),
      headlineSmall: squarePeg(textStyle: textTheme.headlineSmall),
      titleLarge: squarePeg(textStyle: textTheme.titleLarge),
      titleMedium: squarePeg(textStyle: textTheme.titleMedium),
      titleSmall: squarePeg(textStyle: textTheme.titleSmall),
      bodyLarge: squarePeg(textStyle: textTheme.bodyLarge),
      bodyMedium: squarePeg(textStyle: textTheme.bodyMedium),
      bodySmall: squarePeg(textStyle: textTheme.bodySmall),
      labelLarge: squarePeg(textStyle: textTheme.labelLarge),
      labelMedium: squarePeg(textStyle: textTheme.labelMedium),
      labelSmall: squarePeg(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sree Krushnadevaraya font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sree+Krushnadevaraya
  static TextStyle sreeKrushnadevaraya({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd111491f9e55c069d74ceaec1655d7b871fd9c08a1d793086ec88c100e9b1f44',
        405624,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SreeKrushnadevaraya',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sree Krushnadevaraya font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sree+Krushnadevaraya
  static TextTheme sreeKrushnadevarayaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sreeKrushnadevaraya(textStyle: textTheme.displayLarge),
      displayMedium: sreeKrushnadevaraya(textStyle: textTheme.displayMedium),
      displaySmall: sreeKrushnadevaraya(textStyle: textTheme.displaySmall),
      headlineLarge: sreeKrushnadevaraya(textStyle: textTheme.headlineLarge),
      headlineMedium: sreeKrushnadevaraya(textStyle: textTheme.headlineMedium),
      headlineSmall: sreeKrushnadevaraya(textStyle: textTheme.headlineSmall),
      titleLarge: sreeKrushnadevaraya(textStyle: textTheme.titleLarge),
      titleMedium: sreeKrushnadevaraya(textStyle: textTheme.titleMedium),
      titleSmall: sreeKrushnadevaraya(textStyle: textTheme.titleSmall),
      bodyLarge: sreeKrushnadevaraya(textStyle: textTheme.bodyLarge),
      bodyMedium: sreeKrushnadevaraya(textStyle: textTheme.bodyMedium),
      bodySmall: sreeKrushnadevaraya(textStyle: textTheme.bodySmall),
      labelLarge: sreeKrushnadevaraya(textStyle: textTheme.labelLarge),
      labelMedium: sreeKrushnadevaraya(textStyle: textTheme.labelMedium),
      labelSmall: sreeKrushnadevaraya(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sriracha font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sriracha
  static TextStyle sriracha({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2abdfb413a84bb590f0ef33fd5d1f909101491d6ed38685da67943a2a5f3c5da',
        196204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sriracha',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sriracha font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sriracha
  static TextTheme srirachaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sriracha(textStyle: textTheme.displayLarge),
      displayMedium: sriracha(textStyle: textTheme.displayMedium),
      displaySmall: sriracha(textStyle: textTheme.displaySmall),
      headlineLarge: sriracha(textStyle: textTheme.headlineLarge),
      headlineMedium: sriracha(textStyle: textTheme.headlineMedium),
      headlineSmall: sriracha(textStyle: textTheme.headlineSmall),
      titleLarge: sriracha(textStyle: textTheme.titleLarge),
      titleMedium: sriracha(textStyle: textTheme.titleMedium),
      titleSmall: sriracha(textStyle: textTheme.titleSmall),
      bodyLarge: sriracha(textStyle: textTheme.bodyLarge),
      bodyMedium: sriracha(textStyle: textTheme.bodyMedium),
      bodySmall: sriracha(textStyle: textTheme.bodySmall),
      labelLarge: sriracha(textStyle: textTheme.labelLarge),
      labelMedium: sriracha(textStyle: textTheme.labelMedium),
      labelSmall: sriracha(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Srisakdi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Srisakdi
  static TextStyle srisakdi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7775169e0ffb04258245a10dc995dd95347714eb5f3a371a4712444fb78aca9f',
        96252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56babac71f8dce0d0a1d042b2f8e0ff70d5c8103846d8fd5e5d03058b6f509db',
        96120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Srisakdi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Srisakdi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Srisakdi
  static TextTheme srisakdiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: srisakdi(textStyle: textTheme.displayLarge),
      displayMedium: srisakdi(textStyle: textTheme.displayMedium),
      displaySmall: srisakdi(textStyle: textTheme.displaySmall),
      headlineLarge: srisakdi(textStyle: textTheme.headlineLarge),
      headlineMedium: srisakdi(textStyle: textTheme.headlineMedium),
      headlineSmall: srisakdi(textStyle: textTheme.headlineSmall),
      titleLarge: srisakdi(textStyle: textTheme.titleLarge),
      titleMedium: srisakdi(textStyle: textTheme.titleMedium),
      titleSmall: srisakdi(textStyle: textTheme.titleSmall),
      bodyLarge: srisakdi(textStyle: textTheme.bodyLarge),
      bodyMedium: srisakdi(textStyle: textTheme.bodyMedium),
      bodySmall: srisakdi(textStyle: textTheme.bodySmall),
      labelLarge: srisakdi(textStyle: textTheme.labelLarge),
      labelMedium: srisakdi(textStyle: textTheme.labelMedium),
      labelSmall: srisakdi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Staatliches font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Staatliches
  static TextStyle staatliches({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1c82fa66aa28b7170f9e110b1e70c3f054f62ea32a9fa4753ab24843d292158',
        42164,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Staatliches',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Staatliches font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Staatliches
  static TextTheme staatlichesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: staatliches(textStyle: textTheme.displayLarge),
      displayMedium: staatliches(textStyle: textTheme.displayMedium),
      displaySmall: staatliches(textStyle: textTheme.displaySmall),
      headlineLarge: staatliches(textStyle: textTheme.headlineLarge),
      headlineMedium: staatliches(textStyle: textTheme.headlineMedium),
      headlineSmall: staatliches(textStyle: textTheme.headlineSmall),
      titleLarge: staatliches(textStyle: textTheme.titleLarge),
      titleMedium: staatliches(textStyle: textTheme.titleMedium),
      titleSmall: staatliches(textStyle: textTheme.titleSmall),
      bodyLarge: staatliches(textStyle: textTheme.bodyLarge),
      bodyMedium: staatliches(textStyle: textTheme.bodyMedium),
      bodySmall: staatliches(textStyle: textTheme.bodySmall),
      labelLarge: staatliches(textStyle: textTheme.labelLarge),
      labelMedium: staatliches(textStyle: textTheme.labelMedium),
      labelSmall: staatliches(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stalemate font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stalemate
  static TextStyle stalemate({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c100775bc3fe733ef4ef381c8e050e30aae846d86cb93270e9218e8423ccda6f',
        71200,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Stalemate',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stalemate font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stalemate
  static TextTheme stalemateTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stalemate(textStyle: textTheme.displayLarge),
      displayMedium: stalemate(textStyle: textTheme.displayMedium),
      displaySmall: stalemate(textStyle: textTheme.displaySmall),
      headlineLarge: stalemate(textStyle: textTheme.headlineLarge),
      headlineMedium: stalemate(textStyle: textTheme.headlineMedium),
      headlineSmall: stalemate(textStyle: textTheme.headlineSmall),
      titleLarge: stalemate(textStyle: textTheme.titleLarge),
      titleMedium: stalemate(textStyle: textTheme.titleMedium),
      titleSmall: stalemate(textStyle: textTheme.titleSmall),
      bodyLarge: stalemate(textStyle: textTheme.bodyLarge),
      bodyMedium: stalemate(textStyle: textTheme.bodyMedium),
      bodySmall: stalemate(textStyle: textTheme.bodySmall),
      labelLarge: stalemate(textStyle: textTheme.labelLarge),
      labelMedium: stalemate(textStyle: textTheme.labelMedium),
      labelSmall: stalemate(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stalinist One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stalinist+One
  static TextStyle stalinistOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98e18e4854d8430e2c89e895474cc8aec3b39b7df2959df9d7c6da7ceb2371ee',
        28864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'StalinistOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stalinist One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stalinist+One
  static TextTheme stalinistOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stalinistOne(textStyle: textTheme.displayLarge),
      displayMedium: stalinistOne(textStyle: textTheme.displayMedium),
      displaySmall: stalinistOne(textStyle: textTheme.displaySmall),
      headlineLarge: stalinistOne(textStyle: textTheme.headlineLarge),
      headlineMedium: stalinistOne(textStyle: textTheme.headlineMedium),
      headlineSmall: stalinistOne(textStyle: textTheme.headlineSmall),
      titleLarge: stalinistOne(textStyle: textTheme.titleLarge),
      titleMedium: stalinistOne(textStyle: textTheme.titleMedium),
      titleSmall: stalinistOne(textStyle: textTheme.titleSmall),
      bodyLarge: stalinistOne(textStyle: textTheme.bodyLarge),
      bodyMedium: stalinistOne(textStyle: textTheme.bodyMedium),
      bodySmall: stalinistOne(textStyle: textTheme.bodySmall),
      labelLarge: stalinistOne(textStyle: textTheme.labelLarge),
      labelMedium: stalinistOne(textStyle: textTheme.labelMedium),
      labelSmall: stalinistOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stardos Stencil font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stardos+Stencil
  static TextStyle stardosStencil({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f36d178fe86ede4b4236dc32256e0c39b00c9de99db521edb78736e37a853dba',
        42388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3af5016db7cfe1b84326a7f95fdd0ced69e486d50e472e4e7a80befbce89ff92',
        33020,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'StardosStencil',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stardos Stencil font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stardos+Stencil
  static TextTheme stardosStencilTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stardosStencil(textStyle: textTheme.displayLarge),
      displayMedium: stardosStencil(textStyle: textTheme.displayMedium),
      displaySmall: stardosStencil(textStyle: textTheme.displaySmall),
      headlineLarge: stardosStencil(textStyle: textTheme.headlineLarge),
      headlineMedium: stardosStencil(textStyle: textTheme.headlineMedium),
      headlineSmall: stardosStencil(textStyle: textTheme.headlineSmall),
      titleLarge: stardosStencil(textStyle: textTheme.titleLarge),
      titleMedium: stardosStencil(textStyle: textTheme.titleMedium),
      titleSmall: stardosStencil(textStyle: textTheme.titleSmall),
      bodyLarge: stardosStencil(textStyle: textTheme.bodyLarge),
      bodyMedium: stardosStencil(textStyle: textTheme.bodyMedium),
      bodySmall: stardosStencil(textStyle: textTheme.bodySmall),
      labelLarge: stardosStencil(textStyle: textTheme.labelLarge),
      labelMedium: stardosStencil(textStyle: textTheme.labelMedium),
      labelSmall: stardosStencil(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stick font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stick
  static TextStyle stick({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8dcac2309797cdd0525c43f3d43ed0a218017330699f70a1f457040536ab8004',
        2043188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Stick',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stick font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stick
  static TextTheme stickTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stick(textStyle: textTheme.displayLarge),
      displayMedium: stick(textStyle: textTheme.displayMedium),
      displaySmall: stick(textStyle: textTheme.displaySmall),
      headlineLarge: stick(textStyle: textTheme.headlineLarge),
      headlineMedium: stick(textStyle: textTheme.headlineMedium),
      headlineSmall: stick(textStyle: textTheme.headlineSmall),
      titleLarge: stick(textStyle: textTheme.titleLarge),
      titleMedium: stick(textStyle: textTheme.titleMedium),
      titleSmall: stick(textStyle: textTheme.titleSmall),
      bodyLarge: stick(textStyle: textTheme.bodyLarge),
      bodyMedium: stick(textStyle: textTheme.bodyMedium),
      bodySmall: stick(textStyle: textTheme.bodySmall),
      labelLarge: stick(textStyle: textTheme.labelLarge),
      labelMedium: stick(textStyle: textTheme.labelMedium),
      labelSmall: stick(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stick No Bills font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stick+No+Bills
  static TextStyle stickNoBills({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d5d9ff20417ce1f80785df19587ef0a87eae06e25d2e17806f583827c07b2e7',
        162984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ff8f6fc09d8b0ddec07f4e030c7ce7e66fbf6707a9567c1889190fa359ef98c',
        163180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1430733b3935f72bf394d90bbbd33a5caa669389daeeba19194ef3ca9432a58c',
        163108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc04affef19976fba4c7e00172c815acabaedeb1ba9965ec93eaecd10e7e3f1e',
        163132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f09df27e656aa4af3c48b64c96e7b1b3346079845129aca6650cecff510c24b7',
        163080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a969cd4a16c7539136167a51f770e7fb5a5036aed01305fd4f6c22ac58853667',
        163008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f66a58699fcf189c4fa69e5f372b4c0d0657871c02a996277e2cc87d68b67ce7',
        162680,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'StickNoBills',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stick No Bills font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stick+No+Bills
  static TextTheme stickNoBillsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stickNoBills(textStyle: textTheme.displayLarge),
      displayMedium: stickNoBills(textStyle: textTheme.displayMedium),
      displaySmall: stickNoBills(textStyle: textTheme.displaySmall),
      headlineLarge: stickNoBills(textStyle: textTheme.headlineLarge),
      headlineMedium: stickNoBills(textStyle: textTheme.headlineMedium),
      headlineSmall: stickNoBills(textStyle: textTheme.headlineSmall),
      titleLarge: stickNoBills(textStyle: textTheme.titleLarge),
      titleMedium: stickNoBills(textStyle: textTheme.titleMedium),
      titleSmall: stickNoBills(textStyle: textTheme.titleSmall),
      bodyLarge: stickNoBills(textStyle: textTheme.bodyLarge),
      bodyMedium: stickNoBills(textStyle: textTheme.bodyMedium),
      bodySmall: stickNoBills(textStyle: textTheme.bodySmall),
      labelLarge: stickNoBills(textStyle: textTheme.labelLarge),
      labelMedium: stickNoBills(textStyle: textTheme.labelMedium),
      labelSmall: stickNoBills(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stint Ultra Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stint+Ultra+Condensed
  static TextStyle stintUltraCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33e87c795dcf22facc78395cc64bdf93722636fbb6da07d61486390c68283537',
        36956,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'StintUltraCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stint Ultra Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stint+Ultra+Condensed
  static TextTheme stintUltraCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stintUltraCondensed(textStyle: textTheme.displayLarge),
      displayMedium: stintUltraCondensed(textStyle: textTheme.displayMedium),
      displaySmall: stintUltraCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: stintUltraCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: stintUltraCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: stintUltraCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: stintUltraCondensed(textStyle: textTheme.titleLarge),
      titleMedium: stintUltraCondensed(textStyle: textTheme.titleMedium),
      titleSmall: stintUltraCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: stintUltraCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: stintUltraCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: stintUltraCondensed(textStyle: textTheme.bodySmall),
      labelLarge: stintUltraCondensed(textStyle: textTheme.labelLarge),
      labelMedium: stintUltraCondensed(textStyle: textTheme.labelMedium),
      labelSmall: stintUltraCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stint Ultra Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stint+Ultra+Expanded
  static TextStyle stintUltraExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8070a8192a0152ec0a966e30f3b860106fd2d9942ecc873c6e8d7b3a410b014c',
        39000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'StintUltraExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stint Ultra Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stint+Ultra+Expanded
  static TextTheme stintUltraExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stintUltraExpanded(textStyle: textTheme.displayLarge),
      displayMedium: stintUltraExpanded(textStyle: textTheme.displayMedium),
      displaySmall: stintUltraExpanded(textStyle: textTheme.displaySmall),
      headlineLarge: stintUltraExpanded(textStyle: textTheme.headlineLarge),
      headlineMedium: stintUltraExpanded(textStyle: textTheme.headlineMedium),
      headlineSmall: stintUltraExpanded(textStyle: textTheme.headlineSmall),
      titleLarge: stintUltraExpanded(textStyle: textTheme.titleLarge),
      titleMedium: stintUltraExpanded(textStyle: textTheme.titleMedium),
      titleSmall: stintUltraExpanded(textStyle: textTheme.titleSmall),
      bodyLarge: stintUltraExpanded(textStyle: textTheme.bodyLarge),
      bodyMedium: stintUltraExpanded(textStyle: textTheme.bodyMedium),
      bodySmall: stintUltraExpanded(textStyle: textTheme.bodySmall),
      labelLarge: stintUltraExpanded(textStyle: textTheme.labelLarge),
      labelMedium: stintUltraExpanded(textStyle: textTheme.labelMedium),
      labelSmall: stintUltraExpanded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stoke font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stoke
  static TextStyle stoke({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '058ae822e2391cbafdd147c6ec7d223061dbe3e4f9f79bf2b8b3cb8db8c3a8f2',
        47324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80f4c7e15765824a9bb575ae5024766dc62cd6b1a4d21a220d2a4d16175e60a3',
        49124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Stoke',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stoke font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stoke
  static TextTheme stokeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stoke(textStyle: textTheme.displayLarge),
      displayMedium: stoke(textStyle: textTheme.displayMedium),
      displaySmall: stoke(textStyle: textTheme.displaySmall),
      headlineLarge: stoke(textStyle: textTheme.headlineLarge),
      headlineMedium: stoke(textStyle: textTheme.headlineMedium),
      headlineSmall: stoke(textStyle: textTheme.headlineSmall),
      titleLarge: stoke(textStyle: textTheme.titleLarge),
      titleMedium: stoke(textStyle: textTheme.titleMedium),
      titleSmall: stoke(textStyle: textTheme.titleSmall),
      bodyLarge: stoke(textStyle: textTheme.bodyLarge),
      bodyMedium: stoke(textStyle: textTheme.bodyMedium),
      bodySmall: stoke(textStyle: textTheme.bodySmall),
      labelLarge: stoke(textStyle: textTheme.labelLarge),
      labelMedium: stoke(textStyle: textTheme.labelMedium),
      labelSmall: stoke(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Strait font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Strait
  static TextStyle strait({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '391a7049085bcd6098a7768dabb2633d4f79c8b28107ac2e3a370a71412b3f22',
        38616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Strait',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Strait font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Strait
  static TextTheme straitTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: strait(textStyle: textTheme.displayLarge),
      displayMedium: strait(textStyle: textTheme.displayMedium),
      displaySmall: strait(textStyle: textTheme.displaySmall),
      headlineLarge: strait(textStyle: textTheme.headlineLarge),
      headlineMedium: strait(textStyle: textTheme.headlineMedium),
      headlineSmall: strait(textStyle: textTheme.headlineSmall),
      titleLarge: strait(textStyle: textTheme.titleLarge),
      titleMedium: strait(textStyle: textTheme.titleMedium),
      titleSmall: strait(textStyle: textTheme.titleSmall),
      bodyLarge: strait(textStyle: textTheme.bodyLarge),
      bodyMedium: strait(textStyle: textTheme.bodyMedium),
      bodySmall: strait(textStyle: textTheme.bodySmall),
      labelLarge: strait(textStyle: textTheme.labelLarge),
      labelMedium: strait(textStyle: textTheme.labelMedium),
      labelSmall: strait(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Style Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Style+Script
  static TextStyle styleScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '626a9eefaba4202d29c6a4e0a1dafac0a266ce59dc4e2d0898364b53d64bf55f',
        93416,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'StyleScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Style Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Style+Script
  static TextTheme styleScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: styleScript(textStyle: textTheme.displayLarge),
      displayMedium: styleScript(textStyle: textTheme.displayMedium),
      displaySmall: styleScript(textStyle: textTheme.displaySmall),
      headlineLarge: styleScript(textStyle: textTheme.headlineLarge),
      headlineMedium: styleScript(textStyle: textTheme.headlineMedium),
      headlineSmall: styleScript(textStyle: textTheme.headlineSmall),
      titleLarge: styleScript(textStyle: textTheme.titleLarge),
      titleMedium: styleScript(textStyle: textTheme.titleMedium),
      titleSmall: styleScript(textStyle: textTheme.titleSmall),
      bodyLarge: styleScript(textStyle: textTheme.bodyLarge),
      bodyMedium: styleScript(textStyle: textTheme.bodyMedium),
      bodySmall: styleScript(textStyle: textTheme.bodySmall),
      labelLarge: styleScript(textStyle: textTheme.labelLarge),
      labelMedium: styleScript(textStyle: textTheme.labelMedium),
      labelSmall: styleScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Stylish font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stylish
  static TextStyle stylish({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b136e43fc7597c5c758cad6f875c91ddfc0513ed5c18f1217dab7ca9f45acdd',
        6162664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Stylish',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Stylish font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Stylish
  static TextTheme stylishTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: stylish(textStyle: textTheme.displayLarge),
      displayMedium: stylish(textStyle: textTheme.displayMedium),
      displaySmall: stylish(textStyle: textTheme.displaySmall),
      headlineLarge: stylish(textStyle: textTheme.headlineLarge),
      headlineMedium: stylish(textStyle: textTheme.headlineMedium),
      headlineSmall: stylish(textStyle: textTheme.headlineSmall),
      titleLarge: stylish(textStyle: textTheme.titleLarge),
      titleMedium: stylish(textStyle: textTheme.titleMedium),
      titleSmall: stylish(textStyle: textTheme.titleSmall),
      bodyLarge: stylish(textStyle: textTheme.bodyLarge),
      bodyMedium: stylish(textStyle: textTheme.bodyMedium),
      bodySmall: stylish(textStyle: textTheme.bodySmall),
      labelLarge: stylish(textStyle: textTheme.labelLarge),
      labelMedium: stylish(textStyle: textTheme.labelMedium),
      labelSmall: stylish(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sue Ellen Francisco font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sue+Ellen+Francisco
  static TextStyle sueEllenFrancisco({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85181a84047b5825f7519f48a0bf4eff375a91a3273e3734c03034bd5eba29cf',
        38452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SueEllenFrancisco',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sue Ellen Francisco font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sue+Ellen+Francisco
  static TextTheme sueEllenFranciscoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sueEllenFrancisco(textStyle: textTheme.displayLarge),
      displayMedium: sueEllenFrancisco(textStyle: textTheme.displayMedium),
      displaySmall: sueEllenFrancisco(textStyle: textTheme.displaySmall),
      headlineLarge: sueEllenFrancisco(textStyle: textTheme.headlineLarge),
      headlineMedium: sueEllenFrancisco(textStyle: textTheme.headlineMedium),
      headlineSmall: sueEllenFrancisco(textStyle: textTheme.headlineSmall),
      titleLarge: sueEllenFrancisco(textStyle: textTheme.titleLarge),
      titleMedium: sueEllenFrancisco(textStyle: textTheme.titleMedium),
      titleSmall: sueEllenFrancisco(textStyle: textTheme.titleSmall),
      bodyLarge: sueEllenFrancisco(textStyle: textTheme.bodyLarge),
      bodyMedium: sueEllenFrancisco(textStyle: textTheme.bodyMedium),
      bodySmall: sueEllenFrancisco(textStyle: textTheme.bodySmall),
      labelLarge: sueEllenFrancisco(textStyle: textTheme.labelLarge),
      labelMedium: sueEllenFrancisco(textStyle: textTheme.labelMedium),
      labelSmall: sueEllenFrancisco(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Suez One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suez+One
  static TextStyle suezOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e71e2ca5c9bb6e71f3bd31e42025c7ae7fc2de017c96a057c4ea60988ec76ce3',
        62988,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SuezOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Suez One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suez+One
  static TextTheme suezOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: suezOne(textStyle: textTheme.displayLarge),
      displayMedium: suezOne(textStyle: textTheme.displayMedium),
      displaySmall: suezOne(textStyle: textTheme.displaySmall),
      headlineLarge: suezOne(textStyle: textTheme.headlineLarge),
      headlineMedium: suezOne(textStyle: textTheme.headlineMedium),
      headlineSmall: suezOne(textStyle: textTheme.headlineSmall),
      titleLarge: suezOne(textStyle: textTheme.titleLarge),
      titleMedium: suezOne(textStyle: textTheme.titleMedium),
      titleSmall: suezOne(textStyle: textTheme.titleSmall),
      bodyLarge: suezOne(textStyle: textTheme.bodyLarge),
      bodyMedium: suezOne(textStyle: textTheme.bodyMedium),
      bodySmall: suezOne(textStyle: textTheme.bodySmall),
      labelLarge: suezOne(textStyle: textTheme.labelLarge),
      labelMedium: suezOne(textStyle: textTheme.labelMedium),
      labelSmall: suezOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sulphur Point font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sulphur+Point
  static TextStyle sulphurPoint({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87bc11a73ff1fbac689043334a0f6e890d0d4093842e48267f0f5dc2600e882f',
        36536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '115dc8c9a9090d7a27c41084ac14e3d060cb9a298cdd5fe70ae01e919d6fc772',
        34424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5822e7db7610cc19e7a9af7fe3abdcac0b08bd5f64aef598977cad72e8d01c49',
        36196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SulphurPoint',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sulphur Point font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sulphur+Point
  static TextTheme sulphurPointTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sulphurPoint(textStyle: textTheme.displayLarge),
      displayMedium: sulphurPoint(textStyle: textTheme.displayMedium),
      displaySmall: sulphurPoint(textStyle: textTheme.displaySmall),
      headlineLarge: sulphurPoint(textStyle: textTheme.headlineLarge),
      headlineMedium: sulphurPoint(textStyle: textTheme.headlineMedium),
      headlineSmall: sulphurPoint(textStyle: textTheme.headlineSmall),
      titleLarge: sulphurPoint(textStyle: textTheme.titleLarge),
      titleMedium: sulphurPoint(textStyle: textTheme.titleMedium),
      titleSmall: sulphurPoint(textStyle: textTheme.titleSmall),
      bodyLarge: sulphurPoint(textStyle: textTheme.bodyLarge),
      bodyMedium: sulphurPoint(textStyle: textTheme.bodyMedium),
      bodySmall: sulphurPoint(textStyle: textTheme.bodySmall),
      labelLarge: sulphurPoint(textStyle: textTheme.labelLarge),
      labelMedium: sulphurPoint(textStyle: textTheme.labelMedium),
      labelSmall: sulphurPoint(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sumana font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sumana
  static TextStyle sumana({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '487d0e8078f8118146c6b53e28205b07d518aa4de959efc17744dca773dd5f61',
        129900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5f322c9c6dacffa7f8c0db28af9e3a3c07e08bccfd722c668fccdc96e54026b8',
        127732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sumana',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sumana font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sumana
  static TextTheme sumanaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sumana(textStyle: textTheme.displayLarge),
      displayMedium: sumana(textStyle: textTheme.displayMedium),
      displaySmall: sumana(textStyle: textTheme.displaySmall),
      headlineLarge: sumana(textStyle: textTheme.headlineLarge),
      headlineMedium: sumana(textStyle: textTheme.headlineMedium),
      headlineSmall: sumana(textStyle: textTheme.headlineSmall),
      titleLarge: sumana(textStyle: textTheme.titleLarge),
      titleMedium: sumana(textStyle: textTheme.titleMedium),
      titleSmall: sumana(textStyle: textTheme.titleSmall),
      bodyLarge: sumana(textStyle: textTheme.bodyLarge),
      bodyMedium: sumana(textStyle: textTheme.bodyMedium),
      bodySmall: sumana(textStyle: textTheme.bodySmall),
      labelLarge: sumana(textStyle: textTheme.labelLarge),
      labelMedium: sumana(textStyle: textTheme.labelMedium),
      labelSmall: sumana(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sunflower font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sunflower
  static TextStyle sunflower({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e02235d4975ffffccc84960795e6e2ced319a51673d3aca633f6727cb5ef037',
        352904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '796345d5fa846a7810f9f54374d41902b0982db9d0b704b20550ff8eb7747a69',
        341128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1008ad967420669d0007dd70b88c59b195c23e32753614c2fdbfe3cd99528ff',
        347780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sunflower',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sunflower font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sunflower
  static TextTheme sunflowerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sunflower(textStyle: textTheme.displayLarge),
      displayMedium: sunflower(textStyle: textTheme.displayMedium),
      displaySmall: sunflower(textStyle: textTheme.displaySmall),
      headlineLarge: sunflower(textStyle: textTheme.headlineLarge),
      headlineMedium: sunflower(textStyle: textTheme.headlineMedium),
      headlineSmall: sunflower(textStyle: textTheme.headlineSmall),
      titleLarge: sunflower(textStyle: textTheme.titleLarge),
      titleMedium: sunflower(textStyle: textTheme.titleMedium),
      titleSmall: sunflower(textStyle: textTheme.titleSmall),
      bodyLarge: sunflower(textStyle: textTheme.bodyLarge),
      bodyMedium: sunflower(textStyle: textTheme.bodyMedium),
      bodySmall: sunflower(textStyle: textTheme.bodySmall),
      labelLarge: sunflower(textStyle: textTheme.labelLarge),
      labelMedium: sunflower(textStyle: textTheme.labelMedium),
      labelSmall: sunflower(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sunshiney font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sunshiney
  static TextStyle sunshiney({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '340a040155260d2c6c13405367407afba0f4e8823b92c82b7dd09f7d73c42e58',
        158216,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sunshiney',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sunshiney font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sunshiney
  static TextTheme sunshineyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sunshiney(textStyle: textTheme.displayLarge),
      displayMedium: sunshiney(textStyle: textTheme.displayMedium),
      displaySmall: sunshiney(textStyle: textTheme.displaySmall),
      headlineLarge: sunshiney(textStyle: textTheme.headlineLarge),
      headlineMedium: sunshiney(textStyle: textTheme.headlineMedium),
      headlineSmall: sunshiney(textStyle: textTheme.headlineSmall),
      titleLarge: sunshiney(textStyle: textTheme.titleLarge),
      titleMedium: sunshiney(textStyle: textTheme.titleMedium),
      titleSmall: sunshiney(textStyle: textTheme.titleSmall),
      bodyLarge: sunshiney(textStyle: textTheme.bodyLarge),
      bodyMedium: sunshiney(textStyle: textTheme.bodyMedium),
      bodySmall: sunshiney(textStyle: textTheme.bodySmall),
      labelLarge: sunshiney(textStyle: textTheme.labelLarge),
      labelMedium: sunshiney(textStyle: textTheme.labelMedium),
      labelSmall: sunshiney(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Supermercado One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Supermercado+One
  static TextStyle supermercadoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '023770a0efe041f50dcf3f16e8d3b23dcb3b45b70a140058dfa6cdcdd38f1b9c',
        74196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SupermercadoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Supermercado One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Supermercado+One
  static TextTheme supermercadoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: supermercadoOne(textStyle: textTheme.displayLarge),
      displayMedium: supermercadoOne(textStyle: textTheme.displayMedium),
      displaySmall: supermercadoOne(textStyle: textTheme.displaySmall),
      headlineLarge: supermercadoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: supermercadoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: supermercadoOne(textStyle: textTheme.headlineSmall),
      titleLarge: supermercadoOne(textStyle: textTheme.titleLarge),
      titleMedium: supermercadoOne(textStyle: textTheme.titleMedium),
      titleSmall: supermercadoOne(textStyle: textTheme.titleSmall),
      bodyLarge: supermercadoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: supermercadoOne(textStyle: textTheme.bodyMedium),
      bodySmall: supermercadoOne(textStyle: textTheme.bodySmall),
      labelLarge: supermercadoOne(textStyle: textTheme.labelLarge),
      labelMedium: supermercadoOne(textStyle: textTheme.labelMedium),
      labelSmall: supermercadoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Sura font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sura
  static TextStyle sura({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd9f9ba02d52ff32486116bdcff81404de5e347a887fc6ec22e08a24e1624ef09',
        96908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '226020841a8951aff5fe07ef05a32dc8a1e495ab82bc07a24b81a7352e392626',
        97028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Sura',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Sura font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Sura
  static TextTheme suraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: sura(textStyle: textTheme.displayLarge),
      displayMedium: sura(textStyle: textTheme.displayMedium),
      displaySmall: sura(textStyle: textTheme.displaySmall),
      headlineLarge: sura(textStyle: textTheme.headlineLarge),
      headlineMedium: sura(textStyle: textTheme.headlineMedium),
      headlineSmall: sura(textStyle: textTheme.headlineSmall),
      titleLarge: sura(textStyle: textTheme.titleLarge),
      titleMedium: sura(textStyle: textTheme.titleMedium),
      titleSmall: sura(textStyle: textTheme.titleSmall),
      bodyLarge: sura(textStyle: textTheme.bodyLarge),
      bodyMedium: sura(textStyle: textTheme.bodyMedium),
      bodySmall: sura(textStyle: textTheme.bodySmall),
      labelLarge: sura(textStyle: textTheme.labelLarge),
      labelMedium: sura(textStyle: textTheme.labelMedium),
      labelSmall: sura(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Suranna font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suranna
  static TextStyle suranna({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04cb9ee9218da469b2a81c8746333d7e155ae3f8899ff7db453db59a6422a21e',
        383148,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Suranna',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Suranna font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suranna
  static TextTheme surannaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: suranna(textStyle: textTheme.displayLarge),
      displayMedium: suranna(textStyle: textTheme.displayMedium),
      displaySmall: suranna(textStyle: textTheme.displaySmall),
      headlineLarge: suranna(textStyle: textTheme.headlineLarge),
      headlineMedium: suranna(textStyle: textTheme.headlineMedium),
      headlineSmall: suranna(textStyle: textTheme.headlineSmall),
      titleLarge: suranna(textStyle: textTheme.titleLarge),
      titleMedium: suranna(textStyle: textTheme.titleMedium),
      titleSmall: suranna(textStyle: textTheme.titleSmall),
      bodyLarge: suranna(textStyle: textTheme.bodyLarge),
      bodyMedium: suranna(textStyle: textTheme.bodyMedium),
      bodySmall: suranna(textStyle: textTheme.bodySmall),
      labelLarge: suranna(textStyle: textTheme.labelLarge),
      labelMedium: suranna(textStyle: textTheme.labelMedium),
      labelSmall: suranna(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Suravaram font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suravaram
  static TextStyle suravaram({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8275b2a12413f07eba65c1a222f413a6d5d61da37ec93df6ef10419f1cfbda9a',
        182608,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Suravaram',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Suravaram font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suravaram
  static TextTheme suravaramTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: suravaram(textStyle: textTheme.displayLarge),
      displayMedium: suravaram(textStyle: textTheme.displayMedium),
      displaySmall: suravaram(textStyle: textTheme.displaySmall),
      headlineLarge: suravaram(textStyle: textTheme.headlineLarge),
      headlineMedium: suravaram(textStyle: textTheme.headlineMedium),
      headlineSmall: suravaram(textStyle: textTheme.headlineSmall),
      titleLarge: suravaram(textStyle: textTheme.titleLarge),
      titleMedium: suravaram(textStyle: textTheme.titleMedium),
      titleSmall: suravaram(textStyle: textTheme.titleSmall),
      bodyLarge: suravaram(textStyle: textTheme.bodyLarge),
      bodyMedium: suravaram(textStyle: textTheme.bodyMedium),
      bodySmall: suravaram(textStyle: textTheme.bodySmall),
      labelLarge: suravaram(textStyle: textTheme.labelLarge),
      labelMedium: suravaram(textStyle: textTheme.labelMedium),
      labelSmall: suravaram(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Suwannaphum font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suwannaphum
  static TextStyle suwannaphum({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7cc477b84d36c3a1e6172d80243b6999b1f1f25ee5675c32c4b0cea03f6c3a6',
        62484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2054f20811d48442cb78df9b02f04c09b4dd384400a65ce6777f8c1b16143836',
        57836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63fe48864b1887b1c0b381a26ca55d880febbe7563c7019cd4136856ee618aad',
        56856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '380cedf0bb7a1b00dd8ca65683925042a85bd4086bfd59bb068952b8771a9be7',
        55720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23726f1af1a12bbc901785c052ec43c38d6ad63dda299b559fd5bc3db358f1fa',
        54828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Suwannaphum',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Suwannaphum font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Suwannaphum
  static TextTheme suwannaphumTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: suwannaphum(textStyle: textTheme.displayLarge),
      displayMedium: suwannaphum(textStyle: textTheme.displayMedium),
      displaySmall: suwannaphum(textStyle: textTheme.displaySmall),
      headlineLarge: suwannaphum(textStyle: textTheme.headlineLarge),
      headlineMedium: suwannaphum(textStyle: textTheme.headlineMedium),
      headlineSmall: suwannaphum(textStyle: textTheme.headlineSmall),
      titleLarge: suwannaphum(textStyle: textTheme.titleLarge),
      titleMedium: suwannaphum(textStyle: textTheme.titleMedium),
      titleSmall: suwannaphum(textStyle: textTheme.titleSmall),
      bodyLarge: suwannaphum(textStyle: textTheme.bodyLarge),
      bodyMedium: suwannaphum(textStyle: textTheme.bodyMedium),
      bodySmall: suwannaphum(textStyle: textTheme.bodySmall),
      labelLarge: suwannaphum(textStyle: textTheme.labelLarge),
      labelMedium: suwannaphum(textStyle: textTheme.labelMedium),
      labelSmall: suwannaphum(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Swanky and Moo Moo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Swanky+and+Moo+Moo
  static TextStyle swankyAndMooMoo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee6f7a875b433b03c4b4185484db8cbc4044393e4d6079aa81b216f44d0b539f',
        44056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SwankyandMooMoo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Swanky and Moo Moo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Swanky+and+Moo+Moo
  static TextTheme swankyAndMooMooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: swankyAndMooMoo(textStyle: textTheme.displayLarge),
      displayMedium: swankyAndMooMoo(textStyle: textTheme.displayMedium),
      displaySmall: swankyAndMooMoo(textStyle: textTheme.displaySmall),
      headlineLarge: swankyAndMooMoo(textStyle: textTheme.headlineLarge),
      headlineMedium: swankyAndMooMoo(textStyle: textTheme.headlineMedium),
      headlineSmall: swankyAndMooMoo(textStyle: textTheme.headlineSmall),
      titleLarge: swankyAndMooMoo(textStyle: textTheme.titleLarge),
      titleMedium: swankyAndMooMoo(textStyle: textTheme.titleMedium),
      titleSmall: swankyAndMooMoo(textStyle: textTheme.titleSmall),
      bodyLarge: swankyAndMooMoo(textStyle: textTheme.bodyLarge),
      bodyMedium: swankyAndMooMoo(textStyle: textTheme.bodyMedium),
      bodySmall: swankyAndMooMoo(textStyle: textTheme.bodySmall),
      labelLarge: swankyAndMooMoo(textStyle: textTheme.labelLarge),
      labelMedium: swankyAndMooMoo(textStyle: textTheme.labelMedium),
      labelSmall: swankyAndMooMoo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Syncopate font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syncopate
  static TextStyle syncopate({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '299a8b368a6ed8298f0c9a66139e4a5fc6a101d1b57f89a28bb1570fdba8a84f',
        35164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1338d03efb29aec8902ddfc714a23cfbf8d830a0306d9c99086107a3723b99e8',
        32604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Syncopate',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Syncopate font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syncopate
  static TextTheme syncopateTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: syncopate(textStyle: textTheme.displayLarge),
      displayMedium: syncopate(textStyle: textTheme.displayMedium),
      displaySmall: syncopate(textStyle: textTheme.displaySmall),
      headlineLarge: syncopate(textStyle: textTheme.headlineLarge),
      headlineMedium: syncopate(textStyle: textTheme.headlineMedium),
      headlineSmall: syncopate(textStyle: textTheme.headlineSmall),
      titleLarge: syncopate(textStyle: textTheme.titleLarge),
      titleMedium: syncopate(textStyle: textTheme.titleMedium),
      titleSmall: syncopate(textStyle: textTheme.titleSmall),
      bodyLarge: syncopate(textStyle: textTheme.bodyLarge),
      bodyMedium: syncopate(textStyle: textTheme.bodyMedium),
      bodySmall: syncopate(textStyle: textTheme.bodySmall),
      labelLarge: syncopate(textStyle: textTheme.labelLarge),
      labelMedium: syncopate(textStyle: textTheme.labelMedium),
      labelSmall: syncopate(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Syne font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syne
  static TextStyle syne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b50ba67d570fde939dd3615183624c0c2d1618a18a30963ae3902218ee70f85',
        52344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cbdaab5748d9994029fa028e7452d2b44e92ad062e2604cb9b2143e72e813b4',
        52616,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '81eab38144227888f0acc178ecbe0c6fe6cfaa8125952194cc4a86e8ae7f7f62',
        52736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f802f340811b9d19b277fca970a0200b58ad867936d8ba34f477ea867764c77c',
        52708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b954dc011310056b9966299070ba11169135b2d354acd0ebfc0e31530faf46f4',
        52844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Syne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Syne font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syne
  static TextTheme syneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: syne(textStyle: textTheme.displayLarge),
      displayMedium: syne(textStyle: textTheme.displayMedium),
      displaySmall: syne(textStyle: textTheme.displaySmall),
      headlineLarge: syne(textStyle: textTheme.headlineLarge),
      headlineMedium: syne(textStyle: textTheme.headlineMedium),
      headlineSmall: syne(textStyle: textTheme.headlineSmall),
      titleLarge: syne(textStyle: textTheme.titleLarge),
      titleMedium: syne(textStyle: textTheme.titleMedium),
      titleSmall: syne(textStyle: textTheme.titleSmall),
      bodyLarge: syne(textStyle: textTheme.bodyLarge),
      bodyMedium: syne(textStyle: textTheme.bodyMedium),
      bodySmall: syne(textStyle: textTheme.bodySmall),
      labelLarge: syne(textStyle: textTheme.labelLarge),
      labelMedium: syne(textStyle: textTheme.labelMedium),
      labelSmall: syne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Syne Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syne+Mono
  static TextStyle syneMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fafc4cf13bf0649bcbac840cc061d6d2e296031c5e99fcfd8cf6375694b134c4',
        35128,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SyneMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Syne Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syne+Mono
  static TextTheme syneMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: syneMono(textStyle: textTheme.displayLarge),
      displayMedium: syneMono(textStyle: textTheme.displayMedium),
      displaySmall: syneMono(textStyle: textTheme.displaySmall),
      headlineLarge: syneMono(textStyle: textTheme.headlineLarge),
      headlineMedium: syneMono(textStyle: textTheme.headlineMedium),
      headlineSmall: syneMono(textStyle: textTheme.headlineSmall),
      titleLarge: syneMono(textStyle: textTheme.titleLarge),
      titleMedium: syneMono(textStyle: textTheme.titleMedium),
      titleSmall: syneMono(textStyle: textTheme.titleSmall),
      bodyLarge: syneMono(textStyle: textTheme.bodyLarge),
      bodyMedium: syneMono(textStyle: textTheme.bodyMedium),
      bodySmall: syneMono(textStyle: textTheme.bodySmall),
      labelLarge: syneMono(textStyle: textTheme.labelLarge),
      labelMedium: syneMono(textStyle: textTheme.labelMedium),
      labelSmall: syneMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Syne Tactile font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syne+Tactile
  static TextStyle syneTactile({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcb27bc1f445cc3306d9c5054884e1b614167b14839ccf3c67491ed56f8aa108',
        86160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'SyneTactile',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Syne Tactile font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Syne+Tactile
  static TextTheme syneTactileTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: syneTactile(textStyle: textTheme.displayLarge),
      displayMedium: syneTactile(textStyle: textTheme.displayMedium),
      displaySmall: syneTactile(textStyle: textTheme.displaySmall),
      headlineLarge: syneTactile(textStyle: textTheme.headlineLarge),
      headlineMedium: syneTactile(textStyle: textTheme.headlineMedium),
      headlineSmall: syneTactile(textStyle: textTheme.headlineSmall),
      titleLarge: syneTactile(textStyle: textTheme.titleLarge),
      titleMedium: syneTactile(textStyle: textTheme.titleMedium),
      titleSmall: syneTactile(textStyle: textTheme.titleSmall),
      bodyLarge: syneTactile(textStyle: textTheme.bodyLarge),
      bodyMedium: syneTactile(textStyle: textTheme.bodyMedium),
      bodySmall: syneTactile(textStyle: textTheme.bodySmall),
      labelLarge: syneTactile(textStyle: textTheme.labelLarge),
      labelMedium: syneTactile(textStyle: textTheme.labelMedium),
      labelSmall: syneTactile(textStyle: textTheme.labelSmall),
    );
  }
}
