// Code generated by re2c, DO NOT EDIT.
//go:generate re2go $INPUT -o $OUTPUT --loop-switch -i
package main

import "testing"

// Returns "fake" terminating null if cursor has reached limit.
func peek(str string, cursor int, limit int) byte {
	if cursor >= limit {
		return 0 // fake null
	} else {
		return str[cursor]
	}
}

// Expects a string without terminating null.
func lex(str string) int {
	var cursor, marker int
	limit := len(str)
	count := 0
loop:
	
{
	var yych byte
	yystate := 0
yyl:
	for {
		switch (yystate) {
		case 0:
			yych = peek(str, cursor, limit)
			switch (yych) {
			case ' ':
				cursor += 1
				yystate = 3
				continue yyl
			case '\'':
				cursor += 1
				yystate = 5
				continue yyl
			default:
				if (cursor >= limit) {
					yystate = 10
					continue yyl
				}
				cursor += 1
				yystate = 1
				continue yyl
			}
		case 1:
			yystate = 2
			continue yyl
		case 2:
			{ return -1 }
		case 3:
			yych = peek(str, cursor, limit)
			switch (yych) {
			case ' ':
				cursor += 1
				yystate = 3
				continue yyl
			default:
				yystate = 4
				continue yyl
			}
		case 4:
			{ goto loop }
		case 5:
			marker = cursor
			yych = peek(str, cursor, limit)
			if (yych >= 0x01) {
				yystate = 7
				continue yyl
			}
			if (cursor >= limit) {
				yystate = 2
				continue yyl
			}
			cursor += 1
			yystate = 6
			continue yyl
		case 6:
			yych = peek(str, cursor, limit)
			yystate = 7
			continue yyl
		case 7:
			switch (yych) {
			case '\'':
				cursor += 1
				yystate = 8
				continue yyl
			case '\\':
				cursor += 1
				yystate = 9
				continue yyl
			default:
				if (cursor >= limit) {
					yystate = 11
					continue yyl
				}
				cursor += 1
				yystate = 6
				continue yyl
			}
		case 8:
			{ count += 1; goto loop }
		case 9:
			yych = peek(str, cursor, limit)
			if (yych <= 0x00) {
				if (cursor >= limit) {
					yystate = 11
					continue yyl
				}
				cursor += 1
				yystate = 6
				continue yyl
			}
			cursor += 1
			yystate = 6
			continue yyl
		case 10:
			{ return count }
		case 11:
			cursor = marker
			yystate = 2
			continue yyl
		default:
			panic("internal lexer error")
		}
	}
}

}

func TestLex(t *testing.T) {
	var tests = []struct {
		res int
		str string
	}{
		{0, ""},
		{3, "'qu\000tes' 'are' 'fine: \\'' "},
		{-1, "'unterminated\\'"},
	}

	for _, x := range tests {
		t.Run(x.str, func(t *testing.T) {
			res := lex(x.str)
			if res != x.res {
				t.Errorf("got %d, want %d", res, x.res)
			}
		})
	}
}
