// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'Z'.
class PartZ {
  /// Applies the ZCOOL KuaiLe font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ZCOOL+KuaiLe
  static TextStyle zcoolKuaiLe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f6b0ea1eee74c44e089a9336b9f21d4092d7634e8e65406ba9bdfb761f8b808',
        1509564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZCOOLKuaiLe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ZCOOL KuaiLe font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ZCOOL+KuaiLe
  static TextTheme zcoolKuaiLeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zcoolKuaiLe(textStyle: textTheme.displayLarge),
      displayMedium: zcoolKuaiLe(textStyle: textTheme.displayMedium),
      displaySmall: zcoolKuaiLe(textStyle: textTheme.displaySmall),
      headlineLarge: zcoolKuaiLe(textStyle: textTheme.headlineLarge),
      headlineMedium: zcoolKuaiLe(textStyle: textTheme.headlineMedium),
      headlineSmall: zcoolKuaiLe(textStyle: textTheme.headlineSmall),
      titleLarge: zcoolKuaiLe(textStyle: textTheme.titleLarge),
      titleMedium: zcoolKuaiLe(textStyle: textTheme.titleMedium),
      titleSmall: zcoolKuaiLe(textStyle: textTheme.titleSmall),
      bodyLarge: zcoolKuaiLe(textStyle: textTheme.bodyLarge),
      bodyMedium: zcoolKuaiLe(textStyle: textTheme.bodyMedium),
      bodySmall: zcoolKuaiLe(textStyle: textTheme.bodySmall),
      labelLarge: zcoolKuaiLe(textStyle: textTheme.labelLarge),
      labelMedium: zcoolKuaiLe(textStyle: textTheme.labelMedium),
      labelSmall: zcoolKuaiLe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the ZCOOL QingKe HuangYou font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ZCOOL+QingKe+HuangYou
  static TextStyle zcoolQingKeHuangYou({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34eb0e090dcfa4189711cd20f5bbafeb1fb9e95321cbdd2fb3899daa440b624e',
        5827424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZCOOLQingKeHuangYou',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ZCOOL QingKe HuangYou font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ZCOOL+QingKe+HuangYou
  static TextTheme zcoolQingKeHuangYouTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zcoolQingKeHuangYou(textStyle: textTheme.displayLarge),
      displayMedium: zcoolQingKeHuangYou(textStyle: textTheme.displayMedium),
      displaySmall: zcoolQingKeHuangYou(textStyle: textTheme.displaySmall),
      headlineLarge: zcoolQingKeHuangYou(textStyle: textTheme.headlineLarge),
      headlineMedium: zcoolQingKeHuangYou(textStyle: textTheme.headlineMedium),
      headlineSmall: zcoolQingKeHuangYou(textStyle: textTheme.headlineSmall),
      titleLarge: zcoolQingKeHuangYou(textStyle: textTheme.titleLarge),
      titleMedium: zcoolQingKeHuangYou(textStyle: textTheme.titleMedium),
      titleSmall: zcoolQingKeHuangYou(textStyle: textTheme.titleSmall),
      bodyLarge: zcoolQingKeHuangYou(textStyle: textTheme.bodyLarge),
      bodyMedium: zcoolQingKeHuangYou(textStyle: textTheme.bodyMedium),
      bodySmall: zcoolQingKeHuangYou(textStyle: textTheme.bodySmall),
      labelLarge: zcoolQingKeHuangYou(textStyle: textTheme.labelLarge),
      labelMedium: zcoolQingKeHuangYou(textStyle: textTheme.labelMedium),
      labelSmall: zcoolQingKeHuangYou(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the ZCOOL XiaoWei font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ZCOOL+XiaoWei
  static TextStyle zcoolXiaoWei({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88f3becb57e71d70863951a31de6f30f09beacc4a0da4efd887409c265d21f9a',
        3917592,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZCOOLXiaoWei',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the ZCOOL XiaoWei font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/ZCOOL+XiaoWei
  static TextTheme zcoolXiaoWeiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zcoolXiaoWei(textStyle: textTheme.displayLarge),
      displayMedium: zcoolXiaoWei(textStyle: textTheme.displayMedium),
      displaySmall: zcoolXiaoWei(textStyle: textTheme.displaySmall),
      headlineLarge: zcoolXiaoWei(textStyle: textTheme.headlineLarge),
      headlineMedium: zcoolXiaoWei(textStyle: textTheme.headlineMedium),
      headlineSmall: zcoolXiaoWei(textStyle: textTheme.headlineSmall),
      titleLarge: zcoolXiaoWei(textStyle: textTheme.titleLarge),
      titleMedium: zcoolXiaoWei(textStyle: textTheme.titleMedium),
      titleSmall: zcoolXiaoWei(textStyle: textTheme.titleSmall),
      bodyLarge: zcoolXiaoWei(textStyle: textTheme.bodyLarge),
      bodyMedium: zcoolXiaoWei(textStyle: textTheme.bodyMedium),
      bodySmall: zcoolXiaoWei(textStyle: textTheme.bodySmall),
      labelLarge: zcoolXiaoWei(textStyle: textTheme.labelLarge),
      labelMedium: zcoolXiaoWei(textStyle: textTheme.labelMedium),
      labelSmall: zcoolXiaoWei(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Antique font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Antique
  static TextStyle zenAntique({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5194e2ed9f0bcce89bbfc2b6e65da19646fa1dd59e90d81803a59e87a9d07d87',
        5505072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenAntique',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Antique font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Antique
  static TextTheme zenAntiqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenAntique(textStyle: textTheme.displayLarge),
      displayMedium: zenAntique(textStyle: textTheme.displayMedium),
      displaySmall: zenAntique(textStyle: textTheme.displaySmall),
      headlineLarge: zenAntique(textStyle: textTheme.headlineLarge),
      headlineMedium: zenAntique(textStyle: textTheme.headlineMedium),
      headlineSmall: zenAntique(textStyle: textTheme.headlineSmall),
      titleLarge: zenAntique(textStyle: textTheme.titleLarge),
      titleMedium: zenAntique(textStyle: textTheme.titleMedium),
      titleSmall: zenAntique(textStyle: textTheme.titleSmall),
      bodyLarge: zenAntique(textStyle: textTheme.bodyLarge),
      bodyMedium: zenAntique(textStyle: textTheme.bodyMedium),
      bodySmall: zenAntique(textStyle: textTheme.bodySmall),
      labelLarge: zenAntique(textStyle: textTheme.labelLarge),
      labelMedium: zenAntique(textStyle: textTheme.labelMedium),
      labelSmall: zenAntique(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Antique Soft font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Antique+Soft
  static TextStyle zenAntiqueSoft({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6c11851b251a8fd6164f4085b8541094e5f5a6e2e5e37754e8642b13ff87c19',
        7092760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenAntiqueSoft',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Antique Soft font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Antique+Soft
  static TextTheme zenAntiqueSoftTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenAntiqueSoft(textStyle: textTheme.displayLarge),
      displayMedium: zenAntiqueSoft(textStyle: textTheme.displayMedium),
      displaySmall: zenAntiqueSoft(textStyle: textTheme.displaySmall),
      headlineLarge: zenAntiqueSoft(textStyle: textTheme.headlineLarge),
      headlineMedium: zenAntiqueSoft(textStyle: textTheme.headlineMedium),
      headlineSmall: zenAntiqueSoft(textStyle: textTheme.headlineSmall),
      titleLarge: zenAntiqueSoft(textStyle: textTheme.titleLarge),
      titleMedium: zenAntiqueSoft(textStyle: textTheme.titleMedium),
      titleSmall: zenAntiqueSoft(textStyle: textTheme.titleSmall),
      bodyLarge: zenAntiqueSoft(textStyle: textTheme.bodyLarge),
      bodyMedium: zenAntiqueSoft(textStyle: textTheme.bodyMedium),
      bodySmall: zenAntiqueSoft(textStyle: textTheme.bodySmall),
      labelLarge: zenAntiqueSoft(textStyle: textTheme.labelLarge),
      labelMedium: zenAntiqueSoft(textStyle: textTheme.labelMedium),
      labelSmall: zenAntiqueSoft(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Dots font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Dots
  static TextStyle zenDots({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd6ee080603c3c4f5aa0ee251e0eb45e4e2427de98b9877dc1ec8c67a49865e5',
        23360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenDots',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Dots font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Dots
  static TextTheme zenDotsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenDots(textStyle: textTheme.displayLarge),
      displayMedium: zenDots(textStyle: textTheme.displayMedium),
      displaySmall: zenDots(textStyle: textTheme.displaySmall),
      headlineLarge: zenDots(textStyle: textTheme.headlineLarge),
      headlineMedium: zenDots(textStyle: textTheme.headlineMedium),
      headlineSmall: zenDots(textStyle: textTheme.headlineSmall),
      titleLarge: zenDots(textStyle: textTheme.titleLarge),
      titleMedium: zenDots(textStyle: textTheme.titleMedium),
      titleSmall: zenDots(textStyle: textTheme.titleSmall),
      bodyLarge: zenDots(textStyle: textTheme.bodyLarge),
      bodyMedium: zenDots(textStyle: textTheme.bodyMedium),
      bodySmall: zenDots(textStyle: textTheme.bodySmall),
      labelLarge: zenDots(textStyle: textTheme.labelLarge),
      labelMedium: zenDots(textStyle: textTheme.labelMedium),
      labelSmall: zenDots(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Kaku Gothic Antique font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Kaku+Gothic+Antique
  static TextStyle zenKakuGothicAntique({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1da80d67e16b9876022195beaa1ea087ac76e21280255d782d5952ebb01febcb',
        2181520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f199ad31c87551e707086c1a9af6476e0dd8c0598e514fa4d855350648549c77',
        2367728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f254641a499c75a70f248f4a785864f9bb6bde9ed59a96ce85e2252c5b5d42d',
        2335124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1208cb7db2c87deeee12cd1b0f96e5c33948ea2d5a6068dacb7b985fc0d41db2',
        2321792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af8eb77ebda606e5cc01a4f4f6b2248061707977dfa40da6718ff0342f6dc830',
        2305916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenKakuGothicAntique',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Kaku Gothic Antique font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Kaku+Gothic+Antique
  static TextTheme zenKakuGothicAntiqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenKakuGothicAntique(textStyle: textTheme.displayLarge),
      displayMedium: zenKakuGothicAntique(textStyle: textTheme.displayMedium),
      displaySmall: zenKakuGothicAntique(textStyle: textTheme.displaySmall),
      headlineLarge: zenKakuGothicAntique(textStyle: textTheme.headlineLarge),
      headlineMedium: zenKakuGothicAntique(textStyle: textTheme.headlineMedium),
      headlineSmall: zenKakuGothicAntique(textStyle: textTheme.headlineSmall),
      titleLarge: zenKakuGothicAntique(textStyle: textTheme.titleLarge),
      titleMedium: zenKakuGothicAntique(textStyle: textTheme.titleMedium),
      titleSmall: zenKakuGothicAntique(textStyle: textTheme.titleSmall),
      bodyLarge: zenKakuGothicAntique(textStyle: textTheme.bodyLarge),
      bodyMedium: zenKakuGothicAntique(textStyle: textTheme.bodyMedium),
      bodySmall: zenKakuGothicAntique(textStyle: textTheme.bodySmall),
      labelLarge: zenKakuGothicAntique(textStyle: textTheme.labelLarge),
      labelMedium: zenKakuGothicAntique(textStyle: textTheme.labelMedium),
      labelSmall: zenKakuGothicAntique(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Kaku Gothic New font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Kaku+Gothic+New
  static TextStyle zenKakuGothicNew({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2596f91e83fa7623778350200f33841227d5875d5bb1525d0a23df8085a423f3',
        2178212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13e31d2bb898863a72172252e98ace4f96644e8b3baa54fa6f72f9e1b72ba897',
        2357564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d95448efb1d711f501bcafcb2cf69278c047f5319f3c04726887a19353f0334',
        2325364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8dd1c17b24d972370632cc57f6596905442f4658905eaa7a745078e0dd93c00',
        2311740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '186d3df75062486ddff39ae84fb948d002191a4db1dbe28acc9a13c8f76fb0fa',
        2297792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenKakuGothicNew',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Kaku Gothic New font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Kaku+Gothic+New
  static TextTheme zenKakuGothicNewTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenKakuGothicNew(textStyle: textTheme.displayLarge),
      displayMedium: zenKakuGothicNew(textStyle: textTheme.displayMedium),
      displaySmall: zenKakuGothicNew(textStyle: textTheme.displaySmall),
      headlineLarge: zenKakuGothicNew(textStyle: textTheme.headlineLarge),
      headlineMedium: zenKakuGothicNew(textStyle: textTheme.headlineMedium),
      headlineSmall: zenKakuGothicNew(textStyle: textTheme.headlineSmall),
      titleLarge: zenKakuGothicNew(textStyle: textTheme.titleLarge),
      titleMedium: zenKakuGothicNew(textStyle: textTheme.titleMedium),
      titleSmall: zenKakuGothicNew(textStyle: textTheme.titleSmall),
      bodyLarge: zenKakuGothicNew(textStyle: textTheme.bodyLarge),
      bodyMedium: zenKakuGothicNew(textStyle: textTheme.bodyMedium),
      bodySmall: zenKakuGothicNew(textStyle: textTheme.bodySmall),
      labelLarge: zenKakuGothicNew(textStyle: textTheme.labelLarge),
      labelMedium: zenKakuGothicNew(textStyle: textTheme.labelMedium),
      labelSmall: zenKakuGothicNew(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Kurenaido font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Kurenaido
  static TextStyle zenKurenaido({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d59a527dea3692702f7274f4dfd42d9ada242c16e7fd9d894b3e4df0d86f727',
        4300388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenKurenaido',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Kurenaido font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Kurenaido
  static TextTheme zenKurenaidoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenKurenaido(textStyle: textTheme.displayLarge),
      displayMedium: zenKurenaido(textStyle: textTheme.displayMedium),
      displaySmall: zenKurenaido(textStyle: textTheme.displaySmall),
      headlineLarge: zenKurenaido(textStyle: textTheme.headlineLarge),
      headlineMedium: zenKurenaido(textStyle: textTheme.headlineMedium),
      headlineSmall: zenKurenaido(textStyle: textTheme.headlineSmall),
      titleLarge: zenKurenaido(textStyle: textTheme.titleLarge),
      titleMedium: zenKurenaido(textStyle: textTheme.titleMedium),
      titleSmall: zenKurenaido(textStyle: textTheme.titleSmall),
      bodyLarge: zenKurenaido(textStyle: textTheme.bodyLarge),
      bodyMedium: zenKurenaido(textStyle: textTheme.bodyMedium),
      bodySmall: zenKurenaido(textStyle: textTheme.bodySmall),
      labelLarge: zenKurenaido(textStyle: textTheme.labelLarge),
      labelMedium: zenKurenaido(textStyle: textTheme.labelMedium),
      labelSmall: zenKurenaido(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Loop font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Loop
  static TextStyle zenLoop({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe97d1a558c3bc1201a3c39b2727649bbc5fafabb49e50cbc0174ae225e2019e',
        29632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2d8a14ffc68c214c62f5b82beb32b8481821d925ff7a8fc706d9018dfb445208',
        31236,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenLoop',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Loop font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Loop
  static TextTheme zenLoopTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenLoop(textStyle: textTheme.displayLarge),
      displayMedium: zenLoop(textStyle: textTheme.displayMedium),
      displaySmall: zenLoop(textStyle: textTheme.displaySmall),
      headlineLarge: zenLoop(textStyle: textTheme.headlineLarge),
      headlineMedium: zenLoop(textStyle: textTheme.headlineMedium),
      headlineSmall: zenLoop(textStyle: textTheme.headlineSmall),
      titleLarge: zenLoop(textStyle: textTheme.titleLarge),
      titleMedium: zenLoop(textStyle: textTheme.titleMedium),
      titleSmall: zenLoop(textStyle: textTheme.titleSmall),
      bodyLarge: zenLoop(textStyle: textTheme.bodyLarge),
      bodyMedium: zenLoop(textStyle: textTheme.bodyMedium),
      bodySmall: zenLoop(textStyle: textTheme.bodySmall),
      labelLarge: zenLoop(textStyle: textTheme.labelLarge),
      labelMedium: zenLoop(textStyle: textTheme.labelMedium),
      labelSmall: zenLoop(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Maru Gothic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Maru+Gothic
  static TextStyle zenMaruGothic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f364b37a65191d3ed3358707168db14641f56cbd0c76f41ed5ba0d629e28f5f',
        3720592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '189be41b75ca817dcf5b40dcbb61544c9409522306d6e8a4b34a45544e23bbf9',
        3830064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '264a433ac84944fd11a8220a4a3af42442d3d49eb73b3314d67dc04f5c17c171',
        3808184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68fb56f30194e4d394b7d8f6f7833e1837a9ea6d2b1a1121ccca01821ed7fd29',
        3776316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23cd6e1b6542e8e85384732bec7b86c88be9b7176973e0283a5c6ea68f992c11',
        3707524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenMaruGothic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Maru Gothic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Maru+Gothic
  static TextTheme zenMaruGothicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenMaruGothic(textStyle: textTheme.displayLarge),
      displayMedium: zenMaruGothic(textStyle: textTheme.displayMedium),
      displaySmall: zenMaruGothic(textStyle: textTheme.displaySmall),
      headlineLarge: zenMaruGothic(textStyle: textTheme.headlineLarge),
      headlineMedium: zenMaruGothic(textStyle: textTheme.headlineMedium),
      headlineSmall: zenMaruGothic(textStyle: textTheme.headlineSmall),
      titleLarge: zenMaruGothic(textStyle: textTheme.titleLarge),
      titleMedium: zenMaruGothic(textStyle: textTheme.titleMedium),
      titleSmall: zenMaruGothic(textStyle: textTheme.titleSmall),
      bodyLarge: zenMaruGothic(textStyle: textTheme.bodyLarge),
      bodyMedium: zenMaruGothic(textStyle: textTheme.bodyMedium),
      bodySmall: zenMaruGothic(textStyle: textTheme.bodySmall),
      labelLarge: zenMaruGothic(textStyle: textTheme.labelLarge),
      labelMedium: zenMaruGothic(textStyle: textTheme.labelMedium),
      labelSmall: zenMaruGothic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Old Mincho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Old+Mincho
  static TextStyle zenOldMincho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5cb3236e701ca61184bf1b03f5ac596cd20bbc2118b71471ed35f54b59792b81',
        5439672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd7ef1dad492f0e6b89bd02b7c8be88a6dbff7aafb074325fc3b8d577deb989f',
        5499928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9ab8116608784c966e101d6b62e52cf6fb620e3a04662750663d9a92246decc',
        5518476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c903f98b02d463d21d6badc34ebe84793527294260ab3540d97c88c137fcd541',
        5433620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2731661d4a53117dbe5c10612e4b7abcd24ccdc478765763ac6c083bd7533b17',
        5413444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenOldMincho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Old Mincho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Old+Mincho
  static TextTheme zenOldMinchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenOldMincho(textStyle: textTheme.displayLarge),
      displayMedium: zenOldMincho(textStyle: textTheme.displayMedium),
      displaySmall: zenOldMincho(textStyle: textTheme.displaySmall),
      headlineLarge: zenOldMincho(textStyle: textTheme.headlineLarge),
      headlineMedium: zenOldMincho(textStyle: textTheme.headlineMedium),
      headlineSmall: zenOldMincho(textStyle: textTheme.headlineSmall),
      titleLarge: zenOldMincho(textStyle: textTheme.titleLarge),
      titleMedium: zenOldMincho(textStyle: textTheme.titleMedium),
      titleSmall: zenOldMincho(textStyle: textTheme.titleSmall),
      bodyLarge: zenOldMincho(textStyle: textTheme.bodyLarge),
      bodyMedium: zenOldMincho(textStyle: textTheme.bodyMedium),
      bodySmall: zenOldMincho(textStyle: textTheme.bodySmall),
      labelLarge: zenOldMincho(textStyle: textTheme.labelLarge),
      labelMedium: zenOldMincho(textStyle: textTheme.labelMedium),
      labelSmall: zenOldMincho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zen Tokyo Zoo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Tokyo+Zoo
  static TextStyle zenTokyoZoo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbfc6eee5f92cac1950061ce6b0998c7ab27c687c34a50485c6a702bfe4b2be6',
        33740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZenTokyoZoo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zen Tokyo Zoo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zen+Tokyo+Zoo
  static TextTheme zenTokyoZooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zenTokyoZoo(textStyle: textTheme.displayLarge),
      displayMedium: zenTokyoZoo(textStyle: textTheme.displayMedium),
      displaySmall: zenTokyoZoo(textStyle: textTheme.displaySmall),
      headlineLarge: zenTokyoZoo(textStyle: textTheme.headlineLarge),
      headlineMedium: zenTokyoZoo(textStyle: textTheme.headlineMedium),
      headlineSmall: zenTokyoZoo(textStyle: textTheme.headlineSmall),
      titleLarge: zenTokyoZoo(textStyle: textTheme.titleLarge),
      titleMedium: zenTokyoZoo(textStyle: textTheme.titleMedium),
      titleSmall: zenTokyoZoo(textStyle: textTheme.titleSmall),
      bodyLarge: zenTokyoZoo(textStyle: textTheme.bodyLarge),
      bodyMedium: zenTokyoZoo(textStyle: textTheme.bodyMedium),
      bodySmall: zenTokyoZoo(textStyle: textTheme.bodySmall),
      labelLarge: zenTokyoZoo(textStyle: textTheme.labelLarge),
      labelMedium: zenTokyoZoo(textStyle: textTheme.labelMedium),
      labelSmall: zenTokyoZoo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zeyada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zeyada
  static TextStyle zeyada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '972982f66da1230cddaceb5423ca746fcc3d68ad5a768f560e4000f4eba0b5b7',
        48496,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Zeyada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zeyada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zeyada
  static TextTheme zeyadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zeyada(textStyle: textTheme.displayLarge),
      displayMedium: zeyada(textStyle: textTheme.displayMedium),
      displaySmall: zeyada(textStyle: textTheme.displaySmall),
      headlineLarge: zeyada(textStyle: textTheme.headlineLarge),
      headlineMedium: zeyada(textStyle: textTheme.headlineMedium),
      headlineSmall: zeyada(textStyle: textTheme.headlineSmall),
      titleLarge: zeyada(textStyle: textTheme.titleLarge),
      titleMedium: zeyada(textStyle: textTheme.titleMedium),
      titleSmall: zeyada(textStyle: textTheme.titleSmall),
      bodyLarge: zeyada(textStyle: textTheme.bodyLarge),
      bodyMedium: zeyada(textStyle: textTheme.bodyMedium),
      bodySmall: zeyada(textStyle: textTheme.bodySmall),
      labelLarge: zeyada(textStyle: textTheme.labelLarge),
      labelMedium: zeyada(textStyle: textTheme.labelMedium),
      labelSmall: zeyada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zhi Mang Xing font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zhi+Mang+Xing
  static TextStyle zhiMangXing({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f69c13808c57a2c742095a0944055a3db681e2949262bef05f1bf114d63212af',
        4051716,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZhiMangXing',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zhi Mang Xing font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zhi+Mang+Xing
  static TextTheme zhiMangXingTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zhiMangXing(textStyle: textTheme.displayLarge),
      displayMedium: zhiMangXing(textStyle: textTheme.displayMedium),
      displaySmall: zhiMangXing(textStyle: textTheme.displaySmall),
      headlineLarge: zhiMangXing(textStyle: textTheme.headlineLarge),
      headlineMedium: zhiMangXing(textStyle: textTheme.headlineMedium),
      headlineSmall: zhiMangXing(textStyle: textTheme.headlineSmall),
      titleLarge: zhiMangXing(textStyle: textTheme.titleLarge),
      titleMedium: zhiMangXing(textStyle: textTheme.titleMedium),
      titleSmall: zhiMangXing(textStyle: textTheme.titleSmall),
      bodyLarge: zhiMangXing(textStyle: textTheme.bodyLarge),
      bodyMedium: zhiMangXing(textStyle: textTheme.bodyMedium),
      bodySmall: zhiMangXing(textStyle: textTheme.bodySmall),
      labelLarge: zhiMangXing(textStyle: textTheme.labelLarge),
      labelMedium: zhiMangXing(textStyle: textTheme.labelMedium),
      labelSmall: zhiMangXing(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zilla Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zilla+Slab
  static TextStyle zillaSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '098ff14d2da0e9b254366520823452caf90d5bbb05d1a48594e4cec4ed982c23',
        94340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b3e58722827737d990592c2fbd798dc34c949d152a9915651da6f352a182b9ad',
        98148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e27c73aa9c860c6cf5484b60fbf2877b47a2a764cf554023ff9a1659b5a9527',
        94940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ceef98f8a000770741f1bf7debf5d727fa115637763220e1b4f6b062ad16e691',
        99388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb07656a0c6d822b90741d452a3f26c08a8912d417984d1b998f1eb23108e0ec',
        95756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b04ac0c02cc7094cd2a7dc7c448fa4fa76b0bbfecac528eaf4e8bb86e4ddd6ec',
        100732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19dd95c6a0ac56fe64ac4b5f0dc27b15b4acc44769355893f9324fa2af8b6ccd',
        95628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a1f8b9172d2ac7fcc41bfaf2c657d5a98d46b8ce0546daf30b379e955c61e63',
        100636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e09657275ee68dcf7ce71c430ebb52f717ca867f011cc7c645674a8e6df7212',
        96044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '12ed12c56a8283c4f35d6267f08faf96ecbaca7934ede56d72b36d3800a6a38d',
        100780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZillaSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zilla Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zilla+Slab
  static TextTheme zillaSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zillaSlab(textStyle: textTheme.displayLarge),
      displayMedium: zillaSlab(textStyle: textTheme.displayMedium),
      displaySmall: zillaSlab(textStyle: textTheme.displaySmall),
      headlineLarge: zillaSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: zillaSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: zillaSlab(textStyle: textTheme.headlineSmall),
      titleLarge: zillaSlab(textStyle: textTheme.titleLarge),
      titleMedium: zillaSlab(textStyle: textTheme.titleMedium),
      titleSmall: zillaSlab(textStyle: textTheme.titleSmall),
      bodyLarge: zillaSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: zillaSlab(textStyle: textTheme.bodyMedium),
      bodySmall: zillaSlab(textStyle: textTheme.bodySmall),
      labelLarge: zillaSlab(textStyle: textTheme.labelLarge),
      labelMedium: zillaSlab(textStyle: textTheme.labelMedium),
      labelSmall: zillaSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Zilla Slab Highlight font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zilla+Slab+Highlight
  static TextStyle zillaSlabHighlight({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b818547cf8dae690a22f13d84430c7a0e97ac187687cfdaef4a56527bd15ac46',
        80696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3f326d44980b4d43114437dbe8ca8744c8b778daadd8a7ceae1334ea662dd51',
        79820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ZillaSlabHighlight',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Zilla Slab Highlight font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Zilla+Slab+Highlight
  static TextTheme zillaSlabHighlightTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: zillaSlabHighlight(textStyle: textTheme.displayLarge),
      displayMedium: zillaSlabHighlight(textStyle: textTheme.displayMedium),
      displaySmall: zillaSlabHighlight(textStyle: textTheme.displaySmall),
      headlineLarge: zillaSlabHighlight(textStyle: textTheme.headlineLarge),
      headlineMedium: zillaSlabHighlight(textStyle: textTheme.headlineMedium),
      headlineSmall: zillaSlabHighlight(textStyle: textTheme.headlineSmall),
      titleLarge: zillaSlabHighlight(textStyle: textTheme.titleLarge),
      titleMedium: zillaSlabHighlight(textStyle: textTheme.titleMedium),
      titleSmall: zillaSlabHighlight(textStyle: textTheme.titleSmall),
      bodyLarge: zillaSlabHighlight(textStyle: textTheme.bodyLarge),
      bodyMedium: zillaSlabHighlight(textStyle: textTheme.bodyMedium),
      bodySmall: zillaSlabHighlight(textStyle: textTheme.bodySmall),
      labelLarge: zillaSlabHighlight(textStyle: textTheme.labelLarge),
      labelMedium: zillaSlabHighlight(textStyle: textTheme.labelMedium),
      labelSmall: zillaSlabHighlight(textStyle: textTheme.labelSmall),
    );
  }
}
