import pytest

URL = "https://www.reactine.ca/products/"
BANNER_CSS = "#browser-alert"


@pytest.mark.only_platforms("android")
@pytest.mark.asyncio
@pytest.mark.with_interventions
async def test_enabled(client):
    await client.navigate(URL)
    assert client.await_css(BANNER_CSS, is_displayed=False)


@pytest.mark.only_platforms("android")
@pytest.mark.asyncio
@pytest.mark.without_interventions
async def test_disabled(client):
    await client.navigate(URL)
    assert client.await_css(BANNER_CSS, is_displayed=True)
