/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.JSONMessageCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SettingsChannel {
    private static final String TAG = "SettingsChannel";
    public static final String CHANNEL_NAME = "flutter/settings";
    private static final String TEXT_SCALE_FACTOR = "textScaleFactor";
    private static final String NATIVE_SPELL_CHECK_SERVICE_DEFINED = "nativeSpellCheckServiceDefined";
    private static final String BRIEFLY_SHOW_PASSWORD = "brieflyShowPassword";
    private static final String ALWAYS_USE_24_HOUR_FORMAT = "alwaysUse24HourFormat";
    private static final String PLATFORM_BRIGHTNESS = "platformBrightness";
    private static final String CONFIGURATION_ID = "configurationId";
    private static final ConfigurationQueue CONFIGURATION_QUEUE = new ConfigurationQueue();
    @NonNull
    public final BasicMessageChannel<Object> channel;

    public SettingsChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new BasicMessageChannel<Object>(dartExecutor, CHANNEL_NAME, JSONMessageCodec.INSTANCE);
    }

    @SuppressLint(value={"AnnotateVersionCheck"})
    public static boolean hasNonlinearTextScalingSupport() {
        return Build.VERSION.SDK_INT >= 34;
    }

    public static DisplayMetrics getPastDisplayMetrics(int configId) {
        assert (SettingsChannel.hasNonlinearTextScalingSupport());
        ConfigurationQueue.SentConfiguration configuration = CONFIGURATION_QUEUE.getConfiguration(configId);
        return configuration == null ? null : configuration.displayMetrics;
    }

    @NonNull
    public MessageBuilder startMessage() {
        return new MessageBuilder(this.channel);
    }

    @VisibleForTesting
    public static class ConfigurationQueue {
        private final ConcurrentLinkedQueue<SentConfiguration> sentQueue = new ConcurrentLinkedQueue();
        private SentConfiguration currentConfiguration;
        private SentConfiguration previousEnqueuedConfiguration;

        public SentConfiguration getConfiguration(int configGeneration) {
            if (this.currentConfiguration == null) {
                this.currentConfiguration = this.sentQueue.poll();
            }
            while (this.currentConfiguration != null && this.currentConfiguration.generationNumber < configGeneration) {
                this.currentConfiguration = this.sentQueue.poll();
            }
            if (this.currentConfiguration == null) {
                Log.e(SettingsChannel.TAG, "Cannot find config with generation: " + String.valueOf(configGeneration) + ", after exhausting the queue.");
                return null;
            }
            if (this.currentConfiguration.generationNumber != configGeneration) {
                Log.e(SettingsChannel.TAG, "Cannot find config with generation: " + String.valueOf(configGeneration) + ", the oldest config is now: " + String.valueOf(this.currentConfiguration.generationNumber));
                return null;
            }
            return this.currentConfiguration;
        }

        @UiThread
        @Nullable
        public BasicMessageChannel.Reply enqueueConfiguration(SentConfiguration config) {
            this.sentQueue.add(config);
            final SentConfiguration configurationToRemove = this.previousEnqueuedConfiguration;
            this.previousEnqueuedConfiguration = config;
            return configurationToRemove == null ? null : new BasicMessageChannel.Reply(){

                @UiThread
                public void reply(Object reply) {
                    sentQueue.remove(configurationToRemove);
                    if (!sentQueue.isEmpty()) {
                        Log.e(SettingsChannel.TAG, "The queue becomes empty after removing config generation " + String.valueOf(configurationToRemove.generationNumber));
                    }
                }
            };
        }

        public static class SentConfiguration {
            private static int nextConfigGeneration = Integer.MIN_VALUE;
            @NonNull
            public final int generationNumber = nextConfigGeneration++;
            @NonNull
            private final DisplayMetrics displayMetrics;

            public SentConfiguration(@NonNull DisplayMetrics displayMetrics) {
                this.displayMetrics = displayMetrics;
            }
        }
    }

    public static class MessageBuilder {
        @NonNull
        private final BasicMessageChannel<Object> channel;
        @NonNull
        private Map<String, Object> message = new HashMap<String, Object>();
        @Nullable
        private DisplayMetrics displayMetrics;

        MessageBuilder(@NonNull BasicMessageChannel<Object> channel) {
            this.channel = channel;
        }

        @NonNull
        public MessageBuilder setDisplayMetrics(@NonNull DisplayMetrics displayMetrics) {
            this.displayMetrics = displayMetrics;
            return this;
        }

        @NonNull
        public MessageBuilder setTextScaleFactor(float textScaleFactor) {
            this.message.put(SettingsChannel.TEXT_SCALE_FACTOR, Float.valueOf(textScaleFactor));
            return this;
        }

        @NonNull
        public MessageBuilder setNativeSpellCheckServiceDefined(boolean nativeSpellCheckServiceDefined) {
            this.message.put(SettingsChannel.NATIVE_SPELL_CHECK_SERVICE_DEFINED, nativeSpellCheckServiceDefined);
            return this;
        }

        @NonNull
        public MessageBuilder setBrieflyShowPassword(@NonNull boolean brieflyShowPassword) {
            this.message.put(SettingsChannel.BRIEFLY_SHOW_PASSWORD, brieflyShowPassword);
            return this;
        }

        @NonNull
        public MessageBuilder setUse24HourFormat(boolean use24HourFormat) {
            this.message.put(SettingsChannel.ALWAYS_USE_24_HOUR_FORMAT, use24HourFormat);
            return this;
        }

        @NonNull
        public MessageBuilder setPlatformBrightness(@NonNull PlatformBrightness brightness) {
            this.message.put(SettingsChannel.PLATFORM_BRIGHTNESS, brightness.name);
            return this;
        }

        public void send() {
            Log.v(SettingsChannel.TAG, "Sending message: \ntextScaleFactor: " + this.message.get(SettingsChannel.TEXT_SCALE_FACTOR) + "\nalwaysUse24HourFormat: " + this.message.get(SettingsChannel.ALWAYS_USE_24_HOUR_FORMAT) + "\nplatformBrightness: " + this.message.get(SettingsChannel.PLATFORM_BRIGHTNESS));
            DisplayMetrics metrics = this.displayMetrics;
            if (!SettingsChannel.hasNonlinearTextScalingSupport() || metrics == null) {
                this.channel.send(this.message);
                return;
            }
            ConfigurationQueue.SentConfiguration sentConfiguration = new ConfigurationQueue.SentConfiguration(metrics);
            BasicMessageChannel.Reply deleteCallback = CONFIGURATION_QUEUE.enqueueConfiguration(sentConfiguration);
            this.message.put(SettingsChannel.CONFIGURATION_ID, sentConfiguration.generationNumber);
            this.channel.send(this.message, deleteCallback);
        }
    }

    public static enum PlatformBrightness {
        light("light"),
        dark("dark");

        @NonNull
        public String name;

        private PlatformBrightness(String name) {
            this.name = name;
        }
    }
}

