// Copyright 2023, the Chromium project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// Autogenerated from Pigeon (v11.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#undef _HAS_EXCEPTIONS

#include "messages.g.h"

#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>
#include <utility>

namespace firebase_auth_linux {
using flutter::BasicMessageChannel;
using flutter::CustomEncodableValue;
using flutter::EncodableList;
using flutter::EncodableMap;
using flutter::EncodableValue;

// PigeonMultiFactorSession

PigeonMultiFactorSession::PigeonMultiFactorSession(std::string id)
    : id_(std::move(id)) {}

const std::string& PigeonMultiFactorSession::id() const {
  return id_;
}

void PigeonMultiFactorSession::set_id(std::string_view value_arg) {
  id_ = value_arg;
}

EncodableList PigeonMultiFactorSession::ToEncodableList() const {
  EncodableList list;
  list.reserve(1);
  list.emplace_back(id_);
  return list;
}

PigeonMultiFactorSession PigeonMultiFactorSession::FromEncodableList(
    const EncodableList& list) {
  PigeonMultiFactorSession decoded(std::get<std::string>(list[0]));
  return decoded;
}

// PigeonPhoneMultiFactorAssertion

PigeonPhoneMultiFactorAssertion::PigeonPhoneMultiFactorAssertion(
    std::string verification_id,
    std::string verification_code)
    : verification_id_(std::move(verification_id)),
      verification_code_(std::move(verification_code)) {}

const std::string& PigeonPhoneMultiFactorAssertion::verification_id() const {
  return verification_id_;
}

void PigeonPhoneMultiFactorAssertion::set_verification_id(
    std::string_view value_arg) {
  verification_id_ = value_arg;
}

const std::string& PigeonPhoneMultiFactorAssertion::verification_code() const {
  return verification_code_;
}

void PigeonPhoneMultiFactorAssertion::set_verification_code(
    std::string_view value_arg) {
  verification_code_ = value_arg;
}

EncodableList PigeonPhoneMultiFactorAssertion::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.emplace_back(verification_id_);
  list.emplace_back(verification_code_);
  return list;
}

PigeonPhoneMultiFactorAssertion
PigeonPhoneMultiFactorAssertion::FromEncodableList(const EncodableList& list) {
  PigeonPhoneMultiFactorAssertion decoded(std::get<std::string>(list[0]),
                                          std::get<std::string>(list[1]));
  return decoded;
}

// PigeonMultiFactorInfo

PigeonMultiFactorInfo::PigeonMultiFactorInfo(double enrollment_timestamp,
                                             std::string uid)
    : enrollment_timestamp_(enrollment_timestamp), uid_(std::move(uid)) {}

PigeonMultiFactorInfo::PigeonMultiFactorInfo(const std::string* display_name,
                                             double enrollment_timestamp,
                                             const std::string* factor_id,
                                             std::string uid,
                                             const std::string* phone_number)
    : display_name_(display_name ? std::optional<std::string>(*display_name)
                                 : std::nullopt),
      enrollment_timestamp_(enrollment_timestamp),
      factor_id_(factor_id ? std::optional<std::string>(*factor_id)
                           : std::nullopt),
      uid_(std::move(uid)),
      phone_number_(phone_number ? std::optional<std::string>(*phone_number)
                                 : std::nullopt) {}

const std::string* PigeonMultiFactorInfo::display_name() const {
  return display_name_ ? &(*display_name_) : nullptr;
}

void PigeonMultiFactorInfo::set_display_name(
    const std::string_view* value_arg) {
  display_name_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonMultiFactorInfo::set_display_name(std::string_view value_arg) {
  display_name_ = value_arg;
}

double PigeonMultiFactorInfo::enrollment_timestamp() const {
  return enrollment_timestamp_;
}

void PigeonMultiFactorInfo::set_enrollment_timestamp(double value_arg) {
  enrollment_timestamp_ = value_arg;
}

const std::string* PigeonMultiFactorInfo::factor_id() const {
  return factor_id_ ? &(*factor_id_) : nullptr;
}

void PigeonMultiFactorInfo::set_factor_id(const std::string_view* value_arg) {
  factor_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonMultiFactorInfo::set_factor_id(std::string_view value_arg) {
  factor_id_ = value_arg;
}

const std::string& PigeonMultiFactorInfo::uid() const {
  return uid_;
}

void PigeonMultiFactorInfo::set_uid(std::string_view value_arg) {
  uid_ = value_arg;
}

const std::string* PigeonMultiFactorInfo::phone_number() const {
  return phone_number_ ? &(*phone_number_) : nullptr;
}

void PigeonMultiFactorInfo::set_phone_number(
    const std::string_view* value_arg) {
  phone_number_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonMultiFactorInfo::set_phone_number(std::string_view value_arg) {
  phone_number_ = value_arg;
}

EncodableList PigeonMultiFactorInfo::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.push_back(display_name_ ? EncodableValue(*display_name_)
                               : EncodableValue());
  list.emplace_back(enrollment_timestamp_);
  list.push_back(factor_id_ ? EncodableValue(*factor_id_) : EncodableValue());
  list.emplace_back(uid_);
  list.push_back(phone_number_ ? EncodableValue(*phone_number_)
                               : EncodableValue());
  return list;
}

PigeonMultiFactorInfo PigeonMultiFactorInfo::FromEncodableList(
    const EncodableList& list) {
  PigeonMultiFactorInfo decoded(std::get<double>(list[1]),
                                std::get<std::string>(list[3]));
  auto& encodable_display_name = list[0];
  if (!encodable_display_name.IsNull()) {
    decoded.set_display_name(std::get<std::string>(encodable_display_name));
  }
  auto& encodable_factor_id = list[2];
  if (!encodable_factor_id.IsNull()) {
    decoded.set_factor_id(std::get<std::string>(encodable_factor_id));
  }
  auto& encodable_phone_number = list[4];
  if (!encodable_phone_number.IsNull()) {
    decoded.set_phone_number(std::get<std::string>(encodable_phone_number));
  }
  return decoded;
}

// AuthPigeonFirebaseApp

AuthPigeonFirebaseApp::AuthPigeonFirebaseApp(std::string app_name)
    : app_name_(std::move(app_name)) {}

AuthPigeonFirebaseApp::AuthPigeonFirebaseApp(std::string app_name,
                                             const std::string* tenant_id)
    : app_name_(std::move(app_name)),
      tenant_id_(tenant_id ? std::optional<std::string>(*tenant_id)
                           : std::nullopt) {}

const std::string& AuthPigeonFirebaseApp::app_name() const {
  return app_name_;
}

void AuthPigeonFirebaseApp::set_app_name(std::string_view value_arg) {
  app_name_ = value_arg;
}

const std::string* AuthPigeonFirebaseApp::tenant_id() const {
  return tenant_id_ ? &(*tenant_id_) : nullptr;
}

void AuthPigeonFirebaseApp::set_tenant_id(const std::string_view* value_arg) {
  tenant_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void AuthPigeonFirebaseApp::set_tenant_id(std::string_view value_arg) {
  tenant_id_ = value_arg;
}

EncodableList AuthPigeonFirebaseApp::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.emplace_back(app_name_);
  list.push_back(tenant_id_ ? EncodableValue(*tenant_id_) : EncodableValue());
  return list;
}

AuthPigeonFirebaseApp AuthPigeonFirebaseApp::FromEncodableList(
    const EncodableList& list) {
  AuthPigeonFirebaseApp decoded(std::get<std::string>(list[0]));
  auto& encodable_tenant_id = list[1];
  if (!encodable_tenant_id.IsNull()) {
    decoded.set_tenant_id(std::get<std::string>(encodable_tenant_id));
  }
  return decoded;
}

// PigeonActionCodeInfoData

PigeonActionCodeInfoData::PigeonActionCodeInfoData() = default;

PigeonActionCodeInfoData::PigeonActionCodeInfoData(
    const std::string* email,
    const std::string* previous_email)
    : email_(email ? std::optional<std::string>(*email) : std::nullopt),
      previous_email_(previous_email
                          ? std::optional<std::string>(*previous_email)
                          : std::nullopt) {}

const std::string* PigeonActionCodeInfoData::email() const {
  return email_ ? &(*email_) : nullptr;
}

void PigeonActionCodeInfoData::set_email(const std::string_view* value_arg) {
  email_ = value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonActionCodeInfoData::set_email(std::string_view value_arg) {
  email_ = value_arg;
}

const std::string* PigeonActionCodeInfoData::previous_email() const {
  return previous_email_ ? &(*previous_email_) : nullptr;
}

void PigeonActionCodeInfoData::set_previous_email(
    const std::string_view* value_arg) {
  previous_email_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonActionCodeInfoData::set_previous_email(std::string_view value_arg) {
  previous_email_ = value_arg;
}

EncodableList PigeonActionCodeInfoData::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.push_back(email_ ? EncodableValue(*email_) : EncodableValue());
  list.push_back(previous_email_ ? EncodableValue(*previous_email_)
                                 : EncodableValue());
  return list;
}

PigeonActionCodeInfoData PigeonActionCodeInfoData::FromEncodableList(
    const EncodableList& list) {
  PigeonActionCodeInfoData decoded;
  auto& encodable_email = list[0];
  if (!encodable_email.IsNull()) {
    decoded.set_email(std::get<std::string>(encodable_email));
  }
  auto& encodable_previous_email = list[1];
  if (!encodable_previous_email.IsNull()) {
    decoded.set_previous_email(std::get<std::string>(encodable_previous_email));
  }
  return decoded;
}

// PigeonActionCodeInfo

PigeonActionCodeInfo::PigeonActionCodeInfo(
    const ActionCodeInfoOperation& operation,
    PigeonActionCodeInfoData data)
    : operation_(operation), data_(std::move(data)) {}

const ActionCodeInfoOperation& PigeonActionCodeInfo::operation() const {
  return operation_;
}

void PigeonActionCodeInfo::set_operation(
    const ActionCodeInfoOperation& value_arg) {
  operation_ = value_arg;
}

const PigeonActionCodeInfoData& PigeonActionCodeInfo::data() const {
  return data_;
}

void PigeonActionCodeInfo::set_data(const PigeonActionCodeInfoData& value_arg) {
  data_ = value_arg;
}

EncodableList PigeonActionCodeInfo::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.emplace_back((int)operation_);
  list.emplace_back(data_.ToEncodableList());
  return list;
}

PigeonActionCodeInfo PigeonActionCodeInfo::FromEncodableList(
    const EncodableList& list) {
  PigeonActionCodeInfo decoded(
      (ActionCodeInfoOperation)(std::get<int32_t>(list[0])),
      PigeonActionCodeInfoData::FromEncodableList(
          std::get<EncodableList>(list[1])));
  return decoded;
}

// PigeonAdditionalUserInfo

PigeonAdditionalUserInfo::PigeonAdditionalUserInfo(bool is_new_user)
    : is_new_user_(is_new_user) {}

PigeonAdditionalUserInfo::PigeonAdditionalUserInfo(
    bool is_new_user,
    const std::string* provider_id,
    const std::string* username,
    const std::string* authorization_code,
    const EncodableMap* profile)
    : is_new_user_(is_new_user),
      provider_id_(provider_id ? std::optional<std::string>(*provider_id)
                               : std::nullopt),
      username_(username ? std::optional<std::string>(*username)
                         : std::nullopt),
      authorization_code_(authorization_code
                              ? std::optional<std::string>(*authorization_code)
                              : std::nullopt),
      profile_(profile ? std::optional<EncodableMap>(*profile) : std::nullopt) {
}

bool PigeonAdditionalUserInfo::is_new_user() const {
  return is_new_user_;
}

void PigeonAdditionalUserInfo::set_is_new_user(bool value_arg) {
  is_new_user_ = value_arg;
}

const std::string* PigeonAdditionalUserInfo::provider_id() const {
  return provider_id_ ? &(*provider_id_) : nullptr;
}

void PigeonAdditionalUserInfo::set_provider_id(
    const std::string_view* value_arg) {
  provider_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonAdditionalUserInfo::set_provider_id(std::string_view value_arg) {
  provider_id_ = value_arg;
}

const std::string* PigeonAdditionalUserInfo::username() const {
  return username_ ? &(*username_) : nullptr;
}

void PigeonAdditionalUserInfo::set_username(const std::string_view* value_arg) {
  username_ = value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonAdditionalUserInfo::set_username(std::string_view value_arg) {
  username_ = value_arg;
}

const std::string* PigeonAdditionalUserInfo::authorization_code() const {
  return authorization_code_ ? &(*authorization_code_) : nullptr;
}

void PigeonAdditionalUserInfo::set_authorization_code(
    const std::string_view* value_arg) {
  authorization_code_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonAdditionalUserInfo::set_authorization_code(
    std::string_view value_arg) {
  authorization_code_ = value_arg;
}

const EncodableMap* PigeonAdditionalUserInfo::profile() const {
  return profile_ ? &(*profile_) : nullptr;
}

void PigeonAdditionalUserInfo::set_profile(const EncodableMap* value_arg) {
  profile_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void PigeonAdditionalUserInfo::set_profile(const EncodableMap& value_arg) {
  profile_ = value_arg;
}

EncodableList PigeonAdditionalUserInfo::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.emplace_back(is_new_user_);
  list.push_back(provider_id_ ? EncodableValue(*provider_id_)
                              : EncodableValue());
  list.push_back(username_ ? EncodableValue(*username_) : EncodableValue());
  list.push_back(authorization_code_ ? EncodableValue(*authorization_code_)
                                     : EncodableValue());
  list.push_back(profile_ ? EncodableValue(*profile_) : EncodableValue());
  return list;
}

PigeonAdditionalUserInfo PigeonAdditionalUserInfo::FromEncodableList(
    const EncodableList& list) {
  PigeonAdditionalUserInfo decoded(std::get<bool>(list[0]));
  auto& encodable_provider_id = list[1];
  if (!encodable_provider_id.IsNull()) {
    decoded.set_provider_id(std::get<std::string>(encodable_provider_id));
  }
  auto& encodable_username = list[2];
  if (!encodable_username.IsNull()) {
    decoded.set_username(std::get<std::string>(encodable_username));
  }
  auto& encodable_authorization_code = list[3];
  if (!encodable_authorization_code.IsNull()) {
    decoded.set_authorization_code(
        std::get<std::string>(encodable_authorization_code));
  }
  auto& encodable_profile = list[4];
  if (!encodable_profile.IsNull()) {
    decoded.set_profile(std::get<EncodableMap>(encodable_profile));
  }
  return decoded;
}

// PigeonAuthCredential

PigeonAuthCredential::PigeonAuthCredential(std::string provider_id,
                                           std::string sign_in_method,
                                           int64_t native_id)
    : provider_id_(std::move(provider_id)),
      sign_in_method_(std::move(sign_in_method)),
      native_id_(native_id) {}

PigeonAuthCredential::PigeonAuthCredential(std::string provider_id,
                                           std::string sign_in_method,
                                           int64_t native_id,
                                           const std::string* access_token)
    : provider_id_(std::move(provider_id)),
      sign_in_method_(std::move(sign_in_method)),
      native_id_(native_id),
      access_token_(access_token ? std::optional<std::string>(*access_token)
                                 : std::nullopt) {}

const std::string& PigeonAuthCredential::provider_id() const {
  return provider_id_;
}

void PigeonAuthCredential::set_provider_id(std::string_view value_arg) {
  provider_id_ = value_arg;
}

const std::string& PigeonAuthCredential::sign_in_method() const {
  return sign_in_method_;
}

void PigeonAuthCredential::set_sign_in_method(std::string_view value_arg) {
  sign_in_method_ = value_arg;
}

int64_t PigeonAuthCredential::native_id() const {
  return native_id_;
}

void PigeonAuthCredential::set_native_id(int64_t value_arg) {
  native_id_ = value_arg;
}

const std::string* PigeonAuthCredential::access_token() const {
  return access_token_ ? &(*access_token_) : nullptr;
}

void PigeonAuthCredential::set_access_token(const std::string_view* value_arg) {
  access_token_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonAuthCredential::set_access_token(std::string_view value_arg) {
  access_token_ = value_arg;
}

EncodableList PigeonAuthCredential::ToEncodableList() const {
  EncodableList list;
  list.reserve(4);
  list.emplace_back(provider_id_);
  list.emplace_back(sign_in_method_);
  list.emplace_back(native_id_);
  list.push_back(access_token_ ? EncodableValue(*access_token_)
                               : EncodableValue());
  return list;
}

PigeonAuthCredential PigeonAuthCredential::FromEncodableList(
    const EncodableList& list) {
  PigeonAuthCredential decoded(std::get<std::string>(list[0]),
                               std::get<std::string>(list[1]),
                               list[2].LongValue());
  auto& encodable_access_token = list[3];
  if (!encodable_access_token.IsNull()) {
    decoded.set_access_token(std::get<std::string>(encodable_access_token));
  }
  return decoded;
}

// PigeonUserInfo

PigeonUserInfo::PigeonUserInfo(std::string uid,
                               bool is_anonymous,
                               bool is_email_verified)
    : uid_(std::move(uid)),
      is_anonymous_(is_anonymous),
      is_email_verified_(is_email_verified) {}

PigeonUserInfo::PigeonUserInfo(std::string uid,
                               const std::string* email,
                               const std::string* display_name,
                               const std::string* photo_url,
                               const std::string* phone_number,
                               bool is_anonymous,
                               bool is_email_verified,
                               const std::string* provider_id,
                               const std::string* tenant_id,
                               const std::string* refresh_token,
                               const int64_t* creation_timestamp,
                               const int64_t* last_sign_in_timestamp)
    : uid_(std::move(uid)),
      email_(email ? std::optional<std::string>(*email) : std::nullopt),
      display_name_(display_name ? std::optional<std::string>(*display_name)
                                 : std::nullopt),
      photo_url_(photo_url ? std::optional<std::string>(*photo_url)
                           : std::nullopt),
      phone_number_(phone_number ? std::optional<std::string>(*phone_number)
                                 : std::nullopt),
      is_anonymous_(is_anonymous),
      is_email_verified_(is_email_verified),
      provider_id_(provider_id ? std::optional<std::string>(*provider_id)
                               : std::nullopt),
      tenant_id_(tenant_id ? std::optional<std::string>(*tenant_id)
                           : std::nullopt),
      refresh_token_(refresh_token ? std::optional<std::string>(*refresh_token)
                                   : std::nullopt),
      creation_timestamp_(creation_timestamp
                              ? std::optional<int64_t>(*creation_timestamp)
                              : std::nullopt),
      last_sign_in_timestamp_(
          last_sign_in_timestamp
              ? std::optional<int64_t>(*last_sign_in_timestamp)
              : std::nullopt) {}

const std::string& PigeonUserInfo::uid() const {
  return uid_;
}

void PigeonUserInfo::set_uid(std::string_view value_arg) {
  uid_ = value_arg;
}

const std::string* PigeonUserInfo::email() const {
  return email_ ? &(*email_) : nullptr;
}

void PigeonUserInfo::set_email(const std::string_view* value_arg) {
  email_ = value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_email(std::string_view value_arg) {
  email_ = value_arg;
}

const std::string* PigeonUserInfo::display_name() const {
  return display_name_ ? &(*display_name_) : nullptr;
}

void PigeonUserInfo::set_display_name(const std::string_view* value_arg) {
  display_name_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_display_name(std::string_view value_arg) {
  display_name_ = value_arg;
}

const std::string* PigeonUserInfo::photo_url() const {
  return photo_url_ ? &(*photo_url_) : nullptr;
}

void PigeonUserInfo::set_photo_url(const std::string_view* value_arg) {
  photo_url_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_photo_url(std::string_view value_arg) {
  photo_url_ = value_arg;
}

const std::string* PigeonUserInfo::phone_number() const {
  return phone_number_ ? &(*phone_number_) : nullptr;
}

void PigeonUserInfo::set_phone_number(const std::string_view* value_arg) {
  phone_number_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_phone_number(std::string_view value_arg) {
  phone_number_ = value_arg;
}

bool PigeonUserInfo::is_anonymous() const {
  return is_anonymous_;
}

void PigeonUserInfo::set_is_anonymous(bool value_arg) {
  is_anonymous_ = value_arg;
}

bool PigeonUserInfo::is_email_verified() const {
  return is_email_verified_;
}

void PigeonUserInfo::set_is_email_verified(bool value_arg) {
  is_email_verified_ = value_arg;
}

const std::string* PigeonUserInfo::provider_id() const {
  return provider_id_ ? &(*provider_id_) : nullptr;
}

void PigeonUserInfo::set_provider_id(const std::string_view* value_arg) {
  provider_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_provider_id(std::string_view value_arg) {
  provider_id_ = value_arg;
}

const std::string* PigeonUserInfo::tenant_id() const {
  return tenant_id_ ? &(*tenant_id_) : nullptr;
}

void PigeonUserInfo::set_tenant_id(const std::string_view* value_arg) {
  tenant_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_tenant_id(std::string_view value_arg) {
  tenant_id_ = value_arg;
}

const std::string* PigeonUserInfo::refresh_token() const {
  return refresh_token_ ? &(*refresh_token_) : nullptr;
}

void PigeonUserInfo::set_refresh_token(const std::string_view* value_arg) {
  refresh_token_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_refresh_token(std::string_view value_arg) {
  refresh_token_ = value_arg;
}

const int64_t* PigeonUserInfo::creation_timestamp() const {
  return creation_timestamp_ ? &(*creation_timestamp_) : nullptr;
}

void PigeonUserInfo::set_creation_timestamp(const int64_t* value_arg) {
  creation_timestamp_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_creation_timestamp(int64_t value_arg) {
  creation_timestamp_ = value_arg;
}

const int64_t* PigeonUserInfo::last_sign_in_timestamp() const {
  return last_sign_in_timestamp_ ? &(*last_sign_in_timestamp_) : nullptr;
}

void PigeonUserInfo::set_last_sign_in_timestamp(const int64_t* value_arg) {
  last_sign_in_timestamp_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonUserInfo::set_last_sign_in_timestamp(int64_t value_arg) {
  last_sign_in_timestamp_ = value_arg;
}

EncodableList PigeonUserInfo::ToEncodableList() const {
  EncodableList list;
  list.reserve(12);
  list.emplace_back(uid_);
  list.push_back(email_ ? EncodableValue(*email_) : EncodableValue());
  list.push_back(display_name_ ? EncodableValue(*display_name_)
                               : EncodableValue());
  list.push_back(photo_url_ ? EncodableValue(*photo_url_) : EncodableValue());
  list.push_back(phone_number_ ? EncodableValue(*phone_number_)
                               : EncodableValue());
  list.emplace_back(is_anonymous_);
  list.emplace_back(is_email_verified_);
  list.push_back(provider_id_ ? EncodableValue(*provider_id_)
                              : EncodableValue());
  list.push_back(tenant_id_ ? EncodableValue(*tenant_id_) : EncodableValue());
  list.push_back(refresh_token_ ? EncodableValue(*refresh_token_)
                                : EncodableValue());
  list.push_back(creation_timestamp_ ? EncodableValue(*creation_timestamp_)
                                     : EncodableValue());
  list.push_back(last_sign_in_timestamp_
                     ? EncodableValue(*last_sign_in_timestamp_)
                     : EncodableValue());
  return list;
}

PigeonUserInfo PigeonUserInfo::FromEncodableList(const EncodableList& list) {
  PigeonUserInfo decoded(std::get<std::string>(list[0]),
                         std::get<bool>(list[5]), std::get<bool>(list[6]));
  auto& encodable_email = list[1];
  if (!encodable_email.IsNull()) {
    decoded.set_email(std::get<std::string>(encodable_email));
  }
  auto& encodable_display_name = list[2];
  if (!encodable_display_name.IsNull()) {
    decoded.set_display_name(std::get<std::string>(encodable_display_name));
  }
  auto& encodable_photo_url = list[3];
  if (!encodable_photo_url.IsNull()) {
    decoded.set_photo_url(std::get<std::string>(encodable_photo_url));
  }
  auto& encodable_phone_number = list[4];
  if (!encodable_phone_number.IsNull()) {
    decoded.set_phone_number(std::get<std::string>(encodable_phone_number));
  }
  auto& encodable_provider_id = list[7];
  if (!encodable_provider_id.IsNull()) {
    decoded.set_provider_id(std::get<std::string>(encodable_provider_id));
  }
  auto& encodable_tenant_id = list[8];
  if (!encodable_tenant_id.IsNull()) {
    decoded.set_tenant_id(std::get<std::string>(encodable_tenant_id));
  }
  auto& encodable_refresh_token = list[9];
  if (!encodable_refresh_token.IsNull()) {
    decoded.set_refresh_token(std::get<std::string>(encodable_refresh_token));
  }
  auto& encodable_creation_timestamp = list[10];
  if (!encodable_creation_timestamp.IsNull()) {
    decoded.set_creation_timestamp(encodable_creation_timestamp.LongValue());
  }
  auto& encodable_last_sign_in_timestamp = list[11];
  if (!encodable_last_sign_in_timestamp.IsNull()) {
    decoded.set_last_sign_in_timestamp(
        encodable_last_sign_in_timestamp.LongValue());
  }
  return decoded;
}

// PigeonUserDetails

PigeonUserDetails::PigeonUserDetails(PigeonUserInfo user_info,
                                     EncodableList provider_data)
    : user_info_(std::move(user_info)),
      provider_data_(std::move(provider_data)) {}

const PigeonUserInfo& PigeonUserDetails::user_info() const {
  return user_info_;
}

void PigeonUserDetails::set_user_info(const PigeonUserInfo& value_arg) {
  user_info_ = value_arg;
}

const EncodableList& PigeonUserDetails::provider_data() const {
  return provider_data_;
}

void PigeonUserDetails::set_provider_data(const EncodableList& value_arg) {
  provider_data_ = value_arg;
}

EncodableList PigeonUserDetails::ToEncodableList() const {
  EncodableList list;
  list.reserve(2);
  list.emplace_back(user_info_.ToEncodableList());
  list.emplace_back(provider_data_);
  return list;
}

PigeonUserDetails PigeonUserDetails::FromEncodableList(
    const EncodableList& list) {
  PigeonUserDetails decoded(
      PigeonUserInfo::FromEncodableList(std::get<EncodableList>(list[0])),
      std::get<EncodableList>(list[1]));
  return decoded;
}

// PigeonUserCredential

PigeonUserCredential::PigeonUserCredential() = default;

PigeonUserCredential::PigeonUserCredential(
    const PigeonUserDetails* user,
    const PigeonAdditionalUserInfo* additional_user_info,
    const PigeonAuthCredential* credential)
    : user_(user ? std::optional<PigeonUserDetails>(*user) : std::nullopt),
      additional_user_info_(
          additional_user_info
              ? std::optional<PigeonAdditionalUserInfo>(*additional_user_info)
              : std::nullopt),
      credential_(credential ? std::optional<PigeonAuthCredential>(*credential)
                             : std::nullopt) {}

const PigeonUserDetails* PigeonUserCredential::user() const {
  return user_ ? &(*user_) : nullptr;
}

void PigeonUserCredential::set_user(const PigeonUserDetails* value_arg) {
  user_ =
      value_arg ? std::optional<PigeonUserDetails>(*value_arg) : std::nullopt;
}

void PigeonUserCredential::set_user(const PigeonUserDetails& value_arg) {
  user_ = value_arg;
}

const PigeonAdditionalUserInfo* PigeonUserCredential::additional_user_info()
    const {
  return additional_user_info_ ? &(*additional_user_info_) : nullptr;
}

void PigeonUserCredential::set_additional_user_info(
    const PigeonAdditionalUserInfo* value_arg) {
  additional_user_info_ =
      value_arg ? std::optional<PigeonAdditionalUserInfo>(*value_arg)
                : std::nullopt;
}

void PigeonUserCredential::set_additional_user_info(
    const PigeonAdditionalUserInfo& value_arg) {
  additional_user_info_ = value_arg;
}

const PigeonAuthCredential* PigeonUserCredential::credential() const {
  return credential_ ? &(*credential_) : nullptr;
}

void PigeonUserCredential::set_credential(
    const PigeonAuthCredential* value_arg) {
  credential_ = value_arg ? std::optional<PigeonAuthCredential>(*value_arg)
                          : std::nullopt;
}

void PigeonUserCredential::set_credential(
    const PigeonAuthCredential& value_arg) {
  credential_ = value_arg;
}

EncodableList PigeonUserCredential::ToEncodableList() const {
  EncodableList list;
  list.reserve(3);
  list.push_back(user_ ? EncodableValue(user_->ToEncodableList())
                       : EncodableValue());
  list.push_back(additional_user_info_
                     ? EncodableValue(additional_user_info_->ToEncodableList())
                     : EncodableValue());
  list.push_back(credential_ ? EncodableValue(credential_->ToEncodableList())
                             : EncodableValue());
  return list;
}

PigeonUserCredential PigeonUserCredential::FromEncodableList(
    const EncodableList& list) {
  PigeonUserCredential decoded;
  auto& encodable_user = list[0];
  if (!encodable_user.IsNull()) {
    decoded.set_user(PigeonUserDetails::FromEncodableList(
        std::get<EncodableList>(encodable_user)));
  }
  auto& encodable_additional_user_info = list[1];
  if (!encodable_additional_user_info.IsNull()) {
    decoded.set_additional_user_info(
        PigeonAdditionalUserInfo::FromEncodableList(
            std::get<EncodableList>(encodable_additional_user_info)));
  }
  auto& encodable_credential = list[2];
  if (!encodable_credential.IsNull()) {
    decoded.set_credential(PigeonAuthCredential::FromEncodableList(
        std::get<EncodableList>(encodable_credential)));
  }
  return decoded;
}

// PigeonActionCodeSettings

PigeonActionCodeSettings::PigeonActionCodeSettings(std::string url,
                                                   bool handle_code_in_app,
                                                   bool android_install_app)
    : url_(std::move(url)),
      handle_code_in_app_(handle_code_in_app),
      android_install_app_(android_install_app) {}

PigeonActionCodeSettings::PigeonActionCodeSettings(
    std::string url,
    const std::string* dynamic_link_domain,
    bool handle_code_in_app,
    const std::string* i_o_s_bundle_id,
    const std::string* android_package_name,
    bool android_install_app,
    const std::string* android_minimum_version)
    : url_(std::move(url)),
      dynamic_link_domain_(
          dynamic_link_domain ? std::optional<std::string>(*dynamic_link_domain)
                              : std::nullopt),
      handle_code_in_app_(handle_code_in_app),
      i_o_s_bundle_id_(i_o_s_bundle_id
                           ? std::optional<std::string>(*i_o_s_bundle_id)
                           : std::nullopt),
      android_package_name_(android_package_name ? std::optional<std::string>(
                                                       *android_package_name)
                                                 : std::nullopt),
      android_install_app_(android_install_app),
      android_minimum_version_(
          android_minimum_version
              ? std::optional<std::string>(*android_minimum_version)
              : std::nullopt) {}

const std::string& PigeonActionCodeSettings::url() const {
  return url_;
}

void PigeonActionCodeSettings::set_url(std::string_view value_arg) {
  url_ = value_arg;
}

const std::string* PigeonActionCodeSettings::dynamic_link_domain() const {
  return dynamic_link_domain_ ? &(*dynamic_link_domain_) : nullptr;
}

void PigeonActionCodeSettings::set_dynamic_link_domain(
    const std::string_view* value_arg) {
  dynamic_link_domain_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonActionCodeSettings::set_dynamic_link_domain(
    std::string_view value_arg) {
  dynamic_link_domain_ = value_arg;
}

bool PigeonActionCodeSettings::handle_code_in_app() const {
  return handle_code_in_app_;
}

void PigeonActionCodeSettings::set_handle_code_in_app(bool value_arg) {
  handle_code_in_app_ = value_arg;
}

const std::string* PigeonActionCodeSettings::i_o_s_bundle_id() const {
  return i_o_s_bundle_id_ ? &(*i_o_s_bundle_id_) : nullptr;
}

void PigeonActionCodeSettings::set_i_o_s_bundle_id(
    const std::string_view* value_arg) {
  i_o_s_bundle_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonActionCodeSettings::set_i_o_s_bundle_id(std::string_view value_arg) {
  i_o_s_bundle_id_ = value_arg;
}

const std::string* PigeonActionCodeSettings::android_package_name() const {
  return android_package_name_ ? &(*android_package_name_) : nullptr;
}

void PigeonActionCodeSettings::set_android_package_name(
    const std::string_view* value_arg) {
  android_package_name_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonActionCodeSettings::set_android_package_name(
    std::string_view value_arg) {
  android_package_name_ = value_arg;
}

bool PigeonActionCodeSettings::android_install_app() const {
  return android_install_app_;
}

void PigeonActionCodeSettings::set_android_install_app(bool value_arg) {
  android_install_app_ = value_arg;
}

const std::string* PigeonActionCodeSettings::android_minimum_version() const {
  return android_minimum_version_ ? &(*android_minimum_version_) : nullptr;
}

void PigeonActionCodeSettings::set_android_minimum_version(
    const std::string_view* value_arg) {
  android_minimum_version_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonActionCodeSettings::set_android_minimum_version(
    std::string_view value_arg) {
  android_minimum_version_ = value_arg;
}

EncodableList PigeonActionCodeSettings::ToEncodableList() const {
  EncodableList list;
  list.reserve(7);
  list.emplace_back(url_);
  list.push_back(dynamic_link_domain_ ? EncodableValue(*dynamic_link_domain_)
                                      : EncodableValue());
  list.emplace_back(handle_code_in_app_);
  list.push_back(i_o_s_bundle_id_ ? EncodableValue(*i_o_s_bundle_id_)
                                  : EncodableValue());
  list.push_back(android_package_name_ ? EncodableValue(*android_package_name_)
                                       : EncodableValue());
  list.emplace_back(android_install_app_);
  list.push_back(android_minimum_version_
                     ? EncodableValue(*android_minimum_version_)
                     : EncodableValue());
  return list;
}

PigeonActionCodeSettings PigeonActionCodeSettings::FromEncodableList(
    const EncodableList& list) {
  PigeonActionCodeSettings decoded(std::get<std::string>(list[0]),
                                   std::get<bool>(list[2]),
                                   std::get<bool>(list[5]));
  auto& encodable_dynamic_link_domain = list[1];
  if (!encodable_dynamic_link_domain.IsNull()) {
    decoded.set_dynamic_link_domain(
        std::get<std::string>(encodable_dynamic_link_domain));
  }
  auto& encodable_i_o_s_bundle_id = list[3];
  if (!encodable_i_o_s_bundle_id.IsNull()) {
    decoded.set_i_o_s_bundle_id(
        std::get<std::string>(encodable_i_o_s_bundle_id));
  }
  auto& encodable_android_package_name = list[4];
  if (!encodable_android_package_name.IsNull()) {
    decoded.set_android_package_name(
        std::get<std::string>(encodable_android_package_name));
  }
  auto& encodable_android_minimum_version = list[6];
  if (!encodable_android_minimum_version.IsNull()) {
    decoded.set_android_minimum_version(
        std::get<std::string>(encodable_android_minimum_version));
  }
  return decoded;
}

// PigeonFirebaseAuthSettings

PigeonFirebaseAuthSettings::PigeonFirebaseAuthSettings(
    bool app_verification_disabled_for_testing)
    : app_verification_disabled_for_testing_(
          app_verification_disabled_for_testing) {}

PigeonFirebaseAuthSettings::PigeonFirebaseAuthSettings(
    bool app_verification_disabled_for_testing,
    const std::string* user_access_group,
    const std::string* phone_number,
    const std::string* sms_code,
    const bool* force_recaptcha_flow)
    : app_verification_disabled_for_testing_(
          app_verification_disabled_for_testing),
      user_access_group_(user_access_group
                             ? std::optional<std::string>(*user_access_group)
                             : std::nullopt),
      phone_number_(phone_number ? std::optional<std::string>(*phone_number)
                                 : std::nullopt),
      sms_code_(sms_code ? std::optional<std::string>(*sms_code)
                         : std::nullopt),
      force_recaptcha_flow_(force_recaptcha_flow
                                ? std::optional<bool>(*force_recaptcha_flow)
                                : std::nullopt) {}

bool PigeonFirebaseAuthSettings::app_verification_disabled_for_testing() const {
  return app_verification_disabled_for_testing_;
}

void PigeonFirebaseAuthSettings::set_app_verification_disabled_for_testing(
    bool value_arg) {
  app_verification_disabled_for_testing_ = value_arg;
}

const std::string* PigeonFirebaseAuthSettings::user_access_group() const {
  return user_access_group_ ? &(*user_access_group_) : nullptr;
}

void PigeonFirebaseAuthSettings::set_user_access_group(
    const std::string_view* value_arg) {
  user_access_group_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonFirebaseAuthSettings::set_user_access_group(
    std::string_view value_arg) {
  user_access_group_ = value_arg;
}

const std::string* PigeonFirebaseAuthSettings::phone_number() const {
  return phone_number_ ? &(*phone_number_) : nullptr;
}

void PigeonFirebaseAuthSettings::set_phone_number(
    const std::string_view* value_arg) {
  phone_number_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonFirebaseAuthSettings::set_phone_number(std::string_view value_arg) {
  phone_number_ = value_arg;
}

const std::string* PigeonFirebaseAuthSettings::sms_code() const {
  return sms_code_ ? &(*sms_code_) : nullptr;
}

void PigeonFirebaseAuthSettings::set_sms_code(
    const std::string_view* value_arg) {
  sms_code_ = value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonFirebaseAuthSettings::set_sms_code(std::string_view value_arg) {
  sms_code_ = value_arg;
}

const bool* PigeonFirebaseAuthSettings::force_recaptcha_flow() const {
  return force_recaptcha_flow_ ? &(*force_recaptcha_flow_) : nullptr;
}

void PigeonFirebaseAuthSettings::set_force_recaptcha_flow(
    const bool* value_arg) {
  force_recaptcha_flow_ =
      value_arg ? std::optional<bool>(*value_arg) : std::nullopt;
}

void PigeonFirebaseAuthSettings::set_force_recaptcha_flow(bool value_arg) {
  force_recaptcha_flow_ = value_arg;
}

EncodableList PigeonFirebaseAuthSettings::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.emplace_back(app_verification_disabled_for_testing_);
  list.push_back(user_access_group_ ? EncodableValue(*user_access_group_)
                                    : EncodableValue());
  list.push_back(phone_number_ ? EncodableValue(*phone_number_)
                               : EncodableValue());
  list.push_back(sms_code_ ? EncodableValue(*sms_code_) : EncodableValue());
  list.push_back(force_recaptcha_flow_ ? EncodableValue(*force_recaptcha_flow_)
                                       : EncodableValue());
  return list;
}

PigeonFirebaseAuthSettings PigeonFirebaseAuthSettings::FromEncodableList(
    const EncodableList& list) {
  PigeonFirebaseAuthSettings decoded(std::get<bool>(list[0]));
  auto& encodable_user_access_group = list[1];
  if (!encodable_user_access_group.IsNull()) {
    decoded.set_user_access_group(
        std::get<std::string>(encodable_user_access_group));
  }
  auto& encodable_phone_number = list[2];
  if (!encodable_phone_number.IsNull()) {
    decoded.set_phone_number(std::get<std::string>(encodable_phone_number));
  }
  auto& encodable_sms_code = list[3];
  if (!encodable_sms_code.IsNull()) {
    decoded.set_sms_code(std::get<std::string>(encodable_sms_code));
  }
  auto& encodable_force_recaptcha_flow = list[4];
  if (!encodable_force_recaptcha_flow.IsNull()) {
    decoded.set_force_recaptcha_flow(
        std::get<bool>(encodable_force_recaptcha_flow));
  }
  return decoded;
}

// PigeonSignInProvider

PigeonSignInProvider::PigeonSignInProvider(std::string provider_id)
    : provider_id_(std::move(provider_id)) {}

PigeonSignInProvider::PigeonSignInProvider(
    std::string provider_id,
    const EncodableList* scopes,
    const EncodableMap* custom_parameters)
    : provider_id_(std::move(provider_id)),
      scopes_(scopes ? std::optional<EncodableList>(*scopes) : std::nullopt),
      custom_parameters_(custom_parameters
                             ? std::optional<EncodableMap>(*custom_parameters)
                             : std::nullopt) {}

const std::string& PigeonSignInProvider::provider_id() const {
  return provider_id_;
}

void PigeonSignInProvider::set_provider_id(std::string_view value_arg) {
  provider_id_ = value_arg;
}

const EncodableList* PigeonSignInProvider::scopes() const {
  return scopes_ ? &(*scopes_) : nullptr;
}

void PigeonSignInProvider::set_scopes(const EncodableList* value_arg) {
  scopes_ = value_arg ? std::optional<EncodableList>(*value_arg) : std::nullopt;
}

void PigeonSignInProvider::set_scopes(const EncodableList& value_arg) {
  scopes_ = value_arg;
}

const EncodableMap* PigeonSignInProvider::custom_parameters() const {
  return custom_parameters_ ? &(*custom_parameters_) : nullptr;
}

void PigeonSignInProvider::set_custom_parameters(
    const EncodableMap* value_arg) {
  custom_parameters_ =
      value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void PigeonSignInProvider::set_custom_parameters(
    const EncodableMap& value_arg) {
  custom_parameters_ = value_arg;
}

EncodableList PigeonSignInProvider::ToEncodableList() const {
  EncodableList list;
  list.reserve(3);
  list.emplace_back(provider_id_);
  list.push_back(scopes_ ? EncodableValue(*scopes_) : EncodableValue());
  list.push_back(custom_parameters_ ? EncodableValue(*custom_parameters_)
                                    : EncodableValue());
  return list;
}

PigeonSignInProvider PigeonSignInProvider::FromEncodableList(
    const EncodableList& list) {
  PigeonSignInProvider decoded(std::get<std::string>(list[0]));
  auto& encodable_scopes = list[1];
  if (!encodable_scopes.IsNull()) {
    decoded.set_scopes(std::get<EncodableList>(encodable_scopes));
  }
  auto& encodable_custom_parameters = list[2];
  if (!encodable_custom_parameters.IsNull()) {
    decoded.set_custom_parameters(
        std::get<EncodableMap>(encodable_custom_parameters));
  }
  return decoded;
}

// PigeonVerifyPhoneNumberRequest

PigeonVerifyPhoneNumberRequest::PigeonVerifyPhoneNumberRequest(int64_t timeout)
    : timeout_(timeout) {}

PigeonVerifyPhoneNumberRequest::PigeonVerifyPhoneNumberRequest(
    const std::string* phone_number,
    int64_t timeout,
    const int64_t* force_resending_token,
    const std::string* auto_retrieved_sms_code_for_testing,
    const std::string* multi_factor_info_id,
    const std::string* multi_factor_session_id)
    : phone_number_(phone_number ? std::optional<std::string>(*phone_number)
                                 : std::nullopt),
      timeout_(timeout),
      force_resending_token_(
          force_resending_token ? std::optional<int64_t>(*force_resending_token)
                                : std::nullopt),
      auto_retrieved_sms_code_for_testing_(
          auto_retrieved_sms_code_for_testing
              ? std::optional<std::string>(*auto_retrieved_sms_code_for_testing)
              : std::nullopt),
      multi_factor_info_id_(multi_factor_info_id ? std::optional<std::string>(
                                                       *multi_factor_info_id)
                                                 : std::nullopt),
      multi_factor_session_id_(
          multi_factor_session_id
              ? std::optional<std::string>(*multi_factor_session_id)
              : std::nullopt) {}

const std::string* PigeonVerifyPhoneNumberRequest::phone_number() const {
  return phone_number_ ? &(*phone_number_) : nullptr;
}

void PigeonVerifyPhoneNumberRequest::set_phone_number(
    const std::string_view* value_arg) {
  phone_number_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonVerifyPhoneNumberRequest::set_phone_number(
    std::string_view value_arg) {
  phone_number_ = value_arg;
}

int64_t PigeonVerifyPhoneNumberRequest::timeout() const {
  return timeout_;
}

void PigeonVerifyPhoneNumberRequest::set_timeout(int64_t value_arg) {
  timeout_ = value_arg;
}

const int64_t* PigeonVerifyPhoneNumberRequest::force_resending_token() const {
  return force_resending_token_ ? &(*force_resending_token_) : nullptr;
}

void PigeonVerifyPhoneNumberRequest::set_force_resending_token(
    const int64_t* value_arg) {
  force_resending_token_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonVerifyPhoneNumberRequest::set_force_resending_token(
    int64_t value_arg) {
  force_resending_token_ = value_arg;
}

const std::string*
PigeonVerifyPhoneNumberRequest::auto_retrieved_sms_code_for_testing() const {
  return auto_retrieved_sms_code_for_testing_
             ? &(*auto_retrieved_sms_code_for_testing_)
             : nullptr;
}

void PigeonVerifyPhoneNumberRequest::set_auto_retrieved_sms_code_for_testing(
    const std::string_view* value_arg) {
  auto_retrieved_sms_code_for_testing_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonVerifyPhoneNumberRequest::set_auto_retrieved_sms_code_for_testing(
    std::string_view value_arg) {
  auto_retrieved_sms_code_for_testing_ = value_arg;
}

const std::string* PigeonVerifyPhoneNumberRequest::multi_factor_info_id()
    const {
  return multi_factor_info_id_ ? &(*multi_factor_info_id_) : nullptr;
}

void PigeonVerifyPhoneNumberRequest::set_multi_factor_info_id(
    const std::string_view* value_arg) {
  multi_factor_info_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonVerifyPhoneNumberRequest::set_multi_factor_info_id(
    std::string_view value_arg) {
  multi_factor_info_id_ = value_arg;
}

const std::string* PigeonVerifyPhoneNumberRequest::multi_factor_session_id()
    const {
  return multi_factor_session_id_ ? &(*multi_factor_session_id_) : nullptr;
}

void PigeonVerifyPhoneNumberRequest::set_multi_factor_session_id(
    const std::string_view* value_arg) {
  multi_factor_session_id_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonVerifyPhoneNumberRequest::set_multi_factor_session_id(
    std::string_view value_arg) {
  multi_factor_session_id_ = value_arg;
}

EncodableList PigeonVerifyPhoneNumberRequest::ToEncodableList() const {
  EncodableList list;
  list.reserve(6);
  list.push_back(phone_number_ ? EncodableValue(*phone_number_)
                               : EncodableValue());
  list.emplace_back(timeout_);
  list.push_back(force_resending_token_
                     ? EncodableValue(*force_resending_token_)
                     : EncodableValue());
  list.push_back(auto_retrieved_sms_code_for_testing_
                     ? EncodableValue(*auto_retrieved_sms_code_for_testing_)
                     : EncodableValue());
  list.push_back(multi_factor_info_id_ ? EncodableValue(*multi_factor_info_id_)
                                       : EncodableValue());
  list.push_back(multi_factor_session_id_
                     ? EncodableValue(*multi_factor_session_id_)
                     : EncodableValue());
  return list;
}

PigeonVerifyPhoneNumberRequest
PigeonVerifyPhoneNumberRequest::FromEncodableList(const EncodableList& list) {
  PigeonVerifyPhoneNumberRequest decoded(list[1].LongValue());
  auto& encodable_phone_number = list[0];
  if (!encodable_phone_number.IsNull()) {
    decoded.set_phone_number(std::get<std::string>(encodable_phone_number));
  }
  auto& encodable_force_resending_token = list[2];
  if (!encodable_force_resending_token.IsNull()) {
    decoded.set_force_resending_token(
        encodable_force_resending_token.LongValue());
  }
  auto& encodable_auto_retrieved_sms_code_for_testing = list[3];
  if (!encodable_auto_retrieved_sms_code_for_testing.IsNull()) {
    decoded.set_auto_retrieved_sms_code_for_testing(
        std::get<std::string>(encodable_auto_retrieved_sms_code_for_testing));
  }
  auto& encodable_multi_factor_info_id = list[4];
  if (!encodable_multi_factor_info_id.IsNull()) {
    decoded.set_multi_factor_info_id(
        std::get<std::string>(encodable_multi_factor_info_id));
  }
  auto& encodable_multi_factor_session_id = list[5];
  if (!encodable_multi_factor_session_id.IsNull()) {
    decoded.set_multi_factor_session_id(
        std::get<std::string>(encodable_multi_factor_session_id));
  }
  return decoded;
}

// PigeonIdTokenResult

PigeonIdTokenResult::PigeonIdTokenResult() = default;

PigeonIdTokenResult::PigeonIdTokenResult(
    const std::string* token,
    const int64_t* expiration_timestamp,
    const int64_t* auth_timestamp,
    const int64_t* issued_at_timestamp,
    const std::string* sign_in_provider,
    const EncodableMap* claims,
    const std::string* sign_in_second_factor)
    : token_(token ? std::optional<std::string>(*token) : std::nullopt),
      expiration_timestamp_(expiration_timestamp
                                ? std::optional<int64_t>(*expiration_timestamp)
                                : std::nullopt),
      auth_timestamp_(auth_timestamp ? std::optional<int64_t>(*auth_timestamp)
                                     : std::nullopt),
      issued_at_timestamp_(issued_at_timestamp
                               ? std::optional<int64_t>(*issued_at_timestamp)
                               : std::nullopt),
      sign_in_provider_(sign_in_provider
                            ? std::optional<std::string>(*sign_in_provider)
                            : std::nullopt),
      claims_(claims ? std::optional<EncodableMap>(*claims) : std::nullopt),
      sign_in_second_factor_(sign_in_second_factor ? std::optional<std::string>(
                                                         *sign_in_second_factor)
                                                   : std::nullopt) {}

const std::string* PigeonIdTokenResult::token() const {
  return token_ ? &(*token_) : nullptr;
}

void PigeonIdTokenResult::set_token(const std::string_view* value_arg) {
  token_ = value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_token(std::string_view value_arg) {
  token_ = value_arg;
}

const int64_t* PigeonIdTokenResult::expiration_timestamp() const {
  return expiration_timestamp_ ? &(*expiration_timestamp_) : nullptr;
}

void PigeonIdTokenResult::set_expiration_timestamp(const int64_t* value_arg) {
  expiration_timestamp_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_expiration_timestamp(int64_t value_arg) {
  expiration_timestamp_ = value_arg;
}

const int64_t* PigeonIdTokenResult::auth_timestamp() const {
  return auth_timestamp_ ? &(*auth_timestamp_) : nullptr;
}

void PigeonIdTokenResult::set_auth_timestamp(const int64_t* value_arg) {
  auth_timestamp_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_auth_timestamp(int64_t value_arg) {
  auth_timestamp_ = value_arg;
}

const int64_t* PigeonIdTokenResult::issued_at_timestamp() const {
  return issued_at_timestamp_ ? &(*issued_at_timestamp_) : nullptr;
}

void PigeonIdTokenResult::set_issued_at_timestamp(const int64_t* value_arg) {
  issued_at_timestamp_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_issued_at_timestamp(int64_t value_arg) {
  issued_at_timestamp_ = value_arg;
}

const std::string* PigeonIdTokenResult::sign_in_provider() const {
  return sign_in_provider_ ? &(*sign_in_provider_) : nullptr;
}

void PigeonIdTokenResult::set_sign_in_provider(
    const std::string_view* value_arg) {
  sign_in_provider_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_sign_in_provider(std::string_view value_arg) {
  sign_in_provider_ = value_arg;
}

const EncodableMap* PigeonIdTokenResult::claims() const {
  return claims_ ? &(*claims_) : nullptr;
}

void PigeonIdTokenResult::set_claims(const EncodableMap* value_arg) {
  claims_ = value_arg ? std::optional<EncodableMap>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_claims(const EncodableMap& value_arg) {
  claims_ = value_arg;
}

const std::string* PigeonIdTokenResult::sign_in_second_factor() const {
  return sign_in_second_factor_ ? &(*sign_in_second_factor_) : nullptr;
}

void PigeonIdTokenResult::set_sign_in_second_factor(
    const std::string_view* value_arg) {
  sign_in_second_factor_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonIdTokenResult::set_sign_in_second_factor(
    std::string_view value_arg) {
  sign_in_second_factor_ = value_arg;
}

EncodableList PigeonIdTokenResult::ToEncodableList() const {
  EncodableList list;
  list.reserve(7);
  list.push_back(token_ ? EncodableValue(*token_) : EncodableValue());
  list.push_back(expiration_timestamp_ ? EncodableValue(*expiration_timestamp_)
                                       : EncodableValue());
  list.push_back(auth_timestamp_ ? EncodableValue(*auth_timestamp_)
                                 : EncodableValue());
  list.push_back(issued_at_timestamp_ ? EncodableValue(*issued_at_timestamp_)
                                      : EncodableValue());
  list.push_back(sign_in_provider_ ? EncodableValue(*sign_in_provider_)
                                   : EncodableValue());
  list.push_back(claims_ ? EncodableValue(*claims_) : EncodableValue());
  list.push_back(sign_in_second_factor_
                     ? EncodableValue(*sign_in_second_factor_)
                     : EncodableValue());
  return list;
}

PigeonIdTokenResult PigeonIdTokenResult::FromEncodableList(
    const EncodableList& list) {
  PigeonIdTokenResult decoded;
  auto& encodable_token = list[0];
  if (!encodable_token.IsNull()) {
    decoded.set_token(std::get<std::string>(encodable_token));
  }
  auto& encodable_expiration_timestamp = list[1];
  if (!encodable_expiration_timestamp.IsNull()) {
    decoded.set_expiration_timestamp(
        encodable_expiration_timestamp.LongValue());
  }
  auto& encodable_auth_timestamp = list[2];
  if (!encodable_auth_timestamp.IsNull()) {
    decoded.set_auth_timestamp(encodable_auth_timestamp.LongValue());
  }
  auto& encodable_issued_at_timestamp = list[3];
  if (!encodable_issued_at_timestamp.IsNull()) {
    decoded.set_issued_at_timestamp(encodable_issued_at_timestamp.LongValue());
  }
  auto& encodable_sign_in_provider = list[4];
  if (!encodable_sign_in_provider.IsNull()) {
    decoded.set_sign_in_provider(
        std::get<std::string>(encodable_sign_in_provider));
  }
  auto& encodable_claims = list[5];
  if (!encodable_claims.IsNull()) {
    decoded.set_claims(std::get<EncodableMap>(encodable_claims));
  }
  auto& encodable_sign_in_second_factor = list[6];
  if (!encodable_sign_in_second_factor.IsNull()) {
    decoded.set_sign_in_second_factor(
        std::get<std::string>(encodable_sign_in_second_factor));
  }
  return decoded;
}

// PigeonUserProfile

PigeonUserProfile::PigeonUserProfile(bool display_name_changed,
                                     bool photo_url_changed)
    : display_name_changed_(display_name_changed),
      photo_url_changed_(photo_url_changed) {}

PigeonUserProfile::PigeonUserProfile(const std::string* display_name,
                                     const std::string* photo_url,
                                     bool display_name_changed,
                                     bool photo_url_changed)
    : display_name_(display_name ? std::optional<std::string>(*display_name)
                                 : std::nullopt),
      photo_url_(photo_url ? std::optional<std::string>(*photo_url)
                           : std::nullopt),
      display_name_changed_(display_name_changed),
      photo_url_changed_(photo_url_changed) {}

const std::string* PigeonUserProfile::display_name() const {
  return display_name_ ? &(*display_name_) : nullptr;
}

void PigeonUserProfile::set_display_name(const std::string_view* value_arg) {
  display_name_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserProfile::set_display_name(std::string_view value_arg) {
  display_name_ = value_arg;
}

const std::string* PigeonUserProfile::photo_url() const {
  return photo_url_ ? &(*photo_url_) : nullptr;
}

void PigeonUserProfile::set_photo_url(const std::string_view* value_arg) {
  photo_url_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonUserProfile::set_photo_url(std::string_view value_arg) {
  photo_url_ = value_arg;
}

bool PigeonUserProfile::display_name_changed() const {
  return display_name_changed_;
}

void PigeonUserProfile::set_display_name_changed(bool value_arg) {
  display_name_changed_ = value_arg;
}

bool PigeonUserProfile::photo_url_changed() const {
  return photo_url_changed_;
}

void PigeonUserProfile::set_photo_url_changed(bool value_arg) {
  photo_url_changed_ = value_arg;
}

EncodableList PigeonUserProfile::ToEncodableList() const {
  EncodableList list;
  list.reserve(4);
  list.push_back(display_name_ ? EncodableValue(*display_name_)
                               : EncodableValue());
  list.push_back(photo_url_ ? EncodableValue(*photo_url_) : EncodableValue());
  list.emplace_back(display_name_changed_);
  list.emplace_back(photo_url_changed_);
  return list;
}

PigeonUserProfile PigeonUserProfile::FromEncodableList(
    const EncodableList& list) {
  PigeonUserProfile decoded(std::get<bool>(list[2]), std::get<bool>(list[3]));
  auto& encodable_display_name = list[0];
  if (!encodable_display_name.IsNull()) {
    decoded.set_display_name(std::get<std::string>(encodable_display_name));
  }
  auto& encodable_photo_url = list[1];
  if (!encodable_photo_url.IsNull()) {
    decoded.set_photo_url(std::get<std::string>(encodable_photo_url));
  }
  return decoded;
}

// PigeonTotpSecret

PigeonTotpSecret::PigeonTotpSecret(std::string secret_key)
    : secret_key_(std::move(secret_key)) {}

PigeonTotpSecret::PigeonTotpSecret(
    const int64_t* code_interval_seconds,
    const int64_t* code_length,
    const int64_t* enrollment_completion_deadline,
    const std::string* hashing_algorithm,
    std::string secret_key)
    : code_interval_seconds_(
          code_interval_seconds ? std::optional<int64_t>(*code_interval_seconds)
                                : std::nullopt),
      code_length_(code_length ? std::optional<int64_t>(*code_length)
                               : std::nullopt),
      enrollment_completion_deadline_(
          enrollment_completion_deadline
              ? std::optional<int64_t>(*enrollment_completion_deadline)
              : std::nullopt),
      hashing_algorithm_(hashing_algorithm
                             ? std::optional<std::string>(*hashing_algorithm)
                             : std::nullopt),
      secret_key_(std::move(secret_key)) {}

const int64_t* PigeonTotpSecret::code_interval_seconds() const {
  return code_interval_seconds_ ? &(*code_interval_seconds_) : nullptr;
}

void PigeonTotpSecret::set_code_interval_seconds(const int64_t* value_arg) {
  code_interval_seconds_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonTotpSecret::set_code_interval_seconds(int64_t value_arg) {
  code_interval_seconds_ = value_arg;
}

const int64_t* PigeonTotpSecret::code_length() const {
  return code_length_ ? &(*code_length_) : nullptr;
}

void PigeonTotpSecret::set_code_length(const int64_t* value_arg) {
  code_length_ = value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonTotpSecret::set_code_length(int64_t value_arg) {
  code_length_ = value_arg;
}

const int64_t* PigeonTotpSecret::enrollment_completion_deadline() const {
  return enrollment_completion_deadline_ ? &(*enrollment_completion_deadline_)
                                         : nullptr;
}

void PigeonTotpSecret::set_enrollment_completion_deadline(
    const int64_t* value_arg) {
  enrollment_completion_deadline_ =
      value_arg ? std::optional<int64_t>(*value_arg) : std::nullopt;
}

void PigeonTotpSecret::set_enrollment_completion_deadline(int64_t value_arg) {
  enrollment_completion_deadline_ = value_arg;
}

const std::string* PigeonTotpSecret::hashing_algorithm() const {
  return hashing_algorithm_ ? &(*hashing_algorithm_) : nullptr;
}

void PigeonTotpSecret::set_hashing_algorithm(
    const std::string_view* value_arg) {
  hashing_algorithm_ =
      value_arg ? std::optional<std::string>(*value_arg) : std::nullopt;
}

void PigeonTotpSecret::set_hashing_algorithm(std::string_view value_arg) {
  hashing_algorithm_ = value_arg;
}

const std::string& PigeonTotpSecret::secret_key() const {
  return secret_key_;
}

void PigeonTotpSecret::set_secret_key(std::string_view value_arg) {
  secret_key_ = value_arg;
}

EncodableList PigeonTotpSecret::ToEncodableList() const {
  EncodableList list;
  list.reserve(5);
  list.push_back(code_interval_seconds_
                     ? EncodableValue(*code_interval_seconds_)
                     : EncodableValue());
  list.push_back(code_length_ ? EncodableValue(*code_length_)
                              : EncodableValue());
  list.push_back(enrollment_completion_deadline_
                     ? EncodableValue(*enrollment_completion_deadline_)
                     : EncodableValue());
  list.push_back(hashing_algorithm_ ? EncodableValue(*hashing_algorithm_)
                                    : EncodableValue());
  list.emplace_back(secret_key_);
  return list;
}

PigeonTotpSecret PigeonTotpSecret::FromEncodableList(
    const EncodableList& list) {
  PigeonTotpSecret decoded(std::get<std::string>(list[4]));
  auto& encodable_code_interval_seconds = list[0];
  if (!encodable_code_interval_seconds.IsNull()) {
    decoded.set_code_interval_seconds(
        encodable_code_interval_seconds.LongValue());
  }
  auto& encodable_code_length = list[1];
  if (!encodable_code_length.IsNull()) {
    decoded.set_code_length(encodable_code_length.LongValue());
  }
  auto& encodable_enrollment_completion_deadline = list[2];
  if (!encodable_enrollment_completion_deadline.IsNull()) {
    decoded.set_enrollment_completion_deadline(
        encodable_enrollment_completion_deadline.LongValue());
  }
  auto& encodable_hashing_algorithm = list[3];
  if (!encodable_hashing_algorithm.IsNull()) {
    decoded.set_hashing_algorithm(
        std::get<std::string>(encodable_hashing_algorithm));
  }
  return decoded;
}

FirebaseAuthHostApiCodecSerializer::FirebaseAuthHostApiCodecSerializer() =
    default;

EncodableValue FirebaseAuthHostApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(AuthPigeonFirebaseApp::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 129:
      return CustomEncodableValue(PigeonActionCodeInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 130:
      return CustomEncodableValue(PigeonActionCodeInfoData::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 131:
      return CustomEncodableValue(PigeonActionCodeSettings::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 132:
      return CustomEncodableValue(PigeonAdditionalUserInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 133:
      return CustomEncodableValue(PigeonAuthCredential::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 134:
      return CustomEncodableValue(PigeonFirebaseAuthSettings::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 135:
      return CustomEncodableValue(PigeonIdTokenResult::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 136:
      return CustomEncodableValue(PigeonMultiFactorInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 137:
      return CustomEncodableValue(PigeonMultiFactorSession::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 138:
      return CustomEncodableValue(
          PigeonPhoneMultiFactorAssertion::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    case 139:
      return CustomEncodableValue(PigeonSignInProvider::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 140:
      return CustomEncodableValue(PigeonTotpSecret::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 141:
      return CustomEncodableValue(PigeonUserCredential::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 142:
      return CustomEncodableValue(PigeonUserDetails::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 143:
      return CustomEncodableValue(PigeonUserInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 144:
      return CustomEncodableValue(PigeonUserProfile::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 145:
      return CustomEncodableValue(
          PigeonVerifyPhoneNumberRequest::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void FirebaseAuthHostApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(AuthPigeonFirebaseApp)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(std::any_cast<AuthPigeonFirebaseApp>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonActionCodeInfo)) {
      stream->WriteByte(129);
      WriteValue(
          EncodableValue(std::any_cast<PigeonActionCodeInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonActionCodeInfoData)) {
      stream->WriteByte(130);
      WriteValue(
          EncodableValue(std::any_cast<PigeonActionCodeInfoData>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonActionCodeSettings)) {
      stream->WriteByte(131);
      WriteValue(
          EncodableValue(std::any_cast<PigeonActionCodeSettings>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonAdditionalUserInfo)) {
      stream->WriteByte(132);
      WriteValue(
          EncodableValue(std::any_cast<PigeonAdditionalUserInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonAuthCredential)) {
      stream->WriteByte(133);
      WriteValue(
          EncodableValue(std::any_cast<PigeonAuthCredential>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonFirebaseAuthSettings)) {
      stream->WriteByte(134);
      WriteValue(EncodableValue(
                     std::any_cast<PigeonFirebaseAuthSettings>(*custom_value)
                         .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonIdTokenResult)) {
      stream->WriteByte(135);
      WriteValue(
          EncodableValue(std::any_cast<PigeonIdTokenResult>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonMultiFactorInfo)) {
      stream->WriteByte(136);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonMultiFactorSession)) {
      stream->WriteByte(137);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorSession>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonPhoneMultiFactorAssertion)) {
      stream->WriteByte(138);
      WriteValue(EncodableValue(std::any_cast<PigeonPhoneMultiFactorAssertion>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonSignInProvider)) {
      stream->WriteByte(139);
      WriteValue(
          EncodableValue(std::any_cast<PigeonSignInProvider>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonTotpSecret)) {
      stream->WriteByte(140);
      WriteValue(
          EncodableValue(
              std::any_cast<PigeonTotpSecret>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserCredential)) {
      stream->WriteByte(141);
      WriteValue(
          EncodableValue(std::any_cast<PigeonUserCredential>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserDetails)) {
      stream->WriteByte(142);
      WriteValue(EncodableValue(std::any_cast<PigeonUserDetails>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserInfo)) {
      stream->WriteByte(143);
      WriteValue(
          EncodableValue(
              std::any_cast<PigeonUserInfo>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserProfile)) {
      stream->WriteByte(144);
      WriteValue(EncodableValue(std::any_cast<PigeonUserProfile>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonVerifyPhoneNumberRequest)) {
      stream->WriteByte(145);
      WriteValue(EncodableValue(std::any_cast<PigeonVerifyPhoneNumberRequest>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by FirebaseAuthHostApi.
const flutter::StandardMessageCodec& FirebaseAuthHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &FirebaseAuthHostApiCodecSerializer::GetInstance());
}

// Sets up an instance of `FirebaseAuthHostApi` to handle messages through the
// `binary_messenger`.
void FirebaseAuthHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                FirebaseAuthHostApi* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.registerIdTokenListener",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->RegisterIdTokenListener(
                  app_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.registerAuthStateListener",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->RegisterAuthStateListener(
                  app_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.useEmulator",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_host_arg = args.at(1);
              if (encodable_host_arg.IsNull()) {
                reply(WrapError("host_arg unexpectedly null."));
                return;
              }
              const auto& host_arg = std::get<std::string>(encodable_host_arg);
              const auto& encodable_port_arg = args.at(2);
              if (encodable_port_arg.IsNull()) {
                reply(WrapError("port_arg unexpectedly null."));
                return;
              }
              const int64_t port_arg = encodable_port_arg.LongValue();
              api->UseEmulator(app_arg, host_arg, port_arg,
                               [reply](std::optional<FlutterError>&& output) {
                                 if (output.has_value()) {
                                   reply(WrapError(output.value()));
                                   return;
                                 }
                                 EncodableList wrapped;
                                 wrapped.emplace_back();
                                 reply(EncodableValue(std::move(wrapped)));
                               });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.applyActionCode",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_code_arg = args.at(1);
              if (encodable_code_arg.IsNull()) {
                reply(WrapError("code_arg unexpectedly null."));
                return;
              }
              const auto& code_arg = std::get<std::string>(encodable_code_arg);
              api->ApplyActionCode(
                  app_arg, code_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.checkActionCode",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_code_arg = args.at(1);
              if (encodable_code_arg.IsNull()) {
                reply(WrapError("code_arg unexpectedly null."));
                return;
              }
              const auto& code_arg = std::get<std::string>(encodable_code_arg);
              api->CheckActionCode(
                  app_arg, code_arg,
                  [reply](ErrorOr<PigeonActionCodeInfo>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.confirmPasswordReset",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_code_arg = args.at(1);
              if (encodable_code_arg.IsNull()) {
                reply(WrapError("code_arg unexpectedly null."));
                return;
              }
              const auto& code_arg = std::get<std::string>(encodable_code_arg);
              const auto& encodable_new_password_arg = args.at(2);
              if (encodable_new_password_arg.IsNull()) {
                reply(WrapError("new_password_arg unexpectedly null."));
                return;
              }
              const auto& new_password_arg =
                  std::get<std::string>(encodable_new_password_arg);
              api->ConfirmPasswordReset(
                  app_arg, code_arg, new_password_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.createUserWithEmailAndPassword",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_email_arg = args.at(1);
              if (encodable_email_arg.IsNull()) {
                reply(WrapError("email_arg unexpectedly null."));
                return;
              }
              const auto& email_arg =
                  std::get<std::string>(encodable_email_arg);
              const auto& encodable_password_arg = args.at(2);
              if (encodable_password_arg.IsNull()) {
                reply(WrapError("password_arg unexpectedly null."));
                return;
              }
              const auto& password_arg =
                  std::get<std::string>(encodable_password_arg);
              api->CreateUserWithEmailAndPassword(
                  app_arg, email_arg, password_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signInAnonymously",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->SignInAnonymously(
                  app_arg, [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signInWithCredential",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_input_arg = args.at(1);
              if (encodable_input_arg.IsNull()) {
                reply(WrapError("input_arg unexpectedly null."));
                return;
              }
              const auto& input_arg =
                  std::get<EncodableMap>(encodable_input_arg);
              api->SignInWithCredential(
                  app_arg, input_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signInWithCustomToken",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_token_arg = args.at(1);
              if (encodable_token_arg.IsNull()) {
                reply(WrapError("token_arg unexpectedly null."));
                return;
              }
              const auto& token_arg =
                  std::get<std::string>(encodable_token_arg);
              api->SignInWithCustomToken(
                  app_arg, token_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signInWithEmailAndPassword",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_email_arg = args.at(1);
              if (encodable_email_arg.IsNull()) {
                reply(WrapError("email_arg unexpectedly null."));
                return;
              }
              const auto& email_arg =
                  std::get<std::string>(encodable_email_arg);
              const auto& encodable_password_arg = args.at(2);
              if (encodable_password_arg.IsNull()) {
                reply(WrapError("password_arg unexpectedly null."));
                return;
              }
              const auto& password_arg =
                  std::get<std::string>(encodable_password_arg);
              api->SignInWithEmailAndPassword(
                  app_arg, email_arg, password_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signInWithEmailLink",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_email_arg = args.at(1);
              if (encodable_email_arg.IsNull()) {
                reply(WrapError("email_arg unexpectedly null."));
                return;
              }
              const auto& email_arg =
                  std::get<std::string>(encodable_email_arg);
              const auto& encodable_email_link_arg = args.at(2);
              if (encodable_email_link_arg.IsNull()) {
                reply(WrapError("email_link_arg unexpectedly null."));
                return;
              }
              const auto& email_link_arg =
                  std::get<std::string>(encodable_email_link_arg);
              api->SignInWithEmailLink(
                  app_arg, email_arg, email_link_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signInWithProvider",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_sign_in_provider_arg = args.at(1);
              if (encodable_sign_in_provider_arg.IsNull()) {
                reply(WrapError("sign_in_provider_arg unexpectedly null."));
                return;
              }
              const auto& sign_in_provider_arg =
                  std::any_cast<const PigeonSignInProvider&>(
                      std::get<CustomEncodableValue>(
                          encodable_sign_in_provider_arg));
              api->SignInWithProvider(
                  app_arg, sign_in_provider_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.signOut",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->SignOut(app_arg,
                           [reply](std::optional<FlutterError>&& output) {
                             if (output.has_value()) {
                               reply(WrapError(output.value()));
                               return;
                             }
                             EncodableList wrapped;
                             wrapped.emplace_back();
                             reply(EncodableValue(std::move(wrapped)));
                           });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.fetchSignInMethodsForEmail",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_email_arg = args.at(1);
              if (encodable_email_arg.IsNull()) {
                reply(WrapError("email_arg unexpectedly null."));
                return;
              }
              const auto& email_arg =
                  std::get<std::string>(encodable_email_arg);
              api->FetchSignInMethodsForEmail(
                  app_arg, email_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.sendPasswordResetEmail",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_email_arg = args.at(1);
              if (encodable_email_arg.IsNull()) {
                reply(WrapError("email_arg unexpectedly null."));
                return;
              }
              const auto& email_arg =
                  std::get<std::string>(encodable_email_arg);
              const auto& encodable_action_code_settings_arg = args.at(2);
              const auto* action_code_settings_arg =
                  &(std::any_cast<const PigeonActionCodeSettings&>(
                      std::get<CustomEncodableValue>(
                          encodable_action_code_settings_arg)));
              api->SendPasswordResetEmail(
                  app_arg, email_arg, action_code_settings_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.sendSignInLinkToEmail",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_email_arg = args.at(1);
              if (encodable_email_arg.IsNull()) {
                reply(WrapError("email_arg unexpectedly null."));
                return;
              }
              const auto& email_arg =
                  std::get<std::string>(encodable_email_arg);
              const auto& encodable_action_code_settings_arg = args.at(2);
              if (encodable_action_code_settings_arg.IsNull()) {
                reply(WrapError("action_code_settings_arg unexpectedly null."));
                return;
              }
              const auto& action_code_settings_arg =
                  std::any_cast<const PigeonActionCodeSettings&>(
                      std::get<CustomEncodableValue>(
                          encodable_action_code_settings_arg));
              api->SendSignInLinkToEmail(
                  app_arg, email_arg, action_code_settings_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.setLanguageCode",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_language_code_arg = args.at(1);
              const auto* language_code_arg =
                  std::get_if<std::string>(&encodable_language_code_arg);
              api->SetLanguageCode(
                  app_arg, language_code_arg,
                  [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.setSettings",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_settings_arg = args.at(1);
              if (encodable_settings_arg.IsNull()) {
                reply(WrapError("settings_arg unexpectedly null."));
                return;
              }
              const auto& settings_arg =
                  std::any_cast<const PigeonFirebaseAuthSettings&>(
                      std::get<CustomEncodableValue>(encodable_settings_arg));
              api->SetSettings(app_arg, settings_arg,
                               [reply](std::optional<FlutterError>&& output) {
                                 if (output.has_value()) {
                                   reply(WrapError(output.value()));
                                   return;
                                 }
                                 EncodableList wrapped;
                                 wrapped.emplace_back();
                                 reply(EncodableValue(std::move(wrapped)));
                               });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.verifyPasswordResetCode",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_code_arg = args.at(1);
              if (encodable_code_arg.IsNull()) {
                reply(WrapError("code_arg unexpectedly null."));
                return;
              }
              const auto& code_arg = std::get<std::string>(encodable_code_arg);
              api->VerifyPasswordResetCode(
                  app_arg, code_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.verifyPhoneNumber",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_request_arg = args.at(1);
              if (encodable_request_arg.IsNull()) {
                reply(WrapError("request_arg unexpectedly null."));
                return;
              }
              const auto& request_arg =
                  std::any_cast<const PigeonVerifyPhoneNumberRequest&>(
                      std::get<CustomEncodableValue>(encodable_request_arg));
              api->VerifyPhoneNumber(
                  app_arg, request_arg, [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthHostApi.revokeTokenWithAuthorizationCode",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_authorization_code_arg = args.at(1);
              if (encodable_authorization_code_arg.IsNull()) {
                reply(WrapError("authorization_code_arg unexpectedly null."));
                return;
              }
              const auto& authorization_code_arg =
                  std::get<std::string>(encodable_authorization_code_arg);
              api->RevokeTokenWithAuthorizationCode(
                  app_arg, authorization_code_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue FirebaseAuthHostApi::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue FirebaseAuthHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

FirebaseAuthUserHostApiCodecSerializer::
    FirebaseAuthUserHostApiCodecSerializer() = default;

EncodableValue FirebaseAuthUserHostApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(AuthPigeonFirebaseApp::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 129:
      return CustomEncodableValue(PigeonActionCodeInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 130:
      return CustomEncodableValue(PigeonActionCodeInfoData::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 131:
      return CustomEncodableValue(PigeonActionCodeSettings::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 132:
      return CustomEncodableValue(PigeonAdditionalUserInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 133:
      return CustomEncodableValue(PigeonAuthCredential::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 134:
      return CustomEncodableValue(PigeonFirebaseAuthSettings::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 135:
      return CustomEncodableValue(PigeonIdTokenResult::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 136:
      return CustomEncodableValue(PigeonMultiFactorInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 137:
      return CustomEncodableValue(PigeonMultiFactorSession::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 138:
      return CustomEncodableValue(
          PigeonPhoneMultiFactorAssertion::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    case 139:
      return CustomEncodableValue(PigeonSignInProvider::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 140:
      return CustomEncodableValue(PigeonTotpSecret::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 141:
      return CustomEncodableValue(PigeonUserCredential::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 142:
      return CustomEncodableValue(PigeonUserDetails::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 143:
      return CustomEncodableValue(PigeonUserInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 144:
      return CustomEncodableValue(PigeonUserProfile::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 145:
      return CustomEncodableValue(
          PigeonVerifyPhoneNumberRequest::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void FirebaseAuthUserHostApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(AuthPigeonFirebaseApp)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(std::any_cast<AuthPigeonFirebaseApp>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonActionCodeInfo)) {
      stream->WriteByte(129);
      WriteValue(
          EncodableValue(std::any_cast<PigeonActionCodeInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonActionCodeInfoData)) {
      stream->WriteByte(130);
      WriteValue(
          EncodableValue(std::any_cast<PigeonActionCodeInfoData>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonActionCodeSettings)) {
      stream->WriteByte(131);
      WriteValue(
          EncodableValue(std::any_cast<PigeonActionCodeSettings>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonAdditionalUserInfo)) {
      stream->WriteByte(132);
      WriteValue(
          EncodableValue(std::any_cast<PigeonAdditionalUserInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonAuthCredential)) {
      stream->WriteByte(133);
      WriteValue(
          EncodableValue(std::any_cast<PigeonAuthCredential>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonFirebaseAuthSettings)) {
      stream->WriteByte(134);
      WriteValue(EncodableValue(
                     std::any_cast<PigeonFirebaseAuthSettings>(*custom_value)
                         .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonIdTokenResult)) {
      stream->WriteByte(135);
      WriteValue(
          EncodableValue(std::any_cast<PigeonIdTokenResult>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonMultiFactorInfo)) {
      stream->WriteByte(136);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonMultiFactorSession)) {
      stream->WriteByte(137);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorSession>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonPhoneMultiFactorAssertion)) {
      stream->WriteByte(138);
      WriteValue(EncodableValue(std::any_cast<PigeonPhoneMultiFactorAssertion>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonSignInProvider)) {
      stream->WriteByte(139);
      WriteValue(
          EncodableValue(std::any_cast<PigeonSignInProvider>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonTotpSecret)) {
      stream->WriteByte(140);
      WriteValue(
          EncodableValue(
              std::any_cast<PigeonTotpSecret>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserCredential)) {
      stream->WriteByte(141);
      WriteValue(
          EncodableValue(std::any_cast<PigeonUserCredential>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserDetails)) {
      stream->WriteByte(142);
      WriteValue(EncodableValue(std::any_cast<PigeonUserDetails>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserInfo)) {
      stream->WriteByte(143);
      WriteValue(
          EncodableValue(
              std::any_cast<PigeonUserInfo>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserProfile)) {
      stream->WriteByte(144);
      WriteValue(EncodableValue(std::any_cast<PigeonUserProfile>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonVerifyPhoneNumberRequest)) {
      stream->WriteByte(145);
      WriteValue(EncodableValue(std::any_cast<PigeonVerifyPhoneNumberRequest>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by FirebaseAuthUserHostApi.
const flutter::StandardMessageCodec& FirebaseAuthUserHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &FirebaseAuthUserHostApiCodecSerializer::GetInstance());
}

// Sets up an instance of `FirebaseAuthUserHostApi` to handle messages through
// the `binary_messenger`.
void FirebaseAuthUserHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                    FirebaseAuthUserHostApi* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.delete",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->Delete(app_arg,
                          [reply](std::optional<FlutterError>&& output) {
                            if (output.has_value()) {
                              reply(WrapError(output.value()));
                              return;
                            }
                            EncodableList wrapped;
                            wrapped.emplace_back();
                            reply(EncodableValue(std::move(wrapped)));
                          });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.getIdToken",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_force_refresh_arg = args.at(1);
              if (encodable_force_refresh_arg.IsNull()) {
                reply(WrapError("force_refresh_arg unexpectedly null."));
                return;
              }
              const auto& force_refresh_arg =
                  std::get<bool>(encodable_force_refresh_arg);
              api->GetIdToken(app_arg, force_refresh_arg,
                              [reply](ErrorOr<PigeonIdTokenResult>&& output) {
                                if (output.has_error()) {
                                  reply(WrapError(output.error()));
                                  return;
                                }
                                EncodableList wrapped;
                                wrapped.emplace_back(CustomEncodableValue(
                                    std::move(output).TakeValue()));
                                reply(EncodableValue(std::move(wrapped)));
                              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.linkWithCredential",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_input_arg = args.at(1);
              if (encodable_input_arg.IsNull()) {
                reply(WrapError("input_arg unexpectedly null."));
                return;
              }
              const auto& input_arg =
                  std::get<EncodableMap>(encodable_input_arg);
              api->LinkWithCredential(
                  app_arg, input_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.linkWithProvider",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_sign_in_provider_arg = args.at(1);
              if (encodable_sign_in_provider_arg.IsNull()) {
                reply(WrapError("sign_in_provider_arg unexpectedly null."));
                return;
              }
              const auto& sign_in_provider_arg =
                  std::any_cast<const PigeonSignInProvider&>(
                      std::get<CustomEncodableValue>(
                          encodable_sign_in_provider_arg));
              api->LinkWithProvider(
                  app_arg, sign_in_provider_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.reauthenticateWithCredential",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_input_arg = args.at(1);
              if (encodable_input_arg.IsNull()) {
                reply(WrapError("input_arg unexpectedly null."));
                return;
              }
              const auto& input_arg =
                  std::get<EncodableMap>(encodable_input_arg);
              api->ReauthenticateWithCredential(
                  app_arg, input_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.reauthenticateWithProvider",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_sign_in_provider_arg = args.at(1);
              if (encodable_sign_in_provider_arg.IsNull()) {
                reply(WrapError("sign_in_provider_arg unexpectedly null."));
                return;
              }
              const auto& sign_in_provider_arg =
                  std::any_cast<const PigeonSignInProvider&>(
                      std::get<CustomEncodableValue>(
                          encodable_sign_in_provider_arg));
              api->ReauthenticateWithProvider(
                  app_arg, sign_in_provider_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.reload",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->Reload(
                  app_arg, [reply](ErrorOr<PigeonUserDetails>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.sendEmailVerification",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_action_code_settings_arg = args.at(1);
              const auto* action_code_settings_arg =
                  &(std::any_cast<const PigeonActionCodeSettings&>(
                      std::get<CustomEncodableValue>(
                          encodable_action_code_settings_arg)));
              api->SendEmailVerification(
                  app_arg, action_code_settings_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.unlink",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_provider_id_arg = args.at(1);
              if (encodable_provider_id_arg.IsNull()) {
                reply(WrapError("provider_id_arg unexpectedly null."));
                return;
              }
              const auto& provider_id_arg =
                  std::get<std::string>(encodable_provider_id_arg);
              api->Unlink(app_arg, provider_id_arg,
                          [reply](ErrorOr<PigeonUserCredential>&& output) {
                            if (output.has_error()) {
                              reply(WrapError(output.error()));
                              return;
                            }
                            EncodableList wrapped;
                            wrapped.emplace_back(CustomEncodableValue(
                                std::move(output).TakeValue()));
                            reply(EncodableValue(std::move(wrapped)));
                          });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.updateEmail",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_new_email_arg = args.at(1);
              if (encodable_new_email_arg.IsNull()) {
                reply(WrapError("new_email_arg unexpectedly null."));
                return;
              }
              const auto& new_email_arg =
                  std::get<std::string>(encodable_new_email_arg);
              api->UpdateEmail(app_arg, new_email_arg,
                               [reply](ErrorOr<PigeonUserDetails>&& output) {
                                 if (output.has_error()) {
                                   reply(WrapError(output.error()));
                                   return;
                                 }
                                 EncodableList wrapped;
                                 wrapped.emplace_back(CustomEncodableValue(
                                     std::move(output).TakeValue()));
                                 reply(EncodableValue(std::move(wrapped)));
                               });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.updatePassword",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_new_password_arg = args.at(1);
              if (encodable_new_password_arg.IsNull()) {
                reply(WrapError("new_password_arg unexpectedly null."));
                return;
              }
              const auto& new_password_arg =
                  std::get<std::string>(encodable_new_password_arg);
              api->UpdatePassword(app_arg, new_password_arg,
                                  [reply](ErrorOr<PigeonUserDetails>&& output) {
                                    if (output.has_error()) {
                                      reply(WrapError(output.error()));
                                      return;
                                    }
                                    EncodableList wrapped;
                                    wrapped.emplace_back(CustomEncodableValue(
                                        std::move(output).TakeValue()));
                                    reply(EncodableValue(std::move(wrapped)));
                                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.updatePhoneNumber",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_input_arg = args.at(1);
              if (encodable_input_arg.IsNull()) {
                reply(WrapError("input_arg unexpectedly null."));
                return;
              }
              const auto& input_arg =
                  std::get<EncodableMap>(encodable_input_arg);
              api->UpdatePhoneNumber(
                  app_arg, input_arg,
                  [reply](ErrorOr<PigeonUserDetails>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.updateProfile",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_profile_arg = args.at(1);
              if (encodable_profile_arg.IsNull()) {
                reply(WrapError("profile_arg unexpectedly null."));
                return;
              }
              const auto& profile_arg = std::any_cast<const PigeonUserProfile&>(
                  std::get<CustomEncodableValue>(encodable_profile_arg));
              api->UpdateProfile(app_arg, profile_arg,
                                 [reply](ErrorOr<PigeonUserDetails>&& output) {
                                   if (output.has_error()) {
                                     reply(WrapError(output.error()));
                                     return;
                                   }
                                   EncodableList wrapped;
                                   wrapped.emplace_back(CustomEncodableValue(
                                       std::move(output).TakeValue()));
                                   reply(EncodableValue(std::move(wrapped)));
                                 });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "FirebaseAuthUserHostApi.verifyBeforeUpdateEmail",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_new_email_arg = args.at(1);
              if (encodable_new_email_arg.IsNull()) {
                reply(WrapError("new_email_arg unexpectedly null."));
                return;
              }
              const auto& new_email_arg =
                  std::get<std::string>(encodable_new_email_arg);
              const auto& encodable_action_code_settings_arg = args.at(2);
              const auto* action_code_settings_arg =
                  &(std::any_cast<const PigeonActionCodeSettings&>(
                      std::get<CustomEncodableValue>(
                          encodable_action_code_settings_arg)));
              api->VerifyBeforeUpdateEmail(
                  app_arg, new_email_arg, action_code_settings_arg,
                  [reply](std::optional<FlutterError>&& output) {
                    if (output.has_value()) {
                      reply(WrapError(output.value()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back();
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue FirebaseAuthUserHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue FirebaseAuthUserHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

MultiFactorUserHostApiCodecSerializer::MultiFactorUserHostApiCodecSerializer() =
    default;

EncodableValue MultiFactorUserHostApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(AuthPigeonFirebaseApp::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 129:
      return CustomEncodableValue(PigeonMultiFactorInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 130:
      return CustomEncodableValue(PigeonMultiFactorSession::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 131:
      return CustomEncodableValue(
          PigeonPhoneMultiFactorAssertion::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void MultiFactorUserHostApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(AuthPigeonFirebaseApp)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(std::any_cast<AuthPigeonFirebaseApp>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonMultiFactorInfo)) {
      stream->WriteByte(129);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonMultiFactorSession)) {
      stream->WriteByte(130);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorSession>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonPhoneMultiFactorAssertion)) {
      stream->WriteByte(131);
      WriteValue(EncodableValue(std::any_cast<PigeonPhoneMultiFactorAssertion>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by MultiFactorUserHostApi.
const flutter::StandardMessageCodec& MultiFactorUserHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &MultiFactorUserHostApiCodecSerializer::GetInstance());
}

// Sets up an instance of `MultiFactorUserHostApi` to handle messages through
// the `binary_messenger`.
void MultiFactorUserHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   MultiFactorUserHostApi* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorUserHostApi.enrollPhone",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_assertion_arg = args.at(1);
              if (encodable_assertion_arg.IsNull()) {
                reply(WrapError("assertion_arg unexpectedly null."));
                return;
              }
              const auto& assertion_arg =
                  std::any_cast<const PigeonPhoneMultiFactorAssertion&>(
                      std::get<CustomEncodableValue>(encodable_assertion_arg));
              const auto& encodable_display_name_arg = args.at(2);
              const auto* display_name_arg =
                  std::get_if<std::string>(&encodable_display_name_arg);
              api->EnrollPhone(app_arg, assertion_arg, display_name_arg,
                               [reply](std::optional<FlutterError>&& output) {
                                 if (output.has_value()) {
                                   reply(WrapError(output.value()));
                                   return;
                                 }
                                 EncodableList wrapped;
                                 wrapped.emplace_back();
                                 reply(EncodableValue(std::move(wrapped)));
                               });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorUserHostApi.enrollTotp",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_assertion_id_arg = args.at(1);
              if (encodable_assertion_id_arg.IsNull()) {
                reply(WrapError("assertion_id_arg unexpectedly null."));
                return;
              }
              const auto& assertion_id_arg =
                  std::get<std::string>(encodable_assertion_id_arg);
              const auto& encodable_display_name_arg = args.at(2);
              const auto* display_name_arg =
                  std::get_if<std::string>(&encodable_display_name_arg);
              api->EnrollTotp(app_arg, assertion_id_arg, display_name_arg,
                              [reply](std::optional<FlutterError>&& output) {
                                if (output.has_value()) {
                                  reply(WrapError(output.value()));
                                  return;
                                }
                                EncodableList wrapped;
                                wrapped.emplace_back();
                                reply(EncodableValue(std::move(wrapped)));
                              });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorUserHostApi.getSession",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->GetSession(
                  app_arg, [reply](ErrorOr<PigeonMultiFactorSession>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorUserHostApi.unenroll",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              const auto& encodable_factor_uid_arg = args.at(1);
              if (encodable_factor_uid_arg.IsNull()) {
                reply(WrapError("factor_uid_arg unexpectedly null."));
                return;
              }
              const auto& factor_uid_arg =
                  std::get<std::string>(encodable_factor_uid_arg);
              api->Unenroll(app_arg, factor_uid_arg,
                            [reply](std::optional<FlutterError>&& output) {
                              if (output.has_value()) {
                                reply(WrapError(output.value()));
                                return;
                              }
                              EncodableList wrapped;
                              wrapped.emplace_back();
                              reply(EncodableValue(std::move(wrapped)));
                            });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorUserHostApi.getEnrolledFactors",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_app_arg = args.at(0);
              if (encodable_app_arg.IsNull()) {
                reply(WrapError("app_arg unexpectedly null."));
                return;
              }
              const auto& app_arg = std::any_cast<const AuthPigeonFirebaseApp&>(
                  std::get<CustomEncodableValue>(encodable_app_arg));
              api->GetEnrolledFactors(
                  app_arg, [reply](ErrorOr<EncodableList>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue MultiFactorUserHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue MultiFactorUserHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

MultiFactoResolverHostApiCodecSerializer::
    MultiFactoResolverHostApiCodecSerializer() = default;

EncodableValue MultiFactoResolverHostApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(PigeonAdditionalUserInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 129:
      return CustomEncodableValue(PigeonAuthCredential::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 130:
      return CustomEncodableValue(
          PigeonPhoneMultiFactorAssertion::FromEncodableList(
              std::get<EncodableList>(ReadValue(stream))));
    case 131:
      return CustomEncodableValue(PigeonUserCredential::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 132:
      return CustomEncodableValue(PigeonUserDetails::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    case 133:
      return CustomEncodableValue(PigeonUserInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void MultiFactoResolverHostApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(PigeonAdditionalUserInfo)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(std::any_cast<PigeonAdditionalUserInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonAuthCredential)) {
      stream->WriteByte(129);
      WriteValue(
          EncodableValue(std::any_cast<PigeonAuthCredential>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonPhoneMultiFactorAssertion)) {
      stream->WriteByte(130);
      WriteValue(EncodableValue(std::any_cast<PigeonPhoneMultiFactorAssertion>(
                                    *custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserCredential)) {
      stream->WriteByte(131);
      WriteValue(
          EncodableValue(std::any_cast<PigeonUserCredential>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserDetails)) {
      stream->WriteByte(132);
      WriteValue(EncodableValue(std::any_cast<PigeonUserDetails>(*custom_value)
                                    .ToEncodableList()),
                 stream);
      return;
    }
    if (custom_value->type() == typeid(PigeonUserInfo)) {
      stream->WriteByte(133);
      WriteValue(
          EncodableValue(
              std::any_cast<PigeonUserInfo>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by MultiFactoResolverHostApi.
const flutter::StandardMessageCodec& MultiFactoResolverHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &MultiFactoResolverHostApiCodecSerializer::GetInstance());
}

// Sets up an instance of `MultiFactoResolverHostApi` to handle messages through
// the `binary_messenger`.
void MultiFactoResolverHostApi::SetUp(
    flutter::BinaryMessenger* binary_messenger,
    MultiFactoResolverHostApi* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactoResolverHostApi.resolveSignIn",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_resolver_id_arg = args.at(0);
              if (encodable_resolver_id_arg.IsNull()) {
                reply(WrapError("resolver_id_arg unexpectedly null."));
                return;
              }
              const auto& resolver_id_arg =
                  std::get<std::string>(encodable_resolver_id_arg);
              const auto& encodable_assertion_arg = args.at(1);
              const auto* assertion_arg =
                  &(std::any_cast<const PigeonPhoneMultiFactorAssertion&>(
                      std::get<CustomEncodableValue>(encodable_assertion_arg)));
              const auto& encodable_totp_assertion_id_arg = args.at(2);
              const auto* totp_assertion_id_arg =
                  std::get_if<std::string>(&encodable_totp_assertion_id_arg);
              api->ResolveSignIn(
                  resolver_id_arg, assertion_arg, totp_assertion_id_arg,
                  [reply](ErrorOr<PigeonUserCredential>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue MultiFactoResolverHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue MultiFactoResolverHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

MultiFactorTotpHostApiCodecSerializer::MultiFactorTotpHostApiCodecSerializer() =
    default;

EncodableValue MultiFactorTotpHostApiCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(PigeonTotpSecret::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void MultiFactorTotpHostApiCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(PigeonTotpSecret)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(
              std::any_cast<PigeonTotpSecret>(*custom_value).ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by MultiFactorTotpHostApi.
const flutter::StandardMessageCodec& MultiFactorTotpHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &MultiFactorTotpHostApiCodecSerializer::GetInstance());
}

// Sets up an instance of `MultiFactorTotpHostApi` to handle messages through
// the `binary_messenger`.
void MultiFactorTotpHostApi::SetUp(flutter::BinaryMessenger* binary_messenger,
                                   MultiFactorTotpHostApi* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorTotpHostApi.generateSecret",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_session_id_arg = args.at(0);
              if (encodable_session_id_arg.IsNull()) {
                reply(WrapError("session_id_arg unexpectedly null."));
                return;
              }
              const auto& session_id_arg =
                  std::get<std::string>(encodable_session_id_arg);
              api->GenerateSecret(
                  session_id_arg, [reply](ErrorOr<PigeonTotpSecret>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(
                        CustomEncodableValue(std::move(output).TakeValue()));
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorTotpHostApi.getAssertionForEnrollment",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_secret_key_arg = args.at(0);
              if (encodable_secret_key_arg.IsNull()) {
                reply(WrapError("secret_key_arg unexpectedly null."));
                return;
              }
              const auto& secret_key_arg =
                  std::get<std::string>(encodable_secret_key_arg);
              const auto& encodable_one_time_password_arg = args.at(1);
              if (encodable_one_time_password_arg.IsNull()) {
                reply(WrapError("one_time_password_arg unexpectedly null."));
                return;
              }
              const auto& one_time_password_arg =
                  std::get<std::string>(encodable_one_time_password_arg);
              api->GetAssertionForEnrollment(
                  secret_key_arg, one_time_password_arg,
                  [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorTotpHostApi.getAssertionForSignIn",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_enrollment_id_arg = args.at(0);
              if (encodable_enrollment_id_arg.IsNull()) {
                reply(WrapError("enrollment_id_arg unexpectedly null."));
                return;
              }
              const auto& enrollment_id_arg =
                  std::get<std::string>(encodable_enrollment_id_arg);
              const auto& encodable_one_time_password_arg = args.at(1);
              if (encodable_one_time_password_arg.IsNull()) {
                reply(WrapError("one_time_password_arg unexpectedly null."));
                return;
              }
              const auto& one_time_password_arg =
                  std::get<std::string>(encodable_one_time_password_arg);
              api->GetAssertionForSignIn(
                  enrollment_id_arg, one_time_password_arg,
                  [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue MultiFactorTotpHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue MultiFactorTotpHostApi::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

/// The codec used by MultiFactorTotpSecretHostApi.
const flutter::StandardMessageCodec& MultiFactorTotpSecretHostApi::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &flutter::StandardCodecSerializer::GetInstance());
}

// Sets up an instance of `MultiFactorTotpSecretHostApi` to handle messages
// through the `binary_messenger`.
void MultiFactorTotpSecretHostApi::SetUp(
    flutter::BinaryMessenger* binary_messenger,
    MultiFactorTotpSecretHostApi* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorTotpSecretHostApi.generateQrCodeUrl",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_secret_key_arg = args.at(0);
              if (encodable_secret_key_arg.IsNull()) {
                reply(WrapError("secret_key_arg unexpectedly null."));
                return;
              }
              const auto& secret_key_arg =
                  std::get<std::string>(encodable_secret_key_arg);
              const auto& encodable_account_name_arg = args.at(1);
              const auto* account_name_arg =
                  std::get_if<std::string>(&encodable_account_name_arg);
              const auto& encodable_issuer_arg = args.at(2);
              const auto* issuer_arg =
                  std::get_if<std::string>(&encodable_issuer_arg);
              api->GenerateQrCodeUrl(
                  secret_key_arg, account_name_arg, issuer_arg,
                  [reply](ErrorOr<std::string>&& output) {
                    if (output.has_error()) {
                      reply(WrapError(output.error()));
                      return;
                    }
                    EncodableList wrapped;
                    wrapped.emplace_back(std::move(output).TakeValue());
                    reply(EncodableValue(std::move(wrapped)));
                  });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "MultiFactorTotpSecretHostApi.openInOtpApp",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_secret_key_arg = args.at(0);
              if (encodable_secret_key_arg.IsNull()) {
                reply(WrapError("secret_key_arg unexpectedly null."));
                return;
              }
              const auto& secret_key_arg =
                  std::get<std::string>(encodable_secret_key_arg);
              const auto& encodable_qr_code_url_arg = args.at(1);
              if (encodable_qr_code_url_arg.IsNull()) {
                reply(WrapError("qr_code_url_arg unexpectedly null."));
                return;
              }
              const auto& qr_code_url_arg =
                  std::get<std::string>(encodable_qr_code_url_arg);
              api->OpenInOtpApp(secret_key_arg, qr_code_url_arg,
                                [reply](std::optional<FlutterError>&& output) {
                                  if (output.has_value()) {
                                    reply(WrapError(output.value()));
                                    return;
                                  }
                                  EncodableList wrapped;
                                  wrapped.emplace_back();
                                  reply(EncodableValue(std::move(wrapped)));
                                });
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue MultiFactorTotpSecretHostApi::WrapError(
    std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue MultiFactorTotpSecretHostApi::WrapError(
    const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

GenerateInterfacesCodecSerializer::GenerateInterfacesCodecSerializer() =
    default;

EncodableValue GenerateInterfacesCodecSerializer::ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const {
  switch (type) {
    case 128:
      return CustomEncodableValue(PigeonMultiFactorInfo::FromEncodableList(
          std::get<EncodableList>(ReadValue(stream))));
    default:
      return flutter::StandardCodecSerializer::ReadValueOfType(type, stream);
  }
}

void GenerateInterfacesCodecSerializer::WriteValue(
    const EncodableValue& value,
    flutter::ByteStreamWriter* stream) const {
  if (const CustomEncodableValue* custom_value =
          std::get_if<CustomEncodableValue>(&value)) {
    if (custom_value->type() == typeid(PigeonMultiFactorInfo)) {
      stream->WriteByte(128);
      WriteValue(
          EncodableValue(std::any_cast<PigeonMultiFactorInfo>(*custom_value)
                             .ToEncodableList()),
          stream);
      return;
    }
  }
  flutter::StandardCodecSerializer::WriteValue(value, stream);
}

/// The codec used by GenerateInterfaces.
const flutter::StandardMessageCodec& GenerateInterfaces::GetCodec() {
  return flutter::StandardMessageCodec::GetInstance(
      &GenerateInterfacesCodecSerializer::GetInstance());
}

// Sets up an instance of `GenerateInterfaces` to handle messages through the
// `binary_messenger`.
void GenerateInterfaces::SetUp(flutter::BinaryMessenger* binary_messenger,
                               GenerateInterfaces* api) {
  {
    const auto channel = std::make_unique<BasicMessageChannel<>>(
        binary_messenger,
        "dev.flutter.pigeon.firebase_auth_platform_interface."
        "GenerateInterfaces.pigeonInterface",
        &GetCodec());
    if (api != nullptr) {
      channel->SetMessageHandler(
          [api](const EncodableValue& message,
                const flutter::MessageReply<EncodableValue>& reply) {
            try {
              const auto& args = std::get<EncodableList>(message);
              const auto& encodable_info_arg = args.at(0);
              if (encodable_info_arg.IsNull()) {
                reply(WrapError("info_arg unexpectedly null."));
                return;
              }
              const auto& info_arg =
                  std::any_cast<const PigeonMultiFactorInfo&>(
                      std::get<CustomEncodableValue>(encodable_info_arg));
              const std::optional<FlutterError> output =
                  api->PigeonInterface(info_arg);
              if (output.has_value()) {
                reply(WrapError(output.value()));
                return;
              }
              EncodableList wrapped;
              wrapped.emplace_back();
              reply(EncodableValue(std::move(wrapped)));
            } catch (const std::exception& exception) {
              reply(WrapError(exception.what()));
            }
          });
    } else {
      channel->SetMessageHandler(nullptr);
    }
  }
}

EncodableValue GenerateInterfaces::WrapError(std::string_view error_message) {
  return EncodableValue(
      EncodableList{EncodableValue(std::string(error_message)),
                    EncodableValue("Error"), EncodableValue()});
}

EncodableValue GenerateInterfaces::WrapError(const FlutterError& error) {
  return EncodableValue(EncodableList{EncodableValue(error.code()),
                                      EncodableValue(error.message()),
                                      error.details()});
}

}  // namespace firebase_auth_linux
