/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_RENDER_PASS_H
#define VN_PROTOCOL_DRIVER_RENDER_PASS_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/* struct VkAttachmentDescription */

static inline size_t
vn_sizeof_VkAttachmentDescription(const VkAttachmentDescription *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkSampleCountFlagBits(&val->samples);
    size += vn_sizeof_VkAttachmentLoadOp(&val->loadOp);
    size += vn_sizeof_VkAttachmentStoreOp(&val->storeOp);
    size += vn_sizeof_VkAttachmentLoadOp(&val->stencilLoadOp);
    size += vn_sizeof_VkAttachmentStoreOp(&val->stencilStoreOp);
    size += vn_sizeof_VkImageLayout(&val->initialLayout);
    size += vn_sizeof_VkImageLayout(&val->finalLayout);
    return size;
}

static inline void
vn_encode_VkAttachmentDescription(struct vn_cs_encoder *enc, const VkAttachmentDescription *val)
{
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkSampleCountFlagBits(enc, &val->samples);
    vn_encode_VkAttachmentLoadOp(enc, &val->loadOp);
    vn_encode_VkAttachmentStoreOp(enc, &val->storeOp);
    vn_encode_VkAttachmentLoadOp(enc, &val->stencilLoadOp);
    vn_encode_VkAttachmentStoreOp(enc, &val->stencilStoreOp);
    vn_encode_VkImageLayout(enc, &val->initialLayout);
    vn_encode_VkImageLayout(enc, &val->finalLayout);
}

/* struct VkAttachmentReference */

static inline size_t
vn_sizeof_VkAttachmentReference(const VkAttachmentReference *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->attachment);
    size += vn_sizeof_VkImageLayout(&val->layout);
    return size;
}

static inline void
vn_encode_VkAttachmentReference(struct vn_cs_encoder *enc, const VkAttachmentReference *val)
{
    vn_encode_uint32_t(enc, &val->attachment);
    vn_encode_VkImageLayout(enc, &val->layout);
}

/* struct VkSubpassDescription */

static inline size_t
vn_sizeof_VkSubpassDescription(const VkSubpassDescription *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkPipelineBindPoint(&val->pipelineBindPoint);
    size += vn_sizeof_uint32_t(&val->inputAttachmentCount);
    if (val->pInputAttachments) {
        size += vn_sizeof_array_size(val->inputAttachmentCount);
        for (uint32_t i = 0; i < val->inputAttachmentCount; i++)
            size += vn_sizeof_VkAttachmentReference(&val->pInputAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->colorAttachmentCount);
    if (val->pColorAttachments) {
        size += vn_sizeof_array_size(val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            size += vn_sizeof_VkAttachmentReference(&val->pColorAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    if (val->pResolveAttachments) {
        size += vn_sizeof_array_size(val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            size += vn_sizeof_VkAttachmentReference(&val->pResolveAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pDepthStencilAttachment);
    if (val->pDepthStencilAttachment)
        size += vn_sizeof_VkAttachmentReference(val->pDepthStencilAttachment);
    size += vn_sizeof_uint32_t(&val->preserveAttachmentCount);
    if (val->pPreserveAttachments) {
        size += vn_sizeof_array_size(val->preserveAttachmentCount);
        size += vn_sizeof_uint32_t_array(val->pPreserveAttachments, val->preserveAttachmentCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline void
vn_encode_VkSubpassDescription(struct vn_cs_encoder *enc, const VkSubpassDescription *val)
{
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkPipelineBindPoint(enc, &val->pipelineBindPoint);
    vn_encode_uint32_t(enc, &val->inputAttachmentCount);
    if (val->pInputAttachments) {
        vn_encode_array_size(enc, val->inputAttachmentCount);
        for (uint32_t i = 0; i < val->inputAttachmentCount; i++)
            vn_encode_VkAttachmentReference(enc, &val->pInputAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->colorAttachmentCount);
    if (val->pColorAttachments) {
        vn_encode_array_size(enc, val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_encode_VkAttachmentReference(enc, &val->pColorAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (val->pResolveAttachments) {
        vn_encode_array_size(enc, val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_encode_VkAttachmentReference(enc, &val->pResolveAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pDepthStencilAttachment))
        vn_encode_VkAttachmentReference(enc, val->pDepthStencilAttachment);
    vn_encode_uint32_t(enc, &val->preserveAttachmentCount);
    if (val->pPreserveAttachments) {
        vn_encode_array_size(enc, val->preserveAttachmentCount);
        vn_encode_uint32_t_array(enc, val->pPreserveAttachments, val->preserveAttachmentCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

/* struct VkSubpassDependency */

static inline size_t
vn_sizeof_VkSubpassDependency(const VkSubpassDependency *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->srcSubpass);
    size += vn_sizeof_uint32_t(&val->dstSubpass);
    size += vn_sizeof_VkFlags(&val->srcStageMask);
    size += vn_sizeof_VkFlags(&val->dstStageMask);
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    size += vn_sizeof_VkFlags(&val->dependencyFlags);
    return size;
}

static inline void
vn_encode_VkSubpassDependency(struct vn_cs_encoder *enc, const VkSubpassDependency *val)
{
    vn_encode_uint32_t(enc, &val->srcSubpass);
    vn_encode_uint32_t(enc, &val->dstSubpass);
    vn_encode_VkFlags(enc, &val->srcStageMask);
    vn_encode_VkFlags(enc, &val->dstStageMask);
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
    vn_encode_VkFlags(enc, &val->dependencyFlags);
}

/* struct VkRenderPassMultiviewCreateInfo chain */

static inline size_t
vn_sizeof_VkRenderPassMultiviewCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassMultiviewCreateInfo_self(const VkRenderPassMultiviewCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->subpassCount);
    if (val->pViewMasks) {
        size += vn_sizeof_array_size(val->subpassCount);
        size += vn_sizeof_uint32_t_array(val->pViewMasks, val->subpassCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->dependencyCount);
    if (val->pViewOffsets) {
        size += vn_sizeof_array_size(val->dependencyCount);
        size += vn_sizeof_int32_t_array(val->pViewOffsets, val->dependencyCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->correlationMaskCount);
    if (val->pCorrelationMasks) {
        size += vn_sizeof_array_size(val->correlationMaskCount);
        size += vn_sizeof_uint32_t_array(val->pCorrelationMasks, val->correlationMaskCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassMultiviewCreateInfo(const VkRenderPassMultiviewCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassMultiviewCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassMultiviewCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassMultiviewCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassMultiviewCreateInfo_self(struct vn_cs_encoder *enc, const VkRenderPassMultiviewCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->subpassCount);
    if (val->pViewMasks) {
        vn_encode_array_size(enc, val->subpassCount);
        vn_encode_uint32_t_array(enc, val->pViewMasks, val->subpassCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->dependencyCount);
    if (val->pViewOffsets) {
        vn_encode_array_size(enc, val->dependencyCount);
        vn_encode_int32_t_array(enc, val->pViewOffsets, val->dependencyCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->correlationMaskCount);
    if (val->pCorrelationMasks) {
        vn_encode_array_size(enc, val->correlationMaskCount);
        vn_encode_uint32_t_array(enc, val->pCorrelationMasks, val->correlationMaskCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassMultiviewCreateInfo(struct vn_cs_encoder *enc, const VkRenderPassMultiviewCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO });
    vn_encode_VkRenderPassMultiviewCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassMultiviewCreateInfo_self(enc, val);
}

/* struct VkInputAttachmentAspectReference */

static inline size_t
vn_sizeof_VkInputAttachmentAspectReference(const VkInputAttachmentAspectReference *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->subpass);
    size += vn_sizeof_uint32_t(&val->inputAttachmentIndex);
    size += vn_sizeof_VkFlags(&val->aspectMask);
    return size;
}

static inline void
vn_encode_VkInputAttachmentAspectReference(struct vn_cs_encoder *enc, const VkInputAttachmentAspectReference *val)
{
    vn_encode_uint32_t(enc, &val->subpass);
    vn_encode_uint32_t(enc, &val->inputAttachmentIndex);
    vn_encode_VkFlags(enc, &val->aspectMask);
}

/* struct VkRenderPassInputAttachmentAspectCreateInfo chain */

static inline size_t
vn_sizeof_VkRenderPassInputAttachmentAspectCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassInputAttachmentAspectCreateInfo_self(const VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->aspectReferenceCount);
    if (val->pAspectReferences) {
        size += vn_sizeof_array_size(val->aspectReferenceCount);
        for (uint32_t i = 0; i < val->aspectReferenceCount; i++)
            size += vn_sizeof_VkInputAttachmentAspectReference(&val->pAspectReferences[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassInputAttachmentAspectCreateInfo(const VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassInputAttachmentAspectCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassInputAttachmentAspectCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassInputAttachmentAspectCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassInputAttachmentAspectCreateInfo_self(struct vn_cs_encoder *enc, const VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->aspectReferenceCount);
    if (val->pAspectReferences) {
        vn_encode_array_size(enc, val->aspectReferenceCount);
        for (uint32_t i = 0; i < val->aspectReferenceCount; i++)
            vn_encode_VkInputAttachmentAspectReference(enc, &val->pAspectReferences[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassInputAttachmentAspectCreateInfo(struct vn_cs_encoder *enc, const VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO });
    vn_encode_VkRenderPassInputAttachmentAspectCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassInputAttachmentAspectCreateInfo_self(enc, val);
}

/* struct VkRenderPassCreateInfo chain */

static inline size_t
vn_sizeof_VkRenderPassCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderPassMultiviewCreateInfo_self((const VkRenderPassMultiviewCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderPassInputAttachmentAspectCreateInfo_self((const VkRenderPassInputAttachmentAspectCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassCreateInfo_self(const VkRenderPassCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->attachmentCount);
    if (val->pAttachments) {
        size += vn_sizeof_array_size(val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            size += vn_sizeof_VkAttachmentDescription(&val->pAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->subpassCount);
    if (val->pSubpasses) {
        size += vn_sizeof_array_size(val->subpassCount);
        for (uint32_t i = 0; i < val->subpassCount; i++)
            size += vn_sizeof_VkSubpassDescription(&val->pSubpasses[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->dependencyCount);
    if (val->pDependencies) {
        size += vn_sizeof_array_size(val->dependencyCount);
        for (uint32_t i = 0; i < val->dependencyCount; i++)
            size += vn_sizeof_VkSubpassDependency(&val->pDependencies[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassCreateInfo(const VkRenderPassCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderPassMultiviewCreateInfo_self(enc, (const VkRenderPassMultiviewCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderPassInputAttachmentAspectCreateInfo_self(enc, (const VkRenderPassInputAttachmentAspectCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassCreateInfo_self(struct vn_cs_encoder *enc, const VkRenderPassCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->attachmentCount);
    if (val->pAttachments) {
        vn_encode_array_size(enc, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_encode_VkAttachmentDescription(enc, &val->pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->subpassCount);
    if (val->pSubpasses) {
        vn_encode_array_size(enc, val->subpassCount);
        for (uint32_t i = 0; i < val->subpassCount; i++)
            vn_encode_VkSubpassDescription(enc, &val->pSubpasses[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->dependencyCount);
    if (val->pDependencies) {
        vn_encode_array_size(enc, val->dependencyCount);
        for (uint32_t i = 0; i < val->dependencyCount; i++)
            vn_encode_VkSubpassDependency(enc, &val->pDependencies[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassCreateInfo(struct vn_cs_encoder *enc, const VkRenderPassCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO });
    vn_encode_VkRenderPassCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassCreateInfo_self(enc, val);
}

/* struct VkAttachmentDescriptionStencilLayout chain */

static inline size_t
vn_sizeof_VkAttachmentDescriptionStencilLayout_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAttachmentDescriptionStencilLayout_self(const VkAttachmentDescriptionStencilLayout *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageLayout(&val->stencilInitialLayout);
    size += vn_sizeof_VkImageLayout(&val->stencilFinalLayout);
    return size;
}

static inline size_t
vn_sizeof_VkAttachmentDescriptionStencilLayout(const VkAttachmentDescriptionStencilLayout *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAttachmentDescriptionStencilLayout_pnext(val->pNext);
    size += vn_sizeof_VkAttachmentDescriptionStencilLayout_self(val);

    return size;
}

static inline void
vn_encode_VkAttachmentDescriptionStencilLayout_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAttachmentDescriptionStencilLayout_self(struct vn_cs_encoder *enc, const VkAttachmentDescriptionStencilLayout *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageLayout(enc, &val->stencilInitialLayout);
    vn_encode_VkImageLayout(enc, &val->stencilFinalLayout);
}

static inline void
vn_encode_VkAttachmentDescriptionStencilLayout(struct vn_cs_encoder *enc, const VkAttachmentDescriptionStencilLayout *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT });
    vn_encode_VkAttachmentDescriptionStencilLayout_pnext(enc, val->pNext);
    vn_encode_VkAttachmentDescriptionStencilLayout_self(enc, val);
}

/* struct VkAttachmentDescription2 chain */

static inline size_t
vn_sizeof_VkAttachmentDescription2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkAttachmentDescription2_pnext(pnext->pNext);
            size += vn_sizeof_VkAttachmentDescriptionStencilLayout_self((const VkAttachmentDescriptionStencilLayout *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAttachmentDescription2_self(const VkAttachmentDescription2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkSampleCountFlagBits(&val->samples);
    size += vn_sizeof_VkAttachmentLoadOp(&val->loadOp);
    size += vn_sizeof_VkAttachmentStoreOp(&val->storeOp);
    size += vn_sizeof_VkAttachmentLoadOp(&val->stencilLoadOp);
    size += vn_sizeof_VkAttachmentStoreOp(&val->stencilStoreOp);
    size += vn_sizeof_VkImageLayout(&val->initialLayout);
    size += vn_sizeof_VkImageLayout(&val->finalLayout);
    return size;
}

static inline size_t
vn_sizeof_VkAttachmentDescription2(const VkAttachmentDescription2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAttachmentDescription2_pnext(val->pNext);
    size += vn_sizeof_VkAttachmentDescription2_self(val);

    return size;
}

static inline void
vn_encode_VkAttachmentDescription2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkAttachmentDescription2_pnext(enc, pnext->pNext);
            vn_encode_VkAttachmentDescriptionStencilLayout_self(enc, (const VkAttachmentDescriptionStencilLayout *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAttachmentDescription2_self(struct vn_cs_encoder *enc, const VkAttachmentDescription2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkSampleCountFlagBits(enc, &val->samples);
    vn_encode_VkAttachmentLoadOp(enc, &val->loadOp);
    vn_encode_VkAttachmentStoreOp(enc, &val->storeOp);
    vn_encode_VkAttachmentLoadOp(enc, &val->stencilLoadOp);
    vn_encode_VkAttachmentStoreOp(enc, &val->stencilStoreOp);
    vn_encode_VkImageLayout(enc, &val->initialLayout);
    vn_encode_VkImageLayout(enc, &val->finalLayout);
}

static inline void
vn_encode_VkAttachmentDescription2(struct vn_cs_encoder *enc, const VkAttachmentDescription2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2 });
    vn_encode_VkAttachmentDescription2_pnext(enc, val->pNext);
    vn_encode_VkAttachmentDescription2_self(enc, val);
}

/* struct VkAttachmentReferenceStencilLayout chain */

static inline size_t
vn_sizeof_VkAttachmentReferenceStencilLayout_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAttachmentReferenceStencilLayout_self(const VkAttachmentReferenceStencilLayout *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageLayout(&val->stencilLayout);
    return size;
}

static inline size_t
vn_sizeof_VkAttachmentReferenceStencilLayout(const VkAttachmentReferenceStencilLayout *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAttachmentReferenceStencilLayout_pnext(val->pNext);
    size += vn_sizeof_VkAttachmentReferenceStencilLayout_self(val);

    return size;
}

static inline void
vn_encode_VkAttachmentReferenceStencilLayout_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAttachmentReferenceStencilLayout_self(struct vn_cs_encoder *enc, const VkAttachmentReferenceStencilLayout *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageLayout(enc, &val->stencilLayout);
}

static inline void
vn_encode_VkAttachmentReferenceStencilLayout(struct vn_cs_encoder *enc, const VkAttachmentReferenceStencilLayout *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT });
    vn_encode_VkAttachmentReferenceStencilLayout_pnext(enc, val->pNext);
    vn_encode_VkAttachmentReferenceStencilLayout_self(enc, val);
}

/* struct VkAttachmentReference2 chain */

static inline size_t
vn_sizeof_VkAttachmentReference2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkAttachmentReference2_pnext(pnext->pNext);
            size += vn_sizeof_VkAttachmentReferenceStencilLayout_self((const VkAttachmentReferenceStencilLayout *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkAttachmentReference2_self(const VkAttachmentReference2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->attachment);
    size += vn_sizeof_VkImageLayout(&val->layout);
    size += vn_sizeof_VkFlags(&val->aspectMask);
    return size;
}

static inline size_t
vn_sizeof_VkAttachmentReference2(const VkAttachmentReference2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkAttachmentReference2_pnext(val->pNext);
    size += vn_sizeof_VkAttachmentReference2_self(val);

    return size;
}

static inline void
vn_encode_VkAttachmentReference2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkAttachmentReference2_pnext(enc, pnext->pNext);
            vn_encode_VkAttachmentReferenceStencilLayout_self(enc, (const VkAttachmentReferenceStencilLayout *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkAttachmentReference2_self(struct vn_cs_encoder *enc, const VkAttachmentReference2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->attachment);
    vn_encode_VkImageLayout(enc, &val->layout);
    vn_encode_VkFlags(enc, &val->aspectMask);
}

static inline void
vn_encode_VkAttachmentReference2(struct vn_cs_encoder *enc, const VkAttachmentReference2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2 });
    vn_encode_VkAttachmentReference2_pnext(enc, val->pNext);
    vn_encode_VkAttachmentReference2_self(enc, val);
}

/* struct VkSubpassDescriptionDepthStencilResolve chain */

static inline size_t
vn_sizeof_VkSubpassDescriptionDepthStencilResolve_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassDescriptionDepthStencilResolve_self(const VkSubpassDescriptionDepthStencilResolve *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkResolveModeFlagBits(&val->depthResolveMode);
    size += vn_sizeof_VkResolveModeFlagBits(&val->stencilResolveMode);
    size += vn_sizeof_simple_pointer(val->pDepthStencilResolveAttachment);
    if (val->pDepthStencilResolveAttachment)
        size += vn_sizeof_VkAttachmentReference2(val->pDepthStencilResolveAttachment);
    return size;
}

static inline size_t
vn_sizeof_VkSubpassDescriptionDepthStencilResolve(const VkSubpassDescriptionDepthStencilResolve *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassDescriptionDepthStencilResolve_pnext(val->pNext);
    size += vn_sizeof_VkSubpassDescriptionDepthStencilResolve_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassDescriptionDepthStencilResolve_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassDescriptionDepthStencilResolve_self(struct vn_cs_encoder *enc, const VkSubpassDescriptionDepthStencilResolve *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkResolveModeFlagBits(enc, &val->depthResolveMode);
    vn_encode_VkResolveModeFlagBits(enc, &val->stencilResolveMode);
    if (vn_encode_simple_pointer(enc, val->pDepthStencilResolveAttachment))
        vn_encode_VkAttachmentReference2(enc, val->pDepthStencilResolveAttachment);
}

static inline void
vn_encode_VkSubpassDescriptionDepthStencilResolve(struct vn_cs_encoder *enc, const VkSubpassDescriptionDepthStencilResolve *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE });
    vn_encode_VkSubpassDescriptionDepthStencilResolve_pnext(enc, val->pNext);
    vn_encode_VkSubpassDescriptionDepthStencilResolve_self(enc, val);
}

/* struct VkSubpassDescription2 chain */

static inline size_t
vn_sizeof_VkSubpassDescription2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkSubpassDescription2_pnext(pnext->pNext);
            size += vn_sizeof_VkSubpassDescriptionDepthStencilResolve_self((const VkSubpassDescriptionDepthStencilResolve *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassDescription2_self(const VkSubpassDescription2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkPipelineBindPoint(&val->pipelineBindPoint);
    size += vn_sizeof_uint32_t(&val->viewMask);
    size += vn_sizeof_uint32_t(&val->inputAttachmentCount);
    if (val->pInputAttachments) {
        size += vn_sizeof_array_size(val->inputAttachmentCount);
        for (uint32_t i = 0; i < val->inputAttachmentCount; i++)
            size += vn_sizeof_VkAttachmentReference2(&val->pInputAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->colorAttachmentCount);
    if (val->pColorAttachments) {
        size += vn_sizeof_array_size(val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            size += vn_sizeof_VkAttachmentReference2(&val->pColorAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    if (val->pResolveAttachments) {
        size += vn_sizeof_array_size(val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            size += vn_sizeof_VkAttachmentReference2(&val->pResolveAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pDepthStencilAttachment);
    if (val->pDepthStencilAttachment)
        size += vn_sizeof_VkAttachmentReference2(val->pDepthStencilAttachment);
    size += vn_sizeof_uint32_t(&val->preserveAttachmentCount);
    if (val->pPreserveAttachments) {
        size += vn_sizeof_array_size(val->preserveAttachmentCount);
        size += vn_sizeof_uint32_t_array(val->pPreserveAttachments, val->preserveAttachmentCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkSubpassDescription2(const VkSubpassDescription2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassDescription2_pnext(val->pNext);
    size += vn_sizeof_VkSubpassDescription2_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassDescription2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkSubpassDescription2_pnext(enc, pnext->pNext);
            vn_encode_VkSubpassDescriptionDepthStencilResolve_self(enc, (const VkSubpassDescriptionDepthStencilResolve *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassDescription2_self(struct vn_cs_encoder *enc, const VkSubpassDescription2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkPipelineBindPoint(enc, &val->pipelineBindPoint);
    vn_encode_uint32_t(enc, &val->viewMask);
    vn_encode_uint32_t(enc, &val->inputAttachmentCount);
    if (val->pInputAttachments) {
        vn_encode_array_size(enc, val->inputAttachmentCount);
        for (uint32_t i = 0; i < val->inputAttachmentCount; i++)
            vn_encode_VkAttachmentReference2(enc, &val->pInputAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->colorAttachmentCount);
    if (val->pColorAttachments) {
        vn_encode_array_size(enc, val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_encode_VkAttachmentReference2(enc, &val->pColorAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (val->pResolveAttachments) {
        vn_encode_array_size(enc, val->colorAttachmentCount);
        for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_encode_VkAttachmentReference2(enc, &val->pResolveAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pDepthStencilAttachment))
        vn_encode_VkAttachmentReference2(enc, val->pDepthStencilAttachment);
    vn_encode_uint32_t(enc, &val->preserveAttachmentCount);
    if (val->pPreserveAttachments) {
        vn_encode_array_size(enc, val->preserveAttachmentCount);
        vn_encode_uint32_t_array(enc, val->pPreserveAttachments, val->preserveAttachmentCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkSubpassDescription2(struct vn_cs_encoder *enc, const VkSubpassDescription2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2 });
    vn_encode_VkSubpassDescription2_pnext(enc, val->pNext);
    vn_encode_VkSubpassDescription2_self(enc, val);
}

/* struct VkSubpassDependency2 chain */

static inline size_t
vn_sizeof_VkSubpassDependency2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkSubpassDependency2_pnext(pnext->pNext);
            size += vn_sizeof_VkMemoryBarrier2_self((const VkMemoryBarrier2 *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassDependency2_self(const VkSubpassDependency2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->srcSubpass);
    size += vn_sizeof_uint32_t(&val->dstSubpass);
    size += vn_sizeof_VkFlags(&val->srcStageMask);
    size += vn_sizeof_VkFlags(&val->dstStageMask);
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    size += vn_sizeof_VkFlags(&val->dependencyFlags);
    size += vn_sizeof_int32_t(&val->viewOffset);
    return size;
}

static inline size_t
vn_sizeof_VkSubpassDependency2(const VkSubpassDependency2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassDependency2_pnext(val->pNext);
    size += vn_sizeof_VkSubpassDependency2_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassDependency2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkSubpassDependency2_pnext(enc, pnext->pNext);
            vn_encode_VkMemoryBarrier2_self(enc, (const VkMemoryBarrier2 *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassDependency2_self(struct vn_cs_encoder *enc, const VkSubpassDependency2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->srcSubpass);
    vn_encode_uint32_t(enc, &val->dstSubpass);
    vn_encode_VkFlags(enc, &val->srcStageMask);
    vn_encode_VkFlags(enc, &val->dstStageMask);
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
    vn_encode_VkFlags(enc, &val->dependencyFlags);
    vn_encode_int32_t(enc, &val->viewOffset);
}

static inline void
vn_encode_VkSubpassDependency2(struct vn_cs_encoder *enc, const VkSubpassDependency2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2 });
    vn_encode_VkSubpassDependency2_pnext(enc, val->pNext);
    vn_encode_VkSubpassDependency2_self(enc, val);
}

/* struct VkRenderPassCreateInfo2 chain */

static inline size_t
vn_sizeof_VkRenderPassCreateInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassCreateInfo2_self(const VkRenderPassCreateInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->attachmentCount);
    if (val->pAttachments) {
        size += vn_sizeof_array_size(val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            size += vn_sizeof_VkAttachmentDescription2(&val->pAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->subpassCount);
    if (val->pSubpasses) {
        size += vn_sizeof_array_size(val->subpassCount);
        for (uint32_t i = 0; i < val->subpassCount; i++)
            size += vn_sizeof_VkSubpassDescription2(&val->pSubpasses[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->dependencyCount);
    if (val->pDependencies) {
        size += vn_sizeof_array_size(val->dependencyCount);
        for (uint32_t i = 0; i < val->dependencyCount; i++)
            size += vn_sizeof_VkSubpassDependency2(&val->pDependencies[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->correlatedViewMaskCount);
    if (val->pCorrelatedViewMasks) {
        size += vn_sizeof_array_size(val->correlatedViewMaskCount);
        size += vn_sizeof_uint32_t_array(val->pCorrelatedViewMasks, val->correlatedViewMaskCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassCreateInfo2(const VkRenderPassCreateInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassCreateInfo2_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassCreateInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassCreateInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassCreateInfo2_self(struct vn_cs_encoder *enc, const VkRenderPassCreateInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->attachmentCount);
    if (val->pAttachments) {
        vn_encode_array_size(enc, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_encode_VkAttachmentDescription2(enc, &val->pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->subpassCount);
    if (val->pSubpasses) {
        vn_encode_array_size(enc, val->subpassCount);
        for (uint32_t i = 0; i < val->subpassCount; i++)
            vn_encode_VkSubpassDescription2(enc, &val->pSubpasses[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->dependencyCount);
    if (val->pDependencies) {
        vn_encode_array_size(enc, val->dependencyCount);
        for (uint32_t i = 0; i < val->dependencyCount; i++)
            vn_encode_VkSubpassDependency2(enc, &val->pDependencies[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->correlatedViewMaskCount);
    if (val->pCorrelatedViewMasks) {
        vn_encode_array_size(enc, val->correlatedViewMaskCount);
        vn_encode_uint32_t_array(enc, val->pCorrelatedViewMasks, val->correlatedViewMaskCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassCreateInfo2(struct vn_cs_encoder *enc, const VkRenderPassCreateInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2 });
    vn_encode_VkRenderPassCreateInfo2_pnext(enc, val->pNext);
    vn_encode_VkRenderPassCreateInfo2_self(enc, val);
}

static inline size_t vn_sizeof_vkCreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateRenderPass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkRenderPassCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pRenderPass);
    if (pRenderPass)
        cmd_size += vn_sizeof_VkRenderPass(pRenderPass);

    return cmd_size;
}

static inline void vn_encode_vkCreateRenderPass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateRenderPass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkRenderPassCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pRenderPass))
        vn_encode_VkRenderPass(enc, pRenderPass);
}

static inline size_t vn_sizeof_vkCreateRenderPass_reply(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateRenderPass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pRenderPass);
    if (pRenderPass)
        cmd_size += vn_sizeof_VkRenderPass(pRenderPass);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateRenderPass_reply(struct vn_cs_decoder *dec, VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateRenderPass_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkRenderPass(dec, pRenderPass);
    } else {
        pRenderPass = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyRenderPass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkRenderPass(&renderPass);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyRenderPass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyRenderPass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkRenderPass(enc, &renderPass);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyRenderPass_reply(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyRenderPass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip renderPass */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyRenderPass_reply(struct vn_cs_decoder *dec, VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyRenderPass_EXT);

    /* skip device */
    /* skip renderPass */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkGetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkRenderPass(&renderPass);
    cmd_size += vn_sizeof_simple_pointer(pGranularity);
    if (pGranularity)
        cmd_size += vn_sizeof_VkExtent2D_partial(pGranularity);

    return cmd_size;
}

static inline void vn_encode_vkGetRenderAreaGranularity(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkRenderPass(enc, &renderPass);
    if (vn_encode_simple_pointer(enc, pGranularity))
        vn_encode_VkExtent2D_partial(enc, pGranularity);
}

static inline size_t vn_sizeof_vkGetRenderAreaGranularity_reply(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip renderPass */
    cmd_size += vn_sizeof_simple_pointer(pGranularity);
    if (pGranularity)
        cmd_size += vn_sizeof_VkExtent2D(pGranularity);

    return cmd_size;
}

static inline void vn_decode_vkGetRenderAreaGranularity_reply(struct vn_cs_decoder *dec, VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT);

    /* skip device */
    /* skip renderPass */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkExtent2D(dec, pGranularity);
    } else {
        pGranularity = NULL;
    }
}

static inline size_t vn_sizeof_vkCreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateRenderPass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkRenderPassCreateInfo2(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pRenderPass);
    if (pRenderPass)
        cmd_size += vn_sizeof_VkRenderPass(pRenderPass);

    return cmd_size;
}

static inline void vn_encode_vkCreateRenderPass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateRenderPass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkRenderPassCreateInfo2(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pRenderPass))
        vn_encode_VkRenderPass(enc, pRenderPass);
}

static inline size_t vn_sizeof_vkCreateRenderPass2_reply(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreateRenderPass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pRenderPass);
    if (pRenderPass)
        cmd_size += vn_sizeof_VkRenderPass(pRenderPass);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreateRenderPass2_reply(struct vn_cs_decoder *dec, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreateRenderPass2_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkRenderPass(dec, pRenderPass);
    } else {
        pRenderPass = NULL;
    }

    return ret;
}

static inline void vn_submit_vkCreateRenderPass(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateRenderPass_reply(device, pCreateInfo, pAllocator, pRenderPass) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateRenderPass(enc, cmd_flags, device, pCreateInfo, pAllocator, pRenderPass);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyRenderPass(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyRenderPass(device, renderPass, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyRenderPass_reply(device, renderPass, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyRenderPass(enc, cmd_flags, device, renderPass, pAllocator);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetRenderAreaGranularity(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetRenderAreaGranularity(device, renderPass, pGranularity);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetRenderAreaGranularity_reply(device, renderPass, pGranularity) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetRenderAreaGranularity(enc, cmd_flags, device, renderPass, pGranularity);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkCreateRenderPass2(struct vn_ring *vn_ring, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass, struct vn_ring_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreateRenderPass2_reply(device, pCreateInfo, pAllocator, pRenderPass) : 0;

    struct vn_cs_encoder *enc = vn_ring_submit_command_init(vn_ring, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreateRenderPass2(enc, cmd_flags, device, pCreateInfo, pAllocator, pRenderPass);
        vn_ring_submit_command(vn_ring, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreateRenderPass(struct vn_ring *vn_ring, VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateRenderPass(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pRenderPass, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateRenderPass_reply(dec, device, pCreateInfo, pAllocator, pRenderPass);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateRenderPass(struct vn_ring *vn_ring, VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateRenderPass(vn_ring, 0, device, pCreateInfo, pAllocator, pRenderPass, &submit);
}

static inline void vn_call_vkDestroyRenderPass(struct vn_ring *vn_ring, VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyRenderPass(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, renderPass, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkDestroyRenderPass_reply(dec, device, renderPass, pAllocator);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkDestroyRenderPass(struct vn_ring *vn_ring, VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkDestroyRenderPass(vn_ring, 0, device, renderPass, pAllocator, &submit);
}

static inline void vn_call_vkGetRenderAreaGranularity(struct vn_ring *vn_ring, VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkGetRenderAreaGranularity(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, renderPass, pGranularity, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        vn_decode_vkGetRenderAreaGranularity_reply(dec, device, renderPass, pGranularity);
        vn_ring_free_command_reply(vn_ring, &submit);
    }
}

static inline void vn_async_vkGetRenderAreaGranularity(struct vn_ring *vn_ring, VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkGetRenderAreaGranularity(vn_ring, 0, device, renderPass, pGranularity, &submit);
}

static inline VkResult vn_call_vkCreateRenderPass2(struct vn_ring *vn_ring, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    VN_TRACE_FUNC();

    struct vn_ring_submit_command submit;
    vn_submit_vkCreateRenderPass2(vn_ring, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pRenderPass, &submit);
    struct vn_cs_decoder *dec = vn_ring_get_command_reply(vn_ring, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreateRenderPass2_reply(dec, device, pCreateInfo, pAllocator, pRenderPass);
        vn_ring_free_command_reply(vn_ring, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreateRenderPass2(struct vn_ring *vn_ring, VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass)
{
    struct vn_ring_submit_command submit;
    vn_submit_vkCreateRenderPass2(vn_ring, 0, device, pCreateInfo, pAllocator, pRenderPass, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_RENDER_PASS_H */
