/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.util;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import java.io.File;

public final class PathUtils {
    @NonNull
    public static String getFilesDir(@NonNull Context applicationContext) {
        File filesDir = applicationContext.getFilesDir();
        if (filesDir == null) {
            filesDir = new File(PathUtils.getDataDirPath(applicationContext), "files");
        }
        return filesDir.getPath();
    }

    @NonNull
    public static String getDataDirectory(@NonNull Context applicationContext) {
        String name = "flutter";
        File flutterDir = applicationContext.getDir("flutter", 0);
        if (flutterDir == null) {
            flutterDir = new File(PathUtils.getDataDirPath(applicationContext), "app_flutter");
        }
        return flutterDir.getPath();
    }

    @NonNull
    public static String getCacheDirectory(@NonNull Context applicationContext) {
        File cacheDir = applicationContext.getCodeCacheDir();
        if (cacheDir == null) {
            cacheDir = applicationContext.getCacheDir();
        }
        if (cacheDir == null) {
            cacheDir = new File(PathUtils.getDataDirPath(applicationContext), "cache");
        }
        return cacheDir.getPath();
    }

    private static String getDataDirPath(Context applicationContext) {
        if (Build.VERSION.SDK_INT >= 24) {
            return applicationContext.getDataDir().getPath();
        }
        return applicationContext.getApplicationInfo().dataDir;
    }
}

