/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.platform;

import android.annotation.TargetApi;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import io.flutter.Log;
import io.flutter.plugin.platform.PlatformViewRenderTarget;
import io.flutter.view.TextureRegistry;

@TargetApi(value=29)
public class ImageReaderPlatformViewRenderTarget
implements PlatformViewRenderTarget {
    private TextureRegistry.ImageTextureEntry textureEntry;
    private ImageReader reader;
    private int bufferWidth = 0;
    private int bufferHeight = 0;
    private static final String TAG = "ImageReaderPlatformViewRenderTarget";
    private static final int MAX_IMAGES = 4;
    private final Handler onImageAvailableHandler = new Handler();
    private final ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Image image = null;
            try {
                image = reader.acquireLatestImage();
            }
            catch (IllegalStateException e) {
                Log.e(ImageReaderPlatformViewRenderTarget.TAG, "onImageAvailable acquireLatestImage failed: " + e.toString());
            }
            if (image == null) {
                return;
            }
            ImageReaderPlatformViewRenderTarget.this.textureEntry.pushImage(image);
        }
    };

    private void closeReader() {
        if (this.reader != null) {
            this.textureEntry.pushImage(null);
            this.reader.close();
            this.reader = null;
        }
    }

    @TargetApi(value=33)
    protected ImageReader createImageReader33() {
        ImageReader.Builder builder = new ImageReader.Builder(this.bufferWidth, this.bufferHeight);
        builder.setMaxImages(4);
        builder.setImageFormat(34);
        builder.setUsage(256L);
        ImageReader reader = builder.build();
        reader.setOnImageAvailableListener(this.onImageAvailableListener, this.onImageAvailableHandler);
        return reader;
    }

    @TargetApi(value=29)
    protected ImageReader createImageReader29() {
        ImageReader reader = ImageReader.newInstance((int)this.bufferWidth, (int)this.bufferHeight, (int)34, (int)4, (long)256L);
        reader.setOnImageAvailableListener(this.onImageAvailableListener, this.onImageAvailableHandler);
        return reader;
    }

    protected ImageReader createImageReader() {
        if (Build.VERSION.SDK_INT >= 33) {
            return this.createImageReader33();
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return this.createImageReader29();
        }
        throw new UnsupportedOperationException("ImageReaderPlatformViewRenderTarget requires API version 29+");
    }

    public ImageReaderPlatformViewRenderTarget(TextureRegistry.ImageTextureEntry textureEntry) {
        if (Build.VERSION.SDK_INT < 29) {
            throw new UnsupportedOperationException("ImageReaderPlatformViewRenderTarget requires API version 29+");
        }
        this.textureEntry = textureEntry;
    }

    @Override
    public void resize(int width, int height) {
        if (this.reader != null && this.bufferWidth == width && this.bufferHeight == height) {
            return;
        }
        this.closeReader();
        this.bufferWidth = width;
        this.bufferHeight = height;
        this.reader = this.createImageReader();
    }

    @Override
    public int getWidth() {
        return this.bufferWidth;
    }

    @Override
    public int getHeight() {
        return this.bufferHeight;
    }

    @Override
    public long getId() {
        return this.textureEntry.id();
    }

    @Override
    public void release() {
        this.closeReader();
        this.textureEntry = null;
    }

    @Override
    public boolean isReleased() {
        return this.textureEntry == null;
    }

    @Override
    public Surface getSurface() {
        return this.reader.getSurface();
    }
}

