// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'Y'.
class PartY {
  /// Applies the Yaldevi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yaldevi
  static TextStyle yaldevi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '01d784070789652eba80646aae811ab4e91be2285acc590b6e4e11389383407c',
        265716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ab427c9fad89f47afd6f17f1bad129750fbfbe5037c1f3a3dcab27ca9ca531ae',
        266340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '911a8d73d5596b0867f83aba4b4e0b8b41282c700583451a742644cda469d864',
        266552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c03eadee56f99b14ef0207bd52b5eb43d59bc4ba61edc8e1bc8803569d3d6d64',
        266668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf668a0ffb6a6ad07d20b65b94848d6495a27738c8c35edece2ec7bf8952d369',
        266816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fafafaf3f6901d980a8820ae9c0915a2278a7a7d63b6028b0eff748800e8475f',
        266040,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yaldevi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yaldevi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yaldevi
  static TextTheme yaldeviTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yaldevi(textStyle: textTheme.displayLarge),
      displayMedium: yaldevi(textStyle: textTheme.displayMedium),
      displaySmall: yaldevi(textStyle: textTheme.displaySmall),
      headlineLarge: yaldevi(textStyle: textTheme.headlineLarge),
      headlineMedium: yaldevi(textStyle: textTheme.headlineMedium),
      headlineSmall: yaldevi(textStyle: textTheme.headlineSmall),
      titleLarge: yaldevi(textStyle: textTheme.titleLarge),
      titleMedium: yaldevi(textStyle: textTheme.titleMedium),
      titleSmall: yaldevi(textStyle: textTheme.titleSmall),
      bodyLarge: yaldevi(textStyle: textTheme.bodyLarge),
      bodyMedium: yaldevi(textStyle: textTheme.bodyMedium),
      bodySmall: yaldevi(textStyle: textTheme.bodySmall),
      labelLarge: yaldevi(textStyle: textTheme.labelLarge),
      labelMedium: yaldevi(textStyle: textTheme.labelMedium),
      labelSmall: yaldevi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yanone Kaffeesatz font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yanone+Kaffeesatz
  static TextStyle yanoneKaffeesatz({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '138b09005dce30c6be14bc7e5e878dd0db8bed8102e3a3fabc70af181ca30511',
        75068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd62aa668c6a3fdba74c3ae3b02e1dc59fc34a969c75c1facdec2fe19e655a3ea',
        75496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbe943ed0767065f53bd0d3b7dfa8c65dc76871b5f2931d2662cd147bf7f1a1c',
        75524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f976aa93a2ebff18e31f1d62ad3174747e67e53e16e882a402470d70d11561d',
        75548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e646ae68164782bf796531aa365d8c98c10be4d0aea18d755e3d45bee5f4152',
        75460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '160021b4160fac99e97e4227d4299e26caabc68fb2ffea58a01f693e0c8191f9',
        75328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YanoneKaffeesatz',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yanone Kaffeesatz font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yanone+Kaffeesatz
  static TextTheme yanoneKaffeesatzTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yanoneKaffeesatz(textStyle: textTheme.displayLarge),
      displayMedium: yanoneKaffeesatz(textStyle: textTheme.displayMedium),
      displaySmall: yanoneKaffeesatz(textStyle: textTheme.displaySmall),
      headlineLarge: yanoneKaffeesatz(textStyle: textTheme.headlineLarge),
      headlineMedium: yanoneKaffeesatz(textStyle: textTheme.headlineMedium),
      headlineSmall: yanoneKaffeesatz(textStyle: textTheme.headlineSmall),
      titleLarge: yanoneKaffeesatz(textStyle: textTheme.titleLarge),
      titleMedium: yanoneKaffeesatz(textStyle: textTheme.titleMedium),
      titleSmall: yanoneKaffeesatz(textStyle: textTheme.titleSmall),
      bodyLarge: yanoneKaffeesatz(textStyle: textTheme.bodyLarge),
      bodyMedium: yanoneKaffeesatz(textStyle: textTheme.bodyMedium),
      bodySmall: yanoneKaffeesatz(textStyle: textTheme.bodySmall),
      labelLarge: yanoneKaffeesatz(textStyle: textTheme.labelLarge),
      labelMedium: yanoneKaffeesatz(textStyle: textTheme.labelMedium),
      labelSmall: yanoneKaffeesatz(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yantramanav font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yantramanav
  static TextStyle yantramanav({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f8f821f9254c1ee4ecea7437fd67cd27c149b11d8296aeacbdffbf992c2998e',
        100516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '75b590ebf7b02489e059eafe9ffe1c9cde5b4a431947359d83cf562e3342e6c9',
        98840,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba40b6246a83ce74fb3bf05b7ee892ea531feb9f4e869fb3c2c759976cf8b852',
        98748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc240eb9595734f0b1047c9d10dc728797e54173912cbf4098848d2dcbedff2f',
        97680,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42cb4a2a758648f5405d8cfbd8821a04704a37d0ad5c86201cf5ca1055aaa4d6',
        98144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc57c0cf68b6eaa6d0676269df4aade8e22c06f6085520d608b197dfdbf3834e',
        97960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yantramanav',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yantramanav font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yantramanav
  static TextTheme yantramanavTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yantramanav(textStyle: textTheme.displayLarge),
      displayMedium: yantramanav(textStyle: textTheme.displayMedium),
      displaySmall: yantramanav(textStyle: textTheme.displaySmall),
      headlineLarge: yantramanav(textStyle: textTheme.headlineLarge),
      headlineMedium: yantramanav(textStyle: textTheme.headlineMedium),
      headlineSmall: yantramanav(textStyle: textTheme.headlineSmall),
      titleLarge: yantramanav(textStyle: textTheme.titleLarge),
      titleMedium: yantramanav(textStyle: textTheme.titleMedium),
      titleSmall: yantramanav(textStyle: textTheme.titleSmall),
      bodyLarge: yantramanav(textStyle: textTheme.bodyLarge),
      bodyMedium: yantramanav(textStyle: textTheme.bodyMedium),
      bodySmall: yantramanav(textStyle: textTheme.bodySmall),
      labelLarge: yantramanav(textStyle: textTheme.labelLarge),
      labelMedium: yantramanav(textStyle: textTheme.labelMedium),
      labelSmall: yantramanav(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yatra One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yatra+One
  static TextStyle yatraOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1186b7bd1945106e35a4ce4e71402db39e66d631aa1ac349ea3d94f36443d7ae',
        195904,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YatraOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yatra One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yatra+One
  static TextTheme yatraOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yatraOne(textStyle: textTheme.displayLarge),
      displayMedium: yatraOne(textStyle: textTheme.displayMedium),
      displaySmall: yatraOne(textStyle: textTheme.displaySmall),
      headlineLarge: yatraOne(textStyle: textTheme.headlineLarge),
      headlineMedium: yatraOne(textStyle: textTheme.headlineMedium),
      headlineSmall: yatraOne(textStyle: textTheme.headlineSmall),
      titleLarge: yatraOne(textStyle: textTheme.titleLarge),
      titleMedium: yatraOne(textStyle: textTheme.titleMedium),
      titleSmall: yatraOne(textStyle: textTheme.titleSmall),
      bodyLarge: yatraOne(textStyle: textTheme.bodyLarge),
      bodyMedium: yatraOne(textStyle: textTheme.bodyMedium),
      bodySmall: yatraOne(textStyle: textTheme.bodySmall),
      labelLarge: yatraOne(textStyle: textTheme.labelLarge),
      labelMedium: yatraOne(textStyle: textTheme.labelMedium),
      labelSmall: yatraOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yellowtail font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yellowtail
  static TextStyle yellowtail({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae2bea559dbbd682ec8df15b94994a2407f9ddcb4cc88312a8c8a4cadf2cb665',
        60864,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yellowtail',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yellowtail font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yellowtail
  static TextTheme yellowtailTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yellowtail(textStyle: textTheme.displayLarge),
      displayMedium: yellowtail(textStyle: textTheme.displayMedium),
      displaySmall: yellowtail(textStyle: textTheme.displaySmall),
      headlineLarge: yellowtail(textStyle: textTheme.headlineLarge),
      headlineMedium: yellowtail(textStyle: textTheme.headlineMedium),
      headlineSmall: yellowtail(textStyle: textTheme.headlineSmall),
      titleLarge: yellowtail(textStyle: textTheme.titleLarge),
      titleMedium: yellowtail(textStyle: textTheme.titleMedium),
      titleSmall: yellowtail(textStyle: textTheme.titleSmall),
      bodyLarge: yellowtail(textStyle: textTheme.bodyLarge),
      bodyMedium: yellowtail(textStyle: textTheme.bodyMedium),
      bodySmall: yellowtail(textStyle: textTheme.bodySmall),
      labelLarge: yellowtail(textStyle: textTheme.labelLarge),
      labelMedium: yellowtail(textStyle: textTheme.labelMedium),
      labelSmall: yellowtail(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yeon Sung font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeon+Sung
  static TextStyle yeonSung({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2df96f5b33472f315b4b95c979fbc86e16cf6cb3be06d844568b067525f83c3c',
        1698764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YeonSung',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yeon Sung font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeon+Sung
  static TextTheme yeonSungTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yeonSung(textStyle: textTheme.displayLarge),
      displayMedium: yeonSung(textStyle: textTheme.displayMedium),
      displaySmall: yeonSung(textStyle: textTheme.displaySmall),
      headlineLarge: yeonSung(textStyle: textTheme.headlineLarge),
      headlineMedium: yeonSung(textStyle: textTheme.headlineMedium),
      headlineSmall: yeonSung(textStyle: textTheme.headlineSmall),
      titleLarge: yeonSung(textStyle: textTheme.titleLarge),
      titleMedium: yeonSung(textStyle: textTheme.titleMedium),
      titleSmall: yeonSung(textStyle: textTheme.titleSmall),
      bodyLarge: yeonSung(textStyle: textTheme.bodyLarge),
      bodyMedium: yeonSung(textStyle: textTheme.bodyMedium),
      bodySmall: yeonSung(textStyle: textTheme.bodySmall),
      labelLarge: yeonSung(textStyle: textTheme.labelLarge),
      labelMedium: yeonSung(textStyle: textTheme.labelMedium),
      labelSmall: yeonSung(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yeseva One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeseva+One
  static TextStyle yesevaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f40d9b1cef5ab4f5a9e945257e5528a6165674bfd3746fface336197e65d42d',
        70252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YesevaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yeseva One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yeseva+One
  static TextTheme yesevaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yesevaOne(textStyle: textTheme.displayLarge),
      displayMedium: yesevaOne(textStyle: textTheme.displayMedium),
      displaySmall: yesevaOne(textStyle: textTheme.displaySmall),
      headlineLarge: yesevaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: yesevaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: yesevaOne(textStyle: textTheme.headlineSmall),
      titleLarge: yesevaOne(textStyle: textTheme.titleLarge),
      titleMedium: yesevaOne(textStyle: textTheme.titleMedium),
      titleSmall: yesevaOne(textStyle: textTheme.titleSmall),
      bodyLarge: yesevaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: yesevaOne(textStyle: textTheme.bodyMedium),
      bodySmall: yesevaOne(textStyle: textTheme.bodySmall),
      labelLarge: yesevaOne(textStyle: textTheme.labelLarge),
      labelMedium: yesevaOne(textStyle: textTheme.labelMedium),
      labelSmall: yesevaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yesteryear font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yesteryear
  static TextStyle yesteryear({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e598b4311acf938fde3d479d9331d911d3edbf7b025d4c3db27d8bff2277e96c',
        60736,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yesteryear',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yesteryear font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yesteryear
  static TextTheme yesteryearTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yesteryear(textStyle: textTheme.displayLarge),
      displayMedium: yesteryear(textStyle: textTheme.displayMedium),
      displaySmall: yesteryear(textStyle: textTheme.displaySmall),
      headlineLarge: yesteryear(textStyle: textTheme.headlineLarge),
      headlineMedium: yesteryear(textStyle: textTheme.headlineMedium),
      headlineSmall: yesteryear(textStyle: textTheme.headlineSmall),
      titleLarge: yesteryear(textStyle: textTheme.titleLarge),
      titleMedium: yesteryear(textStyle: textTheme.titleMedium),
      titleSmall: yesteryear(textStyle: textTheme.titleSmall),
      bodyLarge: yesteryear(textStyle: textTheme.bodyLarge),
      bodyMedium: yesteryear(textStyle: textTheme.bodyMedium),
      bodySmall: yesteryear(textStyle: textTheme.bodySmall),
      labelLarge: yesteryear(textStyle: textTheme.labelLarge),
      labelMedium: yesteryear(textStyle: textTheme.labelMedium),
      labelSmall: yesteryear(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yomogi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yomogi
  static TextStyle yomogi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '248551e8412573c3ba73d74b62f10b4691668fe2f37351f99d7d85eb6be1532a',
        4033948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yomogi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yomogi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yomogi
  static TextTheme yomogiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yomogi(textStyle: textTheme.displayLarge),
      displayMedium: yomogi(textStyle: textTheme.displayMedium),
      displaySmall: yomogi(textStyle: textTheme.displaySmall),
      headlineLarge: yomogi(textStyle: textTheme.headlineLarge),
      headlineMedium: yomogi(textStyle: textTheme.headlineMedium),
      headlineSmall: yomogi(textStyle: textTheme.headlineSmall),
      titleLarge: yomogi(textStyle: textTheme.titleLarge),
      titleMedium: yomogi(textStyle: textTheme.titleMedium),
      titleSmall: yomogi(textStyle: textTheme.titleSmall),
      bodyLarge: yomogi(textStyle: textTheme.bodyLarge),
      bodyMedium: yomogi(textStyle: textTheme.bodyMedium),
      bodySmall: yomogi(textStyle: textTheme.bodySmall),
      labelLarge: yomogi(textStyle: textTheme.labelLarge),
      labelMedium: yomogi(textStyle: textTheme.labelMedium),
      labelSmall: yomogi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Young Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Young+Serif
  static TextStyle youngSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '027dca61a80cb0a8f1263d0f19d9cf0d4e972a9755bcdfc454f38f18c5d71bc1',
        75440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YoungSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Young Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Young+Serif
  static TextTheme youngSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: youngSerif(textStyle: textTheme.displayLarge),
      displayMedium: youngSerif(textStyle: textTheme.displayMedium),
      displaySmall: youngSerif(textStyle: textTheme.displaySmall),
      headlineLarge: youngSerif(textStyle: textTheme.headlineLarge),
      headlineMedium: youngSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: youngSerif(textStyle: textTheme.headlineSmall),
      titleLarge: youngSerif(textStyle: textTheme.titleLarge),
      titleMedium: youngSerif(textStyle: textTheme.titleMedium),
      titleSmall: youngSerif(textStyle: textTheme.titleSmall),
      bodyLarge: youngSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: youngSerif(textStyle: textTheme.bodyMedium),
      bodySmall: youngSerif(textStyle: textTheme.bodySmall),
      labelLarge: youngSerif(textStyle: textTheme.labelLarge),
      labelMedium: youngSerif(textStyle: textTheme.labelMedium),
      labelSmall: youngSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yrsa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yrsa
  static TextStyle yrsa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a38ee67425620355a3aebcaeb06b763249a78c34d2239bb3e98437025c620f5f',
        114724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4093a43a011befc898beb6eb48b4543de39a5ee7a13bac0840246be2f2db2434',
        114980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e351dc4b7449c4acfe6c0eeb242198682c38b66e54453bc17df1cc5f646eea55',
        115032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '284884fe11d549aaa04dd224332a79aa9a3923f022620f59a84315888a1efa6d',
        115120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '190934276fcb1e8782c619708b577a330d310a5d4a2759be92d9df6fbf82794c',
        114424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6a82287a8181a39ac9d7a225c90c8c00ca733baeca1e4d96b9e9623d21a0ef97',
        148544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dd306532549a3e66009d1c94ab81a7a776328e8e20a6e86b0b8a628ddb87f279',
        148460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11e022d3ce90023e4e151faf00b8e4bbcaa691cd9639efaade983a72937cad33',
        148536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cd90fd330610600c92ed43da5c35c3437c5a7272abf0d4c8d3d0a982c1b24bf4',
        148660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15ee1b646387e54475ae131d9fe26251e55bc64002d8efc49cf88c3806295c5f',
        147788,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Yrsa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yrsa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yrsa
  static TextTheme yrsaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yrsa(textStyle: textTheme.displayLarge),
      displayMedium: yrsa(textStyle: textTheme.displayMedium),
      displaySmall: yrsa(textStyle: textTheme.displaySmall),
      headlineLarge: yrsa(textStyle: textTheme.headlineLarge),
      headlineMedium: yrsa(textStyle: textTheme.headlineMedium),
      headlineSmall: yrsa(textStyle: textTheme.headlineSmall),
      titleLarge: yrsa(textStyle: textTheme.titleLarge),
      titleMedium: yrsa(textStyle: textTheme.titleMedium),
      titleSmall: yrsa(textStyle: textTheme.titleSmall),
      bodyLarge: yrsa(textStyle: textTheme.bodyLarge),
      bodyMedium: yrsa(textStyle: textTheme.bodyMedium),
      bodySmall: yrsa(textStyle: textTheme.bodySmall),
      labelLarge: yrsa(textStyle: textTheme.labelLarge),
      labelMedium: yrsa(textStyle: textTheme.labelMedium),
      labelSmall: yrsa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau
  static TextStyle ysabeau({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e64c43a43b263c7978b4b8b08f154d09b9f97980c035ef027d86fd3cac2cf87',
        128980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cda9b9ac9325029bcd6e5dfc4e0ad4c7af8693f6b90d1c74d7328601416a1c7f',
        129056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '67350d5807da1123c84a8c1712b556f7a186070a8551eeaddae4e2d8a02b6d1d',
        129032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f5b1a10df31ac3ac55ca2e697524ce3d2c5eb52c7dd9f18a5f967a8a833f04f',
        129112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc5535c1406168b6ad39ae0fdd7c77b3613cdc2f67cf56c3075e1c32bc61834a',
        129028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ab0799f7a575285fd93c7b4e02131a932de64143875f02cccbe86725b1a0853',
        129436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4453fd4fa0813f9219392a181fdd13e9dd2bcce33ebe09f89f5a133004f34612',
        129128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a950782febf1884b9ad9380ffb0c6a243ba430c110cc9fd36b4519cd1791a704',
        130040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f34e6b0e28a1f319edff473d6157bc013232169b4b2f7f9e84c3765607bf1cd',
        130796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b0bc30e5f5fd42987b9868e68546c2f98c5c18c7580c04201756e1f03610217c',
        137328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'baa2f2b34774396ad60968ffb8a45a307999fd01ba660893bfccf6b0ec251e18',
        137580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fdf0f8fc1d7d45ead4e96ef3a416a049b2c60da227fd25ec168d8d8df9255ead',
        137400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6aa02d97a0735abb27ceb20b5d3561f5d5e4e67beebfc7c89c82d794fd8e5830',
        137332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '40f49101a4308b1b20e2c6616a3a853f4282dea59a92f9bb31490ffce5aa2caf',
        137532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c7e53c14fdc103f9581ab0acccc9b02e7b11ca90551eba75aada8e1714975f05',
        137728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3aba978244fab8edfcce0624d9e097cebf723f1839f57de9ed80f6da54e1bd92',
        137480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dad8e9f7ebfa13abb6d33efe6e39f66d4c2ec89ec5d00ec0b4dbb0d7b046827a',
        138504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '594b37683b91d6d1844704937bdb0e0760ac118cfb920bbb9d1e7014ead5ef8e',
        138724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ysabeau',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau
  static TextTheme ysabeauTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeau(textStyle: textTheme.displayLarge),
      displayMedium: ysabeau(textStyle: textTheme.displayMedium),
      displaySmall: ysabeau(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeau(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeau(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeau(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeau(textStyle: textTheme.titleLarge),
      titleMedium: ysabeau(textStyle: textTheme.titleMedium),
      titleSmall: ysabeau(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeau(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeau(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeau(textStyle: textTheme.bodySmall),
      labelLarge: ysabeau(textStyle: textTheme.labelLarge),
      labelMedium: ysabeau(textStyle: textTheme.labelMedium),
      labelSmall: ysabeau(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau Infant font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Infant
  static TextStyle ysabeauInfant({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b8511a2ede2359e195763cec7047e5c36c81034219dd332957835460fcf793d',
        122972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f1047cf0759f93f261e81883ef61a55435c81d72dd2d5ec3571b19f2d2f06087',
        123020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38f511dcf34ba1d77d1f2f6d064bd951a77901e1056f9db7fe49b1412e984c36',
        123000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f3e93f79e7869dc14bf4d9d04ae663940db6e2acd31902aed1ec0086700b291',
        123112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de44d5ae02cbf6aedd8685ca659c674e2607663edd5a8986aef9b8a2006adb80',
        123148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '71d78c9b8da038ec51485682aae3a075fdf100fcb874ac424d7e3a081cf06031',
        123116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c749410d1af7e8cb5ff2481b3544250736a3da4860f2374eab522d0172698c3',
        122856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cea747228fecc835dd2ad0d6232805fb6c283346634eee3a59447ac2ba89b33a',
        123396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a4bf45b911d43032d2ff9fce18afa1d170fc0046ca45a29b2024950159bf31e',
        123484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c0445d3cfa7d7852e675746c29ba91798c07b66adb948f6ee56d171f1830f295',
        129628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f194a10ecf9bbcee58ce9677eb63a1090c7bcccd09923c8a7be26ebaae1ec166',
        129844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6c03b02e067305076a2125a3431d6261f2f62a80c826cbe8aee21932b9a70432',
        129640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05748cb2b2bbbf366420e72e948f9a586e699cf28df1240d1f0258dffccbfc8e',
        129572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '96858ff1cccdb7d3d6dfbddcbccc209bd820df84645dba14b90a82c79189e96c',
        129780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a63b762ea643deb1e90f5e5a53322b08d0258110e15318b491d3680d6ce41d99',
        129648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f2694b3e96bb284df902d2d3b04ce9a4f35b96e228157915f1ef8343914a6a5b',
        129412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5981a0546dec0f84da87f20f22411b6f9fd68a905c3b76022f872e7d4e4a9895',
        129872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4230feb4b860a84ac265d2f0e3db22683920995b572815267abe91187a6a3f4f',
        129784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YsabeauInfant',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau Infant font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Infant
  static TextTheme ysabeauInfantTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeauInfant(textStyle: textTheme.displayLarge),
      displayMedium: ysabeauInfant(textStyle: textTheme.displayMedium),
      displaySmall: ysabeauInfant(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeauInfant(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeauInfant(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeauInfant(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeauInfant(textStyle: textTheme.titleLarge),
      titleMedium: ysabeauInfant(textStyle: textTheme.titleMedium),
      titleSmall: ysabeauInfant(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeauInfant(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeauInfant(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeauInfant(textStyle: textTheme.bodySmall),
      labelLarge: ysabeauInfant(textStyle: textTheme.labelLarge),
      labelMedium: ysabeauInfant(textStyle: textTheme.labelMedium),
      labelSmall: ysabeauInfant(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau Office font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Office
  static TextStyle ysabeauOffice({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dae35c77ebdcfcf0d7f57027dbf5832916e23141a875b5645ae4abfc39ec2f1c',
        123392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '985dd5604f373a6e7888f83a7844722285f2d8825cc39242393c1a5266173661',
        123464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6c651a2ce9054a8930890bd44d24fc4869adfcd2fe8d183e52e88b4d991e68b',
        123444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10dd311b8c22bb146d64605510d189bf684f38d79e4e9248effbd246ff982a09',
        123524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0444cffb10463cfed2a2110381c69d3c0bf762f03e520e4c6bb6902df2a31dfd',
        123452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de6f61fc34f9e8b8182078cbdd97210ddf55f416faaa58c62a40f9fcbd50b19f',
        123544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b16405dd4fac4a6e7dc202ca1fc2e0fc77637582b2d6b20e5cc6aeea4f220af8',
        123244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b6b61fb2142636e25f284ed4e91092c8fe40902500b78643f3a3c6c1755f74e',
        123748,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00b618ea39dcc441276737fa78d22ebeba3f2aa9b9635b154325b209c7741330',
        123856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '34e9d5a26ff2eb1b21b0380f940c83f5be9e3eccdc915c8556e93d0129c1e08b',
        130468,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd0b847df10912423a7c2100fe146316c955648390a6b1d09e42734d240a07128',
        130704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c56b2d350d273f318e55a84bb819cb8c8112bc6a25dec3faef467388067d5c50',
        130492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2551fcd72b244249c349edd42a072e3aaf80c4479c138ad348b4061da342274f',
        130432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6a8eaacbf7c9d1b6c10d7d72f7ca337e3fb07f507a1bfc3d2ff3f08bfb15ea80',
        130640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cacdb8b2728bc0115ae6dffb35e34b584b82b1c2870723dec38596b78985bfb2',
        130496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cd7fedfe5a2d77163ecc0f2317fb444acdcccdf6f7b76263f584e0bb162b371d',
        130248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a3f15fca59f789d77dc593eec07384b9415a6c514ade8bf3e8f6523f5df7621f',
        130732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6659a5f9328e300be4444ae7e295cd9dd433dbc86f76065e477129da59e248a9',
        130636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YsabeauOffice',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau Office font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+Office
  static TextTheme ysabeauOfficeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeauOffice(textStyle: textTheme.displayLarge),
      displayMedium: ysabeauOffice(textStyle: textTheme.displayMedium),
      displaySmall: ysabeauOffice(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeauOffice(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeauOffice(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeauOffice(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeauOffice(textStyle: textTheme.titleLarge),
      titleMedium: ysabeauOffice(textStyle: textTheme.titleMedium),
      titleSmall: ysabeauOffice(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeauOffice(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeauOffice(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeauOffice(textStyle: textTheme.bodySmall),
      labelLarge: ysabeauOffice(textStyle: textTheme.labelLarge),
      labelMedium: ysabeauOffice(textStyle: textTheme.labelMedium),
      labelSmall: ysabeauOffice(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ysabeau SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+SC
  static TextStyle ysabeauSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b88b237fb42d8d37101f3eafcf648ab055660bb5c1c1b24185457e64752ca992',
        102980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3a40a94634f8c49874f1c23ce369ae7eb68f6910c4f550109b0df4cbdbc9883',
        102988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8338a486c0271b9d252b0b781a49461dbdf7495cc2d5ed6d86be7a40ea5fb8cd',
        102984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e476d1f1dc06b08a8105e9f9a0700c56c7f430f2587a1d15ca8c401b9d1d082a',
        103004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55ccd37381181da2d58cbd75d6443746d6b697ce8389306a30f40351fb39fab1',
        102996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7edc8b8b61322afccbbb8fe8a26b503a436660ca61494bd7c411ccc75c68ef41',
        103000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce19361acd5de44517ff45411017f487aef41ff282b8ef1d459022c265584bb0',
        102900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b298a83d7045d3e11d704595a38fe4e4d0f7fd065cbe4ae92945bb4a1092ae0',
        103104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10540c4208dadb73a27b8222657baaaa11e4587b42bbb70c6f7871124e427747',
        103188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YsabeauSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ysabeau SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ysabeau+SC
  static TextTheme ysabeauScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ysabeauSc(textStyle: textTheme.displayLarge),
      displayMedium: ysabeauSc(textStyle: textTheme.displayMedium),
      displaySmall: ysabeauSc(textStyle: textTheme.displaySmall),
      headlineLarge: ysabeauSc(textStyle: textTheme.headlineLarge),
      headlineMedium: ysabeauSc(textStyle: textTheme.headlineMedium),
      headlineSmall: ysabeauSc(textStyle: textTheme.headlineSmall),
      titleLarge: ysabeauSc(textStyle: textTheme.titleLarge),
      titleMedium: ysabeauSc(textStyle: textTheme.titleMedium),
      titleSmall: ysabeauSc(textStyle: textTheme.titleSmall),
      bodyLarge: ysabeauSc(textStyle: textTheme.bodyLarge),
      bodyMedium: ysabeauSc(textStyle: textTheme.bodyMedium),
      bodySmall: ysabeauSc(textStyle: textTheme.bodySmall),
      labelLarge: ysabeauSc(textStyle: textTheme.labelLarge),
      labelMedium: ysabeauSc(textStyle: textTheme.labelMedium),
      labelSmall: ysabeauSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Boku font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Boku
  static TextStyle yujiBoku({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d03c76f62b49981fee9d4f9b3d186a70ac8613d232a75b7a334bd667ef8f49a',
        7847404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiBoku',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Boku font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Boku
  static TextTheme yujiBokuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiBoku(textStyle: textTheme.displayLarge),
      displayMedium: yujiBoku(textStyle: textTheme.displayMedium),
      displaySmall: yujiBoku(textStyle: textTheme.displaySmall),
      headlineLarge: yujiBoku(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiBoku(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiBoku(textStyle: textTheme.headlineSmall),
      titleLarge: yujiBoku(textStyle: textTheme.titleLarge),
      titleMedium: yujiBoku(textStyle: textTheme.titleMedium),
      titleSmall: yujiBoku(textStyle: textTheme.titleSmall),
      bodyLarge: yujiBoku(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiBoku(textStyle: textTheme.bodyMedium),
      bodySmall: yujiBoku(textStyle: textTheme.bodySmall),
      labelLarge: yujiBoku(textStyle: textTheme.labelLarge),
      labelMedium: yujiBoku(textStyle: textTheme.labelMedium),
      labelSmall: yujiBoku(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Hentaigana Akari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akari
  static TextStyle yujiHentaiganaAkari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8dcdb8f12d0708b4cf45b14a42f9c2e15de0a98783e7a324f6f888abfc4dfc5',
        90668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiHentaiganaAkari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Hentaigana Akari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akari
  static TextTheme yujiHentaiganaAkariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiHentaiganaAkari(textStyle: textTheme.displayLarge),
      displayMedium: yujiHentaiganaAkari(textStyle: textTheme.displayMedium),
      displaySmall: yujiHentaiganaAkari(textStyle: textTheme.displaySmall),
      headlineLarge: yujiHentaiganaAkari(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiHentaiganaAkari(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiHentaiganaAkari(textStyle: textTheme.headlineSmall),
      titleLarge: yujiHentaiganaAkari(textStyle: textTheme.titleLarge),
      titleMedium: yujiHentaiganaAkari(textStyle: textTheme.titleMedium),
      titleSmall: yujiHentaiganaAkari(textStyle: textTheme.titleSmall),
      bodyLarge: yujiHentaiganaAkari(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiHentaiganaAkari(textStyle: textTheme.bodyMedium),
      bodySmall: yujiHentaiganaAkari(textStyle: textTheme.bodySmall),
      labelLarge: yujiHentaiganaAkari(textStyle: textTheme.labelLarge),
      labelMedium: yujiHentaiganaAkari(textStyle: textTheme.labelMedium),
      labelSmall: yujiHentaiganaAkari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Hentaigana Akebono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akebono
  static TextStyle yujiHentaiganaAkebono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6953c8bd49f227d2152f7981ab5a9cc8a860caeac6be190ad87e0b57ff265ecb',
        96272,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiHentaiganaAkebono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Hentaigana Akebono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Hentaigana+Akebono
  static TextTheme yujiHentaiganaAkebonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiHentaiganaAkebono(textStyle: textTheme.displayLarge),
      displayMedium: yujiHentaiganaAkebono(textStyle: textTheme.displayMedium),
      displaySmall: yujiHentaiganaAkebono(textStyle: textTheme.displaySmall),
      headlineLarge: yujiHentaiganaAkebono(textStyle: textTheme.headlineLarge),
      headlineMedium:
          yujiHentaiganaAkebono(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiHentaiganaAkebono(textStyle: textTheme.headlineSmall),
      titleLarge: yujiHentaiganaAkebono(textStyle: textTheme.titleLarge),
      titleMedium: yujiHentaiganaAkebono(textStyle: textTheme.titleMedium),
      titleSmall: yujiHentaiganaAkebono(textStyle: textTheme.titleSmall),
      bodyLarge: yujiHentaiganaAkebono(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiHentaiganaAkebono(textStyle: textTheme.bodyMedium),
      bodySmall: yujiHentaiganaAkebono(textStyle: textTheme.bodySmall),
      labelLarge: yujiHentaiganaAkebono(textStyle: textTheme.labelLarge),
      labelMedium: yujiHentaiganaAkebono(textStyle: textTheme.labelMedium),
      labelSmall: yujiHentaiganaAkebono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Mai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Mai
  static TextStyle yujiMai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6741e6df72abe0287210735f84bb297fb8704e9e44ae1bd53e9366f75215ce8',
        7830152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiMai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Mai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Mai
  static TextTheme yujiMaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiMai(textStyle: textTheme.displayLarge),
      displayMedium: yujiMai(textStyle: textTheme.displayMedium),
      displaySmall: yujiMai(textStyle: textTheme.displaySmall),
      headlineLarge: yujiMai(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiMai(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiMai(textStyle: textTheme.headlineSmall),
      titleLarge: yujiMai(textStyle: textTheme.titleLarge),
      titleMedium: yujiMai(textStyle: textTheme.titleMedium),
      titleSmall: yujiMai(textStyle: textTheme.titleSmall),
      bodyLarge: yujiMai(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiMai(textStyle: textTheme.bodyMedium),
      bodySmall: yujiMai(textStyle: textTheme.bodySmall),
      labelLarge: yujiMai(textStyle: textTheme.labelLarge),
      labelMedium: yujiMai(textStyle: textTheme.labelMedium),
      labelSmall: yujiMai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yuji Syuku font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Syuku
  static TextStyle yujiSyuku({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0647d204ae1a4232cce1a635b3e9503bc9ad48ac3bcaa4114131e2514c49f7e8',
        7779080,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YujiSyuku',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yuji Syuku font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yuji+Syuku
  static TextTheme yujiSyukuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yujiSyuku(textStyle: textTheme.displayLarge),
      displayMedium: yujiSyuku(textStyle: textTheme.displayMedium),
      displaySmall: yujiSyuku(textStyle: textTheme.displaySmall),
      headlineLarge: yujiSyuku(textStyle: textTheme.headlineLarge),
      headlineMedium: yujiSyuku(textStyle: textTheme.headlineMedium),
      headlineSmall: yujiSyuku(textStyle: textTheme.headlineSmall),
      titleLarge: yujiSyuku(textStyle: textTheme.titleLarge),
      titleMedium: yujiSyuku(textStyle: textTheme.titleMedium),
      titleSmall: yujiSyuku(textStyle: textTheme.titleSmall),
      bodyLarge: yujiSyuku(textStyle: textTheme.bodyLarge),
      bodyMedium: yujiSyuku(textStyle: textTheme.bodyMedium),
      bodySmall: yujiSyuku(textStyle: textTheme.bodySmall),
      labelLarge: yujiSyuku(textStyle: textTheme.labelLarge),
      labelMedium: yujiSyuku(textStyle: textTheme.labelMedium),
      labelSmall: yujiSyuku(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Yusei Magic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yusei+Magic
  static TextStyle yuseiMagic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c9386186a8664fa5a6aba964e82e856d0ff81ca2a37c1e30a3cbe9d8d1e6afff',
        3129936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'YuseiMagic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Yusei Magic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Yusei+Magic
  static TextTheme yuseiMagicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: yuseiMagic(textStyle: textTheme.displayLarge),
      displayMedium: yuseiMagic(textStyle: textTheme.displayMedium),
      displaySmall: yuseiMagic(textStyle: textTheme.displaySmall),
      headlineLarge: yuseiMagic(textStyle: textTheme.headlineLarge),
      headlineMedium: yuseiMagic(textStyle: textTheme.headlineMedium),
      headlineSmall: yuseiMagic(textStyle: textTheme.headlineSmall),
      titleLarge: yuseiMagic(textStyle: textTheme.titleLarge),
      titleMedium: yuseiMagic(textStyle: textTheme.titleMedium),
      titleSmall: yuseiMagic(textStyle: textTheme.titleSmall),
      bodyLarge: yuseiMagic(textStyle: textTheme.bodyLarge),
      bodyMedium: yuseiMagic(textStyle: textTheme.bodyMedium),
      bodySmall: yuseiMagic(textStyle: textTheme.bodySmall),
      labelLarge: yuseiMagic(textStyle: textTheme.labelLarge),
      labelMedium: yuseiMagic(textStyle: textTheme.labelMedium),
      labelSmall: yuseiMagic(textStyle: textTheme.labelSmall),
    );
  }
}
