// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Replaces deprecated language subtags.
///
/// The subtag must already be lowercase.
///
/// TODO(b/127689510): write a new script for updating this list from CLDR data.
String replaceDeprecatedLanguageSubtag(String languageCode) {
  return _deprecatedLanguageTagReplacements[languageCode] ?? languageCode;
}

const Map<String, String> _deprecatedLanguageTagReplacements = {
  // These map entries are generated by a modified version of Flutter's
  // gen_locale.dart. TODO(hugovdm): make improvements to the tool.
  //
  // Mappings generated for language subtag registry as of 2019-02-20.
  'in': 'id', // Indonesian; deprecated 1989-01-01
  'iw': 'he', // Hebrew; deprecated 1989-01-01
  'ji': 'yi', // Yiddish; deprecated 1989-01-01
  'jw': 'jv', // Javanese; deprecated 2001-08-13
  'mo': 'ro', // Moldavian, Moldovan; deprecated 2008-11-22
  'aam': 'aas', // Aramanik; deprecated 2015-02-12
  'adp': 'dz', // Adap; deprecated 2015-02-12
  'aue': 'ktz', // ǂKxʼauǁʼein; deprecated 2015-02-12
  'ayx': 'nun', // Ayi (China); deprecated 2011-08-16
  'bgm': 'bcg', // Baga Mboteni; deprecated 2016-05-30
  'bjd': 'drl', // Bandjigali; deprecated 2012-08-12
  'ccq': 'rki', // Chaungtha; deprecated 2012-08-12
  'cjr': 'mom', // Chorotega; deprecated 2010-03-11
  'cka': 'cmr', // Khumi Awa Chin; deprecated 2012-08-12
  'cmk': 'xch', // Chimakum; deprecated 2010-03-11
  'coy': 'pij', // Coyaima; deprecated 2016-05-30
  'cqu': 'quh', // Chilean Quechua; deprecated 2016-05-30
  'drh': 'khk', // Darkhat; deprecated 2010-03-11
  'drw': 'prs', // Darwazi; deprecated 2010-03-11
  'gav': 'dev', // Gabutamon; deprecated 2010-03-11
  'gfx': 'vaj', // Mangetti Dune ǃXung; deprecated 2015-02-12
  'ggn': 'gvr', // Eastern Gurung; deprecated 2016-05-30
  'gti': 'nyc', // Gbati-ri; deprecated 2015-02-12
  'guv': 'duz', // Gey; deprecated 2016-05-30
  'hrr': 'jal', // Horuru; deprecated 2012-08-12
  'ibi': 'opa', // Ibilo; deprecated 2012-08-12
  'ilw': 'gal', // Talur; deprecated 2013-09-10
  'jeg': 'oyb', // Jeng; deprecated 2017-02-23
  'kgc': 'tdf', // Kasseng; deprecated 2016-05-30
  'kgh': 'kml', // Upper Tanudan Kalinga; deprecated 2012-08-12
  'koj': 'kwv', // Sara Dunjo; deprecated 2015-02-12
  'krm': 'bmf', // Krim; deprecated 2017-02-23
  'ktr': 'dtp', // Kota Marudu Tinagas; deprecated 2016-05-30
  'kvs': 'gdj', // Kunggara; deprecated 2016-05-30
  'kwq': 'yam', // Kwak; deprecated 2015-02-12
  'kxe': 'tvd', // Kakihum; deprecated 2015-02-12
  'kzj': 'dtp', // Coastal Kadazan; deprecated 2016-05-30
  'kzt': 'dtp', // Tambunan Dusun; deprecated 2016-05-30
  'lii': 'raq', // Lingkhim; deprecated 2015-02-12
  'lmm': 'rmx', // Lamam; deprecated 2014-02-28
  'meg': 'cir', // Mea; deprecated 2013-09-10
  'mst': 'mry', // Cataelano Mandaya; deprecated 2010-03-11
  'mwj': 'vaj', // Maligo; deprecated 2015-02-12
  'myt': 'mry', // Sangab Mandaya; deprecated 2010-03-11
  'nad': 'xny', // Nijadali; deprecated 2016-05-30
  'ncp': 'kdz', // Ndaktup; deprecated 2018-03-08
  'nnx': 'ngv', // Ngong; deprecated 2015-02-12
  'nts': 'pij', // Natagaimas; deprecated 2016-05-30
  'oun': 'vaj', // ǃOǃung; deprecated 2015-02-12
  'pcr': 'adx', // Panang; deprecated 2013-09-10
  'pmc': 'huw', // Palumata; deprecated 2016-05-30
  'pmu': 'phr', // Mirpur Panjabi; deprecated 2015-02-12
  'ppa': 'bfy', // Pao; deprecated 2016-05-30
  'ppr': 'lcq', // Piru; deprecated 2013-09-10
  'pry': 'prt', // Pray 3; deprecated 2016-05-30
  'puz': 'pub', // Purum Naga; deprecated 2014-02-28
  'sca': 'hle', // Sansu; deprecated 2012-08-12
  'skk': 'oyb', // Sok; deprecated 2017-02-23
  'tdu': 'dtp', // Tempasuk Dusun; deprecated 2016-05-30
  'thc': 'tpo', // Tai Hang Tong; deprecated 2016-05-30
  'thx': 'oyb', // The; deprecated 2015-02-12
  'tie': 'ras', // Tingal; deprecated 2011-08-16
  'tkk': 'twm', // Takpa; deprecated 2011-08-16
  'tlw': 'weo', // South Wemale; deprecated 2012-08-12
  'tmp': 'tyj', // Tai Mène; deprecated 2016-05-30
  'tne': 'kak', // Tinoc Kallahan; deprecated 2016-05-30
  'tnf': 'prs', // Tangshewi; deprecated 2010-03-11
  'tsf': 'taj', // Southwestern Tamang; deprecated 2015-02-12
  'uok': 'ema', // Uokha; deprecated 2015-02-12
  'xba': 'cax', // Kamba (Brazil); deprecated 2016-05-30
  'xia': 'acn', // Xiandao; deprecated 2013-09-10
  'xkh': 'waw', // Karahawyana; deprecated 2016-05-30
  'xsj': 'suj', // Subi; deprecated 2015-02-12
  'ybd': 'rki', // Yangbye; deprecated 2012-08-12
  'yma': 'lrr', // Yamphe; deprecated 2012-08-12
  'ymt': 'mtm', // Mator-Taygi-Karagas; deprecated 2015-02-12
  'yos': 'zom', // Yos; deprecated 2013-09-10
  'yuu': 'yug', // Yugh; deprecated 2014-02-28
};

/// Replaces deprecated region subtags.
///
/// The subtag must already be uppercase.
///
/// TODO(b/127689510): write a new script for updating this list from CLDR data.
String replaceDeprecatedRegionSubtag(String regionCode) {
  return _deprecatedRegionTagReplacements[regionCode] ?? regionCode;
}

const Map<String, String> _deprecatedRegionTagReplacements = {
  // These map entries are generated by a modified version of Flutter's
  // gen_locale.dart. TODO(hugovdm): make improvements to the tool.
  //
  // Mappings generated for language subtag registry as of 2019-02-20.
  'BU': 'MM', // Burma; deprecated 1989-12-05
  'DD': 'DE', // German Democratic Republic; deprecated 1990-10-30
  'FX': 'FR', // Metropolitan France; deprecated 1997-07-14
  'TP': 'TL', // East Timor; deprecated 2002-05-20
  'YD': 'YE', // Democratic Yemen; deprecated 1990-08-14
  'ZR': 'CD', // Zaire; deprecated 1997-07-14
};
