// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v11.0.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, unnecessary_import
// ignore_for_file: avoid_relative_lib_imports
import 'dart:async';
import 'dart:typed_data' show Float64List, Int32List, Int64List, Uint8List;
import 'package:flutter/foundation.dart' show ReadBuffer, WriteBuffer;
import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';

import 'package:webview_flutter_android/src/android_webview.g.dart';

/// Host API for managing the native `InstanceManager`.
abstract class TestInstanceManagerHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  /// Clear the native `InstanceManager`.
  ///
  /// This is typically only used after a hot restart.
  void clear();

  static void setup(TestInstanceManagerHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.InstanceManagerHostApi.clear',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          // ignore message
          api.clear();
          return <Object?>[];
        });
      }
    }
  }
}

/// Handles methods calls to the native Java Object class.
///
/// Also handles calls to remove the reference to an instance with `dispose`.
///
/// See https://docs.oracle.com/javase/7/docs/api/java/lang/Object.html.
abstract class TestJavaObjectHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void dispose(int identifier);

  static void setup(TestJavaObjectHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.JavaObjectHostApi.dispose',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.JavaObjectHostApi.dispose was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(arg_identifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.JavaObjectHostApi.dispose was null, expected non-null int.');
          api.dispose(arg_identifier!);
          return <Object?>[];
        });
      }
    }
  }
}

/// Host API for `CookieManager`.
///
/// This class may handle instantiating and adding native object instances that
/// are attached to a Dart instance or handle method calls on the associated
/// native class or an instance of the class.
abstract class TestCookieManagerHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  /// Handles attaching `CookieManager.instance` to a native instance.
  void attachInstance(int instanceIdentifier);

  /// Handles Dart method `CookieManager.setCookie`.
  void setCookie(int identifier, String url, String value);

  /// Handles Dart method `CookieManager.removeAllCookies`.
  Future<bool> removeAllCookies(int identifier);

  /// Handles Dart method `CookieManager.setAcceptThirdPartyCookies`.
  void setAcceptThirdPartyCookies(
      int identifier, int webViewIdentifier, bool accept);

  static void setup(TestCookieManagerHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.attachInstance',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.attachInstance was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceIdentifier = (args[0] as int?);
          assert(arg_instanceIdentifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.attachInstance was null, expected non-null int.');
          api.attachInstance(arg_instanceIdentifier!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setCookie',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setCookie was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(arg_identifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setCookie was null, expected non-null int.');
          final String? arg_url = (args[1] as String?);
          assert(arg_url != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setCookie was null, expected non-null String.');
          final String? arg_value = (args[2] as String?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setCookie was null, expected non-null String.');
          api.setCookie(arg_identifier!, arg_url!, arg_value!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.removeAllCookies',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.removeAllCookies was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(arg_identifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.removeAllCookies was null, expected non-null int.');
          final bool output = await api.removeAllCookies(arg_identifier!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setAcceptThirdPartyCookies',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setAcceptThirdPartyCookies was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(arg_identifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setAcceptThirdPartyCookies was null, expected non-null int.');
          final int? arg_webViewIdentifier = (args[1] as int?);
          assert(arg_webViewIdentifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setAcceptThirdPartyCookies was null, expected non-null int.');
          final bool? arg_accept = (args[2] as bool?);
          assert(arg_accept != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CookieManagerHostApi.setAcceptThirdPartyCookies was null, expected non-null bool.');
          api.setAcceptThirdPartyCookies(
              arg_identifier!, arg_webViewIdentifier!, arg_accept!);
          return <Object?>[];
        });
      }
    }
  }
}

class _TestWebViewHostApiCodec extends StandardMessageCodec {
  const _TestWebViewHostApiCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is WebViewPoint) {
      buffer.putUint8(128);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 128:
        return WebViewPoint.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

abstract class TestWebViewHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = _TestWebViewHostApiCodec();

  void create(int instanceId);

  void loadData(
      int instanceId, String data, String? mimeType, String? encoding);

  void loadDataWithBaseUrl(int instanceId, String? baseUrl, String data,
      String? mimeType, String? encoding, String? historyUrl);

  void loadUrl(int instanceId, String url, Map<String?, String?> headers);

  void postUrl(int instanceId, String url, Uint8List data);

  String? getUrl(int instanceId);

  bool canGoBack(int instanceId);

  bool canGoForward(int instanceId);

  void goBack(int instanceId);

  void goForward(int instanceId);

  void reload(int instanceId);

  void clearCache(int instanceId, bool includeDiskFiles);

  Future<String?> evaluateJavascript(int instanceId, String javascriptString);

  String? getTitle(int instanceId);

  void scrollTo(int instanceId, int x, int y);

  void scrollBy(int instanceId, int x, int y);

  int getScrollX(int instanceId);

  int getScrollY(int instanceId);

  WebViewPoint getScrollPosition(int instanceId);

  void setWebContentsDebuggingEnabled(bool enabled);

  void setWebViewClient(int instanceId, int webViewClientInstanceId);

  void addJavaScriptChannel(int instanceId, int javaScriptChannelInstanceId);

  void removeJavaScriptChannel(int instanceId, int javaScriptChannelInstanceId);

  void setDownloadListener(int instanceId, int? listenerInstanceId);

  void setWebChromeClient(int instanceId, int? clientInstanceId);

  void setBackgroundColor(int instanceId, int color);

  static void setup(TestWebViewHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.create was null, expected non-null int.');
          api.create(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadData',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadData was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadData was null, expected non-null int.');
          final String? arg_data = (args[1] as String?);
          assert(arg_data != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadData was null, expected non-null String.');
          final String? arg_mimeType = (args[2] as String?);
          final String? arg_encoding = (args[3] as String?);
          api.loadData(arg_instanceId!, arg_data!, arg_mimeType, arg_encoding);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadDataWithBaseUrl',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadDataWithBaseUrl was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadDataWithBaseUrl was null, expected non-null int.');
          final String? arg_baseUrl = (args[1] as String?);
          final String? arg_data = (args[2] as String?);
          assert(arg_data != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadDataWithBaseUrl was null, expected non-null String.');
          final String? arg_mimeType = (args[3] as String?);
          final String? arg_encoding = (args[4] as String?);
          final String? arg_historyUrl = (args[5] as String?);
          api.loadDataWithBaseUrl(arg_instanceId!, arg_baseUrl, arg_data!,
              arg_mimeType, arg_encoding, arg_historyUrl);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadUrl',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadUrl was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadUrl was null, expected non-null int.');
          final String? arg_url = (args[1] as String?);
          assert(arg_url != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadUrl was null, expected non-null String.');
          final Map<String?, String?>? arg_headers =
              (args[2] as Map<Object?, Object?>?)?.cast<String?, String?>();
          assert(arg_headers != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.loadUrl was null, expected non-null Map<String?, String?>.');
          api.loadUrl(arg_instanceId!, arg_url!, arg_headers!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.postUrl',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.postUrl was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.postUrl was null, expected non-null int.');
          final String? arg_url = (args[1] as String?);
          assert(arg_url != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.postUrl was null, expected non-null String.');
          final Uint8List? arg_data = (args[2] as Uint8List?);
          assert(arg_data != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.postUrl was null, expected non-null Uint8List.');
          api.postUrl(arg_instanceId!, arg_url!, arg_data!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getUrl',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getUrl was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getUrl was null, expected non-null int.');
          final String? output = api.getUrl(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoBack',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoBack was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoBack was null, expected non-null int.');
          final bool output = api.canGoBack(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoForward',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoForward was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.canGoForward was null, expected non-null int.');
          final bool output = api.canGoForward(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goBack',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goBack was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goBack was null, expected non-null int.');
          api.goBack(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goForward',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goForward was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.goForward was null, expected non-null int.');
          api.goForward(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.reload',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.reload was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.reload was null, expected non-null int.');
          api.reload(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.clearCache',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.clearCache was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.clearCache was null, expected non-null int.');
          final bool? arg_includeDiskFiles = (args[1] as bool?);
          assert(arg_includeDiskFiles != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.clearCache was null, expected non-null bool.');
          api.clearCache(arg_instanceId!, arg_includeDiskFiles!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.evaluateJavascript',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.evaluateJavascript was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.evaluateJavascript was null, expected non-null int.');
          final String? arg_javascriptString = (args[1] as String?);
          assert(arg_javascriptString != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.evaluateJavascript was null, expected non-null String.');
          final String? output = await api.evaluateJavascript(
              arg_instanceId!, arg_javascriptString!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getTitle',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getTitle was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getTitle was null, expected non-null int.');
          final String? output = api.getTitle(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollTo',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollTo was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollTo was null, expected non-null int.');
          final int? arg_x = (args[1] as int?);
          assert(arg_x != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollTo was null, expected non-null int.');
          final int? arg_y = (args[2] as int?);
          assert(arg_y != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollTo was null, expected non-null int.');
          api.scrollTo(arg_instanceId!, arg_x!, arg_y!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollBy',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollBy was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollBy was null, expected non-null int.');
          final int? arg_x = (args[1] as int?);
          assert(arg_x != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollBy was null, expected non-null int.');
          final int? arg_y = (args[2] as int?);
          assert(arg_y != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.scrollBy was null, expected non-null int.');
          api.scrollBy(arg_instanceId!, arg_x!, arg_y!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollX',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollX was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollX was null, expected non-null int.');
          final int output = api.getScrollX(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollY',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollY was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollY was null, expected non-null int.');
          final int output = api.getScrollY(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollPosition',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollPosition was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.getScrollPosition was null, expected non-null int.');
          final WebViewPoint output = api.getScrollPosition(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebContentsDebuggingEnabled',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebContentsDebuggingEnabled was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final bool? arg_enabled = (args[0] as bool?);
          assert(arg_enabled != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebContentsDebuggingEnabled was null, expected non-null bool.');
          api.setWebContentsDebuggingEnabled(arg_enabled!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebViewClient',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebViewClient was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebViewClient was null, expected non-null int.');
          final int? arg_webViewClientInstanceId = (args[1] as int?);
          assert(arg_webViewClientInstanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebViewClient was null, expected non-null int.');
          api.setWebViewClient(arg_instanceId!, arg_webViewClientInstanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.addJavaScriptChannel',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.addJavaScriptChannel was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.addJavaScriptChannel was null, expected non-null int.');
          final int? arg_javaScriptChannelInstanceId = (args[1] as int?);
          assert(arg_javaScriptChannelInstanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.addJavaScriptChannel was null, expected non-null int.');
          api.addJavaScriptChannel(
              arg_instanceId!, arg_javaScriptChannelInstanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.removeJavaScriptChannel',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.removeJavaScriptChannel was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.removeJavaScriptChannel was null, expected non-null int.');
          final int? arg_javaScriptChannelInstanceId = (args[1] as int?);
          assert(arg_javaScriptChannelInstanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.removeJavaScriptChannel was null, expected non-null int.');
          api.removeJavaScriptChannel(
              arg_instanceId!, arg_javaScriptChannelInstanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setDownloadListener',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setDownloadListener was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setDownloadListener was null, expected non-null int.');
          final int? arg_listenerInstanceId = (args[1] as int?);
          api.setDownloadListener(arg_instanceId!, arg_listenerInstanceId);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebChromeClient',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebChromeClient was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setWebChromeClient was null, expected non-null int.');
          final int? arg_clientInstanceId = (args[1] as int?);
          api.setWebChromeClient(arg_instanceId!, arg_clientInstanceId);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setBackgroundColor',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setBackgroundColor was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setBackgroundColor was null, expected non-null int.');
          final int? arg_color = (args[1] as int?);
          assert(arg_color != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewHostApi.setBackgroundColor was null, expected non-null int.');
          api.setBackgroundColor(arg_instanceId!, arg_color!);
          return <Object?>[];
        });
      }
    }
  }
}

abstract class TestWebSettingsHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void create(int instanceId, int webViewInstanceId);

  void setDomStorageEnabled(int instanceId, bool flag);

  void setJavaScriptCanOpenWindowsAutomatically(int instanceId, bool flag);

  void setSupportMultipleWindows(int instanceId, bool support);

  void setJavaScriptEnabled(int instanceId, bool flag);

  void setUserAgentString(int instanceId, String? userAgentString);

  void setMediaPlaybackRequiresUserGesture(int instanceId, bool require);

  void setSupportZoom(int instanceId, bool support);

  void setLoadWithOverviewMode(int instanceId, bool overview);

  void setUseWideViewPort(int instanceId, bool use);

  void setDisplayZoomControls(int instanceId, bool enabled);

  void setBuiltInZoomControls(int instanceId, bool enabled);

  void setAllowFileAccess(int instanceId, bool enabled);

  void setTextZoom(int instanceId, int textZoom);

  String getUserAgentString(int instanceId);

  static void setup(TestWebSettingsHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.create was null, expected non-null int.');
          final int? arg_webViewInstanceId = (args[1] as int?);
          assert(arg_webViewInstanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.create was null, expected non-null int.');
          api.create(arg_instanceId!, arg_webViewInstanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDomStorageEnabled',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDomStorageEnabled was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDomStorageEnabled was null, expected non-null int.');
          final bool? arg_flag = (args[1] as bool?);
          assert(arg_flag != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDomStorageEnabled was null, expected non-null bool.');
          api.setDomStorageEnabled(arg_instanceId!, arg_flag!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptCanOpenWindowsAutomatically',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptCanOpenWindowsAutomatically was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptCanOpenWindowsAutomatically was null, expected non-null int.');
          final bool? arg_flag = (args[1] as bool?);
          assert(arg_flag != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptCanOpenWindowsAutomatically was null, expected non-null bool.');
          api.setJavaScriptCanOpenWindowsAutomatically(
              arg_instanceId!, arg_flag!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportMultipleWindows',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportMultipleWindows was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportMultipleWindows was null, expected non-null int.');
          final bool? arg_support = (args[1] as bool?);
          assert(arg_support != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportMultipleWindows was null, expected non-null bool.');
          api.setSupportMultipleWindows(arg_instanceId!, arg_support!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptEnabled',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptEnabled was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptEnabled was null, expected non-null int.');
          final bool? arg_flag = (args[1] as bool?);
          assert(arg_flag != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setJavaScriptEnabled was null, expected non-null bool.');
          api.setJavaScriptEnabled(arg_instanceId!, arg_flag!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUserAgentString',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUserAgentString was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUserAgentString was null, expected non-null int.');
          final String? arg_userAgentString = (args[1] as String?);
          api.setUserAgentString(arg_instanceId!, arg_userAgentString);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setMediaPlaybackRequiresUserGesture',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setMediaPlaybackRequiresUserGesture was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setMediaPlaybackRequiresUserGesture was null, expected non-null int.');
          final bool? arg_require = (args[1] as bool?);
          assert(arg_require != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setMediaPlaybackRequiresUserGesture was null, expected non-null bool.');
          api.setMediaPlaybackRequiresUserGesture(
              arg_instanceId!, arg_require!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportZoom',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportZoom was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportZoom was null, expected non-null int.');
          final bool? arg_support = (args[1] as bool?);
          assert(arg_support != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setSupportZoom was null, expected non-null bool.');
          api.setSupportZoom(arg_instanceId!, arg_support!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setLoadWithOverviewMode',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setLoadWithOverviewMode was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setLoadWithOverviewMode was null, expected non-null int.');
          final bool? arg_overview = (args[1] as bool?);
          assert(arg_overview != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setLoadWithOverviewMode was null, expected non-null bool.');
          api.setLoadWithOverviewMode(arg_instanceId!, arg_overview!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUseWideViewPort',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUseWideViewPort was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUseWideViewPort was null, expected non-null int.');
          final bool? arg_use = (args[1] as bool?);
          assert(arg_use != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setUseWideViewPort was null, expected non-null bool.');
          api.setUseWideViewPort(arg_instanceId!, arg_use!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDisplayZoomControls',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDisplayZoomControls was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDisplayZoomControls was null, expected non-null int.');
          final bool? arg_enabled = (args[1] as bool?);
          assert(arg_enabled != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setDisplayZoomControls was null, expected non-null bool.');
          api.setDisplayZoomControls(arg_instanceId!, arg_enabled!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setBuiltInZoomControls',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setBuiltInZoomControls was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setBuiltInZoomControls was null, expected non-null int.');
          final bool? arg_enabled = (args[1] as bool?);
          assert(arg_enabled != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setBuiltInZoomControls was null, expected non-null bool.');
          api.setBuiltInZoomControls(arg_instanceId!, arg_enabled!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setAllowFileAccess',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setAllowFileAccess was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setAllowFileAccess was null, expected non-null int.');
          final bool? arg_enabled = (args[1] as bool?);
          assert(arg_enabled != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setAllowFileAccess was null, expected non-null bool.');
          api.setAllowFileAccess(arg_instanceId!, arg_enabled!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setTextZoom',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setTextZoom was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setTextZoom was null, expected non-null int.');
          final int? arg_textZoom = (args[1] as int?);
          assert(arg_textZoom != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.setTextZoom was null, expected non-null int.');
          api.setTextZoom(arg_instanceId!, arg_textZoom!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.getUserAgentString',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.getUserAgentString was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebSettingsHostApi.getUserAgentString was null, expected non-null int.');
          final String output = api.getUserAgentString(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
  }
}

abstract class TestJavaScriptChannelHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void create(int instanceId, String channelName);

  static void setup(TestJavaScriptChannelHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.JavaScriptChannelHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.JavaScriptChannelHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.JavaScriptChannelHostApi.create was null, expected non-null int.');
          final String? arg_channelName = (args[1] as String?);
          assert(arg_channelName != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.JavaScriptChannelHostApi.create was null, expected non-null String.');
          api.create(arg_instanceId!, arg_channelName!);
          return <Object?>[];
        });
      }
    }
  }
}

abstract class TestWebViewClientHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void create(int instanceId);

  void setSynchronousReturnValueForShouldOverrideUrlLoading(
      int instanceId, bool value);

  static void setup(TestWebViewClientHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.create was null, expected non-null int.');
          api.create(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.setSynchronousReturnValueForShouldOverrideUrlLoading',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.setSynchronousReturnValueForShouldOverrideUrlLoading was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.setSynchronousReturnValueForShouldOverrideUrlLoading was null, expected non-null int.');
          final bool? arg_value = (args[1] as bool?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebViewClientHostApi.setSynchronousReturnValueForShouldOverrideUrlLoading was null, expected non-null bool.');
          api.setSynchronousReturnValueForShouldOverrideUrlLoading(
              arg_instanceId!, arg_value!);
          return <Object?>[];
        });
      }
    }
  }
}

abstract class TestDownloadListenerHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void create(int instanceId);

  static void setup(TestDownloadListenerHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.DownloadListenerHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.DownloadListenerHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.DownloadListenerHostApi.create was null, expected non-null int.');
          api.create(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
  }
}

abstract class TestWebChromeClientHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void create(int instanceId);

  void setSynchronousReturnValueForOnShowFileChooser(
      int instanceId, bool value);

  void setSynchronousReturnValueForOnConsoleMessage(int instanceId, bool value);

  void setSynchronousReturnValueForOnJsAlert(int instanceId, bool value);

  void setSynchronousReturnValueForOnJsConfirm(int instanceId, bool value);

  void setSynchronousReturnValueForOnJsPrompt(int instanceId, bool value);

  static void setup(TestWebChromeClientHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.create was null, expected non-null int.');
          api.create(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnShowFileChooser',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnShowFileChooser was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnShowFileChooser was null, expected non-null int.');
          final bool? arg_value = (args[1] as bool?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnShowFileChooser was null, expected non-null bool.');
          api.setSynchronousReturnValueForOnShowFileChooser(
              arg_instanceId!, arg_value!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnConsoleMessage',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnConsoleMessage was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnConsoleMessage was null, expected non-null int.');
          final bool? arg_value = (args[1] as bool?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnConsoleMessage was null, expected non-null bool.');
          api.setSynchronousReturnValueForOnConsoleMessage(
              arg_instanceId!, arg_value!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsAlert',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsAlert was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsAlert was null, expected non-null int.');
          final bool? arg_value = (args[1] as bool?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsAlert was null, expected non-null bool.');
          api.setSynchronousReturnValueForOnJsAlert(
              arg_instanceId!, arg_value!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsConfirm',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsConfirm was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsConfirm was null, expected non-null int.');
          final bool? arg_value = (args[1] as bool?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsConfirm was null, expected non-null bool.');
          api.setSynchronousReturnValueForOnJsConfirm(
              arg_instanceId!, arg_value!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsPrompt',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsPrompt was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsPrompt was null, expected non-null int.');
          final bool? arg_value = (args[1] as bool?);
          assert(arg_value != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebChromeClientHostApi.setSynchronousReturnValueForOnJsPrompt was null, expected non-null bool.');
          api.setSynchronousReturnValueForOnJsPrompt(
              arg_instanceId!, arg_value!);
          return <Object?>[];
        });
      }
    }
  }
}

abstract class TestAssetManagerHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  List<String?> list(String path);

  String getAssetFilePathByName(String name);

  static void setup(TestAssetManagerHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.FlutterAssetManagerHostApi.list',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.FlutterAssetManagerHostApi.list was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final String? arg_path = (args[0] as String?);
          assert(arg_path != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.FlutterAssetManagerHostApi.list was null, expected non-null String.');
          final List<String?> output = api.list(arg_path!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.FlutterAssetManagerHostApi.getAssetFilePathByName',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.FlutterAssetManagerHostApi.getAssetFilePathByName was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final String? arg_name = (args[0] as String?);
          assert(arg_name != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.FlutterAssetManagerHostApi.getAssetFilePathByName was null, expected non-null String.');
          final String output = api.getAssetFilePathByName(arg_name!);
          return <Object?>[output];
        });
      }
    }
  }
}

abstract class TestWebStorageHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  void create(int instanceId);

  void deleteAllData(int instanceId);

  static void setup(TestWebStorageHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebStorageHostApi.create',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebStorageHostApi.create was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebStorageHostApi.create was null, expected non-null int.');
          api.create(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.WebStorageHostApi.deleteAllData',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebStorageHostApi.deleteAllData was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.WebStorageHostApi.deleteAllData was null, expected non-null int.');
          api.deleteAllData(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
  }
}

/// Host API for `PermissionRequest`.
///
/// This class may handle instantiating and adding native object instances that
/// are attached to a Dart instance or handle method calls on the associated
/// native class or an instance of the class.
///
/// See https://developer.android.com/reference/android/webkit/PermissionRequest.
abstract class TestPermissionRequestHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  /// Handles Dart method `PermissionRequest.grant`.
  void grant(int instanceId, List<String?> resources);

  /// Handles Dart method `PermissionRequest.deny`.
  void deny(int instanceId);

  static void setup(TestPermissionRequestHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.grant',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.grant was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.grant was null, expected non-null int.');
          final List<String?>? arg_resources =
              (args[1] as List<Object?>?)?.cast<String?>();
          assert(arg_resources != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.grant was null, expected non-null List<String?>.');
          api.grant(arg_instanceId!, arg_resources!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.deny',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.deny was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.PermissionRequestHostApi.deny was null, expected non-null int.');
          api.deny(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
  }
}

/// Host API for `CustomViewCallback`.
///
/// This class may handle instantiating and adding native object instances that
/// are attached to a Dart instance or handle method calls on the associated
/// native class or an instance of the class.
///
/// See https://developer.android.com/reference/android/webkit/WebChromeClient.CustomViewCallback.
abstract class TestCustomViewCallbackHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  /// Handles Dart method `CustomViewCallback.onCustomViewHidden`.
  void onCustomViewHidden(int identifier);

  static void setup(TestCustomViewCallbackHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.CustomViewCallbackHostApi.onCustomViewHidden',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CustomViewCallbackHostApi.onCustomViewHidden was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_identifier = (args[0] as int?);
          assert(arg_identifier != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.CustomViewCallbackHostApi.onCustomViewHidden was null, expected non-null int.');
          api.onCustomViewHidden(arg_identifier!);
          return <Object?>[];
        });
      }
    }
  }
}

/// Host API for `GeolocationPermissionsCallback`.
///
/// This class may handle instantiating and adding native object instances that
/// are attached to a Dart instance or handle method calls on the associated
/// native class or an instance of the class.
///
/// See https://developer.android.com/reference/android/webkit/GeolocationPermissions.Callback.
abstract class TestGeolocationPermissionsCallbackHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  /// Handles Dart method `GeolocationPermissionsCallback.invoke`.
  void invoke(int instanceId, String origin, bool allow, bool retain);

  static void setup(TestGeolocationPermissionsCallbackHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackHostApi.invoke',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackHostApi.invoke was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackHostApi.invoke was null, expected non-null int.');
          final String? arg_origin = (args[1] as String?);
          assert(arg_origin != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackHostApi.invoke was null, expected non-null String.');
          final bool? arg_allow = (args[2] as bool?);
          assert(arg_allow != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackHostApi.invoke was null, expected non-null bool.');
          final bool? arg_retain = (args[3] as bool?);
          assert(arg_retain != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.GeolocationPermissionsCallbackHostApi.invoke was null, expected non-null bool.');
          api.invoke(arg_instanceId!, arg_origin!, arg_allow!, arg_retain!);
          return <Object?>[];
        });
      }
    }
  }
}

/// Host API for `HttpAuthHandler`.
///
/// This class may handle instantiating and adding native object instances that
/// are attached to a Dart instance or handle method calls on the associated
/// native class or an instance of the class.
///
/// See https://developer.android.com/reference/android/webkit/HttpAuthHandler.
abstract class TestHttpAuthHandlerHostApi {
  static TestDefaultBinaryMessengerBinding? get _testBinaryMessengerBinding =>
      TestDefaultBinaryMessengerBinding.instance;
  static const MessageCodec<Object?> codec = StandardMessageCodec();

  /// Handles Dart method `HttpAuthHandler.useHttpAuthUsernamePassword`.
  bool useHttpAuthUsernamePassword(int instanceId);

  /// Handles Dart method `HttpAuthHandler.cancel`.
  void cancel(int instanceId);

  /// Handles Dart method `HttpAuthHandler.proceed`.
  void proceed(int instanceId, String username, String password);

  static void setup(TestHttpAuthHandlerHostApi? api,
      {BinaryMessenger? binaryMessenger}) {
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.useHttpAuthUsernamePassword',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.useHttpAuthUsernamePassword was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.useHttpAuthUsernamePassword was null, expected non-null int.');
          final bool output = api.useHttpAuthUsernamePassword(arg_instanceId!);
          return <Object?>[output];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.cancel',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.cancel was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.cancel was null, expected non-null int.');
          api.cancel(arg_instanceId!);
          return <Object?>[];
        });
      }
    }
    {
      final BasicMessageChannel<Object?> channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.proceed',
          codec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel, null);
      } else {
        _testBinaryMessengerBinding!.defaultBinaryMessenger
            .setMockDecodedMessageHandler<Object?>(channel,
                (Object? message) async {
          assert(message != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.proceed was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final int? arg_instanceId = (args[0] as int?);
          assert(arg_instanceId != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.proceed was null, expected non-null int.');
          final String? arg_username = (args[1] as String?);
          assert(arg_username != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.proceed was null, expected non-null String.');
          final String? arg_password = (args[2] as String?);
          assert(arg_password != null,
              'Argument for dev.flutter.pigeon.webview_flutter_android.HttpAuthHandlerHostApi.proceed was null, expected non-null String.');
          api.proceed(arg_instanceId!, arg_username!, arg_password!);
          return <Object?>[];
        });
      }
    }
  }
}
