// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#import <Foundation/Foundation.h>
#import <GoogleMobileAds/GADAdNetworkExtras.h>

/**
 * Mediation adapters will provide a class that conforms to this protocol to be
 * added to the `FLTAdRequest`.
 */
@protocol FlutterMediationExtras

// Pair of key-values to be stored received from the dart layer.
@property NSDictionary<NSString *, id> *_Nullable extras;

/**
 * Parses the values in @c extras to the required protocol to append Mediation
 * extras to the `FLTAdRequest`.
 *
 * @return the parsed extra values to an object that conforms to protocol.
 */
- (id<GADAdNetworkExtras> _Nonnull)getMediationExtras;

@end
