// This is a generated file (see the discoveryapis_generator project).

// ignore_for_file: camel_case_types
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: lines_longer_than_80_chars
// ignore_for_file: non_constant_identifier_names
// ignore_for_file: prefer_interpolation_to_compose_strings
// ignore_for_file: unnecessary_brace_in_string_interps
// ignore_for_file: unnecessary_lambdas
// ignore_for_file: unnecessary_library_directive
// ignore_for_file: unnecessary_string_interpolations

/// Vertex AI API - v1
///
/// Train high-quality custom machine learning models with minimal machine
/// learning expertise and effort.
///
/// For more information, see <https://cloud.google.com/vertex-ai/>
///
/// Create an instance of [AiplatformApi] to access these resources:
///
/// - [ProjectsResource]
///   - [ProjectsLocationsResource]
///     - [ProjectsLocationsBatchPredictionJobsResource]
///     - [ProjectsLocationsCustomJobsResource]
///       - [ProjectsLocationsCustomJobsOperationsResource]
///     - [ProjectsLocationsDataLabelingJobsResource]
///       - [ProjectsLocationsDataLabelingJobsOperationsResource]
///     - [ProjectsLocationsDatasetsResource]
///       - [ProjectsLocationsDatasetsAnnotationSpecsResource]
///         - [ProjectsLocationsDatasetsAnnotationSpecsOperationsResource]
///       - [ProjectsLocationsDatasetsDataItemsResource]
///         - [ProjectsLocationsDatasetsDataItemsAnnotationsResource]
/// - [ProjectsLocationsDatasetsDataItemsAnnotationsOperationsResource]
///         - [ProjectsLocationsDatasetsDataItemsOperationsResource]
///       - [ProjectsLocationsDatasetsDatasetVersionsResource]
///       - [ProjectsLocationsDatasetsOperationsResource]
///       - [ProjectsLocationsDatasetsSavedQueriesResource]
///         - [ProjectsLocationsDatasetsSavedQueriesOperationsResource]
///     - [ProjectsLocationsDeploymentResourcePoolsResource]
///       - [ProjectsLocationsDeploymentResourcePoolsOperationsResource]
///     - [ProjectsLocationsEndpointsResource]
///       - [ProjectsLocationsEndpointsOperationsResource]
///     - [ProjectsLocationsFeatureGroupsResource]
///       - [ProjectsLocationsFeatureGroupsFeaturesResource]
///         - [ProjectsLocationsFeatureGroupsFeaturesOperationsResource]
///       - [ProjectsLocationsFeatureGroupsOperationsResource]
///     - [ProjectsLocationsFeatureOnlineStoresResource]
///       - [ProjectsLocationsFeatureOnlineStoresFeatureViewsResource]
/// - [ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsResource]
/// - [ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsResource]
///       - [ProjectsLocationsFeatureOnlineStoresOperationsResource]
///     - [ProjectsLocationsFeaturestoresResource]
///       - [ProjectsLocationsFeaturestoresEntityTypesResource]
///         - [ProjectsLocationsFeaturestoresEntityTypesFeaturesResource]
/// - [ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsResource]
///         - [ProjectsLocationsFeaturestoresEntityTypesOperationsResource]
///       - [ProjectsLocationsFeaturestoresOperationsResource]
///     - [ProjectsLocationsHyperparameterTuningJobsResource]
///       - [ProjectsLocationsHyperparameterTuningJobsOperationsResource]
///     - [ProjectsLocationsIndexEndpointsResource]
///       - [ProjectsLocationsIndexEndpointsOperationsResource]
///     - [ProjectsLocationsIndexesResource]
///       - [ProjectsLocationsIndexesOperationsResource]
///     - [ProjectsLocationsMetadataStoresResource]
///       - [ProjectsLocationsMetadataStoresArtifactsResource]
///       - [ProjectsLocationsMetadataStoresContextsResource]
///       - [ProjectsLocationsMetadataStoresExecutionsResource]
///       - [ProjectsLocationsMetadataStoresMetadataSchemasResource]
///     - [ProjectsLocationsMigratableResourcesResource]
///       - [ProjectsLocationsMigratableResourcesOperationsResource]
///     - [ProjectsLocationsModelDeploymentMonitoringJobsResource]
///       - [ProjectsLocationsModelDeploymentMonitoringJobsOperationsResource]
///     - [ProjectsLocationsModelsResource]
///       - [ProjectsLocationsModelsEvaluationsResource]
///         - [ProjectsLocationsModelsEvaluationsOperationsResource]
///         - [ProjectsLocationsModelsEvaluationsSlicesResource]
///       - [ProjectsLocationsModelsOperationsResource]
///     - [ProjectsLocationsNasJobsResource]
///       - [ProjectsLocationsNasJobsNasTrialDetailsResource]
///     - [ProjectsLocationsNotebookRuntimeTemplatesResource]
///     - [ProjectsLocationsNotebookRuntimesResource]
///     - [ProjectsLocationsOperationsResource]
///     - [ProjectsLocationsPipelineJobsResource]
///       - [ProjectsLocationsPipelineJobsOperationsResource]
///     - [ProjectsLocationsPublishersResource]
///       - [ProjectsLocationsPublishersModelsResource]
///     - [ProjectsLocationsSchedulesResource]
///       - [ProjectsLocationsSchedulesOperationsResource]
///     - [ProjectsLocationsSpecialistPoolsResource]
///       - [ProjectsLocationsSpecialistPoolsOperationsResource]
///     - [ProjectsLocationsStudiesResource]
///       - [ProjectsLocationsStudiesOperationsResource]
///       - [ProjectsLocationsStudiesTrialsResource]
///         - [ProjectsLocationsStudiesTrialsOperationsResource]
///     - [ProjectsLocationsTensorboardsResource]
///       - [ProjectsLocationsTensorboardsExperimentsResource]
///         - [ProjectsLocationsTensorboardsExperimentsOperationsResource]
///         - [ProjectsLocationsTensorboardsExperimentsRunsResource]
/// - [ProjectsLocationsTensorboardsExperimentsRunsOperationsResource]
/// - [ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesResource]
/// - [ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsResource]
///       - [ProjectsLocationsTensorboardsOperationsResource]
///     - [ProjectsLocationsTrainingPipelinesResource]
///       - [ProjectsLocationsTrainingPipelinesOperationsResource]
/// - [PublishersResource]
///   - [PublishersModelsResource]
library aiplatform_v1;

import 'dart:async' as async;
import 'dart:convert' as convert;
import 'dart:core' as core;

import 'package:_discoveryapis_commons/_discoveryapis_commons.dart' as commons;
import 'package:http/http.dart' as http;

import '../shared.dart';
import '../src/user_agent.dart';

export 'package:_discoveryapis_commons/_discoveryapis_commons.dart'
    show ApiRequestError, DetailedApiRequestError;

/// Train high-quality custom machine learning models with minimal machine
/// learning expertise and effort.
class AiplatformApi {
  /// See, edit, configure, and delete your Google Cloud data and see the email
  /// address for your Google Account.
  static const cloudPlatformScope =
      'https://www.googleapis.com/auth/cloud-platform';

  /// View your data across Google Cloud services and see the email address of
  /// your Google Account
  static const cloudPlatformReadOnlyScope =
      'https://www.googleapis.com/auth/cloud-platform.read-only';

  final commons.ApiRequester _requester;

  ProjectsResource get projects => ProjectsResource(_requester);
  PublishersResource get publishers => PublishersResource(_requester);

  AiplatformApi(http.Client client,
      {core.String rootUrl = 'https://aiplatform.googleapis.com/',
      core.String servicePath = ''})
      : _requester =
            commons.ApiRequester(client, rootUrl, servicePath, requestHeaders);
}

class ProjectsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsResource get locations =>
      ProjectsLocationsResource(_requester);

  ProjectsResource(commons.ApiRequester client) : _requester = client;
}

class ProjectsLocationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsBatchPredictionJobsResource get batchPredictionJobs =>
      ProjectsLocationsBatchPredictionJobsResource(_requester);
  ProjectsLocationsCustomJobsResource get customJobs =>
      ProjectsLocationsCustomJobsResource(_requester);
  ProjectsLocationsDataLabelingJobsResource get dataLabelingJobs =>
      ProjectsLocationsDataLabelingJobsResource(_requester);
  ProjectsLocationsDatasetsResource get datasets =>
      ProjectsLocationsDatasetsResource(_requester);
  ProjectsLocationsDeploymentResourcePoolsResource
      get deploymentResourcePools =>
          ProjectsLocationsDeploymentResourcePoolsResource(_requester);
  ProjectsLocationsEndpointsResource get endpoints =>
      ProjectsLocationsEndpointsResource(_requester);
  ProjectsLocationsFeatureGroupsResource get featureGroups =>
      ProjectsLocationsFeatureGroupsResource(_requester);
  ProjectsLocationsFeatureOnlineStoresResource get featureOnlineStores =>
      ProjectsLocationsFeatureOnlineStoresResource(_requester);
  ProjectsLocationsFeaturestoresResource get featurestores =>
      ProjectsLocationsFeaturestoresResource(_requester);
  ProjectsLocationsHyperparameterTuningJobsResource
      get hyperparameterTuningJobs =>
          ProjectsLocationsHyperparameterTuningJobsResource(_requester);
  ProjectsLocationsIndexEndpointsResource get indexEndpoints =>
      ProjectsLocationsIndexEndpointsResource(_requester);
  ProjectsLocationsIndexesResource get indexes =>
      ProjectsLocationsIndexesResource(_requester);
  ProjectsLocationsMetadataStoresResource get metadataStores =>
      ProjectsLocationsMetadataStoresResource(_requester);
  ProjectsLocationsMigratableResourcesResource get migratableResources =>
      ProjectsLocationsMigratableResourcesResource(_requester);
  ProjectsLocationsModelDeploymentMonitoringJobsResource
      get modelDeploymentMonitoringJobs =>
          ProjectsLocationsModelDeploymentMonitoringJobsResource(_requester);
  ProjectsLocationsModelsResource get models =>
      ProjectsLocationsModelsResource(_requester);
  ProjectsLocationsNasJobsResource get nasJobs =>
      ProjectsLocationsNasJobsResource(_requester);
  ProjectsLocationsNotebookRuntimeTemplatesResource
      get notebookRuntimeTemplates =>
          ProjectsLocationsNotebookRuntimeTemplatesResource(_requester);
  ProjectsLocationsNotebookRuntimesResource get notebookRuntimes =>
      ProjectsLocationsNotebookRuntimesResource(_requester);
  ProjectsLocationsOperationsResource get operations =>
      ProjectsLocationsOperationsResource(_requester);
  ProjectsLocationsPipelineJobsResource get pipelineJobs =>
      ProjectsLocationsPipelineJobsResource(_requester);
  ProjectsLocationsPublishersResource get publishers =>
      ProjectsLocationsPublishersResource(_requester);
  ProjectsLocationsSchedulesResource get schedules =>
      ProjectsLocationsSchedulesResource(_requester);
  ProjectsLocationsSpecialistPoolsResource get specialistPools =>
      ProjectsLocationsSpecialistPoolsResource(_requester);
  ProjectsLocationsStudiesResource get studies =>
      ProjectsLocationsStudiesResource(_requester);
  ProjectsLocationsTensorboardsResource get tensorboards =>
      ProjectsLocationsTensorboardsResource(_requester);
  ProjectsLocationsTrainingPipelinesResource get trainingPipelines =>
      ProjectsLocationsTrainingPipelinesResource(_requester);

  ProjectsLocationsResource(commons.ApiRequester client) : _requester = client;

  /// Gets information about a location.
  ///
  /// Request parameters:
  ///
  /// [name] - Resource name for the location.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudLocationLocation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudLocationLocation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudLocationLocation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists information about the supported locations for this service.
  ///
  /// Request parameters:
  ///
  /// [name] - The resource that owns the locations collection, if applicable.
  /// Value must have pattern `^projects/\[^/\]+$`.
  ///
  /// [filter] - A filter to narrow down results to a preferred subset. The
  /// filtering language accepts strings like `"displayName=tokyo"`, and is
  /// documented in more detail in \[AIP-160\](https://google.aip.dev/160).
  ///
  /// [pageSize] - The maximum number of results to return. If not set, the
  /// service selects a default.
  ///
  /// [pageToken] - A page token received from the `next_page_token` field in
  /// the response. Send that page token to receive the subsequent page.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudLocationListLocationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudLocationListLocationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/locations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudLocationListLocationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsBatchPredictionJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsBatchPredictionJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a BatchPredictionJob.
  ///
  /// Starts asynchronous cancellation on the BatchPredictionJob. The server
  /// makes the best effort to cancel the job, but success is not guaranteed.
  /// Clients can use JobService.GetBatchPredictionJob or other methods to check
  /// whether the cancellation succeeded or whether the job completed despite
  /// cancellation. On a successful cancellation, the BatchPredictionJob is not
  /// deleted;instead its BatchPredictionJob.state is set to `CANCELLED`. Any
  /// files already outputted by the job are not deleted.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the BatchPredictionJob to cancel. Format:
  /// `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/batchPredictionJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelBatchPredictionJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a BatchPredictionJob.
  ///
  /// A BatchPredictionJob once created will right away be attempted to start.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// BatchPredictionJob in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1BatchPredictionJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1BatchPredictionJob> create(
    GoogleCloudAiplatformV1BatchPredictionJob request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/batchPredictionJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1BatchPredictionJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a BatchPredictionJob.
  ///
  /// Can only be called on jobs that already finished.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the BatchPredictionJob resource to be
  /// deleted. Format:
  /// `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/batchPredictionJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a BatchPredictionJob
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the BatchPredictionJob resource. Format:
  /// `projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/batchPredictionJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1BatchPredictionJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1BatchPredictionJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1BatchPredictionJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists BatchPredictionJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the
  /// BatchPredictionJobs from. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. *
  /// \`model_display_name\` supports \`=\`, \`!=\` comparisons. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"\` *
  /// \`state!="JOB_STATE_FAILED" OR display_name="my_job"\` * \`NOT
  /// display_name="my_job"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`labels.keyA=valueA\` * \`labels.keyB:*\`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListBatchPredictionJobsResponse.next_page_token of the previous
  /// JobService.ListBatchPredictionJobs call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListBatchPredictionJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListBatchPredictionJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/batchPredictionJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListBatchPredictionJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsCustomJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsCustomJobsOperationsResource get operations =>
      ProjectsLocationsCustomJobsOperationsResource(_requester);

  ProjectsLocationsCustomJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a CustomJob.
  ///
  /// Starts asynchronous cancellation on the CustomJob. The server makes a best
  /// effort to cancel the job, but success is not guaranteed. Clients can use
  /// JobService.GetCustomJob or other methods to check whether the cancellation
  /// succeeded or whether the job completed despite cancellation. On successful
  /// cancellation, the CustomJob is not deleted; instead it becomes a job with
  /// a CustomJob.error value with a google.rpc.Status.code of 1, corresponding
  /// to `Code.CANCELLED`, and CustomJob.state is set to `CANCELLED`.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the CustomJob to cancel. Format:
  /// `projects/{project}/locations/{location}/customJobs/{custom_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelCustomJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a CustomJob.
  ///
  /// A created CustomJob right away will be attempted to be run.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// CustomJob in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1CustomJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1CustomJob> create(
    GoogleCloudAiplatformV1CustomJob request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/customJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1CustomJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a CustomJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the CustomJob resource to be deleted.
  /// Format: `projects/{project}/locations/{location}/customJobs/{custom_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a CustomJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the CustomJob resource. Format:
  /// `projects/{project}/locations/{location}/customJobs/{custom_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1CustomJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1CustomJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1CustomJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists CustomJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the
  /// CustomJobs from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"\` *
  /// \`state!="JOB_STATE_FAILED" OR display_name="my_job"\` * \`NOT
  /// display_name="my_job"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`labels.keyA=valueA\` * \`labels.keyB:*\`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListCustomJobsResponse.next_page_token of the previous
  /// JobService.ListCustomJobs call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListCustomJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListCustomJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/customJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListCustomJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsCustomJobsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsCustomJobsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/customJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataLabelingJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataLabelingJobsOperationsResource get operations =>
      ProjectsLocationsDataLabelingJobsOperationsResource(_requester);

  ProjectsLocationsDataLabelingJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a DataLabelingJob.
  ///
  /// Success of cancellation is not guaranteed.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DataLabelingJob. Format:
  /// `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelDataLabelingJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a DataLabelingJob.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent of the DataLabelingJob. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1DataLabelingJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1DataLabelingJob> create(
    GoogleCloudAiplatformV1DataLabelingJob request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataLabelingJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1DataLabelingJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a DataLabelingJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DataLabelingJob to be deleted. Format:
  /// `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a DataLabelingJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DataLabelingJob. Format:
  /// `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1DataLabelingJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1DataLabelingJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1DataLabelingJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DataLabelingJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent of the DataLabelingJob. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"\` *
  /// \`state!="JOB_STATE_FAILED" OR display_name="my_job"\` * \`NOT
  /// display_name="my_job"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`labels.keyA=valueA\` * \`labels.keyB:*\`
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order by default. Use `desc` after a field name for descending.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [readMask] - Mask specifying which fields to read. FieldMask represents a
  /// set of symbolic field paths. For example, the mask can be `paths: "name"`.
  /// The "name" here is a field in DataLabelingJob. If this field is not set,
  /// all fields of the DataLabelingJob are returned.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListDataLabelingJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListDataLabelingJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataLabelingJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListDataLabelingJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDataLabelingJobsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDataLabelingJobsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/dataLabelingJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsAnnotationSpecsResource get annotationSpecs =>
      ProjectsLocationsDatasetsAnnotationSpecsResource(_requester);
  ProjectsLocationsDatasetsDataItemsResource get dataItems =>
      ProjectsLocationsDatasetsDataItemsResource(_requester);
  ProjectsLocationsDatasetsDatasetVersionsResource get datasetVersions =>
      ProjectsLocationsDatasetsDatasetVersionsResource(_requester);
  ProjectsLocationsDatasetsOperationsResource get operations =>
      ProjectsLocationsDatasetsOperationsResource(_requester);
  ProjectsLocationsDatasetsSavedQueriesResource get savedQueries =>
      ProjectsLocationsDatasetsSavedQueriesResource(_requester);

  ProjectsLocationsDatasetsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a Dataset.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// Dataset in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Dataset request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/datasets';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Dataset.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Dataset to delete. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Exports data from a Dataset.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Dataset resource. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> export(
    GoogleCloudAiplatformV1ExportDataRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':export';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Dataset.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Dataset resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Dataset].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Dataset> get(
    core.String name, {
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Dataset.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Imports data into a Dataset.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Dataset resource. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> import(
    GoogleCloudAiplatformV1ImportDataRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':import';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Datasets in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the Dataset's parent resource. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - An expression for filtering the results of the request. For
  /// field names both snake_case and camelCase are supported. *
  /// \`display_name\`: supports = and != * \`metadata_schema_uri\`: supports =
  /// and != * \`labels\` supports general map functions that is: *
  /// \`labels.key=value\` - key:value equality * \`labels.key:* or labels:key -
  /// key existence * A key including a space must be quoted. \`labels."a
  /// key"\`. Some examples: * \`displayName="myDisplayName"\` *
  /// \`labels.myKey="myValue"\`
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `display_name` * `create_time` * `update_time`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListDatasetsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListDatasetsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/datasets';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListDatasetsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a Dataset.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the Dataset.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask applies to the resource. For the
  /// `FieldMask` definition, see google.protobuf.FieldMask. Updatable fields: *
  /// `display_name` * `description` * `labels`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Dataset].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Dataset> patch(
    GoogleCloudAiplatformV1Dataset request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Dataset.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Searches DataItems in a Dataset.
  ///
  /// Request parameters:
  ///
  /// [dataset] - Required. The resource name of the Dataset from which to
  /// search DataItems. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [annotationFilters] - An expression that specifies what Annotations will
  /// be returned per DataItem. Annotations satisfied either of the conditions
  /// will be returned. * `annotation_spec_id` - for = or !=. Must specify
  /// `saved_query_id=` - saved query id that annotations should belong to.
  ///
  /// [annotationsFilter] - An expression for filtering the Annotations that
  /// will be returned per DataItem. * `annotation_spec_id` - for = or !=.
  ///
  /// [annotationsLimit] - If set, only up to this many of Annotations will be
  /// returned per DataItemView. The maximum value is 1000. If not set, the
  /// maximum value will be used.
  ///
  /// [dataItemFilter] - An expression for filtering the DataItem that will be
  /// returned. * `data_item_id` - for = or !=. * `labeled` - for = or !=. *
  /// `has_annotation(ANNOTATION_SPEC_ID)` - true only for DataItem that have at
  /// least one annotation with annotation_spec_id = `ANNOTATION_SPEC_ID` in the
  /// context of SavedQuery or DataLabelingJob. For example: * `data_item=1` *
  /// `has_annotation(5)`
  ///
  /// [dataLabelingJob] - The resource name of a DataLabelingJob. Format:
  /// `projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}`
  /// If this field is set, all of the search will be done in the context of
  /// this DataLabelingJob.
  ///
  /// [fieldMask] - Mask specifying which fields of DataItemView to read.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending.
  ///
  /// [orderByAnnotation_orderBy] - A comma-separated list of annotation fields
  /// to order by, sorted in ascending order. Use "desc" after a field name for
  /// descending. Must also specify saved_query.
  ///
  /// [orderByAnnotation_savedQuery] - Required. Saved query of the Annotation.
  /// Only Annotations belong to this saved query will be considered for
  /// ordering.
  ///
  /// [orderByDataItem] - A comma-separated list of data item fields to order
  /// by, sorted in ascending order. Use "desc" after a field name for
  /// descending.
  ///
  /// [pageSize] - Requested page size. Server may return fewer results than
  /// requested. Default and maximum page size is 100.
  ///
  /// [pageToken] - A token identifying a page of results for the server to
  /// return Typically obtained via SearchDataItemsResponse.next_page_token of
  /// the previous DatasetService.SearchDataItems call.
  ///
  /// [savedQuery] - The resource name of a SavedQuery(annotation set in UI).
  /// Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
  /// All of the search will be done in the context of this SavedQuery.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1SearchDataItemsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1SearchDataItemsResponse> searchDataItems(
    core.String dataset, {
    core.List<core.String>? annotationFilters,
    core.String? annotationsFilter,
    core.int? annotationsLimit,
    core.String? dataItemFilter,
    core.String? dataLabelingJob,
    core.String? fieldMask,
    core.String? orderBy,
    core.String? orderByAnnotation_orderBy,
    core.String? orderByAnnotation_savedQuery,
    core.String? orderByDataItem,
    core.int? pageSize,
    core.String? pageToken,
    core.String? savedQuery,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (annotationFilters != null) 'annotationFilters': annotationFilters,
      if (annotationsFilter != null) 'annotationsFilter': [annotationsFilter],
      if (annotationsLimit != null) 'annotationsLimit': ['${annotationsLimit}'],
      if (dataItemFilter != null) 'dataItemFilter': [dataItemFilter],
      if (dataLabelingJob != null) 'dataLabelingJob': [dataLabelingJob],
      if (fieldMask != null) 'fieldMask': [fieldMask],
      if (orderBy != null) 'orderBy': [orderBy],
      if (orderByAnnotation_orderBy != null)
        'orderByAnnotation.orderBy': [orderByAnnotation_orderBy],
      if (orderByAnnotation_savedQuery != null)
        'orderByAnnotation.savedQuery': [orderByAnnotation_savedQuery],
      if (orderByDataItem != null) 'orderByDataItem': [orderByDataItem],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (savedQuery != null) 'savedQuery': [savedQuery],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$dataset') + ':searchDataItems';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1SearchDataItemsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsAnnotationSpecsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsAnnotationSpecsOperationsResource get operations =>
      ProjectsLocationsDatasetsAnnotationSpecsOperationsResource(_requester);

  ProjectsLocationsDatasetsAnnotationSpecsResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets an AnnotationSpec.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the AnnotationSpec resource. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/annotationSpecs/\[^/\]+$`.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1AnnotationSpec].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1AnnotationSpec> get(
    core.String name, {
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1AnnotationSpec.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsAnnotationSpecsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsAnnotationSpecsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/annotationSpecs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/annotationSpecs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/annotationSpecs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/annotationSpecs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/annotationSpecs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsDataItemsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsDataItemsAnnotationsResource get annotations =>
      ProjectsLocationsDatasetsDataItemsAnnotationsResource(_requester);
  ProjectsLocationsDatasetsDataItemsOperationsResource get operations =>
      ProjectsLocationsDatasetsDataItemsOperationsResource(_requester);

  ProjectsLocationsDatasetsDataItemsResource(commons.ApiRequester client)
      : _requester = client;

  /// Lists DataItems in a Dataset.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Dataset to list DataItems
  /// from. Format: `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListDataItemsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListDataItemsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/dataItems';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListDataItemsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsDataItemsAnnotationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsDataItemsAnnotationsOperationsResource
      get operations =>
          ProjectsLocationsDatasetsDataItemsAnnotationsOperationsResource(
              _requester);

  ProjectsLocationsDatasetsDataItemsAnnotationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Lists Annotations belongs to a dataitem
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the DataItem to list Annotations
  /// from. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/dataItems/{data_item}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListAnnotationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListAnnotationsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/annotations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListAnnotationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsDataItemsAnnotationsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsDataItemsAnnotationsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/annotations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/annotations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/annotations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/annotations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/annotations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsDataItemsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsDataItemsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/dataItems/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsDatasetVersionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsDatasetVersionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a version from a Dataset.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the Dataset resource. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1DatasetVersion request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/datasetVersions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Dataset version.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Dataset version to delete.
  /// Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/datasetVersions/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Dataset version.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Dataset version to delete.
  /// Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/datasetVersions/\[^/\]+$`.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1DatasetVersion].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1DatasetVersion> get(
    core.String name, {
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1DatasetVersion.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists DatasetVersions in a Dataset.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Dataset to list
  /// DatasetVersions from. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [filter] - Optional. The standard list filter.
  ///
  /// [orderBy] - Optional. A comma-separated list of fields to order by, sorted
  /// in ascending order. Use "desc" after a field name for descending.
  ///
  /// [pageSize] - Optional. The standard list page size.
  ///
  /// [pageToken] - Optional. The standard list page token.
  ///
  /// [readMask] - Optional. Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListDatasetVersionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListDatasetVersionsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/datasetVersions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListDatasetVersionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Restores a dataset version.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DatasetVersion resource. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{dataset_version}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/datasetVersions/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> restore(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':restore';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsSavedQueriesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsSavedQueriesOperationsResource get operations =>
      ProjectsLocationsDatasetsSavedQueriesOperationsResource(_requester);

  ProjectsLocationsDatasetsSavedQueriesResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes a SavedQuery.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the SavedQuery to delete. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/savedQueries/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists SavedQueries in a Dataset.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Dataset to list SavedQueries
  /// from. Format: `projects/{project}/locations/{location}/datasets/{dataset}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListSavedQueriesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListSavedQueriesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/savedQueries';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListSavedQueriesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDatasetsSavedQueriesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDatasetsSavedQueriesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/savedQueries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/savedQueries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/savedQueries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/savedQueries/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/datasets/\[^/\]+/savedQueries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDeploymentResourcePoolsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDeploymentResourcePoolsOperationsResource get operations =>
      ProjectsLocationsDeploymentResourcePoolsOperationsResource(_requester);

  ProjectsLocationsDeploymentResourcePoolsResource(commons.ApiRequester client)
      : _requester = client;

  /// Create a DeploymentResourcePool.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent location resource where this
  /// DeploymentResourcePool will be created. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/deploymentResourcePools';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete a DeploymentResourcePool.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DeploymentResourcePool to delete.
  /// Format:
  /// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Get a DeploymentResourcePool.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the DeploymentResourcePool to retrieve.
  /// Format:
  /// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1DeploymentResourcePool].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1DeploymentResourcePool> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1DeploymentResourcePool.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List DeploymentResourcePools in a location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent Location which owns this collection of
  /// DeploymentResourcePools. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [pageSize] - The maximum number of DeploymentResourcePools to return. The
  /// service may return fewer than this value.
  ///
  /// [pageToken] - A page token, received from a previous
  /// `ListDeploymentResourcePools` call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// `ListDeploymentResourcePools` must match the call that provided the page
  /// token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/deploymentResourcePools';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListDeploymentResourcePoolsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List DeployedModels that have been deployed on this
  /// DeploymentResourcePool.
  ///
  /// Request parameters:
  ///
  /// [deploymentResourcePool] - Required. The name of the target
  /// DeploymentResourcePool to query. Format:
  /// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+$`.
  ///
  /// [pageSize] - The maximum number of DeployedModels to return. The service
  /// may return fewer than this value.
  ///
  /// [pageToken] - A page token, received from a previous `QueryDeployedModels`
  /// call. Provide this to retrieve the subsequent page. When paginating, all
  /// other parameters provided to `QueryDeployedModels` must match the call
  /// that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1QueryDeployedModelsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1QueryDeployedModelsResponse>
      queryDeployedModels(
    core.String deploymentResourcePool, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$deploymentResourcePool') +
        ':queryDeployedModels';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1QueryDeployedModelsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsDeploymentResourcePoolsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsDeploymentResourcePoolsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/deploymentResourcePools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsEndpointsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsEndpointsOperationsResource get operations =>
      ProjectsLocationsEndpointsOperationsResource(_requester);

  ProjectsLocationsEndpointsResource(commons.ApiRequester client)
      : _requester = client;

  /// Return a list of tokens based on the input text.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to get lists of
  /// tokens and token ids.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ComputeTokensResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ComputeTokensResponse> computeTokens(
    GoogleCloudAiplatformV1ComputeTokensRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':computeTokens';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ComputeTokensResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform a token counting.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to perform token
  /// counting. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1CountTokensResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1CountTokensResponse> countTokens(
    GoogleCloudAiplatformV1CountTokensRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':countTokens';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1CountTokensResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an Endpoint.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// Endpoint in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [endpointId] - Immutable. The ID to use for endpoint, which will become
  /// the final component of the endpoint resource name. If not provided, Vertex
  /// AI will generate a value for this ID. If the first character is a letter,
  /// this value may be up to 63 characters, and valid characters are
  /// `[a-z0-9-]`. The last character must be a letter or number. If the first
  /// character is a number, this value may be up to 9 characters, and valid
  /// characters are `[0-9]` with no leading zeros. When using HTTP/JSON, this
  /// field is populated based on a query string argument, such as
  /// `?endpoint_id=12345`. This is the fallback for fields that are not
  /// included in either the URI or the body.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Endpoint request,
    core.String parent, {
    core.String? endpointId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (endpointId != null) 'endpointId': [endpointId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/endpoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an Endpoint.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Endpoint resource to be deleted.
  /// Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deploys a Model into this Endpoint, creating a DeployedModel within it.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint resource into which to
  /// deploy a Model. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> deployModel(
    GoogleCloudAiplatformV1DeployModelRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':deployModel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform an online explanation.
  ///
  /// If deployed_model_id is specified, the corresponding DeployModel must have
  /// explanation_spec populated. If deployed_model_id is not specified, all
  /// DeployedModels must have explanation_spec populated.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// explanation. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ExplainResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ExplainResponse> explain(
    GoogleCloudAiplatformV1ExplainRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':explain';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ExplainResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an Endpoint.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Endpoint resource. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Endpoint].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Endpoint> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Endpoint.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Endpoints in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location from which to list
  /// the Endpoints. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. An expression for filtering the results of the
  /// request. For field names both snake_case and camelCase are supported. *
  /// \`endpoint\` supports = and !=. \`endpoint\` represents the Endpoint ID,
  /// i.e. the last segment of the Endpoint's resource name. * \`display_name\`
  /// supports = and, != * \`labels\` supports general map functions that is: *
  /// \`labels.key=value\` - key:value equality * \`labels.key:* or labels:key -
  /// key existence * A key including a space must be quoted. \`labels."a
  /// key"\`. Some examples: * \`endpoint=1\` * \`displayName="myDisplayName"\`
  /// * \`labels.myKey="myValue"\`
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `display_name` * `create_time` * `update_time` Example:
  /// `display_name, create_time desc`.
  ///
  /// [pageSize] - Optional. The standard list page size.
  ///
  /// [pageToken] - Optional. The standard list page token. Typically obtained
  /// via ListEndpointsResponse.next_page_token of the previous
  /// EndpointService.ListEndpoints call.
  ///
  /// [readMask] - Optional. Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListEndpointsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListEndpointsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/endpoints';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListEndpointsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an existing deployed model.
  ///
  /// Updatable fields include `min_replica_count`, `max_replica_count`,
  /// `autoscaling_metric_specs`, `disable_container_logging` (v1 only), and
  /// `enable_container_logging` (v1beta1 only).
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint resource into which to
  /// mutate a DeployedModel. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> mutateDeployedModel(
    GoogleCloudAiplatformV1MutateDeployedModelRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$endpoint') + ':mutateDeployedModel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an Endpoint.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the Endpoint.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask applies to the resource. See
  /// google.protobuf.FieldMask.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Endpoint].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Endpoint> patch(
    GoogleCloudAiplatformV1Endpoint request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Endpoint.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform an online prediction.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// prediction. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1PredictResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1PredictResponse> predict(
    GoogleCloudAiplatformV1PredictRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':predict';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1PredictResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform an online prediction with an arbitrary HTTP payload.
  ///
  /// The response includes the following HTTP headers: *
  /// `X-Vertex-AI-Endpoint-Id`: ID of the Endpoint that served this prediction.
  /// * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's DeployedModel that
  /// served this prediction.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// prediction. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleApiHttpBody].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleApiHttpBody> rawPredict(
    GoogleCloudAiplatformV1RawPredictRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':rawPredict';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleApiHttpBody.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform a server-side streaming online prediction request for Vertex LLM
  /// streaming.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// prediction. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1StreamingPredictResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1StreamingPredictResponse>
      serverStreamingPredict(
    GoogleCloudAiplatformV1StreamingPredictRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$endpoint') + ':serverStreamingPredict';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1StreamingPredictResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Undeploys a Model from an Endpoint, removing a DeployedModel from it, and
  /// freeing all resources it's using.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint resource from which to
  /// undeploy a Model. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> undeployModel(
    GoogleCloudAiplatformV1UndeployModelRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':undeployModel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsEndpointsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsEndpointsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/endpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureGroupsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureGroupsFeaturesResource get features =>
      ProjectsLocationsFeatureGroupsFeaturesResource(_requester);
  ProjectsLocationsFeatureGroupsOperationsResource get operations =>
      ProjectsLocationsFeatureGroupsOperationsResource(_requester);

  ProjectsLocationsFeatureGroupsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a new FeatureGroup in a given project and location.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create
  /// FeatureGroups. Format: `projects/{project}/locations/{location}'`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [featureGroupId] - Required. The ID to use for this FeatureGroup, which
  /// will become the final component of the FeatureGroup's resource name. This
  /// value may be up to 60 characters, and valid characters are `[a-z0-9_]`.
  /// The first character cannot be a number. The value must be unique within
  /// the project and location.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1FeatureGroup request,
    core.String parent, {
    core.String? featureGroupId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (featureGroupId != null) 'featureGroupId': [featureGroupId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featureGroups';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single FeatureGroup.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureGroup to be deleted. Format:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+$`.
  ///
  /// [force] - If set to true, any Features under this FeatureGroup will also
  /// be deleted. (Otherwise, the request will only work if the FeatureGroup has
  /// no Features.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single FeatureGroup.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureGroup resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1FeatureGroup].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1FeatureGroup> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1FeatureGroup.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists FeatureGroups in a given project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list
  /// FeatureGroups. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Lists the FeatureGroups that match the filter expression. The
  /// following fields are supported: * `create_time`: Supports `=`, `!=`, `<`,
  /// `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format. *
  /// `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
  /// Values must be in RFC 3339 format. * `labels`: Supports key-value equality
  /// and key presence. Examples: * `create_time > "2020-01-01" OR update_time >
  /// "2020-01-01"` FeatureGroups created or updated after 2020-01-01. *
  /// `labels.env = "prod"` FeatureGroups with label "env" set to "prod".
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// Fields: * `create_time` * `update_time`
  ///
  /// [pageSize] - The maximum number of FeatureGroups to return. The service
  /// may return fewer than this value. If unspecified, at most 100
  /// FeatureGroups will be returned. The maximum value is 100; any value
  /// greater than 100 will be coerced to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeatureGroupAdminService.ListFeatureGroups call. Provide this to retrieve
  /// the subsequent page. When paginating, all other parameters provided to
  /// FeatureGroupAdminService.ListFeatureGroups must match the call that
  /// provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeatureGroupsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeatureGroupsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featureGroups';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeatureGroupsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single FeatureGroup.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the FeatureGroup. Format:
  /// `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the FeatureGroup resource by the update. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask then only the non-empty fields present in the request will be
  /// overwritten. Set the update_mask to `*` to override all fields. Updatable
  /// fields: * `labels`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1FeatureGroup request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureGroupsFeaturesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureGroupsFeaturesOperationsResource get operations =>
      ProjectsLocationsFeatureGroupsFeaturesOperationsResource(_requester);

  ProjectsLocationsFeatureGroupsFeaturesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a new Feature in a given FeatureGroup.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the EntityType or FeatureGroup
  /// to create a Feature. Format for entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+$`.
  ///
  /// [featureId] - Required. The ID to use for the Feature, which will become
  /// the final component of the Feature's resource name. This value may be up
  /// to 128 characters, and valid characters are `[a-z0-9_]`. The first
  /// character cannot be a number. The value must be unique within an
  /// EntityType/FeatureGroup.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Feature request,
    core.String parent, {
    core.String? featureId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (featureId != null) 'featureId': [featureId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/features';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single Feature.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Features to be deleted. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single Feature.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Feature resource. Format for
  /// entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Feature].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Feature> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Feature.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Features in a given FeatureGroup.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list Features.
  /// Format for entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+$`.
  ///
  /// [filter] - Lists the Features that match the filter expression. The
  /// following filters are supported: * `value_type`: Supports = and !=
  /// comparisons. * `create_time`: Supports =, !=, \<, \>, \>=, and \<=
  /// comparisons. Values must be in RFC 3339 format. * `update_time`: Supports
  /// =, !=, \<, \>, \>=, and \<= comparisons. Values must be in RFC 3339
  /// format. * `labels`: Supports key-value equality as well as key presence.
  /// Examples: * `value_type = DOUBLE` --\> Features whose type is DOUBLE. *
  /// `create_time > \"2020-01-31T15:30:00.000000Z\" OR update_time >
  /// \"2020-01-31T15:30:00.000000Z\"` --\> EntityTypes created or updated after
  /// 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env = prod`
  /// --\> Features having both (active: yes) and (env: prod) labels. *
  /// `labels.env: *` --\> Any Feature which has a label with 'env' as the key.
  ///
  /// [latestStatsCount] - Only applicable for Vertex AI Feature Store (Legacy).
  /// If set, return the most recent ListFeaturesRequest.latest_stats_count of
  /// stats for each Feature in response. Valid value is \[0, 10\]. If number of
  /// stats exists \< ListFeaturesRequest.latest_stats_count, return all
  /// existing stats.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `feature_id` * `value_type` (Not supported for FeatureRegistry
  /// Feature) * `create_time` * `update_time`
  ///
  /// [pageSize] - The maximum number of Features to return. The service may
  /// return fewer than this value. If unspecified, at most 1000 Features will
  /// be returned. The maximum value is 1000; any value greater than 1000 will
  /// be coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeaturestoreService.ListFeatures call or
  /// FeatureRegistryService.ListFeatures call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// FeaturestoreService.ListFeatures or or FeatureRegistryService.ListFeatures
  /// must match the call that provided the page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeaturesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeaturesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? latestStatsCount,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (latestStatsCount != null) 'latestStatsCount': ['${latestStatsCount}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/features';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeaturesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single Feature.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Immutable. Name of the Feature. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
  /// The last part feature is assigned by the client. The feature can be up to
  /// 64 characters long and can consist only of ASCII Latin letters A-Z and
  /// a-z, underscore(_), and ASCII digits 0-9 starting with a letter. The value
  /// will be unique given an entity type.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the Features resource by the update. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask then only the non-empty fields present in the request will be
  /// overwritten. Set the update_mask to `*` to override all fields. Updatable
  /// fields: * `description` * `labels` * `disable_monitoring` (Not supported
  /// for FeatureRegistry Feature)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1Feature request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureGroupsFeaturesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureGroupsFeaturesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> listWait(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureGroupsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureGroupsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> listWait(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureGroups/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureOnlineStoresResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureOnlineStoresFeatureViewsResource get featureViews =>
      ProjectsLocationsFeatureOnlineStoresFeatureViewsResource(_requester);
  ProjectsLocationsFeatureOnlineStoresOperationsResource get operations =>
      ProjectsLocationsFeatureOnlineStoresOperationsResource(_requester);

  ProjectsLocationsFeatureOnlineStoresResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a new FeatureOnlineStore in a given project and location.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create
  /// FeatureOnlineStores. Format: `projects/{project}/locations/{location}'`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [featureOnlineStoreId] - Required. The ID to use for this
  /// FeatureOnlineStore, which will become the final component of the
  /// FeatureOnlineStore's resource name. This value may be up to 60 characters,
  /// and valid characters are `[a-z0-9_]`. The first character cannot be a
  /// number. The value must be unique within the project and location.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1FeatureOnlineStore request,
    core.String parent, {
    core.String? featureOnlineStoreId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (featureOnlineStoreId != null)
        'featureOnlineStoreId': [featureOnlineStoreId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/featureOnlineStores';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single FeatureOnlineStore.
  ///
  /// The FeatureOnlineStore must not contain any FeatureViews.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureOnlineStore to be deleted.
  /// Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+$`.
  ///
  /// [force] - If set to true, any FeatureViews and Features for this
  /// FeatureOnlineStore will also be deleted. (Otherwise, the request will only
  /// work if the FeatureOnlineStore has no FeatureViews.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single FeatureOnlineStore.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureOnlineStore resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1FeatureOnlineStore].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1FeatureOnlineStore> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1FeatureOnlineStore.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists FeatureOnlineStores in a given project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list
  /// FeatureOnlineStores. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Lists the FeatureOnlineStores that match the filter expression.
  /// The following fields are supported: * `create_time`: Supports `=`, `!=`,
  /// `<`, `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format. *
  /// `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
  /// Values must be in RFC 3339 format. * `labels`: Supports key-value equality
  /// and key presence. Examples: * `create_time > "2020-01-01" OR update_time >
  /// "2020-01-01"` FeatureOnlineStores created or updated after 2020-01-01. *
  /// `labels.env = "prod"` FeatureOnlineStores with label "env" set to "prod".
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// Fields: * `create_time` * `update_time`
  ///
  /// [pageSize] - The maximum number of FeatureOnlineStores to return. The
  /// service may return fewer than this value. If unspecified, at most 100
  /// FeatureOnlineStores will be returned. The maximum value is 100; any value
  /// greater than 100 will be coerced to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeatureOnlineStoreAdminService.ListFeatureOnlineStores call. Provide this
  /// to retrieve the subsequent page. When paginating, all other parameters
  /// provided to FeatureOnlineStoreAdminService.ListFeatureOnlineStores must
  /// match the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/featureOnlineStores';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeatureOnlineStoresResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single FeatureOnlineStore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the FeatureOnlineStore. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the FeatureOnlineStore resource by the update. The fields specified in
  /// the update_mask are relative to the resource, not the full request. A
  /// field will be overwritten if it is in the mask. If the user does not
  /// provide a mask then only the non-empty fields present in the request will
  /// be overwritten. Set the update_mask to `*` to override all fields.
  /// Updatable fields: * `big_query_source` * `labels` * `sync_config`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1FeatureOnlineStore request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureOnlineStoresFeatureViewsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsResource
      get featureViewSyncs =>
          ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsResource(
              _requester);
  ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsResource
      get operations =>
          ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsResource(
              _requester);

  ProjectsLocationsFeatureOnlineStoresFeatureViewsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Creates a new FeatureView in a given FeatureOnlineStore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the FeatureOnlineStore to create
  /// FeatureViews. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+$`.
  ///
  /// [featureViewId] - Required. The ID to use for the FeatureView, which will
  /// become the final component of the FeatureView's resource name. This value
  /// may be up to 60 characters, and valid characters are `[a-z0-9_]`. The
  /// first character cannot be a number. The value must be unique within a
  /// FeatureOnlineStore.
  ///
  /// [runSyncImmediately] - Immutable. If set to true, one on demand sync will
  /// be run immediately, regardless whether the FeatureView.sync_config is
  /// configured or not.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1FeatureView request,
    core.String parent, {
    core.String? featureViewId,
    core.bool? runSyncImmediately,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (featureViewId != null) 'featureViewId': [featureViewId],
      if (runSyncImmediately != null)
        'runSyncImmediately': ['${runSyncImmediately}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featureViews';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single FeatureView.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureView to be deleted. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Fetch feature values under a FeatureView.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [featureView] - Required. FeatureView resource format
  /// `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineStore}/featureViews/{featureView}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1FetchFeatureValuesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1FetchFeatureValuesResponse>
      fetchFeatureValues(
    GoogleCloudAiplatformV1FetchFeatureValuesRequest request,
    core.String featureView, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$featureView') + ':fetchFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1FetchFeatureValuesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single FeatureView.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureView resource. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1FeatureView].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1FeatureView> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1FeatureView.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists FeatureViews in a given FeatureOnlineStore.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the FeatureOnlineStore to list
  /// FeatureViews. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+$`.
  ///
  /// [filter] - Lists the FeatureViews that match the filter expression. The
  /// following filters are supported: * `create_time`: Supports `=`, `!=`, `<`,
  /// `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format. *
  /// `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
  /// Values must be in RFC 3339 format. * `labels`: Supports key-value equality
  /// as well as key presence. Examples: * `create_time >
  /// \"2020-01-31T15:30:00.000000Z\" OR update_time >
  /// \"2020-01-31T15:30:00.000000Z\"` --\> FeatureViews created or updated
  /// after 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env =
  /// prod` --\> FeatureViews having both (active: yes) and (env: prod) labels.
  /// * `labels.env: *` --\> Any FeatureView which has a label with 'env' as the
  /// key.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `feature_view_id` * `create_time` * `update_time`
  ///
  /// [pageSize] - The maximum number of FeatureViews to return. The service may
  /// return fewer than this value. If unspecified, at most 1000 FeatureViews
  /// will be returned. The maximum value is 1000; any value greater than 1000
  /// will be coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeatureOnlineStoreAdminService.ListFeatureViews call. Provide this to
  /// retrieve the subsequent page. When paginating, all other parameters
  /// provided to FeatureOnlineStoreAdminService.ListFeatureViews must match the
  /// call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeatureViewsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeatureViewsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featureViews';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeatureViewsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single FeatureView.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the FeatureView. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the FeatureView resource by the update. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask then only the non-empty fields present in the request will be
  /// overwritten. Set the update_mask to `*` to override all fields. Updatable
  /// fields: * `labels`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1FeatureView request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Triggers on-demand sync for the FeatureView.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [featureView] - Required. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1SyncFeatureViewResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1SyncFeatureViewResponse> sync(
    GoogleCloudAiplatformV1SyncFeatureViewRequest request,
    core.String featureView, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$featureView') + ':sync';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1SyncFeatureViewResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Gets details of a single FeatureViewSync.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the FeatureViewSync resource. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+/featureViewSyncs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1FeatureViewSync].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1FeatureViewSync> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1FeatureViewSync.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists FeatureViewSyncs in a given FeatureView.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the FeatureView to list
  /// FeatureViewSyncs. Format:
  /// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+$`.
  ///
  /// [filter] - Lists the FeatureViewSyncs that match the filter expression.
  /// The following filters are supported: * `create_time`: Supports `=`, `!=`,
  /// `<`, `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format.
  /// Examples: * `create_time > \"2020-01-31T15:30:00.000000Z\"` --\>
  /// FeatureViewSyncs created after 2020-01-31T15:30:00.000000Z.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `create_time`
  ///
  /// [pageSize] - The maximum number of FeatureViewSyncs to return. The service
  /// may return fewer than this value. If unspecified, at most 1000
  /// FeatureViewSyncs will be returned. The maximum value is 1000; any value
  /// greater than 1000 will be coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeatureOnlineStoreAdminService.ListFeatureViewSyncs call. Provide this to
  /// retrieve the subsequent page. When paginating, all other parameters
  /// provided to FeatureOnlineStoreAdminService.ListFeatureViewSyncs must match
  /// the call that provided the page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeatureViewSyncsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeatureViewSyncsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featureViewSyncs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeatureViewSyncsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> listWait(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/featureViews/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeatureOnlineStoresOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeatureOnlineStoresOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> listWait(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featureOnlineStores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeaturestoresResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeaturestoresEntityTypesResource get entityTypes =>
      ProjectsLocationsFeaturestoresEntityTypesResource(_requester);
  ProjectsLocationsFeaturestoresOperationsResource get operations =>
      ProjectsLocationsFeaturestoresOperationsResource(_requester);

  ProjectsLocationsFeaturestoresResource(commons.ApiRequester client)
      : _requester = client;

  /// Batch reads Feature values from a Featurestore.
  ///
  /// This API enables batch reading Feature values, where each read instance in
  /// the batch may read Feature values of entities from one or more
  /// EntityTypes. Point-in-time correctness is guaranteed for Feature values of
  /// each read instance as of each instance's read timestamp.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [featurestore] - Required. The resource name of the Featurestore from
  /// which to query Feature values. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> batchReadFeatureValues(
    GoogleCloudAiplatformV1BatchReadFeatureValuesRequest request,
    core.String featurestore, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$featurestore') +
        ':batchReadFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a new Featurestore in a given project and location.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create
  /// Featurestores. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [featurestoreId] - Required. The ID to use for this Featurestore, which
  /// will become the final component of the Featurestore's resource name. This
  /// value may be up to 60 characters, and valid characters are `[a-z0-9_]`.
  /// The first character cannot be a number. The value must be unique within
  /// the project and location.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Featurestore request,
    core.String parent, {
    core.String? featurestoreId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (featurestoreId != null) 'featurestoreId': [featurestoreId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featurestores';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single Featurestore.
  ///
  /// The Featurestore must not contain any EntityTypes or `force` must be set
  /// to true for the request to succeed.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Featurestore to be deleted. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [force] - If set to true, any EntityTypes and Features for this
  /// Featurestore will also be deleted. (Otherwise, the request will only work
  /// if the Featurestore has no EntityTypes.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single Featurestore.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Featurestore resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Featurestore].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Featurestore> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Featurestore.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy. Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected. Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset. The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1. To learn which resources support
  /// conditions in their IAM policies, see the
  /// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Featurestores in a given project and location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list
  /// Featurestores. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Lists the featurestores that match the filter expression. The
  /// following fields are supported: * `create_time`: Supports `=`, `!=`, `<`,
  /// `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format. *
  /// `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
  /// Values must be in RFC 3339 format. *
  /// `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
  /// `<=`, and `>=` comparisons. * `labels`: Supports key-value equality and
  /// key presence. Examples: * `create_time > "2020-01-01" OR update_time >
  /// "2020-01-01"` Featurestores created or updated after 2020-01-01. *
  /// `labels.env = "prod"` Featurestores with label "env" set to "prod".
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// Fields: * `create_time` * `update_time` *
  /// `online_serving_config.fixed_node_count`
  ///
  /// [pageSize] - The maximum number of Featurestores to return. The service
  /// may return fewer than this value. If unspecified, at most 100
  /// Featurestores will be returned. The maximum value is 100; any value
  /// greater than 100 will be coerced to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeaturestoreService.ListFeaturestores call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// FeaturestoreService.ListFeaturestores must match the call that provided
  /// the page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeaturestoresResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeaturestoresResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/featurestores';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeaturestoresResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single Featurestore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the Featurestore. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the Featurestore resource by the update. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask then only the non-empty fields present in the request will be
  /// overwritten. Set the update_mask to `*` to override all fields. Updatable
  /// fields: * `labels` * `online_serving_config.fixed_node_count` *
  /// `online_serving_config.scaling` * `online_storage_ttl_days`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1Featurestore request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Searches Features matching a query in a given project.
  ///
  /// Request parameters:
  ///
  /// [location] - Required. The resource name of the Location to search
  /// Features. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [pageSize] - The maximum number of Features to return. The service may
  /// return fewer than this value. If unspecified, at most 100 Features will be
  /// returned. The maximum value is 100; any value greater than 100 will be
  /// coerced to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeaturestoreService.SearchFeatures call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// FeaturestoreService.SearchFeatures, except `page_size`, must match the
  /// call that provided the page token.
  ///
  /// [query] - Query string that is a conjunction of field-restricted queries
  /// and/or field-restricted filters. Field-restricted queries and filters can
  /// be combined using `AND` to form a conjunction. A field query is in the
  /// form FIELD:QUERY. This implicitly checks if QUERY exists as a substring
  /// within Feature's FIELD. The QUERY and the FIELD are converted to a
  /// sequence of words (i.e. tokens) for comparison. This is done by: *
  /// Removing leading/trailing whitespace and tokenizing the search value.
  /// Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore `_`,
  /// or asterisk `*` are treated as delimiters for tokens. `*` is treated as a
  /// wildcard that matches characters within a token. * Ignoring case. *
  /// Prepending an asterisk to the first and appending an asterisk to the last
  /// token in QUERY. A QUERY must be either a singular token or a phrase. A
  /// phrase is one or multiple words enclosed in double quotation marks (").
  /// With phrases, the order of the words is important. Words in the phrase
  /// must be matching in order and consecutively. Supported FIELDs for
  /// field-restricted queries: * `feature_id` * `description` *
  /// `entity_type_id` Examples: * `feature_id: foo` --\> Matches a Feature with
  /// ID containing the substring `foo` (eg. `foo`, `foofeature`, `barfoo`). *
  /// `feature_id: foo*feature` --\> Matches a Feature with ID containing the
  /// substring `foo*feature` (eg. `foobarfeature`). * `feature_id: foo AND
  /// description: bar` --\> Matches a Feature with ID containing the substring
  /// `foo` and description containing the substring `bar`. Besides field
  /// queries, the following exact-match filters are supported. The exact-match
  /// filters do not support wildcards. Unlike field-restricted queries,
  /// exact-match filters are case-sensitive. * `feature_id`: Supports =
  /// comparisons. * `description`: Supports = comparisons. Multi-token filters
  /// should be enclosed in quotes. * `entity_type_id`: Supports = comparisons.
  /// * `value_type`: Supports = and != comparisons. * `labels`: Supports
  /// key-value equality as well as key presence. * `featurestore_id`: Supports
  /// = comparisons. Examples: * `description = "foo bar"` --\> Any Feature with
  /// description exactly equal to `foo bar` * `value_type = DOUBLE` --\>
  /// Features whose type is DOUBLE. * `labels.active = yes AND labels.env =
  /// prod` --\> Features having both (active: yes) and (env: prod) labels. *
  /// `labels.env: *` --\> Any Feature which has a label with `env` as the key.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1SearchFeaturesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1SearchFeaturesResponse> searchFeatures(
    core.String location, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? query,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (query != null) 'query': [query],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$location') +
        '/featurestores:searchFeatures';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1SearchFeaturesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
  /// and `PERMISSION_DENIED` errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error. Note: This operation is designed to
  /// be used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [permissions] - The set of permissions to check for the `resource`.
  /// Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
  /// For more information see
  /// [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    core.String resource, {
    core.List<core.String>? permissions,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (permissions != null) 'permissions': permissions,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeaturestoresEntityTypesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeaturestoresEntityTypesFeaturesResource get features =>
      ProjectsLocationsFeaturestoresEntityTypesFeaturesResource(_requester);
  ProjectsLocationsFeaturestoresEntityTypesOperationsResource get operations =>
      ProjectsLocationsFeaturestoresEntityTypesOperationsResource(_requester);

  ProjectsLocationsFeaturestoresEntityTypesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a new EntityType in a given Featurestore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Featurestore to create
  /// EntityTypes. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [entityTypeId] - Required. The ID to use for the EntityType, which will
  /// become the final component of the EntityType's resource name. This value
  /// may be up to 60 characters, and valid characters are `[a-z0-9_]`. The
  /// first character cannot be a number. The value must be unique within a
  /// featurestore.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1EntityType request,
    core.String parent, {
    core.String? entityTypeId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (entityTypeId != null) 'entityTypeId': [entityTypeId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entityTypes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single EntityType.
  ///
  /// The EntityType must not have any Features or `force` must be set to true
  /// for the request to succeed.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the EntityType to be deleted. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [force] - If set to true, any Features for this EntityType will also be
  /// deleted. (Otherwise, the request will only work if the EntityType has no
  /// Features.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Delete Feature values from Featurestore.
  ///
  /// The progress of the deletion is tracked by the returned operation. The
  /// deleted feature values are guaranteed to be invisible to subsequent read
  /// operations after the operation is marked as successfully done. If a delete
  /// feature values operation fails, the feature values returned from reads and
  /// exports may be inconsistent. If consistency is required, the caller must
  /// retry the same delete request again and wait till the new operation
  /// returned is marked as successfully done.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [entityType] - Required. The resource name of the EntityType grouping the
  /// Features for which values are being deleted from. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> deleteFeatureValues(
    GoogleCloudAiplatformV1DeleteFeatureValuesRequest request,
    core.String entityType, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$entityType') + ':deleteFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Exports Feature values from all the entities of a target EntityType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [entityType] - Required. The resource name of the EntityType from which to
  /// export Feature values. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> exportFeatureValues(
    GoogleCloudAiplatformV1ExportFeatureValuesRequest request,
    core.String entityType, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$entityType') + ':exportFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single EntityType.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the EntityType resource. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1EntityType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1EntityType> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1EntityType.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy. Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected. Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset. The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1. To learn which resources support
  /// conditions in their IAM policies, see the
  /// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Imports Feature values into the Featurestore from a source storage.
  ///
  /// The progress of the import is tracked by the returned operation. The
  /// imported features are guaranteed to be visible to subsequent read
  /// operations after the operation is marked as successfully done. If an
  /// import operation fails, the Feature values returned from reads and exports
  /// may be inconsistent. If consistency is required, the caller must retry the
  /// same import request again and wait till the new operation returned is
  /// marked as successfully done. There are also scenarios where the caller can
  /// cause inconsistency. - Source data for import contains multiple distinct
  /// Feature values for the same entity ID and timestamp. - Source is modified
  /// during an import. This includes adding, updating, or removing source data
  /// and/or metadata. Examples of updating metadata include but are not limited
  /// to changing storage location, storage class, or retention policy. - Online
  /// serving cluster is under-provisioned.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [entityType] - Required. The resource name of the EntityType grouping the
  /// Features for which values are being imported. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> importFeatureValues(
    GoogleCloudAiplatformV1ImportFeatureValuesRequest request,
    core.String entityType, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$entityType') + ':importFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists EntityTypes in a given Featurestore.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Featurestore to list
  /// EntityTypes. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [filter] - Lists the EntityTypes that match the filter expression. The
  /// following filters are supported: * `create_time`: Supports `=`, `!=`, `<`,
  /// `>`, `>=`, and `<=` comparisons. Values must be in RFC 3339 format. *
  /// `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
  /// Values must be in RFC 3339 format. * `labels`: Supports key-value equality
  /// as well as key presence. Examples: * `create_time >
  /// \"2020-01-31T15:30:00.000000Z\" OR update_time >
  /// \"2020-01-31T15:30:00.000000Z\"` --\> EntityTypes created or updated after
  /// 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env = prod`
  /// --\> EntityTypes having both (active: yes) and (env: prod) labels. *
  /// `labels.env: *` --\> Any EntityType which has a label with 'env' as the
  /// key.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `entity_type_id` * `create_time` * `update_time`
  ///
  /// [pageSize] - The maximum number of EntityTypes to return. The service may
  /// return fewer than this value. If unspecified, at most 1000 EntityTypes
  /// will be returned. The maximum value is 1000; any value greater than 1000
  /// will be coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeaturestoreService.ListEntityTypes call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// FeaturestoreService.ListEntityTypes must match the call that provided the
  /// page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListEntityTypesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListEntityTypesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/entityTypes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListEntityTypesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single EntityType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Immutable. Name of the EntityType. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// The last part entity_type is assigned by the client. The entity_type can
  /// be up to 64 characters long and can consist only of ASCII Latin letters
  /// A-Z and a-z and underscore(_), and ASCII digits 0-9 starting with a
  /// letter. The value will be unique given a featurestore.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the EntityType resource by the update. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask then only the non-empty fields present in the request will be
  /// overwritten. Set the update_mask to `*` to override all fields. Updatable
  /// fields: * `description` * `labels` *
  /// `monitoring_config.snapshot_analysis.disabled` *
  /// `monitoring_config.snapshot_analysis.monitoring_interval_days` *
  /// `monitoring_config.snapshot_analysis.staleness_days` *
  /// `monitoring_config.import_features_analysis.state` *
  /// `monitoring_config.import_features_analysis.anomaly_detection_baseline` *
  /// `monitoring_config.numerical_threshold_config.value` *
  /// `monitoring_config.categorical_threshold_config.value` *
  /// `offline_storage_ttl_days`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1EntityType].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1EntityType> patch(
    GoogleCloudAiplatformV1EntityType request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1EntityType.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Reads Feature values of a specific entity of an EntityType.
  ///
  /// For reading feature values of multiple entities of an EntityType, please
  /// use StreamingReadFeatureValues.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [entityType] - Required. The resource name of the EntityType for the
  /// entity being read. Value format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
  /// For example, for a machine learning model predicting user clicks on a
  /// website, an EntityType ID could be `user`.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ReadFeatureValuesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadFeatureValuesResponse>
      readFeatureValues(
    GoogleCloudAiplatformV1ReadFeatureValuesRequest request,
    core.String entityType, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$entityType') + ':readFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadFeatureValuesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
  /// and `PERMISSION_DENIED` errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Reads Feature values for multiple entities.
  ///
  /// Depending on their size, data for different entities may be broken up
  /// across multiple responses.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [entityType] - Required. The resource name of the entities' type. Value
  /// format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
  /// For example, for a machine learning model predicting user clicks on a
  /// website, an EntityType ID could be `user`.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ReadFeatureValuesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadFeatureValuesResponse>
      streamingReadFeatureValues(
    GoogleCloudAiplatformV1StreamingReadFeatureValuesRequest request,
    core.String entityType, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$entityType') +
        ':streamingReadFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadFeatureValuesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error. Note: This operation is designed to
  /// be used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [permissions] - The set of permissions to check for the `resource`.
  /// Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
  /// For more information see
  /// [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    core.String resource, {
    core.List<core.String>? permissions,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (permissions != null) 'permissions': permissions,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Writes Feature values of one or more entities of an EntityType.
  ///
  /// The Feature values are merged into existing entities if any. The Feature
  /// values to be written must have timestamp within the online storage
  /// retention.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [entityType] - Required. The resource name of the EntityType for the
  /// entities being written. Value format:
  /// `projects/{project}/locations/{location}/featurestores/
  /// {featurestore}/entityTypes/{entityType}`. For example, for a machine
  /// learning model predicting user clicks on a website, an EntityType ID could
  /// be `user`.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1WriteFeatureValuesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1WriteFeatureValuesResponse>
      writeFeatureValues(
    GoogleCloudAiplatformV1WriteFeatureValuesRequest request,
    core.String entityType, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$entityType') + ':writeFeatureValues';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1WriteFeatureValuesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeaturestoresEntityTypesFeaturesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsResource
      get operations =>
          ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsResource(
              _requester);

  ProjectsLocationsFeaturestoresEntityTypesFeaturesResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Creates a batch of Features in a given EntityType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the EntityType to create the
  /// batch of Features under. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> batchCreate(
    GoogleCloudAiplatformV1BatchCreateFeaturesRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/features:batchCreate';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a new Feature in a given EntityType.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the EntityType or FeatureGroup
  /// to create a Feature. Format for entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [featureId] - Required. The ID to use for the Feature, which will become
  /// the final component of the Feature's resource name. This value may be up
  /// to 128 characters, and valid characters are `[a-z0-9_]`. The first
  /// character cannot be a number. The value must be unique within an
  /// EntityType/FeatureGroup.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Feature request,
    core.String parent, {
    core.String? featureId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (featureId != null) 'featureId': [featureId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/features';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single Feature.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Features to be deleted. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets details of a single Feature.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Feature resource. Format for
  /// entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Feature].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Feature> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Feature.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Features in a given EntityType.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list Features.
  /// Format for entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [filter] - Lists the Features that match the filter expression. The
  /// following filters are supported: * `value_type`: Supports = and !=
  /// comparisons. * `create_time`: Supports =, !=, \<, \>, \>=, and \<=
  /// comparisons. Values must be in RFC 3339 format. * `update_time`: Supports
  /// =, !=, \<, \>, \>=, and \<= comparisons. Values must be in RFC 3339
  /// format. * `labels`: Supports key-value equality as well as key presence.
  /// Examples: * `value_type = DOUBLE` --\> Features whose type is DOUBLE. *
  /// `create_time > \"2020-01-31T15:30:00.000000Z\" OR update_time >
  /// \"2020-01-31T15:30:00.000000Z\"` --\> EntityTypes created or updated after
  /// 2020-01-31T15:30:00.000000Z. * `labels.active = yes AND labels.env = prod`
  /// --\> Features having both (active: yes) and (env: prod) labels. *
  /// `labels.env: *` --\> Any Feature which has a label with 'env' as the key.
  ///
  /// [latestStatsCount] - Only applicable for Vertex AI Feature Store (Legacy).
  /// If set, return the most recent ListFeaturesRequest.latest_stats_count of
  /// stats for each Feature in response. Valid value is \[0, 10\]. If number of
  /// stats exists \< ListFeaturesRequest.latest_stats_count, return all
  /// existing stats.
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `feature_id` * `value_type` (Not supported for FeatureRegistry
  /// Feature) * `create_time` * `update_time`
  ///
  /// [pageSize] - The maximum number of Features to return. The service may
  /// return fewer than this value. If unspecified, at most 1000 Features will
  /// be returned. The maximum value is 1000; any value greater than 1000 will
  /// be coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// FeaturestoreService.ListFeatures call or
  /// FeatureRegistryService.ListFeatures call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// FeaturestoreService.ListFeatures or or FeatureRegistryService.ListFeatures
  /// must match the call that provided the page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListFeaturesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListFeaturesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? latestStatsCount,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (latestStatsCount != null) 'latestStatsCount': ['${latestStatsCount}'],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/features';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListFeaturesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates the parameters of a single Feature.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Immutable. Name of the Feature. Format:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
  /// The last part feature is assigned by the client. The feature can be up to
  /// 64 characters long and can consist only of ASCII Latin letters A-Z and
  /// a-z, underscore(_), and ASCII digits 0-9 starting with a letter. The value
  /// will be unique given an entity type.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [updateMask] - Field mask is used to specify the fields to be overwritten
  /// in the Features resource by the update. The fields specified in the
  /// update_mask are relative to the resource, not the full request. A field
  /// will be overwritten if it is in the mask. If the user does not provide a
  /// mask then only the non-empty fields present in the request will be
  /// overwritten. Set the update_mask to `*` to override all fields. Updatable
  /// fields: * `description` * `labels` * `disable_monitoring` (Not supported
  /// for FeatureRegistry Feature)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Feature].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Feature> patch(
    GoogleCloudAiplatformV1Feature request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Feature.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/features/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeaturestoresEntityTypesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeaturestoresEntityTypesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/entityTypes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsFeaturestoresOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsFeaturestoresOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/featurestores/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsHyperparameterTuningJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsHyperparameterTuningJobsOperationsResource get operations =>
      ProjectsLocationsHyperparameterTuningJobsOperationsResource(_requester);

  ProjectsLocationsHyperparameterTuningJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a HyperparameterTuningJob.
  ///
  /// Starts asynchronous cancellation on the HyperparameterTuningJob. The
  /// server makes a best effort to cancel the job, but success is not
  /// guaranteed. Clients can use JobService.GetHyperparameterTuningJob or other
  /// methods to check whether the cancellation succeeded or whether the job
  /// completed despite cancellation. On successful cancellation, the
  /// HyperparameterTuningJob is not deleted; instead it becomes a job with a
  /// HyperparameterTuningJob.error value with a google.rpc.Status.code of 1,
  /// corresponding to `Code.CANCELLED`, and HyperparameterTuningJob.state is
  /// set to `CANCELLED`.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the HyperparameterTuningJob to cancel.
  /// Format:
  /// `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a HyperparameterTuningJob
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// HyperparameterTuningJob in. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1HyperparameterTuningJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1HyperparameterTuningJob> create(
    GoogleCloudAiplatformV1HyperparameterTuningJob request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/hyperparameterTuningJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1HyperparameterTuningJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a HyperparameterTuningJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the HyperparameterTuningJob resource to be
  /// deleted. Format:
  /// `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a HyperparameterTuningJob
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the HyperparameterTuningJob resource.
  /// Format:
  /// `projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1HyperparameterTuningJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1HyperparameterTuningJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1HyperparameterTuningJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists HyperparameterTuningJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the
  /// HyperparameterTuningJobs from. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"\` *
  /// \`state!="JOB_STATE_FAILED" OR display_name="my_job"\` * \`NOT
  /// display_name="my_job"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`labels.keyA=valueA\` * \`labels.keyB:*\`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListHyperparameterTuningJobsResponse.next_page_token of the previous
  /// JobService.ListHyperparameterTuningJobs call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse>
      list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/hyperparameterTuningJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListHyperparameterTuningJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsHyperparameterTuningJobsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsHyperparameterTuningJobsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/hyperparameterTuningJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsIndexEndpointsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsIndexEndpointsOperationsResource get operations =>
      ProjectsLocationsIndexEndpointsOperationsResource(_requester);

  ProjectsLocationsIndexEndpointsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an IndexEndpoint.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// IndexEndpoint in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1IndexEndpoint request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/indexEndpoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an IndexEndpoint.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the IndexEndpoint resource to be deleted.
  /// Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deploys an Index into this IndexEndpoint, creating a DeployedIndex within
  /// it.
  ///
  /// Only non-empty Indexes can be deployed.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [indexEndpoint] - Required. The name of the IndexEndpoint resource into
  /// which to deploy an Index. Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> deployIndex(
    GoogleCloudAiplatformV1DeployIndexRequest request,
    core.String indexEndpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$indexEndpoint') + ':deployIndex';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Finds the nearest neighbors of each vector within the request.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [indexEndpoint] - Required. The name of the index endpoint. Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1FindNeighborsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1FindNeighborsResponse> findNeighbors(
    GoogleCloudAiplatformV1FindNeighborsRequest request,
    core.String indexEndpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$indexEndpoint') + ':findNeighbors';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1FindNeighborsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an IndexEndpoint.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the IndexEndpoint resource. Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1IndexEndpoint].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1IndexEndpoint> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1IndexEndpoint.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists IndexEndpoints in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location from which to list
  /// the IndexEndpoints. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. An expression for filtering the results of the
  /// request. For field names both snake_case and camelCase are supported. *
  /// `index_endpoint` supports = and !=. `index_endpoint` represents the
  /// IndexEndpoint ID, ie. the last segment of the IndexEndpoint's
  /// resourcename. * `display_name` supports =, != and regex() (uses
  /// [re2](https://github.com/google/re2/wiki/Syntax) syntax) * `labels`
  /// supports general map functions that is: `labels.key=value` - key:value
  /// equality `labels.key:* or labels:key - key existence A key including a
  /// space must be quoted. `labels."a key"`. Some examples: *
  /// `index_endpoint="1"` * `display_name="myDisplayName"` *
  /// `regex(display_name, "^A") -\> The display name starts with an A. *
  /// `labels.myKey="myValue"`
  ///
  /// [pageSize] - Optional. The standard list page size.
  ///
  /// [pageToken] - Optional. The standard list page token. Typically obtained
  /// via ListIndexEndpointsResponse.next_page_token of the previous
  /// IndexEndpointService.ListIndexEndpoints call.
  ///
  /// [readMask] - Optional. Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListIndexEndpointsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListIndexEndpointsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/indexEndpoints';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListIndexEndpointsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Update an existing DeployedIndex under an IndexEndpoint.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [indexEndpoint] - Required. The name of the IndexEndpoint resource into
  /// which to deploy an Index. Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> mutateDeployedIndex(
    GoogleCloudAiplatformV1DeployedIndex request,
    core.String indexEndpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$indexEndpoint') + ':mutateDeployedIndex';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an IndexEndpoint.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the IndexEndpoint.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask applies to the resource. See
  /// google.protobuf.FieldMask.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1IndexEndpoint].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1IndexEndpoint> patch(
    GoogleCloudAiplatformV1IndexEndpoint request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1IndexEndpoint.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Reads the datapoints/vectors of the given IDs.
  ///
  /// A maximum of 1000 datapoints can be retrieved in a batch.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [indexEndpoint] - Required. The name of the index endpoint. Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ReadIndexDatapointsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadIndexDatapointsResponse>
      readIndexDatapoints(
    GoogleCloudAiplatformV1ReadIndexDatapointsRequest request,
    core.String indexEndpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$indexEndpoint') + ':readIndexDatapoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadIndexDatapointsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Undeploys an Index from an IndexEndpoint, removing a DeployedIndex from
  /// it, and freeing all resources it's using.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [indexEndpoint] - Required. The name of the IndexEndpoint resource from
  /// which to undeploy an Index. Format:
  /// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> undeployIndex(
    GoogleCloudAiplatformV1UndeployIndexRequest request,
    core.String indexEndpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$indexEndpoint') + ':undeployIndex';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsIndexEndpointsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsIndexEndpointsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexEndpoints/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsIndexesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsIndexesOperationsResource get operations =>
      ProjectsLocationsIndexesOperationsResource(_requester);

  ProjectsLocationsIndexesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an Index.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the Index
  /// in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Index request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/indexes';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an Index.
  ///
  /// An Index can only be deleted when all its DeployedIndexes had been
  /// undeployed.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Index resource to be deleted. Format:
  /// `projects/{project}/locations/{location}/indexes/{index}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets an Index.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Index resource. Format:
  /// `projects/{project}/locations/{location}/indexes/{index}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Index].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Index> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Index.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Indexes in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location from which to list
  /// the Indexes. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListIndexesResponse.next_page_token of the previous
  /// IndexService.ListIndexes call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListIndexesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListIndexesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/indexes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListIndexesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an Index.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the Index.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+$`.
  ///
  /// [updateMask] - The update mask applies to the resource. For the
  /// `FieldMask` definition, see google.protobuf.FieldMask.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1Index request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Remove Datapoints from an Index.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [index] - Required. The name of the Index resource to be updated. Format:
  /// `projects/{project}/locations/{location}/indexes/{index}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1RemoveDatapointsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1RemoveDatapointsResponse>
      removeDatapoints(
    GoogleCloudAiplatformV1RemoveDatapointsRequest request,
    core.String index, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$index') + ':removeDatapoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1RemoveDatapointsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Add/update Datapoints into an Index.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [index] - Required. The name of the Index resource to be updated. Format:
  /// `projects/{project}/locations/{location}/indexes/{index}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1UpsertDatapointsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1UpsertDatapointsResponse>
      upsertDatapoints(
    GoogleCloudAiplatformV1UpsertDatapointsRequest request,
    core.String index, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$index') + ':upsertDatapoints';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1UpsertDatapointsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsIndexesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsIndexesOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/indexes/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMetadataStoresResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMetadataStoresArtifactsResource get artifacts =>
      ProjectsLocationsMetadataStoresArtifactsResource(_requester);
  ProjectsLocationsMetadataStoresContextsResource get contexts =>
      ProjectsLocationsMetadataStoresContextsResource(_requester);
  ProjectsLocationsMetadataStoresExecutionsResource get executions =>
      ProjectsLocationsMetadataStoresExecutionsResource(_requester);
  ProjectsLocationsMetadataStoresMetadataSchemasResource get metadataSchemas =>
      ProjectsLocationsMetadataStoresMetadataSchemasResource(_requester);

  ProjectsLocationsMetadataStoresResource(commons.ApiRequester client)
      : _requester = client;

  /// Initializes a MetadataStore, including allocation of resources.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location where the
  /// MetadataStore should be created. Format:
  /// `projects/{project}/locations/{location}/`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [metadataStoreId] - The {metadatastore} portion of the resource name with
  /// the format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// If not provided, the MetadataStore's ID will be a UUID generated by the
  /// service. Must be 4-128 characters in length. Valid characters are
  /// `/a-z-/`. Must be unique across all MetadataStores in the parent Location.
  /// (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
  /// if the caller can't view the preexisting MetadataStore.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1MetadataStore request,
    core.String parent, {
    core.String? metadataStoreId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (metadataStoreId != null) 'metadataStoreId': [metadataStoreId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/metadataStores';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a single MetadataStore and all its child resources (Artifacts,
  /// Executions, and Contexts).
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the MetadataStore to delete.
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [force] - Deprecated: Field is no longer supported.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a specific MetadataStore.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the MetadataStore to retrieve.
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1MetadataStore].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1MetadataStore> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1MetadataStore.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists MetadataStores for a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The Location whose MetadataStores should be listed.
  /// Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [pageSize] - The maximum number of Metadata Stores to return. The service
  /// may return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// MetadataService.ListMetadataStores call. Provide this to retrieve the
  /// subsequent page. When paginating, all other provided parameters must match
  /// the call that provided the page token. (Otherwise the request will fail
  /// with INVALID_ARGUMENT error.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListMetadataStoresResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListMetadataStoresResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/metadataStores';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListMetadataStoresResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMetadataStoresArtifactsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMetadataStoresArtifactsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates an Artifact associated with a MetadataStore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the MetadataStore where the
  /// Artifact should be created. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [artifactId] - The {artifact} portion of the resource name with the
  /// format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// If not provided, the Artifact's ID will be a UUID generated by the
  /// service. Must be 4-128 characters in length. Valid characters are
  /// `/a-z-/`. Must be unique across all Artifacts in the parent MetadataStore.
  /// (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
  /// if the caller can't view the preexisting Artifact.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Artifact].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Artifact> create(
    GoogleCloudAiplatformV1Artifact request,
    core.String parent, {
    core.String? artifactId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (artifactId != null) 'artifactId': [artifactId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/artifacts';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Artifact.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an Artifact.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Artifact to delete. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/artifacts/\[^/\]+$`.
  ///
  /// [etag] - Optional. The etag of the Artifact to delete. If this is
  /// provided, it must match the server's etag. Otherwise, the request will
  /// fail with a FAILED_PRECONDITION.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a specific Artifact.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Artifact to retrieve. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/artifacts/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Artifact].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Artifact> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Artifact.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Artifacts in the MetadataStore.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The MetadataStore whose Artifacts should be listed.
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [filter] - Filter specifying the boolean condition for the Artifacts to
  /// satisfy in order to be part of the result set. The syntax to define filter
  /// query is based on https://google.aip.dev/160. The supported set of filters
  /// include the following: * **Attribute filtering**: For example:
  /// `display_name = "test"`. Supported fields include: `name`, `display_name`,
  /// `uri`, `state`, `schema_title`, `create_time`, and `update_time`. Time
  /// fields, such as `create_time` and `update_time`, require values specified
  /// in RFC-3339 format. For example: `create_time =
  /// "2020-11-19T11:30:00-04:00"` * **Metadata field**: To filter on metadata
  /// fields use traversal operation as follows: `metadata..`. For example:
  /// `metadata.field_1.number_value = 10.0` In case the field name contains
  /// special characters (such as colon), one can embed it inside double quote.
  /// For example: `metadata."field:1".number_value = 10.0` * **Context based
  /// filtering**: To filter Artifacts based on the contexts to which they
  /// belong, use the function operator with the full resource name
  /// `in_context()`. For example:
  /// `in_context("projects//locations//metadataStores//contexts/")` Each of the
  /// above supported filter types can be combined together using logical
  /// operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
  /// For example: `display_name = "test" AND metadata.field1.bool_value =
  /// true`.
  ///
  /// [orderBy] - How the list of messages is ordered. Specify the values to
  /// order by and an ordering operation. The default sorting order is
  /// ascending. To specify descending order for a field, users append a " desc"
  /// suffix; for example: "foo desc, bar". Subfields are specified with a `.`
  /// character, such as foo.bar. see https://google.aip.dev/132#ordering for
  /// more details.
  ///
  /// [pageSize] - The maximum number of Artifacts to return. The service may
  /// return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// MetadataService.ListArtifacts call. Provide this to retrieve the
  /// subsequent page. When paginating, all other provided parameters must match
  /// the call that provided the page token. (Otherwise the request will fail
  /// with INVALID_ARGUMENT error.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListArtifactsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListArtifactsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/artifacts';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListArtifactsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a stored Artifact.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the Artifact.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/artifacts/\[^/\]+$`.
  ///
  /// [allowMissing] - If set to true, and the Artifact is not found, a new
  /// Artifact is created.
  ///
  /// [updateMask] - Optional. A FieldMask indicating which fields should be
  /// updated.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Artifact].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Artifact> patch(
    GoogleCloudAiplatformV1Artifact request,
    core.String name, {
    core.bool? allowMissing,
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (allowMissing != null) 'allowMissing': ['${allowMissing}'],
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Artifact.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Purges Artifacts.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The metadata store to purge Artifacts from. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> purge(
    GoogleCloudAiplatformV1PurgeArtifactsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/artifacts:purge';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves lineage of an Artifact represented through Artifacts and
  /// Executions connected by Event edges and returned as a LineageSubgraph.
  ///
  /// Request parameters:
  ///
  /// [artifact] - Required. The resource name of the Artifact whose Lineage
  /// needs to be retrieved as a LineageSubgraph. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  /// The request may error with FAILED_PRECONDITION if the number of Artifacts,
  /// the number of Executions, or the number of Events that would be returned
  /// for the Context exceeds 1000.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/artifacts/\[^/\]+$`.
  ///
  /// [filter] - Filter specifying the boolean condition for the Artifacts to
  /// satisfy in order to be part of the Lineage Subgraph. The syntax to define
  /// filter query is based on https://google.aip.dev/160. The supported set of
  /// filters include the following: * **Attribute filtering**: For example:
  /// `display_name = "test"` Supported fields include: `name`, `display_name`,
  /// `uri`, `state`, `schema_title`, `create_time`, and `update_time`. Time
  /// fields, such as `create_time` and `update_time`, require values specified
  /// in RFC-3339 format. For example: `create_time =
  /// "2020-11-19T11:30:00-04:00"` * **Metadata field**: To filter on metadata
  /// fields use traversal operation as follows: `metadata..`. For example:
  /// `metadata.field_1.number_value = 10.0` In case the field name contains
  /// special characters (such as colon), one can embed it inside double quote.
  /// For example: `metadata."field:1".number_value = 10.0` Each of the above
  /// supported filter types can be combined together using logical operators
  /// (`AND` & `OR`). Maximum nested expression depth allowed is 5. For example:
  /// `display_name = "test" AND metadata.field1.bool_value = true`.
  ///
  /// [maxHops] - Specifies the size of the lineage graph in terms of number of
  /// hops from the specified artifact. Negative Value: INVALID_ARGUMENT error
  /// is returned 0: Only input artifact is returned. No value: Transitive
  /// closure is performed to return the complete graph.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1LineageSubgraph].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1LineageSubgraph>
      queryArtifactLineageSubgraph(
    core.String artifact, {
    core.String? filter,
    core.int? maxHops,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxHops != null) 'maxHops': ['${maxHops}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$artifact') +
        ':queryArtifactLineageSubgraph';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1LineageSubgraph.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMetadataStoresContextsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMetadataStoresContextsResource(commons.ApiRequester client)
      : _requester = client;

  /// Adds a set of Artifacts and Executions to a Context.
  ///
  /// If any of the Artifacts or Executions have already been added to a
  /// Context, they are simply skipped.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [context] - Required. The resource name of the Context that the Artifacts
  /// and Executions belong to. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse>
      addContextArtifactsAndExecutions(
    GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest request,
    core.String context, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$context') +
        ':addContextArtifactsAndExecutions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Adds a set of Contexts as children to a parent Context.
  ///
  /// If any of the child Contexts have already been added to the parent
  /// Context, they are simply skipped. If this call would create a cycle or
  /// cause any Context to have more than 10 parents, the request will fail with
  /// an INVALID_ARGUMENT error.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [context] - Required. The resource name of the parent Context. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1AddContextChildrenResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1AddContextChildrenResponse>
      addContextChildren(
    GoogleCloudAiplatformV1AddContextChildrenRequest request,
    core.String context, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$context') + ':addContextChildren';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1AddContextChildrenResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a Context associated with a MetadataStore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the MetadataStore where the
  /// Context should be created. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [contextId] - The {context} portion of the resource name with the format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`.
  /// If not provided, the Context's ID will be a UUID generated by the service.
  /// Must be 4-128 characters in length. Valid characters are `/a-z-/`. Must be
  /// unique across all Contexts in the parent MetadataStore. (Otherwise the
  /// request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the caller
  /// can't view the preexisting Context.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Context].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Context> create(
    GoogleCloudAiplatformV1Context request,
    core.String parent, {
    core.String? contextId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (contextId != null) 'contextId': [contextId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/contexts';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Context.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a stored Context.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Context to delete. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [etag] - Optional. The etag of the Context to delete. If this is provided,
  /// it must match the server's etag. Otherwise, the request will fail with a
  /// FAILED_PRECONDITION.
  ///
  /// [force] - The force deletion semantics is still undefined. Users should
  /// not use this field.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a specific Context.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Context to retrieve. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Context].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Context> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Context.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Contexts on the MetadataStore.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The MetadataStore whose Contexts should be listed.
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [filter] - Filter specifying the boolean condition for the Contexts to
  /// satisfy in order to be part of the result set. The syntax to define filter
  /// query is based on https://google.aip.dev/160. Following are the supported
  /// set of filters: * **Attribute filtering**: For example: `display_name =
  /// "test"`. Supported fields include: `name`, `display_name`, `schema_title`,
  /// `create_time`, and `update_time`. Time fields, such as `create_time` and
  /// `update_time`, require values specified in RFC-3339 format. For example:
  /// `create_time = "2020-11-19T11:30:00-04:00"`. * **Metadata field**: To
  /// filter on metadata fields use traversal operation as follows:
  /// `metadata..`. For example: `metadata.field_1.number_value = 10.0`. In case
  /// the field name contains special characters (such as colon), one can embed
  /// it inside double quote. For example: `metadata."field:1".number_value =
  /// 10.0` * **Parent Child filtering**: To filter Contexts based on
  /// parent-child relationship use the HAS operator as follows: ```
  /// parent_contexts: "projects//locations//metadataStores//contexts/"
  /// child_contexts: "projects//locations//metadataStores//contexts/" ``` Each
  /// of the above supported filters can be combined together using logical
  /// operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
  /// For example: `display_name = "test" AND metadata.field1.bool_value =
  /// true`.
  ///
  /// [orderBy] - How the list of messages is ordered. Specify the values to
  /// order by and an ordering operation. The default sorting order is
  /// ascending. To specify descending order for a field, users append a " desc"
  /// suffix; for example: "foo desc, bar". Subfields are specified with a `.`
  /// character, such as foo.bar. see https://google.aip.dev/132#ordering for
  /// more details.
  ///
  /// [pageSize] - The maximum number of Contexts to return. The service may
  /// return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// MetadataService.ListContexts call. Provide this to retrieve the subsequent
  /// page. When paginating, all other provided parameters must match the call
  /// that provided the page token. (Otherwise the request will fail with
  /// INVALID_ARGUMENT error.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListContextsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListContextsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/contexts';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListContextsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a stored Context.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Immutable. The resource name of the Context.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [allowMissing] - If set to true, and the Context is not found, a new
  /// Context is created.
  ///
  /// [updateMask] - Optional. A FieldMask indicating which fields should be
  /// updated.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Context].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Context> patch(
    GoogleCloudAiplatformV1Context request,
    core.String name, {
    core.bool? allowMissing,
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (allowMissing != null) 'allowMissing': ['${allowMissing}'],
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Context.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Purges Contexts.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The metadata store to purge Contexts from. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> purge(
    GoogleCloudAiplatformV1PurgeContextsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/contexts:purge';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves Artifacts and Executions within the specified Context, connected
  /// by Event edges and returned as a LineageSubgraph.
  ///
  /// Request parameters:
  ///
  /// [context] - Required. The resource name of the Context whose Artifacts and
  /// Executions should be retrieved as a LineageSubgraph. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// The request may error with FAILED_PRECONDITION if the number of Artifacts,
  /// the number of Executions, or the number of Events that would be returned
  /// for the Context exceeds 1000.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1LineageSubgraph].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1LineageSubgraph>
      queryContextLineageSubgraph(
    core.String context, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$context') +
        ':queryContextLineageSubgraph';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1LineageSubgraph.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Remove a set of children contexts from a parent Context.
  ///
  /// If any of the child Contexts were NOT added to the parent Context, they
  /// are simply skipped.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [context] - Required. The resource name of the parent Context. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/contexts/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1RemoveContextChildrenResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1RemoveContextChildrenResponse>
      removeContextChildren(
    GoogleCloudAiplatformV1RemoveContextChildrenRequest request,
    core.String context, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$context') + ':removeContextChildren';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1RemoveContextChildrenResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMetadataStoresExecutionsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMetadataStoresExecutionsResource(commons.ApiRequester client)
      : _requester = client;

  /// Adds Events to the specified Execution.
  ///
  /// An Event indicates whether an Artifact was used as an input or output for
  /// an Execution. If an Event already exists between the Execution and the
  /// Artifact, the Event is skipped.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [execution] - Required. The resource name of the Execution that the Events
  /// connect Artifacts with. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/executions/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1AddExecutionEventsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1AddExecutionEventsResponse>
      addExecutionEvents(
    GoogleCloudAiplatformV1AddExecutionEventsRequest request,
    core.String execution, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$execution') + ':addExecutionEvents';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1AddExecutionEventsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates an Execution associated with a MetadataStore.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the MetadataStore where the
  /// Execution should be created. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [executionId] - The {execution} portion of the resource name with the
  /// format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// If not provided, the Execution's ID will be a UUID generated by the
  /// service. Must be 4-128 characters in length. Valid characters are
  /// `/a-z-/`. Must be unique across all Executions in the parent
  /// MetadataStore. (Otherwise the request will fail with ALREADY_EXISTS, or
  /// PERMISSION_DENIED if the caller can't view the preexisting Execution.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Execution].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Execution> create(
    GoogleCloudAiplatformV1Execution request,
    core.String parent, {
    core.String? executionId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (executionId != null) 'executionId': [executionId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/executions';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Execution.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes an Execution.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Execution to delete. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/executions/\[^/\]+$`.
  ///
  /// [etag] - Optional. The etag of the Execution to delete. If this is
  /// provided, it must match the server's etag. Otherwise, the request will
  /// fail with a FAILED_PRECONDITION.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? etag,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (etag != null) 'etag': [etag],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a specific Execution.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Execution to retrieve. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/executions/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Execution].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Execution> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Execution.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Executions in the MetadataStore.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The MetadataStore whose Executions should be listed.
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [filter] - Filter specifying the boolean condition for the Executions to
  /// satisfy in order to be part of the result set. The syntax to define filter
  /// query is based on https://google.aip.dev/160. Following are the supported
  /// set of filters: * **Attribute filtering**: For example: `display_name =
  /// "test"`. Supported fields include: `name`, `display_name`, `state`,
  /// `schema_title`, `create_time`, and `update_time`. Time fields, such as
  /// `create_time` and `update_time`, require values specified in RFC-3339
  /// format. For example: `create_time = "2020-11-19T11:30:00-04:00"`. *
  /// **Metadata field**: To filter on metadata fields use traversal operation
  /// as follows: `metadata..` For example: `metadata.field_1.number_value =
  /// 10.0` In case the field name contains special characters (such as colon),
  /// one can embed it inside double quote. For example:
  /// `metadata."field:1".number_value = 10.0` * **Context based filtering**: To
  /// filter Executions based on the contexts to which they belong use the
  /// function operator with the full resource name: `in_context()`. For
  /// example: `in_context("projects//locations//metadataStores//contexts/")`
  /// Each of the above supported filters can be combined together using logical
  /// operators (`AND` & `OR`). Maximum nested expression depth allowed is 5.
  /// For example: `display_name = "test" AND metadata.field1.bool_value =
  /// true`.
  ///
  /// [orderBy] - How the list of messages is ordered. Specify the values to
  /// order by and an ordering operation. The default sorting order is
  /// ascending. To specify descending order for a field, users append a " desc"
  /// suffix; for example: "foo desc, bar". Subfields are specified with a `.`
  /// character, such as foo.bar. see https://google.aip.dev/132#ordering for
  /// more details.
  ///
  /// [pageSize] - The maximum number of Executions to return. The service may
  /// return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// MetadataService.ListExecutions call. Provide this to retrieve the
  /// subsequent page. When paginating, all other provided parameters must match
  /// the call that provided the page token. (Otherwise the request will fail
  /// with an INVALID_ARGUMENT error.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListExecutionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListExecutionsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/executions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListExecutionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a stored Execution.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. The resource name of the Execution.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/executions/\[^/\]+$`.
  ///
  /// [allowMissing] - If set to true, and the Execution is not found, a new
  /// Execution is created.
  ///
  /// [updateMask] - Optional. A FieldMask indicating which fields should be
  /// updated.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Execution].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Execution> patch(
    GoogleCloudAiplatformV1Execution request,
    core.String name, {
    core.bool? allowMissing,
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (allowMissing != null) 'allowMissing': ['${allowMissing}'],
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Execution.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Purges Executions.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The metadata store to purge Executions from. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> purge(
    GoogleCloudAiplatformV1PurgeExecutionsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/executions:purge';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Obtains the set of input and output Artifacts for this Execution, in the
  /// form of LineageSubgraph that also contains the Execution and connecting
  /// Events.
  ///
  /// Request parameters:
  ///
  /// [execution] - Required. The resource name of the Execution whose input and
  /// output Artifacts should be retrieved as a LineageSubgraph. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/executions/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1LineageSubgraph].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1LineageSubgraph>
      queryExecutionInputsAndOutputs(
    core.String execution, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$execution') +
        ':queryExecutionInputsAndOutputs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1LineageSubgraph.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMetadataStoresMetadataSchemasResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMetadataStoresMetadataSchemasResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Creates a MetadataSchema.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the MetadataStore where the
  /// MetadataSchema should be created. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [metadataSchemaId] - The {metadata_schema} portion of the resource name
  /// with the format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
  /// If not provided, the MetadataStore's ID will be a UUID generated by the
  /// service. Must be 4-128 characters in length. Valid characters are
  /// `/a-z-/`. Must be unique across all MetadataSchemas in the parent
  /// Location. (Otherwise the request will fail with ALREADY_EXISTS, or
  /// PERMISSION_DENIED if the caller can't view the preexisting
  /// MetadataSchema.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1MetadataSchema].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1MetadataSchema> create(
    GoogleCloudAiplatformV1MetadataSchema request,
    core.String parent, {
    core.String? metadataSchemaId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (metadataSchemaId != null) 'metadataSchemaId': [metadataSchemaId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/metadataSchemas';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1MetadataSchema.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Retrieves a specific MetadataSchema.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the MetadataSchema to retrieve.
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+/metadataSchemas/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1MetadataSchema].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1MetadataSchema> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1MetadataSchema.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists MetadataSchemas.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The MetadataStore whose MetadataSchemas should be
  /// listed. Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/metadataStores/\[^/\]+$`.
  ///
  /// [filter] - A query to filter available MetadataSchemas for matching
  /// results.
  ///
  /// [pageSize] - The maximum number of MetadataSchemas to return. The service
  /// may return fewer. Must be in range 1-1000, inclusive. Defaults to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// MetadataService.ListMetadataSchemas call. Provide this to retrieve the
  /// next page. When paginating, all other provided parameters must match the
  /// call that provided the page token. (Otherwise the request will fail with
  /// INVALID_ARGUMENT error.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListMetadataSchemasResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListMetadataSchemasResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/metadataSchemas';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListMetadataSchemasResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMigratableResourcesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMigratableResourcesOperationsResource get operations =>
      ProjectsLocationsMigratableResourcesOperationsResource(_requester);

  ProjectsLocationsMigratableResourcesResource(commons.ApiRequester client)
      : _requester = client;

  /// Batch migrates resources from ml.googleapis.com, automl.googleapis.com,
  /// and datalabeling.googleapis.com to Vertex AI.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The location of the migrated resource will live in.
  /// Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> batchMigrate(
    GoogleCloudAiplatformV1BatchMigrateResourcesRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$parent') +
        '/migratableResources:batchMigrate';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Searches all of the resources in automl.googleapis.com,
  /// datalabeling.googleapis.com and ml.googleapis.com that can be migrated to
  /// Vertex AI's given location.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The location that the migratable resources should be
  /// searched from. It's the Vertex AI location that the resources can be
  /// migrated to, not the resources' original location. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1SearchMigratableResourcesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1SearchMigratableResourcesResponse> search(
    GoogleCloudAiplatformV1SearchMigratableResourcesRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/migratableResources:search';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1SearchMigratableResourcesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsMigratableResourcesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsMigratableResourcesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/migratableResources/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/migratableResources/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/migratableResources/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/migratableResources/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/migratableResources/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelDeploymentMonitoringJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelDeploymentMonitoringJobsOperationsResource
      get operations =>
          ProjectsLocationsModelDeploymentMonitoringJobsOperationsResource(
              _requester);

  ProjectsLocationsModelDeploymentMonitoringJobsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Creates a ModelDeploymentMonitoringJob.
  ///
  /// It will run periodically on a configured interval.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent of the ModelDeploymentMonitoringJob.
  /// Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ModelDeploymentMonitoringJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ModelDeploymentMonitoringJob> create(
    GoogleCloudAiplatformV1ModelDeploymentMonitoringJob request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$parent') +
        '/modelDeploymentMonitoringJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ModelDeploymentMonitoringJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a ModelDeploymentMonitoringJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the model monitoring job to
  /// delete. Format:
  /// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a ModelDeploymentMonitoringJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the ModelDeploymentMonitoringJob.
  /// Format:
  /// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ModelDeploymentMonitoringJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ModelDeploymentMonitoringJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ModelDeploymentMonitoringJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists ModelDeploymentMonitoringJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent of the ModelDeploymentMonitoringJob.
  /// Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"\` *
  /// \`state!="JOB_STATE_FAILED" OR display_name="my_job"\` * \`NOT
  /// display_name="my_job"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`labels.keyA=valueA\` * \`labels.keyB:*\`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [readMask] - Mask specifying which fields to read
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse>
      list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$parent') +
        '/modelDeploymentMonitoringJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListModelDeploymentMonitoringJobsResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a ModelDeploymentMonitoringJob.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Resource name of a ModelDeploymentMonitoringJob.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask is used to specify the fields to
  /// be overwritten in the ModelDeploymentMonitoringJob resource by the update.
  /// The fields specified in the update_mask are relative to the resource, not
  /// the full request. A field will be overwritten if it is in the mask. If the
  /// user does not provide a mask then only the non-empty fields present in the
  /// request will be overwritten. Set the update_mask to `*` to override all
  /// fields. For the objective config, the user can either provide the update
  /// mask for model_deployment_monitoring_objective_configs or any combination
  /// of its nested fields, such as:
  /// model_deployment_monitoring_objective_configs.objective_config.training_dataset.
  /// Updatable fields: * `display_name` *
  /// `model_deployment_monitoring_schedule_config` *
  /// `model_monitoring_alert_config` * `logging_sampling_strategy` * `labels` *
  /// `log_ttl` * `enable_monitoring_pipeline_logs` . and *
  /// `model_deployment_monitoring_objective_configs` . or *
  /// `model_deployment_monitoring_objective_configs.objective_config.training_dataset`
  /// *
  /// `model_deployment_monitoring_objective_configs.objective_config.training_prediction_skew_detection_config`
  /// *
  /// `model_deployment_monitoring_objective_configs.objective_config.prediction_drift_detection_config`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1ModelDeploymentMonitoringJob request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Pauses a ModelDeploymentMonitoringJob.
  ///
  /// If the job is running, the server makes a best effort to cancel the job.
  /// Will mark ModelDeploymentMonitoringJob.state to 'PAUSED'.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the ModelDeploymentMonitoringJob
  /// to pause. Format:
  /// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> pause(
    GoogleCloudAiplatformV1PauseModelDeploymentMonitoringJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':pause';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Resumes a paused ModelDeploymentMonitoringJob.
  ///
  /// It will start to run from next scheduled time. A deleted
  /// ModelDeploymentMonitoringJob can't be resumed.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the ModelDeploymentMonitoringJob
  /// to resume. Format:
  /// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> resume(
    GoogleCloudAiplatformV1ResumeModelDeploymentMonitoringJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':resume';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Searches Model Monitoring Statistics generated within a given time window.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [modelDeploymentMonitoringJob] - Required. ModelDeploymentMonitoring Job
  /// resource name. Format:
  /// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<
          GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesResponse>
      searchModelDeploymentMonitoringStatsAnomalies(
    GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesRequest
        request,
    core.String modelDeploymentMonitoringJob, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$modelDeploymentMonitoringJob') +
        ':searchModelDeploymentMonitoringStatsAnomalies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1SearchModelDeploymentMonitoringStatsAnomaliesResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelDeploymentMonitoringJobsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelDeploymentMonitoringJobsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/modelDeploymentMonitoringJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelsEvaluationsResource get evaluations =>
      ProjectsLocationsModelsEvaluationsResource(_requester);
  ProjectsLocationsModelsOperationsResource get operations =>
      ProjectsLocationsModelsOperationsResource(_requester);

  ProjectsLocationsModelsResource(commons.ApiRequester client)
      : _requester = client;

  /// Copies an already existing Vertex AI Model into the specified Location.
  ///
  /// The source Model must exist in the same Project. When copying custom
  /// Models, the users themselves are responsible for Model.metadata content to
  /// be region-agnostic, as well as making sure that any resources (e.g. files)
  /// it depends on remain accessible.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location into which to copy
  /// the Model. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> copy(
    GoogleCloudAiplatformV1CopyModelRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/models:copy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Model.
  ///
  /// A model cannot be deleted if any Endpoint resource has a DeployedModel
  /// based on the model in its deployed_models field.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Model resource to be deleted. Format:
  /// `projects/{project}/locations/{location}/models/{model}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Model version.
  ///
  /// Model version can only be deleted if there are no DeployedModels created
  /// from it. Deleting the only version in the Model is not allowed. Use
  /// DeleteModel for deleting the Model instead.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the model version to be deleted, with a
  /// version ID explicitly included. Example:
  /// `projects/{project}/locations/{location}/models/{model}@1234`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> deleteVersion(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':deleteVersion';

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Exports a trained, exportable Model to a location specified by the user.
  ///
  /// A Model is considered to be exportable if it has at least one supported
  /// export format.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the Model to export. The resource
  /// name may contain version id or version alias to specify the version, if no
  /// version is specified, the default version will be exported.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> export(
    GoogleCloudAiplatformV1ExportModelRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':export';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Model.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Model resource. Format:
  /// `projects/{project}/locations/{location}/models/{model}` In order to
  /// retrieve a specific version of the model, also provide the version ID or
  /// version alias. Example:
  /// `projects/{project}/locations/{location}/models/{model}@2` or
  /// `projects/{project}/locations/{location}/models/{model}@golden` If no
  /// version ID or alias is specified, the "default" version will be returned.
  /// The "default" version alias is created for the first version of the model,
  /// and can be moved to other versions later on. There will be exactly one
  /// default version.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Model].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Model> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Model.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Models in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the Models
  /// from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - An expression for filtering the results of the request. For
  /// field names both snake_case and camelCase are supported. * \`model\`
  /// supports = and !=. \`model\` represents the Model ID, i.e. the last
  /// segment of the Model's resource name. * \`display_name\` supports = and !=
  /// * \`labels\` supports general map functions that is: *
  /// \`labels.key=value\` - key:value equality * \`labels.key:* or labels:key -
  /// key existence * A key including a space must be quoted. \`labels."a
  /// key"\`. Some examples: * \`model=1234\` * \`displayName="myDisplayName"\`
  /// * \`labels.myKey="myValue"\`
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `display_name` * `create_time` * `update_time` Example:
  /// `display_name, create_time desc`.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListModelsResponse.next_page_token of the previous ModelService.ListModels
  /// call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListModelsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListModelsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/models';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListModelsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists versions of the specified model.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the model to list versions for.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [filter] - An expression for filtering the results of the request. For
  /// field names both snake_case and camelCase are supported. * \`labels\`
  /// supports general map functions that is: * \`labels.key=value\` - key:value
  /// equality * \`labels.key:* or labels:key - key existence * A key including
  /// a space must be quoted. \`labels."a key"\`. Some examples: *
  /// \`labels.myKey="myValue"\`
  ///
  /// [orderBy] - A comma-separated list of fields to order by, sorted in
  /// ascending order. Use "desc" after a field name for descending. Supported
  /// fields: * `create_time` * `update_time` Example: `update_time asc,
  /// create_time desc`.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// next_page_token of the previous ListModelVersions call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListModelVersionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListModelVersionsResponse> listVersions(
    core.String name, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':listVersions';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListModelVersionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Merges a set of aliases for a Model version.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the model version to merge aliases, with a
  /// version ID explicitly included. Example:
  /// `projects/{project}/locations/{location}/models/{model}@1234`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Model].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Model> mergeVersionAliases(
    GoogleCloudAiplatformV1MergeVersionAliasesRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':mergeVersionAliases';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Model.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a Model.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - The resource name of the Model.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask applies to the resource. For the
  /// `FieldMask` definition, see google.protobuf.FieldMask.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Model].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Model> patch(
    GoogleCloudAiplatformV1Model request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Model.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Incrementally update the dataset used for an examples model.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [model] - Required. The resource name of the Model to update. Format:
  /// `projects/{project}/locations/{location}/models/{model}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> updateExplanationDataset(
    GoogleCloudAiplatformV1UpdateExplanationDatasetRequest request,
    core.String model, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$model') + ':updateExplanationDataset';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Uploads a Model artifact into Vertex AI.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location into which to
  /// upload the Model. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> upload(
    GoogleCloudAiplatformV1UploadModelRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/models:upload';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelsEvaluationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelsEvaluationsOperationsResource get operations =>
      ProjectsLocationsModelsEvaluationsOperationsResource(_requester);
  ProjectsLocationsModelsEvaluationsSlicesResource get slices =>
      ProjectsLocationsModelsEvaluationsSlicesResource(_requester);

  ProjectsLocationsModelsEvaluationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets a ModelEvaluation.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the ModelEvaluation resource. Format:
  /// `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ModelEvaluation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ModelEvaluation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ModelEvaluation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Imports an externally generated ModelEvaluation.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the parent model resource. Format:
  /// `projects/{project}/locations/{location}/models/{model}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ModelEvaluation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ModelEvaluation> import(
    GoogleCloudAiplatformV1ImportModelEvaluationRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/evaluations:import';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ModelEvaluation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists ModelEvaluations in a Model.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Model to list the
  /// ModelEvaluations from. Format:
  /// `projects/{project}/locations/{location}/models/{model}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListModelEvaluationsResponse.next_page_token of the previous
  /// ModelService.ListModelEvaluations call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListModelEvaluationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListModelEvaluationsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/evaluations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListModelEvaluationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelsEvaluationsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelsEvaluationsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelsEvaluationsSlicesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelsEvaluationsSlicesResource(commons.ApiRequester client)
      : _requester = client;

  /// Imports a list of externally generated EvaluatedAnnotations.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the parent ModelEvaluationSlice resource.
  /// Format:
  /// `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+/slices/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse>
      batchImport(
    GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + ':batchImport';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a ModelEvaluationSlice.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the ModelEvaluationSlice resource. Format:
  /// `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+/slices/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ModelEvaluationSlice].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ModelEvaluationSlice> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ModelEvaluationSlice.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists ModelEvaluationSlices in a ModelEvaluation.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the ModelEvaluation to list the
  /// ModelEvaluationSlices from. Format:
  /// `projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/evaluations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. * `slice.dimension` - for =.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListModelEvaluationSlicesResponse.next_page_token of the previous
  /// ModelService.ListModelEvaluationSlices call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/slices';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListModelEvaluationSlicesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsModelsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsModelsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/models/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsNasJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsNasJobsNasTrialDetailsResource get nasTrialDetails =>
      ProjectsLocationsNasJobsNasTrialDetailsResource(_requester);

  ProjectsLocationsNasJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a NasJob.
  ///
  /// Starts asynchronous cancellation on the NasJob. The server makes a best
  /// effort to cancel the job, but success is not guaranteed. Clients can use
  /// JobService.GetNasJob or other methods to check whether the cancellation
  /// succeeded or whether the job completed despite cancellation. On successful
  /// cancellation, the NasJob is not deleted; instead it becomes a job with a
  /// NasJob.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`, and NasJob.state is set to `CANCELLED`.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NasJob to cancel. Format:
  /// `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/nasJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelNasJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a NasJob
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// NasJob in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1NasJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1NasJob> create(
    GoogleCloudAiplatformV1NasJob request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/nasJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1NasJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a NasJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NasJob resource to be deleted. Format:
  /// `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/nasJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a NasJob
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NasJob resource. Format:
  /// `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/nasJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1NasJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1NasJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1NasJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists NasJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the NasJobs
  /// from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="JOB_STATE_SUCCEEDED" AND display_name:"my_job_*"\` *
  /// \`state!="JOB_STATE_FAILED" OR display_name="my_job"\` * \`NOT
  /// display_name="my_job"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`labels.keyA=valueA\` * \`labels.keyB:*\`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListNasJobsResponse.next_page_token of the previous JobService.ListNasJobs
  /// call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListNasJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListNasJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/nasJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListNasJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsNasJobsNasTrialDetailsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsNasJobsNasTrialDetailsResource(commons.ApiRequester client)
      : _requester = client;

  /// Gets a NasTrialDetail.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NasTrialDetail resource. Format:
  /// `projects/{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_trial_detail}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/nasJobs/\[^/\]+/nasTrialDetails/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1NasTrialDetail].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1NasTrialDetail> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1NasTrialDetail.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// List top NasTrialDetails of a NasJob.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the NasJob resource. Format:
  /// `projects/{project}/locations/{location}/nasJobs/{nas_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/nasJobs/\[^/\]+$`.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListNasTrialDetailsResponse.next_page_token of the previous
  /// JobService.ListNasTrialDetails call.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListNasTrialDetailsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListNasTrialDetailsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/nasTrialDetails';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListNasTrialDetailsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsNotebookRuntimeTemplatesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsNotebookRuntimeTemplatesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a NotebookRuntimeTemplate.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// NotebookRuntimeTemplate. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [notebookRuntimeTemplateId] - Optional. User specified ID for the notebook
  /// runtime template.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1NotebookRuntimeTemplate request,
    core.String parent, {
    core.String? notebookRuntimeTemplateId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (notebookRuntimeTemplateId != null)
        'notebookRuntimeTemplateId': [notebookRuntimeTemplateId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/notebookRuntimeTemplates';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a NotebookRuntimeTemplate.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NotebookRuntimeTemplate resource to be
  /// deleted. Format:
  /// `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimeTemplates/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a NotebookRuntimeTemplate.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NotebookRuntimeTemplate resource.
  /// Format:
  /// `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimeTemplates/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1NotebookRuntimeTemplate].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1NotebookRuntimeTemplate> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1NotebookRuntimeTemplate.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the access control policy for a resource.
  ///
  /// Returns an empty policy if the resource exists and does not have a policy
  /// set.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimeTemplates/\[^/\]+$`.
  ///
  /// [options_requestedPolicyVersion] - Optional. The maximum policy version
  /// that will be used to format the policy. Valid values are 0, 1, and 3.
  /// Requests specifying an invalid value will be rejected. Requests for
  /// policies with any conditional role bindings must specify version 3.
  /// Policies with no conditional role bindings may specify any valid value or
  /// leave the field unset. The policy in the response might use the policy
  /// version that you specified, or it might use a lower policy version. For
  /// example, if you specify version 3, but the policy has no conditional role
  /// bindings, the response uses version 1. To learn which resources support
  /// conditions in their IAM policies, see the
  /// [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> getIamPolicy(
    core.String resource, {
    core.int? options_requestedPolicyVersion,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (options_requestedPolicyVersion != null)
        'options.requestedPolicyVersion': ['${options_requestedPolicyVersion}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':getIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists NotebookRuntimeTemplates in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location from which to list
  /// the NotebookRuntimeTemplates. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. An expression for filtering the results of the
  /// request. For field names both snake_case and camelCase are supported. *
  /// \`notebookRuntimeTemplate\` supports = and !=. \`notebookRuntimeTemplate\`
  /// represents the NotebookRuntimeTemplate ID, i.e. the last segment of the
  /// NotebookRuntimeTemplate's resource name. * \`display_name\` supports = and
  /// != * \`labels\` supports general map functions that is: *
  /// \`labels.key=value\` - key:value equality * \`labels.key:* or labels:key -
  /// key existence * A key including a space must be quoted. \`labels."a
  /// key"\`. * \`notebookRuntimeType\` supports = and !=. notebookRuntimeType
  /// enum: \[USER_DEFINED, ONE_CLICK\]. Some examples: *
  /// \`notebookRuntimeTemplate=notebookRuntimeTemplate123\` *
  /// \`displayName="myDisplayName"\` * \`labels.myKey="myValue"\` *
  /// \`notebookRuntimeType=USER_DEFINED\`
  ///
  /// [orderBy] - Optional. A comma-separated list of fields to order by, sorted
  /// in ascending order. Use "desc" after a field name for descending.
  /// Supported fields: * `display_name` * `create_time` * `update_time`
  /// Example: `display_name, create_time desc`.
  ///
  /// [pageSize] - Optional. The standard list page size.
  ///
  /// [pageToken] - Optional. The standard list page token. Typically obtained
  /// via ListNotebookRuntimeTemplatesResponse.next_page_token of the previous
  /// NotebookService.ListNotebookRuntimeTemplates call.
  ///
  /// [readMask] - Optional. Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse>
      list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/notebookRuntimeTemplates';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListNotebookRuntimeTemplatesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Sets the access control policy on the specified resource.
  ///
  /// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
  /// and `PERMISSION_DENIED` errors.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy is being
  /// specified. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimeTemplates/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1Policy].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1Policy> setIamPolicy(
    GoogleIamV1SetIamPolicyRequest request,
    core.String resource, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$resource') + ':setIamPolicy';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleIamV1Policy.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns permissions that a caller has on the specified resource.
  ///
  /// If the resource does not exist, this will return an empty set of
  /// permissions, not a `NOT_FOUND` error. Note: This operation is designed to
  /// be used for building permission-aware UIs and command-line tools, not for
  /// authorization checking. This operation may "fail open" without warning.
  ///
  /// Request parameters:
  ///
  /// [resource] - REQUIRED: The resource for which the policy detail is being
  /// requested. See
  /// [Resource names](https://cloud.google.com/apis/design/resource_names) for
  /// the appropriate value for this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimeTemplates/\[^/\]+$`.
  ///
  /// [permissions] - The set of permissions to check for the `resource`.
  /// Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
  /// For more information see
  /// [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleIamV1TestIamPermissionsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleIamV1TestIamPermissionsResponse> testIamPermissions(
    core.String resource, {
    core.List<core.String>? permissions,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (permissions != null) 'permissions': permissions,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$resource') + ':testIamPermissions';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleIamV1TestIamPermissionsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsNotebookRuntimesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsNotebookRuntimesResource(commons.ApiRequester client)
      : _requester = client;

  /// Assigns a NotebookRuntime to a user for a particular Notebook file.
  ///
  /// This method will either returns an existing assignment or generates a new
  /// one.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to get the
  /// NotebookRuntime assignment. Format:
  /// `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> assign(
    GoogleCloudAiplatformV1AssignNotebookRuntimeRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/notebookRuntimes:assign';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a NotebookRuntime.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NotebookRuntime resource to be deleted.
  /// Instead of checking whether the name is in valid NotebookRuntime resource
  /// name format, directly throw NotFound exception if there is no such
  /// NotebookRuntime in spanner.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a NotebookRuntime.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NotebookRuntime resource. Instead of
  /// checking whether the name is in valid NotebookRuntime resource name
  /// format, directly throw NotFound exception if there is no such
  /// NotebookRuntime in spanner.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1NotebookRuntime].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1NotebookRuntime> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1NotebookRuntime.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists NotebookRuntimes in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location from which to list
  /// the NotebookRuntimes. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Optional. An expression for filtering the results of the
  /// request. For field names both snake_case and camelCase are supported. *
  /// `notebookRuntime` supports = and !=. `notebookRuntime` represents the
  /// NotebookRuntime ID, i.e. the last segment of the NotebookRuntime's
  /// resource name. * `displayName` supports = and != and regex. *
  /// `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
  /// represents the NotebookRuntimeTemplate ID, i.e. the last segment of the
  /// NotebookRuntimeTemplate's resource name. * `healthState` supports = and
  /// !=. healthState enum: \[HEALTHY, UNHEALTHY, HEALTH_STATE_UNSPECIFIED\]. *
  /// `runtimeState` supports = and !=. runtimeState enum:
  /// \[RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
  /// STOPPED, BEING_UPGRADED\]. * `runtimeUser` supports = and !=. * API
  /// version is UI only: `uiState` supports = and !=. uiState enum:
  /// \[UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
  /// UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
  /// UI_RESOURCE_STATE_CREATION_FAILED\]. * `notebookRuntimeType` supports =
  /// and !=. notebookRuntimeType enum: \[USER_DEFINED, ONE_CLICK\]. Some
  /// examples: * `notebookRuntime="notebookRuntime123"` *
  /// `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"` *
  /// `notebookRuntimeTemplate="notebookRuntimeTemplate321"` *
  /// `healthState=HEALTHY` * `runtimeState=RUNNING` *
  /// `runtimeUser="test@google.com"` *
  /// `uiState=UI_RESOURCE_STATE_BEING_DELETED` *
  /// `notebookRuntimeType=USER_DEFINED`
  ///
  /// [orderBy] - Optional. A comma-separated list of fields to order by, sorted
  /// in ascending order. Use "desc" after a field name for descending.
  /// Supported fields: * `display_name` * `create_time` * `update_time`
  /// Example: `display_name, create_time desc`.
  ///
  /// [pageSize] - Optional. The standard list page size.
  ///
  /// [pageToken] - Optional. The standard list page token. Typically obtained
  /// via ListNotebookRuntimesResponse.next_page_token of the previous
  /// NotebookService.ListNotebookRuntimes call.
  ///
  /// [readMask] - Optional. Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListNotebookRuntimesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListNotebookRuntimesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/notebookRuntimes';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListNotebookRuntimesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Starts a NotebookRuntime.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the NotebookRuntime resource to be started.
  /// Instead of checking whether the name is in valid NotebookRuntime resource
  /// name format, directly throw NotFound exception if there is no such
  /// NotebookRuntime in spanner.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/notebookRuntimes/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> start(
    GoogleCloudAiplatformV1StartNotebookRuntimeRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':start';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsPipelineJobsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsPipelineJobsOperationsResource get operations =>
      ProjectsLocationsPipelineJobsOperationsResource(_requester);

  ProjectsLocationsPipelineJobsResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a PipelineJob.
  ///
  /// Starts asynchronous cancellation on the PipelineJob. The server makes a
  /// best effort to cancel the pipeline, but success is not guaranteed. Clients
  /// can use PipelineService.GetPipelineJob or other methods to check whether
  /// the cancellation succeeded or whether the pipeline completed despite
  /// cancellation. On successful cancellation, the PipelineJob is not deleted;
  /// instead it becomes a pipeline with a PipelineJob.error value with a
  /// google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`, and
  /// PipelineJob.state is set to `CANCELLED`.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the PipelineJob to cancel. Format:
  /// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelPipelineJobRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a PipelineJob.
  ///
  /// A PipelineJob will run immediately when created.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// PipelineJob in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [pipelineJobId] - The ID to use for the PipelineJob, which will become the
  /// final component of the PipelineJob name. If not provided, an ID will be
  /// automatically generated. This value should be less than 128 characters,
  /// and valid characters are `/a-z-/`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1PipelineJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1PipelineJob> create(
    GoogleCloudAiplatformV1PipelineJob request,
    core.String parent, {
    core.String? pipelineJobId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pipelineJobId != null) 'pipelineJobId': [pipelineJobId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/pipelineJobs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1PipelineJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a PipelineJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the PipelineJob resource to be deleted.
  /// Format:
  /// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a PipelineJob.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the PipelineJob resource. Format:
  /// `projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1PipelineJob].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1PipelineJob> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1PipelineJob.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists PipelineJobs in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the
  /// PipelineJobs from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Lists the PipelineJobs that match the filter expression. The
  /// following fields are supported: * `pipeline_name`: Supports `=` and `!=`
  /// comparisons. * `display_name`: Supports `=`, `!=` comparisons, and `:`
  /// wildcard. * `pipeline_job_user_id`: Supports `=`, `!=` comparisons, and
  /// `:` wildcard. for example, can check if pipeline's display_name contains
  /// *step* by doing display_name:\"*step*\" * `state`: Supports `=` and `!=`
  /// comparisons. * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
  /// comparisons. Values must be in RFC 3339 format. * `update_time`: Supports
  /// `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons. Values must be in RFC
  /// 3339 format. * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
  /// comparisons. Values must be in RFC 3339 format. * `labels`: Supports
  /// key-value equality and key presence. * `template_uri`: Supports `=`, `!=`
  /// comparisons, and `:` wildcard. * `template_metadata.version`: Supports
  /// `=`, `!=` comparisons, and `:` wildcard. Filter expressions can be
  /// combined together using logical operators (`AND` & `OR`). For example:
  /// `pipeline_name="test" AND create_time>"2020-05-18T13:30:00Z"`. The syntax
  /// to define filter expression is based on https://google.aip.dev/160.
  /// Examples: * `create_time>"2021-05-18T00:00:00Z" OR
  /// update_time>"2020-05-18T00:00:00Z"` PipelineJobs created or updated after
  /// 2020-05-18 00:00:00 UTC. * `labels.env = "prod"` PipelineJobs with label
  /// "env" set to "prod".
  ///
  /// [orderBy] - A comma-separated list of fields to order by. The default sort
  /// order is in ascending order. Use "desc" after a field name for descending.
  /// You can have multiple order_by fields provided e.g. "create_time desc,
  /// end_time", "end_time, start_time, update_time" For example, using
  /// "create_time desc, end_time" will order results by create time in
  /// descending order, and if there are multiple jobs having the same create
  /// time, order them by the end time in ascending order. if order_by is not
  /// specified, it will order by default order is create time in descending
  /// order. Supported fields: * `create_time` * `update_time` * `end_time` *
  /// `start_time`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListPipelineJobsResponse.next_page_token of the previous
  /// PipelineService.ListPipelineJobs call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListPipelineJobsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListPipelineJobsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/pipelineJobs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListPipelineJobsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsPipelineJobsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsPipelineJobsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/pipelineJobs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsPublishersResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsPublishersModelsResource get models =>
      ProjectsLocationsPublishersModelsResource(_requester);

  ProjectsLocationsPublishersResource(commons.ApiRequester client)
      : _requester = client;
}

class ProjectsLocationsPublishersModelsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsPublishersModelsResource(commons.ApiRequester client)
      : _requester = client;

  /// Return a list of tokens based on the input text.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to get lists of
  /// tokens and token ids.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/publishers/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ComputeTokensResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ComputeTokensResponse> computeTokens(
    GoogleCloudAiplatformV1ComputeTokensRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':computeTokens';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ComputeTokensResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform a token counting.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to perform token
  /// counting. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/publishers/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1CountTokensResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1CountTokensResponse> countTokens(
    GoogleCloudAiplatformV1CountTokensRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':countTokens';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1CountTokensResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform an online prediction.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// prediction. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/publishers/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1PredictResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1PredictResponse> predict(
    GoogleCloudAiplatformV1PredictRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':predict';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1PredictResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform an online prediction with an arbitrary HTTP payload.
  ///
  /// The response includes the following HTTP headers: *
  /// `X-Vertex-AI-Endpoint-Id`: ID of the Endpoint that served this prediction.
  /// * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's DeployedModel that
  /// served this prediction.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// prediction. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/publishers/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleApiHttpBody].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleApiHttpBody> rawPredict(
    GoogleCloudAiplatformV1RawPredictRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$endpoint') + ':rawPredict';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleApiHttpBody.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Perform a server-side streaming online prediction request for Vertex LLM
  /// streaming.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [endpoint] - Required. The name of the Endpoint requested to serve the
  /// prediction. Format:
  /// `projects/{project}/locations/{location}/endpoints/{endpoint}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/publishers/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1StreamingPredictResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1StreamingPredictResponse>
      serverStreamingPredict(
    GoogleCloudAiplatformV1StreamingPredictRequest request,
    core.String endpoint, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$endpoint') + ':serverStreamingPredict';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1StreamingPredictResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsSchedulesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsSchedulesOperationsResource get operations =>
      ProjectsLocationsSchedulesOperationsResource(_requester);

  ProjectsLocationsSchedulesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a Schedule.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// Schedule in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Schedule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Schedule> create(
    GoogleCloudAiplatformV1Schedule request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/schedules';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Schedule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Schedule.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Schedule resource to be deleted.
  /// Format: `projects/{project}/locations/{location}/schedules/{schedule}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Schedule.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Schedule resource. Format:
  /// `projects/{project}/locations/{location}/schedules/{schedule}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Schedule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Schedule> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Schedule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Schedules in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the
  /// Schedules from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Lists the Schedules that match the filter expression. The
  /// following fields are supported: * `display_name`: Supports `=`, `!=`
  /// comparisons, and `:` wildcard. * `state`: Supports `=` and `!=`
  /// comparisons. * `request`: Supports existence of the check. (e.g.
  /// `create_pipeline_job_request:*` --\> Schedule has
  /// create_pipeline_job_request). * `create_time`: Supports `=`, `!=`, `<`,
  /// `>`, `<=`, and `>=` comparisons. Values must be in RFC 3339 format. *
  /// `start_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
  /// Values must be in RFC 3339 format. * `end_time`: Supports `=`, `!=`, `<`,
  /// `>`, `<=`, `>=` comparisons and `:*` existence check. Values must be in
  /// RFC 3339 format. * `next_run_time`: Supports `=`, `!=`, `<`, `>`, `<=`,
  /// and `>=` comparisons. Values must be in RFC 3339 format. Filter
  /// expressions can be combined together using logical operators (`NOT`, `AND`
  /// & `OR`). The syntax to define filter expression is based on
  /// https://google.aip.dev/160. Examples: * `state="ACTIVE" AND
  /// display_name:"my_schedule_*"` * `NOT display_name="my_schedule"` *
  /// `create_time>"2021-05-18T00:00:00Z"` * `end_time>"2021-05-18T00:00:00Z" OR
  /// NOT end_time:*` * `create_pipeline_job_request:*`
  ///
  /// [orderBy] - A comma-separated list of fields to order by. The default sort
  /// order is in ascending order. Use "desc" after a field name for descending.
  /// You can have multiple order_by fields provided. For example, using
  /// "create_time desc, end_time" will order results by create time in
  /// descending order, and if there are multiple schedules having the same
  /// create time, order them by the end time in ascending order. If order_by is
  /// not specified, it will order by default with create_time in descending
  /// order. Supported fields: * `create_time` * `start_time` * `end_time` *
  /// `next_run_time`
  ///
  /// [pageSize] - The standard list page size. Default to 100 if not specified.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListSchedulesResponse.next_page_token of the previous
  /// ScheduleService.ListSchedules call.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListSchedulesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListSchedulesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/schedules';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListSchedulesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates an active or paused Schedule.
  ///
  /// When the Schedule is updated, new runs will be scheduled starting from the
  /// updated next execution time after the update time based on the
  /// time_specification in the updated Schedule. All unstarted runs before the
  /// update time will be skipped while already created runs will NOT be paused
  /// or canceled.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Immutable. The resource name of the Schedule.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask applies to the resource. See
  /// google.protobuf.FieldMask.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Schedule].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Schedule> patch(
    GoogleCloudAiplatformV1Schedule request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Schedule.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Pauses a Schedule.
  ///
  /// Will mark Schedule.state to 'PAUSED'. If the schedule is paused, no new
  /// runs will be created. Already created runs will NOT be paused or canceled.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Schedule resource to be paused. Format:
  /// `projects/{project}/locations/{location}/schedules/{schedule}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> pause(
    GoogleCloudAiplatformV1PauseScheduleRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':pause';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Resumes a paused Schedule to start scheduling new runs.
  ///
  /// Will mark Schedule.state to 'ACTIVE'. Only paused Schedule can be resumed.
  /// When the Schedule is resumed, new runs will be scheduled starting from the
  /// next execution time after the current time based on the time_specification
  /// in the Schedule. If Schedule.catchUp is set up true, all missed runs will
  /// be scheduled for backfill first.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Schedule resource to be resumed.
  /// Format: `projects/{project}/locations/{location}/schedules/{schedule}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> resume(
    GoogleCloudAiplatformV1ResumeScheduleRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':resume';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsSchedulesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsSchedulesOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/schedules/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsSpecialistPoolsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsSpecialistPoolsOperationsResource get operations =>
      ProjectsLocationsSpecialistPoolsOperationsResource(_requester);

  ProjectsLocationsSpecialistPoolsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a SpecialistPool.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The parent Project name for the new SpecialistPool.
  /// The form is `projects/{project}/locations/{location}`.
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1SpecialistPool request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/specialistPools';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a SpecialistPool as well as all Specialists in the pool.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the SpecialistPool to delete.
  /// Format:
  /// `projects/{project}/locations/{location}/specialistPools/{specialist_pool}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+$`.
  ///
  /// [force] - If set to true, any specialist managers in this SpecialistPool
  /// will also be deleted. (Otherwise, the request will only work if the
  /// SpecialistPool has no specialist managers.)
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.bool? force,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (force != null) 'force': ['${force}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a SpecialistPool.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the SpecialistPool resource. The form is
  /// `projects/{project}/locations/{location}/specialistPools/{specialist_pool}`.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1SpecialistPool].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1SpecialistPool> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1SpecialistPool.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists SpecialistPools in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the SpecialistPool's parent resource.
  /// Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained by
  /// ListSpecialistPoolsResponse.next_page_token of the previous
  /// SpecialistPoolService.ListSpecialistPools call. Return first page if
  /// empty.
  ///
  /// [readMask] - Mask specifying which fields to read. FieldMask represents a
  /// set of
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListSpecialistPoolsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListSpecialistPoolsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/specialistPools';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListSpecialistPoolsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a SpecialistPool.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The resource name of the SpecialistPool.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+$`.
  ///
  /// [updateMask] - Required. The update mask applies to the resource.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1SpecialistPool request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsSpecialistPoolsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsSpecialistPoolsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/specialistPools/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsStudiesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsStudiesOperationsResource get operations =>
      ProjectsLocationsStudiesOperationsResource(_requester);
  ProjectsLocationsStudiesTrialsResource get trials =>
      ProjectsLocationsStudiesTrialsResource(_requester);

  ProjectsLocationsStudiesResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a Study.
  ///
  /// A resource name will be generated after creation of the Study.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// CustomJob in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Study].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Study> create(
    GoogleCloudAiplatformV1Study request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/studies';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Study.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Study.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Study resource to be deleted. Format:
  /// `projects/{project}/locations/{location}/studies/{study}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Study by name.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Study resource. Format:
  /// `projects/{project}/locations/{location}/studies/{study}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Study].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Study> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Study.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists all the studies in a region for an associated project.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the Study
  /// from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [pageSize] - Optional. The maximum number of studies to return per "page"
  /// of results. If unspecified, service will pick an appropriate default.
  ///
  /// [pageToken] - Optional. A page token to request the next page of results.
  /// If unspecified, there are no subsequent pages.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListStudiesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListStudiesResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/studies';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListStudiesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Looks a study up using the user-defined display_name field instead of the
  /// fully qualified resource name.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to get the Study
  /// from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Study].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Study> lookup(
    GoogleCloudAiplatformV1LookupStudyRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/studies:lookup';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Study.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsStudiesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsStudiesOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsStudiesTrialsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsStudiesTrialsOperationsResource get operations =>
      ProjectsLocationsStudiesTrialsOperationsResource(_requester);

  ProjectsLocationsStudiesTrialsResource(commons.ApiRequester client)
      : _requester = client;

  /// Adds a measurement of the objective metrics to a Trial.
  ///
  /// This measurement is assumed to have been taken before the Trial is
  /// complete.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [trialName] - Required. The name of the trial to add measurement. Format:
  /// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Trial].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Trial> addTrialMeasurement(
    GoogleCloudAiplatformV1AddTrialMeasurementRequest request,
    core.String trialName, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$trialName') + ':addTrialMeasurement';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Trial.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Checks whether a Trial should stop or not.
  ///
  /// Returns a long-running operation. When the operation is successful, it
  /// will contain a CheckTrialEarlyStoppingStateResponse.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [trialName] - Required. The Trial's name. Format:
  /// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> checkTrialEarlyStoppingState(
    GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest request,
    core.String trialName, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$trialName') +
        ':checkTrialEarlyStoppingState';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Marks a Trial as complete.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The Trial's name. Format:
  /// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Trial].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Trial> complete(
    GoogleCloudAiplatformV1CompleteTrialRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':complete';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Trial.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Adds a user provided Trial to a Study.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Study to create the Trial
  /// in. Format: `projects/{project}/locations/{location}/studies/{study}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Trial].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Trial> create(
    GoogleCloudAiplatformV1Trial request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/trials';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Trial.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Trial.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The Trial's name. Format:
  /// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Trial.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Trial resource. Format:
  /// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Trial].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Trial> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Trial.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the Trials associated with a Study.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Study to list the Trial
  /// from. Format: `projects/{project}/locations/{location}/studies/{study}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [pageSize] - Optional. The number of Trials to retrieve per "page" of
  /// results. If unspecified, the service will pick an appropriate default.
  ///
  /// [pageToken] - Optional. A page token to request the next page of results.
  /// If unspecified, there are no subsequent pages.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListTrialsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListTrialsResponse> list(
    core.String parent, {
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/trials';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListTrialsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists the pareto-optimal Trials for multi-objective Study or the optimal
  /// Trials for single-objective Study.
  ///
  /// The definition of pareto-optimal can be checked in wiki page.
  /// https://en.wikipedia.org/wiki/Pareto_efficiency
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The name of the Study that the optimal Trial belongs
  /// to.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListOptimalTrialsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListOptimalTrialsResponse>
      listOptimalTrials(
    GoogleCloudAiplatformV1ListOptimalTrialsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$parent') + '/trials:listOptimalTrials';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListOptimalTrialsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Stops a Trial.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The Trial's name. Format:
  /// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Trial].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Trial> stop(
    GoogleCloudAiplatformV1StopTrialRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':stop';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Trial.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Adds one or more Trials to a Study, with parameter values suggested by
  /// Vertex AI Vizier.
  ///
  /// Returns a long-running operation associated with the generation of Trial
  /// suggestions. When this long-running operation succeeds, it will contain a
  /// SuggestTrialsResponse.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The project and location that the Study belongs to.
  /// Format: `projects/{project}/locations/{location}/studies/{study}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> suggest(
    GoogleCloudAiplatformV1SuggestTrialsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/trials:suggest';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsStudiesTrialsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsStudiesTrialsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/studies/\[^/\]+/trials/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsResource get experiments =>
      ProjectsLocationsTensorboardsExperimentsResource(_requester);
  ProjectsLocationsTensorboardsOperationsResource get operations =>
      ProjectsLocationsTensorboardsOperationsResource(_requester);

  ProjectsLocationsTensorboardsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a Tensorboard.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// Tensorboard in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> create(
    GoogleCloudAiplatformV1Tensorboard request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/tensorboards';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a Tensorboard.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Tensorboard to be deleted. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a Tensorboard.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the Tensorboard resource. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1Tensorboard].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1Tensorboard> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1Tensorboard.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists Tensorboards in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list
  /// Tensorboards. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - Lists the Tensorboards that match the filter expression.
  ///
  /// [orderBy] - Field to use to sort the list.
  ///
  /// [pageSize] - The maximum number of Tensorboards to return. The service may
  /// return fewer than this value. If unspecified, at most 100 Tensorboards are
  /// returned. The maximum value is 100; values above 100 are coerced to 100.
  ///
  /// [pageToken] - A page token, received from a previous
  /// TensorboardService.ListTensorboards call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// TensorboardService.ListTensorboards must match the call that provided the
  /// page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListTensorboardsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListTensorboardsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/tensorboards';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListTensorboardsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a Tensorboard.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the Tensorboard. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Field mask is used to specify the fields to be
  /// overwritten in the Tensorboard resource by the update. The fields
  /// specified in the update_mask are relative to the resource, not the full
  /// request. A field is overwritten if it's in the mask. If the user does not
  /// provide a mask then all fields are overwritten if new values are
  /// specified.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> patch(
    GoogleCloudAiplatformV1Tensorboard request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns the storage size for a given TensorBoard instance.
  ///
  /// Request parameters:
  ///
  /// [tensorboard] - Required. The name of the Tensorboard resource. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ReadTensorboardSizeResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadTensorboardSizeResponse> readSize(
    core.String tensorboard, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$tensorboard') + ':readSize';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadTensorboardSizeResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Returns a list of monthly active users for a given TensorBoard instance.
  ///
  /// Request parameters:
  ///
  /// [tensorboard] - Required. The name of the Tensorboard resource. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ReadTensorboardUsageResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadTensorboardUsageResponse> readUsage(
    core.String tensorboard, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$tensorboard') + ':readUsage';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadTensorboardUsageResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsExperimentsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsOperationsResource get operations =>
      ProjectsLocationsTensorboardsExperimentsOperationsResource(_requester);
  ProjectsLocationsTensorboardsExperimentsRunsResource get runs =>
      ProjectsLocationsTensorboardsExperimentsRunsResource(_requester);

  ProjectsLocationsTensorboardsExperimentsResource(commons.ApiRequester client)
      : _requester = client;

  /// Creates a TensorboardExperiment.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Tensorboard to create the
  /// TensorboardExperiment in. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [tensorboardExperimentId] - Required. The ID to use for the Tensorboard
  /// experiment, which becomes the final component of the Tensorboard
  /// experiment's resource name. This value should be 1-128 characters, and
  /// valid characters are `/a-z-/`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardExperiment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardExperiment> create(
    GoogleCloudAiplatformV1TensorboardExperiment request,
    core.String parent, {
    core.String? tensorboardExperimentId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (tensorboardExperimentId != null)
        'tensorboardExperimentId': [tensorboardExperimentId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/experiments';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardExperiment.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a TensorboardExperiment.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TensorboardExperiment to be deleted.
  /// Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a TensorboardExperiment.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TensorboardExperiment resource. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardExperiment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardExperiment> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardExperiment.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists TensorboardExperiments in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Tensorboard to list
  /// TensorboardExperiments. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [filter] - Lists the TensorboardExperiments that match the filter
  /// expression.
  ///
  /// [orderBy] - Field to use to sort the list.
  ///
  /// [pageSize] - The maximum number of TensorboardExperiments to return. The
  /// service may return fewer than this value. If unspecified, at most 50
  /// TensorboardExperiments are returned. The maximum value is 1000; values
  /// above 1000 are coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// TensorboardService.ListTensorboardExperiments call. Provide this to
  /// retrieve the subsequent page. When paginating, all other parameters
  /// provided to TensorboardService.ListTensorboardExperiments must match the
  /// call that provided the page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListTensorboardExperimentsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListTensorboardExperimentsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/experiments';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListTensorboardExperimentsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a TensorboardExperiment.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the TensorboardExperiment. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Field mask is used to specify the fields to be
  /// overwritten in the TensorboardExperiment resource by the update. The
  /// fields specified in the update_mask are relative to the resource, not the
  /// full request. A field is overwritten if it's in the mask. If the user does
  /// not provide a mask then all fields are overwritten if new values are
  /// specified.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardExperiment].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardExperiment> patch(
    GoogleCloudAiplatformV1TensorboardExperiment request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardExperiment.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Write time series data points of multiple TensorboardTimeSeries in
  /// multiple TensorboardRun's.
  ///
  /// If any data fail to be ingested, an error is returned.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [tensorboardExperiment] - Required. The resource name of the
  /// TensorboardExperiment to write data to. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1WriteTensorboardExperimentDataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1WriteTensorboardExperimentDataResponse>
      write(
    GoogleCloudAiplatformV1WriteTensorboardExperimentDataRequest request,
    core.String tensorboardExperiment, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$tensorboardExperiment') + ':write';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1WriteTensorboardExperimentDataResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsExperimentsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsExperimentsRunsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsRunsOperationsResource
      get operations =>
          ProjectsLocationsTensorboardsExperimentsRunsOperationsResource(
              _requester);
  ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesResource
      get timeSeries =>
          ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesResource(
              _requester);

  ProjectsLocationsTensorboardsExperimentsRunsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Batch create TensorboardRuns.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the TensorboardExperiment to
  /// create the TensorboardRuns in. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// The parent field in the CreateTensorboardRunRequest messages must match
  /// this field.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse>
      batchCreate(
    GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/runs:batchCreate';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a TensorboardRun.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the TensorboardExperiment to
  /// create the TensorboardRun in. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [tensorboardRunId] - Required. The ID to use for the Tensorboard run,
  /// which becomes the final component of the Tensorboard run's resource name.
  /// This value should be 1-128 characters, and valid characters are `/a-z-/`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardRun].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardRun> create(
    GoogleCloudAiplatformV1TensorboardRun request,
    core.String parent, {
    core.String? tensorboardRunId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (tensorboardRunId != null) 'tensorboardRunId': [tensorboardRunId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/runs';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardRun.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a TensorboardRun.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TensorboardRun to be deleted. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a TensorboardRun.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TensorboardRun resource. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardRun].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardRun> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardRun.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists TensorboardRuns in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the TensorboardExperiment to
  /// list TensorboardRuns. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [filter] - Lists the TensorboardRuns that match the filter expression.
  ///
  /// [orderBy] - Field to use to sort the list.
  ///
  /// [pageSize] - The maximum number of TensorboardRuns to return. The service
  /// may return fewer than this value. If unspecified, at most 50
  /// TensorboardRuns are returned. The maximum value is 1000; values above 1000
  /// are coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// TensorboardService.ListTensorboardRuns call. Provide this to retrieve the
  /// subsequent page. When paginating, all other parameters provided to
  /// TensorboardService.ListTensorboardRuns must match the call that provided
  /// the page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListTensorboardRunsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListTensorboardRunsResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/runs';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListTensorboardRunsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a TensorboardRun.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the TensorboardRun. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Field mask is used to specify the fields to be
  /// overwritten in the TensorboardRun resource by the update. The fields
  /// specified in the update_mask are relative to the resource, not the full
  /// request. A field is overwritten if it's in the mask. If the user does not
  /// provide a mask then all fields are overwritten if new values are
  /// specified.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardRun].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardRun> patch(
    GoogleCloudAiplatformV1TensorboardRun request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardRun.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Write time series data points into multiple TensorboardTimeSeries under a
  /// TensorboardRun.
  ///
  /// If any data fail to be ingested, an error is returned.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [tensorboardRun] - Required. The resource name of the TensorboardRun to
  /// write data to. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1WriteTensorboardRunDataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1WriteTensorboardRunDataResponse> write(
    GoogleCloudAiplatformV1WriteTensorboardRunDataRequest request,
    core.String tensorboardRun, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$tensorboardRun') + ':write';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1WriteTensorboardRunDataResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsExperimentsRunsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsRunsOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsResource
      get operations =>
          ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsResource(
              _requester);

  ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the TensorboardExperiment to
  /// create the TensorboardTimeSeries in. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// The TensorboardRuns referenced by the parent fields in the
  /// CreateTensorboardTimeSeriesRequest messages must be sub resources of this
  /// TensorboardExperiment.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+$`.
  ///
  /// [runsId] - null
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse>
      batchCreate(
    GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest request,
    core.String parent,
    core.String runsId, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$parent') +
        '/runs/' +
        commons.escapeVariable('$runsId') +
        '/timeSeries:batchCreate';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Reads multiple TensorboardTimeSeries' data.
  ///
  /// The data point number limit is 1000 for scalars, 100 for tensors and blob
  /// references. If the number of data points stored is less than the limit,
  /// all data is returned. Otherwise, the number limit of data points is
  /// randomly selected from this time series and returned.
  ///
  /// Request parameters:
  ///
  /// [tensorboard] - Required. The resource name of the Tensorboard containing
  /// TensorboardTimeSeries to read data from. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`. The
  /// TensorboardTimeSeries referenced by time_series must be sub resources of
  /// this Tensorboard.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [experimentsId] - null
  ///
  /// [runsId] - null
  ///
  /// [timeSeries] - Required. The resource names of the TensorboardTimeSeries
  /// to read data from. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async
      .Future<GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse>
      batchRead(
    core.String tensorboard,
    core.String experimentsId,
    core.String runsId, {
    core.List<core.String>? timeSeries,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeSeries != null) 'timeSeries': timeSeries,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$tensorboard') +
        '/experiments/' +
        commons.escapeVariable('$experimentsId') +
        '/runs/' +
        commons.escapeVariable('$runsId') +
        '/timeSeries:batchRead';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a TensorboardTimeSeries.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the TensorboardRun to create the
  /// TensorboardTimeSeries in. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [tensorboardTimeSeriesId] - Optional. The user specified unique ID to use
  /// for the TensorboardTimeSeries, which becomes the final component of the
  /// TensorboardTimeSeries's resource name. This value should match "a-z0-9{0,
  /// 127}"
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardTimeSeries].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardTimeSeries> create(
    GoogleCloudAiplatformV1TensorboardTimeSeries request,
    core.String parent, {
    core.String? tensorboardTimeSeriesId,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (tensorboardTimeSeriesId != null)
        'tensorboardTimeSeriesId': [tensorboardTimeSeriesId],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/timeSeries';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardTimeSeries.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a TensorboardTimeSeries.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TensorboardTimeSeries to be deleted.
  /// Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Exports a TensorboardTimeSeries' data.
  ///
  /// Data is returned in paginated responses.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [tensorboardTimeSeries] - Required. The resource name of the
  /// TensorboardTimeSeries to export data from. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse>
      exportTensorboardTimeSeries(
    GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest request,
    core.String tensorboardTimeSeries, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' +
        core.Uri.encodeFull('$tensorboardTimeSeries') +
        ':exportTensorboardTimeSeries';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a TensorboardTimeSeries.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TensorboardTimeSeries resource. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardTimeSeries].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardTimeSeries> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardTimeSeries.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists TensorboardTimeSeries in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the TensorboardRun to list
  /// TensorboardTimeSeries. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+$`.
  ///
  /// [filter] - Lists the TensorboardTimeSeries that match the filter
  /// expression.
  ///
  /// [orderBy] - Field to use to sort the list.
  ///
  /// [pageSize] - The maximum number of TensorboardTimeSeries to return. The
  /// service may return fewer than this value. If unspecified, at most 50
  /// TensorboardTimeSeries are returned. The maximum value is 1000; values
  /// above 1000 are coerced to 1000.
  ///
  /// [pageToken] - A page token, received from a previous
  /// TensorboardService.ListTensorboardTimeSeries call. Provide this to
  /// retrieve the subsequent page. When paginating, all other parameters
  /// provided to TensorboardService.ListTensorboardTimeSeries must match the
  /// call that provided the page token.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse> list(
    core.String parent, {
    core.String? filter,
    core.String? orderBy,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (orderBy != null) 'orderBy': [orderBy],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/timeSeries';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListTensorboardTimeSeriesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Updates a TensorboardTimeSeries.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Output only. Name of the TensorboardTimeSeries.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [updateMask] - Required. Field mask is used to specify the fields to be
  /// overwritten in the TensorboardTimeSeries resource by the update. The
  /// fields specified in the update_mask are relative to the resource, not the
  /// full request. A field is overwritten if it's in the mask. If the user does
  /// not provide a mask then all fields are overwritten if new values are
  /// specified.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TensorboardTimeSeries].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TensorboardTimeSeries> patch(
    GoogleCloudAiplatformV1TensorboardTimeSeries request,
    core.String name, {
    core.String? updateMask,
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if (updateMask != null) 'updateMask': [updateMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'PATCH',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TensorboardTimeSeries.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Reads a TensorboardTimeSeries' data.
  ///
  /// By default, if the number of data points stored is less than 1000, all
  /// data is returned. Otherwise, 1000 data points is randomly selected from
  /// this time series and returned. This value can be changed by changing
  /// max_data_points, which can't be greater than 10k.
  ///
  /// Request parameters:
  ///
  /// [tensorboardTimeSeries] - Required. The resource name of the
  /// TensorboardTimeSeries to read data from. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [filter] - Reads the TensorboardTimeSeries' data that match the filter
  /// expression.
  ///
  /// [maxDataPoints] - The maximum number of TensorboardTimeSeries' data to
  /// return. This value should be a positive integer. This value can be set to
  /// -1 to return all data.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a
  /// [GoogleCloudAiplatformV1ReadTensorboardTimeSeriesDataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadTensorboardTimeSeriesDataResponse>
      read(
    core.String tensorboardTimeSeries, {
    core.String? filter,
    core.int? maxDataPoints,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (maxDataPoints != null) 'maxDataPoints': ['${maxDataPoints}'],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ =
        'v1/' + core.Uri.encodeFull('$tensorboardTimeSeries') + ':read';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadTensorboardTimeSeriesDataResponse
        .fromJson(response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets bytes of TensorboardBlobs.
  ///
  /// This is to allow reading blob data stored in consumer project's Cloud
  /// Storage bucket without users having to obtain Cloud Storage access
  /// permission.
  ///
  /// Request parameters:
  ///
  /// [timeSeries] - Required. The resource name of the TensorboardTimeSeries to
  /// list Blobs. Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [blobIds] - IDs of the blobs to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ReadTensorboardBlobDataResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ReadTensorboardBlobDataResponse>
      readBlobData(
    core.String timeSeries, {
    core.List<core.String>? blobIds,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (blobIds != null) 'blobIds': blobIds,
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$timeSeries') + ':readBlobData';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ReadTensorboardBlobDataResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/experiments/\[^/\]+/runs/\[^/\]+/timeSeries/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTensorboardsOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTensorboardsOperationsResource(commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/tensorboards/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTrainingPipelinesResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTrainingPipelinesOperationsResource get operations =>
      ProjectsLocationsTrainingPipelinesOperationsResource(_requester);

  ProjectsLocationsTrainingPipelinesResource(commons.ApiRequester client)
      : _requester = client;

  /// Cancels a TrainingPipeline.
  ///
  /// Starts asynchronous cancellation on the TrainingPipeline. The server makes
  /// a best effort to cancel the pipeline, but success is not guaranteed.
  /// Clients can use PipelineService.GetTrainingPipeline or other methods to
  /// check whether the cancellation succeeded or whether the pipeline completed
  /// despite cancellation. On successful cancellation, the TrainingPipeline is
  /// not deleted; instead it becomes a pipeline with a TrainingPipeline.error
  /// value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`, and TrainingPipeline.state is set to `CANCELLED`.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TrainingPipeline to cancel. Format:
  /// `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    GoogleCloudAiplatformV1CancelTrainingPipelineRequest request,
    core.String name, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Creates a TrainingPipeline.
  ///
  /// A created TrainingPipeline right away will be attempted to be run.
  ///
  /// [request] - The metadata request object.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to create the
  /// TrainingPipeline in. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TrainingPipeline].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TrainingPipeline> create(
    GoogleCloudAiplatformV1TrainingPipeline request,
    core.String parent, {
    core.String? $fields,
  }) async {
    final body_ = convert.json.encode(request);
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/trainingPipelines';

    final response_ = await _requester.request(
      url_,
      'POST',
      body: body_,
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TrainingPipeline.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a TrainingPipeline.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TrainingPipeline resource to be
  /// deleted. Format:
  /// `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets a TrainingPipeline.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the TrainingPipeline resource. Format:
  /// `projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}`
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1TrainingPipeline].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1TrainingPipeline> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1TrainingPipeline.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists TrainingPipelines in a Location.
  ///
  /// Request parameters:
  ///
  /// [parent] - Required. The resource name of the Location to list the
  /// TrainingPipelines from. Format: `projects/{project}/locations/{location}`
  /// Value must have pattern `^projects/\[^/\]+/locations/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter. Supported fields: * \`display_name\`
  /// supports \`=\`, \`!=\` comparisons, and \`:\` wildcard. * \`state\`
  /// supports \`=\`, \`!=\` comparisons. * \`training_task_definition\` \`=\`,
  /// \`!=\` comparisons, and \`:\` wildcard. * \`create_time\` supports \`=\`,
  /// \`!=\`,\`\<\`, \`\<=\`,\`\>\`, \`\>=\` comparisons. \`create_time\` must
  /// be in RFC 3339 format. * \`labels\` supports general map functions that
  /// is: \`labels.key=value\` - key:value equality \`labels.key:* - key
  /// existence Some examples of using the filter are: *
  /// \`state="PIPELINE_STATE_SUCCEEDED" AND display_name:"my_pipeline_*"\` *
  /// \`state!="PIPELINE_STATE_FAILED" OR display_name="my_pipeline"\` * \`NOT
  /// display_name="my_pipeline"\` * \`create_time\>"2021-05-18T00:00:00Z"\` *
  /// \`training_task_definition:"*automl_text_classification*"\`
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token. Typically obtained via
  /// ListTrainingPipelinesResponse.next_page_token of the previous
  /// PipelineService.ListTrainingPipelines call.
  ///
  /// [readMask] - Mask specifying which fields to read.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1ListTrainingPipelinesResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1ListTrainingPipelinesResponse> list(
    core.String parent, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? readMask,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if (readMask != null) 'readMask': [readMask],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$parent') + '/trainingPipelines';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1ListTrainingPipelinesResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class ProjectsLocationsTrainingPipelinesOperationsResource {
  final commons.ApiRequester _requester;

  ProjectsLocationsTrainingPipelinesOperationsResource(
      commons.ApiRequester client)
      : _requester = client;

  /// Starts asynchronous cancellation on a long-running operation.
  ///
  /// The server makes a best effort to cancel the operation, but success is not
  /// guaranteed. If the server doesn't support this method, it returns
  /// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation
  /// or other methods to check whether the cancellation succeeded or whether
  /// the operation completed despite cancellation. On successful cancellation,
  /// the operation is not deleted; instead, it becomes an operation with an
  /// Operation.error value with a google.rpc.Status.code of 1, corresponding to
  /// `Code.CANCELLED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be cancelled.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> cancel(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':cancel';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Deletes a long-running operation.
  ///
  /// This method indicates that the client is no longer interested in the
  /// operation result. It does not cancel the operation. If the server doesn't
  /// support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to be deleted.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleProtobufEmpty].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleProtobufEmpty> delete(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'DELETE',
      queryParams: queryParams_,
    );
    return GoogleProtobufEmpty.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Gets the latest state of a long-running operation.
  ///
  /// Clients can use this method to poll the operation result at intervals as
  /// recommended by the API service.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> get(
    core.String name, {
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Lists operations that match the specified filter in the request.
  ///
  /// If the server doesn't support this method, it returns `UNIMPLEMENTED`.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation's parent resource.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+$`.
  ///
  /// [filter] - The standard list filter.
  ///
  /// [pageSize] - The standard list page size.
  ///
  /// [pageToken] - The standard list page token.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningListOperationsResponse].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningListOperationsResponse> list(
    core.String name, {
    core.String? filter,
    core.int? pageSize,
    core.String? pageToken,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (filter != null) 'filter': [filter],
      if (pageSize != null) 'pageSize': ['${pageSize}'],
      if (pageToken != null) 'pageToken': [pageToken],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + '/operations';

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleLongrunningListOperationsResponse.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }

  /// Waits until the specified long-running operation is done or reaches at
  /// most a specified timeout, returning the latest state.
  ///
  /// If the operation is already done, the latest state is immediately
  /// returned. If the timeout specified is greater than the default HTTP/RPC
  /// timeout, the HTTP/RPC timeout is used. If the server does not support this
  /// method, it returns `google.rpc.Code.UNIMPLEMENTED`. Note that this method
  /// is on a best-effort basis. It may return the latest state before the
  /// specified timeout (including immediately), meaning even an immediate
  /// response is no guarantee that the operation is done.
  ///
  /// Request parameters:
  ///
  /// [name] - The name of the operation resource to wait on.
  /// Value must have pattern
  /// `^projects/\[^/\]+/locations/\[^/\]+/trainingPipelines/\[^/\]+/operations/\[^/\]+$`.
  ///
  /// [timeout] - The maximum duration to wait before timing out. If left blank,
  /// the wait will be at most the time permitted by the underlying HTTP/RPC
  /// protocol. If RPC context deadline is also specified, the shorter one will
  /// be used.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleLongrunningOperation].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleLongrunningOperation> wait(
    core.String name, {
    core.String? timeout,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (timeout != null) 'timeout': [timeout],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name') + ':wait';

    final response_ = await _requester.request(
      url_,
      'POST',
      queryParams: queryParams_,
    );
    return GoogleLongrunningOperation.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

class PublishersResource {
  final commons.ApiRequester _requester;

  PublishersModelsResource get models => PublishersModelsResource(_requester);

  PublishersResource(commons.ApiRequester client) : _requester = client;
}

class PublishersModelsResource {
  final commons.ApiRequester _requester;

  PublishersModelsResource(commons.ApiRequester client) : _requester = client;

  /// Gets a Model Garden publisher model.
  ///
  /// Request parameters:
  ///
  /// [name] - Required. The name of the PublisherModel resource. Format:
  /// `publishers/{publisher}/models/{publisher_model}`
  /// Value must have pattern `^publishers/\[^/\]+/models/\[^/\]+$`.
  ///
  /// [languageCode] - Optional. The IETF BCP-47 language code representing the
  /// language in which the publisher model's text information should be written
  /// in (see go/bcp47).
  ///
  /// [view] - Optional. PublisherModel view specifying which fields to read.
  /// Possible string values are:
  /// - "PUBLISHER_MODEL_VIEW_UNSPECIFIED" : The default / unset value. The API
  /// will default to the BASIC view.
  /// - "PUBLISHER_MODEL_VIEW_BASIC" : Include basic metadata about the
  /// publisher model, but not the full contents.
  /// - "PUBLISHER_MODEL_VIEW_FULL" : Include everything.
  /// - "PUBLISHER_MODEL_VERSION_VIEW_BASIC" : Include: VersionId,
  /// ModelVersionExternalName, and SupportedActions.
  ///
  /// [$fields] - Selector specifying which fields to include in a partial
  /// response.
  ///
  /// Completes with a [GoogleCloudAiplatformV1PublisherModel].
  ///
  /// Completes with a [commons.ApiRequestError] if the API endpoint returned an
  /// error.
  ///
  /// If the used [http.Client] completes with an error when making a REST call,
  /// this method will complete with the same error.
  async.Future<GoogleCloudAiplatformV1PublisherModel> get(
    core.String name, {
    core.String? languageCode,
    core.String? view,
    core.String? $fields,
  }) async {
    final queryParams_ = <core.String, core.List<core.String>>{
      if (languageCode != null) 'languageCode': [languageCode],
      if (view != null) 'view': [view],
      if ($fields != null) 'fields': [$fields],
    };

    final url_ = 'v1/' + core.Uri.encodeFull('$name');

    final response_ = await _requester.request(
      url_,
      'GET',
      queryParams: queryParams_,
    );
    return GoogleCloudAiplatformV1PublisherModel.fromJson(
        response_ as core.Map<core.String, core.dynamic>);
  }
}

/// Message that represents an arbitrary HTTP body.
///
/// It should only be used for payload formats that can't be represented as
/// JSON, such as raw binary or an HTML page. This message can be used both in
/// streaming and non-streaming API methods in the request as well as the
/// response. It can be used as a top-level request field, which is convenient
/// if one wants to extract parameters from either the URL or HTTP template into
/// the request fields and also want access to the raw HTTP body. Example:
/// message GetResourceRequest { // A unique request id. string request_id = 1;
/// // The raw HTTP body is bound to this field. google.api.HttpBody http_body =
/// 2; } service ResourceService { rpc GetResource(GetResourceRequest) returns
/// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
/// (google.protobuf.Empty); } Example with streaming methods: service
/// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
/// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
/// (stream google.api.HttpBody); } Use of this type only changes how the
/// request and response bodies are handled, all other features will continue to
/// work unchanged.
typedef GoogleApiHttpBody = $HttpBody;

/// Parameters that configure the active learning pipeline.
///
/// Active learning will label the data incrementally by several iterations. For
/// every iteration, it will select a batch of data based on the sampling
/// strategy.
class GoogleCloudAiplatformV1ActiveLearningConfig {
  /// Max number of human labeled DataItems.
  core.String? maxDataItemCount;

  /// Max percent of total DataItems for human labeling.
  core.int? maxDataItemPercentage;

  /// Active learning data sampling config.
  ///
  /// For every active learning labeling iteration, it will select a batch of
  /// data based on the sampling strategy.
  GoogleCloudAiplatformV1SampleConfig? sampleConfig;

  /// CMLE training config.
  ///
  /// For every active learning labeling iteration, system will train a machine
  /// learning model on CMLE. The trained model will be used by data sampling
  /// algorithm to select DataItems.
  GoogleCloudAiplatformV1TrainingConfig? trainingConfig;

  GoogleCloudAiplatformV1ActiveLearningConfig({
    this.maxDataItemCount,
    this.maxDataItemPercentage,
    this.sampleConfig,
    this.trainingConfig,
  });

  GoogleCloudAiplatformV1ActiveLearningConfig.fromJson(core.Map json_)
      : this(
          maxDataItemCount: json_.containsKey('maxDataItemCount')
              ? json_['maxDataItemCount'] as core.String
              : null,
          maxDataItemPercentage: json_.containsKey('maxDataItemPercentage')
              ? json_['maxDataItemPercentage'] as core.int
              : null,
          sampleConfig: json_.containsKey('sampleConfig')
              ? GoogleCloudAiplatformV1SampleConfig.fromJson(
                  json_['sampleConfig'] as core.Map<core.String, core.dynamic>)
              : null,
          trainingConfig: json_.containsKey('trainingConfig')
              ? GoogleCloudAiplatformV1TrainingConfig.fromJson(
                  json_['trainingConfig']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maxDataItemCount != null) 'maxDataItemCount': maxDataItemCount!,
        if (maxDataItemPercentage != null)
          'maxDataItemPercentage': maxDataItemPercentage!,
        if (sampleConfig != null) 'sampleConfig': sampleConfig!,
        if (trainingConfig != null) 'trainingConfig': trainingConfig!,
      };
}

/// Request message for MetadataService.AddContextArtifactsAndExecutions.
class GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest {
  /// The resource names of the Artifacts to attribute to the Context.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
  core.List<core.String>? artifacts;

  /// The resource names of the Executions to associate with the Context.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
  core.List<core.String>? executions;

  GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest({
    this.artifacts,
    this.executions,
  });

  GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest.fromJson(
      core.Map json_)
      : this(
          artifacts: json_.containsKey('artifacts')
              ? (json_['artifacts'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          executions: json_.containsKey('executions')
              ? (json_['executions'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (artifacts != null) 'artifacts': artifacts!,
        if (executions != null) 'executions': executions!,
      };
}

/// Response message for MetadataService.AddContextArtifactsAndExecutions.
typedef GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse
    = $Empty;

/// Request message for MetadataService.AddContextChildren.
typedef GoogleCloudAiplatformV1AddContextChildrenRequest
    = $ContextChildrenRequest;

/// Response message for MetadataService.AddContextChildren.
typedef GoogleCloudAiplatformV1AddContextChildrenResponse = $Empty;

/// Request message for MetadataService.AddExecutionEvents.
class GoogleCloudAiplatformV1AddExecutionEventsRequest {
  /// The Events to create and add.
  core.List<GoogleCloudAiplatformV1Event>? events;

  GoogleCloudAiplatformV1AddExecutionEventsRequest({
    this.events,
  });

  GoogleCloudAiplatformV1AddExecutionEventsRequest.fromJson(core.Map json_)
      : this(
          events: json_.containsKey('events')
              ? (json_['events'] as core.List)
                  .map((value) => GoogleCloudAiplatformV1Event.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (events != null) 'events': events!,
      };
}

/// Response message for MetadataService.AddExecutionEvents.
typedef GoogleCloudAiplatformV1AddExecutionEventsResponse = $Empty;

/// Request message for VizierService.AddTrialMeasurement.
class GoogleCloudAiplatformV1AddTrialMeasurementRequest {
  /// The measurement to be added to a Trial.
  ///
  /// Required.
  GoogleCloudAiplatformV1Measurement? measurement;

  GoogleCloudAiplatformV1AddTrialMeasurementRequest({
    this.measurement,
  });

  GoogleCloudAiplatformV1AddTrialMeasurementRequest.fromJson(core.Map json_)
      : this(
          measurement: json_.containsKey('measurement')
              ? GoogleCloudAiplatformV1Measurement.fromJson(
                  json_['measurement'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (measurement != null) 'measurement': measurement!,
      };
}

/// Used to assign specific AnnotationSpec to a particular area of a DataItem or
/// the whole part of the DataItem.
class GoogleCloudAiplatformV1Annotation {
  /// The source of the Annotation.
  ///
  /// Output only.
  GoogleCloudAiplatformV1UserActionReference? annotationSource;

  /// Timestamp when this Annotation was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  ///
  /// Optional.
  core.String? etag;

  /// The labels with user-defined metadata to organize your Annotations.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. No more than
  /// 64 user labels can be associated with one Annotation(System labels are
  /// excluded). See https://goo.gl/xmQnxf for more information and examples of
  /// labels. System reserved label keys are prefixed with
  /// "aiplatform.googleapis.com/" and are immutable. Following system labels
  /// exist for each Annotation: *
  /// "aiplatform.googleapis.com/annotation_set_name": optional, name of the
  /// UI's annotation set this Annotation belongs to. If not set, the Annotation
  /// is not visible in the UI. * "aiplatform.googleapis.com/payload_schema":
  /// output only, its value is the payload_schema's title.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// Resource name of the Annotation.
  ///
  /// Output only.
  core.String? name;

  /// The schema of the payload can be found in payload_schema.
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Object? payload;

  /// Google Cloud Storage URI points to a YAML file describing payload.
  ///
  /// The schema is defined as an
  /// [OpenAPI 3.0.2 Schema Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
  /// The schema files that can be used here are found in
  /// gs://google-cloud-aiplatform/schema/dataset/annotation/, note that the
  /// chosen schema must be consistent with the parent Dataset's metadata.
  ///
  /// Required.
  core.String? payloadSchemaUri;

  /// Timestamp when this Annotation was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1Annotation({
    this.annotationSource,
    this.createTime,
    this.etag,
    this.labels,
    this.name,
    this.payload,
    this.payloadSchemaUri,
    this.updateTime,
  });

  GoogleCloudAiplatformV1Annotation.fromJson(core.Map json_)
      : this(
          annotationSource: json_.containsKey('annotationSource')
              ? GoogleCloudAiplatformV1UserActionReference.fromJson(
                  json_['annotationSource']
                      as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          payload: json_.containsKey('payload') ? json_['payload'] : null,
          payloadSchemaUri: json_.containsKey('payloadSchemaUri')
              ? json_['payloadSchemaUri'] as core.String
              : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (annotationSource != null) 'annotationSource': annotationSource!,
        if (createTime != null) 'createTime': createTime!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (payload != null) 'payload': payload!,
        if (payloadSchemaUri != null) 'payloadSchemaUri': payloadSchemaUri!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Identifies a concept with which DataItems may be annotated with.
class GoogleCloudAiplatformV1AnnotationSpec {
  /// Timestamp when this AnnotationSpec was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The user-defined name of the AnnotationSpec.
  ///
  /// The name can be up to 128 characters long and can consist of any UTF-8
  /// characters.
  ///
  /// Required.
  core.String? displayName;

  /// Used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  ///
  /// Optional.
  core.String? etag;

  /// Resource name of the AnnotationSpec.
  ///
  /// Output only.
  core.String? name;

  /// Timestamp when AnnotationSpec was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1AnnotationSpec({
    this.createTime,
    this.displayName,
    this.etag,
    this.name,
    this.updateTime,
  });

  GoogleCloudAiplatformV1AnnotationSpec.fromJson(core.Map json_)
      : this(
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (name != null) 'name': name!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Instance of a general artifact.
class GoogleCloudAiplatformV1Artifact {
  /// Timestamp when this Artifact was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the Artifact
  core.String? description;

  /// User provided display name of the Artifact.
  ///
  /// May be up to 128 Unicode characters.
  core.String? displayName;

  /// An eTag used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  core.String? etag;

  /// The labels with user-defined metadata to organize your Artifacts.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. No more than
  /// 64 user labels can be associated with one Artifact (System labels are
  /// excluded).
  core.Map<core.String, core.String>? labels;

  /// Properties of the Artifact.
  ///
  /// Top level metadata keys' heading and trailing spaces will be trimmed. The
  /// size of this field should not exceed 200KB.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? metadata;

  /// The resource name of the Artifact.
  ///
  /// Output only.
  core.String? name;

  /// The title of the schema describing the metadata.
  ///
  /// Schema title and version is expected to be registered in earlier Create
  /// Schema calls. And both are used together as unique identifiers to identify
  /// schemas within the local metadata store.
  core.String? schemaTitle;

  /// The version of the schema in schema_name to use.
  ///
  /// Schema title and version is expected to be registered in earlier Create
  /// Schema calls. And both are used together as unique identifiers to identify
  /// schemas within the local metadata store.
  core.String? schemaVersion;

  /// The state of this Artifact.
  ///
  /// This is a property of the Artifact, and does not imply or capture any
  /// ongoing process. This property is managed by clients (such as Vertex AI
  /// Pipelines), and the system does not prescribe or check the validity of
  /// state transitions.
  /// Possible string values are:
  /// - "STATE_UNSPECIFIED" : Unspecified state for the Artifact.
  /// - "PENDING" : A state used by systems like Vertex AI Pipelines to indicate
  /// that the underlying data item represented by this Artifact is being
  /// created.
  /// - "LIVE" : A state indicating that the Artifact should exist, unless
  /// something external to the system deletes it.
  core.String? state;

  /// Timestamp when this Artifact was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  /// The uniform resource identifier of the artifact file.
  ///
  /// May be empty if there is no actual artifact file.
  core.String? uri;

  GoogleCloudAiplatformV1Artifact({
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.metadata,
    this.name,
    this.schemaTitle,
    this.schemaVersion,
    this.state,
    this.updateTime,
    this.uri,
  });

  GoogleCloudAiplatformV1Artifact.fromJson(core.Map json_)
      : this(
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          metadata: json_.containsKey('metadata')
              ? json_['metadata'] as core.Map<core.String, core.dynamic>
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          schemaTitle: json_.containsKey('schemaTitle')
              ? json_['schemaTitle'] as core.String
              : null,
          schemaVersion: json_.containsKey('schemaVersion')
              ? json_['schemaVersion'] as core.String
              : null,
          state:
              json_.containsKey('state') ? json_['state'] as core.String : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
          uri: json_.containsKey('uri') ? json_['uri'] as core.String : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (metadata != null) 'metadata': metadata!,
        if (name != null) 'name': name!,
        if (schemaTitle != null) 'schemaTitle': schemaTitle!,
        if (schemaVersion != null) 'schemaVersion': schemaVersion!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
        if (uri != null) 'uri': uri!,
      };
}

/// Request message for NotebookService.AssignNotebookRuntime.
class GoogleCloudAiplatformV1AssignNotebookRuntimeRequest {
  /// Provide runtime specific information (e.g. runtime owner, notebook id)
  /// used for NotebookRuntime assignment.
  ///
  /// Required.
  GoogleCloudAiplatformV1NotebookRuntime? notebookRuntime;

  /// User specified ID for the notebook runtime.
  ///
  /// Optional.
  core.String? notebookRuntimeId;

  /// The resource name of the NotebookRuntimeTemplate based on which a
  /// NotebookRuntime will be assigned (reuse or create a new one).
  ///
  /// Required.
  core.String? notebookRuntimeTemplate;

  GoogleCloudAiplatformV1AssignNotebookRuntimeRequest({
    this.notebookRuntime,
    this.notebookRuntimeId,
    this.notebookRuntimeTemplate,
  });

  GoogleCloudAiplatformV1AssignNotebookRuntimeRequest.fromJson(core.Map json_)
      : this(
          notebookRuntime: json_.containsKey('notebookRuntime')
              ? GoogleCloudAiplatformV1NotebookRuntime.fromJson(
                  json_['notebookRuntime']
                      as core.Map<core.String, core.dynamic>)
              : null,
          notebookRuntimeId: json_.containsKey('notebookRuntimeId')
              ? json_['notebookRuntimeId'] as core.String
              : null,
          notebookRuntimeTemplate: json_.containsKey('notebookRuntimeTemplate')
              ? json_['notebookRuntimeTemplate'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (notebookRuntime != null) 'notebookRuntime': notebookRuntime!,
        if (notebookRuntimeId != null) 'notebookRuntimeId': notebookRuntimeId!,
        if (notebookRuntimeTemplate != null)
          'notebookRuntimeTemplate': notebookRuntimeTemplate!,
      };
}

/// Attribution that explains a particular prediction output.
class GoogleCloudAiplatformV1Attribution {
  /// Error of feature_attributions caused by approximation used in the
  /// explanation method.
  ///
  /// Lower value means more precise attributions. * For Sampled Shapley
  /// attribution, increasing path_count might reduce the error. * For
  /// Integrated Gradients attribution, increasing step_count might reduce the
  /// error. * For XRAI attribution, increasing step_count might reduce the
  /// error. See \[this introduction\](/vertex-ai/docs/explainable-ai/overview)
  /// for more information.
  ///
  /// Output only.
  core.double? approximationError;

  /// Model predicted output if the input instance is constructed from the
  /// baselines of all the features defined in ExplanationMetadata.inputs.
  ///
  /// The field name of the output is determined by the key in
  /// ExplanationMetadata.outputs. If the Model's predicted output has multiple
  /// dimensions (rank \> 1), this is the value in the output located by
  /// output_index. If there are multiple baselines, their output values are
  /// averaged.
  ///
  /// Output only.
  core.double? baselineOutputValue;

  /// Attributions of each explained feature.
  ///
  /// Features are extracted from the prediction instances according to
  /// explanation metadata for inputs. The value is a struct, whose keys are the
  /// name of the feature. The values are how much the feature in the instance
  /// contributed to the predicted result. The format of the value is determined
  /// by the feature's input format: * If the feature is a scalar value, the
  /// attribution value is a floating number. * If the feature is an array of
  /// scalar values, the attribution value is an array. * If the feature is a
  /// struct, the attribution value is a struct. The keys in the attribution
  /// value struct are the same as the keys in the feature struct. The formats
  /// of the values in the attribution struct are determined by the formats of
  /// the values in the feature struct. The
  /// ExplanationMetadata.feature_attributions_schema_uri field, pointed to by
  /// the ExplanationSpec field of the Endpoint.deployed_models object, points
  /// to the schema file that describes the features and their attribution
  /// values (if it is populated).
  ///
  /// Output only.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Object? featureAttributions;

  /// Model predicted output on the corresponding explanation instance.
  ///
  /// The field name of the output is determined by the key in
  /// ExplanationMetadata.outputs. If the Model predicted output has multiple
  /// dimensions, this is the value in the output located by output_index.
  ///
  /// Output only.
  core.double? instanceOutputValue;

  /// The display name of the output identified by output_index.
  ///
  /// For example, the predicted class name by a multi-classification Model.
  /// This field is only populated iff the Model predicts display names as a
  /// separate field along with the explained output. The predicted display name
  /// must has the same shape of the explained output, and can be located using
  /// output_index.
  ///
  /// Output only.
  core.String? outputDisplayName;

  /// The index that locates the explained prediction output.
  ///
  /// If the prediction output is a scalar value, output_index is not populated.
  /// If the prediction output has multiple dimensions, the length of the
  /// output_index list is the same as the number of dimensions of the output.
  /// The i-th element in output_index is the element index of the i-th
  /// dimension of the output vector. Indices start from 0.
  ///
  /// Output only.
  core.List<core.int>? outputIndex;

  /// Name of the explain output.
  ///
  /// Specified as the key in ExplanationMetadata.outputs.
  ///
  /// Output only.
  core.String? outputName;

  GoogleCloudAiplatformV1Attribution({
    this.approximationError,
    this.baselineOutputValue,
    this.featureAttributions,
    this.instanceOutputValue,
    this.outputDisplayName,
    this.outputIndex,
    this.outputName,
  });

  GoogleCloudAiplatformV1Attribution.fromJson(core.Map json_)
      : this(
          approximationError: json_.containsKey('approximationError')
              ? (json_['approximationError'] as core.num).toDouble()
              : null,
          baselineOutputValue: json_.containsKey('baselineOutputValue')
              ? (json_['baselineOutputValue'] as core.num).toDouble()
              : null,
          featureAttributions: json_.containsKey('featureAttributions')
              ? json_['featureAttributions']
              : null,
          instanceOutputValue: json_.containsKey('instanceOutputValue')
              ? (json_['instanceOutputValue'] as core.num).toDouble()
              : null,
          outputDisplayName: json_.containsKey('outputDisplayName')
              ? json_['outputDisplayName'] as core.String
              : null,
          outputIndex: json_.containsKey('outputIndex')
              ? (json_['outputIndex'] as core.List)
                  .map((value) => value as core.int)
                  .toList()
              : null,
          outputName: json_.containsKey('outputName')
              ? json_['outputName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (approximationError != null)
          'approximationError': approximationError!,
        if (baselineOutputValue != null)
          'baselineOutputValue': baselineOutputValue!,
        if (featureAttributions != null)
          'featureAttributions': featureAttributions!,
        if (instanceOutputValue != null)
          'instanceOutputValue': instanceOutputValue!,
        if (outputDisplayName != null) 'outputDisplayName': outputDisplayName!,
        if (outputIndex != null) 'outputIndex': outputIndex!,
        if (outputName != null) 'outputName': outputName!,
      };
}

/// A description of resources that to large degree are decided by Vertex AI,
/// and require only a modest additional configuration.
///
/// Each Model supporting these resources documents its specific guidelines.
class GoogleCloudAiplatformV1AutomaticResources {
  /// The maximum number of replicas this DeployedModel may be deployed on when
  /// the traffic against it increases.
  ///
  /// If the requested value is too large, the deployment will error, but if
  /// deployment succeeds then the ability to scale the model to that many
  /// replicas is guaranteed (barring service outages). If traffic against the
  /// DeployedModel increases beyond what its replicas at maximum may handle, a
  /// portion of the traffic will be dropped. If this value is not provided, a
  /// no upper bound for scaling under heavy traffic will be assume, though
  /// Vertex AI may be unable to scale beyond certain replica number.
  ///
  /// Immutable.
  core.int? maxReplicaCount;

  /// The minimum number of replicas this DeployedModel will be always deployed
  /// on.
  ///
  /// If traffic against it increases, it may dynamically be deployed onto more
  /// replicas up to max_replica_count, and as traffic decreases, some of these
  /// extra replicas may be freed. If the requested value is too large, the
  /// deployment will error.
  ///
  /// Immutable.
  core.int? minReplicaCount;

  GoogleCloudAiplatformV1AutomaticResources({
    this.maxReplicaCount,
    this.minReplicaCount,
  });

  GoogleCloudAiplatformV1AutomaticResources.fromJson(core.Map json_)
      : this(
          maxReplicaCount: json_.containsKey('maxReplicaCount')
              ? json_['maxReplicaCount'] as core.int
              : null,
          minReplicaCount: json_.containsKey('minReplicaCount')
              ? json_['minReplicaCount'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maxReplicaCount != null) 'maxReplicaCount': maxReplicaCount!,
        if (minReplicaCount != null) 'minReplicaCount': minReplicaCount!,
      };
}

/// The metric specification that defines the target resource utilization (CPU
/// utilization, accelerator's duty cycle, and so on) for calculating the
/// desired replica count.
class GoogleCloudAiplatformV1AutoscalingMetricSpec {
  /// The resource metric name.
  ///
  /// Supported metrics: * For Online Prediction: *
  /// `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` *
  /// `aiplatform.googleapis.com/prediction/online/cpu/utilization`
  ///
  /// Required.
  core.String? metricName;

  /// The target resource utilization in percentage (1% - 100%) for the given
  /// metric; once the real usage deviates from the target by a certain
  /// percentage, the machine replicas change.
  ///
  /// The default value is 60 (representing 60%) if not provided.
  core.int? target;

  GoogleCloudAiplatformV1AutoscalingMetricSpec({
    this.metricName,
    this.target,
  });

  GoogleCloudAiplatformV1AutoscalingMetricSpec.fromJson(core.Map json_)
      : this(
          metricName: json_.containsKey('metricName')
              ? json_['metricName'] as core.String
              : null,
          target:
              json_.containsKey('target') ? json_['target'] as core.int : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (metricName != null) 'metricName': metricName!,
        if (target != null) 'target': target!,
      };
}

/// The storage details for Avro input content.
class GoogleCloudAiplatformV1AvroSource {
  /// Google Cloud Storage location.
  ///
  /// Required.
  GoogleCloudAiplatformV1GcsSource? gcsSource;

  GoogleCloudAiplatformV1AvroSource({
    this.gcsSource,
  });

  GoogleCloudAiplatformV1AvroSource.fromJson(core.Map json_)
      : this(
          gcsSource: json_.containsKey('gcsSource')
              ? GoogleCloudAiplatformV1GcsSource.fromJson(
                  json_['gcsSource'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (gcsSource != null) 'gcsSource': gcsSource!,
      };
}

/// Request message for FeaturestoreService.BatchCreateFeatures.
class GoogleCloudAiplatformV1BatchCreateFeaturesRequest {
  /// The request message specifying the Features to create.
  ///
  /// All Features must be created under the same parent EntityType. The
  /// `parent` field in each child request message can be omitted. If `parent`
  /// is set in a child request, then the value must match the `parent` value in
  /// this request message.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1CreateFeatureRequest>? requests;

  GoogleCloudAiplatformV1BatchCreateFeaturesRequest({
    this.requests,
  });

  GoogleCloudAiplatformV1BatchCreateFeaturesRequest.fromJson(core.Map json_)
      : this(
          requests: json_.containsKey('requests')
              ? (json_['requests'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1CreateFeatureRequest.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (requests != null) 'requests': requests!,
      };
}

/// Request message for TensorboardService.BatchCreateTensorboardRuns.
class GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest {
  /// The request message specifying the TensorboardRuns to create.
  ///
  /// A maximum of 1000 TensorboardRuns can be created in a batch.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1CreateTensorboardRunRequest>? requests;

  GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest({
    this.requests,
  });

  GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest.fromJson(
      core.Map json_)
      : this(
          requests: json_.containsKey('requests')
              ? (json_['requests'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1CreateTensorboardRunRequest
                          .fromJson(
                              value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (requests != null) 'requests': requests!,
      };
}

/// Response message for TensorboardService.BatchCreateTensorboardRuns.
class GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse {
  /// The created TensorboardRuns.
  core.List<GoogleCloudAiplatformV1TensorboardRun>? tensorboardRuns;

  GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse({
    this.tensorboardRuns,
  });

  GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse.fromJson(
      core.Map json_)
      : this(
          tensorboardRuns: json_.containsKey('tensorboardRuns')
              ? (json_['tensorboardRuns'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1TensorboardRun.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (tensorboardRuns != null) 'tensorboardRuns': tensorboardRuns!,
      };
}

/// Request message for TensorboardService.BatchCreateTensorboardTimeSeries.
class GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest {
  /// The request message specifying the TensorboardTimeSeries to create.
  ///
  /// A maximum of 1000 TensorboardTimeSeries can be created in a batch.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest>?
      requests;

  GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest({
    this.requests,
  });

  GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest.fromJson(
      core.Map json_)
      : this(
          requests: json_.containsKey('requests')
              ? (json_['requests'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest
                          .fromJson(
                              value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (requests != null) 'requests': requests!,
      };
}

/// Response message for TensorboardService.BatchCreateTensorboardTimeSeries.
class GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse {
  /// The created TensorboardTimeSeries.
  core.List<GoogleCloudAiplatformV1TensorboardTimeSeries>?
      tensorboardTimeSeries;

  GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse({
    this.tensorboardTimeSeries,
  });

  GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse.fromJson(
      core.Map json_)
      : this(
          tensorboardTimeSeries: json_.containsKey('tensorboardTimeSeries')
              ? (json_['tensorboardTimeSeries'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1TensorboardTimeSeries.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (tensorboardTimeSeries != null)
          'tensorboardTimeSeries': tensorboardTimeSeries!,
      };
}

/// A description of resources that are used for performing batch operations,
/// are dedicated to a Model, and need manual configuration.
class GoogleCloudAiplatformV1BatchDedicatedResources {
  /// The specification of a single machine.
  ///
  /// Required. Immutable.
  GoogleCloudAiplatformV1MachineSpec? machineSpec;

  /// The maximum number of machine replicas the batch operation may be scaled
  /// to.
  ///
  /// The default value is 10.
  ///
  /// Immutable.
  core.int? maxReplicaCount;

  /// The number of machine replicas used at the start of the batch operation.
  ///
  /// If not set, Vertex AI decides starting number, not greater than
  /// max_replica_count
  ///
  /// Immutable.
  core.int? startingReplicaCount;

  GoogleCloudAiplatformV1BatchDedicatedResources({
    this.machineSpec,
    this.maxReplicaCount,
    this.startingReplicaCount,
  });

  GoogleCloudAiplatformV1BatchDedicatedResources.fromJson(core.Map json_)
      : this(
          machineSpec: json_.containsKey('machineSpec')
              ? GoogleCloudAiplatformV1MachineSpec.fromJson(
                  json_['machineSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          maxReplicaCount: json_.containsKey('maxReplicaCount')
              ? json_['maxReplicaCount'] as core.int
              : null,
          startingReplicaCount: json_.containsKey('startingReplicaCount')
              ? json_['startingReplicaCount'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (machineSpec != null) 'machineSpec': machineSpec!,
        if (maxReplicaCount != null) 'maxReplicaCount': maxReplicaCount!,
        if (startingReplicaCount != null)
          'startingReplicaCount': startingReplicaCount!,
      };
}

/// Request message for ModelService.BatchImportEvaluatedAnnotations
class GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest {
  /// Evaluated annotations resource to be imported.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1EvaluatedAnnotation>? evaluatedAnnotations;

  GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest({
    this.evaluatedAnnotations,
  });

  GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest.fromJson(
      core.Map json_)
      : this(
          evaluatedAnnotations: json_.containsKey('evaluatedAnnotations')
              ? (json_['evaluatedAnnotations'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1EvaluatedAnnotation.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (evaluatedAnnotations != null)
          'evaluatedAnnotations': evaluatedAnnotations!,
      };
}

/// Response message for ModelService.BatchImportEvaluatedAnnotations
class GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse {
  /// Number of EvaluatedAnnotations imported.
  ///
  /// Output only.
  core.int? importedEvaluatedAnnotationsCount;

  GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse({
    this.importedEvaluatedAnnotationsCount,
  });

  GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse.fromJson(
      core.Map json_)
      : this(
          importedEvaluatedAnnotationsCount:
              json_.containsKey('importedEvaluatedAnnotationsCount')
                  ? json_['importedEvaluatedAnnotationsCount'] as core.int
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (importedEvaluatedAnnotationsCount != null)
          'importedEvaluatedAnnotationsCount':
              importedEvaluatedAnnotationsCount!,
      };
}

/// Request message for MigrationService.BatchMigrateResources.
class GoogleCloudAiplatformV1BatchMigrateResourcesRequest {
  /// The request messages specifying the resources to migrate.
  ///
  /// They must be in the same location as the destination. Up to 50 resources
  /// can be migrated in one batch.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1MigrateResourceRequest>?
      migrateResourceRequests;

  GoogleCloudAiplatformV1BatchMigrateResourcesRequest({
    this.migrateResourceRequests,
  });

  GoogleCloudAiplatformV1BatchMigrateResourcesRequest.fromJson(core.Map json_)
      : this(
          migrateResourceRequests: json_.containsKey('migrateResourceRequests')
              ? (json_['migrateResourceRequests'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1MigrateResourceRequest.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (migrateResourceRequests != null)
          'migrateResourceRequests': migrateResourceRequests!,
      };
}

/// A job that uses a Model to produce predictions on multiple input instances.
///
/// If predictions for significant portion of the instances fail, the job may
/// finish without attempting predictions for all remaining instances.
class GoogleCloudAiplatformV1BatchPredictionJob {
  /// Statistics on completed and failed prediction instances.
  ///
  /// Output only.
  GoogleCloudAiplatformV1CompletionStats? completionStats;

  /// Time when the BatchPredictionJob was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The config of resources used by the Model during the batch prediction.
  ///
  /// If the Model supports DEDICATED_RESOURCES this config may be provided (and
  /// the job will use these resources), if the Model doesn't support
  /// AUTOMATIC_RESOURCES, this config must be provided.
  GoogleCloudAiplatformV1BatchDedicatedResources? dedicatedResources;

  /// For custom-trained Models and AutoML Tabular Models, the container of the
  /// DeployedModel instances will send `stderr` and `stdout` streams to Cloud
  /// Logging by default.
  ///
  /// Please note that the logs incur cost, which are subject to
  /// [Cloud Logging pricing](https://cloud.google.com/logging/pricing). User
  /// can disable container logging by setting this flag to true.
  core.bool? disableContainerLogging;

  /// The user-defined name of this BatchPredictionJob.
  ///
  /// Required.
  core.String? displayName;

  /// Customer-managed encryption key options for a BatchPredictionJob.
  ///
  /// If this is set, then all resources created by the BatchPredictionJob will
  /// be encrypted with the provided encryption key.
  GoogleCloudAiplatformV1EncryptionSpec? encryptionSpec;

  /// Time when the BatchPredictionJob entered any of the following states:
  /// `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
  ///
  /// Output only.
  core.String? endTime;

  /// Only populated when the job's state is JOB_STATE_FAILED or
  /// JOB_STATE_CANCELLED.
  ///
  /// Output only.
  GoogleRpcStatus? error;

  /// Explanation configuration for this BatchPredictionJob.
  ///
  /// Can be specified only if generate_explanation is set to `true`. This value
  /// overrides the value of Model.explanation_spec. All fields of
  /// explanation_spec are optional in the request. If a field of the
  /// explanation_spec object is not populated, the corresponding field of the
  /// Model.explanation_spec object is inherited.
  GoogleCloudAiplatformV1ExplanationSpec? explanationSpec;

  /// Generate explanation with the batch prediction results.
  ///
  /// When set to `true`, the batch prediction output changes based on the
  /// `predictions_format` field of the BatchPredictionJob.output_config object:
  /// * `bigquery`: output includes a column named `explanation`. The value is a
  /// struct that conforms to the Explanation object. * `jsonl`: The JSON
  /// objects on each line include an additional entry keyed `explanation`. The
  /// value of the entry is a JSON object that conforms to the Explanation
  /// object. * `csv`: Generating explanations for CSV format is not supported.
  /// If this field is set to true, either the Model.explanation_spec or
  /// explanation_spec must be populated.
  core.bool? generateExplanation;

  /// Input configuration of the instances on which predictions are performed.
  ///
  /// The schema of any single instance may be specified via the Model's
  /// PredictSchemata's instance_schema_uri.
  ///
  /// Required.
  GoogleCloudAiplatformV1BatchPredictionJobInputConfig? inputConfig;

  /// Configuration for how to convert batch prediction input instances to the
  /// prediction instances that are sent to the Model.
  GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig? instanceConfig;

  /// The labels with user-defined metadata to organize BatchPredictionJobs.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. See
  /// https://goo.gl/xmQnxf for more information and examples of labels.
  core.Map<core.String, core.String>? labels;

  /// Parameters configuring the batch behavior.
  ///
  /// Currently only applicable when dedicated_resources are used (in other
  /// cases Vertex AI does the tuning itself).
  ///
  /// Immutable.
  GoogleCloudAiplatformV1ManualBatchTuningParameters?
      manualBatchTuningParameters;

  /// The name of the Model resource that produces the predictions via this job,
  /// must share the same ancestor Location.
  ///
  /// Starting this job has no impact on any existing deployments of the Model
  /// and their resources. Exactly one of model and unmanaged_container_model
  /// must be set. The model resource name may contain version id or version
  /// alias to specify the version. Example:
  /// `projects/{project}/locations/{location}/models/{model}@2` or
  /// `projects/{project}/locations/{location}/models/{model}@golden` if no
  /// version is specified, the default version will be deployed. The model
  /// resource could also be a publisher model. Example:
  /// `publishers/{publisher}/models/{model}` or
  /// `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
  core.String? model;

  /// The parameters that govern the predictions.
  ///
  /// The schema of the parameters may be specified via the Model's
  /// PredictSchemata's parameters_schema_uri.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Object? modelParameters;

  /// The version ID of the Model that produces the predictions via this job.
  ///
  /// Output only.
  core.String? modelVersionId;

  /// Resource name of the BatchPredictionJob.
  ///
  /// Output only.
  core.String? name;

  /// The Configuration specifying where output predictions should be written.
  ///
  /// The schema of any single prediction may be specified as a concatenation of
  /// Model's PredictSchemata's instance_schema_uri and prediction_schema_uri.
  ///
  /// Required.
  GoogleCloudAiplatformV1BatchPredictionJobOutputConfig? outputConfig;

  /// Information further describing the output of this job.
  ///
  /// Output only.
  GoogleCloudAiplatformV1BatchPredictionJobOutputInfo? outputInfo;

  /// Partial failures encountered.
  ///
  /// For example, single files that can't be read. This field never exceeds 20
  /// entries. Status details fields contain standard Google Cloud error
  /// details.
  ///
  /// Output only.
  core.List<GoogleRpcStatus>? partialFailures;

  /// Information about resources that had been consumed by this job.
  ///
  /// Provided in real time at best effort basis, as well as a final value once
  /// the job completes. Note: This field currently may be not populated for
  /// batch predictions that use AutoML Models.
  ///
  /// Output only.
  GoogleCloudAiplatformV1ResourcesConsumed? resourcesConsumed;

  /// The service account that the DeployedModel's container runs as.
  ///
  /// If not specified, a system generated one will be used, which has minimal
  /// permissions and the custom container, if used, may not have enough
  /// permission to access other Google Cloud resources. Users deploying the
  /// Model must have the `iam.serviceAccounts.actAs` permission on this service
  /// account.
  core.String? serviceAccount;

  /// Time when the BatchPredictionJob for the first time entered the
  /// `JOB_STATE_RUNNING` state.
  ///
  /// Output only.
  core.String? startTime;

  /// The detailed state of the job.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "JOB_STATE_UNSPECIFIED" : The job state is unspecified.
  /// - "JOB_STATE_QUEUED" : The job has been just created or resumed and
  /// processing has not yet begun.
  /// - "JOB_STATE_PENDING" : The service is preparing to run the job.
  /// - "JOB_STATE_RUNNING" : The job is in progress.
  /// - "JOB_STATE_SUCCEEDED" : The job completed successfully.
  /// - "JOB_STATE_FAILED" : The job failed.
  /// - "JOB_STATE_CANCELLING" : The job is being cancelled. From this state the
  /// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
  /// `JOB_STATE_CANCELLED`.
  /// - "JOB_STATE_CANCELLED" : The job has been cancelled.
  /// - "JOB_STATE_PAUSED" : The job has been stopped, and can be resumed.
  /// - "JOB_STATE_EXPIRED" : The job has expired.
  /// - "JOB_STATE_UPDATING" : The job is being updated. Only jobs in the
  /// `RUNNING` state can be updated. After updating, the job goes back to the
  /// `RUNNING` state.
  /// - "JOB_STATE_PARTIALLY_SUCCEEDED" : The job is partially succeeded, some
  /// results may be missing due to errors.
  core.String? state;

  /// Contains model information necessary to perform batch prediction without
  /// requiring uploading to model registry.
  ///
  /// Exactly one of model and unmanaged_container_model must be set.
  GoogleCloudAiplatformV1UnmanagedContainerModel? unmanagedContainerModel;

  /// Time when the BatchPredictionJob was most recently updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1BatchPredictionJob({
    this.completionStats,
    this.createTime,
    this.dedicatedResources,
    this.disableContainerLogging,
    this.displayName,
    this.encryptionSpec,
    this.endTime,
    this.error,
    this.explanationSpec,
    this.generateExplanation,
    this.inputConfig,
    this.instanceConfig,
    this.labels,
    this.manualBatchTuningParameters,
    this.model,
    this.modelParameters,
    this.modelVersionId,
    this.name,
    this.outputConfig,
    this.outputInfo,
    this.partialFailures,
    this.resourcesConsumed,
    this.serviceAccount,
    this.startTime,
    this.state,
    this.unmanagedContainerModel,
    this.updateTime,
  });

  GoogleCloudAiplatformV1BatchPredictionJob.fromJson(core.Map json_)
      : this(
          completionStats: json_.containsKey('completionStats')
              ? GoogleCloudAiplatformV1CompletionStats.fromJson(
                  json_['completionStats']
                      as core.Map<core.String, core.dynamic>)
              : null,
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          dedicatedResources: json_.containsKey('dedicatedResources')
              ? GoogleCloudAiplatformV1BatchDedicatedResources.fromJson(
                  json_['dedicatedResources']
                      as core.Map<core.String, core.dynamic>)
              : null,
          disableContainerLogging: json_.containsKey('disableContainerLogging')
              ? json_['disableContainerLogging'] as core.bool
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          encryptionSpec: json_.containsKey('encryptionSpec')
              ? GoogleCloudAiplatformV1EncryptionSpec.fromJson(
                  json_['encryptionSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          endTime: json_.containsKey('endTime')
              ? json_['endTime'] as core.String
              : null,
          error: json_.containsKey('error')
              ? GoogleRpcStatus.fromJson(
                  json_['error'] as core.Map<core.String, core.dynamic>)
              : null,
          explanationSpec: json_.containsKey('explanationSpec')
              ? GoogleCloudAiplatformV1ExplanationSpec.fromJson(
                  json_['explanationSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          generateExplanation: json_.containsKey('generateExplanation')
              ? json_['generateExplanation'] as core.bool
              : null,
          inputConfig: json_.containsKey('inputConfig')
              ? GoogleCloudAiplatformV1BatchPredictionJobInputConfig.fromJson(
                  json_['inputConfig'] as core.Map<core.String, core.dynamic>)
              : null,
          instanceConfig: json_.containsKey('instanceConfig')
              ? GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig
                  .fromJson(json_['instanceConfig']
                      as core.Map<core.String, core.dynamic>)
              : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          manualBatchTuningParameters:
              json_.containsKey('manualBatchTuningParameters')
                  ? GoogleCloudAiplatformV1ManualBatchTuningParameters.fromJson(
                      json_['manualBatchTuningParameters']
                          as core.Map<core.String, core.dynamic>)
                  : null,
          model:
              json_.containsKey('model') ? json_['model'] as core.String : null,
          modelParameters: json_.containsKey('modelParameters')
              ? json_['modelParameters']
              : null,
          modelVersionId: json_.containsKey('modelVersionId')
              ? json_['modelVersionId'] as core.String
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          outputConfig: json_.containsKey('outputConfig')
              ? GoogleCloudAiplatformV1BatchPredictionJobOutputConfig.fromJson(
                  json_['outputConfig'] as core.Map<core.String, core.dynamic>)
              : null,
          outputInfo: json_.containsKey('outputInfo')
              ? GoogleCloudAiplatformV1BatchPredictionJobOutputInfo.fromJson(
                  json_['outputInfo'] as core.Map<core.String, core.dynamic>)
              : null,
          partialFailures: json_.containsKey('partialFailures')
              ? (json_['partialFailures'] as core.List)
                  .map((value) => GoogleRpcStatus.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          resourcesConsumed: json_.containsKey('resourcesConsumed')
              ? GoogleCloudAiplatformV1ResourcesConsumed.fromJson(
                  json_['resourcesConsumed']
                      as core.Map<core.String, core.dynamic>)
              : null,
          serviceAccount: json_.containsKey('serviceAccount')
              ? json_['serviceAccount'] as core.String
              : null,
          startTime: json_.containsKey('startTime')
              ? json_['startTime'] as core.String
              : null,
          state:
              json_.containsKey('state') ? json_['state'] as core.String : null,
          unmanagedContainerModel: json_.containsKey('unmanagedContainerModel')
              ? GoogleCloudAiplatformV1UnmanagedContainerModel.fromJson(
                  json_['unmanagedContainerModel']
                      as core.Map<core.String, core.dynamic>)
              : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (completionStats != null) 'completionStats': completionStats!,
        if (createTime != null) 'createTime': createTime!,
        if (dedicatedResources != null)
          'dedicatedResources': dedicatedResources!,
        if (disableContainerLogging != null)
          'disableContainerLogging': disableContainerLogging!,
        if (displayName != null) 'displayName': displayName!,
        if (encryptionSpec != null) 'encryptionSpec': encryptionSpec!,
        if (endTime != null) 'endTime': endTime!,
        if (error != null) 'error': error!,
        if (explanationSpec != null) 'explanationSpec': explanationSpec!,
        if (generateExplanation != null)
          'generateExplanation': generateExplanation!,
        if (inputConfig != null) 'inputConfig': inputConfig!,
        if (instanceConfig != null) 'instanceConfig': instanceConfig!,
        if (labels != null) 'labels': labels!,
        if (manualBatchTuningParameters != null)
          'manualBatchTuningParameters': manualBatchTuningParameters!,
        if (model != null) 'model': model!,
        if (modelParameters != null) 'modelParameters': modelParameters!,
        if (modelVersionId != null) 'modelVersionId': modelVersionId!,
        if (name != null) 'name': name!,
        if (outputConfig != null) 'outputConfig': outputConfig!,
        if (outputInfo != null) 'outputInfo': outputInfo!,
        if (partialFailures != null) 'partialFailures': partialFailures!,
        if (resourcesConsumed != null) 'resourcesConsumed': resourcesConsumed!,
        if (serviceAccount != null) 'serviceAccount': serviceAccount!,
        if (startTime != null) 'startTime': startTime!,
        if (state != null) 'state': state!,
        if (unmanagedContainerModel != null)
          'unmanagedContainerModel': unmanagedContainerModel!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Configures the input to BatchPredictionJob.
///
/// See Model.supported_input_storage_formats for Model's supported input
/// formats, and how instances should be expressed via any of them.
class GoogleCloudAiplatformV1BatchPredictionJobInputConfig {
  /// The BigQuery location of the input table.
  ///
  /// The schema of the table should be in the format described by the given
  /// context OpenAPI Schema, if one is provided. The table may contain
  /// additional columns that are not described by the schema, and they will be
  /// ignored.
  GoogleCloudAiplatformV1BigQuerySource? bigquerySource;

  /// The Cloud Storage location for the input instances.
  GoogleCloudAiplatformV1GcsSource? gcsSource;

  /// The format in which instances are given, must be one of the Model's
  /// supported_input_storage_formats.
  ///
  /// Required.
  core.String? instancesFormat;

  GoogleCloudAiplatformV1BatchPredictionJobInputConfig({
    this.bigquerySource,
    this.gcsSource,
    this.instancesFormat,
  });

  GoogleCloudAiplatformV1BatchPredictionJobInputConfig.fromJson(core.Map json_)
      : this(
          bigquerySource: json_.containsKey('bigquerySource')
              ? GoogleCloudAiplatformV1BigQuerySource.fromJson(
                  json_['bigquerySource']
                      as core.Map<core.String, core.dynamic>)
              : null,
          gcsSource: json_.containsKey('gcsSource')
              ? GoogleCloudAiplatformV1GcsSource.fromJson(
                  json_['gcsSource'] as core.Map<core.String, core.dynamic>)
              : null,
          instancesFormat: json_.containsKey('instancesFormat')
              ? json_['instancesFormat'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigquerySource != null) 'bigquerySource': bigquerySource!,
        if (gcsSource != null) 'gcsSource': gcsSource!,
        if (instancesFormat != null) 'instancesFormat': instancesFormat!,
      };
}

/// Configuration defining how to transform batch prediction input instances to
/// the instances that the Model accepts.
class GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig {
  /// Fields that will be excluded in the prediction instance that is sent to
  /// the Model.
  ///
  /// Excluded will be attached to the batch prediction output if key_field is
  /// not specified. When excluded_fields is populated, included_fields must be
  /// empty. The input must be JSONL with objects at each line, CSV, BigQuery or
  /// TfRecord.
  core.List<core.String>? excludedFields;

  /// Fields that will be included in the prediction instance that is sent to
  /// the Model.
  ///
  /// If instance_type is `array`, the order of field names in included_fields
  /// also determines the order of the values in the array. When included_fields
  /// is populated, excluded_fields must be empty. The input must be JSONL with
  /// objects at each line, CSV, BigQuery or TfRecord.
  core.List<core.String>? includedFields;

  /// The format of the instance that the Model accepts.
  ///
  /// Vertex AI will convert compatible batch prediction input instance formats
  /// to the specified format. Supported values are: * `object`: Each input is
  /// converted to JSON object format. * For `bigquery`, each row is converted
  /// to an object. * For `jsonl`, each line of the JSONL input must be an
  /// object. * Does not apply to `csv`, `file-list`, `tf-record`, or
  /// `tf-record-gzip`. * `array`: Each input is converted to JSON array format.
  /// * For `bigquery`, each row is converted to an array. The order of columns
  /// is determined by the BigQuery column order, unless included_fields is
  /// populated. included_fields must be populated for specifying field orders.
  /// * For `jsonl`, if each line of the JSONL input is an object,
  /// included_fields must be populated for specifying field orders. * Does not
  /// apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. If not
  /// specified, Vertex AI converts the batch prediction input as follows: * For
  /// `bigquery` and `csv`, the behavior is the same as `array`. The order of
  /// columns is the same as defined in the file or table, unless
  /// included_fields is populated. * For `jsonl`, the prediction instance
  /// format is determined by each line of the input. * For
  /// `tf-record`/`tf-record-gzip`, each record will be converted to an object
  /// in the format of `{"b64": }`, where `` is the Base64-encoded string of the
  /// content of the record. * For `file-list`, each file in the list will be
  /// converted to an object in the format of `{"b64": }`, where `` is the
  /// Base64-encoded string of the content of the file.
  core.String? instanceType;

  /// The name of the field that is considered as a key.
  ///
  /// The values identified by the key field is not included in the transformed
  /// instances that is sent to the Model. This is similar to specifying this
  /// name of the field in excluded_fields. In addition, the batch prediction
  /// output will not include the instances. Instead the output will only
  /// include the value of the key field, in a field named `key` in the output:
  /// * For `jsonl` output format, the output will have a `key` field instead of
  /// the `instance` field. * For `csv`/`bigquery` output format, the output
  /// will have have a `key` column instead of the instance feature columns. The
  /// input must be JSONL with objects at each line, CSV, BigQuery or TfRecord.
  core.String? keyField;

  GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig({
    this.excludedFields,
    this.includedFields,
    this.instanceType,
    this.keyField,
  });

  GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig.fromJson(
      core.Map json_)
      : this(
          excludedFields: json_.containsKey('excludedFields')
              ? (json_['excludedFields'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          includedFields: json_.containsKey('includedFields')
              ? (json_['includedFields'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          instanceType: json_.containsKey('instanceType')
              ? json_['instanceType'] as core.String
              : null,
          keyField: json_.containsKey('keyField')
              ? json_['keyField'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (excludedFields != null) 'excludedFields': excludedFields!,
        if (includedFields != null) 'includedFields': includedFields!,
        if (instanceType != null) 'instanceType': instanceType!,
        if (keyField != null) 'keyField': keyField!,
      };
}

/// Configures the output of BatchPredictionJob.
///
/// See Model.supported_output_storage_formats for supported output formats, and
/// how predictions are expressed via any of them.
class GoogleCloudAiplatformV1BatchPredictionJobOutputConfig {
  /// The BigQuery project or dataset location where the output is to be written
  /// to.
  ///
  /// If project is provided, a new dataset is created with name `prediction__`
  /// where is made BigQuery-dataset-name compatible (for example, most special
  /// characters become underscores), and timestamp is in
  /// YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset two
  /// tables will be created, `predictions`, and `errors`. If the Model has both
  /// instance and prediction schemata defined then the tables have columns as
  /// follows: The `predictions` table contains instances for which the
  /// prediction succeeded, it has columns as per a concatenation of the Model's
  /// instance and prediction schemata. The `errors` table contains rows for
  /// which the prediction has failed, it has instance columns, as per the
  /// instance schema, followed by a single "errors" column, which as values has
  /// google.rpc.Status represented as a STRUCT, and containing only `code` and
  /// `message`.
  GoogleCloudAiplatformV1BigQueryDestination? bigqueryDestination;

  /// The Cloud Storage location of the directory where the output is to be
  /// written to.
  ///
  /// In the given directory a new directory is created. Its name is
  /// `prediction--`, where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601
  /// format. Inside of it files `predictions_0001.`, `predictions_0002.`, ...,
  /// `predictions_N.` are created where `` depends on chosen
  /// predictions_format, and N may equal 0001 and depends on the total number
  /// of successfully predicted instances. If the Model has both instance and
  /// prediction schemata defined then each such file contains predictions as
  /// per the predictions_format. If prediction for any instance failed
  /// (partially or completely), then an additional `errors_0001.`,
  /// `errors_0002.`,..., `errors_N.` files are created (N depends on total
  /// number of failed predictions). These files contain the failed instances,
  /// as per their schema, followed by an additional `error` field which as
  /// value has google.rpc.Status containing only `code` and `message` fields.
  GoogleCloudAiplatformV1GcsDestination? gcsDestination;

  /// The format in which Vertex AI gives the predictions, must be one of the
  /// Model's supported_output_storage_formats.
  ///
  /// Required.
  core.String? predictionsFormat;

  GoogleCloudAiplatformV1BatchPredictionJobOutputConfig({
    this.bigqueryDestination,
    this.gcsDestination,
    this.predictionsFormat,
  });

  GoogleCloudAiplatformV1BatchPredictionJobOutputConfig.fromJson(core.Map json_)
      : this(
          bigqueryDestination: json_.containsKey('bigqueryDestination')
              ? GoogleCloudAiplatformV1BigQueryDestination.fromJson(
                  json_['bigqueryDestination']
                      as core.Map<core.String, core.dynamic>)
              : null,
          gcsDestination: json_.containsKey('gcsDestination')
              ? GoogleCloudAiplatformV1GcsDestination.fromJson(
                  json_['gcsDestination']
                      as core.Map<core.String, core.dynamic>)
              : null,
          predictionsFormat: json_.containsKey('predictionsFormat')
              ? json_['predictionsFormat'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryDestination != null)
          'bigqueryDestination': bigqueryDestination!,
        if (gcsDestination != null) 'gcsDestination': gcsDestination!,
        if (predictionsFormat != null) 'predictionsFormat': predictionsFormat!,
      };
}

/// Further describes this job's output.
///
/// Supplements output_config.
class GoogleCloudAiplatformV1BatchPredictionJobOutputInfo {
  /// The path of the BigQuery dataset created, in `bq://projectId.bqDatasetId`
  /// format, into which the prediction output is written.
  ///
  /// Output only.
  core.String? bigqueryOutputDataset;

  /// The name of the BigQuery table created, in `predictions_` format, into
  /// which the prediction output is written.
  ///
  /// Can be used by UI to generate the BigQuery output path, for example.
  ///
  /// Output only.
  core.String? bigqueryOutputTable;

  /// The full path of the Cloud Storage directory created, into which the
  /// prediction output is written.
  ///
  /// Output only.
  core.String? gcsOutputDirectory;

  GoogleCloudAiplatformV1BatchPredictionJobOutputInfo({
    this.bigqueryOutputDataset,
    this.bigqueryOutputTable,
    this.gcsOutputDirectory,
  });

  GoogleCloudAiplatformV1BatchPredictionJobOutputInfo.fromJson(core.Map json_)
      : this(
          bigqueryOutputDataset: json_.containsKey('bigqueryOutputDataset')
              ? json_['bigqueryOutputDataset'] as core.String
              : null,
          bigqueryOutputTable: json_.containsKey('bigqueryOutputTable')
              ? json_['bigqueryOutputTable'] as core.String
              : null,
          gcsOutputDirectory: json_.containsKey('gcsOutputDirectory')
              ? json_['gcsOutputDirectory'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryOutputDataset != null)
          'bigqueryOutputDataset': bigqueryOutputDataset!,
        if (bigqueryOutputTable != null)
          'bigqueryOutputTable': bigqueryOutputTable!,
        if (gcsOutputDirectory != null)
          'gcsOutputDirectory': gcsOutputDirectory!,
      };
}

/// Request message for FeaturestoreService.BatchReadFeatureValues.
class GoogleCloudAiplatformV1BatchReadFeatureValuesRequest {
  /// Similar to csv_read_instances, but from BigQuery source.
  GoogleCloudAiplatformV1BigQuerySource? bigqueryReadInstances;

  /// Each read instance consists of exactly one read timestamp and one or more
  /// entity IDs identifying entities of the corresponding EntityTypes whose
  /// Features are requested.
  ///
  /// Each output instance contains Feature values of requested entities
  /// concatenated together as of the read time. An example read instance may be
  /// `foo_entity_id, bar_entity_id, 2020-01-01T10:00:00.123Z`. An example
  /// output instance may be `foo_entity_id, bar_entity_id,
  /// 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
  /// bar_entity_feature2_value`. Timestamp in each read instance must be
  /// millisecond-aligned. `csv_read_instances` are read instances stored in a
  /// plain-text CSV file. The header should be: \[ENTITY_TYPE_ID1\],
  /// \[ENTITY_TYPE_ID2\], ..., timestamp The columns can be in any order.
  /// Values in the timestamp column must use the RFC 3339 format, e.g.
  /// `2012-07-30T10:43:17.123Z`.
  GoogleCloudAiplatformV1CsvSource? csvReadInstances;

  /// Specifies output location and format.
  ///
  /// Required.
  GoogleCloudAiplatformV1FeatureValueDestination? destination;

  /// Specifies EntityType grouping Features to read values of and settings.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec>?
      entityTypeSpecs;

  /// When not empty, the specified fields in the *_read_instances source will
  /// be joined as-is in the output, in addition to those fields from the
  /// Featurestore Entity.
  ///
  /// For BigQuery source, the type of the pass-through values will be
  /// automatically inferred. For CSV source, the pass-through values will be
  /// passed as opaque bytes.
  core.List<
          GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField>?
      passThroughFields;

  /// Excludes Feature values with feature generation timestamp before this
  /// timestamp.
  ///
  /// If not set, retrieve oldest values kept in Feature Store. Timestamp, if
  /// present, must not have higher than millisecond precision.
  ///
  /// Optional.
  core.String? startTime;

  GoogleCloudAiplatformV1BatchReadFeatureValuesRequest({
    this.bigqueryReadInstances,
    this.csvReadInstances,
    this.destination,
    this.entityTypeSpecs,
    this.passThroughFields,
    this.startTime,
  });

  GoogleCloudAiplatformV1BatchReadFeatureValuesRequest.fromJson(core.Map json_)
      : this(
          bigqueryReadInstances: json_.containsKey('bigqueryReadInstances')
              ? GoogleCloudAiplatformV1BigQuerySource.fromJson(
                  json_['bigqueryReadInstances']
                      as core.Map<core.String, core.dynamic>)
              : null,
          csvReadInstances: json_.containsKey('csvReadInstances')
              ? GoogleCloudAiplatformV1CsvSource.fromJson(
                  json_['csvReadInstances']
                      as core.Map<core.String, core.dynamic>)
              : null,
          destination: json_.containsKey('destination')
              ? GoogleCloudAiplatformV1FeatureValueDestination.fromJson(
                  json_['destination'] as core.Map<core.String, core.dynamic>)
              : null,
          entityTypeSpecs: json_.containsKey('entityTypeSpecs')
              ? (json_['entityTypeSpecs'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec
                          .fromJson(
                              value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          passThroughFields: json_.containsKey('passThroughFields')
              ? (json_['passThroughFields'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField
                          .fromJson(
                              value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          startTime: json_.containsKey('startTime')
              ? json_['startTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigqueryReadInstances != null)
          'bigqueryReadInstances': bigqueryReadInstances!,
        if (csvReadInstances != null) 'csvReadInstances': csvReadInstances!,
        if (destination != null) 'destination': destination!,
        if (entityTypeSpecs != null) 'entityTypeSpecs': entityTypeSpecs!,
        if (passThroughFields != null) 'passThroughFields': passThroughFields!,
        if (startTime != null) 'startTime': startTime!,
      };
}

/// Selects Features of an EntityType to read values of and specifies read
/// settings.
class GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec {
  /// ID of the EntityType to select Features.
  ///
  /// The EntityType id is the entity_type_id specified during EntityType
  /// creation.
  ///
  /// Required.
  core.String? entityTypeId;

  /// Selectors choosing which Feature values to read from the EntityType.
  ///
  /// Required.
  GoogleCloudAiplatformV1FeatureSelector? featureSelector;

  /// Per-Feature settings for the batch read.
  core.List<GoogleCloudAiplatformV1DestinationFeatureSetting>? settings;

  GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec({
    this.entityTypeId,
    this.featureSelector,
    this.settings,
  });

  GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec.fromJson(
      core.Map json_)
      : this(
          entityTypeId: json_.containsKey('entityTypeId')
              ? json_['entityTypeId'] as core.String
              : null,
          featureSelector: json_.containsKey('featureSelector')
              ? GoogleCloudAiplatformV1FeatureSelector.fromJson(
                  json_['featureSelector']
                      as core.Map<core.String, core.dynamic>)
              : null,
          settings: json_.containsKey('settings')
              ? (json_['settings'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1DestinationFeatureSetting.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entityTypeId != null) 'entityTypeId': entityTypeId!,
        if (featureSelector != null) 'featureSelector': featureSelector!,
        if (settings != null) 'settings': settings!,
      };
}

/// Describe pass-through fields in read_instance source.
class GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField {
  /// The name of the field in the CSV header or the name of the column in
  /// BigQuery table.
  ///
  /// The naming restriction is the same as Feature.name.
  ///
  /// Required.
  core.String? fieldName;

  GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField({
    this.fieldName,
  });

  GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField.fromJson(
      core.Map json_)
      : this(
          fieldName: json_.containsKey('fieldName')
              ? json_['fieldName'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (fieldName != null) 'fieldName': fieldName!,
      };
}

/// Response message for TensorboardService.BatchReadTensorboardTimeSeriesData.
class GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse {
  /// The returned time series data.
  core.List<GoogleCloudAiplatformV1TimeSeriesData>? timeSeriesData;

  GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse({
    this.timeSeriesData,
  });

  GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse.fromJson(
      core.Map json_)
      : this(
          timeSeriesData: json_.containsKey('timeSeriesData')
              ? (json_['timeSeriesData'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1TimeSeriesData.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (timeSeriesData != null) 'timeSeriesData': timeSeriesData!,
      };
}

/// The BigQuery location for the output content.
class GoogleCloudAiplatformV1BigQueryDestination {
  /// BigQuery URI to a project or table, up to 2000 characters long.
  ///
  /// When only the project is specified, the Dataset and Table is created. When
  /// the full table reference is specified, the Dataset must exist and table
  /// must not exist. Accepted forms: * BigQuery path. For example:
  /// `bq://projectId` or `bq://projectId.bqDatasetId` or
  /// `bq://projectId.bqDatasetId.bqTableId`.
  ///
  /// Required.
  core.String? outputUri;

  GoogleCloudAiplatformV1BigQueryDestination({
    this.outputUri,
  });

  GoogleCloudAiplatformV1BigQueryDestination.fromJson(core.Map json_)
      : this(
          outputUri: json_.containsKey('outputUri')
              ? json_['outputUri'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (outputUri != null) 'outputUri': outputUri!,
      };
}

/// The BigQuery location for the input content.
class GoogleCloudAiplatformV1BigQuerySource {
  /// BigQuery URI to a table, up to 2000 characters long.
  ///
  /// Accepted forms: * BigQuery path. For example:
  /// `bq://projectId.bqDatasetId.bqTableId`.
  ///
  /// Required.
  core.String? inputUri;

  GoogleCloudAiplatformV1BigQuerySource({
    this.inputUri,
  });

  GoogleCloudAiplatformV1BigQuerySource.fromJson(core.Map json_)
      : this(
          inputUri: json_.containsKey('inputUri')
              ? json_['inputUri'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (inputUri != null) 'inputUri': inputUri!,
      };
}

/// Config for blur baseline.
///
/// When enabled, a linear path from the maximally blurred image to the input
/// image is created. Using a blurred baseline instead of zero (black image) is
/// motivated by the BlurIG approach explained here:
/// https://arxiv.org/abs/2004.03383
class GoogleCloudAiplatformV1BlurBaselineConfig {
  /// The standard deviation of the blur kernel for the blurred baseline.
  ///
  /// The same blurring parameter is used for both the height and the width
  /// dimension. If not set, the method defaults to the zero (i.e. black for
  /// images) baseline.
  core.double? maxBlurSigma;

  GoogleCloudAiplatformV1BlurBaselineConfig({
    this.maxBlurSigma,
  });

  GoogleCloudAiplatformV1BlurBaselineConfig.fromJson(core.Map json_)
      : this(
          maxBlurSigma: json_.containsKey('maxBlurSigma')
              ? (json_['maxBlurSigma'] as core.num).toDouble()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (maxBlurSigma != null) 'maxBlurSigma': maxBlurSigma!,
      };
}

/// A list of boolean values.
class GoogleCloudAiplatformV1BoolArray {
  /// A list of bool values.
  core.List<core.bool>? values;

  GoogleCloudAiplatformV1BoolArray({
    this.values,
  });

  GoogleCloudAiplatformV1BoolArray.fromJson(core.Map json_)
      : this(
          values: json_.containsKey('values')
              ? (json_['values'] as core.List)
                  .map((value) => value as core.bool)
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (values != null) 'values': values!,
      };
}

/// Request message for JobService.CancelBatchPredictionJob.
typedef GoogleCloudAiplatformV1CancelBatchPredictionJobRequest = $Empty;

/// Request message for JobService.CancelCustomJob.
typedef GoogleCloudAiplatformV1CancelCustomJobRequest = $Empty;

/// Request message for JobService.CancelDataLabelingJob.
typedef GoogleCloudAiplatformV1CancelDataLabelingJobRequest = $Empty;

/// Request message for JobService.CancelHyperparameterTuningJob.
typedef GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest = $Empty;

/// Request message for JobService.CancelNasJob.
typedef GoogleCloudAiplatformV1CancelNasJobRequest = $Empty;

/// Request message for PipelineService.CancelPipelineJob.
typedef GoogleCloudAiplatformV1CancelPipelineJobRequest = $Empty;

/// Request message for PipelineService.CancelTrainingPipeline.
typedef GoogleCloudAiplatformV1CancelTrainingPipelineRequest = $Empty;

/// Request message for VizierService.CheckTrialEarlyStoppingState.
typedef GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest = $Empty;

/// Request message for VizierService.CompleteTrial.
class GoogleCloudAiplatformV1CompleteTrialRequest {
  /// If provided, it will be used as the completed Trial's final_measurement;
  /// Otherwise, the service will auto-select a previously reported measurement
  /// as the final-measurement
  ///
  /// Optional.
  GoogleCloudAiplatformV1Measurement? finalMeasurement;

  /// A human readable reason why the trial was infeasible.
  ///
  /// This should only be provided if `trial_infeasible` is true.
  ///
  /// Optional.
  core.String? infeasibleReason;

  /// True if the Trial cannot be run with the given Parameter, and
  /// final_measurement will be ignored.
  ///
  /// Optional.
  core.bool? trialInfeasible;

  GoogleCloudAiplatformV1CompleteTrialRequest({
    this.finalMeasurement,
    this.infeasibleReason,
    this.trialInfeasible,
  });

  GoogleCloudAiplatformV1CompleteTrialRequest.fromJson(core.Map json_)
      : this(
          finalMeasurement: json_.containsKey('finalMeasurement')
              ? GoogleCloudAiplatformV1Measurement.fromJson(
                  json_['finalMeasurement']
                      as core.Map<core.String, core.dynamic>)
              : null,
          infeasibleReason: json_.containsKey('infeasibleReason')
              ? json_['infeasibleReason'] as core.String
              : null,
          trialInfeasible: json_.containsKey('trialInfeasible')
              ? json_['trialInfeasible'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (finalMeasurement != null) 'finalMeasurement': finalMeasurement!,
        if (infeasibleReason != null) 'infeasibleReason': infeasibleReason!,
        if (trialInfeasible != null) 'trialInfeasible': trialInfeasible!,
      };
}

/// Success and error statistics of processing multiple entities (for example,
/// DataItems or structured data rows) in batch.
class GoogleCloudAiplatformV1CompletionStats {
  /// The number of entities for which any error was encountered.
  ///
  /// Output only.
  core.String? failedCount;

  /// In cases when enough errors are encountered a job, pipeline, or operation
  /// may be failed as a whole.
  ///
  /// Below is the number of entities for which the processing had not been
  /// finished (either in successful or failed state). Set to -1 if the number
  /// is unknown (for example, the operation failed before the total entity
  /// number could be collected).
  ///
  /// Output only.
  core.String? incompleteCount;

  /// The number of entities that had been processed successfully.
  ///
  /// Output only.
  core.String? successfulCount;

  /// The number of the successful forecast points that are generated by the
  /// forecasting model.
  ///
  /// This is ONLY used by the forecasting batch prediction.
  ///
  /// Output only.
  core.String? successfulForecastPointCount;

  GoogleCloudAiplatformV1CompletionStats({
    this.failedCount,
    this.incompleteCount,
    this.successfulCount,
    this.successfulForecastPointCount,
  });

  GoogleCloudAiplatformV1CompletionStats.fromJson(core.Map json_)
      : this(
          failedCount: json_.containsKey('failedCount')
              ? json_['failedCount'] as core.String
              : null,
          incompleteCount: json_.containsKey('incompleteCount')
              ? json_['incompleteCount'] as core.String
              : null,
          successfulCount: json_.containsKey('successfulCount')
              ? json_['successfulCount'] as core.String
              : null,
          successfulForecastPointCount:
              json_.containsKey('successfulForecastPointCount')
                  ? json_['successfulForecastPointCount'] as core.String
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (failedCount != null) 'failedCount': failedCount!,
        if (incompleteCount != null) 'incompleteCount': incompleteCount!,
        if (successfulCount != null) 'successfulCount': successfulCount!,
        if (successfulForecastPointCount != null)
          'successfulForecastPointCount': successfulForecastPointCount!,
      };
}

/// Request message for ComputeTokens RPC call.
class GoogleCloudAiplatformV1ComputeTokensRequest {
  /// The instances that are the input to token computing API call.
  ///
  /// Schema is identical to the prediction schema of the text model, even for
  /// the non-text models, like chat models, or Codey models.
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.List<core.Object?>? instances;

  GoogleCloudAiplatformV1ComputeTokensRequest({
    this.instances,
  });

  GoogleCloudAiplatformV1ComputeTokensRequest.fromJson(core.Map json_)
      : this(
          instances: json_.containsKey('instances')
              ? json_['instances'] as core.List
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (instances != null) 'instances': instances!,
      };
}

/// Response message for ComputeTokens RPC call.
class GoogleCloudAiplatformV1ComputeTokensResponse {
  /// Lists of tokens info from the input.
  ///
  /// A ComputeTokensRequest could have multiple instances with a prompt in each
  /// instance. We also need to return lists of tokens info for the request with
  /// multiple instances.
  core.List<GoogleCloudAiplatformV1TokensInfo>? tokensInfo;

  GoogleCloudAiplatformV1ComputeTokensResponse({
    this.tokensInfo,
  });

  GoogleCloudAiplatformV1ComputeTokensResponse.fromJson(core.Map json_)
      : this(
          tokensInfo: json_.containsKey('tokensInfo')
              ? (json_['tokensInfo'] as core.List)
                  .map((value) => GoogleCloudAiplatformV1TokensInfo.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (tokensInfo != null) 'tokensInfo': tokensInfo!,
      };
}

/// The Container Registry location for the container image.
class GoogleCloudAiplatformV1ContainerRegistryDestination {
  /// Container Registry URI of a container image.
  ///
  /// Only Google Container Registry and Artifact Registry are supported now.
  /// Accepted forms: * Google Container Registry path. For example:
  /// `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example:
  /// `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag is
  /// not specified, "latest" will be used as the default tag.
  ///
  /// Required.
  core.String? outputUri;

  GoogleCloudAiplatformV1ContainerRegistryDestination({
    this.outputUri,
  });

  GoogleCloudAiplatformV1ContainerRegistryDestination.fromJson(core.Map json_)
      : this(
          outputUri: json_.containsKey('outputUri')
              ? json_['outputUri'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (outputUri != null) 'outputUri': outputUri!,
      };
}

/// The spec of a Container.
class GoogleCloudAiplatformV1ContainerSpec {
  /// The arguments to be passed when starting the container.
  core.List<core.String>? args;

  /// The command to be invoked when the container is started.
  ///
  /// It overrides the entrypoint instruction in Dockerfile when provided.
  core.List<core.String>? command;

  /// Environment variables to be passed to the container.
  ///
  /// Maximum limit is 100.
  core.List<GoogleCloudAiplatformV1EnvVar>? env;

  /// The URI of a container image in the Container Registry that is to be run
  /// on each worker replica.
  ///
  /// Required.
  core.String? imageUri;

  GoogleCloudAiplatformV1ContainerSpec({
    this.args,
    this.command,
    this.env,
    this.imageUri,
  });

  GoogleCloudAiplatformV1ContainerSpec.fromJson(core.Map json_)
      : this(
          args: json_.containsKey('args')
              ? (json_['args'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          command: json_.containsKey('command')
              ? (json_['command'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          env: json_.containsKey('env')
              ? (json_['env'] as core.List)
                  .map((value) => GoogleCloudAiplatformV1EnvVar.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          imageUri: json_.containsKey('imageUri')
              ? json_['imageUri'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (args != null) 'args': args!,
        if (command != null) 'command': command!,
        if (env != null) 'env': env!,
        if (imageUri != null) 'imageUri': imageUri!,
      };
}

/// Instance of a general context.
class GoogleCloudAiplatformV1Context {
  /// Timestamp when this Context was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Description of the Context
  core.String? description;

  /// User provided display name of the Context.
  ///
  /// May be up to 128 Unicode characters.
  core.String? displayName;

  /// An eTag used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  core.String? etag;

  /// The labels with user-defined metadata to organize your Contexts.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. No more than
  /// 64 user labels can be associated with one Context (System labels are
  /// excluded).
  core.Map<core.String, core.String>? labels;

  /// Properties of the Context.
  ///
  /// Top level metadata keys' heading and trailing spaces will be trimmed. The
  /// size of this field should not exceed 200KB.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Map<core.String, core.Object?>? metadata;

  /// The resource name of the Context.
  ///
  /// Immutable.
  core.String? name;

  /// A list of resource names of Contexts that are parents of this Context.
  ///
  /// A Context may have at most 10 parent_contexts.
  ///
  /// Output only.
  core.List<core.String>? parentContexts;

  /// The title of the schema describing the metadata.
  ///
  /// Schema title and version is expected to be registered in earlier Create
  /// Schema calls. And both are used together as unique identifiers to identify
  /// schemas within the local metadata store.
  core.String? schemaTitle;

  /// The version of the schema in schema_name to use.
  ///
  /// Schema title and version is expected to be registered in earlier Create
  /// Schema calls. And both are used together as unique identifiers to identify
  /// schemas within the local metadata store.
  core.String? schemaVersion;

  /// Timestamp when this Context was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1Context({
    this.createTime,
    this.description,
    this.displayName,
    this.etag,
    this.labels,
    this.metadata,
    this.name,
    this.parentContexts,
    this.schemaTitle,
    this.schemaVersion,
    this.updateTime,
  });

  GoogleCloudAiplatformV1Context.fromJson(core.Map json_)
      : this(
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          metadata: json_.containsKey('metadata')
              ? json_['metadata'] as core.Map<core.String, core.dynamic>
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          parentContexts: json_.containsKey('parentContexts')
              ? (json_['parentContexts'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          schemaTitle: json_.containsKey('schemaTitle')
              ? json_['schemaTitle'] as core.String
              : null,
          schemaVersion: json_.containsKey('schemaVersion')
              ? json_['schemaVersion'] as core.String
              : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (metadata != null) 'metadata': metadata!,
        if (name != null) 'name': name!,
        if (parentContexts != null) 'parentContexts': parentContexts!,
        if (schemaTitle != null) 'schemaTitle': schemaTitle!,
        if (schemaVersion != null) 'schemaVersion': schemaVersion!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Request message for ModelService.CopyModel.
class GoogleCloudAiplatformV1CopyModelRequest {
  /// Customer-managed encryption key options.
  ///
  /// If this is set, then the Model copy will be encrypted with the provided
  /// encryption key.
  GoogleCloudAiplatformV1EncryptionSpec? encryptionSpec;

  /// Copy source_model into a new Model with this ID.
  ///
  /// The ID will become the final component of the model resource name. This
  /// value may be up to 63 characters, and valid characters are `[a-z0-9_-]`.
  /// The first character cannot be a number or hyphen.
  ///
  /// Optional.
  core.String? modelId;

  /// Specify this field to copy source_model into this existing Model as a new
  /// version.
  ///
  /// Format: `projects/{project}/locations/{location}/models/{model}`
  ///
  /// Optional.
  core.String? parentModel;

  /// The resource name of the Model to copy.
  ///
  /// That Model must be in the same Project. Format:
  /// `projects/{project}/locations/{location}/models/{model}`
  ///
  /// Required.
  core.String? sourceModel;

  GoogleCloudAiplatformV1CopyModelRequest({
    this.encryptionSpec,
    this.modelId,
    this.parentModel,
    this.sourceModel,
  });

  GoogleCloudAiplatformV1CopyModelRequest.fromJson(core.Map json_)
      : this(
          encryptionSpec: json_.containsKey('encryptionSpec')
              ? GoogleCloudAiplatformV1EncryptionSpec.fromJson(
                  json_['encryptionSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          modelId: json_.containsKey('modelId')
              ? json_['modelId'] as core.String
              : null,
          parentModel: json_.containsKey('parentModel')
              ? json_['parentModel'] as core.String
              : null,
          sourceModel: json_.containsKey('sourceModel')
              ? json_['sourceModel'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (encryptionSpec != null) 'encryptionSpec': encryptionSpec!,
        if (modelId != null) 'modelId': modelId!,
        if (parentModel != null) 'parentModel': parentModel!,
        if (sourceModel != null) 'sourceModel': sourceModel!,
      };
}

/// Request message for PredictionService.CountTokens.
class GoogleCloudAiplatformV1CountTokensRequest {
  /// The instances that are the input to token counting call.
  ///
  /// Schema is identical to the prediction schema of the underlying model.
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.List<core.Object?>? instances;

  GoogleCloudAiplatformV1CountTokensRequest({
    this.instances,
  });

  GoogleCloudAiplatformV1CountTokensRequest.fromJson(core.Map json_)
      : this(
          instances: json_.containsKey('instances')
              ? json_['instances'] as core.List
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (instances != null) 'instances': instances!,
      };
}

/// Response message for PredictionService.CountTokens.
class GoogleCloudAiplatformV1CountTokensResponse {
  /// The total number of billable characters counted across all instances from
  /// the request.
  core.int? totalBillableCharacters;

  /// The total number of tokens counted across all instances from the request.
  core.int? totalTokens;

  GoogleCloudAiplatformV1CountTokensResponse({
    this.totalBillableCharacters,
    this.totalTokens,
  });

  GoogleCloudAiplatformV1CountTokensResponse.fromJson(core.Map json_)
      : this(
          totalBillableCharacters: json_.containsKey('totalBillableCharacters')
              ? json_['totalBillableCharacters'] as core.int
              : null,
          totalTokens: json_.containsKey('totalTokens')
              ? json_['totalTokens'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (totalBillableCharacters != null)
          'totalBillableCharacters': totalBillableCharacters!,
        if (totalTokens != null) 'totalTokens': totalTokens!,
      };
}

/// Request message for CreateDeploymentResourcePool method.
class GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest {
  /// The DeploymentResourcePool to create.
  ///
  /// Required.
  GoogleCloudAiplatformV1DeploymentResourcePool? deploymentResourcePool;

  /// The ID to use for the DeploymentResourcePool, which will become the final
  /// component of the DeploymentResourcePool's resource name.
  ///
  /// The maximum length is 63 characters, and valid characters are
  /// `/^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$/`.
  ///
  /// Required.
  core.String? deploymentResourcePoolId;

  GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest({
    this.deploymentResourcePool,
    this.deploymentResourcePoolId,
  });

  GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest.fromJson(
      core.Map json_)
      : this(
          deploymentResourcePool: json_.containsKey('deploymentResourcePool')
              ? GoogleCloudAiplatformV1DeploymentResourcePool.fromJson(
                  json_['deploymentResourcePool']
                      as core.Map<core.String, core.dynamic>)
              : null,
          deploymentResourcePoolId:
              json_.containsKey('deploymentResourcePoolId')
                  ? json_['deploymentResourcePoolId'] as core.String
                  : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deploymentResourcePool != null)
          'deploymentResourcePool': deploymentResourcePool!,
        if (deploymentResourcePoolId != null)
          'deploymentResourcePoolId': deploymentResourcePoolId!,
      };
}

/// Request message for FeaturestoreService.CreateFeature.
///
/// Request message for FeatureRegistryService.CreateFeature.
class GoogleCloudAiplatformV1CreateFeatureRequest {
  /// The Feature to create.
  ///
  /// Required.
  GoogleCloudAiplatformV1Feature? feature;

  /// The ID to use for the Feature, which will become the final component of
  /// the Feature's resource name.
  ///
  /// This value may be up to 128 characters, and valid characters are
  /// `[a-z0-9_]`. The first character cannot be a number. The value must be
  /// unique within an EntityType/FeatureGroup.
  ///
  /// Required.
  core.String? featureId;

  /// The resource name of the EntityType or FeatureGroup to create a Feature.
  ///
  /// Format for entity_type as parent:
  /// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
  /// Format for feature_group as parent:
  /// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
  ///
  /// Required.
  core.String? parent;

  GoogleCloudAiplatformV1CreateFeatureRequest({
    this.feature,
    this.featureId,
    this.parent,
  });

  GoogleCloudAiplatformV1CreateFeatureRequest.fromJson(core.Map json_)
      : this(
          feature: json_.containsKey('feature')
              ? GoogleCloudAiplatformV1Feature.fromJson(
                  json_['feature'] as core.Map<core.String, core.dynamic>)
              : null,
          featureId: json_.containsKey('featureId')
              ? json_['featureId'] as core.String
              : null,
          parent: json_.containsKey('parent')
              ? json_['parent'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (feature != null) 'feature': feature!,
        if (featureId != null) 'featureId': featureId!,
        if (parent != null) 'parent': parent!,
      };
}

/// Request message for PipelineService.CreatePipelineJob.
class GoogleCloudAiplatformV1CreatePipelineJobRequest {
  /// The resource name of the Location to create the PipelineJob in.
  ///
  /// Format: `projects/{project}/locations/{location}`
  ///
  /// Required.
  core.String? parent;

  /// The PipelineJob to create.
  ///
  /// Required.
  GoogleCloudAiplatformV1PipelineJob? pipelineJob;

  /// The ID to use for the PipelineJob, which will become the final component
  /// of the PipelineJob name.
  ///
  /// If not provided, an ID will be automatically generated. This value should
  /// be less than 128 characters, and valid characters are `/a-z-/`.
  core.String? pipelineJobId;

  GoogleCloudAiplatformV1CreatePipelineJobRequest({
    this.parent,
    this.pipelineJob,
    this.pipelineJobId,
  });

  GoogleCloudAiplatformV1CreatePipelineJobRequest.fromJson(core.Map json_)
      : this(
          parent: json_.containsKey('parent')
              ? json_['parent'] as core.String
              : null,
          pipelineJob: json_.containsKey('pipelineJob')
              ? GoogleCloudAiplatformV1PipelineJob.fromJson(
                  json_['pipelineJob'] as core.Map<core.String, core.dynamic>)
              : null,
          pipelineJobId: json_.containsKey('pipelineJobId')
              ? json_['pipelineJobId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (parent != null) 'parent': parent!,
        if (pipelineJob != null) 'pipelineJob': pipelineJob!,
        if (pipelineJobId != null) 'pipelineJobId': pipelineJobId!,
      };
}

/// Request message for TensorboardService.CreateTensorboardRun.
class GoogleCloudAiplatformV1CreateTensorboardRunRequest {
  /// The resource name of the TensorboardExperiment to create the
  /// TensorboardRun in.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  ///
  /// Required.
  core.String? parent;

  /// The TensorboardRun to create.
  ///
  /// Required.
  GoogleCloudAiplatformV1TensorboardRun? tensorboardRun;

  /// The ID to use for the Tensorboard run, which becomes the final component
  /// of the Tensorboard run's resource name.
  ///
  /// This value should be 1-128 characters, and valid characters are `/a-z-/`.
  ///
  /// Required.
  core.String? tensorboardRunId;

  GoogleCloudAiplatformV1CreateTensorboardRunRequest({
    this.parent,
    this.tensorboardRun,
    this.tensorboardRunId,
  });

  GoogleCloudAiplatformV1CreateTensorboardRunRequest.fromJson(core.Map json_)
      : this(
          parent: json_.containsKey('parent')
              ? json_['parent'] as core.String
              : null,
          tensorboardRun: json_.containsKey('tensorboardRun')
              ? GoogleCloudAiplatformV1TensorboardRun.fromJson(
                  json_['tensorboardRun']
                      as core.Map<core.String, core.dynamic>)
              : null,
          tensorboardRunId: json_.containsKey('tensorboardRunId')
              ? json_['tensorboardRunId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (parent != null) 'parent': parent!,
        if (tensorboardRun != null) 'tensorboardRun': tensorboardRun!,
        if (tensorboardRunId != null) 'tensorboardRunId': tensorboardRunId!,
      };
}

/// Request message for TensorboardService.CreateTensorboardTimeSeries.
class GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest {
  /// The resource name of the TensorboardRun to create the
  /// TensorboardTimeSeries in.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  ///
  /// Required.
  core.String? parent;

  /// The TensorboardTimeSeries to create.
  ///
  /// Required.
  GoogleCloudAiplatformV1TensorboardTimeSeries? tensorboardTimeSeries;

  /// The user specified unique ID to use for the TensorboardTimeSeries, which
  /// becomes the final component of the TensorboardTimeSeries's resource name.
  ///
  /// This value should match "a-z0-9{0, 127}"
  ///
  /// Optional.
  core.String? tensorboardTimeSeriesId;

  GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest({
    this.parent,
    this.tensorboardTimeSeries,
    this.tensorboardTimeSeriesId,
  });

  GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest.fromJson(
      core.Map json_)
      : this(
          parent: json_.containsKey('parent')
              ? json_['parent'] as core.String
              : null,
          tensorboardTimeSeries: json_.containsKey('tensorboardTimeSeries')
              ? GoogleCloudAiplatformV1TensorboardTimeSeries.fromJson(
                  json_['tensorboardTimeSeries']
                      as core.Map<core.String, core.dynamic>)
              : null,
          tensorboardTimeSeriesId: json_.containsKey('tensorboardTimeSeriesId')
              ? json_['tensorboardTimeSeriesId'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (parent != null) 'parent': parent!,
        if (tensorboardTimeSeries != null)
          'tensorboardTimeSeries': tensorboardTimeSeries!,
        if (tensorboardTimeSeriesId != null)
          'tensorboardTimeSeriesId': tensorboardTimeSeriesId!,
      };
}

/// The storage details for CSV output content.
class GoogleCloudAiplatformV1CsvDestination {
  /// Google Cloud Storage location.
  ///
  /// Required.
  GoogleCloudAiplatformV1GcsDestination? gcsDestination;

  GoogleCloudAiplatformV1CsvDestination({
    this.gcsDestination,
  });

  GoogleCloudAiplatformV1CsvDestination.fromJson(core.Map json_)
      : this(
          gcsDestination: json_.containsKey('gcsDestination')
              ? GoogleCloudAiplatformV1GcsDestination.fromJson(
                  json_['gcsDestination']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (gcsDestination != null) 'gcsDestination': gcsDestination!,
      };
}

/// The storage details for CSV input content.
class GoogleCloudAiplatformV1CsvSource {
  /// Google Cloud Storage location.
  ///
  /// Required.
  GoogleCloudAiplatformV1GcsSource? gcsSource;

  GoogleCloudAiplatformV1CsvSource({
    this.gcsSource,
  });

  GoogleCloudAiplatformV1CsvSource.fromJson(core.Map json_)
      : this(
          gcsSource: json_.containsKey('gcsSource')
              ? GoogleCloudAiplatformV1GcsSource.fromJson(
                  json_['gcsSource'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (gcsSource != null) 'gcsSource': gcsSource!,
      };
}

/// Represents a job that runs custom workloads such as a Docker container or a
/// Python package.
///
/// A CustomJob can have multiple worker pools and each worker pool can have its
/// own machine and input spec. A CustomJob will be cleaned up once the job
/// enters terminal state (failed or succeeded).
class GoogleCloudAiplatformV1CustomJob {
  /// Time when the CustomJob was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The display name of the CustomJob.
  ///
  /// The name can be up to 128 characters long and can consist of any UTF-8
  /// characters.
  ///
  /// Required.
  core.String? displayName;

  /// Customer-managed encryption key options for a CustomJob.
  ///
  /// If this is set, then all resources created by the CustomJob will be
  /// encrypted with the provided encryption key.
  GoogleCloudAiplatformV1EncryptionSpec? encryptionSpec;

  /// Time when the CustomJob entered any of the following states:
  /// `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
  ///
  /// Output only.
  core.String? endTime;

  /// Only populated when job's state is `JOB_STATE_FAILED` or
  /// `JOB_STATE_CANCELLED`.
  ///
  /// Output only.
  GoogleRpcStatus? error;

  /// Job spec.
  ///
  /// Required.
  GoogleCloudAiplatformV1CustomJobSpec? jobSpec;

  /// The labels with user-defined metadata to organize CustomJobs.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. See
  /// https://goo.gl/xmQnxf for more information and examples of labels.
  core.Map<core.String, core.String>? labels;

  /// Resource name of a CustomJob.
  ///
  /// Output only.
  core.String? name;

  /// Time when the CustomJob for the first time entered the `JOB_STATE_RUNNING`
  /// state.
  ///
  /// Output only.
  core.String? startTime;

  /// The detailed state of the job.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "JOB_STATE_UNSPECIFIED" : The job state is unspecified.
  /// - "JOB_STATE_QUEUED" : The job has been just created or resumed and
  /// processing has not yet begun.
  /// - "JOB_STATE_PENDING" : The service is preparing to run the job.
  /// - "JOB_STATE_RUNNING" : The job is in progress.
  /// - "JOB_STATE_SUCCEEDED" : The job completed successfully.
  /// - "JOB_STATE_FAILED" : The job failed.
  /// - "JOB_STATE_CANCELLING" : The job is being cancelled. From this state the
  /// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
  /// `JOB_STATE_CANCELLED`.
  /// - "JOB_STATE_CANCELLED" : The job has been cancelled.
  /// - "JOB_STATE_PAUSED" : The job has been stopped, and can be resumed.
  /// - "JOB_STATE_EXPIRED" : The job has expired.
  /// - "JOB_STATE_UPDATING" : The job is being updated. Only jobs in the
  /// `RUNNING` state can be updated. After updating, the job goes back to the
  /// `RUNNING` state.
  /// - "JOB_STATE_PARTIALLY_SUCCEEDED" : The job is partially succeeded, some
  /// results may be missing due to errors.
  core.String? state;

  /// Time when the CustomJob was most recently updated.
  ///
  /// Output only.
  core.String? updateTime;

  /// URIs for accessing
  /// [interactive shells](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
  /// (one URI for each training node).
  ///
  /// Only available if job_spec.enable_web_access is `true`. The keys are names
  /// of each node in the training job; for example, `workerpool0-0` for the
  /// primary node, `workerpool1-0` for the first node in the second worker
  /// pool, and `workerpool1-1` for the second node in the second worker pool.
  /// The values are the URIs for each node's interactive shell.
  ///
  /// Output only.
  core.Map<core.String, core.String>? webAccessUris;

  GoogleCloudAiplatformV1CustomJob({
    this.createTime,
    this.displayName,
    this.encryptionSpec,
    this.endTime,
    this.error,
    this.jobSpec,
    this.labels,
    this.name,
    this.startTime,
    this.state,
    this.updateTime,
    this.webAccessUris,
  });

  GoogleCloudAiplatformV1CustomJob.fromJson(core.Map json_)
      : this(
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          encryptionSpec: json_.containsKey('encryptionSpec')
              ? GoogleCloudAiplatformV1EncryptionSpec.fromJson(
                  json_['encryptionSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          endTime: json_.containsKey('endTime')
              ? json_['endTime'] as core.String
              : null,
          error: json_.containsKey('error')
              ? GoogleRpcStatus.fromJson(
                  json_['error'] as core.Map<core.String, core.dynamic>)
              : null,
          jobSpec: json_.containsKey('jobSpec')
              ? GoogleCloudAiplatformV1CustomJobSpec.fromJson(
                  json_['jobSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          startTime: json_.containsKey('startTime')
              ? json_['startTime'] as core.String
              : null,
          state:
              json_.containsKey('state') ? json_['state'] as core.String : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
          webAccessUris: json_.containsKey('webAccessUris')
              ? (json_['webAccessUris'] as core.Map<core.String, core.dynamic>)
                  .map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (displayName != null) 'displayName': displayName!,
        if (encryptionSpec != null) 'encryptionSpec': encryptionSpec!,
        if (endTime != null) 'endTime': endTime!,
        if (error != null) 'error': error!,
        if (jobSpec != null) 'jobSpec': jobSpec!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (startTime != null) 'startTime': startTime!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
        if (webAccessUris != null) 'webAccessUris': webAccessUris!,
      };
}

/// Represents the spec of a CustomJob.
class GoogleCloudAiplatformV1CustomJobSpec {
  /// The Cloud Storage location to store the output of this CustomJob or
  /// HyperparameterTuningJob.
  ///
  /// For HyperparameterTuningJob, the baseOutputDirectory of each child
  /// CustomJob backing a Trial is set to a subdirectory of name id under its
  /// parent HyperparameterTuningJob's baseOutputDirectory. The following Vertex
  /// AI environment variables will be passed to containers or python modules
  /// when this field is set: For CustomJob: * AIP_MODEL_DIR = `/model/` *
  /// AIP_CHECKPOINT_DIR = `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `/logs/`
  /// For CustomJob backing a Trial of HyperparameterTuningJob: * AIP_MODEL_DIR
  /// = `//model/` * AIP_CHECKPOINT_DIR = `//checkpoints/` *
  /// AIP_TENSORBOARD_LOG_DIR = `//logs/`
  GoogleCloudAiplatformV1GcsDestination? baseOutputDirectory;

  /// Whether you want Vertex AI to enable access to the customized dashboard in
  /// training chief container.
  ///
  /// If set to `true`, you can access the dashboard at the URIs given by
  /// CustomJob.web_access_uris or Trial.web_access_uris (within
  /// HyperparameterTuningJob.trials).
  ///
  /// Optional.
  core.bool? enableDashboardAccess;

  /// Whether you want Vertex AI to enable
  /// [interactive shell access](https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
  /// to training containers.
  ///
  /// If set to `true`, you can access interactive shells at the URIs given by
  /// CustomJob.web_access_uris or Trial.web_access_uris (within
  /// HyperparameterTuningJob.trials).
  ///
  /// Optional.
  core.bool? enableWebAccess;

  /// The Experiment associated with this job.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}`
  ///
  /// Optional.
  core.String? experiment;

  /// The Experiment Run associated with this job.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/metadataStores/{metadataStores}/contexts/{experiment-name}-{experiment-run-name}`
  ///
  /// Optional.
  core.String? experimentRun;

  /// The full name of the Compute Engine
  /// \[network\](/compute/docs/networks-and-firewalls#networks) to which the
  /// Job should be peered.
  ///
  /// For example, `projects/12345/global/networks/myVPC`.
  /// \[Format\](/compute/docs/reference/rest/v1/networks/insert) is of the form
  /// `projects/{project}/global/networks/{network}`. Where {project} is a
  /// project number, as in `12345`, and {network} is a network name. To specify
  /// this field, you must have already
  /// [configured VPC Network Peering for Vertex AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
  /// If this field is left unspecified, the job is not peered with any network.
  ///
  /// Optional.
  core.String? network;

  /// The ID of the location to store protected artifacts.
  ///
  /// e.g. us-central1. Populate only when the location is different than
  /// CustomJob location. List of supported locations:
  /// https://cloud.google.com/vertex-ai/docs/general/locations
  core.String? protectedArtifactLocationId;

  /// A list of names for the reserved ip ranges under the VPC network that can
  /// be used for this job.
  ///
  /// If set, we will deploy the job within the provided ip ranges. Otherwise,
  /// the job will be deployed to any ip ranges under the provided VPC network.
  /// Example: \['vertex-ai-ip-range'\].
  ///
  /// Optional.
  core.List<core.String>? reservedIpRanges;

  /// Scheduling options for a CustomJob.
  GoogleCloudAiplatformV1Scheduling? scheduling;

  /// Specifies the service account for workload run-as account.
  ///
  /// Users submitting jobs must have act-as permission on this run-as account.
  /// If unspecified, the
  /// [Vertex AI Custom Code Service Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
  /// for the CustomJob's project is used.
  core.String? serviceAccount;

  /// The name of a Vertex AI Tensorboard resource to which this CustomJob will
  /// upload Tensorboard logs.
  ///
  /// Format:
  /// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  ///
  /// Optional.
  core.String? tensorboard;

  /// The spec of the worker pools including machine type and Docker image.
  ///
  /// All worker pools except the first one are optional and can be skipped by
  /// providing an empty value.
  ///
  /// Required.
  core.List<GoogleCloudAiplatformV1WorkerPoolSpec>? workerPoolSpecs;

  GoogleCloudAiplatformV1CustomJobSpec({
    this.baseOutputDirectory,
    this.enableDashboardAccess,
    this.enableWebAccess,
    this.experiment,
    this.experimentRun,
    this.network,
    this.protectedArtifactLocationId,
    this.reservedIpRanges,
    this.scheduling,
    this.serviceAccount,
    this.tensorboard,
    this.workerPoolSpecs,
  });

  GoogleCloudAiplatformV1CustomJobSpec.fromJson(core.Map json_)
      : this(
          baseOutputDirectory: json_.containsKey('baseOutputDirectory')
              ? GoogleCloudAiplatformV1GcsDestination.fromJson(
                  json_['baseOutputDirectory']
                      as core.Map<core.String, core.dynamic>)
              : null,
          enableDashboardAccess: json_.containsKey('enableDashboardAccess')
              ? json_['enableDashboardAccess'] as core.bool
              : null,
          enableWebAccess: json_.containsKey('enableWebAccess')
              ? json_['enableWebAccess'] as core.bool
              : null,
          experiment: json_.containsKey('experiment')
              ? json_['experiment'] as core.String
              : null,
          experimentRun: json_.containsKey('experimentRun')
              ? json_['experimentRun'] as core.String
              : null,
          network: json_.containsKey('network')
              ? json_['network'] as core.String
              : null,
          protectedArtifactLocationId:
              json_.containsKey('protectedArtifactLocationId')
                  ? json_['protectedArtifactLocationId'] as core.String
                  : null,
          reservedIpRanges: json_.containsKey('reservedIpRanges')
              ? (json_['reservedIpRanges'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          scheduling: json_.containsKey('scheduling')
              ? GoogleCloudAiplatformV1Scheduling.fromJson(
                  json_['scheduling'] as core.Map<core.String, core.dynamic>)
              : null,
          serviceAccount: json_.containsKey('serviceAccount')
              ? json_['serviceAccount'] as core.String
              : null,
          tensorboard: json_.containsKey('tensorboard')
              ? json_['tensorboard'] as core.String
              : null,
          workerPoolSpecs: json_.containsKey('workerPoolSpecs')
              ? (json_['workerPoolSpecs'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1WorkerPoolSpec.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (baseOutputDirectory != null)
          'baseOutputDirectory': baseOutputDirectory!,
        if (enableDashboardAccess != null)
          'enableDashboardAccess': enableDashboardAccess!,
        if (enableWebAccess != null) 'enableWebAccess': enableWebAccess!,
        if (experiment != null) 'experiment': experiment!,
        if (experimentRun != null) 'experimentRun': experimentRun!,
        if (network != null) 'network': network!,
        if (protectedArtifactLocationId != null)
          'protectedArtifactLocationId': protectedArtifactLocationId!,
        if (reservedIpRanges != null) 'reservedIpRanges': reservedIpRanges!,
        if (scheduling != null) 'scheduling': scheduling!,
        if (serviceAccount != null) 'serviceAccount': serviceAccount!,
        if (tensorboard != null) 'tensorboard': tensorboard!,
        if (workerPoolSpecs != null) 'workerPoolSpecs': workerPoolSpecs!,
      };
}

/// A piece of data in a Dataset.
///
/// Could be an image, a video, a document or plain text.
class GoogleCloudAiplatformV1DataItem {
  /// Timestamp when this DataItem was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  ///
  /// Optional.
  core.String? etag;

  /// The labels with user-defined metadata to organize your DataItems.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. No more than
  /// 64 user labels can be associated with one DataItem(System labels are
  /// excluded). See https://goo.gl/xmQnxf for more information and examples of
  /// labels. System reserved label keys are prefixed with
  /// "aiplatform.googleapis.com/" and are immutable.
  ///
  /// Optional.
  core.Map<core.String, core.String>? labels;

  /// The resource name of the DataItem.
  ///
  /// Output only.
  core.String? name;

  /// The data that the DataItem represents (for example, an image or a text
  /// snippet).
  ///
  /// The schema of the payload is stored in the parent Dataset's metadata
  /// schema's dataItemSchemaUri field.
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Object? payload;

  /// Timestamp when this DataItem was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1DataItem({
    this.createTime,
    this.etag,
    this.labels,
    this.name,
    this.payload,
    this.updateTime,
  });

  GoogleCloudAiplatformV1DataItem.fromJson(core.Map json_)
      : this(
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          payload: json_.containsKey('payload') ? json_['payload'] : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (payload != null) 'payload': payload!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// A container for a single DataItem and Annotations on it.
class GoogleCloudAiplatformV1DataItemView {
  /// The Annotations on the DataItem.
  ///
  /// If too many Annotations should be returned for the DataItem, this field
  /// will be truncated per annotations_limit in request. If it was, then the
  /// has_truncated_annotations will be set to true.
  core.List<GoogleCloudAiplatformV1Annotation>? annotations;

  /// The DataItem.
  GoogleCloudAiplatformV1DataItem? dataItem;

  /// True if and only if the Annotations field has been truncated.
  ///
  /// It happens if more Annotations for this DataItem met the request's
  /// annotation_filter than are allowed to be returned by annotations_limit.
  /// Note that if Annotations field is not being returned due to field mask,
  /// then this field will not be set to true no matter how many Annotations are
  /// there.
  core.bool? hasTruncatedAnnotations;

  GoogleCloudAiplatformV1DataItemView({
    this.annotations,
    this.dataItem,
    this.hasTruncatedAnnotations,
  });

  GoogleCloudAiplatformV1DataItemView.fromJson(core.Map json_)
      : this(
          annotations: json_.containsKey('annotations')
              ? (json_['annotations'] as core.List)
                  .map((value) => GoogleCloudAiplatformV1Annotation.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          dataItem: json_.containsKey('dataItem')
              ? GoogleCloudAiplatformV1DataItem.fromJson(
                  json_['dataItem'] as core.Map<core.String, core.dynamic>)
              : null,
          hasTruncatedAnnotations: json_.containsKey('hasTruncatedAnnotations')
              ? json_['hasTruncatedAnnotations'] as core.bool
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (annotations != null) 'annotations': annotations!,
        if (dataItem != null) 'dataItem': dataItem!,
        if (hasTruncatedAnnotations != null)
          'hasTruncatedAnnotations': hasTruncatedAnnotations!,
      };
}

/// DataLabelingJob is used to trigger a human labeling job on unlabeled data
/// from the following Dataset:
class GoogleCloudAiplatformV1DataLabelingJob {
  /// Parameters that configure the active learning pipeline.
  ///
  /// Active learning will label the data incrementally via several iterations.
  /// For every iteration, it will select a batch of data based on the sampling
  /// strategy.
  GoogleCloudAiplatformV1ActiveLearningConfig? activeLearningConfig;

  /// Labels to assign to annotations generated by this DataLabelingJob.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. See
  /// https://goo.gl/xmQnxf for more information and examples of labels. System
  /// reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
  /// immutable.
  core.Map<core.String, core.String>? annotationLabels;

  /// Timestamp when this DataLabelingJob was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Estimated cost(in US dollars) that the DataLabelingJob has incurred to
  /// date.
  ///
  /// Output only.
  GoogleTypeMoney? currentSpend;

  /// Dataset resource names.
  ///
  /// Right now we only support labeling from a single Dataset. Format:
  /// `projects/{project}/locations/{location}/datasets/{dataset}`
  ///
  /// Required.
  core.List<core.String>? datasets;

  /// The user-defined name of the DataLabelingJob.
  ///
  /// The name can be up to 128 characters long and can consist of any UTF-8
  /// characters. Display name of a DataLabelingJob.
  ///
  /// Required.
  core.String? displayName;

  /// Customer-managed encryption key spec for a DataLabelingJob.
  ///
  /// If set, this DataLabelingJob will be secured by this key. Note:
  /// Annotations created in the DataLabelingJob are associated with the
  /// EncryptionSpec of the Dataset they are exported to.
  GoogleCloudAiplatformV1EncryptionSpec? encryptionSpec;

  /// DataLabelingJob errors.
  ///
  /// It is only populated when job's state is `JOB_STATE_FAILED` or
  /// `JOB_STATE_CANCELLED`.
  ///
  /// Output only.
  GoogleRpcStatus? error;

  /// Input config parameters for the DataLabelingJob.
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Object? inputs;

  /// Points to a YAML file stored on Google Cloud Storage describing the config
  /// for a specific type of DataLabelingJob.
  ///
  /// The schema files that can be used here are found in the
  /// https://storage.googleapis.com/google-cloud-aiplatform bucket in the
  /// /schema/datalabelingjob/inputs/ folder.
  ///
  /// Required.
  core.String? inputsSchemaUri;

  /// The Google Cloud Storage location of the instruction pdf.
  ///
  /// This pdf is shared with labelers, and provides detailed description on how
  /// to label DataItems in Datasets.
  ///
  /// Required.
  core.String? instructionUri;

  /// Number of labelers to work on each DataItem.
  ///
  /// Required.
  core.int? labelerCount;

  /// Current labeling job progress percentage scaled in interval \[0, 100\],
  /// indicating the percentage of DataItems that has been finished.
  ///
  /// Output only.
  core.int? labelingProgress;

  /// The labels with user-defined metadata to organize your DataLabelingJobs.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. See
  /// https://goo.gl/xmQnxf for more information and examples of labels. System
  /// reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
  /// immutable. Following system labels exist for each DataLabelingJob: *
  /// "aiplatform.googleapis.com/schema": output only, its value is the
  /// inputs_schema's title.
  core.Map<core.String, core.String>? labels;

  /// Resource name of the DataLabelingJob.
  ///
  /// Output only.
  core.String? name;

  /// The SpecialistPools' resource names associated with this job.
  core.List<core.String>? specialistPools;

  /// The detailed state of the job.
  ///
  /// Output only.
  /// Possible string values are:
  /// - "JOB_STATE_UNSPECIFIED" : The job state is unspecified.
  /// - "JOB_STATE_QUEUED" : The job has been just created or resumed and
  /// processing has not yet begun.
  /// - "JOB_STATE_PENDING" : The service is preparing to run the job.
  /// - "JOB_STATE_RUNNING" : The job is in progress.
  /// - "JOB_STATE_SUCCEEDED" : The job completed successfully.
  /// - "JOB_STATE_FAILED" : The job failed.
  /// - "JOB_STATE_CANCELLING" : The job is being cancelled. From this state the
  /// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
  /// `JOB_STATE_CANCELLED`.
  /// - "JOB_STATE_CANCELLED" : The job has been cancelled.
  /// - "JOB_STATE_PAUSED" : The job has been stopped, and can be resumed.
  /// - "JOB_STATE_EXPIRED" : The job has expired.
  /// - "JOB_STATE_UPDATING" : The job is being updated. Only jobs in the
  /// `RUNNING` state can be updated. After updating, the job goes back to the
  /// `RUNNING` state.
  /// - "JOB_STATE_PARTIALLY_SUCCEEDED" : The job is partially succeeded, some
  /// results may be missing due to errors.
  core.String? state;

  /// Timestamp when this DataLabelingJob was updated most recently.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1DataLabelingJob({
    this.activeLearningConfig,
    this.annotationLabels,
    this.createTime,
    this.currentSpend,
    this.datasets,
    this.displayName,
    this.encryptionSpec,
    this.error,
    this.inputs,
    this.inputsSchemaUri,
    this.instructionUri,
    this.labelerCount,
    this.labelingProgress,
    this.labels,
    this.name,
    this.specialistPools,
    this.state,
    this.updateTime,
  });

  GoogleCloudAiplatformV1DataLabelingJob.fromJson(core.Map json_)
      : this(
          activeLearningConfig: json_.containsKey('activeLearningConfig')
              ? GoogleCloudAiplatformV1ActiveLearningConfig.fromJson(
                  json_['activeLearningConfig']
                      as core.Map<core.String, core.dynamic>)
              : null,
          annotationLabels: json_.containsKey('annotationLabels')
              ? (json_['annotationLabels']
                      as core.Map<core.String, core.dynamic>)
                  .map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          currentSpend: json_.containsKey('currentSpend')
              ? GoogleTypeMoney.fromJson(
                  json_['currentSpend'] as core.Map<core.String, core.dynamic>)
              : null,
          datasets: json_.containsKey('datasets')
              ? (json_['datasets'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          encryptionSpec: json_.containsKey('encryptionSpec')
              ? GoogleCloudAiplatformV1EncryptionSpec.fromJson(
                  json_['encryptionSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          error: json_.containsKey('error')
              ? GoogleRpcStatus.fromJson(
                  json_['error'] as core.Map<core.String, core.dynamic>)
              : null,
          inputs: json_.containsKey('inputs') ? json_['inputs'] : null,
          inputsSchemaUri: json_.containsKey('inputsSchemaUri')
              ? json_['inputsSchemaUri'] as core.String
              : null,
          instructionUri: json_.containsKey('instructionUri')
              ? json_['instructionUri'] as core.String
              : null,
          labelerCount: json_.containsKey('labelerCount')
              ? json_['labelerCount'] as core.int
              : null,
          labelingProgress: json_.containsKey('labelingProgress')
              ? json_['labelingProgress'] as core.int
              : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          specialistPools: json_.containsKey('specialistPools')
              ? (json_['specialistPools'] as core.List)
                  .map((value) => value as core.String)
                  .toList()
              : null,
          state:
              json_.containsKey('state') ? json_['state'] as core.String : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (activeLearningConfig != null)
          'activeLearningConfig': activeLearningConfig!,
        if (annotationLabels != null) 'annotationLabels': annotationLabels!,
        if (createTime != null) 'createTime': createTime!,
        if (currentSpend != null) 'currentSpend': currentSpend!,
        if (datasets != null) 'datasets': datasets!,
        if (displayName != null) 'displayName': displayName!,
        if (encryptionSpec != null) 'encryptionSpec': encryptionSpec!,
        if (error != null) 'error': error!,
        if (inputs != null) 'inputs': inputs!,
        if (inputsSchemaUri != null) 'inputsSchemaUri': inputsSchemaUri!,
        if (instructionUri != null) 'instructionUri': instructionUri!,
        if (labelerCount != null) 'labelerCount': labelerCount!,
        if (labelingProgress != null) 'labelingProgress': labelingProgress!,
        if (labels != null) 'labels': labels!,
        if (name != null) 'name': name!,
        if (specialistPools != null) 'specialistPools': specialistPools!,
        if (state != null) 'state': state!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// A collection of DataItems and Annotations on them.
class GoogleCloudAiplatformV1Dataset {
  /// Timestamp when this Dataset was created.
  ///
  /// Output only.
  core.String? createTime;

  /// The number of DataItems in this Dataset.
  ///
  /// Only apply for non-structured Dataset.
  ///
  /// Output only.
  core.String? dataItemCount;

  /// The description of the Dataset.
  core.String? description;

  /// The user-defined name of the Dataset.
  ///
  /// The name can be up to 128 characters long and can consist of any UTF-8
  /// characters.
  ///
  /// Required.
  core.String? displayName;

  /// Customer-managed encryption key spec for a Dataset.
  ///
  /// If set, this Dataset and all sub-resources of this Dataset will be secured
  /// by this key.
  GoogleCloudAiplatformV1EncryptionSpec? encryptionSpec;

  /// Used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  core.String? etag;

  /// The labels with user-defined metadata to organize your Datasets.
  ///
  /// Label keys and values can be no longer than 64 characters (Unicode
  /// codepoints), can only contain lowercase letters, numeric characters,
  /// underscores and dashes. International characters are allowed. No more than
  /// 64 user labels can be associated with one Dataset (System labels are
  /// excluded). See https://goo.gl/xmQnxf for more information and examples of
  /// labels. System reserved label keys are prefixed with
  /// "aiplatform.googleapis.com/" and are immutable. Following system labels
  /// exist for each Dataset: *
  /// "aiplatform.googleapis.com/dataset_metadata_schema": output only, its
  /// value is the metadata_schema's title.
  core.Map<core.String, core.String>? labels;

  /// Additional information about the Dataset.
  ///
  /// Required.
  ///
  /// The values for Object must be JSON objects. It can consist of `num`,
  /// `String`, `bool` and `null` as well as `Map` and `List` values.
  core.Object? metadata;

  /// The resource name of the Artifact that was created in MetadataStore when
  /// creating the Dataset.
  ///
  /// The Artifact resource name pattern is
  /// `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
  ///
  /// Output only.
  core.String? metadataArtifact;

  /// Points to a YAML file stored on Google Cloud Storage describing additional
  /// information about the Dataset.
  ///
  /// The schema is defined as an OpenAPI 3.0.2 Schema Object. The schema files
  /// that can be used here are found in
  /// gs://google-cloud-aiplatform/schema/dataset/metadata/.
  ///
  /// Required.
  core.String? metadataSchemaUri;

  /// The resource name of the Dataset.
  ///
  /// Output only.
  core.String? name;

  /// All SavedQueries belong to the Dataset will be returned in List/Get
  /// Dataset response.
  ///
  /// The annotation_specs field will not be populated except for UI cases which
  /// will only use annotation_spec_count. In CreateDataset request, a
  /// SavedQuery is created together if this field is set, up to one SavedQuery
  /// can be set in CreateDatasetRequest. The SavedQuery should not contain any
  /// AnnotationSpec.
  core.List<GoogleCloudAiplatformV1SavedQuery>? savedQueries;

  /// Timestamp when this Dataset was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1Dataset({
    this.createTime,
    this.dataItemCount,
    this.description,
    this.displayName,
    this.encryptionSpec,
    this.etag,
    this.labels,
    this.metadata,
    this.metadataArtifact,
    this.metadataSchemaUri,
    this.name,
    this.savedQueries,
    this.updateTime,
  });

  GoogleCloudAiplatformV1Dataset.fromJson(core.Map json_)
      : this(
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          dataItemCount: json_.containsKey('dataItemCount')
              ? json_['dataItemCount'] as core.String
              : null,
          description: json_.containsKey('description')
              ? json_['description'] as core.String
              : null,
          displayName: json_.containsKey('displayName')
              ? json_['displayName'] as core.String
              : null,
          encryptionSpec: json_.containsKey('encryptionSpec')
              ? GoogleCloudAiplatformV1EncryptionSpec.fromJson(
                  json_['encryptionSpec']
                      as core.Map<core.String, core.dynamic>)
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          labels: json_.containsKey('labels')
              ? (json_['labels'] as core.Map<core.String, core.dynamic>).map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.String,
                  ),
                )
              : null,
          metadata: json_.containsKey('metadata') ? json_['metadata'] : null,
          metadataArtifact: json_.containsKey('metadataArtifact')
              ? json_['metadataArtifact'] as core.String
              : null,
          metadataSchemaUri: json_.containsKey('metadataSchemaUri')
              ? json_['metadataSchemaUri'] as core.String
              : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          savedQueries: json_.containsKey('savedQueries')
              ? (json_['savedQueries'] as core.List)
                  .map((value) => GoogleCloudAiplatformV1SavedQuery.fromJson(
                      value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (createTime != null) 'createTime': createTime!,
        if (dataItemCount != null) 'dataItemCount': dataItemCount!,
        if (description != null) 'description': description!,
        if (displayName != null) 'displayName': displayName!,
        if (encryptionSpec != null) 'encryptionSpec': encryptionSpec!,
        if (etag != null) 'etag': etag!,
        if (labels != null) 'labels': labels!,
        if (metadata != null) 'metadata': metadata!,
        if (metadataArtifact != null) 'metadataArtifact': metadataArtifact!,
        if (metadataSchemaUri != null) 'metadataSchemaUri': metadataSchemaUri!,
        if (name != null) 'name': name!,
        if (savedQueries != null) 'savedQueries': savedQueries!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// Describes the dataset version.
class GoogleCloudAiplatformV1DatasetVersion {
  /// Name of the associated BigQuery dataset.
  ///
  /// Output only.
  core.String? bigQueryDatasetName;

  /// Timestamp when this DatasetVersion was created.
  ///
  /// Output only.
  core.String? createTime;

  /// Used to perform consistent read-modify-write updates.
  ///
  /// If not set, a blind "overwrite" update happens.
  core.String? etag;

  /// The resource name of the DatasetVersion.
  ///
  /// Output only.
  core.String? name;

  /// Timestamp when this DatasetVersion was last updated.
  ///
  /// Output only.
  core.String? updateTime;

  GoogleCloudAiplatformV1DatasetVersion({
    this.bigQueryDatasetName,
    this.createTime,
    this.etag,
    this.name,
    this.updateTime,
  });

  GoogleCloudAiplatformV1DatasetVersion.fromJson(core.Map json_)
      : this(
          bigQueryDatasetName: json_.containsKey('bigQueryDatasetName')
              ? json_['bigQueryDatasetName'] as core.String
              : null,
          createTime: json_.containsKey('createTime')
              ? json_['createTime'] as core.String
              : null,
          etag: json_.containsKey('etag') ? json_['etag'] as core.String : null,
          name: json_.containsKey('name') ? json_['name'] as core.String : null,
          updateTime: json_.containsKey('updateTime')
              ? json_['updateTime'] as core.String
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (bigQueryDatasetName != null)
          'bigQueryDatasetName': bigQueryDatasetName!,
        if (createTime != null) 'createTime': createTime!,
        if (etag != null) 'etag': etag!,
        if (name != null) 'name': name!,
        if (updateTime != null) 'updateTime': updateTime!,
      };
}

/// A description of resources that are dedicated to a DeployedModel, and that
/// need a higher degree of manual configuration.
class GoogleCloudAiplatformV1DedicatedResources {
  /// The metric specifications that overrides a resource utilization metric
  /// (CPU utilization, accelerator's duty cycle, and so on) target value
  /// (default to 60 if not set).
  ///
  /// At most one entry is allowed per metric. If machine_spec.accelerator_count
  /// is above 0, the autoscaling will be based on both CPU utilization and
  /// accelerator's duty cycle metrics and scale up when either metrics exceeds
  /// its target value while scale down if both metrics are under their target
  /// value. The default target value is 60 for both metrics. If
  /// machine_spec.accelerator_count is 0, the autoscaling will be based on CPU
  /// utilization metric only with default target value 60 if not explicitly
  /// set. For example, in the case of Online Prediction, if you want to
  /// override target CPU utilization to 80, you should set
  /// autoscaling_metric_specs.metric_name to
  /// `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
  /// autoscaling_metric_specs.target to `80`.
  ///
  /// Immutable.
  core.List<GoogleCloudAiplatformV1AutoscalingMetricSpec>?
      autoscalingMetricSpecs;

  /// The specification of a single machine used by the prediction.
  ///
  /// Required. Immutable.
  GoogleCloudAiplatformV1MachineSpec? machineSpec;

  /// The maximum number of replicas this DeployedModel may be deployed on when
  /// the traffic against it increases.
  ///
  /// If the requested value is too large, the deployment will error, but if
  /// deployment succeeds then the ability to scale the model to that many
  /// replicas is guaranteed (barring service outages). If traffic against the
  /// DeployedModel increases beyond what its replicas at maximum may handle, a
  /// portion of the traffic will be dropped. If this value is not provided,
  /// will use min_replica_count as the default value. The value of this field
  /// impacts the charge against Vertex CPU and GPU quotas. Specifically, you
  /// will be charged for (max_replica_count * number of cores in the selected
  /// machine type) and (max_replica_count * number of GPUs per replica in the
  /// selected machine type).
  ///
  /// Immutable.
  core.int? maxReplicaCount;

  /// The minimum number of machine replicas this DeployedModel will be always
  /// deployed on.
  ///
  /// This value must be greater than or equal to 1. If traffic against the
  /// DeployedModel increases, it may dynamically be deployed onto more
  /// replicas, and as traffic decreases, some of these extra replicas may be
  /// freed.
  ///
  /// Required. Immutable.
  core.int? minReplicaCount;

  GoogleCloudAiplatformV1DedicatedResources({
    this.autoscalingMetricSpecs,
    this.machineSpec,
    this.maxReplicaCount,
    this.minReplicaCount,
  });

  GoogleCloudAiplatformV1DedicatedResources.fromJson(core.Map json_)
      : this(
          autoscalingMetricSpecs: json_.containsKey('autoscalingMetricSpecs')
              ? (json_['autoscalingMetricSpecs'] as core.List)
                  .map((value) =>
                      GoogleCloudAiplatformV1AutoscalingMetricSpec.fromJson(
                          value as core.Map<core.String, core.dynamic>))
                  .toList()
              : null,
          machineSpec: json_.containsKey('machineSpec')
              ? GoogleCloudAiplatformV1MachineSpec.fromJson(
                  json_['machineSpec'] as core.Map<core.String, core.dynamic>)
              : null,
          maxReplicaCount: json_.containsKey('maxReplicaCount')
              ? json_['maxReplicaCount'] as core.int
              : null,
          minReplicaCount: json_.containsKey('minReplicaCount')
              ? json_['minReplicaCount'] as core.int
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (autoscalingMetricSpecs != null)
          'autoscalingMetricSpecs': autoscalingMetricSpecs!,
        if (machineSpec != null) 'machineSpec': machineSpec!,
        if (maxReplicaCount != null) 'maxReplicaCount': maxReplicaCount!,
        if (minReplicaCount != null) 'minReplicaCount': minReplicaCount!,
      };
}

/// Request message for FeaturestoreService.DeleteFeatureValues.
class GoogleCloudAiplatformV1DeleteFeatureValuesRequest {
  /// Select feature values to be deleted by specifying entities.
  GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity? selectEntity;

  /// Select feature values to be deleted by specifying time range and features.
  GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature?
      selectTimeRangeAndFeature;

  GoogleCloudAiplatformV1DeleteFeatureValuesRequest({
    this.selectEntity,
    this.selectTimeRangeAndFeature,
  });

  GoogleCloudAiplatformV1DeleteFeatureValuesRequest.fromJson(core.Map json_)
      : this(
          selectEntity: json_.containsKey('selectEntity')
              ? GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity
                  .fromJson(json_['selectEntity']
                      as core.Map<core.String, core.dynamic>)
              : null,
          selectTimeRangeAndFeature: json_
                  .containsKey('selectTimeRangeAndFeature')
              ? GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature
                  .fromJson(json_['selectTimeRangeAndFeature']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (selectEntity != null) 'selectEntity': selectEntity!,
        if (selectTimeRangeAndFeature != null)
          'selectTimeRangeAndFeature': selectTimeRangeAndFeature!,
      };
}

/// Message to select entity.
///
/// If an entity id is selected, all the feature values corresponding to the
/// entity id will be deleted, including the entityId.
class GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity {
  /// Selectors choosing feature values of which entity id to be deleted from
  /// the EntityType.
  ///
  /// Required.
  GoogleCloudAiplatformV1EntityIdSelector? entityIdSelector;

  GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity({
    this.entityIdSelector,
  });

  GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity.fromJson(
      core.Map json_)
      : this(
          entityIdSelector: json_.containsKey('entityIdSelector')
              ? GoogleCloudAiplatformV1EntityIdSelector.fromJson(
                  json_['entityIdSelector']
                      as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (entityIdSelector != null) 'entityIdSelector': entityIdSelector!,
      };
}

/// Message to select time range and feature.
///
/// Values of the selected feature generated within an inclusive time range will
/// be deleted. Using this option permanently deletes the feature values from
/// the specified feature IDs within the specified time range. This might
/// include data from the online storage. If you want to retain any deleted
/// historical data in the online storage, you must re-ingest it.
class GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature {
  /// Selectors choosing which feature values to be deleted from the EntityType.
  ///
  /// Required.
  GoogleCloudAiplatformV1FeatureSelector? featureSelector;

  /// If set, data will not be deleted from online storage.
  ///
  /// When time range is older than the data in online storage, setting this to
  /// be true will make the deletion have no impact on online serving.
  core.bool? skipOnlineStorageDelete;

  /// Select feature generated within a half-inclusive time range.
  ///
  /// The time range is lower inclusive and upper exclusive.
  ///
  /// Required.
  GoogleTypeInterval? timeRange;

  GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature({
    this.featureSelector,
    this.skipOnlineStorageDelete,
    this.timeRange,
  });

  GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature.fromJson(
      core.Map json_)
      : this(
          featureSelector: json_.containsKey('featureSelector')
              ? GoogleCloudAiplatformV1FeatureSelector.fromJson(
                  json_['featureSelector']
                      as core.Map<core.String, core.dynamic>)
              : null,
          skipOnlineStorageDelete: json_.containsKey('skipOnlineStorageDelete')
              ? json_['skipOnlineStorageDelete'] as core.bool
              : null,
          timeRange: json_.containsKey('timeRange')
              ? GoogleTypeInterval.fromJson(
                  json_['timeRange'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (featureSelector != null) 'featureSelector': featureSelector!,
        if (skipOnlineStorageDelete != null)
          'skipOnlineStorageDelete': skipOnlineStorageDelete!,
        if (timeRange != null) 'timeRange': timeRange!,
      };
}

/// Request message for IndexEndpointService.DeployIndex.
class GoogleCloudAiplatformV1DeployIndexRequest {
  /// The DeployedIndex to be created within the IndexEndpoint.
  ///
  /// Required.
  GoogleCloudAiplatformV1DeployedIndex? deployedIndex;

  GoogleCloudAiplatformV1DeployIndexRequest({
    this.deployedIndex,
  });

  GoogleCloudAiplatformV1DeployIndexRequest.fromJson(core.Map json_)
      : this(
          deployedIndex: json_.containsKey('deployedIndex')
              ? GoogleCloudAiplatformV1DeployedIndex.fromJson(
                  json_['deployedIndex'] as core.Map<core.String, core.dynamic>)
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deployedIndex != null) 'deployedIndex': deployedIndex!,
      };
}

/// Request message for EndpointService.DeployModel.
class GoogleCloudAiplatformV1DeployModelRequest {
  /// The DeployedModel to be created within the Endpoint.
  ///
  /// Note that Endpoint.traffic_split must be updated for the DeployedModel to
  /// start receiving traffic, either as part of this call, or via
  /// EndpointService.UpdateEndpoint.
  ///
  /// Required.
  GoogleCloudAiplatformV1DeployedModel? deployedModel;

  /// A map from a DeployedModel's ID to the percentage of this Endpoint's
  /// traffic that should be forwarded to that DeployedModel.
  ///
  /// If this field is non-empty, then the Endpoint's traffic_split will be
  /// overwritten with it. To refer to the ID of the just being deployed Model,
  /// a "0" should be used, and the actual ID of the new DeployedModel will be
  /// filled in its place by this method. The traffic percentage values must add
  /// up to 100. If this field is empty, then the Endpoint's traffic_split is
  /// not updated.
  core.Map<core.String, core.int>? trafficSplit;

  GoogleCloudAiplatformV1DeployModelRequest({
    this.deployedModel,
    this.trafficSplit,
  });

  GoogleCloudAiplatformV1DeployModelRequest.fromJson(core.Map json_)
      : this(
          deployedModel: json_.containsKey('deployedModel')
              ? GoogleCloudAiplatformV1DeployedModel.fromJson(
                  json_['deployedModel'] as core.Map<core.String, core.dynamic>)
              : null,
          trafficSplit: json_.containsKey('trafficSplit')
              ? (json_['trafficSplit'] as core.Map<core.String, core.dynamic>)
                  .map(
                  (key, value) => core.MapEntry(
                    key,
                    value as core.int,
                  ),
                )
              : null,
        );

  core.Map<core.String, core.dynamic> toJson() => {
        if (deployedModel != null) 'deployedModel': deployedModel!,
        if (trafficSplit != null) 'trafficSplit': trafficSplit!,
      };
}

/// A deployment of an Index.
///
/// IndexEndpoints contain one or more DeployedIndexes.
class GoogleCloudAiplatformV1DeployedIndex {
  /// A description of resources that the DeployedIndex uses, which to large
  /// degree are decided by Vertex AI, and optionally allows only a modest
  /// additional configuration.
  ///
  /// If min_replica_count is not set, the default value is 2 (we don't provide
  /// SLA when min_replica_count=1). If max_replica_count is not set, the
  /// default value is min_replica_count. The max allowed replica count is 1000.
  ///
  /// Optional.
  GoogleCloudAiplatformV1AutomaticResources? automaticResources;

  /// Timestamp when the DeployedIndex was created.
  ///
  /// Output only.
  core.String? createTime;

  /// A description of resources that are dedicated to the DeployedIndex, and
  /// that need a higher degree of manual configuration.
  ///
  /// The field min_replica_count must be set to a value strictly greater than
  /// 0, or else validation will fail. We don't provide SLA when
  /// min_replica_count=1. If max_replica_count is not set, the default value is
  /// min_replica_count. The max allowed replica count is 1000. Available
  /// machine types for SMALL shard: e2-standard-2 and all machine types
  /// available for MEDIUM and LARGE shard. Available machine types for MEDIUM
  /// shard: e2-standard-16 and all machine types available for LARGE shard.
  /// Available machine types for LARGE shard: e2-highmem-16, n2d-standard-32.
  /// n1-standard-16 and n1-standard-32 are still available, but we recommend
  /// e2-standard-16 and e2-highmem-16 for cost efficiency.
  ///
  /// Optional.
  GoogleCloudAiplatformV1DedicatedResources? dedicatedResources;

  /// If set, the authentication is enabled for the private endpoint.
  ///
  /// Optional.
  GoogleCloudAiplatformV1DeployedIndexAuthConfig? deployedIndexAuthConfig;

  /// The deployment group can be no longer than 64 characters (eg: 'test',
  /// 'prod').
  ///
  /// If not set, we will use the 'default' deployment group. Creating
  /// `deployment_groups` with `reserved_ip_ranges` is a recommended practice
  /// when the peered network has multiple peering ranges. This creates your
  /// deployments from predictable IP spaces for easier traffic administration.
  /// Also, one deployment_group (except 'default') can only be used with the
  /// same reserved_ip_ranges which means if the deployment_group has been used
  /// with reserved_ip_ranges: \[a, b, c\], using it with \[a, b\] or \[d, e\]
  /// is disallowed. Note: we only support up to 5 deployment groups(not
  /// including 'default').
  ///
  /// Optional.
  core.String? deploymentGroup;

  /// The display name of the DeployedIndex.
  ///
  /// If not provided upon creation, the Index's display_name is used.
  core.String? displayName;

  /// If true, private endpoint's access logs are sent to Cloud Logging.
  ///
  /// These logs are like standard server access logs, containing information
  /// like timestamp and latency for each MatchRequest. Note that logs may incur
  /// a cost, especially if the deployed index receives a high queries per
  /// second rate (QPS). Estimate your costs before enabling this option.
  ///
  /// Optional.
  core.bool? enableAccessLogging;

  /// The user specified ID of the DeployedIndex.
  ///
  /// The ID can be up to 128 characters long and must start with a letter and
  /// only contain letters, numbers, and underscores. The ID must be unique
  /// within the project it is created in.
  ///
  /// Required.
  core.String? id;

  /// The name of the Index this is the deployment of.
  ///
  /// We may refer to this Index as the DeployedIndex's "original" Index.
  ///
  /// Required.
  core.String? index;

  /// The DeployedIndex may depend on various data on its original Index.
  ///
  /// Additionally when certain changes to the original Index are being done
  /// (e.g. when what the Index contains is being changed) the DeployedIndex may
  /// be asynchronously updated in the background to reflect these changes. If
  /// this timestamp's value is at least the Index.update_time of the original
  /// Index, it means that this DeployedIndex and the original Index are in
  /// sync. If this timestamp is older, then to see which updates this
  /// DeployedIndex already contains (and which it does not), one must list the
  /// operations that are running on the original Index. Only the successfully
  /// completed Operations with update_time equal or before this sync time are
  /// contained in this DeployedIndex.
  ///
  /// Output only.
  core.String? indexSyncTime;

  /// Provides paths for users to send requests directly to the deployed index
  /// services running on Cloud via private services access.
  ///
  /// This field is populated if network is configured.
  ///
  /// Output only.
  GoogleCloudAiplatformV1IndexPrivateEndpoints? privateEndpoints;

  /// A list of reserved ip ranges under the VPC network that can be used for
  /// this DeployedIndex.
  ///
  /// If set, we will deploy the index within the provided ip ranges. Otherwise,
  /// the index might be deployed to any ip