// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_13_13_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_13_13_H
#include <grpc/support/port_platform.h>

#include <cstddef>
#include <cstdint>
namespace grpc_core {
namespace geometry_13_13 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return table5_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit5(size_t i, size_t emit) {
    return table5_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp7(size_t i) {
    return table7_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit7(size_t i, size_t emit) {
    return table7_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_inner_[i >> 6][table8_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit8(size_t i, size_t emit) {
    return table8_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit9(size_t i, size_t emit) {
    return table9_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_inner_[i >> 6][table1_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit1(size_t i, size_t emit) {
    return table1_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp10(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit10(size_t, size_t emit) {
    return emit ? 125 : 94;
  }
  static inline uint64_t GetOp12(size_t i) {
    return (i < 2 ? (i ? 2 : 0) : ((i - 2) ? 1 : 4));
  }
  static inline uint64_t GetEmit12(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_0_inner_[table13_0_outer_[i]];
  }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp14(size_t i) {
    return table13_0_inner_[table14_0_outer_[i]];
  }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp15(size_t i) { return table15_0_ops_[i]; }
  static inline uint64_t GetEmit15(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 60)) : ((emit - 1) ? 123 : 96));
  }
  static inline uint64_t GetOp16(size_t i) { return table16_0_ops_[i]; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return table16_0_emit_[emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp21(size_t i) {
    return table21_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit21(size_t i, size_t emit) {
    return table21_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp22(size_t i) {
    return table22_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit22(size_t i, size_t emit) {
    return table22_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp11(size_t i) {
    return table11_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit11(size_t i, size_t emit) {
    return table11_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp23(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit23(size_t, size_t emit) { return emit + 203; }
  static inline uint64_t GetOp24(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit24(size_t, size_t emit) { return emit + 211; }
  static inline uint64_t GetOp25(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit25(size_t, size_t emit) {
    return emit ? 221 : 214;
  }
  static inline uint64_t GetOp26(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit26(size_t, size_t emit) { return emit + 222; }
  static inline uint64_t GetOp27(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit27(size_t, size_t emit) {
    return emit ? 244 : 241;
  }
  static inline uint64_t GetOp28(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit28(size_t, size_t emit) { return emit + 245; }
  static inline uint64_t GetOp29(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit29(size_t, size_t emit) { return emit + 247; }
  static inline uint64_t GetOp30(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit30(size_t, size_t emit) { return emit + 250; }
  static inline uint64_t GetOp31(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit31(size_t, size_t emit) { return emit + 252; }
  static inline uint64_t GetOp32(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit32(size_t, size_t emit) { return emit + 4; }
  static inline uint64_t GetOp33(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit33(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 11 : 8) : ((emit - 2) ? 14 : 12));
  }
  static inline uint64_t GetOp34(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit34(size_t, size_t emit) { return emit + 15; }
  static inline uint64_t GetOp35(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit35(size_t, size_t emit) {
    return (emit < 2 ? (emit + 19) : ((emit - 2) ? 23 : 21));
  }
  static inline uint64_t GetOp36(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit36(size_t, size_t emit) { return emit + 24; }
  static inline uint64_t GetOp37(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit37(size_t, size_t emit) { return emit + 28; }
  static inline uint64_t GetOp39(size_t i) { return i; }
  static inline uint64_t GetEmit39(size_t, size_t emit) {
    return ((void)emit, 254);
  }
  static inline uint64_t GetOp38(size_t i) {
    return ((i < 1 ? (((void)i, 0)) : ((i - 1))) < 1
                ? (((void)(i < 1 ? (((void)i, 0)) : ((i - 1))), 1))
                : (((i < 1 ? (((void)i, 0)) : ((i - 1))) - 1) ? 10 : 6));
  }
  static inline uint64_t GetEmit38(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 254)) : ((emit - 1) + 2));
  }
  static inline uint64_t GetOp41(size_t i) {
    return (i < 2 ? (i ? 2 : 0) : ((i - 2) ? 1 : 4));
  }
  static inline uint64_t GetEmit41(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 127)) : ((emit - 1) ? 249 : 220));
  }
  static inline uint64_t GetOp42(size_t i) {
    return table13_0_inner_[table13_0_outer_[i]];
  }
  static inline uint64_t GetEmit42(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 127)) : ((emit - 1) ? 249 : 220));
  }
  static inline uint64_t GetOp40(size_t i) {
    return table40_0_inner_[(i < 11 ? (i / 4 + 0) : ((i - 11) + 2))];
  }
  static inline uint64_t GetEmit40(size_t, size_t emit) {
    return table40_0_emit_[emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table5_0_ops_[128];
  static const uint8_t table5_1_emit_[52];
  static const uint8_t table5_1_ops_[128];
  static const uint8_t* const table5_emit_[2];
  static const uint8_t* const table5_ops_[2];
  static const uint8_t table6_0_emit_[2];
  static const uint8_t table6_0_ops_[32];
  static const uint8_t table6_1_emit_[2];
  static const uint8_t table6_2_emit_[2];
  static const uint8_t table6_3_emit_[2];
  static const uint8_t table6_4_emit_[2];
  static const uint8_t table6_5_emit_[4];
  static const uint8_t table6_5_ops_[32];
  static const uint8_t table6_6_emit_[4];
  static const uint8_t table6_7_emit_[4];
  static const uint8_t table6_8_emit_[4];
  static const uint8_t table6_9_emit_[4];
  static const uint8_t table6_10_emit_[4];
  static const uint8_t table6_11_emit_[6];
  static const uint8_t table6_11_ops_[32];
  static const uint8_t table6_12_emit_[8];
  static const uint8_t table6_12_ops_[32];
  static const uint8_t table6_13_emit_[8];
  static const uint8_t table6_14_emit_[8];
  static const uint8_t table6_15_emit_[10];
  static const uint8_t table6_15_ops_[32];
  static const uint8_t* const table6_emit_[16];
  static const uint8_t* const table6_ops_[16];
  static const uint8_t table7_0_emit_[36];
  static const uint8_t table7_0_ops_[64];
  static const uint8_t table7_1_emit_[36];
  static const uint8_t table7_1_ops_[64];
  static const uint8_t table7_2_emit_[36];
  static const uint8_t table7_2_ops_[64];
  static const uint8_t table7_3_emit_[36];
  static const uint8_t table7_3_ops_[64];
  static const uint8_t table7_4_emit_[38];
  static const uint8_t table7_4_ops_[64];
  static const uint8_t table7_5_ops_[64];
  static const uint8_t table7_11_ops_[64];
  static const uint8_t table7_12_ops_[64];
  static const uint8_t table7_15_emit_[15];
  static const uint8_t table7_15_ops_[64];
  static const uint8_t* const table7_emit_[16];
  static const uint8_t* const table7_ops_[16];
  static const uint8_t table8_0_emit_[71];
  static const uint16_t table8_0_inner_[38];
  static const uint8_t table8_0_outer_[64];
  static const uint8_t table8_1_emit_[71];
  static const uint16_t table8_1_inner_[38];
  static const uint8_t table8_2_emit_[71];
  static const uint16_t table8_2_inner_[38];
  static const uint8_t table8_3_emit_[71];
  static const uint16_t table8_3_inner_[38];
  static const uint8_t table8_4_emit_[71];
  static const uint16_t table8_4_inner_[38];
  static const uint8_t table8_5_emit_[71];
  static const uint16_t table8_5_inner_[38];
  static const uint8_t table8_6_emit_[71];
  static const uint16_t table8_6_inner_[38];
  static const uint8_t table8_7_emit_[71];
  static const uint16_t table8_7_inner_[38];
  static const uint8_t table8_8_emit_[71];
  static const uint16_t table8_8_inner_[38];
  static const uint8_t table8_9_emit_[71];
  static const uint16_t table8_9_inner_[38];
  static const uint8_t table8_10_emit_[40];
  static const uint16_t table8_10_inner_[23];
  static const uint8_t table8_10_outer_[64];
  static const uint8_t table8_11_emit_[40];
  static const uint8_t table8_12_emit_[40];
  static const uint8_t table8_13_emit_[40];
  static const uint8_t table8_14_emit_[40];
  static const uint8_t table8_15_emit_[40];
  static const uint8_t table8_16_emit_[40];
  static const uint8_t table8_17_emit_[40];
  static const uint8_t table8_18_emit_[40];
  static const uint8_t table8_19_emit_[40];
  static const uint8_t table8_20_emit_[40];
  static const uint8_t table8_21_emit_[40];
  static const uint8_t table8_22_emit_[40];
  static const uint8_t table8_23_emit_[4];
  static const uint16_t table8_23_inner_[5];
  static const uint8_t table8_23_outer_[64];
  static const uint8_t table8_24_emit_[4];
  static const uint8_t table8_25_emit_[4];
  static const uint8_t table8_26_emit_[4];
  static const uint8_t table8_27_emit_[4];
  static const uint8_t table8_28_emit_[4];
  static const uint8_t table8_29_emit_[4];
  static const uint8_t table8_30_emit_[4];
  static const uint8_t table8_31_emit_[14];
  static const uint16_t table8_31_inner_[16];
  static const uint8_t table8_31_outer_[64];
  static const uint8_t* const table8_emit_[32];
  static const uint16_t* const table8_inner_[32];
  static const uint8_t* const table8_outer_[32];
  static const uint8_t table9_0_emit_[15];
  static const uint8_t table9_0_ops_[32];
  static const uint8_t table9_1_emit_[28];
  static const uint8_t table9_1_ops_[32];
  static const uint8_t table9_2_emit_[36];
  static const uint8_t table9_2_ops_[32];
  static const uint8_t table9_3_emit_[56];
  static const uint8_t table9_3_ops_[32];
  static const uint8_t table9_4_emit_[15];
  static const uint8_t table9_4_ops_[32];
  static const uint8_t table9_5_emit_[28];
  static const uint8_t table9_6_emit_[36];
  static const uint8_t table9_7_emit_[56];
  static const uint8_t table9_8_emit_[15];
  static const uint8_t table9_8_ops_[32];
  static const uint8_t table9_9_emit_[28];
  static const uint8_t table9_10_emit_[36];
  static const uint8_t table9_11_emit_[56];
  static const uint8_t table9_12_emit_[15];
  static const uint8_t table9_12_ops_[32];
  static const uint8_t table9_13_emit_[28];
  static const uint8_t table9_14_emit_[36];
  static const uint8_t table9_15_emit_[56];
  static const uint8_t table9_16_emit_[15];
  static const uint8_t table9_16_ops_[32];
  static const uint8_t table9_17_emit_[28];
  static const uint8_t table9_18_emit_[36];
  static const uint8_t table9_19_emit_[56];
  static const uint8_t table9_20_emit_[15];
  static const uint8_t table9_20_ops_[32];
  static const uint8_t table9_21_emit_[28];
  static const uint8_t table9_22_emit_[36];
  static const uint8_t table9_23_emit_[56];
  static const uint8_t table9_24_emit_[15];
  static const uint8_t table9_24_ops_[32];
  static const uint8_t table9_25_emit_[28];
  static const uint8_t table9_26_emit_[36];
  static const uint8_t table9_27_emit_[56];
  static const uint8_t table9_28_emit_[16];
  static const uint8_t table9_28_ops_[32];
  static const uint8_t table9_29_emit_[28];
  static const uint8_t table9_30_emit_[36];
  static const uint8_t table9_31_emit_[56];
  static const uint8_t table9_32_emit_[16];
  static const uint8_t table9_33_emit_[27];
  static const uint8_t table9_33_ops_[32];
  static const uint8_t table9_34_emit_[36];
  static const uint8_t table9_35_emit_[56];
  static const uint8_t table9_36_emit_[16];
  static const uint8_t table9_37_emit_[27];
  static const uint8_t table9_37_ops_[32];
  static const uint8_t table9_38_emit_[36];
  static const uint8_t table9_39_emit_[56];
  static const uint8_t table9_40_emit_[43];
  static const uint8_t table9_40_ops_[32];
  static const uint8_t table9_41_emit_[28];
  static const uint8_t table9_41_ops_[32];
  static const uint8_t table9_42_emit_[43];
  static const uint8_t table9_42_ops_[32];
  static const uint8_t table9_43_emit_[28];
  static const uint8_t table9_44_emit_[43];
  static const uint8_t table9_44_ops_[32];
  static const uint8_t table9_45_emit_[28];
  static const uint8_t table9_46_emit_[43];
  static const uint8_t table9_46_ops_[32];
  static const uint8_t table9_47_emit_[28];
  static const uint8_t table9_48_emit_[43];
  static const uint8_t table9_48_ops_[32];
  static const uint8_t table9_49_emit_[28];
  static const uint8_t table9_50_emit_[43];
  static const uint8_t table9_50_ops_[32];
  static const uint8_t table9_51_emit_[28];
  static const uint8_t table9_52_emit_[43];
  static const uint8_t table9_52_ops_[32];
  static const uint8_t table9_53_emit_[28];
  static const uint8_t table9_54_emit_[43];
  static const uint8_t table9_54_ops_[32];
  static const uint8_t table9_55_emit_[28];
  static const uint8_t table9_56_emit_[43];
  static const uint8_t table9_56_ops_[32];
  static const uint8_t table9_57_emit_[28];
  static const uint8_t table9_58_emit_[43];
  static const uint8_t table9_58_ops_[32];
  static const uint8_t table9_59_emit_[28];
  static const uint8_t table9_60_emit_[43];
  static const uint8_t table9_60_ops_[32];
  static const uint8_t table9_61_emit_[28];
  static const uint8_t table9_62_emit_[44];
  static const uint8_t table9_62_ops_[32];
  static const uint8_t table9_63_emit_[28];
  static const uint8_t table9_64_emit_[44];
  static const uint8_t table9_65_emit_[27];
  static const uint8_t table9_65_ops_[32];
  static const uint8_t table9_66_emit_[44];
  static const uint8_t table9_67_emit_[27];
  static const uint8_t table9_67_ops_[32];
  static const uint8_t table9_68_emit_[44];
  static const uint8_t table9_69_emit_[27];
  static const uint8_t table9_69_ops_[32];
  static const uint8_t table9_70_emit_[44];
  static const uint8_t table9_71_emit_[27];
  static const uint8_t table9_71_ops_[32];
  static const uint8_t table9_72_emit_[44];
  static const uint8_t table9_73_emit_[27];
  static const uint8_t table9_73_ops_[32];
  static const uint8_t table9_74_emit_[44];
  static const uint8_t table9_75_emit_[27];
  static const uint8_t table9_75_ops_[32];
  static const uint8_t table9_76_emit_[44];
  static const uint8_t table9_77_emit_[27];
  static const uint8_t table9_77_ops_[32];
  static const uint8_t table9_78_emit_[44];
  static const uint8_t table9_79_emit_[27];
  static const uint8_t table9_79_ops_[32];
  static const uint8_t table9_80_emit_[44];
  static const uint8_t table9_81_emit_[27];
  static const uint8_t table9_81_ops_[32];
  static const uint8_t table9_82_emit_[44];
  static const uint8_t table9_83_emit_[27];
  static const uint8_t table9_83_ops_[32];
  static const uint8_t table9_84_emit_[44];
  static const uint8_t table9_85_emit_[27];
  static const uint8_t table9_85_ops_[32];
  static const uint8_t table9_86_emit_[44];
  static const uint8_t table9_87_emit_[27];
  static const uint8_t table9_87_ops_[32];
  static const uint8_t table9_88_emit_[44];
  static const uint8_t table9_89_emit_[27];
  static const uint8_t table9_89_ops_[32];
  static const uint8_t table9_90_emit_[44];
  static const uint8_t table9_91_emit_[28];
  static const uint8_t table9_92_emit_[20];
  static const uint8_t table9_92_ops_[32];
  static const uint8_t table9_93_emit_[20];
  static const uint8_t table9_94_emit_[20];
  static const uint8_t table9_95_emit_[20];
  static const uint8_t table9_96_emit_[20];
  static const uint8_t table9_97_emit_[20];
  static const uint8_t table9_98_emit_[20];
  static const uint8_t table9_99_emit_[20];
  static const uint8_t table9_100_emit_[20];
  static const uint8_t table9_101_emit_[20];
  static const uint8_t table9_102_emit_[20];
  static const uint8_t table9_103_emit_[20];
  static const uint8_t table9_104_emit_[20];
  static const uint8_t table9_105_emit_[20];
  static const uint8_t table9_106_emit_[20];
  static const uint8_t table9_107_emit_[20];
  static const uint8_t table9_108_emit_[20];
  static const uint8_t table9_109_emit_[20];
  static const uint8_t table9_110_emit_[20];
  static const uint8_t table9_111_emit_[20];
  static const uint8_t table9_112_emit_[20];
  static const uint8_t table9_113_emit_[20];
  static const uint8_t table9_114_emit_[20];
  static const uint8_t table9_115_emit_[20];
  static const uint8_t table9_116_emit_[20];
  static const uint8_t table9_117_emit_[20];
  static const uint8_t table9_118_emit_[20];
  static const uint8_t table9_119_emit_[20];
  static const uint8_t table9_120_emit_[20];
  static const uint8_t table9_121_emit_[20];
  static const uint8_t table9_122_emit_[20];
  static const uint8_t table9_123_emit_[20];
  static const uint8_t table9_124_emit_[2];
  static const uint8_t table9_124_ops_[32];
  static const uint8_t table9_125_emit_[2];
  static const uint8_t table9_126_emit_[2];
  static const uint8_t table9_127_emit_[10];
  static const uint8_t table9_127_ops_[32];
  static const uint8_t* const table9_emit_[128];
  static const uint8_t* const table9_ops_[128];
  static const uint16_t table1_0_inner_[8];
  static const uint8_t table1_0_outer_[64];
  static const uint16_t table1_1_inner_[14];
  static const uint8_t table1_1_outer_[64];
  static const uint16_t table1_2_inner_[18];
  static const uint8_t table1_2_outer_[64];
  static const uint8_t table1_3_emit_[68];
  static const uint16_t table1_3_inner_[35];
  static const uint8_t table1_3_outer_[64];
  static const uint16_t table1_4_inner_[8];
  static const uint8_t table1_7_emit_[68];
  static const uint16_t table1_8_inner_[8];
  static const uint8_t table1_11_emit_[68];
  static const uint16_t table1_12_inner_[8];
  static const uint8_t table1_15_emit_[68];
  static const uint16_t table1_16_inner_[8];
  static const uint8_t table1_19_emit_[68];
  static const uint16_t table1_20_inner_[8];
  static const uint8_t table1_23_emit_[68];
  static const uint16_t table1_24_inner_[8];
  static const uint8_t table1_27_emit_[68];
  static const uint16_t table1_28_inner_[8];
  static const uint8_t table1_31_emit_[68];
  static const uint16_t table1_33_inner_[14];
  static const uint8_t table1_35_emit_[68];
  static const uint16_t table1_37_inner_[14];
  static const uint8_t table1_39_emit_[68];
  static const uint16_t table1_40_inner_[22];
  static const uint8_t table1_40_outer_[64];
  static const uint8_t table1_41_emit_[92];
  static const uint16_t table1_41_inner_[47];
  static const uint8_t table1_41_outer_[64];
  static const uint16_t table1_42_inner_[22];
  static const uint8_t table1_43_emit_[92];
  static const uint16_t table1_44_inner_[22];
  static const uint8_t table1_45_emit_[92];
  static const uint16_t table1_46_inner_[22];
  static const uint8_t table1_47_emit_[92];
  static const uint16_t table1_48_inner_[22];
  static const uint8_t table1_49_emit_[92];
  static const uint16_t table1_50_inner_[22];
  static const uint8_t table1_51_emit_[92];
  static const uint16_t table1_52_inner_[22];
  static const uint8_t table1_53_emit_[92];
  static const uint16_t table1_54_inner_[22];
  static const uint8_t table1_55_emit_[92];
  static const uint16_t table1_56_inner_[22];
  static const uint8_t table1_57_emit_[92];
  static const uint16_t table1_58_inner_[22];
  static const uint8_t table1_59_emit_[92];
  static const uint16_t table1_60_inner_[22];
  static const uint8_t table1_61_emit_[92];
  static const uint16_t table1_62_inner_[22];
  static const uint8_t table1_63_emit_[92];
  static const uint8_t table1_65_emit_[91];
  static const uint16_t table1_65_inner_[47];
  static const uint8_t table1_67_emit_[91];
  static const uint16_t table1_67_inner_[47];
  static const uint8_t table1_69_emit_[91];
  static const uint16_t table1_69_inner_[47];
  static const uint8_t table1_71_emit_[91];
  static const uint16_t table1_71_inner_[47];
  static const uint8_t table1_73_emit_[91];
  static const uint16_t table1_73_inner_[47];
  static const uint8_t table1_75_emit_[91];
  static const uint16_t table1_75_inner_[47];
  static const uint8_t table1_77_emit_[91];
  static const uint16_t table1_77_inner_[47];
  static const uint8_t table1_79_emit_[91];
  static const uint16_t table1_79_inner_[47];
  static const uint8_t table1_81_emit_[91];
  static const uint16_t table1_81_inner_[47];
  static const uint8_t table1_83_emit_[91];
  static const uint16_t table1_83_inner_[47];
  static const uint8_t table1_85_emit_[91];
  static const uint16_t table1_85_inner_[47];
  static const uint8_t table1_87_emit_[91];
  static const uint16_t table1_87_inner_[47];
  static const uint8_t table1_89_emit_[91];
  static const uint16_t table1_89_inner_[47];
  static const uint8_t table1_91_emit_[91];
  static const uint16_t table1_91_inner_[47];
  static const uint8_t table1_92_emit_[72];
  static const uint16_t table1_92_inner_[37];
  static const uint8_t table1_92_outer_[64];
  static const uint8_t table1_93_emit_[72];
  static const uint8_t table1_94_emit_[72];
  static const uint8_t table1_95_emit_[72];
  static const uint8_t table1_96_emit_[72];
  static const uint8_t table1_97_emit_[72];
  static const uint8_t table1_98_emit_[72];
  static const uint8_t table1_99_emit_[72];
  static const uint8_t table1_100_emit_[72];
  static const uint8_t table1_101_emit_[72];
  static const uint8_t table1_102_emit_[72];
  static const uint8_t table1_103_emit_[72];
  static const uint8_t table1_104_emit_[72];
  static const uint8_t table1_105_emit_[72];
  static const uint8_t table1_106_emit_[72];
  static const uint8_t table1_107_emit_[72];
  static const uint8_t table1_108_emit_[72];
  static const uint8_t table1_109_emit_[72];
  static const uint8_t table1_110_emit_[72];
  static const uint8_t table1_111_emit_[72];
  static const uint8_t table1_112_emit_[72];
  static const uint8_t table1_113_emit_[72];
  static const uint8_t table1_114_emit_[72];
  static const uint8_t table1_115_emit_[72];
  static const uint8_t table1_116_emit_[72];
  static const uint8_t table1_117_emit_[72];
  static const uint8_t table1_118_emit_[72];
  static const uint8_t table1_119_emit_[72];
  static const uint8_t table1_120_emit_[72];
  static const uint8_t table1_121_emit_[72];
  static const uint8_t table1_122_emit_[72];
  static const uint8_t table1_123_emit_[72];
  static const uint8_t table1_124_emit_[40];
  static const uint16_t table1_124_inner_[22];
  static const uint8_t table1_124_outer_[64];
  static const uint8_t table1_125_emit_[40];
  static const uint8_t table1_126_emit_[40];
  static const uint8_t table1_127_emit_[16];
  static const uint16_t table1_127_inner_[18];
  static const uint8_t table1_127_outer_[64];
  static const uint8_t* const table1_emit_[128];
  static const uint16_t* const table1_inner_[128];
  static const uint8_t* const table1_outer_[128];
  static const uint8_t table13_0_inner_[5];
  static const uint8_t table13_0_outer_[8];
  static const uint8_t table14_0_outer_[16];
  static const uint8_t table15_0_ops_[32];
  static const uint8_t table16_0_emit_[6];
  static const uint8_t table16_0_ops_[64];
  static const uint8_t table17_0_emit_[20];
  static const uint8_t table17_0_ops_[32];
  static const uint8_t table17_1_emit_[20];
  static const uint8_t table17_2_emit_[20];
  static const uint8_t table17_3_emit_[11];
  static const uint8_t table17_3_ops_[32];
  static const uint8_t* const table17_emit_[4];
  static const uint8_t* const table17_ops_[4];
  static const uint8_t table18_0_emit_[72];
  static const uint16_t table18_0_ops_[64];
  static const uint8_t table18_1_emit_[72];
  static const uint8_t table18_2_emit_[72];
  static const uint8_t table18_3_emit_[24];
  static const uint16_t table18_3_ops_[64];
  static const uint8_t* const table18_emit_[4];
  static const uint16_t* const table18_ops_[4];
  static const uint8_t table19_0_emit_[136];
  static const uint16_t table19_0_ops_[128];
  static const uint8_t table19_1_emit_[136];
  static const uint8_t table19_2_emit_[136];
  static const uint8_t table19_3_emit_[50];
  static const uint16_t table19_3_ops_[128];
  static const uint8_t* const table19_emit_[4];
  static const uint16_t* const table19_ops_[4];
  static const uint8_t table20_0_emit_[44];
  static const uint16_t table20_0_ops_[128];
  static const uint8_t table20_1_emit_[104];
  static const uint16_t table20_1_ops_[128];
  static const uint8_t table20_2_emit_[44];
  static const uint8_t table20_3_emit_[104];
  static const uint8_t table20_4_emit_[44];
  static const uint8_t table20_5_emit_[104];
  static const uint8_t table20_6_emit_[15];
  static const uint16_t table20_6_ops_[128];
  static const uint8_t table20_7_emit_[64];
  static const uint16_t table20_7_ops_[128];
  static const uint8_t* const table20_emit_[8];
  static const uint16_t* const table20_ops_[8];
  static const uint8_t table21_0_emit_[16];
  static const uint16_t table21_0_ops_[128];
  static const uint8_t table21_1_emit_[28];
  static const uint16_t table21_1_ops_[128];
  static const uint8_t table21_2_emit_[36];
  static const uint16_t table21_2_ops_[128];
  static const uint8_t table21_3_emit_[68];
  static const uint16_t table21_3_ops_[128];
  static const uint8_t table21_4_emit_[16];
  static const uint8_t table21_5_emit_[28];
  static const uint8_t table21_6_emit_[36];
  static const uint8_t table21_7_emit_[68];
  static const uint8_t table21_8_emit_[16];
  static const uint8_t table21_9_emit_[28];
  static const uint8_t table21_10_emit_[36];
  static const uint8_t table21_11_emit_[68];
  static const uint8_t table21_12_emit_[62];
  static const uint16_t table21_12_ops_[128];
  static const uint8_t table21_13_emit_[10];
  static const uint16_t table21_13_ops_[128];
  static const uint8_t table21_14_emit_[23];
  static const uint16_t table21_14_ops_[128];
  static const uint8_t table21_15_emit_[53];
  static const uint16_t table21_15_ops_[128];
  static const uint8_t* const table21_emit_[16];
  static const uint16_t* const table21_ops_[16];
  static const uint8_t table22_0_emit_[60];
  static const uint16_t table22_0_ops_[64];
  static const uint8_t table22_1_emit_[60];
  static const uint8_t table22_2_emit_[60];
  static const uint8_t table22_3_emit_[60];
  static const uint8_t table22_4_emit_[60];
  static const uint8_t table22_5_emit_[8];
  static const uint16_t table22_5_ops_[64];
  static const uint8_t table22_6_emit_[8];
  static const uint8_t table22_7_emit_[8];
  static const uint8_t table22_8_emit_[8];
  static const uint8_t table22_9_emit_[8];
  static const uint8_t table22_10_emit_[8];
  static const uint8_t table22_11_emit_[12];
  static const uint16_t table22_11_ops_[64];
  static const uint8_t table22_12_emit_[16];
  static const uint16_t table22_12_ops_[64];
  static const uint8_t table22_13_emit_[16];
  static const uint8_t table22_14_emit_[16];
  static const uint8_t table22_15_emit_[30];
  static const uint16_t table22_15_ops_[64];
  static const uint8_t table22_16_emit_[60];
  static const uint8_t table22_17_emit_[60];
  static const uint8_t table22_18_emit_[60];
  static const uint8_t table22_19_emit_[60];
  static const uint8_t table22_20_emit_[60];
  static const uint8_t table22_21_emit_[8];
  static const uint8_t table22_22_emit_[8];
  static const uint8_t table22_23_emit_[8];
  static const uint8_t table22_24_emit_[8];
  static const uint8_t table22_25_emit_[8];
  static const uint8_t table22_26_emit_[8];
  static const uint8_t table22_27_emit_[12];
  static const uint8_t table22_28_emit_[16];
  static const uint8_t table22_29_emit_[16];
  static const uint8_t table22_30_emit_[16];
  static const uint8_t table22_31_emit_[30];
  static const uint8_t table22_32_emit_[60];
  static const uint8_t table22_33_emit_[60];
  static const uint8_t table22_34_emit_[60];
  static const uint8_t table22_35_emit_[60];
  static const uint8_t table22_36_emit_[60];
  static const uint8_t table22_37_emit_[8];
  static const uint8_t table22_38_emit_[8];
  static const uint8_t table22_39_emit_[8];
  static const uint8_t table22_40_emit_[8];
  static const uint8_t table22_41_emit_[8];
  static const uint8_t table22_42_emit_[8];
  static const uint8_t table22_43_emit_[12];
  static const uint8_t table22_44_emit_[16];
  static const uint8_t table22_45_emit_[16];
  static const uint8_t table22_46_emit_[16];
  static const uint8_t table22_47_emit_[30];
  static const uint8_t table22_48_emit_[72];
  static const uint16_t table22_48_ops_[64];
  static const uint8_t table22_49_emit_[72];
  static const uint8_t table22_50_emit_[72];
  static const uint8_t table22_51_emit_[40];
  static const uint16_t table22_51_ops_[64];
  static const uint8_t table22_52_emit_[40];
  static const uint8_t table22_53_emit_[40];
  static const uint8_t table22_54_emit_[40];
  static const uint8_t table22_55_emit_[4];
  static const uint16_t table22_55_ops_[64];
  static const uint8_t table22_56_emit_[4];
  static const uint8_t table22_57_emit_[4];
  static const uint8_t table22_58_emit_[7];
  static const uint16_t table22_58_ops_[64];
  static const uint8_t table22_59_emit_[8];
  static const uint16_t table22_59_ops_[64];
  static const uint8_t table22_60_emit_[8];
  static const uint8_t table22_61_emit_[12];
  static const uint16_t table22_61_ops_[64];
  static const uint8_t table22_62_emit_[16];
  static const uint16_t table22_62_ops_[64];
  static const uint8_t table22_63_emit_[21];
  static const uint16_t table22_63_ops_[64];
  static const uint8_t* const table22_emit_[64];
  static const uint16_t* const table22_ops_[64];
  static const uint8_t table11_0_emit_[1];
  static const uint16_t table11_0_ops_[128];
  static const uint8_t table11_16_emit_[1];
  static const uint8_t table11_32_emit_[1];
  static const uint8_t table11_48_emit_[1];
  static const uint16_t table11_48_ops_[128];
  static const uint8_t table11_49_emit_[1];
  static const uint8_t table11_50_emit_[1];
  static const uint8_t table11_51_emit_[2];
  static const uint16_t table11_51_ops_[128];
  static const uint8_t table11_52_emit_[2];
  static const uint8_t table11_53_emit_[2];
  static const uint8_t table11_54_emit_[2];
  static const uint16_t table11_55_ops_[128];
  static const uint16_t table11_58_ops_[128];
  static const uint16_t table11_59_ops_[128];
  static const uint16_t table11_61_ops_[128];
  static const uint16_t table11_62_ops_[128];
  static const uint8_t table11_63_emit_[36];
  static const uint16_t table11_63_ops_[128];
  static const uint8_t* const table11_emit_[64];
  static const uint16_t* const table11_ops_[64];
  static const uint8_t table40_0_emit_[6];
  static const uint8_t table40_0_inner_[7];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo13()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 13)) & 0x1fff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 4) & 3) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          sink_(GetEmit1(index, emit_ofs + 1));
          break;
        }
        case 1: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 2: {
          DecodeStep0();
          break;
        }
        case 3: {
          DecodeStep1();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo13() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4: {
        return Read2to7Bytes();
      }
      case 5:
      case 6:
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp5(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit5(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp6(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit6(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            sink_(GetEmit7(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            sink_(GetEmit8(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            sink_(GetEmit9(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo1()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp10(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit10(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Done1() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep1() {
    if (!RefillTo13()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 13)) & 0x1fff;
    const auto op = GetOp11(index);
    const int consumed = op & 15;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 9;
    switch ((op >> 4) & 31) {
      case 0: {
        sink_(GetEmit11(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep2();
        break;
      }
      case 2: {
        DecodeStep3();
        break;
      }
      case 3: {
        DecodeStep4();
        break;
      }
      case 4: {
        DecodeStep5();
        break;
      }
      case 5: {
        DecodeStep6();
        break;
      }
      case 6: {
        DecodeStep7();
        break;
      }
      case 7: {
        DecodeStep8();
        break;
      }
      case 8: {
        DecodeStep9();
        break;
      }
      case 9: {
        DecodeStep10();
        break;
      }
      case 10: {
        DecodeStep17();
        break;
      }
      case 11: {
        DecodeStep11();
        break;
      }
      case 12: {
        DecodeStep12();
        break;
      }
      case 13: {
        DecodeStep13();
        break;
      }
      case 14: {
        DecodeStep14();
        break;
      }
      case 15: {
        DecodeStep15();
        break;
      }
      case 16: {
        DecodeStep16();
        break;
      }
      case 17: {
        DecodeStep18();
        break;
      }
    }
  }
  void Done2() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp12(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit12(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            sink_(GetEmit17(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            sink_(GetEmit18(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            sink_(GetEmit19(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            sink_(GetEmit20(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp21(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            sink_(GetEmit21(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp22(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            sink_(GetEmit22(index, (op >> 3) + 1));
            sink_(GetEmit22(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            sink_(GetEmit22(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit22(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep2() {
    if (!RefillTo1()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp23(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit23(index, emit_ofs + 0));
  }
  void Done3() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep3() {
    if (!RefillTo1()) {
      Done4();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp24(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit24(index, emit_ofs + 0));
  }
  void Done4() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep4() {
    if (!RefillTo1()) {
      Done5();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp25(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit25(index, emit_ofs + 0));
  }
  void Done5() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep5() {
    if (!RefillTo1()) {
      Done6();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp26(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit26(index, emit_ofs + 0));
  }
  void Done6() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep6() {
    if (!RefillTo1()) {
      Done7();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp27(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit27(index, emit_ofs + 0));
  }
  void Done7() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep7() {
    if (!RefillTo1()) {
      Done8();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp28(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit28(index, emit_ofs + 0));
  }
  void Done8() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep8() {
    if (!RefillTo1()) {
      Done9();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp29(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit29(index, emit_ofs + 0));
  }
  void Done9() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep9() {
    if (!RefillTo1()) {
      Done10();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp30(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit30(index, emit_ofs + 0));
  }
  void Done10() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep10() {
    if (!RefillTo1()) {
      Done11();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp31(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit31(index, emit_ofs + 0));
  }
  void Done11() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep11() {
    if (!RefillTo2()) {
      Done12();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp32(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit32(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done12() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep12() {
    if (!RefillTo2()) {
      Done13();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp33(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit33(index, emit_ofs + 0));
  }
  void Done13() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep13() {
    if (!RefillTo2()) {
      Done14();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp34(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit34(index, emit_ofs + 0));
  }
  void Done14() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep14() {
    if (!RefillTo2()) {
      Done15();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp35(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit35(index, emit_ofs + 0));
  }
  void Done15() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep15() {
    if (!RefillTo2()) {
      Done16();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp36(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit36(index, emit_ofs + 0));
  }
  void Done16() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep16() {
    if (!RefillTo2()) {
      Done17();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp37(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit37(index, emit_ofs + 0));
  }
  void Done17() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep17() {
    if (!RefillTo2()) {
      Done18();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp38(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit38(index, emit_ofs + 0));
  }
  void Done18() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        const auto index = buffer_ & 1;
        const auto op = GetOp39(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit39(index, (op >> 1) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep18() {
    if (!RefillTo4()) {
      Done19();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 4)) & 0xf;
    const auto op = GetOp40(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 4;
    switch ((op >> 3) & 1) {
      case 0: {
        sink_(GetEmit40(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo4() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done19() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp41(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit41(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp42(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit42(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_13_13
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_13_13_H
