#include <tests/llvm.h>
const char test_llvm__bpf_test_relocation[] =
"// SPDX-License-Identifier: GPL-2.0\n"
"/*\n"
" * bpf-script-test-relocation.c\n"
" * Test BPF loader checking relocation\n"
" */\n"
"#ifndef LINUX_VERSION_CODE\n"
"# error Need LINUX_VERSION_CODE\n"
"# error Example: for 4.2 kernel, put 'clang-opt=\"-DLINUX_VERSION_CODE=0x40200\" into llvm section of ~/.perfconfig'\n"
"#endif\n"
"#define BPF_ANY 0\n"
"#define BPF_MAP_TYPE_ARRAY 2\n"
"#define BPF_FUNC_map_lookup_elem 1\n"
"#define BPF_FUNC_map_update_elem 2\n"
"\n"
"static void *(*bpf_map_lookup_elem)(void *map, void *key) =\n"
"	(void *) BPF_FUNC_map_lookup_elem;\n"
"static void *(*bpf_map_update_elem)(void *map, void *key, void *value, int flags) =\n"
"	(void *) BPF_FUNC_map_update_elem;\n"
"\n"
"struct bpf_map_def {\n"
"	unsigned int type;\n"
"	unsigned int key_size;\n"
"	unsigned int value_size;\n"
"	unsigned int max_entries;\n"
"};\n"
"\n"
"#define SEC(NAME) __attribute__((section(NAME), used))\n"
"struct bpf_map_def SEC(\"maps\") my_table = {\n"
"	.type = BPF_MAP_TYPE_ARRAY,\n"
"	.key_size = sizeof(int),\n"
"	.value_size = sizeof(int),\n"
"	.max_entries = 1,\n"
"};\n"
"\n"
"int this_is_a_global_val;\n"
"\n"
"SEC(\"func=sys_write\")\n"
"int bpf_func__sys_write(void *ctx)\n"
"{\n"
"	int key = 0;\n"
"	int value = 0;\n"
"\n"
"	/*\n"
"	 * Incorrect relocation. Should not allow this program be\n"
"	 * loaded into kernel.\n"
"	 */\n"
"	bpf_map_update_elem(&this_is_a_global_val, &key, &value, 0);\n"
"	return 0;\n"
"}\n"
"char _license[] SEC(\"license\") = \"GPL\";\n"
"int _version SEC(\"version\") = LINUX_VERSION_CODE;\n"
;
