// Copyright (C) 2023 MapLibre contributors

// SPDX-License-Identifier: BSD-2-Clause

#pragma once

#include <mbgl/gfx/renderable.hpp>

#if defined(MLN_RENDER_BACKEND_OPENGL)
#include "opengl_renderer_backend_p.hpp"
#elif defined(MLN_RENDER_BACKEND_VULKAN)
#include "vulkan_renderer_backend_p.hpp"
#elif defined(MLN_RENDER_BACKEND_METAL)
#include "metal_renderer_backend_p.hpp"
#endif

namespace QMapLibre {

#if defined(MLN_RENDER_BACKEND_OPENGL)
using RendererBackend = OpenGLRendererBackend;
#elif defined(MLN_RENDER_BACKEND_VULKAN)
using RendererBackend = VulkanRendererBackend;
#elif defined(MLN_RENDER_BACKEND_METAL)
using RendererBackend = MetalRendererBackend;
#endif

} // namespace QMapLibre
