// Copyright (c) 2023, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// IMPORTANT: This file should only ever be modified by modifying the
// corresponding .proto file and then running
// `dart runtime/vm/protos/tools/compile_perfetto_protos.dart` from the SDK root
// directory.
// Autogenerated by the ProtoZero compiler plugin. DO NOT EDIT.

#ifndef PERFETTO_PROTOS_PROTOS_PERFETTO_TRACE_TRACK_EVENT_TRACK_DESCRIPTOR_PROTO_H_
#define PERFETTO_PROTOS_PROTOS_PERFETTO_TRACE_TRACK_EVENT_TRACK_DESCRIPTOR_PROTO_H_

#include <stddef.h>
#include <stdint.h>

#include "perfetto/protozero/field_writer.h"
#include "perfetto/protozero/message.h"
#include "perfetto/protozero/packed_repeated_fields.h"
#include "perfetto/protozero/proto_decoder.h"
#include "perfetto/protozero/proto_utils.h"

namespace perfetto {
namespace protos {
namespace pbzero {

class ProcessDescriptor;
class ThreadDescriptor;

class TrackDescriptor_Decoder : public ::protozero::TypedProtoDecoder<
                                    /*MAX_FIELD_ID=*/5,
                                    /*HAS_NONPACKED_REPEATED_FIELDS=*/false> {
 public:
  TrackDescriptor_Decoder(const uint8_t* data, size_t len)
      : TypedProtoDecoder(data, len) {}
  explicit TrackDescriptor_Decoder(const std::string& raw)
      : TypedProtoDecoder(reinterpret_cast<const uint8_t*>(raw.data()),
                          raw.size()) {}
  explicit TrackDescriptor_Decoder(const ::protozero::ConstBytes& raw)
      : TypedProtoDecoder(raw.data, raw.size) {}
  bool has_uuid() const { return at<1>().valid(); }
  uint64_t uuid() const { return at<1>().as_uint64(); }
  bool has_parent_uuid() const { return at<5>().valid(); }
  uint64_t parent_uuid() const { return at<5>().as_uint64(); }
  bool has_name() const { return at<2>().valid(); }
  ::protozero::ConstChars name() const { return at<2>().as_string(); }
  bool has_process() const { return at<3>().valid(); }
  ::protozero::ConstBytes process() const { return at<3>().as_bytes(); }
  bool has_thread() const { return at<4>().valid(); }
  ::protozero::ConstBytes thread() const { return at<4>().as_bytes(); }
};

class TrackDescriptor : public ::protozero::Message {
 public:
  using Decoder = TrackDescriptor_Decoder;
  enum : int32_t {
    kUuidFieldNumber = 1,
    kParentUuidFieldNumber = 5,
    kNameFieldNumber = 2,
    kProcessFieldNumber = 3,
    kThreadFieldNumber = 4,
  };
  static constexpr const char* GetName() {
    return ".perfetto.protos.TrackDescriptor";
  }

  using FieldMetadata_Uuid = ::protozero::proto_utils::FieldMetadata<
      1,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      TrackDescriptor>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_Uuid kUuid() { return {}; }
  void set_uuid(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_Uuid::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_ParentUuid = ::protozero::proto_utils::FieldMetadata<
      5,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kUint64,
      uint64_t,
      TrackDescriptor>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_ParentUuid kParentUuid() { return {}; }
  void set_parent_uuid(uint64_t value) {
    static constexpr uint32_t field_id = FieldMetadata_ParentUuid::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kUint64>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_Name = ::protozero::proto_utils::FieldMetadata<
      2,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kString,
      std::string,
      TrackDescriptor>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_Name kName() { return {}; }
  void set_name(const char* data, size_t size) {
    AppendBytes(FieldMetadata_Name::kFieldId, data, size);
  }
  void set_name(::protozero::ConstChars chars) {
    AppendBytes(FieldMetadata_Name::kFieldId, chars.data, chars.size);
  }
  void set_name(std::string value) {
    static constexpr uint32_t field_id = FieldMetadata_Name::kFieldId;
    // Call the appropriate protozero::Message::Append(field_id, ...)
    // method based on the type of the field.
    ::protozero::internal::FieldWriter<
        ::protozero::proto_utils::ProtoSchemaType::kString>::Append(*this,
                                                                    field_id,
                                                                    value);
  }

  using FieldMetadata_Process = ::protozero::proto_utils::FieldMetadata<
      3,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      ProcessDescriptor,
      TrackDescriptor>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_Process kProcess() { return {}; }
  template <typename T = ProcessDescriptor>
  T* set_process() {
    return BeginNestedMessage<T>(3);
  }

  using FieldMetadata_Thread = ::protozero::proto_utils::FieldMetadata<
      4,
      ::protozero::proto_utils::RepetitionType::kNotRepeated,
      ::protozero::proto_utils::ProtoSchemaType::kMessage,
      ThreadDescriptor,
      TrackDescriptor>;

  // Ceci n'est pas une pipe.
  // This is actually a variable of FieldMetadataHelper<FieldMetadata<...>>
  // type (and users are expected to use it as such, hence kCamelCase name).
  // It is declared as a function to keep protozero bindings header-only as
  // inline constexpr variables are not available until C++17 (while inline
  // functions are).
  // TODO(altimin): Use inline variable instead after adopting C++17.
  static constexpr FieldMetadata_Thread kThread() { return {}; }
  template <typename T = ThreadDescriptor>
  T* set_thread() {
    return BeginNestedMessage<T>(4);
  }
};

}  // namespace pbzero
}  // namespace protos
}  // namespace perfetto
#endif  // Include guard.
