/*
 * Copyright (C) 2024 Red Hat, Inc.
 *
 * Author: Daiki Ueno
 *
 * This file is part of GnuTLS.
 *
 * GnuTLS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GnuTLS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GnuTLS.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GNUTLS_TESTS_DH_COMPUTE_H
#define GNUTLS_TESTS_DH_COMPUTE_H

#include <stdint.h>

static const uint8_t ffdhe_2048_priv_key[] = {
	0x44, 0xee, 0xae, 0x12, 0x66, 0x64, 0x92, 0x9e, 0x42, 0x44, 0x56, 0x3a,
	0x09, 0x0e, 0x5d, 0xad, 0xad, 0x90, 0xd5, 0x82, 0xaf, 0x63, 0xc1, 0xc1,
	0x52, 0x7e, 0xe5, 0x04, 0x30, 0x25, 0x90, 0x6b, 0x57, 0xa7, 0x28, 0x6d,
	0x8b, 0x6a, 0x53, 0xa8, 0x87, 0xd6, 0xfe, 0xde, 0xac, 0x21, 0xb0, 0x9e,
	0x86, 0xc1, 0x56, 0x17, 0xce, 0x45, 0x8b, 0x9e, 0x2f, 0x8f, 0xf3, 0x9a,
	0xba, 0x97, 0x40, 0x0d, 0xff, 0xd3, 0xcd, 0x70, 0x9f, 0x27, 0x47, 0x0d,
	0x65, 0x09, 0x98, 0x2b, 0x22, 0x1e, 0xe2, 0x51, 0xce, 0x5f, 0x27, 0x64,
	0x45, 0x3f, 0xb3, 0x4b, 0x43, 0x45, 0x3e, 0x79, 0xe2, 0xc5, 0x61, 0x6f,
	0xc2, 0x03, 0xfc, 0x14, 0x03, 0x22, 0x9a, 0x97, 0x3f, 0x69, 0xee, 0x83,
	0x92, 0xa8, 0x6d, 0xf4, 0x1f, 0x49, 0xba, 0x11, 0xb1, 0x30, 0x6f, 0x84,
	0x2b, 0xd5, 0x21, 0x31, 0x6b, 0x72, 0x19, 0x83, 0xba, 0x7b, 0x96, 0x01,
	0x29, 0x40, 0x6a, 0xef, 0xf4, 0xc5, 0x0e, 0xb9, 0x16, 0xf4, 0x33, 0xd7,
	0xd3, 0x5f, 0x22, 0x68, 0xc4, 0x36, 0x92, 0x09, 0x42, 0x7a, 0x60, 0x93,
	0xf0, 0x95, 0xde, 0x0e, 0xce, 0xa3, 0x34, 0xd6, 0xd7, 0x08, 0xda, 0xc3,
	0xa6, 0x38, 0x36, 0x72, 0x01, 0xc5, 0xaa, 0x93, 0x1a, 0xf6, 0x56, 0x45,
	0x73, 0x57, 0x0d, 0x17, 0x23, 0xbb, 0x7a, 0x5d, 0x9b, 0x76, 0x54, 0xba,
	0x60, 0x43, 0xbb, 0xf6, 0xca, 0x46, 0x72, 0xd0, 0x0d, 0x98, 0x00, 0xbf,
	0x02, 0xdd, 0x1e, 0x22, 0xbb, 0xa5, 0x87, 0xc1, 0xbd, 0x79, 0xc9, 0xee,
	0x9d, 0x3c, 0x19, 0x75, 0xcf, 0xce, 0x49, 0xd4, 0xd8, 0xad, 0x0a, 0xc7,
	0x5d, 0x96, 0x2c, 0xb0, 0x10, 0xaf, 0xc2, 0xfe, 0xc0, 0xd9, 0x6b, 0x1e,
	0x5f, 0x2e, 0x8c, 0x5a, 0x68, 0xaa, 0x8a, 0xda, 0xb2, 0xd8, 0x36, 0xe3,
	0x82, 0x04, 0xed, 0x20
};

static const uint8_t ffdhe_2048_pub_key[] = {
	0x00, 0xdd, 0x55, 0x13, 0x28, 0xc9, 0xbf, 0xf1, 0x5f, 0x42, 0x6b, 0x85,
	0x7c, 0xe6, 0xb1, 0xcb, 0x80, 0xee, 0x6b, 0xa5, 0x0f, 0x52, 0xc5, 0x02,
	0x49, 0x66, 0x7f, 0x3a, 0x49, 0xae, 0xb7, 0xf6, 0xee, 0xff, 0x97, 0x83,
	0xe2, 0xce, 0xb3, 0x55, 0x73, 0xcc, 0xbf, 0x69, 0x5e, 0x6f, 0x32, 0xb8,
	0x5a, 0x43, 0x3b, 0x2d, 0x2c, 0xb0, 0x25, 0xb8, 0xd1, 0x8c, 0x70, 0x95,
	0xf7, 0x5c, 0x6d, 0xa2, 0x44, 0x58, 0x5d, 0x82, 0x8d, 0x4a, 0x0c, 0x4d,
	0x28, 0x94, 0x19, 0x16, 0xb7, 0x64, 0xbf, 0x86, 0xa5, 0x78, 0x13, 0x60,
	0x14, 0x6a, 0x2b, 0xc5, 0x45, 0x5b, 0xc7, 0xb8, 0xea, 0x1f, 0xd7, 0x1d,
	0x29, 0xa3, 0x6c, 0xd9, 0xc8, 0x00, 0x77, 0x77, 0x5d, 0xc7, 0x5f, 0xd8,
	0xbe, 0xa4, 0xa7, 0x2c, 0xc5, 0xcd, 0x3c, 0x47, 0x33, 0x5a, 0x59, 0x43,
	0x3c, 0x02, 0x7d, 0xf3, 0xea, 0x69, 0xc2, 0x21, 0xd7, 0x02, 0x07, 0x58,
	0x96, 0xee, 0xd7, 0x97, 0x4f, 0x9c, 0xa5, 0x89, 0xd9, 0xf2, 0x68, 0x15,
	0x9c, 0x28, 0xf9, 0x50, 0x98, 0xe9, 0xe1, 0xed, 0xb3, 0x06, 0xb5, 0x41,
	0x64, 0x10, 0x1a, 0x0c, 0xc3, 0xcc, 0x4c, 0x77, 0x47, 0xf8, 0x18, 0xff,
	0xf4, 0x77, 0xbf, 0x95, 0x76, 0x5c, 0x9a, 0xcc, 0x72, 0x5f, 0xb3, 0x9f,
	0xa5, 0x0d, 0x31, 0x85, 0x78, 0xea, 0xd6, 0xd4, 0x26, 0xf8, 0x96, 0xbd,
	0x05, 0x0a, 0xea, 0x63, 0xb9, 0x51, 0x04, 0x07, 0xe5, 0xbf, 0x58, 0x20,
	0x2d, 0x8d, 0x8b, 0x93, 0x38, 0xe4, 0x04, 0x18, 0x07, 0x29, 0xf2, 0x11,
	0xb0, 0xf2, 0x3d, 0x09, 0xef, 0x22, 0xfd, 0xe0, 0x8c, 0x50, 0x23, 0x9f,
	0x78, 0x1c, 0x13, 0xcc, 0x05, 0x27, 0xc2, 0xed, 0xf1, 0x24, 0x3f, 0x86,
	0xf4, 0x8d, 0x3a, 0x60, 0x3e, 0x92, 0x0e, 0x36, 0x64, 0x67, 0xaf, 0x42,
	0xaa, 0x90, 0x20, 0x21, 0xad
};

static const uint8_t ffdhe_2048_result[] = {
	0xdd, 0x55, 0x13, 0x28, 0xc9, 0xbf, 0xf1, 0x5f, 0x42, 0x6b, 0x85, 0x7c,
	0xe6, 0xb1, 0xcb, 0x80, 0xee, 0x6b, 0xa5, 0x0f, 0x52, 0xc5, 0x02, 0x49,
	0x66, 0x7f, 0x3a, 0x49, 0xae, 0xb7, 0xf6, 0xee, 0xff, 0x97, 0x83, 0xe2,
	0xce, 0xb3, 0x55, 0x73, 0xcc, 0xbf, 0x69, 0x5e, 0x6f, 0x32, 0xb8, 0x5a,
	0x43, 0x3b, 0x2d, 0x2c, 0xb0, 0x25, 0xb8, 0xd1, 0x8c, 0x70, 0x95, 0xf7,
	0x5c, 0x6d, 0xa2, 0x44, 0x58, 0x5d, 0x82, 0x8d, 0x4a, 0x0c, 0x4d, 0x28,
	0x94, 0x19, 0x16, 0xb7, 0x64, 0xbf, 0x86, 0xa5, 0x78, 0x13, 0x60, 0x14,
	0x6a, 0x2b, 0xc5, 0x45, 0x5b, 0xc7, 0xb8, 0xea, 0x1f, 0xd7, 0x1d, 0x29,
	0xa3, 0x6c, 0xd9, 0xc8, 0x00, 0x77, 0x77, 0x5d, 0xc7, 0x5f, 0xd8, 0xbe,
	0xa4, 0xa7, 0x2c, 0xc5, 0xcd, 0x3c, 0x47, 0x33, 0x5a, 0x59, 0x43, 0x3c,
	0x02, 0x7d, 0xf3, 0xea, 0x69, 0xc2, 0x21, 0xd7, 0x02, 0x07, 0x58, 0x96,
	0xee, 0xd7, 0x97, 0x4f, 0x9c, 0xa5, 0x89, 0xd9, 0xf2, 0x68, 0x15, 0x9c,
	0x28, 0xf9, 0x50, 0x98, 0xe9, 0xe1, 0xed, 0xb3, 0x06, 0xb5, 0x41, 0x64,
	0x10, 0x1a, 0x0c, 0xc3, 0xcc, 0x4c, 0x77, 0x47, 0xf8, 0x18, 0xff, 0xf4,
	0x77, 0xbf, 0x95, 0x76, 0x5c, 0x9a, 0xcc, 0x72, 0x5f, 0xb3, 0x9f, 0xa5,
	0x0d, 0x31, 0x85, 0x78, 0xea, 0xd6, 0xd4, 0x26, 0xf8, 0x96, 0xbd, 0x05,
	0x0a, 0xea, 0x63, 0xb9, 0x51, 0x04, 0x07, 0xe5, 0xbf, 0x58, 0x20, 0x2d,
	0x8d, 0x8b, 0x93, 0x38, 0xe4, 0x04, 0x18, 0x07, 0x29, 0xf2, 0x11, 0xb0,
	0xf2, 0x3d, 0x09, 0xef, 0x22, 0xfd, 0xe0, 0x8c, 0x50, 0x23, 0x9f, 0x78,
	0x1c, 0x13, 0xcc, 0x05, 0x27, 0xc2, 0xed, 0xf1, 0x24, 0x3f, 0x86, 0xf4,
	0x8d, 0x3a, 0x60, 0x3e, 0x92, 0x0e, 0x36, 0x64, 0x67, 0xaf, 0x42, 0xaa,
	0x90, 0x20, 0x21, 0xad
};

#endif /* GNUTLS_TESTS_DH_COMPUTE_H */
