// This file was generated by qtwaylandscanner
// source file is /w/workspace/ci-platform-AGL-repo-verify-CIB-h3ulcb-nogfx/repoclone2617/output/tmp/work/aarch64-agl-linux/qtwayland/6.7.3/git/src/3rdparty/protocol/wayland.xml

#include "qwayland-server-wayland.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    wl_callback::wl_callback(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_callback::wl_callback(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_callback::wl_callback(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_callback::wl_callback()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_callback::~wl_callback()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->callback_object = nullptr;

        if (m_resource)
            m_resource->callback_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_callback::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_callback::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_callback::Resource *wl_callback::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_callback::Resource *wl_callback::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_callback::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_callback_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_callback::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_callback::interface()
    {
        return &::wl_callback_interface;
    }

    wl_callback::Resource *wl_callback::callback_allocate()
    {
        return new Resource;
    }

    void wl_callback::callback_bind_resource(Resource *)
    {
    }

    void wl_callback::callback_destroy_resource(Resource *)
    {
    }

    void wl_callback::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_callback *that = static_cast<wl_callback *>(data);
        that->add(client, id, version);
    }

    void wl_callback::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_callback *that = static_cast<wl_callback::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_callback::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_callback *that = resource->callback_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->callback_destroy_resource(resource);

            that = resource->callback_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_callback::Resource *wl_callback::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_callback_interface, version, id);
        return bind(handle);
    }

    wl_callback::Resource *wl_callback::bind(struct ::wl_resource *handle)
    {
        Resource *resource = callback_allocate();
        resource->callback_object = this;

        wl_resource_set_implementation(handle, nullptr, resource, destroy_func);
        resource->handle = handle;
        callback_bind_resource(resource);
        return resource;
    }
    wl_callback::Resource *wl_callback::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_callback_interface, nullptr))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    void wl_callback::send_done(uint32_t callback_data)
    {
        Q_ASSERT_X(m_resource, "wl_callback::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_callback::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle,
            callback_data);
    }

    void wl_callback::send_done(struct ::wl_resource *resource, uint32_t callback_data)
    {
        wl_callback_send_done(
            resource,
            callback_data);
    }


    wl_compositor::wl_compositor(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_compositor::wl_compositor(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_compositor::wl_compositor(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_compositor::wl_compositor()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_compositor::~wl_compositor()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->compositor_object = nullptr;

        if (m_resource)
            m_resource->compositor_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_compositor::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_compositor::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_compositor::Resource *wl_compositor::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_compositor::Resource *wl_compositor::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_compositor::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_compositor_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_compositor::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_compositor::interface()
    {
        return &::wl_compositor_interface;
    }

    wl_compositor::Resource *wl_compositor::compositor_allocate()
    {
        return new Resource;
    }

    void wl_compositor::compositor_bind_resource(Resource *)
    {
    }

    void wl_compositor::compositor_destroy_resource(Resource *)
    {
    }

    void wl_compositor::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_compositor *that = static_cast<wl_compositor *>(data);
        that->add(client, id, version);
    }

    void wl_compositor::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_compositor *that = static_cast<wl_compositor::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_compositor::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_compositor *that = resource->compositor_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->compositor_destroy_resource(resource);

            that = resource->compositor_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_compositor::Resource *wl_compositor::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_compositor_interface, version, id);
        return bind(handle);
    }

    wl_compositor::Resource *wl_compositor::bind(struct ::wl_resource *handle)
    {
        Resource *resource = compositor_allocate();
        resource->compositor_object = this;

        wl_resource_set_implementation(handle, &m_wl_compositor_interface, resource, destroy_func);
        resource->handle = handle;
        compositor_bind_resource(resource);
        return resource;
    }
    wl_compositor::Resource *wl_compositor::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_compositor_interface, &m_wl_compositor_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_compositor_interface wl_compositor::m_wl_compositor_interface = {
        wl_compositor::handle_create_surface,
        wl_compositor::handle_create_region
    };

    void wl_compositor::compositor_create_surface(Resource *, uint32_t)
    {
    }

    void wl_compositor::compositor_create_region(Resource *, uint32_t)
    {
    }


    void wl_compositor::handle_create_surface(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->compositor_object)) {
            return;
        }
        static_cast<wl_compositor *>(r->compositor_object)->compositor_create_surface(
            r,
            id);
    }

    void wl_compositor::handle_create_region(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->compositor_object)) {
            return;
        }
        static_cast<wl_compositor *>(r->compositor_object)->compositor_create_region(
            r,
            id);
    }

    wl_shm_pool::wl_shm_pool(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_shm_pool::wl_shm_pool(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_shm_pool::wl_shm_pool(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_shm_pool::wl_shm_pool()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_shm_pool::~wl_shm_pool()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->shm_pool_object = nullptr;

        if (m_resource)
            m_resource->shm_pool_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_shm_pool::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_shm_pool::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_shm_pool::Resource *wl_shm_pool::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_shm_pool::Resource *wl_shm_pool::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_shm_pool::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_shm_pool_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_shm_pool::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_shm_pool::interface()
    {
        return &::wl_shm_pool_interface;
    }

    wl_shm_pool::Resource *wl_shm_pool::shm_pool_allocate()
    {
        return new Resource;
    }

    void wl_shm_pool::shm_pool_bind_resource(Resource *)
    {
    }

    void wl_shm_pool::shm_pool_destroy_resource(Resource *)
    {
    }

    void wl_shm_pool::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_shm_pool *that = static_cast<wl_shm_pool *>(data);
        that->add(client, id, version);
    }

    void wl_shm_pool::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_shm_pool *that = static_cast<wl_shm_pool::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_shm_pool::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_shm_pool *that = resource->shm_pool_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->shm_pool_destroy_resource(resource);

            that = resource->shm_pool_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_shm_pool::Resource *wl_shm_pool::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_shm_pool_interface, version, id);
        return bind(handle);
    }

    wl_shm_pool::Resource *wl_shm_pool::bind(struct ::wl_resource *handle)
    {
        Resource *resource = shm_pool_allocate();
        resource->shm_pool_object = this;

        wl_resource_set_implementation(handle, &m_wl_shm_pool_interface, resource, destroy_func);
        resource->handle = handle;
        shm_pool_bind_resource(resource);
        return resource;
    }
    wl_shm_pool::Resource *wl_shm_pool::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_shm_pool_interface, &m_wl_shm_pool_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_shm_pool_interface wl_shm_pool::m_wl_shm_pool_interface = {
        wl_shm_pool::handle_create_buffer,
        wl_shm_pool::handle_destroy,
        wl_shm_pool::handle_resize
    };

    void wl_shm_pool::shm_pool_create_buffer(Resource *, uint32_t, int32_t , int32_t , int32_t , int32_t , uint32_t )
    {
    }

    void wl_shm_pool::shm_pool_destroy(Resource *)
    {
    }

    void wl_shm_pool::shm_pool_resize(Resource *, int32_t )
    {
    }


    void wl_shm_pool::handle_create_buffer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        int32_t offset,
        int32_t width,
        int32_t height,
        int32_t stride,
        uint32_t format)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shm_pool_object)) {
            return;
        }
        static_cast<wl_shm_pool *>(r->shm_pool_object)->shm_pool_create_buffer(
            r,
            id,
            offset,
            width,
            height,
            stride,
            format);
    }

    void wl_shm_pool::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shm_pool_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_shm_pool *>(r->shm_pool_object)->shm_pool_destroy(
            r);
    }

    void wl_shm_pool::handle_resize(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t size)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shm_pool_object)) {
            return;
        }
        static_cast<wl_shm_pool *>(r->shm_pool_object)->shm_pool_resize(
            r,
            size);
    }

    wl_shm::wl_shm(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_shm::wl_shm(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_shm::wl_shm(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_shm::wl_shm()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_shm::~wl_shm()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->shm_object = nullptr;

        if (m_resource)
            m_resource->shm_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_shm::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_shm::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_shm::Resource *wl_shm::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_shm::Resource *wl_shm::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_shm::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_shm_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_shm::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_shm::interface()
    {
        return &::wl_shm_interface;
    }

    wl_shm::Resource *wl_shm::shm_allocate()
    {
        return new Resource;
    }

    void wl_shm::shm_bind_resource(Resource *)
    {
    }

    void wl_shm::shm_destroy_resource(Resource *)
    {
    }

    void wl_shm::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_shm *that = static_cast<wl_shm *>(data);
        that->add(client, id, version);
    }

    void wl_shm::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_shm *that = static_cast<wl_shm::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_shm::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_shm *that = resource->shm_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->shm_destroy_resource(resource);

            that = resource->shm_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_shm::Resource *wl_shm::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_shm_interface, version, id);
        return bind(handle);
    }

    wl_shm::Resource *wl_shm::bind(struct ::wl_resource *handle)
    {
        Resource *resource = shm_allocate();
        resource->shm_object = this;

        wl_resource_set_implementation(handle, &m_wl_shm_interface, resource, destroy_func);
        resource->handle = handle;
        shm_bind_resource(resource);
        return resource;
    }
    wl_shm::Resource *wl_shm::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_shm_interface, &m_wl_shm_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_shm_interface wl_shm::m_wl_shm_interface = {
        wl_shm::handle_create_pool
    };

    void wl_shm::shm_create_pool(Resource *, uint32_t, int32_t , int32_t )
    {
    }


    void wl_shm::handle_create_pool(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        int32_t fd,
        int32_t size)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shm_object)) {
            return;
        }
        static_cast<wl_shm *>(r->shm_object)->shm_create_pool(
            r,
            id,
            fd,
            size);
    }

    void wl_shm::send_format(uint32_t format)
    {
        Q_ASSERT_X(m_resource, "wl_shm::format", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_shm::format as it's not initialised");
            return;
        }
        send_format(
            m_resource->handle,
            format);
    }

    void wl_shm::send_format(struct ::wl_resource *resource, uint32_t format)
    {
        wl_shm_send_format(
            resource,
            format);
    }


    wl_buffer::wl_buffer(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_buffer::wl_buffer(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_buffer::wl_buffer(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_buffer::wl_buffer()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_buffer::~wl_buffer()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->buffer_object = nullptr;

        if (m_resource)
            m_resource->buffer_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_buffer::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_buffer::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_buffer::Resource *wl_buffer::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_buffer::Resource *wl_buffer::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_buffer::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_buffer_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_buffer::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_buffer::interface()
    {
        return &::wl_buffer_interface;
    }

    wl_buffer::Resource *wl_buffer::buffer_allocate()
    {
        return new Resource;
    }

    void wl_buffer::buffer_bind_resource(Resource *)
    {
    }

    void wl_buffer::buffer_destroy_resource(Resource *)
    {
    }

    void wl_buffer::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_buffer *that = static_cast<wl_buffer *>(data);
        that->add(client, id, version);
    }

    void wl_buffer::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_buffer *that = static_cast<wl_buffer::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_buffer::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_buffer *that = resource->buffer_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->buffer_destroy_resource(resource);

            that = resource->buffer_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_buffer::Resource *wl_buffer::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_buffer_interface, version, id);
        return bind(handle);
    }

    wl_buffer::Resource *wl_buffer::bind(struct ::wl_resource *handle)
    {
        Resource *resource = buffer_allocate();
        resource->buffer_object = this;

        wl_resource_set_implementation(handle, &m_wl_buffer_interface, resource, destroy_func);
        resource->handle = handle;
        buffer_bind_resource(resource);
        return resource;
    }
    wl_buffer::Resource *wl_buffer::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_buffer_interface, &m_wl_buffer_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_buffer_interface wl_buffer::m_wl_buffer_interface = {
        wl_buffer::handle_destroy
    };

    void wl_buffer::buffer_destroy(Resource *)
    {
    }


    void wl_buffer::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->buffer_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_buffer *>(r->buffer_object)->buffer_destroy(
            r);
    }

    void wl_buffer::send_release()
    {
        Q_ASSERT_X(m_resource, "wl_buffer::release", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_buffer::release as it's not initialised");
            return;
        }
        send_release(
            m_resource->handle);
    }

    void wl_buffer::send_release(struct ::wl_resource *resource)
    {
        wl_buffer_send_release(
            resource);
    }


    wl_data_offer::wl_data_offer(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_data_offer::wl_data_offer(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_data_offer::wl_data_offer(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_data_offer::wl_data_offer()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_data_offer::~wl_data_offer()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->data_offer_object = nullptr;

        if (m_resource)
            m_resource->data_offer_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_data_offer::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_data_offer::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_data_offer::Resource *wl_data_offer::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_data_offer::Resource *wl_data_offer::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_data_offer::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_data_offer_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_data_offer::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_data_offer::interface()
    {
        return &::wl_data_offer_interface;
    }

    wl_data_offer::Resource *wl_data_offer::data_offer_allocate()
    {
        return new Resource;
    }

    void wl_data_offer::data_offer_bind_resource(Resource *)
    {
    }

    void wl_data_offer::data_offer_destroy_resource(Resource *)
    {
    }

    void wl_data_offer::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_data_offer *that = static_cast<wl_data_offer *>(data);
        that->add(client, id, version);
    }

    void wl_data_offer::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_data_offer *that = static_cast<wl_data_offer::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_data_offer::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_data_offer *that = resource->data_offer_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->data_offer_destroy_resource(resource);

            that = resource->data_offer_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_data_offer::Resource *wl_data_offer::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_data_offer_interface, version, id);
        return bind(handle);
    }

    wl_data_offer::Resource *wl_data_offer::bind(struct ::wl_resource *handle)
    {
        Resource *resource = data_offer_allocate();
        resource->data_offer_object = this;

        wl_resource_set_implementation(handle, &m_wl_data_offer_interface, resource, destroy_func);
        resource->handle = handle;
        data_offer_bind_resource(resource);
        return resource;
    }
    wl_data_offer::Resource *wl_data_offer::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_data_offer_interface, &m_wl_data_offer_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_data_offer_interface wl_data_offer::m_wl_data_offer_interface = {
        wl_data_offer::handle_accept,
        wl_data_offer::handle_receive,
        wl_data_offer::handle_destroy,
        wl_data_offer::handle_finish,
        wl_data_offer::handle_set_actions
    };

    void wl_data_offer::data_offer_accept(Resource *, uint32_t , const QString &)
    {
    }

    void wl_data_offer::data_offer_receive(Resource *, const QString &, int32_t )
    {
    }

    void wl_data_offer::data_offer_destroy(Resource *)
    {
    }

    void wl_data_offer::data_offer_finish(Resource *)
    {
    }

    void wl_data_offer::data_offer_set_actions(Resource *, uint32_t , uint32_t )
    {
    }


    void wl_data_offer::handle_accept(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t serial,
        const char *mime_type)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_offer_object)) {
            return;
        }
        static_cast<wl_data_offer *>(r->data_offer_object)->data_offer_accept(
            r,
            serial,
            QString::fromUtf8(mime_type));
    }

    void wl_data_offer::handle_receive(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *mime_type,
        int32_t fd)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_offer_object)) {
            return;
        }
        static_cast<wl_data_offer *>(r->data_offer_object)->data_offer_receive(
            r,
            QString::fromUtf8(mime_type),
            fd);
    }

    void wl_data_offer::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_offer_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_data_offer *>(r->data_offer_object)->data_offer_destroy(
            r);
    }

    void wl_data_offer::handle_finish(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_offer_object)) {
            return;
        }
        static_cast<wl_data_offer *>(r->data_offer_object)->data_offer_finish(
            r);
    }

    void wl_data_offer::handle_set_actions(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t dnd_actions,
        uint32_t preferred_action)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_offer_object)) {
            return;
        }
        static_cast<wl_data_offer *>(r->data_offer_object)->data_offer_set_actions(
            r,
            dnd_actions,
            preferred_action);
    }

    void wl_data_offer::send_offer(const QString &mime_type)
    {
        Q_ASSERT_X(m_resource, "wl_data_offer::offer", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_offer::offer as it's not initialised");
            return;
        }
        send_offer(
            m_resource->handle,
            mime_type);
    }

    void wl_data_offer::send_offer(struct ::wl_resource *resource, const QString &mime_type)
    {
        wl_data_offer_send_offer(
            resource,
            mime_type.toUtf8().constData());
    }


    void wl_data_offer::send_source_actions(uint32_t source_actions)
    {
        Q_ASSERT_X(m_resource, "wl_data_offer::source_actions", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_offer::source_actions as it's not initialised");
            return;
        }
        send_source_actions(
            m_resource->handle,
            source_actions);
    }

    void wl_data_offer::send_source_actions(struct ::wl_resource *resource, uint32_t source_actions)
    {
        wl_data_offer_send_source_actions(
            resource,
            source_actions);
    }


    void wl_data_offer::send_action(uint32_t dnd_action)
    {
        Q_ASSERT_X(m_resource, "wl_data_offer::action", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_offer::action as it's not initialised");
            return;
        }
        send_action(
            m_resource->handle,
            dnd_action);
    }

    void wl_data_offer::send_action(struct ::wl_resource *resource, uint32_t dnd_action)
    {
        wl_data_offer_send_action(
            resource,
            dnd_action);
    }


    wl_data_source::wl_data_source(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_data_source::wl_data_source(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_data_source::wl_data_source(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_data_source::wl_data_source()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_data_source::~wl_data_source()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->data_source_object = nullptr;

        if (m_resource)
            m_resource->data_source_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_data_source::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_data_source::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_data_source::Resource *wl_data_source::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_data_source::Resource *wl_data_source::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_data_source::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_data_source_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_data_source::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_data_source::interface()
    {
        return &::wl_data_source_interface;
    }

    wl_data_source::Resource *wl_data_source::data_source_allocate()
    {
        return new Resource;
    }

    void wl_data_source::data_source_bind_resource(Resource *)
    {
    }

    void wl_data_source::data_source_destroy_resource(Resource *)
    {
    }

    void wl_data_source::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_data_source *that = static_cast<wl_data_source *>(data);
        that->add(client, id, version);
    }

    void wl_data_source::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_data_source *that = static_cast<wl_data_source::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_data_source::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_data_source *that = resource->data_source_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->data_source_destroy_resource(resource);

            that = resource->data_source_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_data_source::Resource *wl_data_source::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_data_source_interface, version, id);
        return bind(handle);
    }

    wl_data_source::Resource *wl_data_source::bind(struct ::wl_resource *handle)
    {
        Resource *resource = data_source_allocate();
        resource->data_source_object = this;

        wl_resource_set_implementation(handle, &m_wl_data_source_interface, resource, destroy_func);
        resource->handle = handle;
        data_source_bind_resource(resource);
        return resource;
    }
    wl_data_source::Resource *wl_data_source::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_data_source_interface, &m_wl_data_source_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_data_source_interface wl_data_source::m_wl_data_source_interface = {
        wl_data_source::handle_offer,
        wl_data_source::handle_destroy,
        wl_data_source::handle_set_actions
    };

    void wl_data_source::data_source_offer(Resource *, const QString &)
    {
    }

    void wl_data_source::data_source_destroy(Resource *)
    {
    }

    void wl_data_source::data_source_set_actions(Resource *, uint32_t )
    {
    }


    void wl_data_source::handle_offer(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *mime_type)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_source_object)) {
            return;
        }
        static_cast<wl_data_source *>(r->data_source_object)->data_source_offer(
            r,
            QString::fromUtf8(mime_type));
    }

    void wl_data_source::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_source_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_data_source *>(r->data_source_object)->data_source_destroy(
            r);
    }

    void wl_data_source::handle_set_actions(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t dnd_actions)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_source_object)) {
            return;
        }
        static_cast<wl_data_source *>(r->data_source_object)->data_source_set_actions(
            r,
            dnd_actions);
    }

    void wl_data_source::send_target(const QString &mime_type)
    {
        Q_ASSERT_X(m_resource, "wl_data_source::target", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_source::target as it's not initialised");
            return;
        }
        send_target(
            m_resource->handle,
            mime_type);
    }

    void wl_data_source::send_target(struct ::wl_resource *resource, const QString &mime_type)
    {
        wl_data_source_send_target(
            resource,
            mime_type.toUtf8().constData());
    }


    void wl_data_source::send_send(const QString &mime_type, int32_t fd)
    {
        Q_ASSERT_X(m_resource, "wl_data_source::send", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_source::send as it's not initialised");
            return;
        }
        send_send(
            m_resource->handle,
            mime_type,
            fd);
    }

    void wl_data_source::send_send(struct ::wl_resource *resource, const QString &mime_type, int32_t fd)
    {
        wl_data_source_send_send(
            resource,
            mime_type.toUtf8().constData(),
            fd);
    }


    void wl_data_source::send_cancelled()
    {
        Q_ASSERT_X(m_resource, "wl_data_source::cancelled", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_source::cancelled as it's not initialised");
            return;
        }
        send_cancelled(
            m_resource->handle);
    }

    void wl_data_source::send_cancelled(struct ::wl_resource *resource)
    {
        wl_data_source_send_cancelled(
            resource);
    }


    void wl_data_source::send_dnd_drop_performed()
    {
        Q_ASSERT_X(m_resource, "wl_data_source::dnd_drop_performed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_source::dnd_drop_performed as it's not initialised");
            return;
        }
        send_dnd_drop_performed(
            m_resource->handle);
    }

    void wl_data_source::send_dnd_drop_performed(struct ::wl_resource *resource)
    {
        wl_data_source_send_dnd_drop_performed(
            resource);
    }


    void wl_data_source::send_dnd_finished()
    {
        Q_ASSERT_X(m_resource, "wl_data_source::dnd_finished", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_source::dnd_finished as it's not initialised");
            return;
        }
        send_dnd_finished(
            m_resource->handle);
    }

    void wl_data_source::send_dnd_finished(struct ::wl_resource *resource)
    {
        wl_data_source_send_dnd_finished(
            resource);
    }


    void wl_data_source::send_action(uint32_t dnd_action)
    {
        Q_ASSERT_X(m_resource, "wl_data_source::action", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_source::action as it's not initialised");
            return;
        }
        send_action(
            m_resource->handle,
            dnd_action);
    }

    void wl_data_source::send_action(struct ::wl_resource *resource, uint32_t dnd_action)
    {
        wl_data_source_send_action(
            resource,
            dnd_action);
    }


    wl_data_device::wl_data_device(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_data_device::wl_data_device(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_data_device::wl_data_device(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_data_device::wl_data_device()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_data_device::~wl_data_device()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->data_device_object = nullptr;

        if (m_resource)
            m_resource->data_device_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_data_device::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_data_device::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_data_device::Resource *wl_data_device::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_data_device::Resource *wl_data_device::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_data_device::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_data_device_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_data_device::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_data_device::interface()
    {
        return &::wl_data_device_interface;
    }

    wl_data_device::Resource *wl_data_device::data_device_allocate()
    {
        return new Resource;
    }

    void wl_data_device::data_device_bind_resource(Resource *)
    {
    }

    void wl_data_device::data_device_destroy_resource(Resource *)
    {
    }

    void wl_data_device::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_data_device *that = static_cast<wl_data_device *>(data);
        that->add(client, id, version);
    }

    void wl_data_device::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_data_device *that = static_cast<wl_data_device::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_data_device::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_data_device *that = resource->data_device_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->data_device_destroy_resource(resource);

            that = resource->data_device_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_data_device::Resource *wl_data_device::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_data_device_interface, version, id);
        return bind(handle);
    }

    wl_data_device::Resource *wl_data_device::bind(struct ::wl_resource *handle)
    {
        Resource *resource = data_device_allocate();
        resource->data_device_object = this;

        wl_resource_set_implementation(handle, &m_wl_data_device_interface, resource, destroy_func);
        resource->handle = handle;
        data_device_bind_resource(resource);
        return resource;
    }
    wl_data_device::Resource *wl_data_device::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_data_device_interface, &m_wl_data_device_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_data_device_interface wl_data_device::m_wl_data_device_interface = {
        wl_data_device::handle_start_drag,
        wl_data_device::handle_set_selection,
        wl_data_device::handle_release
    };

    void wl_data_device::data_device_start_drag(Resource *, struct ::wl_resource *, struct ::wl_resource *, struct ::wl_resource *, uint32_t )
    {
    }

    void wl_data_device::data_device_set_selection(Resource *, struct ::wl_resource *, uint32_t )
    {
    }

    void wl_data_device::data_device_release(Resource *)
    {
    }


    void wl_data_device::handle_start_drag(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *source,
        struct ::wl_resource *origin,
        struct ::wl_resource *icon,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_device_object)) {
            return;
        }
        static_cast<wl_data_device *>(r->data_device_object)->data_device_start_drag(
            r,
            source,
            origin,
            icon,
            serial);
    }

    void wl_data_device::handle_set_selection(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *source,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_device_object)) {
            return;
        }
        static_cast<wl_data_device *>(r->data_device_object)->data_device_set_selection(
            r,
            source,
            serial);
    }

    void wl_data_device::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_device_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_data_device *>(r->data_device_object)->data_device_release(
            r);
    }

    void wl_data_device::send_data_offer(struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "wl_data_device::data_offer", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_device::data_offer as it's not initialised");
            return;
        }
        send_data_offer(
            m_resource->handle,
            id);
    }

    void wl_data_device::send_data_offer(struct ::wl_resource *resource, struct ::wl_resource *id)
    {
        wl_data_device_send_data_offer(
            resource,
            id);
    }


    void wl_data_device::send_enter(uint32_t serial, struct ::wl_resource *surface, wl_fixed_t x, wl_fixed_t y, struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "wl_data_device::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_device::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            serial,
            surface,
            x,
            y,
            id);
    }

    void wl_data_device::send_enter(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface, wl_fixed_t x, wl_fixed_t y, struct ::wl_resource *id)
    {
        wl_data_device_send_enter(
            resource,
            serial,
            surface,
            x,
            y,
            id);
    }


    void wl_data_device::send_leave()
    {
        Q_ASSERT_X(m_resource, "wl_data_device::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_device::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle);
    }

    void wl_data_device::send_leave(struct ::wl_resource *resource)
    {
        wl_data_device_send_leave(
            resource);
    }


    void wl_data_device::send_motion(uint32_t time, wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "wl_data_device::motion", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_device::motion as it's not initialised");
            return;
        }
        send_motion(
            m_resource->handle,
            time,
            x,
            y);
    }

    void wl_data_device::send_motion(struct ::wl_resource *resource, uint32_t time, wl_fixed_t x, wl_fixed_t y)
    {
        wl_data_device_send_motion(
            resource,
            time,
            x,
            y);
    }


    void wl_data_device::send_drop()
    {
        Q_ASSERT_X(m_resource, "wl_data_device::drop", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_device::drop as it's not initialised");
            return;
        }
        send_drop(
            m_resource->handle);
    }

    void wl_data_device::send_drop(struct ::wl_resource *resource)
    {
        wl_data_device_send_drop(
            resource);
    }


    void wl_data_device::send_selection(struct ::wl_resource *id)
    {
        Q_ASSERT_X(m_resource, "wl_data_device::selection", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_data_device::selection as it's not initialised");
            return;
        }
        send_selection(
            m_resource->handle,
            id);
    }

    void wl_data_device::send_selection(struct ::wl_resource *resource, struct ::wl_resource *id)
    {
        wl_data_device_send_selection(
            resource,
            id);
    }


    wl_data_device_manager::wl_data_device_manager(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_data_device_manager::wl_data_device_manager(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_data_device_manager::wl_data_device_manager(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_data_device_manager::wl_data_device_manager()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_data_device_manager::~wl_data_device_manager()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->data_device_manager_object = nullptr;

        if (m_resource)
            m_resource->data_device_manager_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_data_device_manager::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_data_device_manager::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_data_device_manager::Resource *wl_data_device_manager::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_data_device_manager::Resource *wl_data_device_manager::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_data_device_manager::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_data_device_manager_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_data_device_manager::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_data_device_manager::interface()
    {
        return &::wl_data_device_manager_interface;
    }

    wl_data_device_manager::Resource *wl_data_device_manager::data_device_manager_allocate()
    {
        return new Resource;
    }

    void wl_data_device_manager::data_device_manager_bind_resource(Resource *)
    {
    }

    void wl_data_device_manager::data_device_manager_destroy_resource(Resource *)
    {
    }

    void wl_data_device_manager::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_data_device_manager *that = static_cast<wl_data_device_manager *>(data);
        that->add(client, id, version);
    }

    void wl_data_device_manager::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_data_device_manager *that = static_cast<wl_data_device_manager::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_data_device_manager::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_data_device_manager *that = resource->data_device_manager_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->data_device_manager_destroy_resource(resource);

            that = resource->data_device_manager_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_data_device_manager::Resource *wl_data_device_manager::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_data_device_manager_interface, version, id);
        return bind(handle);
    }

    wl_data_device_manager::Resource *wl_data_device_manager::bind(struct ::wl_resource *handle)
    {
        Resource *resource = data_device_manager_allocate();
        resource->data_device_manager_object = this;

        wl_resource_set_implementation(handle, &m_wl_data_device_manager_interface, resource, destroy_func);
        resource->handle = handle;
        data_device_manager_bind_resource(resource);
        return resource;
    }
    wl_data_device_manager::Resource *wl_data_device_manager::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_data_device_manager_interface, &m_wl_data_device_manager_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_data_device_manager_interface wl_data_device_manager::m_wl_data_device_manager_interface = {
        wl_data_device_manager::handle_create_data_source,
        wl_data_device_manager::handle_get_data_device
    };

    void wl_data_device_manager::data_device_manager_create_data_source(Resource *, uint32_t)
    {
    }

    void wl_data_device_manager::data_device_manager_get_data_device(Resource *, uint32_t, struct ::wl_resource *)
    {
    }


    void wl_data_device_manager::handle_create_data_source(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_device_manager_object)) {
            return;
        }
        static_cast<wl_data_device_manager *>(r->data_device_manager_object)->data_device_manager_create_data_source(
            r,
            id);
    }

    void wl_data_device_manager::handle_get_data_device(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        struct ::wl_resource *seat)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->data_device_manager_object)) {
            return;
        }
        static_cast<wl_data_device_manager *>(r->data_device_manager_object)->data_device_manager_get_data_device(
            r,
            id,
            seat);
    }

    wl_shell::wl_shell(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_shell::wl_shell(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_shell::wl_shell(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_shell::wl_shell()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_shell::~wl_shell()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->shell_object = nullptr;

        if (m_resource)
            m_resource->shell_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_shell::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_shell::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_shell::Resource *wl_shell::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_shell::Resource *wl_shell::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_shell::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_shell_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_shell::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_shell::interface()
    {
        return &::wl_shell_interface;
    }

    wl_shell::Resource *wl_shell::shell_allocate()
    {
        return new Resource;
    }

    void wl_shell::shell_bind_resource(Resource *)
    {
    }

    void wl_shell::shell_destroy_resource(Resource *)
    {
    }

    void wl_shell::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_shell *that = static_cast<wl_shell *>(data);
        that->add(client, id, version);
    }

    void wl_shell::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_shell *that = static_cast<wl_shell::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_shell::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_shell *that = resource->shell_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->shell_destroy_resource(resource);

            that = resource->shell_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_shell::Resource *wl_shell::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_shell_interface, version, id);
        return bind(handle);
    }

    wl_shell::Resource *wl_shell::bind(struct ::wl_resource *handle)
    {
        Resource *resource = shell_allocate();
        resource->shell_object = this;

        wl_resource_set_implementation(handle, &m_wl_shell_interface, resource, destroy_func);
        resource->handle = handle;
        shell_bind_resource(resource);
        return resource;
    }
    wl_shell::Resource *wl_shell::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_shell_interface, &m_wl_shell_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_shell_interface wl_shell::m_wl_shell_interface = {
        wl_shell::handle_get_shell_surface
    };

    void wl_shell::shell_get_shell_surface(Resource *, uint32_t, struct ::wl_resource *)
    {
    }


    void wl_shell::handle_get_shell_surface(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        struct ::wl_resource *surface)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_object)) {
            return;
        }
        static_cast<wl_shell *>(r->shell_object)->shell_get_shell_surface(
            r,
            id,
            surface);
    }

    wl_shell_surface::wl_shell_surface(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_shell_surface::wl_shell_surface(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_shell_surface::wl_shell_surface(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_shell_surface::wl_shell_surface()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_shell_surface::~wl_shell_surface()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->shell_surface_object = nullptr;

        if (m_resource)
            m_resource->shell_surface_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_shell_surface::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_shell_surface::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_shell_surface::Resource *wl_shell_surface::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_shell_surface::Resource *wl_shell_surface::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_shell_surface::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_shell_surface_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_shell_surface::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_shell_surface::interface()
    {
        return &::wl_shell_surface_interface;
    }

    wl_shell_surface::Resource *wl_shell_surface::shell_surface_allocate()
    {
        return new Resource;
    }

    void wl_shell_surface::shell_surface_bind_resource(Resource *)
    {
    }

    void wl_shell_surface::shell_surface_destroy_resource(Resource *)
    {
    }

    void wl_shell_surface::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_shell_surface *that = static_cast<wl_shell_surface *>(data);
        that->add(client, id, version);
    }

    void wl_shell_surface::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_shell_surface *that = static_cast<wl_shell_surface::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_shell_surface::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_shell_surface *that = resource->shell_surface_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->shell_surface_destroy_resource(resource);

            that = resource->shell_surface_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_shell_surface::Resource *wl_shell_surface::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_shell_surface_interface, version, id);
        return bind(handle);
    }

    wl_shell_surface::Resource *wl_shell_surface::bind(struct ::wl_resource *handle)
    {
        Resource *resource = shell_surface_allocate();
        resource->shell_surface_object = this;

        wl_resource_set_implementation(handle, &m_wl_shell_surface_interface, resource, destroy_func);
        resource->handle = handle;
        shell_surface_bind_resource(resource);
        return resource;
    }
    wl_shell_surface::Resource *wl_shell_surface::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_shell_surface_interface, &m_wl_shell_surface_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_shell_surface_interface wl_shell_surface::m_wl_shell_surface_interface = {
        wl_shell_surface::handle_pong,
        wl_shell_surface::handle_move,
        wl_shell_surface::handle_resize,
        wl_shell_surface::handle_set_toplevel,
        wl_shell_surface::handle_set_transient,
        wl_shell_surface::handle_set_fullscreen,
        wl_shell_surface::handle_set_popup,
        wl_shell_surface::handle_set_maximized,
        wl_shell_surface::handle_set_title,
        wl_shell_surface::handle_set_class
    };

    void wl_shell_surface::shell_surface_pong(Resource *, uint32_t )
    {
    }

    void wl_shell_surface::shell_surface_move(Resource *, struct ::wl_resource *, uint32_t )
    {
    }

    void wl_shell_surface::shell_surface_resize(Resource *, struct ::wl_resource *, uint32_t , uint32_t )
    {
    }

    void wl_shell_surface::shell_surface_set_toplevel(Resource *)
    {
    }

    void wl_shell_surface::shell_surface_set_transient(Resource *, struct ::wl_resource *, int32_t , int32_t , uint32_t )
    {
    }

    void wl_shell_surface::shell_surface_set_fullscreen(Resource *, uint32_t , uint32_t , struct ::wl_resource *)
    {
    }

    void wl_shell_surface::shell_surface_set_popup(Resource *, struct ::wl_resource *, uint32_t , struct ::wl_resource *, int32_t , int32_t , uint32_t )
    {
    }

    void wl_shell_surface::shell_surface_set_maximized(Resource *, struct ::wl_resource *)
    {
    }

    void wl_shell_surface::shell_surface_set_title(Resource *, const QString &)
    {
    }

    void wl_shell_surface::shell_surface_set_class(Resource *, const QString &)
    {
    }


    void wl_shell_surface::handle_pong(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_pong(
            r,
            serial);
    }

    void wl_shell_surface::handle_move(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *seat,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_move(
            r,
            seat,
            serial);
    }

    void wl_shell_surface::handle_resize(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *seat,
        uint32_t serial,
        uint32_t edges)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_resize(
            r,
            seat,
            serial,
            edges);
    }

    void wl_shell_surface::handle_set_toplevel(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_toplevel(
            r);
    }

    void wl_shell_surface::handle_set_transient(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *parent,
        int32_t x,
        int32_t y,
        uint32_t flags)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_transient(
            r,
            parent,
            x,
            y,
            flags);
    }

    void wl_shell_surface::handle_set_fullscreen(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t method,
        uint32_t framerate,
        struct ::wl_resource *output)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_fullscreen(
            r,
            method,
            framerate,
            output);
    }

    void wl_shell_surface::handle_set_popup(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *seat,
        uint32_t serial,
        struct ::wl_resource *parent,
        int32_t x,
        int32_t y,
        uint32_t flags)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_popup(
            r,
            seat,
            serial,
            parent,
            x,
            y,
            flags);
    }

    void wl_shell_surface::handle_set_maximized(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *output)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_maximized(
            r,
            output);
    }

    void wl_shell_surface::handle_set_title(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *title)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_title(
            r,
            QString::fromUtf8(title));
    }

    void wl_shell_surface::handle_set_class(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *class_)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->shell_surface_object)) {
            return;
        }
        static_cast<wl_shell_surface *>(r->shell_surface_object)->shell_surface_set_class(
            r,
            QString::fromUtf8(class_));
    }

    void wl_shell_surface::send_ping(uint32_t serial)
    {
        Q_ASSERT_X(m_resource, "wl_shell_surface::ping", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_shell_surface::ping as it's not initialised");
            return;
        }
        send_ping(
            m_resource->handle,
            serial);
    }

    void wl_shell_surface::send_ping(struct ::wl_resource *resource, uint32_t serial)
    {
        wl_shell_surface_send_ping(
            resource,
            serial);
    }


    void wl_shell_surface::send_configure(uint32_t edges, int32_t width, int32_t height)
    {
        Q_ASSERT_X(m_resource, "wl_shell_surface::configure", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_shell_surface::configure as it's not initialised");
            return;
        }
        send_configure(
            m_resource->handle,
            edges,
            width,
            height);
    }

    void wl_shell_surface::send_configure(struct ::wl_resource *resource, uint32_t edges, int32_t width, int32_t height)
    {
        wl_shell_surface_send_configure(
            resource,
            edges,
            width,
            height);
    }


    void wl_shell_surface::send_popup_done()
    {
        Q_ASSERT_X(m_resource, "wl_shell_surface::popup_done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_shell_surface::popup_done as it's not initialised");
            return;
        }
        send_popup_done(
            m_resource->handle);
    }

    void wl_shell_surface::send_popup_done(struct ::wl_resource *resource)
    {
        wl_shell_surface_send_popup_done(
            resource);
    }


    wl_surface::wl_surface(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_surface::wl_surface(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_surface::wl_surface(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_surface::wl_surface()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_surface::~wl_surface()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->surface_object = nullptr;

        if (m_resource)
            m_resource->surface_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_surface::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_surface::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_surface::Resource *wl_surface::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_surface::Resource *wl_surface::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_surface::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_surface_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_surface::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_surface::interface()
    {
        return &::wl_surface_interface;
    }

    wl_surface::Resource *wl_surface::surface_allocate()
    {
        return new Resource;
    }

    void wl_surface::surface_bind_resource(Resource *)
    {
    }

    void wl_surface::surface_destroy_resource(Resource *)
    {
    }

    void wl_surface::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_surface *that = static_cast<wl_surface *>(data);
        that->add(client, id, version);
    }

    void wl_surface::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_surface *that = static_cast<wl_surface::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_surface::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_surface *that = resource->surface_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->surface_destroy_resource(resource);

            that = resource->surface_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_surface::Resource *wl_surface::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_surface_interface, version, id);
        return bind(handle);
    }

    wl_surface::Resource *wl_surface::bind(struct ::wl_resource *handle)
    {
        Resource *resource = surface_allocate();
        resource->surface_object = this;

        wl_resource_set_implementation(handle, &m_wl_surface_interface, resource, destroy_func);
        resource->handle = handle;
        surface_bind_resource(resource);
        return resource;
    }
    wl_surface::Resource *wl_surface::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_surface_interface, &m_wl_surface_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_surface_interface wl_surface::m_wl_surface_interface = {
        wl_surface::handle_destroy,
        wl_surface::handle_attach,
        wl_surface::handle_damage,
        wl_surface::handle_frame,
        wl_surface::handle_set_opaque_region,
        wl_surface::handle_set_input_region,
        wl_surface::handle_commit,
        wl_surface::handle_set_buffer_transform,
        wl_surface::handle_set_buffer_scale,
        wl_surface::handle_damage_buffer,
        wl_surface::handle_offset
    };

    void wl_surface::surface_destroy(Resource *)
    {
    }

    void wl_surface::surface_attach(Resource *, struct ::wl_resource *, int32_t , int32_t )
    {
    }

    void wl_surface::surface_damage(Resource *, int32_t , int32_t , int32_t , int32_t )
    {
    }

    void wl_surface::surface_frame(Resource *, uint32_t)
    {
    }

    void wl_surface::surface_set_opaque_region(Resource *, struct ::wl_resource *)
    {
    }

    void wl_surface::surface_set_input_region(Resource *, struct ::wl_resource *)
    {
    }

    void wl_surface::surface_commit(Resource *)
    {
    }

    void wl_surface::surface_set_buffer_transform(Resource *, int32_t )
    {
    }

    void wl_surface::surface_set_buffer_scale(Resource *, int32_t )
    {
    }

    void wl_surface::surface_damage_buffer(Resource *, int32_t , int32_t , int32_t , int32_t )
    {
    }

    void wl_surface::surface_offset(Resource *, int32_t , int32_t )
    {
    }


    void wl_surface::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_destroy(
            r);
    }

    void wl_surface::handle_attach(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *buffer,
        int32_t x,
        int32_t y)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_attach(
            r,
            buffer,
            x,
            y);
    }

    void wl_surface::handle_damage(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y,
        int32_t width,
        int32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_damage(
            r,
            x,
            y,
            width,
            height);
    }

    void wl_surface::handle_frame(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t callback)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_frame(
            r,
            callback);
    }

    void wl_surface::handle_set_opaque_region(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *region)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_set_opaque_region(
            r,
            region);
    }

    void wl_surface::handle_set_input_region(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *region)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_set_input_region(
            r,
            region);
    }

    void wl_surface::handle_commit(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_commit(
            r);
    }

    void wl_surface::handle_set_buffer_transform(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t transform)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_set_buffer_transform(
            r,
            transform);
    }

    void wl_surface::handle_set_buffer_scale(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t scale)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_set_buffer_scale(
            r,
            scale);
    }

    void wl_surface::handle_damage_buffer(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y,
        int32_t width,
        int32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_damage_buffer(
            r,
            x,
            y,
            width,
            height);
    }

    void wl_surface::handle_offset(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->surface_object)) {
            return;
        }
        static_cast<wl_surface *>(r->surface_object)->surface_offset(
            r,
            x,
            y);
    }

    void wl_surface::send_enter(struct ::wl_resource *output)
    {
        Q_ASSERT_X(m_resource, "wl_surface::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_surface::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            output);
    }

    void wl_surface::send_enter(struct ::wl_resource *resource, struct ::wl_resource *output)
    {
        wl_surface_send_enter(
            resource,
            output);
    }


    void wl_surface::send_leave(struct ::wl_resource *output)
    {
        Q_ASSERT_X(m_resource, "wl_surface::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_surface::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle,
            output);
    }

    void wl_surface::send_leave(struct ::wl_resource *resource, struct ::wl_resource *output)
    {
        wl_surface_send_leave(
            resource,
            output);
    }


    void wl_surface::send_preferred_buffer_scale(int32_t factor)
    {
        Q_ASSERT_X(m_resource, "wl_surface::preferred_buffer_scale", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_surface::preferred_buffer_scale as it's not initialised");
            return;
        }
        send_preferred_buffer_scale(
            m_resource->handle,
            factor);
    }

    void wl_surface::send_preferred_buffer_scale(struct ::wl_resource *resource, int32_t factor)
    {
        wl_surface_send_preferred_buffer_scale(
            resource,
            factor);
    }


    void wl_surface::send_preferred_buffer_transform(uint32_t transform)
    {
        Q_ASSERT_X(m_resource, "wl_surface::preferred_buffer_transform", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_surface::preferred_buffer_transform as it's not initialised");
            return;
        }
        send_preferred_buffer_transform(
            m_resource->handle,
            transform);
    }

    void wl_surface::send_preferred_buffer_transform(struct ::wl_resource *resource, uint32_t transform)
    {
        wl_surface_send_preferred_buffer_transform(
            resource,
            transform);
    }


    wl_seat::wl_seat(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_seat::wl_seat(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_seat::wl_seat(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_seat::wl_seat()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_seat::~wl_seat()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->seat_object = nullptr;

        if (m_resource)
            m_resource->seat_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_seat::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_seat::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_seat::Resource *wl_seat::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_seat::Resource *wl_seat::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_seat::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_seat_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_seat::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_seat::interface()
    {
        return &::wl_seat_interface;
    }

    wl_seat::Resource *wl_seat::seat_allocate()
    {
        return new Resource;
    }

    void wl_seat::seat_bind_resource(Resource *)
    {
    }

    void wl_seat::seat_destroy_resource(Resource *)
    {
    }

    void wl_seat::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_seat *that = static_cast<wl_seat *>(data);
        that->add(client, id, version);
    }

    void wl_seat::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_seat *that = static_cast<wl_seat::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_seat::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_seat *that = resource->seat_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->seat_destroy_resource(resource);

            that = resource->seat_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_seat::Resource *wl_seat::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_seat_interface, version, id);
        return bind(handle);
    }

    wl_seat::Resource *wl_seat::bind(struct ::wl_resource *handle)
    {
        Resource *resource = seat_allocate();
        resource->seat_object = this;

        wl_resource_set_implementation(handle, &m_wl_seat_interface, resource, destroy_func);
        resource->handle = handle;
        seat_bind_resource(resource);
        return resource;
    }
    wl_seat::Resource *wl_seat::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_seat_interface, &m_wl_seat_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_seat_interface wl_seat::m_wl_seat_interface = {
        wl_seat::handle_get_pointer,
        wl_seat::handle_get_keyboard,
        wl_seat::handle_get_touch,
        wl_seat::handle_release
    };

    void wl_seat::seat_get_pointer(Resource *, uint32_t)
    {
    }

    void wl_seat::seat_get_keyboard(Resource *, uint32_t)
    {
    }

    void wl_seat::seat_get_touch(Resource *, uint32_t)
    {
    }

    void wl_seat::seat_release(Resource *)
    {
    }


    void wl_seat::handle_get_pointer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->seat_object)) {
            return;
        }
        static_cast<wl_seat *>(r->seat_object)->seat_get_pointer(
            r,
            id);
    }

    void wl_seat::handle_get_keyboard(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->seat_object)) {
            return;
        }
        static_cast<wl_seat *>(r->seat_object)->seat_get_keyboard(
            r,
            id);
    }

    void wl_seat::handle_get_touch(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->seat_object)) {
            return;
        }
        static_cast<wl_seat *>(r->seat_object)->seat_get_touch(
            r,
            id);
    }

    void wl_seat::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->seat_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_seat *>(r->seat_object)->seat_release(
            r);
    }

    void wl_seat::send_capabilities(uint32_t capabilities)
    {
        Q_ASSERT_X(m_resource, "wl_seat::capabilities", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_seat::capabilities as it's not initialised");
            return;
        }
        send_capabilities(
            m_resource->handle,
            capabilities);
    }

    void wl_seat::send_capabilities(struct ::wl_resource *resource, uint32_t capabilities)
    {
        wl_seat_send_capabilities(
            resource,
            capabilities);
    }


    void wl_seat::send_name(const QString &name)
    {
        Q_ASSERT_X(m_resource, "wl_seat::name", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_seat::name as it's not initialised");
            return;
        }
        send_name(
            m_resource->handle,
            name);
    }

    void wl_seat::send_name(struct ::wl_resource *resource, const QString &name)
    {
        wl_seat_send_name(
            resource,
            name.toUtf8().constData());
    }


    wl_pointer::wl_pointer(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_pointer::wl_pointer(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_pointer::wl_pointer(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_pointer::wl_pointer()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_pointer::~wl_pointer()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->pointer_object = nullptr;

        if (m_resource)
            m_resource->pointer_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_pointer::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_pointer::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_pointer::Resource *wl_pointer::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_pointer::Resource *wl_pointer::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_pointer::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_pointer_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_pointer::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_pointer::interface()
    {
        return &::wl_pointer_interface;
    }

    wl_pointer::Resource *wl_pointer::pointer_allocate()
    {
        return new Resource;
    }

    void wl_pointer::pointer_bind_resource(Resource *)
    {
    }

    void wl_pointer::pointer_destroy_resource(Resource *)
    {
    }

    void wl_pointer::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_pointer *that = static_cast<wl_pointer *>(data);
        that->add(client, id, version);
    }

    void wl_pointer::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_pointer *that = static_cast<wl_pointer::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_pointer::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_pointer *that = resource->pointer_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->pointer_destroy_resource(resource);

            that = resource->pointer_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_pointer::Resource *wl_pointer::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_pointer_interface, version, id);
        return bind(handle);
    }

    wl_pointer::Resource *wl_pointer::bind(struct ::wl_resource *handle)
    {
        Resource *resource = pointer_allocate();
        resource->pointer_object = this;

        wl_resource_set_implementation(handle, &m_wl_pointer_interface, resource, destroy_func);
        resource->handle = handle;
        pointer_bind_resource(resource);
        return resource;
    }
    wl_pointer::Resource *wl_pointer::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_pointer_interface, &m_wl_pointer_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_pointer_interface wl_pointer::m_wl_pointer_interface = {
        wl_pointer::handle_set_cursor,
        wl_pointer::handle_release
    };

    void wl_pointer::pointer_set_cursor(Resource *, uint32_t , struct ::wl_resource *, int32_t , int32_t )
    {
    }

    void wl_pointer::pointer_release(Resource *)
    {
    }


    void wl_pointer::handle_set_cursor(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t serial,
        struct ::wl_resource *surface,
        int32_t hotspot_x,
        int32_t hotspot_y)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->pointer_object)) {
            return;
        }
        static_cast<wl_pointer *>(r->pointer_object)->pointer_set_cursor(
            r,
            serial,
            surface,
            hotspot_x,
            hotspot_y);
    }

    void wl_pointer::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->pointer_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_pointer *>(r->pointer_object)->pointer_release(
            r);
    }

    void wl_pointer::send_enter(uint32_t serial, struct ::wl_resource *surface, wl_fixed_t surface_x, wl_fixed_t surface_y)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            serial,
            surface,
            surface_x,
            surface_y);
    }

    void wl_pointer::send_enter(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface, wl_fixed_t surface_x, wl_fixed_t surface_y)
    {
        wl_pointer_send_enter(
            resource,
            serial,
            surface,
            surface_x,
            surface_y);
    }


    void wl_pointer::send_leave(uint32_t serial, struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle,
            serial,
            surface);
    }

    void wl_pointer::send_leave(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface)
    {
        wl_pointer_send_leave(
            resource,
            serial,
            surface);
    }


    void wl_pointer::send_motion(uint32_t time, wl_fixed_t surface_x, wl_fixed_t surface_y)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::motion", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::motion as it's not initialised");
            return;
        }
        send_motion(
            m_resource->handle,
            time,
            surface_x,
            surface_y);
    }

    void wl_pointer::send_motion(struct ::wl_resource *resource, uint32_t time, wl_fixed_t surface_x, wl_fixed_t surface_y)
    {
        wl_pointer_send_motion(
            resource,
            time,
            surface_x,
            surface_y);
    }


    void wl_pointer::send_button(uint32_t serial, uint32_t time, uint32_t button, uint32_t state)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::button", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::button as it's not initialised");
            return;
        }
        send_button(
            m_resource->handle,
            serial,
            time,
            button,
            state);
    }

    void wl_pointer::send_button(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t button, uint32_t state)
    {
        wl_pointer_send_button(
            resource,
            serial,
            time,
            button,
            state);
    }


    void wl_pointer::send_axis(uint32_t time, uint32_t axis, wl_fixed_t value)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::axis", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::axis as it's not initialised");
            return;
        }
        send_axis(
            m_resource->handle,
            time,
            axis,
            value);
    }

    void wl_pointer::send_axis(struct ::wl_resource *resource, uint32_t time, uint32_t axis, wl_fixed_t value)
    {
        wl_pointer_send_axis(
            resource,
            time,
            axis,
            value);
    }


    void wl_pointer::send_frame()
    {
        Q_ASSERT_X(m_resource, "wl_pointer::frame", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::frame as it's not initialised");
            return;
        }
        send_frame(
            m_resource->handle);
    }

    void wl_pointer::send_frame(struct ::wl_resource *resource)
    {
        wl_pointer_send_frame(
            resource);
    }


    void wl_pointer::send_axis_source(uint32_t axis_source)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::axis_source", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::axis_source as it's not initialised");
            return;
        }
        send_axis_source(
            m_resource->handle,
            axis_source);
    }

    void wl_pointer::send_axis_source(struct ::wl_resource *resource, uint32_t axis_source)
    {
        wl_pointer_send_axis_source(
            resource,
            axis_source);
    }


    void wl_pointer::send_axis_stop(uint32_t time, uint32_t axis)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::axis_stop", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::axis_stop as it's not initialised");
            return;
        }
        send_axis_stop(
            m_resource->handle,
            time,
            axis);
    }

    void wl_pointer::send_axis_stop(struct ::wl_resource *resource, uint32_t time, uint32_t axis)
    {
        wl_pointer_send_axis_stop(
            resource,
            time,
            axis);
    }


    void wl_pointer::send_axis_discrete(uint32_t axis, int32_t discrete)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::axis_discrete", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::axis_discrete as it's not initialised");
            return;
        }
        send_axis_discrete(
            m_resource->handle,
            axis,
            discrete);
    }

    void wl_pointer::send_axis_discrete(struct ::wl_resource *resource, uint32_t axis, int32_t discrete)
    {
        wl_pointer_send_axis_discrete(
            resource,
            axis,
            discrete);
    }


    void wl_pointer::send_axis_value120(uint32_t axis, int32_t value120)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::axis_value120", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::axis_value120 as it's not initialised");
            return;
        }
        send_axis_value120(
            m_resource->handle,
            axis,
            value120);
    }

    void wl_pointer::send_axis_value120(struct ::wl_resource *resource, uint32_t axis, int32_t value120)
    {
        wl_pointer_send_axis_value120(
            resource,
            axis,
            value120);
    }


    void wl_pointer::send_axis_relative_direction(uint32_t axis, uint32_t direction)
    {
        Q_ASSERT_X(m_resource, "wl_pointer::axis_relative_direction", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_pointer::axis_relative_direction as it's not initialised");
            return;
        }
        send_axis_relative_direction(
            m_resource->handle,
            axis,
            direction);
    }

    void wl_pointer::send_axis_relative_direction(struct ::wl_resource *resource, uint32_t axis, uint32_t direction)
    {
        wl_pointer_send_axis_relative_direction(
            resource,
            axis,
            direction);
    }


    wl_keyboard::wl_keyboard(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_keyboard::wl_keyboard(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_keyboard::wl_keyboard(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_keyboard::wl_keyboard()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_keyboard::~wl_keyboard()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->keyboard_object = nullptr;

        if (m_resource)
            m_resource->keyboard_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_keyboard::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_keyboard::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_keyboard::Resource *wl_keyboard::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_keyboard::Resource *wl_keyboard::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_keyboard::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_keyboard_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_keyboard::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_keyboard::interface()
    {
        return &::wl_keyboard_interface;
    }

    wl_keyboard::Resource *wl_keyboard::keyboard_allocate()
    {
        return new Resource;
    }

    void wl_keyboard::keyboard_bind_resource(Resource *)
    {
    }

    void wl_keyboard::keyboard_destroy_resource(Resource *)
    {
    }

    void wl_keyboard::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_keyboard *that = static_cast<wl_keyboard *>(data);
        that->add(client, id, version);
    }

    void wl_keyboard::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_keyboard *that = static_cast<wl_keyboard::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_keyboard::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_keyboard *that = resource->keyboard_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->keyboard_destroy_resource(resource);

            that = resource->keyboard_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_keyboard::Resource *wl_keyboard::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_keyboard_interface, version, id);
        return bind(handle);
    }

    wl_keyboard::Resource *wl_keyboard::bind(struct ::wl_resource *handle)
    {
        Resource *resource = keyboard_allocate();
        resource->keyboard_object = this;

        wl_resource_set_implementation(handle, &m_wl_keyboard_interface, resource, destroy_func);
        resource->handle = handle;
        keyboard_bind_resource(resource);
        return resource;
    }
    wl_keyboard::Resource *wl_keyboard::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_keyboard_interface, &m_wl_keyboard_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_keyboard_interface wl_keyboard::m_wl_keyboard_interface = {
        wl_keyboard::handle_release
    };

    void wl_keyboard::keyboard_release(Resource *)
    {
    }


    void wl_keyboard::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->keyboard_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_keyboard *>(r->keyboard_object)->keyboard_release(
            r);
    }

    void wl_keyboard::send_keymap(uint32_t format, int32_t fd, uint32_t size)
    {
        Q_ASSERT_X(m_resource, "wl_keyboard::keymap", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_keyboard::keymap as it's not initialised");
            return;
        }
        send_keymap(
            m_resource->handle,
            format,
            fd,
            size);
    }

    void wl_keyboard::send_keymap(struct ::wl_resource *resource, uint32_t format, int32_t fd, uint32_t size)
    {
        wl_keyboard_send_keymap(
            resource,
            format,
            fd,
            size);
    }


    void wl_keyboard::send_enter(uint32_t serial, struct ::wl_resource *surface, const QByteArray &keys)
    {
        Q_ASSERT_X(m_resource, "wl_keyboard::enter", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_keyboard::enter as it's not initialised");
            return;
        }
        send_enter(
            m_resource->handle,
            serial,
            surface,
            keys);
    }

    void wl_keyboard::send_enter(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface, const QByteArray &keys)
    {
        struct wl_array keys_data;
        keys_data.size = keys.size();
        keys_data.data = static_cast<void *>(const_cast<char *>(keys.constData()));
        keys_data.alloc = 0;

        wl_keyboard_send_enter(
            resource,
            serial,
            surface,
            &keys_data);
    }


    void wl_keyboard::send_leave(uint32_t serial, struct ::wl_resource *surface)
    {
        Q_ASSERT_X(m_resource, "wl_keyboard::leave", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_keyboard::leave as it's not initialised");
            return;
        }
        send_leave(
            m_resource->handle,
            serial,
            surface);
    }

    void wl_keyboard::send_leave(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface)
    {
        wl_keyboard_send_leave(
            resource,
            serial,
            surface);
    }


    void wl_keyboard::send_key(uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
    {
        Q_ASSERT_X(m_resource, "wl_keyboard::key", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_keyboard::key as it's not initialised");
            return;
        }
        send_key(
            m_resource->handle,
            serial,
            time,
            key,
            state);
    }

    void wl_keyboard::send_key(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
    {
        wl_keyboard_send_key(
            resource,
            serial,
            time,
            key,
            state);
    }


    void wl_keyboard::send_modifiers(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
    {
        Q_ASSERT_X(m_resource, "wl_keyboard::modifiers", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_keyboard::modifiers as it's not initialised");
            return;
        }
        send_modifiers(
            m_resource->handle,
            serial,
            mods_depressed,
            mods_latched,
            mods_locked,
            group);
    }

    void wl_keyboard::send_modifiers(struct ::wl_resource *resource, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
    {
        wl_keyboard_send_modifiers(
            resource,
            serial,
            mods_depressed,
            mods_latched,
            mods_locked,
            group);
    }


    void wl_keyboard::send_repeat_info(int32_t rate, int32_t delay)
    {
        Q_ASSERT_X(m_resource, "wl_keyboard::repeat_info", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_keyboard::repeat_info as it's not initialised");
            return;
        }
        send_repeat_info(
            m_resource->handle,
            rate,
            delay);
    }

    void wl_keyboard::send_repeat_info(struct ::wl_resource *resource, int32_t rate, int32_t delay)
    {
        wl_keyboard_send_repeat_info(
            resource,
            rate,
            delay);
    }


    wl_touch::wl_touch(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_touch::wl_touch(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_touch::wl_touch(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_touch::wl_touch()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_touch::~wl_touch()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->touch_object = nullptr;

        if (m_resource)
            m_resource->touch_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_touch::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_touch::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_touch::Resource *wl_touch::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_touch::Resource *wl_touch::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_touch::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_touch_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_touch::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_touch::interface()
    {
        return &::wl_touch_interface;
    }

    wl_touch::Resource *wl_touch::touch_allocate()
    {
        return new Resource;
    }

    void wl_touch::touch_bind_resource(Resource *)
    {
    }

    void wl_touch::touch_destroy_resource(Resource *)
    {
    }

    void wl_touch::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_touch *that = static_cast<wl_touch *>(data);
        that->add(client, id, version);
    }

    void wl_touch::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_touch *that = static_cast<wl_touch::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_touch::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_touch *that = resource->touch_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->touch_destroy_resource(resource);

            that = resource->touch_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_touch::Resource *wl_touch::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_touch_interface, version, id);
        return bind(handle);
    }

    wl_touch::Resource *wl_touch::bind(struct ::wl_resource *handle)
    {
        Resource *resource = touch_allocate();
        resource->touch_object = this;

        wl_resource_set_implementation(handle, &m_wl_touch_interface, resource, destroy_func);
        resource->handle = handle;
        touch_bind_resource(resource);
        return resource;
    }
    wl_touch::Resource *wl_touch::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_touch_interface, &m_wl_touch_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_touch_interface wl_touch::m_wl_touch_interface = {
        wl_touch::handle_release
    };

    void wl_touch::touch_release(Resource *)
    {
    }


    void wl_touch::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->touch_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_touch *>(r->touch_object)->touch_release(
            r);
    }

    void wl_touch::send_down(uint32_t serial, uint32_t time, struct ::wl_resource *surface, int32_t id, wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "wl_touch::down", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::down as it's not initialised");
            return;
        }
        send_down(
            m_resource->handle,
            serial,
            time,
            surface,
            id,
            x,
            y);
    }

    void wl_touch::send_down(struct ::wl_resource *resource, uint32_t serial, uint32_t time, struct ::wl_resource *surface, int32_t id, wl_fixed_t x, wl_fixed_t y)
    {
        wl_touch_send_down(
            resource,
            serial,
            time,
            surface,
            id,
            x,
            y);
    }


    void wl_touch::send_up(uint32_t serial, uint32_t time, int32_t id)
    {
        Q_ASSERT_X(m_resource, "wl_touch::up", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::up as it's not initialised");
            return;
        }
        send_up(
            m_resource->handle,
            serial,
            time,
            id);
    }

    void wl_touch::send_up(struct ::wl_resource *resource, uint32_t serial, uint32_t time, int32_t id)
    {
        wl_touch_send_up(
            resource,
            serial,
            time,
            id);
    }


    void wl_touch::send_motion(uint32_t time, int32_t id, wl_fixed_t x, wl_fixed_t y)
    {
        Q_ASSERT_X(m_resource, "wl_touch::motion", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::motion as it's not initialised");
            return;
        }
        send_motion(
            m_resource->handle,
            time,
            id,
            x,
            y);
    }

    void wl_touch::send_motion(struct ::wl_resource *resource, uint32_t time, int32_t id, wl_fixed_t x, wl_fixed_t y)
    {
        wl_touch_send_motion(
            resource,
            time,
            id,
            x,
            y);
    }


    void wl_touch::send_frame()
    {
        Q_ASSERT_X(m_resource, "wl_touch::frame", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::frame as it's not initialised");
            return;
        }
        send_frame(
            m_resource->handle);
    }

    void wl_touch::send_frame(struct ::wl_resource *resource)
    {
        wl_touch_send_frame(
            resource);
    }


    void wl_touch::send_cancel()
    {
        Q_ASSERT_X(m_resource, "wl_touch::cancel", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::cancel as it's not initialised");
            return;
        }
        send_cancel(
            m_resource->handle);
    }

    void wl_touch::send_cancel(struct ::wl_resource *resource)
    {
        wl_touch_send_cancel(
            resource);
    }


    void wl_touch::send_shape(int32_t id, wl_fixed_t major, wl_fixed_t minor)
    {
        Q_ASSERT_X(m_resource, "wl_touch::shape", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::shape as it's not initialised");
            return;
        }
        send_shape(
            m_resource->handle,
            id,
            major,
            minor);
    }

    void wl_touch::send_shape(struct ::wl_resource *resource, int32_t id, wl_fixed_t major, wl_fixed_t minor)
    {
        wl_touch_send_shape(
            resource,
            id,
            major,
            minor);
    }


    void wl_touch::send_orientation(int32_t id, wl_fixed_t orientation)
    {
        Q_ASSERT_X(m_resource, "wl_touch::orientation", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_touch::orientation as it's not initialised");
            return;
        }
        send_orientation(
            m_resource->handle,
            id,
            orientation);
    }

    void wl_touch::send_orientation(struct ::wl_resource *resource, int32_t id, wl_fixed_t orientation)
    {
        wl_touch_send_orientation(
            resource,
            id,
            orientation);
    }


    wl_output::wl_output(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_output::wl_output(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_output::wl_output(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_output::wl_output()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_output::~wl_output()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->output_object = nullptr;

        if (m_resource)
            m_resource->output_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_output::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_output::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_output::Resource *wl_output::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_output::Resource *wl_output::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_output::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_output_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_output::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_output::interface()
    {
        return &::wl_output_interface;
    }

    wl_output::Resource *wl_output::output_allocate()
    {
        return new Resource;
    }

    void wl_output::output_bind_resource(Resource *)
    {
    }

    void wl_output::output_destroy_resource(Resource *)
    {
    }

    void wl_output::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_output *that = static_cast<wl_output *>(data);
        that->add(client, id, version);
    }

    void wl_output::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_output *that = static_cast<wl_output::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_output::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_output *that = resource->output_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->output_destroy_resource(resource);

            that = resource->output_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_output::Resource *wl_output::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_output_interface, version, id);
        return bind(handle);
    }

    wl_output::Resource *wl_output::bind(struct ::wl_resource *handle)
    {
        Resource *resource = output_allocate();
        resource->output_object = this;

        wl_resource_set_implementation(handle, &m_wl_output_interface, resource, destroy_func);
        resource->handle = handle;
        output_bind_resource(resource);
        return resource;
    }
    wl_output::Resource *wl_output::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_output_interface, &m_wl_output_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_output_interface wl_output::m_wl_output_interface = {
        wl_output::handle_release
    };

    void wl_output::output_release(Resource *)
    {
    }


    void wl_output::handle_release(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->output_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_output *>(r->output_object)->output_release(
            r);
    }

    void wl_output::send_geometry(int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const QString &make, const QString &model, int32_t transform)
    {
        Q_ASSERT_X(m_resource, "wl_output::geometry", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_output::geometry as it's not initialised");
            return;
        }
        send_geometry(
            m_resource->handle,
            x,
            y,
            physical_width,
            physical_height,
            subpixel,
            make,
            model,
            transform);
    }

    void wl_output::send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const QString &make, const QString &model, int32_t transform)
    {
        wl_output_send_geometry(
            resource,
            x,
            y,
            physical_width,
            physical_height,
            subpixel,
            make.toUtf8().constData(),
            model.toUtf8().constData(),
            transform);
    }


    void wl_output::send_mode(uint32_t flags, int32_t width, int32_t height, int32_t refresh)
    {
        Q_ASSERT_X(m_resource, "wl_output::mode", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_output::mode as it's not initialised");
            return;
        }
        send_mode(
            m_resource->handle,
            flags,
            width,
            height,
            refresh);
    }

    void wl_output::send_mode(struct ::wl_resource *resource, uint32_t flags, int32_t width, int32_t height, int32_t refresh)
    {
        wl_output_send_mode(
            resource,
            flags,
            width,
            height,
            refresh);
    }


    void wl_output::send_done()
    {
        Q_ASSERT_X(m_resource, "wl_output::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_output::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void wl_output::send_done(struct ::wl_resource *resource)
    {
        wl_output_send_done(
            resource);
    }


    void wl_output::send_scale(int32_t factor)
    {
        Q_ASSERT_X(m_resource, "wl_output::scale", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_output::scale as it's not initialised");
            return;
        }
        send_scale(
            m_resource->handle,
            factor);
    }

    void wl_output::send_scale(struct ::wl_resource *resource, int32_t factor)
    {
        wl_output_send_scale(
            resource,
            factor);
    }


    void wl_output::send_name(const QString &name)
    {
        Q_ASSERT_X(m_resource, "wl_output::name", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_output::name as it's not initialised");
            return;
        }
        send_name(
            m_resource->handle,
            name);
    }

    void wl_output::send_name(struct ::wl_resource *resource, const QString &name)
    {
        wl_output_send_name(
            resource,
            name.toUtf8().constData());
    }


    void wl_output::send_description(const QString &description)
    {
        Q_ASSERT_X(m_resource, "wl_output::description", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call wl_output::description as it's not initialised");
            return;
        }
        send_description(
            m_resource->handle,
            description);
    }

    void wl_output::send_description(struct ::wl_resource *resource, const QString &description)
    {
        wl_output_send_description(
            resource,
            description.toUtf8().constData());
    }


    wl_region::wl_region(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_region::wl_region(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_region::wl_region(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_region::wl_region()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_region::~wl_region()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->region_object = nullptr;

        if (m_resource)
            m_resource->region_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_region::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_region::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_region::Resource *wl_region::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_region::Resource *wl_region::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_region::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_region_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_region::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_region::interface()
    {
        return &::wl_region_interface;
    }

    wl_region::Resource *wl_region::region_allocate()
    {
        return new Resource;
    }

    void wl_region::region_bind_resource(Resource *)
    {
    }

    void wl_region::region_destroy_resource(Resource *)
    {
    }

    void wl_region::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_region *that = static_cast<wl_region *>(data);
        that->add(client, id, version);
    }

    void wl_region::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_region *that = static_cast<wl_region::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_region::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_region *that = resource->region_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->region_destroy_resource(resource);

            that = resource->region_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_region::Resource *wl_region::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_region_interface, version, id);
        return bind(handle);
    }

    wl_region::Resource *wl_region::bind(struct ::wl_resource *handle)
    {
        Resource *resource = region_allocate();
        resource->region_object = this;

        wl_resource_set_implementation(handle, &m_wl_region_interface, resource, destroy_func);
        resource->handle = handle;
        region_bind_resource(resource);
        return resource;
    }
    wl_region::Resource *wl_region::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_region_interface, &m_wl_region_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_region_interface wl_region::m_wl_region_interface = {
        wl_region::handle_destroy,
        wl_region::handle_add,
        wl_region::handle_subtract
    };

    void wl_region::region_destroy(Resource *)
    {
    }

    void wl_region::region_add(Resource *, int32_t , int32_t , int32_t , int32_t )
    {
    }

    void wl_region::region_subtract(Resource *, int32_t , int32_t , int32_t , int32_t )
    {
    }


    void wl_region::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->region_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_region *>(r->region_object)->region_destroy(
            r);
    }

    void wl_region::handle_add(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y,
        int32_t width,
        int32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->region_object)) {
            return;
        }
        static_cast<wl_region *>(r->region_object)->region_add(
            r,
            x,
            y,
            width,
            height);
    }

    void wl_region::handle_subtract(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y,
        int32_t width,
        int32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->region_object)) {
            return;
        }
        static_cast<wl_region *>(r->region_object)->region_subtract(
            r,
            x,
            y,
            width,
            height);
    }

    wl_subcompositor::wl_subcompositor(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_subcompositor::wl_subcompositor(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_subcompositor::wl_subcompositor(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_subcompositor::wl_subcompositor()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_subcompositor::~wl_subcompositor()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->subcompositor_object = nullptr;

        if (m_resource)
            m_resource->subcompositor_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_subcompositor::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_subcompositor::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_subcompositor::Resource *wl_subcompositor::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_subcompositor::Resource *wl_subcompositor::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_subcompositor::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_subcompositor_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_subcompositor::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_subcompositor::interface()
    {
        return &::wl_subcompositor_interface;
    }

    wl_subcompositor::Resource *wl_subcompositor::subcompositor_allocate()
    {
        return new Resource;
    }

    void wl_subcompositor::subcompositor_bind_resource(Resource *)
    {
    }

    void wl_subcompositor::subcompositor_destroy_resource(Resource *)
    {
    }

    void wl_subcompositor::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_subcompositor *that = static_cast<wl_subcompositor *>(data);
        that->add(client, id, version);
    }

    void wl_subcompositor::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_subcompositor *that = static_cast<wl_subcompositor::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_subcompositor::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_subcompositor *that = resource->subcompositor_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->subcompositor_destroy_resource(resource);

            that = resource->subcompositor_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_subcompositor::Resource *wl_subcompositor::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_subcompositor_interface, version, id);
        return bind(handle);
    }

    wl_subcompositor::Resource *wl_subcompositor::bind(struct ::wl_resource *handle)
    {
        Resource *resource = subcompositor_allocate();
        resource->subcompositor_object = this;

        wl_resource_set_implementation(handle, &m_wl_subcompositor_interface, resource, destroy_func);
        resource->handle = handle;
        subcompositor_bind_resource(resource);
        return resource;
    }
    wl_subcompositor::Resource *wl_subcompositor::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_subcompositor_interface, &m_wl_subcompositor_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_subcompositor_interface wl_subcompositor::m_wl_subcompositor_interface = {
        wl_subcompositor::handle_destroy,
        wl_subcompositor::handle_get_subsurface
    };

    void wl_subcompositor::subcompositor_destroy(Resource *)
    {
    }

    void wl_subcompositor::subcompositor_get_subsurface(Resource *, uint32_t, struct ::wl_resource *, struct ::wl_resource *)
    {
    }


    void wl_subcompositor::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subcompositor_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_subcompositor *>(r->subcompositor_object)->subcompositor_destroy(
            r);
    }

    void wl_subcompositor::handle_get_subsurface(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        struct ::wl_resource *surface,
        struct ::wl_resource *parent)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subcompositor_object)) {
            return;
        }
        static_cast<wl_subcompositor *>(r->subcompositor_object)->subcompositor_get_subsurface(
            r,
            id,
            surface,
            parent);
    }

    wl_subsurface::wl_subsurface(struct ::wl_client *client, uint32_t id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    wl_subsurface::wl_subsurface(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    wl_subsurface::wl_subsurface(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    wl_subsurface::wl_subsurface()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    wl_subsurface::~wl_subsurface()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->subsurface_object = nullptr;

        if (m_resource)
            m_resource->subsurface_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void wl_subsurface::init(struct ::wl_client *client, uint32_t id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void wl_subsurface::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    wl_subsurface::Resource *wl_subsurface::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    wl_subsurface::Resource *wl_subsurface::add(struct ::wl_client *client, uint32_t id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void wl_subsurface::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::wl_subsurface_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = wl_subsurface::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *wl_subsurface::interface()
    {
        return &::wl_subsurface_interface;
    }

    wl_subsurface::Resource *wl_subsurface::subsurface_allocate()
    {
        return new Resource;
    }

    void wl_subsurface::subsurface_bind_resource(Resource *)
    {
    }

    void wl_subsurface::subsurface_destroy_resource(Resource *)
    {
    }

    void wl_subsurface::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        wl_subsurface *that = static_cast<wl_subsurface *>(data);
        that->add(client, id, version);
    }

    void wl_subsurface::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        wl_subsurface *that = static_cast<wl_subsurface::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void wl_subsurface::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        wl_subsurface *that = resource->subsurface_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->subsurface_destroy_resource(resource);

            that = resource->subsurface_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    wl_subsurface::Resource *wl_subsurface::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::wl_subsurface_interface, version, id);
        return bind(handle);
    }

    wl_subsurface::Resource *wl_subsurface::bind(struct ::wl_resource *handle)
    {
        Resource *resource = subsurface_allocate();
        resource->subsurface_object = this;

        wl_resource_set_implementation(handle, &m_wl_subsurface_interface, resource, destroy_func);
        resource->handle = handle;
        subsurface_bind_resource(resource);
        return resource;
    }
    wl_subsurface::Resource *wl_subsurface::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::wl_subsurface_interface, &m_wl_subsurface_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::wl_subsurface_interface wl_subsurface::m_wl_subsurface_interface = {
        wl_subsurface::handle_destroy,
        wl_subsurface::handle_set_position,
        wl_subsurface::handle_place_above,
        wl_subsurface::handle_place_below,
        wl_subsurface::handle_set_sync,
        wl_subsurface::handle_set_desync
    };

    void wl_subsurface::subsurface_destroy(Resource *)
    {
    }

    void wl_subsurface::subsurface_set_position(Resource *, int32_t , int32_t )
    {
    }

    void wl_subsurface::subsurface_place_above(Resource *, struct ::wl_resource *)
    {
    }

    void wl_subsurface::subsurface_place_below(Resource *, struct ::wl_resource *)
    {
    }

    void wl_subsurface::subsurface_set_sync(Resource *)
    {
    }

    void wl_subsurface::subsurface_set_desync(Resource *)
    {
    }


    void wl_subsurface::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subsurface_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<wl_subsurface *>(r->subsurface_object)->subsurface_destroy(
            r);
    }

    void wl_subsurface::handle_set_position(
        ::wl_client *client,
        struct wl_resource *resource,
        int32_t x,
        int32_t y)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subsurface_object)) {
            return;
        }
        static_cast<wl_subsurface *>(r->subsurface_object)->subsurface_set_position(
            r,
            x,
            y);
    }

    void wl_subsurface::handle_place_above(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *sibling)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subsurface_object)) {
            return;
        }
        static_cast<wl_subsurface *>(r->subsurface_object)->subsurface_place_above(
            r,
            sibling);
    }

    void wl_subsurface::handle_place_below(
        ::wl_client *client,
        struct wl_resource *resource,
        struct ::wl_resource *sibling)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subsurface_object)) {
            return;
        }
        static_cast<wl_subsurface *>(r->subsurface_object)->subsurface_place_below(
            r,
            sibling);
    }

    void wl_subsurface::handle_set_sync(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subsurface_object)) {
            return;
        }
        static_cast<wl_subsurface *>(r->subsurface_object)->subsurface_set_sync(
            r);
    }

    void wl_subsurface::handle_set_desync(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->subsurface_object)) {
            return;
        }
        static_cast<wl_subsurface *>(r->subsurface_object)->subsurface_set_desync(
            r);
    }
}

QT_WARNING_POP
QT_END_NAMESPACE
