














	.file "sha512-compress.asm"
	.fpu	neon




































































































	
	

	.text
	.align 2

.globl _nettle_sha512_compress_neon
.type _nettle_sha512_compress_neon,%function
_nettle_sha512_compress_neon: 
	vpush	{d8,d9,d10,d11,d12,d13}
	
	ands	r12, r1, #7
	and	r1, r1, #-8
	vld1.8	{d13}, [r1 :64]
	addne	r1, r1, #8
	addeq	r12, r12, #8
	lsl	r12, r12, #3

	
	neg	r12, r12
	vmov.i32	d8, #0
	vmov.32		d8[0], r12
	vmov		d9, d8
	
	add		r12, r12, #64
	vmov.i32	d10, #0
	vmov.32		d10[0], r12
	vmov		d11, d10
	vshl.u64	d13, d13, d8

	
	vld1.8		{d16,d17,d18,d19}, [r1 :64]!
	vshl.u64	q0, q8, q4	
	vshl.u64	q8, q8, q5	
	veor		d16, d16, d13
	veor		d17, d17, d0
	vrev64.8	q8, q8
	vshl.u64	q6, q9, q4	
	vshl.u64	q9, q9, q5	
	veor		d18, d18, d1
	veor		d19, d19, d12
	vrev64.8	q9, q9

	vld1.8		{d20,d21,d22,d23}, [r1 :64]!
	vshl.u64	q0, q10, q4	
	vshl.u64	q10, q10, q5	
	veor		d20, d20, d13
	veor		d21, d21, d0
	vrev64.8	q10, q10
	vshl.u64	q6, q11, q4	
	vshl.u64	q11, q11, q5	
	veor		d22, d22, d1
	veor		d23, d23, d12
	vrev64.8	q11, q11

	vld1.8		{d24,d25,d26,d27}, [r1 :64]!
	vshl.u64	q0, q12, q4	
	vshl.u64	q12, q12, q5	
	veor		d24, d24, d13
	veor		d25, d25, d0
	vrev64.8	q12, q12
	vshl.u64	q6, q13, q4	
	vshl.u64	q13, q13, q5	
	veor		d26, d26, d1
	veor		d27, d27, d12
	vrev64.8	q13, q13

	vld1.8		{d28,d29,d30,d31}, [r1 :64]!
	vshl.u64	q0, q14, q4	
	vshl.u64	q14, q14, q5	
	veor		d28, d28, d13
	veor		d29, d29, d0
	vrev64.8	q14, q14
	vshl.u64	q6, q15, q4	
	vshl.u64	q15, q15, q5	
	veor		d30, d30, d1
	veor		d31, d31, d12
	vrev64.8	q15, q15

	vldm	r0, {d0,d1,d2,d3,d4,d5,d6,d7}

	
	vshl.i64	d8, d4, #50
	vshl.i64	d9, d0, #36
	vshr.u64	d10, d4, #14
	vshr.u64	d11, d0, #28
	vshl.i64	d12, d4, #46
	vshl.i64	d13, d0, #30
	veor		q4, q4, q5
	vshr.u64	d10, d4, #18
	vshr.u64	d11, d0, #34
	veor		q4, q4, q6
	vshl.i64	d12, d4, #23
	vshl.i64	d13, d0, #25
	veor		q4, q4, q5
	vshr.u64	d10, d4, #41
	vshr.u64	d11, d0, #39
	veor		q4, q4, q6
	veor		d12, d5, d6
	veor		d13, d0, d1
	vand		d12, d12, d4
	vand		d13, d13, d2
	veor		d12, d12, d6
	veor		q4, q4, q5
	vand		d10, d0, d1
	vldr		d11, [r2,#0]
	vadd.i64	d7, d7, d16
	vadd.i64	q4, q4, q6
	vadd.i64	d7, d7, d11
	vadd.i64	d7, d7, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d3, d3, d7
	vadd.i64	d7, d7, d9

	
	vshl.i64	d8, d3, #50
	vshl.i64	d9, d7, #36
	vshr.u64	d10, d3, #14
	vshr.u64	d11, d7, #28
	vshl.i64	d12, d3, #46
	vshl.i64	d13, d7, #30
	veor		q4, q4, q5
	vshr.u64	d10, d3, #18
	vshr.u64	d11, d7, #34
	veor		q4, q4, q6
	vshl.i64	d12, d3, #23
	vshl.i64	d13, d7, #25
	veor		q4, q4, q5
	vshr.u64	d10, d3, #41
	vshr.u64	d11, d7, #39
	veor		q4, q4, q6
	veor		d12, d4, d5
	veor		d13, d7, d0
	vand		d12, d12, d3
	vand		d13, d13, d1
	veor		d12, d12, d5
	veor		q4, q4, q5
	vand		d10, d7, d0
	vldr		d11, [r2,#8]
	vadd.i64	d6, d6, d17
	vadd.i64	q4, q4, q6
	vadd.i64	d6, d6, d11
	vadd.i64	d6, d6, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d2, d2, d6
	vadd.i64	d6, d6, d9

	
	vshl.i64	d8, d2, #50
	vshl.i64	d9, d6, #36
	vshr.u64	d10, d2, #14
	vshr.u64	d11, d6, #28
	vshl.i64	d12, d2, #46
	vshl.i64	d13, d6, #30
	veor		q4, q4, q5
	vshr.u64	d10, d2, #18
	vshr.u64	d11, d6, #34
	veor		q4, q4, q6
	vshl.i64	d12, d2, #23
	vshl.i64	d13, d6, #25
	veor		q4, q4, q5
	vshr.u64	d10, d2, #41
	vshr.u64	d11, d6, #39
	veor		q4, q4, q6
	veor		d12, d3, d4
	veor		d13, d6, d7
	vand		d12, d12, d2
	vand		d13, d13, d0
	veor		d12, d12, d4
	veor		q4, q4, q5
	vand		d10, d6, d7
	vldr		d11, [r2,#16]
	vadd.i64	d5, d5, d18
	vadd.i64	q4, q4, q6
	vadd.i64	d5, d5, d11
	vadd.i64	d5, d5, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d1, d1, d5
	vadd.i64	d5, d5, d9

	
	vshl.i64	d8, d1, #50
	vshl.i64	d9, d5, #36
	vshr.u64	d10, d1, #14
	vshr.u64	d11, d5, #28
	vshl.i64	d12, d1, #46
	vshl.i64	d13, d5, #30
	veor		q4, q4, q5
	vshr.u64	d10, d1, #18
	vshr.u64	d11, d5, #34
	veor		q4, q4, q6
	vshl.i64	d12, d1, #23
	vshl.i64	d13, d5, #25
	veor		q4, q4, q5
	vshr.u64	d10, d1, #41
	vshr.u64	d11, d5, #39
	veor		q4, q4, q6
	veor		d12, d2, d3
	veor		d13, d5, d6
	vand		d12, d12, d1
	vand		d13, d13, d7
	veor		d12, d12, d3
	veor		q4, q4, q5
	vand		d10, d5, d6
	vldr		d11, [r2,#24]
	vadd.i64	d4, d4, d19
	vadd.i64	q4, q4, q6
	vadd.i64	d4, d4, d11
	vadd.i64	d4, d4, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d0, d0, d4
	vadd.i64	d4, d4, d9

	
	vshl.i64	d8, d0, #50
	vshl.i64	d9, d4, #36
	vshr.u64	d10, d0, #14
	vshr.u64	d11, d4, #28
	vshl.i64	d12, d0, #46
	vshl.i64	d13, d4, #30
	veor		q4, q4, q5
	vshr.u64	d10, d0, #18
	vshr.u64	d11, d4, #34
	veor		q4, q4, q6
	vshl.i64	d12, d0, #23
	vshl.i64	d13, d4, #25
	veor		q4, q4, q5
	vshr.u64	d10, d0, #41
	vshr.u64	d11, d4, #39
	veor		q4, q4, q6
	veor		d12, d1, d2
	veor		d13, d4, d5
	vand		d12, d12, d0
	vand		d13, d13, d6
	veor		d12, d12, d2
	veor		q4, q4, q5
	vand		d10, d4, d5
	vldr		d11, [r2,#32]
	vadd.i64	d3, d3, d20
	vadd.i64	q4, q4, q6
	vadd.i64	d3, d3, d11
	vadd.i64	d3, d3, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d7, d7, d3
	vadd.i64	d3, d3, d9

	
	vshl.i64	d8, d7, #50
	vshl.i64	d9, d3, #36
	vshr.u64	d10, d7, #14
	vshr.u64	d11, d3, #28
	vshl.i64	d12, d7, #46
	vshl.i64	d13, d3, #30
	veor		q4, q4, q5
	vshr.u64	d10, d7, #18
	vshr.u64	d11, d3, #34
	veor		q4, q4, q6
	vshl.i64	d12, d7, #23
	vshl.i64	d13, d3, #25
	veor		q4, q4, q5
	vshr.u64	d10, d7, #41
	vshr.u64	d11, d3, #39
	veor		q4, q4, q6
	veor		d12, d0, d1
	veor		d13, d3, d4
	vand		d12, d12, d7
	vand		d13, d13, d5
	veor		d12, d12, d1
	veor		q4, q4, q5
	vand		d10, d3, d4
	vldr		d11, [r2,#40]
	vadd.i64	d2, d2, d21
	vadd.i64	q4, q4, q6
	vadd.i64	d2, d2, d11
	vadd.i64	d2, d2, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d6, d6, d2
	vadd.i64	d2, d2, d9

	
	vshl.i64	d8, d6, #50
	vshl.i64	d9, d2, #36
	vshr.u64	d10, d6, #14
	vshr.u64	d11, d2, #28
	vshl.i64	d12, d6, #46
	vshl.i64	d13, d2, #30
	veor		q4, q4, q5
	vshr.u64	d10, d6, #18
	vshr.u64	d11, d2, #34
	veor		q4, q4, q6
	vshl.i64	d12, d6, #23
	vshl.i64	d13, d2, #25
	veor		q4, q4, q5
	vshr.u64	d10, d6, #41
	vshr.u64	d11, d2, #39
	veor		q4, q4, q6
	veor		d12, d7, d0
	veor		d13, d2, d3
	vand		d12, d12, d6
	vand		d13, d13, d4
	veor		d12, d12, d0
	veor		q4, q4, q5
	vand		d10, d2, d3
	vldr		d11, [r2,#48]
	vadd.i64	d1, d1, d22
	vadd.i64	q4, q4, q6
	vadd.i64	d1, d1, d11
	vadd.i64	d1, d1, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d5, d5, d1
	vadd.i64	d1, d1, d9

	
	vshl.i64	d8, d5, #50
	vshl.i64	d9, d1, #36
	vshr.u64	d10, d5, #14
	vshr.u64	d11, d1, #28
	vshl.i64	d12, d5, #46
	vshl.i64	d13, d1, #30
	veor		q4, q4, q5
	vshr.u64	d10, d5, #18
	vshr.u64	d11, d1, #34
	veor		q4, q4, q6
	vshl.i64	d12, d5, #23
	vshl.i64	d13, d1, #25
	veor		q4, q4, q5
	vshr.u64	d10, d5, #41
	vshr.u64	d11, d1, #39
	veor		q4, q4, q6
	veor		d12, d6, d7
	veor		d13, d1, d2
	vand		d12, d12, d5
	vand		d13, d13, d3
	veor		d12, d12, d7
	veor		q4, q4, q5
	vand		d10, d1, d2
	vldr		d11, [r2,#56]
	vadd.i64	d0, d0, d23
	vadd.i64	q4, q4, q6
	vadd.i64	d0, d0, d11
	vadd.i64	d0, d0, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d4, d4, d0
	vadd.i64	d0, d0, d9


	
	vshl.i64	d8, d4, #50
	vshl.i64	d9, d0, #36
	vshr.u64	d10, d4, #14
	vshr.u64	d11, d0, #28
	vshl.i64	d12, d4, #46
	vshl.i64	d13, d0, #30
	veor		q4, q4, q5
	vshr.u64	d10, d4, #18
	vshr.u64	d11, d0, #34
	veor		q4, q4, q6
	vshl.i64	d12, d4, #23
	vshl.i64	d13, d0, #25
	veor		q4, q4, q5
	vshr.u64	d10, d4, #41
	vshr.u64	d11, d0, #39
	veor		q4, q4, q6
	veor		d12, d5, d6
	veor		d13, d0, d1
	vand		d12, d12, d4
	vand		d13, d13, d2
	veor		d12, d12, d6
	veor		q4, q4, q5
	vand		d10, d0, d1
	vldr		d11, [r2,#64]
	vadd.i64	d7, d7, d24
	vadd.i64	q4, q4, q6
	vadd.i64	d7, d7, d11
	vadd.i64	d7, d7, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d3, d3, d7
	vadd.i64	d7, d7, d9

	
	vshl.i64	d8, d3, #50
	vshl.i64	d9, d7, #36
	vshr.u64	d10, d3, #14
	vshr.u64	d11, d7, #28
	vshl.i64	d12, d3, #46
	vshl.i64	d13, d7, #30
	veor		q4, q4, q5
	vshr.u64	d10, d3, #18
	vshr.u64	d11, d7, #34
	veor		q4, q4, q6
	vshl.i64	d12, d3, #23
	vshl.i64	d13, d7, #25
	veor		q4, q4, q5
	vshr.u64	d10, d3, #41
	vshr.u64	d11, d7, #39
	veor		q4, q4, q6
	veor		d12, d4, d5
	veor		d13, d7, d0
	vand		d12, d12, d3
	vand		d13, d13, d1
	veor		d12, d12, d5
	veor		q4, q4, q5
	vand		d10, d7, d0
	vldr		d11, [r2,#72]
	vadd.i64	d6, d6, d25
	vadd.i64	q4, q4, q6
	vadd.i64	d6, d6, d11
	vadd.i64	d6, d6, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d2, d2, d6
	vadd.i64	d6, d6, d9

	
	vshl.i64	d8, d2, #50
	vshl.i64	d9, d6, #36
	vshr.u64	d10, d2, #14
	vshr.u64	d11, d6, #28
	vshl.i64	d12, d2, #46
	vshl.i64	d13, d6, #30
	veor		q4, q4, q5
	vshr.u64	d10, d2, #18
	vshr.u64	d11, d6, #34
	veor		q4, q4, q6
	vshl.i64	d12, d2, #23
	vshl.i64	d13, d6, #25
	veor		q4, q4, q5
	vshr.u64	d10, d2, #41
	vshr.u64	d11, d6, #39
	veor		q4, q4, q6
	veor		d12, d3, d4
	veor		d13, d6, d7
	vand		d12, d12, d2
	vand		d13, d13, d0
	veor		d12, d12, d4
	veor		q4, q4, q5
	vand		d10, d6, d7
	vldr		d11, [r2,#80]
	vadd.i64	d5, d5, d26
	vadd.i64	q4, q4, q6
	vadd.i64	d5, d5, d11
	vadd.i64	d5, d5, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d1, d1, d5
	vadd.i64	d5, d5, d9

	
	vshl.i64	d8, d1, #50
	vshl.i64	d9, d5, #36
	vshr.u64	d10, d1, #14
	vshr.u64	d11, d5, #28
	vshl.i64	d12, d1, #46
	vshl.i64	d13, d5, #30
	veor		q4, q4, q5
	vshr.u64	d10, d1, #18
	vshr.u64	d11, d5, #34
	veor		q4, q4, q6
	vshl.i64	d12, d1, #23
	vshl.i64	d13, d5, #25
	veor		q4, q4, q5
	vshr.u64	d10, d1, #41
	vshr.u64	d11, d5, #39
	veor		q4, q4, q6
	veor		d12, d2, d3
	veor		d13, d5, d6
	vand		d12, d12, d1
	vand		d13, d13, d7
	veor		d12, d12, d3
	veor		q4, q4, q5
	vand		d10, d5, d6
	vldr		d11, [r2,#88]
	vadd.i64	d4, d4, d27
	vadd.i64	q4, q4, q6
	vadd.i64	d4, d4, d11
	vadd.i64	d4, d4, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d0, d0, d4
	vadd.i64	d4, d4, d9

	
	vshl.i64	d8, d0, #50
	vshl.i64	d9, d4, #36
	vshr.u64	d10, d0, #14
	vshr.u64	d11, d4, #28
	vshl.i64	d12, d0, #46
	vshl.i64	d13, d4, #30
	veor		q4, q4, q5
	vshr.u64	d10, d0, #18
	vshr.u64	d11, d4, #34
	veor		q4, q4, q6
	vshl.i64	d12, d0, #23
	vshl.i64	d13, d4, #25
	veor		q4, q4, q5
	vshr.u64	d10, d0, #41
	vshr.u64	d11, d4, #39
	veor		q4, q4, q6
	veor		d12, d1, d2
	veor		d13, d4, d5
	vand		d12, d12, d0
	vand		d13, d13, d6
	veor		d12, d12, d2
	veor		q4, q4, q5
	vand		d10, d4, d5
	vldr		d11, [r2,#96]
	vadd.i64	d3, d3, d28
	vadd.i64	q4, q4, q6
	vadd.i64	d3, d3, d11
	vadd.i64	d3, d3, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d7, d7, d3
	vadd.i64	d3, d3, d9

	
	vshl.i64	d8, d7, #50
	vshl.i64	d9, d3, #36
	vshr.u64	d10, d7, #14
	vshr.u64	d11, d3, #28
	vshl.i64	d12, d7, #46
	vshl.i64	d13, d3, #30
	veor		q4, q4, q5
	vshr.u64	d10, d7, #18
	vshr.u64	d11, d3, #34
	veor		q4, q4, q6
	vshl.i64	d12, d7, #23
	vshl.i64	d13, d3, #25
	veor		q4, q4, q5
	vshr.u64	d10, d7, #41
	vshr.u64	d11, d3, #39
	veor		q4, q4, q6
	veor		d12, d0, d1
	veor		d13, d3, d4
	vand		d12, d12, d7
	vand		d13, d13, d5
	veor		d12, d12, d1
	veor		q4, q4, q5
	vand		d10, d3, d4
	vldr		d11, [r2,#104]
	vadd.i64	d2, d2, d29
	vadd.i64	q4, q4, q6
	vadd.i64	d2, d2, d11
	vadd.i64	d2, d2, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d6, d6, d2
	vadd.i64	d2, d2, d9

	
	vshl.i64	d8, d6, #50
	vshl.i64	d9, d2, #36
	vshr.u64	d10, d6, #14
	vshr.u64	d11, d2, #28
	vshl.i64	d12, d6, #46
	vshl.i64	d13, d2, #30
	veor		q4, q4, q5
	vshr.u64	d10, d6, #18
	vshr.u64	d11, d2, #34
	veor		q4, q4, q6
	vshl.i64	d12, d6, #23
	vshl.i64	d13, d2, #25
	veor		q4, q4, q5
	vshr.u64	d10, d6, #41
	vshr.u64	d11, d2, #39
	veor		q4, q4, q6
	veor		d12, d7, d0
	veor		d13, d2, d3
	vand		d12, d12, d6
	vand		d13, d13, d4
	veor		d12, d12, d0
	veor		q4, q4, q5
	vand		d10, d2, d3
	vldr		d11, [r2,#112]
	vadd.i64	d1, d1, d30
	vadd.i64	q4, q4, q6
	vadd.i64	d1, d1, d11
	vadd.i64	d1, d1, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d5, d5, d1
	vadd.i64	d1, d1, d9

	
	vshl.i64	d8, d5, #50
	vshl.i64	d9, d1, #36
	vshr.u64	d10, d5, #14
	vshr.u64	d11, d1, #28
	vshl.i64	d12, d5, #46
	vshl.i64	d13, d1, #30
	veor		q4, q4, q5
	vshr.u64	d10, d5, #18
	vshr.u64	d11, d1, #34
	veor		q4, q4, q6
	vshl.i64	d12, d5, #23
	vshl.i64	d13, d1, #25
	veor		q4, q4, q5
	vshr.u64	d10, d5, #41
	vshr.u64	d11, d1, #39
	veor		q4, q4, q6
	veor		d12, d6, d7
	veor		d13, d1, d2
	vand		d12, d12, d5
	vand		d13, d13, d3
	veor		d12, d12, d7
	veor		q4, q4, q5
	vand		d10, d1, d2
	vldr		d11, [r2,#120]
	vadd.i64	d0, d0, d31
	vadd.i64	q4, q4, q6
	vadd.i64	d0, d0, d11
	vadd.i64	d0, d0, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d4, d4, d0
	vadd.i64	d0, d0, d9


	add	r2, r2, #128

	mov	r3, #4
.Loop:

	
	vshl.i64	d8, d30, #45
	vshl.i64	d9, d17, #63
	vshr.u64	d10, d30, #19
	vshr.u64	d11, d17, #1
	vshl.i64	d12, d30, #3
	vshl.i64	d13, d17, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d30, #61
	vshr.u64	d11, d17, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d30, #6
	vshr.u64	d13, d17, #7
	veor.i64	q4, q4, q5
	vadd.i64	d16, d16, d25
	veor.i64	q4, q4, q6
	vadd.i64	d16, d16, d8
	vadd.i64	d16, d16, d9
 
	vshl.i64	d8, d4, #50
	vshl.i64	d9, d0, #36
	vshr.u64	d10, d4, #14
	vshr.u64	d11, d0, #28
	vshl.i64	d12, d4, #46
	vshl.i64	d13, d0, #30
	veor		q4, q4, q5
	vshr.u64	d10, d4, #18
	vshr.u64	d11, d0, #34
	veor		q4, q4, q6
	vshl.i64	d12, d4, #23
	vshl.i64	d13, d0, #25
	veor		q4, q4, q5
	vshr.u64	d10, d4, #41
	vshr.u64	d11, d0, #39
	veor		q4, q4, q6
	veor		d12, d5, d6
	veor		d13, d0, d1
	vand		d12, d12, d4
	vand		d13, d13, d2
	veor		d12, d12, d6
	veor		q4, q4, q5
	vand		d10, d0, d1
	vldr		d11, [r2,#0]
	vadd.i64	d7, d7, d16
	vadd.i64	q4, q4, q6
	vadd.i64	d7, d7, d11
	vadd.i64	d7, d7, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d3, d3, d7
	vadd.i64	d7, d7, d9

	
	vshl.i64	d8, d31, #45
	vshl.i64	d9, d18, #63
	vshr.u64	d10, d31, #19
	vshr.u64	d11, d18, #1
	vshl.i64	d12, d31, #3
	vshl.i64	d13, d18, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d31, #61
	vshr.u64	d11, d18, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d31, #6
	vshr.u64	d13, d18, #7
	veor.i64	q4, q4, q5
	vadd.i64	d17, d17, d26
	veor.i64	q4, q4, q6
	vadd.i64	d17, d17, d8
	vadd.i64	d17, d17, d9
 
	vshl.i64	d8, d3, #50
	vshl.i64	d9, d7, #36
	vshr.u64	d10, d3, #14
	vshr.u64	d11, d7, #28
	vshl.i64	d12, d3, #46
	vshl.i64	d13, d7, #30
	veor		q4, q4, q5
	vshr.u64	d10, d3, #18
	vshr.u64	d11, d7, #34
	veor		q4, q4, q6
	vshl.i64	d12, d3, #23
	vshl.i64	d13, d7, #25
	veor		q4, q4, q5
	vshr.u64	d10, d3, #41
	vshr.u64	d11, d7, #39
	veor		q4, q4, q6
	veor		d12, d4, d5
	veor		d13, d7, d0
	vand		d12, d12, d3
	vand		d13, d13, d1
	veor		d12, d12, d5
	veor		q4, q4, q5
	vand		d10, d7, d0
	vldr		d11, [r2,#8]
	vadd.i64	d6, d6, d17
	vadd.i64	q4, q4, q6
	vadd.i64	d6, d6, d11
	vadd.i64	d6, d6, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d2, d2, d6
	vadd.i64	d6, d6, d9

	
	vshl.i64	d8, d16, #45
	vshl.i64	d9, d19, #63
	vshr.u64	d10, d16, #19
	vshr.u64	d11, d19, #1
	vshl.i64	d12, d16, #3
	vshl.i64	d13, d19, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d16, #61
	vshr.u64	d11, d19, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d16, #6
	vshr.u64	d13, d19, #7
	veor.i64	q4, q4, q5
	vadd.i64	d18, d18, d27
	veor.i64	q4, q4, q6
	vadd.i64	d18, d18, d8
	vadd.i64	d18, d18, d9
 
	vshl.i64	d8, d2, #50
	vshl.i64	d9, d6, #36
	vshr.u64	d10, d2, #14
	vshr.u64	d11, d6, #28
	vshl.i64	d12, d2, #46
	vshl.i64	d13, d6, #30
	veor		q4, q4, q5
	vshr.u64	d10, d2, #18
	vshr.u64	d11, d6, #34
	veor		q4, q4, q6
	vshl.i64	d12, d2, #23
	vshl.i64	d13, d6, #25
	veor		q4, q4, q5
	vshr.u64	d10, d2, #41
	vshr.u64	d11, d6, #39
	veor		q4, q4, q6
	veor		d12, d3, d4
	veor		d13, d6, d7
	vand		d12, d12, d2
	vand		d13, d13, d0
	veor		d12, d12, d4
	veor		q4, q4, q5
	vand		d10, d6, d7
	vldr		d11, [r2,#16]
	vadd.i64	d5, d5, d18
	vadd.i64	q4, q4, q6
	vadd.i64	d5, d5, d11
	vadd.i64	d5, d5, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d1, d1, d5
	vadd.i64	d5, d5, d9

	
	vshl.i64	d8, d17, #45
	vshl.i64	d9, d20, #63
	vshr.u64	d10, d17, #19
	vshr.u64	d11, d20, #1
	vshl.i64	d12, d17, #3
	vshl.i64	d13, d20, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d17, #61
	vshr.u64	d11, d20, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d17, #6
	vshr.u64	d13, d20, #7
	veor.i64	q4, q4, q5
	vadd.i64	d19, d19, d28
	veor.i64	q4, q4, q6
	vadd.i64	d19, d19, d8
	vadd.i64	d19, d19, d9
 
	vshl.i64	d8, d1, #50
	vshl.i64	d9, d5, #36
	vshr.u64	d10, d1, #14
	vshr.u64	d11, d5, #28
	vshl.i64	d12, d1, #46
	vshl.i64	d13, d5, #30
	veor		q4, q4, q5
	vshr.u64	d10, d1, #18
	vshr.u64	d11, d5, #34
	veor		q4, q4, q6
	vshl.i64	d12, d1, #23
	vshl.i64	d13, d5, #25
	veor		q4, q4, q5
	vshr.u64	d10, d1, #41
	vshr.u64	d11, d5, #39
	veor		q4, q4, q6
	veor		d12, d2, d3
	veor		d13, d5, d6
	vand		d12, d12, d1
	vand		d13, d13, d7
	veor		d12, d12, d3
	veor		q4, q4, q5
	vand		d10, d5, d6
	vldr		d11, [r2,#24]
	vadd.i64	d4, d4, d19
	vadd.i64	q4, q4, q6
	vadd.i64	d4, d4, d11
	vadd.i64	d4, d4, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d0, d0, d4
	vadd.i64	d4, d4, d9

	
	vshl.i64	d8, d18, #45
	vshl.i64	d9, d21, #63
	vshr.u64	d10, d18, #19
	vshr.u64	d11, d21, #1
	vshl.i64	d12, d18, #3
	vshl.i64	d13, d21, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d18, #61
	vshr.u64	d11, d21, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d18, #6
	vshr.u64	d13, d21, #7
	veor.i64	q4, q4, q5
	vadd.i64	d20, d20, d29
	veor.i64	q4, q4, q6
	vadd.i64	d20, d20, d8
	vadd.i64	d20, d20, d9
 
	vshl.i64	d8, d0, #50
	vshl.i64	d9, d4, #36
	vshr.u64	d10, d0, #14
	vshr.u64	d11, d4, #28
	vshl.i64	d12, d0, #46
	vshl.i64	d13, d4, #30
	veor		q4, q4, q5
	vshr.u64	d10, d0, #18
	vshr.u64	d11, d4, #34
	veor		q4, q4, q6
	vshl.i64	d12, d0, #23
	vshl.i64	d13, d4, #25
	veor		q4, q4, q5
	vshr.u64	d10, d0, #41
	vshr.u64	d11, d4, #39
	veor		q4, q4, q6
	veor		d12, d1, d2
	veor		d13, d4, d5
	vand		d12, d12, d0
	vand		d13, d13, d6
	veor		d12, d12, d2
	veor		q4, q4, q5
	vand		d10, d4, d5
	vldr		d11, [r2,#32]
	vadd.i64	d3, d3, d20
	vadd.i64	q4, q4, q6
	vadd.i64	d3, d3, d11
	vadd.i64	d3, d3, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d7, d7, d3
	vadd.i64	d3, d3, d9

	
	vshl.i64	d8, d19, #45
	vshl.i64	d9, d22, #63
	vshr.u64	d10, d19, #19
	vshr.u64	d11, d22, #1
	vshl.i64	d12, d19, #3
	vshl.i64	d13, d22, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d19, #61
	vshr.u64	d11, d22, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d19, #6
	vshr.u64	d13, d22, #7
	veor.i64	q4, q4, q5
	vadd.i64	d21, d21, d30
	veor.i64	q4, q4, q6
	vadd.i64	d21, d21, d8
	vadd.i64	d21, d21, d9
 
	vshl.i64	d8, d7, #50
	vshl.i64	d9, d3, #36
	vshr.u64	d10, d7, #14
	vshr.u64	d11, d3, #28
	vshl.i64	d12, d7, #46
	vshl.i64	d13, d3, #30
	veor		q4, q4, q5
	vshr.u64	d10, d7, #18
	vshr.u64	d11, d3, #34
	veor		q4, q4, q6
	vshl.i64	d12, d7, #23
	vshl.i64	d13, d3, #25
	veor		q4, q4, q5
	vshr.u64	d10, d7, #41
	vshr.u64	d11, d3, #39
	veor		q4, q4, q6
	veor		d12, d0, d1
	veor		d13, d3, d4
	vand		d12, d12, d7
	vand		d13, d13, d5
	veor		d12, d12, d1
	veor		q4, q4, q5
	vand		d10, d3, d4
	vldr		d11, [r2,#40]
	vadd.i64	d2, d2, d21
	vadd.i64	q4, q4, q6
	vadd.i64	d2, d2, d11
	vadd.i64	d2, d2, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d6, d6, d2
	vadd.i64	d2, d2, d9

	
	vshl.i64	d8, d20, #45
	vshl.i64	d9, d23, #63
	vshr.u64	d10, d20, #19
	vshr.u64	d11, d23, #1
	vshl.i64	d12, d20, #3
	vshl.i64	d13, d23, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d20, #61
	vshr.u64	d11, d23, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d20, #6
	vshr.u64	d13, d23, #7
	veor.i64	q4, q4, q5
	vadd.i64	d22, d22, d31
	veor.i64	q4, q4, q6
	vadd.i64	d22, d22, d8
	vadd.i64	d22, d22, d9
 
	vshl.i64	d8, d6, #50
	vshl.i64	d9, d2, #36
	vshr.u64	d10, d6, #14
	vshr.u64	d11, d2, #28
	vshl.i64	d12, d6, #46
	vshl.i64	d13, d2, #30
	veor		q4, q4, q5
	vshr.u64	d10, d6, #18
	vshr.u64	d11, d2, #34
	veor		q4, q4, q6
	vshl.i64	d12, d6, #23
	vshl.i64	d13, d2, #25
	veor		q4, q4, q5
	vshr.u64	d10, d6, #41
	vshr.u64	d11, d2, #39
	veor		q4, q4, q6
	veor		d12, d7, d0
	veor		d13, d2, d3
	vand		d12, d12, d6
	vand		d13, d13, d4
	veor		d12, d12, d0
	veor		q4, q4, q5
	vand		d10, d2, d3
	vldr		d11, [r2,#48]
	vadd.i64	d1, d1, d22
	vadd.i64	q4, q4, q6
	vadd.i64	d1, d1, d11
	vadd.i64	d1, d1, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d5, d5, d1
	vadd.i64	d1, d1, d9

	
	vshl.i64	d8, d21, #45
	vshl.i64	d9, d24, #63
	vshr.u64	d10, d21, #19
	vshr.u64	d11, d24, #1
	vshl.i64	d12, d21, #3
	vshl.i64	d13, d24, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d21, #61
	vshr.u64	d11, d24, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d21, #6
	vshr.u64	d13, d24, #7
	veor.i64	q4, q4, q5
	vadd.i64	d23, d23, d16
	veor.i64	q4, q4, q6
	vadd.i64	d23, d23, d8
	vadd.i64	d23, d23, d9
 
	vshl.i64	d8, d5, #50
	vshl.i64	d9, d1, #36
	vshr.u64	d10, d5, #14
	vshr.u64	d11, d1, #28
	vshl.i64	d12, d5, #46
	vshl.i64	d13, d1, #30
	veor		q4, q4, q5
	vshr.u64	d10, d5, #18
	vshr.u64	d11, d1, #34
	veor		q4, q4, q6
	vshl.i64	d12, d5, #23
	vshl.i64	d13, d1, #25
	veor		q4, q4, q5
	vshr.u64	d10, d5, #41
	vshr.u64	d11, d1, #39
	veor		q4, q4, q6
	veor		d12, d6, d7
	veor		d13, d1, d2
	vand		d12, d12, d5
	vand		d13, d13, d3
	veor		d12, d12, d7
	veor		q4, q4, q5
	vand		d10, d1, d2
	vldr		d11, [r2,#56]
	vadd.i64	d0, d0, d23
	vadd.i64	q4, q4, q6
	vadd.i64	d0, d0, d11
	vadd.i64	d0, d0, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d4, d4, d0
	vadd.i64	d0, d0, d9

	
	vshl.i64	d8, d22, #45
	vshl.i64	d9, d25, #63
	vshr.u64	d10, d22, #19
	vshr.u64	d11, d25, #1
	vshl.i64	d12, d22, #3
	vshl.i64	d13, d25, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d22, #61
	vshr.u64	d11, d25, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d22, #6
	vshr.u64	d13, d25, #7
	veor.i64	q4, q4, q5
	vadd.i64	d24, d24, d17
	veor.i64	q4, q4, q6
	vadd.i64	d24, d24, d8
	vadd.i64	d24, d24, d9
 
	vshl.i64	d8, d4, #50
	vshl.i64	d9, d0, #36
	vshr.u64	d10, d4, #14
	vshr.u64	d11, d0, #28
	vshl.i64	d12, d4, #46
	vshl.i64	d13, d0, #30
	veor		q4, q4, q5
	vshr.u64	d10, d4, #18
	vshr.u64	d11, d0, #34
	veor		q4, q4, q6
	vshl.i64	d12, d4, #23
	vshl.i64	d13, d0, #25
	veor		q4, q4, q5
	vshr.u64	d10, d4, #41
	vshr.u64	d11, d0, #39
	veor		q4, q4, q6
	veor		d12, d5, d6
	veor		d13, d0, d1
	vand		d12, d12, d4
	vand		d13, d13, d2
	veor		d12, d12, d6
	veor		q4, q4, q5
	vand		d10, d0, d1
	vldr		d11, [r2,#64]
	vadd.i64	d7, d7, d24
	vadd.i64	q4, q4, q6
	vadd.i64	d7, d7, d11
	vadd.i64	d7, d7, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d3, d3, d7
	vadd.i64	d7, d7, d9

	
	vshl.i64	d8, d23, #45
	vshl.i64	d9, d26, #63
	vshr.u64	d10, d23, #19
	vshr.u64	d11, d26, #1
	vshl.i64	d12, d23, #3
	vshl.i64	d13, d26, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d23, #61
	vshr.u64	d11, d26, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d23, #6
	vshr.u64	d13, d26, #7
	veor.i64	q4, q4, q5
	vadd.i64	d25, d25, d18
	veor.i64	q4, q4, q6
	vadd.i64	d25, d25, d8
	vadd.i64	d25, d25, d9
 
	vshl.i64	d8, d3, #50
	vshl.i64	d9, d7, #36
	vshr.u64	d10, d3, #14
	vshr.u64	d11, d7, #28
	vshl.i64	d12, d3, #46
	vshl.i64	d13, d7, #30
	veor		q4, q4, q5
	vshr.u64	d10, d3, #18
	vshr.u64	d11, d7, #34
	veor		q4, q4, q6
	vshl.i64	d12, d3, #23
	vshl.i64	d13, d7, #25
	veor		q4, q4, q5
	vshr.u64	d10, d3, #41
	vshr.u64	d11, d7, #39
	veor		q4, q4, q6
	veor		d12, d4, d5
	veor		d13, d7, d0
	vand		d12, d12, d3
	vand		d13, d13, d1
	veor		d12, d12, d5
	veor		q4, q4, q5
	vand		d10, d7, d0
	vldr		d11, [r2,#72]
	vadd.i64	d6, d6, d25
	vadd.i64	q4, q4, q6
	vadd.i64	d6, d6, d11
	vadd.i64	d6, d6, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d2, d2, d6
	vadd.i64	d6, d6, d9

	
	vshl.i64	d8, d24, #45
	vshl.i64	d9, d27, #63
	vshr.u64	d10, d24, #19
	vshr.u64	d11, d27, #1
	vshl.i64	d12, d24, #3
	vshl.i64	d13, d27, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d24, #61
	vshr.u64	d11, d27, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d24, #6
	vshr.u64	d13, d27, #7
	veor.i64	q4, q4, q5
	vadd.i64	d26, d26, d19
	veor.i64	q4, q4, q6
	vadd.i64	d26, d26, d8
	vadd.i64	d26, d26, d9
 
	vshl.i64	d8, d2, #50
	vshl.i64	d9, d6, #36
	vshr.u64	d10, d2, #14
	vshr.u64	d11, d6, #28
	vshl.i64	d12, d2, #46
	vshl.i64	d13, d6, #30
	veor		q4, q4, q5
	vshr.u64	d10, d2, #18
	vshr.u64	d11, d6, #34
	veor		q4, q4, q6
	vshl.i64	d12, d2, #23
	vshl.i64	d13, d6, #25
	veor		q4, q4, q5
	vshr.u64	d10, d2, #41
	vshr.u64	d11, d6, #39
	veor		q4, q4, q6
	veor		d12, d3, d4
	veor		d13, d6, d7
	vand		d12, d12, d2
	vand		d13, d13, d0
	veor		d12, d12, d4
	veor		q4, q4, q5
	vand		d10, d6, d7
	vldr		d11, [r2,#80]
	vadd.i64	d5, d5, d26
	vadd.i64	q4, q4, q6
	vadd.i64	d5, d5, d11
	vadd.i64	d5, d5, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d1, d1, d5
	vadd.i64	d5, d5, d9

	
	vshl.i64	d8, d25, #45
	vshl.i64	d9, d28, #63
	vshr.u64	d10, d25, #19
	vshr.u64	d11, d28, #1
	vshl.i64	d12, d25, #3
	vshl.i64	d13, d28, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d25, #61
	vshr.u64	d11, d28, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d25, #6
	vshr.u64	d13, d28, #7
	veor.i64	q4, q4, q5
	vadd.i64	d27, d27, d20
	veor.i64	q4, q4, q6
	vadd.i64	d27, d27, d8
	vadd.i64	d27, d27, d9
 
	vshl.i64	d8, d1, #50
	vshl.i64	d9, d5, #36
	vshr.u64	d10, d1, #14
	vshr.u64	d11, d5, #28
	vshl.i64	d12, d1, #46
	vshl.i64	d13, d5, #30
	veor		q4, q4, q5
	vshr.u64	d10, d1, #18
	vshr.u64	d11, d5, #34
	veor		q4, q4, q6
	vshl.i64	d12, d1, #23
	vshl.i64	d13, d5, #25
	veor		q4, q4, q5
	vshr.u64	d10, d1, #41
	vshr.u64	d11, d5, #39
	veor		q4, q4, q6
	veor		d12, d2, d3
	veor		d13, d5, d6
	vand		d12, d12, d1
	vand		d13, d13, d7
	veor		d12, d12, d3
	veor		q4, q4, q5
	vand		d10, d5, d6
	vldr		d11, [r2,#88]
	vadd.i64	d4, d4, d27
	vadd.i64	q4, q4, q6
	vadd.i64	d4, d4, d11
	vadd.i64	d4, d4, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d0, d0, d4
	vadd.i64	d4, d4, d9

	
	vshl.i64	d8, d26, #45
	vshl.i64	d9, d29, #63
	vshr.u64	d10, d26, #19
	vshr.u64	d11, d29, #1
	vshl.i64	d12, d26, #3
	vshl.i64	d13, d29, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d26, #61
	vshr.u64	d11, d29, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d26, #6
	vshr.u64	d13, d29, #7
	veor.i64	q4, q4, q5
	vadd.i64	d28, d28, d21
	veor.i64	q4, q4, q6
	vadd.i64	d28, d28, d8
	vadd.i64	d28, d28, d9
 
	vshl.i64	d8, d0, #50
	vshl.i64	d9, d4, #36
	vshr.u64	d10, d0, #14
	vshr.u64	d11, d4, #28
	vshl.i64	d12, d0, #46
	vshl.i64	d13, d4, #30
	veor		q4, q4, q5
	vshr.u64	d10, d0, #18
	vshr.u64	d11, d4, #34
	veor		q4, q4, q6
	vshl.i64	d12, d0, #23
	vshl.i64	d13, d4, #25
	veor		q4, q4, q5
	vshr.u64	d10, d0, #41
	vshr.u64	d11, d4, #39
	veor		q4, q4, q6
	veor		d12, d1, d2
	veor		d13, d4, d5
	vand		d12, d12, d0
	vand		d13, d13, d6
	veor		d12, d12, d2
	veor		q4, q4, q5
	vand		d10, d4, d5
	vldr		d11, [r2,#96]
	vadd.i64	d3, d3, d28
	vadd.i64	q4, q4, q6
	vadd.i64	d3, d3, d11
	vadd.i64	d3, d3, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d7, d7, d3
	vadd.i64	d3, d3, d9

	
	vshl.i64	d8, d27, #45
	vshl.i64	d9, d30, #63
	vshr.u64	d10, d27, #19
	vshr.u64	d11, d30, #1
	vshl.i64	d12, d27, #3
	vshl.i64	d13, d30, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d27, #61
	vshr.u64	d11, d30, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d27, #6
	vshr.u64	d13, d30, #7
	veor.i64	q4, q4, q5
	vadd.i64	d29, d29, d22
	veor.i64	q4, q4, q6
	vadd.i64	d29, d29, d8
	vadd.i64	d29, d29, d9
 
	vshl.i64	d8, d7, #50
	vshl.i64	d9, d3, #36
	vshr.u64	d10, d7, #14
	vshr.u64	d11, d3, #28
	vshl.i64	d12, d7, #46
	vshl.i64	d13, d3, #30
	veor		q4, q4, q5
	vshr.u64	d10, d7, #18
	vshr.u64	d11, d3, #34
	veor		q4, q4, q6
	vshl.i64	d12, d7, #23
	vshl.i64	d13, d3, #25
	veor		q4, q4, q5
	vshr.u64	d10, d7, #41
	vshr.u64	d11, d3, #39
	veor		q4, q4, q6
	veor		d12, d0, d1
	veor		d13, d3, d4
	vand		d12, d12, d7
	vand		d13, d13, d5
	veor		d12, d12, d1
	veor		q4, q4, q5
	vand		d10, d3, d4
	vldr		d11, [r2,#104]
	vadd.i64	d2, d2, d29
	vadd.i64	q4, q4, q6
	vadd.i64	d2, d2, d11
	vadd.i64	d2, d2, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d6, d6, d2
	vadd.i64	d2, d2, d9

	
	vshl.i64	d8, d28, #45
	vshl.i64	d9, d31, #63
	vshr.u64	d10, d28, #19
	vshr.u64	d11, d31, #1
	vshl.i64	d12, d28, #3
	vshl.i64	d13, d31, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d28, #61
	vshr.u64	d11, d31, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d28, #6
	vshr.u64	d13, d31, #7
	veor.i64	q4, q4, q5
	vadd.i64	d30, d30, d23
	veor.i64	q4, q4, q6
	vadd.i64	d30, d30, d8
	vadd.i64	d30, d30, d9
 
	vshl.i64	d8, d6, #50
	vshl.i64	d9, d2, #36
	vshr.u64	d10, d6, #14
	vshr.u64	d11, d2, #28
	vshl.i64	d12, d6, #46
	vshl.i64	d13, d2, #30
	veor		q4, q4, q5
	vshr.u64	d10, d6, #18
	vshr.u64	d11, d2, #34
	veor		q4, q4, q6
	vshl.i64	d12, d6, #23
	vshl.i64	d13, d2, #25
	veor		q4, q4, q5
	vshr.u64	d10, d6, #41
	vshr.u64	d11, d2, #39
	veor		q4, q4, q6
	veor		d12, d7, d0
	veor		d13, d2, d3
	vand		d12, d12, d6
	vand		d13, d13, d4
	veor		d12, d12, d0
	veor		q4, q4, q5
	vand		d10, d2, d3
	vldr		d11, [r2,#112]
	vadd.i64	d1, d1, d30
	vadd.i64	q4, q4, q6
	vadd.i64	d1, d1, d11
	vadd.i64	d1, d1, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d5, d5, d1
	vadd.i64	d1, d1, d9

	subs	r3, r3, #1
	
	vshl.i64	d8, d29, #45
	vshl.i64	d9, d16, #63
	vshr.u64	d10, d29, #19
	vshr.u64	d11, d16, #1
	vshl.i64	d12, d29, #3
	vshl.i64	d13, d16, #56
	veor.i64	q4, q4, q5
	vshr.u64	d10, d29, #61
	vshr.u64	d11, d16, #8
	veor.i64	q4, q4, q6
	vshr.u64	d12, d29, #6
	vshr.u64	d13, d16, #7
	veor.i64	q4, q4, q5
	vadd.i64	d31, d31, d24
	veor.i64	q4, q4, q6
	vadd.i64	d31, d31, d8
	vadd.i64	d31, d31, d9
 
	vshl.i64	d8, d5, #50
	vshl.i64	d9, d1, #36
	vshr.u64	d10, d5, #14
	vshr.u64	d11, d1, #28
	vshl.i64	d12, d5, #46
	vshl.i64	d13, d1, #30
	veor		q4, q4, q5
	vshr.u64	d10, d5, #18
	vshr.u64	d11, d1, #34
	veor		q4, q4, q6
	vshl.i64	d12, d5, #23
	vshl.i64	d13, d1, #25
	veor		q4, q4, q5
	vshr.u64	d10, d5, #41
	vshr.u64	d11, d1, #39
	veor		q4, q4, q6
	veor		d12, d6, d7
	veor		d13, d1, d2
	vand		d12, d12, d5
	vand		d13, d13, d3
	veor		d12, d12, d7
	veor		q4, q4, q5
	vand		d10, d1, d2
	vldr		d11, [r2,#120]
	vadd.i64	d0, d0, d31
	vadd.i64	q4, q4, q6
	vadd.i64	d0, d0, d11
	vadd.i64	d0, d0, d8
	vadd.i64	d9, d9, d10
	vadd.i64	d4, d4, d0
	vadd.i64	d0, d0, d9

	add	r2, r2, #128
	bne	.Loop

	vld1.64		{d16, d17, d18, d19}, [r0]
	vadd.i64	q0, q0, q8
	vadd.i64	q1, q1, q9
	vst1.64		{d0,d1,d2,d3}, [r0]!
	vld1.64		{d16, d17, d18, d19}, [r0]
	vadd.i64	q2, q2, q8
	vadd.i64	q3, q3, q9
	vst1.64		{d4,d5,d6,d7}, [r0]!

	vpop	{d8,d9,d10,d11,d12,d13}
	bx	lr
.size _nettle_sha512_compress_neon, . - _nettle_sha512_compress_neon



.section .note.GNU-stack,"",%progbits
