/* Generated by wayland-scanner 1.22.0 */

#ifndef IVI_HMI_CONTROLLER_SERVER_PROTOCOL_H
#define IVI_HMI_CONTROLLER_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_ivi_hmi_controller The ivi_hmi_controller protocol
 * @section page_ifaces_ivi_hmi_controller Interfaces
 * - @subpage page_iface_ivi_hmi_controller - set up and control IVI style UI
 * @section page_copyright_ivi_hmi_controller Copyright
 * <pre>
 *
 * Copyright (C) 2013 DENSO CORPORATION
 * Copyright (c) 2013 BMW Car IT GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ivi_hmi_controller;
struct wl_seat;

#ifndef IVI_HMI_CONTROLLER_INTERFACE
#define IVI_HMI_CONTROLLER_INTERFACE
/**
 * @page page_iface_ivi_hmi_controller ivi_hmi_controller
 * @section page_iface_ivi_hmi_controller_desc Description
 * @section page_iface_ivi_hmi_controller_api API
 * See @ref iface_ivi_hmi_controller.
 */
/**
 * @defgroup iface_ivi_hmi_controller The ivi_hmi_controller interface
 */
extern const struct wl_interface ivi_hmi_controller_interface;
#endif

#ifndef IVI_HMI_CONTROLLER_LAYOUT_MODE_ENUM
#define IVI_HMI_CONTROLLER_LAYOUT_MODE_ENUM
enum ivi_hmi_controller_layout_mode {
	IVI_HMI_CONTROLLER_LAYOUT_MODE_TILING = 0,
	IVI_HMI_CONTROLLER_LAYOUT_MODE_SIDE_BY_SIDE = 1,
	IVI_HMI_CONTROLLER_LAYOUT_MODE_FULL_SCREEN = 2,
	IVI_HMI_CONTROLLER_LAYOUT_MODE_RANDOM = 3,
};
#endif /* IVI_HMI_CONTROLLER_LAYOUT_MODE_ENUM */

#ifndef IVI_HMI_CONTROLLER_HOME_ENUM
#define IVI_HMI_CONTROLLER_HOME_ENUM
enum ivi_hmi_controller_home {
	IVI_HMI_CONTROLLER_HOME_OFF = 0,
	IVI_HMI_CONTROLLER_HOME_ON = 1,
};
#endif /* IVI_HMI_CONTROLLER_HOME_ENUM */

/**
 * @ingroup iface_ivi_hmi_controller
 * @struct ivi_hmi_controller_interface
 */
struct ivi_hmi_controller_interface {
	/**
	 * inform the ready for drawing desktop.
	 *
	 * 
	 */
	void (*UI_ready)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * start controlling a surface by server
	 *
	 * Reference protocol to control a surface by server. To control
	 * a surface by server, it gives seat to the server to e.g. control
	 * Home screen. Home screen has several workspaces to group
	 * launchers of wayland application. These workspaces are drawn on
	 * a horizontally long surface to be controlled by motion of input
	 * device. E.g. A motion from right to left happens, the viewport
	 * of surface is controlled in the ivi-shell by using ivi-layout.
	 * client can recognizes the end of controlling by event
	 * "workspace_end_control".
	 */
	void (*workspace_control)(struct wl_client *client,
				  struct wl_resource *resource,
				  struct wl_resource *seat,
				  uint32_t serial);
	/**
	 * request mode switch of application layout
	 *
	 * hmi-controller loaded to ivi-shall implements 4 types of
	 * layout as a reference; tiling, side by side, full_screen, and
	 * random.
	 */
	void (*switch_mode)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t layout_mode);
	/**
	 * request displaying/undisplaying home screen
	 *
	 * home screen is a reference implementation of launcher to
	 * launch wayland applications. The home screen has several
	 * workspaces to group wayland applications. By defining the
	 * following keys in weston.ini, user can add launcher icon to
	 * launch a wayland application to a workspace. [ivi-launcher]
	 * workspace-id=0 : id of workspace to add a launcher icon-id=4001
	 * : ivi id of ivi_surface to draw an icon
	 * icon=/home/user/review/build-ivi-shell/data/icon_ivi_flower.png
	 * : path to icon image
	 * path=/home/user/review/build-ivi-shell/weston-dnd : path to
	 * wayland application
	 */
	void (*home)(struct wl_client *client,
		     struct wl_resource *resource,
		     uint32_t home);
};

#define IVI_HMI_CONTROLLER_WORKSPACE_END_CONTROL 0

/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_WORKSPACE_END_CONTROL_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_UI_READY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_WORKSPACE_CONTROL_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_SWITCH_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_hmi_controller
 */
#define IVI_HMI_CONTROLLER_HOME_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_hmi_controller
 * Sends an workspace_end_control event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ivi_hmi_controller_send_workspace_end_control(struct wl_resource *resource_, int32_t is_controlled)
{
	wl_resource_post_event(resource_, IVI_HMI_CONTROLLER_WORKSPACE_END_CONTROL, is_controlled);
}

#ifdef  __cplusplus
}
#endif

#endif
