#line 1 "numpy/core/src/umath/loops.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#define _UMATHMODULE
#define _MULTIARRAYMODULE
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "npy_config.h"
#include "numpy/npy_common.h"
#include "numpy/arrayobject.h"
#include "numpy/ufuncobject.h"
#include "numpy/npy_math.h"
#include "numpy/halffloat.h"
#include "lowlevel_strided_loops.h"
#include "loops_utils.h"

#include "npy_pycompat.h"

#include "ufunc_object.h"

#include <string.h> /* for memchr */

/* Use Libdivide for faster division */
#include "numpy/libdivide/libdivide.h"

/*
 * cutoff blocksize for pairwise summation
 * decreasing it decreases errors slightly as more pairs are summed but
 * also lowers performance, as the inner loop is unrolled eight times it is
 * effectively 16
 */
#define PW_BLOCKSIZE    128

/** Provides the various *_LOOP macros */
#include "fast_loop_macros.h"

/******************************************************************************
 **                          GENERIC FLOAT LOOPS                             **
 *****************************************************************************/

/* direct loops using a suitable callback */

#line 48

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_e_e(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_half func_type(npy_half);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *(npy_half *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ee_e(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_half func_type(npy_half, npy_half);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_half in1 = *(npy_half *)ip1;
        npy_half in2 = *(npy_half *)ip2;
        *(npy_half *)op1 = f(in1, in2);
    }
}


#line 48

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_f_f(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_float func_type(npy_float);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ff_f(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_float func_type(npy_float, npy_float);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_float in1 = *(npy_float *)ip1;
        npy_float in2 = *(npy_float *)ip2;
        *(npy_float *)op1 = f(in1, in2);
    }
}


#line 48

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_d_d(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_double func_type(npy_double);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_dd_d(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_double func_type(npy_double, npy_double);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_double in1 = *(npy_double *)ip1;
        npy_double in2 = *(npy_double *)ip2;
        *(npy_double *)op1 = f(in1, in2);
    }
}


#line 48

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_g_g(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_longdouble func_type(npy_longdouble);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *(npy_longdouble *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_gg_g(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_longdouble func_type(npy_longdouble, npy_longdouble);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_longdouble in1 = *(npy_longdouble *)ip1;
        npy_longdouble in2 = *(npy_longdouble *)ip2;
        *(npy_longdouble *)op1 = f(in1, in2);
    }
}



/* indirect loops with casting */
#line 86

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_e_e_As_f_f(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_float func_type(npy_float);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_float in1 = npy_half_to_float(*(npy_half *)ip1);
        *(npy_half *)op1 = npy_float_to_half(f(in1));
    }
}
/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ee_e_As_ff_f(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_float func_type(npy_float, npy_float);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        const npy_float in1 = npy_half_to_float(*(npy_half *)ip1);
        const npy_float in2 = npy_half_to_float(*(npy_half *)ip2);
        *(npy_half *)op1 = npy_float_to_half(f(in1, in2));
    }
}


#line 86

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_e_e_As_d_d(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_double func_type(npy_double);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_double in1 = npy_half_to_double(*(npy_half *)ip1);
        *(npy_half *)op1 = npy_double_to_half(f(in1));
    }
}
/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ee_e_As_dd_d(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_double func_type(npy_double, npy_double);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        const npy_double in1 = npy_half_to_double(*(npy_half *)ip1);
        const npy_double in2 = npy_half_to_double(*(npy_half *)ip2);
        *(npy_half *)op1 = npy_double_to_half(f(in1, in2));
    }
}


#line 86

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_f_f_As_d_d(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_double func_type(npy_double);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        const npy_double in1 = (double)(*(npy_float *)ip1);
        *(npy_float *)op1 = (float)(f(in1));
    }
}
/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ff_f_As_dd_d(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef npy_double func_type(npy_double, npy_double);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        const npy_double in1 = (double)(*(npy_float *)ip1);
        const npy_double in2 = (double)(*(npy_float *)ip2);
        *(npy_float *)op1 = (float)(f(in1, in2));
    }
}



/******************************************************************************
 **                          GENERIC COMPLEX LOOPS                           **
 *****************************************************************************/

/* direct loops using a suitable callback */
#line 122

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_F_F(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_cfloat *, npy_cfloat *);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        npy_cfloat in1 = *(npy_cfloat *)ip1;
        npy_cfloat *out = (npy_cfloat *)op1;
        f(&in1, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_FF_F(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_cfloat *, npy_cfloat *, npy_cfloat *);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_cfloat in1 = *(npy_cfloat *)ip1;
        npy_cfloat in2 = *(npy_cfloat *)ip2;
        npy_cfloat *out = (npy_cfloat *)op1;
        f(&in1, &in2, out);
    }
}

#line 122

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_D_D(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_cdouble *, npy_cdouble *);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        npy_cdouble in1 = *(npy_cdouble *)ip1;
        npy_cdouble *out = (npy_cdouble *)op1;
        f(&in1, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_DD_D(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_cdouble *, npy_cdouble *, npy_cdouble *);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_cdouble in1 = *(npy_cdouble *)ip1;
        npy_cdouble in2 = *(npy_cdouble *)ip2;
        npy_cdouble *out = (npy_cdouble *)op1;
        f(&in1, &in2, out);
    }
}

#line 122

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_G_G(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_clongdouble *, npy_clongdouble *);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        npy_clongdouble in1 = *(npy_clongdouble *)ip1;
        npy_clongdouble *out = (npy_clongdouble *)op1;
        f(&in1, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_GG_G(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_clongdouble *, npy_clongdouble *, npy_clongdouble *);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_clongdouble in1 = *(npy_clongdouble *)ip1;
        npy_clongdouble in2 = *(npy_clongdouble *)ip2;
        npy_clongdouble *out = (npy_clongdouble *)op1;
        f(&in1, &in2, out);
    }
}



/* indirect loops with casting */
/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_F_F_As_D_D(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_cdouble *, npy_cdouble *);
    func_type *f = (func_type *)func;
    UNARY_LOOP {
        npy_cdouble tmp, out;
        tmp.real = (double)((float *)ip1)[0];
        tmp.imag = (double)((float *)ip1)[1];
        f(&tmp, &out);
        ((float *)op1)[0] = (float)out.real;
        ((float *)op1)[1] = (float)out.imag;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_FF_F_As_DD_D(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    typedef void func_type(npy_cdouble *, npy_cdouble *, npy_cdouble *);
    func_type *f = (func_type *)func;
    BINARY_LOOP {
        npy_cdouble tmp1, tmp2, out;
        tmp1.real = (double)((float *)ip1)[0];
        tmp1.imag = (double)((float *)ip1)[1];
        tmp2.real = (double)((float *)ip2)[0];
        tmp2.imag = (double)((float *)ip2)[1];
        f(&tmp1, &tmp2, &out);
        ((float *)op1)[0] = (float)out.real;
        ((float *)op1)[1] = (float)out.imag;
    }
}


/******************************************************************************
 **                         GENERIC OBJECT lOOPS                             **
 *****************************************************************************/

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_O_O(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    unaryfunc f = (unaryfunc)func;
    UNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject **out = (PyObject **)op1;
        /* We allow NULL, but try to guarantee non-NULL to downstream */
        assert(in1 != NULL);
        PyObject *ret = f(in1 ? in1 : Py_None);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_O_O_method(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    char *meth = (char *)func;
    UNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject **out = (PyObject **)op1;
        /* We allow NULL, but try to guarantee non-NULL to downstream */
        assert(in1 != NULL);
        PyObject *ret, *func;
        func = PyObject_GetAttrString(in1 ? in1 : Py_None, meth);
        if (func != NULL && !PyCallable_Check(func)) {
            Py_DECREF(func);
            func = NULL;
        }
        if (func == NULL) {
            PyObject *exc, *val, *tb;
            PyTypeObject *type = in1 ? Py_TYPE(in1) : Py_TYPE(Py_None);
            PyErr_Fetch(&exc, &val, &tb);
            PyErr_Format(PyExc_TypeError,
                         "loop of ufunc does not support argument %d of "
                         "type %s which has no callable %s method",
                         i, type->tp_name, meth);
            npy_PyErr_ChainExceptionsCause(exc, val, tb);
            Py_XDECREF(func);
            return;
        }
        ret = PyObject_CallObject(func, NULL);
        Py_DECREF(func);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_OO_O(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    binaryfunc f = (binaryfunc)func;
    BINARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;
        PyObject **out = (PyObject **)op1;
        /* We allow NULL, but try to guarantee non-NULL to downstream */
        assert(in1 != NULL);
        assert(in2 != NULL);
        PyObject *ret = f(in1 ? in1 : Py_None, in2 ? in2 : Py_None);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

NPY_NO_EXPORT void
PyUFunc_OOO_O(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    ternaryfunc f = (ternaryfunc)func;
    TERNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;
        PyObject *in3 = *(PyObject **)ip3;
        PyObject **out = (PyObject **)op1;
        /* We allow NULL, but try to guarantee non-NULL to downstream */
        assert(in1 != NULL);
        assert(in2 != NULL);
        assert(in3 != NULL);
        PyObject *ret = f(
            in1 ? in1 : Py_None,
            in2 ? in2 : Py_None,
            in3 ? in3 : Py_None
        );
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_OO_O_method(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    char *meth = (char *)func;
    BINARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;
        PyObject **out = (PyObject **)op1;
        /* We allow NULL, but try to guarantee non-NULL to downstream */
        assert(in1 != NULL);
        assert(in2 != NULL);
        PyObject *ret = PyObject_CallMethod(in1 ? in1 : Py_None,
                                            meth, "(O)", in2);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*
 * A general-purpose ufunc that deals with general-purpose Python callable.
 * func is a structure with nin, nout, and a Python callable function
 */

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_On_Om(char **args, npy_intp const *dimensions, npy_intp const *steps, void *func)
{
    npy_intp n =  dimensions[0];
    PyUFunc_PyFuncData *data = (PyUFunc_PyFuncData *)func;
    int nin = data->nin;
    int nout = data->nout;
    PyObject *tocall = data->callable;
    char *ptrs[NPY_MAXARGS];
    PyObject *arglist, *result;
    PyObject *in, **op;
    npy_intp i, j, ntot;

    ntot = nin+nout;

    for(j = 0; j < ntot; j++) {
        ptrs[j] = args[j];
    }
    for(i = 0; i < n; i++) {
        arglist = PyTuple_New(nin);
        if (arglist == NULL) {
            return;
        }
        for(j = 0; j < nin; j++) {
            in = *((PyObject **)ptrs[j]);
            /* We allow NULL, but try to guarantee non-NULL to downstream */
            assert(in != NULL);
            if (in == NULL) {
                in = Py_None;
            }
            PyTuple_SET_ITEM(arglist, j, in);
            Py_INCREF(in);
        }
        result = PyObject_CallObject(tocall, arglist);
        Py_DECREF(arglist);
        if (result == NULL) {
            return;
        }
        if (nout == 0  && result == Py_None) {
            /* No output expected, no output received, continue */
            Py_DECREF(result);
        }
        else if (nout == 1) {
            /* Single output expected, assign and continue */
            op = (PyObject **)ptrs[nin];
            Py_XDECREF(*op);
            *op = result;
        }
        else if (PyTuple_Check(result) && nout == PyTuple_Size(result)) {
            /*
             * Multiple returns match expected number of outputs, assign
             * and continue. Will also gobble empty tuples if nout == 0.
             */
            for(j = 0; j < nout; j++) {
                op = (PyObject **)ptrs[j+nin];
                Py_XDECREF(*op);
                *op = PyTuple_GET_ITEM(result, j);
                Py_INCREF(*op);
            }
            Py_DECREF(result);
        }
        else {
            /* Mismatch between returns and expected outputs, exit */
            Py_DECREF(result);
            return;
        }
        for(j = 0; j < ntot; j++) {
            ptrs[j] += steps[j];
        }
    }
}

/*
 *****************************************************************************
 **                             BOOLEAN LOOPS                               **
 *****************************************************************************
 */

NPY_NO_EXPORT void
BOOL__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_bool *)op1) = 1;
    }
}

/*
 *****************************************************************************
 **                           INTEGER LOOPS
 *****************************************************************************
 */

#line 426

#define BYTE_floor_divide BYTE_divide
#define BYTE_floor_divide_indexed BYTE_divide_indexed
#define BYTE_fmax BYTE_maximum
#define BYTE_fmax_indexed BYTE_maximum_indexed
#define BYTE_fmin BYTE_minimum
#define BYTE_fmin_indexed BYTE_minimum_indexed

NPY_NO_EXPORT void
BYTE__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_byte *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
BYTE_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_byte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_byte *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_byte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
BYTE_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_byte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_byte *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_byte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
BYTE_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_byte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_byte *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_byte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
BYTE_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_byte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_byte *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_byte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
BYTE_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_byte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_byte *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_byte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
BYTE_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_byte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_byte *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_byte *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
BYTE_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_byte in1 = *(npy_byte *)ip1;
        npy_byte in2 = *(npy_byte *)ip2;
        npy_byte out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_byte *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_byte *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_byte *) op1) = out;
    }
}

#line 426

#define UBYTE_floor_divide UBYTE_divide
#define UBYTE_floor_divide_indexed UBYTE_divide_indexed
#define UBYTE_fmax UBYTE_maximum
#define UBYTE_fmax_indexed UBYTE_maximum_indexed
#define UBYTE_fmin UBYTE_minimum
#define UBYTE_fmin_indexed UBYTE_minimum_indexed

NPY_NO_EXPORT void
UBYTE__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ubyte *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UBYTE_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ubyte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ubyte *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_ubyte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UBYTE_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ubyte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ubyte *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_ubyte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UBYTE_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ubyte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ubyte *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_ubyte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UBYTE_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ubyte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ubyte *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_ubyte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UBYTE_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ubyte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ubyte *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_ubyte *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UBYTE_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ubyte *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ubyte *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_ubyte *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
UBYTE_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ubyte in1 = *(npy_ubyte *)ip1;
        npy_ubyte in2 = *(npy_ubyte *)ip2;
        npy_ubyte out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ubyte *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ubyte *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ubyte *) op1) = out;
    }
}

#line 426

#define SHORT_floor_divide SHORT_divide
#define SHORT_floor_divide_indexed SHORT_divide_indexed
#define SHORT_fmax SHORT_maximum
#define SHORT_fmax_indexed SHORT_maximum_indexed
#define SHORT_fmin SHORT_minimum
#define SHORT_fmin_indexed SHORT_minimum_indexed

NPY_NO_EXPORT void
SHORT__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_short *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
SHORT_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_short *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_short *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_short *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
SHORT_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_short *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_short *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_short *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
SHORT_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_short *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_short *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_short *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
SHORT_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_short *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_short *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_short *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
SHORT_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_short *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_short *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_short *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
SHORT_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_short *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_short *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_short *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
SHORT_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_short in1 = *(npy_short *)ip1;
        npy_short in2 = *(npy_short *)ip2;
        npy_short out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_short *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_short *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_short *) op1) = out;
    }
}

#line 426

#define USHORT_floor_divide USHORT_divide
#define USHORT_floor_divide_indexed USHORT_divide_indexed
#define USHORT_fmax USHORT_maximum
#define USHORT_fmax_indexed USHORT_maximum_indexed
#define USHORT_fmin USHORT_minimum
#define USHORT_fmin_indexed USHORT_minimum_indexed

NPY_NO_EXPORT void
USHORT__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ushort *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
USHORT_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ushort *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ushort *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_ushort *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
USHORT_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ushort *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ushort *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_ushort *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
USHORT_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ushort *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ushort *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_ushort *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
USHORT_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ushort *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ushort *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_ushort *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
USHORT_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ushort *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ushort *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_ushort *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
USHORT_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ushort *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ushort *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_ushort *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
USHORT_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ushort in1 = *(npy_ushort *)ip1;
        npy_ushort in2 = *(npy_ushort *)ip2;
        npy_ushort out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ushort *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ushort *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ushort *) op1) = out;
    }
}

#line 426

#define INT_floor_divide INT_divide
#define INT_floor_divide_indexed INT_divide_indexed
#define INT_fmax INT_maximum
#define INT_fmax_indexed INT_maximum_indexed
#define INT_fmin INT_minimum
#define INT_fmin_indexed INT_minimum_indexed

NPY_NO_EXPORT void
INT__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_int *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
INT_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_int *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_int *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_int *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
INT_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_int *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_int *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_int *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
INT_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_int *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_int *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_int *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
INT_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_int *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_int *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_int *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
INT_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_int *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_int *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_int *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
INT_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_int *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_int *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_int *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
INT_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_int in1 = *(npy_int *)ip1;
        npy_int in2 = *(npy_int *)ip2;
        npy_int out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_int *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_int *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_int *) op1) = out;
    }
}

#line 426

#define UINT_floor_divide UINT_divide
#define UINT_floor_divide_indexed UINT_divide_indexed
#define UINT_fmax UINT_maximum
#define UINT_fmax_indexed UINT_maximum_indexed
#define UINT_fmin UINT_minimum
#define UINT_fmin_indexed UINT_minimum_indexed

NPY_NO_EXPORT void
UINT__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_uint *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UINT_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_uint *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_uint *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_uint *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UINT_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_uint *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_uint *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_uint *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UINT_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_uint *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_uint *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_uint *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UINT_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_uint *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_uint *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_uint *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UINT_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_uint *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_uint *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_uint *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
UINT_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_uint *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_uint *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_uint *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
UINT_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_uint in1 = *(npy_uint *)ip1;
        npy_uint in2 = *(npy_uint *)ip2;
        npy_uint out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_uint *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_uint *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_uint *) op1) = out;
    }
}

#line 426

#define LONG_floor_divide LONG_divide
#define LONG_floor_divide_indexed LONG_divide_indexed
#define LONG_fmax LONG_maximum
#define LONG_fmax_indexed LONG_maximum_indexed
#define LONG_fmin LONG_minimum
#define LONG_fmin_indexed LONG_minimum_indexed

NPY_NO_EXPORT void
LONG__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_long *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONG_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_long *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_long *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_long *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONG_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_long *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_long *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_long *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONG_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_long *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_long *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_long *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONG_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_long *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_long *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_long *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONG_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_long *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_long *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_long *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONG_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_long *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_long *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_long *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
LONG_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_long in1 = *(npy_long *)ip1;
        npy_long in2 = *(npy_long *)ip2;
        npy_long out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_long *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_long *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_long *) op1) = out;
    }
}

#line 426

#define ULONG_floor_divide ULONG_divide
#define ULONG_floor_divide_indexed ULONG_divide_indexed
#define ULONG_fmax ULONG_maximum
#define ULONG_fmax_indexed ULONG_maximum_indexed
#define ULONG_fmin ULONG_minimum
#define ULONG_fmin_indexed ULONG_minimum_indexed

NPY_NO_EXPORT void
ULONG__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ulong *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONG_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulong *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_ulong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONG_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulong *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_ulong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONG_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulong *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_ulong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONG_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulong *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_ulong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONG_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulong *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_ulong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONG_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulong *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_ulong *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
ULONG_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ulong in1 = *(npy_ulong *)ip1;
        npy_ulong in2 = *(npy_ulong *)ip2;
        npy_ulong out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ulong *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ulong *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ulong *) op1) = out;
    }
}

#line 426

#define LONGLONG_floor_divide LONGLONG_divide
#define LONGLONG_floor_divide_indexed LONGLONG_divide_indexed
#define LONGLONG_fmax LONGLONG_maximum
#define LONGLONG_fmax_indexed LONGLONG_maximum_indexed
#define LONGLONG_fmin LONGLONG_minimum
#define LONGLONG_fmin_indexed LONGLONG_minimum_indexed

NPY_NO_EXPORT void
LONGLONG__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_longlong *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONGLONG_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longlong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longlong *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_longlong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONGLONG_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longlong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longlong *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_longlong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONGLONG_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longlong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longlong *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_longlong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONGLONG_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longlong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longlong *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_longlong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONGLONG_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longlong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longlong *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_longlong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
LONGLONG_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longlong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longlong *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_longlong *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
LONGLONG_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_longlong in1 = *(npy_longlong *)ip1;
        npy_longlong in2 = *(npy_longlong *)ip2;
        npy_longlong out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_longlong *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_longlong *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_longlong *) op1) = out;
    }
}

#line 426

#define ULONGLONG_floor_divide ULONGLONG_divide
#define ULONGLONG_floor_divide_indexed ULONGLONG_divide_indexed
#define ULONGLONG_fmax ULONGLONG_maximum
#define ULONGLONG_fmax_indexed ULONGLONG_maximum_indexed
#define ULONGLONG_fmin ULONGLONG_minimum
#define ULONGLONG_fmin_indexed ULONGLONG_minimum_indexed

NPY_NO_EXPORT void
ULONGLONG__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ulonglong *)op1) = 1;
    }
}
#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONGLONG_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulonglong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulonglong *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_ulonglong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONGLONG_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulonglong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulonglong *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_ulonglong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONGLONG_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulonglong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulonglong *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_ulonglong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONGLONG_bitwise_and_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulonglong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulonglong *)(ip1 + is1 * indx);
        *indexed = *indexed & *(npy_ulonglong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONGLONG_bitwise_or_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulonglong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulonglong *)(ip1 + is1 * indx);
        *indexed = *indexed | *(npy_ulonglong *)value;
    }
    return 0;
}

#line 446

NPY_NO_EXPORT NPY_GCC_OPT_3 int
ULONGLONG_bitwise_xor_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
                      char **args, npy_intp const *dimensions, npy_intp const *steps,
                      void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_ulonglong *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_ulonglong *)(ip1 + is1 * indx);
        *indexed = *indexed ^ *(npy_ulonglong *)value;
    }
    return 0;
}


NPY_NO_EXPORT void
ULONGLONG_power(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        npy_ulonglong out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ulonglong *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ulonglong *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ulonglong *) op1) = out;
    }
}


#line 518
#line 521
NPY_NO_EXPORT void
BYTE_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        *((npy_byte *)op1) = npy_gcd(in1, in2);
    }
}

#line 521
NPY_NO_EXPORT void
BYTE_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        *((npy_byte *)op1) = npy_lcm(in1, in2);
    }
}


#line 518
#line 521
NPY_NO_EXPORT void
SHORT_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        *((npy_short *)op1) = npy_gcd(in1, in2);
    }
}

#line 521
NPY_NO_EXPORT void
SHORT_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        *((npy_short *)op1) = npy_lcm(in1, in2);
    }
}


#line 518
#line 521
NPY_NO_EXPORT void
INT_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        *((npy_int *)op1) = npy_gcd(in1, in2);
    }
}

#line 521
NPY_NO_EXPORT void
INT_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        *((npy_int *)op1) = npy_lcm(in1, in2);
    }
}


#line 518
#line 521
NPY_NO_EXPORT void
LONG_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        *((npy_long *)op1) = npy_gcdl(in1, in2);
    }
}

#line 521
NPY_NO_EXPORT void
LONG_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        *((npy_long *)op1) = npy_lcml(in1, in2);
    }
}


#line 518
#line 521
NPY_NO_EXPORT void
LONGLONG_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        *((npy_longlong *)op1) = npy_gcdll(in1, in2);
    }
}

#line 521
NPY_NO_EXPORT void
LONGLONG_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        *((npy_longlong *)op1) = npy_lcmll(in1, in2);
    }
}



#line 538
#line 541
NPY_NO_EXPORT void
UBYTE_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        *((npy_ubyte *)op1) = npy_gcdu(in1, in2);
    }
}

#line 541
NPY_NO_EXPORT void
UBYTE_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        *((npy_ubyte *)op1) = npy_lcmu(in1, in2);
    }
}


#line 538
#line 541
NPY_NO_EXPORT void
USHORT_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        *((npy_ushort *)op1) = npy_gcdu(in1, in2);
    }
}

#line 541
NPY_NO_EXPORT void
USHORT_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        *((npy_ushort *)op1) = npy_lcmu(in1, in2);
    }
}


#line 538
#line 541
NPY_NO_EXPORT void
UINT_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        *((npy_uint *)op1) = npy_gcdu(in1, in2);
    }
}

#line 541
NPY_NO_EXPORT void
UINT_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        *((npy_uint *)op1) = npy_lcmu(in1, in2);
    }
}


#line 538
#line 541
NPY_NO_EXPORT void
ULONG_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        *((npy_ulong *)op1) = npy_gcdul(in1, in2);
    }
}

#line 541
NPY_NO_EXPORT void
ULONG_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        *((npy_ulong *)op1) = npy_lcmul(in1, in2);
    }
}


#line 538
#line 541
NPY_NO_EXPORT void
ULONGLONG_gcd(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        *((npy_ulonglong *)op1) = npy_gcdull(in1, in2);
    }
}

#line 541
NPY_NO_EXPORT void
ULONGLONG_lcm(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        *((npy_ulonglong *)op1) = npy_lcmull(in1, in2);
    }
}




/*
 * NOTE: It may be nice to vectorize these, OTOH, these are still faster
 *       than the cast we used to do.
 */

#line 563
NPY_NO_EXPORT void
LONGLONG_Qq_bool_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 < 0) {
            *(npy_bool *)op1 = 0 == in2;
        }
        else {
            *(npy_bool *)op1 = in1 == (npy_ulonglong)in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_qQ_bool_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in1 < 0) {
            *(npy_bool *)op1 = in1 == 0;
        }
        else {
            *(npy_bool *)op1 = (npy_ulonglong)in1 == in2;
        }
    }
}

#line 563
NPY_NO_EXPORT void
LONGLONG_Qq_bool_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 < 0) {
            *(npy_bool *)op1 = 0 != in2;
        }
        else {
            *(npy_bool *)op1 = in1 != (npy_ulonglong)in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_qQ_bool_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in1 < 0) {
            *(npy_bool *)op1 = in1 != 0;
        }
        else {
            *(npy_bool *)op1 = (npy_ulonglong)in1 != in2;
        }
    }
}

#line 563
NPY_NO_EXPORT void
LONGLONG_Qq_bool_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 < 0) {
            *(npy_bool *)op1 = 0 < in2;
        }
        else {
            *(npy_bool *)op1 = in1 < (npy_ulonglong)in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_qQ_bool_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in1 < 0) {
            *(npy_bool *)op1 = in1 < 0;
        }
        else {
            *(npy_bool *)op1 = (npy_ulonglong)in1 < in2;
        }
    }
}

#line 563
NPY_NO_EXPORT void
LONGLONG_Qq_bool_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 < 0) {
            *(npy_bool *)op1 = 0 <= in2;
        }
        else {
            *(npy_bool *)op1 = in1 <= (npy_ulonglong)in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_qQ_bool_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in1 < 0) {
            *(npy_bool *)op1 = in1 <= 0;
        }
        else {
            *(npy_bool *)op1 = (npy_ulonglong)in1 <= in2;
        }
    }
}

#line 563
NPY_NO_EXPORT void
LONGLONG_Qq_bool_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 < 0) {
            *(npy_bool *)op1 = 0 > in2;
        }
        else {
            *(npy_bool *)op1 = in1 > (npy_ulonglong)in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_qQ_bool_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in1 < 0) {
            *(npy_bool *)op1 = in1 > 0;
        }
        else {
            *(npy_bool *)op1 = (npy_ulonglong)in1 > in2;
        }
    }
}

#line 563
NPY_NO_EXPORT void
LONGLONG_Qq_bool_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 < 0) {
            *(npy_bool *)op1 = 0 >= in2;
        }
        else {
            *(npy_bool *)op1 = in1 >= (npy_ulonglong)in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_qQ_bool_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in1 < 0) {
            *(npy_bool *)op1 = in1 >= 0;
        }
        else {
            *(npy_bool *)op1 = (npy_ulonglong)in1 >= in2;
        }
    }
}



/*
 *****************************************************************************
 **                           DATETIME LOOPS                                **
 *****************************************************************************
 */

NPY_NO_EXPORT void
TIMEDELTA_negative(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = -in1;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_positive(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_timedelta *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
TIMEDELTA_absolute(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = (in1 >= 0) ? in1 : -in1;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_timedelta *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : 0);
    }
}

#line 651

NPY_NO_EXPORT void
DATETIME_isnat(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        *((npy_bool *)op1) = (in1 == NPY_DATETIME_NAT);
    }
}

NPY_NO_EXPORT void
DATETIME_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        *((npy_bool *)op1) = (in1 != NPY_DATETIME_NAT);
    }
}

NPY_NO_EXPORT void
DATETIME__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_datetime *)op1) = 1;
    }
}

#line 682
NPY_NO_EXPORT void
DATETIME_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 == in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
DATETIME_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 > in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
DATETIME_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 >= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
DATETIME_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 < in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
DATETIME_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 <= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}


NPY_NO_EXPORT void
DATETIME_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 != in2 ||
                              in1 == NPY_DATETIME_NAT ||
                              in2 == NPY_DATETIME_NAT);
    }
}


#line 712
NPY_NO_EXPORT void
DATETIME_maximum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in1;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in2;
        }
        else {
            *((npy_datetime *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 712
NPY_NO_EXPORT void
DATETIME_minimum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in1;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in2;
        }
        else {
            *((npy_datetime *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



#line 736
NPY_NO_EXPORT void
DATETIME_fmax(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in1;
        }
        else {
            *((npy_datetime *)op1) = in1 >= in2 ? in1 : in2;
        }
    }
}

#line 736
NPY_NO_EXPORT void
DATETIME_fmin(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in1;
        }
        else {
            *((npy_datetime *)op1) = in1 <= in2 ? in1 : in2;
        }
    }
}



#line 651

NPY_NO_EXPORT void
TIMEDELTA_isnat(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_bool *)op1) = (in1 == NPY_DATETIME_NAT);
    }
}

NPY_NO_EXPORT void
TIMEDELTA_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_bool *)op1) = (in1 != NPY_DATETIME_NAT);
    }
}

NPY_NO_EXPORT void
TIMEDELTA__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_timedelta *)op1) = 1;
    }
}

#line 682
NPY_NO_EXPORT void
TIMEDELTA_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 == in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
TIMEDELTA_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 > in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
TIMEDELTA_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 >= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
TIMEDELTA_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 < in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 682
NPY_NO_EXPORT void
TIMEDELTA_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 <= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}


NPY_NO_EXPORT void
TIMEDELTA_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 != in2 ||
                              in1 == NPY_DATETIME_NAT ||
                              in2 == NPY_DATETIME_NAT);
    }
}


#line 712
NPY_NO_EXPORT void
TIMEDELTA_maximum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in1;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in2;
        }
        else {
            *((npy_timedelta *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 712
NPY_NO_EXPORT void
TIMEDELTA_minimum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in1;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in2;
        }
        else {
            *((npy_timedelta *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



#line 736
NPY_NO_EXPORT void
TIMEDELTA_fmax(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in1;
        }
        else {
            *((npy_timedelta *)op1) = in1 >= in2 ? in1 : in2;
        }
    }
}

#line 736
NPY_NO_EXPORT void
TIMEDELTA_fmin(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in1;
        }
        else {
            *((npy_timedelta *)op1) = in1 <= in2 ? in1 : in2;
        }
    }
}




NPY_NO_EXPORT void
DATETIME_Mm_M_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_datetime *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT void
DATETIME_mM_M_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_datetime *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_m_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT void
DATETIME_Mm_M_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_datetime *)op1) = in1 - in2;
        }
    }
}

NPY_NO_EXPORT void
DATETIME_MM_m_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 - in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_m_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 - in2;
        }
    }
}

/* Note: Assuming 'q' == NPY_LONGLONG */
NPY_NO_EXPORT void
TIMEDELTA_mq_m_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_int64 in2 = *(npy_int64 *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 * in2;
        }
    }
}

/* Note: Assuming 'q' == NPY_LONGLONG */
NPY_NO_EXPORT void
TIMEDELTA_qm_m_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int64 in1 = *(npy_int64 *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 * in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_md_m_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const double in2 = *(double *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            double result = in1 * in2;
            if (npy_isfinite(result)) {
                *((npy_timedelta *)op1) = (npy_timedelta)result;
            }
            else {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_dm_m_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const double in1 = *(double *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            double result = in1 * in2;
            if (npy_isfinite(result)) {
                *((npy_timedelta *)op1) = (npy_timedelta)result;
            }
            else {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
    }
}

/* Note: Assuming 'q' == NPY_LONGLONG */
NPY_NO_EXPORT void
TIMEDELTA_mq_m_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* NOTE: This code is similar to array floor divide */
    BINARY_DEFS

    /* When the divisor is a constant, use libdivide for faster division */
    if (steps[1] == 0) {
        /* In case of empty array, just return */
        if (n == 0) {
            return;
        }

        const npy_int64 in2 = *(npy_int64 *)ip2;

        /* If divisor is 0, we need not compute anything */
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            BINARY_LOOP_SLIDING {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
        else {
            struct libdivide_s64_t fast_d = libdivide_s64_gen(in2);
            BINARY_LOOP_SLIDING {
                const npy_timedelta in1 = *(npy_timedelta *)ip1;
                if (in1 == NPY_DATETIME_NAT) {
                    *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
                }
                else {
                    *((npy_timedelta *)op1) = libdivide_s64_do(in1, &fast_d);
                }
            }
        }
    }
    else {
        BINARY_LOOP_SLIDING {
            const npy_timedelta in1 = *(npy_timedelta *)ip1;
            const npy_int64 in2 = *(npy_int64 *)ip2;
            if (in1 == NPY_DATETIME_NAT || in2 == 0) {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
            else {
                *((npy_timedelta *)op1) = in1 / in2;
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_md_m_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const double in2 = *(double *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            double result = in1 / in2;
            if (npy_isfinite(result)) {
                *((npy_timedelta *)op1) = (npy_timedelta)result;
            }
            else {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_d_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((double *)op1) = NPY_NAN;
        }
        else {
            *((double *)op1) = (double)in1 / (double)in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_m_remainder(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            if (in2 == 0) {
                npy_set_floatstatus_divbyzero();
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
            else {
                /* handle mixed case the way Python does */
                const npy_timedelta rem = in1 % in2;
                if ((in1 > 0) == (in2 > 0) || rem == 0) {
                    *((npy_timedelta *)op1) = rem;
                }
                else {
                    *((npy_timedelta *)op1) = rem + in2;
                }
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_q_floor_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* NOTE: This code is similar to array floor divide */
    BINARY_DEFS

    /* When the divisor is a constant, use libdivide for faster division */
    if (steps[1] == 0) {
        /* In case of empty array, just return */
        if (n == 0) {
            return;
        }

        const npy_timedelta in2 = *(npy_timedelta *)ip2;

        /* If divisor is 0 or NAT, we need not compute anything */
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            BINARY_LOOP_SLIDING {
                *((npy_int64 *)op1) = 0;
            }
        }
        else if (in2 == NPY_DATETIME_NAT) {
            npy_set_floatstatus_invalid();
            BINARY_LOOP_SLIDING {
                *((npy_int64 *)op1) = 0;
            }
        }
        else {
            struct libdivide_s64_t fast_d = libdivide_s64_gen(in2);
             BINARY_LOOP_SLIDING {
                const npy_timedelta in1 = *(npy_timedelta *)ip1;
                if (in1 == NPY_DATETIME_NAT) {
                    npy_set_floatstatus_invalid();
                    *((npy_int64 *)op1) = 0;
                }
                else {
                    *((npy_int64 *)op1) = libdivide_s64_do(in1, &fast_d);

                    /* Negative quotients needs to be rounded down */
                    if (((in1 > 0) != (in2 > 0)) && (*((npy_int64 *)op1) * in2 != in1)) {
                        *((npy_int64 *)op1) = *((npy_int64 *)op1) - 1;
                    }
                }
            }
        }
    }
    else {
        BINARY_LOOP_SLIDING {
            const npy_timedelta in1 = *(npy_timedelta *)ip1;
            const npy_timedelta in2 = *(npy_timedelta *)ip2;
            if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
                npy_set_floatstatus_invalid();
                *((npy_int64 *)op1) = 0;
            }
            else if (in2 == 0) {
                npy_set_floatstatus_divbyzero();
                *((npy_int64 *)op1) = 0;
            }
            else {
                *((npy_int64 *)op1) = in1/in2;

                /* Negative quotients needs to be rounded down */
                if (((in1 > 0) != (in2 > 0)) && (*((npy_int64 *)op1) * in2 != in1)) {
                    *((npy_int64 *)op1) = *((npy_int64 *)op1) - 1;
                }
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_qm_divmod(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            npy_set_floatstatus_invalid();
            *((npy_int64 *)op1) = 0;
            *((npy_timedelta *)op2) = NPY_DATETIME_NAT;
        }
        else if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_int64 *)op1) = 0;
            *((npy_timedelta *)op2) = NPY_DATETIME_NAT;
        }
        else {
            const npy_int64 quo = in1 / in2;
            const npy_timedelta rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_int64 *)op1) = quo;
                *((npy_timedelta *)op2) = rem;
            }
            else {
                *((npy_int64 *)op1) = quo - 1;
                *((npy_timedelta *)op2) = rem + in2;
            }
        }
    }
}

/*
 *****************************************************************************
 **                             FLOAT LOOPS                                 **
 *****************************************************************************
 */

#line 1152
#line 1156
NPY_NO_EXPORT void
FLOAT_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_bool *)op1) = in1 && in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1156
NPY_NO_EXPORT void
FLOAT_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_bool *)op1) = in1 || in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
FLOAT_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_float *)ip1;
        const int t2 = !!*(npy_float *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}

NPY_NO_EXPORT void
FLOAT_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_bool *)op1) = !in1;
    }
}

#if !1
#line 1192
NPY_NO_EXPORT void
FLOAT_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_bool *)op1) = npy_isnan(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
FLOAT_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_bool *)op1) = npy_isinf(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
FLOAT_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_bool *)op1) = npy_isfinite(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
FLOAT_signbit(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_bool *)op1) = npy_signbit(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#endif

NPY_NO_EXPORT void
FLOAT_spacing(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = npy_spacingf(in1);
    }
}

NPY_NO_EXPORT void
FLOAT_copysign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1)= npy_copysignf(in1, in2);
    }
}

NPY_NO_EXPORT void
FLOAT_nextafter(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1)= npy_nextafterf(in1, in2);
    }
}

NPY_NO_EXPORT void
FLOAT_floor_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1) = npy_floor_dividef(in1, in2);
    }
}

NPY_NO_EXPORT int
FLOAT_floor_divide_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_float *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_float *)(ip1 + is1 * indx);
        *indexed = npy_floor_dividef(*indexed, *(npy_float *)value);
    }
    return 0;
}

NPY_NO_EXPORT void
FLOAT_remainder(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *) op1) = npy_remainderf(in1, in2);
    }
}

NPY_NO_EXPORT void
FLOAT_divmod(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1) = npy_divmodf(in1, in2, (npy_float *)op2);
    }
}

NPY_NO_EXPORT void
FLOAT__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_float *)op1) = 1;
    }
}

NPY_NO_EXPORT void
FLOAT_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = in1;
    }
}

NPY_NO_EXPORT void
FLOAT_positive(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
FLOAT_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : (in1 == 0 ? 0 : in1));
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
FLOAT_modf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = npy_modff(in1, (npy_float *)op2);
    }
}

NPY_NO_EXPORT void
FLOAT_ldexp_long(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_float *)op1) = npy_ldexpf(in1, ((int)in2));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_float *)op1) = npy_ldexpf(in1, NPY_MAX_INT);
            }
            else {
                *((npy_float *)op1) = npy_ldexpf(in1, NPY_MIN_INT);
            }
        }
    }
}


#line 1152
#line 1156
NPY_NO_EXPORT void
DOUBLE_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_bool *)op1) = in1 && in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1156
NPY_NO_EXPORT void
DOUBLE_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_bool *)op1) = in1 || in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
DOUBLE_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_double *)ip1;
        const int t2 = !!*(npy_double *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}

NPY_NO_EXPORT void
DOUBLE_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_bool *)op1) = !in1;
    }
}

#if !1
#line 1192
NPY_NO_EXPORT void
DOUBLE_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_bool *)op1) = npy_isnan(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
DOUBLE_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_bool *)op1) = npy_isinf(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
DOUBLE_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_bool *)op1) = npy_isfinite(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
DOUBLE_signbit(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_bool *)op1) = npy_signbit(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#endif

NPY_NO_EXPORT void
DOUBLE_spacing(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = npy_spacing(in1);
    }
}

NPY_NO_EXPORT void
DOUBLE_copysign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1)= npy_copysign(in1, in2);
    }
}

NPY_NO_EXPORT void
DOUBLE_nextafter(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1)= npy_nextafter(in1, in2);
    }
}

NPY_NO_EXPORT void
DOUBLE_floor_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1) = npy_floor_divide(in1, in2);
    }
}

NPY_NO_EXPORT int
DOUBLE_floor_divide_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_double *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_double *)(ip1 + is1 * indx);
        *indexed = npy_floor_divide(*indexed, *(npy_double *)value);
    }
    return 0;
}

NPY_NO_EXPORT void
DOUBLE_remainder(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *) op1) = npy_remainder(in1, in2);
    }
}

NPY_NO_EXPORT void
DOUBLE_divmod(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1) = npy_divmod(in1, in2, (npy_double *)op2);
    }
}

NPY_NO_EXPORT void
DOUBLE__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_double *)op1) = 1;
    }
}

NPY_NO_EXPORT void
DOUBLE_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = in1;
    }
}

NPY_NO_EXPORT void
DOUBLE_positive(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
DOUBLE_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : (in1 == 0 ? 0 : in1));
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
DOUBLE_modf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = npy_modf(in1, (npy_double *)op2);
    }
}

NPY_NO_EXPORT void
DOUBLE_ldexp_long(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_double *)op1) = npy_ldexp(in1, ((int)in2));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_double *)op1) = npy_ldexp(in1, NPY_MAX_INT);
            }
            else {
                *((npy_double *)op1) = npy_ldexp(in1, NPY_MIN_INT);
            }
        }
    }
}


#line 1152
#line 1156
NPY_NO_EXPORT void
LONGDOUBLE_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 && in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1156
NPY_NO_EXPORT void
LONGDOUBLE_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 || in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
LONGDOUBLE_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_longdouble *)ip1;
        const int t2 = !!*(npy_longdouble *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_bool *)op1) = !in1;
    }
}

#if !0
#line 1192
NPY_NO_EXPORT void
LONGDOUBLE_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_bool *)op1) = npy_isnan(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
LONGDOUBLE_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_bool *)op1) = npy_isinf(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
LONGDOUBLE_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_bool *)op1) = npy_isfinite(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1192
NPY_NO_EXPORT void
LONGDOUBLE_signbit(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_bool *)op1) = npy_signbit(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#endif

NPY_NO_EXPORT void
LONGDOUBLE_spacing(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = npy_spacingl(in1);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_copysign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1)= npy_copysignl(in1, in2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_nextafter(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1)= npy_nextafterl(in1, in2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_floor_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1) = npy_floor_dividel(in1, in2);
    }
}

NPY_NO_EXPORT int
LONGDOUBLE_floor_divide_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        *indexed = npy_floor_dividel(*indexed, *(npy_longdouble *)value);
    }
    return 0;
}

NPY_NO_EXPORT void
LONGDOUBLE_remainder(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *) op1) = npy_remainderl(in1, in2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_divmod(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1) = npy_divmodl(in1, in2, (npy_longdouble *)op2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_longdouble *)op1) = 1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = in1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_positive(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : (in1 == 0 ? 0 : in1));
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
LONGDOUBLE_modf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = npy_modfl(in1, (npy_longdouble *)op2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_ldexp_long(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_longdouble *)op1) = npy_ldexpl(in1, ((int)in2));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_longdouble *)op1) = npy_ldexpl(in1, NPY_MAX_INT);
            }
            else {
                *((npy_longdouble *)op1) = npy_ldexpl(in1, NPY_MIN_INT);
            }
        }
    }
}



/*
 *****************************************************************************
 **                          LONGDOUBLE LOOPS                               **
 *****************************************************************************
 */

#line 1377
NPY_NO_EXPORT void
LONGDOUBLE_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 1
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 += LONGDOUBLE_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 += *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT int
LONGDOUBLE_add_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        *indexed = *indexed + *(npy_longdouble *)value;
    }
    return 0;
}


#line 1377
NPY_NO_EXPORT void
LONGDOUBLE_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 -= LONGDOUBLE_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 -= *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 - in2;
        }
    }
}

NPY_NO_EXPORT int
LONGDOUBLE_subtract_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        *indexed = *indexed - *(npy_longdouble *)value;
    }
    return 0;
}


#line 1377
NPY_NO_EXPORT void
LONGDOUBLE_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 *= LONGDOUBLE_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 *= *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 * in2;
        }
    }
}

NPY_NO_EXPORT int
LONGDOUBLE_multiply_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        *indexed = *indexed * *(npy_longdouble *)value;
    }
    return 0;
}


#line 1377
NPY_NO_EXPORT void
LONGDOUBLE_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 /= LONGDOUBLE_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 /= *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 / in2;
        }
    }
}

NPY_NO_EXPORT int
LONGDOUBLE_divide_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        *indexed = *indexed / *(npy_longdouble *)value;
    }
    return 0;
}



#line 1432
NPY_NO_EXPORT void
LONGDOUBLE_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 == in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1432
NPY_NO_EXPORT void
LONGDOUBLE_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 != in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1432
NPY_NO_EXPORT void
LONGDOUBLE_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 < in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1432
NPY_NO_EXPORT void
LONGDOUBLE_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 <= in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1432
NPY_NO_EXPORT void
LONGDOUBLE_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 > in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1432
NPY_NO_EXPORT void
LONGDOUBLE_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_bool *)op1) = in1 >= in2;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
LONGDOUBLE_reciprocal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble*)ip1;
        *((npy_longdouble *)op1) = 1/in1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_absolute(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble tmp = in1 > 0 ? in1 : -in1;
        /* add 0 to clear -0.0 */
        *((npy_longdouble *)op1) = tmp + 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
LONGDOUBLE_square(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = in1*in1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_frexp(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = npy_frexpl(in1, (int *)op2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_ldexp(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const int in2 = *(int *)ip2;
        *((npy_longdouble *)op1) = npy_ldexpl(in1, in2);
    }
}

/*
 *****************************************************************************
 **                          HALF-FLOAT LOOPS                               **
 *****************************************************************************
 */


#line 1506
NPY_NO_EXPORT void
HALF_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 1
        npy_intp n = dimensions[0];

        io1 += HALF_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 += npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 + in2);
        }
    }
}

NPY_NO_EXPORT int
HALF_add_indexed(void *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        const float v = npy_half_to_float(*(npy_half *)value);
        *indexed = npy_float_to_half(npy_half_to_float(*indexed) + v);
    }
    return 0;
}

#line 1506
NPY_NO_EXPORT void
HALF_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 0
        npy_intp n = dimensions[0];

        io1 -= HALF_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 -= npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 - in2);
        }
    }
}

NPY_NO_EXPORT int
HALF_subtract_indexed(void *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        const float v = npy_half_to_float(*(npy_half *)value);
        *indexed = npy_float_to_half(npy_half_to_float(*indexed) - v);
    }
    return 0;
}

#line 1506
NPY_NO_EXPORT void
HALF_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 0
        npy_intp n = dimensions[0];

        io1 *= HALF_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 *= npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 * in2);
        }
    }
}

NPY_NO_EXPORT int
HALF_multiply_indexed(void *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        const float v = npy_half_to_float(*(npy_half *)value);
        *indexed = npy_float_to_half(npy_half_to_float(*indexed) * v);
    }
    return 0;
}

#line 1506
NPY_NO_EXPORT void
HALF_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 0
        npy_intp n = dimensions[0];

        io1 /= HALF_pairwise_sum(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 /= npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 / in2);
        }
    }
}

NPY_NO_EXPORT int
HALF_divide_indexed(void *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        const float v = npy_half_to_float(*(npy_half *)value);
        *indexed = npy_float_to_half(npy_half_to_float(*indexed) / v);
    }
    return 0;
}


#define _HALF_LOGICAL_AND(a,b) (!npy_half_iszero(a) && !npy_half_iszero(b))
#define _HALF_LOGICAL_OR(a,b) (!npy_half_iszero(a) || !npy_half_iszero(b))
#line 1566
NPY_NO_EXPORT void
HALF_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_eq(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_ne(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_lt(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_le(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_gt(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_ge(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = _HALF_LOGICAL_AND(in1, in2);
    }
}

#line 1566
NPY_NO_EXPORT void
HALF_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = _HALF_LOGICAL_OR(in1, in2);
    }
}

#undef _HALF_LOGICAL_AND
#undef _HALF_LOGICAL_OR

NPY_NO_EXPORT void
HALF_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int in1 = !npy_half_iszero(*(npy_half *)ip1);
        const int in2 = !npy_half_iszero(*(npy_half *)ip2);
        *((npy_bool *)op1) = (in1 != in2);
    }
}

NPY_NO_EXPORT void
HALF_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_iszero(in1);
    }
}

#line 1602
NPY_NO_EXPORT void
HALF_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_isnan(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1602
NPY_NO_EXPORT void
HALF_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_isinf(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1602
NPY_NO_EXPORT void
HALF_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_isfinite(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1602
NPY_NO_EXPORT void
HALF_signbit(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_signbit(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
HALF_spacing(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = npy_half_spacing(in1);
    }
}

NPY_NO_EXPORT void
HALF_copysign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1)= npy_half_copysign(in1, in2);
    }
}

NPY_NO_EXPORT void
HALF_nextafter(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1)= npy_half_nextafter(in1, in2);
    }
}

#line 1646
NPY_NO_EXPORT void
HALF_maximum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_ge(in1, in2) || npy_half_isnan(in1)) ? in1 : in2;
    }
    /* npy_half_isnan will never set floatstatus_invalid, so do not clear */
}

NPY_NO_EXPORT int
HALF_maximum_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        npy_half v = *(npy_half *)value;
        *indexed = (npy_half_ge(*indexed, v) || npy_half_isnan(*indexed)) ? *indexed : v;
    }
    return 0;
}


#line 1646
NPY_NO_EXPORT void
HALF_minimum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_le(in1, in2) || npy_half_isnan(in1)) ? in1 : in2;
    }
    /* npy_half_isnan will never set floatstatus_invalid, so do not clear */
}

NPY_NO_EXPORT int
HALF_minimum_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        npy_half v = *(npy_half *)value;
        *indexed = (npy_half_le(*indexed, v) || npy_half_isnan(*indexed)) ? *indexed : v;
    }
    return 0;
}



#line 1689
NPY_NO_EXPORT void
HALF_fmax(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_ge(in1, in2) || npy_half_isnan(in2)) ? in1 : in2;
    }
    /* no need to clear floatstatus_invalid */
}

NPY_NO_EXPORT int
HALF_fmax_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for (i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        npy_half v = *(npy_half *)value;
        *indexed = (npy_half_ge(*indexed, v) || npy_half_isnan(v)) ? *indexed: v;
    }
    return 0;
}


#line 1689
NPY_NO_EXPORT void
HALF_fmin(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_le(in1, in2) || npy_half_isnan(in2)) ? in1 : in2;
    }
    /* no need to clear floatstatus_invalid */
}

NPY_NO_EXPORT int
HALF_fmin_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for (i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        npy_half v = *(npy_half *)value;
        *indexed = (npy_half_le(*indexed, v) || npy_half_isnan(v)) ? *indexed: v;
    }
    return 0;
}



NPY_NO_EXPORT void
HALF_floor_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;

        float fh1 = npy_half_to_float(in1);
        float fh2 = npy_half_to_float(in2);
        float div;

        div = npy_floor_dividef(fh1, fh2);
        *((npy_half *)op1) = npy_float_to_half(div);
    }
}

NPY_NO_EXPORT int
HALF_floor_divide_indexed(PyArrayMethod_Context *NPY_UNUSED(context),
         char **args, npy_intp const *dimensions, npy_intp const *steps,
         void *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_half *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_half *)(ip1 + is1 * indx);
        float v = npy_half_to_float(*(npy_half *)value);
        float div = npy_floor_dividef(npy_half_to_float(*indexed), v);
        *indexed = npy_float_to_half(div);
    }
    return 0;
}

NPY_NO_EXPORT void
HALF_remainder(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        float fh1 = npy_half_to_float(in1);
        float fh2 = npy_half_to_float(in2);
        float mod;
        mod = npy_remainderf(fh1, fh2);
        *((npy_half *)op1) = npy_float_to_half(mod);
    }
}

NPY_NO_EXPORT void
HALF_divmod(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = npy_half_divmod(in1, in2, (npy_half *)op2);
    }
}

NPY_NO_EXPORT void
HALF_square(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(in1*in1);
    }
}

NPY_NO_EXPORT void
HALF_reciprocal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(1/in1);
    }
}

NPY_NO_EXPORT void
HALF__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_half *)op1) = NPY_HALF_ONE;
    }
}

NPY_NO_EXPORT void
HALF_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = in1;
    }
}

NPY_NO_EXPORT void
HALF_negative(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = in1^0x8000u;
    }
}

NPY_NO_EXPORT void
HALF_positive(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
HALF_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = npy_half_isnan(in1) ? in1 :
                    (((in1&0x7fffu) == 0) ? 0 :
                      (((in1&0x8000u) == 0) ? NPY_HALF_ONE : NPY_HALF_NEGONE));
    }
}

NPY_NO_EXPORT void
HALF_modf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    float temp;

    UNARY_LOOP_TWO_OUT {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(npy_modff(in1, &temp));
        *((npy_half *)op2) = npy_float_to_half(temp);
    }
}

NPY_NO_EXPORT void
HALF_frexp(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(npy_frexpf(in1, (int *)op2));
    }
}

NPY_NO_EXPORT void
HALF_ldexp(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        const int in2 = *(int *)ip2;
        *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, in2));
    }
}

NPY_NO_EXPORT void
HALF_ldexp_long(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, ((int)in2)));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, NPY_MAX_INT));
            }
            else {
                *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, NPY_MIN_INT));
            }
        }
    }
}

/*
 *****************************************************************************
 **                           COMPLEX LOOPS                                 **
 *****************************************************************************
 */

#define CGE(xr,xi,yr,yi) ((xr > yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi >= yi))
#define CLE(xr,xi,yr,yi) ((xr < yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi <= yi))
#define CGT(xr,xi,yr,yi) ((xr > yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi > yi))
#define CLT(xr,xi,yr,yi) ((xr < yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi < yi))
#define CEQ(xr,xi,yr,yi) (xr == yr && xi == yi)
#define CNE(xr,xi,yr,yi) (xr != yr || xi != yi)

#line 1945

#if !1
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
#line 1954
NPY_NO_EXPORT void
CFLOAT_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    // Parenthesis around 1 tells clang dead code is intentional
    if (IS_BINARY_REDUCE && (1)) {
        npy_intp n = dimensions[0];
        npy_float * or = ((npy_float *)args[0]);
        npy_float * oi = ((npy_float *)args[0]) + 1;
        npy_float rr, ri;

        CFLOAT_pairwise_sum(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or += rr;
        *oi += ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_float in1r = ((npy_float *)ip1)[0];
            const npy_float in1i = ((npy_float *)ip1)[1];
            const npy_float in2r = ((npy_float *)ip2)[0];
            const npy_float in2i = ((npy_float *)ip2)[1];
            ((npy_float *)op1)[0] = in1r + in2r;
            ((npy_float *)op1)[1] = in1i + in2i;
        }
    }
}

NPY_NO_EXPORT int CFLOAT_add_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_float *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_float *)(ip1 + is1 * indx);
        const npy_float b_r = ((npy_float *)value)[0];
        const npy_float b_i = ((npy_float *)value)[1];
        indexed[0] += b_r;
        indexed[1] += b_i;
    }
    return 0;
}

#line 1954
NPY_NO_EXPORT void
CFLOAT_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    // Parenthesis around 0 tells clang dead code is intentional
    if (IS_BINARY_REDUCE && (0)) {
        npy_intp n = dimensions[0];
        npy_float * or = ((npy_float *)args[0]);
        npy_float * oi = ((npy_float *)args[0]) + 1;
        npy_float rr, ri;

        CFLOAT_pairwise_sum(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or -= rr;
        *oi -= ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_float in1r = ((npy_float *)ip1)[0];
            const npy_float in1i = ((npy_float *)ip1)[1];
            const npy_float in2r = ((npy_float *)ip2)[0];
            const npy_float in2i = ((npy_float *)ip2)[1];
            ((npy_float *)op1)[0] = in1r - in2r;
            ((npy_float *)op1)[1] = in1i - in2i;
        }
    }
}

NPY_NO_EXPORT int CFLOAT_subtract_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_float *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_float *)(ip1 + is1 * indx);
        const npy_float b_r = ((npy_float *)value)[0];
        const npy_float b_i = ((npy_float *)value)[1];
        indexed[0] -= b_r;
        indexed[1] -= b_i;
    }
    return 0;
}


NPY_NO_EXPORT void
CFLOAT_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        ((npy_float *)op1)[0] = in1r*in2r - in1i*in2i;
        ((npy_float *)op1)[1] = in1r*in2i + in1i*in2r;
    }
}

NPY_NO_EXPORT int CFLOAT_multiply_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_float *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_float *)(ip1 + is1 * indx);
        const npy_float a_r = indexed[0];
        const npy_float a_i = indexed[1];
        const npy_float b_r = ((npy_float *)value)[0];
        const npy_float b_i = ((npy_float *)value)[1];
        indexed[0] = a_r*b_r - a_i*b_i;
        indexed[1] = a_r*b_i + a_i*b_r;
    }
    return 0;
}
#endif // !SIMD

NPY_NO_EXPORT void
CFLOAT_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        const npy_float in2r_abs = npy_fabsf(in2r);
        const npy_float in2i_abs = npy_fabsf(in2i);
        if (in2r_abs >= in2i_abs) {
            if (in2r_abs == 0 && in2i_abs == 0) {
                /* divide by zero should yield a complex inf or nan */
                ((npy_float *)op1)[0] = in1r/in2r_abs;
                ((npy_float *)op1)[1] = in1i/in2i_abs;
            }
            else {
                const npy_float rat = in2i/in2r;
                const npy_float scl = 1.0f/(in2r + in2i*rat);
                ((npy_float *)op1)[0] = (in1r + in1i*rat)*scl;
                ((npy_float *)op1)[1] = (in1i - in1r*rat)*scl;
            }
        }
        else {
            const npy_float rat = in2r/in2i;
            const npy_float scl = 1.0f/(in2i + in2r*rat);
            ((npy_float *)op1)[0] = (in1r*rat + in1i)*scl;
            ((npy_float *)op1)[1] = (in1i*rat - in1r)*scl;
        }
    }
}


#line 2085
NPY_NO_EXPORT void
CFLOAT_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CGT(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CFLOAT_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CGE(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CFLOAT_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CLT(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CFLOAT_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CLE(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CFLOAT_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CEQ(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CFLOAT_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CNE(in1r,in1i,in2r,in2i);
    }
}


#line 2103
NPY_NO_EXPORT void
CFLOAT_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) && (in2r || in2i);
    }
}

#line 2103
NPY_NO_EXPORT void
CFLOAT_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) || (in2r || in2i);
    }
}


NPY_NO_EXPORT void
CFLOAT_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        const npy_bool tmp1 = (in1r || in1i);
        const npy_bool tmp2 = (in2r || in2i);
        *((npy_bool *)op1) = tmp1 != tmp2;
    }
}

NPY_NO_EXPORT void
CFLOAT_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = !(in1r || in1i);
    }
}

#line 2145
NPY_NO_EXPORT void
CFLOAT_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = npy_isnan(in1r) || npy_isnan(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2145
NPY_NO_EXPORT void
CFLOAT_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = npy_isinf(in1r) || npy_isinf(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2145
NPY_NO_EXPORT void
CFLOAT_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = npy_isfinite(in1r) && npy_isfinite(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#if !1
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
NPY_NO_EXPORT void
CFLOAT_square(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        ((npy_float *)op1)[0] = in1r*in1r - in1i*in1i;
        ((npy_float *)op1)[1] = in1r*in1i + in1i*in1r;
    }
}
#endif

NPY_NO_EXPORT void
CFLOAT_reciprocal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        if (npy_fabsf(in1i) <= npy_fabsf(in1r)) {
            const npy_float r = in1i/in1r;
            const npy_float d = in1r + in1i*r;
            ((npy_float *)op1)[0] = 1/d;
            ((npy_float *)op1)[1] = -r/d;
        } else {
            const npy_float r = in1r/in1i;
            const npy_float d = in1r*r + in1i;
            ((npy_float *)op1)[0] = r/d;
            ((npy_float *)op1)[1] = -1/d;
        }
    }
}

NPY_NO_EXPORT void
CFLOAT__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        ((npy_float *)op1)[0] = 1;
        ((npy_float *)op1)[1] = 0;
    }
}

#if !1
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
NPY_NO_EXPORT void
CFLOAT_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        ((npy_float *)op1)[0] = in1r;
        ((npy_float *)op1)[1] = -in1i;
    }
}

NPY_NO_EXPORT void
CFLOAT_absolute(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_float *)op1) = npy_hypotf(in1r, in1i);
    }
}
#endif

NPY_NO_EXPORT void
CFLOAT__arg(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_float *)op1) = npy_atan2f(in1i, in1r);
    }
}

NPY_NO_EXPORT void
CFLOAT_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* fixme: sign of nan is currently 0 */
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        ((npy_float *)op1)[0] = CGT(in1r, in1i, 0.0, 0.0) ?  1 :
                            (CLT(in1r, in1i, 0.0, 0.0) ? -1 :
                            (CEQ(in1r, in1i, 0.0, 0.0) ?  0 : NPY_NANF));
        ((npy_float *)op1)[1] = 0;
    }
}

#line 2251
NPY_NO_EXPORT void
CFLOAT_maximum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_float in1r = ((npy_float *)ip1)[0];
        npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CGE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_float *)op1)[0] = in1r;
        ((npy_float *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2251
NPY_NO_EXPORT void
CFLOAT_minimum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_float in1r = ((npy_float *)ip1)[0];
        npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CLE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_float *)op1)[0] = in1r;
        ((npy_float *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 2274
NPY_NO_EXPORT void
CFLOAT_fmax(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CGE(in1r, in1i, in2r, in2i)) {
            ((npy_float *)op1)[0] = in1r;
            ((npy_float *)op1)[1] = in1i;
        }
        else {
            ((npy_float *)op1)[0] = in2r;
            ((npy_float *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2274
NPY_NO_EXPORT void
CFLOAT_fmin(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CLE(in1r, in1i, in2r, in2i)) {
            ((npy_float *)op1)[0] = in1r;
            ((npy_float *)op1)[1] = in1i;
        }
        else {
            ((npy_float *)op1)[0] = in2r;
            ((npy_float *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}



#line 1945

#if !1
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
#line 1954
NPY_NO_EXPORT void
CDOUBLE_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    // Parenthesis around 1 tells clang dead code is intentional
    if (IS_BINARY_REDUCE && (1)) {
        npy_intp n = dimensions[0];
        npy_double * or = ((npy_double *)args[0]);
        npy_double * oi = ((npy_double *)args[0]) + 1;
        npy_double rr, ri;

        CDOUBLE_pairwise_sum(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or += rr;
        *oi += ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_double in1r = ((npy_double *)ip1)[0];
            const npy_double in1i = ((npy_double *)ip1)[1];
            const npy_double in2r = ((npy_double *)ip2)[0];
            const npy_double in2i = ((npy_double *)ip2)[1];
            ((npy_double *)op1)[0] = in1r + in2r;
            ((npy_double *)op1)[1] = in1i + in2i;
        }
    }
}

NPY_NO_EXPORT int CDOUBLE_add_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_double *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_double *)(ip1 + is1 * indx);
        const npy_double b_r = ((npy_double *)value)[0];
        const npy_double b_i = ((npy_double *)value)[1];
        indexed[0] += b_r;
        indexed[1] += b_i;
    }
    return 0;
}

#line 1954
NPY_NO_EXPORT void
CDOUBLE_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    // Parenthesis around 0 tells clang dead code is intentional
    if (IS_BINARY_REDUCE && (0)) {
        npy_intp n = dimensions[0];
        npy_double * or = ((npy_double *)args[0]);
        npy_double * oi = ((npy_double *)args[0]) + 1;
        npy_double rr, ri;

        CDOUBLE_pairwise_sum(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or -= rr;
        *oi -= ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_double in1r = ((npy_double *)ip1)[0];
            const npy_double in1i = ((npy_double *)ip1)[1];
            const npy_double in2r = ((npy_double *)ip2)[0];
            const npy_double in2i = ((npy_double *)ip2)[1];
            ((npy_double *)op1)[0] = in1r - in2r;
            ((npy_double *)op1)[1] = in1i - in2i;
        }
    }
}

NPY_NO_EXPORT int CDOUBLE_subtract_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_double *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_double *)(ip1 + is1 * indx);
        const npy_double b_r = ((npy_double *)value)[0];
        const npy_double b_i = ((npy_double *)value)[1];
        indexed[0] -= b_r;
        indexed[1] -= b_i;
    }
    return 0;
}


NPY_NO_EXPORT void
CDOUBLE_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        ((npy_double *)op1)[0] = in1r*in2r - in1i*in2i;
        ((npy_double *)op1)[1] = in1r*in2i + in1i*in2r;
    }
}

NPY_NO_EXPORT int CDOUBLE_multiply_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_double *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_double *)(ip1 + is1 * indx);
        const npy_double a_r = indexed[0];
        const npy_double a_i = indexed[1];
        const npy_double b_r = ((npy_double *)value)[0];
        const npy_double b_i = ((npy_double *)value)[1];
        indexed[0] = a_r*b_r - a_i*b_i;
        indexed[1] = a_r*b_i + a_i*b_r;
    }
    return 0;
}
#endif // !SIMD

NPY_NO_EXPORT void
CDOUBLE_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        const npy_double in2r_abs = npy_fabs(in2r);
        const npy_double in2i_abs = npy_fabs(in2i);
        if (in2r_abs >= in2i_abs) {
            if (in2r_abs == 0 && in2i_abs == 0) {
                /* divide by zero should yield a complex inf or nan */
                ((npy_double *)op1)[0] = in1r/in2r_abs;
                ((npy_double *)op1)[1] = in1i/in2i_abs;
            }
            else {
                const npy_double rat = in2i/in2r;
                const npy_double scl = 1.0/(in2r + in2i*rat);
                ((npy_double *)op1)[0] = (in1r + in1i*rat)*scl;
                ((npy_double *)op1)[1] = (in1i - in1r*rat)*scl;
            }
        }
        else {
            const npy_double rat = in2r/in2i;
            const npy_double scl = 1.0/(in2i + in2r*rat);
            ((npy_double *)op1)[0] = (in1r*rat + in1i)*scl;
            ((npy_double *)op1)[1] = (in1i*rat - in1r)*scl;
        }
    }
}


#line 2085
NPY_NO_EXPORT void
CDOUBLE_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CGT(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CDOUBLE_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CGE(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CDOUBLE_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CLT(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CDOUBLE_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CLE(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CDOUBLE_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CEQ(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CDOUBLE_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CNE(in1r,in1i,in2r,in2i);
    }
}


#line 2103
NPY_NO_EXPORT void
CDOUBLE_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) && (in2r || in2i);
    }
}

#line 2103
NPY_NO_EXPORT void
CDOUBLE_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) || (in2r || in2i);
    }
}


NPY_NO_EXPORT void
CDOUBLE_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        const npy_bool tmp1 = (in1r || in1i);
        const npy_bool tmp2 = (in2r || in2i);
        *((npy_bool *)op1) = tmp1 != tmp2;
    }
}

NPY_NO_EXPORT void
CDOUBLE_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = !(in1r || in1i);
    }
}

#line 2145
NPY_NO_EXPORT void
CDOUBLE_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = npy_isnan(in1r) || npy_isnan(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2145
NPY_NO_EXPORT void
CDOUBLE_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = npy_isinf(in1r) || npy_isinf(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2145
NPY_NO_EXPORT void
CDOUBLE_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = npy_isfinite(in1r) && npy_isfinite(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#if !1
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
NPY_NO_EXPORT void
CDOUBLE_square(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        ((npy_double *)op1)[0] = in1r*in1r - in1i*in1i;
        ((npy_double *)op1)[1] = in1r*in1i + in1i*in1r;
    }
}
#endif

NPY_NO_EXPORT void
CDOUBLE_reciprocal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        if (npy_fabs(in1i) <= npy_fabs(in1r)) {
            const npy_double r = in1i/in1r;
            const npy_double d = in1r + in1i*r;
            ((npy_double *)op1)[0] = 1/d;
            ((npy_double *)op1)[1] = -r/d;
        } else {
            const npy_double r = in1r/in1i;
            const npy_double d = in1r*r + in1i;
            ((npy_double *)op1)[0] = r/d;
            ((npy_double *)op1)[1] = -1/d;
        }
    }
}

NPY_NO_EXPORT void
CDOUBLE__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        ((npy_double *)op1)[0] = 1;
        ((npy_double *)op1)[1] = 0;
    }
}

#if !1
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
NPY_NO_EXPORT void
CDOUBLE_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        ((npy_double *)op1)[0] = in1r;
        ((npy_double *)op1)[1] = -in1i;
    }
}

NPY_NO_EXPORT void
CDOUBLE_absolute(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_double *)op1) = npy_hypot(in1r, in1i);
    }
}
#endif

NPY_NO_EXPORT void
CDOUBLE__arg(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_double *)op1) = npy_atan2(in1i, in1r);
    }
}

NPY_NO_EXPORT void
CDOUBLE_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* fixme: sign of nan is currently 0 */
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        ((npy_double *)op1)[0] = CGT(in1r, in1i, 0.0, 0.0) ?  1 :
                            (CLT(in1r, in1i, 0.0, 0.0) ? -1 :
                            (CEQ(in1r, in1i, 0.0, 0.0) ?  0 : NPY_NAN));
        ((npy_double *)op1)[1] = 0;
    }
}

#line 2251
NPY_NO_EXPORT void
CDOUBLE_maximum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_double in1r = ((npy_double *)ip1)[0];
        npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CGE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_double *)op1)[0] = in1r;
        ((npy_double *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2251
NPY_NO_EXPORT void
CDOUBLE_minimum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_double in1r = ((npy_double *)ip1)[0];
        npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CLE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_double *)op1)[0] = in1r;
        ((npy_double *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 2274
NPY_NO_EXPORT void
CDOUBLE_fmax(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CGE(in1r, in1i, in2r, in2i)) {
            ((npy_double *)op1)[0] = in1r;
            ((npy_double *)op1)[1] = in1i;
        }
        else {
            ((npy_double *)op1)[0] = in2r;
            ((npy_double *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2274
NPY_NO_EXPORT void
CDOUBLE_fmin(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CLE(in1r, in1i, in2r, in2i)) {
            ((npy_double *)op1)[0] = in1r;
            ((npy_double *)op1)[1] = in1i;
        }
        else {
            ((npy_double *)op1)[0] = in2r;
            ((npy_double *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}



#line 1945

#if !0
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
#line 1954
NPY_NO_EXPORT void
CLONGDOUBLE_add(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    // Parenthesis around 1 tells clang dead code is intentional
    if (IS_BINARY_REDUCE && (1)) {
        npy_intp n = dimensions[0];
        npy_longdouble * or = ((npy_longdouble *)args[0]);
        npy_longdouble * oi = ((npy_longdouble *)args[0]) + 1;
        npy_longdouble rr, ri;

        CLONGDOUBLE_pairwise_sum(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or += rr;
        *oi += ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
            const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
            const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
            const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
            ((npy_longdouble *)op1)[0] = in1r + in2r;
            ((npy_longdouble *)op1)[1] = in1i + in2i;
        }
    }
}

NPY_NO_EXPORT int CLONGDOUBLE_add_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        const npy_longdouble b_r = ((npy_longdouble *)value)[0];
        const npy_longdouble b_i = ((npy_longdouble *)value)[1];
        indexed[0] += b_r;
        indexed[1] += b_i;
    }
    return 0;
}

#line 1954
NPY_NO_EXPORT void
CLONGDOUBLE_subtract(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    // Parenthesis around 0 tells clang dead code is intentional
    if (IS_BINARY_REDUCE && (0)) {
        npy_intp n = dimensions[0];
        npy_longdouble * or = ((npy_longdouble *)args[0]);
        npy_longdouble * oi = ((npy_longdouble *)args[0]) + 1;
        npy_longdouble rr, ri;

        CLONGDOUBLE_pairwise_sum(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or -= rr;
        *oi -= ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
            const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
            const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
            const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
            ((npy_longdouble *)op1)[0] = in1r - in2r;
            ((npy_longdouble *)op1)[1] = in1i - in2i;
        }
    }
}

NPY_NO_EXPORT int CLONGDOUBLE_subtract_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        const npy_longdouble b_r = ((npy_longdouble *)value)[0];
        const npy_longdouble b_i = ((npy_longdouble *)value)[1];
        indexed[0] -= b_r;
        indexed[1] -= b_i;
    }
    return 0;
}


NPY_NO_EXPORT void
CLONGDOUBLE_multiply(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        ((npy_longdouble *)op1)[0] = in1r*in2r - in1i*in2i;
        ((npy_longdouble *)op1)[1] = in1r*in2i + in1i*in2r;
    }
}

NPY_NO_EXPORT int CLONGDOUBLE_multiply_indexed
(PyArrayMethod_Context *NPY_UNUSED(context), char * const*args, npy_intp const *dimensions, npy_intp const *steps, NpyAuxData *NPY_UNUSED(func))
{
    char *ip1 = args[0];
    char *indxp = args[1];
    char *value = args[2];
    npy_intp is1 = steps[0], isindex = steps[1], isb = steps[2];
    npy_intp shape = steps[3];
    npy_intp n = dimensions[0];
    npy_intp i;
    npy_longdouble *indexed;
    for(i = 0; i < n; i++, indxp += isindex, value += isb) {
        npy_intp indx = *(npy_intp *)indxp;
        if (indx < 0) {
            indx += shape;
        }
        indexed = (npy_longdouble *)(ip1 + is1 * indx);
        const npy_longdouble a_r = indexed[0];
        const npy_longdouble a_i = indexed[1];
        const npy_longdouble b_r = ((npy_longdouble *)value)[0];
        const npy_longdouble b_i = ((npy_longdouble *)value)[1];
        indexed[0] = a_r*b_r - a_i*b_i;
        indexed[1] = a_r*b_i + a_i*b_r;
    }
    return 0;
}
#endif // !SIMD

NPY_NO_EXPORT void
CLONGDOUBLE_divide(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        const npy_longdouble in2r_abs = npy_fabsl(in2r);
        const npy_longdouble in2i_abs = npy_fabsl(in2i);
        if (in2r_abs >= in2i_abs) {
            if (in2r_abs == 0 && in2i_abs == 0) {
                /* divide by zero should yield a complex inf or nan */
                ((npy_longdouble *)op1)[0] = in1r/in2r_abs;
                ((npy_longdouble *)op1)[1] = in1i/in2i_abs;
            }
            else {
                const npy_longdouble rat = in2i/in2r;
                const npy_longdouble scl = 1.0l/(in2r + in2i*rat);
                ((npy_longdouble *)op1)[0] = (in1r + in1i*rat)*scl;
                ((npy_longdouble *)op1)[1] = (in1i - in1r*rat)*scl;
            }
        }
        else {
            const npy_longdouble rat = in2r/in2i;
            const npy_longdouble scl = 1.0l/(in2i + in2r*rat);
            ((npy_longdouble *)op1)[0] = (in1r*rat + in1i)*scl;
            ((npy_longdouble *)op1)[1] = (in1i*rat - in1r)*scl;
        }
    }
}


#line 2085
NPY_NO_EXPORT void
CLONGDOUBLE_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CGT(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CLONGDOUBLE_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CGE(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CLONGDOUBLE_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CLT(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CLONGDOUBLE_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CLE(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CLONGDOUBLE_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CEQ(in1r,in1i,in2r,in2i);
    }
}

#line 2085
NPY_NO_EXPORT void
CLONGDOUBLE_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CNE(in1r,in1i,in2r,in2i);
    }
}


#line 2103
NPY_NO_EXPORT void
CLONGDOUBLE_logical_and(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) && (in2r || in2i);
    }
}

#line 2103
NPY_NO_EXPORT void
CLONGDOUBLE_logical_or(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) || (in2r || in2i);
    }
}


NPY_NO_EXPORT void
CLONGDOUBLE_logical_xor(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        const npy_bool tmp1 = (in1r || in1i);
        const npy_bool tmp2 = (in2r || in2i);
        *((npy_bool *)op1) = tmp1 != tmp2;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_logical_not(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = !(in1r || in1i);
    }
}

#line 2145
NPY_NO_EXPORT void
CLONGDOUBLE_isnan(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = npy_isnan(in1r) || npy_isnan(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2145
NPY_NO_EXPORT void
CLONGDOUBLE_isinf(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = npy_isinf(in1r) || npy_isinf(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2145
NPY_NO_EXPORT void
CLONGDOUBLE_isfinite(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = npy_isfinite(in1r) && npy_isfinite(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#if !0
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
NPY_NO_EXPORT void
CLONGDOUBLE_square(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        ((npy_longdouble *)op1)[0] = in1r*in1r - in1i*in1i;
        ((npy_longdouble *)op1)[1] = in1r*in1i + in1i*in1r;
    }
}
#endif

NPY_NO_EXPORT void
CLONGDOUBLE_reciprocal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        if (npy_fabsl(in1i) <= npy_fabsl(in1r)) {
            const npy_longdouble r = in1i/in1r;
            const npy_longdouble d = in1r + in1i*r;
            ((npy_longdouble *)op1)[0] = 1/d;
            ((npy_longdouble *)op1)[1] = -r/d;
        } else {
            const npy_longdouble r = in1r/in1i;
            const npy_longdouble d = in1r*r + in1i;
            ((npy_longdouble *)op1)[0] = r/d;
            ((npy_longdouble *)op1)[1] = -1/d;
        }
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE__ones_like(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        ((npy_longdouble *)op1)[0] = 1;
        ((npy_longdouble *)op1)[1] = 0;
    }
}

#if !0
// CFLOAT & CDOUBLE defined by 'loops_arithm_fp.dispatch.c.src'
NPY_NO_EXPORT void
CLONGDOUBLE_conjugate(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        ((npy_longdouble *)op1)[0] = in1r;
        ((npy_longdouble *)op1)[1] = -in1i;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_absolute(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_longdouble *)op1) = npy_hypotl(in1r, in1i);
    }
}
#endif

NPY_NO_EXPORT void
CLONGDOUBLE__arg(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_longdouble *)op1) = npy_atan2l(in1i, in1r);
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    /* fixme: sign of nan is currently 0 */
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        ((npy_longdouble *)op1)[0] = CGT(in1r, in1i, 0.0, 0.0) ?  1 :
                            (CLT(in1r, in1i, 0.0, 0.0) ? -1 :
                            (CEQ(in1r, in1i, 0.0, 0.0) ?  0 : NPY_NANL));
        ((npy_longdouble *)op1)[1] = 0;
    }
}

#line 2251
NPY_NO_EXPORT void
CLONGDOUBLE_maximum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CGE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_longdouble *)op1)[0] = in1r;
        ((npy_longdouble *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2251
NPY_NO_EXPORT void
CLONGDOUBLE_minimum(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CLE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_longdouble *)op1)[0] = in1r;
        ((npy_longdouble *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 2274
NPY_NO_EXPORT void
CLONGDOUBLE_fmax(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CGE(in1r, in1i, in2r, in2i)) {
            ((npy_longdouble *)op1)[0] = in1r;
            ((npy_longdouble *)op1)[1] = in1i;
        }
        else {
            ((npy_longdouble *)op1)[0] = in2r;
            ((npy_longdouble *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2274
NPY_NO_EXPORT void
CLONGDOUBLE_fmin(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CLE(in1r, in1i, in2r, in2i)) {
            ((npy_longdouble *)op1)[0] = in1r;
            ((npy_longdouble *)op1)[1] = in1i;
        }
        else {
            ((npy_longdouble *)op1)[0] = in2r;
            ((npy_longdouble *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}




#undef CGE
#undef CLE
#undef CGT
#undef CLT
#undef CEQ
#undef CNE

/*
 *****************************************************************************
 **                            OBJECT LOOPS                                 **
 *****************************************************************************
 */

#line 2315

#line 2320
NPY_NO_EXPORT void
OBJECT_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_EQ);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2320
NPY_NO_EXPORT void
OBJECT_OO_O_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_EQ);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2315

#line 2320
NPY_NO_EXPORT void
OBJECT_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_NE);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2320
NPY_NO_EXPORT void
OBJECT_OO_O_not_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_NE);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2315

#line 2320
NPY_NO_EXPORT void
OBJECT_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GT);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2320
NPY_NO_EXPORT void
OBJECT_OO_O_greater(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GT);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2315

#line 2320
NPY_NO_EXPORT void
OBJECT_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GE);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2320
NPY_NO_EXPORT void
OBJECT_OO_O_greater_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GE);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2315

#line 2320
NPY_NO_EXPORT void
OBJECT_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LT);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2320
NPY_NO_EXPORT void
OBJECT_OO_O_less(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LT);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2315

#line 2320
NPY_NO_EXPORT void
OBJECT_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LE);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2320
NPY_NO_EXPORT void
OBJECT_OO_O_less_equal(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LE);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}



NPY_NO_EXPORT void
OBJECT_sign(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(func))
{
    PyObject *zero = PyLong_FromLong(0);

    UNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject **out = (PyObject **)op1;
        PyObject *ret = NULL;
        int v;

        if (in1 == NULL) {
            in1 = Py_None;
        }

        if ((v = PyObject_RichCompareBool(in1, zero, Py_LT)) == 1) {
            ret = PyLong_FromLong(-1);
        }
        else if (v == 0 &&
                (v = PyObject_RichCompareBool(in1, zero, Py_GT)) == 1) {
            ret = PyLong_FromLong(1);
        }
        else if (v == 0 &&
                (v = PyObject_RichCompareBool(in1, zero, Py_EQ)) == 1) {
            ret = PyLong_FromLong(0);
        }
        else if (v == 0) {
            /* in1 is NaN */
            PyErr_SetString(PyExc_TypeError,
                    "unorderable types for comparison");
        }

        if (ret == NULL) {
            break;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
    Py_XDECREF(zero);
}

/*
 *****************************************************************************
 **                              END LOOPS                                  **
 *****************************************************************************
 */

