// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
#ifndef RUNTIME_VM_COMPILER_RUNTIME_OFFSETS_EXTRACTED_H_
#define RUNTIME_VM_COMPILER_RUNTIME_OFFSETS_EXTRACTED_H_

#include "platform/globals.h"

// The constants below correspond to the macros in runtime_offsets_list.h.

// This file was generated by ./tools/run_offsets_extractor.dart.
// It's checked in, rather than being generated as part of the build, because
// simarm_x64 needs 32-bit arm offsets, but is built on a 64-bit machine and
// offsets_extractor only extracts offsets for the host architecture. This
// file needs to be regenerated when the offsets change, which is usually
// detected by CheckOffsets() in dart.cc.

#if !defined(PRODUCT) && defined(TARGET_ARCH_ARM) &&                           \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x38;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x48;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x10;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x4;
static constexpr dart::compiler::target::word Array_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x60;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x10;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x8;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x14;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word Array_data_offset = 0xc;
static constexpr dart::compiler::target::word Array_length_offset = 0x8;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x34;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x60;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x2c;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x6c;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x4;
static constexpr dart::compiler::target::word Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x10;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x18;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x14;
static constexpr dart::compiler::target::word Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x28;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x18;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x2c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word Function_code_offset = 0x20;
static constexpr dart::compiler::target::word Function_data_offset = 0x18;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x4, 0x8};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x40;
static constexpr dart::compiler::target::word Function_signature_offset = 0x14;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x1c;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x20;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x14;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x1c;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x10;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x18;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x1c;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x10;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x8;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x8;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x10;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0xc;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x4;
static constexpr dart::compiler::target::word NativeArguments_argv_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0xc;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0xc0;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0xd4;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0xc;
static constexpr dart::compiler::target::word Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x8;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x4;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x4;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x18;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x8;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x1c;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0xc;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x3c0;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x3c4;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x3e0;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x40;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x3c;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x408;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x3e4;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x40c;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x130;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0xdc;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x160;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x3d4;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x164;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x3c8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x3dc;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x384;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x388;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x30;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x39c;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x3a0;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0x64;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0xb4;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0xb8;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x38;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x3cc;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x3d0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x3d8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x3fc;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x1c;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x38c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x390;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x11c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x398;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x35c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x360;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x358;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x364;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x368;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x36c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x370;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x374;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x378;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x37c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x394;
static constexpr dart::compiler::target::word Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x10;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x3b0;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x3a8;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x3e8;
static constexpr dart::compiler::target::word Thread_random_offset = 0x3f0;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x3f8;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x4;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0xc;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x10;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x18;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0xc;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset = 0xc;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x4;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x1a;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0xc;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x4;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataBase_length_offset = 0x8;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0xc;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x8;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x4;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x338, 0x33c, 0x340, 0x344, 0x348, -1, 0x34c, -1,
        0x350, 0x354, -1,    -1,    -1,    -1, -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x14;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Array_header_size = 0xc;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x78;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x14;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0xc;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x3c;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x58;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x20;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x50;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x4;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x10;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x14;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x8;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x1c;
static constexpr dart::compiler::target::word String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x14;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0xc;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x14;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0xc;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0xc;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                           \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x70;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Array_element_size = 0x8;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0xb0;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x50;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x8;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fffffffffff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fffffffffff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x20;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x20;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x28;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word Array_data_offset = 0x18;
static constexpr dart::compiler::target::word Array_length_offset = 0x10;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x68;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0xb0;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x58;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0xbc;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word Closure_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x20;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x48;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x54;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x30;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x4c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x56;
static constexpr dart::compiler::target::word Function_code_offset = 0x40;
static constexpr dart::compiler::target::word Function_data_offset = 0x30;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x68;
static constexpr dart::compiler::target::word Function_signature_offset = 0x28;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x10;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x18;
static constexpr dart::compiler::target::word Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x30;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x38;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x780;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x788;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x7c0;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x80;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x800;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x7c8;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x808;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c0;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7a8;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x790;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x7b8;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x720;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x728;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x60;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x170;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x798;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7a0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7b0;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x7e8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x730;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x6c8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x740;
static constexpr dart::compiler::target::word Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x770;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x768;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x7d0;
static constexpr dart::compiler::target::word Thread_random_offset = 0x7d8;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x7e0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x30;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x20;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x32;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x20;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x20;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x10;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, -1,    -1,    0x690, 0x698,
        0x6a0, 0x6a8, 0x6b0, -1,    0x6b8, 0x6c0, -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x18;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0xc8;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x38;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x28;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x18;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x80;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x50;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x60;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x98;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x28;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x30;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x50;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x38;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x28;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x38;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x28;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x18;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x18;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_X64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_IA32) &&                          \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x38;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x48;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x10;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x4;
static constexpr dart::compiler::target::word Array_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x60;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x24;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x8;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x14;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word Array_data_offset = 0xc;
static constexpr dart::compiler::target::word Array_length_offset = 0x8;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x34;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x60;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x2c;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x6c;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x4;
static constexpr dart::compiler::target::word Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x10;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x18;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x14;
static constexpr dart::compiler::target::word Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x28;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x18;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x2c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word Function_code_offset = 0x20;
static constexpr dart::compiler::target::word Function_data_offset = 0x18;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x4, 0x8};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x40;
static constexpr dart::compiler::target::word Function_signature_offset = 0x14;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x1c;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x20;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x14;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x1c;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x10;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x18;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x1c;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x10;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x8;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x8;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x10;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0xc;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x4;
static constexpr dart::compiler::target::word NativeArguments_argv_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0xc;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0xc0;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0xd4;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0xc;
static constexpr dart::compiler::target::word Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x8;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x4;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x4;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x18;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x8;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x1c;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0xc;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x3b0;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x3b4;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x3d0;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x40;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x3c;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x3f8;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x3d4;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x3fc;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x130;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0xdc;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x160;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x3c4;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x164;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x3b8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x3cc;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x378;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x37c;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x30;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x390;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x394;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0x64;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0xb4;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0xb8;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x38;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x3bc;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x3c0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x3c8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x3ec;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x1c;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x380;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x384;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x11c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x38c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x350;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x354;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x34c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x358;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x35c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x360;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x364;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x368;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x36c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x370;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x374;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x388;
static constexpr dart::compiler::target::word Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x10;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x3a0;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x39c;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x3d8;
static constexpr dart::compiler::target::word Thread_random_offset = 0x3e0;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x3e8;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x4;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0xc;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x10;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x18;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0xc;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset = 0xc;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x4;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x1a;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0xc;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x4;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataBase_length_offset = 0x8;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0xc;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x8;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x4;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x338, 0x33c, 0x340, 0x344, -1, -1, -1, 0x348};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x14;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Array_header_size = 0xc;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x78;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x14;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0xc;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x3c;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x58;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x20;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x50;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x4;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x10;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x14;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x8;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x1c;
static constexpr dart::compiler::target::word String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x14;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0xc;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x14;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0xc;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0xc;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_IA32) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_ARM64) &&                         \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x70;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Array_element_size = 0x8;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0xb0;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x50;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x8;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x34;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x18;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fffffffffff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fffffffffff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x20;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x20;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x28;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word Array_data_offset = 0x18;
static constexpr dart::compiler::target::word Array_length_offset = 0x10;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x68;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0xb0;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x58;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0xbc;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word Closure_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x20;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x48;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x54;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x30;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x4c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x56;
static constexpr dart::compiler::target::word Function_code_offset = 0x40;
static constexpr dart::compiler::target::word Function_data_offset = 0x30;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x68;
static constexpr dart::compiler::target::word Function_signature_offset = 0x28;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x10;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x18;
static constexpr dart::compiler::target::word Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x30;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x38;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x7c8;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x7d0;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x808;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x80;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x848;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x810;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x850;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c0;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7f0;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x7d8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x800;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x768;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x770;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x60;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x798;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x170;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7e0;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7e8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x830;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x778;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x780;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x790;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x760;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x788;
static constexpr dart::compiler::target::word Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x7b8;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x7b0;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x818;
static constexpr dart::compiler::target::word Thread_random_offset = 0x820;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x828;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x30;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x20;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x32;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x20;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x20;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x10;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, 0x690, 0x698, 0x6a0, 0x6a8,
        0x6b0, 0x6b8, 0x6c0, 0x6c8, 0x6d0, 0x6d8, 0x6e0, -1,
        -1,    -1,    -1,    0x6e8, 0x6f0, -1,    -1,    0x6f8,
        0x700, 0x708, -1,    -1,    -1,    -1,    -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x18;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0xc8;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x38;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x28;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x18;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x80;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x50;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x60;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x98;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x28;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x30;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x50;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x38;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x28;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x38;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x28;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x18;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x18;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                           \
    defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x50;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0xb0;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffc;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x14;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x20;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x10;
static constexpr dart::compiler::target::word Array_data_offset = 0x10;
static constexpr dart::compiler::target::word Array_length_offset = 0xc;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x38;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x64;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x30;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x70;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word Closure_context_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x14;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0xc;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x18;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x2c;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x38;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x1c;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x30;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x3a;
static constexpr dart::compiler::target::word Function_code_offset = 0x2c;
static constexpr dart::compiler::target::word Function_data_offset = 0x24;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x48;
static constexpr dart::compiler::target::word Function_signature_offset = 0x20;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0xc;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x1c;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x14;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x10;
static constexpr dart::compiler::target::word Record_shape_offset = 0xc;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x24;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2f0;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x788;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x790;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x158;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x160;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x7c8;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x88;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc8;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x808;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x60;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x7d0;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x810;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x268;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1c0;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2c0;
static constexpr dart::compiler::target::word Thread_end_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7b0;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d8;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2d0;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x798;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb8;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x7c0;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x728;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x730;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x68;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x760;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x258;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x1a0;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x170;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x178;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2b0;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7a8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7b8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x70;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x7f0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x738;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x750;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x748;
static constexpr dart::compiler::target::word Thread_top_offset = 0x50;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x778;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x770;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_heap_base_offset = 0x48;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x7d8;
static constexpr dart::compiler::target::word Thread_random_offset = 0x7e0;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x7e8;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x20;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x24;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x14;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0xc;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x14;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x18;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x20;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x2c;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x30;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x34;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x20;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x26;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0xc;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x14;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x18;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0xc;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x1c;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0xc;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0xc;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x678, 0x680, 0x688, 0x690, -1,    -1,    0x698, 0x6a0,
        0x6a8, 0x6b0, 0x6b8, -1,    0x6c0, 0x6c8, -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x10;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x48;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x80;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x10;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x60;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x68;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x20;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x20;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x38;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x30;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x18;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x10;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_X64) &&
        // defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_ARM64) &&                         \
    defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x50;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0xb0;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffc;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x34;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x18;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x14;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x20;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x10;
static constexpr dart::compiler::target::word Array_data_offset = 0x10;
static constexpr dart::compiler::target::word Array_length_offset = 0xc;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x38;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x64;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x30;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x70;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word Closure_context_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x14;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0xc;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x18;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x2c;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x38;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x1c;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x30;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x3a;
static constexpr dart::compiler::target::word Function_code_offset = 0x2c;
static constexpr dart::compiler::target::word Function_data_offset = 0x24;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x48;
static constexpr dart::compiler::target::word Function_signature_offset = 0x20;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0xc;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x1c;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x14;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x10;
static constexpr dart::compiler::target::word Record_shape_offset = 0xc;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x24;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2f0;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x7d0;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x7d8;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x158;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x160;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x810;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x88;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc8;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x850;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x60;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x818;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x858;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x268;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1c0;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2c0;
static constexpr dart::compiler::target::word Thread_end_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d8;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2d0;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb8;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x808;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x770;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x778;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x68;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x7a8;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x258;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x1a0;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x170;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x178;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2b0;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7e8;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7f0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x800;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x70;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x838;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x780;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x788;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x798;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x760;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x768;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x790;
static constexpr dart::compiler::target::word Thread_top_offset = 0x50;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x7c0;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x7b8;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_heap_base_offset = 0x48;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x820;
static constexpr dart::compiler::target::word Thread_random_offset = 0x828;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x830;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x20;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x24;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x14;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0xc;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x14;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x18;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x20;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x2c;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x30;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x34;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x20;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x26;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0xc;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x14;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x18;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0xc;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x1c;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0xc;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0xc;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x678, 0x680, 0x688, 0x690, 0x698, 0x6a0, 0x6a8, 0x6b0,
        0x6b8, 0x6c0, 0x6c8, 0x6d0, 0x6d8, 0x6e0, 0x6e8, -1,
        -1,    -1,    -1,    0x6f0, 0x6f8, -1,    -1,    0x700,
        0x708, 0x710, -1,    -1,    -1,    -1,    -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x10;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x48;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x80;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x10;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x60;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x68;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x20;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x20;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x38;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x30;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x18;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x10;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM64) &&
        // defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_RISCV32) &&                       \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x38;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x48;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x10;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x4;
static constexpr dart::compiler::target::word Array_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x60;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x12;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x8;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x14;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word Array_data_offset = 0xc;
static constexpr dart::compiler::target::word Array_length_offset = 0x8;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x34;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x60;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x2c;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x6c;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x4;
static constexpr dart::compiler::target::word Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x10;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x18;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x14;
static constexpr dart::compiler::target::word Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x28;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x18;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x2c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word Function_code_offset = 0x20;
static constexpr dart::compiler::target::word Function_data_offset = 0x18;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x4, 0x8};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x40;
static constexpr dart::compiler::target::word Function_signature_offset = 0x14;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x1c;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x20;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x14;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x1c;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x10;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x18;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x1c;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x10;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x8;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x8;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x10;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0xc;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x4;
static constexpr dart::compiler::target::word NativeArguments_argv_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0xc;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0xc0;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0xd4;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0xc;
static constexpr dart::compiler::target::word Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x8;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x4;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x4;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x18;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x8;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x1c;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0xc;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x3e8;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x3ec;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x408;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x40;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x3c;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x430;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x40c;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x434;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x130;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0xdc;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x160;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x3fc;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x164;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x3f0;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x404;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x3ac;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x3b0;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x30;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x3c4;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x3c8;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0x64;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0xb4;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0xb8;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x38;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x3f4;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x3f8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x400;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x424;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x1c;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x3b4;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x3b8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x11c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x3c0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x384;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x388;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x38c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x390;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x394;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x398;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x39c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x3a0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x3a4;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x3a8;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x3bc;
static constexpr dart::compiler::target::word Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x10;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x3d8;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x3d0;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x410;
static constexpr dart::compiler::target::word Thread_random_offset = 0x418;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x420;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x4;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0xc;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x10;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x18;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0xc;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset = 0xc;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x4;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x1a;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0xc;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x4;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataBase_length_offset = 0x8;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0xc;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x8;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x4;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        -1,    -1,    -1, -1, -1, 0x338, 0x33c, 0x340, -1,    -1,    0x344,
        0x348, 0x34c, -1, -1, -1, 0x350, 0x354, 0x358, 0x35c, 0x360, 0x364,
        0x368, 0x36c, -1, -1, -1, -1,    0x370, 0x374, 0x378, 0x37c};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x14;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Array_header_size = 0xc;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x78;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x14;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0xc;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x3c;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x58;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x20;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x50;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x4;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x10;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x14;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x8;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x1c;
static constexpr dart::compiler::target::word String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x14;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0xc;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x14;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0xc;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0xc;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_RISCV32) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_RISCV64) &&                       \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x70;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Array_element_size = 0x8;
static constexpr dart::compiler::target::word ClassTable_elements_start_offset =
    0x0;
static constexpr dart::compiler::target::word ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0xb0;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x50;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x8;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x12;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fffffffffff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fffffffffff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x20;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x20;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x28;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word Array_data_offset = 0x18;
static constexpr dart::compiler::target::word Array_length_offset = 0x10;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x68;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0xb0;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x58;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0xbc;
static constexpr dart::compiler::target::word
    ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word Closure_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x20;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x48;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x54;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x30;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x4c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x56;
static constexpr dart::compiler::target::word Function_code_offset = 0x40;
static constexpr dart::compiler::target::word Function_data_offset = 0x30;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x68;
static constexpr dart::compiler::target::word Function_signature_offset = 0x28;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word
    Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x10;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x18;
static constexpr dart::compiler::target::word Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x30;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x38;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x7b8;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x7c0;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x80;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x838;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x800;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x840;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c0;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x7c8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x7f0;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x758;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x760;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x60;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x788;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x790;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x170;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7d0;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7d8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7e8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word Thread_single_step_offset = 0x820;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x768;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x770;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x780;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x778;
static constexpr dart::compiler::target::word Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x7a8;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x808;
static constexpr dart::compiler::target::word Thread_random_offset = 0x810;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x818;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x30;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x20;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x32;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x20;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x20;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x10;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        -1,    -1,    -1, -1, -1, 0x670, 0x678, 0x680, -1,    -1,    0x688,
        0x690, 0x698, -1, -1, -1, 0x6a0, 0x6a8, 0x6b0, 0x6b8, 0x6c0, 0x6c8,
        0x6d0, 0x6d8, -1, -1, -1, -1,    0x6e0, 0x6e8, 0x6f0, 0x6f8};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x18;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0xc8;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x38;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x28;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x18;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x80;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x50;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x60;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x98;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x28;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x30;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x50;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x38;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x28;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x38;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x28;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x18;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x18;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_RISCV64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_ARM) &&                            \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x38;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x48;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x10;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x4;
static constexpr dart::compiler::target::word Array_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x4c;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x10;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x8;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x14;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word Array_data_offset = 0xc;
static constexpr dart::compiler::target::word Array_length_offset = 0x8;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x30;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x5c;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x28;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x68;
static constexpr dart::compiler::target::word Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x10;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x18;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x14;
static constexpr dart::compiler::target::word Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x28;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x18;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x2c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word Function_code_offset = 0x20;
static constexpr dart::compiler::target::word Function_data_offset = 0x18;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x4, 0x8};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x40;
static constexpr dart::compiler::target::word Function_signature_offset = 0x14;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x1c;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x20;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x14;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x1c;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x10;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x18;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x10;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x8;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x8;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x10;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0xc;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x4;
static constexpr dart::compiler::target::word NativeArguments_argv_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0xc;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0xc0;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0xd4;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0xc;
static constexpr dart::compiler::target::word Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x8;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x4;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x4;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x18;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x8;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x1c;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0xc;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x3c0;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x3c4;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x3e0;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x40;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x3c;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x408;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x3e4;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x40c;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x130;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0xdc;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x160;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x3d4;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x164;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x3c8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x3dc;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x384;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x388;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x30;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x39c;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x3a0;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0x64;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0xb4;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0xb8;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x38;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x3cc;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x3d0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x3d8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x1c;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x38c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x390;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x11c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x398;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x35c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x360;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x358;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x364;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x368;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x36c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x370;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x374;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x378;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x37c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x394;
static constexpr dart::compiler::target::word Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x10;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x3b0;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x3a8;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x3e8;
static constexpr dart::compiler::target::word Thread_random_offset = 0x3f0;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x3f8;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x4;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0xc;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x10;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x18;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0xc;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset = 0xc;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x4;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x1a;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0xc;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x4;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataBase_length_offset = 0x8;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0xc;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x8;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x4;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x338, 0x33c, 0x340, 0x344, 0x348, -1, 0x34c, -1,
        0x350, 0x354, -1,    -1,    -1,    -1, -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x14;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Array_header_size = 0xc;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x74;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x14;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0xc;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x3c;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x58;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x20;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x50;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x4;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x10;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x14;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x8;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x10;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x1c;
static constexpr dart::compiler::target::word String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x14;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0xc;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x14;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0xc;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0xc;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                            \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x70;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Array_element_size = 0x8;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x90;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x50;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x8;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fffffffffff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fffffffffff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x20;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x20;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x28;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word Array_data_offset = 0x18;
static constexpr dart::compiler::target::word Array_length_offset = 0x10;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x60;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0xa8;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x50;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0xb4;
static constexpr dart::compiler::target::word Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word Closure_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x20;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x48;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x54;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x30;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x4c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x56;
static constexpr dart::compiler::target::word Function_code_offset = 0x40;
static constexpr dart::compiler::target::word Function_data_offset = 0x30;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x68;
static constexpr dart::compiler::target::word Function_signature_offset = 0x28;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x10;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x18;
static constexpr dart::compiler::target::word Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x30;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x38;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x780;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x788;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x7c0;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x80;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x800;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x7c8;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x808;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c0;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7a8;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x790;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x7b8;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x720;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x728;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x60;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x170;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x798;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7a0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7b0;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x730;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x6c8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x740;
static constexpr dart::compiler::target::word Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x770;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x768;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x7d0;
static constexpr dart::compiler::target::word Thread_random_offset = 0x7d8;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x7e0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x30;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x20;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x32;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x20;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x20;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x10;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, -1,    -1,    0x690, 0x698,
        0x6a0, 0x6a8, 0x6b0, -1,    0x6b8, 0x6c0, -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x18;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0xc0;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x38;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x28;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x18;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x80;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x50;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x60;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x98;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x28;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x20;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x50;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x38;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x28;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x38;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x28;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x18;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x18;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_X64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_IA32) &&                           \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x38;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x48;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x10;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x4;
static constexpr dart::compiler::target::word Array_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x4c;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x24;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x8;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x14;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word Array_data_offset = 0xc;
static constexpr dart::compiler::target::word Array_length_offset = 0x8;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x30;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x5c;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x28;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x68;
static constexpr dart::compiler::target::word Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x10;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x18;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x14;
static constexpr dart::compiler::target::word Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x28;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x18;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x2c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word Function_code_offset = 0x20;
static constexpr dart::compiler::target::word Function_data_offset = 0x18;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x4, 0x8};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x40;
static constexpr dart::compiler::target::word Function_signature_offset = 0x14;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x1c;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x20;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x14;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x1c;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x10;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x18;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x10;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x8;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x8;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x10;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0xc;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x4;
static constexpr dart::compiler::target::word NativeArguments_argv_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0xc;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0xc0;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0xd4;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0xc;
static constexpr dart::compiler::target::word Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x8;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x4;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x4;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x18;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x8;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x1c;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0xc;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x3b0;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x3b4;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x3d0;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x40;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x3c;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x3f8;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x3d4;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x3fc;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x130;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0xdc;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x160;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x3c4;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x164;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x3b8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x3cc;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x378;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x37c;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x30;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x390;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x394;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0x64;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0xb4;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0xb8;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x38;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x3bc;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x3c0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x3c8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x1c;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x380;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x384;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x11c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x38c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x350;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x354;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x34c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x358;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x35c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x360;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x364;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x368;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x36c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x370;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x374;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x388;
static constexpr dart::compiler::target::word Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x10;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x3a0;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x39c;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x3d8;
static constexpr dart::compiler::target::word Thread_random_offset = 0x3e0;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x3e8;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x4;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0xc;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x10;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x18;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0xc;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset = 0xc;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x4;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x1a;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0xc;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x4;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataBase_length_offset = 0x8;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0xc;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x8;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x4;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x338, 0x33c, 0x340, 0x344, -1, -1, -1, 0x348};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x14;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Array_header_size = 0xc;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x74;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x14;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0xc;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x3c;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x58;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x20;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x50;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x4;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x10;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x14;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x8;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x10;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x1c;
static constexpr dart::compiler::target::word String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x14;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0xc;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x14;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0xc;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0xc;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_IA32) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_ARM64) &&                          \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x70;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Array_element_size = 0x8;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x90;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x50;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x8;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x34;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x18;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fffffffffff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fffffffffff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x20;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x20;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x28;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word Array_data_offset = 0x18;
static constexpr dart::compiler::target::word Array_length_offset = 0x10;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x60;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0xa8;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x50;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0xb4;
static constexpr dart::compiler::target::word Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word Closure_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x20;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x48;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x54;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x30;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x4c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x56;
static constexpr dart::compiler::target::word Function_code_offset = 0x40;
static constexpr dart::compiler::target::word Function_data_offset = 0x30;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x68;
static constexpr dart::compiler::target::word Function_signature_offset = 0x28;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x10;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x18;
static constexpr dart::compiler::target::word Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x30;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x38;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x7c8;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x7d0;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x808;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x80;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x848;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x810;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x850;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c0;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7f0;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x7d8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x800;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x768;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x770;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x60;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x798;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x170;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7e0;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7e8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x778;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x780;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x790;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x760;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x788;
static constexpr dart::compiler::target::word Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x7b8;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x7b0;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x818;
static constexpr dart::compiler::target::word Thread_random_offset = 0x820;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x828;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x30;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x20;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x32;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x20;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x20;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x10;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, 0x690, 0x698, 0x6a0, 0x6a8,
        0x6b0, 0x6b8, 0x6c0, 0x6c8, 0x6d0, 0x6d8, 0x6e0, -1,
        -1,    -1,    -1,    0x6e8, 0x6f0, -1,    -1,    0x6f8,
        0x700, 0x708, -1,    -1,    -1,    -1,    -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x18;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0xc0;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x38;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x28;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x18;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x80;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x50;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x60;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x98;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x28;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x20;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x50;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x38;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x28;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x38;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x28;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x18;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x18;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                            \
    defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x50;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x90;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffc;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x14;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x20;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x10;
static constexpr dart::compiler::target::word Array_data_offset = 0x10;
static constexpr dart::compiler::target::word Array_length_offset = 0xc;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x34;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x60;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x2c;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x6c;
static constexpr dart::compiler::target::word Closure_context_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x14;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0xc;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x18;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x2c;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x38;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x1c;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x30;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x3a;
static constexpr dart::compiler::target::word Function_code_offset = 0x2c;
static constexpr dart::compiler::target::word Function_data_offset = 0x24;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x48;
static constexpr dart::compiler::target::word Function_signature_offset = 0x20;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0xc;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x1c;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x14;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x10;
static constexpr dart::compiler::target::word Record_shape_offset = 0xc;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x24;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2f0;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x788;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x790;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x158;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x160;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x7c8;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x88;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc8;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x808;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x60;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x7d0;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x810;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x268;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1c0;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2c0;
static constexpr dart::compiler::target::word Thread_end_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7b0;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d8;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2d0;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x798;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb8;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x7c0;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x728;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x730;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x68;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x760;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x258;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x1a0;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x170;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x178;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2b0;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7a8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7b8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x738;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x750;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x748;
static constexpr dart::compiler::target::word Thread_top_offset = 0x50;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x778;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x770;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_heap_base_offset = 0x48;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x7d8;
static constexpr dart::compiler::target::word Thread_random_offset = 0x7e0;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x7e8;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x20;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x24;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x14;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0xc;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x14;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x18;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x20;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x2c;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x30;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x34;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x20;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x26;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0xc;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x14;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x18;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0xc;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x1c;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0xc;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0xc;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x678, 0x680, 0x688, 0x690, -1,    -1,    0x698, 0x6a0,
        0x6a8, 0x6b0, 0x6b8, -1,    0x6c0, 0x6c8, -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x10;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x78;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x10;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x60;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x68;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x20;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x38;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x30;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x18;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x10;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_X64) &&
        // defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_ARM64) &&                          \
    defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x50;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x90;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffc;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x34;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x18;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x14;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x20;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x10;
static constexpr dart::compiler::target::word Array_data_offset = 0x10;
static constexpr dart::compiler::target::word Array_length_offset = 0xc;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x34;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x60;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x2c;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x6c;
static constexpr dart::compiler::target::word Closure_context_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x14;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0xc;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x14;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x18;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x2c;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x38;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x1c;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x30;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x3a;
static constexpr dart::compiler::target::word Function_code_offset = 0x2c;
static constexpr dart::compiler::target::word Function_data_offset = 0x24;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x48;
static constexpr dart::compiler::target::word Function_signature_offset = 0x20;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0xc;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x1c;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x14;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x10;
static constexpr dart::compiler::target::word Record_shape_offset = 0xc;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x24;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2f0;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x7d0;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x7d8;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x158;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x160;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x810;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x88;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc8;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x850;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x60;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x818;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x858;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x268;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1c0;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2c0;
static constexpr dart::compiler::target::word Thread_end_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d8;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2d0;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb8;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x808;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x770;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x778;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x68;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x7a8;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x258;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x1a0;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x170;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x178;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2b0;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7e8;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7f0;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x800;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x780;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x788;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x798;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x758;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x760;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x768;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x790;
static constexpr dart::compiler::target::word Thread_top_offset = 0x50;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x7c0;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x7b8;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_heap_base_offset = 0x48;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x820;
static constexpr dart::compiler::target::word Thread_random_offset = 0x828;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x830;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x20;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x24;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x14;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0xc;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x14;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x18;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x20;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x2c;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x30;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x34;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x20;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x26;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0xc;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x14;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x18;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0xc;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x14;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x1c;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0xc;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0xc;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        0x678, 0x680, 0x688, 0x690, 0x698, 0x6a0, 0x6a8, 0x6b0,
        0x6b8, 0x6c0, 0x6c8, 0x6d0, 0x6d8, 0x6e0, 0x6e8, -1,
        -1,    -1,    -1,    0x6f0, 0x6f8, -1,    -1,    0x700,
        0x708, 0x710, -1,    -1,    -1,    -1,    -1,    -1};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x10;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x78;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x10;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x60;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x68;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x18;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x20;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x40;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x38;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x30;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x28;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x18;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x10;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM64) &&
        // defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_RISCV32) &&                        \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x38;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x48;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x10;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x4;
static constexpr dart::compiler::target::word Array_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word Array_element_size = 0x4;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x4c;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x28;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x4;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word Array_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word Context_kMaxElements = 0xfffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x12;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements = 0x1fffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x8;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x10;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x14;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word Array_data_offset = 0xc;
static constexpr dart::compiler::target::word Array_length_offset = 0x8;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x30;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0x5c;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x28;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0x68;
static constexpr dart::compiler::target::word Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word Closure_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x10;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x18;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x14;
static constexpr dart::compiler::target::word Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x28;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x18;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x2c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word Function_code_offset = 0x20;
static constexpr dart::compiler::target::word Function_data_offset = 0x18;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x4, 0x8};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x40;
static constexpr dart::compiler::target::word Function_signature_offset = 0x14;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x1c;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x20;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x14;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x1c;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x10;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x18;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x10;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x8;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x8;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x10;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0xc;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x4;
static constexpr dart::compiler::target::word NativeArguments_argv_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0xc;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0xc0;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0xd4;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0xc;
static constexpr dart::compiler::target::word Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x8;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x4;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x4;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x18;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x8;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x1c;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0xc;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x3e8;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x3ec;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x408;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x40;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x3c;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x430;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x40c;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x434;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x130;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0xdc;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x160;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x3fc;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x164;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x3f0;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x404;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x3ac;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x3b0;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x30;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x3c4;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x3c8;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0x64;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0xb4;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0xb8;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x38;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x3f4;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x3f8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x400;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x1c;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x3b4;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x3b8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x11c;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x3c0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x384;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x388;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x38c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x390;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x394;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x398;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x39c;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x3a0;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x3a4;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x3a8;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x3bc;
static constexpr dart::compiler::target::word Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x10;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x3d8;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x3d0;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x410;
static constexpr dart::compiler::target::word Thread_random_offset = 0x418;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x420;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x4;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0xc;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x10;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0xc;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x18;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0xc;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x10;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x14;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset = 0xc;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x4;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x1a;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0xc;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word TypeArguments_length_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x14;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x4;
static constexpr dart::compiler::target::word TypeParameters_flags_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataBase_length_offset = 0x8;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0xc;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x8;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x4;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        -1,    -1,    -1, -1, -1, 0x338, 0x33c, 0x340, -1,    -1,    0x344,
        0x348, 0x34c, -1, -1, -1, 0x350, 0x354, 0x358, 0x35c, 0x360, 0x364,
        0x368, 0x36c, -1, -1, -1, -1,    0x370, 0x374, 0x378, 0x37c};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x14;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Array_header_size = 0xc;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0x74;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x14;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0xc;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x3c;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x58;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x20;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x50;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x14;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x4;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x10;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x14;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x8;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x10;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x1c;
static constexpr dart::compiler::target::word String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x14;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0xc;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x14;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x10;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0xc;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x10;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0xc;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_RISCV32) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_RISCV64) &&                        \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word Code_active_instructions_offset =
    0x70;
static constexpr dart::compiler::target::word Function_usage_counter_offset =
    0x70;
static constexpr dart::compiler::target::word
    ICData_receivers_static_type_offset = 0x20;
static constexpr dart::compiler::target::word
    SuspendState_frame_capacity_offset = 0x8;
static constexpr dart::compiler::target::word Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Array_element_size = 0x8;
static constexpr dart::compiler::target::word Code_elements_start_offset = 0x90;
static constexpr dart::compiler::target::word Code_element_size = 0x4;
static constexpr dart::compiler::target::word Context_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word ContextScope_element_size = 0x50;
static constexpr dart::compiler::target::word
    ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word ExceptionHandlers_element_size =
    0xc;
static constexpr dart::compiler::target::word ObjectPool_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word OneByteString_element_size = 0x1;
static constexpr dart::compiler::target::word Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word TypeArguments_element_size = 0x8;
static constexpr dart::compiler::target::word
    TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word TwoByteString_element_size = 0x2;
static constexpr dart::compiler::target::word WeakArray_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    Instructions_kMonomorphicEntryOffsetAOT = 0x6;
static constexpr dart::compiler::target::word
    Instructions_kPolymorphicEntryOffsetAOT = 0x12;
static constexpr dart::compiler::target::word
    Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word RecordShape_kFieldNamesIndexMask =
    0x3fffffffffff;
static constexpr dart::compiler::target::word
    RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word RecordShape_kMaxFieldNamesIndex =
    0x3fffffffffff;
static constexpr dart::compiler::target::word RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_kMaxInputs = 0x7;
static constexpr dart::compiler::target::word SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AbstractType_flags_offset = 0x10;
static constexpr dart::compiler::target::word AbstractType_hash_offset = 0x20;
static constexpr dart::compiler::target::word
    AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word ArgumentsDescriptor_count_offset =
    0x20;
static constexpr dart::compiler::target::word ArgumentsDescriptor_size_offset =
    0x28;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word ArgumentsDescriptor_name_offset =
    0x0;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word Array_data_offset = 0x18;
static constexpr dart::compiler::target::word Array_length_offset = 0x10;
static constexpr dart::compiler::target::word Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word Array_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Class_declaration_type_offset =
    0x60;
static constexpr dart::compiler::target::word Class_num_type_arguments_offset =
    0xa8;
static constexpr dart::compiler::target::word Class_super_type_offset = 0x50;
static constexpr dart::compiler::target::word
    Class_host_type_arguments_field_offset_in_words_offset = 0xb4;
static constexpr dart::compiler::target::word Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word Closure_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word ClosureData_packed_fields_offset =
    0x20;
static constexpr dart::compiler::target::word Code_instructions_offset = 0x30;
static constexpr dart::compiler::target::word Code_object_pool_offset = 0x28;
static constexpr dart::compiler::target::word Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word Double_value_offset = 0x8;
static constexpr dart::compiler::target::word Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word Field_guarded_cid_offset = 0x48;
static constexpr dart::compiler::target::word
    Field_guarded_list_length_in_object_offset_offset = 0x54;
static constexpr dart::compiler::target::word Field_guarded_list_length_offset =
    0x30;
static constexpr dart::compiler::target::word Field_is_nullable_offset = 0x4c;
static constexpr dart::compiler::target::word Field_kind_bits_offset = 0x56;
static constexpr dart::compiler::target::word Function_code_offset = 0x40;
static constexpr dart::compiler::target::word Function_data_offset = 0x30;
static constexpr dart::compiler::target::word Function_entry_point_offset[] = {
    0x8, 0x10};
static constexpr dart::compiler::target::word Function_kind_tag_offset = 0x68;
static constexpr dart::compiler::target::word Function_signature_offset = 0x28;
static constexpr dart::compiler::target::word FutureOr_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word GrowableObjectArray_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word Page_original_top_offset = 0x38;
static constexpr dart::compiler::target::word Page_original_end_offset = 0x40;
static constexpr dart::compiler::target::word
    CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word ICData_NumArgsTestedMask = 0x3;
static constexpr dart::compiler::target::word ICData_NumArgsTestedShift = 0x0;
static constexpr dart::compiler::target::word ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word ICData_owner_offset = 0x28;
static constexpr dart::compiler::target::word ICData_state_bits_offset = 0x34;
static constexpr dart::compiler::target::word Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word Isolate_current_tag_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_default_tag_offset = 0x20;
static constexpr dart::compiler::target::word Isolate_finalizers_offset = 0x30;
static constexpr dart::compiler::target::word IsolateGroup_object_store_offset =
    0x20;
static constexpr dart::compiler::target::word IsolateGroup_class_table_offset =
    0x10;
static constexpr dart::compiler::target::word
    IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word Isolate_user_tag_offset = 0x10;
static constexpr dart::compiler::target::word LinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_hash_mask_offset =
    0x10;
static constexpr dart::compiler::target::word LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word LinkedHashBase_used_data_offset =
    0x20;
static constexpr dart::compiler::target::word LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word MegamorphicCache_buckets_offset =
    0x18;
static constexpr dart::compiler::target::word MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeArguments_argc_tag_offset =
    0x8;
static constexpr dart::compiler::target::word NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word NativeArguments_retval_offset =
    0x18;
static constexpr dart::compiler::target::word NativeArguments_thread_offset =
    0x0;
static constexpr dart::compiler::target::word ObjectStore_double_type_offset =
    0x180;
static constexpr dart::compiler::target::word ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word ObjectStore_string_type_offset =
    0x1a8;
static constexpr dart::compiler::target::word ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word OneByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word PersistentHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word Pointer_type_arguments_offset =
    0x10;
static constexpr dart::compiler::target::word ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word ReceivePort_handler_offset = 0x18;
static constexpr dart::compiler::target::word Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word SingleTargetCache_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word StoreBufferBlock_pointers_offset =
    0x10;
static constexpr dart::compiler::target::word StoreBufferBlock_top_offset = 0x8;
static constexpr dart::compiler::target::word StreamInfo_enabled_offset = 0x8;
static constexpr dart::compiler::target::word String_hash_offset = 0x4;
static constexpr dart::compiler::target::word String_length_offset = 0x8;
static constexpr dart::compiler::target::word SubtypeTestCache_cache_offset =
    0x8;
static constexpr dart::compiler::target::word
    SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word SuspendState_FrameSizeGrowthGap =
    0x2;
static constexpr dart::compiler::target::word
    SuspendState_error_callback_offset = 0x30;
static constexpr dart::compiler::target::word SuspendState_frame_size_offset =
    0x10;
static constexpr dart::compiler::target::word
    SuspendState_function_data_offset = 0x20;
static constexpr dart::compiler::target::word SuspendState_payload_offset =
    0x38;
static constexpr dart::compiler::target::word SuspendState_pc_offset = 0x18;
static constexpr dart::compiler::target::word
    SuspendState_then_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word Thread_active_exception_offset =
    0x7b8;
static constexpr dart::compiler::target::word Thread_active_stacktrace_offset =
    0x7c0;
static constexpr dart::compiler::target::word
    Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word Thread_api_top_scope_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word Thread_bool_false_offset = 0x80;
static constexpr dart::compiler::target::word Thread_bool_true_offset = 0x78;
static constexpr dart::compiler::target::word
    Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word Thread_dart_stream_offset = 0x838;
static constexpr dart::compiler::target::word
    Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    Thread_double_truncate_round_supported_offset = 0x800;
static constexpr dart::compiler::target::word
    Thread_service_extension_stream_offset = 0x840;
static constexpr dart::compiler::target::word Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word Thread_deoptimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word Thread_deoptimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word Thread_double_abs_address_offset =
    0x2c0;
static constexpr dart::compiler::target::word
    Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word Thread_execution_state_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word Thread_float_not_address_offset =
    0x2c8;
static constexpr dart::compiler::target::word
    Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word Thread_global_object_pool_offset =
    0x7c8;
static constexpr dart::compiler::target::word
    Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word Thread_exit_through_ffi_offset =
    0x7f0;
static constexpr dart::compiler::target::word Thread_isolate_offset = 0x758;
static constexpr dart::compiler::target::word Thread_isolate_group_offset =
    0x760;
static constexpr dart::compiler::target::word Thread_field_table_values_offset =
    0x60;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    Thread_old_marking_stack_block_offset = 0x788;
static constexpr dart::compiler::target::word
    Thread_new_marking_stack_block_offset = 0x790;
static constexpr dart::compiler::target::word
    Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_with_fpu_regs_stub_offset = 0xd0;
static constexpr dart::compiler::target::word
    Thread_late_initialization_error_shared_without_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word Thread_resume_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word Thread_return_async_stub_offset =
    0x170;
static constexpr dart::compiler::target::word Thread_object_null_offset = 0x70;
static constexpr dart::compiler::target::word
    Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word Thread_resume_pc_offset = 0x7d0;
static constexpr dart::compiler::target::word
    Thread_saved_shadow_call_stack_offset = 0x7d8;
static constexpr dart::compiler::target::word Thread_safepoint_state_offset =
    0x7e8;
static constexpr dart::compiler::target::word
    Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word Thread_stack_limit_offset = 0x38;
static constexpr dart::compiler::target::word Thread_saved_stack_limit_offset =
    0x768;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_flags_offset = 0x770;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word Thread_store_buffer_block_offset =
    0x780;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    Thread_suspend_state_await_with_type_check_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_not_future_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_async_star_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    Thread_suspend_state_yield_async_star_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    Thread_suspend_state_return_async_star_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    Thread_suspend_state_init_sync_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    Thread_suspend_state_handle_exception_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    Thread_top_exit_frame_info_offset = 0x778;
static constexpr dart::compiler::target::word Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word Thread_top_resource_offset = 0x20;
static constexpr dart::compiler::target::word
    Thread_unboxed_runtime_arg_offset = 0x7a8;
static constexpr dart::compiler::target::word Thread_vm_tag_offset = 0x7a0;
static constexpr dart::compiler::target::word
    Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word Thread_write_barrier_mask_offset =
    0x40;
static constexpr dart::compiler::target::word Thread_next_task_id_offset =
    0x808;
static constexpr dart::compiler::target::word Thread_random_offset = 0x810;
static constexpr dart::compiler::target::word
    Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word Thread_tsan_utils_offset = 0x818;
static constexpr dart::compiler::target::word TsanUtils_setjmp_function_offset =
    0x0;
static constexpr dart::compiler::target::word TsanUtils_setjmp_buffer_offset =
    0x8;
static constexpr dart::compiler::target::word TsanUtils_exception_pc_offset =
    0x10;
static constexpr dart::compiler::target::word TsanUtils_exception_sp_offset =
    0x18;
static constexpr dart::compiler::target::word TsanUtils_exception_fp_offset =
    0x20;
static constexpr dart::compiler::target::word TimelineStream_enabled_offset =
    0x10;
static constexpr dart::compiler::target::word TwoByteString_data_offset = 0x10;
static constexpr dart::compiler::target::word Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word Finalizer_type_arguments_offset =
    0x30;
static constexpr dart::compiler::target::word Finalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerBase_all_entries_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerBase_detachments_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_finalizer_offset =
    0x20;
static constexpr dart::compiler::target::word FinalizerEntry_next_offset = 0x28;
static constexpr dart::compiler::target::word FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word FinalizerEntry_value_offset = 0x8;
static constexpr dart::compiler::target::word NativeFinalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameter_index_offset = 0x32;
static constexpr dart::compiler::target::word TypeArguments_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypeArguments_nullability_offset =
    0x20;
static constexpr dart::compiler::target::word TypeArguments_types_offset = 0x28;
static constexpr dart::compiler::target::word TypeParameters_names_offset = 0x8;
static constexpr dart::compiler::target::word TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word TypeParameters_defaults_offset =
    0x20;
static constexpr dart::compiler::target::word TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word TypedDataView_typed_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word TypedData_payload_offset = 0x18;
static constexpr dart::compiler::target::word
    UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word WeakProperty_value_offset = 0x10;
static constexpr dart::compiler::target::word WeakReference_target_offset = 0x8;
static constexpr dart::compiler::target::word
    WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    Thread_write_barrier_wrappers_thread_offset[] = {
        -1,    -1,    -1, -1, -1, 0x670, 0x678, 0x680, -1,    -1,    0x688,
        0x690, 0x698, -1, -1, -1, 0x6a0, 0x6a8, 0x6b0, 0x6b8, 0x6c0, 0x6c8,
        0x6d0, 0x6d8, -1, -1, -1, -1,    0x6e0, 0x6e8, 0x6f0, 0x6f8};
static constexpr dart::compiler::target::word AbstractType_InstanceSize = 0x28;
static constexpr dart::compiler::target::word ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Array_header_size = 0x18;
static constexpr dart::compiler::target::word Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Capability_InstanceSize = 0x10;
static constexpr dart::compiler::target::word Class_InstanceSize = 0xc0;
static constexpr dart::compiler::target::word Closure_InstanceSize = 0x38;
static constexpr dart::compiler::target::word ClosureData_InstanceSize = 0x28;
static constexpr dart::compiler::target::word CodeSourceMap_HeaderSize = 0x10;
static constexpr dart::compiler::target::word
    CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word Context_header_size = 0x18;
static constexpr dart::compiler::target::word Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word ExternalTypedData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word FfiTrampolineData_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Field_InstanceSize = 0x60;
static constexpr dart::compiler::target::word Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Function_InstanceSize = 0x80;
static constexpr dart::compiler::target::word FunctionType_InstanceSize = 0x50;
static constexpr dart::compiler::target::word FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word GrowableObjectArray_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word ICData_InstanceSize = 0x38;
static constexpr dart::compiler::target::word Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Instructions_UnalignedHeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word InstructionsSection_HeaderSize =
    0x40;
static constexpr dart::compiler::target::word InstructionsTable_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word KernelProgramInfo_InstanceSize =
    0x60;
static constexpr dart::compiler::target::word LanguageError_InstanceSize = 0x30;
static constexpr dart::compiler::target::word Library_InstanceSize = 0x98;
static constexpr dart::compiler::target::word LibraryPrefix_InstanceSize = 0x28;
static constexpr dart::compiler::target::word LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word LocalHandle_InstanceSize = 0x8;
static constexpr dart::compiler::target::word MegamorphicCache_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word NativeArguments_StructSize = 0x20;
static constexpr dart::compiler::target::word Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word PatchClass_InstanceSize = 0x28;
static constexpr dart::compiler::target::word PcDescriptors_HeaderSize = 0x10;
static constexpr dart::compiler::target::word Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word ReceivePort_InstanceSize = 0x20;
static constexpr dart::compiler::target::word RecordType_InstanceSize = 0x38;
static constexpr dart::compiler::target::word RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word Script_InstanceSize = 0x50;
static constexpr dart::compiler::target::word SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word SingleTargetCache_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word StackTrace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word SuspendState_HeaderSize = 0x38;
static constexpr dart::compiler::target::word String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word SubtypeTestCache_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word LoadingUnit_InstanceSize = 0x28;
static constexpr dart::compiler::target::word
    TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word TypeParameter_InstanceSize = 0x38;
static constexpr dart::compiler::target::word TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word TypedDataBase_InstanceSize = 0x18;
static constexpr dart::compiler::target::word TypedDataView_InstanceSize = 0x28;
static constexpr dart::compiler::target::word UnhandledException_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word UnlinkedCall_InstanceSize = 0x20;
static constexpr dart::compiler::target::word UnwindError_InstanceSize = 0x18;
static constexpr dart::compiler::target::word UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakProperty_InstanceSize = 0x20;
static constexpr dart::compiler::target::word WeakReference_InstanceSize = 0x20;
static constexpr dart::compiler::target::word
    WeakSerializationReference_InstanceSize = 0x18;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_RISCV64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_ARM) &&                           \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x1c;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x58;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x28;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x0;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x10;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x4c;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x2c;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x4;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x2c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x32;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x4, 0x8};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x1c;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x8;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0xc;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x4;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0xd4;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0xc;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x3c0;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x3c4;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x3e0;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x40;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x3c;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x408;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x3e4;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x40c;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0xdc;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x3d4;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x164;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x3c8;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x3dc;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x384;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x388;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x39c;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x3a0;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0x68;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0x64;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0xb4;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0xb8;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x3cc;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x3d0;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x3d8;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x3fc;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x38c;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x390;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x11c;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x398;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x35c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x360;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x358;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x364;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x368;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x36c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x370;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x374;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x378;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x37c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x394;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x3b0;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x3a8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x3e8;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x3f8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x10;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x1a;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x338, 0x33c, 0x340, 0x344, 0x348, -1, 0x34c, -1,
        0x350, 0x354, -1,    -1,    -1,    -1, -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0xc;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0x60;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0xc;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0xc;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x34;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x2c;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x20;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x48;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x4;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x8;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x14;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x18;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0xc;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                           \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x98;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x50;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fffffffffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fffffffffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x68;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x94;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x58;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x48;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x52;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x8, 0x10};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x40;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x20;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0x18;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0x180;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0x1a8;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x780;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x788;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x7c0;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x80;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x800;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x7c8;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x808;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x260;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0x1b8;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x2c0;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x7a8;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x2c8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x790;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x7b8;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x720;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x728;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x750;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0xd0;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0x170;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x798;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x7a0;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x7b0;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x7e8;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x730;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x738;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x238;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x748;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x6c8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x710;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x740;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x770;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x768;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x7d0;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x7d8;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x32;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, -1,    -1,    0x690, 0x698,
        0x6a0, 0x6a8, 0x6b0, -1,    0x6b8, 0x6c0, -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0xa8;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x50;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x50;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x40;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x60;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x88;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x48;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x30;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0x18;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_X64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_IA32) &&                          \
    !defined(DART_COMPRESSED_POINTERS)
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_IA32) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_ARM64) &&                         \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x98;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x50;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x34;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x18;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fffffffffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fffffffffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x68;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x94;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x58;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x48;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x52;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x8, 0x10};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x40;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x20;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0x18;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0x180;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0x1a8;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x7c8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x7d0;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x808;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x80;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x848;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x810;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x850;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x260;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0x1b8;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x2c0;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x7f0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x2c8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x7d8;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x800;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x768;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x770;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x798;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x7a0;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0xd0;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0x170;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x7e8;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x7f8;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x830;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x778;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x780;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x238;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x790;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x758;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x760;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x788;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x7b8;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x7b0;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x818;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x820;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x828;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x32;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, 0x690, 0x698, 0x6a0, 0x6a8,
        0x6b0, 0x6b8, 0x6c0, 0x6c8, 0x6d0, 0x6d8, 0x6e0, -1,
        -1,    -1,    -1,    0x6e8, 0x6f0, -1,    -1,    0x6f8,
        0x700, 0x708, -1,    -1,    -1,    -1,    -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0xa8;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x50;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x50;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x40;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x60;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x88;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x48;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x30;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0x18;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                           \
    defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x98;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x28;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0xfffc;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x50;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0x5c;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x14;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x2c;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x2c;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x24;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x8, 0x10};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x34;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x40;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0xc;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x14;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0x18;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0x180;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0x1a8;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x2f0;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x788;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x790;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0x158;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0x160;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x7c8;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x88;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x80;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0xc8;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x808;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x7d0;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x810;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x268;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x2c8;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x2c0;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x7b0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x2d0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x2e8;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x798;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x2a8;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x7c0;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x728;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x730;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x760;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x258;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0x1a0;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0xd0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0x170;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0x188;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0x178;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x2b0;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x7a0;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x7a8;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x7b8;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x70;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x7f0;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x738;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x740;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x248;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x240;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x750;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x718;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x748;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x50;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x778;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x770;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Thread_heap_base_offset =
    0x48;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x7d8;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x7e0;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x7e8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x24;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x14;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x2c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x26;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0xc;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x678, 0x680, 0x688, 0x690, -1,    -1,    0x698, 0x6a0,
        0x6a8, 0x6b0, 0x6b8, -1,    0x6c0, 0x6c8, -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0x10;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0x68;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0x10;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x40;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x28;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0x10;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_X64) &&
        // defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_ARM64) &&                         \
    defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x98;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x28;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0xfffc;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x34;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x18;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x50;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0x5c;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x14;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x2c;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x36;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x2c;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x24;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x8, 0x10};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x34;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x40;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0xc;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x14;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0x18;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0x180;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0x1a8;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x2f0;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x7d0;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x7d8;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0x158;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x238;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0x160;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x810;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x88;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x80;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0xc8;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x850;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x818;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x858;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x260;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0x1b8;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x268;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x2c8;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x2c0;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x7f8;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x2d0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x2e8;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x7e0;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x2a8;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x808;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x770;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x778;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x7a0;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x7a8;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x258;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0x1a0;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0xd0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0x170;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0x188;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0x178;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x2b0;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x7e8;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x7f0;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x800;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x70;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x838;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x780;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x788;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x248;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x240;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x798;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x748;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x758;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x760;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x768;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x790;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x50;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x7c0;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x7b8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Thread_heap_base_offset =
    0x48;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x820;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x828;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x830;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x24;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x14;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x2c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x26;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0xc;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x678, 0x680, 0x688, 0x690, 0x698, 0x6a0, 0x6a8, 0x6b0,
        0x6b8, 0x6c0, 0x6c8, 0x6d0, 0x6d8, 0x6e0, 0x6e8, -1,
        -1,    -1,    -1,    0x6f0, 0x6f8, -1,    -1,    0x700,
        0x708, 0x710, -1,    -1,    -1,    -1,    -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0x10;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0x68;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0x10;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x40;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x28;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0x10;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM64) &&
        // defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_RISCV32) &&                       \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x1c;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x58;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x28;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x6;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x12;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x4c;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x2c;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x4;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x2c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x32;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x4, 0x8};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x1c;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x8;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0xc;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x4;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0xd4;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0xc;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x3e8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x3ec;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x408;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x40;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x3c;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x430;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x40c;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x434;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0xdc;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x3fc;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x164;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x404;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x3ac;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x3b0;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x3c4;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x3c8;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0x68;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0x64;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0xb4;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0xb8;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x3f4;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x3f8;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x400;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x424;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x3b4;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x3b8;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x11c;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x3c0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x384;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x388;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x38c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x390;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x394;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x398;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x39c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x3a0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x3a4;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x3a8;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x3bc;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x3d8;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x3d0;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x410;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x418;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x420;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x10;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x1a;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        -1,    -1,    -1, -1, -1, 0x338, 0x33c, 0x340, -1,    -1,    0x344,
        0x348, 0x34c, -1, -1, -1, 0x350, 0x354, 0x358, 0x35c, 0x360, 0x364,
        0x368, 0x36c, -1, -1, -1, -1,    0x370, 0x374, 0x378, 0x37c};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0xc;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0x60;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0xc;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0xc;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x34;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x2c;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x20;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x48;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x4;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x8;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x14;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x18;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0xc;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_RISCV32) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if !defined(PRODUCT) && defined(TARGET_ARCH_RISCV64) &&                       \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClassTable_elements_start_offset = 0x0;
static constexpr dart::compiler::target::word AOT_ClassTable_element_size = 0x1;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x98;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x50;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x6;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x6;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x12;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fffffffffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fffffffffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x68;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x94;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x58;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_ClassTable_allocation_tracing_state_table_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x48;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x52;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x8, 0x10};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x40;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_Isolate_has_resumption_breakpoints_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x20;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0x18;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0x180;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0x1a8;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x7b8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x7c0;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x7f8;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x80;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x838;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x800;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x840;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x260;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0x1b8;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x2c0;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x7e0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x2c8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x7c8;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x7f0;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x758;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x760;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x788;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x790;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0xd0;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0x170;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x7d0;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x7d8;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x7e8;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word AOT_Thread_single_step_offset =
    0x820;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x768;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x770;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x238;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x780;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x710;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x720;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x728;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x730;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x738;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x740;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x748;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x750;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x778;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x7a8;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x7a0;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x808;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x810;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x818;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x32;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        -1,    -1,    -1, -1, -1, 0x670, 0x678, 0x680, -1,    -1,    0x688,
        0x690, 0x698, -1, -1, -1, 0x6a0, 0x6a8, 0x6b0, 0x6b8, 0x6c0, 0x6c8,
        0x6d0, 0x6d8, -1, -1, -1, -1,    0x6e0, 0x6e8, 0x6f0, 0x6f8};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0xa8;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x50;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x50;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x40;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x60;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x88;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x20;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x48;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x30;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0x18;
#endif  // !defined(PRODUCT) &&
        // defined(TARGET_ARCH_RISCV64) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_ARM) &&                            \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x1c;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x4;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x40;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x28;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0xc;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x4;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0xfffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x0;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x0;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x10;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x7;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff4;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fffa;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0xfffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0x4c;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x1c;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x14;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x2c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x32;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x4, 0x8};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x24;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x1c;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0xc;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0xc;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x8;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0xc;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x4;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x98;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0xd4;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x84;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x274;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x224;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x244;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x21c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x23c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x22c;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x238;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x234;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x8;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0xc;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x174;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x3c0;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x3c4;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x9c;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x10c;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0xa4;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x114;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0xac;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x3e0;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x14c;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x40;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x3c;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x144;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x104;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0x60;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x408;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x2c;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x3e4;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x40c;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x12c;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0xdc;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x15c;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x3d4;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0xf4;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x134;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0x54;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x16c;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x164;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x170;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x3c8;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0x5c;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x3dc;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x384;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x388;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0xe4;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0xec;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x39c;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x3a0;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x124;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x128;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0xcc;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0x68;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0x64;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0x6c;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0x74;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x80;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0x7c;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x88;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x84;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x90;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x8c;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x98;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x94;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0xb4;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0xbc;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0xc0;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0xb8;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x154;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x140;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x3cc;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x3d0;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x3d8;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x34;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x13c;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x1c;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x38c;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x390;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x11c;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0xc4;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x398;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x35c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x360;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x358;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x364;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x368;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x36c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x370;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x374;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x378;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x37c;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x380;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x394;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x24;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x3b0;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x3a8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0xfc;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x3e8;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x138;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x3f8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x14;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x10;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x10;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0xc;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x14;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x24;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x14;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x1a;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x4;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x14;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x4;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0xc;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0xc;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x8;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x4;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x4;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x4;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x4, 0xc, 0x8, 0x10};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x338, 0x33c, 0x340, 0x344, 0x348, -1, 0x34c, -1,
        0x350, 0x354, -1,    -1,    -1,    -1, -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0xc;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x8;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0x54;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0xc;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0xc;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x34;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x1c;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x20;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x2c;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x14;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x20;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x48;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x4;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_Namespace_InstanceSize = 0x14;
static constexpr dart::compiler::target::word AOT_NativeArguments_StructSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Number_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_Object_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_PatchClass_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_PcDescriptors_HeaderSize =
    0x8;
static constexpr dart::compiler::target::word AOT_Pointer_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_ReceivePort_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_RecordType_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_RegExp_InstanceSize = 0x2c;
static constexpr dart::compiler::target::word AOT_Script_InstanceSize = 0x28;
static constexpr dart::compiler::target::word AOT_SendPort_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Sentinel_InstanceSize = 0x4;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_InstanceSize = 0x14;
static constexpr dart::compiler::target::word AOT_StackTrace_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_SuspendState_HeaderSize =
    0x18;
static constexpr dart::compiler::target::word AOT_String_InstanceSize = 0xc;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_LoadingUnit_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word
    AOT_TransferableTypedData_InstanceSize = 0x4;
static constexpr dart::compiler::target::word AOT_Type_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_TypeParameter_InstanceSize =
    0x1c;
static constexpr dart::compiler::target::word AOT_TypeParameters_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word AOT_TypedData_HeaderSize = 0xc;
static constexpr dart::compiler::target::word AOT_TypedDataBase_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word AOT_TypedDataView_InstanceSize =
    0x14;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_InstanceSize = 0xc;
static constexpr dart::compiler::target::word AOT_UnlinkedCall_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_UnwindError_InstanceSize =
    0xc;
static constexpr dart::compiler::target::word AOT_UserTag_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_WeakSerializationReference_InstanceSize = 0xc;
#endif  // defined(PRODUCT) &&
        // defined(TARGET_ARCH_ARM) &&
        // !defined(DART_COMPRESSED_POINTERS)

#if defined(PRODUCT) && defined(TARGET_ARCH_X64) &&                            \
    !defined(DART_COMPRESSED_POINTERS)
static constexpr dart::compiler::target::word AOT_Closure_entry_point_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Array_elements_start_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Array_element_size = 0x8;
static constexpr dart::compiler::target::word AOT_Code_elements_start_offset =
    0x78;
static constexpr dart::compiler::target::word AOT_Code_element_size = 0x4;
static constexpr dart::compiler::target::word
    AOT_Context_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Context_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_ContextScope_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ContextScope_element_size =
    0x50;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_ExceptionHandlers_element_size = 0xc;
static constexpr dart::compiler::target::word
    AOT_ObjectPool_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ObjectPool_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_OneByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_OneByteString_element_size =
    0x1;
static constexpr dart::compiler::target::word AOT_Record_elements_start_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Record_element_size = 0x8;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_elements_start_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeArguments_element_size =
    0x8;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_elements_start_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_element_size =
    0x2;
static constexpr dart::compiler::target::word
    AOT_WeakArray_elements_start_offset = 0x18;
static constexpr dart::compiler::target::word AOT_WeakArray_element_size = 0x8;
static constexpr dart::compiler::target::word AOT_Array_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_Array_kMaxNewSpaceElements =
    0x7ffd;
static constexpr dart::compiler::target::word AOT_Context_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetJIT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetJIT = 0x2a;
static constexpr dart::compiler::target::word
    AOT_Instructions_kMonomorphicEntryOffsetAOT = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_kPolymorphicEntryOffsetAOT = 0x16;
static constexpr dart::compiler::target::word
    AOT_Instructions_kBarePayloadAlignment = 0x4;
static constexpr dart::compiler::target::word
    AOT_Instructions_kNonBarePayloadAlignment = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeEntry_kNumCallWrapperArguments = 0x2;
static constexpr dart::compiler::target::word AOT_Page_kBytesPerCardLog2 = 0x8;
static constexpr dart::compiler::target::word AOT_Record_kMaxElements = 0xffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexMask = 0x3fffffffffff;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kFieldNamesIndexShift = 0x10;
static constexpr dart::compiler::target::word
    AOT_RecordShape_kMaxFieldNamesIndex = 0x3fffffffffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kMaxNumFields =
    0xffff;
static constexpr dart::compiler::target::word AOT_RecordShape_kNumFieldsMask =
    0xffff;
static constexpr dart::compiler::target::word AOT_String_kMaxElements =
    0x1fffffffffffffff;
static constexpr dart::compiler::target::word
    AOT_OneByteString_kMaxNewSpaceElements = 0x3fff0;
static constexpr dart::compiler::target::word
    AOT_TwoByteString_kMaxNewSpaceElements = 0x1fff8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kFunctionTypeArguments = 0x3;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceCidOrSignature = 0x0;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kDestinationType = 0x6;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceDelayedFunctionTypeArguments = 0x5;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceParentFunctionTypeArguments = 0x4;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstanceTypeArguments = 0x1;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kInstantiatorTypeArguments = 0x2;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_kTestEntryLength = 0x8;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kMaxInputs =
    0x7;
static constexpr dart::compiler::target::word AOT_SubtypeTestCache_kTestResult =
    0x7;
static constexpr dart::compiler::target::word AOT_TypeArguments_kMaxElements =
    0x7ffffffffffffff;
static constexpr dart::compiler::target::word AOT_AbstractType_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_AbstractType_hash_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_AbstractType_type_test_stub_entry_point_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_count_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_size_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_first_named_entry_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_named_entry_size = 0x10;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_name_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_position_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_positional_count_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_ArgumentsDescriptor_type_args_len_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Array_length_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Array_tags_offset = 0x0;
static constexpr dart::compiler::target::word AOT_Array_type_arguments_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_Class_declaration_type_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Class_num_type_arguments_offset = 0x7c;
static constexpr dart::compiler::target::word AOT_Class_super_type_offset =
    0x50;
static constexpr dart::compiler::target::word
    AOT_Class_host_type_arguments_field_offset_in_words_offset = 0x88;
static constexpr dart::compiler::target::word AOT_Closure_context_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Closure_delayed_type_arguments_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Closure_function_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Closure_function_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Closure_hash_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Closure_instantiator_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_ClosureData_packed_fields_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Code_instructions_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_Code_object_pool_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Code_owner_offset = 0x38;
static constexpr dart::compiler::target::word AOT_Context_num_variables_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_Context_parent_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Double_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Float64x2_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Field_initializer_function_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Field_host_offset_or_field_id_offset = 0x28;
static constexpr dart::compiler::target::word AOT_Field_guarded_cid_offset =
    0x48;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_in_object_offset_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Field_guarded_list_length_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Field_is_nullable_offset =
    0x4c;
static constexpr dart::compiler::target::word AOT_Field_kind_bits_offset = 0x52;
static constexpr dart::compiler::target::word AOT_Function_code_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Function_data_offset = 0x30;
static constexpr dart::compiler::target::word
    AOT_Function_entry_point_offset[] = {0x8, 0x10};
static constexpr dart::compiler::target::word AOT_Function_kind_tag_offset =
    0x48;
static constexpr dart::compiler::target::word AOT_Function_signature_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FutureOr_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_length_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Page_card_table_offset = 0x20;
static constexpr dart::compiler::target::word AOT_Page_original_top_offset =
    0x38;
static constexpr dart::compiler::target::word AOT_Page_original_end_offset =
    0x40;
static constexpr dart::compiler::target::word
    AOT_CallSiteData_arguments_descriptor_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedMask =
    0x3;
static constexpr dart::compiler::target::word AOT_ICData_NumArgsTestedShift =
    0x0;
static constexpr dart::compiler::target::word AOT_ICData_entries_offset = 0x18;
static constexpr dart::compiler::target::word AOT_ICData_owner_offset = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_state_bits_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_Int32x4_value_offset = 0x8;
static constexpr dart::compiler::target::word AOT_Isolate_current_tag_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Isolate_default_tag_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Isolate_finalizers_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_object_store_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_class_table_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_IsolateGroup_cached_class_table_table_offset = 0x18;
static constexpr dart::compiler::target::word AOT_Isolate_user_tag_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_data_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ImmutableLinkedHashBase_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_deleted_keys_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_hash_mask_offset = 0x10;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_index_offset =
    0x30;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_type_arguments_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_LinkedHashBase_used_data_offset = 0x20;
static constexpr dart::compiler::target::word AOT_LocalHandle_ptr_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_MarkingStackBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_MarkingStackBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_buckets_offset = 0x18;
static constexpr dart::compiler::target::word AOT_MegamorphicCache_mask_offset =
    0x20;
static constexpr dart::compiler::target::word AOT_Mint_value_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_argc_tag_offset = 0x8;
static constexpr dart::compiler::target::word AOT_NativeArguments_argv_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_retval_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_NativeArguments_thread_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_double_type_offset = 0x180;
static constexpr dart::compiler::target::word AOT_ObjectStore_int_type_offset =
    0x130;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_record_field_names_offset = 0x3f0;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_string_type_offset = 0x1a8;
static constexpr dart::compiler::target::word AOT_ObjectStore_type_type_offset =
    0x108;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_ffi_callback_code_offset = 0x4e8;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_offset = 0x440;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_await_with_type_check_offset = 0x448;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_handle_exception_offset = 0x488;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_offset = 0x438;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_async_star_offset = 0x460;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_init_sync_star_offset = 0x478;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_offset = 0x450;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_not_future_offset = 0x458;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_return_async_star_offset = 0x470;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_suspend_sync_star_at_start_offset = 0x480;
static constexpr dart::compiler::target::word
    AOT_ObjectStore_suspend_state_yield_async_star_offset = 0x468;
static constexpr dart::compiler::target::word AOT_OneByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_PersistentHandle_ptr_offset =
    0x0;
static constexpr dart::compiler::target::word AOT_PointerBase_data_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_Pointer_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_ReceivePort_send_port_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_ReceivePort_handler_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_Record_shape_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_entry_point_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_lower_limit_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_target_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SingleTargetCache_upper_limit_offset = 0x1c;
static constexpr dart::compiler::target::word
    AOT_StoreBufferBlock_pointers_offset = 0x10;
static constexpr dart::compiler::target::word AOT_StoreBufferBlock_top_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_StreamInfo_enabled_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_String_hash_offset = 0x4;
static constexpr dart::compiler::target::word AOT_String_length_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_cache_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SubtypeTestCache_num_inputs_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_FrameSizeGrowthGap = 0x0;
static constexpr dart::compiler::target::word
    AOT_SuspendState_error_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_SuspendState_frame_size_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_SuspendState_function_data_offset = 0x18;
static constexpr dart::compiler::target::word AOT_SuspendState_payload_offset =
    0x30;
static constexpr dart::compiler::target::word AOT_SuspendState_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_SuspendState_then_callback_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_AllocateArray_entry_point_offset = 0x2e8;
static constexpr dart::compiler::target::word
    AOT_Thread_active_exception_offset = 0x780;
static constexpr dart::compiler::target::word
    AOT_Thread_active_stacktrace_offset = 0x788;
static constexpr dart::compiler::target::word
    AOT_Thread_array_write_barrier_entry_point_offset = 0x200;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_entry_point_offset = 0x210;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_with_fpu_regs_stub_offset = 0x138;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_entry_point_offset = 0x218;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_mint_without_fpu_regs_stub_offset = 0x140;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_entry_point_offset = 0x220;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_stub_offset = 0x148;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_entry_point_offset = 0x228;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_parameterized_stub_offset = 0x150;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_entry_point_offset = 0x230;
static constexpr dart::compiler::target::word
    AOT_Thread_allocate_object_slow_stub_offset = 0x158;
static constexpr dart::compiler::target::word AOT_Thread_api_top_scope_offset =
    0x7c0;
static constexpr dart::compiler::target::word
    AOT_Thread_async_exception_handler_stub_offset = 0x160;
static constexpr dart::compiler::target::word
    AOT_Thread_auto_scope_native_wrapper_entry_point_offset = 0x298;
static constexpr dart::compiler::target::word AOT_Thread_bool_false_offset =
    0x80;
static constexpr dart::compiler::target::word AOT_Thread_bool_true_offset =
    0x78;
static constexpr dart::compiler::target::word
    AOT_Thread_bootstrap_native_wrapper_entry_point_offset = 0x288;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_entry_point_offset = 0x208;
static constexpr dart::compiler::target::word
    AOT_Thread_call_to_runtime_stub_offset = 0xc0;
static constexpr dart::compiler::target::word AOT_Thread_dart_stream_offset =
    0x800;
static constexpr dart::compiler::target::word
    AOT_Thread_dispatch_table_array_offset = 0x58;
static constexpr dart::compiler::target::word
    AOT_Thread_double_truncate_round_supported_offset = 0x7c8;
static constexpr dart::compiler::target::word
    AOT_Thread_service_extension_stream_offset = 0x808;
static constexpr dart::compiler::target::word AOT_Thread_optimize_entry_offset =
    0x258;
static constexpr dart::compiler::target::word AOT_Thread_optimize_stub_offset =
    0x1b0;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_entry_offset = 0x260;
static constexpr dart::compiler::target::word
    AOT_Thread_deoptimize_stub_offset = 0x1b8;
static constexpr dart::compiler::target::word
    AOT_Thread_double_abs_address_offset = 0x2c0;
static constexpr dart::compiler::target::word
    AOT_Thread_double_negate_address_offset = 0x2b8;
static constexpr dart::compiler::target::word AOT_Thread_end_offset = 0x50;
static constexpr dart::compiler::target::word
    AOT_Thread_enter_safepoint_stub_offset = 0x1e0;
static constexpr dart::compiler::target::word
    AOT_Thread_execution_state_offset = 0x7a8;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_safepoint_stub_offset = 0x1e8;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_stub_offset = 0x1f0;
static constexpr dart::compiler::target::word
    AOT_Thread_call_native_through_safepoint_entry_point_offset = 0x268;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_allocation_stub_code_offset = 0xa8;
static constexpr dart::compiler::target::word
    AOT_Thread_fix_callers_target_code_offset = 0xa0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_absolute_address_offset = 0x2d8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_negate_address_offset = 0x2d0;
static constexpr dart::compiler::target::word
    AOT_Thread_float_not_address_offset = 0x2c8;
static constexpr dart::compiler::target::word
    AOT_Thread_float_zerow_address_offset = 0x2e0;
static constexpr dart::compiler::target::word
    AOT_Thread_global_object_pool_offset = 0x790;
static constexpr dart::compiler::target::word
    AOT_Thread_interpret_call_entry_point_offset = 0x2a0;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_from_bytecode_stub_offset = 0xb8;
static constexpr dart::compiler::target::word
    AOT_Thread_invoke_dart_code_stub_offset = 0xb0;
static constexpr dart::compiler::target::word
    AOT_Thread_exit_through_ffi_offset = 0x7b8;
static constexpr dart::compiler::target::word AOT_Thread_isolate_offset = 0x720;
static constexpr dart::compiler::target::word AOT_Thread_isolate_group_offset =
    0x728;
static constexpr dart::compiler::target::word
    AOT_Thread_field_table_values_offset = 0x60;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_return_stub_offset = 0x1c0;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_deopt_from_throw_stub_offset = 0x1c8;
static constexpr dart::compiler::target::word
    AOT_Thread_lazy_specialize_type_test_stub_offset = 0x1d8;
static constexpr dart::compiler::target::word
    AOT_Thread_old_marking_stack_block_offset = 0x750;
static constexpr dart::compiler::target::word
    AOT_Thread_new_marking_stack_block_offset = 0x758;
static constexpr dart::compiler::target::word
    AOT_Thread_megamorphic_call_checked_entry_offset = 0x248;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_entry_offset = 0x250;
static constexpr dart::compiler::target::word
    AOT_Thread_switchable_call_miss_stub_offset = 0x198;
static constexpr dart::compiler::target::word
    AOT_Thread_no_scope_native_wrapper_entry_point_offset = 0x290;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_with_fpu_regs_stub_offset =
        0xd0;
static constexpr dart::compiler::target::word
    AOT_Thread_late_initialization_error_shared_without_fpu_regs_stub_offset =
        0xc8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_with_fpu_regs_stub_offset = 0xe0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_error_shared_without_fpu_regs_stub_offset = 0xd8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_with_fpu_regs_stub_offset = 0xf0;
static constexpr dart::compiler::target::word
    AOT_Thread_null_arg_error_shared_without_fpu_regs_stub_offset = 0xe8;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_with_fpu_regs_stub_offset = 0x100;
static constexpr dart::compiler::target::word
    AOT_Thread_null_cast_error_shared_without_fpu_regs_stub_offset = 0xf8;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_with_fpu_regs_stub_offset = 0x110;
static constexpr dart::compiler::target::word
    AOT_Thread_range_error_shared_without_fpu_regs_stub_offset = 0x108;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_with_fpu_regs_stub_offset = 0x120;
static constexpr dart::compiler::target::word
    AOT_Thread_write_error_shared_without_fpu_regs_stub_offset = 0x118;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_with_fpu_regs_stub_offset = 0x130;
static constexpr dart::compiler::target::word
    AOT_Thread_field_access_error_shared_without_fpu_regs_stub_offset = 0x128;
static constexpr dart::compiler::target::word AOT_Thread_resume_stub_offset =
    0x168;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_not_future_stub_offset = 0x178;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_star_stub_offset = 0x180;
static constexpr dart::compiler::target::word
    AOT_Thread_return_async_stub_offset = 0x170;
static constexpr dart::compiler::target::word AOT_Thread_object_null_offset =
    0x70;
static constexpr dart::compiler::target::word
    AOT_Thread_predefined_symbols_address_offset = 0x2a8;
static constexpr dart::compiler::target::word
    AOT_Thread_resume_interpreter_adjusted_entry_point_offset = 0x280;
static constexpr dart::compiler::target::word AOT_Thread_resume_pc_offset =
    0x798;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_shadow_call_stack_offset = 0x7a0;
static constexpr dart::compiler::target::word
    AOT_Thread_safepoint_state_offset = 0x7b0;
static constexpr dart::compiler::target::word
    AOT_Thread_shared_field_table_values_offset = 0x68;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_stub_offset = 0x1d0;
static constexpr dart::compiler::target::word
    AOT_Thread_slow_type_test_entry_point_offset = 0x278;
static constexpr dart::compiler::target::word AOT_Thread_stack_limit_offset =
    0x38;
static constexpr dart::compiler::target::word
    AOT_Thread_saved_stack_limit_offset = 0x730;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_flags_offset = 0x738;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_entry_point_offset = 0x240;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_with_fpu_regs_stub_offset = 0x190;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_entry_point_offset =
        0x238;
static constexpr dart::compiler::target::word
    AOT_Thread_stack_overflow_shared_without_fpu_regs_stub_offset = 0x188;
static constexpr dart::compiler::target::word
    AOT_Thread_store_buffer_block_offset = 0x748;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_entry_point_offset = 0x6d0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_await_with_type_check_entry_point_offset = 0x6d8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_entry_point_offset = 0x6c8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_entry_point_offset = 0x6e0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_not_future_entry_point_offset = 0x6e8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_async_star_entry_point_offset = 0x6f0;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_yield_async_star_entry_point_offset = 0x6f8;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_return_async_star_entry_point_offset = 0x700;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_init_sync_star_entry_point_offset = 0x708;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_suspend_sync_star_at_start_entry_point_offset =
        0x710;
static constexpr dart::compiler::target::word
    AOT_Thread_suspend_state_handle_exception_entry_point_offset = 0x718;
static constexpr dart::compiler::target::word
    AOT_Thread_top_exit_frame_info_offset = 0x740;
static constexpr dart::compiler::target::word AOT_Thread_top_offset = 0x48;
static constexpr dart::compiler::target::word AOT_Thread_top_resource_offset =
    0x20;
static constexpr dart::compiler::target::word
    AOT_Thread_unboxed_runtime_arg_offset = 0x770;
static constexpr dart::compiler::target::word AOT_Thread_vm_tag_offset = 0x768;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_entry_point_offset = 0x1f8;
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_mask_offset = 0x40;
static constexpr dart::compiler::target::word AOT_Thread_next_task_id_offset =
    0x7d0;
static constexpr dart::compiler::target::word AOT_Thread_random_offset = 0x7d8;
static constexpr dart::compiler::target::word
    AOT_Thread_jump_to_frame_entry_point_offset = 0x270;
static constexpr dart::compiler::target::word AOT_Thread_tsan_utils_offset =
    0x7e0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_function_offset = 0x0;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_setjmp_buffer_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_pc_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_sp_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TsanUtils_exception_fp_offset = 0x20;
static constexpr dart::compiler::target::word
    AOT_TimelineStream_enabled_offset = 0x10;
static constexpr dart::compiler::target::word AOT_TwoByteString_data_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_Type_arguments_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_Finalizer_type_arguments_offset = 0x30;
static constexpr dart::compiler::target::word AOT_Finalizer_callback_offset =
    0x28;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_all_entries_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_detachments_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerBase_entries_collected_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerBase_isolate_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_detach_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_external_size_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FinalizerEntry_finalizer_offset = 0x20;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_next_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_token_offset =
    0x18;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_value_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_NativeFinalizer_callback_offset = 0x28;
static constexpr dart::compiler::target::word
    AOT_FunctionType_named_parameter_names_offset = 0x40;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_parameter_counts_offset = 0x48;
static constexpr dart::compiler::target::word
    AOT_FunctionType_packed_type_parameter_counts_offset = 0x4c;
static constexpr dart::compiler::target::word
    AOT_FunctionType_parameter_types_offset = 0x38;
static constexpr dart::compiler::target::word
    AOT_FunctionType_type_parameters_offset = 0x28;
static constexpr dart::compiler::target::word AOT_TypeParameter_index_offset =
    0x32;
static constexpr dart::compiler::target::word AOT_TypeArguments_hash_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_instantiations_offset = 0x8;
static constexpr dart::compiler::target::word AOT_TypeArguments_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypeArguments_nullability_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypeArguments_types_offset =
    0x28;
static constexpr dart::compiler::target::word AOT_TypeParameters_names_offset =
    0x8;
static constexpr dart::compiler::target::word AOT_TypeParameters_flags_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_TypeParameters_bounds_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_TypeParameters_defaults_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedDataBase_length_offset =
    0x10;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_typed_data_offset = 0x18;
static constexpr dart::compiler::target::word
    AOT_TypedDataView_offset_in_bytes_offset = 0x20;
static constexpr dart::compiler::target::word AOT_TypedData_payload_offset =
    0x18;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_exception_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_UnhandledException_stacktrace_offset = 0x10;
static constexpr dart::compiler::target::word AOT_UserTag_tag_offset = 0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_expected_cid_offset = 0x8;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_entrypoint_offset = 0x10;
static constexpr dart::compiler::target::word AOT_WeakProperty_key_offset = 0x8;
static constexpr dart::compiler::target::word AOT_WeakProperty_value_offset =
    0x10;
static constexpr dart::compiler::target::word AOT_WeakReference_target_offset =
    0x8;
static constexpr dart::compiler::target::word
    AOT_WeakReference_type_arguments_offset = 0x10;
static constexpr dart::compiler::target::word AOT_Code_entry_point_offset[] = {
    0x8, 0x18, 0x10, 0x20};
static constexpr dart::compiler::target::word
    AOT_Thread_write_barrier_wrappers_thread_offset[] = {
        0x670, 0x678, 0x680, 0x688, -1,    -1,    0x690, 0x698,
        0x6a0, 0x6a8, 0x6b0, -1,    0x6b8, 0x6c0, -1,    -1};
static constexpr dart::compiler::target::word AOT_AbstractType_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_ApiError_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Array_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Bool_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_Bytecode_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Capability_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word AOT_Class_InstanceSize = 0x90;
static constexpr dart::compiler::target::word AOT_Closure_InstanceSize = 0x40;
static constexpr dart::compiler::target::word AOT_ClosureData_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_CodeSourceMap_HeaderSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_ObjectHeaderSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_CompressedStackMaps_PayloadHeaderSize = 0x4;
static constexpr dart::compiler::target::word AOT_Context_header_size = 0x18;
static constexpr dart::compiler::target::word AOT_Double_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_DynamicLibrary_InstanceSize =
    0x18;
static constexpr dart::compiler::target::word
    AOT_ExternalTypedData_InstanceSize = 0x18;
static constexpr dart::compiler::target::word
    AOT_FfiTrampolineData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Field_InstanceSize = 0x58;
static constexpr dart::compiler::target::word AOT_Finalizer_InstanceSize = 0x38;
static constexpr dart::compiler::target::word AOT_FinalizerEntry_InstanceSize =
    0x40;
static constexpr dart::compiler::target::word AOT_NativeFinalizer_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Float32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Float64x2_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Function_InstanceSize = 0x50;
static constexpr dart::compiler::target::word AOT_FunctionType_InstanceSize =
    0x50;
static constexpr dart::compiler::target::word AOT_FutureOr_InstanceSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_GrowableObjectArray_InstanceSize = 0x20;
static constexpr dart::compiler::target::word AOT_ICData_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Instance_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_Instructions_UnalignedHeaderSize = 0x10;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_UnalignedHeaderSize = 0x28;
static constexpr dart::compiler::target::word
    AOT_InstructionsSection_HeaderSize = 0x40;
static constexpr dart::compiler::target::word
    AOT_InstructionsTable_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Int32x4_InstanceSize = 0x18;
static constexpr dart::compiler::target::word AOT_Integer_InstanceSize = 0x8;
static constexpr dart::compiler::target::word
    AOT_KernelProgramInfo_InstanceSize = 0x60;
static constexpr dart::compiler::target::word AOT_LanguageError_InstanceSize =
    0x30;
static constexpr dart::compiler::target::word AOT_Library_InstanceSize = 0x88;
static constexpr dart::compiler::target::word AOT_LibraryPrefix_InstanceSize =
    0x28;
static constexpr dart::compiler::target::word AOT_LinkedHashBase_InstanceSize =
    0x38;
static constexpr dart::compiler::target::word AOT_LocalHandle_InstanceSize =
    0x8;
static constexpr dart::compiler::target::word
    AOT_MegamorphicCache_InstanceSize = 0x30;
static constexpr dart::compiler::target::word AOT_Mint_InstanceSize = 0x10;
static constexpr dart::compiler::target::word AOT_MirrorReference_InstanceSize =
    0x10;
static constexpr dart::compiler::target::word
    AOT_MonomorphicSmiableCall_InstanceSize = 0x18;
st