/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "secret-dbus-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_algorithm,
        GVariant *arg_input,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_properties,
        const gchar *arg_alias,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_attributes,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_objects,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_items,
        const gchar *arg_session,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_name,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_name,
        const gchar *arg_collection,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantVariantBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_properties,
        GVariant *arg_secret,
        gboolean arg_replace,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantVariantBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantVariantBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__BOOLEAN_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_BooleanVariantFunc)
       (void *data1,
        gboolean arg_dismissed,
        GVariant *arg_result,
        void *data2);
  _GDbusCodegenMarshalVoid_BooleanVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_BooleanVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_boolean (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Secret.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_SecretGenService
 * @title: _SecretGenService
 * @short_description: Generated C code for the org.freedesktop.Secret.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link> D-Bus interface in C.
 */

enum
{
  _SECRET_GEN__SERVICE_COLLECTION_CREATED,
  _SECRET_GEN__SERVICE_COLLECTION_DELETED,
  _SECRET_GEN__SERVICE_COLLECTION_CHANGED,
};

static unsigned _SECRET_GEN__SERVICE_SIGNALS[3] = { 0 };

/* ---- Introspection data for org.freedesktop.Secret.Service ---- */

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_open_session_IN_ARG_algorithm =
{
  {
    -1,
    (gchar *) "algorithm",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_open_session_IN_ARG_input =
{
  {
    -1,
    (gchar *) "input",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_open_session_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_open_session_IN_ARG_algorithm.parent_struct,
  &__secret_gen_service_method_info_open_session_IN_ARG_input.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_open_session_OUT_ARG_output =
{
  {
    -1,
    (gchar *) "output",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_open_session_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_open_session_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_open_session_OUT_ARG_output.parent_struct,
  &__secret_gen_service_method_info_open_session_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_open_session =
{
  {
    -1,
    (gchar *) "OpenSession",
    (GDBusArgInfo **) &__secret_gen_service_method_info_open_session_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_open_session_OUT_ARG_pointers,
    NULL
  },
  "handle-open-session",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_create_collection_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_create_collection_IN_ARG_alias =
{
  {
    -1,
    (gchar *) "alias",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_create_collection_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_create_collection_IN_ARG_properties.parent_struct,
  &__secret_gen_service_method_info_create_collection_IN_ARG_alias.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_create_collection_OUT_ARG_collection =
{
  {
    -1,
    (gchar *) "collection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_create_collection_OUT_ARG_prompt =
{
  {
    -1,
    (gchar *) "prompt",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_create_collection_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_create_collection_OUT_ARG_collection.parent_struct,
  &__secret_gen_service_method_info_create_collection_OUT_ARG_prompt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_create_collection =
{
  {
    -1,
    (gchar *) "CreateCollection",
    (GDBusArgInfo **) &__secret_gen_service_method_info_create_collection_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_create_collection_OUT_ARG_pointers,
    NULL
  },
  "handle-create-collection",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_search_items_IN_ARG_attributes =
{
  {
    -1,
    (gchar *) "attributes",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_search_items_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_search_items_IN_ARG_attributes.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_search_items_OUT_ARG_unlocked =
{
  {
    -1,
    (gchar *) "unlocked",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_search_items_OUT_ARG_locked =
{
  {
    -1,
    (gchar *) "locked",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_search_items_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_search_items_OUT_ARG_unlocked.parent_struct,
  &__secret_gen_service_method_info_search_items_OUT_ARG_locked.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_search_items =
{
  {
    -1,
    (gchar *) "SearchItems",
    (GDBusArgInfo **) &__secret_gen_service_method_info_search_items_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_search_items_OUT_ARG_pointers,
    NULL
  },
  "handle-search-items",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_unlock_IN_ARG_objects =
{
  {
    -1,
    (gchar *) "objects",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_unlock_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_unlock_IN_ARG_objects.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_unlock_OUT_ARG_unlocked =
{
  {
    -1,
    (gchar *) "unlocked",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_unlock_OUT_ARG_prompt =
{
  {
    -1,
    (gchar *) "prompt",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_unlock_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_unlock_OUT_ARG_unlocked.parent_struct,
  &__secret_gen_service_method_info_unlock_OUT_ARG_prompt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_unlock =
{
  {
    -1,
    (gchar *) "Unlock",
    (GDBusArgInfo **) &__secret_gen_service_method_info_unlock_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_unlock_OUT_ARG_pointers,
    NULL
  },
  "handle-unlock",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_lock_IN_ARG_objects =
{
  {
    -1,
    (gchar *) "objects",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_lock_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_lock_IN_ARG_objects.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_lock_OUT_ARG_locked =
{
  {
    -1,
    (gchar *) "locked",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_lock_OUT_ARG_Prompt =
{
  {
    -1,
    (gchar *) "Prompt",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_lock_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_lock_OUT_ARG_locked.parent_struct,
  &__secret_gen_service_method_info_lock_OUT_ARG_Prompt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    (GDBusArgInfo **) &__secret_gen_service_method_info_lock_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_lock_OUT_ARG_pointers,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_get_secrets_IN_ARG_items =
{
  {
    -1,
    (gchar *) "items",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_get_secrets_IN_ARG_session =
{
  {
    -1,
    (gchar *) "session",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_get_secrets_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_get_secrets_IN_ARG_items.parent_struct,
  &__secret_gen_service_method_info_get_secrets_IN_ARG_session.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_get_secrets_OUT_ARG_secrets =
{
  {
    -1,
    (gchar *) "secrets",
    (gchar *) "a{o(oayays)}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_get_secrets_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_get_secrets_OUT_ARG_secrets.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_get_secrets =
{
  {
    -1,
    (gchar *) "GetSecrets",
    (GDBusArgInfo **) &__secret_gen_service_method_info_get_secrets_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_get_secrets_OUT_ARG_pointers,
    NULL
  },
  "handle-get-secrets",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_read_alias_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_read_alias_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_read_alias_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_read_alias_OUT_ARG_collection =
{
  {
    -1,
    (gchar *) "collection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_read_alias_OUT_ARG_pointers[] =
{
  &__secret_gen_service_method_info_read_alias_OUT_ARG_collection.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_read_alias =
{
  {
    -1,
    (gchar *) "ReadAlias",
    (GDBusArgInfo **) &__secret_gen_service_method_info_read_alias_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_service_method_info_read_alias_OUT_ARG_pointers,
    NULL
  },
  "handle-read-alias",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_set_alias_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_service_method_info_set_alias_IN_ARG_collection =
{
  {
    -1,
    (gchar *) "collection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_method_info_set_alias_IN_ARG_pointers[] =
{
  &__secret_gen_service_method_info_set_alias_IN_ARG_name.parent_struct,
  &__secret_gen_service_method_info_set_alias_IN_ARG_collection.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_service_method_info_set_alias =
{
  {
    -1,
    (gchar *) "SetAlias",
    (GDBusArgInfo **) &__secret_gen_service_method_info_set_alias_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-alias",
  FALSE
};

static const GDBusMethodInfo * const __secret_gen_service_method_info_pointers[] =
{
  &__secret_gen_service_method_info_open_session.parent_struct,
  &__secret_gen_service_method_info_create_collection.parent_struct,
  &__secret_gen_service_method_info_search_items.parent_struct,
  &__secret_gen_service_method_info_unlock.parent_struct,
  &__secret_gen_service_method_info_lock.parent_struct,
  &__secret_gen_service_method_info_get_secrets.parent_struct,
  &__secret_gen_service_method_info_read_alias.parent_struct,
  &__secret_gen_service_method_info_set_alias.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_service_signal_info_collection_created_ARG_collection =
{
  {
    -1,
    (gchar *) "collection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_signal_info_collection_created_ARG_pointers[] =
{
  &__secret_gen_service_signal_info_collection_created_ARG_collection.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_service_signal_info_collection_created =
{
  {
    -1,
    (gchar *) "CollectionCreated",
    (GDBusArgInfo **) &__secret_gen_service_signal_info_collection_created_ARG_pointers,
    NULL
  },
  "collection-created"
};

static const _ExtendedGDBusArgInfo __secret_gen_service_signal_info_collection_deleted_ARG_collection =
{
  {
    -1,
    (gchar *) "collection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_signal_info_collection_deleted_ARG_pointers[] =
{
  &__secret_gen_service_signal_info_collection_deleted_ARG_collection.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_service_signal_info_collection_deleted =
{
  {
    -1,
    (gchar *) "CollectionDeleted",
    (GDBusArgInfo **) &__secret_gen_service_signal_info_collection_deleted_ARG_pointers,
    NULL
  },
  "collection-deleted"
};

static const _ExtendedGDBusArgInfo __secret_gen_service_signal_info_collection_changed_ARG_collection =
{
  {
    -1,
    (gchar *) "collection",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_service_signal_info_collection_changed_ARG_pointers[] =
{
  &__secret_gen_service_signal_info_collection_changed_ARG_collection.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_service_signal_info_collection_changed =
{
  {
    -1,
    (gchar *) "CollectionChanged",
    (GDBusArgInfo **) &__secret_gen_service_signal_info_collection_changed_ARG_pointers,
    NULL
  },
  "collection-changed"
};

static const GDBusSignalInfo * const __secret_gen_service_signal_info_pointers[] =
{
  &__secret_gen_service_signal_info_collection_created.parent_struct,
  &__secret_gen_service_signal_info_collection_deleted.parent_struct,
  &__secret_gen_service_signal_info_collection_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo __secret_gen_service_property_info_collections =
{
  {
    -1,
    (gchar *) "Collections",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "collections",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const __secret_gen_service_property_info_pointers[] =
{
  &__secret_gen_service_property_info_collections.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __secret_gen_service_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Secret.Service",
    (GDBusMethodInfo **) &__secret_gen_service_method_info_pointers,
    (GDBusSignalInfo **) &__secret_gen_service_signal_info_pointers,
    (GDBusPropertyInfo **) &__secret_gen_service_property_info_pointers,
    NULL
  },
  "service",
};


/**
 * _secret_gen_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_secret_gen_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__secret_gen_service_interface_info.parent_struct;
}

/**
 * _secret_gen_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_SecretGenService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_secret_gen_service_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "collections");
  return property_id_begin - 1;
}


inline static void
_secret_gen_service_signal_marshal_collection_created (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_signal_marshal_collection_deleted (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_signal_marshal_collection_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_open_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_create_collection (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_search_items (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_unlock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_lock (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_get_secrets (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_read_alias (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_service_method_marshal_set_alias (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _SecretGenService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link>.
 */

/**
 * _SecretGenServiceIface:
 * @parent_iface: The parent interface.
 * @handle_create_collection: Handler for the #_SecretGenService::handle-create-collection signal.
 * @handle_get_secrets: Handler for the #_SecretGenService::handle-get-secrets signal.
 * @handle_lock: Handler for the #_SecretGenService::handle-lock signal.
 * @handle_open_session: Handler for the #_SecretGenService::handle-open-session signal.
 * @handle_read_alias: Handler for the #_SecretGenService::handle-read-alias signal.
 * @handle_search_items: Handler for the #_SecretGenService::handle-search-items signal.
 * @handle_set_alias: Handler for the #_SecretGenService::handle-set-alias signal.
 * @handle_unlock: Handler for the #_SecretGenService::handle-unlock signal.
 * @get_collections: Getter for the #_SecretGenService:collections property.
 * @collection_changed: Handler for the #_SecretGenService::collection-changed signal.
 * @collection_created: Handler for the #_SecretGenService::collection-created signal.
 * @collection_deleted: Handler for the #_SecretGenService::collection-deleted signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link>.
 */

typedef _SecretGenServiceIface _SecretGenServiceInterface;
G_DEFINE_INTERFACE (_SecretGenService, _secret_gen_service, G_TYPE_OBJECT)

static void
_secret_gen_service_default_init (_SecretGenServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _SecretGenService::handle-open-session:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_algorithm: Argument passed by remote caller.
   * @arg_input: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.OpenSession">OpenSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_open_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_open_session),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_open_session,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * _SecretGenService::handle-create-collection:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   * @arg_alias: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.CreateCollection">CreateCollection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_create_collection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-collection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_create_collection),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_create_collection,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_STRING);

  /**
   * _SecretGenService::handle-search-items:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_attributes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SearchItems">SearchItems()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_search_items() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-search-items",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_search_items),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_search_items,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * _SecretGenService::handle-unlock:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_objects: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Unlock">Unlock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_unlock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unlock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_unlock),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_unlock,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * _SecretGenService::handle-lock:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_objects: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_lock,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * _SecretGenService::handle-get-secrets:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_items: Argument passed by remote caller.
   * @arg_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.GetSecrets">GetSecrets()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_get_secrets() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-secrets",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_get_secrets),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_get_secrets,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV, G_TYPE_STRING);

  /**
   * _SecretGenService::handle-read-alias:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.ReadAlias">ReadAlias()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_read_alias() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-read-alias",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_read_alias),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_read_alias,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * _SecretGenService::handle-set-alias:
   * @object: A #_SecretGenService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_collection: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SetAlias">SetAlias()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_service_complete_set_alias() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-alias",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenServiceIface, handle_set_alias),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_service_method_marshal_set_alias,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * _SecretGenService::collection-created:
   * @object: A #_SecretGenService.
   * @arg_collection: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Service.CollectionCreated">"CollectionCreated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__SERVICE_SIGNALS[_SECRET_GEN__SERVICE_COLLECTION_CREATED] =
    g_signal_new ("collection-created",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenServiceIface, collection_created),
      NULL,
      NULL,
      _secret_gen_service_signal_marshal_collection_created,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * _SecretGenService::collection-deleted:
   * @object: A #_SecretGenService.
   * @arg_collection: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Service.CollectionDeleted">"CollectionDeleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__SERVICE_SIGNALS[_SECRET_GEN__SERVICE_COLLECTION_DELETED] =
    g_signal_new ("collection-deleted",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenServiceIface, collection_deleted),
      NULL,
      NULL,
      _secret_gen_service_signal_marshal_collection_deleted,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * _SecretGenService::collection-changed:
   * @object: A #_SecretGenService.
   * @arg_collection: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Service.CollectionChanged">"CollectionChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__SERVICE_SIGNALS[_SECRET_GEN__SERVICE_COLLECTION_CHANGED] =
    g_signal_new ("collection-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenServiceIface, collection_changed),
      NULL,
      NULL,
      _secret_gen_service_signal_marshal_collection_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * _SecretGenService:collections:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Service.Collections">"Collections"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("collections", "Collections", "Collections", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * _secret_gen_service_get_collections: (skip)
 * @object: A #_SecretGenService.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Service.Collections">"Collections"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _secret_gen_service_dup_collections() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
_secret_gen_service_get_collections (_SecretGenService *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_SERVICE (object), NULL);

  return _SECRET_GEN_SERVICE_GET_IFACE (object)->get_collections (object);
}

/**
 * _secret_gen_service_dup_collections: (skip)
 * @object: A #_SecretGenService.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Secret-Service.Collections">"Collections"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
_secret_gen_service_dup_collections (_SecretGenService *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "collections", &value, NULL);
  return value;
}

/**
 * _secret_gen_service_set_collections: (skip)
 * @object: A #_SecretGenService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Service.Collections">"Collections"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_service_set_collections (_SecretGenService *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "collections", value, NULL);
}

/**
 * _secret_gen_service_emit_collection_created:
 * @object: A #_SecretGenService.
 * @arg_collection: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Service.CollectionCreated">"CollectionCreated"</link> D-Bus signal.
 */
void
_secret_gen_service_emit_collection_created (
    _SecretGenService *object,
    const gchar *arg_collection)
{
  g_signal_emit (object, _SECRET_GEN__SERVICE_SIGNALS[_SECRET_GEN__SERVICE_COLLECTION_CREATED], 0, arg_collection);
}

/**
 * _secret_gen_service_emit_collection_deleted:
 * @object: A #_SecretGenService.
 * @arg_collection: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Service.CollectionDeleted">"CollectionDeleted"</link> D-Bus signal.
 */
void
_secret_gen_service_emit_collection_deleted (
    _SecretGenService *object,
    const gchar *arg_collection)
{
  g_signal_emit (object, _SECRET_GEN__SERVICE_SIGNALS[_SECRET_GEN__SERVICE_COLLECTION_DELETED], 0, arg_collection);
}

/**
 * _secret_gen_service_emit_collection_changed:
 * @object: A #_SecretGenService.
 * @arg_collection: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Service.CollectionChanged">"CollectionChanged"</link> D-Bus signal.
 */
void
_secret_gen_service_emit_collection_changed (
    _SecretGenService *object,
    const gchar *arg_collection)
{
  g_signal_emit (object, _SECRET_GEN__SERVICE_SIGNALS[_SECRET_GEN__SERVICE_COLLECTION_CHANGED], 0, arg_collection);
}

/**
 * _secret_gen_service_call_open_session:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_algorithm: Argument to pass with the method invocation.
 * @arg_input: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.OpenSession">OpenSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_open_session_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_open_session_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_open_session (
    _SecretGenService *proxy,
    const gchar *arg_algorithm,
    GVariant *arg_input,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenSession",
    g_variant_new ("(s@v)",
                   arg_algorithm,
                   arg_input),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_open_session_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_output: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_open_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_open_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_open_session_finish (
    _SecretGenService *proxy,
    GVariant **out_output,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@vo)",
                 out_output,
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_open_session_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_algorithm: Argument to pass with the method invocation.
 * @arg_input: Argument to pass with the method invocation.
 * @out_output: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.OpenSession">OpenSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_open_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_open_session_sync (
    _SecretGenService *proxy,
    const gchar *arg_algorithm,
    GVariant *arg_input,
    GVariant **out_output,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenSession",
    g_variant_new ("(s@v)",
                   arg_algorithm,
                   arg_input),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@vo)",
                 out_output,
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_create_collection:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_alias: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.CreateCollection">CreateCollection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_create_collection_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_create_collection_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_create_collection (
    _SecretGenService *proxy,
    GVariant *arg_properties,
    const gchar *arg_alias,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateCollection",
    g_variant_new ("(@a{sv}s)",
                   arg_properties,
                   arg_alias),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_create_collection_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_collection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_create_collection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_create_collection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_create_collection_finish (
    _SecretGenService *proxy,
    gchar **out_collection,
    gchar **out_prompt,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo)",
                 out_collection,
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_create_collection_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_alias: Argument to pass with the method invocation.
 * @out_collection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.CreateCollection">CreateCollection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_create_collection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_create_collection_sync (
    _SecretGenService *proxy,
    GVariant *arg_properties,
    const gchar *arg_alias,
    gchar **out_collection,
    gchar **out_prompt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateCollection",
    g_variant_new ("(@a{sv}s)",
                   arg_properties,
                   arg_alias),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo)",
                 out_collection,
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_search_items:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SearchItems">SearchItems()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_search_items_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_search_items_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_search_items (
    _SecretGenService *proxy,
    GVariant *arg_attributes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SearchItems",
    g_variant_new ("(@a{ss})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_search_items_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_unlocked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_locked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_search_items().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_search_items().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_search_items_finish (
    _SecretGenService *proxy,
    gchar ***out_unlocked,
    gchar ***out_locked,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao^ao)",
                 out_unlocked,
                 out_locked);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_search_items_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @out_unlocked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_locked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SearchItems">SearchItems()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_search_items() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_search_items_sync (
    _SecretGenService *proxy,
    GVariant *arg_attributes,
    gchar ***out_unlocked,
    gchar ***out_locked,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SearchItems",
    g_variant_new ("(@a{ss})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao^ao)",
                 out_unlocked,
                 out_locked);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_unlock:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_objects: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Unlock">Unlock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_unlock_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_unlock_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_unlock (
    _SecretGenService *proxy,
    const gchar *const *arg_objects,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("(^ao)",
                   arg_objects),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_unlock_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_unlocked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_unlock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_unlock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_unlock_finish (
    _SecretGenService *proxy,
    gchar ***out_unlocked,
    gchar **out_prompt,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^aoo)",
                 out_unlocked,
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_unlock_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_objects: Argument to pass with the method invocation.
 * @out_unlocked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Unlock">Unlock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_unlock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_unlock_sync (
    _SecretGenService *proxy,
    const gchar *const *arg_objects,
    gchar ***out_unlocked,
    gchar **out_prompt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Unlock",
    g_variant_new ("(^ao)",
                   arg_objects),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^aoo)",
                 out_unlocked,
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_lock:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_objects: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_lock_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_lock (
    _SecretGenService *proxy,
    const gchar *const *arg_objects,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("(^ao)",
                   arg_objects),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_lock_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_locked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_Prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_lock_finish (
    _SecretGenService *proxy,
    gchar ***out_locked,
    gchar **out_Prompt,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^aoo)",
                 out_locked,
                 out_Prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_lock_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_objects: Argument to pass with the method invocation.
 * @out_locked: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_Prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_lock_sync (
    _SecretGenService *proxy,
    const gchar *const *arg_objects,
    gchar ***out_locked,
    gchar **out_Prompt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("(^ao)",
                   arg_objects),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^aoo)",
                 out_locked,
                 out_Prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_get_secrets:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_items: Argument to pass with the method invocation.
 * @arg_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.GetSecrets">GetSecrets()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_get_secrets_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_get_secrets_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_get_secrets (
    _SecretGenService *proxy,
    const gchar *const *arg_items,
    const gchar *arg_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSecrets",
    g_variant_new ("(^aoo)",
                   arg_items,
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_get_secrets_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_secrets: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_get_secrets().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_get_secrets().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_get_secrets_finish (
    _SecretGenService *proxy,
    GVariant **out_secrets,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{o(oayays)})",
                 out_secrets);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_get_secrets_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_items: Argument to pass with the method invocation.
 * @arg_session: Argument to pass with the method invocation.
 * @out_secrets: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.GetSecrets">GetSecrets()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_get_secrets() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_get_secrets_sync (
    _SecretGenService *proxy,
    const gchar *const *arg_items,
    const gchar *arg_session,
    GVariant **out_secrets,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSecrets",
    g_variant_new ("(^aoo)",
                   arg_items,
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{o(oayays)})",
                 out_secrets);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_read_alias:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.ReadAlias">ReadAlias()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_read_alias_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_read_alias_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_read_alias (
    _SecretGenService *proxy,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReadAlias",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_read_alias_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @out_collection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_read_alias().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_read_alias().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_read_alias_finish (
    _SecretGenService *proxy,
    gchar **out_collection,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_collection);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_read_alias_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @out_collection: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.ReadAlias">ReadAlias()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_read_alias() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_read_alias_sync (
    _SecretGenService *proxy,
    const gchar *arg_name,
    gchar **out_collection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReadAlias",
    g_variant_new ("(s)",
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_collection);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_set_alias:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_collection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SetAlias">SetAlias()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_call_set_alias_finish() to get the result of the operation.
 *
 * See _secret_gen_service_call_set_alias_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_service_call_set_alias (
    _SecretGenService *proxy,
    const gchar *arg_name,
    const gchar *arg_collection,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetAlias",
    g_variant_new ("(so)",
                   arg_name,
                   arg_collection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_service_call_set_alias_finish:
 * @proxy: A #_SecretGenServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_call_set_alias().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_service_call_set_alias().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_set_alias_finish (
    _SecretGenService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_call_set_alias_sync:
 * @proxy: A #_SecretGenServiceProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_collection: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SetAlias">SetAlias()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_call_set_alias() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_service_call_set_alias_sync (
    _SecretGenService *proxy,
    const gchar *arg_name,
    const gchar *arg_collection,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetAlias",
    g_variant_new ("(so)",
                   arg_name,
                   arg_collection),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_service_complete_open_session:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @output: Parameter to return.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.OpenSession">OpenSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_open_session (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *output,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@vo)",
                   output,
                   result));
}

/**
 * _secret_gen_service_complete_create_collection:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @collection: Parameter to return.
 * @prompt: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.CreateCollection">CreateCollection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_create_collection (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *collection,
    const gchar *prompt)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(oo)",
                   collection,
                   prompt));
}

/**
 * _secret_gen_service_complete_search_items:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unlocked: Parameter to return.
 * @locked: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SearchItems">SearchItems()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_search_items (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *unlocked,
    const gchar *const *locked)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao^ao)",
                   unlocked,
                   locked));
}

/**
 * _secret_gen_service_complete_unlock:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unlocked: Parameter to return.
 * @prompt: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Unlock">Unlock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_unlock (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *unlocked,
    const gchar *prompt)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^aoo)",
                   unlocked,
                   prompt));
}

/**
 * _secret_gen_service_complete_lock:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @locked: Parameter to return.
 * @Prompt: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_lock (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *locked,
    const gchar *Prompt)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^aoo)",
                   locked,
                   Prompt));
}

/**
 * _secret_gen_service_complete_get_secrets:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @secrets: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.GetSecrets">GetSecrets()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_get_secrets (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *secrets)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{o(oayays)})",
                   secrets));
}

/**
 * _secret_gen_service_complete_read_alias:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @collection: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.ReadAlias">ReadAlias()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_read_alias (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *collection)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   collection));
}

/**
 * _secret_gen_service_complete_set_alias:
 * @object: A #_SecretGenService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Service.SetAlias">SetAlias()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_service_complete_set_alias (
    _SecretGenService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * _SecretGenServiceProxy:
 *
 * The #_SecretGenServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenServiceProxy.
 */

struct __SecretGenServiceProxyPrivate
{
  GData *qdata;
};

static void _secret_gen_service_proxy_iface_init (_SecretGenServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenServiceProxy, _secret_gen_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_SecretGenServiceProxy)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SERVICE, _secret_gen_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenServiceProxy, _secret_gen_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SERVICE, _secret_gen_service_proxy_iface_init))

#endif
static void
_secret_gen_service_proxy_finalize (GObject *object)
{
  _SecretGenServiceProxy *proxy = _SECRET_GEN_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_secret_gen_service_proxy_parent_class)->finalize (object);
}

static void
_secret_gen_service_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_service_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
_secret_gen_service_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Secret.Service: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
_secret_gen_service_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_service_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Secret.Service", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) _secret_gen_service_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
_secret_gen_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__secret_gen_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _SECRET_GEN_TYPE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_secret_gen_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _SecretGenServiceProxy *proxy = _SECRET_GEN_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
_secret_gen_service_proxy_get_collections (_SecretGenService *object)
{
  _SecretGenServiceProxy *proxy = _SECRET_GEN_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Collections");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Collections");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Collections", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
_secret_gen_service_proxy_init (_SecretGenServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _secret_gen_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _SECRET_GEN_TYPE_SERVICE_PROXY, _SecretGenServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _secret_gen_service_interface_info ());
}

static void
_secret_gen_service_proxy_class_init (_SecretGenServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _secret_gen_service_proxy_finalize;
  gobject_class->get_property = _secret_gen_service_proxy_get_property;
  gobject_class->set_property = _secret_gen_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _secret_gen_service_proxy_g_signal;
  proxy_class->g_properties_changed = _secret_gen_service_proxy_g_properties_changed;

  _secret_gen_service_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenServiceProxyPrivate));
#endif
}

static void
_secret_gen_service_proxy_iface_init (_SecretGenServiceIface *iface)
{
  iface->get_collections = _secret_gen_service_proxy_get_collections;
}

/**
 * _secret_gen_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_proxy_new_finish() to get the result of the operation.
 *
 * See _secret_gen_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Service", NULL);
}

/**
 * _secret_gen_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_service_proxy_new().
 *
 * Returns: (transfer full) (type _SecretGenServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenService *
_secret_gen_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_SERVICE (ret);
  else
    return NULL;
}

/**
 * _secret_gen_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenService *
_secret_gen_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Service", NULL);
  if (ret != NULL)
    return _SECRET_GEN_SERVICE (ret);
  else
    return NULL;
}


/**
 * _secret_gen_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _secret_gen_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _secret_gen_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Service", NULL);
}

/**
 * _secret_gen_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _SecretGenServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenService *
_secret_gen_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_SERVICE (ret);
  else
    return NULL;
}

/**
 * _secret_gen_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _secret_gen_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenService *
_secret_gen_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Service", NULL);
  if (ret != NULL)
    return _SECRET_GEN_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _SecretGenServiceSkeleton:
 *
 * The #_SecretGenServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenServiceSkeleton.
 */

struct __SecretGenServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__secret_gen_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _SECRET_GEN_TYPE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__secret_gen_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__secret_gen_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __secret_gen_service_skeleton_vtable =
{
  __secret_gen_service_skeleton_handle_method_call,
  __secret_gen_service_skeleton_handle_get_property,
  __secret_gen_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_secret_gen_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _secret_gen_service_interface_info ();
}

static GDBusInterfaceVTable *
_secret_gen_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__secret_gen_service_skeleton_vtable;
}

static GVariant *
_secret_gen_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__secret_gen_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __secret_gen_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __secret_gen_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __secret_gen_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean __secret_gen_service_emit_changed (gpointer user_data);

static void
_secret_gen_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    __secret_gen_service_emit_changed (skeleton);
}

static void
__secret_gen_service_on_signal_collection_created (
    _SecretGenService *object,
    const gchar *arg_collection)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_collection));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Service", "CollectionCreated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__secret_gen_service_on_signal_collection_deleted (
    _SecretGenService *object,
    const gchar *arg_collection)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_collection));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Service", "CollectionDeleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__secret_gen_service_on_signal_collection_changed (
    _SecretGenService *object,
    const gchar *arg_collection)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_collection));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Service", "CollectionChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void _secret_gen_service_skeleton_iface_init (_SecretGenServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenServiceSkeleton, _secret_gen_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_SecretGenServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SERVICE, _secret_gen_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenServiceSkeleton, _secret_gen_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SERVICE, _secret_gen_service_skeleton_iface_init))

#endif
static void
_secret_gen_service_skeleton_finalize (GObject *object)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_secret_gen_service_skeleton_parent_class)->finalize (object);
}

static void
_secret_gen_service_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
__secret_gen_service_emit_changed (gpointer user_data)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Secret.Service",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
__secret_gen_service_schedule_emit_changed (_SecretGenServiceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
_secret_gen_service_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, __secret_gen_service_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] __secret_gen_service_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
_secret_gen_service_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_service_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        __secret_gen_service_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
_secret_gen_service_skeleton_init (_SecretGenServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _secret_gen_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _SECRET_GEN_TYPE_SERVICE_SKELETON, _SecretGenServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
}

static const gchar *const *
_secret_gen_service_skeleton_get_collections (_SecretGenService *object)
{
  _SecretGenServiceSkeleton *skeleton = _SECRET_GEN_SERVICE_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
_secret_gen_service_skeleton_class_init (_SecretGenServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _secret_gen_service_skeleton_finalize;
  gobject_class->get_property = _secret_gen_service_skeleton_get_property;
  gobject_class->set_property = _secret_gen_service_skeleton_set_property;
  gobject_class->notify       = _secret_gen_service_skeleton_notify;


  _secret_gen_service_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _secret_gen_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _secret_gen_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _secret_gen_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _secret_gen_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenServiceSkeletonPrivate));
#endif
}

static void
_secret_gen_service_skeleton_iface_init (_SecretGenServiceIface *iface)
{
  iface->collection_created = __secret_gen_service_on_signal_collection_created;
  iface->collection_deleted = __secret_gen_service_on_signal_collection_deleted;
  iface->collection_changed = __secret_gen_service_on_signal_collection_changed;
  iface->get_collections = _secret_gen_service_skeleton_get_collections;
}

/**
 * _secret_gen_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Service.top_of_page">org.freedesktop.Secret.Service</link>.
 *
 * Returns: (transfer full) (type _SecretGenServiceSkeleton): The skeleton object.
 */
_SecretGenService *
_secret_gen_service_skeleton_new (void)
{
  return _SECRET_GEN_SERVICE (g_object_new (_SECRET_GEN_TYPE_SERVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Secret.Collection
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_SecretGenCollection
 * @title: _SecretGenCollection
 * @short_description: Generated C code for the org.freedesktop.Secret.Collection D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link> D-Bus interface in C.
 */

enum
{
  _SECRET_GEN__COLLECTION_ITEM_CREATED,
  _SECRET_GEN__COLLECTION_ITEM_DELETED,
  _SECRET_GEN__COLLECTION_ITEM_CHANGED,
};

static unsigned _SECRET_GEN__COLLECTION_SIGNALS[3] = { 0 };

/* ---- Introspection data for org.freedesktop.Secret.Collection ---- */

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_delete_OUT_ARG_prompt =
{
  {
    -1,
    (gchar *) "prompt",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_method_info_delete_OUT_ARG_pointers[] =
{
  &__secret_gen_collection_method_info_delete_OUT_ARG_prompt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_collection_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    NULL,
    (GDBusArgInfo **) &__secret_gen_collection_method_info_delete_OUT_ARG_pointers,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_search_items_IN_ARG_attributes =
{
  {
    -1,
    (gchar *) "attributes",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_method_info_search_items_IN_ARG_pointers[] =
{
  &__secret_gen_collection_method_info_search_items_IN_ARG_attributes.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_search_items_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_method_info_search_items_OUT_ARG_pointers[] =
{
  &__secret_gen_collection_method_info_search_items_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_collection_method_info_search_items =
{
  {
    -1,
    (gchar *) "SearchItems",
    (GDBusArgInfo **) &__secret_gen_collection_method_info_search_items_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_collection_method_info_search_items_OUT_ARG_pointers,
    NULL
  },
  "handle-search-items",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_create_item_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_create_item_IN_ARG_secret =
{
  {
    -1,
    (gchar *) "secret",
    (gchar *) "(oayays)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_create_item_IN_ARG_replace =
{
  {
    -1,
    (gchar *) "replace",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_method_info_create_item_IN_ARG_pointers[] =
{
  &__secret_gen_collection_method_info_create_item_IN_ARG_properties.parent_struct,
  &__secret_gen_collection_method_info_create_item_IN_ARG_secret.parent_struct,
  &__secret_gen_collection_method_info_create_item_IN_ARG_replace.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_create_item_OUT_ARG_item =
{
  {
    -1,
    (gchar *) "item",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_method_info_create_item_OUT_ARG_prompt =
{
  {
    -1,
    (gchar *) "prompt",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_method_info_create_item_OUT_ARG_pointers[] =
{
  &__secret_gen_collection_method_info_create_item_OUT_ARG_item.parent_struct,
  &__secret_gen_collection_method_info_create_item_OUT_ARG_prompt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_collection_method_info_create_item =
{
  {
    -1,
    (gchar *) "CreateItem",
    (GDBusArgInfo **) &__secret_gen_collection_method_info_create_item_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_collection_method_info_create_item_OUT_ARG_pointers,
    NULL
  },
  "handle-create-item",
  FALSE
};

static const GDBusMethodInfo * const __secret_gen_collection_method_info_pointers[] =
{
  &__secret_gen_collection_method_info_delete.parent_struct,
  &__secret_gen_collection_method_info_search_items.parent_struct,
  &__secret_gen_collection_method_info_create_item.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_signal_info_item_created_ARG_item =
{
  {
    -1,
    (gchar *) "item",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_signal_info_item_created_ARG_pointers[] =
{
  &__secret_gen_collection_signal_info_item_created_ARG_item.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_collection_signal_info_item_created =
{
  {
    -1,
    (gchar *) "ItemCreated",
    (GDBusArgInfo **) &__secret_gen_collection_signal_info_item_created_ARG_pointers,
    NULL
  },
  "item-created"
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_signal_info_item_deleted_ARG_item =
{
  {
    -1,
    (gchar *) "item",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_signal_info_item_deleted_ARG_pointers[] =
{
  &__secret_gen_collection_signal_info_item_deleted_ARG_item.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_collection_signal_info_item_deleted =
{
  {
    -1,
    (gchar *) "ItemDeleted",
    (GDBusArgInfo **) &__secret_gen_collection_signal_info_item_deleted_ARG_pointers,
    NULL
  },
  "item-deleted"
};

static const _ExtendedGDBusArgInfo __secret_gen_collection_signal_info_item_changed_ARG_item =
{
  {
    -1,
    (gchar *) "item",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_collection_signal_info_item_changed_ARG_pointers[] =
{
  &__secret_gen_collection_signal_info_item_changed_ARG_item.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_collection_signal_info_item_changed =
{
  {
    -1,
    (gchar *) "ItemChanged",
    (GDBusArgInfo **) &__secret_gen_collection_signal_info_item_changed_ARG_pointers,
    NULL
  },
  "item-changed"
};

static const GDBusSignalInfo * const __secret_gen_collection_signal_info_pointers[] =
{
  &__secret_gen_collection_signal_info_item_created.parent_struct,
  &__secret_gen_collection_signal_info_item_deleted.parent_struct,
  &__secret_gen_collection_signal_info_item_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo __secret_gen_collection_property_info_items =
{
  {
    -1,
    (gchar *) "Items",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "items",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_collection_property_info_label =
{
  {
    -1,
    (gchar *) "Label",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_collection_property_info_locked =
{
  {
    -1,
    (gchar *) "Locked",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "locked",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_collection_property_info_created =
{
  {
    -1,
    (gchar *) "Created",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "created",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_collection_property_info_modified =
{
  {
    -1,
    (gchar *) "Modified",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "modified",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const __secret_gen_collection_property_info_pointers[] =
{
  &__secret_gen_collection_property_info_items.parent_struct,
  &__secret_gen_collection_property_info_label.parent_struct,
  &__secret_gen_collection_property_info_locked.parent_struct,
  &__secret_gen_collection_property_info_created.parent_struct,
  &__secret_gen_collection_property_info_modified.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __secret_gen_collection_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Secret.Collection",
    (GDBusMethodInfo **) &__secret_gen_collection_method_info_pointers,
    (GDBusSignalInfo **) &__secret_gen_collection_signal_info_pointers,
    (GDBusPropertyInfo **) &__secret_gen_collection_property_info_pointers,
    NULL
  },
  "collection",
};


/**
 * _secret_gen_collection_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_secret_gen_collection_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__secret_gen_collection_interface_info.parent_struct;
}

/**
 * _secret_gen_collection_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_SecretGenCollection interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_secret_gen_collection_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "items");
  g_object_class_override_property (klass, property_id_begin++, "label");
  g_object_class_override_property (klass, property_id_begin++, "locked");
  g_object_class_override_property (klass, property_id_begin++, "created");
  g_object_class_override_property (klass, property_id_begin++, "modified");
  return property_id_begin - 1;
}


inline static void
_secret_gen_collection_signal_marshal_item_created (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_collection_signal_marshal_item_deleted (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_collection_signal_marshal_item_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_collection_method_marshal_delete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_collection_method_marshal_search_items (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_collection_method_marshal_create_item (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _SecretGenCollection:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link>.
 */

/**
 * _SecretGenCollectionIface:
 * @parent_iface: The parent interface.
 * @handle_create_item: Handler for the #_SecretGenCollection::handle-create-item signal.
 * @handle_delete: Handler for the #_SecretGenCollection::handle-delete signal.
 * @handle_search_items: Handler for the #_SecretGenCollection::handle-search-items signal.
 * @get_created: Getter for the #_SecretGenCollection:created property.
 * @get_items: Getter for the #_SecretGenCollection:items property.
 * @get_label: Getter for the #_SecretGenCollection:label property.
 * @get_locked: Getter for the #_SecretGenCollection:locked property.
 * @get_modified: Getter for the #_SecretGenCollection:modified property.
 * @item_changed: Handler for the #_SecretGenCollection::item-changed signal.
 * @item_created: Handler for the #_SecretGenCollection::item-created signal.
 * @item_deleted: Handler for the #_SecretGenCollection::item-deleted signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link>.
 */

typedef _SecretGenCollectionIface _SecretGenCollectionInterface;
G_DEFINE_INTERFACE (_SecretGenCollection, _secret_gen_collection, G_TYPE_OBJECT)

static void
_secret_gen_collection_default_init (_SecretGenCollectionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _SecretGenCollection::handle-delete:
   * @object: A #_SecretGenCollection.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_collection_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenCollectionIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_collection_method_marshal_delete,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * _SecretGenCollection::handle-search-items:
   * @object: A #_SecretGenCollection.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_attributes: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.SearchItems">SearchItems()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_collection_complete_search_items() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-search-items",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenCollectionIface, handle_search_items),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_collection_method_marshal_search_items,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * _SecretGenCollection::handle-create-item:
   * @object: A #_SecretGenCollection.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   * @arg_secret: Argument passed by remote caller.
   * @arg_replace: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.CreateItem">CreateItem()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_collection_complete_create_item() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-item",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenCollectionIface, handle_create_item),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_collection_method_marshal_create_item,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_BOOLEAN);

  /* GObject signals for received D-Bus signals: */
  /**
   * _SecretGenCollection::item-created:
   * @object: A #_SecretGenCollection.
   * @arg_item: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Collection.ItemCreated">"ItemCreated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__COLLECTION_SIGNALS[_SECRET_GEN__COLLECTION_ITEM_CREATED] =
    g_signal_new ("item-created",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenCollectionIface, item_created),
      NULL,
      NULL,
      _secret_gen_collection_signal_marshal_item_created,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * _SecretGenCollection::item-deleted:
   * @object: A #_SecretGenCollection.
   * @arg_item: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Collection.ItemDeleted">"ItemDeleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__COLLECTION_SIGNALS[_SECRET_GEN__COLLECTION_ITEM_DELETED] =
    g_signal_new ("item-deleted",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenCollectionIface, item_deleted),
      NULL,
      NULL,
      _secret_gen_collection_signal_marshal_item_deleted,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * _SecretGenCollection::item-changed:
   * @object: A #_SecretGenCollection.
   * @arg_item: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Collection.ItemChanged">"ItemChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__COLLECTION_SIGNALS[_SECRET_GEN__COLLECTION_ITEM_CHANGED] =
    g_signal_new ("item-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenCollectionIface, item_changed),
      NULL,
      NULL,
      _secret_gen_collection_signal_marshal_item_changed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * _SecretGenCollection:items:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Items">"Items"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("items", "Items", "Items", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenCollection:label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Label">"Label"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("label", "Label", "Label", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenCollection:locked:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Locked">"Locked"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("locked", "Locked", "Locked", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenCollection:created:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Created">"Created"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("created", "Created", "Created", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenCollection:modified:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Modified">"Modified"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("modified", "Modified", "Modified", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * _secret_gen_collection_get_items: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Items">"Items"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _secret_gen_collection_dup_items() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
_secret_gen_collection_get_items (_SecretGenCollection *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_COLLECTION (object), NULL);

  return _SECRET_GEN_COLLECTION_GET_IFACE (object)->get_items (object);
}

/**
 * _secret_gen_collection_dup_items: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Items">"Items"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
_secret_gen_collection_dup_items (_SecretGenCollection *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "items", &value, NULL);
  return value;
}

/**
 * _secret_gen_collection_set_items: (skip)
 * @object: A #_SecretGenCollection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Items">"Items"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_collection_set_items (_SecretGenCollection *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "items", value, NULL);
}

/**
 * _secret_gen_collection_get_label: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _secret_gen_collection_dup_label() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
_secret_gen_collection_get_label (_SecretGenCollection *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_COLLECTION (object), NULL);

  return _SECRET_GEN_COLLECTION_GET_IFACE (object)->get_label (object);
}

/**
 * _secret_gen_collection_dup_label: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
_secret_gen_collection_dup_label (_SecretGenCollection *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "label", &value, NULL);
  return value;
}

/**
 * _secret_gen_collection_set_label: (skip)
 * @object: A #_SecretGenCollection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Label">"Label"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
_secret_gen_collection_set_label (_SecretGenCollection *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "label", value, NULL);
}

/**
 * _secret_gen_collection_get_locked: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Locked">"Locked"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_secret_gen_collection_get_locked (_SecretGenCollection *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_COLLECTION (object), FALSE);

  return _SECRET_GEN_COLLECTION_GET_IFACE (object)->get_locked (object);
}

/**
 * _secret_gen_collection_set_locked: (skip)
 * @object: A #_SecretGenCollection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Locked">"Locked"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_collection_set_locked (_SecretGenCollection *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "locked", value, NULL);
}

/**
 * _secret_gen_collection_get_created: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Created">"Created"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
_secret_gen_collection_get_created (_SecretGenCollection *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_COLLECTION (object), 0);

  return _SECRET_GEN_COLLECTION_GET_IFACE (object)->get_created (object);
}

/**
 * _secret_gen_collection_set_created: (skip)
 * @object: A #_SecretGenCollection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Created">"Created"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_collection_set_created (_SecretGenCollection *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "created", value, NULL);
}

/**
 * _secret_gen_collection_get_modified: (skip)
 * @object: A #_SecretGenCollection.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Modified">"Modified"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
_secret_gen_collection_get_modified (_SecretGenCollection *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_COLLECTION (object), 0);

  return _SECRET_GEN_COLLECTION_GET_IFACE (object)->get_modified (object);
}

/**
 * _secret_gen_collection_set_modified: (skip)
 * @object: A #_SecretGenCollection.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Collection.Modified">"Modified"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_collection_set_modified (_SecretGenCollection *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "modified", value, NULL);
}

/**
 * _secret_gen_collection_emit_item_created:
 * @object: A #_SecretGenCollection.
 * @arg_item: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Collection.ItemCreated">"ItemCreated"</link> D-Bus signal.
 */
void
_secret_gen_collection_emit_item_created (
    _SecretGenCollection *object,
    const gchar *arg_item)
{
  g_signal_emit (object, _SECRET_GEN__COLLECTION_SIGNALS[_SECRET_GEN__COLLECTION_ITEM_CREATED], 0, arg_item);
}

/**
 * _secret_gen_collection_emit_item_deleted:
 * @object: A #_SecretGenCollection.
 * @arg_item: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Collection.ItemDeleted">"ItemDeleted"</link> D-Bus signal.
 */
void
_secret_gen_collection_emit_item_deleted (
    _SecretGenCollection *object,
    const gchar *arg_item)
{
  g_signal_emit (object, _SECRET_GEN__COLLECTION_SIGNALS[_SECRET_GEN__COLLECTION_ITEM_DELETED], 0, arg_item);
}

/**
 * _secret_gen_collection_emit_item_changed:
 * @object: A #_SecretGenCollection.
 * @arg_item: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Collection.ItemChanged">"ItemChanged"</link> D-Bus signal.
 */
void
_secret_gen_collection_emit_item_changed (
    _SecretGenCollection *object,
    const gchar *arg_item)
{
  g_signal_emit (object, _SECRET_GEN__COLLECTION_SIGNALS[_SECRET_GEN__COLLECTION_ITEM_CHANGED], 0, arg_item);
}

/**
 * _secret_gen_collection_call_delete:
 * @proxy: A #_SecretGenCollectionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_collection_call_delete_finish() to get the result of the operation.
 *
 * See _secret_gen_collection_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_collection_call_delete (
    _SecretGenCollection *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_collection_call_delete_finish:
 * @proxy: A #_SecretGenCollectionProxy.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_collection_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_collection_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_collection_call_delete_finish (
    _SecretGenCollection *proxy,
    gchar **out_prompt,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_collection_call_delete_sync:
 * @proxy: A #_SecretGenCollectionProxy.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_collection_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_collection_call_delete_sync (
    _SecretGenCollection *proxy,
    gchar **out_prompt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_collection_call_search_items:
 * @proxy: A #_SecretGenCollectionProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.SearchItems">SearchItems()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_collection_call_search_items_finish() to get the result of the operation.
 *
 * See _secret_gen_collection_call_search_items_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_collection_call_search_items (
    _SecretGenCollection *proxy,
    GVariant *arg_attributes,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SearchItems",
    g_variant_new ("(@a{ss})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_collection_call_search_items_finish:
 * @proxy: A #_SecretGenCollectionProxy.
 * @out_results: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_collection_call_search_items().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_collection_call_search_items().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_collection_call_search_items_finish (
    _SecretGenCollection *proxy,
    gchar ***out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_collection_call_search_items_sync:
 * @proxy: A #_SecretGenCollectionProxy.
 * @arg_attributes: Argument to pass with the method invocation.
 * @out_results: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.SearchItems">SearchItems()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_collection_call_search_items() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_collection_call_search_items_sync (
    _SecretGenCollection *proxy,
    GVariant *arg_attributes,
    gchar ***out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SearchItems",
    g_variant_new ("(@a{ss})",
                   arg_attributes),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_collection_call_create_item:
 * @proxy: A #_SecretGenCollectionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_secret: Argument to pass with the method invocation.
 * @arg_replace: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.CreateItem">CreateItem()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_collection_call_create_item_finish() to get the result of the operation.
 *
 * See _secret_gen_collection_call_create_item_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_collection_call_create_item (
    _SecretGenCollection *proxy,
    GVariant *arg_properties,
    GVariant *arg_secret,
    gboolean arg_replace,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateItem",
    g_variant_new ("(@a{sv}@(oayays)b)",
                   arg_properties,
                   arg_secret,
                   arg_replace),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_collection_call_create_item_finish:
 * @proxy: A #_SecretGenCollectionProxy.
 * @out_item: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_collection_call_create_item().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_collection_call_create_item().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_collection_call_create_item_finish (
    _SecretGenCollection *proxy,
    gchar **out_item,
    gchar **out_prompt,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo)",
                 out_item,
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_collection_call_create_item_sync:
 * @proxy: A #_SecretGenCollectionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @arg_secret: Argument to pass with the method invocation.
 * @arg_replace: Argument to pass with the method invocation.
 * @out_item: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.CreateItem">CreateItem()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_collection_call_create_item() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_collection_call_create_item_sync (
    _SecretGenCollection *proxy,
    GVariant *arg_properties,
    GVariant *arg_secret,
    gboolean arg_replace,
    gchar **out_item,
    gchar **out_prompt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateItem",
    g_variant_new ("(@a{sv}@(oayays)b)",
                   arg_properties,
                   arg_secret,
                   arg_replace),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(oo)",
                 out_item,
                 out_prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_collection_complete_delete:
 * @object: A #_SecretGenCollection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @prompt: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_collection_complete_delete (
    _SecretGenCollection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *prompt)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   prompt));
}

/**
 * _secret_gen_collection_complete_search_items:
 * @object: A #_SecretGenCollection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.SearchItems">SearchItems()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_collection_complete_search_items (
    _SecretGenCollection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   results));
}

/**
 * _secret_gen_collection_complete_create_item:
 * @object: A #_SecretGenCollection.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @item: Parameter to return.
 * @prompt: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Collection.CreateItem">CreateItem()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_collection_complete_create_item (
    _SecretGenCollection *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *item,
    const gchar *prompt)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(oo)",
                   item,
                   prompt));
}

/* ------------------------------------------------------------------------ */

/**
 * _SecretGenCollectionProxy:
 *
 * The #_SecretGenCollectionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenCollectionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenCollectionProxy.
 */

struct __SecretGenCollectionProxyPrivate
{
  GData *qdata;
};

static void _secret_gen_collection_proxy_iface_init (_SecretGenCollectionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenCollectionProxy, _secret_gen_collection_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_SecretGenCollectionProxy)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_COLLECTION, _secret_gen_collection_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenCollectionProxy, _secret_gen_collection_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_COLLECTION, _secret_gen_collection_proxy_iface_init))

#endif
static void
_secret_gen_collection_proxy_finalize (GObject *object)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_secret_gen_collection_proxy_parent_class)->finalize (object);
}

static void
_secret_gen_collection_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_collection_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
_secret_gen_collection_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Secret.Collection: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
_secret_gen_collection_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_collection_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Secret.Collection", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) _secret_gen_collection_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
_secret_gen_collection_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__secret_gen_collection_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _SECRET_GEN_TYPE_COLLECTION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_COLLECTION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_secret_gen_collection_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_collection_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_collection_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
_secret_gen_collection_proxy_get_items (_SecretGenCollection *object)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Items");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Items");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Items", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
_secret_gen_collection_proxy_get_label (_SecretGenCollection *object)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Label");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
_secret_gen_collection_proxy_get_locked (_SecretGenCollection *object)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Locked");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
_secret_gen_collection_proxy_get_created (_SecretGenCollection *object)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Created");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
_secret_gen_collection_proxy_get_modified (_SecretGenCollection *object)
{
  _SecretGenCollectionProxy *proxy = _SECRET_GEN_COLLECTION_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Modified");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
_secret_gen_collection_proxy_init (_SecretGenCollectionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _secret_gen_collection_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _SECRET_GEN_TYPE_COLLECTION_PROXY, _SecretGenCollectionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _secret_gen_collection_interface_info ());
}

static void
_secret_gen_collection_proxy_class_init (_SecretGenCollectionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _secret_gen_collection_proxy_finalize;
  gobject_class->get_property = _secret_gen_collection_proxy_get_property;
  gobject_class->set_property = _secret_gen_collection_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _secret_gen_collection_proxy_g_signal;
  proxy_class->g_properties_changed = _secret_gen_collection_proxy_g_properties_changed;

  _secret_gen_collection_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenCollectionProxyPrivate));
#endif
}

static void
_secret_gen_collection_proxy_iface_init (_SecretGenCollectionIface *iface)
{
  iface->get_items = _secret_gen_collection_proxy_get_items;
  iface->get_label = _secret_gen_collection_proxy_get_label;
  iface->get_locked = _secret_gen_collection_proxy_get_locked;
  iface->get_created = _secret_gen_collection_proxy_get_created;
  iface->get_modified = _secret_gen_collection_proxy_get_modified;
}

/**
 * _secret_gen_collection_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_collection_proxy_new_finish() to get the result of the operation.
 *
 * See _secret_gen_collection_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_collection_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_COLLECTION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Collection", NULL);
}

/**
 * _secret_gen_collection_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_collection_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_collection_proxy_new().
 *
 * Returns: (transfer full) (type _SecretGenCollectionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenCollection *
_secret_gen_collection_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_COLLECTION (ret);
  else
    return NULL;
}

/**
 * _secret_gen_collection_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_collection_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenCollectionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenCollection *
_secret_gen_collection_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_COLLECTION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Collection", NULL);
  if (ret != NULL)
    return _SECRET_GEN_COLLECTION (ret);
  else
    return NULL;
}


/**
 * _secret_gen_collection_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _secret_gen_collection_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_collection_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _secret_gen_collection_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_collection_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_COLLECTION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Collection", NULL);
}

/**
 * _secret_gen_collection_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_collection_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_collection_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _SecretGenCollectionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenCollection *
_secret_gen_collection_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_COLLECTION (ret);
  else
    return NULL;
}

/**
 * _secret_gen_collection_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _secret_gen_collection_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_collection_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenCollectionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenCollection *
_secret_gen_collection_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_COLLECTION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Collection", NULL);
  if (ret != NULL)
    return _SECRET_GEN_COLLECTION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _SecretGenCollectionSkeleton:
 *
 * The #_SecretGenCollectionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenCollectionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenCollectionSkeleton.
 */

struct __SecretGenCollectionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__secret_gen_collection_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _SECRET_GEN_TYPE_COLLECTION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_COLLECTION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__secret_gen_collection_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_collection_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__secret_gen_collection_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_collection_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __secret_gen_collection_skeleton_vtable =
{
  __secret_gen_collection_skeleton_handle_method_call,
  __secret_gen_collection_skeleton_handle_get_property,
  __secret_gen_collection_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_secret_gen_collection_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _secret_gen_collection_interface_info ();
}

static GDBusInterfaceVTable *
_secret_gen_collection_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__secret_gen_collection_skeleton_vtable;
}

static GVariant *
_secret_gen_collection_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__secret_gen_collection_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __secret_gen_collection_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __secret_gen_collection_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __secret_gen_collection_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Collection", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean __secret_gen_collection_emit_changed (gpointer user_data);

static void
_secret_gen_collection_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    __secret_gen_collection_emit_changed (skeleton);
}

static void
__secret_gen_collection_on_signal_item_created (
    _SecretGenCollection *object,
    const gchar *arg_item)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_item));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Collection", "ItemCreated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__secret_gen_collection_on_signal_item_deleted (
    _SecretGenCollection *object,
    const gchar *arg_item)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_item));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Collection", "ItemDeleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
__secret_gen_collection_on_signal_item_changed (
    _SecretGenCollection *object,
    const gchar *arg_item)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_item));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Collection", "ItemChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void _secret_gen_collection_skeleton_iface_init (_SecretGenCollectionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenCollectionSkeleton, _secret_gen_collection_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_SecretGenCollectionSkeleton)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_COLLECTION, _secret_gen_collection_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenCollectionSkeleton, _secret_gen_collection_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_COLLECTION, _secret_gen_collection_skeleton_iface_init))

#endif
static void
_secret_gen_collection_skeleton_finalize (GObject *object)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_secret_gen_collection_skeleton_parent_class)->finalize (object);
}

static void
_secret_gen_collection_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
__secret_gen_collection_emit_changed (gpointer user_data)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Secret.Collection",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
__secret_gen_collection_schedule_emit_changed (_SecretGenCollectionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
_secret_gen_collection_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, __secret_gen_collection_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] __secret_gen_collection_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
_secret_gen_collection_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_collection_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        __secret_gen_collection_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
_secret_gen_collection_skeleton_init (_SecretGenCollectionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _secret_gen_collection_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _SECRET_GEN_TYPE_COLLECTION_SKELETON, _SecretGenCollectionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT64);
}

static const gchar *const *
_secret_gen_collection_skeleton_get_items (_SecretGenCollection *object)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
_secret_gen_collection_skeleton_get_label (_SecretGenCollection *object)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
_secret_gen_collection_skeleton_get_locked (_SecretGenCollection *object)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
_secret_gen_collection_skeleton_get_created (_SecretGenCollection *object)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
_secret_gen_collection_skeleton_get_modified (_SecretGenCollection *object)
{
  _SecretGenCollectionSkeleton *skeleton = _SECRET_GEN_COLLECTION_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
_secret_gen_collection_skeleton_class_init (_SecretGenCollectionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _secret_gen_collection_skeleton_finalize;
  gobject_class->get_property = _secret_gen_collection_skeleton_get_property;
  gobject_class->set_property = _secret_gen_collection_skeleton_set_property;
  gobject_class->notify       = _secret_gen_collection_skeleton_notify;


  _secret_gen_collection_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _secret_gen_collection_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _secret_gen_collection_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _secret_gen_collection_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _secret_gen_collection_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenCollectionSkeletonPrivate));
#endif
}

static void
_secret_gen_collection_skeleton_iface_init (_SecretGenCollectionIface *iface)
{
  iface->item_created = __secret_gen_collection_on_signal_item_created;
  iface->item_deleted = __secret_gen_collection_on_signal_item_deleted;
  iface->item_changed = __secret_gen_collection_on_signal_item_changed;
  iface->get_items = _secret_gen_collection_skeleton_get_items;
  iface->get_label = _secret_gen_collection_skeleton_get_label;
  iface->get_locked = _secret_gen_collection_skeleton_get_locked;
  iface->get_created = _secret_gen_collection_skeleton_get_created;
  iface->get_modified = _secret_gen_collection_skeleton_get_modified;
}

/**
 * _secret_gen_collection_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Collection.top_of_page">org.freedesktop.Secret.Collection</link>.
 *
 * Returns: (transfer full) (type _SecretGenCollectionSkeleton): The skeleton object.
 */
_SecretGenCollection *
_secret_gen_collection_skeleton_new (void)
{
  return _SECRET_GEN_COLLECTION (g_object_new (_SECRET_GEN_TYPE_COLLECTION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Secret.Item
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_SecretGenItem
 * @title: _SecretGenItem
 * @short_description: Generated C code for the org.freedesktop.Secret.Item D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Secret.Item ---- */

static const _ExtendedGDBusArgInfo __secret_gen_item_method_info_delete_OUT_ARG_Prompt =
{
  {
    -1,
    (gchar *) "Prompt",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_item_method_info_delete_OUT_ARG_pointers[] =
{
  &__secret_gen_item_method_info_delete_OUT_ARG_Prompt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_item_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    NULL,
    (GDBusArgInfo **) &__secret_gen_item_method_info_delete_OUT_ARG_pointers,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_item_method_info_get_secret_IN_ARG_session =
{
  {
    -1,
    (gchar *) "session",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_item_method_info_get_secret_IN_ARG_pointers[] =
{
  &__secret_gen_item_method_info_get_secret_IN_ARG_session.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_item_method_info_get_secret_OUT_ARG_secret =
{
  {
    -1,
    (gchar *) "secret",
    (gchar *) "(oayays)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_item_method_info_get_secret_OUT_ARG_pointers[] =
{
  &__secret_gen_item_method_info_get_secret_OUT_ARG_secret.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_item_method_info_get_secret =
{
  {
    -1,
    (gchar *) "GetSecret",
    (GDBusArgInfo **) &__secret_gen_item_method_info_get_secret_IN_ARG_pointers,
    (GDBusArgInfo **) &__secret_gen_item_method_info_get_secret_OUT_ARG_pointers,
    NULL
  },
  "handle-get-secret",
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_item_method_info_set_secret_IN_ARG_secret =
{
  {
    -1,
    (gchar *) "secret",
    (gchar *) "(oayays)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_item_method_info_set_secret_IN_ARG_pointers[] =
{
  &__secret_gen_item_method_info_set_secret_IN_ARG_secret.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_item_method_info_set_secret =
{
  {
    -1,
    (gchar *) "SetSecret",
    (GDBusArgInfo **) &__secret_gen_item_method_info_set_secret_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-secret",
  FALSE
};

static const GDBusMethodInfo * const __secret_gen_item_method_info_pointers[] =
{
  &__secret_gen_item_method_info_delete.parent_struct,
  &__secret_gen_item_method_info_get_secret.parent_struct,
  &__secret_gen_item_method_info_set_secret.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo __secret_gen_item_property_info_locked =
{
  {
    -1,
    (gchar *) "Locked",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "locked",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_item_property_info_attributes =
{
  {
    -1,
    (gchar *) "Attributes",
    (gchar *) "a{ss}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "attributes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_item_property_info_label =
{
  {
    -1,
    (gchar *) "Label",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_item_property_info_created =
{
  {
    -1,
    (gchar *) "Created",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "created",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo __secret_gen_item_property_info_modified =
{
  {
    -1,
    (gchar *) "Modified",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "modified",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const __secret_gen_item_property_info_pointers[] =
{
  &__secret_gen_item_property_info_locked.parent_struct,
  &__secret_gen_item_property_info_attributes.parent_struct,
  &__secret_gen_item_property_info_label.parent_struct,
  &__secret_gen_item_property_info_created.parent_struct,
  &__secret_gen_item_property_info_modified.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __secret_gen_item_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Secret.Item",
    (GDBusMethodInfo **) &__secret_gen_item_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &__secret_gen_item_property_info_pointers,
    NULL
  },
  "item",
};


/**
 * _secret_gen_item_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_secret_gen_item_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__secret_gen_item_interface_info.parent_struct;
}

/**
 * _secret_gen_item_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_SecretGenItem interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_secret_gen_item_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "locked");
  g_object_class_override_property (klass, property_id_begin++, "attributes");
  g_object_class_override_property (klass, property_id_begin++, "label");
  g_object_class_override_property (klass, property_id_begin++, "created");
  g_object_class_override_property (klass, property_id_begin++, "modified");
  return property_id_begin - 1;
}


inline static void
_secret_gen_item_method_marshal_delete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_item_method_marshal_get_secret (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_item_method_marshal_set_secret (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _SecretGenItem:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link>.
 */

/**
 * _SecretGenItemIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #_SecretGenItem::handle-delete signal.
 * @handle_get_secret: Handler for the #_SecretGenItem::handle-get-secret signal.
 * @handle_set_secret: Handler for the #_SecretGenItem::handle-set-secret signal.
 * @get_attributes: Getter for the #_SecretGenItem:attributes property.
 * @get_created: Getter for the #_SecretGenItem:created property.
 * @get_label: Getter for the #_SecretGenItem:label property.
 * @get_locked: Getter for the #_SecretGenItem:locked property.
 * @get_modified: Getter for the #_SecretGenItem:modified property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link>.
 */

typedef _SecretGenItemIface _SecretGenItemInterface;
G_DEFINE_INTERFACE (_SecretGenItem, _secret_gen_item, G_TYPE_OBJECT)

static void
_secret_gen_item_default_init (_SecretGenItemIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _SecretGenItem::handle-delete:
   * @object: A #_SecretGenItem.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Item.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_item_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenItemIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_item_method_marshal_delete,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * _SecretGenItem::handle-get-secret:
   * @object: A #_SecretGenItem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Item.GetSecret">GetSecret()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_item_complete_get_secret() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-secret",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenItemIface, handle_get_secret),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_item_method_marshal_get_secret,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * _SecretGenItem::handle-set-secret:
   * @object: A #_SecretGenItem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_secret: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Item.SetSecret">SetSecret()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_item_complete_set_secret() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-secret",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenItemIface, handle_set_secret),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_item_method_marshal_set_secret,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * _SecretGenItem:locked:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Item.Locked">"Locked"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("locked", "Locked", "Locked", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenItem:attributes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Item.Attributes">"Attributes"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("attributes", "Attributes", "Attributes", G_VARIANT_TYPE ("a{ss}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenItem:label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Item.Label">"Label"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("label", "Label", "Label", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenItem:created:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Item.Created">"Created"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("created", "Created", "Created", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * _SecretGenItem:modified:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-Secret-Item.Modified">"Modified"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("modified", "Modified", "Modified", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * _secret_gen_item_get_locked: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Locked">"Locked"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
_secret_gen_item_get_locked (_SecretGenItem *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_ITEM (object), FALSE);

  return _SECRET_GEN_ITEM_GET_IFACE (object)->get_locked (object);
}

/**
 * _secret_gen_item_set_locked: (skip)
 * @object: A #_SecretGenItem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Locked">"Locked"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_item_set_locked (_SecretGenItem *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "locked", value, NULL);
}

/**
 * _secret_gen_item_get_attributes: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Attributes">"Attributes"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _secret_gen_item_dup_attributes() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
_secret_gen_item_get_attributes (_SecretGenItem *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_ITEM (object), NULL);

  return _SECRET_GEN_ITEM_GET_IFACE (object)->get_attributes (object);
}

/**
 * _secret_gen_item_dup_attributes: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Attributes">"Attributes"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
_secret_gen_item_dup_attributes (_SecretGenItem *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "attributes", &value, NULL);
  return value;
}

/**
 * _secret_gen_item_set_attributes: (skip)
 * @object: A #_SecretGenItem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Attributes">"Attributes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
_secret_gen_item_set_attributes (_SecretGenItem *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "attributes", value, NULL);
}

/**
 * _secret_gen_item_get_label: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use _secret_gen_item_dup_label() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
_secret_gen_item_get_label (_SecretGenItem *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_ITEM (object), NULL);

  return _SECRET_GEN_ITEM_GET_IFACE (object)->get_label (object);
}

/**
 * _secret_gen_item_dup_label: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
_secret_gen_item_dup_label (_SecretGenItem *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "label", &value, NULL);
  return value;
}

/**
 * _secret_gen_item_set_label: (skip)
 * @object: A #_SecretGenItem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Label">"Label"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
_secret_gen_item_set_label (_SecretGenItem *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "label", value, NULL);
}

/**
 * _secret_gen_item_get_created: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Created">"Created"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
_secret_gen_item_get_created (_SecretGenItem *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_ITEM (object), 0);

  return _SECRET_GEN_ITEM_GET_IFACE (object)->get_created (object);
}

/**
 * _secret_gen_item_set_created: (skip)
 * @object: A #_SecretGenItem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Created">"Created"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_item_set_created (_SecretGenItem *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "created", value, NULL);
}

/**
 * _secret_gen_item_get_modified: (skip)
 * @object: A #_SecretGenItem.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Modified">"Modified"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
_secret_gen_item_get_modified (_SecretGenItem *object)
{
  g_return_val_if_fail (_SECRET_GEN_IS_ITEM (object), 0);

  return _SECRET_GEN_ITEM_GET_IFACE (object)->get_modified (object);
}

/**
 * _secret_gen_item_set_modified: (skip)
 * @object: A #_SecretGenItem.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-Secret-Item.Modified">"Modified"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
_secret_gen_item_set_modified (_SecretGenItem *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "modified", value, NULL);
}

/**
 * _secret_gen_item_call_delete:
 * @proxy: A #_SecretGenItemProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Item.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_item_call_delete_finish() to get the result of the operation.
 *
 * See _secret_gen_item_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_item_call_delete (
    _SecretGenItem *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_item_call_delete_finish:
 * @proxy: A #_SecretGenItemProxy.
 * @out_Prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_item_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_item_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_item_call_delete_finish (
    _SecretGenItem *proxy,
    gchar **out_Prompt,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_Prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_item_call_delete_sync:
 * @proxy: A #_SecretGenItemProxy.
 * @out_Prompt: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Item.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_item_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_item_call_delete_sync (
    _SecretGenItem *proxy,
    gchar **out_Prompt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_Prompt);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_item_call_get_secret:
 * @proxy: A #_SecretGenItemProxy.
 * @arg_session: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Item.GetSecret">GetSecret()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_item_call_get_secret_finish() to get the result of the operation.
 *
 * See _secret_gen_item_call_get_secret_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_item_call_get_secret (
    _SecretGenItem *proxy,
    const gchar *arg_session,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetSecret",
    g_variant_new ("(o)",
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_item_call_get_secret_finish:
 * @proxy: A #_SecretGenItemProxy.
 * @out_secret: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_item_call_get_secret().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_item_call_get_secret().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_item_call_get_secret_finish (
    _SecretGenItem *proxy,
    GVariant **out_secret,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(oayays))",
                 out_secret);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_item_call_get_secret_sync:
 * @proxy: A #_SecretGenItemProxy.
 * @arg_session: Argument to pass with the method invocation.
 * @out_secret: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Item.GetSecret">GetSecret()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_item_call_get_secret() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_item_call_get_secret_sync (
    _SecretGenItem *proxy,
    const gchar *arg_session,
    GVariant **out_secret,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetSecret",
    g_variant_new ("(o)",
                   arg_session),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(oayays))",
                 out_secret);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_item_call_set_secret:
 * @proxy: A #_SecretGenItemProxy.
 * @arg_secret: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Item.SetSecret">SetSecret()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_item_call_set_secret_finish() to get the result of the operation.
 *
 * See _secret_gen_item_call_set_secret_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_item_call_set_secret (
    _SecretGenItem *proxy,
    GVariant *arg_secret,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSecret",
    g_variant_new ("(@(oayays))",
                   arg_secret),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_item_call_set_secret_finish:
 * @proxy: A #_SecretGenItemProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_item_call_set_secret().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_item_call_set_secret().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_item_call_set_secret_finish (
    _SecretGenItem *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_item_call_set_secret_sync:
 * @proxy: A #_SecretGenItemProxy.
 * @arg_secret: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Item.SetSecret">SetSecret()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_item_call_set_secret() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_item_call_set_secret_sync (
    _SecretGenItem *proxy,
    GVariant *arg_secret,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSecret",
    g_variant_new ("(@(oayays))",
                   arg_secret),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_item_complete_delete:
 * @object: A #_SecretGenItem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @Prompt: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Item.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_item_complete_delete (
    _SecretGenItem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *Prompt)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   Prompt));
}

/**
 * _secret_gen_item_complete_get_secret:
 * @object: A #_SecretGenItem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @secret: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Item.GetSecret">GetSecret()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_item_complete_get_secret (
    _SecretGenItem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *secret)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(oayays))",
                   secret));
}

/**
 * _secret_gen_item_complete_set_secret:
 * @object: A #_SecretGenItem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Item.SetSecret">SetSecret()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_item_complete_set_secret (
    _SecretGenItem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * _SecretGenItemProxy:
 *
 * The #_SecretGenItemProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenItemProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenItemProxy.
 */

struct __SecretGenItemProxyPrivate
{
  GData *qdata;
};

static void _secret_gen_item_proxy_iface_init (_SecretGenItemIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenItemProxy, _secret_gen_item_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_SecretGenItemProxy)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_ITEM, _secret_gen_item_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenItemProxy, _secret_gen_item_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_ITEM, _secret_gen_item_proxy_iface_init))

#endif
static void
_secret_gen_item_proxy_finalize (GObject *object)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_secret_gen_item_proxy_parent_class)->finalize (object);
}

static void
_secret_gen_item_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_item_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
_secret_gen_item_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.Secret.Item: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
_secret_gen_item_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_item_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.Secret.Item", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) _secret_gen_item_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
_secret_gen_item_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__secret_gen_item_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _SECRET_GEN_TYPE_ITEM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_ITEM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_secret_gen_item_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_item_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_item_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
_secret_gen_item_proxy_get_locked (_SecretGenItem *object)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Locked");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
_secret_gen_item_proxy_get_attributes (_SecretGenItem *object)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Attributes");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
_secret_gen_item_proxy_get_label (_SecretGenItem *object)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Label");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
_secret_gen_item_proxy_get_created (_SecretGenItem *object)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Created");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
_secret_gen_item_proxy_get_modified (_SecretGenItem *object)
{
  _SecretGenItemProxy *proxy = _SECRET_GEN_ITEM_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Modified");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
_secret_gen_item_proxy_init (_SecretGenItemProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _secret_gen_item_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _SECRET_GEN_TYPE_ITEM_PROXY, _SecretGenItemProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _secret_gen_item_interface_info ());
}

static void
_secret_gen_item_proxy_class_init (_SecretGenItemProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _secret_gen_item_proxy_finalize;
  gobject_class->get_property = _secret_gen_item_proxy_get_property;
  gobject_class->set_property = _secret_gen_item_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _secret_gen_item_proxy_g_signal;
  proxy_class->g_properties_changed = _secret_gen_item_proxy_g_properties_changed;

  _secret_gen_item_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenItemProxyPrivate));
#endif
}

static void
_secret_gen_item_proxy_iface_init (_SecretGenItemIface *iface)
{
  iface->get_locked = _secret_gen_item_proxy_get_locked;
  iface->get_attributes = _secret_gen_item_proxy_get_attributes;
  iface->get_label = _secret_gen_item_proxy_get_label;
  iface->get_created = _secret_gen_item_proxy_get_created;
  iface->get_modified = _secret_gen_item_proxy_get_modified;
}

/**
 * _secret_gen_item_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_item_proxy_new_finish() to get the result of the operation.
 *
 * See _secret_gen_item_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_item_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_ITEM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Item", NULL);
}

/**
 * _secret_gen_item_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_item_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_item_proxy_new().
 *
 * Returns: (transfer full) (type _SecretGenItemProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenItem *
_secret_gen_item_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_ITEM (ret);
  else
    return NULL;
}

/**
 * _secret_gen_item_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_item_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenItemProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenItem *
_secret_gen_item_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_ITEM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Item", NULL);
  if (ret != NULL)
    return _SECRET_GEN_ITEM (ret);
  else
    return NULL;
}


/**
 * _secret_gen_item_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _secret_gen_item_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_item_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _secret_gen_item_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_item_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_ITEM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Item", NULL);
}

/**
 * _secret_gen_item_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_item_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_item_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _SecretGenItemProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenItem *
_secret_gen_item_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_ITEM (ret);
  else
    return NULL;
}

/**
 * _secret_gen_item_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _secret_gen_item_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_item_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenItemProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenItem *
_secret_gen_item_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_ITEM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Item", NULL);
  if (ret != NULL)
    return _SECRET_GEN_ITEM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _SecretGenItemSkeleton:
 *
 * The #_SecretGenItemSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenItemSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenItemSkeleton.
 */

struct __SecretGenItemSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__secret_gen_item_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _SECRET_GEN_TYPE_ITEM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_ITEM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__secret_gen_item_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_item_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__secret_gen_item_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_item_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __secret_gen_item_skeleton_vtable =
{
  __secret_gen_item_skeleton_handle_method_call,
  __secret_gen_item_skeleton_handle_get_property,
  __secret_gen_item_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_secret_gen_item_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _secret_gen_item_interface_info ();
}

static GDBusInterfaceVTable *
_secret_gen_item_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__secret_gen_item_skeleton_vtable;
}

static GVariant *
_secret_gen_item_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__secret_gen_item_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __secret_gen_item_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __secret_gen_item_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __secret_gen_item_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Item", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean __secret_gen_item_emit_changed (gpointer user_data);

static void
_secret_gen_item_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    __secret_gen_item_emit_changed (skeleton);
}

static void _secret_gen_item_skeleton_iface_init (_SecretGenItemIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenItemSkeleton, _secret_gen_item_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_SecretGenItemSkeleton)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_ITEM, _secret_gen_item_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenItemSkeleton, _secret_gen_item_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_ITEM, _secret_gen_item_skeleton_iface_init))

#endif
static void
_secret_gen_item_skeleton_finalize (GObject *object)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  guint n;
  for (n = 0; n < 5; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_secret_gen_item_skeleton_parent_class)->finalize (object);
}

static void
_secret_gen_item_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
__secret_gen_item_emit_changed (gpointer user_data)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.Secret.Item",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
__secret_gen_item_schedule_emit_changed (_SecretGenItemSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
_secret_gen_item_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, __secret_gen_item_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] __secret_gen_item_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
_secret_gen_item_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 5);
  info = (const _ExtendedGDBusPropertyInfo *) __secret_gen_item_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        __secret_gen_item_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
_secret_gen_item_skeleton_init (_SecretGenItemSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _secret_gen_item_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _SECRET_GEN_TYPE_ITEM_SKELETON, _SecretGenItemSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 5);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_UINT64);
}

static gboolean 
_secret_gen_item_skeleton_get_locked (_SecretGenItem *object)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
_secret_gen_item_skeleton_get_attributes (_SecretGenItem *object)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
_secret_gen_item_skeleton_get_label (_SecretGenItem *object)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
_secret_gen_item_skeleton_get_created (_SecretGenItem *object)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
_secret_gen_item_skeleton_get_modified (_SecretGenItem *object)
{
  _SecretGenItemSkeleton *skeleton = _SECRET_GEN_ITEM_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
_secret_gen_item_skeleton_class_init (_SecretGenItemSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _secret_gen_item_skeleton_finalize;
  gobject_class->get_property = _secret_gen_item_skeleton_get_property;
  gobject_class->set_property = _secret_gen_item_skeleton_set_property;
  gobject_class->notify       = _secret_gen_item_skeleton_notify;


  _secret_gen_item_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _secret_gen_item_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _secret_gen_item_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _secret_gen_item_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _secret_gen_item_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenItemSkeletonPrivate));
#endif
}

static void
_secret_gen_item_skeleton_iface_init (_SecretGenItemIface *iface)
{
  iface->get_locked = _secret_gen_item_skeleton_get_locked;
  iface->get_attributes = _secret_gen_item_skeleton_get_attributes;
  iface->get_label = _secret_gen_item_skeleton_get_label;
  iface->get_created = _secret_gen_item_skeleton_get_created;
  iface->get_modified = _secret_gen_item_skeleton_get_modified;
}

/**
 * _secret_gen_item_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Item.top_of_page">org.freedesktop.Secret.Item</link>.
 *
 * Returns: (transfer full) (type _SecretGenItemSkeleton): The skeleton object.
 */
_SecretGenItem *
_secret_gen_item_skeleton_new (void)
{
  return _SECRET_GEN_ITEM (g_object_new (_SECRET_GEN_TYPE_ITEM_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Secret.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_SecretGenSession
 * @title: _SecretGenSession
 * @short_description: Generated C code for the org.freedesktop.Secret.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.Secret.Session ---- */

static const _ExtendedGDBusMethodInfo __secret_gen_session_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const __secret_gen_session_method_info_pointers[] =
{
  &__secret_gen_session_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __secret_gen_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Secret.Session",
    (GDBusMethodInfo **) &__secret_gen_session_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "session",
};


/**
 * _secret_gen_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_secret_gen_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__secret_gen_session_interface_info.parent_struct;
}

/**
 * _secret_gen_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_SecretGenSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_secret_gen_session_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
_secret_gen_session_method_marshal_close (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _SecretGenSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link>.
 */

/**
 * _SecretGenSessionIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #_SecretGenSession::handle-close signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link>.
 */

typedef _SecretGenSessionIface _SecretGenSessionInterface;
G_DEFINE_INTERFACE (_SecretGenSession, _secret_gen_session, G_TYPE_OBJECT)

static void
_secret_gen_session_default_init (_SecretGenSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _SecretGenSession::handle-close:
   * @object: A #_SecretGenSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Session.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_session_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenSessionIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_session_method_marshal_close,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * _secret_gen_session_call_close:
 * @proxy: A #_SecretGenSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Session.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_session_call_close_finish() to get the result of the operation.
 *
 * See _secret_gen_session_call_close_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_session_call_close (
    _SecretGenSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_session_call_close_finish:
 * @proxy: A #_SecretGenSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_session_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_session_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_session_call_close_finish (
    _SecretGenSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_session_call_close_sync:
 * @proxy: A #_SecretGenSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Session.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_session_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_session_call_close_sync (
    _SecretGenSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_session_complete_close:
 * @object: A #_SecretGenSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Session.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_session_complete_close (
    _SecretGenSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * _SecretGenSessionProxy:
 *
 * The #_SecretGenSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenSessionProxy.
 */

struct __SecretGenSessionProxyPrivate
{
  GData *qdata;
};

static void _secret_gen_session_proxy_iface_init (_SecretGenSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenSessionProxy, _secret_gen_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_SecretGenSessionProxy)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SESSION, _secret_gen_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenSessionProxy, _secret_gen_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SESSION, _secret_gen_session_proxy_iface_init))

#endif
static void
_secret_gen_session_proxy_finalize (GObject *object)
{
  _SecretGenSessionProxy *proxy = _SECRET_GEN_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_secret_gen_session_proxy_parent_class)->finalize (object);
}

static void
_secret_gen_session_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_secret_gen_session_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_secret_gen_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__secret_gen_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _SECRET_GEN_TYPE_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_secret_gen_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _SecretGenSessionProxy *proxy = _SECRET_GEN_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
_secret_gen_session_proxy_init (_SecretGenSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _secret_gen_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _SECRET_GEN_TYPE_SESSION_PROXY, _SecretGenSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _secret_gen_session_interface_info ());
}

static void
_secret_gen_session_proxy_class_init (_SecretGenSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _secret_gen_session_proxy_finalize;
  gobject_class->get_property = _secret_gen_session_proxy_get_property;
  gobject_class->set_property = _secret_gen_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _secret_gen_session_proxy_g_signal;
  proxy_class->g_properties_changed = _secret_gen_session_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenSessionProxyPrivate));
#endif
}

static void
_secret_gen_session_proxy_iface_init (_SecretGenSessionIface *iface G_GNUC_UNUSED)
{
}

/**
 * _secret_gen_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_session_proxy_new_finish() to get the result of the operation.
 *
 * See _secret_gen_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Session", NULL);
}

/**
 * _secret_gen_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_session_proxy_new().
 *
 * Returns: (transfer full) (type _SecretGenSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenSession *
_secret_gen_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_SESSION (ret);
  else
    return NULL;
}

/**
 * _secret_gen_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenSession *
_secret_gen_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Session", NULL);
  if (ret != NULL)
    return _SECRET_GEN_SESSION (ret);
  else
    return NULL;
}


/**
 * _secret_gen_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _secret_gen_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _secret_gen_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Session", NULL);
}

/**
 * _secret_gen_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _SecretGenSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenSession *
_secret_gen_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_SESSION (ret);
  else
    return NULL;
}

/**
 * _secret_gen_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _secret_gen_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenSession *
_secret_gen_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Session", NULL);
  if (ret != NULL)
    return _SECRET_GEN_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _SecretGenSessionSkeleton:
 *
 * The #_SecretGenSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenSessionSkeleton.
 */

struct __SecretGenSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__secret_gen_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _SecretGenSessionSkeleton *skeleton = _SECRET_GEN_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _SECRET_GEN_TYPE_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__secret_gen_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _SecretGenSessionSkeleton *skeleton = _SECRET_GEN_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__secret_gen_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _SecretGenSessionSkeleton *skeleton = _SECRET_GEN_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __secret_gen_session_skeleton_vtable =
{
  __secret_gen_session_skeleton_handle_method_call,
  __secret_gen_session_skeleton_handle_get_property,
  __secret_gen_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_secret_gen_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _secret_gen_session_interface_info ();
}

static GDBusInterfaceVTable *
_secret_gen_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__secret_gen_session_skeleton_vtable;
}

static GVariant *
_secret_gen_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenSessionSkeleton *skeleton = _SECRET_GEN_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__secret_gen_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __secret_gen_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __secret_gen_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __secret_gen_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
_secret_gen_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void _secret_gen_session_skeleton_iface_init (_SecretGenSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenSessionSkeleton, _secret_gen_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_SecretGenSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SESSION, _secret_gen_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenSessionSkeleton, _secret_gen_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_SESSION, _secret_gen_session_skeleton_iface_init))

#endif
static void
_secret_gen_session_skeleton_finalize (GObject *object)
{
  _SecretGenSessionSkeleton *skeleton = _SECRET_GEN_SESSION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_secret_gen_session_skeleton_parent_class)->finalize (object);
}

static void
_secret_gen_session_skeleton_init (_SecretGenSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _secret_gen_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _SECRET_GEN_TYPE_SESSION_SKELETON, _SecretGenSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
_secret_gen_session_skeleton_class_init (_SecretGenSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _secret_gen_session_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _secret_gen_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _secret_gen_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _secret_gen_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _secret_gen_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenSessionSkeletonPrivate));
#endif
}

static void
_secret_gen_session_skeleton_iface_init (_SecretGenSessionIface *iface G_GNUC_UNUSED)
{
}

/**
 * _secret_gen_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Session.top_of_page">org.freedesktop.Secret.Session</link>.
 *
 * Returns: (transfer full) (type _SecretGenSessionSkeleton): The skeleton object.
 */
_SecretGenSession *
_secret_gen_session_skeleton_new (void)
{
  return _SECRET_GEN_SESSION (g_object_new (_SECRET_GEN_TYPE_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Secret.Prompt
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:_SecretGenPrompt
 * @title: _SecretGenPrompt
 * @short_description: Generated C code for the org.freedesktop.Secret.Prompt D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link> D-Bus interface in C.
 */

enum
{
  _SECRET_GEN__PROMPT_COMPLETED,
};

static unsigned _SECRET_GEN__PROMPT_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.freedesktop.Secret.Prompt ---- */

static const _ExtendedGDBusArgInfo __secret_gen_prompt_method_info_prompt_IN_ARG_window_id =
{
  {
    -1,
    (gchar *) "window_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_prompt_method_info_prompt_IN_ARG_pointers[] =
{
  &__secret_gen_prompt_method_info_prompt_IN_ARG_window_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo __secret_gen_prompt_method_info_prompt =
{
  {
    -1,
    (gchar *) "Prompt",
    (GDBusArgInfo **) &__secret_gen_prompt_method_info_prompt_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-prompt",
  FALSE
};

static const _ExtendedGDBusMethodInfo __secret_gen_prompt_method_info_dismiss =
{
  {
    -1,
    (gchar *) "Dismiss",
    NULL,
    NULL,
    NULL
  },
  "handle-dismiss",
  FALSE
};

static const GDBusMethodInfo * const __secret_gen_prompt_method_info_pointers[] =
{
  &__secret_gen_prompt_method_info_prompt.parent_struct,
  &__secret_gen_prompt_method_info_dismiss.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo __secret_gen_prompt_signal_info_completed_ARG_dismissed =
{
  {
    -1,
    (gchar *) "dismissed",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo __secret_gen_prompt_signal_info_completed_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const __secret_gen_prompt_signal_info_completed_ARG_pointers[] =
{
  &__secret_gen_prompt_signal_info_completed_ARG_dismissed.parent_struct,
  &__secret_gen_prompt_signal_info_completed_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo __secret_gen_prompt_signal_info_completed =
{
  {
    -1,
    (gchar *) "Completed",
    (GDBusArgInfo **) &__secret_gen_prompt_signal_info_completed_ARG_pointers,
    NULL
  },
  "completed"
};

static const GDBusSignalInfo * const __secret_gen_prompt_signal_info_pointers[] =
{
  &__secret_gen_prompt_signal_info_completed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo __secret_gen_prompt_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Secret.Prompt",
    (GDBusMethodInfo **) &__secret_gen_prompt_method_info_pointers,
    (GDBusSignalInfo **) &__secret_gen_prompt_signal_info_pointers,
    NULL,
    NULL
  },
  "prompt",
};


/**
 * _secret_gen_prompt_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
_secret_gen_prompt_interface_info (void)
{
  return (GDBusInterfaceInfo *) &__secret_gen_prompt_interface_info.parent_struct;
}

/**
 * _secret_gen_prompt_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #_SecretGenPrompt interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
_secret_gen_prompt_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
_secret_gen_prompt_signal_marshal_completed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__BOOLEAN_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_prompt_method_marshal_prompt (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
_secret_gen_prompt_method_marshal_dismiss (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * _SecretGenPrompt:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link>.
 */

/**
 * _SecretGenPromptIface:
 * @parent_iface: The parent interface.
 * @handle_dismiss: Handler for the #_SecretGenPrompt::handle-dismiss signal.
 * @handle_prompt: Handler for the #_SecretGenPrompt::handle-prompt signal.
 * @completed: Handler for the #_SecretGenPrompt::completed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link>.
 */

typedef _SecretGenPromptIface _SecretGenPromptInterface;
G_DEFINE_INTERFACE (_SecretGenPrompt, _secret_gen_prompt, G_TYPE_OBJECT)

static void
_secret_gen_prompt_default_init (_SecretGenPromptIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * _SecretGenPrompt::handle-prompt:
   * @object: A #_SecretGenPrompt.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_window_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Prompt">Prompt()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_prompt_complete_prompt() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prompt",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenPromptIface, handle_prompt),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_prompt_method_marshal_prompt,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * _SecretGenPrompt::handle-dismiss:
   * @object: A #_SecretGenPrompt.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Dismiss">Dismiss()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call _secret_gen_prompt_complete_dismiss() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dismiss",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (_SecretGenPromptIface, handle_dismiss),
    g_signal_accumulator_true_handled,
    NULL,
      _secret_gen_prompt_method_marshal_dismiss,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * _SecretGenPrompt::completed:
   * @object: A #_SecretGenPrompt.
   * @arg_dismissed: Argument.
   * @arg_result: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Secret-Prompt.Completed">"Completed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _SECRET_GEN__PROMPT_SIGNALS[_SECRET_GEN__PROMPT_COMPLETED] =
    g_signal_new ("completed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (_SecretGenPromptIface, completed),
      NULL,
      NULL,
      _secret_gen_prompt_signal_marshal_completed,
      G_TYPE_NONE,
      2, G_TYPE_BOOLEAN, G_TYPE_VARIANT);

}

/**
 * _secret_gen_prompt_emit_completed:
 * @object: A #_SecretGenPrompt.
 * @arg_dismissed: Argument to pass with the signal.
 * @arg_result: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Secret-Prompt.Completed">"Completed"</link> D-Bus signal.
 */
void
_secret_gen_prompt_emit_completed (
    _SecretGenPrompt *object,
    gboolean arg_dismissed,
    GVariant *arg_result)
{
  g_signal_emit (object, _SECRET_GEN__PROMPT_SIGNALS[_SECRET_GEN__PROMPT_COMPLETED], 0, arg_dismissed, arg_result);
}

/**
 * _secret_gen_prompt_call_prompt:
 * @proxy: A #_SecretGenPromptProxy.
 * @arg_window_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Prompt">Prompt()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_prompt_call_prompt_finish() to get the result of the operation.
 *
 * See _secret_gen_prompt_call_prompt_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_prompt_call_prompt (
    _SecretGenPrompt *proxy,
    const gchar *arg_window_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Prompt",
    g_variant_new ("(s)",
                   arg_window_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_prompt_call_prompt_finish:
 * @proxy: A #_SecretGenPromptProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_prompt_call_prompt().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_prompt_call_prompt().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_prompt_call_prompt_finish (
    _SecretGenPrompt *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_prompt_call_prompt_sync:
 * @proxy: A #_SecretGenPromptProxy.
 * @arg_window_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Prompt">Prompt()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_prompt_call_prompt() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_prompt_call_prompt_sync (
    _SecretGenPrompt *proxy,
    const gchar *arg_window_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Prompt",
    g_variant_new ("(s)",
                   arg_window_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_prompt_call_dismiss:
 * @proxy: A #_SecretGenPromptProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Dismiss">Dismiss()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_prompt_call_dismiss_finish() to get the result of the operation.
 *
 * See _secret_gen_prompt_call_dismiss_sync() for the synchronous, blocking version of this method.
 */
void
_secret_gen_prompt_call_dismiss (
    _SecretGenPrompt *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Dismiss",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * _secret_gen_prompt_call_dismiss_finish:
 * @proxy: A #_SecretGenPromptProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_prompt_call_dismiss().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with _secret_gen_prompt_call_dismiss().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_prompt_call_dismiss_finish (
    _SecretGenPrompt *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_prompt_call_dismiss_sync:
 * @proxy: A #_SecretGenPromptProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Dismiss">Dismiss()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_prompt_call_dismiss() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
_secret_gen_prompt_call_dismiss_sync (
    _SecretGenPrompt *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Dismiss",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * _secret_gen_prompt_complete_prompt:
 * @object: A #_SecretGenPrompt.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Prompt">Prompt()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_prompt_complete_prompt (
    _SecretGenPrompt *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * _secret_gen_prompt_complete_dismiss:
 * @object: A #_SecretGenPrompt.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Secret-Prompt.Dismiss">Dismiss()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
_secret_gen_prompt_complete_dismiss (
    _SecretGenPrompt *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * _SecretGenPromptProxy:
 *
 * The #_SecretGenPromptProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenPromptProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenPromptProxy.
 */

struct __SecretGenPromptProxyPrivate
{
  GData *qdata;
};

static void _secret_gen_prompt_proxy_iface_init (_SecretGenPromptIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenPromptProxy, _secret_gen_prompt_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (_SecretGenPromptProxy)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_PROMPT, _secret_gen_prompt_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenPromptProxy, _secret_gen_prompt_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_PROMPT, _secret_gen_prompt_proxy_iface_init))

#endif
static void
_secret_gen_prompt_proxy_finalize (GObject *object)
{
  _SecretGenPromptProxy *proxy = _SECRET_GEN_PROMPT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (_secret_gen_prompt_proxy_parent_class)->finalize (object);
}

static void
_secret_gen_prompt_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_secret_gen_prompt_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
_secret_gen_prompt_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &__secret_gen_prompt_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], _SECRET_GEN_TYPE_PROMPT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_PROMPT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
_secret_gen_prompt_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  _SecretGenPromptProxy *proxy = _SECRET_GEN_PROMPT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_prompt_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_prompt_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
_secret_gen_prompt_proxy_init (_SecretGenPromptProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = _secret_gen_prompt_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, _SECRET_GEN_TYPE_PROMPT_PROXY, _SecretGenPromptProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), _secret_gen_prompt_interface_info ());
}

static void
_secret_gen_prompt_proxy_class_init (_SecretGenPromptProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = _secret_gen_prompt_proxy_finalize;
  gobject_class->get_property = _secret_gen_prompt_proxy_get_property;
  gobject_class->set_property = _secret_gen_prompt_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = _secret_gen_prompt_proxy_g_signal;
  proxy_class->g_properties_changed = _secret_gen_prompt_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenPromptProxyPrivate));
#endif
}

static void
_secret_gen_prompt_proxy_iface_init (_SecretGenPromptIface *iface G_GNUC_UNUSED)
{
}

/**
 * _secret_gen_prompt_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_prompt_proxy_new_finish() to get the result of the operation.
 *
 * See _secret_gen_prompt_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_prompt_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_PROMPT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Prompt", NULL);
}

/**
 * _secret_gen_prompt_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_prompt_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_prompt_proxy_new().
 *
 * Returns: (transfer full) (type _SecretGenPromptProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenPrompt *
_secret_gen_prompt_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_PROMPT (ret);
  else
    return NULL;
}

/**
 * _secret_gen_prompt_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_prompt_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenPromptProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenPrompt *
_secret_gen_prompt_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_PROMPT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Prompt", NULL);
  if (ret != NULL)
    return _SECRET_GEN_PROMPT (ret);
  else
    return NULL;
}


/**
 * _secret_gen_prompt_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like _secret_gen_prompt_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call _secret_gen_prompt_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See _secret_gen_prompt_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
_secret_gen_prompt_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (_SECRET_GEN_TYPE_PROMPT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Prompt", NULL);
}

/**
 * _secret_gen_prompt_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to _secret_gen_prompt_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with _secret_gen_prompt_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type _SecretGenPromptProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenPrompt *
_secret_gen_prompt_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return _SECRET_GEN_PROMPT (ret);
  else
    return NULL;
}

/**
 * _secret_gen_prompt_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like _secret_gen_prompt_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See _secret_gen_prompt_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type _SecretGenPromptProxy): The constructed proxy object or %NULL if @error is set.
 */
_SecretGenPrompt *
_secret_gen_prompt_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (_SECRET_GEN_TYPE_PROMPT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Secret.Prompt", NULL);
  if (ret != NULL)
    return _SECRET_GEN_PROMPT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * _SecretGenPromptSkeleton:
 *
 * The #_SecretGenPromptSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * _SecretGenPromptSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #_SecretGenPromptSkeleton.
 */

struct __SecretGenPromptSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
__secret_gen_prompt_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  _SecretGenPromptSkeleton *skeleton = _SECRET_GEN_PROMPT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], _SECRET_GEN_TYPE_PROMPT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, _SECRET_GEN_TYPE_PROMPT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
__secret_gen_prompt_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  _SecretGenPromptSkeleton *skeleton = _SECRET_GEN_PROMPT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_prompt_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
__secret_gen_prompt_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  _SecretGenPromptSkeleton *skeleton = _SECRET_GEN_PROMPT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &__secret_gen_prompt_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable __secret_gen_prompt_skeleton_vtable =
{
  __secret_gen_prompt_skeleton_handle_method_call,
  __secret_gen_prompt_skeleton_handle_get_property,
  __secret_gen_prompt_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
_secret_gen_prompt_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return _secret_gen_prompt_interface_info ();
}

static GDBusInterfaceVTable *
_secret_gen_prompt_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &__secret_gen_prompt_skeleton_vtable;
}

static GVariant *
_secret_gen_prompt_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  _SecretGenPromptSkeleton *skeleton = _SECRET_GEN_PROMPT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (__secret_gen_prompt_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; __secret_gen_prompt_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = __secret_gen_prompt_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = __secret_gen_prompt_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Prompt", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
_secret_gen_prompt_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
__secret_gen_prompt_on_signal_completed (
    _SecretGenPrompt *object,
    gboolean arg_dismissed,
    GVariant *arg_result)
{
  _SecretGenPromptSkeleton *skeleton = _SECRET_GEN_PROMPT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(b@v)",
                   arg_dismissed,
                   arg_result));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Secret.Prompt", "Completed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void _secret_gen_prompt_skeleton_iface_init (_SecretGenPromptIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (_SecretGenPromptSkeleton, _secret_gen_prompt_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (_SecretGenPromptSkeleton)
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_PROMPT, _secret_gen_prompt_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (_SecretGenPromptSkeleton, _secret_gen_prompt_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (_SECRET_GEN_TYPE_PROMPT, _secret_gen_prompt_skeleton_iface_init))

#endif
static void
_secret_gen_prompt_skeleton_finalize (GObject *object)
{
  _SecretGenPromptSkeleton *skeleton = _SECRET_GEN_PROMPT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (_secret_gen_prompt_skeleton_parent_class)->finalize (object);
}

static void
_secret_gen_prompt_skeleton_init (_SecretGenPromptSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = _secret_gen_prompt_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, _SECRET_GEN_TYPE_PROMPT_SKELETON, _SecretGenPromptSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
_secret_gen_prompt_skeleton_class_init (_SecretGenPromptSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = _secret_gen_prompt_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = _secret_gen_prompt_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = _secret_gen_prompt_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = _secret_gen_prompt_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = _secret_gen_prompt_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (_SecretGenPromptSkeletonPrivate));
#endif
}

static void
_secret_gen_prompt_skeleton_iface_init (_SecretGenPromptIface *iface)
{
  iface->completed = __secret_gen_prompt_on_signal_completed;
}

/**
 * _secret_gen_prompt_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Secret-Prompt.top_of_page">org.freedesktop.Secret.Prompt</link>.
 *
 * Returns: (transfer full) (type _SecretGenPromptSkeleton): The skeleton object.
 */
_SecretGenPrompt *
_secret_gen_prompt_skeleton_new (void)
{
  return _SECRET_GEN_PROMPT (g_object_new (_SECRET_GEN_TYPE_PROMPT_SKELETON, NULL));
}

